// Copyright (c) 2001-2004 Rowley Associates Limited.
//
// This file may be distributed under the terms of the License Agreement
// provided with this software.
//
// THIS FILE IS PROVIDED AS IS WITH NO WARRANTY OF ANY KIND, INCLUDING THE
// WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
//
////////////////////////////////////////////////////////////////////////////////
//
//           Analog ADuC7020 Eval Board LED Example
//
// Description
// -----------
// This example demonstrates writing to the GPIO ports and also how to place
// functions into the .fast section.
//
////////////////////////////////////////////////////////////////////////////////

#include <targets/ADuC7020.h>

extern void delay(volatile unsigned int d);

static void
cycle(int n)
{
  int m = 0;
  for (; n; m++, n--)
    {
      GP4CLR = 1 << (2 + 16);
      delay(m);
      GP4SET = 1 << (2 + 16);
      delay(n);
    }

  for (; m; m--, n++)
    {
      GP4CLR = 1 << (2 + 16);
      delay(m);
      GP4SET = 1 << (2 + 16);
      delay(n);
    }
}

int
main(void)
{
  GP4CON &= ~(3 << 16); /* Set P4.2 to GPIO function */
  GP4DAT |= 1 << (2 + 24); /* Set P4.2 to output */
  while (1)
    {
      cycle(400);
      cycle(700);
      delay(200000);
    }
  return 0;
}

