// Copyright (c) 2001-2004 Rowley Associates Limited.
//
// This file may be distributed under the terms of the License Agreement
// provided with this software.
//
// THIS FILE IS PROVIDED AS IS WITH NO WARRANTY OF ANY KIND, INCLUDING THE
// WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
//
////////////////////////////////////////////////////////////////////////////////
//
//                         Atmel EB55 LED Example
//
// Description
// -----------
// This example demonstrates writing to the PIO ports and also how to place
// functions into the .fast section.
//
////////////////////////////////////////////////////////////////////////////////

#include <targets/AT91M55800A.h>

#define NUM_LEDS 8

void ledInit()
{
  PIOB_PER = 0x0000FF00;
  PIOB_OER = 0x0000FF00;
}

void ledOff(int led)
{
  PIOB_SODR = 0x100 << led;
}

void ledOn(int led)
{
  PIOB_CODR = 0x100 << led;
}

int
main(void)
{ 
  int i, j;
  ledInit();
  while (1)
    { 
      for (i = 0; i < NUM_LEDS; ++i)
        { 
          ledOn(i);
          delay(30000);
        } 
      for (i = 0; i < NUM_LEDS; ++i)
        { 
          ledOff(i);
          delay(30000);
        } 
      for (i = NUM_LEDS - 1; i >= 0; --i)
        { 
          ledOn(i);
          delay(30000);
        } 
      for (i = NUM_LEDS - 1; i >= 0; --i)
        { 
          ledOff(i);
          delay(30000);
        }
    
    }
  return 0;
}

