// Copyright (c) 2001-2004 Rowley Associates Limited.
//
// This file may be distributed under the terms of the License Agreement
// provided with this software.
//
// THIS FILE IS PROVIDED AS IS WITH NO WARRANTY OF ANY KIND, INCLUDING THE
// WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
//
////////////////////////////////////////////////////////////////////////////////
//
//                    ARM Evaluator-7T UART Example
//
// Description
// -----------
// This example demonstrates configuring and writing to a UART. It also 
// demonstrates how to get printf output over the UART by implementing 
// __putchar.
//
// To see output:
//   - Connect serial cable from USER COM0 on the Evaluator7T board to your
//     host computer.
//   - Open CrossStudio's "Terminal Emulator Window". Configure it to 4800 baud, 
//     8 data bits, no parity, 2 stop bits. Click "Connect" to start the
//     terminal emulator window.
//
////////////////////////////////////////////////////////////////////////////////

#include <targets/S3C4510B.h>

#define PROCESSOR_CLOCK_FREQUENCY 50000000

static void
UARTInitialize(unsigned long baudrate)
{
  ULCON0 = 0x7; // 8 bit data, 2 stop bits, no parity
  UCON0 = 0x9;
  UBRDIV0 = (((PROCESSOR_CLOCK_FREQUENCY / 2) / (16 * baudrate)) - 1) << 4;
}

void
UARTWriteChar(char ch)
{
  while (!(USTAT0 & (1 << 6)));
  UTXBUF0 = ch;
}

void __putchar(int ch)
{
  if (ch == '\n')
    UARTWriteChar('\r');
  UARTWriteChar(ch);
}
int
main(void)
{
  int i;
  UARTInitialize(4800);
  for (i = 0; ; ++i)
    printf("Hello World (%d)\n", i);
  return 0; 
}

