// Copyright (c) 2001-2004 Rowley Associates Limited.
//
// This file may be distributed under the terms of the License Agreement
// provided with this software.
//
// THIS FILE IS PROVIDED AS IS WITH NO WARRANTY OF ANY KIND, INCLUDING THE
// WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
//
////////////////////////////////////////////////////////////////////////////////
//
//                ARM Evaluator-7T Timer Interrupt Example
//
// Description
// -----------
// This example demonstrates a simple interrupt handler and setting up a timer.
//
////////////////////////////////////////////////////////////////////////////////

#include <targets/S3C4510B.h>

#define PROCESSOR_CLOCK_FREQUENCY 50000000

#define TIMER0_INT 10

static int count;

void irq_handler(void) __attribute__ ((interrupt ("IRQ")));

void
irq_handler(void)
{
  count++;
  INTPND = 1 << TIMER0_INT;
}

int
main(void)
{
  __ARMLIB_enableIRQ();
  INTPND = 1 << TIMER0_INT;
  INTMSK &= ~(1 << 21 | 1 << TIMER0_INT);  
  TDATA0 = PROCESSOR_CLOCK_FREQUENCY;
  TMOD = 3;

  while (count < 5);

  return 0; 
}
