// Copyright (c) 2001-2004 Rowley Associates Limited.
//
// This file may be distributed under the terms of the License Agreement
// provided with this software.
//
// THIS FILE IS PROVIDED AS IS WITH NO WARRANTY OF ANY KIND, INCLUDING THE
// WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
//
////////////////////////////////////////////////////////////////////////////////
//
//                 ARM Evaluator-7T LED Example
//
// Description
// -----------
// This example demonstrates writing to the PIO ports and also how to place
// functions into the .fast section.
//
////////////////////////////////////////////////////////////////////////////////

#include <string.h>
#include <targets/S3C4510B.h>

unsigned int banner[] = {0x0001D800, 0x0001E400, 0x00016000, 0x00016000, 0x00017C00, 0x00000000};

// Put delay routine in the .fast section so that both FLASH and RAM
// configurations delay for the same time.
void delay(unsigned int d) __attribute__((section(".fast")));

void
delay(unsigned int d)
{     
  for(; d; --d);
}
                        
static unsigned int count;

int
main(void)
{
  unsigned int *ptr = banner;

  IOPMOD = 0x0001FCF0;
  
  while(1)
    {  
      IOPDATA = *ptr;
      if(*ptr == 0)
        ptr = banner;
      else
        ptr++;
      delay(0x20000);
      IOPDATA = 0;
      delay(0x5000);
      count++;
    }      
          
  return 0;    
}


