// STR71x register and bit definitions.
//
// Copyright (c) 2005 Rowley Associates Limited.
//
// This file may be distributed under the terms of the License Agreement
// provided with this software.
//
// THIS FILE IS PROVIDED AS IS WITH NO WARRANTY OF ANY KIND, INCLUDING THE
// WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.

#ifndef STR71x_h
#define STR71x_h

#define APB1_CKDIS (*(volatile unsigned long *)0xC0000010)

#define APB1_SWRES (*(volatile unsigned long *)0xC0000014)

#define I2C0_CR (*(volatile unsigned char *)0xC0001000)
#define I2C0_CR_ITE_MASK 0x1U
#define I2C0_CR_ITE 0x1U
#define I2C0_CR_ITE_BIT 0
#define I2C0_CR_STOP_MASK 0x2U
#define I2C0_CR_STOP 0x2U
#define I2C0_CR_STOP_BIT 1
#define I2C0_CR_ACK_MASK 0x4U
#define I2C0_CR_ACK 0x4U
#define I2C0_CR_ACK_BIT 2
#define I2C0_CR_START_MASK 0x8U
#define I2C0_CR_START 0x8U
#define I2C0_CR_START_BIT 3
#define I2C0_CR_ENGC_MASK 0x10U
#define I2C0_CR_ENGC 0x10U
#define I2C0_CR_ENGC_BIT 4
#define I2C0_CR_PE_MASK 0x20U
#define I2C0_CR_PE 0x20U
#define I2C0_CR_PE_BIT 5

#define I2C0_SR1 (*(volatile unsigned char *)0xC0001004)
#define I2C0_SR1_SB_MASK 0x1U
#define I2C0_SR1_SB 0x1U
#define I2C0_SR1_SB_BIT 0
#define I2C0_SR1_M_SL_MASK 0x2U
#define I2C0_SR1_M_SL 0x2U
#define I2C0_SR1_M_SL_BIT 1
#define I2C0_SR1_ADSL_MASK 0x4U
#define I2C0_SR1_ADSL 0x4U
#define I2C0_SR1_ADSL_BIT 2
#define I2C0_SR1_BTF_MASK 0x8U
#define I2C0_SR1_BTF 0x8U
#define I2C0_SR1_BTF_BIT 3
#define I2C0_SR1_BUSY_MASK 0x10U
#define I2C0_SR1_BUSY 0x10U
#define I2C0_SR1_BUSY_BIT 4
#define I2C0_SR1_TRA_MASK 0x20U
#define I2C0_SR1_TRA 0x20U
#define I2C0_SR1_TRA_BIT 5
#define I2C0_SR1_ADD10_MASK 0x40U
#define I2C0_SR1_ADD10 0x40U
#define I2C0_SR1_ADD10_BIT 6
#define I2C0_SR1_EVF_MASK 0x80U
#define I2C0_SR1_EVF 0x80U
#define I2C0_SR1_EVF_BIT 7

#define I2C0_SR2 (*(volatile unsigned char *)0xC0001008)
#define I2C0_SR2_GCAL_MASK 0x1U
#define I2C0_SR2_GCAL 0x1U
#define I2C0_SR2_GCAL_BIT 0
#define I2C0_SR2_BERR_MASK 0x2U
#define I2C0_SR2_BERR 0x2U
#define I2C0_SR2_BERR_BIT 1
#define I2C0_SR2_ARLO_MASK 0x4U
#define I2C0_SR2_ARLO 0x4U
#define I2C0_SR2_ARLO_BIT 2
#define I2C0_SR2_STOPF_MASK 0x8U
#define I2C0_SR2_STOPF 0x8U
#define I2C0_SR2_STOPF_BIT 3
#define I2C0_SR2_AF_MASK 0x10U
#define I2C0_SR2_AF 0x10U
#define I2C0_SR2_AF_BIT 4
#define I2C0_SR2_ENDAD_MASK 0x20U
#define I2C0_SR2_ENDAD 0x20U
#define I2C0_SR2_ENDAD_BIT 5

#define I2C0_CCR (*(volatile unsigned char *)0xC000100C)
#define I2C0_CCR_CC0_MASK 0x1U
#define I2C0_CCR_CC0 0x1U
#define I2C0_CCR_CC0_BIT 0
#define I2C0_CCR_CC1_MASK 0x2U
#define I2C0_CCR_CC1 0x2U
#define I2C0_CCR_CC1_BIT 1
#define I2C0_CCR_CC2_MASK 0x4U
#define I2C0_CCR_CC2 0x4U
#define I2C0_CCR_CC2_BIT 2
#define I2C0_CCR_CC3_MASK 0x8U
#define I2C0_CCR_CC3 0x8U
#define I2C0_CCR_CC3_BIT 3
#define I2C0_CCR_CC4_MASK 0x10U
#define I2C0_CCR_CC4 0x10U
#define I2C0_CCR_CC4_BIT 4
#define I2C0_CCR_CC5_MASK 0x20U
#define I2C0_CCR_CC5 0x20U
#define I2C0_CCR_CC5_BIT 5
#define I2C0_CCR_CC6_MASK 0x40U
#define I2C0_CCR_CC6 0x40U
#define I2C0_CCR_CC6_BIT 6
#define I2C0_CCR_FM_SM_MASK 0x80U
#define I2C0_CCR_FM_SM 0x80U
#define I2C0_CCR_FM_SM_BIT 7

#define I2C0_OAR1 (*(volatile unsigned char *)0xC0001010)
#define I2C0_OAR1_ADD0_MASK 0x1U
#define I2C0_OAR1_ADD0 0x1U
#define I2C0_OAR1_ADD0_BIT 0
#define I2C0_OAR1_ADD1_MASK 0x2U
#define I2C0_OAR1_ADD1 0x2U
#define I2C0_OAR1_ADD1_BIT 1
#define I2C0_OAR1_ADD2_MASK 0x4U
#define I2C0_OAR1_ADD2 0x4U
#define I2C0_OAR1_ADD2_BIT 2
#define I2C0_OAR1_ADD3_MASK 0x8U
#define I2C0_OAR1_ADD3 0x8U
#define I2C0_OAR1_ADD3_BIT 3
#define I2C0_OAR1_ADD4_MASK 0x10U
#define I2C0_OAR1_ADD4 0x10U
#define I2C0_OAR1_ADD4_BIT 4
#define I2C0_OAR1_ADD5_MASK 0x20U
#define I2C0_OAR1_ADD5 0x20U
#define I2C0_OAR1_ADD5_BIT 5
#define I2C0_OAR1_ADD6_MASK 0x40U
#define I2C0_OAR1_ADD6 0x40U
#define I2C0_OAR1_ADD6_BIT 6
#define I2C0_OAR1_ADD7_MASK 0x80U
#define I2C0_OAR1_ADD7 0x80U
#define I2C0_OAR1_ADD7_BIT 7

#define I2C0_OAR2 (*(volatile unsigned char *)0xC0001014)
#define I2C0_OAR2_ADD8_MASK 0x2U
#define I2C0_OAR2_ADD8 0x2U
#define I2C0_OAR2_ADD8_BIT 1
#define I2C0_OAR2_ADD9_MASK 0x4U
#define I2C0_OAR2_ADD9 0x4U
#define I2C0_OAR2_ADD9_BIT 2
#define I2C0_OAR2_FR0_MASK 0x20U
#define I2C0_OAR2_FR0 0x20U
#define I2C0_OAR2_FR0_BIT 5
#define I2C0_OAR2_FR1_MASK 0x40U
#define I2C0_OAR2_FR1 0x40U
#define I2C0_OAR2_FR1_BIT 6
#define I2C0_OAR2_FR2_MASK 0x80U
#define I2C0_OAR2_FR2 0x80U
#define I2C0_OAR2_FR2_BIT 7

#define I2C0_DR (*(volatile unsigned char *)0xC0001018)
#define I2C0_DR_D0_MASK 0x1U
#define I2C0_DR_D0 0x1U
#define I2C0_DR_D0_BIT 0
#define I2C0_DR_D1_MASK 0x2U
#define I2C0_DR_D1 0x2U
#define I2C0_DR_D1_BIT 1
#define I2C0_DR_D2_MASK 0x4U
#define I2C0_DR_D2 0x4U
#define I2C0_DR_D2_BIT 2
#define I2C0_DR_D3_MASK 0x8U
#define I2C0_DR_D3 0x8U
#define I2C0_DR_D3_BIT 3
#define I2C0_DR_D4_MASK 0x10U
#define I2C0_DR_D4 0x10U
#define I2C0_DR_D4_BIT 4
#define I2C0_DR_D5_MASK 0x20U
#define I2C0_DR_D5 0x20U
#define I2C0_DR_D5_BIT 5
#define I2C0_DR_D6_MASK 0x40U
#define I2C0_DR_D6 0x40U
#define I2C0_DR_D6_BIT 6
#define I2C0_DR_D7_MASK 0x80U
#define I2C0_DR_D7 0x80U
#define I2C0_DR_D7_BIT 7

#define I2C0_ECCR (*(volatile unsigned char *)0xC000101C)
#define I2C0_ECCR_CC7_MASK 0x1U
#define I2C0_ECCR_CC7 0x1U
#define I2C0_ECCR_CC7_BIT 0
#define I2C0_ECCR_CC8_MASK 0x2U
#define I2C0_ECCR_CC8 0x2U
#define I2C0_ECCR_CC8_BIT 1
#define I2C0_ECCR_CC9_MASK 0x4U
#define I2C0_ECCR_CC9 0x4U
#define I2C0_ECCR_CC9_BIT 2
#define I2C0_ECCR_CC10_MASK 0x8U
#define I2C0_ECCR_CC10 0x8U
#define I2C0_ECCR_CC10_BIT 3
#define I2C0_ECCR_CC11_MASK 0x10U
#define I2C0_ECCR_CC11 0x10U
#define I2C0_ECCR_CC11_BIT 4

#define I2C1_CR (*(volatile unsigned char *)0xC0002000)
#define I2C1_CR_ITE_MASK 0x1U
#define I2C1_CR_ITE 0x1U
#define I2C1_CR_ITE_BIT 0
#define I2C1_CR_STOP_MASK 0x2U
#define I2C1_CR_STOP 0x2U
#define I2C1_CR_STOP_BIT 1
#define I2C1_CR_ACK_MASK 0x4U
#define I2C1_CR_ACK 0x4U
#define I2C1_CR_ACK_BIT 2
#define I2C1_CR_START_MASK 0x8U
#define I2C1_CR_START 0x8U
#define I2C1_CR_START_BIT 3
#define I2C1_CR_ENGC_MASK 0x10U
#define I2C1_CR_ENGC 0x10U
#define I2C1_CR_ENGC_BIT 4
#define I2C1_CR_PE_MASK 0x20U
#define I2C1_CR_PE 0x20U
#define I2C1_CR_PE_BIT 5

#define I2C1_SR1 (*(volatile unsigned char *)0xC0002004)
#define I2C1_SR1_SB_MASK 0x1U
#define I2C1_SR1_SB 0x1U
#define I2C1_SR1_SB_BIT 0
#define I2C1_SR1_M_SL_MASK 0x2U
#define I2C1_SR1_M_SL 0x2U
#define I2C1_SR1_M_SL_BIT 1
#define I2C1_SR1_ADSL_MASK 0x4U
#define I2C1_SR1_ADSL 0x4U
#define I2C1_SR1_ADSL_BIT 2
#define I2C1_SR1_BTF_MASK 0x8U
#define I2C1_SR1_BTF 0x8U
#define I2C1_SR1_BTF_BIT 3
#define I2C1_SR1_BUSY_MASK 0x10U
#define I2C1_SR1_BUSY 0x10U
#define I2C1_SR1_BUSY_BIT 4
#define I2C1_SR1_TRA_MASK 0x20U
#define I2C1_SR1_TRA 0x20U
#define I2C1_SR1_TRA_BIT 5
#define I2C1_SR1_ADD10_MASK 0x40U
#define I2C1_SR1_ADD10 0x40U
#define I2C1_SR1_ADD10_BIT 6
#define I2C1_SR1_EVF_MASK 0x80U
#define I2C1_SR1_EVF 0x80U
#define I2C1_SR1_EVF_BIT 7

#define I2C1_SR2 (*(volatile unsigned char *)0xC0002008)
#define I2C1_SR2_GCAL_MASK 0x1U
#define I2C1_SR2_GCAL 0x1U
#define I2C1_SR2_GCAL_BIT 0
#define I2C1_SR2_BERR_MASK 0x2U
#define I2C1_SR2_BERR 0x2U
#define I2C1_SR2_BERR_BIT 1
#define I2C1_SR2_ARLO_MASK 0x4U
#define I2C1_SR2_ARLO 0x4U
#define I2C1_SR2_ARLO_BIT 2
#define I2C1_SR2_STOPF_MASK 0x8U
#define I2C1_SR2_STOPF 0x8U
#define I2C1_SR2_STOPF_BIT 3
#define I2C1_SR2_AF_MASK 0x10U
#define I2C1_SR2_AF 0x10U
#define I2C1_SR2_AF_BIT 4
#define I2C1_SR2_ENDAD_MASK 0x20U
#define I2C1_SR2_ENDAD 0x20U
#define I2C1_SR2_ENDAD_BIT 5

#define I2C1_CCR (*(volatile unsigned char *)0xC000200C)
#define I2C1_CCR_CC0_MASK 0x1U
#define I2C1_CCR_CC0 0x1U
#define I2C1_CCR_CC0_BIT 0
#define I2C1_CCR_CC1_MASK 0x2U
#define I2C1_CCR_CC1 0x2U
#define I2C1_CCR_CC1_BIT 1
#define I2C1_CCR_CC2_MASK 0x4U
#define I2C1_CCR_CC2 0x4U
#define I2C1_CCR_CC2_BIT 2
#define I2C1_CCR_CC3_MASK 0x8U
#define I2C1_CCR_CC3 0x8U
#define I2C1_CCR_CC3_BIT 3
#define I2C1_CCR_CC4_MASK 0x10U
#define I2C1_CCR_CC4 0x10U
#define I2C1_CCR_CC4_BIT 4
#define I2C1_CCR_CC5_MASK 0x20U
#define I2C1_CCR_CC5 0x20U
#define I2C1_CCR_CC5_BIT 5
#define I2C1_CCR_CC6_MASK 0x40U
#define I2C1_CCR_CC6 0x40U
#define I2C1_CCR_CC6_BIT 6
#define I2C1_CCR_FM_SM_MASK 0x80U
#define I2C1_CCR_FM_SM 0x80U
#define I2C1_CCR_FM_SM_BIT 7

#define I2C1_OAR1 (*(volatile unsigned char *)0xC0002010)
#define I2C1_OAR1_ADD0_MASK 0x1U
#define I2C1_OAR1_ADD0 0x1U
#define I2C1_OAR1_ADD0_BIT 0
#define I2C1_OAR1_ADD1_MASK 0x2U
#define I2C1_OAR1_ADD1 0x2U
#define I2C1_OAR1_ADD1_BIT 1
#define I2C1_OAR1_ADD2_MASK 0x4U
#define I2C1_OAR1_ADD2 0x4U
#define I2C1_OAR1_ADD2_BIT 2
#define I2C1_OAR1_ADD3_MASK 0x8U
#define I2C1_OAR1_ADD3 0x8U
#define I2C1_OAR1_ADD3_BIT 3
#define I2C1_OAR1_ADD4_MASK 0x10U
#define I2C1_OAR1_ADD4 0x10U
#define I2C1_OAR1_ADD4_BIT 4
#define I2C1_OAR1_ADD5_MASK 0x20U
#define I2C1_OAR1_ADD5 0x20U
#define I2C1_OAR1_ADD5_BIT 5
#define I2C1_OAR1_ADD6_MASK 0x40U
#define I2C1_OAR1_ADD6 0x40U
#define I2C1_OAR1_ADD6_BIT 6
#define I2C1_OAR1_ADD7_MASK 0x80U
#define I2C1_OAR1_ADD7 0x80U
#define I2C1_OAR1_ADD7_BIT 7

#define I2C1_OAR2 (*(volatile unsigned char *)0xC0002014)
#define I2C1_OAR2_ADD8_MASK 0x2U
#define I2C1_OAR2_ADD8 0x2U
#define I2C1_OAR2_ADD8_BIT 1
#define I2C1_OAR2_ADD9_MASK 0x4U
#define I2C1_OAR2_ADD9 0x4U
#define I2C1_OAR2_ADD9_BIT 2
#define I2C1_OAR2_FR0_MASK 0x20U
#define I2C1_OAR2_FR0 0x20U
#define I2C1_OAR2_FR0_BIT 5
#define I2C1_OAR2_FR1_MASK 0x40U
#define I2C1_OAR2_FR1 0x40U
#define I2C1_OAR2_FR1_BIT 6
#define I2C1_OAR2_FR2_MASK 0x80U
#define I2C1_OAR2_FR2 0x80U
#define I2C1_OAR2_FR2_BIT 7

#define I2C1_DR (*(volatile unsigned char *)0xC0002018)
#define I2C1_DR_D0_MASK 0x1U
#define I2C1_DR_D0 0x1U
#define I2C1_DR_D0_BIT 0
#define I2C1_DR_D1_MASK 0x2U
#define I2C1_DR_D1 0x2U
#define I2C1_DR_D1_BIT 1
#define I2C1_DR_D2_MASK 0x4U
#define I2C1_DR_D2 0x4U
#define I2C1_DR_D2_BIT 2
#define I2C1_DR_D3_MASK 0x8U
#define I2C1_DR_D3 0x8U
#define I2C1_DR_D3_BIT 3
#define I2C1_DR_D4_MASK 0x10U
#define I2C1_DR_D4 0x10U
#define I2C1_DR_D4_BIT 4
#define I2C1_DR_D5_MASK 0x20U
#define I2C1_DR_D5 0x20U
#define I2C1_DR_D5_BIT 5
#define I2C1_DR_D6_MASK 0x40U
#define I2C1_DR_D6 0x40U
#define I2C1_DR_D6_BIT 6
#define I2C1_DR_D7_MASK 0x80U
#define I2C1_DR_D7 0x80U
#define I2C1_DR_D7_BIT 7

#define I2C1_ECCR (*(volatile unsigned char *)0xC000201C)
#define I2C1_ECCR_CC7_MASK 0x1U
#define I2C1_ECCR_CC7 0x1U
#define I2C1_ECCR_CC7_BIT 0
#define I2C1_ECCR_CC8_MASK 0x2U
#define I2C1_ECCR_CC8 0x2U
#define I2C1_ECCR_CC8_BIT 1
#define I2C1_ECCR_CC9_MASK 0x4U
#define I2C1_ECCR_CC9 0x4U
#define I2C1_ECCR_CC9_BIT 2
#define I2C1_ECCR_CC10_MASK 0x8U
#define I2C1_ECCR_CC10 0x8U
#define I2C1_ECCR_CC10_BIT 3
#define I2C1_ECCR_CC11_MASK 0x10U
#define I2C1_ECCR_CC11 0x10U
#define I2C1_ECCR_CC11_BIT 4

#define UART0_BR (*(volatile unsigned short *)0xC0004000)

#define UART0_TxBUFR (*(volatile unsigned short *)0xC0004004)

#define UART0_RxBUFR (*(volatile unsigned short *)0xC0004008)

#define UART0_CR (*(volatile unsigned short *)0xC000400C)
#define UART0_CR_Mode_MASK 0x7U
#define UART0_CR_Mode_BIT 0
#define UART0_CR_Stop_Bits_MASK 0x18U
#define UART0_CR_Stop_Bits_BIT 3
#define UART0_CR_Parity_Odd_MASK 0x20U
#define UART0_CR_Parity_Odd 0x20U
#define UART0_CR_Parity_Odd_BIT 5
#define UART0_CR_Loop_Back_MASK 0x40U
#define UART0_CR_Loop_Back 0x40U
#define UART0_CR_Loop_Back_BIT 6
#define UART0_CR_Run_MASK 0x80U
#define UART0_CR_Run 0x80U
#define UART0_CR_Run_BIT 7
#define UART0_CR_RxEnable_MASK 0x100U
#define UART0_CR_RxEnable 0x100U
#define UART0_CR_RxEnable_BIT 8
#define UART0_CR_FifoEnable_MASK 0x400U
#define UART0_CR_FifoEnable 0x400U
#define UART0_CR_FifoEnable_BIT 10

#define UART0_IER (*(volatile unsigned short *)0xC0004010)

#define UART0_SR (*(volatile unsigned short *)0xC0004014)

#define UART0_GTR (*(volatile unsigned short *)0xC0004018)

#define UART0_TOR (*(volatile unsigned short *)0xC000401C)

#define UART0_TxRSTR (*(volatile unsigned short *)0xC0004020)

#define UART0_RxRSTR (*(volatile unsigned short *)0xC0004024)

#define UART1_BR (*(volatile unsigned short *)0xC0005000)

#define UART1_TxBUFR (*(volatile unsigned short *)0xC0005004)

#define UART1_RxBUFR (*(volatile unsigned short *)0xC0005008)

#define UART1_CR (*(volatile unsigned short *)0xC000500C)
#define UART1_CR_Mode_MASK 0x7U
#define UART1_CR_Mode_BIT 0
#define UART1_CR_Stop_Bits_MASK 0x18U
#define UART1_CR_Stop_Bits_BIT 3
#define UART1_CR_Parity_Odd_MASK 0x20U
#define UART1_CR_Parity_Odd 0x20U
#define UART1_CR_Parity_Odd_BIT 5
#define UART1_CR_Loop_Back_MASK 0x40U
#define UART1_CR_Loop_Back 0x40U
#define UART1_CR_Loop_Back_BIT 6
#define UART1_CR_Run_MASK 0x80U
#define UART1_CR_Run 0x80U
#define UART1_CR_Run_BIT 7
#define UART1_CR_RxEnable_MASK 0x100U
#define UART1_CR_RxEnable 0x100U
#define UART1_CR_RxEnable_BIT 8
#define UART1_CR_FifoEnable_MASK 0x400U
#define UART1_CR_FifoEnable 0x400U
#define UART1_CR_FifoEnable_BIT 10

#define UART1_IER (*(volatile unsigned short *)0xC0005010)

#define UART1_SR (*(volatile unsigned short *)0xC0005014)

#define UART1_GTR (*(volatile unsigned short *)0xC0005018)

#define UART1_TOR (*(volatile unsigned short *)0xC000501C)

#define UART1_TxRSTR (*(volatile unsigned short *)0xC0005020)

#define UART1_RxRSTR (*(volatile unsigned short *)0xC0005024)

#define SC_ClkVal (*(volatile unsigned short *)0xC0005040)

#define SC_ClkCon (*(volatile unsigned short *)0xC0005044)

#define UART2_BR (*(volatile unsigned short *)0xC0006000)

#define UART2_TxBUFR (*(volatile unsigned short *)0xC0006004)

#define UART2_RxBUFR (*(volatile unsigned short *)0xC0006008)

#define UART2_CR (*(volatile unsigned short *)0xC000600C)
#define UART2_CR_Mode_MASK 0x7U
#define UART2_CR_Mode_BIT 0
#define UART2_CR_Stop_Bits_MASK 0x18U
#define UART2_CR_Stop_Bits_BIT 3
#define UART2_CR_Parity_Odd_MASK 0x20U
#define UART2_CR_Parity_Odd 0x20U
#define UART2_CR_Parity_Odd_BIT 5
#define UART2_CR_Loop_Back_MASK 0x40U
#define UART2_CR_Loop_Back 0x40U
#define UART2_CR_Loop_Back_BIT 6
#define UART2_CR_Run_MASK 0x80U
#define UART2_CR_Run 0x80U
#define UART2_CR_Run_BIT 7
#define UART2_CR_RxEnable_MASK 0x100U
#define UART2_CR_RxEnable 0x100U
#define UART2_CR_RxEnable_BIT 8
#define UART2_CR_FifoEnable_MASK 0x400U
#define UART2_CR_FifoEnable 0x400U
#define UART2_CR_FifoEnable_BIT 10

#define UART2_IER (*(volatile unsigned short *)0xC0006010)

#define UART2_SR (*(volatile unsigned short *)0xC0006014)

#define UART2_GTR (*(volatile unsigned short *)0xC0006018)

#define UART2_TOR (*(volatile unsigned short *)0xC000601C)

#define UART2_TxRSTR (*(volatile unsigned short *)0xC0006020)

#define UART2_RxRSTR (*(volatile unsigned short *)0xC0006024)

#define UART3_BR (*(volatile unsigned short *)0xC0007000)

#define UART3_TxBUFR (*(volatile unsigned short *)0xC0007004)

#define UART3_RxBUFR (*(volatile unsigned short *)0xC0007008)

#define UART3_CR (*(volatile unsigned short *)0xC000700C)
#define UART3_CR_Mode_MASK 0x7U
#define UART3_CR_Mode_BIT 0
#define UART3_CR_Stop_Bits_MASK 0x18U
#define UART3_CR_Stop_Bits_BIT 3
#define UART3_CR_Parity_Odd_MASK 0x20U
#define UART3_CR_Parity_Odd 0x20U
#define UART3_CR_Parity_Odd_BIT 5
#define UART3_CR_Loop_Back_MASK 0x40U
#define UART3_CR_Loop_Back 0x40U
#define UART3_CR_Loop_Back_BIT 6
#define UART3_CR_Run_MASK 0x80U
#define UART3_CR_Run 0x80U
#define UART3_CR_Run_BIT 7
#define UART3_CR_RxEnable_MASK 0x100U
#define UART3_CR_RxEnable 0x100U
#define UART3_CR_RxEnable_BIT 8
#define UART3_CR_FifoEnable_MASK 0x400U
#define UART3_CR_FifoEnable 0x400U
#define UART3_CR_FifoEnable_BIT 10

#define UART3_IER (*(volatile unsigned short *)0xC0007010)

#define UART3_SR (*(volatile unsigned short *)0xC0007014)

#define UART3_GTR (*(volatile unsigned short *)0xC0007018)

#define UART3_TOR (*(volatile unsigned short *)0xC000701C)

#define UART3_TxRSTR (*(volatile unsigned short *)0xC0007020)

#define UART3_RxRSTR (*(volatile unsigned short *)0xC0007024)

#define USB_EP0R (*(volatile unsigned short *)0xC0008000)
#define USB_EP0R_EA_MASK 0xFU
#define USB_EP0R_EA_BIT 0
#define USB_EP0R_STATTX_MASK 0x30U
#define USB_EP0R_STATTX_BIT 4
#define USB_EP0R_DTOGTX_MASK 0x40U
#define USB_EP0R_DTOGTX 0x40U
#define USB_EP0R_DTOGTX_BIT 6
#define USB_EP0R_CTRTX_MASK 0x80U
#define USB_EP0R_CTRTX 0x80U
#define USB_EP0R_CTRTX_BIT 7
#define USB_EP0R_EPKIND_MASK 0x100U
#define USB_EP0R_EPKIND 0x100U
#define USB_EP0R_EPKIND_BIT 8
#define USB_EP0R_EPTYPE_MASK 0x600U
#define USB_EP0R_EPTYPE_BIT 9
#define USB_EP0R_SETUP_MASK 0x800U
#define USB_EP0R_SETUP 0x800U
#define USB_EP0R_SETUP_BIT 11
#define USB_EP0R_STATRX_MASK 0x3000U
#define USB_EP0R_STATRX_BIT 12
#define USB_EP0R_DTOGRX_MASK 0x4000U
#define USB_EP0R_DTOGRX 0x4000U
#define USB_EP0R_DTOGRX_BIT 14
#define USB_EP0R_CTRRX_MASK 0x8000U
#define USB_EP0R_CTRRX 0x8000U
#define USB_EP0R_CTRRX_BIT 15

#define USB_EP1R (*(volatile unsigned short *)0xC0008004)
#define USB_EP1R_EA_MASK 0xFU
#define USB_EP1R_EA_BIT 0
#define USB_EP1R_STATTX_MASK 0x30U
#define USB_EP1R_STATTX_BIT 4
#define USB_EP1R_DTOGTX_MASK 0x40U
#define USB_EP1R_DTOGTX 0x40U
#define USB_EP1R_DTOGTX_BIT 6
#define USB_EP1R_CTRTX_MASK 0x80U
#define USB_EP1R_CTRTX 0x80U
#define USB_EP1R_CTRTX_BIT 7
#define USB_EP1R_EPKIND_MASK 0x100U
#define USB_EP1R_EPKIND 0x100U
#define USB_EP1R_EPKIND_BIT 8
#define USB_EP1R_EPTYPE_MASK 0x600U
#define USB_EP1R_EPTYPE_BIT 9
#define USB_EP1R_SETUP_MASK 0x800U
#define USB_EP1R_SETUP 0x800U
#define USB_EP1R_SETUP_BIT 11
#define USB_EP1R_STATRX_MASK 0x3000U
#define USB_EP1R_STATRX_BIT 12
#define USB_EP1R_DTOGRX_MASK 0x4000U
#define USB_EP1R_DTOGRX 0x4000U
#define USB_EP1R_DTOGRX_BIT 14
#define USB_EP1R_CTRRX_MASK 0x8000U
#define USB_EP1R_CTRRX 0x8000U
#define USB_EP1R_CTRRX_BIT 15

#define USB_EP2R (*(volatile unsigned short *)0xC0008008)
#define USB_EP2R_EA_MASK 0xFU
#define USB_EP2R_EA_BIT 0
#define USB_EP2R_STATTX_MASK 0x30U
#define USB_EP2R_STATTX_BIT 4
#define USB_EP2R_DTOGTX_MASK 0x40U
#define USB_EP2R_DTOGTX 0x40U
#define USB_EP2R_DTOGTX_BIT 6
#define USB_EP2R_CTRTX_MASK 0x80U
#define USB_EP2R_CTRTX 0x80U
#define USB_EP2R_CTRTX_BIT 7
#define USB_EP2R_EPKIND_MASK 0x100U
#define USB_EP2R_EPKIND 0x100U
#define USB_EP2R_EPKIND_BIT 8
#define USB_EP2R_EPTYPE_MASK 0x600U
#define USB_EP2R_EPTYPE_BIT 9
#define USB_EP2R_SETUP_MASK 0x800U
#define USB_EP2R_SETUP 0x800U
#define USB_EP2R_SETUP_BIT 11
#define USB_EP2R_STATRX_MASK 0x3000U
#define USB_EP2R_STATRX_BIT 12
#define USB_EP2R_DTOGRX_MASK 0x4000U
#define USB_EP2R_DTOGRX 0x4000U
#define USB_EP2R_DTOGRX_BIT 14
#define USB_EP2R_CTRRX_MASK 0x8000U
#define USB_EP2R_CTRRX 0x8000U
#define USB_EP2R_CTRRX_BIT 15

#define USB_EP3R (*(volatile unsigned short *)0xC000800C)
#define USB_EP3R_EA_MASK 0xFU
#define USB_EP3R_EA_BIT 0
#define USB_EP3R_STATTX_MASK 0x30U
#define USB_EP3R_STATTX_BIT 4
#define USB_EP3R_DTOGTX_MASK 0x40U
#define USB_EP3R_DTOGTX 0x40U
#define USB_EP3R_DTOGTX_BIT 6
#define USB_EP3R_CTRTX_MASK 0x80U
#define USB_EP3R_CTRTX 0x80U
#define USB_EP3R_CTRTX_BIT 7
#define USB_EP3R_EPKIND_MASK 0x100U
#define USB_EP3R_EPKIND 0x100U
#define USB_EP3R_EPKIND_BIT 8
#define USB_EP3R_EPTYPE_MASK 0x600U
#define USB_EP3R_EPTYPE_BIT 9
#define USB_EP3R_SETUP_MASK 0x800U
#define USB_EP3R_SETUP 0x800U
#define USB_EP3R_SETUP_BIT 11
#define USB_EP3R_STATRX_MASK 0x3000U
#define USB_EP3R_STATRX_BIT 12
#define USB_EP3R_DTOGRX_MASK 0x4000U
#define USB_EP3R_DTOGRX 0x4000U
#define USB_EP3R_DTOGRX_BIT 14
#define USB_EP3R_CTRRX_MASK 0x8000U
#define USB_EP3R_CTRRX 0x8000U
#define USB_EP3R_CTRRX_BIT 15

#define USB_EP4R (*(volatile unsigned short *)0xC0008010)
#define USB_EP4R_EA_MASK 0xFU
#define USB_EP4R_EA_BIT 0
#define USB_EP4R_STATTX_MASK 0x30U
#define USB_EP4R_STATTX_BIT 4
#define USB_EP4R_DTOGTX_MASK 0x40U
#define USB_EP4R_DTOGTX 0x40U
#define USB_EP4R_DTOGTX_BIT 6
#define USB_EP4R_CTRTX_MASK 0x80U
#define USB_EP4R_CTRTX 0x80U
#define USB_EP4R_CTRTX_BIT 7
#define USB_EP4R_EPKIND_MASK 0x100U
#define USB_EP4R_EPKIND 0x100U
#define USB_EP4R_EPKIND_BIT 8
#define USB_EP4R_EPTYPE_MASK 0x600U
#define USB_EP4R_EPTYPE_BIT 9
#define USB_EP4R_SETUP_MASK 0x800U
#define USB_EP4R_SETUP 0x800U
#define USB_EP4R_SETUP_BIT 11
#define USB_EP4R_STATRX_MASK 0x3000U
#define USB_EP4R_STATRX_BIT 12
#define USB_EP4R_DTOGRX_MASK 0x4000U
#define USB_EP4R_DTOGRX 0x4000U
#define USB_EP4R_DTOGRX_BIT 14
#define USB_EP4R_CTRRX_MASK 0x8000U
#define USB_EP4R_CTRRX 0x8000U
#define USB_EP4R_CTRRX_BIT 15

#define USB_EP5R (*(volatile unsigned short *)0xC0008014)
#define USB_EP5R_EA_MASK 0xFU
#define USB_EP5R_EA_BIT 0
#define USB_EP5R_STATTX_MASK 0x30U
#define USB_EP5R_STATTX_BIT 4
#define USB_EP5R_DTOGTX_MASK 0x40U
#define USB_EP5R_DTOGTX 0x40U
#define USB_EP5R_DTOGTX_BIT 6
#define USB_EP5R_CTRTX_MASK 0x80U
#define USB_EP5R_CTRTX 0x80U
#define USB_EP5R_CTRTX_BIT 7
#define USB_EP5R_EPKIND_MASK 0x100U
#define USB_EP5R_EPKIND 0x100U
#define USB_EP5R_EPKIND_BIT 8
#define USB_EP5R_EPTYPE_MASK 0x600U
#define USB_EP5R_EPTYPE_BIT 9
#define USB_EP5R_SETUP_MASK 0x800U
#define USB_EP5R_SETUP 0x800U
#define USB_EP5R_SETUP_BIT 11
#define USB_EP5R_STATRX_MASK 0x3000U
#define USB_EP5R_STATRX_BIT 12
#define USB_EP5R_DTOGRX_MASK 0x4000U
#define USB_EP5R_DTOGRX 0x4000U
#define USB_EP5R_DTOGRX_BIT 14
#define USB_EP5R_CTRRX_MASK 0x8000U
#define USB_EP5R_CTRRX 0x8000U
#define USB_EP5R_CTRRX_BIT 15

#define USB_EP6R (*(volatile unsigned short *)0xC0008018)
#define USB_EP6R_EA_MASK 0xFU
#define USB_EP6R_EA_BIT 0
#define USB_EP6R_STATTX_MASK 0x30U
#define USB_EP6R_STATTX_BIT 4
#define USB_EP6R_DTOGTX_MASK 0x40U
#define USB_EP6R_DTOGTX 0x40U
#define USB_EP6R_DTOGTX_BIT 6
#define USB_EP6R_CTRTX_MASK 0x80U
#define USB_EP6R_CTRTX 0x80U
#define USB_EP6R_CTRTX_BIT 7
#define USB_EP6R_EPKIND_MASK 0x100U
#define USB_EP6R_EPKIND 0x100U
#define USB_EP6R_EPKIND_BIT 8
#define USB_EP6R_EPTYPE_MASK 0x600U
#define USB_EP6R_EPTYPE_BIT 9
#define USB_EP6R_SETUP_MASK 0x800U
#define USB_EP6R_SETUP 0x800U
#define USB_EP6R_SETUP_BIT 11
#define USB_EP6R_STATRX_MASK 0x3000U
#define USB_EP6R_STATRX_BIT 12
#define USB_EP6R_DTOGRX_MASK 0x4000U
#define USB_EP6R_DTOGRX 0x4000U
#define USB_EP6R_DTOGRX_BIT 14
#define USB_EP6R_CTRRX_MASK 0x8000U
#define USB_EP6R_CTRRX 0x8000U
#define USB_EP6R_CTRRX_BIT 15

#define USB_EP7R (*(volatile unsigned short *)0xC000801C)
#define USB_EP7R_EA_MASK 0xFU
#define USB_EP7R_EA_BIT 0
#define USB_EP7R_STATTX_MASK 0x30U
#define USB_EP7R_STATTX_BIT 4
#define USB_EP7R_DTOGTX_MASK 0x40U
#define USB_EP7R_DTOGTX 0x40U
#define USB_EP7R_DTOGTX_BIT 6
#define USB_EP7R_CTRTX_MASK 0x80U
#define USB_EP7R_CTRTX 0x80U
#define USB_EP7R_CTRTX_BIT 7
#define USB_EP7R_EPKIND_MASK 0x100U
#define USB_EP7R_EPKIND 0x100U
#define USB_EP7R_EPKIND_BIT 8
#define USB_EP7R_EPTYPE_MASK 0x600U
#define USB_EP7R_EPTYPE_BIT 9
#define USB_EP7R_SETUP_MASK 0x800U
#define USB_EP7R_SETUP 0x800U
#define USB_EP7R_SETUP_BIT 11
#define USB_EP7R_STATRX_MASK 0x3000U
#define USB_EP7R_STATRX_BIT 12
#define USB_EP7R_DTOGRX_MASK 0x4000U
#define USB_EP7R_DTOGRX 0x4000U
#define USB_EP7R_DTOGRX_BIT 14
#define USB_EP7R_CTRRX_MASK 0x8000U
#define USB_EP7R_CTRRX 0x8000U
#define USB_EP7R_CTRRX_BIT 15

#define USB_EP8R (*(volatile unsigned short *)0xC0008020)
#define USB_EP8R_EA_MASK 0xFU
#define USB_EP8R_EA_BIT 0
#define USB_EP8R_STATTX_MASK 0x30U
#define USB_EP8R_STATTX_BIT 4
#define USB_EP8R_DTOGTX_MASK 0x40U
#define USB_EP8R_DTOGTX 0x40U
#define USB_EP8R_DTOGTX_BIT 6
#define USB_EP8R_CTRTX_MASK 0x80U
#define USB_EP8R_CTRTX 0x80U
#define USB_EP8R_CTRTX_BIT 7
#define USB_EP8R_EPKIND_MASK 0x100U
#define USB_EP8R_EPKIND 0x100U
#define USB_EP8R_EPKIND_BIT 8
#define USB_EP8R_EPTYPE_MASK 0x600U
#define USB_EP8R_EPTYPE_BIT 9
#define USB_EP8R_SETUP_MASK 0x800U
#define USB_EP8R_SETUP 0x800U
#define USB_EP8R_SETUP_BIT 11
#define USB_EP8R_STATRX_MASK 0x3000U
#define USB_EP8R_STATRX_BIT 12
#define USB_EP8R_DTOGRX_MASK 0x4000U
#define USB_EP8R_DTOGRX 0x4000U
#define USB_EP8R_DTOGRX_BIT 14
#define USB_EP8R_CTRRX_MASK 0x8000U
#define USB_EP8R_CTRRX 0x8000U
#define USB_EP8R_CTRRX_BIT 15

#define USB_EP9R (*(volatile unsigned short *)0xC0008024)
#define USB_EP9R_EA_MASK 0xFU
#define USB_EP9R_EA_BIT 0
#define USB_EP9R_STATTX_MASK 0x30U
#define USB_EP9R_STATTX_BIT 4
#define USB_EP9R_DTOGTX_MASK 0x40U
#define USB_EP9R_DTOGTX 0x40U
#define USB_EP9R_DTOGTX_BIT 6
#define USB_EP9R_CTRTX_MASK 0x80U
#define USB_EP9R_CTRTX 0x80U
#define USB_EP9R_CTRTX_BIT 7
#define USB_EP9R_EPKIND_MASK 0x100U
#define USB_EP9R_EPKIND 0x100U
#define USB_EP9R_EPKIND_BIT 8
#define USB_EP9R_EPTYPE_MASK 0x600U
#define USB_EP9R_EPTYPE_BIT 9
#define USB_EP9R_SETUP_MASK 0x800U
#define USB_EP9R_SETUP 0x800U
#define USB_EP9R_SETUP_BIT 11
#define USB_EP9R_STATRX_MASK 0x3000U
#define USB_EP9R_STATRX_BIT 12
#define USB_EP9R_DTOGRX_MASK 0x4000U
#define USB_EP9R_DTOGRX 0x4000U
#define USB_EP9R_DTOGRX_BIT 14
#define USB_EP9R_CTRRX_MASK 0x8000U
#define USB_EP9R_CTRRX 0x8000U
#define USB_EP9R_CTRRX_BIT 15

#define USB_EP10R (*(volatile unsigned short *)0xC0008028)
#define USB_EP10R_EA_MASK 0xFU
#define USB_EP10R_EA_BIT 0
#define USB_EP10R_STATTX_MASK 0x30U
#define USB_EP10R_STATTX_BIT 4
#define USB_EP10R_DTOGTX_MASK 0x40U
#define USB_EP10R_DTOGTX 0x40U
#define USB_EP10R_DTOGTX_BIT 6
#define USB_EP10R_CTRTX_MASK 0x80U
#define USB_EP10R_CTRTX 0x80U
#define USB_EP10R_CTRTX_BIT 7
#define USB_EP10R_EPKIND_MASK 0x100U
#define USB_EP10R_EPKIND 0x100U
#define USB_EP10R_EPKIND_BIT 8
#define USB_EP10R_EPTYPE_MASK 0x600U
#define USB_EP10R_EPTYPE_BIT 9
#define USB_EP10R_SETUP_MASK 0x800U
#define USB_EP10R_SETUP 0x800U
#define USB_EP10R_SETUP_BIT 11
#define USB_EP10R_STATRX_MASK 0x3000U
#define USB_EP10R_STATRX_BIT 12
#define USB_EP10R_DTOGRX_MASK 0x4000U
#define USB_EP10R_DTOGRX 0x4000U
#define USB_EP10R_DTOGRX_BIT 14
#define USB_EP10R_CTRRX_MASK 0x8000U
#define USB_EP10R_CTRRX 0x8000U
#define USB_EP10R_CTRRX_BIT 15

#define USB_EP11R (*(volatile unsigned short *)0xC000802C)
#define USB_EP11R_EA_MASK 0xFU
#define USB_EP11R_EA_BIT 0
#define USB_EP11R_STATTX_MASK 0x30U
#define USB_EP11R_STATTX_BIT 4
#define USB_EP11R_DTOGTX_MASK 0x40U
#define USB_EP11R_DTOGTX 0x40U
#define USB_EP11R_DTOGTX_BIT 6
#define USB_EP11R_CTRTX_MASK 0x80U
#define USB_EP11R_CTRTX 0x80U
#define USB_EP11R_CTRTX_BIT 7
#define USB_EP11R_EPKIND_MASK 0x100U
#define USB_EP11R_EPKIND 0x100U
#define USB_EP11R_EPKIND_BIT 8
#define USB_EP11R_EPTYPE_MASK 0x600U
#define USB_EP11R_EPTYPE_BIT 9
#define USB_EP11R_SETUP_MASK 0x800U
#define USB_EP11R_SETUP 0x800U
#define USB_EP11R_SETUP_BIT 11
#define USB_EP11R_STATRX_MASK 0x3000U
#define USB_EP11R_STATRX_BIT 12
#define USB_EP11R_DTOGRX_MASK 0x4000U
#define USB_EP11R_DTOGRX 0x4000U
#define USB_EP11R_DTOGRX_BIT 14
#define USB_EP11R_CTRRX_MASK 0x8000U
#define USB_EP11R_CTRRX 0x8000U
#define USB_EP11R_CTRRX_BIT 15

#define USB_EP12R (*(volatile unsigned short *)0xC0008030)
#define USB_EP12R_EA_MASK 0xFU
#define USB_EP12R_EA_BIT 0
#define USB_EP12R_STATTX_MASK 0x30U
#define USB_EP12R_STATTX_BIT 4
#define USB_EP12R_DTOGTX_MASK 0x40U
#define USB_EP12R_DTOGTX 0x40U
#define USB_EP12R_DTOGTX_BIT 6
#define USB_EP12R_CTRTX_MASK 0x80U
#define USB_EP12R_CTRTX 0x80U
#define USB_EP12R_CTRTX_BIT 7
#define USB_EP12R_EPKIND_MASK 0x100U
#define USB_EP12R_EPKIND 0x100U
#define USB_EP12R_EPKIND_BIT 8
#define USB_EP12R_EPTYPE_MASK 0x600U
#define USB_EP12R_EPTYPE_BIT 9
#define USB_EP12R_SETUP_MASK 0x800U
#define USB_EP12R_SETUP 0x800U
#define USB_EP12R_SETUP_BIT 11
#define USB_EP12R_STATRX_MASK 0x3000U
#define USB_EP12R_STATRX_BIT 12
#define USB_EP12R_DTOGRX_MASK 0x4000U
#define USB_EP12R_DTOGRX 0x4000U
#define USB_EP12R_DTOGRX_BIT 14
#define USB_EP12R_CTRRX_MASK 0x8000U
#define USB_EP12R_CTRRX 0x8000U
#define USB_EP12R_CTRRX_BIT 15

#define USB_EP13R (*(volatile unsigned short *)0xC0008034)
#define USB_EP13R_EA_MASK 0xFU
#define USB_EP13R_EA_BIT 0
#define USB_EP13R_STATTX_MASK 0x30U
#define USB_EP13R_STATTX_BIT 4
#define USB_EP13R_DTOGTX_MASK 0x40U
#define USB_EP13R_DTOGTX 0x40U
#define USB_EP13R_DTOGTX_BIT 6
#define USB_EP13R_CTRTX_MASK 0x80U
#define USB_EP13R_CTRTX 0x80U
#define USB_EP13R_CTRTX_BIT 7
#define USB_EP13R_EPKIND_MASK 0x100U
#define USB_EP13R_EPKIND 0x100U
#define USB_EP13R_EPKIND_BIT 8
#define USB_EP13R_EPTYPE_MASK 0x600U
#define USB_EP13R_EPTYPE_BIT 9
#define USB_EP13R_SETUP_MASK 0x800U
#define USB_EP13R_SETUP 0x800U
#define USB_EP13R_SETUP_BIT 11
#define USB_EP13R_STATRX_MASK 0x3000U
#define USB_EP13R_STATRX_BIT 12
#define USB_EP13R_DTOGRX_MASK 0x4000U
#define USB_EP13R_DTOGRX 0x4000U
#define USB_EP13R_DTOGRX_BIT 14
#define USB_EP13R_CTRRX_MASK 0x8000U
#define USB_EP13R_CTRRX 0x8000U
#define USB_EP13R_CTRRX_BIT 15

#define USB_EP14R (*(volatile unsigned short *)0xC0008038)
#define USB_EP14R_EA_MASK 0xFU
#define USB_EP14R_EA_BIT 0
#define USB_EP14R_STATTX_MASK 0x30U
#define USB_EP14R_STATTX_BIT 4
#define USB_EP14R_DTOGTX_MASK 0x40U
#define USB_EP14R_DTOGTX 0x40U
#define USB_EP14R_DTOGTX_BIT 6
#define USB_EP14R_CTRTX_MASK 0x80U
#define USB_EP14R_CTRTX 0x80U
#define USB_EP14R_CTRTX_BIT 7
#define USB_EP14R_EPKIND_MASK 0x100U
#define USB_EP14R_EPKIND 0x100U
#define USB_EP14R_EPKIND_BIT 8
#define USB_EP14R_EPTYPE_MASK 0x600U
#define USB_EP14R_EPTYPE_BIT 9
#define USB_EP14R_SETUP_MASK 0x800U
#define USB_EP14R_SETUP 0x800U
#define USB_EP14R_SETUP_BIT 11
#define USB_EP14R_STATRX_MASK 0x3000U
#define USB_EP14R_STATRX_BIT 12
#define USB_EP14R_DTOGRX_MASK 0x4000U
#define USB_EP14R_DTOGRX 0x4000U
#define USB_EP14R_DTOGRX_BIT 14
#define USB_EP14R_CTRRX_MASK 0x8000U
#define USB_EP14R_CTRRX 0x8000U
#define USB_EP14R_CTRRX_BIT 15

#define USB_EP15R (*(volatile unsigned short *)0xC000803C)
#define USB_EP15R_EA_MASK 0xFU
#define USB_EP15R_EA_BIT 0
#define USB_EP15R_STATTX_MASK 0x30U
#define USB_EP15R_STATTX_BIT 4
#define USB_EP15R_DTOGTX_MASK 0x40U
#define USB_EP15R_DTOGTX 0x40U
#define USB_EP15R_DTOGTX_BIT 6
#define USB_EP15R_CTRTX_MASK 0x80U
#define USB_EP15R_CTRTX 0x80U
#define USB_EP15R_CTRTX_BIT 7
#define USB_EP15R_EPKIND_MASK 0x100U
#define USB_EP15R_EPKIND 0x100U
#define USB_EP15R_EPKIND_BIT 8
#define USB_EP15R_EPTYPE_MASK 0x600U
#define USB_EP15R_EPTYPE_BIT 9
#define USB_EP15R_SETUP_MASK 0x800U
#define USB_EP15R_SETUP 0x800U
#define USB_EP15R_SETUP_BIT 11
#define USB_EP15R_STATRX_MASK 0x3000U
#define USB_EP15R_STATRX_BIT 12
#define USB_EP15R_DTOGRX_MASK 0x4000U
#define USB_EP15R_DTOGRX 0x4000U
#define USB_EP15R_DTOGRX_BIT 14
#define USB_EP15R_CTRRX_MASK 0x8000U
#define USB_EP15R_CTRRX 0x8000U
#define USB_EP15R_CTRRX_BIT 15

#define USB_CNTR (*(volatile unsigned short *)0xC0008040)
#define USB_CNTR_FRES_MASK 0x1U
#define USB_CNTR_FRES 0x1U
#define USB_CNTR_FRES_BIT 0
#define USB_CNTR_PDWN_MASK 0x2U
#define USB_CNTR_PDWN 0x2U
#define USB_CNTR_PDWN_BIT 1
#define USB_CNTR_LPMODE_MASK 0x4U
#define USB_CNTR_LPMODE 0x4U
#define USB_CNTR_LPMODE_BIT 2
#define USB_CNTR_FSUSP_MASK 0x8U
#define USB_CNTR_FSUSP 0x8U
#define USB_CNTR_FSUSP_BIT 3
#define USB_CNTR_RESUME_MASK 0x10U
#define USB_CNTR_RESUME 0x10U
#define USB_CNTR_RESUME_BIT 4
#define USB_CNTR_ESOFM_MASK 0x100U
#define USB_CNTR_ESOFM 0x100U
#define USB_CNTR_ESOFM_BIT 8
#define USB_CNTR_SOFM_MASK 0x200U
#define USB_CNTR_SOFM 0x200U
#define USB_CNTR_SOFM_BIT 9
#define USB_CNTR_RESETM_MASK 0x400U
#define USB_CNTR_RESETM 0x400U
#define USB_CNTR_RESETM_BIT 10
#define USB_CNTR_SUSPM_MASK 0x800U
#define USB_CNTR_SUSPM 0x800U
#define USB_CNTR_SUSPM_BIT 11
#define USB_CNTR_WKPM_MASK 0x1000U
#define USB_CNTR_WKPM 0x1000U
#define USB_CNTR_WKPM_BIT 12
#define USB_CNTR_ERRM_MASK 0x2000U
#define USB_CNTR_ERRM 0x2000U
#define USB_CNTR_ERRM_BIT 13
#define USB_CNTR_DORM_MASK 0x4000U
#define USB_CNTR_DORM 0x4000U
#define USB_CNTR_DORM_BIT 14
#define USB_CNTR_CTRM_MASK 0x8000U
#define USB_CNTR_CTRM 0x8000U
#define USB_CNTR_CTRM_BIT 15

#define USB_ISTR (*(volatile unsigned short *)0xC0008044)
#define USB_ISTR_EP_ID_MASK 0xFU
#define USB_ISTR_EP_ID_BIT 0
#define USB_ISTR_DIR_MASK 0x10U
#define USB_ISTR_DIR 0x10U
#define USB_ISTR_DIR_BIT 4
#define USB_ISTR_ESOF_MASK 0x100U
#define USB_ISTR_ESOF 0x100U
#define USB_ISTR_ESOF_BIT 8
#define USB_ISTR_SOF_MASK 0x200U
#define USB_ISTR_SOF 0x200U
#define USB_ISTR_SOF_BIT 9
#define USB_ISTR_RESET_MASK 0x400U
#define USB_ISTR_RESET 0x400U
#define USB_ISTR_RESET_BIT 10
#define USB_ISTR_SUSP_MASK 0x800U
#define USB_ISTR_SUSP 0x800U
#define USB_ISTR_SUSP_BIT 11
#define USB_ISTR_WKUP_MASK 0x1000U
#define USB_ISTR_WKUP 0x1000U
#define USB_ISTR_WKUP_BIT 12
#define USB_ISTR_ERR_MASK 0x2000U
#define USB_ISTR_ERR 0x2000U
#define USB_ISTR_ERR_BIT 13
#define USB_ISTR_DOVR_MASK 0x4000U
#define USB_ISTR_DOVR 0x4000U
#define USB_ISTR_DOVR_BIT 14
#define USB_ISTR_CTR_MASK 0x8000U
#define USB_ISTR_CTR 0x8000U
#define USB_ISTR_CTR_BIT 15

#define USB_FNR (*(volatile unsigned short *)0xC0008048)
#define USB_FNR_FN_MASK 0x7FFU
#define USB_FNR_FN_BIT 0
#define USB_FNR_LSOF_MASK 0x1800U
#define USB_FNR_LSOF_BIT 11
#define USB_FNR_LCK_MASK 0x6000U
#define USB_FNR_LCK_BIT 13
#define USB_FNR_RXDM_MASK 0xC000U
#define USB_FNR_RXDM_BIT 14
#define USB_FNR_RXDP_MASK 0x18000U
#define USB_FNR_RXDP_BIT 15

#define USB_DADDR (*(volatile unsigned short *)0xC000804C)
#define USB_DADDR_ADD_MASK 0x7FU
#define USB_DADDR_ADD_BIT 0
#define USB_DADDR_EF_MASK 0x80U
#define USB_DADDR_EF 0x80U
#define USB_DADDR_EF_BIT 7

#define USB_BTABLE (*(volatile unsigned short *)0xC0008050)
#define USB_BTABLE_BTABLE_MASK 0xFFF8U
#define USB_BTABLE_BTABLE_BIT 3

#define CAN_CR (*(volatile unsigned short *)0xC0009000)
#define CAN_CR_Init_MASK 0x1U
#define CAN_CR_Init 0x1U
#define CAN_CR_Init_BIT 0
#define CAN_CR_IE_MASK 0x2U
#define CAN_CR_IE 0x2U
#define CAN_CR_IE_BIT 1
#define CAN_CR_SIE_MASK 0x4U
#define CAN_CR_SIE 0x4U
#define CAN_CR_SIE_BIT 2
#define CAN_CR_EIE_MASK 0x8U
#define CAN_CR_EIE 0x8U
#define CAN_CR_EIE_BIT 3
#define CAN_CR_DAR_MASK 0x20U
#define CAN_CR_DAR 0x20U
#define CAN_CR_DAR_BIT 5
#define CAN_CR_CCE_MASK 0x40U
#define CAN_CR_CCE 0x40U
#define CAN_CR_CCE_BIT 6
#define CAN_CR_Test_MASK 0x80U
#define CAN_CR_Test 0x80U
#define CAN_CR_Test_BIT 7

#define CAN_SR (*(volatile unsigned short *)0xC0009004)
#define CAN_SR_LEC_MASK 0x7U
#define CAN_SR_LEC_BIT 0
#define CAN_SR_TxOk_MASK 0x8U
#define CAN_SR_TxOk 0x8U
#define CAN_SR_TxOk_BIT 3
#define CAN_SR_RxOk_MASK 0x10U
#define CAN_SR_RxOk 0x10U
#define CAN_SR_RxOk_BIT 4
#define CAN_SR_EPass_MASK 0x20U
#define CAN_SR_EPass 0x20U
#define CAN_SR_EPass_BIT 5
#define CAN_SR_EWarn_MASK 0x40U
#define CAN_SR_EWarn 0x40U
#define CAN_SR_EWarn_BIT 6
#define CAN_SR_BOff_MASK 0x80U
#define CAN_SR_BOff 0x80U
#define CAN_SR_BOff_BIT 7

#define CAN_ERR (*(volatile unsigned short *)0xC0009008)
#define CAN_ERR_TEC7_0_MASK 0xFFU
#define CAN_ERR_TEC7_0_BIT 0
#define CAN_ERR_REC6_0_MASK 0x7F00U
#define CAN_ERR_REC6_0_BIT 8
#define CAN_ERR_RP_MASK 0x8000U
#define CAN_ERR_RP 0x8000U
#define CAN_ERR_RP_BIT 15

#define CAN_BTR (*(volatile unsigned short *)0xC000900C)
#define CAN_BTR_BRP_MASK 0x3FU
#define CAN_BTR_BRP_BIT 0
#define CAN_BTR_SJW_MASK 0xC0U
#define CAN_BTR_SJW_BIT 6
#define CAN_BTR_TSeg1_MASK 0xF00U
#define CAN_BTR_TSeg1_BIT 8
#define CAN_BTR_TSeg2_MASK 0x7000U
#define CAN_BTR_TSeg2_BIT 12

#define CAN_IDR (*(volatile unsigned short *)0xC0009010)
#define CAN_IDR_IntId7_0_MASK 0xFFU
#define CAN_IDR_IntId7_0_BIT 0
#define CAN_IDR_IntId15_8_MASK 0xFF00U
#define CAN_IDR_IntId15_8_BIT 8

#define CAN_TESTR (*(volatile unsigned short *)0xC0009014)
#define CAN_TESTR_Basic_MASK 0x4U
#define CAN_TESTR_Basic 0x4U
#define CAN_TESTR_Basic_BIT 2
#define CAN_TESTR_Silent_MASK 0x8U
#define CAN_TESTR_Silent 0x8U
#define CAN_TESTR_Silent_BIT 3
#define CAN_TESTR_LBack_MASK 0x10U
#define CAN_TESTR_LBack 0x10U
#define CAN_TESTR_LBack_BIT 4
#define CAN_TESTR_Tx0_MASK 0x20U
#define CAN_TESTR_Tx0 0x20U
#define CAN_TESTR_Tx0_BIT 5
#define CAN_TESTR_Tx1_MASK 0x40U
#define CAN_TESTR_Tx1 0x40U
#define CAN_TESTR_Tx1_BIT 6
#define CAN_TESTR_Rx1_MASK 0x80U
#define CAN_TESTR_Rx1 0x80U
#define CAN_TESTR_Rx1_BIT 7

#define CAN_BRPR (*(volatile unsigned short *)0xC0009018)

#define CAN_IF1_CR (*(volatile unsigned short *)0xC0009020)
#define CAN_IF1_CR_Message_Number_MASK 0x3FU
#define CAN_IF1_CR_Message_Number_BIT 0
#define CAN_IF1_CR_Busy_MASK 0x8000U
#define CAN_IF1_CR_Busy 0x8000U
#define CAN_IF1_CR_Busy_BIT 15

#define CAN_IF1_CMR (*(volatile unsigned short *)0xC0009024)
#define CAN_IF1_CMR_Data_B_MASK 0x1U
#define CAN_IF1_CMR_Data_B 0x1U
#define CAN_IF1_CMR_Data_B_BIT 0
#define CAN_IF1_CMR_Data_A_MASK 0x2U
#define CAN_IF1_CMR_Data_A 0x2U
#define CAN_IF1_CMR_Data_A_BIT 1
#define CAN_IF1_CMR_TxRqst_NewDat_MASK 0x4U
#define CAN_IF1_CMR_TxRqst_NewDat 0x4U
#define CAN_IF1_CMR_TxRqst_NewDat_BIT 2
#define CAN_IF1_CMR_ClrIntPnd_MASK 0x8U
#define CAN_IF1_CMR_ClrIntPnd 0x8U
#define CAN_IF1_CMR_ClrIntPnd_BIT 3
#define CAN_IF1_CMR_Control_MASK 0x10U
#define CAN_IF1_CMR_Control 0x10U
#define CAN_IF1_CMR_Control_BIT 4
#define CAN_IF1_CMR_Arb_MASK 0x20U
#define CAN_IF1_CMR_Arb 0x20U
#define CAN_IF1_CMR_Arb_BIT 5
#define CAN_IF1_CMR_Mask_MASK 0x40U
#define CAN_IF1_CMR_Mask 0x40U
#define CAN_IF1_CMR_Mask_BIT 6
#define CAN_IF1_CMR_WR/RD_MASK 0x80U
#define CAN_IF1_CMR_WR/RD 0x80U
#define CAN_IF1_CMR_WR/RD_BIT 7

#define CAN_IF1_M1R (*(volatile unsigned short *)0xC0009028)

#define CAN_IF1_M2R (*(volatile unsigned short *)0xC000902C)
#define CAN_IF1_M2R_Msk28_16_MASK 0x1FFFU
#define CAN_IF1_M2R_Msk28_16_BIT 0
#define CAN_IF1_M2R_MDir_MASK 0x4000U
#define CAN_IF1_M2R_MDir 0x4000U
#define CAN_IF1_M2R_MDir_BIT 14
#define CAN_IF1_M2R_MXtd_MASK 0x8000U
#define CAN_IF1_M2R_MXtd 0x8000U
#define CAN_IF1_M2R_MXtd_BIT 15

#define CAN_IF1_A1R (*(volatile unsigned short *)0xC0009030)

#define CAN_IF1_A2R (*(volatile unsigned short *)0xC0009034)
#define CAN_IF1_A2R_ID28_16_MASK 0x1FFFU
#define CAN_IF1_A2R_ID28_16_BIT 0
#define CAN_IF1_A2R_Dir_MASK 0x2000U
#define CAN_IF1_A2R_Dir 0x2000U
#define CAN_IF1_A2R_Dir_BIT 13
#define CAN_IF1_A2R_Xtd_MASK 0x4000U
#define CAN_IF1_A2R_Xtd 0x4000U
#define CAN_IF1_A2R_Xtd_BIT 14
#define CAN_IF1_A2R_MsgVaI_MASK 0x8000U
#define CAN_IF1_A2R_MsgVaI 0x8000U
#define CAN_IF1_A2R_MsgVaI_BIT 15

#define CAN_IF1_MCR (*(volatile unsigned short *)0xC0009038)
#define CAN_IF1_MCR_DLC3_0_MASK 0xFU
#define CAN_IF1_MCR_DLC3_0_BIT 0
#define CAN_IF1_MCR_EoB_MASK 0x80U
#define CAN_IF1_MCR_EoB 0x80U
#define CAN_IF1_MCR_EoB_BIT 7
#define CAN_IF1_MCR_TxRqst_MASK 0x100U
#define CAN_IF1_MCR_TxRqst 0x100U
#define CAN_IF1_MCR_TxRqst_BIT 8
#define CAN_IF1_MCR_RmtEn_MASK 0x200U
#define CAN_IF1_MCR_RmtEn 0x200U
#define CAN_IF1_MCR_RmtEn_BIT 9
#define CAN_IF1_MCR_RxlE_MASK 0x400U
#define CAN_IF1_MCR_RxlE 0x400U
#define CAN_IF1_MCR_RxlE_BIT 10
#define CAN_IF1_MCR_TxlE_MASK 0x800U
#define CAN_IF1_MCR_TxlE 0x800U
#define CAN_IF1_MCR_TxlE_BIT 11
#define CAN_IF1_MCR_UMask_MASK 0x1000U
#define CAN_IF1_MCR_UMask 0x1000U
#define CAN_IF1_MCR_UMask_BIT 12
#define CAN_IF1_MCR_IntPnd_MASK 0x2000U
#define CAN_IF1_MCR_IntPnd 0x2000U
#define CAN_IF1_MCR_IntPnd_BIT 13
#define CAN_IF1_MCR_MsgLst_MASK 0x4000U
#define CAN_IF1_MCR_MsgLst 0x4000U
#define CAN_IF1_MCR_MsgLst_BIT 14
#define CAN_IF1_MCR_NewDat_MASK 0x8000U
#define CAN_IF1_MCR_NewDat 0x8000U
#define CAN_IF1_MCR_NewDat_BIT 15

#define CAN_IF1_DA1R (*(volatile unsigned short *)0xC000903C)

#define CAN_IF1_DA2R (*(volatile unsigned short *)0xC0009040)

#define CAN_IF1_DB1R (*(volatile unsigned short *)0xC0009044)

#define CAN_IF1_DB2R (*(volatile unsigned short *)0xC0009048)

#define CAN_IF2_CMR (*(volatile unsigned short *)0xC0009080)
#define CAN_IF2_CMR_Message_Number_MASK 0x3FU
#define CAN_IF2_CMR_Message_Number_BIT 0
#define CAN_IF2_CMR_Busy_MASK 0x8000U
#define CAN_IF2_CMR_Busy 0x8000U
#define CAN_IF2_CMR_Busy_BIT 15

#define CAN_IF2_CMR (*(volatile unsigned short *)0xC0009084)
#define CAN_IF2_CMR_Data_B_MASK 0x1U
#define CAN_IF2_CMR_Data_B 0x1U
#define CAN_IF2_CMR_Data_B_BIT 0
#define CAN_IF2_CMR_Data_A_MASK 0x2U
#define CAN_IF2_CMR_Data_A 0x2U
#define CAN_IF2_CMR_Data_A_BIT 1
#define CAN_IF2_CMR_TxRqst_NewDat_MASK 0x4U
#define CAN_IF2_CMR_TxRqst_NewDat 0x4U
#define CAN_IF2_CMR_TxRqst_NewDat_BIT 2
#define CAN_IF2_CMR_ClrIntPnd_MASK 0x8U
#define CAN_IF2_CMR_ClrIntPnd 0x8U
#define CAN_IF2_CMR_ClrIntPnd_BIT 3
#define CAN_IF2_CMR_Control_MASK 0x10U
#define CAN_IF2_CMR_Control 0x10U
#define CAN_IF2_CMR_Control_BIT 4
#define CAN_IF2_CMR_Arb_MASK 0x20U
#define CAN_IF2_CMR_Arb 0x20U
#define CAN_IF2_CMR_Arb_BIT 5
#define CAN_IF2_CMR_Mask_MASK 0x40U
#define CAN_IF2_CMR_Mask 0x40U
#define CAN_IF2_CMR_Mask_BIT 6
#define CAN_IF2_CMR_WR/RD_MASK 0x80U
#define CAN_IF2_CMR_WR/RD 0x80U
#define CAN_IF2_CMR_WR/RD_BIT 7

#define CAN_IF2_M1R (*(volatile unsigned short *)0xC0009088)

#define CAN_IF2_M2R (*(volatile unsigned short *)0xC000908C)
#define CAN_IF2_M2R_Msk28_16_MASK 0x1FFFU
#define CAN_IF2_M2R_Msk28_16_BIT 0
#define CAN_IF2_M2R_MDir_MASK 0x4000U
#define CAN_IF2_M2R_MDir 0x4000U
#define CAN_IF2_M2R_MDir_BIT 14
#define CAN_IF2_M2R_MXtd_MASK 0x8000U
#define CAN_IF2_M2R_MXtd 0x8000U
#define CAN_IF2_M2R_MXtd_BIT 15

#define CAN_IF2_A1R (*(volatile unsigned short *)0xC0009090)

#define CAN_IF2_A2R (*(volatile unsigned short *)0xC0009094)
#define CAN_IF2_A2R_ID28_16_MASK 0x1FFFU
#define CAN_IF2_A2R_ID28_16_BIT 0
#define CAN_IF2_A2R_Dir_MASK 0x2000U
#define CAN_IF2_A2R_Dir 0x2000U
#define CAN_IF2_A2R_Dir_BIT 13
#define CAN_IF2_A2R_Xtd_MASK 0x4000U
#define CAN_IF2_A2R_Xtd 0x4000U
#define CAN_IF2_A2R_Xtd_BIT 14
#define CAN_IF2_A2R_MsgVaI_MASK 0x8000U
#define CAN_IF2_A2R_MsgVaI 0x8000U
#define CAN_IF2_A2R_MsgVaI_BIT 15

#define CAN_IF2_MCR (*(volatile unsigned short *)0xC0009098)
#define CAN_IF2_MCR_DLC3_0_MASK 0xFU
#define CAN_IF2_MCR_DLC3_0_BIT 0
#define CAN_IF2_MCR_EoB_MASK 0x80U
#define CAN_IF2_MCR_EoB 0x80U
#define CAN_IF2_MCR_EoB_BIT 7
#define CAN_IF2_MCR_TxRqst_MASK 0x100U
#define CAN_IF2_MCR_TxRqst 0x100U
#define CAN_IF2_MCR_TxRqst_BIT 8
#define CAN_IF2_MCR_RmtEn_MASK 0x200U
#define CAN_IF2_MCR_RmtEn 0x200U
#define CAN_IF2_MCR_RmtEn_BIT 9
#define CAN_IF2_MCR_RxlE_MASK 0x400U
#define CAN_IF2_MCR_RxlE 0x400U
#define CAN_IF2_MCR_RxlE_BIT 10
#define CAN_IF2_MCR_TxlE_MASK 0x800U
#define CAN_IF2_MCR_TxlE 0x800U
#define CAN_IF2_MCR_TxlE_BIT 11
#define CAN_IF2_MCR_UMask_MASK 0x1000U
#define CAN_IF2_MCR_UMask 0x1000U
#define CAN_IF2_MCR_UMask_BIT 12
#define CAN_IF2_MCR_IntPnd_MASK 0x2000U
#define CAN_IF2_MCR_IntPnd 0x2000U
#define CAN_IF2_MCR_IntPnd_BIT 13
#define CAN_IF2_MCR_MsgLst_MASK 0x4000U
#define CAN_IF2_MCR_MsgLst 0x4000U
#define CAN_IF2_MCR_MsgLst_BIT 14
#define CAN_IF2_MCR_NewDat_MASK 0x8000U
#define CAN_IF2_MCR_NewDat 0x8000U
#define CAN_IF2_MCR_NewDat_BIT 15

#define CAN_IF2_DA1R (*(volatile unsigned short *)0xC000909C)

#define CAN_IF2_DA2R (*(volatile unsigned short *)0xC00090A0)

#define CAN_IF2_DB1R (*(volatile unsigned short *)0xC00090A4)

#define CAN_IF2_DB2R (*(volatile unsigned short *)0xC00090A8)

#define CAN_TxR1R (*(volatile unsigned short *)0xC0009100)

#define CAN_TxR2R (*(volatile unsigned short *)0xC0009104)

#define CAN_ND1R (*(volatile unsigned short *)0xC0009120)

#define CAN_ND2R (*(volatile unsigned short *)0xC0009124)

#define CAN_IP1R (*(volatile unsigned short *)0xC0009140)
#define CAN_IP1R_IntPnd8_1_MASK 0xFFU
#define CAN_IP1R_IntPnd8_1_BIT 0
#define CAN_IP1R_IntPnd16_9_MASK 0xFF00U
#define CAN_IP1R_IntPnd16_9_BIT 8

#define CAN_IP2R (*(volatile unsigned short *)0xC0009144)
#define CAN_IP2R_IntPnd24_17_MASK 0xFFU
#define CAN_IP2R_IntPnd24_17_BIT 0
#define CAN_IP2R_IntPnd32_25_MASK 0xFF00U
#define CAN_IP2R_IntPnd32_25_BIT 8

#define CAN_MV1R (*(volatile unsigned short *)0xC0009160)
#define CAN_MV1R_MsgVal8_1_MASK 0xFFU
#define CAN_MV1R_MsgVal8_1_BIT 0
#define CAN_MV1R_MsgVal16_9_MASK 0xFF00U
#define CAN_MV1R_MsgVal16_9_BIT 8

#define CAN_MV2R (*(volatile unsigned short *)0xC0009164)
#define CAN_MV2R_MsgVal24_17_MASK 0xFFU
#define CAN_MV2R_MsgVal24_17_BIT 0
#define CAN_MV2R_MsgVal32_25_MASK 0xFF00U
#define CAN_MV2R_MsgVal32_25_BIT 8

#define BSPI0_RXR (*(volatile unsigned short *)0xC000A000)

#define BSPI0_TXR (*(volatile unsigned short *)0xC000A004)

#define BSPI0_CSR1 (*(volatile unsigned short *)0xC000A008)
#define BSPI0_CSR1_BSPE_MASK 0x1U
#define BSPI0_CSR1_BSPE 0x1U
#define BSPI0_CSR1_BSPE_BIT 0
#define BSPI0_CSR1_MSTR_MASK 0x2U
#define BSPI0_CSR1_MSTR 0x2U
#define BSPI0_CSR1_MSTR_BIT 1
#define BSPI0_CSR1_RIE_MASK 0xCU
#define BSPI0_CSR1_RIE_BIT 2
#define BSPI0_CSR1_REIE_MASK 0x10U
#define BSPI0_CSR1_REIE 0x10U
#define BSPI0_CSR1_REIE_BIT 4
#define BSPI0_CSR1_BEIE_MASK 0x80U
#define BSPI0_CSR1_BEIE 0x80U
#define BSPI0_CSR1_BEIE_BIT 7
#define BSPI0_CSR1_CPOL_MASK 0x100U
#define BSPI0_CSR1_CPOL 0x100U
#define BSPI0_CSR1_CPOL_BIT 8
#define BSPI0_CSR1_CPHA_MASK 0x200U
#define BSPI0_CSR1_CPHA 0x200U
#define BSPI0_CSR1_CPHA_BIT 9
#define BSPI0_CSR1_WL_MASK 0xC00U
#define BSPI0_CSR1_WL_BIT 10
#define BSPI0_CSR1_RFE_MASK 0xF000U
#define BSPI0_CSR1_RFE_BIT 12

#define BSPI0_CSR2 (*(volatile unsigned short *)0xC000A00C)
#define BSPI0_CSR2_DFIFO_MASK 0x1U
#define BSPI0_CSR2_DFIFO 0x1U
#define BSPI0_CSR2_DFIFO_BIT 0
#define BSPI0_CSR2_BERR_MASK 0xCU
#define BSPI0_CSR2_BERR_BIT 2
#define BSPI0_CSR2_RFNE_MASK 0x8U
#define BSPI0_CSR2_RFNE 0x8U
#define BSPI0_CSR2_RFNE_BIT 3
#define BSPI0_CSR2_RFF_MASK 0x10U
#define BSPI0_CSR2_RFF 0x10U
#define BSPI0_CSR2_RFF_BIT 4
#define BSPI0_CSR2_ROFL_MASK 0x20U
#define BSPI0_CSR2_ROFL 0x20U
#define BSPI0_CSR2_ROFL_BIT 5
#define BSPI0_CSR2_TFE_MASK 0x40U
#define BSPI0_CSR2_TFE 0x40U
#define BSPI0_CSR2_TFE_BIT 6
#define BSPI0_CSR2_TUFL_MASK 0x80U
#define BSPI0_CSR2_TUFL 0x80U
#define BSPI0_CSR2_TUFL_BIT 7
#define BSPI0_CSR2_TFF_MASK 0x100U
#define BSPI0_CSR2_TFF 0x100U
#define BSPI0_CSR2_TFF_BIT 8
#define BSPI0_CSR2_TFNE_MASK 0x200U
#define BSPI0_CSR2_TFNE 0x200U
#define BSPI0_CSR2_TFNE_BIT 9
#define BSPI0_CSR2_TFE_MASK 0x3C00U
#define BSPI0_CSR2_TFE_BIT 10
#define BSPI0_CSR2_TIE_MASK 0x4U
#define BSPI0_CSR2_TIE 0x4U
#define BSPI0_CSR2_TIE_BIT 2

#define BSPI0_CLK (*(volatile unsigned short *)0xC000A010)

#define BSPI1_RXR (*(volatile unsigned short *)0xC000B000)

#define BSPI1_TXR (*(volatile unsigned short *)0xC000B004)

#define BSPI1_CSR1 (*(volatile unsigned short *)0xC000B008)
#define BSPI1_CSR1_BSPE_MASK 0x1U
#define BSPI1_CSR1_BSPE 0x1U
#define BSPI1_CSR1_BSPE_BIT 0
#define BSPI1_CSR1_MSTR_MASK 0x2U
#define BSPI1_CSR1_MSTR 0x2U
#define BSPI1_CSR1_MSTR_BIT 1
#define BSPI1_CSR1_RIE_MASK 0xCU
#define BSPI1_CSR1_RIE_BIT 2
#define BSPI1_CSR1_REIE_MASK 0x10U
#define BSPI1_CSR1_REIE 0x10U
#define BSPI1_CSR1_REIE_BIT 4
#define BSPI1_CSR1_BEIE_MASK 0x80U
#define BSPI1_CSR1_BEIE 0x80U
#define BSPI1_CSR1_BEIE_BIT 7
#define BSPI1_CSR1_CPOL_MASK 0x100U
#define BSPI1_CSR1_CPOL 0x100U
#define BSPI1_CSR1_CPOL_BIT 8
#define BSPI1_CSR1_CPHA_MASK 0x200U
#define BSPI1_CSR1_CPHA 0x200U
#define BSPI1_CSR1_CPHA_BIT 9
#define BSPI1_CSR1_WL_MASK 0xC00U
#define BSPI1_CSR1_WL_BIT 10
#define BSPI1_CSR1_RFE_MASK 0xF000U
#define BSPI1_CSR1_RFE_BIT 12

#define BSPI1_CSR2 (*(volatile unsigned short *)0xC000B00C)
#define BSPI1_CSR2_DFIFO_MASK 0x1U
#define BSPI1_CSR2_DFIFO 0x1U
#define BSPI1_CSR2_DFIFO_BIT 0
#define BSPI1_CSR2_BERR_MASK 0xCU
#define BSPI1_CSR2_BERR_BIT 2
#define BSPI1_CSR2_RFNE_MASK 0x8U
#define BSPI1_CSR2_RFNE 0x8U
#define BSPI1_CSR2_RFNE_BIT 3
#define BSPI1_CSR2_RFF_MASK 0x10U
#define BSPI1_CSR2_RFF 0x10U
#define BSPI1_CSR2_RFF_BIT 4
#define BSPI1_CSR2_ROFL_MASK 0x20U
#define BSPI1_CSR2_ROFL 0x20U
#define BSPI1_CSR2_ROFL_BIT 5
#define BSPI1_CSR2_TFE_MASK 0x40U
#define BSPI1_CSR2_TFE 0x40U
#define BSPI1_CSR2_TFE_BIT 6
#define BSPI1_CSR2_TUFL_MASK 0x80U
#define BSPI1_CSR2_TUFL 0x80U
#define BSPI1_CSR2_TUFL_BIT 7
#define BSPI1_CSR2_TFF_MASK 0x100U
#define BSPI1_CSR2_TFF 0x100U
#define BSPI1_CSR2_TFF_BIT 8
#define BSPI1_CSR2_TFNE_MASK 0x200U
#define BSPI1_CSR2_TFNE 0x200U
#define BSPI1_CSR2_TFNE_BIT 9
#define BSPI1_CSR2_TFE_MASK 0x3C00U
#define BSPI1_CSR2_TFE_BIT 10
#define BSPI1_CSR2_TIE_MASK 0x4U
#define BSPI1_CSR2_TIE 0x4U
#define BSPI1_CSR2_TIE_BIT 2

#define BSPI1_CLK (*(volatile unsigned short *)0xC000B010)

#define HDLC_PARH (*(volatile unsigned short *)0xC000E000)
#define HDLC_PARH_PAB2_MASK 0xFFU
#define HDLC_PARH_PAB2_BIT 0
#define HDLC_PARH_PAB3_MASK 0xFF00U
#define HDLC_PARH_PAB3_BIT 8

#define HDLC_PARL (*(volatile unsigned short *)0xC000E004)
#define HDLC_PARL_PAB0_MASK 0xFFU
#define HDLC_PARL_PAB0_BIT 0
#define HDLC_PARL_PAB1_MASK 0xFF00U
#define HDLC_PARL_PAB1_BIT 8

#define HDLC_PAMH (*(volatile unsigned short *)0xC000E008)
#define HDLC_PAMH_PAMB2_MASK 0xFFU
#define HDLC_PAMH_PAMB2_BIT 0
#define HDLC_PAMH_PAMB3_MASK 0xFF00U
#define HDLC_PAMH_PAMB3_BIT 8

#define HDLC_PAML (*(volatile unsigned short *)0xC000E00C)
#define HDLC_PAML_PAMB0_MASK 0xFFU
#define HDLC_PAML_PAMB0_BIT 0
#define HDLC_PAML_PAMB1_MASK 0xFF00U
#define HDLC_PAML_PAMB1_BIT 8

#define HDLC_GA1 (*(volatile unsigned short *)0xC000E010)
#define HDLC_GA1_GA2_MASK 0xFFU
#define HDLC_GA1_GA2_BIT 0
#define HDLC_GA1_BA_MASK 0xFF00U
#define HDLC_GA1_BA_BIT 8

#define HDLC_GA0 (*(volatile unsigned short *)0xC000E014)
#define HDLC_GA0_GA0_MASK 0xFFU
#define HDLC_GA0_GA0_BIT 0
#define HDLC_GA0_GA1_MASK 0xFF00U
#define HDLC_GA0_GA1_BIT 8

#define HDLC_GAM1 (*(volatile unsigned short *)0xC000E018)
#define HDLC_GAM1_GAM2_MASK 0xFFU
#define HDLC_GAM1_GAM2_BIT 0
#define HDLC_GAM1_BAM_MASK 0xFF00U
#define HDLC_GAM1_BAM_BIT 8

#define HDLC_GAM0 (*(volatile unsigned short *)0xC000E01C)
#define HDLC_GAM0_GAM0_MASK 0xFFU
#define HDLC_GAM0_GAM0_BIT 0
#define HDLC_GAM0_GAM1_MASK 0xFF00U
#define HDLC_GAM0_GAM1_BIT 8

#define HDLC_PRES (*(volatile unsigned short *)0xC000E020)

#define HDLC_POSS (*(volatile unsigned short *)0xC000E024)

#define HDLC_TCTL (*(volatile unsigned short *)0xC000E028)
#define HDLC_TCTL_NPOSB_MASK 0xFU
#define HDLC_TCTL_NPOSB_BIT 0
#define HDLC_TCTL_NPREB_MASK 0xF0U
#define HDLC_TCTL_NPREB_BIT 4
#define HDLC_TCTL_POSE_MASK 0x100U
#define HDLC_TCTL_POSE 0x100U
#define HDLC_TCTL_POSE_BIT 8
#define HDLC_TCTL_PREE_MASK 0x200U
#define HDLC_TCTL_PREE 0x200U
#define HDLC_TCTL_PREE_BIT 9
#define HDLC_TCTL_TCOD_MASK 0xC00U
#define HDLC_TCTL_TCOD_BIT 10
#define HDLC_TCTL_TCRCI_MASK 0x1000U
#define HDLC_TCTL_TCRCI 0x1000U
#define HDLC_TCTL_TCRCI_BIT 12
#define HDLC_TCTL_ITF_MASK 0x2000U
#define HDLC_TCTL_ITF 0x2000U
#define HDLC_TCTL_ITF_BIT 13
#define HDLC_TCTL_SOC_MASK 0x8000U
#define HDLC_TCTL_SOC 0x8000U
#define HDLC_TCTL_SOC_BIT 15
#define HDLC_TCTL_HTEN_MASK 0xF0000U
#define HDLC_TCTL_HTEN_BIT 16

#define HDLC_RCTL (*(volatile unsigned short *)0xC000E02C)
#define HDLC_RCTL_RCOD_MASK 0x3U
#define HDLC_RCTL_RCOD_BIT 0
#define HDLC_RCTL_RCRCI_MASK 0x4U
#define HDLC_RCTL_RCRCI 0x4U
#define HDLC_RCTL_RCRCI_BIT 2
#define HDLC_RCTL_SIC_MASK 0x8U
#define HDLC_RCTL_SIC 0x8U
#define HDLC_RCTL_SIC_BIT 3
#define HDLC_RCTL_LBEN_MASK 0x10U
#define HDLC_RCTL_LBEN 0x10U
#define HDLC_RCTL_LBEN_BIT 4
#define HDLC_RCTL_AEN_MASK 0x20U
#define HDLC_RCTL_AEN 0x20U
#define HDLC_RCTL_AEN_BIT 5
#define HDLC_RCTL_GAOE_MASK 0x40U
#define HDLC_RCTL_GAOE 0x40U
#define HDLC_RCTL_GAOE_BIT 6
#define HDLC_RCTL_GA1E_MASK 0x80U
#define HDLC_RCTL_GA1E 0x80U
#define HDLC_RCTL_GA1E_BIT 7
#define HDLC_RCTL_GA2E_MASK 0x100U
#define HDLC_RCTL_GA2E 0x100U
#define HDLC_RCTL_GA2E_BIT 8
#define HDLC_RCTL_BAE_MASK 0x200U
#define HDLC_RCTL_BAE 0x200U
#define HDLC_RCTL_BAE_BIT 9
#define HDLC_RCTL_PAE_MASK 0x400U
#define HDLC_RCTL_PAE 0x400U
#define HDLC_RCTL_PAE_BIT 10
#define HDLC_RCTL_DPLLE_MASK 0x800U
#define HDLC_RCTL_DPLLE 0x800U
#define HDLC_RCTL_DPLLE_BIT 11
#define HDLC_RCTL_RCME_MASK 0x1000U
#define HDLC_RCTL_RCME 0x1000U
#define HDLC_RCTL_RCME_BIT 12

#define HDLC_BRR (*(volatile unsigned short *)0xC000E030)
#define HDLC_BRR_BRG_MASK 0xFFFU
#define HDLC_BRR_BRG_BIT 0
#define HDLC_BRR_TCKS_MASK 0x1000U
#define HDLC_BRR_TCKS 0x1000U
#define HDLC_BRR_TCKS_BIT 12

#define HDLC_PRSR (*(volatile unsigned short *)0xC000E034)
#define HDLC_PRSR_PSR_MASK 0xFFU
#define HDLC_PRSR_PSR_BIT 0
#define HDLC_PRSR_RCKS_MASK 0x300U
#define HDLC_PRSR_RCKS_BIT 8

#define HDLC_PSR (*(volatile unsigned short *)0xC000E038)
#define HDLC_PSR_RLS_MASK 0x3U
#define HDLC_PSR_RLS_BIT 0
#define HDLC_PSR_TBR_MASK 0x4U
#define HDLC_PSR_TBR 0x4U
#define HDLC_PSR_TBR_BIT 2
#define HDLC_PSR_RBR_MASK 0x8U
#define HDLC_PSR_RBR 0x8U
#define HDLC_PSR_RBR_BIT 3

#define HDLC_FSBR (*(volatile unsigned short *)0xC000E03C)
#define HDLC_FSBR_RAB_MASK 0x1U
#define HDLC_FSBR_RAB 0x1U
#define HDLC_FSBR_RAB_BIT 0
#define HDLC_FSBR_CRC_MASK 0x2U
#define HDLC_FSBR_CRC 0x2U
#define HDLC_FSBR_CRC_BIT 1
#define HDLC_FSBR_RDO_MASK 0x4U
#define HDLC_FSBR_RDO 0x4U
#define HDLC_FSBR_RDO_BIT 2
#define HDLC_FSBR_RBC_MASK 0x8U
#define HDLC_FSBR_RBC 0x8U
#define HDLC_FSBR_RBC_BIT 3

#define HDLC_TFBCR (*(volatile unsigned short *)0xC000E040)

#define HDLC_RFBCR (*(volatile unsigned short *)0xC000E044)

#define HDLC_PCR (*(volatile unsigned short *)0xC000E048)
#define HDLC_PCR_REN_MASK 0x1U
#define HDLC_PCR_REN 0x1U
#define HDLC_PCR_REN_BIT 0
#define HDLC_PCR_TEN_MASK 0x2U
#define HDLC_PCR_TEN 0x2U
#define HDLC_PCR_TEN_BIT 1

#define HDLC_ISR (*(volatile unsigned short *)0xC000E04C)
#define HDLC_ISR_RME_MASK 0x1U
#define HDLC_ISR_RME 0x1U
#define HDLC_ISR_RME_BIT 0
#define HDLC_ISR_RMC_MASK 0x2U
#define HDLC_ISR_RMC 0x2U
#define HDLC_ISR_RMC_BIT 1
#define HDLC_ISR_RFO_MASK 0x4U
#define HDLC_ISR_RFO 0x4U
#define HDLC_ISR_RFO_BIT 2
#define HDLC_ISR_RBF_MASK 0x8U
#define HDLC_ISR_RBF 0x8U
#define HDLC_ISR_RBF_BIT 3
#define HDLC_ISR_TBU_MASK 0x10U
#define HDLC_ISR_TBU 0x10U
#define HDLC_ISR_TBU_BIT 4
#define HDLC_ISR_TBE_MASK 0x20U
#define HDLC_ISR_TBE 0x20U
#define HDLC_ISR_TBE_BIT 5
#define HDLC_ISR_TMC_MASK 0x40U
#define HDLC_ISR_TMC 0x40U
#define HDLC_ISR_TMC_BIT 6

#define HDLC_IMR (*(volatile unsigned short *)0xC000E050)
#define HDLC_IMR_RMEM_MASK 0x1U
#define HDLC_IMR_RMEM 0x1U
#define HDLC_IMR_RMEM_BIT 0
#define HDLC_IMR_RMCM_MASK 0x2U
#define HDLC_IMR_RMCM 0x2U
#define HDLC_IMR_RMCM_BIT 1
#define HDLC_IMR_RFOM_MASK 0x4U
#define HDLC_IMR_RFOM 0x4U
#define HDLC_IMR_RFOM_BIT 2
#define HDLC_IMR_RBFM_MASK 0x8U
#define HDLC_IMR_RBFM 0x8U
#define HDLC_IMR_RBFM_BIT 3
#define HDLC_IMR_TBUM_MASK 0x10U
#define HDLC_IMR_TBUM 0x10U
#define HDLC_IMR_TBUM_BIT 4
#define HDLC_IMR_TBEM_MASK 0x20U
#define HDLC_IMR_TBEM 0x20U
#define HDLC_IMR_TBEM_BIT 5
#define HDLC_IMR_TMCM_MASK 0x40U
#define HDLC_IMR_TMCM 0x40U
#define HDLC_IMR_TMCM_BIT 6

#define APB2_CKDIS (*(volatile unsigned long *)0xE0000010)

#define APB2_SWRES (*(volatile unsigned long *)0xE0000014)

#define XTI_SR (*(volatile unsigned char *)0xE000101C)

#define XTI_CTRL (*(volatile unsigned char *)0xE0001024)
#define XTI_CTRL_WKUP_INT_MASK 0x1U
#define XTI_CTRL_WKUP_INT 0x1U
#define XTI_CTRL_WKUP_INT_BIT 0
#define XTI_CTRL_ID1S_MASK 0x2U
#define XTI_CTRL_ID1S 0x2U
#define XTI_CTRL_ID1S_BIT 1
#define XTI_CTRL_STOP_MASK 0x4U
#define XTI_CTRL_STOP 0x4U
#define XTI_CTRL_STOP_BIT 2

#define XTI_MRH (*(volatile unsigned char *)0xE0001028)

#define XTI_MRL (*(volatile unsigned char *)0xE000102C)

#define XTI_TRH (*(volatile unsigned char *)0xE0001030)

#define XTI_TRL (*(volatile unsigned char *)0xE0001034)

#define XTI_PRH (*(volatile unsigned char *)0xE0001038)

#define XTI_PRL (*(volatile unsigned char *)0xE000103C)

#define IOPORT0_PC0 (*(volatile unsigned short *)0xE0003000)

#define IOPORT0_PC1 (*(volatile unsigned short *)0xE0003004)

#define IOPORT0_PC2 (*(volatile unsigned short *)0xE0003008)

#define IOPORT0_PD (*(volatile unsigned short *)0xE000300C)

#define IOPORT1_PC0 (*(volatile unsigned short *)0xE0004000)

#define IOPORT1_PC1 (*(volatile unsigned short *)0xE0004004)

#define IOPORT1_PC2 (*(volatile unsigned short *)0xE0004008)

#define IOPORT1_PD (*(volatile unsigned short *)0xE000400C)

#define IOPORT2_PC0 (*(volatile unsigned short *)0xE0005000)

#define IOPORT2_PC1 (*(volatile unsigned short *)0xE0005004)

#define IOPORT2_PC2 (*(volatile unsigned short *)0xE0005008)

#define IOPORT2_PD (*(volatile unsigned short *)0xE000500C)

#define ADC_DATA0 (*(volatile unsigned short *)0xE0007000)
#define ADC_DATA0_DATA0_MASK 0x7FF0U
#define ADC_DATA0_DATA0_BIT 4

#define ADC_DATA1 (*(volatile unsigned short *)0xE0007008)
#define ADC_DATA1_DATA1_MASK 0x7FF0U
#define ADC_DATA1_DATA1_BIT 4

#define ADC_DATA2 (*(volatile unsigned short *)0xE0007010)
#define ADC_DATA2_DATA2_MASK 0x7FF0U
#define ADC_DATA2_DATA2_BIT 4

#define ADC_DATA3 (*(volatile unsigned short *)0xE0007018)
#define ADC_DATA3_DATA3_MASK 0x7FF0U
#define ADC_DATA3_DATA3_BIT 4

#define ADC_CSR (*(volatile unsigned short *)0xE0007020)
#define ADC_CSR_DA_MASK 0xFU
#define ADC_CSR_DA_BIT 0
#define ADC_CSR_A_MASK 0x30U
#define ADC_CSR_A_BIT 4
#define ADC_CSR_AXT_MASK 0x40U
#define ADC_CSR_AXT 0x40U
#define ADC_CSR_AXT_BIT 6
#define ADC_CSR_IE_MASK 0xF00U
#define ADC_CSR_IE_BIT 8
#define ADC_CSR_OR_MASK 0x2000U
#define ADC_CSR_OR 0x2000U
#define ADC_CSR_OR_BIT 13

#define ADC_CPR (*(volatile unsigned short *)0xE0007030)

#define TIM0_ICAR (*(volatile unsigned short *)0xE0009000)

#define TIM0_ICBR (*(volatile unsigned short *)0xE0009004)

#define TIM0_OCAR (*(volatile unsigned short *)0xE0009008)

#define TIM0_OCBR (*(volatile unsigned short *)0xE000900C)

#define TIM0_CNTR (*(volatile unsigned short *)0xE0009010)

#define TIM0_CR1 (*(volatile unsigned short *)0xE0009014)
#define TIM0_CR1_ECKEN_MASK 0x1U
#define TIM0_CR1_ECKEN 0x1U
#define TIM0_CR1_ECKEN_BIT 0
#define TIM0_CR1_EXEDG_MASK 0x2U
#define TIM0_CR1_EXEDG 0x2U
#define TIM0_CR1_EXEDG_BIT 1
#define TIM0_CR1_IEDGA_MASK 0x4U
#define TIM0_CR1_IEDGA 0x4U
#define TIM0_CR1_IEDGA_BIT 2
#define TIM0_CR1_IEDGB_MASK 0x8U
#define TIM0_CR1_IEDGB 0x8U
#define TIM0_CR1_IEDGB_BIT 3
#define TIM0_CR1_PWM_MASK 0x10U
#define TIM0_CR1_PWM 0x10U
#define TIM0_CR1_PWM_BIT 4
#define TIM0_CR1_OPM_MASK 0x20U
#define TIM0_CR1_OPM 0x20U
#define TIM0_CR1_OPM_BIT 5
#define TIM0_CR1_OCAE_MASK 0x40U
#define TIM0_CR1_OCAE 0x40U
#define TIM0_CR1_OCAE_BIT 6
#define TIM0_CR1_OCBE_MASK 0x80U
#define TIM0_CR1_OCBE 0x80U
#define TIM0_CR1_OCBE_BIT 7
#define TIM0_CR1_OLVLA_MASK 0x100U
#define TIM0_CR1_OLVLA 0x100U
#define TIM0_CR1_OLVLA_BIT 8
#define TIM0_CR1_OLVLB_MASK 0x200U
#define TIM0_CR1_OLVLB 0x200U
#define TIM0_CR1_OLVLB_BIT 9
#define TIM0_CR1_FOLVLA_MASK 0x400U
#define TIM0_CR1_FOLVLA 0x400U
#define TIM0_CR1_FOLVLA_BIT 10
#define TIM0_CR1_FOLVLB_MASK 0x800U
#define TIM0_CR1_FOLVLB 0x800U
#define TIM0_CR1_FOLVLB_BIT 11
#define TIM0_CR1_PWMI_MASK 0x4000U
#define TIM0_CR1_PWMI 0x4000U
#define TIM0_CR1_PWMI_BIT 14
#define TIM0_CR1_EN_MASK 0x8000U
#define TIM0_CR1_EN 0x8000U
#define TIM0_CR1_EN_BIT 15

#define TIM0_CR2 (*(volatile unsigned short *)0xE0009018)
#define TIM0_CR2_CC0_MASK 0x1U
#define TIM0_CR2_CC0 0x1U
#define TIM0_CR2_CC0_BIT 0
#define TIM0_CR2_CC1_MASK 0x2U
#define TIM0_CR2_CC1 0x2U
#define TIM0_CR2_CC1_BIT 1
#define TIM0_CR2_CC2_MASK 0x4U
#define TIM0_CR2_CC2 0x4U
#define TIM0_CR2_CC2_BIT 2
#define TIM0_CR2_CC3_MASK 0x8U
#define TIM0_CR2_CC3 0x8U
#define TIM0_CR2_CC3_BIT 3
#define TIM0_CR2_CC4_MASK 0x10U
#define TIM0_CR2_CC4 0x10U
#define TIM0_CR2_CC4_BIT 4
#define TIM0_CR2_CC5_MASK 0x20U
#define TIM0_CR2_CC5 0x20U
#define TIM0_CR2_CC5_BIT 5
#define TIM0_CR2_CC6_MASK 0x40U
#define TIM0_CR2_CC6 0x40U
#define TIM0_CR2_CC6_BIT 6
#define TIM0_CR2_CC7_MASK 0x80U
#define TIM0_CR2_CC7 0x80U
#define TIM0_CR2_CC7_BIT 7
#define TIM0_CR2_OCBIE_MASK 0x800U
#define TIM0_CR2_OCBIE 0x800U
#define TIM0_CR2_OCBIE_BIT 11
#define TIM0_CR2_ICBIE_MASK 0x1000U
#define TIM0_CR2_ICBIE 0x1000U
#define TIM0_CR2_ICBIE_BIT 12
#define TIM0_CR2_TOE_MASK 0x2000U
#define TIM0_CR2_TOE 0x2000U
#define TIM0_CR2_TOE_BIT 13
#define TIM0_CR2_OCAIE_MASK 0x4000U
#define TIM0_CR2_OCAIE 0x4000U
#define TIM0_CR2_OCAIE_BIT 14
#define TIM0_CR2_ICAIE_MASK 0x8000U
#define TIM0_CR2_ICAIE 0x8000U
#define TIM0_CR2_ICAIE_BIT 15

#define TIM0_SR (*(volatile unsigned short *)0xE000901C)
#define TIM0_SR_OCFB_MASK 0x800U
#define TIM0_SR_OCFB 0x800U
#define TIM0_SR_OCFB_BIT 11
#define TIM0_SR_ICFB_MASK 0x1000U
#define TIM0_SR_ICFB 0x1000U
#define TIM0_SR_ICFB_BIT 12
#define TIM0_SR_TOF_MASK 0x2000U
#define TIM0_SR_TOF 0x2000U
#define TIM0_SR_TOF_BIT 13
#define TIM0_SR_OCFA_MASK 0x4000U
#define TIM0_SR_OCFA 0x4000U
#define TIM0_SR_OCFA_BIT 14
#define TIM0_SR_ICFA_MASK 0x8000U
#define TIM0_SR_ICFA 0x8000U
#define TIM0_SR_ICFA_BIT 15

#define TIM1_ICAR (*(volatile unsigned short *)0xE000A000)

#define TIM1_ICBR (*(volatile unsigned short *)0xE000A004)

#define TIM1_OCAR (*(volatile unsigned short *)0xE000A008)

#define TIM1_OCBR (*(volatile unsigned short *)0xE000A00C)

#define TIM1_CNTR (*(volatile unsigned short *)0xE000A010)

#define TIM1_CR1 (*(volatile unsigned short *)0xE000A014)
#define TIM1_CR1_ECKEN_MASK 0x1U
#define TIM1_CR1_ECKEN 0x1U
#define TIM1_CR1_ECKEN_BIT 0
#define TIM1_CR1_EXEDG_MASK 0x2U
#define TIM1_CR1_EXEDG 0x2U
#define TIM1_CR1_EXEDG_BIT 1
#define TIM1_CR1_IEDGA_MASK 0x4U
#define TIM1_CR1_IEDGA 0x4U
#define TIM1_CR1_IEDGA_BIT 2
#define TIM1_CR1_IEDGB_MASK 0x8U
#define TIM1_CR1_IEDGB 0x8U
#define TIM1_CR1_IEDGB_BIT 3
#define TIM1_CR1_PWM_MASK 0x10U
#define TIM1_CR1_PWM 0x10U
#define TIM1_CR1_PWM_BIT 4
#define TIM1_CR1_OPM_MASK 0x20U
#define TIM1_CR1_OPM 0x20U
#define TIM1_CR1_OPM_BIT 5
#define TIM1_CR1_OCAE_MASK 0x40U
#define TIM1_CR1_OCAE 0x40U
#define TIM1_CR1_OCAE_BIT 6
#define TIM1_CR1_OCBE_MASK 0x80U
#define TIM1_CR1_OCBE 0x80U
#define TIM1_CR1_OCBE_BIT 7
#define TIM1_CR1_OLVLA_MASK 0x100U
#define TIM1_CR1_OLVLA 0x100U
#define TIM1_CR1_OLVLA_BIT 8
#define TIM1_CR1_OLVLB_MASK 0x200U
#define TIM1_CR1_OLVLB 0x200U
#define TIM1_CR1_OLVLB_BIT 9
#define TIM1_CR1_FOLVLA_MASK 0x400U
#define TIM1_CR1_FOLVLA 0x400U
#define TIM1_CR1_FOLVLA_BIT 10
#define TIM1_CR1_FOLVLB_MASK 0x800U
#define TIM1_CR1_FOLVLB 0x800U
#define TIM1_CR1_FOLVLB_BIT 11
#define TIM1_CR1_PWMI_MASK 0x4000U
#define TIM1_CR1_PWMI 0x4000U
#define TIM1_CR1_PWMI_BIT 14
#define TIM1_CR1_EN_MASK 0x8000U
#define TIM1_CR1_EN 0x8000U
#define TIM1_CR1_EN_BIT 15

#define TIM1_CR2 (*(volatile unsigned short *)0xE000A018)
#define TIM1_CR2_CC0_MASK 0x1U
#define TIM1_CR2_CC0 0x1U
#define TIM1_CR2_CC0_BIT 0
#define TIM1_CR2_CC1_MASK 0x2U
#define TIM1_CR2_CC1 0x2U
#define TIM1_CR2_CC1_BIT 1
#define TIM1_CR2_CC2_MASK 0x4U
#define TIM1_CR2_CC2 0x4U
#define TIM1_CR2_CC2_BIT 2
#define TIM1_CR2_CC3_MASK 0x8U
#define TIM1_CR2_CC3 0x8U
#define TIM1_CR2_CC3_BIT 3
#define TIM1_CR2_CC4_MASK 0x10U
#define TIM1_CR2_CC4 0x10U
#define TIM1_CR2_CC4_BIT 4
#define TIM1_CR2_CC5_MASK 0x20U
#define TIM1_CR2_CC5 0x20U
#define TIM1_CR2_CC5_BIT 5
#define TIM1_CR2_CC6_MASK 0x40U
#define TIM1_CR2_CC6 0x40U
#define TIM1_CR2_CC6_BIT 6
#define TIM1_CR2_CC7_MASK 0x80U
#define TIM1_CR2_CC7 0x80U
#define TIM1_CR2_CC7_BIT 7
#define TIM1_CR2_OCBIE_MASK 0x800U
#define TIM1_CR2_OCBIE 0x800U
#define TIM1_CR2_OCBIE_BIT 11
#define TIM1_CR2_ICBIE_MASK 0x1000U
#define TIM1_CR2_ICBIE 0x1000U
#define TIM1_CR2_ICBIE_BIT 12
#define TIM1_CR2_TOE_MASK 0x2000U
#define TIM1_CR2_TOE 0x2000U
#define TIM1_CR2_TOE_BIT 13
#define TIM1_CR2_OCAIE_MASK 0x4000U
#define TIM1_CR2_OCAIE 0x4000U
#define TIM1_CR2_OCAIE_BIT 14
#define TIM1_CR2_ICAIE_MASK 0x8000U
#define TIM1_CR2_ICAIE 0x8000U
#define TIM1_CR2_ICAIE_BIT 15

#define TIM1_SR (*(volatile unsigned short *)0xE000A01C)
#define TIM1_SR_OCFB_MASK 0x800U
#define TIM1_SR_OCFB 0x800U
#define TIM1_SR_OCFB_BIT 11
#define TIM1_SR_ICFB_MASK 0x1000U
#define TIM1_SR_ICFB 0x1000U
#define TIM1_SR_ICFB_BIT 12
#define TIM1_SR_TOF_MASK 0x2000U
#define TIM1_SR_TOF 0x2000U
#define TIM1_SR_TOF_BIT 13
#define TIM1_SR_OCFA_MASK 0x4000U
#define TIM1_SR_OCFA 0x4000U
#define TIM1_SR_OCFA_BIT 14
#define TIM1_SR_ICFA_MASK 0x8000U
#define TIM1_SR_ICFA 0x8000U
#define TIM1_SR_ICFA_BIT 15

#define TIM2_ICAR (*(volatile unsigned short *)0xE000B000)

#define TIM2_ICBR (*(volatile unsigned short *)0xE000B004)

#define TIM2_OCAR (*(volatile unsigned short *)0xE000B008)

#define TIM2_OCBR (*(volatile unsigned short *)0xE000B00C)

#define TIM2_CNTR (*(volatile unsigned short *)0xE000B010)

#define TIM2_CR1 (*(volatile unsigned short *)0xE000B014)
#define TIM2_CR1_ECKEN_MASK 0x1U
#define TIM2_CR1_ECKEN 0x1U
#define TIM2_CR1_ECKEN_BIT 0
#define TIM2_CR1_EXEDG_MASK 0x2U
#define TIM2_CR1_EXEDG 0x2U
#define TIM2_CR1_EXEDG_BIT 1
#define TIM2_CR1_IEDGA_MASK 0x4U
#define TIM2_CR1_IEDGA 0x4U
#define TIM2_CR1_IEDGA_BIT 2
#define TIM2_CR1_IEDGB_MASK 0x8U
#define TIM2_CR1_IEDGB 0x8U
#define TIM2_CR1_IEDGB_BIT 3
#define TIM2_CR1_PWM_MASK 0x10U
#define TIM2_CR1_PWM 0x10U
#define TIM2_CR1_PWM_BIT 4
#define TIM2_CR1_OPM_MASK 0x20U
#define TIM2_CR1_OPM 0x20U
#define TIM2_CR1_OPM_BIT 5
#define TIM2_CR1_OCAE_MASK 0x40U
#define TIM2_CR1_OCAE 0x40U
#define TIM2_CR1_OCAE_BIT 6
#define TIM2_CR1_OCBE_MASK 0x80U
#define TIM2_CR1_OCBE 0x80U
#define TIM2_CR1_OCBE_BIT 7
#define TIM2_CR1_OLVLA_MASK 0x100U
#define TIM2_CR1_OLVLA 0x100U
#define TIM2_CR1_OLVLA_BIT 8
#define TIM2_CR1_OLVLB_MASK 0x200U
#define TIM2_CR1_OLVLB 0x200U
#define TIM2_CR1_OLVLB_BIT 9
#define TIM2_CR1_FOLVLA_MASK 0x400U
#define TIM2_CR1_FOLVLA 0x400U
#define TIM2_CR1_FOLVLA_BIT 10
#define TIM2_CR1_FOLVLB_MASK 0x800U
#define TIM2_CR1_FOLVLB 0x800U
#define TIM2_CR1_FOLVLB_BIT 11
#define TIM2_CR1_PWMI_MASK 0x4000U
#define TIM2_CR1_PWMI 0x4000U
#define TIM2_CR1_PWMI_BIT 14
#define TIM2_CR1_EN_MASK 0x8000U
#define TIM2_CR1_EN 0x8000U
#define TIM2_CR1_EN_BIT 15

#define TIM2_CR2 (*(volatile unsigned short *)0xE000B018)
#define TIM2_CR2_CC0_MASK 0x1U
#define TIM2_CR2_CC0 0x1U
#define TIM2_CR2_CC0_BIT 0
#define TIM2_CR2_CC1_MASK 0x2U
#define TIM2_CR2_CC1 0x2U
#define TIM2_CR2_CC1_BIT 1
#define TIM2_CR2_CC2_MASK 0x4U
#define TIM2_CR2_CC2 0x4U
#define TIM2_CR2_CC2_BIT 2
#define TIM2_CR2_CC3_MASK 0x8U
#define TIM2_CR2_CC3 0x8U
#define TIM2_CR2_CC3_BIT 3
#define TIM2_CR2_CC4_MASK 0x10U
#define TIM2_CR2_CC4 0x10U
#define TIM2_CR2_CC4_BIT 4
#define TIM2_CR2_CC5_MASK 0x20U
#define TIM2_CR2_CC5 0x20U
#define TIM2_CR2_CC5_BIT 5
#define TIM2_CR2_CC6_MASK 0x40U
#define TIM2_CR2_CC6 0x40U
#define TIM2_CR2_CC6_BIT 6
#define TIM2_CR2_CC7_MASK 0x80U
#define TIM2_CR2_CC7 0x80U
#define TIM2_CR2_CC7_BIT 7
#define TIM2_CR2_OCBIE_MASK 0x800U
#define TIM2_CR2_OCBIE 0x800U
#define TIM2_CR2_OCBIE_BIT 11
#define TIM2_CR2_ICBIE_MASK 0x1000U
#define TIM2_CR2_ICBIE 0x1000U
#define TIM2_CR2_ICBIE_BIT 12
#define TIM2_CR2_TOE_MASK 0x2000U
#define TIM2_CR2_TOE 0x2000U
#define TIM2_CR2_TOE_BIT 13
#define TIM2_CR2_OCAIE_MASK 0x4000U
#define TIM2_CR2_OCAIE 0x4000U
#define TIM2_CR2_OCAIE_BIT 14
#define TIM2_CR2_ICAIE_MASK 0x8000U
#define TIM2_CR2_ICAIE 0x8000U
#define TIM2_CR2_ICAIE_BIT 15

#define TIM2_SR (*(volatile unsigned short *)0xE000B01C)
#define TIM2_SR_OCFB_MASK 0x800U
#define TIM2_SR_OCFB 0x800U
#define TIM2_SR_OCFB_BIT 11
#define TIM2_SR_ICFB_MASK 0x1000U
#define TIM2_SR_ICFB 0x1000U
#define TIM2_SR_ICFB_BIT 12
#define TIM2_SR_TOF_MASK 0x2000U
#define TIM2_SR_TOF 0x2000U
#define TIM2_SR_TOF_BIT 13
#define TIM2_SR_OCFA_MASK 0x4000U
#define TIM2_SR_OCFA 0x4000U
#define TIM2_SR_OCFA_BIT 14
#define TIM2_SR_ICFA_MASK 0x8000U
#define TIM2_SR_ICFA 0x8000U
#define TIM2_SR_ICFA_BIT 15

#define TIM3_ICAR (*(volatile unsigned short *)0xE000C000)

#define TIM3_ICBR (*(volatile unsigned short *)0xE000C004)

#define TIM3_OCAR (*(volatile unsigned short *)0xE000C008)

#define TIM3_OCBR (*(volatile unsigned short *)0xE000C00C)

#define TIM3_CNTR (*(volatile unsigned short *)0xE000C010)

#define TIM3_CR1 (*(volatile unsigned short *)0xE000C014)
#define TIM3_CR1_ECKEN_MASK 0x1U
#define TIM3_CR1_ECKEN 0x1U
#define TIM3_CR1_ECKEN_BIT 0
#define TIM3_CR1_EXEDG_MASK 0x2U
#define TIM3_CR1_EXEDG 0x2U
#define TIM3_CR1_EXEDG_BIT 1
#define TIM3_CR1_IEDGA_MASK 0x4U
#define TIM3_CR1_IEDGA 0x4U
#define TIM3_CR1_IEDGA_BIT 2
#define TIM3_CR1_IEDGB_MASK 0x8U
#define TIM3_CR1_IEDGB 0x8U
#define TIM3_CR1_IEDGB_BIT 3
#define TIM3_CR1_PWM_MASK 0x10U
#define TIM3_CR1_PWM 0x10U
#define TIM3_CR1_PWM_BIT 4
#define TIM3_CR1_OPM_MASK 0x20U
#define TIM3_CR1_OPM 0x20U
#define TIM3_CR1_OPM_BIT 5
#define TIM3_CR1_OCAE_MASK 0x40U
#define TIM3_CR1_OCAE 0x40U
#define TIM3_CR1_OCAE_BIT 6
#define TIM3_CR1_OCBE_MASK 0x80U
#define TIM3_CR1_OCBE 0x80U
#define TIM3_CR1_OCBE_BIT 7
#define TIM3_CR1_OLVLA_MASK 0x100U
#define TIM3_CR1_OLVLA 0x100U
#define TIM3_CR1_OLVLA_BIT 8
#define TIM3_CR1_OLVLB_MASK 0x200U
#define TIM3_CR1_OLVLB 0x200U
#define TIM3_CR1_OLVLB_BIT 9
#define TIM3_CR1_FOLVLA_MASK 0x400U
#define TIM3_CR1_FOLVLA 0x400U
#define TIM3_CR1_FOLVLA_BIT 10
#define TIM3_CR1_FOLVLB_MASK 0x800U
#define TIM3_CR1_FOLVLB 0x800U
#define TIM3_CR1_FOLVLB_BIT 11
#define TIM3_CR1_PWMI_MASK 0x4000U
#define TIM3_CR1_PWMI 0x4000U
#define TIM3_CR1_PWMI_BIT 14
#define TIM3_CR1_EN_MASK 0x8000U
#define TIM3_CR1_EN 0x8000U
#define TIM3_CR1_EN_BIT 15

#define TIM3_CR2 (*(volatile unsigned short *)0xE000C018)
#define TIM3_CR2_CC0_MASK 0x1U
#define TIM3_CR2_CC0 0x1U
#define TIM3_CR2_CC0_BIT 0
#define TIM3_CR2_CC1_MASK 0x2U
#define TIM3_CR2_CC1 0x2U
#define TIM3_CR2_CC1_BIT 1
#define TIM3_CR2_CC2_MASK 0x4U
#define TIM3_CR2_CC2 0x4U
#define TIM3_CR2_CC2_BIT 2
#define TIM3_CR2_CC3_MASK 0x8U
#define TIM3_CR2_CC3 0x8U
#define TIM3_CR2_CC3_BIT 3
#define TIM3_CR2_CC4_MASK 0x10U
#define TIM3_CR2_CC4 0x10U
#define TIM3_CR2_CC4_BIT 4
#define TIM3_CR2_CC5_MASK 0x20U
#define TIM3_CR2_CC5 0x20U
#define TIM3_CR2_CC5_BIT 5
#define TIM3_CR2_CC6_MASK 0x40U
#define TIM3_CR2_CC6 0x40U
#define TIM3_CR2_CC6_BIT 6
#define TIM3_CR2_CC7_MASK 0x80U
#define TIM3_CR2_CC7 0x80U
#define TIM3_CR2_CC7_BIT 7
#define TIM3_CR2_OCBIE_MASK 0x800U
#define TIM3_CR2_OCBIE 0x800U
#define TIM3_CR2_OCBIE_BIT 11
#define TIM3_CR2_ICBIE_MASK 0x1000U
#define TIM3_CR2_ICBIE 0x1000U
#define TIM3_CR2_ICBIE_BIT 12
#define TIM3_CR2_TOE_MASK 0x2000U
#define TIM3_CR2_TOE 0x2000U
#define TIM3_CR2_TOE_BIT 13
#define TIM3_CR2_OCAIE_MASK 0x4000U
#define TIM3_CR2_OCAIE 0x4000U
#define TIM3_CR2_OCAIE_BIT 14
#define TIM3_CR2_ICAIE_MASK 0x8000U
#define TIM3_CR2_ICAIE 0x8000U
#define TIM3_CR2_ICAIE_BIT 15

#define TIM3_SR (*(volatile unsigned short *)0xE000C01C)
#define TIM3_SR_OCFB_MASK 0x800U
#define TIM3_SR_OCFB 0x800U
#define TIM3_SR_OCFB_BIT 11
#define TIM3_SR_ICFB_MASK 0x1000U
#define TIM3_SR_ICFB 0x1000U
#define TIM3_SR_ICFB_BIT 12
#define TIM3_SR_TOF_MASK 0x2000U
#define TIM3_SR_TOF 0x2000U
#define TIM3_SR_TOF_BIT 13
#define TIM3_SR_OCFA_MASK 0x4000U
#define TIM3_SR_OCFA 0x4000U
#define TIM3_SR_OCFA_BIT 14
#define TIM3_SR_ICFA_MASK 0x8000U
#define TIM3_SR_ICFA 0x8000U
#define TIM3_SR_ICFA_BIT 15

#define RTC_CRH (*(volatile unsigned short *)0xE000D000)
#define RTC_CRH_SEN_MASK 0x1U
#define RTC_CRH_SEN 0x1U
#define RTC_CRH_SEN_BIT 0
#define RTC_CRH_AEN_MASK 0x2U
#define RTC_CRH_AEN 0x2U
#define RTC_CRH_AEN_BIT 1
#define RTC_CRH_OWEN_MASK 0x4U
#define RTC_CRH_OWEN 0x4U
#define RTC_CRH_OWEN_BIT 2
#define RTC_CRH_GEN_MASK 0x8U
#define RTC_CRH_GEN 0x8U
#define RTC_CRH_GEN_BIT 3

#define RTC_CRL (*(volatile unsigned short *)0xE000D004)
#define RTC_CRL_SIR_MASK 0x1U
#define RTC_CRL_SIR 0x1U
#define RTC_CRL_SIR_BIT 0
#define RTC_CRL_AIR_MASK 0x2U
#define RTC_CRL_AIR 0x2U
#define RTC_CRL_AIR_BIT 1
#define RTC_CRL_OWIR_MASK 0x4U
#define RTC_CRL_OWIR 0x4U
#define RTC_CRL_OWIR_BIT 2
#define RTC_CRL_GIR_MASK 0x8U
#define RTC_CRL_GIR 0x8U
#define RTC_CRL_GIR_BIT 3
#define RTC_CRL_CNF_MASK 0x10U
#define RTC_CRL_CNF 0x10U
#define RTC_CRL_CNF_BIT 4
#define RTC_CRL_RTOFF_MASK 0x20U
#define RTC_CRL_RTOFF 0x20U
#define RTC_CRL_RTOFF_BIT 5

#define RTC_PRLH (*(volatile unsigned short *)0xE000D008)

#define RTC_PRLL (*(volatile unsigned short *)0xE000D00C)

#define RTC_DIVH (*(volatile unsigned short *)0xE000D010)

#define RTC_DIVL (*(volatile unsigned short *)0xE000D014)

#define RTC_CNTH (*(volatile unsigned short *)0xE000D018)

#define RTC_CNTL (*(volatile unsigned short *)0xE000D01C)

#define RTC_ALRH (*(volatile unsigned short *)0xE000D020)

#define RTC_ALRL (*(volatile unsigned short *)0xE000D024)

#define WDG_CR (*(volatile unsigned short *)0xE000E000)
#define WDG_CR_WE_MASK 0x1U
#define WDG_CR_WE 0x1U
#define WDG_CR_WE_BIT 0
#define WDG_CR_SC_MASK 0x2U
#define WDG_CR_SC 0x2U
#define WDG_CR_SC_BIT 1
#define WDG_CR_EE_MASK 0x4U
#define WDG_CR_EE 0x4U
#define WDG_CR_EE_BIT 2

#define WDG_PR (*(volatile unsigned short *)0xE000E004)
#define WDG_PR_PR_MASK 0xFFU
#define WDG_PR_PR_BIT 0

#define WDG_VR (*(volatile unsigned short *)0xE000E008)

#define WDG_CNT (*(volatile unsigned short *)0xE000E00C)

#define WDG_SR (*(volatile unsigned short *)0xE000E010)

#define WDG_MR (*(volatile unsigned short *)0xE000E014)

#define WDG_KR (*(volatile unsigned short *)0xE000E018)

#define EIC_ICR (*(volatile unsigned long *)0xFFFFFC00)
#define EIC_ICR_IRQ_EN_MASK 0x1U
#define EIC_ICR_IRQ_EN 0x1U
#define EIC_ICR_IRQ_EN_BIT 0
#define EIC_ICR_FIQ_EN_MASK 0x2U
#define EIC_ICR_FIQ_EN 0x2U
#define EIC_ICR_FIQ_EN_BIT 1

#define EIC_CICR (*(volatile unsigned long *)0xFFFFFC04)

#define EIC_CIPR (*(volatile unsigned long *)0xFFFFFC08)

#define EIC_IVR (*(volatile unsigned long *)0xFFFFFC18)
#define EIC_IVR_Jump_Offset_MASK 0xFFFFU
#define EIC_IVR_Jump_Offset_BIT 0
#define EIC_IVR_Jump_Opcode_Or_Base_Address_MASK 0xFFFF0000U
#define EIC_IVR_Jump_Opcode_Or_Base_Address_BIT 16

#define EIC_FIR (*(volatile unsigned long *)0xFFFFFC1C)

#define EIC_IER0 (*(volatile unsigned long *)0xFFFFFC20)

#define EIC_IPR0 (*(volatile unsigned long *)0xFFFFFC40)

#define EIC_SIR0 (*(volatile unsigned long *)0xFFFFFC60)
#define EIC_SIR0_SIPL0_MASK 0xFU
#define EIC_SIR0_SIPL0_BIT 0
#define EIC_SIR0_SIV0_MASK 0xFFFF0000U
#define EIC_SIR0_SIV0_BIT 16

#define EIC_SIR1 (*(volatile unsigned long *)0xFFFFFC64)
#define EIC_SIR1_SIPL1_MASK 0xFU
#define EIC_SIR1_SIPL1_BIT 0
#define EIC_SIR1_SIV1_MASK 0xFFFF0000U
#define EIC_SIR1_SIV1_BIT 16

#define EIC_SIR2 (*(volatile unsigned long *)0xFFFFFC68)
#define EIC_SIR2_SIPL2_MASK 0xFU
#define EIC_SIR2_SIPL2_BIT 0
#define EIC_SIR2_SIV2_MASK 0xFFFF0000U
#define EIC_SIR2_SIV2_BIT 16

#define EIC_SIR3 (*(volatile unsigned long *)0xFFFFFC6C)
#define EIC_SIR3_SIPL3_MASK 0xFU
#define EIC_SIR3_SIPL3_BIT 0
#define EIC_SIR3_SIV3_MASK 0xFFFF0000U
#define EIC_SIR3_SIV3_BIT 16

#define EIC_SIR4 (*(volatile unsigned long *)0xFFFFFC70)
#define EIC_SIR4_SIPL4_MASK 0xFU
#define EIC_SIR4_SIPL4_BIT 0
#define EIC_SIR4_SIV4_MASK 0xFFFF0000U
#define EIC_SIR4_SIV4_BIT 16

#define EIC_SIR5 (*(volatile unsigned long *)0xFFFFFC74)
#define EIC_SIR5_SIPL5_MASK 0xFU
#define EIC_SIR5_SIPL5_BIT 0
#define EIC_SIR5_SIV5_MASK 0xFFFF0000U
#define EIC_SIR5_SIV5_BIT 16

#define EIC_SIR6 (*(volatile unsigned long *)0xFFFFFC78)
#define EIC_SIR6_SIPL6_MASK 0xFU
#define EIC_SIR6_SIPL6_BIT 0
#define EIC_SIR6_SIV6_MASK 0xFFFF0000U
#define EIC_SIR6_SIV6_BIT 16

#define EIC_SIR7 (*(volatile unsigned long *)0xFFFFFC7C)
#define EIC_SIR7_SIPL7_MASK 0xFU
#define EIC_SIR7_SIPL7_BIT 0
#define EIC_SIR7_SIV7_MASK 0xFFFF0000U
#define EIC_SIR7_SIV7_BIT 16

#define EIC_SIR8 (*(volatile unsigned long *)0xFFFFFC80)
#define EIC_SIR8_SIPL8_MASK 0xFU
#define EIC_SIR8_SIPL8_BIT 0
#define EIC_SIR8_SIV8_MASK 0xFFFF0000U
#define EIC_SIR8_SIV8_BIT 16

#define EIC_SIR9 (*(volatile unsigned long *)0xFFFFFC84)
#define EIC_SIR9_SIPL9_MASK 0xFU
#define EIC_SIR9_SIPL9_BIT 0
#define EIC_SIR9_SIV9_MASK 0xFFFF0000U
#define EIC_SIR9_SIV9_BIT 16

#define EIC_SIR10 (*(volatile unsigned long *)0xFFFFFC88)
#define EIC_SIR10_SIPL10_MASK 0xFU
#define EIC_SIR10_SIPL10_BIT 0
#define EIC_SIR10_SIV10_MASK 0xFFFF0000U
#define EIC_SIR10_SIV10_BIT 16

#define EIC_SIR11 (*(volatile unsigned long *)0xFFFFFC8C)
#define EIC_SIR11_SIPL11_MASK 0xFU
#define EIC_SIR11_SIPL11_BIT 0
#define EIC_SIR11_SIV11_MASK 0xFFFF0000U
#define EIC_SIR11_SIV11_BIT 16

#define EIC_SIR12 (*(volatile unsigned long *)0xFFFFFC90)
#define EIC_SIR12_SIPL12_MASK 0xFU
#define EIC_SIR12_SIPL12_BIT 0
#define EIC_SIR12_SIV12_MASK 0xFFFF0000U
#define EIC_SIR12_SIV12_BIT 16

#define EIC_SIR13 (*(volatile unsigned long *)0xFFFFFC94)
#define EIC_SIR13_SIPL13_MASK 0xFU
#define EIC_SIR13_SIPL13_BIT 0
#define EIC_SIR13_SIV13_MASK 0xFFFF0000U
#define EIC_SIR13_SIV13_BIT 16

#define EIC_SIR14 (*(volatile unsigned long *)0xFFFFFC98)
#define EIC_SIR14_SIPL14_MASK 0xFU
#define EIC_SIR14_SIPL14_BIT 0
#define EIC_SIR14_SIV14_MASK 0xFFFF0000U
#define EIC_SIR14_SIV14_BIT 16

#define EIC_SIR15 (*(volatile unsigned long *)0xFFFFFC9C)
#define EIC_SIR15_SIPL15_MASK 0xFU
#define EIC_SIR15_SIPL15_BIT 0
#define EIC_SIR15_SIV15_MASK 0xFFFF0000U
#define EIC_SIR15_SIV15_BIT 16

#define EIC_SIR16 (*(volatile unsigned long *)0xFFFFFCA0)
#define EIC_SIR16_SIPL16_MASK 0xFU
#define EIC_SIR16_SIPL16_BIT 0
#define EIC_SIR16_SIV16_MASK 0xFFFF0000U
#define EIC_SIR16_SIV16_BIT 16

#define EIC_SIR17 (*(volatile unsigned long *)0xFFFFFCA4)
#define EIC_SIR17_SIPL17_MASK 0xFU
#define EIC_SIR17_SIPL17_BIT 0
#define EIC_SIR17_SIV17_MASK 0xFFFF0000U
#define EIC_SIR17_SIV17_BIT 16

#define EIC_SIR18 (*(volatile unsigned long *)0xFFFFFCA8)
#define EIC_SIR18_SIPL18_MASK 0xFU
#define EIC_SIR18_SIPL18_BIT 0
#define EIC_SIR18_SIV18_MASK 0xFFFF0000U
#define EIC_SIR18_SIV18_BIT 16

#define EIC_SIR19 (*(volatile unsigned long *)0xFFFFFCAC)
#define EIC_SIR19_SIPL19_MASK 0xFU
#define EIC_SIR19_SIPL19_BIT 0
#define EIC_SIR19_SIV19_MASK 0xFFFF0000U
#define EIC_SIR19_SIV19_BIT 16

#define EIC_SIR20 (*(volatile unsigned long *)0xFFFFFCB0)
#define EIC_SIR20_SIPL20_MASK 0xFU
#define EIC_SIR20_SIPL20_BIT 0
#define EIC_SIR20_SIV20_MASK 0xFFFF0000U
#define EIC_SIR20_SIV20_BIT 16

#define EIC_SIR21 (*(volatile unsigned long *)0xFFFFFCB4)
#define EIC_SIR21_SIPL21_MASK 0xFU
#define EIC_SIR21_SIPL21_BIT 0
#define EIC_SIR21_SIV21_MASK 0xFFFF0000U
#define EIC_SIR21_SIV21_BIT 16

#define EIC_SIR22 (*(volatile unsigned long *)0xFFFFFCB8)
#define EIC_SIR22_SIPL22_MASK 0xFU
#define EIC_SIR22_SIPL22_BIT 0
#define EIC_SIR22_SIV22_MASK 0xFFFF0000U
#define EIC_SIR22_SIV22_BIT 16

#define EIC_SIR23 (*(volatile unsigned long *)0xFFFFFCBC)
#define EIC_SIR23_SIPL23_MASK 0xFU
#define EIC_SIR23_SIPL23_BIT 0
#define EIC_SIR23_SIV23_MASK 0xFFFF0000U
#define EIC_SIR23_SIV23_BIT 16

#define EIC_SIR24 (*(volatile unsigned long *)0xFFFFFCC0)
#define EIC_SIR24_SIPL24_MASK 0xFU
#define EIC_SIR24_SIPL24_BIT 0
#define EIC_SIR24_SIV24_MASK 0xFFFF0000U
#define EIC_SIR24_SIV24_BIT 16

#define EIC_SIR25 (*(volatile unsigned long *)0xFFFFFCC4)
#define EIC_SIR25_SIPL25_MASK 0xFU
#define EIC_SIR25_SIPL25_BIT 0
#define EIC_SIR25_SIV25_MASK 0xFFFF0000U
#define EIC_SIR25_SIV25_BIT 16

#define EIC_SIR26 (*(volatile unsigned long *)0xFFFFFCC8)
#define EIC_SIR26_SIPL26_MASK 0xFU
#define EIC_SIR26_SIPL26_BIT 0
#define EIC_SIR26_SIV26_MASK 0xFFFF0000U
#define EIC_SIR26_SIV26_BIT 16

#define EIC_SIR27 (*(volatile unsigned long *)0xFFFFFCCC)
#define EIC_SIR27_SIPL27_MASK 0xFU
#define EIC_SIR27_SIPL27_BIT 0
#define EIC_SIR27_SIV27_MASK 0xFFFF0000U
#define EIC_SIR27_SIV27_BIT 16

#define EIC_SIR28 (*(volatile unsigned long *)0xFFFFFCD0)
#define EIC_SIR28_SIPL28_MASK 0xFU
#define EIC_SIR28_SIPL28_BIT 0
#define EIC_SIR28_SIV28_MASK 0xFFFF0000U
#define EIC_SIR28_SIV28_BIT 16

#define EIC_SIR29 (*(volatile unsigned long *)0xFFFFFCD4)
#define EIC_SIR29_SIPL29_MASK 0xFU
#define EIC_SIR29_SIPL29_BIT 0
#define EIC_SIR29_SIV29_MASK 0xFFFF0000U
#define EIC_SIR29_SIV29_BIT 16

#define EIC_SIR30 (*(volatile unsigned long *)0xFFFFFCD8)
#define EIC_SIR30_SIPL30_MASK 0xFU
#define EIC_SIR30_SIPL30_BIT 0
#define EIC_SIR30_SIV30_MASK 0xFFFF0000U
#define EIC_SIR30_SIV30_BIT 16

#define EIC_SIR31 (*(volatile unsigned long *)0xFFFFFCDC)
#define EIC_SIR31_SIPL31_MASK 0xFU
#define EIC_SIR31_SIPL31_BIT 0
#define EIC_SIR31_SIV31_MASK 0xFFFF0000U
#define EIC_SIR31_SIV31_BIT 16

#define EMI_BCON0 (*(volatile unsigned *)0x6C000000)
#define EMI_BCON0_B_SIZE_MASK 0x3U
#define EMI_BCON0_B_SIZE_BIT 0
#define EMI_BCON0_C_LENGTH_MASK 0x3CU
#define EMI_BCON0_C_LENGTH_BIT 2
#define EMI_BCON0_BE_MASK 0x8000U
#define EMI_BCON0_BE 0x8000U
#define EMI_BCON0_BE_BIT 15

#define EMI_BCON1 (*(volatile unsigned *)0x6C000004)
#define EMI_BCON1_B_SIZE_MASK 0x3U
#define EMI_BCON1_B_SIZE_BIT 0
#define EMI_BCON1_C_LENGTH_MASK 0x3CU
#define EMI_BCON1_C_LENGTH_BIT 2
#define EMI_BCON1_BE_MASK 0x8000U
#define EMI_BCON1_BE 0x8000U
#define EMI_BCON1_BE_BIT 15

#define EMI_BCON2 (*(volatile unsigned *)0x6C000008)
#define EMI_BCON2_B_SIZE_MASK 0x3U
#define EMI_BCON2_B_SIZE_BIT 0
#define EMI_BCON2_C_LENGTH_MASK 0x3CU
#define EMI_BCON2_C_LENGTH_BIT 2
#define EMI_BCON2_BE_MASK 0x8000U
#define EMI_BCON2_BE 0x8000U
#define EMI_BCON2_BE_BIT 15

#define EMI_BCON3 (*(volatile unsigned *)0x6C00000C)
#define EMI_BCON3_B_SIZE_MASK 0x3U
#define EMI_BCON3_B_SIZE_BIT 0
#define EMI_BCON3_C_LENGTH_MASK 0x3CU
#define EMI_BCON3_C_LENGTH_BIT 2
#define EMI_BCON3_BE_MASK 0x8000U
#define EMI_BCON3_BE 0x8000U
#define EMI_BCON3_BE_BIT 15

#define FLASH_CR0 (*(volatile unsigned *)0x40100000)
#define FLASH_CR0_BSY0_MASK 0x2U
#define FLASH_CR0_BSY0 0x2U
#define FLASH_CR0_BSY0_BIT 1
#define FLASH_CR0_BSY1_MASK 0x4U
#define FLASH_CR0_BSY1 0x4U
#define FLASH_CR0_BSY1_BIT 2
#define FLASH_CR0_LOCK_MASK 0x10U
#define FLASH_CR0_LOCK 0x10U
#define FLASH_CR0_LOCK_BIT 4
#define FLASH_CR0_LPS_MASK 0x8000U
#define FLASH_CR0_LPS 0x8000U
#define FLASH_CR0_LPS_BIT 15
#define FLASH_CR0_INTP_MASK 0x100000U
#define FLASH_CR0_INTP 0x100000U
#define FLASH_CR0_INTP_BIT 20
#define FLASH_CR0_INTM_MASK 0x200000U
#define FLASH_CR0_INTM 0x200000U
#define FLASH_CR0_INTM_BIT 21
#define FLASH_CR0_SPR_MASK 0x1000000U
#define FLASH_CR0_SPR 0x1000000U
#define FLASH_CR0_SPR_BIT 24
#define FLASH_CR0_MER_MASK 0x2000000U
#define FLASH_CR0_MER 0x2000000U
#define FLASH_CR0_MER_BIT 25
#define FLASH_CR0_BER_MASK 0x4000000U
#define FLASH_CR0_BER 0x4000000U
#define FLASH_CR0_BER_BIT 26
#define FLASH_CR0_SER_MASK 0x8000000U
#define FLASH_CR0_SER 0x8000000U
#define FLASH_CR0_SER_BIT 27
#define FLASH_CR0_DWPG_MASK 0x10000000U
#define FLASH_CR0_DWPG 0x10000000U
#define FLASH_CR0_DWPG_BIT 28
#define FLASH_CR0_WPG_MASK 0x20000000U
#define FLASH_CR0_WPG 0x20000000U
#define FLASH_CR0_WPG_BIT 29
#define FLASH_CR0_SUSP_MASK 0x40000000U
#define FLASH_CR0_SUSP 0x40000000U
#define FLASH_CR0_SUSP_BIT 30
#define FLASH_CR0_WMS_MASK 0x80000000U
#define FLASH_CR0_WMS 0x80000000U
#define FLASH_CR0_WMS_BIT 31

#define FLASH_CR1 (*(volatile unsigned *)0x40100004)
#define FLASH_CR1_BOF_MASK 0xFFU
#define FLASH_CR1_BOF_BIT 0
#define FLASH_CR1_B1F0_MASK 0x10000U
#define FLASH_CR1_B1F0 0x10000U
#define FLASH_CR1_B1F0_BIT 16
#define FLASH_CR1_B1F1_MASK 0x20000U
#define FLASH_CR1_B1F1 0x20000U
#define FLASH_CR1_B1F1_BIT 17
#define FLASH_CR1_B1F0_MASK 0x1000000U
#define FLASH_CR1_B1F0 0x1000000U
#define FLASH_CR1_B1F0_BIT 24
#define FLASH_CR1_B1F1_MASK 0x2000000U
#define FLASH_CR1_B1F1 0x2000000U
#define FLASH_CR1_B1F1_BIT 25

#define FLASH_DR0 (*(volatile unsigned *)0x40100008)

#define FLASH_DR1 (*(volatile unsigned *)0x4010000C)

#define FLASH_AR (*(volatile unsigned *)0x40100010)

#define FLASH_ER (*(volatile unsigned *)0x40100014)
#define FLASH_ER_ERR_MASK 0x1U
#define FLASH_ER_ERR 0x1U
#define FLASH_ER_ERR_BIT 0
#define FLASH_ER_ERER_MASK 0x2U
#define FLASH_ER_ERER 0x2U
#define FLASH_ER_ERER_BIT 1
#define FLASH_ER_PGER_MASK 0x4U
#define FLASH_ER_PGER 0x4U
#define FLASH_ER_PGER_BIT 2
#define FLASH_ER__10ER_MASK 0x8U
#define FLASH_ER__10ER 0x8U
#define FLASH_ER__10ER_BIT 3
#define FLASH_ER_SEQER_MASK 0x40U
#define FLASH_ER_SEQER 0x40U
#define FLASH_ER_SEQER_BIT 6
#define FLASH_ER_REQER_MASK 0x80U
#define FLASH_ER_REQER 0x80U
#define FLASH_ER_REQER_BIT 7
#define FLASH_ER_WPF_MASK 0x100U
#define FLASH_ER_WPF 0x100U
#define FLASH_ER_WPF_BIT 8

#define FLASH_NVWPAR (*(volatile unsigned *)0x4010DFB0)
#define FLASH_NVWPAR_W0P_MASK 0xFFU
#define FLASH_NVWPAR_W0P_BIT 0
#define FLASH_NVWPAR_W1P0_MASK 0x10000U
#define FLASH_NVWPAR_W1P0 0x10000U
#define FLASH_NVWPAR_W1P0_BIT 16
#define FLASH_NVWPAR_W1P1_MASK 0x20000U
#define FLASH_NVWPAR_W1P1 0x20000U
#define FLASH_NVWPAR_W1P1_BIT 17

#define FLASH_NVAPR0 (*(volatile unsigned *)0x4010DFB8)
#define FLASH_NVAPR0_ACCP_MASK 0x1U
#define FLASH_NVAPR0_ACCP 0x1U
#define FLASH_NVAPR0_ACCP_BIT 0
#define FLASH_NVAPR0_DBGP_MASK 0x2U
#define FLASH_NVAPR0_DBGP 0x2U
#define FLASH_NVAPR0_DBGP_BIT 1

#define FLASH_NVAPR1 (*(volatile unsigned *)0x4010DFBC)
#define FLASH_NVAPR1_PDS_MASK 0xFFFFU
#define FLASH_NVAPR1_PDS_BIT 0
#define FLASH_NVAPR1_PEN_MASK 0xFFFF0000U
#define FLASH_NVAPR1_PEN_BIT 16

#define PRCCU_CCR (*(volatile unsigned long *)0xA0000000)
#define PRCCU_CCR_LOP_WFI_MASK 0x1U
#define PRCCU_CCR_LOP_WFI 0x1U
#define PRCCU_CCR_LOP_WFI_BIT 0
#define PRCCU_CCR_WFI_CKSEL_MASK 0x2U
#define PRCCU_CCR_WFI_CKSEL 0x2U
#define PRCCU_CCR_WFI_CKSEL_BIT 1
#define PRCCU_CCR_CKAF_SEL_MASK 0x4U
#define PRCCU_CCR_CKAF_SEL 0x4U
#define PRCCU_CCR_CKAF_SEL_BIT 2
#define PRCCU_CCR_SRES_EN_MASK 0x8U
#define PRCCU_CCR_SRES_EN 0x8U
#define PRCCU_CCR_SRES_EN_BIT 3
#define PRCCU_CCR_EN_LOCK_MASK 0x80U
#define PRCCU_CCR_EN_LOCK 0x80U
#define PRCCU_CCR_EN_LOCK_BIT 7
#define PRCCU_CCR_EN_CKAF_MASK 0x100U
#define PRCCU_CCR_EN_CKAF 0x100U
#define PRCCU_CCR_EN_CKAF_BIT 8
#define PRCCU_CCR_EN_CK2_16_MASK 0x200U
#define PRCCU_CCR_EN_CK2_16 0x200U
#define PRCCU_CCR_EN_CK2_16_BIT 9
#define PRCCU_CCR_EN_STOP_MASK 0x400U
#define PRCCU_CCR_EN_STOP 0x400U
#define PRCCU_CCR_EN_STOP_BIT 10
#define PRCCU_CCR_EN_HALT_MASK 0x800U
#define PRCCU_CCR_EN_HALT 0x800U
#define PRCCU_CCR_EN_HALT_BIT 11

#define PRCCU_CFR (*(volatile unsigned long *)0xA0000008)
#define PRCCU_CFR_CSU_CKSEL_MASK 0x1U
#define PRCCU_CFR_CSU_CKSEL 0x1U
#define PRCCU_CFR_CSU_CKSEL_BIT 0
#define PRCCU_CFR_LOCK_MASK 0x2U
#define PRCCU_CFR_LOCK 0x2U
#define PRCCU_CFR_LOCK_BIT 1
#define PRCCU_CFR_CKAF_ST_MASK 0x4U
#define PRCCU_CFR_CKAF_ST 0x4U
#define PRCCU_CFR_CKAF_ST_BIT 2
#define PRCCU_CFR_CK2_16_MASK 0x8U
#define PRCCU_CFR_CK2_16 0x8U
#define PRCCU_CFR_CK2_16_BIT 3
#define PRCCU_CFR_SOFT_RES_MASK 0x20U
#define PRCCU_CFR_SOFT_RES 0x20U
#define PRCCU_CFR_SOFT_RES_BIT 5
#define PRCCU_CFR_WDG_RES_MASK 0x40U
#define PRCCU_CFR_WDG_RES 0x40U
#define PRCCU_CFR_WDG_RES_BIT 6
#define PRCCU_CFR_RTC_ALARM_MASK 0x80U
#define PRCCU_CFR_RTC_ALARM 0x80U
#define PRCCU_CFR_RTC_ALARM_BIT 7
#define PRCCU_CFR_FLASH_POR_MASK 0x200U
#define PRCCU_CFR_FLASH_POR 0x200U
#define PRCCU_CFR_FLASH_POR_BIT 9
#define PRCCU_CFR_WKP_RES_MASK 0x400U
#define PRCCU_CFR_WKP_RES 0x400U
#define PRCCU_CFR_WKP_RES_BIT 10
#define PRCCU_CFR_LOCK_I_MASK 0x800U
#define PRCCU_CFR_LOCK_I 0x800U
#define PRCCU_CFR_LOCK_I_BIT 11
#define PRCCU_CFR_CKAF_I_MASK 0x1000U
#define PRCCU_CFR_CKAF_I 0x1000U
#define PRCCU_CFR_CKAF_I_BIT 12
#define PRCCU_CFR_CK2_16_I_MASK 0x2000U
#define PRCCU_CFR_CK2_16_I 0x2000U
#define PRCCU_CFR_CK2_16_I_BIT 13
#define PRCCU_CFR_STOP_I_MASK 0x4000U
#define PRCCU_CFR_STOP_I 0x4000U
#define PRCCU_CFR_STOP_I_BIT 14
#define PRCCU_CFR_DIV2_MASK 0x8000U
#define PRCCU_CFR_DIV2 0x8000U
#define PRCCU_CFR_DIV2_BIT 15

#define PRCCU_PLL1CR (*(volatile unsigned long *)0xA0000018)
#define PRCCU_PLL1CR_DX0_MASK 0x1U
#define PRCCU_PLL1CR_DX0 0x1U
#define PRCCU_PLL1CR_DX0_BIT 0
#define PRCCU_PLL1CR_DX1_MASK 0x2U
#define PRCCU_PLL1CR_DX1 0x2U
#define PRCCU_PLL1CR_DX1_BIT 1
#define PRCCU_PLL1CR_DX2_MASK 0x4U
#define PRCCU_PLL1CR_DX2 0x4U
#define PRCCU_PLL1CR_DX2_BIT 2
#define PRCCU_PLL1CR_MX0_MASK 0x10U
#define PRCCU_PLL1CR_MX0 0x10U
#define PRCCU_PLL1CR_MX0_BIT 4
#define PRCCU_PLL1CR_MX1_MASK 0x20U
#define PRCCU_PLL1CR_MX1 0x20U
#define PRCCU_PLL1CR_MX1_BIT 5
#define PRCCU_PLL1CR_FREF_RANGE_MASK 0x40U
#define PRCCU_PLL1CR_FREF_RANGE 0x40U
#define PRCCU_PLL1CR_FREF_RANGE_BIT 6
#define PRCCU_PLL1CR_FREEN_MASK 0x80U
#define PRCCU_PLL1CR_FREEN 0x80U
#define PRCCU_PLL1CR_FREEN_BIT 7

#define PRCCU_PER (*(volatile unsigned long *)0xA000001C)

#define PRCCU_SMR (*(volatile unsigned long *)0xA0000020)
#define PRCCU_SMR_WFI_MASK 0x1U
#define PRCCU_SMR_WFI 0x1U
#define PRCCU_SMR_WFI_BIT 0
#define PRCCU_SMR_HALT_MASK 0x2U
#define PRCCU_SMR_HALT 0x2U
#define PRCCU_SMR_HALT_BIT 1

#define PRCCU_MDIVR (*(volatile unsigned long *)0xA0000040)

#define PRCCU_PDIVR (*(volatile unsigned long *)0xA0000044)
#define PRCCU_PDIVR_FACT1_MASK 0x3U
#define PRCCU_PDIVR_FACT1_BIT 0
#define PRCCU_PDIVR_FACT2_MASK 0x300U
#define PRCCU_PDIVR_FACT2_BIT 8

#define PRCCU_RSTR (*(volatile unsigned long *)0xA0000048)

#define PRCCU_PLL2CR (*(volatile unsigned long *)0xA000004C)
#define PRCCU_PLL2CR_DX_MASK 0x3U
#define PRCCU_PLL2CR_DX_BIT 0
#define PRCCU_PLL2CR_MX_MASK 0x30U
#define PRCCU_PLL2CR_MX_BIT 4
#define PRCCU_PLL2CR_FRQRNG_MASK 0x40U
#define PRCCU_PLL2CR_FRQRNG 0x40U
#define PRCCU_PLL2CR_FRQRNG_BIT 6
#define PRCCU_PLL2CR_PLLEN_MASK 0x80U
#define PRCCU_PLL2CR_PLLEN 0x80U
#define PRCCU_PLL2CR_PLLEN_BIT 7
#define PRCCU_PLL2CR_USBEN_MASK 0x100U
#define PRCCU_PLL2CR_USBEN 0x100U
#define PRCCU_PLL2CR_USBEN_BIT 8
#define PRCCU_PLL2CR_IRQMASK_MASK 0x200U
#define PRCCU_PLL2CR_IRQMASK 0x200U
#define PRCCU_PLL2CR_IRQMASK_BIT 9
#define PRCCU_PLL2CR_IRQPEND_MASK 0x400U
#define PRCCU_PLL2CR_IRQPEND 0x400U
#define PRCCU_PLL2CR_IRQPEND_BIT 10
#define PRCCU_PLL2CR_LOCK_MASK 0x8000U
#define PRCCU_PLL2CR_LOCK 0x8000U
#define PRCCU_PLL2CR_LOCK_BIT 15

#define PRCCU_BOOTCR (*(volatile unsigned long *)0xA0000050)
#define PRCCU_BOOTCR_BOOT_MASK 0x3U
#define PRCCU_BOOTCR_BOOT_BIT 0
#define PRCCU_BOOTCR_SPI0EN_MASK 0x4U
#define PRCCU_BOOTCR_SPI0EN 0x4U
#define PRCCU_BOOTCR_SPI0EN_BIT 2
#define PRCCU_BOOTCR_USBFILTEN_MASK 0x8U
#define PRCCU_BOOTCR_USBFILTEN 0x8U
#define PRCCU_BOOTCR_USBFILTEN_BIT 3
#define PRCCU_BOOTCR_LPOWDBGEN_MASK 0x10U
#define PRCCU_BOOTCR_LPOWDBGEN 0x10U
#define PRCCU_BOOTCR_LPOWDBGEN_BIT 4
#define PRCCU_BOOTCR_ADCEN_MASK 0x20U
#define PRCCU_BOOTCR_ADCEN 0x20U
#define PRCCU_BOOTCR_ADCEN_BIT 5
#define PRCCU_BOOTCR_CAN_MASK 0x40U
#define PRCCU_BOOTCR_CAN 0x40U
#define PRCCU_BOOTCR_CAN_BIT 6
#define PRCCU_BOOTCR_HDLC_MASK 0x80U
#define PRCCU_BOOTCR_HDLC 0x80U
#define PRCCU_BOOTCR_HDLC_BIT 7
#define PRCCU_BOOTCR_GPS_MASK 0x100U
#define PRCCU_BOOTCR_GPS 0x100U
#define PRCCU_BOOTCR_GPS_BIT 8
#define PRCCU_BOOTCR_PKG64_MASK 0x200U
#define PRCCU_BOOTCR_PKG64 0x200U
#define PRCCU_BOOTCR_PKG64_BIT 9

#define PRCCU_PWRCR (*(volatile unsigned long *)0xA0000054)
#define PRCCU_PWRCR_VRBYP_MASK 0x8U
#define PRCCU_PWRCR_VRBYP 0x8U
#define PRCCU_PWRCR_VRBYP_BIT 3
#define PRCCU_PWRCR_LPVRWFI_MASK 0x10U
#define PRCCU_PWRCR_LPVRWFI 0x10U
#define PRCCU_PWRCR_LPVRWFI_BIT 4
#define PRCCU_PWRCR_LPVRBYP_MASK 0x20U
#define PRCCU_PWRCR_LPVRBYP 0x20U
#define PRCCU_PWRCR_LPVRBYP_BIT 5
#define PRCCU_PWRCR_PWRDWN_MASK 0x40U
#define PRCCU_PWRCR_PWRDWN 0x40U
#define PRCCU_PWRCR_PWRDWN_BIT 6
#define PRCCU_PWRCR_OSCBYP_MASK 0x80U
#define PRCCU_PWRCR_OSCBYP 0x80U
#define PRCCU_PWRCR_OSCBYP_BIT 7
#define PRCCU_PWRCR_LVDDIS_MASK 0x100U
#define PRCCU_PWRCR_LVDDIS 0x100U
#define PRCCU_PWRCR_LVDDIS_BIT 8
#define PRCCU_PWRCR_FLASH_LP_MASK 0x200U
#define PRCCU_PWRCR_FLASH_LP 0x200U
#define PRCCU_PWRCR_FLASH_LP_BIT 9
#define PRCCU_PWRCR_VROK_MASK 0x1000U
#define PRCCU_PWRCR_VROK 0x1000U
#define PRCCU_PWRCR_VROK_BIT 12
#define PRCCU_PWRCR_WKUPALRM_MASK 0x2000U
#define PRCCU_PWRCR_WKUPALRM 0x2000U
#define PRCCU_PWRCR_WKUPALRM_BIT 13
#define PRCCU_PWRCR_BUSY_MASK 0x4000U
#define PRCCU_PWRCR_BUSY 0x4000U
#define PRCCU_PWRCR_BUSY_BIT 14
#define PRCCU_PWRCR_WREN_MASK 0x8000U
#define PRCCU_PWRCR_WREN 0x8000U
#define PRCCU_PWRCR_WREN_BIT 15


#endif
