// LH79524 register and bit definitions.
//
// Copyright (c) 2005 Rowley Associates Limited.
//
// This file may be distributed under the terms of the License Agreement
// provided with this software.
//
// THIS FILE IS PROVIDED AS IS WITH NO WARRANTY OF ANY KIND, INCLUDING THE
// WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.

#ifndef LH79524_h
#define LH79524_h

#define UART0_BASE 0xFFFC0000

#define UART0_DR (*(volatile unsigned long *)0xFFFC0000)
#define UART0_DR_OFFSET 0x0

#define UART0_RSR (*(volatile unsigned long *)0xFFFC0004)
#define UART0_RSR_OFFSET 0x4

#define UART0_ECR (*(volatile unsigned long *)0xFFFC0004)
#define UART0_ECR_OFFSET 0x4

#define UART0_FR (*(volatile unsigned long *)0xFFFC0018)
#define UART0_FR_OFFSET 0x18

#define UART0_ILPR (*(volatile unsigned long *)0xFFFC0020)
#define UART0_ILPR_OFFSET 0x20

#define UART0_IBRD (*(volatile unsigned long *)0xFFFC0024)
#define UART0_IBRD_OFFSET 0x24

#define UART0_FBRD (*(volatile unsigned long *)0xFFFC0028)
#define UART0_FBRD_OFFSET 0x28

#define UART0_LCR_H (*(volatile unsigned long *)0xFFFC002C)
#define UART0_LCR_H_OFFSET 0x2C

#define UART0_CR (*(volatile unsigned long *)0xFFFC0030)
#define UART0_CR_OFFSET 0x30

#define UART0_IFLS (*(volatile unsigned long *)0xFFFC0034)
#define UART0_IFLS_OFFSET 0x34

#define UART0_IMSC (*(volatile unsigned long *)0xFFFC0038)
#define UART0_IMSC_OFFSET 0x38

#define UART0_RIS (*(volatile unsigned long *)0xFFFC003C)
#define UART0_RIS_OFFSET 0x3C

#define UART0_MIS (*(volatile unsigned long *)0xFFFC0040)
#define UART0_MIS_OFFSET 0x40

#define UART0_ICR (*(volatile unsigned long *)0xFFFC0044)
#define UART0_ICR_OFFSET 0x44

#define UART0_DMACTRL (*(volatile unsigned long *)0xFFFC0048)
#define UART0_DMACTRL_OFFSET 0x48

#define UART1_BASE 0xFFFC1000

#define UART1_DR (*(volatile unsigned long *)0xFFFC1000)
#define UART1_DR_OFFSET 0x0

#define UART1_RSR (*(volatile unsigned long *)0xFFFC1004)
#define UART1_RSR_OFFSET 0x4

#define UART1_ECR (*(volatile unsigned long *)0xFFFC1004)
#define UART1_ECR_OFFSET 0x4

#define UART1_FR (*(volatile unsigned long *)0xFFFC1018)
#define UART1_FR_OFFSET 0x18

#define UART1_ILPR (*(volatile unsigned long *)0xFFFC1020)
#define UART1_ILPR_OFFSET 0x20

#define UART1_IBRD (*(volatile unsigned long *)0xFFFC1024)
#define UART1_IBRD_OFFSET 0x24

#define UART1_FBRD (*(volatile unsigned long *)0xFFFC1028)
#define UART1_FBRD_OFFSET 0x28

#define UART1_LCR_H (*(volatile unsigned long *)0xFFFC102C)
#define UART1_LCR_H_OFFSET 0x2C

#define UART1_CR (*(volatile unsigned long *)0xFFFC1030)
#define UART1_CR_OFFSET 0x30

#define UART1_IFLS (*(volatile unsigned long *)0xFFFC1034)
#define UART1_IFLS_OFFSET 0x34

#define UART1_IMSC (*(volatile unsigned long *)0xFFFC1038)
#define UART1_IMSC_OFFSET 0x38

#define UART1_RIS (*(volatile unsigned long *)0xFFFC103C)
#define UART1_RIS_OFFSET 0x3C

#define UART1_MIS (*(volatile unsigned long *)0xFFFC1040)
#define UART1_MIS_OFFSET 0x40

#define UART1_ICR (*(volatile unsigned long *)0xFFFC1044)
#define UART1_ICR_OFFSET 0x44

#define UART1_DMACTRL (*(volatile unsigned long *)0xFFFC1048)
#define UART1_DMACTRL_OFFSET 0x48

#define UART2_BASE 0xFFFC2000

#define UART2_DR (*(volatile unsigned long *)0xFFFC2000)
#define UART2_DR_OFFSET 0x0

#define UART2_RSR (*(volatile unsigned long *)0xFFFC2004)
#define UART2_RSR_OFFSET 0x4

#define UART2_ECR (*(volatile unsigned long *)0xFFFC2004)
#define UART2_ECR_OFFSET 0x4

#define UART2_FR (*(volatile unsigned long *)0xFFFC2018)
#define UART2_FR_OFFSET 0x18

#define UART2_ILPR (*(volatile unsigned long *)0xFFFC2020)
#define UART2_ILPR_OFFSET 0x20

#define UART2_IBRD (*(volatile unsigned long *)0xFFFC2024)
#define UART2_IBRD_OFFSET 0x24

#define UART2_FBRD (*(volatile unsigned long *)0xFFFC2028)
#define UART2_FBRD_OFFSET 0x28

#define UART2_LCR_H (*(volatile unsigned long *)0xFFFC202C)
#define UART2_LCR_H_OFFSET 0x2C

#define UART2_CR (*(volatile unsigned long *)0xFFFC2030)
#define UART2_CR_OFFSET 0x30

#define UART2_IFLS (*(volatile unsigned long *)0xFFFC2034)
#define UART2_IFLS_OFFSET 0x34

#define UART2_IMSC (*(volatile unsigned long *)0xFFFC2038)
#define UART2_IMSC_OFFSET 0x38

#define UART2_RIS (*(volatile unsigned long *)0xFFFC203C)
#define UART2_RIS_OFFSET 0x3C

#define UART2_MIS (*(volatile unsigned long *)0xFFFC2040)
#define UART2_MIS_OFFSET 0x40

#define UART2_ICR (*(volatile unsigned long *)0xFFFC2044)
#define UART2_ICR_OFFSET 0x44

#define UART2_DMACTRL (*(volatile unsigned long *)0xFFFC2048)
#define UART2_DMACTRL_OFFSET 0x48

#define ADC_BASE 0xFFFC3000

#define ADC_HW (*(volatile unsigned long *)0xFFFC3000)
#define ADC_HW_OFFSET 0x0

#define ADC_LW (*(volatile unsigned long *)0xFFFC3004)
#define ADC_LW_OFFSET 0x4

#define ADC_RR (*(volatile unsigned long *)0xFFFC3008)
#define ADC_RR_OFFSET 0x8

#define ADC_IM (*(volatile unsigned long *)0xFFFC300C)
#define ADC_IM_OFFSET 0xC

#define ADC_PC (*(volatile unsigned long *)0xFFFC3010)
#define ADC_PC_OFFSET 0x10

#define ADC_GC (*(volatile unsigned long *)0xFFFC3014)
#define ADC_GC_OFFSET 0x14

#define ADC_GS (*(volatile unsigned long *)0xFFFC3018)
#define ADC_GS_OFFSET 0x18

#define ADC_IS (*(volatile unsigned long *)0xFFFC301C)
#define ADC_IS_OFFSET 0x1C

#define ADC_FS (*(volatile unsigned long *)0xFFFC3020)
#define ADC_FS_OFFSET 0x20

#define ADC_HWCB0 (*(volatile unsigned long *)0xFFFC3024)
#define ADC_HWCB0_OFFSET 0x24

#define ADC_HWCB1 (*(volatile unsigned long *)0xFFFC3028)
#define ADC_HWCB1_OFFSET 0x28

#define ADC_HWCB2 (*(volatile unsigned long *)0xFFFC302C)
#define ADC_HWCB2_OFFSET 0x2C

#define ADC_HWCB3 (*(volatile unsigned long *)0xFFFC3030)
#define ADC_HWCB3_OFFSET 0x30

#define ADC_HWCB4 (*(volatile unsigned long *)0xFFFC3034)
#define ADC_HWCB4_OFFSET 0x34

#define ADC_HWCB5 (*(volatile unsigned long *)0xFFFC3038)
#define ADC_HWCB5_OFFSET 0x38

#define ADC_HWCB6 (*(volatile unsigned long *)0xFFFC303C)
#define ADC_HWCB6_OFFSET 0x3C

#define ADC_HWCB7 (*(volatile unsigned long *)0xFFFC3040)
#define ADC_HWCB7_OFFSET 0x40

#define ADC_HWCB8 (*(volatile unsigned long *)0xFFFC3044)
#define ADC_HWCB8_OFFSET 0x44

#define ADC_HWCB9 (*(volatile unsigned long *)0xFFFC3048)
#define ADC_HWCB9_OFFSET 0x48

#define ADC_HWCB10 (*(volatile unsigned long *)0xFFFC304C)
#define ADC_HWCB10_OFFSET 0x4C

#define ADC_HWCB11 (*(volatile unsigned long *)0xFFFC3050)
#define ADC_HWCB11_OFFSET 0x50

#define ADC_HWCB12 (*(volatile unsigned long *)0xFFFC3054)
#define ADC_HWCB12_OFFSET 0x54

#define ADC_HWCB13 (*(volatile unsigned long *)0xFFFC3058)
#define ADC_HWCB13_OFFSET 0x58

#define ADC_HWCB14 (*(volatile unsigned long *)0xFFFC305C)
#define ADC_HWCB14_OFFSET 0x5C

#define ADC_HWCB15 (*(volatile unsigned long *)0xFFFC3060)
#define ADC_HWCB15_OFFSET 0x60

#define ADC_LWCB0 (*(volatile unsigned long *)0xFFFC3064)
#define ADC_LWCB0_OFFSET 0x64

#define ADC_LWCB1 (*(volatile unsigned long *)0xFFFC3068)
#define ADC_LWCB1_OFFSET 0x68

#define ADC_LWCB2 (*(volatile unsigned long *)0xFFFC306C)
#define ADC_LWCB2_OFFSET 0x6C

#define ADC_LWCB3 (*(volatile unsigned long *)0xFFFC3070)
#define ADC_LWCB3_OFFSET 0x70

#define ADC_LWCB4 (*(volatile unsigned long *)0xFFFC3074)
#define ADC_LWCB4_OFFSET 0x74

#define ADC_LWCB5 (*(volatile unsigned long *)0xFFFC3078)
#define ADC_LWCB5_OFFSET 0x78

#define ADC_LWCB6 (*(volatile unsigned long *)0xFFFC307C)
#define ADC_LWCB6_OFFSET 0x7C

#define ADC_LWCB7 (*(volatile unsigned long *)0xFFFC3080)
#define ADC_LWCB7_OFFSET 0x80

#define ADC_LWCB8 (*(volatile unsigned long *)0xFFFC3084)
#define ADC_LWCB8_OFFSET 0x84

#define ADC_LWCB9 (*(volatile unsigned long *)0xFFFC3088)
#define ADC_LWCB9_OFFSET 0x88

#define ADC_LWCB10 (*(volatile unsigned long *)0xFFFC308C)
#define ADC_LWCB10_OFFSET 0x8C

#define ADC_LWCB11 (*(volatile unsigned long *)0xFFFC3090)
#define ADC_LWCB11_OFFSET 0x90

#define ADC_LWCB12 (*(volatile unsigned long *)0xFFFC3094)
#define ADC_LWCB12_OFFSET 0x94

#define ADC_LWCB13 (*(volatile unsigned long *)0xFFFC3098)
#define ADC_LWCB13_OFFSET 0x98

#define ADC_LWCB14 (*(volatile unsigned long *)0xFFFC309C)
#define ADC_LWCB14_OFFSET 0x9C

#define ADC_LWCB15 (*(volatile unsigned long *)0xFFFC30A0)
#define ADC_LWCB15_OFFSET 0xA0

#define ADC_IHWCTRL (*(volatile unsigned long *)0xFFFC30A4)
#define ADC_IHWCTRL_OFFSET 0xA4

#define ADC_ILWCTRL (*(volatile unsigned long *)0xFFFC30A8)
#define ADC_ILWCTRL_OFFSET 0xA8

#define ADC_MIS (*(volatile unsigned long *)0xFFFC30AC)
#define ADC_MIS_OFFSET 0xAC

#define ADC_IC (*(volatile unsigned long *)0xFFFC30B0)
#define ADC_IC_OFFSET 0xB0

#define TIMER0_BASE 0xFFFC4000

#define TIMER_CTRL0 (*(volatile unsigned long *)0xFFFC4000)
#define TIMER_CTRL0_OFFSET 0x0

#define TIMER_CMP_CAP_CTRL (*(volatile unsigned long *)0xFFFC4004)
#define TIMER_CMP_CAP_CTRL_OFFSET 0x4

#define TIMER_INTEN0 (*(volatile unsigned long *)0xFFFC4008)
#define TIMER_INTEN0_OFFSET 0x8

#define TIMER_STATUS0 (*(volatile unsigned long *)0xFFFC400C)
#define TIMER_STATUS0_OFFSET 0xC

#define TIMER_CNT0 (*(volatile unsigned long *)0xFFFC4010)
#define TIMER_CNT0_OFFSET 0x10

#define TIMER_T0CMP0 (*(volatile unsigned long *)0xFFFC4014)
#define TIMER_T0CMP0_OFFSET 0x14

#define TIMER_T0CMP1 (*(volatile unsigned long *)0xFFFC4018)
#define TIMER_T0CMP1_OFFSET 0x18

#define TIMER_T0CAPA (*(volatile unsigned long *)0xFFFC401C)
#define TIMER_T0CAPA_OFFSET 0x1C

#define TIMER_T0CAPB (*(volatile unsigned long *)0xFFFC4020)
#define TIMER_T0CAPB_OFFSET 0x20

#define TIMER_T0CAPC (*(volatile unsigned long *)0xFFFC4024)
#define TIMER_T0CAPC_OFFSET 0x24

#define TIMER_T0CAPD (*(volatile unsigned long *)0xFFFC4028)
#define TIMER_T0CAPD_OFFSET 0x28

#define TIMER_T0CAPE (*(volatile unsigned long *)0xFFFC402C)
#define TIMER_T0CAPE_OFFSET 0x2C

#define TIMER1_BASE 0xFFFC4030

#define TIMER_CTRL1 (*(volatile unsigned long *)0xFFFC4030)
#define TIMER_CTRL1_OFFSET 0x0

#define TIMER_INTEN1 (*(volatile unsigned long *)0xFFFC4034)
#define TIMER_INTEN1_OFFSET 0x4

#define TIMER_STATUS1 (*(volatile unsigned long *)0xFFFC4038)
#define TIMER_STATUS1_OFFSET 0x8

#define TIMER_CNT1 (*(volatile unsigned long *)0xFFFC403C)
#define TIMER_CNT1_OFFSET 0xC

#define TIMER_T1CMP0 (*(volatile unsigned long *)0xFFFC4040)
#define TIMER_T1CMP0_OFFSET 0x10

#define TIMER_T1CMP1 (*(volatile unsigned long *)0xFFFC4044)
#define TIMER_T1CMP1_OFFSET 0x14

#define TIMER_T1CAPA (*(volatile unsigned long *)0xFFFC4048)
#define TIMER_T1CAPA_OFFSET 0x18

#define TIMER_T1CAPB (*(volatile unsigned long *)0xFFFC404C)
#define TIMER_T1CAPB_OFFSET 0x1C

#define TIMER2_BASE 0xFFFC4050

#define TIMER_CTRL2 (*(volatile unsigned long *)0xFFFC4050)
#define TIMER_CTRL2_OFFSET 0x0

#define TIMER_INTEN2 (*(volatile unsigned long *)0xFFFC4054)
#define TIMER_INTEN2_OFFSET 0x4

#define TIMER_STATUS2 (*(volatile unsigned long *)0xFFFC4058)
#define TIMER_STATUS2_OFFSET 0x8

#define TIMER_CNT2 (*(volatile unsigned long *)0xFFFC405C)
#define TIMER_CNT2_OFFSET 0xC

#define TIMER_T2CMP0 (*(volatile unsigned long *)0xFFFC4060)
#define TIMER_T2CMP0_OFFSET 0x10

#define TIMER_T2CMP1 (*(volatile unsigned long *)0xFFFC4064)
#define TIMER_T2CMP1_OFFSET 0x14

#define TIMER_T2CAPA (*(volatile unsigned long *)0xFFFC4068)
#define TIMER_T2CAPA_OFFSET 0x18

#define TIMER_T2CAPB (*(volatile unsigned long *)0xFFFC406C)
#define TIMER_T2CAPB_OFFSET 0x1C

#define I2C_BASE 0xFFFC5000

#define ICCON (*(volatile unsigned long *)0xFFFC5000)
#define ICCON_OFFSET 0x0

#define ICSAR (*(volatile unsigned long *)0xFFFC5004)
#define ICSAR_OFFSET 0x4

#define ICUSAR (*(volatile unsigned long *)0xFFFC5008)
#define ICUSAR_OFFSET 0x8

#define ICDATA (*(volatile unsigned long *)0xFFFC500C)
#define ICDATA_OFFSET 0xC

#define ICHCNT (*(volatile unsigned long *)0xFFFC5010)
#define ICHCNT_OFFSET 0x10

#define ICLCNT (*(volatile unsigned long *)0xFFFC5014)
#define ICLCNT_OFFSET 0x14

#define ICDEBUG (*(volatile unsigned long *)0xFFFC5018)
#define ICDEBUG_OFFSET 0x18

#define ICSTAT (*(volatile unsigned long *)0xFFFC501C)
#define ICSTAT_OFFSET 0x1C

#define SSP_BASE 0xFFFC6000

#define SSP_CTRL0 (*(volatile unsigned long *)0xFFFC6000)
#define SSP_CTRL0_OFFSET 0x0

#define SSP_CTRL1 (*(volatile unsigned long *)0xFFFC6004)
#define SSP_CTRL1_OFFSET 0x4

#define SSP_DR (*(volatile unsigned long *)0xFFFC6008)
#define SSP_DR_OFFSET 0x8

#define SSP_SR (*(volatile unsigned long *)0xFFFC600C)
#define SSP_SR_OFFSET 0xC

#define SSP_CPSR (*(volatile unsigned long *)0xFFFC6010)
#define SSP_CPSR_OFFSET 0x10

#define SSP_IMSC (*(volatile unsigned long *)0xFFFC6014)
#define SSP_IMSC_OFFSET 0x14

#define SSP_RIS (*(volatile unsigned long *)0xFFFC6018)
#define SSP_RIS_OFFSET 0x18

#define SSP_MIS (*(volatile unsigned long *)0xFFFC601C)
#define SSP_MIS_OFFSET 0x1C

#define SSP_ICR (*(volatile unsigned long *)0xFFFC6020)
#define SSP_ICR_OFFSET 0x20

#define SSP_DCR (*(volatile unsigned long *)0xFFFC5024)
#define SSP_DCR_OFFSET 0xFFFFF024

#define EMAC_BASE 0xFFFC7000

#define EMAC_NETCTL (*(volatile unsigned long *)0xFFFC7000)
#define EMAC_NETCTL_OFFSET 0x0

#define EMAC_NETCONFIG (*(volatile unsigned long *)0xFFFC7004)
#define EMAC_NETCONFIG_OFFSET 0x4

#define EMAC_NETSTATUS (*(volatile unsigned long *)0xFFFC7008)
#define EMAC_NETSTATUS_OFFSET 0x8

#define EMAC_TXSTATUS (*(volatile unsigned long *)0xFFFC7014)
#define EMAC_TXSTATUS_OFFSET 0x14

#define EMAC_RXBQP (*(volatile unsigned long *)0xFFFC7018)
#define EMAC_RXBQP_OFFSET 0x18

#define EMAC_TXBQP (*(volatile unsigned long *)0xFFFC701C)
#define EMAC_TXBQP_OFFSET 0x1C

#define EMAC_RXSTATUS (*(volatile unsigned long *)0xFFFC7020)
#define EMAC_RXSTATUS_OFFSET 0x20

#define EMAC_INSTATUS (*(volatile unsigned long *)0xFFFC7024)
#define EMAC_INSTATUS_OFFSET 0x24

#define EMAC_ENABLE (*(volatile unsigned long *)0xFFFC7028)
#define EMAC_ENABLE_OFFSET 0x28

#define EMAC_DISABLE (*(volatile unsigned long *)0xFFFC702C)
#define EMAC_DISABLE_OFFSET 0x2C

#define EMAC_MASK (*(volatile unsigned long *)0xFFFC7030)
#define EMAC_MASK_OFFSET 0x30

#define EMAC_PHYMAINT (*(volatile unsigned long *)0xFFFC7034)
#define EMAC_PHYMAINT_OFFSET 0x34

#define EMAC_PAUSETIME (*(volatile unsigned long *)0xFFFC7038)
#define EMAC_PAUSETIME_OFFSET 0x38

#define EMAC_PAUSEFRRX (*(volatile unsigned long *)0xFFFC703C)
#define EMAC_PAUSEFRRX_OFFSET 0x3C

#define EMAC_FRMTXOK (*(volatile unsigned long *)0xFFFC7040)
#define EMAC_FRMTXOK_OFFSET 0x40

#define EMAC_SINGLECOL (*(volatile unsigned long *)0xFFFC7044)
#define EMAC_SINGLECOL_OFFSET 0x44

#define EMAC_MULTFRM (*(volatile unsigned long *)0xFFFC7048)
#define EMAC_MULTFRM_OFFSET 0x48

#define EMAC_FRMRXOK (*(volatile unsigned long *)0xFFFC704C)
#define EMAC_FRMRXOK_OFFSET 0x4C

#define EMAC_FRCHK (*(volatile unsigned long *)0xFFFC7050)
#define EMAC_FRCHK_OFFSET 0x50

#define EMAC_ALIGNERR (*(volatile unsigned long *)0xFFFC7054)
#define EMAC_ALIGNERR_OFFSET 0x54

#define EMAC_DEFTXFRM (*(volatile unsigned long *)0xFFFC7058)
#define EMAC_DEFTXFRM_OFFSET 0x58

#define EMAC_LATECOL (*(volatile unsigned long *)0xFFFC705C)
#define EMAC_LATECOL_OFFSET 0x5C

#define EMAC_EXCOL (*(volatile unsigned long *)0xFFFC7060)
#define EMAC_EXCOL_OFFSET 0x60

#define EMAC_TXUNDER (*(volatile unsigned long *)0xFFFC7064)
#define EMAC_TXUNDER_OFFSET 0x64

#define EMAC_SENSERR (*(volatile unsigned long *)0xFFFC7068)
#define EMAC_SENSERR_OFFSET 0x68

#define EMAC_RXRERR (*(volatile unsigned long *)0xFFFC706C)
#define EMAC_RXRERR_OFFSET 0x6C

#define EMAC_RXOVERR (*(volatile unsigned long *)0xFFFC7070)
#define EMAC_RXOVERR_OFFSET 0x70

#define EMAC_RXSYMERR (*(volatile unsigned long *)0xFFFC7074)
#define EMAC_RXSYMERR_OFFSET 0x74

#define EMAC_LENERR (*(volatile unsigned long *)0xFFFC7078)
#define EMAC_LENERR_OFFSET 0x78

#define EMAC_RXJAB (*(volatile unsigned long *)0xFFFC707C)
#define EMAC_RXJAB_OFFSET 0x7C

#define EMAC_UNDERFRM (*(volatile unsigned long *)0xFFFC7080)
#define EMAC_UNDERFRM_OFFSET 0x80

#define EMAC_SQERR (*(volatile unsigned long *)0xFFFC7084)
#define EMAC_SQERR_OFFSET 0x84

#define EMAC_RXLEN (*(volatile unsigned long *)0xFFFC7088)
#define EMAC_RXLEN_OFFSET 0x88

#define EMAC_TXPAUSEFM (*(volatile unsigned long *)0xFFFC708C)
#define EMAC_TXPAUSEFM_OFFSET 0x8C

#define EMAC_HASHBOT (*(volatile unsigned long *)0xFFFC7090)
#define EMAC_HASHBOT_OFFSET 0x90

#define EMAC_HASHTOP (*(volatile unsigned long *)0xFFFC7094)
#define EMAC_HASHTOP_OFFSET 0x94

#define EMAC_SPECAD1BOT (*(volatile unsigned long *)0xFFFC7098)
#define EMAC_SPECAD1BOT_OFFSET 0x98

#define EMAC_SPECAD1TOP (*(volatile unsigned long *)0xFFFC709C)
#define EMAC_SPECAD1TOP_OFFSET 0x9C

#define EMAC_SPECAD2BOT (*(volatile unsigned long *)0xFFFC70A0)
#define EMAC_SPECAD2BOT_OFFSET 0xA0

#define EMAC_SPECAD2TOP (*(volatile unsigned long *)0xFFFC70A4)
#define EMAC_SPECAD2TOP_OFFSET 0xA4

#define EMAC_SPECAD3BOT (*(volatile unsigned long *)0xFFFC70A8)
#define EMAC_SPECAD3BOT_OFFSET 0xA8

#define EMAC_SPECAD3TOP (*(volatile unsigned long *)0xFFFC70AC)
#define EMAC_SPECAD3TOP_OFFSET 0xAC

#define EMAC_SPECAD4BOT (*(volatile unsigned long *)0xFFFC70B0)
#define EMAC_SPECAD4BOT_OFFSET 0xB0

#define EMAC_SPECAD4TOP (*(volatile unsigned long *)0xFFFC70B4)
#define EMAC_SPECAD4TOP_OFFSET 0xB4

#define EMAC_IDCHK (*(volatile unsigned long *)0xFFFC70B8)
#define EMAC_IDCHK_OFFSET 0xB8

#define EMAC_TXPAUSEQUAN (*(volatile unsigned long *)0xFFFC70BC)
#define EMAC_TXPAUSEQUAN_OFFSET 0xBC

#define I2S_BASE 0xFFFC8000

#define I2S_CTRL (*(volatile unsigned long *)0xFFFC8000)
#define I2S_CTRL_OFFSET 0x0

#define I2S_STAT (*(volatile unsigned long *)0xFFFC8004)
#define I2S_STAT_OFFSET 0x4

#define I2S_IMSC (*(volatile unsigned long *)0xFFFC8008)
#define I2S_IMSC_OFFSET 0x8

#define I2S_RIS (*(volatile unsigned long *)0xFFFC800C)
#define I2S_RIS_OFFSET 0xC

#define I2S_MIS (*(volatile unsigned long *)0xFFFC8010)
#define I2S_MIS_OFFSET 0x10

#define I2S_ICR (*(volatile unsigned long *)0xFFFC8014)
#define I2S_ICR_OFFSET 0x14

#define GPIO_BASE 0xFFFD9000

#define GPIO_P1DRM (*(volatile unsigned long *)0xFFFD9000)
#define GPIO_P1DRM_OFFSET 0x0

#define GPIO_P2DRN (*(volatile unsigned long *)0xFFFD9004)
#define GPIO_P2DRN_OFFSET 0x4

#define GPIO_P1DDRM (*(volatile unsigned long *)0xFFFD9008)
#define GPIO_P1DDRM_OFFSET 0x8

#define GPIO_P2DDRN (*(volatile unsigned long *)0xFFFD900C)
#define GPIO_P2DDRN_OFFSET 0xC

#define GPIO_P1DRK (*(volatile unsigned long *)0xFFFDA000)
#define GPIO_P1DRK_OFFSET 0x1000

#define GPIO_P2DRL (*(volatile unsigned long *)0xFFFDA004)
#define GPIO_P2DRL_OFFSET 0x1004

#define GPIO_P1DDRK (*(volatile unsigned long *)0xFFFDA008)
#define GPIO_P1DDRK_OFFSET 0x1008

#define GPIO_P2DDRL (*(volatile unsigned long *)0xFFFDA00C)
#define GPIO_P2DDRL_OFFSET 0x100C

#define GPIO_P1DRI (*(volatile unsigned long *)0xFFFDB000)
#define GPIO_P1DRI_OFFSET 0x2000

#define GPIO_P2DRJ (*(volatile unsigned long *)0xFFFDB004)
#define GPIO_P2DRJ_OFFSET 0x2004

#define GPIO_P1DDRI (*(volatile unsigned long *)0xFFFDB008)
#define GPIO_P1DDRI_OFFSET 0x2008

#define GPIO_P2DDRJ (*(volatile unsigned long *)0xFFFDB00C)
#define GPIO_P2DDRJ_OFFSET 0x200C

#define GPIO_P1DRG (*(volatile unsigned long *)0xFFFDC000)
#define GPIO_P1DRG_OFFSET 0x3000

#define GPIO_P2DRH (*(volatile unsigned long *)0xFFFDC004)
#define GPIO_P2DRH_OFFSET 0x3004

#define GPIO_P1DDRG (*(volatile unsigned long *)0xFFFDC008)
#define GPIO_P1DDRG_OFFSET 0x3008

#define GPIO_P2DDRH (*(volatile unsigned long *)0xFFFDC00C)
#define GPIO_P2DDRH_OFFSET 0x300C

#define GPIO_P1DRE (*(volatile unsigned long *)0xFFFDD000)
#define GPIO_P1DRE_OFFSET 0x4000

#define GPIO_P2DRF (*(volatile unsigned long *)0xFFFDD004)
#define GPIO_P2DRF_OFFSET 0x4004

#define GPIO_P1DDRE (*(volatile unsigned long *)0xFFFDD008)
#define GPIO_P1DDRE_OFFSET 0x4008

#define GPIO_P2DDRF (*(volatile unsigned long *)0xFFFDD00C)
#define GPIO_P2DDRF_OFFSET 0x400C

#define GPIO_P1DRC (*(volatile unsigned long *)0xFFFDE000)
#define GPIO_P1DRC_OFFSET 0x5000

#define GPIO_P2DRD (*(volatile unsigned long *)0xFFFDE004)
#define GPIO_P2DRD_OFFSET 0x5004

#define GPIO_P1DDRC (*(volatile unsigned long *)0xFFFDE008)
#define GPIO_P1DDRC_OFFSET 0x5008

#define GPIO_P2DDRD (*(volatile unsigned long *)0xFFFDE00C)
#define GPIO_P2DDRD_OFFSET 0x500C

#define GPIO_P1DRA (*(volatile unsigned long *)0xFFFDF000)
#define GPIO_P1DRA_OFFSET 0x6000

#define GPIO_P2DRB (*(volatile unsigned long *)0xFFFDF004)
#define GPIO_P2DRB_OFFSET 0x6004

#define GPIO_P1DDRA (*(volatile unsigned long *)0xFFFDF008)
#define GPIO_P1DDRA_OFFSET 0x6008

#define GPIO_P2DDRB (*(volatile unsigned long *)0xFFFDF00C)
#define GPIO_P2DDRB_OFFSET 0x600C

#define RTC_BASE 0xFFFE0000

#define RTC_DR (*(volatile unsigned long *)0xFFFE0000)
#define RTC_DR_OFFSET 0x0

#define RTC_MR (*(volatile unsigned long *)0xFFFE0004)
#define RTC_MR_OFFSET 0x4

#define RTC_LR (*(volatile unsigned long *)0xFFFE0008)
#define RTC_LR_OFFSET 0x8

#define RTC_CR (*(volatile unsigned long *)0xFFFE000C)
#define RTC_CR_OFFSET 0xC

#define RTC_IMSC (*(volatile unsigned long *)0xFFFE0010)
#define RTC_IMSC_OFFSET 0x10

#define RTC_RIS (*(volatile unsigned long *)0xFFFE0014)
#define RTC_RIS_OFFSET 0x14

#define RTC_MIS (*(volatile unsigned long *)0xFFFE0018)
#define RTC_MIS_OFFSET 0x18

#define RTC_ICR (*(volatile unsigned long *)0xFFFE001C)
#define RTC_ICR_OFFSET 0x1C

#define DMA_BASE 0xFFFE1000

#define DMA0_SOURCELO (*(volatile unsigned long *)0xFFFE1000)
#define DMA0_SOURCELO_OFFSET 0x0

#define DMA0_SOURCEHI (*(volatile unsigned long *)0xFFFE1004)
#define DMA0_SOURCEHI_OFFSET 0x4

#define DMA0_DESTLO (*(volatile unsigned long *)0xFFFE1008)
#define DMA0_DESTLO_OFFSET 0x8

#define DMA0_DESTHI (*(volatile unsigned long *)0xFFFE100C)
#define DMA0_DESTHI_OFFSET 0xC

#define DMA0_MAX (*(volatile unsigned long *)0xFFFE1010)
#define DMA0_MAX_OFFSET 0x10

#define DMA0_CTRL (*(volatile unsigned long *)0xFFFE1014)
#define DMA0_CTRL_OFFSET 0x14

#define DMA0_CURSLO (*(volatile unsigned long *)0xFFFE1018)
#define DMA0_CURSLO_OFFSET 0x18

#define DMA0_CURSHI (*(volatile unsigned long *)0xFFFE101C)
#define DMA0_CURSHI_OFFSET 0x1C

#define DMA0_CURDLO (*(volatile unsigned long *)0xFFFE1020)
#define DMA0_CURDLO_OFFSET 0x20

#define DMA0_CURDHI (*(volatile unsigned long *)0xFFFE1024)
#define DMA0_CURDHI_OFFSET 0x24

#define DMA0_TCNT (*(volatile unsigned long *)0xFFFE1028)
#define DMA0_TCNT_OFFSET 0x28

#define DMA1_SOURCELO (*(volatile unsigned long *)0xFFFE1040)
#define DMA1_SOURCELO_OFFSET 0x40

#define DMA1_SOURCEHI (*(volatile unsigned long *)0xFFFE1044)
#define DMA1_SOURCEHI_OFFSET 0x44

#define DMA1_DESTLO (*(volatile unsigned long *)0xFFFE1048)
#define DMA1_DESTLO_OFFSET 0x48

#define DMA1_DESTHI (*(volatile unsigned long *)0xFFFE104C)
#define DMA1_DESTHI_OFFSET 0x4C

#define DMA1_MAX (*(volatile unsigned long *)0xFFFE1050)
#define DMA1_MAX_OFFSET 0x50

#define DMA1_CTRL (*(volatile unsigned long *)0xFFFE1054)
#define DMA1_CTRL_OFFSET 0x54

#define DMA1_CURSLO (*(volatile unsigned long *)0xFFFE1058)
#define DMA1_CURSLO_OFFSET 0x58

#define DMA1_CURSHI (*(volatile unsigned long *)0xFFFE105C)
#define DMA1_CURSHI_OFFSET 0x5C

#define DMA1_CURDLO (*(volatile unsigned long *)0xFFFE1060)
#define DMA1_CURDLO_OFFSET 0x60

#define DMA1_CURDHI (*(volatile unsigned long *)0xFFFE1064)
#define DMA1_CURDHI_OFFSET 0x64

#define DMA1_TCNT (*(volatile unsigned long *)0xFFFE1068)
#define DMA1_TCNT_OFFSET 0x68

#define DMA2_SOURCELO (*(volatile unsigned long *)0xFFFE1080)
#define DMA2_SOURCELO_OFFSET 0x80

#define DMA2_SOURCEHI (*(volatile unsigned long *)0xFFFE1084)
#define DMA2_SOURCEHI_OFFSET 0x84

#define DMA2_DESTLO (*(volatile unsigned long *)0xFFFE1088)
#define DMA2_DESTLO_OFFSET 0x88

#define DMA2_DESTHI (*(volatile unsigned long *)0xFFFE108C)
#define DMA2_DESTHI_OFFSET 0x8C

#define DMA2_MAX (*(volatile unsigned long *)0xFFFE1090)
#define DMA2_MAX_OFFSET 0x90

#define DMA2_CTRL (*(volatile unsigned long *)0xFFFE1094)
#define DMA2_CTRL_OFFSET 0x94

#define DMA2_CURSLO (*(volatile unsigned long *)0xFFFE1098)
#define DMA2_CURSLO_OFFSET 0x98

#define DMA2_CURSHI (*(volatile unsigned long *)0xFFFE109C)
#define DMA2_CURSHI_OFFSET 0x9C

#define DMA2_CURDLO (*(volatile unsigned long *)0xFFFE10A0)
#define DMA2_CURDLO_OFFSET 0xA0

#define DMA2_CURDHI (*(volatile unsigned long *)0xFFFE10A4)
#define DMA2_CURDHI_OFFSET 0xA4

#define DMA2_TCNT (*(volatile unsigned long *)0xFFFE10A8)
#define DMA2_TCNT_OFFSET 0xA8

#define DMA3_SOURCELO (*(volatile unsigned long *)0xFFFE10C0)
#define DMA3_SOURCELO_OFFSET 0xC0

#define DMA3_SOURCEHI (*(volatile unsigned long *)0xFFFE10C4)
#define DMA3_SOURCEHI_OFFSET 0xC4

#define DMA3_DESTLO (*(volatile unsigned long *)0xFFFE10C8)
#define DMA3_DESTLO_OFFSET 0xC8

#define DMA3_DESTHI (*(volatile unsigned long *)0xFFFE10CC)
#define DMA3_DESTHI_OFFSET 0xCC

#define DMA3_MAX (*(volatile unsigned long *)0xFFFE10D0)
#define DMA3_MAX_OFFSET 0xD0

#define DMA3_CTRL (*(volatile unsigned long *)0xFFFE10D4)
#define DMA3_CTRL_OFFSET 0xD4

#define DMA3_CURSLO (*(volatile unsigned long *)0xFFFE10D8)
#define DMA3_CURSLO_OFFSET 0xD8

#define DMA3_CURSHI (*(volatile unsigned long *)0xFFFE10DC)
#define DMA3_CURSHI_OFFSET 0xDC

#define DMA3_CURDLO (*(volatile unsigned long *)0xFFFE10E0)
#define DMA3_CURDLO_OFFSET 0xE0

#define DMA3_CURDHI (*(volatile unsigned long *)0xFFFE10E4)
#define DMA3_CURDHI_OFFSET 0xE4

#define DMA3_TCNT (*(volatile unsigned long *)0xFFFE10E8)
#define DMA3_TCNT_OFFSET 0xE8

#define DMA_MASK (*(volatile unsigned long *)0xFFFE10F0)
#define DMA_MASK_OFFSET 0xF0

#define DMA_CLR (*(volatile unsigned long *)0xFFFE10F4)
#define DMA_CLR_OFFSET 0xF4

#define DMA_STATUS (*(volatile unsigned long *)0xFFFE10F8)
#define DMA_STATUS_OFFSET 0xF8

#define RCPC_BASE 0xFFFE2000

#define RCPC_CTRL (*(volatile unsigned long *)0xFFFE2000)
#define RCPC_CTRL_OFFSET 0x0

#define RCPC_CHIPID (*(volatile unsigned long *)0xFFFE2004)
#define RCPC_CHIPID_OFFSET 0x4

#define RCPC_REMAP (*(volatile unsigned long *)0xFFFE2008)
#define RCPC_REMAP_OFFSET 0x8

#define RCPC_SOFTRESET (*(volatile unsigned long *)0xFFFE200C)
#define RCPC_SOFTRESET_OFFSET 0xC

#define RCPC_RSTSTATUS (*(volatile unsigned long *)0xFFFE2010)
#define RCPC_RSTSTATUS_OFFSET 0x10

#define RCPC_STATUSCLR (*(volatile unsigned long *)0xFFFE2014)
#define RCPC_STATUSCLR_OFFSET 0x14

#define RCPC_SYSCLKPRE (*(volatile unsigned long *)0xFFFE2018)
#define RCPC_SYSCLKPRE_OFFSET 0x18

#define RCPC_CPUCLKPRE (*(volatile unsigned long *)0xFFFE201C)
#define RCPC_CPUCLKPRE_OFFSET 0x1C

#define RCPC_PCLKCTRL0 (*(volatile unsigned long *)0xFFFE2024)
#define RCPC_PCLKCTRL0_OFFSET 0x24

#define RCPC_PCLKCTRL1 (*(volatile unsigned long *)0xFFFE2028)
#define RCPC_PCLKCTRL1_OFFSET 0x28

#define RCPC_AHBCLKCTRL (*(volatile unsigned long *)0xFFFE202C)
#define RCPC_AHBCLKCTRL_OFFSET 0x2C

#define RCPC_PCLKSEL0 (*(volatile unsigned long *)0xFFFE2030)
#define RCPC_PCLKSEL0_OFFSET 0x30

#define RCPC_PCLKSEL2 (*(volatile unsigned long *)0xFFFE2034)
#define RCPC_PCLKSEL2_OFFSET 0x34

#define RCPC_LCDPRE (*(volatile unsigned long *)0xFFFE2040)
#define RCPC_LCDPRE_OFFSET 0x40

#define RCPC_SSPPRE (*(volatile unsigned long *)0xFFFE2044)
#define RCPC_SSPPRE_OFFSET 0x44

#define RCPC_ADCPRE (*(volatile unsigned long *)0xFFFE2048)
#define RCPC_ADCPRE_OFFSET 0x48

#define RCPC_USBPRE (*(volatile unsigned long *)0xFFFE204C)
#define RCPC_USBPRE_OFFSET 0x4C

#define RCPC_INTCONFIG (*(volatile unsigned long *)0xFFFE2080)
#define RCPC_INTCONFIG_OFFSET 0x80

#define RCPC_INTCLR (*(volatile unsigned long *)0xFFFE2084)
#define RCPC_INTCLR_OFFSET 0x84

#define RCPC_CORECONFIG (*(volatile unsigned long *)0xFFFE2088)
#define RCPC_CORECONFIG_OFFSET 0x88

#define RCPC_SYSPLLCNTL (*(volatile unsigned long *)0xFFFE20C0)
#define RCPC_SYSPLLCNTL_OFFSET 0xC0

#define RCPC_USBPLLCTL (*(volatile unsigned long *)0xFFFE20C4)
#define RCPC_USBPLLCTL_OFFSET 0xC4

#define WDT_BASE 0xFFFE3000

#define WDT_CTL (*(volatile unsigned long *)0xFFFE3000)
#define WDT_CTL_OFFSET 0x0

#define WDT_RST (*(volatile unsigned long *)0xFFFE3004)
#define WDT_RST_OFFSET 0x4

#define WDT_STATUS (*(volatile unsigned long *)0xFFFE3008)
#define WDT_STATUS_OFFSET 0x8

#define WDT_COUNT0 (*(volatile unsigned long *)0xFFFE300C)
#define WDT_COUNT0_OFFSET 0xC

#define WDT_COUNT1 (*(volatile unsigned long *)0xFFFE3010)
#define WDT_COUNT1_OFFSET 0x10

#define WDT_COUNT2 (*(volatile unsigned long *)0xFFFE3014)
#define WDT_COUNT2_OFFSET 0x14

#define WDT_COUNT3 (*(volatile unsigned long *)0xFFFE3018)
#define WDT_COUNT3_OFFSET 0x18

#define ALI_BASE 0xFFFE4000

#define ALI_ALISETUP (*(volatile unsigned long *)0xFFFE4000)
#define ALI_ALISETUP_OFFSET 0x0

#define ALI_ALICTRL (*(volatile unsigned long *)0xFFFE4004)
#define ALI_ALICTRL_OFFSET 0x4

#define ALI_ALITIMING1 (*(volatile unsigned long *)0xFFFE4008)
#define ALI_ALITIMING1_OFFSET 0x8

#define ALI_ALITIMING2 (*(volatile unsigned long *)0xFFFE400C)
#define ALI_ALITIMING2_OFFSET 0xC

#define IOCON_BASE 0xFFFE5000

#define IOCON_MUXCTL1 (*(volatile unsigned long *)0xFFFE5000)
#define IOCON_MUXCTL1_OFFSET 0x0

#define IOCON_RESCTL1 (*(volatile unsigned long *)0xFFFE5004)
#define IOCON_RESCTL1_OFFSET 0x4

#define IOCON_MUXCTL3 (*(volatile unsigned long *)0xFFFE5010)
#define IOCON_MUXCTL3_OFFSET 0x10

#define IOCON_RESCTL3 (*(volatile unsigned long *)0xFFFE5014)
#define IOCON_RESCTL3_OFFSET 0x14

#define IOCON_MUXCTL4 (*(volatile unsigned long *)0xFFFE5018)
#define IOCON_MUXCTL4_OFFSET 0x18

#define IOCON_RESCTL4 (*(volatile unsigned long *)0xFFFE501C)
#define IOCON_RESCTL4_OFFSET 0x1C

#define IOCON_MUXCTL5 (*(volatile unsigned long *)0xFFFE5020)
#define IOCON_MUXCTL5_OFFSET 0x20

#define IOCON_RESCTL5 (*(volatile unsigned long *)0xFFFE5024)
#define IOCON_RESCTL5_OFFSET 0x24

#define IOCON_MUXCTL6 (*(volatile unsigned long *)0xFFFE5028)
#define IOCON_MUXCTL6_OFFSET 0x28

#define IOCON_RESCTL6 (*(volatile unsigned long *)0xFFFE502C)
#define IOCON_RESCTL6_OFFSET 0x2C

#define IOCON_MUXCTL7 (*(volatile unsigned long *)0xFFFE5030)
#define IOCON_MUXCTL7_OFFSET 0x30

#define IOCON_RESCTL7 (*(volatile unsigned long *)0xFFFE5034)
#define IOCON_RESCTL7_OFFSET 0x34

#define IOCON_MUXCTL10 (*(volatile unsigned long *)0xFFFE5048)
#define IOCON_MUXCTL10_OFFSET 0x48

#define IOCON_RESCTL10 (*(volatile unsigned long *)0xFFFE504C)
#define IOCON_RESCTL10_OFFSET 0x4C

#define IOCON_MUXCTL11 (*(volatile unsigned long *)0xFFFE5050)
#define IOCON_MUXCTL11_OFFSET 0x50

#define IOCON_RESCTL11 (*(volatile unsigned long *)0xFFFE5054)
#define IOCON_RESCTL11_OFFSET 0x54

#define IOCON_MUXCTL12 (*(volatile unsigned long *)0xFFFE5058)
#define IOCON_MUXCTL12_OFFSET 0x58

#define IOCON_RESCTL12 (*(volatile unsigned long *)0xFFFE505C)
#define IOCON_RESCTL12_OFFSET 0x5C

#define IOCON_RESCTL13 (*(volatile unsigned long *)0xFFFE5064)
#define IOCON_RESCTL13_OFFSET 0x64

#define IOCON_MUXCTL14 (*(volatile unsigned long *)0xFFFE5068)
#define IOCON_MUXCTL14_OFFSET 0x68

#define IOCON_MUXCTL15 (*(volatile unsigned long *)0xFFFE5070)
#define IOCON_MUXCTL15_OFFSET 0x70

#define IOCON_RESCTL15 (*(volatile unsigned long *)0xFFFE5074)
#define IOCON_RESCTL15_OFFSET 0x74

#define IOCON_RESCTL17 (*(volatile unsigned long *)0xFFFE5084)
#define IOCON_RESCTL17_OFFSET 0x84

#define IOCON_MUXCTL19 (*(volatile unsigned long *)0xFFFE5090)
#define IOCON_MUXCTL19_OFFSET 0x90

#define IOCON_RESCTL19 (*(volatile unsigned long *)0xFFFE5094)
#define IOCON_RESCTL19_OFFSET 0x94

#define IOCON_MUXCTL20 (*(volatile unsigned long *)0xFFFE5098)
#define IOCON_MUXCTL20_OFFSET 0x98

#define IOCON_RESCTL20 (*(volatile unsigned long *)0xFFFE509C)
#define IOCON_RESCTL20_OFFSET 0x9C

#define IOCON_MUXCTL21 (*(volatile unsigned long *)0xFFFE50A0)
#define IOCON_MUXCTL21_OFFSET 0xA0

#define IOCON_RESCTL21 (*(volatile unsigned long *)0xFFFE50A4)
#define IOCON_RESCTL21_OFFSET 0xA4

#define IOCON_MUXCTL22 (*(volatile unsigned long *)0xFFFE50A8)
#define IOCON_MUXCTL22_OFFSET 0xA8

#define IOCON_RESCTL22 (*(volatile unsigned long *)0xFFFE50AC)
#define IOCON_RESCTL22_OFFSET 0xAC

#define IOCON_MUXCTL23 (*(volatile unsigned long *)0xFFFE50B0)
#define IOCON_MUXCTL23_OFFSET 0xB0

#define IOCON_RESCTL23 (*(volatile unsigned long *)0xFFFE50B4)
#define IOCON_RESCTL23_OFFSET 0xB4

#define IOCON_MUXCTL24 (*(volatile unsigned long *)0xFFFE50B8)
#define IOCON_MUXCTL24_OFFSET 0xB8

#define IOCON_RESCTL24 (*(volatile unsigned long *)0xFFFE50BC)
#define IOCON_RESCTL24_OFFSET 0xBC

#define IOCON_MUXCTL25 (*(volatile unsigned long *)0xFFFE50C0)
#define IOCON_MUXCTL25_OFFSET 0xC0

#define BOOT_BASE 0xFFFE6000

#define BOOT_PBC (*(volatile unsigned long *)0xFFFE6000)
#define BOOT_PBC_OFFSET 0x0

#define BOOT_CS1OV (*(volatile unsigned long *)0xFFFE6004)
#define BOOT_CS1OV_OFFSET 0x4

#define BOOT_EPM (*(volatile unsigned long *)0xFFFE6008)
#define BOOT_EPM_OFFSET 0x8

#define EMC_BASE 0xFFFF1000

#define EMC_CONTROL (*(volatile unsigned long *)0xFFFF1000)
#define EMC_CONTROL_OFFSET 0x0

#define EMC_STATUS (*(volatile unsigned long *)0xFFFF1004)
#define EMC_STATUS_OFFSET 0x4

#define EMC_CONFIG (*(volatile unsigned long *)0xFFFF1008)
#define EMC_CONFIG_OFFSET 0x8

#define EMC_DYNMCTRL (*(volatile unsigned long *)0xFFFF1020)
#define EMC_DYNMCTRL_OFFSET 0x20

#define EMC_DYNMREF (*(volatile unsigned long *)0xFFFF1024)
#define EMC_DYNMREF_OFFSET 0x24

#define EMC_PRECHARGE (*(volatile unsigned long *)0xFFFF1030)
#define EMC_PRECHARGE_OFFSET 0x30

#define EMC_DYNM2PRE (*(volatile unsigned long *)0xFFFF1034)
#define EMC_DYNM2PRE_OFFSET 0x34

#define EMC_REFEXIT (*(volatile unsigned long *)0xFFFF1038)
#define EMC_REFEXIT_OFFSET 0x38

#define EMC_DOACTIVE (*(volatile unsigned long *)0xFFFF103C)
#define EMC_DOACTIVE_OFFSET 0x3C

#define EMC_DIACTIVE (*(volatile unsigned long *)0xFFFF1040)
#define EMC_DIACTIVE_OFFSET 0x40

#define EMC_DWRT (*(volatile unsigned long *)0xFFFF1044)
#define EMC_DWRT_OFFSET 0x44

#define EMC_DYNACTCMD (*(volatile unsigned long *)0xFFFF1048)
#define EMC_DYNACTCMD_OFFSET 0x48

#define EMC_DYNAUTO (*(volatile unsigned long *)0xFFFF104C)
#define EMC_DYNAUTO_OFFSET 0x4C

#define EMC_DYNREFEXIT (*(volatile unsigned long *)0xFFFF1050)
#define EMC_DYNREFEXIT_OFFSET 0x50

#define EMC_DYNACTIVEAB (*(volatile unsigned long *)0xFFFF1054)
#define EMC_DYNACTIVEAB_OFFSET 0x54

#define EMC_DYNAMICMRD (*(volatile unsigned long *)0xFFFF1058)
#define EMC_DYNAMICMRD_OFFSET 0x58

#define EMC_WAIT (*(volatile unsigned long *)0xFFFF1080)
#define EMC_WAIT_OFFSET 0x80

#define EMC_DYNCFG0 (*(volatile unsigned long *)0xFFFF1100)
#define EMC_DYNCFG0_OFFSET 0x100

#define EMC_DYNRASCAS0 (*(volatile unsigned long *)0xFFFF1104)
#define EMC_DYNRASCAS0_OFFSET 0x104

#define EMC_DYNCFG1 (*(volatile unsigned long *)0xFFFF1120)
#define EMC_DYNCFG1_OFFSET 0x120

#define EMC_DYNRASCAS1 (*(volatile unsigned long *)0xFFFF1124)
#define EMC_DYNRASCAS1_OFFSET 0x124

#define EMC_SCONFIG0 (*(volatile unsigned long *)0xFFFF1200)
#define EMC_SCONFIG0_OFFSET 0x200

#define EMC_SWAITWEN0 (*(volatile unsigned long *)0xFFFF1204)
#define EMC_SWAITWEN0_OFFSET 0x204

#define EMC_SWAITOEN0 (*(volatile unsigned long *)0xFFFF1208)
#define EMC_SWAITOEN0_OFFSET 0x208

#define EMC_SWAITRD0 (*(volatile unsigned long *)0xFFFF120C)
#define EMC_SWAITRD0_OFFSET 0x20C

#define EMC_SWAITPAGE0 (*(volatile unsigned long *)0xFFFF1210)
#define EMC_SWAITPAGE0_OFFSET 0x210

#define EMC_SWAITWR0 (*(volatile unsigned long *)0xFFFF1214)
#define EMC_SWAITWR0_OFFSET 0x214

#define EMC_STURN0 (*(volatile unsigned long *)0xFFFF1218)
#define EMC_STURN0_OFFSET 0x218

#define EMC_SCONFIG1 (*(volatile unsigned long *)0xFFFF1220)
#define EMC_SCONFIG1_OFFSET 0x220

#define EMC_SWAITWEN1 (*(volatile unsigned long *)0xFFFF1224)
#define EMC_SWAITWEN1_OFFSET 0x224

#define EMC_SWAITOEN1 (*(volatile unsigned long *)0xFFFF1228)
#define EMC_SWAITOEN1_OFFSET 0x228

#define EMC_SWAITRD1 (*(volatile unsigned long *)0xFFFF122C)
#define EMC_SWAITRD1_OFFSET 0x22C

#define EMC_SWAITPAGE1 (*(volatile unsigned long *)0xFFFF1230)
#define EMC_SWAITPAGE1_OFFSET 0x230

#define EMC_SWAITWR1 (*(volatile unsigned long *)0xFFFF1234)
#define EMC_SWAITWR1_OFFSET 0x234

#define EMC_STURN1 (*(volatile unsigned long *)0xFFFF1238)
#define EMC_STURN1_OFFSET 0x238

#define EMC_SCONFIG2 (*(volatile unsigned long *)0xFFFF1240)
#define EMC_SCONFIG2_OFFSET 0x240

#define EMC_SWAITWEN2 (*(volatile unsigned long *)0xFFFF1244)
#define EMC_SWAITWEN2_OFFSET 0x244

#define EMC_SWAITOEN2 (*(volatile unsigned long *)0xFFFF1248)
#define EMC_SWAITOEN2_OFFSET 0x248

#define EMC_SWAITRD2 (*(volatile unsigned long *)0xFFFF124C)
#define EMC_SWAITRD2_OFFSET 0x24C

#define EMC_SWAITPAGE2 (*(volatile unsigned long *)0xFFFF1250)
#define EMC_SWAITPAGE2_OFFSET 0x250

#define EMC_SWAITWR2 (*(volatile unsigned long *)0xFFFF1254)
#define EMC_SWAITWR2_OFFSET 0x254

#define EMC_STURN2 (*(volatile unsigned long *)0xFFFF1258)
#define EMC_STURN2_OFFSET 0x258

#define EMC_SCONFIG3 (*(volatile unsigned long *)0xFFFF1260)
#define EMC_SCONFIG3_OFFSET 0x260

#define EMC_SWAITWEN3 (*(volatile unsigned long *)0xFFFF1264)
#define EMC_SWAITWEN3_OFFSET 0x264

#define EMC_SWAITOEN3 (*(volatile unsigned long *)0xFFFF1268)
#define EMC_SWAITOEN3_OFFSET 0x268

#define EMC_SWAITRD3 (*(volatile unsigned long *)0xFFFF126C)
#define EMC_SWAITRD3_OFFSET 0x26C

#define EMC_SWAITPAGE3 (*(volatile unsigned long *)0xFFFF1270)
#define EMC_SWAITPAGE3_OFFSET 0x270

#define EMC_SWAITWR3 (*(volatile unsigned long *)0xFFFF1274)
#define EMC_SWAITWR3_OFFSET 0x274

#define EMC_STURN3 (*(volatile unsigned long *)0xFFFF1278)
#define EMC_STURN3_OFFSET 0x278

#define CLCDC_BASE 0xFFFF4000

#define CLCDC_TIMING0 (*(volatile unsigned long *)0xFFFF4000)
#define CLCDC_TIMING0_OFFSET 0x0

#define CLCDC_TIMING1 (*(volatile unsigned long *)0xFFFF4004)
#define CLCDC_TIMING1_OFFSET 0x4

#define CLCDC_TIMING2 (*(volatile unsigned long *)0xFFFF4008)
#define CLCDC_TIMING2_OFFSET 0x8

#define CLCDC_UPBASE (*(volatile unsigned long *)0xFFFF4010)
#define CLCDC_UPBASE_OFFSET 0x10

#define CLCDC_LPBASE (*(volatile unsigned long *)0xFFFF4014)
#define CLCDC_LPBASE_OFFSET 0x14

#define CLCDC_INTREN (*(volatile unsigned long *)0xFFFF4018)
#define CLCDC_INTREN_OFFSET 0x18

#define CLCDC_CTRL (*(volatile unsigned long *)0xFFFF401C)
#define CLCDC_CTRL_OFFSET 0x1C

#define CLCDC_STATUS (*(volatile unsigned long *)0xFFFF4020)
#define CLCDC_STATUS_OFFSET 0x20

#define CLCDC_INTERRUPT (*(volatile unsigned long *)0xFFFF4024)
#define CLCDC_INTERRUPT_OFFSET 0x24

#define CLCDC_UPCURR (*(volatile unsigned long *)0xFFFF4028)
#define CLCDC_UPCURR_OFFSET 0x28

#define CLCDC_LPCURR (*(volatile unsigned long *)0xFFFF402C)
#define CLCDC_LPCURR_OFFSET 0x2C

#define USB_BASE 0xFFFF5000

#define USB_FAR (*(volatile unsigned long *)0xFFFF5000)
#define USB_FAR_OFFSET 0x0

#define USB_PMR (*(volatile unsigned long *)0xFFFF5004)
#define USB_PMR_OFFSET 0x4

#define USB_IIR (*(volatile unsigned long *)0xFFFF5008)
#define USB_IIR_OFFSET 0x8

#define USB_OIR (*(volatile unsigned long *)0xFFFF5010)
#define USB_OIR_OFFSET 0x10

#define USB_UIR (*(volatile unsigned long *)0xFFFF5018)
#define USB_UIR_OFFSET 0x18

#define USB_IIE (*(volatile unsigned long *)0xFFFF501C)
#define USB_IIE_OFFSET 0x1C

#define USB_OIE (*(volatile unsigned long *)0xFFFF5024)
#define USB_OIE_OFFSET 0x24

#define USB_UIE (*(volatile unsigned long *)0xFFFF502C)
#define USB_UIE_OFFSET 0x2C

#define USB_FRAME1 (*(volatile unsigned long *)0xFFFF5030)
#define USB_FRAME1_OFFSET 0x30

#define USB_FRAME2 (*(volatile unsigned long *)0xFFFF5034)
#define USB_FRAME2_OFFSET 0x34

#define USB_INDEX (*(volatile unsigned long *)0xFFFF5038)
#define USB_INDEX_OFFSET 0x38

#define USB_INMAXP (*(volatile unsigned long *)0xFFFF5040)
#define USB_INMAXP_OFFSET 0x40

#define USB_CSR0 (*(volatile unsigned long *)0xFFFF5044)
#define USB_CSR0_OFFSET 0x44

#define USB_INCSR1 (*(volatile unsigned long *)0xFFFF5044)
#define USB_INCSR1_OFFSET 0x44

#define USB_INCSR2 (*(volatile unsigned long *)0xFFFF5048)
#define USB_INCSR2_OFFSET 0x48

#define USB_OUTMAXP (*(volatile unsigned long *)0xFFFF504C)
#define USB_OUTMAXP_OFFSET 0x4C

#define USB_OUTCSR1 (*(volatile unsigned long *)0xFFFF5050)
#define USB_OUTCSR1_OFFSET 0x50

#define USB_OUTCSR2 (*(volatile unsigned long *)0xFFFF5054)
#define USB_OUTCSR2_OFFSET 0x54

#define USB_OUTCOUNT0 (*(volatile unsigned long *)0xFFFF5058)
#define USB_OUTCOUNT0_OFFSET 0x58

#define USB_OUTCOUNT1 (*(volatile unsigned long *)0xFFFF5058)
#define USB_OUTCOUNT1_OFFSET 0x58

#define USB_OUTCOUNT2 (*(volatile unsigned long *)0xFFFF505C)
#define USB_OUTCOUNT2_OFFSET 0x5C

#define USB_EP0FIFO (*(volatile unsigned long *)0xFFFF5080)
#define USB_EP0FIFO_OFFSET 0x80

#define USB_EP1FIFO (*(volatile unsigned long *)0xFFFF5090)
#define USB_EP1FIFO_OFFSET 0x90

#define USB_EP2FIFO (*(volatile unsigned long *)0xFFFF50A0)
#define USB_EP2FIFO_OFFSET 0xA0

#define USB_EP3FIFO (*(volatile unsigned long *)0xFFFF50B0)
#define USB_EP3FIFO_OFFSET 0xB0

#define USB_INTR (*(volatile unsigned long *)0xFFFF5200)
#define USB_INTR_OFFSET 0x200

#define USB_CNTL1 (*(volatile unsigned long *)0xFFFF5204)
#define USB_CNTL1_OFFSET 0x204

#define USB_ADDR1 (*(volatile unsigned long *)0xFFFF5208)
#define USB_ADDR1_OFFSET 0x208

#define USB_COUNT1 (*(volatile unsigned long *)0xFFFF520C)
#define USB_COUNT1_OFFSET 0x20C

#define USB_CNTL2 (*(volatile unsigned long *)0xFFFF5214)
#define USB_CNTL2_OFFSET 0x214

#define USB_ADDR2 (*(volatile unsigned long *)0xFFFF5218)
#define USB_ADDR2_OFFSET 0x218

#define USB_COUNT2 (*(volatile unsigned long *)0xFFFF521C)
#define USB_COUNT2_OFFSET 0x21C

#define USB_CNTL3 (*(volatile unsigned long *)0xFFFF5224)
#define USB_CNTL3_OFFSET 0x224

#define USB_ADDR3 (*(volatile unsigned long *)0xFFFF5228)
#define USB_ADDR3_OFFSET 0x228

#define USB_COUNT3 (*(volatile unsigned long *)0xFFFF522C)
#define USB_COUNT3_OFFSET 0x22C

#define USB_CNTL4 (*(volatile unsigned long *)0xFFFF5234)
#define USB_CNTL4_OFFSET 0x234

#define USB_ADDR4 (*(volatile unsigned long *)0xFFFF5238)
#define USB_ADDR4_OFFSET 0x238

#define USB_COUNT4 (*(volatile unsigned long *)0xFFFF523C)
#define USB_COUNT4_OFFSET 0x23C

#define USB_CNTL5 (*(volatile unsigned long *)0xFFFF5244)
#define USB_CNTL5_OFFSET 0x244

#define USB_ADDR5 (*(volatile unsigned long *)0xFFFF5248)
#define USB_ADDR5_OFFSET 0x248

#define USB_COUNT5 (*(volatile unsigned long *)0xFFFF524C)
#define USB_COUNT5_OFFSET 0x24C

#define USB_CNTL6 (*(volatile unsigned long *)0xFFFF5254)
#define USB_CNTL6_OFFSET 0x254

#define USB_ADDR6 (*(volatile unsigned long *)0xFFFF5258)
#define USB_ADDR6_OFFSET 0x258

#define USB_COUNT6 (*(volatile unsigned long *)0xFFFF525C)
#define USB_COUNT6_OFFSET 0x25C

#define VIC_BASE 0xFFFFF000

#define VIC_IRQSTATUS (*(volatile unsigned long *)0xFFFFF000)
#define VIC_IRQSTATUS_OFFSET 0x0

#define VIC_FIQSTATUS (*(volatile unsigned long *)0xFFFFF004)
#define VIC_FIQSTATUS_OFFSET 0x4

#define VIC_RAWINTR (*(volatile unsigned long *)0xFFFFF008)
#define VIC_RAWINTR_OFFSET 0x8

#define VIC_INTSELECT (*(volatile unsigned long *)0xFFFFF00C)
#define VIC_INTSELECT_OFFSET 0xC

#define VIC_INTENABLE (*(volatile unsigned long *)0xFFFFF010)
#define VIC_INTENABLE_OFFSET 0x10

#define VIC_INTENCLEAR (*(volatile unsigned long *)0xFFFFF014)
#define VIC_INTENCLEAR_OFFSET 0x14

#define VIC_SOFTINT (*(volatile unsigned long *)0xFFFFF018)
#define VIC_SOFTINT_OFFSET 0x18

#define VIC_SOFTINT_CLEAR (*(volatile unsigned long *)0xFFFFF01C)
#define VIC_SOFTINT_CLEAR_OFFSET 0x1C

#define VIC_VECTADDR (*(volatile unsigned long *)0xFFFFF030)
#define VIC_VECTADDR_OFFSET 0x30

#define VIC_DEFVECTADDR (*(volatile unsigned long *)0xFFFFF034)
#define VIC_DEFVECTADDR_OFFSET 0x34

#define VIC_VECTADDR0 (*(volatile unsigned long *)0xFFFFF100)
#define VIC_VECTADDR0_OFFSET 0x100

#define VIC_VECTADDR1 (*(volatile unsigned long *)0xFFFFF104)
#define VIC_VECTADDR1_OFFSET 0x104

#define VIC_VECTADDR2 (*(volatile unsigned long *)0xFFFFF108)
#define VIC_VECTADDR2_OFFSET 0x108

#define VIC_VECTADDR3 (*(volatile unsigned long *)0xFFFFF10C)
#define VIC_VECTADDR3_OFFSET 0x10C

#define VIC_VECTADDR4 (*(volatile unsigned long *)0xFFFFF110)
#define VIC_VECTADDR4_OFFSET 0x110

#define VIC_VECTADDR5 (*(volatile unsigned long *)0xFFFFF114)
#define VIC_VECTADDR5_OFFSET 0x114

#define VIC_VECTADDR6 (*(volatile unsigned long *)0xFFFFF118)
#define VIC_VECTADDR6_OFFSET 0x118

#define VIC_VECTADDR7 (*(volatile unsigned long *)0xFFFFF11C)
#define VIC_VECTADDR7_OFFSET 0x11C

#define VIC_VECTADDR8 (*(volatile unsigned long *)0xFFFFF120)
#define VIC_VECTADDR8_OFFSET 0x120

#define VIC_VECTADDR9 (*(volatile unsigned long *)0xFFFFF124)
#define VIC_VECTADDR9_OFFSET 0x124

#define VIC_VECTADDR10 (*(volatile unsigned long *)0xFFFFF128)
#define VIC_VECTADDR10_OFFSET 0x128

#define VIC_VECTADDR11 (*(volatile unsigned long *)0xFFFFF12C)
#define VIC_VECTADDR11_OFFSET 0x12C

#define VIC_VECTADDR12 (*(volatile unsigned long *)0xFFFFF130)
#define VIC_VECTADDR12_OFFSET 0x130

#define VIC_VECTADDR13 (*(volatile unsigned long *)0xFFFFF134)
#define VIC_VECTADDR13_OFFSET 0x134

#define VIC_VECTADDR14 (*(volatile unsigned long *)0xFFFFF138)
#define VIC_VECTADDR14_OFFSET 0x138

#define VIC_VECTADDR15 (*(volatile unsigned long *)0xFFFFF13C)
#define VIC_VECTADDR15_OFFSET 0x13C

#define VIC_VECTCTRL0 (*(volatile unsigned long *)0xFFFFF200)
#define VIC_VECTCTRL0_OFFSET 0x200

#define VIC_VECTCTRL1 (*(volatile unsigned long *)0xFFFFF204)
#define VIC_VECTCTRL1_OFFSET 0x204

#define VIC_VECTCTRL2 (*(volatile unsigned long *)0xFFFFF208)
#define VIC_VECTCTRL2_OFFSET 0x208

#define VIC_VECTCTRL3 (*(volatile unsigned long *)0xFFFFF20C)
#define VIC_VECTCTRL3_OFFSET 0x20C

#define VIC_VECTCTRL4 (*(volatile unsigned long *)0xFFFFF210)
#define VIC_VECTCTRL4_OFFSET 0x210

#define VIC_VECTCTRL5 (*(volatile unsigned long *)0xFFFFF214)
#define VIC_VECTCTRL5_OFFSET 0x214

#define VIC_VECTCTRL6 (*(volatile unsigned long *)0xFFFFF218)
#define VIC_VECTCTRL6_OFFSET 0x218

#define VIC_VECTCTRL7 (*(volatile unsigned long *)0xFFFFF21C)
#define VIC_VECTCTRL7_OFFSET 0x21C

#define VIC_VECTCTRL8 (*(volatile unsigned long *)0xFFFFF220)
#define VIC_VECTCTRL8_OFFSET 0x220

#define VIC_VECTCTRL9 (*(volatile unsigned long *)0xFFFFF224)
#define VIC_VECTCTRL9_OFFSET 0x224

#define VIC_VECTCTRL10 (*(volatile unsigned long *)0xFFFFF228)
#define VIC_VECTCTRL10_OFFSET 0x228

#define VIC_VECTCTRL11 (*(volatile unsigned long *)0xFFFFF22C)
#define VIC_VECTCTRL11_OFFSET 0x22C

#define VIC_VECTCTRL12 (*(volatile unsigned long *)0xFFFFF230)
#define VIC_VECTCTRL12_OFFSET 0x230

#define VIC_VECTCTRL13 (*(volatile unsigned long *)0xFFFFF234)
#define VIC_VECTCTRL13_OFFSET 0x234

#define VIC_VECTCTRL14 (*(volatile unsigned long *)0xFFFFF238)
#define VIC_VECTCTRL14_OFFSET 0x238

#define VIC_VECTCTRL15 (*(volatile unsigned long *)0xFFFFF23C)
#define VIC_VECTCTRL15_OFFSET 0x23C

#define VIC_ITOP (*(volatile unsigned long *)0xFFFFF30C)
#define VIC_ITOP_OFFSET 0x30C


#endif
