// LH754xx register and bit definitions.
//
// Copyright (c) 2005 Rowley Associates Limited.
//
// This file may be distributed under the terms of the License Agreement
// provided with this software.
//
// THIS FILE IS PROVIDED AS IS WITH NO WARRANTY OF ANY KIND, INCLUDING THE
// WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.

#ifndef LH754xx_h
#define LH754xx_h

#define UART0_BASE 0xFFFC0000

#define UART0_DR (*(volatile unsigned long *)0xFFFC0000)
#define UART0_DR_OFFSET 0x0

#define UART0_RSR (*(volatile unsigned long *)0xFFFC0004)
#define UART0_RSR_OFFSET 0x4
#define UART0_RSR_FRAMING_ERROR_MASK 0x1U
#define UART0_RSR_FRAMING_ERROR 0x1U
#define UART0_RSR_FRAMING_ERROR_BIT 0
#define UART0_RSR_PARITY_ERROR_MASK 0x2U
#define UART0_RSR_PARITY_ERROR 0x2U
#define UART0_RSR_PARITY_ERROR_BIT 1
#define UART0_RSR_BREAK_ERROR_MASK 0x4U
#define UART0_RSR_BREAK_ERROR 0x4U
#define UART0_RSR_BREAK_ERROR_BIT 2
#define UART0_RSR_OVERRUN_ERROR_MASK 0x8U
#define UART0_RSR_OVERRUN_ERROR 0x8U
#define UART0_RSR_OVERRUN_ERROR_BIT 3

#define UART0_ECR (*(volatile unsigned long *)0xFFFC0004)
#define UART0_ECR_OFFSET 0x4

#define UART0_FR (*(volatile unsigned long *)0xFFFC0018)
#define UART0_FR_OFFSET 0x18
#define UART0_FR_UART_BUSY_MASK 0x8U
#define UART0_FR_UART_BUSY 0x8U
#define UART0_FR_UART_BUSY_BIT 3
#define UART0_FR_RECEIVE_FIFO_EMPTY_MASK 0x10U
#define UART0_FR_RECEIVE_FIFO_EMPTY 0x10U
#define UART0_FR_RECEIVE_FIFO_EMPTY_BIT 4
#define UART0_FR_TRANSMIT_FIFO_FULL_MASK 0x20U
#define UART0_FR_TRANSMIT_FIFO_FULL 0x20U
#define UART0_FR_TRANSMIT_FIFO_FULL_BIT 5
#define UART0_FR_RECEIVE_FIFO_FULL_MASK 0x40U
#define UART0_FR_RECEIVE_FIFO_FULL 0x40U
#define UART0_FR_RECEIVE_FIFO_FULL_BIT 6
#define UART0_FR_TRANSMIT_FIFO_EMPTY_MASK 0x80U
#define UART0_FR_TRANSMIT_FIFO_EMPTY 0x80U
#define UART0_FR_TRANSMIT_FIFO_EMPTY_BIT 7

#define UART0_IBRD (*(volatile unsigned long *)0xFFFC0024)
#define UART0_IBRD_OFFSET 0x24

#define UART0_FBRD (*(volatile unsigned long *)0xFFFC0028)
#define UART0_FBRD_OFFSET 0x28

#define UART0_LCR_H (*(volatile unsigned long *)0xFFFC002C)
#define UART0_LCR_H_OFFSET 0x2C
#define UART0_LCR_H_SEND_BREAK_MASK 0x1U
#define UART0_LCR_H_SEND_BREAK 0x1U
#define UART0_LCR_H_SEND_BREAK_BIT 0
#define UART0_LCR_H_PARITY_ENABLE_MASK 0x2U
#define UART0_LCR_H_PARITY_ENABLE 0x2U
#define UART0_LCR_H_PARITY_ENABLE_BIT 1
#define UART0_LCR_H_EVEN_PARITY_SELECT_MASK 0x4U
#define UART0_LCR_H_EVEN_PARITY_SELECT 0x4U
#define UART0_LCR_H_EVEN_PARITY_SELECT_BIT 2
#define UART0_LCR_H_TWO_STOP_BITS_SELECT_MASK 0x8U
#define UART0_LCR_H_TWO_STOP_BITS_SELECT 0x8U
#define UART0_LCR_H_TWO_STOP_BITS_SELECT_BIT 3
#define UART0_LCR_H_ENABLE_FIFOS_MASK 0x10U
#define UART0_LCR_H_ENABLE_FIFOS 0x10U
#define UART0_LCR_H_ENABLE_FIFOS_BIT 4
#define UART0_LCR_H_WORDLENGTH_MASK 0x60U
#define UART0_LCR_H_WORDLENGTH_BIT 5
#define UART0_LCR_H_STICK_PARITY_SELECT_MASK 0x40U
#define UART0_LCR_H_STICK_PARITY_SELECT 0x40U
#define UART0_LCR_H_STICK_PARITY_SELECT_BIT 6

#define UART0_CTRL (*(volatile unsigned long *)0xFFFC0030)
#define UART0_CTRL_OFFSET 0x30
#define UART0_CTRL_UART_ENABLE_MASK 0x1U
#define UART0_CTRL_UART_ENABLE 0x1U
#define UART0_CTRL_UART_ENABLE_BIT 0
#define UART0_CTRL_LC_MASK 0x80U
#define UART0_CTRL_LC 0x80U
#define UART0_CTRL_LC_BIT 7
#define UART0_CTRL_TRANSMIT_ENABLE_MASK 0x100U
#define UART0_CTRL_TRANSMIT_ENABLE 0x100U
#define UART0_CTRL_TRANSMIT_ENABLE_BIT 8
#define UART0_CTRL_RECEIVE_ENABLE_MASK 0x200U
#define UART0_CTRL_RECEIVE_ENABLE 0x200U
#define UART0_CTRL_RECEIVE_ENABLE_BIT 9

#define UART0_IFLS (*(volatile unsigned long *)0xFFFC0034)
#define UART0_IFLS_OFFSET 0x34
#define UART0_IFLS_RECEIVE_INTERRUPT_FIFO_LEVEL_SELECT_MASK 0x38U
#define UART0_IFLS_RECEIVE_INTERRUPT_FIFO_LEVEL_SELECT_BIT 3

#define UART0_IMSC (*(volatile unsigned long *)0xFFFC0038)
#define UART0_IMSC_OFFSET 0x38
#define UART0_IMSC_RXIM_MASK 0x10U
#define UART0_IMSC_RXIM 0x10U
#define UART0_IMSC_RXIM_BIT 4
#define UART0_IMSC_TXIM_MASK 0x20U
#define UART0_IMSC_TXIM 0x20U
#define UART0_IMSC_TXIM_BIT 5
#define UART0_IMSC_RTIM_MASK 0x40U
#define UART0_IMSC_RTIM 0x40U
#define UART0_IMSC_RTIM_BIT 6
#define UART0_IMSC_FEIM_MASK 0x80U
#define UART0_IMSC_FEIM 0x80U
#define UART0_IMSC_FEIM_BIT 7
#define UART0_IMSC_PEIM_MASK 0x100U
#define UART0_IMSC_PEIM 0x100U
#define UART0_IMSC_PEIM_BIT 8
#define UART0_IMSC_BEIM_MASK 0x200U
#define UART0_IMSC_BEIM 0x200U
#define UART0_IMSC_BEIM_BIT 9
#define UART0_IMSC_OEIM_MASK 0x400U
#define UART0_IMSC_OEIM 0x400U
#define UART0_IMSC_OEIM_BIT 10

#define UART0_RIS (*(volatile unsigned long *)0xFFFC003C)
#define UART0_RIS_OFFSET 0x3C
#define UART0_RIS_RECEIVE_INTERRUPT_STATUS_MASK 0x10U
#define UART0_RIS_RECEIVE_INTERRUPT_STATUS 0x10U
#define UART0_RIS_RECEIVE_INTERRUPT_STATUS_BIT 4
#define UART0_RIS_TRANSMIT_INTERRUPT_STATUS_MASK 0x20U
#define UART0_RIS_TRANSMIT_INTERRUPT_STATUS 0x20U
#define UART0_RIS_TRANSMIT_INTERRUPT_STATUS_BIT 5
#define UART0_RIS_RECEIVE_TIMEOUT_INTERRUPT_STATUS_MASK 0x40U
#define UART0_RIS_RECEIVE_TIMEOUT_INTERRUPT_STATUS 0x40U
#define UART0_RIS_RECEIVE_TIMEOUT_INTERRUPT_STATUS_BIT 6
#define UART0_RIS_FRAMING_ERROR_INTERRUPT_STATUS_MASK 0x80U
#define UART0_RIS_FRAMING_ERROR_INTERRUPT_STATUS 0x80U
#define UART0_RIS_FRAMING_ERROR_INTERRUPT_STATUS_BIT 7
#define UART0_RIS_PARITY_ERROR_INTERRUPT_STATUS_MASK 0x100U
#define UART0_RIS_PARITY_ERROR_INTERRUPT_STATUS 0x100U
#define UART0_RIS_PARITY_ERROR_INTERRUPT_STATUS_BIT 8
#define UART0_RIS_BREAK_ERROR_INTERRUPT_STATUS_MASK 0x200U
#define UART0_RIS_BREAK_ERROR_INTERRUPT_STATUS 0x200U
#define UART0_RIS_BREAK_ERROR_INTERRUPT_STATUS_BIT 9
#define UART0_RIS_OVERRUN_ERROR_INTERRUPT_STATUS_MASK 0x400U
#define UART0_RIS_OVERRUN_ERROR_INTERRUPT_STATUS 0x400U
#define UART0_RIS_OVERRUN_ERROR_INTERRUPT_STATUS_BIT 10

#define UART0_MIS (*(volatile unsigned long *)0xFFFC0040)
#define UART0_MIS_OFFSET 0x40
#define UART0_MIS_RECEIVE_MASKED_INTERRUPT_STATUS_MASK 0x10U
#define UART0_MIS_RECEIVE_MASKED_INTERRUPT_STATUS 0x10U
#define UART0_MIS_RECEIVE_MASKED_INTERRUPT_STATUS_BIT 4
#define UART0_MIS_TRANSMIT_MASKED_INTERRUPT_STATUS_MASK 0x20U
#define UART0_MIS_TRANSMIT_MASKED_INTERRUPT_STATUS 0x20U
#define UART0_MIS_TRANSMIT_MASKED_INTERRUPT_STATUS_BIT 5
#define UART0_MIS_RECEIVE_TIMEOUT_MASKED_INTERRUPT_STATUS_MASK 0x40U
#define UART0_MIS_RECEIVE_TIMEOUT_MASKED_INTERRUPT_STATUS 0x40U
#define UART0_MIS_RECEIVE_TIMEOUT_MASKED_INTERRUPT_STATUS_BIT 6
#define UART0_MIS_FRAMING_ERROR_MASKED_INTERRUPT_STATUS_MASK 0x80U
#define UART0_MIS_FRAMING_ERROR_MASKED_INTERRUPT_STATUS 0x80U
#define UART0_MIS_FRAMING_ERROR_MASKED_INTERRUPT_STATUS_BIT 7
#define UART0_MIS_PARITY_ERROR_MASKED_INTERRUPT_STATUS_MASK 0x100U
#define UART0_MIS_PARITY_ERROR_MASKED_INTERRUPT_STATUS 0x100U
#define UART0_MIS_PARITY_ERROR_MASKED_INTERRUPT_STATUS_BIT 8
#define UART0_MIS_BREAK_ERROR_MASKED_INTERRUPT_STATUS_MASK 0x200U
#define UART0_MIS_BREAK_ERROR_MASKED_INTERRUPT_STATUS 0x200U
#define UART0_MIS_BREAK_ERROR_MASKED_INTERRUPT_STATUS_BIT 9
#define UART0_MIS_OVERRUN_ERROR_MASKED_INTERRUPT_STATUS_MASK 0x400U
#define UART0_MIS_OVERRUN_ERROR_MASKED_INTERRUPT_STATUS 0x400U
#define UART0_MIS_OVERRUN_ERROR_MASKED_INTERRUPT_STATUS_BIT 10

#define UART0_ICR (*(volatile unsigned long *)0xFFFC0044)
#define UART0_ICR_OFFSET 0x44
#define UART0_ICR_RECEIVE_INTERRUPT_CLEAR_MASK 0x10U
#define UART0_ICR_RECEIVE_INTERRUPT_CLEAR 0x10U
#define UART0_ICR_RECEIVE_INTERRUPT_CLEAR_BIT 4
#define UART0_ICR_TRANSMIT_INTERRUPT_CLEAR_MASK 0x20U
#define UART0_ICR_TRANSMIT_INTERRUPT_CLEAR 0x20U
#define UART0_ICR_TRANSMIT_INTERRUPT_CLEAR_BIT 5
#define UART0_ICR_RECEIVE_TIMEOUT_INTERRUPT_CLEAR_MASK 0x40U
#define UART0_ICR_RECEIVE_TIMEOUT_INTERRUPT_CLEAR 0x40U
#define UART0_ICR_RECEIVE_TIMEOUT_INTERRUPT_CLEAR_BIT 6
#define UART0_ICR_FRAMING_ERROR_INTERRUPT_CLEAR_MASK 0x80U
#define UART0_ICR_FRAMING_ERROR_INTERRUPT_CLEAR 0x80U
#define UART0_ICR_FRAMING_ERROR_INTERRUPT_CLEAR_BIT 7
#define UART0_ICR_PARITY_ERROR_INTERRUPT_CLEAR_MASK 0x100U
#define UART0_ICR_PARITY_ERROR_INTERRUPT_CLEAR 0x100U
#define UART0_ICR_PARITY_ERROR_INTERRUPT_CLEAR_BIT 8
#define UART0_ICR_BREAK_ERROR_INTERRUPT_CLEAR_MASK 0x200U
#define UART0_ICR_BREAK_ERROR_INTERRUPT_CLEAR 0x200U
#define UART0_ICR_BREAK_ERROR_INTERRUPT_CLEAR_BIT 9
#define UART0_ICR_OVERRUN_ERROR_INTERRUPT_CLEAR_MASK 0x400U
#define UART0_ICR_OVERRUN_ERROR_INTERRUPT_CLEAR 0x400U
#define UART0_ICR_OVERRUN_ERROR_INTERRUPT_CLEAR_BIT 10

#define UART0_DMACTRL (*(volatile unsigned long *)0xFFFC0048)
#define UART0_DMACTRL_OFFSET 0x48
#define UART0_DMACTRL_RECEIVE_DMA_ENABLE_MASK 0x1U
#define UART0_DMACTRL_RECEIVE_DMA_ENABLE 0x1U
#define UART0_DMACTRL_RECEIVE_DMA_ENABLE_BIT 0
#define UART0_DMACTRL_TRANSMIT_DMA_ENABLE_MASK 0x2U
#define UART0_DMACTRL_TRANSMIT_DMA_ENABLE 0x2U
#define UART0_DMACTRL_TRANSMIT_DMA_ENABLE_BIT 1
#define UART0_DMACTRL_DMA_ON_ERROR_MASK 0x4U
#define UART0_DMACTRL_DMA_ON_ERROR 0x4U
#define UART0_DMACTRL_DMA_ON_ERROR_BIT 2

#define UART1_BASE 0xFFFC1000

#define UART1_DR (*(volatile unsigned long *)0xFFFC1000)
#define UART1_DR_OFFSET 0x0

#define UART1_RSR (*(volatile unsigned long *)0xFFFC1004)
#define UART1_RSR_OFFSET 0x4
#define UART1_RSR_FRAMING_ERROR_MASK 0x1U
#define UART1_RSR_FRAMING_ERROR 0x1U
#define UART1_RSR_FRAMING_ERROR_BIT 0
#define UART1_RSR_PARITY_ERROR_MASK 0x2U
#define UART1_RSR_PARITY_ERROR 0x2U
#define UART1_RSR_PARITY_ERROR_BIT 1
#define UART1_RSR_BREAK_ERROR_MASK 0x4U
#define UART1_RSR_BREAK_ERROR 0x4U
#define UART1_RSR_BREAK_ERROR_BIT 2
#define UART1_RSR_OVERRUN_ERROR_MASK 0x8U
#define UART1_RSR_OVERRUN_ERROR 0x8U
#define UART1_RSR_OVERRUN_ERROR_BIT 3

#define UART1_ECR (*(volatile unsigned long *)0xFFFC1004)
#define UART1_ECR_OFFSET 0x4

#define UART1_FR (*(volatile unsigned long *)0xFFFC1018)
#define UART1_FR_OFFSET 0x18
#define UART1_FR_UART_BUSY_MASK 0x8U
#define UART1_FR_UART_BUSY 0x8U
#define UART1_FR_UART_BUSY_BIT 3
#define UART1_FR_RECEIVE_FIFO_EMPTY_MASK 0x10U
#define UART1_FR_RECEIVE_FIFO_EMPTY 0x10U
#define UART1_FR_RECEIVE_FIFO_EMPTY_BIT 4
#define UART1_FR_TRANSMIT_FIFO_FULL_MASK 0x20U
#define UART1_FR_TRANSMIT_FIFO_FULL 0x20U
#define UART1_FR_TRANSMIT_FIFO_FULL_BIT 5
#define UART1_FR_RECEIVE_FIFO_FULL_MASK 0x40U
#define UART1_FR_RECEIVE_FIFO_FULL 0x40U
#define UART1_FR_RECEIVE_FIFO_FULL_BIT 6
#define UART1_FR_TRANSMIT_FIFO_EMPTY_MASK 0x80U
#define UART1_FR_TRANSMIT_FIFO_EMPTY 0x80U
#define UART1_FR_TRANSMIT_FIFO_EMPTY_BIT 7

#define UART1_IBRD (*(volatile unsigned long *)0xFFFC1024)
#define UART1_IBRD_OFFSET 0x24

#define UART1_FBRD (*(volatile unsigned long *)0xFFFC1028)
#define UART1_FBRD_OFFSET 0x28

#define UART1_LCR_H (*(volatile unsigned long *)0xFFFC102C)
#define UART1_LCR_H_OFFSET 0x2C
#define UART1_LCR_H_SEND_BREAK_MASK 0x1U
#define UART1_LCR_H_SEND_BREAK 0x1U
#define UART1_LCR_H_SEND_BREAK_BIT 0
#define UART1_LCR_H_PARITY_ENABLE_MASK 0x2U
#define UART1_LCR_H_PARITY_ENABLE 0x2U
#define UART1_LCR_H_PARITY_ENABLE_BIT 1
#define UART1_LCR_H_EVEN_PARITY_SELECT_MASK 0x4U
#define UART1_LCR_H_EVEN_PARITY_SELECT 0x4U
#define UART1_LCR_H_EVEN_PARITY_SELECT_BIT 2
#define UART1_LCR_H_TWO_STOP_BITS_SELECT_MASK 0x8U
#define UART1_LCR_H_TWO_STOP_BITS_SELECT 0x8U
#define UART1_LCR_H_TWO_STOP_BITS_SELECT_BIT 3
#define UART1_LCR_H_ENABLE_FIFOS_MASK 0x10U
#define UART1_LCR_H_ENABLE_FIFOS 0x10U
#define UART1_LCR_H_ENABLE_FIFOS_BIT 4
#define UART1_LCR_H_WORDLENGTH_MASK 0x60U
#define UART1_LCR_H_WORDLENGTH_BIT 5
#define UART1_LCR_H_STICK_PARITY_SELECT_MASK 0x40U
#define UART1_LCR_H_STICK_PARITY_SELECT 0x40U
#define UART1_LCR_H_STICK_PARITY_SELECT_BIT 6

#define UART1_CTRL (*(volatile unsigned long *)0xFFFC1030)
#define UART1_CTRL_OFFSET 0x30
#define UART1_CTRL_UART_ENABLE_MASK 0x1U
#define UART1_CTRL_UART_ENABLE 0x1U
#define UART1_CTRL_UART_ENABLE_BIT 0
#define UART1_CTRL_LC_MASK 0x80U
#define UART1_CTRL_LC 0x80U
#define UART1_CTRL_LC_BIT 7
#define UART1_CTRL_TRANSMIT_ENABLE_MASK 0x100U
#define UART1_CTRL_TRANSMIT_ENABLE 0x100U
#define UART1_CTRL_TRANSMIT_ENABLE_BIT 8
#define UART1_CTRL_RECEIVE_ENABLE_MASK 0x200U
#define UART1_CTRL_RECEIVE_ENABLE 0x200U
#define UART1_CTRL_RECEIVE_ENABLE_BIT 9

#define UART1_IFLS (*(volatile unsigned long *)0xFFFC1034)
#define UART1_IFLS_OFFSET 0x34
#define UART1_IFLS_RECEIVE_INTERRUPT_FIFO_LEVEL_SELECT_MASK 0x38U
#define UART1_IFLS_RECEIVE_INTERRUPT_FIFO_LEVEL_SELECT_BIT 3

#define UART1_IMSC (*(volatile unsigned long *)0xFFFC1038)
#define UART1_IMSC_OFFSET 0x38
#define UART1_IMSC_RXIM_MASK 0x10U
#define UART1_IMSC_RXIM 0x10U
#define UART1_IMSC_RXIM_BIT 4
#define UART1_IMSC_TXIM_MASK 0x20U
#define UART1_IMSC_TXIM 0x20U
#define UART1_IMSC_TXIM_BIT 5
#define UART1_IMSC_RTIM_MASK 0x40U
#define UART1_IMSC_RTIM 0x40U
#define UART1_IMSC_RTIM_BIT 6
#define UART1_IMSC_FEIM_MASK 0x80U
#define UART1_IMSC_FEIM 0x80U
#define UART1_IMSC_FEIM_BIT 7
#define UART1_IMSC_PEIM_MASK 0x100U
#define UART1_IMSC_PEIM 0x100U
#define UART1_IMSC_PEIM_BIT 8
#define UART1_IMSC_BEIM_MASK 0x200U
#define UART1_IMSC_BEIM 0x200U
#define UART1_IMSC_BEIM_BIT 9
#define UART1_IMSC_OEIM_MASK 0x400U
#define UART1_IMSC_OEIM 0x400U
#define UART1_IMSC_OEIM_BIT 10

#define UART1_RIS (*(volatile unsigned long *)0xFFFC103C)
#define UART1_RIS_OFFSET 0x3C
#define UART1_RIS_RECEIVE_INTERRUPT_STATUS_MASK 0x10U
#define UART1_RIS_RECEIVE_INTERRUPT_STATUS 0x10U
#define UART1_RIS_RECEIVE_INTERRUPT_STATUS_BIT 4
#define UART1_RIS_TRANSMIT_INTERRUPT_STATUS_MASK 0x20U
#define UART1_RIS_TRANSMIT_INTERRUPT_STATUS 0x20U
#define UART1_RIS_TRANSMIT_INTERRUPT_STATUS_BIT 5
#define UART1_RIS_RECEIVE_TIMEOUT_INTERRUPT_STATUS_MASK 0x40U
#define UART1_RIS_RECEIVE_TIMEOUT_INTERRUPT_STATUS 0x40U
#define UART1_RIS_RECEIVE_TIMEOUT_INTERRUPT_STATUS_BIT 6
#define UART1_RIS_FRAMING_ERROR_INTERRUPT_STATUS_MASK 0x80U
#define UART1_RIS_FRAMING_ERROR_INTERRUPT_STATUS 0x80U
#define UART1_RIS_FRAMING_ERROR_INTERRUPT_STATUS_BIT 7
#define UART1_RIS_PARITY_ERROR_INTERRUPT_STATUS_MASK 0x100U
#define UART1_RIS_PARITY_ERROR_INTERRUPT_STATUS 0x100U
#define UART1_RIS_PARITY_ERROR_INTERRUPT_STATUS_BIT 8
#define UART1_RIS_BREAK_ERROR_INTERRUPT_STATUS_MASK 0x200U
#define UART1_RIS_BREAK_ERROR_INTERRUPT_STATUS 0x200U
#define UART1_RIS_BREAK_ERROR_INTERRUPT_STATUS_BIT 9
#define UART1_RIS_OVERRUN_ERROR_INTERRUPT_STATUS_MASK 0x400U
#define UART1_RIS_OVERRUN_ERROR_INTERRUPT_STATUS 0x400U
#define UART1_RIS_OVERRUN_ERROR_INTERRUPT_STATUS_BIT 10

#define UART1_MIS (*(volatile unsigned long *)0xFFFC1040)
#define UART1_MIS_OFFSET 0x40
#define UART1_MIS_RECEIVE_MASKED_INTERRUPT_STATUS_MASK 0x10U
#define UART1_MIS_RECEIVE_MASKED_INTERRUPT_STATUS 0x10U
#define UART1_MIS_RECEIVE_MASKED_INTERRUPT_STATUS_BIT 4
#define UART1_MIS_TRANSMIT_MASKED_INTERRUPT_STATUS_MASK 0x20U
#define UART1_MIS_TRANSMIT_MASKED_INTERRUPT_STATUS 0x20U
#define UART1_MIS_TRANSMIT_MASKED_INTERRUPT_STATUS_BIT 5
#define UART1_MIS_RECEIVE_TIMEOUT_MASKED_INTERRUPT_STATUS_MASK 0x40U
#define UART1_MIS_RECEIVE_TIMEOUT_MASKED_INTERRUPT_STATUS 0x40U
#define UART1_MIS_RECEIVE_TIMEOUT_MASKED_INTERRUPT_STATUS_BIT 6
#define UART1_MIS_FRAMING_ERROR_MASKED_INTERRUPT_STATUS_MASK 0x80U
#define UART1_MIS_FRAMING_ERROR_MASKED_INTERRUPT_STATUS 0x80U
#define UART1_MIS_FRAMING_ERROR_MASKED_INTERRUPT_STATUS_BIT 7
#define UART1_MIS_PARITY_ERROR_MASKED_INTERRUPT_STATUS_MASK 0x100U
#define UART1_MIS_PARITY_ERROR_MASKED_INTERRUPT_STATUS 0x100U
#define UART1_MIS_PARITY_ERROR_MASKED_INTERRUPT_STATUS_BIT 8
#define UART1_MIS_BREAK_ERROR_MASKED_INTERRUPT_STATUS_MASK 0x200U
#define UART1_MIS_BREAK_ERROR_MASKED_INTERRUPT_STATUS 0x200U
#define UART1_MIS_BREAK_ERROR_MASKED_INTERRUPT_STATUS_BIT 9
#define UART1_MIS_OVERRUN_ERROR_MASKED_INTERRUPT_STATUS_MASK 0x400U
#define UART1_MIS_OVERRUN_ERROR_MASKED_INTERRUPT_STATUS 0x400U
#define UART1_MIS_OVERRUN_ERROR_MASKED_INTERRUPT_STATUS_BIT 10

#define UART1_ICR (*(volatile unsigned long *)0xFFFC1044)
#define UART1_ICR_OFFSET 0x44
#define UART1_ICR_RECEIVE_INTERRUPT_CLEAR_MASK 0x10U
#define UART1_ICR_RECEIVE_INTERRUPT_CLEAR 0x10U
#define UART1_ICR_RECEIVE_INTERRUPT_CLEAR_BIT 4
#define UART1_ICR_TRANSMIT_INTERRUPT_CLEAR_MASK 0x20U
#define UART1_ICR_TRANSMIT_INTERRUPT_CLEAR 0x20U
#define UART1_ICR_TRANSMIT_INTERRUPT_CLEAR_BIT 5
#define UART1_ICR_RECEIVE_TIMEOUT_INTERRUPT_CLEAR_MASK 0x40U
#define UART1_ICR_RECEIVE_TIMEOUT_INTERRUPT_CLEAR 0x40U
#define UART1_ICR_RECEIVE_TIMEOUT_INTERRUPT_CLEAR_BIT 6
#define UART1_ICR_FRAMING_ERROR_INTERRUPT_CLEAR_MASK 0x80U
#define UART1_ICR_FRAMING_ERROR_INTERRUPT_CLEAR 0x80U
#define UART1_ICR_FRAMING_ERROR_INTERRUPT_CLEAR_BIT 7
#define UART1_ICR_PARITY_ERROR_INTERRUPT_CLEAR_MASK 0x100U
#define UART1_ICR_PARITY_ERROR_INTERRUPT_CLEAR 0x100U
#define UART1_ICR_PARITY_ERROR_INTERRUPT_CLEAR_BIT 8
#define UART1_ICR_BREAK_ERROR_INTERRUPT_CLEAR_MASK 0x200U
#define UART1_ICR_BREAK_ERROR_INTERRUPT_CLEAR 0x200U
#define UART1_ICR_BREAK_ERROR_INTERRUPT_CLEAR_BIT 9
#define UART1_ICR_OVERRUN_ERROR_INTERRUPT_CLEAR_MASK 0x400U
#define UART1_ICR_OVERRUN_ERROR_INTERRUPT_CLEAR 0x400U
#define UART1_ICR_OVERRUN_ERROR_INTERRUPT_CLEAR_BIT 10

#define UART1_DMACTRL (*(volatile unsigned long *)0xFFFC1048)
#define UART1_DMACTRL_OFFSET 0x48
#define UART1_DMACTRL_RECEIVE_DMA_ENABLE_MASK 0x1U
#define UART1_DMACTRL_RECEIVE_DMA_ENABLE 0x1U
#define UART1_DMACTRL_RECEIVE_DMA_ENABLE_BIT 0
#define UART1_DMACTRL_TRANSMIT_DMA_ENABLE_MASK 0x2U
#define UART1_DMACTRL_TRANSMIT_DMA_ENABLE 0x2U
#define UART1_DMACTRL_TRANSMIT_DMA_ENABLE_BIT 1
#define UART1_DMACTRL_DMA_ON_ERROR_MASK 0x4U
#define UART1_DMACTRL_DMA_ON_ERROR 0x4U
#define UART1_DMACTRL_DMA_ON_ERROR_BIT 2

#define UART2_BASE 0xFFFC2000

#define UART2_TXD (*(volatile unsigned long *)0xFFFC2000)
#define UART2_TXD_OFFSET 0x0

#define UART2_RXD (*(volatile unsigned long *)0xFFFC2000)
#define UART2_RXD_OFFSET 0x0

#define UART2_BAL (*(volatile unsigned long *)0xFFFC2000)
#define UART2_BAL_OFFSET 0x0

#define UART2_CLCF (*(volatile unsigned long *)0xFFFC2000)
#define UART2_CLCF_OFFSET 0x0

#define UART2_BBL (*(volatile unsigned long *)0xFFFC2000)
#define UART2_BBL_OFFSET 0x0

#define UART2_BAH (*(volatile unsigned long *)0xFFFC2004)
#define UART2_BAH_OFFSET 0x4

#define UART2_GER (*(volatile unsigned long *)0xFFFC2004)
#define UART2_GER_OFFSET 0x4

#define UART2_TXF (*(volatile unsigned long *)0xFFFC2004)
#define UART2_TXF_OFFSET 0x4

#define UART2_RXF (*(volatile unsigned long *)0xFFFC2004)
#define UART2_RXF_OFFSET 0x4

#define UART2_FMD (*(volatile unsigned long *)0xFFFC2004)
#define UART2_FMD_OFFSET 0x4

#define UART2_BACF (*(volatile unsigned long *)0xFFFC2004)
#define UART2_BACF_OFFSET 0x4

#define UART2_BBH (*(volatile unsigned long *)0xFFFC2004)
#define UART2_BBH_OFFSET 0x4

#define UART2_GIR (*(volatile unsigned long *)0xFFFC2008)
#define UART2_GIR_OFFSET 0x8

#define UART2_LCR (*(volatile unsigned long *)0xFFFC200C)
#define UART2_LCR_OFFSET 0xC

#define UART2_TMCR (*(volatile unsigned long *)0xFFFC200C)
#define UART2_TMCR_OFFSET 0xC

#define UART2_TMST (*(volatile unsigned long *)0xFFFC200C)
#define UART2_TMST_OFFSET 0xC

#define UART2_TMD (*(volatile unsigned long *)0xFFFC200C)
#define UART2_TMD_OFFSET 0xC

#define UART2_BBCF (*(volatile unsigned long *)0xFFFC200C)
#define UART2_BBCF_OFFSET 0xC

#define UART2_MCR (*(volatile unsigned long *)0xFFFC2010)
#define UART2_MCR_OFFSET 0x10

#define UART2_FLR (*(volatile unsigned long *)0xFFFC2010)
#define UART2_FLR_OFFSET 0x10

#define UART2_IMD (*(volatile unsigned long *)0xFFFC2010)
#define UART2_IMD_OFFSET 0x10

#define UART2_LSR (*(volatile unsigned long *)0xFFFC2014)
#define UART2_LSR_OFFSET 0x14

#define UART2_RCM (*(volatile unsigned long *)0xFFFC2014)
#define UART2_RCM_OFFSET 0x14

#define UART2_RST (*(volatile unsigned long *)0xFFFC2014)
#define UART2_RST_OFFSET 0x14

#define UART2_ACR1 (*(volatile unsigned long *)0xFFFC2014)
#define UART2_ACR1_OFFSET 0x14

#define UART2_RIE (*(volatile unsigned long *)0xFFFC2018)
#define UART2_RIE_OFFSET 0x18

#define UART2_TMIE (*(volatile unsigned long *)0xFFFC2018)
#define UART2_TMIE_OFFSET 0x18

#define UART2_ACR0 (*(volatile unsigned long *)0xFFFC201C)
#define UART2_ACR0_OFFSET 0x1C

#define UART2_ICM (*(volatile unsigned long *)0xFFFC201C)
#define UART2_ICM_OFFSET 0x1C

#define UART2_GSR (*(volatile unsigned long *)0xFFFC201C)
#define UART2_GSR_OFFSET 0x1C

#define UART2_RMD (*(volatile unsigned long *)0xFFFC201C)
#define UART2_RMD_OFFSET 0x1C

#define ADC_BASE 0xFFFC3000

#define ADC_HW (*(volatile unsigned long *)0xFFFC3000)
#define ADC_HW_OFFSET 0x0
#define ADC_HW_RefP_MASK 0x3U
#define ADC_HW_RefP_BIT 0
#define ADC_HW_INM_MASK 0x4U
#define ADC_HW_INM 0x4U
#define ADC_HW_INM_BIT 2
#define ADC_HW_INP_MASK 0x38U
#define ADC_HW_INP_BIT 3
#define ADC_HW_SETTIME_MASK 0xFF80U
#define ADC_HW_SETTIME_BIT 7

#define ADC_LW (*(volatile unsigned long *)0xFFFC3004)
#define ADC_LW_OFFSET 0x4
#define ADC_LW_RefM_MASK 0x3U
#define ADC_LW_RefM_BIT 0
#define ADC_LW_BIASCON_MASK 0x3FFCU
#define ADC_LW_BIASCON_BIT 2

#define ADC_RR (*(volatile unsigned long *)0xFFFC3008)
#define ADC_RR_OFFSET 0x8
#define ADC_RR_CBTAG_MASK 0xFU
#define ADC_RR_CBTAG_BIT 0
#define ADC_RR_BITRES_MASK 0xFFC0U
#define ADC_RR_BITRES_BIT 6

#define ADC_IM (*(volatile unsigned long *)0xFFFC300C)
#define ADC_IM_OFFSET 0xC
#define ADC_IM_F0MSK_MASK 0x1U
#define ADC_IM_F0MSK 0x1U
#define ADC_IM_F0MSK_BIT 0
#define ADC_IM_FWMSK_MASK 0x2U
#define ADC_IM_FWMSK 0x2U
#define ADC_IM_FWMSK_BIT 1
#define ADC_IM_EOSMSK_MASK 0x4U
#define ADC_IM_EOSMSK 0x4U
#define ADC_IM_EOSMSK_BIT 2
#define ADC_IM_PMSK_MASK 0x8U
#define ADC_IM_PMSK 0x8U
#define ADC_IM_PMSK_BIT 3
#define ADC_IM_BOMSK_MASK 0x10U
#define ADC_IM_BOMSK 0x10U
#define ADC_IM_BOMSK_BIT 4
#define ADC_IM_INTEN_MASK 0x40U
#define ADC_IM_INTEN 0x40U
#define ADC_IM_INTEN_BIT 6

#define ADC_PC (*(volatile unsigned long *)0xFFFC3010)
#define ADC_PC_OFFSET 0x10
#define ADC_PC_NOC_MASK 0xFU
#define ADC_PC_NOC_BIT 0
#define ADC_PC_REFEN_MASK 0x20U
#define ADC_PC_REFEN 0x20U
#define ADC_PC_REFEN_BIT 5
#define ADC_PC_PWM_MASK 0xC0U
#define ADC_PC_PWM_BIT 6
#define ADC_PC_CLKSEL_MASK 0x700U
#define ADC_PC_CLKSEL_BIT 8

#define ADC_GC (*(volatile unsigned long *)0xFFFC3014)
#define ADC_GC_OFFSET 0x14
#define ADC_GC_SSM_MASK 0x3U
#define ADC_GC_SSM_BIT 0
#define ADC_GC_SSB_MASK 0x4U
#define ADC_GC_SSB 0x4U
#define ADC_GC_SSB_BIT 2
#define ADC_GC_FIFOWMK_MASK 0x78U
#define ADC_GC_FIFOWMK_BIT 3

#define ADC_GS (*(volatile unsigned long *)0xFFFC3018)
#define ADC_GS_OFFSET 0x18
#define ADC_GS_CBTAG_MASK 0xFU
#define ADC_GS_CBTAG_BIT 0
#define ADC_GS_CBSTATE_MASK 0xF0U
#define ADC_GS_CBSTATE_BIT 4
#define ADC_GS_PENIRQ_MASK 0x100U
#define ADC_GS_PENIRQ 0x100U
#define ADC_GS_PENIRQ_BIT 8
#define ADC_GS_BROWNOUT_MASK 0x200U
#define ADC_GS_BROWNOUT 0x200U
#define ADC_GS_BROWNOUT_BIT 9

#define ADC_IS (*(volatile unsigned long *)0xFFFC301C)
#define ADC_IS_OFFSET 0x1C
#define ADC_IS_FOVRNINTR_UM_MASK 0x1U
#define ADC_IS_FOVRNINTR_UM 0x1U
#define ADC_IS_FOVRNINTR_UM_BIT 0
#define ADC_IS_FWATERINTR_UM_MASK 0x2U
#define ADC_IS_FWATERINTR_UM 0x2U
#define ADC_IS_FWATERINTR_UM_BIT 1
#define ADC_IS_EOSINTR_UM_MASK 0x4U
#define ADC_IS_EOSINTR_UM 0x4U
#define ADC_IS_EOSINTR_UM_BIT 2
#define ADC_IS_PENSYNC_UM_MASK 0x8U
#define ADC_IS_PENSYNC_UM 0x8U
#define ADC_IS_PENSYNC_UM_BIT 3
#define ADC_IS_BROWNOUTINTR_UM_MASK 0x10U
#define ADC_IS_BROWNOUTINTR_UM 0x10U
#define ADC_IS_BROWNOUTINTR_UM_BIT 4

#define ADC_FS (*(volatile unsigned long *)0xFFFC3020)
#define ADC_FS_OFFSET 0x20
#define ADC_FS_FGTEWATERMRK_MASK 0x1U
#define ADC_FS_FGTEWATERMRK 0x1U
#define ADC_FS_FGTEWATERMRK_BIT 0
#define ADC_FS_FOVRNDET_MASK 0x2U
#define ADC_FS_FOVRNDET 0x2U
#define ADC_FS_FOVRNDET_BIT 1
#define ADC_FS_FEMPTY_MASK 0x4U
#define ADC_FS_FEMPTY 0x4U
#define ADC_FS_FEMPTY_BIT 2
#define ADC_FS_FFF_MASK 0x8U
#define ADC_FS_FFF 0x8U
#define ADC_FS_FFF_BIT 3
#define ADC_FS_RSPTR_MASK 0xF0U
#define ADC_FS_RSPTR_BIT 4
#define ADC_FS_WRPTR_MASK 0xF00U
#define ADC_FS_WRPTR_BIT 8

#define ADC_HWCB0 (*(volatile unsigned long *)0xFFFC3024)
#define ADC_HWCB0_OFFSET 0x24
#define ADC_HWCB0_RefPlus_MASK 0x3U
#define ADC_HWCB0_RefPlus_BIT 0
#define ADC_HWCB0_In-_MASK 0x4U
#define ADC_HWCB0_In- 0x4U
#define ADC_HWCB0_In-_BIT 2
#define ADC_HWCB0_In+_MASK 0x78U
#define ADC_HWCB0_In+_BIT 3
#define ADC_HWCB0_SettlingTime_MASK 0xFF80U
#define ADC_HWCB0_SettlingTime_BIT 7

#define ADC_HWCB1 (*(volatile unsigned long *)0xFFFC3028)
#define ADC_HWCB1_OFFSET 0x28
#define ADC_HWCB1_RefPlus_MASK 0x3U
#define ADC_HWCB1_RefPlus_BIT 0
#define ADC_HWCB1_In-_MASK 0x4U
#define ADC_HWCB1_In- 0x4U
#define ADC_HWCB1_In-_BIT 2
#define ADC_HWCB1_In+_MASK 0x78U
#define ADC_HWCB1_In+_BIT 3
#define ADC_HWCB1_SettlingTime_MASK 0xFF80U
#define ADC_HWCB1_SettlingTime_BIT 7

#define ADC_HWCB2 (*(volatile unsigned long *)0xFFFC302C)
#define ADC_HWCB2_OFFSET 0x2C
#define ADC_HWCB2_RefPlus_MASK 0x3U
#define ADC_HWCB2_RefPlus_BIT 0
#define ADC_HWCB2_In-_MASK 0x4U
#define ADC_HWCB2_In- 0x4U
#define ADC_HWCB2_In-_BIT 2
#define ADC_HWCB2_In+_MASK 0x78U
#define ADC_HWCB2_In+_BIT 3
#define ADC_HWCB2_SettlingTime_MASK 0xFF80U
#define ADC_HWCB2_SettlingTime_BIT 7

#define ADC_HWCB3 (*(volatile unsigned long *)0xFFFC3030)
#define ADC_HWCB3_OFFSET 0x30
#define ADC_HWCB3_RefPlus_MASK 0x3U
#define ADC_HWCB3_RefPlus_BIT 0
#define ADC_HWCB3_In-_MASK 0x4U
#define ADC_HWCB3_In- 0x4U
#define ADC_HWCB3_In-_BIT 2
#define ADC_HWCB3_In+_MASK 0x78U
#define ADC_HWCB3_In+_BIT 3
#define ADC_HWCB3_SettlingTime_MASK 0xFF80U
#define ADC_HWCB3_SettlingTime_BIT 7

#define ADC_HWCB4 (*(volatile unsigned long *)0xFFFC3034)
#define ADC_HWCB4_OFFSET 0x34
#define ADC_HWCB4_RefPlus_MASK 0x3U
#define ADC_HWCB4_RefPlus_BIT 0
#define ADC_HWCB4_In-_MASK 0x4U
#define ADC_HWCB4_In- 0x4U
#define ADC_HWCB4_In-_BIT 2
#define ADC_HWCB4_In+_MASK 0x78U
#define ADC_HWCB4_In+_BIT 3
#define ADC_HWCB4_SettlingTime_MASK 0xFF80U
#define ADC_HWCB4_SettlingTime_BIT 7

#define ADC_HWCB5 (*(volatile unsigned long *)0xFFFC3038)
#define ADC_HWCB5_OFFSET 0x38
#define ADC_HWCB5_RefPlus_MASK 0x3U
#define ADC_HWCB5_RefPlus_BIT 0
#define ADC_HWCB5_In-_MASK 0x4U
#define ADC_HWCB5_In- 0x4U
#define ADC_HWCB5_In-_BIT 2
#define ADC_HWCB5_In+_MASK 0x78U
#define ADC_HWCB5_In+_BIT 3
#define ADC_HWCB5_SettlingTime_MASK 0xFF80U
#define ADC_HWCB5_SettlingTime_BIT 7

#define ADC_HWCB6 (*(volatile unsigned long *)0xFFFC303C)
#define ADC_HWCB6_OFFSET 0x3C
#define ADC_HWCB6_RefPlus_MASK 0x3U
#define ADC_HWCB6_RefPlus_BIT 0
#define ADC_HWCB6_In-_MASK 0x4U
#define ADC_HWCB6_In- 0x4U
#define ADC_HWCB6_In-_BIT 2
#define ADC_HWCB6_In+_MASK 0x78U
#define ADC_HWCB6_In+_BIT 3
#define ADC_HWCB6_SettlingTime_MASK 0xFF80U
#define ADC_HWCB6_SettlingTime_BIT 7

#define ADC_HWCB7 (*(volatile unsigned long *)0xFFFC3040)
#define ADC_HWCB7_OFFSET 0x40
#define ADC_HWCB7_RefPlus_MASK 0x3U
#define ADC_HWCB7_RefPlus_BIT 0
#define ADC_HWCB7_In-_MASK 0x4U
#define ADC_HWCB7_In- 0x4U
#define ADC_HWCB7_In-_BIT 2
#define ADC_HWCB7_In+_MASK 0x78U
#define ADC_HWCB7_In+_BIT 3
#define ADC_HWCB7_SettlingTime_MASK 0xFF80U
#define ADC_HWCB7_SettlingTime_BIT 7

#define ADC_HWCB8 (*(volatile unsigned long *)0xFFFC3044)
#define ADC_HWCB8_OFFSET 0x44
#define ADC_HWCB8_RefPlus_MASK 0x3U
#define ADC_HWCB8_RefPlus_BIT 0
#define ADC_HWCB8_In-_MASK 0x4U
#define ADC_HWCB8_In- 0x4U
#define ADC_HWCB8_In-_BIT 2
#define ADC_HWCB8_In+_MASK 0x78U
#define ADC_HWCB8_In+_BIT 3
#define ADC_HWCB8_SettlingTime_MASK 0xFF80U
#define ADC_HWCB8_SettlingTime_BIT 7

#define ADC_HWCB9 (*(volatile unsigned long *)0xFFFC3048)
#define ADC_HWCB9_OFFSET 0x48
#define ADC_HWCB9_RefPlus_MASK 0x3U
#define ADC_HWCB9_RefPlus_BIT 0
#define ADC_HWCB9_In-_MASK 0x4U
#define ADC_HWCB9_In- 0x4U
#define ADC_HWCB9_In-_BIT 2
#define ADC_HWCB9_In+_MASK 0x78U
#define ADC_HWCB9_In+_BIT 3
#define ADC_HWCB9_SettlingTime_MASK 0xFF80U
#define ADC_HWCB9_SettlingTime_BIT 7

#define ADC_HWCB10 (*(volatile unsigned long *)0xFFFC304C)
#define ADC_HWCB10_OFFSET 0x4C
#define ADC_HWCB10_RefPlus_MASK 0x3U
#define ADC_HWCB10_RefPlus_BIT 0
#define ADC_HWCB10_In-_MASK 0x4U
#define ADC_HWCB10_In- 0x4U
#define ADC_HWCB10_In-_BIT 2
#define ADC_HWCB10_In+_MASK 0x78U
#define ADC_HWCB10_In+_BIT 3
#define ADC_HWCB10_SettlingTime_MASK 0xFF80U
#define ADC_HWCB10_SettlingTime_BIT 7

#define ADC_HWCB11 (*(volatile unsigned long *)0xFFFC3050)
#define ADC_HWCB11_OFFSET 0x50
#define ADC_HWCB11_RefPlus_MASK 0x3U
#define ADC_HWCB11_RefPlus_BIT 0
#define ADC_HWCB11_In-_MASK 0x4U
#define ADC_HWCB11_In- 0x4U
#define ADC_HWCB11_In-_BIT 2
#define ADC_HWCB11_In+_MASK 0x78U
#define ADC_HWCB11_In+_BIT 3
#define ADC_HWCB11_SettlingTime_MASK 0xFF80U
#define ADC_HWCB11_SettlingTime_BIT 7

#define ADC_HWCB12 (*(volatile unsigned long *)0xFFFC3054)
#define ADC_HWCB12_OFFSET 0x54
#define ADC_HWCB12_RefPlus_MASK 0x3U
#define ADC_HWCB12_RefPlus_BIT 0
#define ADC_HWCB12_In-_MASK 0x4U
#define ADC_HWCB12_In- 0x4U
#define ADC_HWCB12_In-_BIT 2
#define ADC_HWCB12_In+_MASK 0x78U
#define ADC_HWCB12_In+_BIT 3
#define ADC_HWCB12_SettlingTime_MASK 0xFF80U
#define ADC_HWCB12_SettlingTime_BIT 7

#define ADC_HWCB13 (*(volatile unsigned long *)0xFFFC3058)
#define ADC_HWCB13_OFFSET 0x58
#define ADC_HWCB13_RefPlus_MASK 0x3U
#define ADC_HWCB13_RefPlus_BIT 0
#define ADC_HWCB13_In-_MASK 0x4U
#define ADC_HWCB13_In- 0x4U
#define ADC_HWCB13_In-_BIT 2
#define ADC_HWCB13_In+_MASK 0x78U
#define ADC_HWCB13_In+_BIT 3
#define ADC_HWCB13_SettlingTime_MASK 0xFF80U
#define ADC_HWCB13_SettlingTime_BIT 7

#define ADC_HWCB14 (*(volatile unsigned long *)0xFFFC305C)
#define ADC_HWCB14_OFFSET 0x5C
#define ADC_HWCB14_RefPlus_MASK 0x3U
#define ADC_HWCB14_RefPlus_BIT 0
#define ADC_HWCB14_In-_MASK 0x4U
#define ADC_HWCB14_In- 0x4U
#define ADC_HWCB14_In-_BIT 2
#define ADC_HWCB14_In+_MASK 0x78U
#define ADC_HWCB14_In+_BIT 3
#define ADC_HWCB14_SettlingTime_MASK 0xFF80U
#define ADC_HWCB14_SettlingTime_BIT 7

#define ADC_HWCB15 (*(volatile unsigned long *)0xFFFC3060)
#define ADC_HWCB15_OFFSET 0x60
#define ADC_HWCB15_RefPlus_MASK 0x3U
#define ADC_HWCB15_RefPlus_BIT 0
#define ADC_HWCB15_In-_MASK 0x4U
#define ADC_HWCB15_In- 0x4U
#define ADC_HWCB15_In-_BIT 2
#define ADC_HWCB15_In+_MASK 0x78U
#define ADC_HWCB15_In+_BIT 3
#define ADC_HWCB15_SettlingTime_MASK 0xFF80U
#define ADC_HWCB15_SettlingTime_BIT 7

#define ADC_LWCB0 (*(volatile unsigned long *)0xFFFC3064)
#define ADC_LWCB0_OFFSET 0x64
#define ADC_LWCB0_RefMinus_MASK 0x3U
#define ADC_LWCB0_RefMinus_BIT 0
#define ADC_LWCB0_BiasControl_MASK 0x3FFCU
#define ADC_LWCB0_BiasControl_BIT 2

#define ADC_LWCB1 (*(volatile unsigned long *)0xFFFC3068)
#define ADC_LWCB1_OFFSET 0x68
#define ADC_LWCB1_RefMinus_MASK 0x3U
#define ADC_LWCB1_RefMinus_BIT 0
#define ADC_LWCB1_BiasControl_MASK 0x3FFCU
#define ADC_LWCB1_BiasControl_BIT 2

#define ADC_LWCB2 (*(volatile unsigned long *)0xFFFC306C)
#define ADC_LWCB2_OFFSET 0x6C
#define ADC_LWCB2_RefMinus_MASK 0x3U
#define ADC_LWCB2_RefMinus_BIT 0
#define ADC_LWCB2_BiasControl_MASK 0x3FFCU
#define ADC_LWCB2_BiasControl_BIT 2

#define ADC_LWCB3 (*(volatile unsigned long *)0xFFFC3070)
#define ADC_LWCB3_OFFSET 0x70
#define ADC_LWCB3_RefMinus_MASK 0x3U
#define ADC_LWCB3_RefMinus_BIT 0
#define ADC_LWCB3_BiasControl_MASK 0x3FFCU
#define ADC_LWCB3_BiasControl_BIT 2

#define ADC_LWCB4 (*(volatile unsigned long *)0xFFFC3074)
#define ADC_LWCB4_OFFSET 0x74
#define ADC_LWCB4_RefMinus_MASK 0x3U
#define ADC_LWCB4_RefMinus_BIT 0
#define ADC_LWCB4_BiasControl_MASK 0x3FFCU
#define ADC_LWCB4_BiasControl_BIT 2

#define ADC_LWCB5 (*(volatile unsigned long *)0xFFFC3078)
#define ADC_LWCB5_OFFSET 0x78
#define ADC_LWCB5_RefMinus_MASK 0x3U
#define ADC_LWCB5_RefMinus_BIT 0
#define ADC_LWCB5_BiasControl_MASK 0x3FFCU
#define ADC_LWCB5_BiasControl_BIT 2

#define ADC_LWCB6 (*(volatile unsigned long *)0xFFFC307C)
#define ADC_LWCB6_OFFSET 0x7C
#define ADC_LWCB6_RefMinus_MASK 0x3U
#define ADC_LWCB6_RefMinus_BIT 0
#define ADC_LWCB6_BiasControl_MASK 0x3FFCU
#define ADC_LWCB6_BiasControl_BIT 2

#define ADC_LWCB7 (*(volatile unsigned long *)0xFFFC3080)
#define ADC_LWCB7_OFFSET 0x80
#define ADC_LWCB7_RefMinus_MASK 0x3U
#define ADC_LWCB7_RefMinus_BIT 0
#define ADC_LWCB7_BiasControl_MASK 0x3FFCU
#define ADC_LWCB7_BiasControl_BIT 2

#define ADC_LWCB8 (*(volatile unsigned long *)0xFFFC3084)
#define ADC_LWCB8_OFFSET 0x84
#define ADC_LWCB8_RefMinus_MASK 0x3U
#define ADC_LWCB8_RefMinus_BIT 0
#define ADC_LWCB8_BiasControl_MASK 0x3FFCU
#define ADC_LWCB8_BiasControl_BIT 2

#define ADC_LWCB9 (*(volatile unsigned long *)0xFFFC3088)
#define ADC_LWCB9_OFFSET 0x88
#define ADC_LWCB9_RefMinus_MASK 0x3U
#define ADC_LWCB9_RefMinus_BIT 0
#define ADC_LWCB9_BiasControl_MASK 0x3FFCU
#define ADC_LWCB9_BiasControl_BIT 2

#define ADC_LWCB10 (*(volatile unsigned long *)0xFFFC308C)
#define ADC_LWCB10_OFFSET 0x8C
#define ADC_LWCB10_RefMinus_MASK 0x3U
#define ADC_LWCB10_RefMinus_BIT 0
#define ADC_LWCB10_BiasControl_MASK 0x3FFCU
#define ADC_LWCB10_BiasControl_BIT 2

#define ADC_LWCB11 (*(volatile unsigned long *)0xFFFC3090)
#define ADC_LWCB11_OFFSET 0x90
#define ADC_LWCB11_RefMinus_MASK 0x3U
#define ADC_LWCB11_RefMinus_BIT 0
#define ADC_LWCB11_BiasControl_MASK 0x3FFCU
#define ADC_LWCB11_BiasControl_BIT 2

#define ADC_LWCB12 (*(volatile unsigned long *)0xFFFC3094)
#define ADC_LWCB12_OFFSET 0x94
#define ADC_LWCB12_RefMinus_MASK 0x3U
#define ADC_LWCB12_RefMinus_BIT 0
#define ADC_LWCB12_BiasControl_MASK 0x3FFCU
#define ADC_LWCB12_BiasControl_BIT 2

#define ADC_LWCB13 (*(volatile unsigned long *)0xFFFC3098)
#define ADC_LWCB13_OFFSET 0x98
#define ADC_LWCB13_RefMinus_MASK 0x3U
#define ADC_LWCB13_RefMinus_BIT 0
#define ADC_LWCB13_BiasControl_MASK 0x3FFCU
#define ADC_LWCB13_BiasControl_BIT 2

#define ADC_LWCB14 (*(volatile unsigned long *)0xFFFC309C)
#define ADC_LWCB14_OFFSET 0x9C
#define ADC_LWCB14_RefMinus_MASK 0x3U
#define ADC_LWCB14_RefMinus_BIT 0
#define ADC_LWCB14_BiasControl_MASK 0x3FFCU
#define ADC_LWCB14_BiasControl_BIT 2

#define ADC_LWCB15 (*(volatile unsigned long *)0xFFFC30A0)
#define ADC_LWCB15_OFFSET 0xA0
#define ADC_LWCB15_RefMinus_MASK 0x3U
#define ADC_LWCB15_RefMinus_BIT 0
#define ADC_LWCB15_BiasControl_MASK 0x3FFCU
#define ADC_LWCB15_BiasControl_BIT 2

#define ADC_IHWCTRL (*(volatile unsigned long *)0xFFFC30A4)
#define ADC_IHWCTRL_OFFSET 0xA4
#define ADC_IHWCTRL_REFP_ID_MASK 0x3U
#define ADC_IHWCTRL_REFP_ID_BIT 0
#define ADC_IHWCTRL_INM_ID_MASK 0x4U
#define ADC_IHWCTRL_INM_ID 0x4U
#define ADC_IHWCTRL_INM_ID_BIT 2
#define ADC_IHWCTRL_INP_ID_MASK 0x38U
#define ADC_IHWCTRL_INP_ID_BIT 3
#define ADC_IHWCTRL_SETTIME_ID_MASK 0xFF80U
#define ADC_IHWCTRL_SETTIME_ID_BIT 7

#define ADC_ILWCTRL (*(volatile unsigned long *)0xFFFC30A8)
#define ADC_ILWCTRL_OFFSET 0xA8
#define ADC_ILWCTRL_REFM_ID_MASK 0x3U
#define ADC_ILWCTRL_REFM_ID_BIT 0
#define ADC_ILWCTRL_BIASCON_ID_MASK 0x3FFCU
#define ADC_ILWCTRL_BIASCON_ID_BIT 2

#define ADC_MIS (*(volatile unsigned long *)0xFFFC30AC)
#define ADC_MIS_OFFSET 0xAC
#define ADC_MIS_FOVRNINTR_MASK 0x1U
#define ADC_MIS_FOVRNINTR 0x1U
#define ADC_MIS_FOVRNINTR_BIT 0
#define ADC_MIS_FWATERINTR_MASK 0x2U
#define ADC_MIS_FWATERINTR 0x2U
#define ADC_MIS_FWATERINTR_BIT 1
#define ADC_MIS_EOSINTR_MASK 0x4U
#define ADC_MIS_EOSINTR 0x4U
#define ADC_MIS_EOSINTR_BIT 2
#define ADC_MIS_PENSYNC_MASK 0x8U
#define ADC_MIS_PENSYNC 0x8U
#define ADC_MIS_PENSYNC_BIT 3
#define ADC_MIS_BROWNOUT_MASK 0x10U
#define ADC_MIS_BROWNOUT 0x10U
#define ADC_MIS_BROWNOUT_BIT 4

#define ADC_IC (*(volatile unsigned long *)0xFFFC30AC)
#define ADC_IC_OFFSET 0xAC
#define ADC_IC_EOSINTC_MASK 0x1U
#define ADC_IC_EOSINTC 0x1U
#define ADC_IC_EOSINTC_BIT 0
#define ADC_IC_PENIC_MASK 0x2U
#define ADC_IC_PENIC 0x2U
#define ADC_IC_PENIC_BIT 1
#define ADC_IC_BOIC_MASK 0x4U
#define ADC_IC_BOIC 0x4U
#define ADC_IC_BOIC_BIT 2

#define Timer_BASE 0xFFFC4000

#define Timer0_CTRL (*(volatile unsigned long *)0xFFFC4000)
#define Timer0_CTRL_OFFSET 0x0
#define Timer0_CTRL_CCL_MASK 0x1U
#define Timer0_CTRL_CCL 0x1U
#define Timer0_CTRL_CCL_BIT 0
#define Timer0_CTRL_CS_MASK 0x2U
#define Timer0_CTRL_CS 0x2U
#define Timer0_CTRL_CS_BIT 1
#define Timer0_CTRL_SEL_MASK 0x1CU
#define Timer0_CTRL_SEL_BIT 2

#define Timer0_CMP_CAP_CTRL (*(volatile unsigned long *)0xFFFC4004)
#define Timer0_CMP_CAP_CTRL_OFFSET 0x4
#define Timer0_CMP_CAP_CTRL_CAP0_MASK 0x3U
#define Timer0_CMP_CAP_CTRL_CAP0_BIT 0
#define Timer0_CMP_CAP_CTRL_CAP1_MASK 0xCU
#define Timer0_CMP_CAP_CTRL_CAP1_BIT 2
#define Timer0_CMP_CAP_CTRL_CAP2_MASK 0x30U
#define Timer0_CMP_CAP_CTRL_CAP2_BIT 4
#define Timer0_CMP_CAP_CTRL_CAP3_MASK 0xC0U
#define Timer0_CMP_CAP_CTRL_CAP3_BIT 6
#define Timer0_CMP_CAP_CTRL_CAP4_MASK 0x300U
#define Timer0_CMP_CAP_CTRL_CAP4_BIT 8
#define Timer0_CMP_CAP_CTRL_CMP0_MASK 0xC00U
#define Timer0_CMP_CAP_CTRL_CMP0_BIT 10
#define Timer0_CMP_CAP_CTRL_CMP1_MASK 0x3000U
#define Timer0_CMP_CAP_CTRL_CMP1_BIT 12
#define Timer0_CMP_CAP_CTRL_TC_MASK 0x4000U
#define Timer0_CMP_CAP_CTRL_TC 0x4000U
#define Timer0_CMP_CAP_CTRL_TC_BIT 14
#define Timer0_CMP_CAP_CTRL_PWM_MASK 0x8000U
#define Timer0_CMP_CAP_CTRL_PWM 0x8000U
#define Timer0_CMP_CAP_CTRL_PWM_BIT 15

#define Timer0_INT_CTRL (*(volatile unsigned long *)0xFFFC4008)
#define Timer0_INT_CTRL_OFFSET 0x8
#define Timer0_INT_CTRL_OVF_EN_MASK 0x1U
#define Timer0_INT_CTRL_OVF_EN 0x1U
#define Timer0_INT_CTRL_OVF_EN_BIT 0
#define Timer0_INT_CTRL_CMP0_EN_MASK 0x2U
#define Timer0_INT_CTRL_CMP0_EN 0x2U
#define Timer0_INT_CTRL_CMP0_EN_BIT 1
#define Timer0_INT_CTRL_CMP1_EN_MASK 0x4U
#define Timer0_INT_CTRL_CMP1_EN 0x4U
#define Timer0_INT_CTRL_CMP1_EN_BIT 2
#define Timer0_INT_CTRL_CAP0_EN_MASK 0x8U
#define Timer0_INT_CTRL_CAP0_EN 0x8U
#define Timer0_INT_CTRL_CAP0_EN_BIT 3
#define Timer0_INT_CTRL_CAP1_EN_MASK 0x10U
#define Timer0_INT_CTRL_CAP1_EN 0x10U
#define Timer0_INT_CTRL_CAP1_EN_BIT 4
#define Timer0_INT_CTRL_CAP2_EN_MASK 0x20U
#define Timer0_INT_CTRL_CAP2_EN 0x20U
#define Timer0_INT_CTRL_CAP2_EN_BIT 5
#define Timer0_INT_CTRL_CAP3_EN_MASK 0x40U
#define Timer0_INT_CTRL_CAP3_EN 0x40U
#define Timer0_INT_CTRL_CAP3_EN_BIT 6
#define Timer0_INT_CTRL_CAP4_EN_MASK 0x80U
#define Timer0_INT_CTRL_CAP4_EN 0x80U
#define Timer0_INT_CTRL_CAP4_EN_BIT 7

#define Timer0_STATUS (*(volatile unsigned long *)0xFFFC400C)
#define Timer0_STATUS_OFFSET 0xC
#define Timer0_STATUS_OVF_ST_MASK 0x1U
#define Timer0_STATUS_OVF_ST 0x1U
#define Timer0_STATUS_OVF_ST_BIT 0
#define Timer0_STATUS_CMP0_ST_MASK 0x2U
#define Timer0_STATUS_CMP0_ST 0x2U
#define Timer0_STATUS_CMP0_ST_BIT 1
#define Timer0_STATUS_CMP1_ST_MASK 0x4U
#define Timer0_STATUS_CMP1_ST 0x4U
#define Timer0_STATUS_CMP1_ST_BIT 2
#define Timer0_STATUS_CAP0_ST_MASK 0x8U
#define Timer0_STATUS_CAP0_ST 0x8U
#define Timer0_STATUS_CAP0_ST_BIT 3
#define Timer0_STATUS_CAP1_ST_MASK 0x10U
#define Timer0_STATUS_CAP1_ST 0x10U
#define Timer0_STATUS_CAP1_ST_BIT 4
#define Timer0_STATUS_CAP2_ST_MASK 0x20U
#define Timer0_STATUS_CAP2_ST 0x20U
#define Timer0_STATUS_CAP2_ST_BIT 5
#define Timer0_STATUS_CAP3_ST_MASK 0x40U
#define Timer0_STATUS_CAP3_ST 0x40U
#define Timer0_STATUS_CAP3_ST_BIT 6
#define Timer0_STATUS_CAP4_ST_MASK 0x80U
#define Timer0_STATUS_CAP4_ST 0x80U
#define Timer0_STATUS_CAP4_ST_BIT 7

#define Timer0_CNT (*(volatile unsigned long *)0xFFFC4010)
#define Timer0_CNT_OFFSET 0x10

#define Timer0_CMP0 (*(volatile unsigned long *)0xFFFC4014)
#define Timer0_CMP0_OFFSET 0x14

#define Timer0_CMP1 (*(volatile unsigned long *)0xFFFC4018)
#define Timer0_CMP1_OFFSET 0x18

#define Timer0_CAP0 (*(volatile unsigned long *)0xFFFC401C)
#define Timer0_CAP0_OFFSET 0x1C

#define Timer0_CAP1 (*(volatile unsigned long *)0xFFFC4020)
#define Timer0_CAP1_OFFSET 0x20

#define Timer0_CAP2 (*(volatile unsigned long *)0xFFFC4024)
#define Timer0_CAP2_OFFSET 0x24

#define Timer0_CAP3 (*(volatile unsigned long *)0xFFFC4028)
#define Timer0_CAP3_OFFSET 0x28

#define Timer0_CAP4 (*(volatile unsigned long *)0xFFFC402C)
#define Timer0_CAP4_OFFSET 0x2C

#define Timer1_CTRL (*(volatile unsigned long *)0xFFFC4030)
#define Timer1_CTRL_OFFSET 0x30
#define Timer1_CTRL_CCL_MASK 0x1U
#define Timer1_CTRL_CCL 0x1U
#define Timer1_CTRL_CCL_BIT 0
#define Timer1_CTRL_CS_MASK 0x2U
#define Timer1_CTRL_CS 0x2U
#define Timer1_CTRL_CS_BIT 1
#define Timer1_CTRL_SEL_MASK 0x1CU
#define Timer1_CTRL_SEL_BIT 2
#define Timer1_CTRL_CAP0_MASK 0x60U
#define Timer1_CTRL_CAP0_BIT 5
#define Timer1_CTRL_CAP1_MASK 0x180U
#define Timer1_CTRL_CAP1_BIT 7
#define Timer1_CTRL_CMP0_MASK 0x600U
#define Timer1_CTRL_CMP0_BIT 9
#define Timer1_CTRL_CMP1_MASK 0x1800U
#define Timer1_CTRL_CMP1_BIT 11
#define Timer1_CTRL_TC_MASK 0x2000U
#define Timer1_CTRL_TC 0x2000U
#define Timer1_CTRL_TC_BIT 13
#define Timer1_CTRL_PWM_MASK 0x4000U
#define Timer1_CTRL_PWM 0x4000U
#define Timer1_CTRL_PWM_BIT 14

#define Timer1_INT_CTRL (*(volatile unsigned long *)0xFFFC4034)
#define Timer1_INT_CTRL_OFFSET 0x34
#define Timer1_INT_CTRL_OVF_EN_MASK 0x1U
#define Timer1_INT_CTRL_OVF_EN 0x1U
#define Timer1_INT_CTRL_OVF_EN_BIT 0
#define Timer1_INT_CTRL_CMP0_EN_MASK 0x2U
#define Timer1_INT_CTRL_CMP0_EN 0x2U
#define Timer1_INT_CTRL_CMP0_EN_BIT 1
#define Timer1_INT_CTRL_CMP1_EN_MASK 0x4U
#define Timer1_INT_CTRL_CMP1_EN 0x4U
#define Timer1_INT_CTRL_CMP1_EN_BIT 2
#define Timer1_INT_CTRL_CAP0_EN_MASK 0x8U
#define Timer1_INT_CTRL_CAP0_EN 0x8U
#define Timer1_INT_CTRL_CAP0_EN_BIT 3
#define Timer1_INT_CTRL_CAP1_EN_MASK 0x10U
#define Timer1_INT_CTRL_CAP1_EN 0x10U
#define Timer1_INT_CTRL_CAP1_EN_BIT 4

#define Timer1_STATUS (*(volatile unsigned long *)0xFFFC4038)
#define Timer1_STATUS_OFFSET 0x38
#define Timer1_STATUS_OVF_ST_MASK 0x1U
#define Timer1_STATUS_OVF_ST 0x1U
#define Timer1_STATUS_OVF_ST_BIT 0
#define Timer1_STATUS_CMP0_ST_MASK 0x2U
#define Timer1_STATUS_CMP0_ST 0x2U
#define Timer1_STATUS_CMP0_ST_BIT 1
#define Timer1_STATUS_CMP1_ST_MASK 0x4U
#define Timer1_STATUS_CMP1_ST 0x4U
#define Timer1_STATUS_CMP1_ST_BIT 2
#define Timer1_STATUS_CAP0_ST_MASK 0x8U
#define Timer1_STATUS_CAP0_ST 0x8U
#define Timer1_STATUS_CAP0_ST_BIT 3
#define Timer1_STATUS_CAP1_ST_MASK 0x10U
#define Timer1_STATUS_CAP1_ST 0x10U
#define Timer1_STATUS_CAP1_ST_BIT 4

#define Timer1_CNT (*(volatile unsigned long *)0xFFFC403C)
#define Timer1_CNT_OFFSET 0x3C

#define Timer1_CMP0 (*(volatile unsigned long *)0xFFFC4040)
#define Timer1_CMP0_OFFSET 0x40

#define Timer1_CMP1 (*(volatile unsigned long *)0xFFFC4044)
#define Timer1_CMP1_OFFSET 0x44

#define Timer1_CAP0 (*(volatile unsigned long *)0xFFFC4048)
#define Timer1_CAP0_OFFSET 0x48

#define Timer1_CAP1 (*(volatile unsigned long *)0xFFFC404C)
#define Timer1_CAP1_OFFSET 0x4C

#define Timer2_CTRL (*(volatile unsigned long *)0xFFFC4050)
#define Timer2_CTRL_OFFSET 0x50
#define Timer2_CTRL_CCL_MASK 0x1U
#define Timer2_CTRL_CCL 0x1U
#define Timer2_CTRL_CCL_BIT 0
#define Timer2_CTRL_CS_MASK 0x2U
#define Timer2_CTRL_CS 0x2U
#define Timer2_CTRL_CS_BIT 1
#define Timer2_CTRL_SEL_MASK 0x1CU
#define Timer2_CTRL_SEL_BIT 2
#define Timer2_CTRL_CAP0_MASK 0x60U
#define Timer2_CTRL_CAP0_BIT 5
#define Timer2_CTRL_CAP1_MASK 0x180U
#define Timer2_CTRL_CAP1_BIT 7
#define Timer2_CTRL_CMP0_MASK 0x600U
#define Timer2_CTRL_CMP0_BIT 9
#define Timer2_CTRL_CMP1_MASK 0x1800U
#define Timer2_CTRL_CMP1_BIT 11
#define Timer2_CTRL_TC_MASK 0x2000U
#define Timer2_CTRL_TC 0x2000U
#define Timer2_CTRL_TC_BIT 13
#define Timer2_CTRL_PWM_MASK 0x4000U
#define Timer2_CTRL_PWM 0x4000U
#define Timer2_CTRL_PWM_BIT 14

#define Timer2_INT_CTRL (*(volatile unsigned long *)0xFFFC4054)
#define Timer2_INT_CTRL_OFFSET 0x54
#define Timer2_INT_CTRL_OVF_EN_MASK 0x1U
#define Timer2_INT_CTRL_OVF_EN 0x1U
#define Timer2_INT_CTRL_OVF_EN_BIT 0
#define Timer2_INT_CTRL_CMP0_EN_MASK 0x2U
#define Timer2_INT_CTRL_CMP0_EN 0x2U
#define Timer2_INT_CTRL_CMP0_EN_BIT 1
#define Timer2_INT_CTRL_CMP1_EN_MASK 0x4U
#define Timer2_INT_CTRL_CMP1_EN 0x4U
#define Timer2_INT_CTRL_CMP1_EN_BIT 2
#define Timer2_INT_CTRL_CAP0_EN_MASK 0x8U
#define Timer2_INT_CTRL_CAP0_EN 0x8U
#define Timer2_INT_CTRL_CAP0_EN_BIT 3
#define Timer2_INT_CTRL_CAP1_EN_MASK 0x10U
#define Timer2_INT_CTRL_CAP1_EN 0x10U
#define Timer2_INT_CTRL_CAP1_EN_BIT 4

#define Timer2_STATUS (*(volatile unsigned long *)0xFFFC4058)
#define Timer2_STATUS_OFFSET 0x58
#define Timer2_STATUS_OVF_ST_MASK 0x1U
#define Timer2_STATUS_OVF_ST 0x1U
#define Timer2_STATUS_OVF_ST_BIT 0
#define Timer2_STATUS_CMP0_ST_MASK 0x2U
#define Timer2_STATUS_CMP0_ST 0x2U
#define Timer2_STATUS_CMP0_ST_BIT 1
#define Timer2_STATUS_CMP1_ST_MASK 0x4U
#define Timer2_STATUS_CMP1_ST 0x4U
#define Timer2_STATUS_CMP1_ST_BIT 2
#define Timer2_STATUS_CAP0_ST_MASK 0x8U
#define Timer2_STATUS_CAP0_ST 0x8U
#define Timer2_STATUS_CAP0_ST_BIT 3
#define Timer2_STATUS_CAP1_ST_MASK 0x10U
#define Timer2_STATUS_CAP1_ST 0x10U
#define Timer2_STATUS_CAP1_ST_BIT 4

#define Timer2_CNT (*(volatile unsigned long *)0xFFFC405C)
#define Timer2_CNT_OFFSET 0x5C

#define Timer2_CMP0 (*(volatile unsigned long *)0xFFFC4060)
#define Timer2_CMP0_OFFSET 0x60

#define Timer2_CMP1 (*(volatile unsigned long *)0xFFFC4064)
#define Timer2_CMP1_OFFSET 0x64

#define Timer2_CAP0 (*(volatile unsigned long *)0xFFFC4068)
#define Timer2_CAP0_OFFSET 0x68

#define Timer2_CAP1 (*(volatile unsigned long *)0xFFFC406C)
#define Timer2_CAP1_OFFSET 0x6C

#define CANBUS_BASE 0xFFFC5000

#define CANBUS_MOD (*(volatile unsigned long *)0xFFFC5000)
#define CANBUS_MOD_OFFSET 0x0
#define CANBUS_MOD_RM_MASK 0x1U
#define CANBUS_MOD_RM 0x1U
#define CANBUS_MOD_RM_BIT 0
#define CANBUS_MOD_LOM_MASK 0x2U
#define CANBUS_MOD_LOM 0x2U
#define CANBUS_MOD_LOM_BIT 1
#define CANBUS_MOD_STM_MASK 0x4U
#define CANBUS_MOD_STM 0x4U
#define CANBUS_MOD_STM_BIT 2
#define CANBUS_MOD_AFM_MASK 0x8U
#define CANBUS_MOD_AFM 0x8U
#define CANBUS_MOD_AFM_BIT 3

#define CANBUS_CMR (*(volatile unsigned long *)0xFFFC5004)
#define CANBUS_CMR_OFFSET 0x4
#define CANBUS_CMR_TR_MASK 0x1U
#define CANBUS_CMR_TR 0x1U
#define CANBUS_CMR_TR_BIT 0
#define CANBUS_CMR_AT_MASK 0x2U
#define CANBUS_CMR_AT 0x2U
#define CANBUS_CMR_AT_BIT 1
#define CANBUS_CMR_RRB_MASK 0x4U
#define CANBUS_CMR_RRB 0x4U
#define CANBUS_CMR_RRB_BIT 2
#define CANBUS_CMR_CDO_MASK 0x8U
#define CANBUS_CMR_CDO 0x8U
#define CANBUS_CMR_CDO_BIT 3
#define CANBUS_CMR_SRR_MASK 0x10U
#define CANBUS_CMR_SRR 0x10U
#define CANBUS_CMR_SRR_BIT 4

#define CANBUS_SR (*(volatile unsigned long *)0xFFFC5008)
#define CANBUS_SR_OFFSET 0x8
#define CANBUS_SR_RBS_MASK 0x1U
#define CANBUS_SR_RBS 0x1U
#define CANBUS_SR_RBS_BIT 0
#define CANBUS_SR_DOS_MASK 0x2U
#define CANBUS_SR_DOS 0x2U
#define CANBUS_SR_DOS_BIT 1
#define CANBUS_SR_TBS_MASK 0x4U
#define CANBUS_SR_TBS 0x4U
#define CANBUS_SR_TBS_BIT 2
#define CANBUS_SR_TCS_MASK 0x8U
#define CANBUS_SR_TCS 0x8U
#define CANBUS_SR_TCS_BIT 3
#define CANBUS_SR_RS_MASK 0x10U
#define CANBUS_SR_RS 0x10U
#define CANBUS_SR_RS_BIT 4
#define CANBUS_SR_TS_MASK 0x20U
#define CANBUS_SR_TS 0x20U
#define CANBUS_SR_TS_BIT 5
#define CANBUS_SR_ES_MASK 0x40U
#define CANBUS_SR_ES 0x40U
#define CANBUS_SR_ES_BIT 6
#define CANBUS_SR_BS_MASK 0x80U
#define CANBUS_SR_BS 0x80U
#define CANBUS_SR_BS_BIT 7

#define CANBUS_IR (*(volatile unsigned long *)0xFFFC500C)
#define CANBUS_IR_OFFSET 0xC
#define CANBUS_IR_RI_MASK 0x1U
#define CANBUS_IR_RI 0x1U
#define CANBUS_IR_RI_BIT 0
#define CANBUS_IR_TI_MASK 0x2U
#define CANBUS_IR_TI 0x2U
#define CANBUS_IR_TI_BIT 1
#define CANBUS_IR_EI_MASK 0x4U
#define CANBUS_IR_EI 0x4U
#define CANBUS_IR_EI_BIT 2
#define CANBUS_IR_DOI_MASK 0x8U
#define CANBUS_IR_DOI 0x8U
#define CANBUS_IR_DOI_BIT 3
#define CANBUS_IR_WUI_MASK 0x10U
#define CANBUS_IR_WUI 0x10U
#define CANBUS_IR_WUI_BIT 4
#define CANBUS_IR_EPI_MASK 0x20U
#define CANBUS_IR_EPI 0x20U
#define CANBUS_IR_EPI_BIT 5
#define CANBUS_IR_ALI_MASK 0x40U
#define CANBUS_IR_ALI 0x40U
#define CANBUS_IR_ALI_BIT 6
#define CANBUS_IR_BEI_MASK 0x80U
#define CANBUS_IR_BEI 0x80U
#define CANBUS_IR_BEI_BIT 7

#define CANBUS_IER (*(volatile unsigned long *)0xFFFC5010)
#define CANBUS_IER_OFFSET 0x10
#define CANBUS_IER_RIE_MASK 0x1U
#define CANBUS_IER_RIE 0x1U
#define CANBUS_IER_RIE_BIT 0
#define CANBUS_IER_TIE_MASK 0x2U
#define CANBUS_IER_TIE 0x2U
#define CANBUS_IER_TIE_BIT 1
#define CANBUS_IER_EIE_MASK 0x4U
#define CANBUS_IER_EIE 0x4U
#define CANBUS_IER_EIE_BIT 2
#define CANBUS_IER_DOIE_MASK 0x8U
#define CANBUS_IER_DOIE 0x8U
#define CANBUS_IER_DOIE_BIT 3
#define CANBUS_IER_EPIE_MASK 0x20U
#define CANBUS_IER_EPIE 0x20U
#define CANBUS_IER_EPIE_BIT 5
#define CANBUS_IER_ALIE_MASK 0x40U
#define CANBUS_IER_ALIE 0x40U
#define CANBUS_IER_ALIE_BIT 6
#define CANBUS_IER_BEIE_MASK 0x80U
#define CANBUS_IER_BEIE 0x80U
#define CANBUS_IER_BEIE_BIT 7

#define CANBUS_BTR0 (*(volatile unsigned long *)0xFFFC5018)
#define CANBUS_BTR0_OFFSET 0x18
#define CANBUS_BTR0_BRP_MASK 0x3FU
#define CANBUS_BTR0_BRP_BIT 0
#define CANBUS_BTR0_SJW_MASK 0xC0U
#define CANBUS_BTR0_SJW_BIT 6

#define CANBUS_BTR1 (*(volatile unsigned long *)0xFFFC501C)
#define CANBUS_BTR1_OFFSET 0x1C
#define CANBUS_BTR1_TSEG_MASK 0x3FU
#define CANBUS_BTR1_TSEG_BIT 0
#define CANBUS_BTR1_SAM_MASK 0x80U
#define CANBUS_BTR1_SAM 0x80U
#define CANBUS_BTR1_SAM_BIT 7

#define CANBUS_ALC (*(volatile unsigned long *)0xFFFC502C)
#define CANBUS_ALC_OFFSET 0x2C

#define CANBUS_ECC (*(volatile unsigned long *)0xFFFC5030)
#define CANBUS_ECC_OFFSET 0x30
#define CANBUS_ECC_Segment_Code_MASK 0x1FU
#define CANBUS_ECC_Segment_Code_BIT 0
#define CANBUS_ECC_Direction_MASK 0x20U
#define CANBUS_ECC_Direction 0x20U
#define CANBUS_ECC_Direction_BIT 5
#define CANBUS_ECC_Error_Code_MASK 0xC0U
#define CANBUS_ECC_Error_Code_BIT 6

#define CANBUS_EWLR (*(volatile unsigned long *)0xFFFC5034)
#define CANBUS_EWLR_OFFSET 0x34

#define CANBUS_RXERR (*(volatile unsigned long *)0xFFFC5038)
#define CANBUS_RXERR_OFFSET 0x38

#define CANBUS_TXERR (*(volatile unsigned long *)0xFFFC503C)
#define CANBUS_TXERR_OFFSET 0x3C

#define CANBUS_ACR0 (*(volatile unsigned long *)0xFFFC5040)
#define CANBUS_ACR0_OFFSET 0x40

#define CANBUS_ACR1 (*(volatile unsigned long *)0xFFFC5044)
#define CANBUS_ACR1_OFFSET 0x44

#define CANBUS_ACR2 (*(volatile unsigned long *)0xFFFC5048)
#define CANBUS_ACR2_OFFSET 0x48

#define CANBUS_ACR3 (*(volatile unsigned long *)0xFFFC504C)
#define CANBUS_ACR3_OFFSET 0x4C

#define CANBUS_AMR0 (*(volatile unsigned long *)0xFFFC5050)
#define CANBUS_AMR0_OFFSET 0x50

#define CANBUS_AMR1 (*(volatile unsigned long *)0xFFFC5054)
#define CANBUS_AMR1_OFFSET 0x54

#define CANBUS_AMR2 (*(volatile unsigned long *)0xFFFC5058)
#define CANBUS_AMR2_OFFSET 0x58

#define CANBUS_AMR3 (*(volatile unsigned long *)0xFFFC505C)
#define CANBUS_AMR3_OFFSET 0x5C

#define CANBUS_RMC (*(volatile unsigned long *)0xFFFC5074)
#define CANBUS_RMC_OFFSET 0x74

#define CANBUS_RBSA (*(volatile unsigned long *)0xFFFC5078)
#define CANBUS_RBSA_OFFSET 0x78

#define SSP_BASE 0xFFFC6000

#define SSP_CTRL0 (*(volatile unsigned long *)0xFFFC6000)
#define SSP_CTRL0_OFFSET 0x0
#define SSP_CTRL0_DSS_MASK 0xFU
#define SSP_CTRL0_DSS_BIT 0
#define SSP_CTRL0_FRF_MASK 0x30U
#define SSP_CTRL0_FRF_BIT 4
#define SSP_CTRL0_SPO_MASK 0x40U
#define SSP_CTRL0_SPO 0x40U
#define SSP_CTRL0_SPO_BIT 6
#define SSP_CTRL0_SPH_MASK 0x80U
#define SSP_CTRL0_SPH 0x80U
#define SSP_CTRL0_SPH_BIT 7
#define SSP_CTRL0_SCR_MASK 0xFF00U
#define SSP_CTRL0_SCR_BIT 8

#define SSP_CTRL1 (*(volatile unsigned long *)0xFFFC6004)
#define SSP_CTRL1_OFFSET 0x4
#define SSP_CTRL1_RIE_MASK 0x1U
#define SSP_CTRL1_RIE 0x1U
#define SSP_CTRL1_RIE_BIT 0
#define SSP_CTRL1_TIE_MASK 0x2U
#define SSP_CTRL1_TIE 0x2U
#define SSP_CTRL1_TIE_BIT 1
#define SSP_CTRL1_RORIE_MASK 0x4U
#define SSP_CTRL1_RORIE 0x4U
#define SSP_CTRL1_RORIE_BIT 2
#define SSP_CTRL1_LBM_MASK 0x8U
#define SSP_CTRL1_LBM 0x8U
#define SSP_CTRL1_LBM_BIT 3
#define SSP_CTRL1_SSE_MASK 0x10U
#define SSP_CTRL1_SSE 0x10U
#define SSP_CTRL1_SSE_BIT 4

#define SSP_DR (*(volatile unsigned long *)0xFFFC6008)
#define SSP_DR_OFFSET 0x8

#define SSP_SR (*(volatile unsigned long *)0xFFFC600C)
#define SSP_SR_OFFSET 0xC
#define SSP_SR_TFE_MASK 0x1U
#define SSP_SR_TFE 0x1U
#define SSP_SR_TFE_BIT 0
#define SSP_SR_TNF_MASK 0x2U
#define SSP_SR_TNF 0x2U
#define SSP_SR_TNF_BIT 1
#define SSP_SR_RNE_MASK 0x4U
#define SSP_SR_RNE 0x4U
#define SSP_SR_RNE_BIT 2
#define SSP_SR_RFF_MASK 0x8U
#define SSP_SR_RFF 0x8U
#define SSP_SR_RFF_BIT 3
#define SSP_SR_BSY_MASK 0x10U
#define SSP_SR_BSY 0x10U
#define SSP_SR_BSY_BIT 4

#define SSP_CPSR (*(volatile unsigned long *)0xFFFC6010)
#define SSP_CPSR_OFFSET 0x10

#define SSP_IIR (*(volatile unsigned long *)0xFFFC6014)
#define SSP_IIR_OFFSET 0x14
#define SSP_IIR_RIS_MASK 0x1U
#define SSP_IIR_RIS 0x1U
#define SSP_IIR_RIS_BIT 0
#define SSP_IIR_TIS_MASK 0x2U
#define SSP_IIR_TIS 0x2U
#define SSP_IIR_TIS_BIT 1
#define SSP_IIR_RORIS_MASK 0x4U
#define SSP_IIR_RORIS 0x4U
#define SSP_IIR_RORIS_BIT 2

#define SSP_ICR (*(volatile unsigned long *)0xFFFC6014)
#define SSP_ICR_OFFSET 0x14

#define SSP_RXTO (*(volatile unsigned long *)0xFFFC6018)
#define SSP_RXTO_OFFSET 0x18

#define GPIO_BASE 0xFFFDC000

#define GPIO_PIDR (*(volatile unsigned long *)0xFFFDB000)
#define GPIO_PIDR_OFFSET 0xFFFFF000

#define GPIO_PJDR (*(volatile unsigned long *)0xFFFDB004)
#define GPIO_PJDR_OFFSET 0xFFFFF004

#define GPIO_PIDDR (*(volatile unsigned long *)0xFFFDB008)
#define GPIO_PIDDR_OFFSET 0xFFFFF008

#define GPIO_PGDR (*(volatile unsigned long *)0xFFFDC000)
#define GPIO_PGDR_OFFSET 0x0

#define GPIO_PHDR (*(volatile unsigned long *)0xFFFDC004)
#define GPIO_PHDR_OFFSET 0x4

#define GPIO_PGDDR (*(volatile unsigned long *)0xFFFDC008)
#define GPIO_PGDDR_OFFSET 0x8

#define GPIO_PHDDR (*(volatile unsigned long *)0xFFFDC00C)
#define GPIO_PHDDR_OFFSET 0xC

#define GPIO_PEDR (*(volatile unsigned long *)0xFFFDD000)
#define GPIO_PEDR_OFFSET 0x1000

#define GPIO_PFDR (*(volatile unsigned long *)0xFFFDD004)
#define GPIO_PFDR_OFFSET 0x1004

#define GPIO_PEDDR (*(volatile unsigned long *)0xFFFDD008)
#define GPIO_PEDDR_OFFSET 0x1008

#define GPIO_PFDDR (*(volatile unsigned long *)0xFFFDD00C)
#define GPIO_PFDDR_OFFSET 0x100C

#define GPIO_PCDR (*(volatile unsigned long *)0xFFFDE000)
#define GPIO_PCDR_OFFSET 0x2000

#define GPIO_PDDR (*(volatile unsigned long *)0xFFFDE004)
#define GPIO_PDDR_OFFSET 0x2004

#define GPIO_PCDDR (*(volatile unsigned long *)0xFFFDE008)
#define GPIO_PCDDR_OFFSET 0x2008

#define GPIO_PDDDR (*(volatile unsigned long *)0xFFFDE00C)
#define GPIO_PDDDR_OFFSET 0x200C

#define GPIO_PADR (*(volatile unsigned long *)0xFFFDF000)
#define GPIO_PADR_OFFSET 0x3000

#define GPIO_PBDR (*(volatile unsigned long *)0xFFFDF004)
#define GPIO_PBDR_OFFSET 0x3004

#define GPIO_PADDR (*(volatile unsigned long *)0xFFFDF008)
#define GPIO_PADDR_OFFSET 0x3008

#define GPIO_PBDDR (*(volatile unsigned long *)0xFFFDF00C)
#define GPIO_PBDDR_OFFSET 0x300C

#define RTC_BASE 0xFFFE0000

#define RTC_DR0 (*(volatile unsigned long *)0xFFFE0000)
#define RTC_DR0_OFFSET 0x0

#define RTC_DR1 (*(volatile unsigned long *)0xFFFE0004)
#define RTC_DR1_OFFSET 0x4

#define RTC_MR0 (*(volatile unsigned long *)0xFFFE0008)
#define RTC_MR0_OFFSET 0x8

#define RTC_MR1 (*(volatile unsigned long *)0xFFFE000C)
#define RTC_MR1_OFFSET 0xC

#define RTC_STAT (*(volatile unsigned long *)0xFFFE0010)
#define RTC_STAT_OFFSET 0x10

#define RTC_EOI (*(volatile unsigned long *)0xFFFE0010)
#define RTC_EOI_OFFSET 0x10

#define RTC_LR0 (*(volatile unsigned long *)0xFFFE0014)
#define RTC_LR0_OFFSET 0x14

#define RTC_LR1 (*(volatile unsigned long *)0xFFFE0018)
#define RTC_LR1_OFFSET 0x18

#define RTC_CTRL (*(volatile unsigned long *)0xFFFE001C)
#define RTC_CTRL_OFFSET 0x1C

#define DMA_BASE 0xFFFE1000

#define DMA0_SourceLo (*(volatile unsigned long *)0xFFFE1000)
#define DMA0_SourceLo_OFFSET 0x0

#define DMA0_SourceHi (*(volatile unsigned long *)0xFFFE1004)
#define DMA0_SourceHi_OFFSET 0x4

#define DMA0_DestLo (*(volatile unsigned long *)0xFFFE1008)
#define DMA0_DestLo_OFFSET 0x8

#define DMA0_DestHi (*(volatile unsigned long *)0xFFFE100C)
#define DMA0_DestHi_OFFSET 0xC

#define DMA0_Max (*(volatile unsigned long *)0xFFFE1010)
#define DMA0_Max_OFFSET 0x10

#define DMA0_Ctrl (*(volatile unsigned long *)0xFFFE1014)
#define DMA0_Ctrl_OFFSET 0x14

#define DMA0_SoCurrHi (*(volatile unsigned long *)0xFFFE1018)
#define DMA0_SoCurrHi_OFFSET 0x18

#define DMA0_SoCurrLo (*(volatile unsigned long *)0xFFFE101C)
#define DMA0_SoCurrLo_OFFSET 0x1C

#define DMA0_DeCurrHi (*(volatile unsigned long *)0xFFFE1020)
#define DMA0_DeCurrHi_OFFSET 0x20

#define DMA0_DeCurrLo (*(volatile unsigned long *)0xFFFE1024)
#define DMA0_DeCurrLo_OFFSET 0x24

#define DMA0_Tcnt (*(volatile unsigned long *)0xFFFE1028)
#define DMA0_Tcnt_OFFSET 0x28

#define DMA1_SourceLo (*(volatile unsigned long *)0xFFFE1040)
#define DMA1_SourceLo_OFFSET 0x40

#define DMA1_SourceHi (*(volatile unsigned long *)0xFFFE1044)
#define DMA1_SourceHi_OFFSET 0x44

#define DMA1_DestLo (*(volatile unsigned long *)0xFFFE1048)
#define DMA1_DestLo_OFFSET 0x48

#define DMA1_DestHi (*(volatile unsigned long *)0xFFFE104C)
#define DMA1_DestHi_OFFSET 0x4C

#define DMA1_Max (*(volatile unsigned long *)0xFFFE1050)
#define DMA1_Max_OFFSET 0x50

#define DMA1_Ctrl (*(volatile unsigned long *)0xFFFE1054)
#define DMA1_Ctrl_OFFSET 0x54

#define DMA1_SoCurrHi (*(volatile unsigned long *)0xFFFE1058)
#define DMA1_SoCurrHi_OFFSET 0x58

#define DMA1_SoCurrLo (*(volatile unsigned long *)0xFFFE105C)
#define DMA1_SoCurrLo_OFFSET 0x5C

#define DMA1_DeCurrHi (*(volatile unsigned long *)0xFFFE1060)
#define DMA1_DeCurrHi_OFFSET 0x60

#define DMA1_DeCurrLo (*(volatile unsigned long *)0xFFFE1064)
#define DMA1_DeCurrLo_OFFSET 0x64

#define DMA1_Tcnt (*(volatile unsigned long *)0xFFFE1068)
#define DMA1_Tcnt_OFFSET 0x68

#define DMA2_SourceLo (*(volatile unsigned long *)0xFFFE1080)
#define DMA2_SourceLo_OFFSET 0x80

#define DMA2_SourceHi (*(volatile unsigned long *)0xFFFE1084)
#define DMA2_SourceHi_OFFSET 0x84

#define DMA2_DestLo (*(volatile unsigned long *)0xFFFE1088)
#define DMA2_DestLo_OFFSET 0x88

#define DMA2_DestHi (*(volatile unsigned long *)0xFFFE108C)
#define DMA2_DestHi_OFFSET 0x8C

#define DMA2_Max (*(volatile unsigned long *)0xFFFE1090)
#define DMA2_Max_OFFSET 0x90

#define DMA2_Ctrl (*(volatile unsigned long *)0xFFFE1094)
#define DMA2_Ctrl_OFFSET 0x94

#define DMA2_SoCurrHi (*(volatile unsigned long *)0xFFFE1098)
#define DMA2_SoCurrHi_OFFSET 0x98

#define DMA2_SoCurrLo (*(volatile unsigned long *)0xFFFE109C)
#define DMA2_SoCurrLo_OFFSET 0x9C

#define DMA2_DeCurrHi (*(volatile unsigned long *)0xFFFE10A0)
#define DMA2_DeCurrHi_OFFSET 0xA0

#define DMA2_DeCurrLo (*(volatile unsigned long *)0xFFFE10A4)
#define DMA2_DeCurrLo_OFFSET 0xA4

#define DMA2_Tcnt (*(volatile unsigned long *)0xFFFE10A8)
#define DMA2_Tcnt_OFFSET 0xA8

#define DMA3_SourceLo (*(volatile unsigned long *)0xFFFE10C0)
#define DMA3_SourceLo_OFFSET 0xC0

#define DMA3_SourceHi (*(volatile unsigned long *)0xFFFE10C4)
#define DMA3_SourceHi_OFFSET 0xC4

#define DMA3_DestLo (*(volatile unsigned long *)0xFFFE10C8)
#define DMA3_DestLo_OFFSET 0xC8

#define DMA3_DestHi (*(volatile unsigned long *)0xFFFE10CC)
#define DMA3_DestHi_OFFSET 0xCC

#define DMA3_Max (*(volatile unsigned long *)0xFFFE10D0)
#define DMA3_Max_OFFSET 0xD0

#define DMA3_Ctrl (*(volatile unsigned long *)0xFFFE10D4)
#define DMA3_Ctrl_OFFSET 0xD4

#define DMA3_SoCurrHi (*(volatile unsigned long *)0xFFFE10D8)
#define DMA3_SoCurrHi_OFFSET 0xD8

#define DMA3_SoCurrLo (*(volatile unsigned long *)0xFFFE10DC)
#define DMA3_SoCurrLo_OFFSET 0xDC

#define DMA3_DeCurrHi (*(volatile unsigned long *)0xFFFE10E0)
#define DMA3_DeCurrHi_OFFSET 0xE0

#define DMA3_DeCurrLo (*(volatile unsigned long *)0xFFFE10E4)
#define DMA3_DeCurrLo_OFFSET 0xE4

#define DMA3_Tcnt (*(volatile unsigned long *)0xFFFE10E8)
#define DMA3_Tcnt_OFFSET 0xE8

#define DMA_Mask (*(volatile unsigned long *)0xFFFE10F0)
#define DMA_Mask_OFFSET 0xF0

#define DMA_Clr (*(volatile unsigned long *)0xFFFE10F4)
#define DMA_Clr_OFFSET 0xF4

#define DMA_Status (*(volatile unsigned long *)0xFFFE10F8)
#define DMA_Status_OFFSET 0xF8

#define RCPC_BASE 0xFFFE2000

#define RCPC_Ctrl (*(volatile unsigned long *)0xFFFE2000)
#define RCPC_Ctrl_OFFSET 0x0

#define RCPC_Identification (*(volatile unsigned long *)0xFFFE2004)
#define RCPC_Identification_OFFSET 0x4

#define RCPC_Remap (*(volatile unsigned long *)0xFFFE2008)
#define RCPC_Remap_OFFSET 0x8

#define RCPC_SoftReset (*(volatile unsigned long *)0xFFFE200C)
#define RCPC_SoftReset_OFFSET 0xC

#define RCPC_ResetStatus (*(volatile unsigned long *)0xFFFE2010)
#define RCPC_ResetStatus_OFFSET 0x10

#define RCPC_ResetStatusClr (*(volatile unsigned long *)0xFFFE2014)
#define RCPC_ResetStatusClr_OFFSET 0x14

#define RCPC_SysClkPrescaler (*(volatile unsigned long *)0xFFFE2018)
#define RCPC_SysClkPrescaler_OFFSET 0x18

#define RCPC_APBPeriphClkCtrl0 (*(volatile unsigned long *)0xFFFE2024)
#define RCPC_APBPeriphClkCtrl0_OFFSET 0x24

#define RCPC_APBPeriphClkCtrl1 (*(volatile unsigned long *)0xFFFE2028)
#define RCPC_APBPeriphClkCtrl1_OFFSET 0x28

#define RCPC_AHBClkCtrl (*(volatile unsigned long *)0xFFFE202C)
#define RCPC_AHBClkCtrl_OFFSET 0x2C

#define RCPC_LCDPrescaler (*(volatile unsigned long *)0xFFFE2040)
#define RCPC_LCDPrescaler_OFFSET 0x40

#define RCPC_SSPPrescaler (*(volatile unsigned long *)0xFFFE2044)
#define RCPC_SSPPrescaler_OFFSET 0x44

#define RCPC_IntConfig (*(volatile unsigned long *)0xFFFE2080)
#define RCPC_IntConfig_OFFSET 0x80

#define RCPC_IntClear (*(volatile unsigned long *)0xFFFE2084)
#define RCPC_IntClear_OFFSET 0x84

#define WDT_BASE 0xFFFE3000

#define WDT_CTRL (*(volatile unsigned long *)0xFFFE3000)
#define WDT_CTRL_OFFSET 0x0

#define WDT_CNTR (*(volatile unsigned long *)0xFFFE3004)
#define WDT_CNTR_OFFSET 0x4

#define WDT_TSTR (*(volatile unsigned long *)0xFFFE3008)
#define WDT_TSTR_OFFSET 0x8

#define WDT_CNT0 (*(volatile unsigned long *)0xFFFE300C)
#define WDT_CNT0_OFFSET 0xC

#define WDT_CNT1 (*(volatile unsigned long *)0xFFFE3010)
#define WDT_CNT1_OFFSET 0x10

#define WDT_CNT2 (*(volatile unsigned long *)0xFFFE3014)
#define WDT_CNT2_OFFSET 0x14

#define WDT_CNT3 (*(volatile unsigned long *)0xFFFE3018)
#define WDT_CNT3_OFFSET 0x18

#define ALI_BASE 0xFFFE4000

#define ALI_Setup (*(volatile unsigned long *)0xFFFE4000)
#define ALI_Setup_OFFSET 0x0

#define ALI_CTRL (*(volatile unsigned long *)0xFFFE4004)
#define ALI_CTRL_OFFSET 0x4

#define ALI_Timing1 (*(volatile unsigned long *)0xFFFE4008)
#define ALI_Timing1_OFFSET 0x8

#define ALI_Timing2 (*(volatile unsigned long *)0xFFFE400C)
#define ALI_Timing2_OFFSET 0xC

#define IOCON_BASE 0xFFFE5000

#define IOCON_EBI_MUX (*(volatile unsigned long *)0xFFFE5000)
#define IOCON_EBI_MUX_OFFSET 0x0

#define IOCON_PD_MUX (*(volatile unsigned long *)0xFFFE5004)
#define IOCON_PD_MUX_OFFSET 0x4

#define IOCON_PE_MUX (*(volatile unsigned long *)0xFFFE5008)
#define IOCON_PE_MUX_OFFSET 0x8

#define IOCON_TIMER_MUX (*(volatile unsigned long *)0xFFFE500C)
#define IOCON_TIMER_MUX_OFFSET 0xC

#define IOCON_LCD_MUX (*(volatile unsigned long *)0xFFFE5010)
#define IOCON_LCD_MUX_OFFSET 0x10

#define IOCON_PA_RES_MUX (*(volatile unsigned long *)0xFFFE5014)
#define IOCON_PA_RES_MUX_OFFSET 0x14

#define IOCON_PB_RES_MUX (*(volatile unsigned long *)0xFFFE5018)
#define IOCON_PB_RES_MUX_OFFSET 0x18

#define IOCON_PC_RES_MUX (*(volatile unsigned long *)0xFFFE501C)
#define IOCON_PC_RES_MUX_OFFSET 0x1C

#define IOCON_PD_RES_MUX (*(volatile unsigned long *)0xFFFE5020)
#define IOCON_PD_RES_MUX_OFFSET 0x20

#define IOCON_PE_RES_MUX (*(volatile unsigned long *)0xFFFE5024)
#define IOCON_PE_RES_MUX_OFFSET 0x24

#define IOCON_ADC_MUX (*(volatile unsigned long *)0xFFFE5028)
#define IOCON_ADC_MUX_OFFSET 0x28

#define SMC_BASE 0xFFFF1000

#define SMC_BCR0 (*(volatile unsigned long *)0xFFFF1000)
#define SMC_BCR0_OFFSET 0x0

#define SMC_BCR1 (*(volatile unsigned long *)0xFFFF1004)
#define SMC_BCR1_OFFSET 0x4

#define SMC_BCR2 (*(volatile unsigned long *)0xFFFF1008)
#define SMC_BCR2_OFFSET 0x8

#define SMC_BCR3 (*(volatile unsigned long *)0xFFFF100C)
#define SMC_BCR3_OFFSET 0xC

#define CLCDC_BASE 0xFFFF4000

#define CLCDC_Timing0 (*(volatile unsigned long *)0xFFFF4000)
#define CLCDC_Timing0_OFFSET 0x0

#define CLCDC_Timing1 (*(volatile unsigned long *)0xFFFF4004)
#define CLCDC_Timing1_OFFSET 0x4

#define CLCDC_Timing2 (*(volatile unsigned long *)0xFFFF4008)
#define CLCDC_Timing2_OFFSET 0x8

#define CLCDC_UPBASE (*(volatile unsigned long *)0xFFFF4010)
#define CLCDC_UPBASE_OFFSET 0x10

#define CLCDC_LPBASE (*(volatile unsigned long *)0xFFFF4014)
#define CLCDC_LPBASE_OFFSET 0x14

#define CLCDC_INTRENABLE (*(volatile unsigned long *)0xFFFF4018)
#define CLCDC_INTRENABLE_OFFSET 0x18

#define CLCDC_Ctrl (*(volatile unsigned long *)0xFFFF401C)
#define CLCDC_Ctrl_OFFSET 0x1C

#define CLCDC_Status (*(volatile unsigned long *)0xFFFF4020)
#define CLCDC_Status_OFFSET 0x20

#define CLCDC_Interrupt (*(volatile unsigned long *)0xFFFF4024)
#define CLCDC_Interrupt_OFFSET 0x24

#define CLCDC_UPCURR (*(volatile unsigned long *)0xFFFF4028)
#define CLCDC_UPCURR_OFFSET 0x28

#define CLCDC_LPCURR (*(volatile unsigned long *)0xFFFF402C)
#define CLCDC_LPCURR_OFFSET 0x2C

#define CLCDC_Palette0 (*(volatile unsigned long *)0xFFFF4200)
#define CLCDC_Palette0_OFFSET 0x200

#define VIC_BASE 0xFFFFF000

#define VIC_IRQStatus (*(volatile unsigned long *)0xFFFFF000)
#define VIC_IRQStatus_OFFSET 0x0

#define VIC_FIQStatus (*(volatile unsigned long *)0xFFFFF004)
#define VIC_FIQStatus_OFFSET 0x4

#define VIC_RawIntr (*(volatile unsigned long *)0xFFFFF008)
#define VIC_RawIntr_OFFSET 0x8

#define VIC_IntSelect (*(volatile unsigned long *)0xFFFFF00C)
#define VIC_IntSelect_OFFSET 0xC

#define VIC_IntEnable (*(volatile unsigned long *)0xFFFFF010)
#define VIC_IntEnable_OFFSET 0x10

#define VIC_IntEnClear (*(volatile unsigned long *)0xFFFFF014)
#define VIC_IntEnClear_OFFSET 0x14

#define VIC_SoftInt (*(volatile unsigned long *)0xFFFFF018)
#define VIC_SoftInt_OFFSET 0x18

#define VIC_SoftIntClear (*(volatile unsigned long *)0xFFFFF01C)
#define VIC_SoftIntClear_OFFSET 0x1C

#define VIC_VectAddr (*(volatile unsigned long *)0xFFFFF030)
#define VIC_VectAddr_OFFSET 0x30

#define VIC_DefVecAddr (*(volatile unsigned long *)0xFFFFF034)
#define VIC_DefVecAddr_OFFSET 0x34

#define VIC_VectAddr0 (*(volatile unsigned long *)0xFFFFF100)
#define VIC_VectAddr0_OFFSET 0x100

#define VIC_VectAddr1 (*(volatile unsigned long *)0xFFFFF104)
#define VIC_VectAddr1_OFFSET 0x104

#define VIC_VectAddr2 (*(volatile unsigned long *)0xFFFFF108)
#define VIC_VectAddr2_OFFSET 0x108

#define VIC_VectAddr3 (*(volatile unsigned long *)0xFFFFF10C)
#define VIC_VectAddr3_OFFSET 0x10C

#define VIC_VectAddr4 (*(volatile unsigned long *)0xFFFFF110)
#define VIC_VectAddr4_OFFSET 0x110

#define VIC_VectAddr5 (*(volatile unsigned long *)0xFFFFF114)
#define VIC_VectAddr5_OFFSET 0x114

#define VIC_VectAddr6 (*(volatile unsigned long *)0xFFFFF118)
#define VIC_VectAddr6_OFFSET 0x118

#define VIC_VectAddr7 (*(volatile unsigned long *)0xFFFFF11C)
#define VIC_VectAddr7_OFFSET 0x11C

#define VIC_VectAddr8 (*(volatile unsigned long *)0xFFFFF120)
#define VIC_VectAddr8_OFFSET 0x120

#define VIC_VectAddr9 (*(volatile unsigned long *)0xFFFFF124)
#define VIC_VectAddr9_OFFSET 0x124

#define VIC_VectAddr10 (*(volatile unsigned long *)0xFFFFF128)
#define VIC_VectAddr10_OFFSET 0x128

#define VIC_VectAddr11 (*(volatile unsigned long *)0xFFFFF12C)
#define VIC_VectAddr11_OFFSET 0x12C

#define VIC_VectAddr12 (*(volatile unsigned long *)0xFFFFF130)
#define VIC_VectAddr12_OFFSET 0x130

#define VIC_VectAddr13 (*(volatile unsigned long *)0xFFFFF134)
#define VIC_VectAddr13_OFFSET 0x134

#define VIC_VectAddr14 (*(volatile unsigned long *)0xFFFFF138)
#define VIC_VectAddr14_OFFSET 0x138

#define VIC_VectAddr15 (*(volatile unsigned long *)0xFFFFF13C)
#define VIC_VectAddr15_OFFSET 0x13C

#define VIC_VectCtrl0 (*(volatile unsigned long *)0xFFFFF200)
#define VIC_VectCtrl0_OFFSET 0x200

#define VIC_VectCtrl1 (*(volatile unsigned long *)0xFFFFF204)
#define VIC_VectCtrl1_OFFSET 0x204

#define VIC_VectCtrl2 (*(volatile unsigned long *)0xFFFFF208)
#define VIC_VectCtrl2_OFFSET 0x208

#define VIC_VectCtrl3 (*(volatile unsigned long *)0xFFFFF20C)
#define VIC_VectCtrl3_OFFSET 0x20C

#define VIC_VectCtrl4 (*(volatile unsigned long *)0xFFFFF210)
#define VIC_VectCtrl4_OFFSET 0x210

#define VIC_VectCtrl5 (*(volatile unsigned long *)0xFFFFF214)
#define VIC_VectCtrl5_OFFSET 0x214

#define VIC_VectCtrl6 (*(volatile unsigned long *)0xFFFFF218)
#define VIC_VectCtrl6_OFFSET 0x218

#define VIC_VectCtrl7 (*(volatile unsigned long *)0xFFFFF21C)
#define VIC_VectCtrl7_OFFSET 0x21C

#define VIC_VectCtrl8 (*(volatile unsigned long *)0xFFFFF220)
#define VIC_VectCtrl8_OFFSET 0x220

#define VIC_VectCtrl9 (*(volatile unsigned long *)0xFFFFF224)
#define VIC_VectCtrl9_OFFSET 0x224

#define VIC_VectCtrl10 (*(volatile unsigned long *)0xFFFFF228)
#define VIC_VectCtrl10_OFFSET 0x228

#define VIC_VectCtrl11 (*(volatile unsigned long *)0xFFFFF22C)
#define VIC_VectCtrl11_OFFSET 0x22C

#define VIC_VectCtrl12 (*(volatile unsigned long *)0xFFFFF230)
#define VIC_VectCtrl12_OFFSET 0x230

#define VIC_VectCtrl13 (*(volatile unsigned long *)0xFFFFF234)
#define VIC_VectCtrl13_OFFSET 0x234

#define VIC_VectCntl14 (*(volatile unsigned long *)0xFFFFF238)
#define VIC_VectCntl14_OFFSET 0x238

#define VIC_VectCntl15 (*(volatile unsigned long *)0xFFFFF23C)
#define VIC_VectCntl15_OFFSET 0x23C


#endif
