/******************************************************************************
  Target Script for ATMEL AT91SAM7AX.

  Copyright (c) 2005 Rowley Associates Limited.

  This file may be distributed under the terms of the License Agreement
  provided with this software.

  THIS FILE IS PROVIDED AS IS WITH NO WARRANTY OF ANY KIND, INCLUDING THE
  WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
 ******************************************************************************/

function Reset()
{
  // Get the target interface into debug state for the peeks and pokes
  TargetInterface.beginDebugAccess();
  // Set a breakpoint on reset vector
  TargetInterface.setICEBreakerBreakpoint(0, 0x00000000, 0xFFFFFFFF, 0x00000000, 0xFFFFFFFF, 0x100, 0xF7);
  // WD_MR - Setup watchdog timer
  TargetInterface.pokeWord(0xFFFA0064, 0x37000000);
  // WD_OMR - Enable watchdog and internal reset 
  TargetInterface.pokeWord(0xFFFA0068, 0x2343);
  TargetInterface.delay(200);

  // Release target from debug state.
  TargetInterface.endDebugAccess(true);

  TargetInterface.waitForDebugState(1000);
  TargetInterface.trst();
}

function RAMReset()
{
  Reset();
  TargetInterface.pokeWord(0xFFE00000, 0x400030A5);
  TargetInterface.pokeWord(0xFFE00004, 0x48003081);
  TargetInterface.pokeWord(0xFFE00024, 0x40000017);
  // AMC_RCR - Switch to remap mode
  TargetInterface.pokeWord(0xFFE00020, 1);

}

function FLASHReset()
{
  Reset();
}

