// Copyright (c) 2001-2005 Rowley Associates Limited.
//
// This file may be distributed under the terms of the License Agreement
// provided with this software.
//
// THIS FILE IS PROVIDED AS IS WITH NO WARRANTY OF ANY KIND, INCLUDING THE
// WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
//
////////////////////////////////////////////////////////////////////////////////
//
//                theARMPatch LPC SBC2 Interrupt Example
//
// Description
// -----------
// This example demonstrates setting up interrupt handlers. Press the BOOT
// button to generate an interrupt.
//
////////////////////////////////////////////////////////////////////////////////

#include <targets/LPC22xx.h>

#define EINT1_INT 15

static int isrCount = 0;

static void buttonISR(void) __attribute__ ((interrupt ("IRQ")));

static void
buttonISR(void)
{
  ++isrCount;
  EXTINT = 2; /* Clear the interrupt */
  VICVectAddr = 0; /* Update VIC priorities */
}

int
main(void)
{
  PINSEL0 |= 2 << 28; /* Configure P0.14 for alternate function EINT1 */
  EXTMODE = 2; /* Make EINT1 edge sensitive */
  EXTPOLAR = 2; /* Make EINT1 rising edge sensitive */
  VICIntSelect &= ~(1 << EINT1_INT); /* IRQ interrupt */
  VICVectCntl0 = (1 << 5) | EINT1_INT; /* Use slot 0 for button interrupt */
  VICVectAddr0 = (unsigned int)buttonISR; /* Setup button ISR */
  VICIntEnable |= 1 << EINT1_INT;  

  __ARMLIB_enableIRQ(); /* Enable global interrupts */
  
  while (isrCount < 5);

  return 0; 
}
