// Copyright (c) 2001-2005 Rowley Associates Limited.
//
// This file may be distributed under the terms of the License Agreement
// provided with this software.
//
// THIS FILE IS PROVIDED AS IS WITH NO WARRANTY OF ANY KIND, INCLUDING THE
// WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
//
////////////////////////////////////////////////////////////////////////////////
//
//                    TMS470 Timer Interrupt Example
//
// Description
// -----------
// This example demonstrates a simple interrupt handler and setting up a timer.
//
////////////////////////////////////////////////////////////////////////////////

#include <targets/TMS470.h>

#define RTI_CMP2_INT 1
#define RTI_CMP1_INT 2

void irq_handler(void) __attribute__ ((interrupt ("IRQ")));

void
irq_handler(void)
{
  switch ((0xFF & IRQIVEC) - 1)
    {
      case RTI_CMP1_INT:
        RTICMP1 += 1000;       /* Setup the next CMP1 interrupt */
        RTICINT &= ~0x80;      /* Clear CM1 flag */
        HETDOUT ^= 0x0000FFFF; /* Toggle LEDs */
        break;
      case RTI_CMP2_INT:
        RTICMP2 += 1000000;    /* Setup the next CMP2 interrupt */
        RTICINT &= ~0x40;      /* Clear CMP2 flag */
        HETDOUT ^= 0xFFFF0000; /* Toggle LEDs */
        break;
    }
}

int
main(void)
{
  /* Enable global IRQ interrupts */
  __ARMLIB_enableIRQ();

  /* Initialise LEDs */
  HETDIR  = 0xFFFFFFFF;
  HETDOUT = 0xFFFFFFFF;

  /* Initialise RTI */
  RTICMP1 = 0;
  RTICMP2 = 0;
  RTIPCTL = 11; /* Clock timer counter at 1Mhz */
  REQMASK = (1 << RTI_CMP1_INT) | (1 << RTI_CMP2_INT); /* Unmask CMP1 and CMP2 interrupts */
  RTICINT |= 0x30; /* Enable CMP1 and CMP2 interrupts */

  /* Infinite loop */
  for (;;);

  return 0; 
}
