// Copyright (c) 2004 Rowley Associates Limited.
//
// This file may be distributed under the terms of the License Agreement
// provided with this software.
//
// THIS FILE IS PROVIDED AS IS WITH NO WARRANTY OF ANY KIND, INCLUDING THE
// WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
//
////////////////////////////////////////////////////////////////////////////////
//
//                TMS-FET470A256 Specific ctl example code
//
// Description
// -----------
// This module contains the MCB2100 specific source code for running the CTL
// examples.
// NOTE: For the button press examples to run properly, J7 should be set.
//
////////////////////////////////////////////////////////////////////////////////

#include "test.h"
#include <ctl_api.h>
#include <targets/TMS470.h>

#define BUTTON1 2
#define BUTTON2 3

#define GIO_INT_A 5
#define GIO_INT_B 29

void
BoardInit(void)
{
  /* Initialise LEDs */
  HETDIR  = 0xFFFFFFFF;
  HETDOUT = 0xFFFFFFFF;
}

unsigned long
TicksPerSecond(void)
{
  return 1000;
}

static CTL_ISR_FN_t userButtonISR;
static void
buttonISR(void)
{
  GIOFLG1 = GIOFLG1;
  ctl_mask_isr(GIO_INT_B); /* Prevent re-entry of ISR if interrupts are re-enabled within ISR */
  userButtonISR();
  ctl_unmask_isr(GIO_INT_B);
}

void
SetButtonPressedISR(CTL_ISR_FN_t isr)
{
  userButtonISR = isr;
  // P0.14 to alternate function 2 (EINT1)
  GIOENA1 |= (1 << BUTTON1) | (1 << BUTTON2); /* Enable button interrupts */
  ctl_set_isr(GIO_INT_B, 1, CTL_ISR_TRIGGER_FIXED, buttonISR, 0);
  ctl_unmask_isr(GIO_INT_B);
}

void
SetLeds(unsigned v)
{
  HETDOUT = v ? 0x00000000 : 0xFFFFFFFF;
}
