// Copyright (c) 2001-2004 Rowley Associates Limited.
//
// This file may be distributed under the terms of the License Agreement
// provided with this software.
//
// THIS FILE IS PROVIDED AS IS WITH NO WARRANTY OF ANY KIND, INCLUDING THE
// WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
//
////////////////////////////////////////////////////////////////////////////////
//
//                        Revely RMS101 LED Example
//
// Description
// -----------
// This example demonstrates writing to the GPIO ports and also how to place
// functions into the .fast section.
//
////////////////////////////////////////////////////////////////////////////////

#include <targets/LH79520.h>

extern void delay(volatile unsigned int d);

static void
cycle(int n)
{
  int m = 0;
  for (; n; m++, n--)
    {
      GPIOPFDR &= ~2;
      delay(m);
      GPIOPFDR |= 2;
      delay(n);
    }

  for (; m; m--, n++)
    {
      GPIOPFDR &= ~2;
      delay(m);
      GPIOPFDR |= 2;
      delay(n);
    }
}

int
main(void)
{
  int i, j;
  GPIOPFDDR = 2;
  while (1)
    {
      cycle(300);
      cycle(500);
      delay(200000);
    }
  return 0;
}
