// Copyright (c) 2001-2004 Rowley Associates Limited.
//
// This file may be distributed under the terms of the License Agreement
// provided with this software.
//
// THIS FILE IS PROVIDED AS IS WITH NO WARRANTY OF ANY KIND, INCLUDING THE
// WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
//
////////////////////////////////////////////////////////////////////////////////
//
//                        Revely RMS100 LED Example
//
// Description
// -----------
// This example demonstrates writing to the GPIO ports and also how to place
// functions into the .fast section.
//
////////////////////////////////////////////////////////////////////////////////

#include <targets/LH754xx.h>

extern void delay(volatile unsigned int d);

static void
cycle(int n)
{
  int m = 0;
  for (; n; m++, n--)
    {
      GPIO_PCDR |= 0xC0;
      delay(m);
      GPIO_PCDR &= ~0xC0;
      delay(n);
    }

  for (; m; m--, n++)
    {
      GPIO_PCDR |= 0xC0;
      delay(m);
      GPIO_PCDR &= ~0xC0;
      delay(n);
    }
}

int
main(void)
{
  int i, j;
  GPIO_PCDDR = 0xC0; 
  while (1)
    {
      cycle(300);
      cycle(500);
      delay(200000);
    }
  return 0;
}
