// Copyright (c) 2001-2004 Rowley Associates Limited.
//
// This file may be distributed under the terms of the License Agreement
// provided with this software.
//
// THIS FILE IS PROVIDED AS IS WITH NO WARRANTY OF ANY KIND, INCLUDING THE
// WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
//
////////////////////////////////////////////////////////////////////////////////
//
//                      Keil MCB2100 LED Example
//
// Description
// -----------
// This example demonstrates writing to the programmable peripheral interface.
//
////////////////////////////////////////////////////////////////////////////////

#include <targets/LPC21xx.h>

#define NUM_LEDS 8

static void
ledInit()
{
  IO1DIR |= 0xFF << 16;
  IO1SET = 0xFF << 16;
}

static void
ledOn(int led)
{
  IO1SET = 1 << (16 + led);
}

static void
ledOff(int led)
{
  IO1CLR = 1 << (16 + led);
}

void
delay(int d)
{     
  for(; d; --d);
}
 
int
main(void)
{
  int i;
  MAMCR = 2;
  ledInit();
  while (1)
    {
      for (i = 0; i < NUM_LEDS; ++i)
        { 
          ledOn(i);
          delay(20000);
        } 
      for (i = 0; i < NUM_LEDS; ++i)
        { 
          ledOff(i);
          delay(20000);
        } 
      for (i = NUM_LEDS - 1; i >= 0; --i)
        { 
          ledOn(i);
          delay(20000);
        } 
      for (i = NUM_LEDS - 1; i >= 0; --i)
        { 
          ledOff(i);
          delay(20000);
        }
    }

  return 0;
}


