// Copyright (c) 2005 Rowley Associates Limited.
//
// This file may be distributed under the terms of the License Agreement
// provided with this software.
//
// THIS FILE IS PROVIDED AS IS WITH NO WARRANTY OF ANY KIND, INCLUDING THE
// WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.

#include "test.h"
#include <ctl_api.h>
#include <targets/LH79524.h>

#define BUTTON_INT 0

#define EXTENDED_GPIO_REG *((volatile unsigned char *)0x4CB00000)

void
BoardInit(void)
{
  EXTENDED_GPIO_REG |= 6;
}

unsigned long
TicksPerSecond(void)
{
  return 1000;
}

void
SetButtonPressedISR(CTL_ISR_FN_t isr)
{
}

void
SetLeds(unsigned v)
{
  if (v)
    EXTENDED_GPIO_REG &= ~6;
  else
    EXTENDED_GPIO_REG |= 6;
}
