// Copyright (c) 2004 Rowley Associates Limited.
//
// This file may be distributed under the terms of the License Agreement
// provided with this software.
//
// THIS FILE IS PROVIDED AS IS WITH NO WARRANTY OF ANY KIND, INCLUDING THE
// WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.

#include "test.h"
#include <ctl_api.h>
#include <targets/LH79520.h>

#define BUTTON_INT 0

#define EXTENDED_GPIO_REG *((volatile unsigned char *)0x55600000)

void
BoardInit(void)
{
  EXTENDED_GPIO_REG |= 3;
}

unsigned long
TicksPerSecond(void)
{
  return 1000;
}

static CTL_ISR_FN_t userButtonISR;
static void
buttonISR(void)
{
  userButtonISR();
  /* Clear the timer 0 interrupt */
  IntClear = 1 << BUTTON_INT;
}

void
SetButtonPressedISR(CTL_ISR_FN_t isr)
{
  userButtonISR = isr;
  ctl_set_isr(BUTTON_INT, 1, CTL_ISR_TRIGGER_FIXED, buttonISR, 0);
  ctl_unmask_isr(BUTTON_INT);
}

void
SetLeds(unsigned v)
{
  if (v)
    EXTENDED_GPIO_REG &= ~3;
  else
    EXTENDED_GPIO_REG |= 3;
}
