// Copyright (c) 2004 Rowley Associates Limited.
//
// This file may be distributed under the terms of the License Agreement
// provided with this software.
//
// THIS FILE IS PROVIDED AS IS WITH NO WARRANTY OF ANY KIND, INCLUDING THE
// WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.

#include "test.h"
#include <ctl_api.h>
#include <targets/AX07CF192.h>

unsigned long idleCount;

static CTL_ISR_FN_t userTimerISR;

static void
timerISR(void)
{
  userTimerISR();
  /* Clear the timer interrupt */
  TSR0;
}

void
SetTimerISR(CTL_ISR_FN_t isr)
{
  userTimerISR = isr;
  TCR0 = 0; /* Free running, BCLK/2 */
  TIER0 |= 0x4; /* Enable overflow interrupt */
  TSTARTR |= 1; /* Start timer */
  ctl_set_isr(14, 0, CTL_ISR_TRIGGER_POSITIVE_EDGE, timerISR, 0);
  ctl_unmask_isr(14);
}

void
Idle(void)
{
  ++idleCount;
  /* Enter halt mode */
}
