// Copyright (c) 2005 Rowley Associates Limited.
//
// This file may be distributed under the terms of the License Agreement
// provided with this software.
//
// THIS FILE IS PROVIDED AS IS WITH NO WARRANTY OF ANY KIND, INCLUDING THE
// WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.

#include "test.h"
#include <ctl_api.h>
#include <targets/AT91SAM7A1.h>

#define IRQ0_INT 28

void
BoardInit(void)
{  
  /* Setup LEDs */
  GPT0C0_ECR = 0x00000001;
  GPT0C0_PER = 0x00020000;
  GPT0C0_OER = 0x00020000;
  GPT0C0_CODR = 0x00020000;
}

void
SetButtonPressedISR(CTL_ISR_FN_t isr)
{
  ctl_set_isr(IRQ0_INT, 0, CTL_ISR_TRIGGER_POSITIVE_EDGE, isr, 0);
  ctl_unmask_isr(IRQ0_INT);
}

void
SetLeds(unsigned v)
{
  if (v)
    GPT0C0_SODR = 0x00020000;
  else
    GPT0C0_CODR = 0x00020000;
}
