// Copyright (c) 2004 Rowley Associates Limited.
//
// This file may be distributed under the terms of the License Agreement
// provided with this software.
//
// THIS FILE IS PROVIDED AS IS WITH NO WARRANTY OF ANY KIND, INCLUDING THE
// WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.

#include "test.h"
#include <ctl_api.h>
#include <targets/AT91SAM7A1.h>

#define ST0_INT 24

#define CORECLK_FREQUENCY 30000000

static CTL_ISR_FN_t userTimerISR;

unsigned long idleCount;

static int count;

static void
timerISR(void)
{
  userTimerISR();
  ST0_CSR = 1 << 0; // Clear timer interrupt
}

void
SetTimerISR(CTL_ISR_FN_t isr)
{
  userTimerISR = isr;
#if 1
  ctl_set_isr(ST0_INT, 1, CTL_ISR_TRIGGER_LOW_LEVEL, timerISR, 0);
  ctl_unmask_isr(ST0_INT);

  ST0_ECR = 1 << 1; // Enable simple timer clock
  ST0_CR = 1 << 2; // Disable simple timer channel 0

  ST0_PR0 = 0x00000020 | (((CORECLK_FREQUENCY / 2000000) - 1) << 8); // Setup prescaler for 1Mhz timer frequency
  ST0_CT0 = 999; // Generate a 1Khz timer interrupt

  ST0_IER |= 1 << 0; // Generate interrupt when timer reaches zero
  ST0_CR = 1 << 1; // Enable simple timer channel 0
#endif
}

unsigned long
TicksPerSecond(void)
{
  return 1000;
}

void
Idle()
{
  ++idleCount;
}


