// Copyright (c) 2004 Rowley Associates Limited.
//
// This file may be distributed under the terms of the License Agreement
// provided with this software.
//
// THIS FILE IS PROVIDED AS IS WITH NO WARRANTY OF ANY KIND, INCLUDING THE
// WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.

#include "test.h"
#include <ctl_api.h>
#include <targets/S3C4510B.h>

unsigned long idleCount;

void
SetTimerISR(CTL_ISR_FN_t isr)
{
  TDATA1 = 50000; // interrupt frequency
  TMOD = (1<<3)|(1<<4); // enable timer1 in interval mode
  ctl_set_isr(11, 1, 0, isr, 0); // timer1 is 
  ctl_unmask_isr(11);
}

void
Idle(void)
{
  ++idleCount;
}
