// STA2051 register and bit definitions.
//
// Copyright (c) 2005 Rowley Associates Limited.
//
// This file may be distributed under the terms of the License Agreement
// provided with this software.
//
// THIS FILE IS PROVIDED AS IS WITH NO WARRANTY OF ANY KIND, INCLUDING THE
// WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.

#ifndef STA2051_h
#define STA2051_h

#define FCR0 (*(volatile unsigned *)0x40100000)
#define FCR0_BSY0_MASK 0x2
#define FCR0_BSY0 0x2
#define FCR0_BSY0_BIT 1
#define FCR0_BSY1_MASK 0x4
#define FCR0_BSY1 0x4
#define FCR0_BSY1_BIT 2
#define FCR0_LOCK_MASK 0x10
#define FCR0_LOCK 0x10
#define FCR0_LOCK_BIT 4
#define FCR0_LPS_MASK 0x8000
#define FCR0_LPS 0x8000
#define FCR0_LPS_BIT 15
#define FCR0_INTP_MASK 0x100000
#define FCR0_INTP 0x100000
#define FCR0_INTP_BIT 20
#define FCR0_INTM_MASK 0x200000
#define FCR0_INTM 0x200000
#define FCR0_INTM_BIT 21
#define FCR0_SPR_MASK 0x1000000
#define FCR0_SPR 0x1000000
#define FCR0_SPR_BIT 24
#define FCR0_MER_MASK 0x2000000
#define FCR0_MER 0x2000000
#define FCR0_MER_BIT 25
#define FCR0_BER_MASK 0x4000000
#define FCR0_BER 0x4000000
#define FCR0_BER_BIT 26
#define FCR0_SER_MASK 0x8000000
#define FCR0_SER 0x8000000
#define FCR0_SER_BIT 27
#define FCR0_DWPG_MASK 0x10000000
#define FCR0_DWPG 0x10000000
#define FCR0_DWPG_BIT 28
#define FCR0_WPG_MASK 0x20000000
#define FCR0_WPG 0x20000000
#define FCR0_WPG_BIT 29
#define FCR0_SUSP_MASK 0x40000000
#define FCR0_SUSP 0x40000000
#define FCR0_SUSP_BIT 30
#define FCR0_WMS_MASK 0x80000000
#define FCR0_WMS 0x80000000
#define FCR0_WMS_BIT 31

#define FCR1 (*(volatile unsigned *)0x40100004)
#define FCR1_BOF_MASK 0xFF
#define FCR1_BOF_BIT 0
#define FCR1_B1F0_MASK 0x10000
#define FCR1_B1F0 0x10000
#define FCR1_B1F0_BIT 16
#define FCR1_B1F1_MASK 0x20000
#define FCR1_B1F1 0x20000
#define FCR1_B1F1_BIT 17
#define FCR1_B1F0_MASK 0x1000000
#define FCR1_B1F0 0x1000000
#define FCR1_B1F0_BIT 24
#define FCR1_B1F1_MASK 0x2000000
#define FCR1_B1F1 0x2000000
#define FCR1_B1F1_BIT 25

#define FDR0 (*(volatile unsigned *)0x40100008)

#define FDR1 (*(volatile unsigned *)0x4010000C)

#define FAR (*(volatile unsigned *)0x40100010)

#define FER (*(volatile unsigned *)0x40100014)
#define FER_ERR_MASK 0x1
#define FER_ERR 0x1
#define FER_ERR_BIT 0
#define FER_ERER_MASK 0x2
#define FER_ERER 0x2
#define FER_ERER_BIT 1
#define FER_PGER_MASK 0x4
#define FER_PGER 0x4
#define FER_PGER_BIT 2
#define FER__10ER_MASK 0x8
#define FER__10ER 0x8
#define FER__10ER_BIT 3
#define FER_SEQER_MASK 0x40
#define FER_SEQER 0x40
#define FER_SEQER_BIT 6
#define FER_REQER_MASK 0x80
#define FER_REQER 0x80
#define FER_REQER_BIT 7
#define FER_WPF_MASK 0x100
#define FER_WPF 0x100
#define FER_WPF_BIT 8

#define FNVWPAR (*(volatile unsigned *)0x4010DFB0)
#define FNVWPAR_W0P_MASK 0xFF
#define FNVWPAR_W0P_BIT 0
#define FNVWPAR_W1P0_MASK 0x10000
#define FNVWPAR_W1P0 0x10000
#define FNVWPAR_W1P0_BIT 16
#define FNVWPAR_W1P1_MASK 0x20000
#define FNVWPAR_W1P1 0x20000
#define FNVWPAR_W1P1_BIT 17

#define FNVAPR0 (*(volatile unsigned *)0x4010DFB8)
#define FNVAPR0_ACCP_MASK 0x1
#define FNVAPR0_ACCP 0x1
#define FNVAPR0_ACCP_BIT 0
#define FNVAPR0_DBGP_MASK 0x2
#define FNVAPR0_DBGP 0x2
#define FNVAPR0_DBGP_BIT 1

#define FNVAPR1 (*(volatile unsigned *)0x4010DFBC)
#define FNVAPR1_PDS_MASK 0xFFFF
#define FNVAPR1_PDS_BIT 0
#define FNVAPR1_PEN_MASK 0xFFFF0000
#define FNVAPR1_PEN_BIT 16

#define BCON0 (*(volatile unsigned *)0x6C000000)
#define BCON0_B_SIZE_MASK 0x3
#define BCON0_B_SIZE_BIT 0
#define BCON0_C_LENGTH_MASK 0x3C
#define BCON0_C_LENGTH_BIT 2
#define BCON0_BE_MASK 0x8000
#define BCON0_BE 0x8000
#define BCON0_BE_BIT 15

#define BCON1 (*(volatile unsigned *)0x6C000004)
#define BCON1_B_SIZE_MASK 0x3
#define BCON1_B_SIZE_BIT 0
#define BCON1_C_LENGTH_MASK 0x3C
#define BCON1_C_LENGTH_BIT 2
#define BCON1_BE_MASK 0x8000
#define BCON1_BE 0x8000
#define BCON1_BE_BIT 15

#define BCON2 (*(volatile unsigned *)0x6C000008)
#define BCON2_B_SIZE_MASK 0x3
#define BCON2_B_SIZE_BIT 0
#define BCON2_C_LENGTH_MASK 0x3C
#define BCON2_C_LENGTH_BIT 2
#define BCON2_BE_MASK 0x8000
#define BCON2_BE 0x8000
#define BCON2_BE_BIT 15

#define BCON3 (*(volatile unsigned *)0x6C00000C)
#define BCON3_B_SIZE_MASK 0x3
#define BCON3_B_SIZE_BIT 0
#define BCON3_C_LENGTH_MASK 0x3C
#define BCON3_C_LENGTH_BIT 2
#define BCON3_BE_MASK 0x8000
#define BCON3_BE 0x8000
#define BCON3_BE_BIT 15

#define PRNC0 (*(volatile unsigned *)0x80000000)

#define PRNC1 (*(volatile unsigned *)0x80000004)

#define PRNC2 (*(volatile unsigned *)0x80000008)

#define PRNC3 (*(volatile unsigned *)0x8000000C)

#define PRNC4 (*(volatile unsigned *)0x80000010)

#define PRNC5 (*(volatile unsigned *)0x80000014)

#define PRNC6 (*(volatile unsigned *)0x80000018)

#define PRNC7 (*(volatile unsigned *)0x8000001C)

#define PRNC8 (*(volatile unsigned *)0x80000020)

#define PRNC9 (*(volatile unsigned *)0x80000024)

#define PRNC10 (*(volatile unsigned *)0x80000028)

#define PRNC11 (*(volatile unsigned *)0x8000002C)

#define APB3_BSR (*(volatile unsigned long *)0x80000000)
#define APB3_BSR_ABORT_MASK 0x1
#define APB3_BSR_ABORT 0x1
#define APB3_BSR_ABORT_BIT 0
#define APB3_BSR_OUTM_MASK 0x10
#define APB3_BSR_OUTM 0x10
#define APB3_BSR_OUTM_BIT 4
#define APB3_BSR_APBT_MASK 0x60
#define APB3_BSR_APBT_BIT 5

#define APB3_TOR (*(volatile unsigned long *)0x80000004)
#define APB3_TOR_TOUT_CNT_MASK 0x1F
#define APB3_TOR_TOUT_CNT_BIT 0
#define APB3_TOR_ABTEN_MASK 0x100
#define APB3_TOR_ABTEN 0x100
#define APB3_TOR_ABTEN_BIT 8

#define APB3_OMR (*(volatile unsigned long *)0x80000008)
#define APB3_OMR_nRW_MASK 0x80
#define APB3_OMR_nRW 0x80
#define APB3_OMR_nRW_BIT 7
#define APB3_OMR_Peripheral_Address_MASK 0xFFFF00
#define APB3_OMR_Peripheral_Address_BIT 8

#define APB3_TOER (*(volatile unsigned long *)0x8000000C)
#define APB3_TOER_nRW_MASK 0x80
#define APB3_TOER_nRW 0x80
#define APB3_TOER_nRW_BIT 7
#define APB3_TOER_Peripheral_Address_MASK 0xFFFF00
#define APB3_TOER_Peripheral_Address_BIT 8

#define APB3_CKDIS (*(volatile unsigned long *)0x80000010)

#define APB3_SWRES (*(volatile unsigned long *)0x80000014)

#define PRNP0 (*(volatile unsigned *)0x80000040)

#define PRNP1 (*(volatile unsigned *)0x80000044)

#define PRNP2 (*(volatile unsigned *)0x80000048)

#define PRNP3 (*(volatile unsigned *)0x8000004C)

#define PRNP4 (*(volatile unsigned *)0x80000050)

#define PRNP5 (*(volatile unsigned *)0x80000054)

#define PRNP6 (*(volatile unsigned *)0x80000058)

#define PRNP7 (*(volatile unsigned *)0x8000005C)

#define PRNP8 (*(volatile unsigned *)0x80000060)

#define PRNP9 (*(volatile unsigned *)0x80000064)

#define PRNP10 (*(volatile unsigned *)0x80000068)

#define PRNP11 (*(volatile unsigned *)0x8000006C)

#define NCOF0 (*(volatile unsigned *)0x80000080)

#define NCOF1 (*(volatile unsigned *)0x80000084)

#define NCOF2 (*(volatile unsigned *)0x80000088)

#define NCOF3 (*(volatile unsigned *)0x8000008C)

#define NCOF4 (*(volatile unsigned *)0x80000090)

#define NCOF5 (*(volatile unsigned *)0x80000094)

#define NCOF6 (*(volatile unsigned *)0x80000098)

#define NCOF7 (*(volatile unsigned *)0x8000009C)

#define NCOF8 (*(volatile unsigned *)0x800000A0)

#define NCOF9 (*(volatile unsigned *)0x800000A4)

#define NCOF10 (*(volatile unsigned *)0x800000A8)

#define NCOF11 (*(volatile unsigned *)0x800000AC)

#define NCOP0 (*(volatile unsigned *)0x800000C0)

#define NCOP1 (*(volatile unsigned *)0x800000C4)

#define NCOP2 (*(volatile unsigned *)0x800000C8)

#define NCOP3 (*(volatile unsigned *)0x800000CC)

#define NCOP4 (*(volatile unsigned *)0x800000D0)

#define NCOP5 (*(volatile unsigned *)0x800000D4)

#define NCOP6 (*(volatile unsigned *)0x800000D8)

#define NCOP7 (*(volatile unsigned *)0x800000DC)

#define NCOP8 (*(volatile unsigned *)0x800000E0)

#define NCOP9 (*(volatile unsigned *)0x800000E4)

#define NCOP10 (*(volatile unsigned *)0x800000E8)

#define NCOP11 (*(volatile unsigned *)0x800000EC)

#define PRNGI0 (*(volatile unsigned *)0x80000100)

#define PRNGI1 (*(volatile unsigned *)0x80000104)

#define PRNGI2 (*(volatile unsigned *)0x80000108)

#define PRNGI3 (*(volatile unsigned *)0x8000010C)

#define PRNGI4 (*(volatile unsigned *)0x80000110)

#define PRNGI5 (*(volatile unsigned *)0x80000114)

#define PRNGI6 (*(volatile unsigned *)0x80000118)

#define PRNGI7 (*(volatile unsigned *)0x8000011C)

#define PRNGI8 (*(volatile unsigned *)0x80000120)

#define PRNGI9 (*(volatile unsigned *)0x80000124)

#define PRNGI10 (*(volatile unsigned *)0x80000128)

#define PRNGI11 (*(volatile unsigned *)0x8000012C)

#define CTL (*(volatile unsigned *)0x80000140)

#define TBH (*(volatile unsigned *)0x80000144)

#define TBL (*(volatile unsigned *)0x80000148)

#define CMPSH (*(volatile unsigned *)0x8000014C)

#define CMPSL (*(volatile unsigned *)0x80000150)

#define CMPRH (*(volatile unsigned *)0x80000154)

#define CMPRL (*(volatile unsigned *)0x80000158)

#define TBBH (*(volatile unsigned *)0x8000015C)

#define TBBL (*(volatile unsigned *)0x80000160)

#define PRND (*(volatile unsigned *)0x80000164)

#define IS (*(volatile unsigned *)0x80000168)

#define IM (*(volatile unsigned *)0x8000016C)

#define NCOAP0 (*(volatile unsigned *)0x80000180)

#define NCOAP1 (*(volatile unsigned *)0x80000184)

#define NCOAP2 (*(volatile unsigned *)0x80000188)

#define NCOAP3 (*(volatile unsigned *)0x8000018C)

#define NCOAP4 (*(volatile unsigned *)0x80000190)

#define NCOAP5 (*(volatile unsigned *)0x80000194)

#define NCOAP6 (*(volatile unsigned *)0x80000198)

#define NCOAP7 (*(volatile unsigned *)0x8000019C)

#define NCOAP8 (*(volatile unsigned *)0x800001A0)

#define NCOAP9 (*(volatile unsigned *)0x800001A4)

#define NCOAP10 (*(volatile unsigned *)0x800001A8)

#define NCOAP11 (*(volatile unsigned *)0x800001AC)

#define NCOAPT (*(volatile unsigned *)0x800001C0)

#define SM (*(volatile unsigned *)0x800001C4)

#define IDATA0 (*(volatile unsigned *)0x80000200)

#define IDATA1 (*(volatile unsigned *)0x80000204)

#define IDATA2 (*(volatile unsigned *)0x80000208)

#define IDATA3 (*(volatile unsigned *)0x8000020C)

#define IDATA4 (*(volatile unsigned *)0x80000210)

#define IDATA5 (*(volatile unsigned *)0x80000214)

#define IDATA6 (*(volatile unsigned *)0x80000218)

#define IDATA7 (*(volatile unsigned *)0x8000021C)

#define IDATA8 (*(volatile unsigned *)0x80000220)

#define IDATA9 (*(volatile unsigned *)0x80000224)

#define IDATA10 (*(volatile unsigned *)0x80000228)

#define IDATA11 (*(volatile unsigned *)0x8000022C)

#define QDATA0 (*(volatile unsigned *)0x80000240)

#define QDATA1 (*(volatile unsigned *)0x80000244)

#define QDATA2 (*(volatile unsigned *)0x80000248)

#define QDATA3 (*(volatile unsigned *)0x8000024C)

#define QDATA4 (*(volatile unsigned *)0x80000250)

#define QDATA5 (*(volatile unsigned *)0x80000254)

#define QDATA6 (*(volatile unsigned *)0x80000258)

#define QDATA7 (*(volatile unsigned *)0x8000025C)

#define QDATA8 (*(volatile unsigned *)0x80000260)

#define QDATA9 (*(volatile unsigned *)0x80000264)

#define QDATA10 (*(volatile unsigned *)0x80000268)

#define QDATA11 (*(volatile unsigned *)0x8000026C)

#define TIME01 (*(volatile unsigned *)0x80000280)

#define TIME23 (*(volatile unsigned *)0x80000284)

#define TIME45 (*(volatile unsigned *)0x80000288)

#define TIME67 (*(volatile unsigned *)0x8000028C)

#define TIME89 (*(volatile unsigned *)0x80000290)

#define TIME1011 (*(volatile unsigned *)0x80000294)

#define CLKCTL (*(volatile unsigned long *)0xA0000000)
#define CLKCTL_LOP_WFI_MASK 0x1
#define CLKCTL_LOP_WFI 0x1
#define CLKCTL_LOP_WFI_BIT 0
#define CLKCTL_WFI_CKSEL_MASK 0x2
#define CLKCTL_WFI_CKSEL 0x2
#define CLKCTL_WFI_CKSEL_BIT 1
#define CLKCTL_CKAF_SEL_MASK 0x4
#define CLKCTL_CKAF_SEL 0x4
#define CLKCTL_CKAF_SEL_BIT 2
#define CLKCTL_SRES_EN_MASK 0x8
#define CLKCTL_SRES_EN 0x8
#define CLKCTL_SRES_EN_BIT 3
#define CLKCTL_EN_LOCK_MASK 0x80
#define CLKCTL_EN_LOCK 0x80
#define CLKCTL_EN_LOCK_BIT 7
#define CLKCTL_EN_CKAF_MASK 0x100
#define CLKCTL_EN_CKAF 0x100
#define CLKCTL_EN_CKAF_BIT 8
#define CLKCTL_EN_CK2_16_MASK 0x200
#define CLKCTL_EN_CK2_16 0x200
#define CLKCTL_EN_CK2_16_BIT 9
#define CLKCTL_EN_STOP_MASK 0x400
#define CLKCTL_EN_STOP 0x400
#define CLKCTL_EN_STOP_BIT 10
#define CLKCTL_EN_HALT_MASK 0x800
#define CLKCTL_EN_HALT 0x800
#define CLKCTL_EN_HALT_BIT 11

#define CLK_FLAG (*(volatile unsigned long *)0xA0000008)
#define CLK_FLAG_CSU_CKSEL_MASK 0x1
#define CLK_FLAG_CSU_CKSEL 0x1
#define CLK_FLAG_CSU_CKSEL_BIT 0
#define CLK_FLAG_LOCK_MASK 0x2
#define CLK_FLAG_LOCK 0x2
#define CLK_FLAG_LOCK_BIT 1
#define CLK_FLAG_CKAF_ST_MASK 0x4
#define CLK_FLAG_CKAF_ST 0x4
#define CLK_FLAG_CKAF_ST_BIT 2
#define CLK_FLAG_CK2_16_MASK 0x8
#define CLK_FLAG_CK2_16 0x8
#define CLK_FLAG_CK2_16_BIT 3
#define CLK_FLAG_SOFT_RES_MASK 0x20
#define CLK_FLAG_SOFT_RES 0x20
#define CLK_FLAG_SOFT_RES_BIT 5
#define CLK_FLAG_WDG_RES_MASK 0x40
#define CLK_FLAG_WDG_RES 0x40
#define CLK_FLAG_WDG_RES_BIT 6
#define CLK_FLAG_RTC_ALARM_MASK 0x80
#define CLK_FLAG_RTC_ALARM 0x80
#define CLK_FLAG_RTC_ALARM_BIT 7
#define CLK_FLAG_FLASH_POR_MASK 0x200
#define CLK_FLAG_FLASH_POR 0x200
#define CLK_FLAG_FLASH_POR_BIT 9
#define CLK_FLAG_WKP_RES_MASK 0x400
#define CLK_FLAG_WKP_RES 0x400
#define CLK_FLAG_WKP_RES_BIT 10
#define CLK_FLAG_LOCK_I_MASK 0x800
#define CLK_FLAG_LOCK_I 0x800
#define CLK_FLAG_LOCK_I_BIT 11
#define CLK_FLAG_CKAF_I_MASK 0x1000
#define CLK_FLAG_CKAF_I 0x1000
#define CLK_FLAG_CKAF_I_BIT 12
#define CLK_FLAG_CK2_16_I_MASK 0x2000
#define CLK_FLAG_CK2_16_I 0x2000
#define CLK_FLAG_CK2_16_I_BIT 13
#define CLK_FLAG_STOP_I_MASK 0x4000
#define CLK_FLAG_STOP_I 0x4000
#define CLK_FLAG_STOP_I_BIT 14
#define CLK_FLAG_DIV2_MASK 0x8000
#define CLK_FLAG_DIV2 0x8000
#define CLK_FLAG_DIV2_BIT 15

#define PLLCONF (*(volatile unsigned long *)0xA0000018)
#define PLLCONF_DX0_MASK 0x1
#define PLLCONF_DX0 0x1
#define PLLCONF_DX0_BIT 0
#define PLLCONF_DX1_MASK 0x2
#define PLLCONF_DX1 0x2
#define PLLCONF_DX1_BIT 1
#define PLLCONF_DX2_MASK 0x4
#define PLLCONF_DX2 0x4
#define PLLCONF_DX2_BIT 2
#define PLLCONF_MX0_MASK 0x10
#define PLLCONF_MX0 0x10
#define PLLCONF_MX0_BIT 4
#define PLLCONF_MX1_MASK 0x20
#define PLLCONF_MX1 0x20
#define PLLCONF_MX1_BIT 5
#define PLLCONF_FREF_RANGE_MASK 0x40
#define PLLCONF_FREF_RANGE 0x40
#define PLLCONF_FREF_RANGE_BIT 6
#define PLLCONF_FREEN_MASK 0x80
#define PLLCONF_FREEN 0x80
#define PLLCONF_FREEN_BIT 7

#define PH_CLOCK_EN (*(volatile unsigned long *)0xA000001C)

#define SYSMODE (*(volatile unsigned long *)0xA0000020)
#define SYSMODE_WFI_MASK 0x1
#define SYSMODE_WFI 0x1
#define SYSMODE_WFI_BIT 0
#define SYSMODE_HALT_MASK 0x2
#define SYSMODE_HALT 0x2
#define SYSMODE_HALT_BIT 1

#define CPUDIV (*(volatile unsigned long *)0xA0000040)

#define APBDIV (*(volatile unsigned long *)0xA0000044)
#define APBDIV_FACT1_MASK 0x3
#define APBDIV_FACT1_BIT 0
#define APBDIV_FACT2_MASK 0x300
#define APBDIV_FACT2_BIT 8

#define PH_RST (*(volatile unsigned long *)0xA0000048)

#define PLL2CTL (*(volatile unsigned long *)0xA000004C)
#define PLL2CTL_DX_MASK 0x3
#define PLL2CTL_DX_BIT 0
#define PLL2CTL_MX_MASK 0x30
#define PLL2CTL_MX_BIT 4
#define PLL2CTL_FRQRNG_MASK 0x40
#define PLL2CTL_FRQRNG 0x40
#define PLL2CTL_FRQRNG_BIT 6
#define PLL2CTL_PLLEN_MASK 0x80
#define PLL2CTL_PLLEN 0x80
#define PLL2CTL_PLLEN_BIT 7
#define PLL2CTL_USBEN_MASK 0x100
#define PLL2CTL_USBEN 0x100
#define PLL2CTL_USBEN_BIT 8
#define PLL2CTL_IRQMASK_MASK 0x200
#define PLL2CTL_IRQMASK 0x200
#define PLL2CTL_IRQMASK_BIT 9
#define PLL2CTL_IRQPEND_MASK 0x400
#define PLL2CTL_IRQPEND 0x400
#define PLL2CTL_IRQPEND_BIT 10
#define PLL2CTL_LOCK_MASK 0x8000
#define PLL2CTL_LOCK 0x8000
#define PLL2CTL_LOCK_BIT 15

#define BOOTCONF (*(volatile unsigned long *)0xA0000050)
#define BOOTCONF_BOOT_MASK 0x3
#define BOOTCONF_BOOT_BIT 0
#define BOOTCONF_SPI0EN_MASK 0x4
#define BOOTCONF_SPI0EN 0x4
#define BOOTCONF_SPI0EN_BIT 2
#define BOOTCONF_USBFILTEN_MASK 0x8
#define BOOTCONF_USBFILTEN 0x8
#define BOOTCONF_USBFILTEN_BIT 3
#define BOOTCONF_LPOWDBGEN_MASK 0x10
#define BOOTCONF_LPOWDBGEN 0x10
#define BOOTCONF_LPOWDBGEN_BIT 4
#define BOOTCONF_ADCEN_MASK 0x20
#define BOOTCONF_ADCEN 0x20
#define BOOTCONF_ADCEN_BIT 5
#define BOOTCONF_CAN_MASK 0x40
#define BOOTCONF_CAN 0x40
#define BOOTCONF_CAN_BIT 6
#define BOOTCONF_HDLC_MASK 0x80
#define BOOTCONF_HDLC 0x80
#define BOOTCONF_HDLC_BIT 7
#define BOOTCONF_GPS_MASK 0x100
#define BOOTCONF_GPS 0x100
#define BOOTCONF_GPS_BIT 8
#define BOOTCONF_PKG64_MASK 0x200
#define BOOTCONF_PKG64 0x200
#define BOOTCONF_PKG64_BIT 9

#define PWRCTRL (*(volatile unsigned long *)0xA0000054)
#define PWRCTRL_VRBYP_MASK 0x8
#define PWRCTRL_VRBYP 0x8
#define PWRCTRL_VRBYP_BIT 3
#define PWRCTRL_LPVRWFI_MASK 0x10
#define PWRCTRL_LPVRWFI 0x10
#define PWRCTRL_LPVRWFI_BIT 4
#define PWRCTRL_LPVRBYP_MASK 0x20
#define PWRCTRL_LPVRBYP 0x20
#define PWRCTRL_LPVRBYP_BIT 5
#define PWRCTRL_PWRDWN_MASK 0x40
#define PWRCTRL_PWRDWN 0x40
#define PWRCTRL_PWRDWN_BIT 6
#define PWRCTRL_OSCBYP_MASK 0x80
#define PWRCTRL_OSCBYP 0x80
#define PWRCTRL_OSCBYP_BIT 7
#define PWRCTRL_LVDDIS_MASK 0x100
#define PWRCTRL_LVDDIS 0x100
#define PWRCTRL_LVDDIS_BIT 8
#define PWRCTRL_FLASH_LP_MASK 0x200
#define PWRCTRL_FLASH_LP 0x200
#define PWRCTRL_FLASH_LP_BIT 9
#define PWRCTRL_VROK_MASK 0x1000
#define PWRCTRL_VROK 0x1000
#define PWRCTRL_VROK_BIT 12
#define PWRCTRL_WKUPALRM_MASK 0x2000
#define PWRCTRL_WKUPALRM 0x2000
#define PWRCTRL_WKUPALRM_BIT 13
#define PWRCTRL_BUSY_MASK 0x4000
#define PWRCTRL_BUSY 0x4000
#define PWRCTRL_BUSY_BIT 14
#define PWRCTRL_WREN_MASK 0x8000
#define PWRCTRL_WREN 0x8000
#define PWRCTRL_WREN_BIT 15

#define APB1_BSR (*(volatile unsigned long *)0xC0000000)
#define APB1_BSR_ABORT_MASK 0x1
#define APB1_BSR_ABORT 0x1
#define APB1_BSR_ABORT_BIT 0
#define APB1_BSR_OUTM_MASK 0x10
#define APB1_BSR_OUTM 0x10
#define APB1_BSR_OUTM_BIT 4
#define APB1_BSR_APBT_MASK 0x60
#define APB1_BSR_APBT_BIT 5

#define APB1_TOR (*(volatile unsigned long *)0xC0000004)
#define APB1_TOR_TOUT_CNT_MASK 0x1F
#define APB1_TOR_TOUT_CNT_BIT 0
#define APB1_TOR_ABTEN_MASK 0x100
#define APB1_TOR_ABTEN 0x100
#define APB1_TOR_ABTEN_BIT 8

#define APB1_OMR (*(volatile unsigned long *)0xC0000008)
#define APB1_OMR_nRW_MASK 0x80
#define APB1_OMR_nRW 0x80
#define APB1_OMR_nRW_BIT 7
#define APB1_OMR_Peripheral_Address_MASK 0xFFFF00
#define APB1_OMR_Peripheral_Address_BIT 8

#define APB1_TOER (*(volatile unsigned long *)0xC000000C)
#define APB1_TOER_nRW_MASK 0x80
#define APB1_TOER_nRW 0x80
#define APB1_TOER_nRW_BIT 7
#define APB1_TOER_Peripheral_Address_MASK 0xFFFF00
#define APB1_TOER_Peripheral_Address_BIT 8

#define APB1_CKDIS (*(volatile unsigned long *)0xC0000010)

#define APB1_SWRES (*(volatile unsigned long *)0xC0000014)

#define I2C0_CR (*(volatile unsigned char *)0xC0001000)
#define I2C0_CR_ITE_MASK 0x1
#define I2C0_CR_ITE 0x1
#define I2C0_CR_ITE_BIT 0
#define I2C0_CR_STOP_MASK 0x2
#define I2C0_CR_STOP 0x2
#define I2C0_CR_STOP_BIT 1
#define I2C0_CR_ACK_MASK 0x4
#define I2C0_CR_ACK 0x4
#define I2C0_CR_ACK_BIT 2
#define I2C0_CR_START_MASK 0x8
#define I2C0_CR_START 0x8
#define I2C0_CR_START_BIT 3
#define I2C0_CR_ENGC_MASK 0x10
#define I2C0_CR_ENGC 0x10
#define I2C0_CR_ENGC_BIT 4
#define I2C0_CR_PE_MASK 0x20
#define I2C0_CR_PE 0x20
#define I2C0_CR_PE_BIT 5

#define I2C0_SR1 (*(volatile unsigned char *)0xC0001004)
#define I2C0_SR1_SB_MASK 0x1
#define I2C0_SR1_SB 0x1
#define I2C0_SR1_SB_BIT 0
#define I2C0_SR1_M_SL_MASK 0x2
#define I2C0_SR1_M_SL 0x2
#define I2C0_SR1_M_SL_BIT 1
#define I2C0_SR1_ADSL_MASK 0x4
#define I2C0_SR1_ADSL 0x4
#define I2C0_SR1_ADSL_BIT 2
#define I2C0_SR1_BTF_MASK 0x8
#define I2C0_SR1_BTF 0x8
#define I2C0_SR1_BTF_BIT 3
#define I2C0_SR1_BUSY_MASK 0x10
#define I2C0_SR1_BUSY 0x10
#define I2C0_SR1_BUSY_BIT 4
#define I2C0_SR1_TRA_MASK 0x20
#define I2C0_SR1_TRA 0x20
#define I2C0_SR1_TRA_BIT 5
#define I2C0_SR1_ADD10_MASK 0x40
#define I2C0_SR1_ADD10 0x40
#define I2C0_SR1_ADD10_BIT 6
#define I2C0_SR1_EVF_MASK 0x80
#define I2C0_SR1_EVF 0x80
#define I2C0_SR1_EVF_BIT 7

#define I2C0_SR2 (*(volatile unsigned char *)0xC0001008)
#define I2C0_SR2_GCAL_MASK 0x1
#define I2C0_SR2_GCAL 0x1
#define I2C0_SR2_GCAL_BIT 0
#define I2C0_SR2_BERR_MASK 0x2
#define I2C0_SR2_BERR 0x2
#define I2C0_SR2_BERR_BIT 1
#define I2C0_SR2_ARLO_MASK 0x4
#define I2C0_SR2_ARLO 0x4
#define I2C0_SR2_ARLO_BIT 2
#define I2C0_SR2_STOPF_MASK 0x8
#define I2C0_SR2_STOPF 0x8
#define I2C0_SR2_STOPF_BIT 3
#define I2C0_SR2_AF_MASK 0x10
#define I2C0_SR2_AF 0x10
#define I2C0_SR2_AF_BIT 4
#define I2C0_SR2_ENDAD_MASK 0x20
#define I2C0_SR2_ENDAD 0x20
#define I2C0_SR2_ENDAD_BIT 5

#define I2C0_CCR (*(volatile unsigned char *)0xC000100C)
#define I2C0_CCR_CC0_MASK 0x1
#define I2C0_CCR_CC0 0x1
#define I2C0_CCR_CC0_BIT 0
#define I2C0_CCR_CC1_MASK 0x2
#define I2C0_CCR_CC1 0x2
#define I2C0_CCR_CC1_BIT 1
#define I2C0_CCR_CC2_MASK 0x4
#define I2C0_CCR_CC2 0x4
#define I2C0_CCR_CC2_BIT 2
#define I2C0_CCR_CC3_MASK 0x8
#define I2C0_CCR_CC3 0x8
#define I2C0_CCR_CC3_BIT 3
#define I2C0_CCR_CC4_MASK 0x10
#define I2C0_CCR_CC4 0x10
#define I2C0_CCR_CC4_BIT 4
#define I2C0_CCR_CC5_MASK 0x20
#define I2C0_CCR_CC5 0x20
#define I2C0_CCR_CC5_BIT 5
#define I2C0_CCR_CC6_MASK 0x40
#define I2C0_CCR_CC6 0x40
#define I2C0_CCR_CC6_BIT 6
#define I2C0_CCR_FM_SM_MASK 0x80
#define I2C0_CCR_FM_SM 0x80
#define I2C0_CCR_FM_SM_BIT 7

#define I2C0_OAR1 (*(volatile unsigned char *)0xC0001010)
#define I2C0_OAR1_ADD0_MASK 0x1
#define I2C0_OAR1_ADD0 0x1
#define I2C0_OAR1_ADD0_BIT 0
#define I2C0_OAR1_ADD1_MASK 0x2
#define I2C0_OAR1_ADD1 0x2
#define I2C0_OAR1_ADD1_BIT 1
#define I2C0_OAR1_ADD2_MASK 0x4
#define I2C0_OAR1_ADD2 0x4
#define I2C0_OAR1_ADD2_BIT 2
#define I2C0_OAR1_ADD3_MASK 0x8
#define I2C0_OAR1_ADD3 0x8
#define I2C0_OAR1_ADD3_BIT 3
#define I2C0_OAR1_ADD4_MASK 0x10
#define I2C0_OAR1_ADD4 0x10
#define I2C0_OAR1_ADD4_BIT 4
#define I2C0_OAR1_ADD5_MASK 0x20
#define I2C0_OAR1_ADD5 0x20
#define I2C0_OAR1_ADD5_BIT 5
#define I2C0_OAR1_ADD6_MASK 0x40
#define I2C0_OAR1_ADD6 0x40
#define I2C0_OAR1_ADD6_BIT 6
#define I2C0_OAR1_ADD7_MASK 0x80
#define I2C0_OAR1_ADD7 0x80
#define I2C0_OAR1_ADD7_BIT 7

#define I2C0_OAR2 (*(volatile unsigned char *)0xC0001014)
#define I2C0_OAR2_ADD8_MASK 0x2
#define I2C0_OAR2_ADD8 0x2
#define I2C0_OAR2_ADD8_BIT 1
#define I2C0_OAR2_ADD9_MASK 0x4
#define I2C0_OAR2_ADD9 0x4
#define I2C0_OAR2_ADD9_BIT 2
#define I2C0_OAR2_FR0_MASK 0x20
#define I2C0_OAR2_FR0 0x20
#define I2C0_OAR2_FR0_BIT 5
#define I2C0_OAR2_FR1_MASK 0x40
#define I2C0_OAR2_FR1 0x40
#define I2C0_OAR2_FR1_BIT 6
#define I2C0_OAR2_FR2_MASK 0x80
#define I2C0_OAR2_FR2 0x80
#define I2C0_OAR2_FR2_BIT 7

#define I2C0_DR (*(volatile unsigned char *)0xC0001018)
#define I2C0_DR_D0_MASK 0x1
#define I2C0_DR_D0 0x1
#define I2C0_DR_D0_BIT 0
#define I2C0_DR_D1_MASK 0x2
#define I2C0_DR_D1 0x2
#define I2C0_DR_D1_BIT 1
#define I2C0_DR_D2_MASK 0x4
#define I2C0_DR_D2 0x4
#define I2C0_DR_D2_BIT 2
#define I2C0_DR_D3_MASK 0x8
#define I2C0_DR_D3 0x8
#define I2C0_DR_D3_BIT 3
#define I2C0_DR_D4_MASK 0x10
#define I2C0_DR_D4 0x10
#define I2C0_DR_D4_BIT 4
#define I2C0_DR_D5_MASK 0x20
#define I2C0_DR_D5 0x20
#define I2C0_DR_D5_BIT 5
#define I2C0_DR_D6_MASK 0x40
#define I2C0_DR_D6 0x40
#define I2C0_DR_D6_BIT 6
#define I2C0_DR_D7_MASK 0x80
#define I2C0_DR_D7 0x80
#define I2C0_DR_D7_BIT 7

#define I2C0_ECCR (*(volatile unsigned char *)0xC000101C)
#define I2C0_ECCR_CC7_MASK 0x1
#define I2C0_ECCR_CC7 0x1
#define I2C0_ECCR_CC7_BIT 0
#define I2C0_ECCR_CC8_MASK 0x2
#define I2C0_ECCR_CC8 0x2
#define I2C0_ECCR_CC8_BIT 1
#define I2C0_ECCR_CC9_MASK 0x4
#define I2C0_ECCR_CC9 0x4
#define I2C0_ECCR_CC9_BIT 2
#define I2C0_ECCR_CC10_MASK 0x8
#define I2C0_ECCR_CC10 0x8
#define I2C0_ECCR_CC10_BIT 3
#define I2C0_ECCR_CC11_MASK 0x10
#define I2C0_ECCR_CC11 0x10
#define I2C0_ECCR_CC11_BIT 4

#define I2C1_CR (*(volatile unsigned char *)0xC0002000)
#define I2C1_CR_ITE_MASK 0x1
#define I2C1_CR_ITE 0x1
#define I2C1_CR_ITE_BIT 0
#define I2C1_CR_STOP_MASK 0x2
#define I2C1_CR_STOP 0x2
#define I2C1_CR_STOP_BIT 1
#define I2C1_CR_ACK_MASK 0x4
#define I2C1_CR_ACK 0x4
#define I2C1_CR_ACK_BIT 2
#define I2C1_CR_START_MASK 0x8
#define I2C1_CR_START 0x8
#define I2C1_CR_START_BIT 3
#define I2C1_CR_ENGC_MASK 0x10
#define I2C1_CR_ENGC 0x10
#define I2C1_CR_ENGC_BIT 4
#define I2C1_CR_PE_MASK 0x20
#define I2C1_CR_PE 0x20
#define I2C1_CR_PE_BIT 5

#define I2C1_SR1 (*(volatile unsigned char *)0xC0002004)
#define I2C1_SR1_SB_MASK 0x1
#define I2C1_SR1_SB 0x1
#define I2C1_SR1_SB_BIT 0
#define I2C1_SR1_M_SL_MASK 0x2
#define I2C1_SR1_M_SL 0x2
#define I2C1_SR1_M_SL_BIT 1
#define I2C1_SR1_ADSL_MASK 0x4
#define I2C1_SR1_ADSL 0x4
#define I2C1_SR1_ADSL_BIT 2
#define I2C1_SR1_BTF_MASK 0x8
#define I2C1_SR1_BTF 0x8
#define I2C1_SR1_BTF_BIT 3
#define I2C1_SR1_BUSY_MASK 0x10
#define I2C1_SR1_BUSY 0x10
#define I2C1_SR1_BUSY_BIT 4
#define I2C1_SR1_TRA_MASK 0x20
#define I2C1_SR1_TRA 0x20
#define I2C1_SR1_TRA_BIT 5
#define I2C1_SR1_ADD10_MASK 0x40
#define I2C1_SR1_ADD10 0x40
#define I2C1_SR1_ADD10_BIT 6
#define I2C1_SR1_EVF_MASK 0x80
#define I2C1_SR1_EVF 0x80
#define I2C1_SR1_EVF_BIT 7

#define I2C1_SR2 (*(volatile unsigned char *)0xC0002008)
#define I2C1_SR2_GCAL_MASK 0x1
#define I2C1_SR2_GCAL 0x1
#define I2C1_SR2_GCAL_BIT 0
#define I2C1_SR2_BERR_MASK 0x2
#define I2C1_SR2_BERR 0x2
#define I2C1_SR2_BERR_BIT 1
#define I2C1_SR2_ARLO_MASK 0x4
#define I2C1_SR2_ARLO 0x4
#define I2C1_SR2_ARLO_BIT 2
#define I2C1_SR2_STOPF_MASK 0x8
#define I2C1_SR2_STOPF 0x8
#define I2C1_SR2_STOPF_BIT 3
#define I2C1_SR2_AF_MASK 0x10
#define I2C1_SR2_AF 0x10
#define I2C1_SR2_AF_BIT 4
#define I2C1_SR2_ENDAD_MASK 0x20
#define I2C1_SR2_ENDAD 0x20
#define I2C1_SR2_ENDAD_BIT 5

#define I2C1_CCR (*(volatile unsigned char *)0xC000200C)
#define I2C1_CCR_CC0_MASK 0x1
#define I2C1_CCR_CC0 0x1
#define I2C1_CCR_CC0_BIT 0
#define I2C1_CCR_CC1_MASK 0x2
#define I2C1_CCR_CC1 0x2
#define I2C1_CCR_CC1_BIT 1
#define I2C1_CCR_CC2_MASK 0x4
#define I2C1_CCR_CC2 0x4
#define I2C1_CCR_CC2_BIT 2
#define I2C1_CCR_CC3_MASK 0x8
#define I2C1_CCR_CC3 0x8
#define I2C1_CCR_CC3_BIT 3
#define I2C1_CCR_CC4_MASK 0x10
#define I2C1_CCR_CC4 0x10
#define I2C1_CCR_CC4_BIT 4
#define I2C1_CCR_CC5_MASK 0x20
#define I2C1_CCR_CC5 0x20
#define I2C1_CCR_CC5_BIT 5
#define I2C1_CCR_CC6_MASK 0x40
#define I2C1_CCR_CC6 0x40
#define I2C1_CCR_CC6_BIT 6
#define I2C1_CCR_FM_SM_MASK 0x80
#define I2C1_CCR_FM_SM 0x80
#define I2C1_CCR_FM_SM_BIT 7

#define I2C1_OAR1 (*(volatile unsigned char *)0xC0002010)
#define I2C1_OAR1_ADD0_MASK 0x1
#define I2C1_OAR1_ADD0 0x1
#define I2C1_OAR1_ADD0_BIT 0
#define I2C1_OAR1_ADD1_MASK 0x2
#define I2C1_OAR1_ADD1 0x2
#define I2C1_OAR1_ADD1_BIT 1
#define I2C1_OAR1_ADD2_MASK 0x4
#define I2C1_OAR1_ADD2 0x4
#define I2C1_OAR1_ADD2_BIT 2
#define I2C1_OAR1_ADD3_MASK 0x8
#define I2C1_OAR1_ADD3 0x8
#define I2C1_OAR1_ADD3_BIT 3
#define I2C1_OAR1_ADD4_MASK 0x10
#define I2C1_OAR1_ADD4 0x10
#define I2C1_OAR1_ADD4_BIT 4
#define I2C1_OAR1_ADD5_MASK 0x20
#define I2C1_OAR1_ADD5 0x20
#define I2C1_OAR1_ADD5_BIT 5
#define I2C1_OAR1_ADD6_MASK 0x40
#define I2C1_OAR1_ADD6 0x40
#define I2C1_OAR1_ADD6_BIT 6
#define I2C1_OAR1_ADD7_MASK 0x80
#define I2C1_OAR1_ADD7 0x80
#define I2C1_OAR1_ADD7_BIT 7

#define I2C1_OAR2 (*(volatile unsigned char *)0xC0002014)
#define I2C1_OAR2_ADD8_MASK 0x2
#define I2C1_OAR2_ADD8 0x2
#define I2C1_OAR2_ADD8_BIT 1
#define I2C1_OAR2_ADD9_MASK 0x4
#define I2C1_OAR2_ADD9 0x4
#define I2C1_OAR2_ADD9_BIT 2
#define I2C1_OAR2_FR0_MASK 0x20
#define I2C1_OAR2_FR0 0x20
#define I2C1_OAR2_FR0_BIT 5
#define I2C1_OAR2_FR1_MASK 0x40
#define I2C1_OAR2_FR1 0x40
#define I2C1_OAR2_FR1_BIT 6
#define I2C1_OAR2_FR2_MASK 0x80
#define I2C1_OAR2_FR2 0x80
#define I2C1_OAR2_FR2_BIT 7

#define I2C1_DR (*(volatile unsigned char *)0xC0002018)
#define I2C1_DR_D0_MASK 0x1
#define I2C1_DR_D0 0x1
#define I2C1_DR_D0_BIT 0
#define I2C1_DR_D1_MASK 0x2
#define I2C1_DR_D1 0x2
#define I2C1_DR_D1_BIT 1
#define I2C1_DR_D2_MASK 0x4
#define I2C1_DR_D2 0x4
#define I2C1_DR_D2_BIT 2
#define I2C1_DR_D3_MASK 0x8
#define I2C1_DR_D3 0x8
#define I2C1_DR_D3_BIT 3
#define I2C1_DR_D4_MASK 0x10
#define I2C1_DR_D4 0x10
#define I2C1_DR_D4_BIT 4
#define I2C1_DR_D5_MASK 0x20
#define I2C1_DR_D5 0x20
#define I2C1_DR_D5_BIT 5
#define I2C1_DR_D6_MASK 0x40
#define I2C1_DR_D6 0x40
#define I2C1_DR_D6_BIT 6
#define I2C1_DR_D7_MASK 0x80
#define I2C1_DR_D7 0x80
#define I2C1_DR_D7_BIT 7

#define I2C1_ECCR (*(volatile unsigned char *)0xC000201C)
#define I2C1_ECCR_CC7_MASK 0x1
#define I2C1_ECCR_CC7 0x1
#define I2C1_ECCR_CC7_BIT 0
#define I2C1_ECCR_CC8_MASK 0x2
#define I2C1_ECCR_CC8 0x2
#define I2C1_ECCR_CC8_BIT 1
#define I2C1_ECCR_CC9_MASK 0x4
#define I2C1_ECCR_CC9 0x4
#define I2C1_ECCR_CC9_BIT 2
#define I2C1_ECCR_CC10_MASK 0x8
#define I2C1_ECCR_CC10 0x8
#define I2C1_ECCR_CC10_BIT 3
#define I2C1_ECCR_CC11_MASK 0x10
#define I2C1_ECCR_CC11 0x10
#define I2C1_ECCR_CC11_BIT 4

#define UART0_ASCBaudRate (*(volatile unsigned short *)0xC0004000)

#define UART0_ASCTxBuffer (*(volatile unsigned short *)0xC0004004)

#define UART0_ASCRxBuffer (*(volatile unsigned short *)0xC0004008)

#define UART0_ASCControl (*(volatile unsigned short *)0xC000400C)
#define UART0_ASCControl_Mode_MASK 0x7
#define UART0_ASCControl_Mode_BIT 0
#define UART0_ASCControl_Stop_Bits_MASK 0x18
#define UART0_ASCControl_Stop_Bits_BIT 3
#define UART0_ASCControl_Parity_Odd_MASK 0x20
#define UART0_ASCControl_Parity_Odd 0x20
#define UART0_ASCControl_Parity_Odd_BIT 5
#define UART0_ASCControl_Loop_Back_MASK 0x40
#define UART0_ASCControl_Loop_Back 0x40
#define UART0_ASCControl_Loop_Back_BIT 6
#define UART0_ASCControl_Run_MASK 0x80
#define UART0_ASCControl_Run 0x80
#define UART0_ASCControl_Run_BIT 7
#define UART0_ASCControl_RxEnable_MASK 0x100
#define UART0_ASCControl_RxEnable 0x100
#define UART0_ASCControl_RxEnable_BIT 8
#define UART0_ASCControl_FifoEnable_MASK 0x400
#define UART0_ASCControl_FifoEnable 0x400
#define UART0_ASCControl_FifoEnable_BIT 10

#define UART0_ASCIntEnable (*(volatile unsigned short *)0xC0004010)

#define UART0_ASCStatus (*(volatile unsigned short *)0xC0004014)

#define UART0_ASCGuardTime (*(volatile unsigned short *)0xC0004018)

#define UART0_ASCTimeout (*(volatile unsigned short *)0xC000401C)

#define UART0_ASCTxReset (*(volatile unsigned short *)0xC0004020)

#define UART0_ASCRxReset (*(volatile unsigned short *)0xC0004024)

#define UART1_ASCBaudRate (*(volatile unsigned short *)0xC0005000)

#define UART1_ASCTxBuffer (*(volatile unsigned short *)0xC0005004)

#define UART1_ASCRxBuffer (*(volatile unsigned short *)0xC0005008)

#define UART1_ASCControl (*(volatile unsigned short *)0xC000500C)
#define UART1_ASCControl_Mode_MASK 0x7
#define UART1_ASCControl_Mode_BIT 0
#define UART1_ASCControl_Stop_Bits_MASK 0x18
#define UART1_ASCControl_Stop_Bits_BIT 3
#define UART1_ASCControl_Parity_Odd_MASK 0x20
#define UART1_ASCControl_Parity_Odd 0x20
#define UART1_ASCControl_Parity_Odd_BIT 5
#define UART1_ASCControl_Loop_Back_MASK 0x40
#define UART1_ASCControl_Loop_Back 0x40
#define UART1_ASCControl_Loop_Back_BIT 6
#define UART1_ASCControl_Run_MASK 0x80
#define UART1_ASCControl_Run 0x80
#define UART1_ASCControl_Run_BIT 7
#define UART1_ASCControl_RxEnable_MASK 0x100
#define UART1_ASCControl_RxEnable 0x100
#define UART1_ASCControl_RxEnable_BIT 8
#define UART1_ASCControl_FifoEnable_MASK 0x400
#define UART1_ASCControl_FifoEnable 0x400
#define UART1_ASCControl_FifoEnable_BIT 10

#define UART1_ASCIntEnable (*(volatile unsigned short *)0xC0005010)

#define UART1_ASCStatus (*(volatile unsigned short *)0xC0005014)

#define UART1_ASCGuardTime (*(volatile unsigned short *)0xC0005018)

#define UART1_ASCTimeout (*(volatile unsigned short *)0xC000501C)

#define UART1_ASCTxReset (*(volatile unsigned short *)0xC0005020)

#define UART1_ASCRxReset (*(volatile unsigned short *)0xC0005024)

#define UART2_ASCBaudRate (*(volatile unsigned short *)0xC0006000)

#define UART2_ASCTxBuffer (*(volatile unsigned short *)0xC0006004)

#define UART2_ASCRxBuffer (*(volatile unsigned short *)0xC0006008)

#define UART2_ASCControl (*(volatile unsigned short *)0xC000600C)
#define UART2_ASCControl_Mode_MASK 0x7
#define UART2_ASCControl_Mode_BIT 0
#define UART2_ASCControl_Stop_Bits_MASK 0x18
#define UART2_ASCControl_Stop_Bits_BIT 3
#define UART2_ASCControl_Parity_Odd_MASK 0x20
#define UART2_ASCControl_Parity_Odd 0x20
#define UART2_ASCControl_Parity_Odd_BIT 5
#define UART2_ASCControl_Loop_Back_MASK 0x40
#define UART2_ASCControl_Loop_Back 0x40
#define UART2_ASCControl_Loop_Back_BIT 6
#define UART2_ASCControl_Run_MASK 0x80
#define UART2_ASCControl_Run 0x80
#define UART2_ASCControl_Run_BIT 7
#define UART2_ASCControl_RxEnable_MASK 0x100
#define UART2_ASCControl_RxEnable 0x100
#define UART2_ASCControl_RxEnable_BIT 8
#define UART2_ASCControl_FifoEnable_MASK 0x400
#define UART2_ASCControl_FifoEnable 0x400
#define UART2_ASCControl_FifoEnable_BIT 10

#define UART2_ASCIntEnable (*(volatile unsigned short *)0xC0006010)

#define UART2_ASCStatus (*(volatile unsigned short *)0xC0006014)

#define UART2_ASCGuardTime (*(volatile unsigned short *)0xC0006018)

#define UART2_ASCTimeout (*(volatile unsigned short *)0xC000601C)

#define UART2_ASCTxReset (*(volatile unsigned short *)0xC0006020)

#define UART2_ASCRxReset (*(volatile unsigned short *)0xC0006024)

#define UART3_ASCBaudRate (*(volatile unsigned short *)0xC0007000)

#define UART3_ASCTxBuffer (*(volatile unsigned short *)0xC0007004)

#define UART3_ASCRxBuffer (*(volatile unsigned short *)0xC0007008)

#define UART3_ASCControl (*(volatile unsigned short *)0xC000700C)
#define UART3_ASCControl_Mode_MASK 0x7
#define UART3_ASCControl_Mode_BIT 0
#define UART3_ASCControl_Stop_Bits_MASK 0x18
#define UART3_ASCControl_Stop_Bits_BIT 3
#define UART3_ASCControl_Parity_Odd_MASK 0x20
#define UART3_ASCControl_Parity_Odd 0x20
#define UART3_ASCControl_Parity_Odd_BIT 5
#define UART3_ASCControl_Loop_Back_MASK 0x40
#define UART3_ASCControl_Loop_Back 0x40
#define UART3_ASCControl_Loop_Back_BIT 6
#define UART3_ASCControl_Run_MASK 0x80
#define UART3_ASCControl_Run 0x80
#define UART3_ASCControl_Run_BIT 7
#define UART3_ASCControl_RxEnable_MASK 0x100
#define UART3_ASCControl_RxEnable 0x100
#define UART3_ASCControl_RxEnable_BIT 8
#define UART3_ASCControl_FifoEnable_MASK 0x400
#define UART3_ASCControl_FifoEnable 0x400
#define UART3_ASCControl_FifoEnable_BIT 10

#define UART3_ASCIntEnable (*(volatile unsigned short *)0xC0007010)

#define UART3_ASCStatus (*(volatile unsigned short *)0xC0007014)

#define UART3_ASCGuardTime (*(volatile unsigned short *)0xC0007018)

#define UART3_ASCTimeout (*(volatile unsigned short *)0xC000701C)

#define UART3_ASCTxReset (*(volatile unsigned short *)0xC0007020)

#define UART3_ASCRxReset (*(volatile unsigned short *)0xC0007024)

#define USB_EP0R (*(volatile unsigned short *)0xC0008000)
#define USB_EP0R_EA_MASK 0xF
#define USB_EP0R_EA_BIT 0
#define USB_EP0R_STATTX_MASK 0x30
#define USB_EP0R_STATTX_BIT 4
#define USB_EP0R_DTOGTX_MASK 0x40
#define USB_EP0R_DTOGTX 0x40
#define USB_EP0R_DTOGTX_BIT 6
#define USB_EP0R_CTRTX_MASK 0x80
#define USB_EP0R_CTRTX 0x80
#define USB_EP0R_CTRTX_BIT 7
#define USB_EP0R_EPKIND_MASK 0x100
#define USB_EP0R_EPKIND 0x100
#define USB_EP0R_EPKIND_BIT 8
#define USB_EP0R_EPTYPE_MASK 0x600
#define USB_EP0R_EPTYPE_BIT 9
#define USB_EP0R_SETUP_MASK 0x800
#define USB_EP0R_SETUP 0x800
#define USB_EP0R_SETUP_BIT 11
#define USB_EP0R_STATRX_MASK 0x3000
#define USB_EP0R_STATRX_BIT 12
#define USB_EP0R_DTOGRX_MASK 0x4000
#define USB_EP0R_DTOGRX 0x4000
#define USB_EP0R_DTOGRX_BIT 14
#define USB_EP0R_CTRRX_MASK 0x8000
#define USB_EP0R_CTRRX 0x8000
#define USB_EP0R_CTRRX_BIT 15

#define USB_EP1R (*(volatile unsigned short *)0xC0008004)
#define USB_EP1R_EA_MASK 0xF
#define USB_EP1R_EA_BIT 0
#define USB_EP1R_STATTX_MASK 0x30
#define USB_EP1R_STATTX_BIT 4
#define USB_EP1R_DTOGTX_MASK 0x40
#define USB_EP1R_DTOGTX 0x40
#define USB_EP1R_DTOGTX_BIT 6
#define USB_EP1R_CTRTX_MASK 0x80
#define USB_EP1R_CTRTX 0x80
#define USB_EP1R_CTRTX_BIT 7
#define USB_EP1R_EPKIND_MASK 0x100
#define USB_EP1R_EPKIND 0x100
#define USB_EP1R_EPKIND_BIT 8
#define USB_EP1R_EPTYPE_MASK 0x600
#define USB_EP1R_EPTYPE_BIT 9
#define USB_EP1R_SETUP_MASK 0x800
#define USB_EP1R_SETUP 0x800
#define USB_EP1R_SETUP_BIT 11
#define USB_EP1R_STATRX_MASK 0x3000
#define USB_EP1R_STATRX_BIT 12
#define USB_EP1R_DTOGRX_MASK 0x4000
#define USB_EP1R_DTOGRX 0x4000
#define USB_EP1R_DTOGRX_BIT 14
#define USB_EP1R_CTRRX_MASK 0x8000
#define USB_EP1R_CTRRX 0x8000
#define USB_EP1R_CTRRX_BIT 15

#define USB_EP2R (*(volatile unsigned short *)0xC0008008)
#define USB_EP2R_EA_MASK 0xF
#define USB_EP2R_EA_BIT 0
#define USB_EP2R_STATTX_MASK 0x30
#define USB_EP2R_STATTX_BIT 4
#define USB_EP2R_DTOGTX_MASK 0x40
#define USB_EP2R_DTOGTX 0x40
#define USB_EP2R_DTOGTX_BIT 6
#define USB_EP2R_CTRTX_MASK 0x80
#define USB_EP2R_CTRTX 0x80
#define USB_EP2R_CTRTX_BIT 7
#define USB_EP2R_EPKIND_MASK 0x100
#define USB_EP2R_EPKIND 0x100
#define USB_EP2R_EPKIND_BIT 8
#define USB_EP2R_EPTYPE_MASK 0x600
#define USB_EP2R_EPTYPE_BIT 9
#define USB_EP2R_SETUP_MASK 0x800
#define USB_EP2R_SETUP 0x800
#define USB_EP2R_SETUP_BIT 11
#define USB_EP2R_STATRX_MASK 0x3000
#define USB_EP2R_STATRX_BIT 12
#define USB_EP2R_DTOGRX_MASK 0x4000
#define USB_EP2R_DTOGRX 0x4000
#define USB_EP2R_DTOGRX_BIT 14
#define USB_EP2R_CTRRX_MASK 0x8000
#define USB_EP2R_CTRRX 0x8000
#define USB_EP2R_CTRRX_BIT 15

#define USB_EP3R (*(volatile unsigned short *)0xC000800C)
#define USB_EP3R_EA_MASK 0xF
#define USB_EP3R_EA_BIT 0
#define USB_EP3R_STATTX_MASK 0x30
#define USB_EP3R_STATTX_BIT 4
#define USB_EP3R_DTOGTX_MASK 0x40
#define USB_EP3R_DTOGTX 0x40
#define USB_EP3R_DTOGTX_BIT 6
#define USB_EP3R_CTRTX_MASK 0x80
#define USB_EP3R_CTRTX 0x80
#define USB_EP3R_CTRTX_BIT 7
#define USB_EP3R_EPKIND_MASK 0x100
#define USB_EP3R_EPKIND 0x100
#define USB_EP3R_EPKIND_BIT 8
#define USB_EP3R_EPTYPE_MASK 0x600
#define USB_EP3R_EPTYPE_BIT 9
#define USB_EP3R_SETUP_MASK 0x800
#define USB_EP3R_SETUP 0x800
#define USB_EP3R_SETUP_BIT 11
#define USB_EP3R_STATRX_MASK 0x3000
#define USB_EP3R_STATRX_BIT 12
#define USB_EP3R_DTOGRX_MASK 0x4000
#define USB_EP3R_DTOGRX 0x4000
#define USB_EP3R_DTOGRX_BIT 14
#define USB_EP3R_CTRRX_MASK 0x8000
#define USB_EP3R_CTRRX 0x8000
#define USB_EP3R_CTRRX_BIT 15

#define USB_EP4R (*(volatile unsigned short *)0xC0008010)
#define USB_EP4R_EA_MASK 0xF
#define USB_EP4R_EA_BIT 0
#define USB_EP4R_STATTX_MASK 0x30
#define USB_EP4R_STATTX_BIT 4
#define USB_EP4R_DTOGTX_MASK 0x40
#define USB_EP4R_DTOGTX 0x40
#define USB_EP4R_DTOGTX_BIT 6
#define USB_EP4R_CTRTX_MASK 0x80
#define USB_EP4R_CTRTX 0x80
#define USB_EP4R_CTRTX_BIT 7
#define USB_EP4R_EPKIND_MASK 0x100
#define USB_EP4R_EPKIND 0x100
#define USB_EP4R_EPKIND_BIT 8
#define USB_EP4R_EPTYPE_MASK 0x600
#define USB_EP4R_EPTYPE_BIT 9
#define USB_EP4R_SETUP_MASK 0x800
#define USB_EP4R_SETUP 0x800
#define USB_EP4R_SETUP_BIT 11
#define USB_EP4R_STATRX_MASK 0x3000
#define USB_EP4R_STATRX_BIT 12
#define USB_EP4R_DTOGRX_MASK 0x4000
#define USB_EP4R_DTOGRX 0x4000
#define USB_EP4R_DTOGRX_BIT 14
#define USB_EP4R_CTRRX_MASK 0x8000
#define USB_EP4R_CTRRX 0x8000
#define USB_EP4R_CTRRX_BIT 15

#define USB_EP5R (*(volatile unsigned short *)0xC0008014)
#define USB_EP5R_EA_MASK 0xF
#define USB_EP5R_EA_BIT 0
#define USB_EP5R_STATTX_MASK 0x30
#define USB_EP5R_STATTX_BIT 4
#define USB_EP5R_DTOGTX_MASK 0x40
#define USB_EP5R_DTOGTX 0x40
#define USB_EP5R_DTOGTX_BIT 6
#define USB_EP5R_CTRTX_MASK 0x80
#define USB_EP5R_CTRTX 0x80
#define USB_EP5R_CTRTX_BIT 7
#define USB_EP5R_EPKIND_MASK 0x100
#define USB_EP5R_EPKIND 0x100
#define USB_EP5R_EPKIND_BIT 8
#define USB_EP5R_EPTYPE_MASK 0x600
#define USB_EP5R_EPTYPE_BIT 9
#define USB_EP5R_SETUP_MASK 0x800
#define USB_EP5R_SETUP 0x800
#define USB_EP5R_SETUP_BIT 11
#define USB_EP5R_STATRX_MASK 0x3000
#define USB_EP5R_STATRX_BIT 12
#define USB_EP5R_DTOGRX_MASK 0x4000
#define USB_EP5R_DTOGRX 0x4000
#define USB_EP5R_DTOGRX_BIT 14
#define USB_EP5R_CTRRX_MASK 0x8000
#define USB_EP5R_CTRRX 0x8000
#define USB_EP5R_CTRRX_BIT 15

#define USB_EP6R (*(volatile unsigned short *)0xC0008018)
#define USB_EP6R_EA_MASK 0xF
#define USB_EP6R_EA_BIT 0
#define USB_EP6R_STATTX_MASK 0x30
#define USB_EP6R_STATTX_BIT 4
#define USB_EP6R_DTOGTX_MASK 0x40
#define USB_EP6R_DTOGTX 0x40
#define USB_EP6R_DTOGTX_BIT 6
#define USB_EP6R_CTRTX_MASK 0x80
#define USB_EP6R_CTRTX 0x80
#define USB_EP6R_CTRTX_BIT 7
#define USB_EP6R_EPKIND_MASK 0x100
#define USB_EP6R_EPKIND 0x100
#define USB_EP6R_EPKIND_BIT 8
#define USB_EP6R_EPTYPE_MASK 0x600
#define USB_EP6R_EPTYPE_BIT 9
#define USB_EP6R_SETUP_MASK 0x800
#define USB_EP6R_SETUP 0x800
#define USB_EP6R_SETUP_BIT 11
#define USB_EP6R_STATRX_MASK 0x3000
#define USB_EP6R_STATRX_BIT 12
#define USB_EP6R_DTOGRX_MASK 0x4000
#define USB_EP6R_DTOGRX 0x4000
#define USB_EP6R_DTOGRX_BIT 14
#define USB_EP6R_CTRRX_MASK 0x8000
#define USB_EP6R_CTRRX 0x8000
#define USB_EP6R_CTRRX_BIT 15

#define USB_EP7R (*(volatile unsigned short *)0xC000801C)
#define USB_EP7R_EA_MASK 0xF
#define USB_EP7R_EA_BIT 0
#define USB_EP7R_STATTX_MASK 0x30
#define USB_EP7R_STATTX_BIT 4
#define USB_EP7R_DTOGTX_MASK 0x40
#define USB_EP7R_DTOGTX 0x40
#define USB_EP7R_DTOGTX_BIT 6
#define USB_EP7R_CTRTX_MASK 0x80
#define USB_EP7R_CTRTX 0x80
#define USB_EP7R_CTRTX_BIT 7
#define USB_EP7R_EPKIND_MASK 0x100
#define USB_EP7R_EPKIND 0x100
#define USB_EP7R_EPKIND_BIT 8
#define USB_EP7R_EPTYPE_MASK 0x600
#define USB_EP7R_EPTYPE_BIT 9
#define USB_EP7R_SETUP_MASK 0x800
#define USB_EP7R_SETUP 0x800
#define USB_EP7R_SETUP_BIT 11
#define USB_EP7R_STATRX_MASK 0x3000
#define USB_EP7R_STATRX_BIT 12
#define USB_EP7R_DTOGRX_MASK 0x4000
#define USB_EP7R_DTOGRX 0x4000
#define USB_EP7R_DTOGRX_BIT 14
#define USB_EP7R_CTRRX_MASK 0x8000
#define USB_EP7R_CTRRX 0x8000
#define USB_EP7R_CTRRX_BIT 15

#define USB_CNTR (*(volatile unsigned short *)0xC0008040)
#define USB_CNTR_FRES_MASK 0x1
#define USB_CNTR_FRES 0x1
#define USB_CNTR_FRES_BIT 0
#define USB_CNTR_PDWN_MASK 0x2
#define USB_CNTR_PDWN 0x2
#define USB_CNTR_PDWN_BIT 1
#define USB_CNTR_LPMODE_MASK 0x4
#define USB_CNTR_LPMODE 0x4
#define USB_CNTR_LPMODE_BIT 2
#define USB_CNTR_FSUSP_MASK 0x8
#define USB_CNTR_FSUSP 0x8
#define USB_CNTR_FSUSP_BIT 3
#define USB_CNTR_RESUME_MASK 0x10
#define USB_CNTR_RESUME 0x10
#define USB_CNTR_RESUME_BIT 4
#define USB_CNTR_ESOFM_MASK 0x100
#define USB_CNTR_ESOFM 0x100
#define USB_CNTR_ESOFM_BIT 8
#define USB_CNTR_SOFM_MASK 0x200
#define USB_CNTR_SOFM 0x200
#define USB_CNTR_SOFM_BIT 9
#define USB_CNTR_RESETM_MASK 0x400
#define USB_CNTR_RESETM 0x400
#define USB_CNTR_RESETM_BIT 10
#define USB_CNTR_SUSPM_MASK 0x800
#define USB_CNTR_SUSPM 0x800
#define USB_CNTR_SUSPM_BIT 11
#define USB_CNTR_WKPM_MASK 0x1000
#define USB_CNTR_WKPM 0x1000
#define USB_CNTR_WKPM_BIT 12
#define USB_CNTR_ERRM_MASK 0x2000
#define USB_CNTR_ERRM 0x2000
#define USB_CNTR_ERRM_BIT 13
#define USB_CNTR_DORM_MASK 0x4000
#define USB_CNTR_DORM 0x4000
#define USB_CNTR_DORM_BIT 14
#define USB_CNTR_CTRM_MASK 0x8000
#define USB_CNTR_CTRM 0x8000
#define USB_CNTR_CTRM_BIT 15

#define USB_ISTR (*(volatile unsigned short *)0xC0008044)
#define USB_ISTR_EP_ID_MASK 0xF
#define USB_ISTR_EP_ID_BIT 0
#define USB_ISTR_DIR_MASK 0x10
#define USB_ISTR_DIR 0x10
#define USB_ISTR_DIR_BIT 4
#define USB_ISTR_ESOF_MASK 0x100
#define USB_ISTR_ESOF 0x100
#define USB_ISTR_ESOF_BIT 8
#define USB_ISTR_SOF_MASK 0x200
#define USB_ISTR_SOF 0x200
#define USB_ISTR_SOF_BIT 9
#define USB_ISTR_RESET_MASK 0x400
#define USB_ISTR_RESET 0x400
#define USB_ISTR_RESET_BIT 10
#define USB_ISTR_SUSP_MASK 0x800
#define USB_ISTR_SUSP 0x800
#define USB_ISTR_SUSP_BIT 11
#define USB_ISTR_WKUP_MASK 0x1000
#define USB_ISTR_WKUP 0x1000
#define USB_ISTR_WKUP_BIT 12
#define USB_ISTR_ERR_MASK 0x2000
#define USB_ISTR_ERR 0x2000
#define USB_ISTR_ERR_BIT 13
#define USB_ISTR_DOVR_MASK 0x4000
#define USB_ISTR_DOVR 0x4000
#define USB_ISTR_DOVR_BIT 14
#define USB_ISTR_CTR_MASK 0x8000
#define USB_ISTR_CTR 0x8000
#define USB_ISTR_CTR_BIT 15

#define USB_FNR (*(volatile unsigned short *)0xC0008048)
#define USB_FNR_FN_MASK 0x7FF
#define USB_FNR_FN_BIT 0
#define USB_FNR_LSOF_MASK 0x1800
#define USB_FNR_LSOF_BIT 11
#define USB_FNR_LCK_MASK 0x6000
#define USB_FNR_LCK_BIT 13
#define USB_FNR_RXDM_MASK 0xC000
#define USB_FNR_RXDM_BIT 14
#define USB_FNR_RXDP_MASK 0x18000
#define USB_FNR_RXDP_BIT 15

#define USB_DADDR (*(volatile unsigned short *)0xC000804C)
#define USB_DADDR_ADD_MASK 0x7F
#define USB_DADDR_ADD_BIT 0
#define USB_DADDR_EF_MASK 0x80
#define USB_DADDR_EF 0x80
#define USB_DADDR_EF_BIT 7

#define USB_BTABLE (*(volatile unsigned short *)0xC0008050)
#define USB_BTABLE_BTABLE_MASK 0xFFF8
#define USB_BTABLE_BTABLE_BIT 3

#define CAN_Control_Register (*(volatile unsigned short *)0xC0009000)
#define CAN_Control_Register_Init_MASK 0x1
#define CAN_Control_Register_Init 0x1
#define CAN_Control_Register_Init_BIT 0
#define CAN_Control_Register_IE_MASK 0x2
#define CAN_Control_Register_IE 0x2
#define CAN_Control_Register_IE_BIT 1
#define CAN_Control_Register_SIE_MASK 0x4
#define CAN_Control_Register_SIE 0x4
#define CAN_Control_Register_SIE_BIT 2
#define CAN_Control_Register_EIE_MASK 0x8
#define CAN_Control_Register_EIE 0x8
#define CAN_Control_Register_EIE_BIT 3
#define CAN_Control_Register_DAR_MASK 0x20
#define CAN_Control_Register_DAR 0x20
#define CAN_Control_Register_DAR_BIT 5
#define CAN_Control_Register_CCE_MASK 0x40
#define CAN_Control_Register_CCE 0x40
#define CAN_Control_Register_CCE_BIT 6
#define CAN_Control_Register_Test_MASK 0x80
#define CAN_Control_Register_Test 0x80
#define CAN_Control_Register_Test_BIT 7

#define CAN_Status_Register (*(volatile unsigned short *)0xC0009004)
#define CAN_Status_Register_LEC_MASK 0x7
#define CAN_Status_Register_LEC_BIT 0
#define CAN_Status_Register_TxOk_MASK 0x8
#define CAN_Status_Register_TxOk 0x8
#define CAN_Status_Register_TxOk_BIT 3
#define CAN_Status_Register_RxOk_MASK 0x10
#define CAN_Status_Register_RxOk 0x10
#define CAN_Status_Register_RxOk_BIT 4
#define CAN_Status_Register_EPass_MASK 0x20
#define CAN_Status_Register_EPass 0x20
#define CAN_Status_Register_EPass_BIT 5
#define CAN_Status_Register_EWarn_MASK 0x40
#define CAN_Status_Register_EWarn 0x40
#define CAN_Status_Register_EWarn_BIT 6
#define CAN_Status_Register_BOff_MASK 0x80
#define CAN_Status_Register_BOff 0x80
#define CAN_Status_Register_BOff_BIT 7

#define CAN_Error_Counter (*(volatile unsigned short *)0xC0009008)
#define CAN_Error_Counter_TEC7_0_MASK 0xFF
#define CAN_Error_Counter_TEC7_0_BIT 0
#define CAN_Error_Counter_REC6_0_MASK 0x7F00
#define CAN_Error_Counter_REC6_0_BIT 8
#define CAN_Error_Counter_RP_MASK 0x8000
#define CAN_Error_Counter_RP 0x8000
#define CAN_Error_Counter_RP_BIT 15

#define CAN_Bit_Timing_Register (*(volatile unsigned short *)0xC000900C)
#define CAN_Bit_Timing_Register_BRP_MASK 0x3F
#define CAN_Bit_Timing_Register_BRP_BIT 0
#define CAN_Bit_Timing_Register_SJW_MASK 0xC0
#define CAN_Bit_Timing_Register_SJW_BIT 6
#define CAN_Bit_Timing_Register_TSeg1_MASK 0xF00
#define CAN_Bit_Timing_Register_TSeg1_BIT 8
#define CAN_Bit_Timing_Register_TSeg2_MASK 0x7000
#define CAN_Bit_Timing_Register_TSeg2_BIT 12

#define CAN_Interrupt_Register (*(volatile unsigned short *)0xC0009010)
#define CAN_Interrupt_Register_IntId7_0_MASK 0xFF
#define CAN_Interrupt_Register_IntId7_0_BIT 0
#define CAN_Interrupt_Register_IntId15_8_MASK 0xFF00
#define CAN_Interrupt_Register_IntId15_8_BIT 8

#define CAN_Test_Register (*(volatile unsigned short *)0xC0009014)
#define CAN_Test_Register_Basic_MASK 0x4
#define CAN_Test_Register_Basic 0x4
#define CAN_Test_Register_Basic_BIT 2
#define CAN_Test_Register_Silent_MASK 0x8
#define CAN_Test_Register_Silent 0x8
#define CAN_Test_Register_Silent_BIT 3
#define CAN_Test_Register_LBack_MASK 0x10
#define CAN_Test_Register_LBack 0x10
#define CAN_Test_Register_LBack_BIT 4
#define CAN_Test_Register_Tx0_MASK 0x20
#define CAN_Test_Register_Tx0 0x20
#define CAN_Test_Register_Tx0_BIT 5
#define CAN_Test_Register_Tx1_MASK 0x40
#define CAN_Test_Register_Tx1 0x40
#define CAN_Test_Register_Tx1_BIT 6
#define CAN_Test_Register_Rx1_MASK 0x80
#define CAN_Test_Register_Rx1 0x80
#define CAN_Test_Register_Rx1_BIT 7

#define CAN_BPR_Extension_Register (*(volatile unsigned short *)0xC0009018)

#define CAN_IF1_Command_Request (*(volatile unsigned short *)0xC0009020)
#define CAN_IF1_Command_Request_Message_Number_MASK 0x3F
#define CAN_IF1_Command_Request_Message_Number_BIT 0
#define CAN_IF1_Command_Request_Busy_MASK 0x8000
#define CAN_IF1_Command_Request_Busy 0x8000
#define CAN_IF1_Command_Request_Busy_BIT 15

#define CAN_IF1_Command_Mask (*(volatile unsigned short *)0xC0009024)
#define CAN_IF1_Command_Mask_Data_B_MASK 0x1
#define CAN_IF1_Command_Mask_Data_B 0x1
#define CAN_IF1_Command_Mask_Data_B_BIT 0
#define CAN_IF1_Command_Mask_Data_A_MASK 0x2
#define CAN_IF1_Command_Mask_Data_A 0x2
#define CAN_IF1_Command_Mask_Data_A_BIT 1
#define CAN_IF1_Command_Mask_TxRqst_NewDat_MASK 0x4
#define CAN_IF1_Command_Mask_TxRqst_NewDat 0x4
#define CAN_IF1_Command_Mask_TxRqst_NewDat_BIT 2
#define CAN_IF1_Command_Mask_ClrIntPnd_MASK 0x8
#define CAN_IF1_Command_Mask_ClrIntPnd 0x8
#define CAN_IF1_Command_Mask_ClrIntPnd_BIT 3
#define CAN_IF1_Command_Mask_Control_MASK 0x10
#define CAN_IF1_Command_Mask_Control 0x10
#define CAN_IF1_Command_Mask_Control_BIT 4
#define CAN_IF1_Command_Mask_Arb_MASK 0x20
#define CAN_IF1_Command_Mask_Arb 0x20
#define CAN_IF1_Command_Mask_Arb_BIT 5
#define CAN_IF1_Command_Mask_Mask_MASK 0x40
#define CAN_IF1_Command_Mask_Mask 0x40
#define CAN_IF1_Command_Mask_Mask_BIT 6
#define CAN_IF1_Command_Mask_WR_RD_MASK 0x80
#define CAN_IF1_Command_Mask_WR_RD 0x80
#define CAN_IF1_Command_Mask_WR_RD_BIT 7

#define CAN_IF1_Mask_1 (*(volatile unsigned short *)0xC0009028)

#define CAN_IF1_Mask_2 (*(volatile unsigned short *)0xC000902C)
#define CAN_IF1_Mask_2_Msk28_16_MASK 0x1FFF
#define CAN_IF1_Mask_2_Msk28_16_BIT 0
#define CAN_IF1_Mask_2_MDir_MASK 0x4000
#define CAN_IF1_Mask_2_MDir 0x4000
#define CAN_IF1_Mask_2_MDir_BIT 14
#define CAN_IF1_Mask_2_MXtd_MASK 0x8000
#define CAN_IF1_Mask_2_MXtd 0x8000
#define CAN_IF1_Mask_2_MXtd_BIT 15

#define CAN_IF1_Arbitration_1 (*(volatile unsigned short *)0xC0009030)

#define CAN_IF1_Arbitration_2 (*(volatile unsigned short *)0xC0009034)
#define CAN_IF1_Arbitration_2_ID28_16_MASK 0x1FFF
#define CAN_IF1_Arbitration_2_ID28_16_BIT 0
#define CAN_IF1_Arbitration_2_Dir_MASK 0x2000
#define CAN_IF1_Arbitration_2_Dir 0x2000
#define CAN_IF1_Arbitration_2_Dir_BIT 13
#define CAN_IF1_Arbitration_2_Xtd_MASK 0x4000
#define CAN_IF1_Arbitration_2_Xtd 0x4000
#define CAN_IF1_Arbitration_2_Xtd_BIT 14
#define CAN_IF1_Arbitration_2_MsgVaI_MASK 0x8000
#define CAN_IF1_Arbitration_2_MsgVaI 0x8000
#define CAN_IF1_Arbitration_2_MsgVaI_BIT 15

#define CAN_IF1_Message_Control (*(volatile unsigned short *)0xC0009038)
#define CAN_IF1_Message_Control_DLC3_0_MASK 0xF
#define CAN_IF1_Message_Control_DLC3_0_BIT 0
#define CAN_IF1_Message_Control_EoB_MASK 0x80
#define CAN_IF1_Message_Control_EoB 0x80
#define CAN_IF1_Message_Control_EoB_BIT 7
#define CAN_IF1_Message_Control_TxRqst_MASK 0x100
#define CAN_IF1_Message_Control_TxRqst 0x100
#define CAN_IF1_Message_Control_TxRqst_BIT 8
#define CAN_IF1_Message_Control_RmtEn_MASK 0x200
#define CAN_IF1_Message_Control_RmtEn 0x200
#define CAN_IF1_Message_Control_RmtEn_BIT 9
#define CAN_IF1_Message_Control_RxlE_MASK 0x400
#define CAN_IF1_Message_Control_RxlE 0x400
#define CAN_IF1_Message_Control_RxlE_BIT 10
#define CAN_IF1_Message_Control_TxlE_MASK 0x800
#define CAN_IF1_Message_Control_TxlE 0x800
#define CAN_IF1_Message_Control_TxlE_BIT 11
#define CAN_IF1_Message_Control_UMask_MASK 0x1000
#define CAN_IF1_Message_Control_UMask 0x1000
#define CAN_IF1_Message_Control_UMask_BIT 12
#define CAN_IF1_Message_Control_IntPnd_MASK 0x2000
#define CAN_IF1_Message_Control_IntPnd 0x2000
#define CAN_IF1_Message_Control_IntPnd_BIT 13
#define CAN_IF1_Message_Control_MsgLst_MASK 0x4000
#define CAN_IF1_Message_Control_MsgLst 0x4000
#define CAN_IF1_Message_Control_MsgLst_BIT 14
#define CAN_IF1_Message_Control_NewDat_MASK 0x8000
#define CAN_IF1_Message_Control_NewDat 0x8000
#define CAN_IF1_Message_Control_NewDat_BIT 15

#define CAN_IF1_Data_A_1 (*(volatile unsigned short *)0xC000903C)

#define CAN_IF1_Data_A_2 (*(volatile unsigned short *)0xC0009040)

#define CAN_IF1_Data_B_1 (*(volatile unsigned short *)0xC0009044)

#define CAN_IF1_Data_B_2 (*(volatile unsigned short *)0xC0009048)

#define CAN_IF2_Command_Request (*(volatile unsigned short *)0xC0009080)
#define CAN_IF2_Command_Request_Message_Number_MASK 0x3F
#define CAN_IF2_Command_Request_Message_Number_BIT 0
#define CAN_IF2_Command_Request_Busy_MASK 0x8000
#define CAN_IF2_Command_Request_Busy 0x8000
#define CAN_IF2_Command_Request_Busy_BIT 15

#define CAN_IF2_Command_Mask (*(volatile unsigned short *)0xC0009084)
#define CAN_IF2_Command_Mask_Data_B_MASK 0x1
#define CAN_IF2_Command_Mask_Data_B 0x1
#define CAN_IF2_Command_Mask_Data_B_BIT 0
#define CAN_IF2_Command_Mask_Data_A_MASK 0x2
#define CAN_IF2_Command_Mask_Data_A 0x2
#define CAN_IF2_Command_Mask_Data_A_BIT 1
#define CAN_IF2_Command_Mask_TxRqst_NewDat_MASK 0x4
#define CAN_IF2_Command_Mask_TxRqst_NewDat 0x4
#define CAN_IF2_Command_Mask_TxRqst_NewDat_BIT 2
#define CAN_IF2_Command_Mask_ClrIntPnd_MASK 0x8
#define CAN_IF2_Command_Mask_ClrIntPnd 0x8
#define CAN_IF2_Command_Mask_ClrIntPnd_BIT 3
#define CAN_IF2_Command_Mask_Control_MASK 0x10
#define CAN_IF2_Command_Mask_Control 0x10
#define CAN_IF2_Command_Mask_Control_BIT 4
#define CAN_IF2_Command_Mask_Arb_MASK 0x20
#define CAN_IF2_Command_Mask_Arb 0x20
#define CAN_IF2_Command_Mask_Arb_BIT 5
#define CAN_IF2_Command_Mask_Mask_MASK 0x40
#define CAN_IF2_Command_Mask_Mask 0x40
#define CAN_IF2_Command_Mask_Mask_BIT 6
#define CAN_IF2_Command_Mask_WR_RD_MASK 0x80
#define CAN_IF2_Command_Mask_WR_RD 0x80
#define CAN_IF2_Command_Mask_WR_RD_BIT 7

#define CAN_IF2_Mask_1 (*(volatile unsigned short *)0xC0009088)

#define CAN_IF2_Mask_2 (*(volatile unsigned short *)0xC000908C)
#define CAN_IF2_Mask_2_Msk28_16_MASK 0x1FFF
#define CAN_IF2_Mask_2_Msk28_16_BIT 0
#define CAN_IF2_Mask_2_MDir_MASK 0x4000
#define CAN_IF2_Mask_2_MDir 0x4000
#define CAN_IF2_Mask_2_MDir_BIT 14
#define CAN_IF2_Mask_2_MXtd_MASK 0x8000
#define CAN_IF2_Mask_2_MXtd 0x8000
#define CAN_IF2_Mask_2_MXtd_BIT 15

#define CAN_IF2_Arbitration_1 (*(volatile unsigned short *)0xC0009090)

#define CAN_IF2_Arbitration_2 (*(volatile unsigned short *)0xC0009094)
#define CAN_IF2_Arbitration_2_ID28_16_MASK 0x1FFF
#define CAN_IF2_Arbitration_2_ID28_16_BIT 0
#define CAN_IF2_Arbitration_2_Dir_MASK 0x2000
#define CAN_IF2_Arbitration_2_Dir 0x2000
#define CAN_IF2_Arbitration_2_Dir_BIT 13
#define CAN_IF2_Arbitration_2_Xtd_MASK 0x4000
#define CAN_IF2_Arbitration_2_Xtd 0x4000
#define CAN_IF2_Arbitration_2_Xtd_BIT 14
#define CAN_IF2_Arbitration_2_MsgVaI_MASK 0x8000
#define CAN_IF2_Arbitration_2_MsgVaI 0x8000
#define CAN_IF2_Arbitration_2_MsgVaI_BIT 15

#define CAN_IF2_Message_Control (*(volatile unsigned short *)0xC0009098)
#define CAN_IF2_Message_Control_DLC3_0_MASK 0xF
#define CAN_IF2_Message_Control_DLC3_0_BIT 0
#define CAN_IF2_Message_Control_EoB_MASK 0x80
#define CAN_IF2_Message_Control_EoB 0x80
#define CAN_IF2_Message_Control_EoB_BIT 7
#define CAN_IF2_Message_Control_TxRqst_MASK 0x100
#define CAN_IF2_Message_Control_TxRqst 0x100
#define CAN_IF2_Message_Control_TxRqst_BIT 8
#define CAN_IF2_Message_Control_RmtEn_MASK 0x200
#define CAN_IF2_Message_Control_RmtEn 0x200
#define CAN_IF2_Message_Control_RmtEn_BIT 9
#define CAN_IF2_Message_Control_RxlE_MASK 0x400
#define CAN_IF2_Message_Control_RxlE 0x400
#define CAN_IF2_Message_Control_RxlE_BIT 10
#define CAN_IF2_Message_Control_TxlE_MASK 0x800
#define CAN_IF2_Message_Control_TxlE 0x800
#define CAN_IF2_Message_Control_TxlE_BIT 11
#define CAN_IF2_Message_Control_UMask_MASK 0x1000
#define CAN_IF2_Message_Control_UMask 0x1000
#define CAN_IF2_Message_Control_UMask_BIT 12
#define CAN_IF2_Message_Control_IntPnd_MASK 0x2000
#define CAN_IF2_Message_Control_IntPnd 0x2000
#define CAN_IF2_Message_Control_IntPnd_BIT 13
#define CAN_IF2_Message_Control_MsgLst_MASK 0x4000
#define CAN_IF2_Message_Control_MsgLst 0x4000
#define CAN_IF2_Message_Control_MsgLst_BIT 14
#define CAN_IF2_Message_Control_NewDat_MASK 0x8000
#define CAN_IF2_Message_Control_NewDat 0x8000
#define CAN_IF2_Message_Control_NewDat_BIT 15

#define CAN_IF2_Data_A_1 (*(volatile unsigned short *)0xC000909C)

#define CAN_IF2_Data_A_2 (*(volatile unsigned short *)0xC00090A0)

#define CAN_IF2_Data_B_1 (*(volatile unsigned short *)0xC00090A4)

#define CAN_IF2_Data_B_2 (*(volatile unsigned short *)0xC00090A8)

#define CAN_Transmission_Request_1 (*(volatile unsigned short *)0xC0009100)

#define CAN_Transmission_Request_2 (*(volatile unsigned short *)0xC0009104)

#define CAN_New_Data_1 (*(volatile unsigned short *)0xC0009120)

#define CAN_New_Data_2 (*(volatile unsigned short *)0xC0009124)

#define CAN_Interrupt_Pending_1 (*(volatile unsigned short *)0xC0009140)
#define CAN_Interrupt_Pending_1_IntPnd8_1_MASK 0xFF
#define CAN_Interrupt_Pending_1_IntPnd8_1_BIT 0
#define CAN_Interrupt_Pending_1_IntPnd16_9_MASK 0xFF00
#define CAN_Interrupt_Pending_1_IntPnd16_9_BIT 8

#define CAN_Interrupt_Pending_2 (*(volatile unsigned short *)0xC0009144)
#define CAN_Interrupt_Pending_2_IntPnd24_17_MASK 0xFF
#define CAN_Interrupt_Pending_2_IntPnd24_17_BIT 0
#define CAN_Interrupt_Pending_2_IntPnd32_25_MASK 0xFF00
#define CAN_Interrupt_Pending_2_IntPnd32_25_BIT 8

#define CAN_Message_Valid_1 (*(volatile unsigned short *)0xC0009160)
#define CAN_Message_Valid_1_MsgVal8_1_MASK 0xFF
#define CAN_Message_Valid_1_MsgVal8_1_BIT 0
#define CAN_Message_Valid_1_MsgVal16_9_MASK 0xFF00
#define CAN_Message_Valid_1_MsgVal16_9_BIT 8

#define CAN_Message_Valid_2 (*(volatile unsigned short *)0xC0009164)
#define CAN_Message_Valid_2_MsgVal24_17_MASK 0xFF
#define CAN_Message_Valid_2_MsgVal24_17_BIT 0
#define CAN_Message_Valid_2_MsgVal32_25_MASK 0xFF00
#define CAN_Message_Valid_2_MsgVal32_25_BIT 8

#define BSPI0_BSPRXR (*(volatile unsigned short *)0xC000A000)

#define BSPI0_BSPTXR (*(volatile unsigned short *)0xC000A004)

#define BSPI0_BSPCSR1 (*(volatile unsigned short *)0xC000A008)
#define BSPI0_BSPCSR1_BSPE_MASK 0x1
#define BSPI0_BSPCSR1_BSPE 0x1
#define BSPI0_BSPCSR1_BSPE_BIT 0
#define BSPI0_BSPCSR1_MSTR_MASK 0x2
#define BSPI0_BSPCSR1_MSTR 0x2
#define BSPI0_BSPCSR1_MSTR_BIT 1
#define BSPI0_BSPCSR1_RIE_MASK 0xC
#define BSPI0_BSPCSR1_RIE_BIT 2
#define BSPI0_BSPCSR1_REIE_MASK 0x10
#define BSPI0_BSPCSR1_REIE 0x10
#define BSPI0_BSPCSR1_REIE_BIT 4
#define BSPI0_BSPCSR1_BEIE_MASK 0x80
#define BSPI0_BSPCSR1_BEIE 0x80
#define BSPI0_BSPCSR1_BEIE_BIT 7
#define BSPI0_BSPCSR1_CPOL_MASK 0x100
#define BSPI0_BSPCSR1_CPOL 0x100
#define BSPI0_BSPCSR1_CPOL_BIT 8
#define BSPI0_BSPCSR1_CPHA_MASK 0x200
#define BSPI0_BSPCSR1_CPHA 0x200
#define BSPI0_BSPCSR1_CPHA_BIT 9
#define BSPI0_BSPCSR1_WL_MASK 0xC00
#define BSPI0_BSPCSR1_WL_BIT 10
#define BSPI0_BSPCSR1_RFE_MASK 0xF000
#define BSPI0_BSPCSR1_RFE_BIT 12

#define BSPI0_BSPCSR2 (*(volatile unsigned short *)0xC000A00C)
#define BSPI0_BSPCSR2_DFIFO_MASK 0x1
#define BSPI0_BSPCSR2_DFIFO 0x1
#define BSPI0_BSPCSR2_DFIFO_BIT 0
#define BSPI0_BSPCSR2_BERR_MASK 0x4
#define BSPI0_BSPCSR2_BERR 0x4
#define BSPI0_BSPCSR2_BERR_BIT 2
#define BSPI0_BSPCSR2_RFNE_MASK 0x8
#define BSPI0_BSPCSR2_RFNE 0x8
#define BSPI0_BSPCSR2_RFNE_BIT 3
#define BSPI0_BSPCSR2_RFF_MASK 0x10
#define BSPI0_BSPCSR2_RFF 0x10
#define BSPI0_BSPCSR2_RFF_BIT 4
#define BSPI0_BSPCSR2_ROFL_MASK 0x20
#define BSPI0_BSPCSR2_ROFL 0x20
#define BSPI0_BSPCSR2_ROFL_BIT 5
#define BSPI0_BSPCSR2_TFE_MASK 0x40
#define BSPI0_BSPCSR2_TFE 0x40
#define BSPI0_BSPCSR2_TFE_BIT 6
#define BSPI0_BSPCSR2_TUFL_MASK 0x80
#define BSPI0_BSPCSR2_TUFL 0x80
#define BSPI0_BSPCSR2_TUFL_BIT 7
#define BSPI0_BSPCSR2_TFF_MASK 0x100
#define BSPI0_BSPCSR2_TFF 0x100
#define BSPI0_BSPCSR2_TFF_BIT 8
#define BSPI0_BSPCSR2_TFNE_MASK 0x200
#define BSPI0_BSPCSR2_TFNE 0x200
#define BSPI0_BSPCSR2_TFNE_BIT 9
#define BSPI0_BSPCSR2_TFE_MASK 0x3C00
#define BSPI0_BSPCSR2_TFE_BIT 10
#define BSPI0_BSPCSR2_TIE_MASK 0xC000
#define BSPI0_BSPCSR2_TIE_BIT 14

#define BSPI0_BSPCLK (*(volatile unsigned short *)0xC000A010)

#define BSPI1_BSPRXR (*(volatile unsigned short *)0xC000B000)

#define BSPI1_BSPTXR (*(volatile unsigned short *)0xC000B004)

#define BSPI1_BSPCSR1 (*(volatile unsigned short *)0xC000B008)
#define BSPI1_BSPCSR1_BSPE_MASK 0x1
#define BSPI1_BSPCSR1_BSPE 0x1
#define BSPI1_BSPCSR1_BSPE_BIT 0
#define BSPI1_BSPCSR1_MSTR_MASK 0x2
#define BSPI1_BSPCSR1_MSTR 0x2
#define BSPI1_BSPCSR1_MSTR_BIT 1
#define BSPI1_BSPCSR1_RIE_MASK 0xC
#define BSPI1_BSPCSR1_RIE_BIT 2
#define BSPI1_BSPCSR1_REIE_MASK 0x10
#define BSPI1_BSPCSR1_REIE 0x10
#define BSPI1_BSPCSR1_REIE_BIT 4
#define BSPI1_BSPCSR1_BEIE_MASK 0x80
#define BSPI1_BSPCSR1_BEIE 0x80
#define BSPI1_BSPCSR1_BEIE_BIT 7
#define BSPI1_BSPCSR1_CPOL_MASK 0x100
#define BSPI1_BSPCSR1_CPOL 0x100
#define BSPI1_BSPCSR1_CPOL_BIT 8
#define BSPI1_BSPCSR1_CPHA_MASK 0x200
#define BSPI1_BSPCSR1_CPHA 0x200
#define BSPI1_BSPCSR1_CPHA_BIT 9
#define BSPI1_BSPCSR1_WL_MASK 0xC00
#define BSPI1_BSPCSR1_WL_BIT 10
#define BSPI1_BSPCSR1_RFE_MASK 0xF000
#define BSPI1_BSPCSR1_RFE_BIT 12

#define BSPI1_BSPCSR2 (*(volatile unsigned short *)0xC000B00C)
#define BSPI1_BSPCSR2_DFIFO_MASK 0x1
#define BSPI1_BSPCSR2_DFIFO 0x1
#define BSPI1_BSPCSR2_DFIFO_BIT 0
#define BSPI1_BSPCSR2_BERR_MASK 0x4
#define BSPI1_BSPCSR2_BERR 0x4
#define BSPI1_BSPCSR2_BERR_BIT 2
#define BSPI1_BSPCSR2_RFNE_MASK 0x8
#define BSPI1_BSPCSR2_RFNE 0x8
#define BSPI1_BSPCSR2_RFNE_BIT 3
#define BSPI1_BSPCSR2_RFF_MASK 0x10
#define BSPI1_BSPCSR2_RFF 0x10
#define BSPI1_BSPCSR2_RFF_BIT 4
#define BSPI1_BSPCSR2_ROFL_MASK 0x20
#define BSPI1_BSPCSR2_ROFL 0x20
#define BSPI1_BSPCSR2_ROFL_BIT 5
#define BSPI1_BSPCSR2_TFE_MASK 0x40
#define BSPI1_BSPCSR2_TFE 0x40
#define BSPI1_BSPCSR2_TFE_BIT 6
#define BSPI1_BSPCSR2_TUFL_MASK 0x80
#define BSPI1_BSPCSR2_TUFL 0x80
#define BSPI1_BSPCSR2_TUFL_BIT 7
#define BSPI1_BSPCSR2_TFF_MASK 0x100
#define BSPI1_BSPCSR2_TFF 0x100
#define BSPI1_BSPCSR2_TFF_BIT 8
#define BSPI1_BSPCSR2_TFNE_MASK 0x200
#define BSPI1_BSPCSR2_TFNE 0x200
#define BSPI1_BSPCSR2_TFNE_BIT 9
#define BSPI1_BSPCSR2_TFE_MASK 0x3C00
#define BSPI1_BSPCSR2_TFE_BIT 10
#define BSPI1_BSPCSR2_TIE_MASK 0xC000
#define BSPI1_BSPCSR2_TIE_BIT 14

#define BSPI1_BSPCLK (*(volatile unsigned short *)0xC000B010)

#define HDLC_Private_Address_High (*(volatile unsigned short *)0xC000E000)
#define HDLC_Private_Address_High_PAB2_MASK 0xFF
#define HDLC_Private_Address_High_PAB2_BIT 0
#define HDLC_Private_Address_High_PAB3_MASK 0xFF00
#define HDLC_Private_Address_High_PAB3_BIT 8

#define HDLC_Private_Address_Low (*(volatile unsigned short *)0xC000E004)
#define HDLC_Private_Address_Low_PAB0_MASK 0xFF
#define HDLC_Private_Address_Low_PAB0_BIT 0
#define HDLC_Private_Address_Low_PAB1_MASK 0xFF00
#define HDLC_Private_Address_Low_PAB1_BIT 8

#define HDLC_Private_Address_Mask_High (*(volatile unsigned short *)0xC000E008)
#define HDLC_Private_Address_Mask_High_PAMB2_MASK 0xFF
#define HDLC_Private_Address_Mask_High_PAMB2_BIT 0
#define HDLC_Private_Address_Mask_High_PAMB3_MASK 0xFF00
#define HDLC_Private_Address_Mask_High_PAMB3_BIT 8

#define HDLC_Private_Address_Mask_Low (*(volatile unsigned short *)0xC000E00C)
#define HDLC_Private_Address_Mask_Low_PAMB0_MASK 0xFF
#define HDLC_Private_Address_Mask_Low_PAMB0_BIT 0
#define HDLC_Private_Address_Mask_Low_PAMB1_MASK 0xFF00
#define HDLC_Private_Address_Mask_Low_PAMB1_BIT 8

#define HDLC_Group_Address_1 (*(volatile unsigned short *)0xC000E010)
#define HDLC_Group_Address_1_GA2_MASK 0xFF
#define HDLC_Group_Address_1_GA2_BIT 0
#define HDLC_Group_Address_1_BA_MASK 0xFF00
#define HDLC_Group_Address_1_BA_BIT 8

#define HDLC_Group_Address_0 (*(volatile unsigned short *)0xC000E014)
#define HDLC_Group_Address_0_GA0_MASK 0xFF
#define HDLC_Group_Address_0_GA0_BIT 0
#define HDLC_Group_Address_0_GA1_MASK 0xFF00
#define HDLC_Group_Address_0_GA1_BIT 8

#define HDLC_Group_Address_Mask_1 (*(volatile unsigned short *)0xC000E018)
#define HDLC_Group_Address_Mask_1_GAM2_MASK 0xFF
#define HDLC_Group_Address_Mask_1_GAM2_BIT 0
#define HDLC_Group_Address_Mask_1_BAM_MASK 0xFF00
#define HDLC_Group_Address_Mask_1_BAM_BIT 8

#define HDLC_Group_Address_Mask_0 (*(volatile unsigned short *)0xC000E01C)
#define HDLC_Group_Address_Mask_0_GAM0_MASK 0xFF
#define HDLC_Group_Address_Mask_0_GAM0_BIT 0
#define HDLC_Group_Address_Mask_0_GAM1_MASK 0xFF00
#define HDLC_Group_Address_Mask_0_GAM1_BIT 8

#define HDLC_Preamble_Sequence (*(volatile unsigned short *)0xC000E020)

#define HDLC_Postamble_Sequence (*(volatile unsigned short *)0xC000E024)

#define HDLC_Transmission_Control (*(volatile unsigned short *)0xC000E028)
#define HDLC_Transmission_Control_NPOSB_MASK 0xF
#define HDLC_Transmission_Control_NPOSB_BIT 0
#define HDLC_Transmission_Control_NPREB_MASK 0xF0
#define HDLC_Transmission_Control_NPREB_BIT 4
#define HDLC_Transmission_Control_POSE_MASK 0x100
#define HDLC_Transmission_Control_POSE 0x100
#define HDLC_Transmission_Control_POSE_BIT 8
#define HDLC_Transmission_Control_PREE_MASK 0x200
#define HDLC_Transmission_Control_PREE 0x200
#define HDLC_Transmission_Control_PREE_BIT 9
#define HDLC_Transmission_Control_TCOD_MASK 0xC00
#define HDLC_Transmission_Control_TCOD_BIT 10
#define HDLC_Transmission_Control_TCRCI_MASK 0x1000
#define HDLC_Transmission_Control_TCRCI 0x1000
#define HDLC_Transmission_Control_TCRCI_BIT 12
#define HDLC_Transmission_Control_ITF_MASK 0x2000
#define HDLC_Transmission_Control_ITF 0x2000
#define HDLC_Transmission_Control_ITF_BIT 13
#define HDLC_Transmission_Control_SOC_MASK 0x8000
#define HDLC_Transmission_Control_SOC 0x8000
#define HDLC_Transmission_Control_SOC_BIT 15
#define HDLC_Transmission_Control_HTEN_MASK 0xF0000
#define HDLC_Transmission_Control_HTEN_BIT 16

#define HDLC_Receive_Control (*(volatile unsigned short *)0xC000E02C)
#define HDLC_Receive_Control_RCOD_MASK 0x3
#define HDLC_Receive_Control_RCOD_BIT 0
#define HDLC_Receive_Control_RCRCI_MASK 0x4
#define HDLC_Receive_Control_RCRCI 0x4
#define HDLC_Receive_Control_RCRCI_BIT 2
#define HDLC_Receive_Control_SIC_MASK 0x8
#define HDLC_Receive_Control_SIC 0x8
#define HDLC_Receive_Control_SIC_BIT 3
#define HDLC_Receive_Control_LBEN_MASK 0x10
#define HDLC_Receive_Control_LBEN 0x10
#define HDLC_Receive_Control_LBEN_BIT 4
#define HDLC_Receive_Control_AEN_MASK 0x20
#define HDLC_Receive_Control_AEN 0x20
#define HDLC_Receive_Control_AEN_BIT 5
#define HDLC_Receive_Control_GAOE_MASK 0x40
#define HDLC_Receive_Control_GAOE 0x40
#define HDLC_Receive_Control_GAOE_BIT 6
#define HDLC_Receive_Control_GA1E_MASK 0x80
#define HDLC_Receive_Control_GA1E 0x80
#define HDLC_Receive_Control_GA1E_BIT 7
#define HDLC_Receive_Control_GA2E_MASK 0x100
#define HDLC_Receive_Control_GA2E 0x100
#define HDLC_Receive_Control_GA2E_BIT 8
#define HDLC_Receive_Control_BAE_MASK 0x200
#define HDLC_Receive_Control_BAE 0x200
#define HDLC_Receive_Control_BAE_BIT 9
#define HDLC_Receive_Control_PAE_MASK 0x400
#define HDLC_Receive_Control_PAE 0x400
#define HDLC_Receive_Control_PAE_BIT 10
#define HDLC_Receive_Control_DPLLE_MASK 0x800
#define HDLC_Receive_Control_DPLLE 0x800
#define HDLC_Receive_Control_DPLLE_BIT 11
#define HDLC_Receive_Control_RCME_MASK 0x1000
#define HDLC_Receive_Control_RCME 0x1000
#define HDLC_Receive_Control_RCME_BIT 12

#define HDLC_Baud_Rate (*(volatile unsigned short *)0xC000E030)
#define HDLC_Baud_Rate_BRG_MASK 0xFFF
#define HDLC_Baud_Rate_BRG_BIT 0
#define HDLC_Baud_Rate_TCKS_MASK 0x1000
#define HDLC_Baud_Rate_TCKS 0x1000
#define HDLC_Baud_Rate_TCKS_BIT 12

#define HDLC_Prescaler_Register (*(volatile unsigned short *)0xC000E034)
#define HDLC_Prescaler_Register_PSR_MASK 0xFF
#define HDLC_Prescaler_Register_PSR_BIT 0
#define HDLC_Prescaler_Register_RCKS_MASK 0x300
#define HDLC_Prescaler_Register_RCKS_BIT 8

#define HDLC_Peripheral_Status (*(volatile unsigned short *)0xC000E038)
#define HDLC_Peripheral_Status_RLS_MASK 0x3
#define HDLC_Peripheral_Status_RLS_BIT 0
#define HDLC_Peripheral_Status_TBR_MASK 0x4
#define HDLC_Peripheral_Status_TBR 0x4
#define HDLC_Peripheral_Status_TBR_BIT 2
#define HDLC_Peripheral_Status_RBR_MASK 0x8
#define HDLC_Peripheral_Status_RBR 0x8
#define HDLC_Peripheral_Status_RBR_BIT 3

#define HDLC_Frame Status_Byte (*(volatile unsigned short *)0xC000E03C)
#define HDLC_Frame Status_Byte_RAB_MASK 0x1
#define HDLC_Frame Status_Byte_RAB 0x1
#define HDLC_Frame Status_Byte_RAB_BIT 0
#define HDLC_Frame Status_Byte_CRC_MASK 0x2
#define HDLC_Frame Status_Byte_CRC 0x2
#define HDLC_Frame Status_Byte_CRC_BIT 1
#define HDLC_Frame Status_Byte_RDO_MASK 0x4
#define HDLC_Frame Status_Byte_RDO 0x4
#define HDLC_Frame Status_Byte_RDO_BIT 2
#define HDLC_Frame Status_Byte_RBC_MASK 0x8
#define HDLC_Frame Status_Byte_RBC 0x8
#define HDLC_Frame Status_Byte_RBC_BIT 3

#define HDLC_Transmission_Frame_Byte_Count (*(volatile unsigned short *)0xC000E040)

#define HDLC_Receive_Frame_Byte_Count (*(volatile unsigned short *)0xC000E044)

#define HDLC_Peripheral_Command (*(volatile unsigned short *)0xC000E048)
#define HDLC_Peripheral_Command_REN_MASK 0x1
#define HDLC_Peripheral_Command_REN 0x1
#define HDLC_Peripheral_Command_REN_BIT 0
#define HDLC_Peripheral_Command_TEN_MASK 0x2
#define HDLC_Peripheral_Command_TEN 0x2
#define HDLC_Peripheral_Command_TEN_BIT 1

#define HDLC_Interrupt_Status (*(volatile unsigned short *)0xC000E04C)
#define HDLC_Interrupt_Status_RME_MASK 0x1
#define HDLC_Interrupt_Status_RME 0x1
#define HDLC_Interrupt_Status_RME_BIT 0
#define HDLC_Interrupt_Status_RMC_MASK 0x2
#define HDLC_Interrupt_Status_RMC 0x2
#define HDLC_Interrupt_Status_RMC_BIT 1
#define HDLC_Interrupt_Status_RFO_MASK 0x4
#define HDLC_Interrupt_Status_RFO 0x4
#define HDLC_Interrupt_Status_RFO_BIT 2
#define HDLC_Interrupt_Status_RBF_MASK 0x8
#define HDLC_Interrupt_Status_RBF 0x8
#define HDLC_Interrupt_Status_RBF_BIT 3
#define HDLC_Interrupt_Status_TBU_MASK 0x10
#define HDLC_Interrupt_Status_TBU 0x10
#define HDLC_Interrupt_Status_TBU_BIT 4
#define HDLC_Interrupt_Status_TBE_MASK 0x20
#define HDLC_Interrupt_Status_TBE 0x20
#define HDLC_Interrupt_Status_TBE_BIT 5
#define HDLC_Interrupt_Status_TMC_MASK 0x40
#define HDLC_Interrupt_Status_TMC 0x40
#define HDLC_Interrupt_Status_TMC_BIT 6

#define HDLC_Interrupt_Mask (*(volatile unsigned short *)0xC000E050)
#define HDLC_Interrupt_Mask_RMEM_MASK 0x1
#define HDLC_Interrupt_Mask_RMEM 0x1
#define HDLC_Interrupt_Mask_RMEM_BIT 0
#define HDLC_Interrupt_Mask_RMCM_MASK 0x2
#define HDLC_Interrupt_Mask_RMCM 0x2
#define HDLC_Interrupt_Mask_RMCM_BIT 1
#define HDLC_Interrupt_Mask_RFOM_MASK 0x4
#define HDLC_Interrupt_Mask_RFOM 0x4
#define HDLC_Interrupt_Mask_RFOM_BIT 2
#define HDLC_Interrupt_Mask_RBFM_MASK 0x8
#define HDLC_Interrupt_Mask_RBFM 0x8
#define HDLC_Interrupt_Mask_RBFM_BIT 3
#define HDLC_Interrupt_Mask_TBUM_MASK 0x10
#define HDLC_Interrupt_Mask_TBUM 0x10
#define HDLC_Interrupt_Mask_TBUM_BIT 4
#define HDLC_Interrupt_Mask_TBEM_MASK 0x20
#define HDLC_Interrupt_Mask_TBEM 0x20
#define HDLC_Interrupt_Mask_TBEM_BIT 5
#define HDLC_Interrupt_Mask_TMCM_MASK 0x40
#define HDLC_Interrupt_Mask_TMCM 0x40
#define HDLC_Interrupt_Mask_TMCM_BIT 6

#define APB2_BSR (*(volatile unsigned long *)0xE0000000)
#define APB2_BSR_ABORT_MASK 0x1
#define APB2_BSR_ABORT 0x1
#define APB2_BSR_ABORT_BIT 0
#define APB2_BSR_OUTM_MASK 0x10
#define APB2_BSR_OUTM 0x10
#define APB2_BSR_OUTM_BIT 4
#define APB2_BSR_APBT_MASK 0x60
#define APB2_BSR_APBT_BIT 5

#define APB2_TOR (*(volatile unsigned long *)0xE0000004)
#define APB2_TOR_TOUT_CNT_MASK 0x1F
#define APB2_TOR_TOUT_CNT_BIT 0
#define APB2_TOR_ABTEN_MASK 0x100
#define APB2_TOR_ABTEN 0x100
#define APB2_TOR_ABTEN_BIT 8

#define APB2_OMR (*(volatile unsigned long *)0xE0000008)
#define APB2_OMR_nRW_MASK 0x80
#define APB2_OMR_nRW 0x80
#define APB2_OMR_nRW_BIT 7
#define APB2_OMR_Peripheral_Address_MASK 0xFFFF00
#define APB2_OMR_Peripheral_Address_BIT 8

#define APB2_TOER (*(volatile unsigned long *)0xE000000C)
#define APB2_TOER_nRW_MASK 0x80
#define APB2_TOER_nRW 0x80
#define APB2_TOER_nRW_BIT 7
#define APB2_TOER_Peripheral_Address_MASK 0xFFFF00
#define APB2_TOER_Peripheral_Address_BIT 8

#define APB2_CKDIS (*(volatile unsigned long *)0xE0000010)

#define APB2_SWRES (*(volatile unsigned long *)0xE0000014)

#define WUSRL (*(volatile unsigned char *)0xE000101C)

#define WUCTRL (*(volatile unsigned char *)0xE0001024)
#define WUCTRL_WKUP_INT_MASK 0x1
#define WUCTRL_WKUP_INT 0x1
#define WUCTRL_WKUP_INT_BIT 0
#define WUCTRL_ID1S_MASK 0x2
#define WUCTRL_ID1S 0x2
#define WUCTRL_ID1S_BIT 1
#define WUCTRL_STOP_MASK 0x4
#define WUCTRL_STOP 0x4
#define WUCTRL_STOP_BIT 2

#define WUMRH (*(volatile unsigned char *)0xE0001028)

#define WUMRL (*(volatile unsigned char *)0xE000102C)

#define WUTRH (*(volatile unsigned char *)0xE0001030)

#define WUTRL (*(volatile unsigned char *)0xE0001034)

#define WUPRH (*(volatile unsigned char *)0xE0001038)

#define WUPRL (*(volatile unsigned char *)0xE000103C)

#define IOPORT0_PC0 (*(volatile unsigned short *)0xE0003000)

#define IOPORT0_PC1 (*(volatile unsigned short *)0xE0003004)

#define IOPORT0_PC2 (*(volatile unsigned short *)0xE0003008)

#define IOPORT0_PD (*(volatile unsigned short *)0xE000300C)

#define IOPORT1_PC0 (*(volatile unsigned short *)0xE0004000)

#define IOPORT1_PC1 (*(volatile unsigned short *)0xE0004004)

#define IOPORT1_PC2 (*(volatile unsigned short *)0xE0004008)

#define IOPORT1_PD (*(volatile unsigned short *)0xE000400C)

#define IOPORT2_PC0 (*(volatile unsigned short *)0xE0005000)

#define IOPORT2_PC1 (*(volatile unsigned short *)0xE0005004)

#define IOPORT2_PC2 (*(volatile unsigned short *)0xE0005008)

#define IOPORT2_PD (*(volatile unsigned short *)0xE000500C)

#define ADC_DATA0 (*(volatile unsigned short *)0xE0007000)
#define ADC_DATA0_OR_MASK 0xFFF0
#define ADC_DATA0_OR_BIT 4

#define ADC_DATA1 (*(volatile unsigned short *)0xE0007008)
#define ADC_DATA1_OR_MASK 0xFFF0
#define ADC_DATA1_OR_BIT 4

#define ADC_DATA2 (*(volatile unsigned short *)0xE0007010)
#define ADC_DATA2_OR_MASK 0xFFF0
#define ADC_DATA2_OR_BIT 4

#define ADC_DATA3 (*(volatile unsigned short *)0xE0007018)
#define ADC_DATA3_OR_MASK 0xFFF0
#define ADC_DATA3_OR_BIT 4

#define ADC_CSR (*(volatile unsigned short *)0xE0007020)
#define ADC_CSR_DA0_MASK 0x1
#define ADC_CSR_DA0 0x1
#define ADC_CSR_DA0_BIT 0
#define ADC_CSR_DA1_MASK 0x2
#define ADC_CSR_DA1 0x2
#define ADC_CSR_DA1_BIT 1
#define ADC_CSR_DA2_MASK 0x4
#define ADC_CSR_DA2 0x4
#define ADC_CSR_DA2_BIT 2
#define ADC_CSR_DA3_MASK 0x8
#define ADC_CSR_DA3 0x8
#define ADC_CSR_DA3_BIT 3
#define ADC_CSR_DA4_MASK 0x30
#define ADC_CSR_DA4_BIT 4
#define ADC_CSR_AXT_MASK 0x40
#define ADC_CSR_AXT 0x40
#define ADC_CSR_AXT_BIT 6
#define ADC_CSR_IE_MASK 0xF00
#define ADC_CSR_IE_BIT 8
#define ADC_CSR_OR_MASK 0x2000
#define ADC_CSR_OR 0x2000
#define ADC_CSR_OR_BIT 13

#define ADC_PRE (*(volatile unsigned short *)0xE0007030)

#define EFT0_ICAR (*(volatile unsigned short *)0xE0009000)

#define EFT0_ICBR (*(volatile unsigned short *)0xE0009004)

#define EFT0_OCAR (*(volatile unsigned short *)0xE0009008)

#define EFT0_OCBR (*(volatile unsigned short *)0xE000900C)

#define EFT0_CNTR (*(volatile unsigned short *)0xE0009010)

#define EFT0_CR1 (*(volatile unsigned short *)0xE0009014)
#define EFT0_CR1_ECKEN_MASK 0x1
#define EFT0_CR1_ECKEN 0x1
#define EFT0_CR1_ECKEN_BIT 0
#define EFT0_CR1_EXEDG_MASK 0x2
#define EFT0_CR1_EXEDG 0x2
#define EFT0_CR1_EXEDG_BIT 1
#define EFT0_CR1_IEDGA_MASK 0x4
#define EFT0_CR1_IEDGA 0x4
#define EFT0_CR1_IEDGA_BIT 2
#define EFT0_CR1_IEDGB_MASK 0x8
#define EFT0_CR1_IEDGB 0x8
#define EFT0_CR1_IEDGB_BIT 3
#define EFT0_CR1_PWM_MASK 0x10
#define EFT0_CR1_PWM 0x10
#define EFT0_CR1_PWM_BIT 4
#define EFT0_CR1_OPM_MASK 0x20
#define EFT0_CR1_OPM 0x20
#define EFT0_CR1_OPM_BIT 5
#define EFT0_CR1_OCAE_MASK 0x40
#define EFT0_CR1_OCAE 0x40
#define EFT0_CR1_OCAE_BIT 6
#define EFT0_CR1_OCBE_MASK 0x80
#define EFT0_CR1_OCBE 0x80
#define EFT0_CR1_OCBE_BIT 7
#define EFT0_CR1_OLVLA_MASK 0x100
#define EFT0_CR1_OLVLA 0x100
#define EFT0_CR1_OLVLA_BIT 8
#define EFT0_CR1_OLVLB_MASK 0x200
#define EFT0_CR1_OLVLB 0x200
#define EFT0_CR1_OLVLB_BIT 9
#define EFT0_CR1_FOLVLA_MASK 0x400
#define EFT0_CR1_FOLVLA 0x400
#define EFT0_CR1_FOLVLA_BIT 10
#define EFT0_CR1_FOLVLB_MASK 0x800
#define EFT0_CR1_FOLVLB 0x800
#define EFT0_CR1_FOLVLB_BIT 11
#define EFT0_CR1_PWMI_MASK 0x4000
#define EFT0_CR1_PWMI 0x4000
#define EFT0_CR1_PWMI_BIT 14
#define EFT0_CR1_EN_MASK 0x8000
#define EFT0_CR1_EN 0x8000
#define EFT0_CR1_EN_BIT 15

#define EFT0_CR2 (*(volatile unsigned short *)0xE0009018)
#define EFT0_CR2_CC0_MASK 0x1
#define EFT0_CR2_CC0 0x1
#define EFT0_CR2_CC0_BIT 0
#define EFT0_CR2_CC1_MASK 0x2
#define EFT0_CR2_CC1 0x2
#define EFT0_CR2_CC1_BIT 1
#define EFT0_CR2_CC2_MASK 0x4
#define EFT0_CR2_CC2 0x4
#define EFT0_CR2_CC2_BIT 2
#define EFT0_CR2_CC3_MASK 0x8
#define EFT0_CR2_CC3 0x8
#define EFT0_CR2_CC3_BIT 3
#define EFT0_CR2_CC4_MASK 0x10
#define EFT0_CR2_CC4 0x10
#define EFT0_CR2_CC4_BIT 4
#define EFT0_CR2_CC5_MASK 0x20
#define EFT0_CR2_CC5 0x20
#define EFT0_CR2_CC5_BIT 5
#define EFT0_CR2_CC6_MASK 0x40
#define EFT0_CR2_CC6 0x40
#define EFT0_CR2_CC6_BIT 6
#define EFT0_CR2_CC7_MASK 0x80
#define EFT0_CR2_CC7 0x80
#define EFT0_CR2_CC7_BIT 7
#define EFT0_CR2_OCBIE_MASK 0x800
#define EFT0_CR2_OCBIE 0x800
#define EFT0_CR2_OCBIE_BIT 11
#define EFT0_CR2_ICBIE_MASK 0x1000
#define EFT0_CR2_ICBIE 0x1000
#define EFT0_CR2_ICBIE_BIT 12
#define EFT0_CR2_TOE_MASK 0x2000
#define EFT0_CR2_TOE 0x2000
#define EFT0_CR2_TOE_BIT 13
#define EFT0_CR2_OCAIE_MASK 0x4000
#define EFT0_CR2_OCAIE 0x4000
#define EFT0_CR2_OCAIE_BIT 14
#define EFT0_CR2_ICAIE_MASK 0x8000
#define EFT0_CR2_ICAIE 0x8000
#define EFT0_CR2_ICAIE_BIT 15

#define EFT0_SR (*(volatile unsigned short *)0xE000901C)
#define EFT0_SR_OCFB_MASK 0x800
#define EFT0_SR_OCFB 0x800
#define EFT0_SR_OCFB_BIT 11
#define EFT0_SR_ICFB_MASK 0x1000
#define EFT0_SR_ICFB 0x1000
#define EFT0_SR_ICFB_BIT 12
#define EFT0_SR_TOF_MASK 0x2000
#define EFT0_SR_TOF 0x2000
#define EFT0_SR_TOF_BIT 13
#define EFT0_SR_OCFA_MASK 0x4000
#define EFT0_SR_OCFA 0x4000
#define EFT0_SR_OCFA_BIT 14
#define EFT0_SR_ICFA_MASK 0x8000
#define EFT0_SR_ICFA 0x8000
#define EFT0_SR_ICFA_BIT 15

#define EFT1_ICAR (*(volatile unsigned short *)0xE000A000)

#define EFT1_ICBR (*(volatile unsigned short *)0xE000A004)

#define EFT1_OCAR (*(volatile unsigned short *)0xE000A008)

#define EFT1_OCBR (*(volatile unsigned short *)0xE000A00C)

#define EFT1_CNTR (*(volatile unsigned short *)0xE000A010)

#define EFT1_CR1 (*(volatile unsigned short *)0xE000A014)
#define EFT1_CR1_ECKEN_MASK 0x1
#define EFT1_CR1_ECKEN 0x1
#define EFT1_CR1_ECKEN_BIT 0
#define EFT1_CR1_EXEDG_MASK 0x2
#define EFT1_CR1_EXEDG 0x2
#define EFT1_CR1_EXEDG_BIT 1
#define EFT1_CR1_IEDGA_MASK 0x4
#define EFT1_CR1_IEDGA 0x4
#define EFT1_CR1_IEDGA_BIT 2
#define EFT1_CR1_IEDGB_MASK 0x8
#define EFT1_CR1_IEDGB 0x8
#define EFT1_CR1_IEDGB_BIT 3
#define EFT1_CR1_PWM_MASK 0x10
#define EFT1_CR1_PWM 0x10
#define EFT1_CR1_PWM_BIT 4
#define EFT1_CR1_OPM_MASK 0x20
#define EFT1_CR1_OPM 0x20
#define EFT1_CR1_OPM_BIT 5
#define EFT1_CR1_OCAE_MASK 0x40
#define EFT1_CR1_OCAE 0x40
#define EFT1_CR1_OCAE_BIT 6
#define EFT1_CR1_OCBE_MASK 0x80
#define EFT1_CR1_OCBE 0x80
#define EFT1_CR1_OCBE_BIT 7
#define EFT1_CR1_OLVLA_MASK 0x100
#define EFT1_CR1_OLVLA 0x100
#define EFT1_CR1_OLVLA_BIT 8
#define EFT1_CR1_OLVLB_MASK 0x200
#define EFT1_CR1_OLVLB 0x200
#define EFT1_CR1_OLVLB_BIT 9
#define EFT1_CR1_FOLVLA_MASK 0x400
#define EFT1_CR1_FOLVLA 0x400
#define EFT1_CR1_FOLVLA_BIT 10
#define EFT1_CR1_FOLVLB_MASK 0x800
#define EFT1_CR1_FOLVLB 0x800
#define EFT1_CR1_FOLVLB_BIT 11
#define EFT1_CR1_PWMI_MASK 0x4000
#define EFT1_CR1_PWMI 0x4000
#define EFT1_CR1_PWMI_BIT 14
#define EFT1_CR1_EN_MASK 0x8000
#define EFT1_CR1_EN 0x8000
#define EFT1_CR1_EN_BIT 15

#define EFT1_CR2 (*(volatile unsigned short *)0xE000A018)
#define EFT1_CR2_CC0_MASK 0x1
#define EFT1_CR2_CC0 0x1
#define EFT1_CR2_CC0_BIT 0
#define EFT1_CR2_CC1_MASK 0x2
#define EFT1_CR2_CC1 0x2
#define EFT1_CR2_CC1_BIT 1
#define EFT1_CR2_CC2_MASK 0x4
#define EFT1_CR2_CC2 0x4
#define EFT1_CR2_CC2_BIT 2
#define EFT1_CR2_CC3_MASK 0x8
#define EFT1_CR2_CC3 0x8
#define EFT1_CR2_CC3_BIT 3
#define EFT1_CR2_CC4_MASK 0x10
#define EFT1_CR2_CC4 0x10
#define EFT1_CR2_CC4_BIT 4
#define EFT1_CR2_CC5_MASK 0x20
#define EFT1_CR2_CC5 0x20
#define EFT1_CR2_CC5_BIT 5
#define EFT1_CR2_CC6_MASK 0x40
#define EFT1_CR2_CC6 0x40
#define EFT1_CR2_CC6_BIT 6
#define EFT1_CR2_CC7_MASK 0x80
#define EFT1_CR2_CC7 0x80
#define EFT1_CR2_CC7_BIT 7
#define EFT1_CR2_OCBIE_MASK 0x800
#define EFT1_CR2_OCBIE 0x800
#define EFT1_CR2_OCBIE_BIT 11
#define EFT1_CR2_ICBIE_MASK 0x1000
#define EFT1_CR2_ICBIE 0x1000
#define EFT1_CR2_ICBIE_BIT 12
#define EFT1_CR2_TOE_MASK 0x2000
#define EFT1_CR2_TOE 0x2000
#define EFT1_CR2_TOE_BIT 13
#define EFT1_CR2_OCAIE_MASK 0x4000
#define EFT1_CR2_OCAIE 0x4000
#define EFT1_CR2_OCAIE_BIT 14
#define EFT1_CR2_ICAIE_MASK 0x8000
#define EFT1_CR2_ICAIE 0x8000
#define EFT1_CR2_ICAIE_BIT 15

#define EFT1_SR (*(volatile unsigned short *)0xE000A01C)
#define EFT1_SR_OCFB_MASK 0x800
#define EFT1_SR_OCFB 0x800
#define EFT1_SR_OCFB_BIT 11
#define EFT1_SR_ICFB_MASK 0x1000
#define EFT1_SR_ICFB 0x1000
#define EFT1_SR_ICFB_BIT 12
#define EFT1_SR_TOF_MASK 0x2000
#define EFT1_SR_TOF 0x2000
#define EFT1_SR_TOF_BIT 13
#define EFT1_SR_OCFA_MASK 0x4000
#define EFT1_SR_OCFA 0x4000
#define EFT1_SR_OCFA_BIT 14
#define EFT1_SR_ICFA_MASK 0x8000
#define EFT1_SR_ICFA 0x8000
#define EFT1_SR_ICFA_BIT 15

#define EFT2_ICAR (*(volatile unsigned short *)0xE000B000)

#define EFT2_ICBR (*(volatile unsigned short *)0xE000B004)

#define EFT2_OCAR (*(volatile unsigned short *)0xE000B008)

#define EFT2_OCBR (*(volatile unsigned short *)0xE000B00C)

#define EFT2_CNTR (*(volatile unsigned short *)0xE000B010)

#define EFT2_CR1 (*(volatile unsigned short *)0xE000B014)
#define EFT2_CR1_ECKEN_MASK 0x1
#define EFT2_CR1_ECKEN 0x1
#define EFT2_CR1_ECKEN_BIT 0
#define EFT2_CR1_EXEDG_MASK 0x2
#define EFT2_CR1_EXEDG 0x2
#define EFT2_CR1_EXEDG_BIT 1
#define EFT2_CR1_IEDGA_MASK 0x4
#define EFT2_CR1_IEDGA 0x4
#define EFT2_CR1_IEDGA_BIT 2
#define EFT2_CR1_IEDGB_MASK 0x8
#define EFT2_CR1_IEDGB 0x8
#define EFT2_CR1_IEDGB_BIT 3
#define EFT2_CR1_PWM_MASK 0x10
#define EFT2_CR1_PWM 0x10
#define EFT2_CR1_PWM_BIT 4
#define EFT2_CR1_OPM_MASK 0x20
#define EFT2_CR1_OPM 0x20
#define EFT2_CR1_OPM_BIT 5
#define EFT2_CR1_OCAE_MASK 0x40
#define EFT2_CR1_OCAE 0x40
#define EFT2_CR1_OCAE_BIT 6
#define EFT2_CR1_OCBE_MASK 0x80
#define EFT2_CR1_OCBE 0x80
#define EFT2_CR1_OCBE_BIT 7
#define EFT2_CR1_OLVLA_MASK 0x100
#define EFT2_CR1_OLVLA 0x100
#define EFT2_CR1_OLVLA_BIT 8
#define EFT2_CR1_OLVLB_MASK 0x200
#define EFT2_CR1_OLVLB 0x200
#define EFT2_CR1_OLVLB_BIT 9
#define EFT2_CR1_FOLVLA_MASK 0x400
#define EFT2_CR1_FOLVLA 0x400
#define EFT2_CR1_FOLVLA_BIT 10
#define EFT2_CR1_FOLVLB_MASK 0x800
#define EFT2_CR1_FOLVLB 0x800
#define EFT2_CR1_FOLVLB_BIT 11
#define EFT2_CR1_PWMI_MASK 0x4000
#define EFT2_CR1_PWMI 0x4000
#define EFT2_CR1_PWMI_BIT 14
#define EFT2_CR1_EN_MASK 0x8000
#define EFT2_CR1_EN 0x8000
#define EFT2_CR1_EN_BIT 15

#define EFT2_CR2 (*(volatile unsigned short *)0xE000B018)
#define EFT2_CR2_CC0_MASK 0x1
#define EFT2_CR2_CC0 0x1
#define EFT2_CR2_CC0_BIT 0
#define EFT2_CR2_CC1_MASK 0x2
#define EFT2_CR2_CC1 0x2
#define EFT2_CR2_CC1_BIT 1
#define EFT2_CR2_CC2_MASK 0x4
#define EFT2_CR2_CC2 0x4
#define EFT2_CR2_CC2_BIT 2
#define EFT2_CR2_CC3_MASK 0x8
#define EFT2_CR2_CC3 0x8
#define EFT2_CR2_CC3_BIT 3
#define EFT2_CR2_CC4_MASK 0x10
#define EFT2_CR2_CC4 0x10
#define EFT2_CR2_CC4_BIT 4
#define EFT2_CR2_CC5_MASK 0x20
#define EFT2_CR2_CC5 0x20
#define EFT2_CR2_CC5_BIT 5
#define EFT2_CR2_CC6_MASK 0x40
#define EFT2_CR2_CC6 0x40
#define EFT2_CR2_CC6_BIT 6
#define EFT2_CR2_CC7_MASK 0x80
#define EFT2_CR2_CC7 0x80
#define EFT2_CR2_CC7_BIT 7
#define EFT2_CR2_OCBIE_MASK 0x800
#define EFT2_CR2_OCBIE 0x800
#define EFT2_CR2_OCBIE_BIT 11
#define EFT2_CR2_ICBIE_MASK 0x1000
#define EFT2_CR2_ICBIE 0x1000
#define EFT2_CR2_ICBIE_BIT 12
#define EFT2_CR2_TOE_MASK 0x2000
#define EFT2_CR2_TOE 0x2000
#define EFT2_CR2_TOE_BIT 13
#define EFT2_CR2_OCAIE_MASK 0x4000
#define EFT2_CR2_OCAIE 0x4000
#define EFT2_CR2_OCAIE_BIT 14
#define EFT2_CR2_ICAIE_MASK 0x8000
#define EFT2_CR2_ICAIE 0x8000
#define EFT2_CR2_ICAIE_BIT 15

#define EFT2_SR (*(volatile unsigned short *)0xE000B01C)
#define EFT2_SR_OCFB_MASK 0x800
#define EFT2_SR_OCFB 0x800
#define EFT2_SR_OCFB_BIT 11
#define EFT2_SR_ICFB_MASK 0x1000
#define EFT2_SR_ICFB 0x1000
#define EFT2_SR_ICFB_BIT 12
#define EFT2_SR_TOF_MASK 0x2000
#define EFT2_SR_TOF 0x2000
#define EFT2_SR_TOF_BIT 13
#define EFT2_SR_OCFA_MASK 0x4000
#define EFT2_SR_OCFA 0x4000
#define EFT2_SR_OCFA_BIT 14
#define EFT2_SR_ICFA_MASK 0x8000
#define EFT2_SR_ICFA 0x8000
#define EFT2_SR_ICFA_BIT 15

#define EFT3_ICAR (*(volatile unsigned short *)0xE000C000)

#define EFT3_ICBR (*(volatile unsigned short *)0xE000C004)

#define EFT3_OCAR (*(volatile unsigned short *)0xE000C008)

#define EFT3_OCBR (*(volatile unsigned short *)0xE000C00C)

#define EFT3_CNTR (*(volatile unsigned short *)0xE000C010)

#define EFT3_CR1 (*(volatile unsigned short *)0xE000C014)
#define EFT3_CR1_ECKEN_MASK 0x1
#define EFT3_CR1_ECKEN 0x1
#define EFT3_CR1_ECKEN_BIT 0
#define EFT3_CR1_EXEDG_MASK 0x2
#define EFT3_CR1_EXEDG 0x2
#define EFT3_CR1_EXEDG_BIT 1
#define EFT3_CR1_IEDGA_MASK 0x4
#define EFT3_CR1_IEDGA 0x4
#define EFT3_CR1_IEDGA_BIT 2
#define EFT3_CR1_IEDGB_MASK 0x8
#define EFT3_CR1_IEDGB 0x8
#define EFT3_CR1_IEDGB_BIT 3
#define EFT3_CR1_PWM_MASK 0x10
#define EFT3_CR1_PWM 0x10
#define EFT3_CR1_PWM_BIT 4
#define EFT3_CR1_OPM_MASK 0x20
#define EFT3_CR1_OPM 0x20
#define EFT3_CR1_OPM_BIT 5
#define EFT3_CR1_OCAE_MASK 0x40
#define EFT3_CR1_OCAE 0x40
#define EFT3_CR1_OCAE_BIT 6
#define EFT3_CR1_OCBE_MASK 0x80
#define EFT3_CR1_OCBE 0x80
#define EFT3_CR1_OCBE_BIT 7
#define EFT3_CR1_OLVLA_MASK 0x100
#define EFT3_CR1_OLVLA 0x100
#define EFT3_CR1_OLVLA_BIT 8
#define EFT3_CR1_OLVLB_MASK 0x200
#define EFT3_CR1_OLVLB 0x200
#define EFT3_CR1_OLVLB_BIT 9
#define EFT3_CR1_FOLVLA_MASK 0x400
#define EFT3_CR1_FOLVLA 0x400
#define EFT3_CR1_FOLVLA_BIT 10
#define EFT3_CR1_FOLVLB_MASK 0x800
#define EFT3_CR1_FOLVLB 0x800
#define EFT3_CR1_FOLVLB_BIT 11
#define EFT3_CR1_PWMI_MASK 0x4000
#define EFT3_CR1_PWMI 0x4000
#define EFT3_CR1_PWMI_BIT 14
#define EFT3_CR1_EN_MASK 0x8000
#define EFT3_CR1_EN 0x8000
#define EFT3_CR1_EN_BIT 15

#define EFT3_CR2 (*(volatile unsigned short *)0xE000C018)
#define EFT3_CR2_CC0_MASK 0x1
#define EFT3_CR2_CC0 0x1
#define EFT3_CR2_CC0_BIT 0
#define EFT3_CR2_CC1_MASK 0x2
#define EFT3_CR2_CC1 0x2
#define EFT3_CR2_CC1_BIT 1
#define EFT3_CR2_CC2_MASK 0x4
#define EFT3_CR2_CC2 0x4
#define EFT3_CR2_CC2_BIT 2
#define EFT3_CR2_CC3_MASK 0x8
#define EFT3_CR2_CC3 0x8
#define EFT3_CR2_CC3_BIT 3
#define EFT3_CR2_CC4_MASK 0x10
#define EFT3_CR2_CC4 0x10
#define EFT3_CR2_CC4_BIT 4
#define EFT3_CR2_CC5_MASK 0x20
#define EFT3_CR2_CC5 0x20
#define EFT3_CR2_CC5_BIT 5
#define EFT3_CR2_CC6_MASK 0x40
#define EFT3_CR2_CC6 0x40
#define EFT3_CR2_CC6_BIT 6
#define EFT3_CR2_CC7_MASK 0x80
#define EFT3_CR2_CC7 0x80
#define EFT3_CR2_CC7_BIT 7
#define EFT3_CR2_OCBIE_MASK 0x800
#define EFT3_CR2_OCBIE 0x800
#define EFT3_CR2_OCBIE_BIT 11
#define EFT3_CR2_ICBIE_MASK 0x1000
#define EFT3_CR2_ICBIE 0x1000
#define EFT3_CR2_ICBIE_BIT 12
#define EFT3_CR2_TOE_MASK 0x2000
#define EFT3_CR2_TOE 0x2000
#define EFT3_CR2_TOE_BIT 13
#define EFT3_CR2_OCAIE_MASK 0x4000
#define EFT3_CR2_OCAIE 0x4000
#define EFT3_CR2_OCAIE_BIT 14
#define EFT3_CR2_ICAIE_MASK 0x8000
#define EFT3_CR2_ICAIE 0x8000
#define EFT3_CR2_ICAIE_BIT 15

#define EFT3_SR (*(volatile unsigned short *)0xE000C01C)
#define EFT3_SR_OCFB_MASK 0x800
#define EFT3_SR_OCFB 0x800
#define EFT3_SR_OCFB_BIT 11
#define EFT3_SR_ICFB_MASK 0x1000
#define EFT3_SR_ICFB 0x1000
#define EFT3_SR_ICFB_BIT 12
#define EFT3_SR_TOF_MASK 0x2000
#define EFT3_SR_TOF 0x2000
#define EFT3_SR_TOF_BIT 13
#define EFT3_SR_OCFA_MASK 0x4000
#define EFT3_SR_OCFA 0x4000
#define EFT3_SR_OCFA_BIT 14
#define EFT3_SR_ICFA_MASK 0x8000
#define EFT3_SR_ICFA 0x8000
#define EFT3_SR_ICFA_BIT 15

#define RTCCRH (*(volatile unsigned short *)0xE000D000)
#define RTCCRH_SEN_MASK 0x1
#define RTCCRH_SEN 0x1
#define RTCCRH_SEN_BIT 0
#define RTCCRH_AEN_MASK 0x2
#define RTCCRH_AEN 0x2
#define RTCCRH_AEN_BIT 1
#define RTCCRH_OWEN_MASK 0x4
#define RTCCRH_OWEN 0x4
#define RTCCRH_OWEN_BIT 2
#define RTCCRH_GEN_MASK 0x8
#define RTCCRH_GEN 0x8
#define RTCCRH_GEN_BIT 3

#define RTCCRL (*(volatile unsigned short *)0xE000D004)
#define RTCCRL_SIR_MASK 0x1
#define RTCCRL_SIR 0x1
#define RTCCRL_SIR_BIT 0
#define RTCCRL_AIR_MASK 0x2
#define RTCCRL_AIR 0x2
#define RTCCRL_AIR_BIT 1
#define RTCCRL_OWIR_MASK 0x4
#define RTCCRL_OWIR 0x4
#define RTCCRL_OWIR_BIT 2
#define RTCCRL_GIR_MASK 0x8
#define RTCCRL_GIR 0x8
#define RTCCRL_GIR_BIT 3
#define RTCCRL_CNF_MASK 0x10
#define RTCCRL_CNF 0x10
#define RTCCRL_CNF_BIT 4
#define RTCCRL_RTOFF_MASK 0x20
#define RTCCRL_RTOFF 0x20
#define RTCCRL_RTOFF_BIT 5

#define RTC_LHI (*(volatile unsigned short *)0xE000D008)

#define RTC_LLO (*(volatile unsigned short *)0xE000D00C)

#define RTC_DHI (*(volatile unsigned short *)0xE000D010)

#define RTC_DLO (*(volatile unsigned short *)0xE000D014)

#define RTCCNT_H (*(volatile unsigned short *)0xE000D018)

#define RTCCNT_L (*(volatile unsigned short *)0xE000D01C)

#define RTC_AHI (*(volatile unsigned short *)0xE000D020)

#define RTC_ALO (*(volatile unsigned short *)0xE000D024)

#define WDTCR (*(volatile unsigned short *)0xE000E000)
#define WDTCR_WE_MASK 0x1
#define WDTCR_WE 0x1
#define WDTCR_WE_BIT 0
#define WDTCR_SC_MASK 0x2
#define WDTCR_SC 0x2
#define WDTCR_SC_BIT 1
#define WDTCR_EE_MASK 0x4
#define WDTCR_EE 0x4
#define WDTCR_EE_BIT 2

#define WDTPR (*(volatile unsigned short *)0xE000E004)
#define WDTPR_PR_MASK 0xFF
#define WDTPR_PR_BIT 0

#define WDTVR (*(volatile unsigned short *)0xE000E008)

#define WDTCNT (*(volatile unsigned short *)0xE000E00C)

#define WDTSR (*(volatile unsigned short *)0xE000E010)

#define WDTMR (*(volatile unsigned short *)0xE000E014)

#define WDTKR (*(volatile unsigned short *)0xE000E018)

#define ICR (*(volatile unsigned long *)0xFFFFFC00)
#define ICR_IRQ_EN_MASK 0x1
#define ICR_IRQ_EN 0x1
#define ICR_IRQ_EN_BIT 0
#define ICR_FIQ_EN_MASK 0x2
#define ICR_FIQ_EN 0x2
#define ICR_FIQ_EN_BIT 1

#define CICR (*(volatile unsigned long *)0xFFFFFC04)

#define CIPR (*(volatile unsigned long *)0xFFFFFC08)

#define IVR (*(volatile unsigned long *)0xFFFFFC18)
#define IVR_Jump_Offset_MASK 0xFFFF
#define IVR_Jump_Offset_BIT 0
#define IVR_Jump_Opcode_Or_Base_Address_MASK 0xFFFF0000
#define IVR_Jump_Opcode_Or_Base_Address_BIT 16

#define FIR (*(volatile unsigned long *)0xFFFFFC1C)

#define IER0 (*(volatile unsigned long *)0xFFFFFC20)

#define IPR0 (*(volatile unsigned long *)0xFFFFFC40)

#define SIR0 (*(volatile unsigned long *)0xFFFFFC60)
#define SIR0_SIPL0_MASK 0xF
#define SIR0_SIPL0_BIT 0
#define SIR0_SIV0_MASK 0xFFFF0000
#define SIR0_SIV0_BIT 16

#define SIR1 (*(volatile unsigned long *)0xFFFFFC64)
#define SIR1_SIPL1_MASK 0xF
#define SIR1_SIPL1_BIT 0
#define SIR1_SIV1_MASK 0xFFFF0000
#define SIR1_SIV1_BIT 16

#define SIR2 (*(volatile unsigned long *)0xFFFFFC68)
#define SIR2_SIPL2_MASK 0xF
#define SIR2_SIPL2_BIT 0
#define SIR2_SIV2_MASK 0xFFFF0000
#define SIR2_SIV2_BIT 16

#define SIR3 (*(volatile unsigned long *)0xFFFFFC6C)
#define SIR3_SIPL3_MASK 0xF
#define SIR3_SIPL3_BIT 0
#define SIR3_SIV3_MASK 0xFFFF0000
#define SIR3_SIV3_BIT 16

#define SIR4 (*(volatile unsigned long *)0xFFFFFC70)
#define SIR4_SIPL4_MASK 0xF
#define SIR4_SIPL4_BIT 0
#define SIR4_SIV4_MASK 0xFFFF0000
#define SIR4_SIV4_BIT 16

#define SIR5 (*(volatile unsigned long *)0xFFFFFC74)
#define SIR5_SIPL5_MASK 0xF
#define SIR5_SIPL5_BIT 0
#define SIR5_SIV5_MASK 0xFFFF0000
#define SIR5_SIV5_BIT 16

#define SIR6 (*(volatile unsigned long *)0xFFFFFC78)
#define SIR6_SIPL6_MASK 0xF
#define SIR6_SIPL6_BIT 0
#define SIR6_SIV6_MASK 0xFFFF0000
#define SIR6_SIV6_BIT 16

#define SIR7 (*(volatile unsigned long *)0xFFFFFC7C)
#define SIR7_SIPL7_MASK 0xF
#define SIR7_SIPL7_BIT 0
#define SIR7_SIV7_MASK 0xFFFF0000
#define SIR7_SIV7_BIT 16

#define SIR8 (*(volatile unsigned long *)0xFFFFFC80)
#define SIR8_SIPL8_MASK 0xF
#define SIR8_SIPL8_BIT 0
#define SIR8_SIV8_MASK 0xFFFF0000
#define SIR8_SIV8_BIT 16

#define SIR9 (*(volatile unsigned long *)0xFFFFFC84)
#define SIR9_SIPL9_MASK 0xF
#define SIR9_SIPL9_BIT 0
#define SIR9_SIV9_MASK 0xFFFF0000
#define SIR9_SIV9_BIT 16

#define SIR10 (*(volatile unsigned long *)0xFFFFFC88)
#define SIR10_SIPL10_MASK 0xF
#define SIR10_SIPL10_BIT 0
#define SIR10_SIV10_MASK 0xFFFF0000
#define SIR10_SIV10_BIT 16

#define SIR11 (*(volatile unsigned long *)0xFFFFFC8C)
#define SIR11_SIPL11_MASK 0xF
#define SIR11_SIPL11_BIT 0
#define SIR11_SIV11_MASK 0xFFFF0000
#define SIR11_SIV11_BIT 16

#define SIR12 (*(volatile unsigned long *)0xFFFFFC90)
#define SIR12_SIPL12_MASK 0xF
#define SIR12_SIPL12_BIT 0
#define SIR12_SIV12_MASK 0xFFFF0000
#define SIR12_SIV12_BIT 16

#define SIR13 (*(volatile unsigned long *)0xFFFFFC94)
#define SIR13_SIPL13_MASK 0xF
#define SIR13_SIPL13_BIT 0
#define SIR13_SIV13_MASK 0xFFFF0000
#define SIR13_SIV13_BIT 16

#define SIR14 (*(volatile unsigned long *)0xFFFFFC98)
#define SIR14_SIPL14_MASK 0xF
#define SIR14_SIPL14_BIT 0
#define SIR14_SIV14_MASK 0xFFFF0000
#define SIR14_SIV14_BIT 16

#define SIR15 (*(volatile unsigned long *)0xFFFFFC9C)
#define SIR15_SIPL15_MASK 0xF
#define SIR15_SIPL15_BIT 0
#define SIR15_SIV15_MASK 0xFFFF0000
#define SIR15_SIV15_BIT 16

#define SIR16 (*(volatile unsigned long *)0xFFFFFCA0)
#define SIR16_SIPL16_MASK 0xF
#define SIR16_SIPL16_BIT 0
#define SIR16_SIV16_MASK 0xFFFF0000
#define SIR16_SIV16_BIT 16

#define SIR17 (*(volatile unsigned long *)0xFFFFFCA4)
#define SIR17_SIPL17_MASK 0xF
#define SIR17_SIPL17_BIT 0
#define SIR17_SIV17_MASK 0xFFFF0000
#define SIR17_SIV17_BIT 16

#define SIR18 (*(volatile unsigned long *)0xFFFFFCA8)
#define SIR18_SIPL18_MASK 0xF
#define SIR18_SIPL18_BIT 0
#define SIR18_SIV18_MASK 0xFFFF0000
#define SIR18_SIV18_BIT 16

#define SIR19 (*(volatile unsigned long *)0xFFFFFCAC)
#define SIR19_SIPL19_MASK 0xF
#define SIR19_SIPL19_BIT 0
#define SIR19_SIV19_MASK 0xFFFF0000
#define SIR19_SIV19_BIT 16

#define SIR20 (*(volatile unsigned long *)0xFFFFFCB0)
#define SIR20_SIPL20_MASK 0xF
#define SIR20_SIPL20_BIT 0
#define SIR20_SIV20_MASK 0xFFFF0000
#define SIR20_SIV20_BIT 16

#define SIR21 (*(volatile unsigned long *)0xFFFFFCB4)
#define SIR21_SIPL21_MASK 0xF
#define SIR21_SIPL21_BIT 0
#define SIR21_SIV21_MASK 0xFFFF0000
#define SIR21_SIV21_BIT 16

#define SIR22 (*(volatile unsigned long *)0xFFFFFCB8)
#define SIR22_SIPL22_MASK 0xF
#define SIR22_SIPL22_BIT 0
#define SIR22_SIV22_MASK 0xFFFF0000
#define SIR22_SIV22_BIT 16

#define SIR23 (*(volatile unsigned long *)0xFFFFFCBC)
#define SIR23_SIPL23_MASK 0xF
#define SIR23_SIPL23_BIT 0
#define SIR23_SIV23_MASK 0xFFFF0000
#define SIR23_SIV23_BIT 16

#define SIR24 (*(volatile unsigned long *)0xFFFFFCC0)
#define SIR24_SIPL24_MASK 0xF
#define SIR24_SIPL24_BIT 0
#define SIR24_SIV24_MASK 0xFFFF0000
#define SIR24_SIV24_BIT 16

#define SIR25 (*(volatile unsigned long *)0xFFFFFCC4)
#define SIR25_SIPL25_MASK 0xF
#define SIR25_SIPL25_BIT 0
#define SIR25_SIV25_MASK 0xFFFF0000
#define SIR25_SIV25_BIT 16

#define SIR26 (*(volatile unsigned long *)0xFFFFFCC8)
#define SIR26_SIPL26_MASK 0xF
#define SIR26_SIPL26_BIT 0
#define SIR26_SIV26_MASK 0xFFFF0000
#define SIR26_SIV26_BIT 16

#define SIR27 (*(volatile unsigned long *)0xFFFFFCCC)
#define SIR27_SIPL27_MASK 0xF
#define SIR27_SIPL27_BIT 0
#define SIR27_SIV27_MASK 0xFFFF0000
#define SIR27_SIV27_BIT 16

#define SIR28 (*(volatile unsigned long *)0xFFFFFCD0)
#define SIR28_SIPL28_MASK 0xF
#define SIR28_SIPL28_BIT 0
#define SIR28_SIV28_MASK 0xFFFF0000
#define SIR28_SIV28_BIT 16

#define SIR29 (*(volatile unsigned long *)0xFFFFFCD4)
#define SIR29_SIPL29_MASK 0xF
#define SIR29_SIPL29_BIT 0
#define SIR29_SIV29_MASK 0xFFFF0000
#define SIR29_SIV29_BIT 16

#define SIR30 (*(volatile unsigned long *)0xFFFFFCD8)
#define SIR30_SIPL30_MASK 0xF
#define SIR30_SIPL30_BIT 0
#define SIR30_SIV30_MASK 0xFFFF0000
#define SIR30_SIV30_BIT 16

#define SIR31 (*(volatile unsigned long *)0xFFFFFCDC)
#define SIR31_SIPL31_MASK 0xF
#define SIR31_SIPL31_BIT 0
#define SIR31_SIV31_MASK 0xFFFF0000
#define SIR31_SIV31_BIT 16


#endif
