// S3C4510B register and bit definitions.
//
// Copyright (c) 2005 Rowley Associates Limited.
//
// This file may be distributed under the terms of the License Agreement
// provided with this software.
//
// THIS FILE IS PROVIDED AS IS WITH NO WARRANTY OF ANY KIND, INCLUDING THE
// WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.

#ifndef S3C4510B_h
#define S3C4510B_h

#define SYSCFG (*(volatile unsigned *)0x3FF0000)
#define SYSCFG_SE_MASK 0x1U
#define SYSCFG_SE 0x1U
#define SYSCFG_SE_BIT 0
#define SYSCFG_CE_MASK 0x2U
#define SYSCFG_CE 0x2U
#define SYSCFG_CE_BIT 1
#define SYSCFG_WE_MASK 0x4U
#define SYSCFG_WE 0x4U
#define SYSCFG_WE_BIT 2
#define SYSCFG_CM_MASK 0x30U
#define SYSCFG_CM_BIT 4
#define SYSCFG_Internal_SRAM_Base_Pointer_MASK 0xFFC0U
#define SYSCFG_Internal_SRAM_Base_Pointer_BIT 6
#define SYSCFG_Special_Register_Bank_Base_Pointer_MASK 0xFFFF0000U
#define SYSCFG_Special_Register_Bank_Base_Pointer_BIT 16
#define SYSCFG__MASK 0xFC000000U
#define SYSCFG__BIT 26

#define CLKCON (*(volatile unsigned *)0x3FF3000)
#define CLKCON_Clock_dividing_value_MASK 0xFFFFU
#define CLKCON_Clock_dividing_value_BIT 0
#define CLKCON_ROM_bank_5_wait_enable_MASK 0x10000U
#define CLKCON_ROM_bank_5_wait_enable 0x10000U
#define CLKCON_ROM_bank_5_wait_enable_BIT 16
#define CLKCON_ROM_bank_5_address_data_MUX_enable_MASK 0x20000U
#define CLKCON_ROM_bank_5_address_data_MUX_enable 0x20000U
#define CLKCON_ROM_bank_5_address_data_MUX_enable_BIT 17
#define CLKCON_tAC_MASK 0xC0000U
#define CLKCON_tAC_BIT 18
#define CLKCON_Test_bit_MASK 0x80000000U
#define CLKCON_Test_bit 0x80000000U
#define CLKCON_Test_bit_BIT 31

#define EXTACON0 (*(volatile unsigned *)0x3FF3008)
#define EXTACON0_tCOS0_MASK 0x7U
#define EXTACON0_tCOS0_BIT 0
#define EXTACON0_tACS0_MASK 0x38U
#define EXTACON0_tACS0_BIT 3
#define EXTACON0_tCOH0_MASK 0x1C0U
#define EXTACON0_tCOH0_BIT 6
#define EXTACON0_tACC0_MASK 0xE00U
#define EXTACON0_tACC0_BIT 9
#define EXTACON0_tCOS1_MASK 0x70000U
#define EXTACON0_tCOS1_BIT 16
#define EXTACON0_tACS1_MASK 0x380000U
#define EXTACON0_tACS1_BIT 19
#define EXTACON0_tCOH1_MASK 0x1C00000U
#define EXTACON0_tCOH1_BIT 22
#define EXTACON0_tACC1_MASK 0xE000000U
#define EXTACON0_tACC1_BIT 25

#define EXTACON1 (*(volatile unsigned *)0x3FF300C)
#define EXTACON1_tCOS2_MASK 0x7U
#define EXTACON1_tCOS2_BIT 0
#define EXTACON1_tACS2_MASK 0x38U
#define EXTACON1_tACS2_BIT 3
#define EXTACON1_tCOH2_MASK 0x1C0U
#define EXTACON1_tCOH2_BIT 6
#define EXTACON1_tACC2_MASK 0xE00U
#define EXTACON1_tACC2_BIT 9
#define EXTACON1_tCOS3_MASK 0x70000U
#define EXTACON1_tCOS3_BIT 16
#define EXTACON1_tACS3_MASK 0x380000U
#define EXTACON1_tACS3_BIT 19
#define EXTACON1_tCOH3_MASK 0x1C00000U
#define EXTACON1_tCOH3_BIT 22
#define EXTACON1_tACC3_MASK 0xE000000U
#define EXTACON1_tACC3_BIT 25

#define EXTDBWTH (*(volatile unsigned *)0x3FF3010)
#define EXTDBWTH_DSR0_MASK 0x3U
#define EXTDBWTH_DSR0_BIT 0
#define EXTDBWTH_DSR1_MASK 0xCU
#define EXTDBWTH_DSR1_BIT 2
#define EXTDBWTH_DSR2_MASK 0x30U
#define EXTDBWTH_DSR2_BIT 4
#define EXTDBWTH_DSR3_MASK 0xC0U
#define EXTDBWTH_DSR3_BIT 6
#define EXTDBWTH_DSR4_MASK 0x300U
#define EXTDBWTH_DSR4_BIT 8
#define EXTDBWTH_DSR5_MASK 0xC00U
#define EXTDBWTH_DSR5_BIT 10
#define EXTDBWTH_DSD0_MASK 0x3000U
#define EXTDBWTH_DSD0_BIT 12
#define EXTDBWTH_DSD1_MASK 0xC000U
#define EXTDBWTH_DSD1_BIT 14
#define EXTDBWTH_DSD2_MASK 0x30000U
#define EXTDBWTH_DSD2_BIT 16
#define EXTDBWTH_DSD3_MASK 0xC0000U
#define EXTDBWTH_DSD3_BIT 18
#define EXTDBWTH_DSX0_MASK 0x300000U
#define EXTDBWTH_DSX0_BIT 20
#define EXTDBWTH_DSX1_MASK 0xC00000U
#define EXTDBWTH_DSX1_BIT 22
#define EXTDBWTH_DSX2_MASK 0x3000000U
#define EXTDBWTH_DSX2_BIT 24
#define EXTDBWTH_DSX3_MASK 0xC000000U
#define EXTDBWTH_DSX3_BIT 26

#define ROMCON0 (*(volatile unsigned *)0x3FF3014)
#define ROMCON0_PMC_MASK 0x3U
#define ROMCON0_PMC_BIT 0
#define ROMCON0_tPA_MASK 0xCU
#define ROMCON0_tPA_BIT 2
#define ROMCON0_tACC_MASK 0x70U
#define ROMCON0_tACC_BIT 4
#define ROMCON0_ROM_SRAM_Flash_bank_base_pointer_MASK 0xFFC00U
#define ROMCON0_ROM_SRAM_Flash_bank_base_pointer_BIT 10
#define ROMCON0_ROM_SRAM_Flash_bank_next_pointer_MASK 0x3FF00000U
#define ROMCON0_ROM_SRAM_Flash_bank_next_pointer_BIT 20

#define ROMCON1 (*(volatile unsigned *)0x3FF3018)
#define ROMCON1_PMC_MASK 0x3U
#define ROMCON1_PMC_BIT 0
#define ROMCON1_tPA_MASK 0xCU
#define ROMCON1_tPA_BIT 2
#define ROMCON1_tACC_MASK 0x70U
#define ROMCON1_tACC_BIT 4
#define ROMCON1_ROM_SRAM_Flash_bank_base_pointer_MASK 0xFFC00U
#define ROMCON1_ROM_SRAM_Flash_bank_base_pointer_BIT 10
#define ROMCON1_ROM_SRAM_Flash_bank_next_pointer_MASK 0x3FF00000U
#define ROMCON1_ROM_SRAM_Flash_bank_next_pointer_BIT 20

#define ROMCON2 (*(volatile unsigned *)0x3FF301C)
#define ROMCON2_PMC_MASK 0x3U
#define ROMCON2_PMC_BIT 0
#define ROMCON2_tPA_MASK 0xCU
#define ROMCON2_tPA_BIT 2
#define ROMCON2_tACC_MASK 0x70U
#define ROMCON2_tACC_BIT 4
#define ROMCON2_ROM_SRAM_Flash_bank_base_pointer_MASK 0xFFC00U
#define ROMCON2_ROM_SRAM_Flash_bank_base_pointer_BIT 10
#define ROMCON2_ROM_SRAM_Flash_bank_next_pointer_MASK 0x3FF00000U
#define ROMCON2_ROM_SRAM_Flash_bank_next_pointer_BIT 20

#define ROMCON3 (*(volatile unsigned *)0x3FF3020)
#define ROMCON3_PMC_MASK 0x3U
#define ROMCON3_PMC_BIT 0
#define ROMCON3_tPA_MASK 0xCU
#define ROMCON3_tPA_BIT 2
#define ROMCON3_tACC_MASK 0x70U
#define ROMCON3_tACC_BIT 4
#define ROMCON3_ROM_SRAM_Flash_bank_base_pointer_MASK 0xFFC00U
#define ROMCON3_ROM_SRAM_Flash_bank_base_pointer_BIT 10
#define ROMCON3_ROM_SRAM_Flash_bank_next_pointer_MASK 0x3FF00000U
#define ROMCON3_ROM_SRAM_Flash_bank_next_pointer_BIT 20

#define ROMCON4 (*(volatile unsigned *)0x3FF3024)
#define ROMCON4_PMC_MASK 0x3U
#define ROMCON4_PMC_BIT 0
#define ROMCON4_tPA_MASK 0xCU
#define ROMCON4_tPA_BIT 2
#define ROMCON4_tACC_MASK 0x70U
#define ROMCON4_tACC_BIT 4
#define ROMCON4_ROM_SRAM_Flash_bank_base_pointer_MASK 0xFFC00U
#define ROMCON4_ROM_SRAM_Flash_bank_base_pointer_BIT 10
#define ROMCON4_ROM_SRAM_Flash_bank_next_pointer_MASK 0x3FF00000U
#define ROMCON4_ROM_SRAM_Flash_bank_next_pointer_BIT 20

#define ROMCON5 (*(volatile unsigned *)0x3FF3028)
#define ROMCON5_PMC_MASK 0x3U
#define ROMCON5_PMC_BIT 0
#define ROMCON5_tPA_MASK 0xCU
#define ROMCON5_tPA_BIT 2
#define ROMCON5_tACC_MASK 0x70U
#define ROMCON5_tACC_BIT 4
#define ROMCON5_ROM_SRAM_Flash_bank_base_pointer_MASK 0xFFC00U
#define ROMCON5_ROM_SRAM_Flash_bank_base_pointer_BIT 10
#define ROMCON5_ROM_SRAM_Flash_bank_next_pointer_MASK 0x3FF00000U
#define ROMCON5_ROM_SRAM_Flash_bank_next_pointer_BIT 20

#define DRAMCON0 (*(volatile unsigned *)0x3FF302C)
#define DRAMCON0_EDO_MASK 0x1U
#define DRAMCON0_EDO 0x1U
#define DRAMCON0_EDO_BIT 0
#define DRAMCON0_tCS_MASK 0x6U
#define DRAMCON0_tCS_BIT 1
#define DRAMCON0_tCP_MASK 0x8U
#define DRAMCON0_tCP 0x8U
#define DRAMCON0_tCP_BIT 3
#define DRAMCON0_tRC_MASK 0x80U
#define DRAMCON0_tRC 0x80U
#define DRAMCON0_tRC_BIT 7
#define DRAMCON0_tRP_MASK 0x300U
#define DRAMCON0_tRP_BIT 8
#define DRAMCON0_DRAM_bank_base_pointer_MASK 0xFFC00U
#define DRAMCON0_DRAM_bank_base_pointer_BIT 10
#define DRAMCON0_DRAM_bank_next_pointer_MASK 0x3FF00000U
#define DRAMCON0_DRAM_bank_next_pointer_BIT 20
#define DRAMCON0_CAN_MASK 0xC0000000U
#define DRAMCON0_CAN_BIT 30

#define DRAMCON1 (*(volatile unsigned *)0x3FF3030)
#define DRAMCON1_EDO_MASK 0x1U
#define DRAMCON1_EDO 0x1U
#define DRAMCON1_EDO_BIT 0
#define DRAMCON1_tCS_MASK 0x6U
#define DRAMCON1_tCS_BIT 1
#define DRAMCON1_tCP_MASK 0x8U
#define DRAMCON1_tCP 0x8U
#define DRAMCON1_tCP_BIT 3
#define DRAMCON1_tRC_MASK 0x80U
#define DRAMCON1_tRC 0x80U
#define DRAMCON1_tRC_BIT 7
#define DRAMCON1_tRP_MASK 0x300U
#define DRAMCON1_tRP_BIT 8
#define DRAMCON1_DRAM_bank_base_pointer_MASK 0xFFC00U
#define DRAMCON1_DRAM_bank_base_pointer_BIT 10
#define DRAMCON1_DRAM_bank_next_pointer_MASK 0x3FF00000U
#define DRAMCON1_DRAM_bank_next_pointer_BIT 20
#define DRAMCON1_CAN_MASK 0xC0000000U
#define DRAMCON1_CAN_BIT 30

#define DRAMCON2 (*(volatile unsigned *)0x3FF3034)
#define DRAMCON2_EDO_MASK 0x1U
#define DRAMCON2_EDO 0x1U
#define DRAMCON2_EDO_BIT 0
#define DRAMCON2_tCS_MASK 0x6U
#define DRAMCON2_tCS_BIT 1
#define DRAMCON2_tCP_MASK 0x8U
#define DRAMCON2_tCP 0x8U
#define DRAMCON2_tCP_BIT 3
#define DRAMCON2_tRC_MASK 0x80U
#define DRAMCON2_tRC 0x80U
#define DRAMCON2_tRC_BIT 7
#define DRAMCON2_tRP_MASK 0x300U
#define DRAMCON2_tRP_BIT 8
#define DRAMCON2_DRAM_bank_base_pointer_MASK 0xFFC00U
#define DRAMCON2_DRAM_bank_base_pointer_BIT 10
#define DRAMCON2_DRAM_bank_next_pointer_MASK 0x3FF00000U
#define DRAMCON2_DRAM_bank_next_pointer_BIT 20
#define DRAMCON2_CAN_MASK 0xC0000000U
#define DRAMCON2_CAN_BIT 30

#define DRAMCON3 (*(volatile unsigned *)0x3FF3038)
#define DRAMCON3_EDO_MASK 0x1U
#define DRAMCON3_EDO 0x1U
#define DRAMCON3_EDO_BIT 0
#define DRAMCON3_tCS_MASK 0x6U
#define DRAMCON3_tCS_BIT 1
#define DRAMCON3_tCP_MASK 0x8U
#define DRAMCON3_tCP 0x8U
#define DRAMCON3_tCP_BIT 3
#define DRAMCON3_tRC_MASK 0x80U
#define DRAMCON3_tRC 0x80U
#define DRAMCON3_tRC_BIT 7
#define DRAMCON3_tRP_MASK 0x300U
#define DRAMCON3_tRP_BIT 8
#define DRAMCON3_DRAM_bank_base_pointer_MASK 0xFFC00U
#define DRAMCON3_DRAM_bank_base_pointer_BIT 10
#define DRAMCON3_DRAM_bank_next_pointer_MASK 0x3FF00000U
#define DRAMCON3_DRAM_bank_next_pointer_BIT 20
#define DRAMCON3_CAN_MASK 0xC0000000U
#define DRAMCON3_CAN_BIT 30

#define REFEXTCON (*(volatile unsigned *)0x3FF303C)
#define REFEXTCON_External_I_O_bank_0_base_pointer_MASK 0x3FFU
#define REFEXTCON_External_I_O_bank_0_base_pointer_BIT 0
#define REFEXTCON_VSF_MASK 0x8000U
#define REFEXTCON_VSF 0x8000U
#define REFEXTCON_VSF_BIT 15
#define REFEXTCON_REN_MASK 0x10000U
#define REFEXTCON_REN 0x10000U
#define REFEXTCON_REN_BIT 16
#define REFEXTCON_tCHR_MASK 0xE0000U
#define REFEXTCON_tCHR_BIT 17
#define REFEXTCON_tCSR_MASK 0x100000U
#define REFEXTCON_tCSR 0x100000U
#define REFEXTCON_tCSR_BIT 20
#define REFEXTCON_duration_MASK 0xFFE00000U
#define REFEXTCON_duration_BIT 21

#define INTMOD (*(volatile unsigned *)0x3FF4000)
#define INTMOD_External_interrupt_0_MASK 0x1U
#define INTMOD_External_interrupt_0 0x1U
#define INTMOD_External_interrupt_0_BIT 0
#define INTMOD_External_interrupt_1_MASK 0x2U
#define INTMOD_External_interrupt_1 0x2U
#define INTMOD_External_interrupt_1_BIT 1
#define INTMOD_External_interrupt_2_MASK 0x4U
#define INTMOD_External_interrupt_2 0x4U
#define INTMOD_External_interrupt_2_BIT 2
#define INTMOD_External_interrupt_3_MASK 0x8U
#define INTMOD_External_interrupt_3 0x8U
#define INTMOD_External_interrupt_3_BIT 3
#define INTMOD_UART0_transmit_interrupt_MASK 0x10U
#define INTMOD_UART0_transmit_interrupt 0x10U
#define INTMOD_UART0_transmit_interrupt_BIT 4
#define INTMOD_UART0_receive_and_error_interrupt_MASK 0x20U
#define INTMOD_UART0_receive_and_error_interrupt 0x20U
#define INTMOD_UART0_receive_and_error_interrupt_BIT 5
#define INTMOD_UART1_transmit_interrupt_MASK 0x40U
#define INTMOD_UART1_transmit_interrupt 0x40U
#define INTMOD_UART1_transmit_interrupt_BIT 6
#define INTMOD_UART1_receive_and_error_interrupt_MASK 0x80U
#define INTMOD_UART1_receive_and_error_interrupt 0x80U
#define INTMOD_UART1_receive_and_error_interrupt_BIT 7
#define INTMOD_GDMA_channel_0_interrupt_MASK 0x100U
#define INTMOD_GDMA_channel_0_interrupt 0x100U
#define INTMOD_GDMA_channel_0_interrupt_BIT 8
#define INTMOD_GDMA_channel_1_interrupt_MASK 0x200U
#define INTMOD_GDMA_channel_1_interrupt 0x200U
#define INTMOD_GDMA_channel_1_interrupt_BIT 9
#define INTMOD_Timer_0_interrupt_MASK 0x400U
#define INTMOD_Timer_0_interrupt 0x400U
#define INTMOD_Timer_0_interrupt_BIT 10
#define INTMOD_Timer_0_interrupt_MASK 0x800U
#define INTMOD_Timer_0_interrupt 0x800U
#define INTMOD_Timer_0_interrupt_BIT 11
#define INTMOD_HDLC_channel_A_Tx_interrupt_MASK 0x1000U
#define INTMOD_HDLC_channel_A_Tx_interrupt 0x1000U
#define INTMOD_HDLC_channel_A_Tx_interrupt_BIT 12
#define INTMOD_HDLC_channel_A_Rx_interrupt_MASK 0x2000U
#define INTMOD_HDLC_channel_A_Rx_interrupt 0x2000U
#define INTMOD_HDLC_channel_A_Rx_interrupt_BIT 13
#define INTMOD_HDLC_channel_B_Tx_interrupt_MASK 0x4000U
#define INTMOD_HDLC_channel_B_Tx_interrupt 0x4000U
#define INTMOD_HDLC_channel_B_Tx_interrupt_BIT 14
#define INTMOD_HDLC_channel_B_Rx_interrupt_MASK 0x8000U
#define INTMOD_HDLC_channel_B_Rx_interrupt 0x8000U
#define INTMOD_HDLC_channel_B_Rx_interrupt_BIT 15
#define INTMOD_Ethernet_controller_BDMA_Tx_interrupt_MASK 0x10000U
#define INTMOD_Ethernet_controller_BDMA_Tx_interrupt 0x10000U
#define INTMOD_Ethernet_controller_BDMA_Tx_interrupt_BIT 16
#define INTMOD_Ethernet_controller_BDMA_Rx_interrupt_MASK 0x20000U
#define INTMOD_Ethernet_controller_BDMA_Rx_interrupt 0x20000U
#define INTMOD_Ethernet_controller_BDMA_Rx_interrupt_BIT 17
#define INTMOD_Ethernet_controller_MAC_Tx_interrupt_MASK 0x40000U
#define INTMOD_Ethernet_controller_MAC_Tx_interrupt 0x40000U
#define INTMOD_Ethernet_controller_MAC_Tx_interrupt_BIT 18
#define INTMOD_Ethernet_controller_MAC_Rx_interrupt_MASK 0x80000U
#define INTMOD_Ethernet_controller_MAC_Rx_interrupt 0x80000U
#define INTMOD_Ethernet_controller_MAC_Rx_interrupt_BIT 19
#define INTMOD_I2C_interrupt_MASK 0x100000U
#define INTMOD_I2C_interrupt 0x100000U
#define INTMOD_I2C_interrupt_BIT 20

#define INTPND (*(volatile unsigned *)0x3FF4004)
#define INTPND_External_interrupt_0_MASK 0x1U
#define INTPND_External_interrupt_0 0x1U
#define INTPND_External_interrupt_0_BIT 0
#define INTPND_External_interrupt_1_MASK 0x2U
#define INTPND_External_interrupt_1 0x2U
#define INTPND_External_interrupt_1_BIT 1
#define INTPND_External_interrupt_2_MASK 0x4U
#define INTPND_External_interrupt_2 0x4U
#define INTPND_External_interrupt_2_BIT 2
#define INTPND_External_interrupt_3_MASK 0x8U
#define INTPND_External_interrupt_3 0x8U
#define INTPND_External_interrupt_3_BIT 3
#define INTPND_UART0_transmit_interrupt_MASK 0x10U
#define INTPND_UART0_transmit_interrupt 0x10U
#define INTPND_UART0_transmit_interrupt_BIT 4
#define INTPND_UART0_receive_and_error_interrupt_MASK 0x20U
#define INTPND_UART0_receive_and_error_interrupt 0x20U
#define INTPND_UART0_receive_and_error_interrupt_BIT 5
#define INTPND_UART1_transmit_interrupt_MASK 0x40U
#define INTPND_UART1_transmit_interrupt 0x40U
#define INTPND_UART1_transmit_interrupt_BIT 6
#define INTPND_UART1_receive_and_error_interrupt_MASK 0x80U
#define INTPND_UART1_receive_and_error_interrupt 0x80U
#define INTPND_UART1_receive_and_error_interrupt_BIT 7
#define INTPND_GDMA_channel_0_interrupt_MASK 0x100U
#define INTPND_GDMA_channel_0_interrupt 0x100U
#define INTPND_GDMA_channel_0_interrupt_BIT 8
#define INTPND_GDMA_channel_1_interrupt_MASK 0x200U
#define INTPND_GDMA_channel_1_interrupt 0x200U
#define INTPND_GDMA_channel_1_interrupt_BIT 9
#define INTPND_Timer_0_interrupt_MASK 0x400U
#define INTPND_Timer_0_interrupt 0x400U
#define INTPND_Timer_0_interrupt_BIT 10
#define INTPND_Timer_0_interrupt_MASK 0x800U
#define INTPND_Timer_0_interrupt 0x800U
#define INTPND_Timer_0_interrupt_BIT 11
#define INTPND_HDLC_channel_A_Tx_interrupt_MASK 0x1000U
#define INTPND_HDLC_channel_A_Tx_interrupt 0x1000U
#define INTPND_HDLC_channel_A_Tx_interrupt_BIT 12
#define INTPND_HDLC_channel_A_Rx_interrupt_MASK 0x2000U
#define INTPND_HDLC_channel_A_Rx_interrupt 0x2000U
#define INTPND_HDLC_channel_A_Rx_interrupt_BIT 13
#define INTPND_HDLC_channel_B_Tx_interrupt_MASK 0x4000U
#define INTPND_HDLC_channel_B_Tx_interrupt 0x4000U
#define INTPND_HDLC_channel_B_Tx_interrupt_BIT 14
#define INTPND_HDLC_channel_B_Rx_interrupt_MASK 0x8000U
#define INTPND_HDLC_channel_B_Rx_interrupt 0x8000U
#define INTPND_HDLC_channel_B_Rx_interrupt_BIT 15
#define INTPND_Ethernet_controller_BDMA_Tx_interrupt_MASK 0x10000U
#define INTPND_Ethernet_controller_BDMA_Tx_interrupt 0x10000U
#define INTPND_Ethernet_controller_BDMA_Tx_interrupt_BIT 16
#define INTPND_Ethernet_controller_BDMA_Rx_interrupt_MASK 0x20000U
#define INTPND_Ethernet_controller_BDMA_Rx_interrupt 0x20000U
#define INTPND_Ethernet_controller_BDMA_Rx_interrupt_BIT 17
#define INTPND_Ethernet_controller_MAC_Tx_interrupt_MASK 0x40000U
#define INTPND_Ethernet_controller_MAC_Tx_interrupt 0x40000U
#define INTPND_Ethernet_controller_MAC_Tx_interrupt_BIT 18
#define INTPND_Ethernet_controller_MAC_Rx_interrupt_MASK 0x80000U
#define INTPND_Ethernet_controller_MAC_Rx_interrupt 0x80000U
#define INTPND_Ethernet_controller_MAC_Rx_interrupt_BIT 19
#define INTPND_I2C_interrupt_MASK 0x100000U
#define INTPND_I2C_interrupt 0x100000U
#define INTPND_I2C_interrupt_BIT 20

#define INTMSK (*(volatile unsigned *)0x3FF4008)
#define INTMSK_External_interrupt_0_MASK 0x1U
#define INTMSK_External_interrupt_0 0x1U
#define INTMSK_External_interrupt_0_BIT 0
#define INTMSK_External_interrupt_1_MASK 0x2U
#define INTMSK_External_interrupt_1 0x2U
#define INTMSK_External_interrupt_1_BIT 1
#define INTMSK_External_interrupt_2_MASK 0x4U
#define INTMSK_External_interrupt_2 0x4U
#define INTMSK_External_interrupt_2_BIT 2
#define INTMSK_External_interrupt_3_MASK 0x8U
#define INTMSK_External_interrupt_3 0x8U
#define INTMSK_External_interrupt_3_BIT 3
#define INTMSK_UART0_transmit_interrupt_MASK 0x10U
#define INTMSK_UART0_transmit_interrupt 0x10U
#define INTMSK_UART0_transmit_interrupt_BIT 4
#define INTMSK_UART0_receive_and_error_interrupt_MASK 0x20U
#define INTMSK_UART0_receive_and_error_interrupt 0x20U
#define INTMSK_UART0_receive_and_error_interrupt_BIT 5
#define INTMSK_UART1_transmit_interrupt_MASK 0x40U
#define INTMSK_UART1_transmit_interrupt 0x40U
#define INTMSK_UART1_transmit_interrupt_BIT 6
#define INTMSK_UART1_receive_and_error_interrupt_MASK 0x80U
#define INTMSK_UART1_receive_and_error_interrupt 0x80U
#define INTMSK_UART1_receive_and_error_interrupt_BIT 7
#define INTMSK_GDMA_channel_0_interrupt_MASK 0x100U
#define INTMSK_GDMA_channel_0_interrupt 0x100U
#define INTMSK_GDMA_channel_0_interrupt_BIT 8
#define INTMSK_GDMA_channel_1_interrupt_MASK 0x200U
#define INTMSK_GDMA_channel_1_interrupt 0x200U
#define INTMSK_GDMA_channel_1_interrupt_BIT 9
#define INTMSK_Timer_0_interrupt_MASK 0x400U
#define INTMSK_Timer_0_interrupt 0x400U
#define INTMSK_Timer_0_interrupt_BIT 10
#define INTMSK_Timer_0_interrupt_MASK 0x800U
#define INTMSK_Timer_0_interrupt 0x800U
#define INTMSK_Timer_0_interrupt_BIT 11
#define INTMSK_HDLC_channel_A_Tx_interrupt_MASK 0x1000U
#define INTMSK_HDLC_channel_A_Tx_interrupt 0x1000U
#define INTMSK_HDLC_channel_A_Tx_interrupt_BIT 12
#define INTMSK_HDLC_channel_A_Rx_interrupt_MASK 0x2000U
#define INTMSK_HDLC_channel_A_Rx_interrupt 0x2000U
#define INTMSK_HDLC_channel_A_Rx_interrupt_BIT 13
#define INTMSK_HDLC_channel_B_Tx_interrupt_MASK 0x4000U
#define INTMSK_HDLC_channel_B_Tx_interrupt 0x4000U
#define INTMSK_HDLC_channel_B_Tx_interrupt_BIT 14
#define INTMSK_HDLC_channel_B_Rx_interrupt_MASK 0x8000U
#define INTMSK_HDLC_channel_B_Rx_interrupt 0x8000U
#define INTMSK_HDLC_channel_B_Rx_interrupt_BIT 15
#define INTMSK_Ethernet_controller_BDMA_Tx_interrupt_MASK 0x10000U
#define INTMSK_Ethernet_controller_BDMA_Tx_interrupt 0x10000U
#define INTMSK_Ethernet_controller_BDMA_Tx_interrupt_BIT 16
#define INTMSK_Ethernet_controller_BDMA_Rx_interrupt_MASK 0x20000U
#define INTMSK_Ethernet_controller_BDMA_Rx_interrupt 0x20000U
#define INTMSK_Ethernet_controller_BDMA_Rx_interrupt_BIT 17
#define INTMSK_Ethernet_controller_MAC_Tx_interrupt_MASK 0x40000U
#define INTMSK_Ethernet_controller_MAC_Tx_interrupt 0x40000U
#define INTMSK_Ethernet_controller_MAC_Tx_interrupt_BIT 18
#define INTMSK_Ethernet_controller_MAC_Rx_interrupt_MASK 0x80000U
#define INTMSK_Ethernet_controller_MAC_Rx_interrupt 0x80000U
#define INTMSK_Ethernet_controller_MAC_Rx_interrupt_BIT 19
#define INTMSK_I2C_interrupt_MASK 0x100000U
#define INTMSK_I2C_interrupt 0x100000U
#define INTMSK_I2C_interrupt_BIT 20

#define INTPRI0 (*(volatile unsigned *)0x3FF400C)
#define INTPRI0_PRIORITY0_MASK 0x1FU
#define INTPRI0_PRIORITY0_BIT 0
#define INTPRI0_PRIORITY1_MASK 0x1F00U
#define INTPRI0_PRIORITY1_BIT 8
#define INTPRI0_PRIORITY2_MASK 0x1F0000U
#define INTPRI0_PRIORITY2_BIT 16
#define INTPRI0_PRIORITY3_MASK 0x1F000000U
#define INTPRI0_PRIORITY3_BIT 24

#define INTPRI1 (*(volatile unsigned *)0x3FF4010)
#define INTPRI1_PRIORITY4_MASK 0x1FU
#define INTPRI1_PRIORITY4_BIT 0
#define INTPRI1_PRIORITY5_MASK 0x1F00U
#define INTPRI1_PRIORITY5_BIT 8
#define INTPRI1_PRIORITY6_MASK 0x1F0000U
#define INTPRI1_PRIORITY6_BIT 16
#define INTPRI1_PRIORITY7_MASK 0x1F000000U
#define INTPRI1_PRIORITY7_BIT 24

#define INTPRI2 (*(volatile unsigned *)0x3FF4014)
#define INTPRI2_PRIORITY8_MASK 0x1FU
#define INTPRI2_PRIORITY8_BIT 0
#define INTPRI2_PRIORITY9_MASK 0x1F00U
#define INTPRI2_PRIORITY9_BIT 8
#define INTPRI2_PRIORITY10_MASK 0x1F0000U
#define INTPRI2_PRIORITY10_BIT 16
#define INTPRI2_PRIORITY11_MASK 0x1F000000U
#define INTPRI2_PRIORITY11_BIT 24

#define INTPRI3 (*(volatile unsigned *)0x3FF4018)
#define INTPRI3_PRIORITY12_MASK 0x1FU
#define INTPRI3_PRIORITY12_BIT 0
#define INTPRI3_PRIORITY13_MASK 0x1F00U
#define INTPRI3_PRIORITY13_BIT 8
#define INTPRI3_PRIORITY14_MASK 0x1F0000U
#define INTPRI3_PRIORITY14_BIT 16
#define INTPRI3_PRIORITY15_MASK 0x1F000000U
#define INTPRI3_PRIORITY15_BIT 24

#define INTPRI4 (*(volatile unsigned *)0x3FF401C)
#define INTPRI4_PRIORITY16_MASK 0x1FU
#define INTPRI4_PRIORITY16_BIT 0
#define INTPRI4_PRIORITY17_MASK 0x1F00U
#define INTPRI4_PRIORITY17_BIT 8
#define INTPRI4_PRIORITY18_MASK 0x1F0000U
#define INTPRI4_PRIORITY18_BIT 16
#define INTPRI4_PRIORITY19_MASK 0x1F000000U
#define INTPRI4_PRIORITY19_BIT 24

#define INTPRI5 (*(volatile unsigned *)0x3FF4020)
#define INTPRI5_PRIORITY20_MASK 0x1FU
#define INTPRI5_PRIORITY20_BIT 0

#define INTOFFSET (*(volatile unsigned *)0x3FF4024)

#define INTOSET_FIQ (*(volatile unsigned *)0x3FF4030)

#define INTOSET_IRQ (*(volatile unsigned *)0x3FF4034)

#define IOPMOD (*(volatile unsigned *)0x3FF5000)
#define IOPMOD_port0_MASK 0x1U
#define IOPMOD_port0 0x1U
#define IOPMOD_port0_BIT 0
#define IOPMOD_port1_MASK 0x2U
#define IOPMOD_port1 0x2U
#define IOPMOD_port1_BIT 1
#define IOPMOD_port2_MASK 0x4U
#define IOPMOD_port2 0x4U
#define IOPMOD_port2_BIT 2
#define IOPMOD_port3_MASK 0x8U
#define IOPMOD_port3 0x8U
#define IOPMOD_port3_BIT 3
#define IOPMOD_port4_MASK 0x10U
#define IOPMOD_port4 0x10U
#define IOPMOD_port4_BIT 4
#define IOPMOD_port5_MASK 0x20U
#define IOPMOD_port5 0x20U
#define IOPMOD_port5_BIT 5
#define IOPMOD_port6_MASK 0x40U
#define IOPMOD_port6 0x40U
#define IOPMOD_port6_BIT 6
#define IOPMOD_port7_MASK 0x80U
#define IOPMOD_port7 0x80U
#define IOPMOD_port7_BIT 7
#define IOPMOD_port8_MASK 0x100U
#define IOPMOD_port8 0x100U
#define IOPMOD_port8_BIT 8
#define IOPMOD_port9_MASK 0x200U
#define IOPMOD_port9 0x200U
#define IOPMOD_port9_BIT 9
#define IOPMOD_port10_MASK 0x400U
#define IOPMOD_port10 0x400U
#define IOPMOD_port10_BIT 10
#define IOPMOD_port11_MASK 0x800U
#define IOPMOD_port11 0x800U
#define IOPMOD_port11_BIT 11
#define IOPMOD_port12_MASK 0x1000U
#define IOPMOD_port12 0x1000U
#define IOPMOD_port12_BIT 12
#define IOPMOD_port13_MASK 0x2000U
#define IOPMOD_port13 0x2000U
#define IOPMOD_port13_BIT 13
#define IOPMOD_port14_MASK 0x4000U
#define IOPMOD_port14 0x4000U
#define IOPMOD_port14_BIT 14
#define IOPMOD_port15_MASK 0x8000U
#define IOPMOD_port15 0x8000U
#define IOPMOD_port15_BIT 15
#define IOPMOD_port16_MASK 0x10000U
#define IOPMOD_port16 0x10000U
#define IOPMOD_port16_BIT 16
#define IOPMOD_port17_MASK 0x20000U
#define IOPMOD_port17 0x20000U
#define IOPMOD_port17_BIT 17

#define IOPCON (*(volatile unsigned *)0x3FF5004)
#define IOPCON_xIRQ0_MASK 0x1FU
#define IOPCON_xIRQ0_BIT 0
#define IOPCON_xIRQ1_MASK 0x3E0U
#define IOPCON_xIRQ1_BIT 5
#define IOPCON_xIRQ2_MASK 0x7C00U
#define IOPCON_xIRQ2_BIT 10
#define IOPCON_xIRQ3_MASK 0xF8000U
#define IOPCON_xIRQ3_BIT 15
#define IOPCON_DRQ0_MASK 0x700000U
#define IOPCON_DRQ0_BIT 20
#define IOPCON_DRQ1_MASK 0x3800000U
#define IOPCON_DRQ1_BIT 23
#define IOPCON_DAK0_MASK 0xC000000U
#define IOPCON_DAK0_BIT 26
#define IOPCON_DAK1_MASK 0x30000000U
#define IOPCON_DAK1_BIT 28
#define IOPCON_TOEN0_MASK 0x40000000U
#define IOPCON_TOEN0 0x40000000U
#define IOPCON_TOEN0_BIT 30
#define IOPCON_TOEN1_MASK 0x80000000U
#define IOPCON_TOEN1 0x80000000U
#define IOPCON_TOEN1_BIT 31

#define IOPDATA (*(volatile unsigned *)0x3FF5008)

#define TMOD (*(volatile unsigned *)0x3FF6000)
#define TMOD_TE0_MASK 0x1U
#define TMOD_TE0 0x1U
#define TMOD_TE0_BIT 0
#define TMOD_TMD0_MASK 0x2U
#define TMOD_TMD0 0x2U
#define TMOD_TMD0_BIT 1
#define TMOD_TCLR0_MASK 0x4U
#define TMOD_TCLR0 0x4U
#define TMOD_TCLR0_BIT 2
#define TMOD_TE1_MASK 0x8U
#define TMOD_TE1 0x8U
#define TMOD_TE1_BIT 3
#define TMOD_TMD1_MASK 0x10U
#define TMOD_TMD1 0x10U
#define TMOD_TMD1_BIT 4
#define TMOD_TCLR1_MASK 0x20U
#define TMOD_TCLR1 0x20U
#define TMOD_TCLR1_BIT 5

#define TDATA0 (*(volatile unsigned *)0x3FF6004)

#define TDATA1 (*(volatile unsigned *)0x3FF6008)

#define TCNT0 (*(volatile unsigned *)0x3FF600C)

#define TCNT1 (*(volatile unsigned *)0x3FF6010)

#define HMODE (*(volatile unsigned *)0x3FF7000)
#define HMODE_MFF_MASK 0x1U
#define HMODE_MFF 0x1U
#define HMODE_MFF_BIT 0
#define HMODE_RxCINV_MASK 0x4U
#define HMODE_RxCINV 0x4U
#define HMODE_RxCINV_BIT 2
#define HMODE_TxCINV_MASK 0x8U
#define HMODE_TxCINV 0x8U
#define HMODE_TxCINV_BIT 3
#define HMODE_RxLittle_MASK 0x10U
#define HMODE_RxLittle 0x10U
#define HMODE_RxLittle_BIT 4
#define HMODE_TxLittle_MASK 0x20U
#define HMODE_TxLittle 0x20U
#define HMODE_TxLittle_BIT 5
#define HMODE_TxPL_MASK 0x300U
#define HMODE_TxPL_BIT 8
#define HMODE_DF_MASK 0x3000U
#define HMODE_DF_BIT 12
#define HMODE_DPLLCLK_MASK 0x70000U
#define HMODE_DPLLCLK_BIT 16
#define HMODE_BRGCLK_MASK 0x80000U
#define HMODE_BRGCLK 0x80000U
#define HMODE_BRGCLK_BIT 19
#define HMODE_TxCLK_MASK 0x700000U
#define HMODE_TxCLK_BIT 20
#define HMODE_RxCLK_MASK 0x7000000U
#define HMODE_RxCLK_BIT 24
#define HMODE_TxCOPS_MASK 0x38U
#define HMODE_TxCOPS_BIT 3

#define HCON (*(volatile unsigned *)0x3FF7004)
#define HCON_TxRS_MASK 0x1U
#define HCON_TxRS 0x1U
#define HCON_TxRS_BIT 0
#define HCON_RxRS_MASK 0x2U
#define HCON_RxRS 0x2U
#define HCON_RxRS_BIT 1
#define HCON_DTxRS_MASK 0x4U
#define HCON_DTxRS 0x4U
#define HCON_DTxRS_BIT 2
#define HCON_DRxRS_MASK 0x8U
#define HCON_DRxRS 0x8U
#define HCON_DRxRS_BIT 3
#define HCON_TxEN_MASK 0x10U
#define HCON_TxEN 0x10U
#define HCON_TxEN_BIT 4
#define HCON_RxEN_MASK 0x20U
#define HCON_RxEN 0x20U
#define HCON_RxEN_BIT 5
#define HCON_DTxEN_MASK 0x40U
#define HCON_DTxEN 0x40U
#define HCON_DTxEN_BIT 6
#define HCON_DRxEN_MASK 0x80U
#define HCON_DRxEN 0x80U
#define HCON_DRxEN_BIT 7
#define HCON_DPLLEN_MASK 0x100U
#define HCON_DPLLEN 0x100U
#define HCON_DPLLEN_BIT 8
#define HCON_BRGEN_MASK 0x200U
#define HCON_BRGEN 0x200U
#define HCON_BRGEN_BIT 9
#define HCON_Tx4WD_MASK 0x400U
#define HCON_Tx4WD 0x400U
#define HCON_Tx4WD_BIT 10
#define HCON_Rx4WD_MASK 0x800U
#define HCON_Rx4WD 0x800U
#define HCON_Rx4WD_BIT 11
#define HCON_RxWA_MASK 0x3000U
#define HCON_RxWA_BIT 12
#define HCON_DTxSTSK_MASK 0x4000U
#define HCON_DTxSTSK 0x4000U
#define HCON_DTxSTSK_BIT 14
#define HCON_DRxSTSK_MASK 0x8000U
#define HCON_DRxSTSK 0x8000U
#define HCON_DRxSTSK_BIT 15
#define HCON_DRxMADEC_MASK 0x10000U
#define HCON_DRxMADEC 0x10000U
#define HCON_DRxMADEC_BIT 16
#define HCON_TxFLAG_MASK 0x20000U
#define HCON_TxFLAG 0x20000U
#define HCON_TxFLAG_BIT 17
#define HCON_TxSFLAG_MASK 0x40000U
#define HCON_TxSFLAG 0x40000U
#define HCON_TxSFLAG_BIT 18
#define HCON_TxLOOP_MASK 0x80000U
#define HCON_TxLOOP 0x80000U
#define HCON_TxLOOP_BIT 19
#define HCON_RxECHO_MASK 0x100000U
#define HCON_RxECHO 0x100000U
#define HCON_RxECHO_BIT 20
#define HCON_TxABTEXT_MASK 0x200000U
#define HCON_TxABTEXT 0x200000U
#define HCON_TxABTEXT_BIT 21
#define HCON_TxABT_MASK 0x400000U
#define HCON_TxABT 0x400000U
#define HCON_TxABT_BIT 22
#define HCON_TxPRMB_MASK 0x800000U
#define HCON_TxPRMB 0x800000U
#define HCON_TxPRMB_BIT 23
#define HCON_TxDTR_MASK 0x1000000U
#define HCON_TxDTR 0x1000000U
#define HCON_TxDTR_BIT 24
#define HCON_RxDISCON_MASK 0x2000000U
#define HCON_RxDISCON 0x2000000U
#define HCON_RxDISCON_BIT 25
#define HCON_TxNOCRC_MASK 0x4000000U
#define HCON_TxNOCRC 0x4000000U
#define HCON_TxNOCRC_BIT 26
#define HCON_RxNOCRC_MASK 0x8000000U
#define HCON_RxNOCRC 0x8000000U
#define HCON_RxNOCRC_BIT 27
#define HCON_AutoEN_MASK 0x10000000U
#define HCON_AutoEN 0x10000000U
#define HCON_AutoEN_BIT 28

#define HSTAT (*(volatile unsigned *)0x3FF7008)
#define HSTAT_RxRB_MASK 0xFU
#define HSTAT_RxRB_BIT 0
#define HSTAT_TxFC_MASK 0x10U
#define HSTAT_TxFC 0x10U
#define HSTAT_TxFC_BIT 4
#define HSTAT_TxFA_MASK 0x20U
#define HSTAT_TxFA 0x20U
#define HSTAT_TxFA_BIT 5
#define HSTAT_TxCTS_MASK 0x40U
#define HSTAT_TxCTS 0x40U
#define HSTAT_TxCTS_BIT 6
#define HSTAT_TxSCTS_MASK 0x80U
#define HSTAT_TxSCTS 0x80U
#define HSTAT_TxSCTS_BIT 7
#define HSTAT_TxU_MASK 0x100U
#define HSTAT_TxU 0x100U
#define HSTAT_TxU_BIT 8
#define HSTAT_RxFA_MASK 0x200U
#define HSTAT_RxFA 0x200U
#define HSTAT_RxFA_BIT 9
#define HSTAT_RxFD_MASK 0x800U
#define HSTAT_RxFD 0x800U
#define HSTAT_RxFD_BIT 11
#define HSTAT_RxDCD_MASK 0x1000U
#define HSTAT_RxDCD 0x1000U
#define HSTAT_RxDCD_BIT 12
#define HSTAT_RxSDCD_MASK 0x2000U
#define HSTAT_RxSDCD 0x2000U
#define HSTAT_RxSDCD_BIT 13
#define HSTAT_RxFV_MASK 0x4000U
#define HSTAT_RxFV 0x4000U
#define HSTAT_RxFV_BIT 14
#define HSTAT_RxIDLE_MASK 0x8000U
#define HSTAT_RxIDLE 0x8000U
#define HSTAT_RxIDLE_BIT 15
#define HSTAT_RxABT_MASK 0x10000U
#define HSTAT_RxABT 0x10000U
#define HSTAT_RxABT_BIT 16
#define HSTAT_RxCRCE_MASK 0x20000U
#define HSTAT_RxCRCE 0x20000U
#define HSTAT_RxCRCE_BIT 17
#define HSTAT_RxNO_MASK 0x40000U
#define HSTAT_RxNO 0x40000U
#define HSTAT_RxNO_BIT 18
#define HSTAT_RxOV_MASK 0x80000U
#define HSTAT_RxOV 0x80000U
#define HSTAT_RxOV_BIT 19
#define HSTAT_RxMOV_MASK 0x100000U
#define HSTAT_RxMOV 0x100000U
#define HSTAT_RxMOV_BIT 20
#define HSTAT_DTxABT_MASK 0x400000U
#define HSTAT_DTxABT 0x400000U
#define HSTAT_DTxABT_BIT 22
#define HSTAT_RxIERR_MASK 0x800000U
#define HSTAT_RxIERR 0x800000U
#define HSTAT_RxIERR_BIT 23
#define HSTAT_DRxFD_MASK 0x1000000U
#define HSTAT_DRxFD 0x1000000U
#define HSTAT_DRxFD_BIT 24
#define HSTAT_DRxNL_MASK 0x2000000U
#define HSTAT_DRxNL 0x2000000U
#define HSTAT_DRxNL_BIT 25
#define HSTAT_DRxNO_MASK 0x4000000U
#define HSTAT_DRxNO 0x4000000U
#define HSTAT_DRxNO_BIT 26
#define HSTAT_DTxFD_MASK 0x8000000U
#define HSTAT_DTxFD 0x8000000U
#define HSTAT_DTxFD_BIT 27
#define HSTAT_DTxNL_MASK 0x10000000U
#define HSTAT_DTxNL 0x10000000U
#define HSTAT_DTxNL_BIT 28
#define HSTAT_DTxNO_MASK 0x20000000U
#define HSTAT_DTxNO 0x20000000U
#define HSTAT_DTxNO_BIT 29
#define HSTAT_DPLLOM_MASK 0x40000000U
#define HSTAT_DPLLOM 0x40000000U
#define HSTAT_DPLLOM_BIT 30
#define HSTAT_DPLLTM_MASK 0x80000000U
#define HSTAT_DPLLTM 0x80000000U
#define HSTAT_DPLLTM_BIT 31

#define HINTEN (*(volatile unsigned *)0x3FF700C)
#define HINTEN_TxFCIE_MASK 0x10U
#define HINTEN_TxFCIE 0x10U
#define HINTEN_TxFCIE_BIT 4
#define HINTEN_TxFAIE_MASK 0x20U
#define HINTEN_TxFAIE 0x20U
#define HINTEN_TxFAIE_BIT 5
#define HINTEN_TxSCTSIE_MASK 0x80U
#define HINTEN_TxSCTSIE 0x80U
#define HINTEN_TxSCTSIE_BIT 7
#define HINTEN_TxUIE_MASK 0x100U
#define HINTEN_TxUIE 0x100U
#define HINTEN_TxUIE_BIT 8
#define HINTEN_RxFAIE_MASK 0x200U
#define HINTEN_RxFAIE 0x200U
#define HINTEN_RxFAIE_BIT 9
#define HINTEN_RxFDIE_MASK 0x800U
#define HINTEN_RxFDIE 0x800U
#define HINTEN_RxFDIE_BIT 11
#define HINTEN_RxSDCDIE_MASK 0x2000U
#define HINTEN_RxSDCDIE 0x2000U
#define HINTEN_RxSDCDIE_BIT 13
#define HINTEN_RxFVIE_MASK 0x4000U
#define HINTEN_RxFVIE 0x4000U
#define HINTEN_RxFVIE_BIT 14
#define HINTEN_RxIDLEIE_MASK 0x8000U
#define HINTEN_RxIDLEIE 0x8000U
#define HINTEN_RxIDLEIE_BIT 15
#define HINTEN_RxABTIE_MASK 0x10000U
#define HINTEN_RxABTIE 0x10000U
#define HINTEN_RxABTIE_BIT 16
#define HINTEN_RxCRCEIE_MASK 0x20000U
#define HINTEN_RxCRCEIE 0x20000U
#define HINTEN_RxCRCEIE_BIT 17
#define HINTEN_RxNOIE_MASK 0x40000U
#define HINTEN_RxNOIE 0x40000U
#define HINTEN_RxNOIE_BIT 18
#define HINTEN_RxOVIE_MASK 0x80000U
#define HINTEN_RxOVIE 0x80000U
#define HINTEN_RxOVIE_BIT 19
#define HINTEN_RxMOVIE_MASK 0x100000U
#define HINTEN_RxMOVIE 0x100000U
#define HINTEN_RxMOVIE_BIT 20
#define HINTEN_DTxABTIE_MASK 0x400000U
#define HINTEN_DTxABTIE 0x400000U
#define HINTEN_DTxABTIE_BIT 22
#define HINTEN_RxIERRIE_MASK 0x800000U
#define HINTEN_RxIERRIE 0x800000U
#define HINTEN_RxIERRIE_BIT 23
#define HINTEN_DRxFDIE_MASK 0x1000000U
#define HINTEN_DRxFDIE 0x1000000U
#define HINTEN_DRxFDIE_BIT 24
#define HINTEN_DRxNLIE_MASK 0x2000000U
#define HINTEN_DRxNLIE 0x2000000U
#define HINTEN_DRxNLIE_BIT 25
#define HINTEN_DRxNOIE_MASK 0x4000000U
#define HINTEN_DRxNOIE 0x4000000U
#define HINTEN_DRxNOIE_BIT 26
#define HINTEN_DTxFDIE_MASK 0x8000000U
#define HINTEN_DTxFDIE 0x8000000U
#define HINTEN_DTxFDIE_BIT 27
#define HINTEN_DTxNLIE_MASK 0x10000000U
#define HINTEN_DTxNLIE 0x10000000U
#define HINTEN_DTxNLIE_BIT 28
#define HINTEN_DTxNOIE_MASK 0x20000000U
#define HINTEN_DTxNOIE 0x20000000U
#define HINTEN_DTxNOIE_BIT 29
#define HINTEN_DPLLOMIE_MASK 0x40000000U
#define HINTEN_DPLLOMIE 0x40000000U
#define HINTEN_DPLLOMIE_BIT 30
#define HINTEN_DPLLTMIE_MASK 0x80000000U
#define HINTEN_DPLLTMIE 0x80000000U
#define HINTEN_DPLLTMIE_BIT 31

#define HTXFIFOC (*(volatile unsigned *)0x3FF7010)

#define HTXFIFOT (*(volatile unsigned *)0x3FF7014)

#define HRXFIFO (*(volatile unsigned *)0x3FF7018)

#define HBRGTC (*(volatile unsigned *)0x3FF701C)
#define HBRGTC_CNT2_MASK 0x3U
#define HBRGTC_CNT2_BIT 0
#define HBRGTC_CNT1_MASK 0xCU
#define HBRGTC_CNT1_BIT 2
#define HBRGTC_CNT0_MASK 0x7FFF0U
#define HBRGTC_CNT0_BIT 4

#define HPRMB (*(volatile unsigned *)0x3FF7020)

#define HSAR0 (*(volatile unsigned *)0x3FF7024)

#define HSAR1 (*(volatile unsigned *)0x3FF7028)

#define HSAR2 (*(volatile unsigned *)0x3FF702C)

#define HSAR3 (*(volatile unsigned *)0x3FF7030)

#define HMASK (*(volatile unsigned *)0x3FF7034)

#define DMATxPTR (*(volatile unsigned *)0x3FF7038)

#define DMARxPTR (*(volatile unsigned *)0x3FF703C)

#define HMFLR (*(volatile unsigned *)0x3FF7040)

#define HRBSR (*(volatile unsigned *)0x3FF7044)

#define HMODE (*(volatile unsigned *)0x3FF8000)
#define HMODE_MFF_MASK 0x1U
#define HMODE_MFF 0x1U
#define HMODE_MFF_BIT 0
#define HMODE_RxCINV_MASK 0x4U
#define HMODE_RxCINV 0x4U
#define HMODE_RxCINV_BIT 2
#define HMODE_TxCINV_MASK 0x8U
#define HMODE_TxCINV 0x8U
#define HMODE_TxCINV_BIT 3
#define HMODE_RxLittle_MASK 0x10U
#define HMODE_RxLittle 0x10U
#define HMODE_RxLittle_BIT 4
#define HMODE_TxLittle_MASK 0x20U
#define HMODE_TxLittle 0x20U
#define HMODE_TxLittle_BIT 5
#define HMODE_TxPL_MASK 0x300U
#define HMODE_TxPL_BIT 8
#define HMODE_DF_MASK 0x3000U
#define HMODE_DF_BIT 12
#define HMODE_DPLLCLK_MASK 0x70000U
#define HMODE_DPLLCLK_BIT 16
#define HMODE_BRGCLK_MASK 0x80000U
#define HMODE_BRGCLK 0x80000U
#define HMODE_BRGCLK_BIT 19
#define HMODE_TxCLK_MASK 0x700000U
#define HMODE_TxCLK_BIT 20
#define HMODE_RxCLK_MASK 0x7000000U
#define HMODE_RxCLK_BIT 24
#define HMODE_TxCOPS_MASK 0x38U
#define HMODE_TxCOPS_BIT 3

#define HCON (*(volatile unsigned *)0x3FF8004)
#define HCON_TxRS_MASK 0x1U
#define HCON_TxRS 0x1U
#define HCON_TxRS_BIT 0
#define HCON_RxRS_MASK 0x2U
#define HCON_RxRS 0x2U
#define HCON_RxRS_BIT 1
#define HCON_DTxRS_MASK 0x4U
#define HCON_DTxRS 0x4U
#define HCON_DTxRS_BIT 2
#define HCON_DRxRS_MASK 0x8U
#define HCON_DRxRS 0x8U
#define HCON_DRxRS_BIT 3
#define HCON_TxEN_MASK 0x10U
#define HCON_TxEN 0x10U
#define HCON_TxEN_BIT 4
#define HCON_RxEN_MASK 0x20U
#define HCON_RxEN 0x20U
#define HCON_RxEN_BIT 5
#define HCON_DTxEN_MASK 0x40U
#define HCON_DTxEN 0x40U
#define HCON_DTxEN_BIT 6
#define HCON_DRxEN_MASK 0x80U
#define HCON_DRxEN 0x80U
#define HCON_DRxEN_BIT 7
#define HCON_DPLLEN_MASK 0x100U
#define HCON_DPLLEN 0x100U
#define HCON_DPLLEN_BIT 8
#define HCON_BRGEN_MASK 0x200U
#define HCON_BRGEN 0x200U
#define HCON_BRGEN_BIT 9
#define HCON_Tx4WD_MASK 0x400U
#define HCON_Tx4WD 0x400U
#define HCON_Tx4WD_BIT 10
#define HCON_Rx4WD_MASK 0x800U
#define HCON_Rx4WD 0x800U
#define HCON_Rx4WD_BIT 11
#define HCON_RxWA_MASK 0x3000U
#define HCON_RxWA_BIT 12
#define HCON_DTxSTSK_MASK 0x4000U
#define HCON_DTxSTSK 0x4000U
#define HCON_DTxSTSK_BIT 14
#define HCON_DRxSTSK_MASK 0x8000U
#define HCON_DRxSTSK 0x8000U
#define HCON_DRxSTSK_BIT 15
#define HCON_DRxMADEC_MASK 0x10000U
#define HCON_DRxMADEC 0x10000U
#define HCON_DRxMADEC_BIT 16
#define HCON_TxFLAG_MASK 0x20000U
#define HCON_TxFLAG 0x20000U
#define HCON_TxFLAG_BIT 17
#define HCON_TxSFLAG_MASK 0x40000U
#define HCON_TxSFLAG 0x40000U
#define HCON_TxSFLAG_BIT 18
#define HCON_TxLOOP_MASK 0x80000U
#define HCON_TxLOOP 0x80000U
#define HCON_TxLOOP_BIT 19
#define HCON_RxECHO_MASK 0x100000U
#define HCON_RxECHO 0x100000U
#define HCON_RxECHO_BIT 20
#define HCON_TxABTEXT_MASK 0x200000U
#define HCON_TxABTEXT 0x200000U
#define HCON_TxABTEXT_BIT 21
#define HCON_TxABT_MASK 0x400000U
#define HCON_TxABT 0x400000U
#define HCON_TxABT_BIT 22
#define HCON_TxPRMB_MASK 0x800000U
#define HCON_TxPRMB 0x800000U
#define HCON_TxPRMB_BIT 23
#define HCON_TxDTR_MASK 0x1000000U
#define HCON_TxDTR 0x1000000U
#define HCON_TxDTR_BIT 24
#define HCON_RxDISCON_MASK 0x2000000U
#define HCON_RxDISCON 0x2000000U
#define HCON_RxDISCON_BIT 25
#define HCON_TxNOCRC_MASK 0x4000000U
#define HCON_TxNOCRC 0x4000000U
#define HCON_TxNOCRC_BIT 26
#define HCON_RxNOCRC_MASK 0x8000000U
#define HCON_RxNOCRC 0x8000000U
#define HCON_RxNOCRC_BIT 27
#define HCON_AutoEN_MASK 0x10000000U
#define HCON_AutoEN 0x10000000U
#define HCON_AutoEN_BIT 28

#define HSTAT (*(volatile unsigned *)0x3FF8008)
#define HSTAT_RxRB_MASK 0xFU
#define HSTAT_RxRB_BIT 0
#define HSTAT_TxFC_MASK 0x10U
#define HSTAT_TxFC 0x10U
#define HSTAT_TxFC_BIT 4
#define HSTAT_TxFA_MASK 0x20U
#define HSTAT_TxFA 0x20U
#define HSTAT_TxFA_BIT 5
#define HSTAT_TxCTS_MASK 0x40U
#define HSTAT_TxCTS 0x40U
#define HSTAT_TxCTS_BIT 6
#define HSTAT_TxSCTS_MASK 0x80U
#define HSTAT_TxSCTS 0x80U
#define HSTAT_TxSCTS_BIT 7
#define HSTAT_TxU_MASK 0x100U
#define HSTAT_TxU 0x100U
#define HSTAT_TxU_BIT 8
#define HSTAT_RxFA_MASK 0x200U
#define HSTAT_RxFA 0x200U
#define HSTAT_RxFA_BIT 9
#define HSTAT_RxFD_MASK 0x800U
#define HSTAT_RxFD 0x800U
#define HSTAT_RxFD_BIT 11
#define HSTAT_RxDCD_MASK 0x1000U
#define HSTAT_RxDCD 0x1000U
#define HSTAT_RxDCD_BIT 12
#define HSTAT_RxSDCD_MASK 0x2000U
#define HSTAT_RxSDCD 0x2000U
#define HSTAT_RxSDCD_BIT 13
#define HSTAT_RxFV_MASK 0x4000U
#define HSTAT_RxFV 0x4000U
#define HSTAT_RxFV_BIT 14
#define HSTAT_RxIDLE_MASK 0x8000U
#define HSTAT_RxIDLE 0x8000U
#define HSTAT_RxIDLE_BIT 15
#define HSTAT_RxABT_MASK 0x10000U
#define HSTAT_RxABT 0x10000U
#define HSTAT_RxABT_BIT 16
#define HSTAT_RxCRCE_MASK 0x20000U
#define HSTAT_RxCRCE 0x20000U
#define HSTAT_RxCRCE_BIT 17
#define HSTAT_RxNO_MASK 0x40000U
#define HSTAT_RxNO 0x40000U
#define HSTAT_RxNO_BIT 18
#define HSTAT_RxOV_MASK 0x80000U
#define HSTAT_RxOV 0x80000U
#define HSTAT_RxOV_BIT 19
#define HSTAT_RxMOV_MASK 0x100000U
#define HSTAT_RxMOV 0x100000U
#define HSTAT_RxMOV_BIT 20
#define HSTAT_DTxABT_MASK 0x400000U
#define HSTAT_DTxABT 0x400000U
#define HSTAT_DTxABT_BIT 22
#define HSTAT_RxIERR_MASK 0x800000U
#define HSTAT_RxIERR 0x800000U
#define HSTAT_RxIERR_BIT 23
#define HSTAT_DRxFD_MASK 0x1000000U
#define HSTAT_DRxFD 0x1000000U
#define HSTAT_DRxFD_BIT 24
#define HSTAT_DRxNL_MASK 0x2000000U
#define HSTAT_DRxNL 0x2000000U
#define HSTAT_DRxNL_BIT 25
#define HSTAT_DRxNO_MASK 0x4000000U
#define HSTAT_DRxNO 0x4000000U
#define HSTAT_DRxNO_BIT 26
#define HSTAT_DTxFD_MASK 0x8000000U
#define HSTAT_DTxFD 0x8000000U
#define HSTAT_DTxFD_BIT 27
#define HSTAT_DTxNL_MASK 0x10000000U
#define HSTAT_DTxNL 0x10000000U
#define HSTAT_DTxNL_BIT 28
#define HSTAT_DTxNO_MASK 0x20000000U
#define HSTAT_DTxNO 0x20000000U
#define HSTAT_DTxNO_BIT 29
#define HSTAT_DPLLOM_MASK 0x40000000U
#define HSTAT_DPLLOM 0x40000000U
#define HSTAT_DPLLOM_BIT 30
#define HSTAT_DPLLTM_MASK 0x80000000U
#define HSTAT_DPLLTM 0x80000000U
#define HSTAT_DPLLTM_BIT 31

#define HINTEN (*(volatile unsigned *)0x3FF800C)

#define HTXFIFOC (*(volatile unsigned *)0x3FF8010)

#define HTXFIFOT (*(volatile unsigned *)0x3FF8014)

#define HRXFIFO (*(volatile unsigned *)0x3FF8018)

#define HBRGTC (*(volatile unsigned *)0x3FF801C)
#define HBRGTC_CNT2_MASK 0x3U
#define HBRGTC_CNT2_BIT 0
#define HBRGTC_CNT1_MASK 0xCU
#define HBRGTC_CNT1_BIT 2
#define HBRGTC_CNT0_MASK 0x7FFF0U
#define HBRGTC_CNT0_BIT 4

#define HPRMB (*(volatile unsigned *)0x3FF8020)

#define HSAR0 (*(volatile unsigned *)0x3FF8024)

#define HSAR1 (*(volatile unsigned *)0x3FF8028)

#define HSAR2 (*(volatile unsigned *)0x3FF802C)

#define HSAR3 (*(volatile unsigned *)0x3FF8030)

#define HMASK (*(volatile unsigned *)0x3FF8034)

#define DMATxPTR (*(volatile unsigned *)0x3FF8038)

#define DMARxPTR (*(volatile unsigned *)0x3FF803C)

#define HMFLR (*(volatile unsigned *)0x3FF8040)

#define HRBSR (*(volatile unsigned *)0x3FF8044)

#define BDMATXCON (*(volatile unsigned *)0x3FF9000)
#define BDMATXCON_BTxBRST_MASK 0x1FU
#define BDMATXCON_BTxBRST_BIT 0
#define BDMATXCON_BTxSTSKO_MASK 0x20U
#define BDMATXCON_BTxSTSKO 0x20U
#define BDMATXCON_BTxSTSKO_BIT 5
#define BDMATXCON_BTxMAINC_MASK 0x40U
#define BDMATXCON_BTxMAINC 0x40U
#define BDMATXCON_BTxMAINC_BIT 6
#define BDMATXCON_BTxCCPIE_MASK 0x80U
#define BDMATXCON_BTxCCPIE 0x80U
#define BDMATXCON_BTxCCPIE_BIT 7
#define BDMATXCON_BTxNLIE_MASK 0x100U
#define BDMATXCON_BTxNLIE 0x100U
#define BDMATXCON_BTxNLIE_BIT 8
#define BDMATXCON_BTxNOIE_MASK 0x200U
#define BDMATXCON_BTxNOIE 0x200U
#define BDMATXCON_BTxNOIE_BIT 9
#define BDMATXCON_BTxEmpty_MASK 0x400U
#define BDMATXCON_BTxEmpty 0x400U
#define BDMATXCON_BTxEmpty_BIT 10
#define BDMATXCON_BTxMSL_MASK 0x3800U
#define BDMATXCON_BTxMSL_BIT 11
#define BDMATXCON_BTxEn_MASK 0x4000U
#define BDMATXCON_BTxEn 0x4000U
#define BDMATXCON_BTxEn_BIT 14
#define BDMATXCON_BTxRs_MASK 0x8000U
#define BDMATXCON_BTxRs 0x8000U
#define BDMATXCON_BTxRs_BIT 15

#define BDMARXCON (*(volatile unsigned *)0x3FF9004)
#define BDMARXCON_BRxBRST_MASK 0x1FU
#define BDMARXCON_BRxBRST_BIT 0
#define BDMARXCON_BRxSTSKO_MASK 0x20U
#define BDMARXCON_BRxSTSKO 0x20U
#define BDMARXCON_BRxSTSKO_BIT 5
#define BDMARXCON_BRxMAINC_MASK 0x40U
#define BDMARXCON_BRxMAINC 0x40U
#define BDMARXCON_BRxMAINC_BIT 6
#define BDMARXCON_BRxDIE_MASK 0x80U
#define BDMARXCON_BRxDIE 0x80U
#define BDMARXCON_BRxDIE_BIT 7
#define BDMARXCON_BRxNLIE_MASK 0x100U
#define BDMARXCON_BRxNLIE 0x100U
#define BDMARXCON_BRxNLIE_BIT 8
#define BDMARXCON_BRxNOIE_MASK 0x200U
#define BDMARXCON_BRxNOIE 0x200U
#define BDMARXCON_BRxNOIE_BIT 9
#define BDMARXCON_BRxMSOIE_MASK 0x400U
#define BDMARXCON_BRxMSOIE 0x400U
#define BDMARXCON_BRxMSOIE_BIT 10
#define BDMARXCON_BRxLittle_MASK 0x3800U
#define BDMARXCON_BRxLittle_BIT 11
#define BDMARXCON_BRxWA_MASK 0x3000U
#define BDMARXCON_BRxWA_BIT 12
#define BDMARXCON_BRxEn_MASK 0x4000U
#define BDMARXCON_BRxEn 0x4000U
#define BDMARXCON_BRxEn_BIT 14
#define BDMARXCON_BRxRS_MASK 0x8000U
#define BDMARXCON_BRxRS 0x8000U
#define BDMARXCON_BRxRS_BIT 15
#define BDMARXCON_BRxEmpty_MASK 0x10000U
#define BDMARXCON_BRxEmpty 0x10000U
#define BDMARXCON_BRxEmpty_BIT 16
#define BDMARXCON_BRxEarly_MASK 0x20000U
#define BDMARXCON_BRxEarly 0x20000U
#define BDMARXCON_BRxEarly_BIT 17

#define BDMATXPTR (*(volatile unsigned *)0x3FF9008)

#define BDMARXPTR (*(volatile unsigned *)0x3FF900C)

#define BDMARXLSZ (*(volatile unsigned *)0x3FF9010)
#define BDMARXLSZ_BRxLSZ_MASK 0xFFFFU
#define BDMARXLSZ_BRxLSZ_BIT 0
#define BDMARXLSZ_BRxFSZ_MASK 0xFFFF0000U
#define BDMARXLSZ_BRxFSZ_BIT 16

#define BDMASTAT (*(volatile unsigned *)0x3FF9014)
#define BDMASTAT_BRxRDF_MASK 0x1U
#define BDMASTAT_BRxRDF 0x1U
#define BDMASTAT_BRxRDF_BIT 0
#define BDMASTAT_BRxNL_MASK 0x2U
#define BDMASTAT_BRxNL 0x2U
#define BDMASTAT_BRxNL_BIT 1
#define BDMASTAT_BRxNO_MASK 0x4U
#define BDMASTAT_BRxNO 0x4U
#define BDMASTAT_BRxNO_BIT 2
#define BDMASTAT_BRxMSO_MASK 0x8U
#define BDMASTAT_BRxMSO 0x8U
#define BDMASTAT_BRxMSO_BIT 3
#define BDMASTAT_BRxEmpty_MASK 0x10U
#define BDMASTAT_BRxEmpty 0x10U
#define BDMASTAT_BRxEmpty_BIT 4
#define BDMASTAT_BRxSEarly_MASK 0x20U
#define BDMASTAT_BRxSEarly 0x20U
#define BDMASTAT_BRxSEarly_BIT 5
#define BDMASTAT_BRxFRF_MASK 0x80U
#define BDMASTAT_BRxFRF 0x80U
#define BDMASTAT_BRxFRF_BIT 7
#define BDMASTAT_BRxNFR_MASK 0xFF00U
#define BDMASTAT_BRxNFR_BIT 8
#define BDMASTAT_BTxCCP_MASK 0x10000U
#define BDMASTAT_BTxCCP 0x10000U
#define BDMASTAT_BTxCCP_BIT 16
#define BDMASTAT_BTxNL_MASK 0x20000U
#define BDMASTAT_BTxNL 0x20000U
#define BDMASTAT_BTxNL_BIT 17
#define BDMASTAT_BTxNO_MASK 0x40000U
#define BDMASTAT_BTxNO 0x40000U
#define BDMASTAT_BTxNO_BIT 18
#define BDMASTAT_BTxEmpty_MASK 0x100000U
#define BDMASTAT_BTxEmpty 0x100000U
#define BDMASTAT_BTxEmpty_BIT 20

#define ETXSTAT (*(volatile unsigned *)0x3FF9040)

#define MACON (*(volatile unsigned *)0x3FFA000)
#define MACON_HaltReq_MASK 0x1U
#define MACON_HaltReq 0x1U
#define MACON_HaltReq_BIT 0
#define MACON_HaltImm_MASK 0x2U
#define MACON_HaltImm 0x2U
#define MACON_HaltImm_BIT 1
#define MACON_Reset_MASK 0x4U
#define MACON_Reset 0x4U
#define MACON_Reset_BIT 2
#define MACON_FullDup_MASK 0x8U
#define MACON_FullDup 0x8U
#define MACON_FullDup_BIT 3
#define MACON_MACLoop_MASK 0x10U
#define MACON_MACLoop 0x10U
#define MACON_MACLoop_BIT 4
#define MACON_MII_OFF_MASK 0x40U
#define MACON_MII_OFF 0x40U
#define MACON_MII_OFF_BIT 6
#define MACON_Loop10_MASK 0x80U
#define MACON_Loop10 0x80U
#define MACON_Loop10_BIT 7
#define MACON_MissRoll_MASK 0x400U
#define MACON_MissRoll 0x400U
#define MACON_MissRoll_BIT 10
#define MACON_MDC_OFF_MASK 0x1000U
#define MACON_MDC_OFF 0x1000U
#define MACON_MDC_OFF_BIT 12
#define MACON_EnMissRoll_MASK 0x2000U
#define MACON_EnMissRoll 0x2000U
#define MACON_EnMissRoll_BIT 13
#define MACON_Link10_MASK 0x8000U
#define MACON_Link10 0x8000U
#define MACON_Link10_BIT 15

#define CAMCON (*(volatile unsigned *)0x3FFA004)
#define CAMCON_StationAcc_MASK 0x1U
#define CAMCON_StationAcc 0x1U
#define CAMCON_StationAcc_BIT 0
#define CAMCON_GroupAcc_MASK 0x2U
#define CAMCON_GroupAcc 0x2U
#define CAMCON_GroupAcc_BIT 1
#define CAMCON_BroadAcc_MASK 0x4U
#define CAMCON_BroadAcc 0x4U
#define CAMCON_BroadAcc_BIT 2
#define CAMCON_NegCAM_MASK 0x8U
#define CAMCON_NegCAM 0x8U
#define CAMCON_NegCAM_BIT 3
#define CAMCON_CompEn_MASK 0x10U
#define CAMCON_CompEn 0x10U
#define CAMCON_CompEn_BIT 4

#define MACTXCON (*(volatile unsigned *)0x3FFA008)
#define MACTXCON_TxEn_MASK 0x1U
#define MACTXCON_TxEn 0x1U
#define MACTXCON_TxEn_BIT 0
#define MACTXCON_TxHalt_MASK 0x2U
#define MACTXCON_TxHalt 0x2U
#define MACTXCON_TxHalt_BIT 1
#define MACTXCON_NoPad_MASK 0x4U
#define MACTXCON_NoPad 0x4U
#define MACTXCON_NoPad_BIT 2
#define MACTXCON_NoCRC_MASK 0x8U
#define MACTXCON_NoCRC 0x8U
#define MACTXCON_NoCRC_BIT 3
#define MACTXCON_FBack_MASK 0x10U
#define MACTXCON_FBack 0x10U
#define MACTXCON_FBack_BIT 4
#define MACTXCON_NoDef_MASK 0x20U
#define MACTXCON_NoDef 0x20U
#define MACTXCON_NoDef_BIT 5
#define MACTXCON_SdPause_MASK 0x40U
#define MACTXCON_SdPause 0x40U
#define MACTXCON_SdPause_BIT 6
#define MACTXCON_SQEn_MASK 0x80U
#define MACTXCON_SQEn 0x80U
#define MACTXCON_SQEn_BIT 7
#define MACTXCON_EnUnder_MASK 0x100U
#define MACTXCON_EnUnder 0x100U
#define MACTXCON_EnUnder_BIT 8
#define MACTXCON_EnDefer_MASK 0x200U
#define MACTXCON_EnDefer 0x200U
#define MACTXCON_EnDefer_BIT 9
#define MACTXCON_EnNCarr_MASK 0x400U
#define MACTXCON_EnNCarr 0x400U
#define MACTXCON_EnNCarr_BIT 10
#define MACTXCON_EnExColl_MASK 0x800U
#define MACTXCON_EnExColl 0x800U
#define MACTXCON_EnExColl_BIT 11
#define MACTXCON_EnLateColl_MASK 0x1000U
#define MACTXCON_EnLateColl 0x1000U
#define MACTXCON_EnLateColl_BIT 12
#define MACTXCON_EnTxPar_MASK 0x2000U
#define MACTXCON_EnTxPar 0x2000U
#define MACTXCON_EnTxPar_BIT 13
#define MACTXCON_EnComp_MASK 0x4000U
#define MACTXCON_EnComp 0x4000U
#define MACTXCON_EnComp_BIT 14

#define MACTXSTAT (*(volatile unsigned *)0x3FFA00C)
#define MACTXSTAT_TxColl_MASK 0xFU
#define MACTXSTAT_TxColl_BIT 0
#define MACTXSTAT_ExColl_MASK 0x10U
#define MACTXSTAT_ExColl 0x10U
#define MACTXSTAT_ExColl_BIT 4
#define MACTXSTAT_TxDeferred_MASK 0x20U
#define MACTXSTAT_TxDeferred 0x20U
#define MACTXSTAT_TxDeferred_BIT 5
#define MACTXSTAT_Paused_MASK 0x40U
#define MACTXSTAT_Paused 0x40U
#define MACTXSTAT_Paused_BIT 6
#define MACTXSTAT_IntTx_MASK 0x80U
#define MACTXSTAT_IntTx 0x80U
#define MACTXSTAT_IntTx_BIT 7
#define MACTXSTAT_Under_MASK 0x100U
#define MACTXSTAT_Under 0x100U
#define MACTXSTAT_Under_BIT 8
#define MACTXSTAT_Defer_MASK 0x200U
#define MACTXSTAT_Defer 0x200U
#define MACTXSTAT_Defer_BIT 9
#define MACTXSTAT_NCarr_MASK 0x400U
#define MACTXSTAT_NCarr 0x400U
#define MACTXSTAT_NCarr_BIT 10
#define MACTXSTAT_SQE_MASK 0x800U
#define MACTXSTAT_SQE 0x800U
#define MACTXSTAT_SQE_BIT 11
#define MACTXSTAT_LateColl_MASK 0x1000U
#define MACTXSTAT_LateColl 0x1000U
#define MACTXSTAT_LateColl_BIT 12
#define MACTXSTAT_TxPar_MASK 0x2000U
#define MACTXSTAT_TxPar 0x2000U
#define MACTXSTAT_TxPar_BIT 13
#define MACTXSTAT_Comp_MASK 0x4000U
#define MACTXSTAT_Comp 0x4000U
#define MACTXSTAT_Comp_BIT 14
#define MACTXSTAT_TxHalted_MASK 0x8000U
#define MACTXSTAT_TxHalted 0x8000U
#define MACTXSTAT_TxHalted_BIT 15

#define MACRXCON (*(volatile unsigned *)0x3FFA010)
#define MACRXCON_RxEn_MASK 0x1U
#define MACRXCON_RxEn 0x1U
#define MACRXCON_RxEn_BIT 0
#define MACRXCON_RxHalt_MASK 0x2U
#define MACRXCON_RxHalt 0x2U
#define MACRXCON_RxHalt_BIT 1
#define MACRXCON_LongEn_MASK 0x4U
#define MACRXCON_LongEn 0x4U
#define MACRXCON_LongEn_BIT 2
#define MACRXCON_ShortEn_MASK 0x8U
#define MACRXCON_ShortEn 0x8U
#define MACRXCON_ShortEn_BIT 3
#define MACRXCON_StripCRC_MASK 0x10U
#define MACRXCON_StripCRC 0x10U
#define MACRXCON_StripCRC_BIT 4
#define MACRXCON_PassCtl_MASK 0x20U
#define MACRXCON_PassCtl 0x20U
#define MACRXCON_PassCtl_BIT 5
#define MACRXCON_IgnoreCRC_MASK 0x40U
#define MACRXCON_IgnoreCRC 0x40U
#define MACRXCON_IgnoreCRC_BIT 6
#define MACRXCON_EnAlign_MASK 0x100U
#define MACRXCON_EnAlign 0x100U
#define MACRXCON_EnAlign_BIT 8
#define MACRXCON_EnCRCErr_MASK 0x200U
#define MACRXCON_EnCRCErr 0x200U
#define MACRXCON_EnCRCErr_BIT 9
#define MACRXCON_EnOver_MASK 0x400U
#define MACRXCON_EnOver 0x400U
#define MACRXCON_EnOver_BIT 10
#define MACRXCON_EnLongErr_MASK 0x800U
#define MACRXCON_EnLongErr 0x800U
#define MACRXCON_EnLongErr_BIT 11
#define MACRXCON_EnRxPar_MASK 0x2000U
#define MACRXCON_EnRxPar 0x2000U
#define MACRXCON_EnRxPar_BIT 13
#define MACRXCON_EnGood_MASK 0x4000U
#define MACRXCON_EnGood 0x4000U
#define MACRXCON_EnGood_BIT 14

#define MACRXSTAT (*(volatile unsigned *)0x3FFA014)
#define MACRXSTAT_CtlRecd_MASK 0x20U
#define MACRXSTAT_CtlRecd 0x20U
#define MACRXSTAT_CtlRecd_BIT 5
#define MACRXSTAT_IntRx_MASK 0x40U
#define MACRXSTAT_IntRx 0x40U
#define MACRXSTAT_IntRx_BIT 6
#define MACRXSTAT_Rx10Stat_MASK 0x80U
#define MACRXSTAT_Rx10Stat 0x80U
#define MACRXSTAT_Rx10Stat_BIT 7
#define MACRXSTAT_AlignErr_MASK 0x100U
#define MACRXSTAT_AlignErr 0x100U
#define MACRXSTAT_AlignErr_BIT 8
#define MACRXSTAT_CRCErr_MASK 0x200U
#define MACRXSTAT_CRCErr 0x200U
#define MACRXSTAT_CRCErr_BIT 9
#define MACRXSTAT_overflow_MASK 0x400U
#define MACRXSTAT_overflow 0x400U
#define MACRXSTAT_overflow_BIT 10
#define MACRXSTAT_LongErr_MASK 0x800U
#define MACRXSTAT_LongErr 0x800U
#define MACRXSTAT_LongErr_BIT 11
#define MACRXSTAT_RxPar_MASK 0x2000U
#define MACRXSTAT_RxPar 0x2000U
#define MACRXSTAT_RxPar_BIT 13
#define MACRXSTAT_Good_MASK 0x4000U
#define MACRXSTAT_Good 0x4000U
#define MACRXSTAT_Good_BIT 14
#define MACRXSTAT_RxHalted_MASK 0x8000U
#define MACRXSTAT_RxHalted 0x8000U
#define MACRXSTAT_RxHalted_BIT 15

#define STADATA (*(volatile unsigned *)0x3FFA018)

#define STACON (*(volatile unsigned *)0x3FFA01C)
#define STACON_Addr_MASK 0x1FU
#define STACON_Addr_BIT 0
#define STACON_PHY_MASK 0x3E0U
#define STACON_PHY_BIT 5
#define STACON_Wr_MASK 0x400U
#define STACON_Wr 0x400U
#define STACON_Wr_BIT 10
#define STACON_Busy_MASK 0x800U
#define STACON_Busy 0x800U
#define STACON_Busy_BIT 11
#define STACON_PreSup_MASK 0x1000U
#define STACON_PreSup 0x1000U
#define STACON_PreSup_BIT 12
#define STACON_MD_CA_MASK 0xE000U
#define STACON_MD_CA_BIT 13

#define CAMEN (*(volatile unsigned *)0x3FFA028)

#define EMISSCNT (*(volatile unsigned *)0x3FFA03C)

#define EPZCNT (*(volatile unsigned long *)0x3FFA040)

#define ERMPZCNT (*(volatile unsigned long *)0x3FFA044)

#define GDMACON0 (*(volatile unsigned *)0x3FFB000)
#define GDMACON0_BE_MASK 0x1U
#define GDMACON0_BE 0x1U
#define GDMACON0_BE_BIT 0
#define GDMACON0_BS_MASK 0x2U
#define GDMACON0_BS 0x2U
#define GDMACON0_BS_BIT 1
#define GDMACON0_MODE_MASK 0xCU
#define GDMACON0_MODE_BIT 2
#define GDMACON0_DA_MASK 0x10U
#define GDMACON0_DA 0x10U
#define GDMACON0_DA_BIT 4
#define GDMACON0_SA_MASK 0x20U
#define GDMACON0_SA 0x20U
#define GDMACON0_SA_BIT 5
#define GDMACON0_DF_MASK 0x40U
#define GDMACON0_DF 0x40U
#define GDMACON0_DF_BIT 6
#define GDMACON0_SF_MASK 0x80U
#define GDMACON0_SF 0x80U
#define GDMACON0_SF_BIT 7
#define GDMACON0_SI_MASK 0x100U
#define GDMACON0_SI 0x100U
#define GDMACON0_SI_BIT 8
#define GDMACON0_FB_MASK 0x200U
#define GDMACON0_FB 0x200U
#define GDMACON0_FB_BIT 9
#define GDMACON0_TD_MASK 0x400U
#define GDMACON0_TD 0x400U
#define GDMACON0_TD_BIT 10
#define GDMACON0_SB_MASK 0x800U
#define GDMACON0_SB 0x800U
#define GDMACON0_SB_BIT 11
#define GDMACON0_TW_MASK 0x3000U
#define GDMACON0_TW_BIT 12
#define GDMACON0_CN_MASK 0x4000U
#define GDMACON0_CN 0x4000U
#define GDMACON0_CN_BIT 14
#define GDMACON0_DM_MASK 0x8000U
#define GDMACON0_DM 0x8000U
#define GDMACON0_DM_BIT 15

#define GDMASRC0 (*(volatile unsigned *)0x3FFB004)

#define GDMADST0 (*(volatile unsigned *)0x3FFB008)

#define GDMACNT0 (*(volatile unsigned *)0x3FFB00C)

#define GDMACON1 (*(volatile unsigned *)0x3FFC000)
#define GDMACON1_BE_MASK 0x1U
#define GDMACON1_BE 0x1U
#define GDMACON1_BE_BIT 0
#define GDMACON1_BS_MASK 0x2U
#define GDMACON1_BS 0x2U
#define GDMACON1_BS_BIT 1
#define GDMACON1_MODE_MASK 0xCU
#define GDMACON1_MODE_BIT 2
#define GDMACON1_DA_MASK 0x10U
#define GDMACON1_DA 0x10U
#define GDMACON1_DA_BIT 4
#define GDMACON1_SA_MASK 0x20U
#define GDMACON1_SA 0x20U
#define GDMACON1_SA_BIT 5
#define GDMACON1_DF_MASK 0x40U
#define GDMACON1_DF 0x40U
#define GDMACON1_DF_BIT 6
#define GDMACON1_SF_MASK 0x80U
#define GDMACON1_SF 0x80U
#define GDMACON1_SF_BIT 7
#define GDMACON1_SI_MASK 0x100U
#define GDMACON1_SI 0x100U
#define GDMACON1_SI_BIT 8
#define GDMACON1_FB_MASK 0x200U
#define GDMACON1_FB 0x200U
#define GDMACON1_FB_BIT 9
#define GDMACON1_TD_MASK 0x400U
#define GDMACON1_TD 0x400U
#define GDMACON1_TD_BIT 10
#define GDMACON1_SB_MASK 0x800U
#define GDMACON1_SB 0x800U
#define GDMACON1_SB_BIT 11
#define GDMACON1_TW_MASK 0x3000U
#define GDMACON1_TW_BIT 12
#define GDMACON1_CN_MASK 0x4000U
#define GDMACON1_CN 0x4000U
#define GDMACON1_CN_BIT 14
#define GDMACON1_DM_MASK 0x8000U
#define GDMACON1_DM 0x8000U
#define GDMACON1_DM_BIT 15

#define GDMASRC1 (*(volatile unsigned *)0x3FFC004)

#define GDMADST1 (*(volatile unsigned *)0x3FFC008)

#define GDMACNT1 (*(volatile unsigned *)0x3FFC00C)

#define ULCON0 (*(volatile unsigned *)0x3FFD000)
#define ULCON0_WL_MASK 0x3U
#define ULCON0_WL_BIT 0
#define ULCON0_STB_MASK 0x4U
#define ULCON0_STB 0x4U
#define ULCON0_STB_BIT 2
#define ULCON0_PMD_MASK 0x38U
#define ULCON0_PMD_BIT 3
#define ULCON0_X_MASK 0x40U
#define ULCON0_X 0x40U
#define ULCON0_X_BIT 6
#define ULCON0_IR_MASK 0x80U
#define ULCON0_IR 0x80U
#define ULCON0_IR_BIT 7

#define UCON0 (*(volatile unsigned *)0x3FFD004)
#define UCON0_RxM_MASK 0x3U
#define UCON0_RxM_BIT 0
#define UCON0_RxSI_MASK 0x4U
#define UCON0_RxSI 0x4U
#define UCON0_RxSI_BIT 2
#define UCON0_TxM_MASK 0x18U
#define UCON0_TxM_BIT 3
#define UCON0_DSR_MASK 0x20U
#define UCON0_DSR 0x20U
#define UCON0_DSR_BIT 5
#define UCON0_SBK_MASK 0x40U
#define UCON0_SBK 0x40U
#define UCON0_SBK_BIT 6
#define UCON0_LPB_MASK 0x80U
#define UCON0_LPB 0x80U
#define UCON0_LPB_BIT 7

#define USTAT0 (*(volatile unsigned *)0x3FFD008)
#define USTAT0_OV_MASK 0x1U
#define USTAT0_OV 0x1U
#define USTAT0_OV_BIT 0
#define USTAT0_PE_MASK 0x2U
#define USTAT0_PE 0x2U
#define USTAT0_PE_BIT 1
#define USTAT0_FE_MASK 0x4U
#define USTAT0_FE 0x4U
#define USTAT0_FE_BIT 2
#define USTAT0_BKD_MASK 0x8U
#define USTAT0_BKD 0x8U
#define USTAT0_BKD_BIT 3
#define USTAT0_DTR_MASK 0x10U
#define USTAT0_DTR 0x10U
#define USTAT0_DTR_BIT 4
#define USTAT0_RDR_MASK 0x20U
#define USTAT0_RDR 0x20U
#define USTAT0_RDR_BIT 5
#define USTAT0_TBE_MASK 0x40U
#define USTAT0_TBE 0x40U
#define USTAT0_TBE_BIT 6
#define USTAT0_TC_MASK 0x80U
#define USTAT0_TC 0x80U
#define USTAT0_TC_BIT 7

#define UTXBUF0 (*(volatile unsigned *)0x3FFD00C)

#define URXBUF0 (*(volatile unsigned *)0x3FFD010)

#define UBRDIV0 (*(volatile unsigned *)0x3FFD014)
#define UBRDIV0_CNT1_MASK 0xFU
#define UBRDIV0_CNT1_BIT 0
#define UBRDIV0_CNT2_MASK 0xFFF0U
#define UBRDIV0_CNT2_BIT 4

#define ULCON1 (*(volatile unsigned *)0x3FFE000)
#define ULCON1_WL_MASK 0x3U
#define ULCON1_WL_BIT 0
#define ULCON1_STB_MASK 0x4U
#define ULCON1_STB 0x4U
#define ULCON1_STB_BIT 2
#define ULCON1_PMD_MASK 0x38U
#define ULCON1_PMD_BIT 3
#define ULCON1_X_MASK 0x40U
#define ULCON1_X 0x40U
#define ULCON1_X_BIT 6
#define ULCON1_IR_MASK 0x80U
#define ULCON1_IR 0x80U
#define ULCON1_IR_BIT 7

#define UCON1 (*(volatile unsigned *)0x3FFE004)
#define UCON1_RxM_MASK 0x3U
#define UCON1_RxM_BIT 0
#define UCON1_RxSI_MASK 0x4U
#define UCON1_RxSI 0x4U
#define UCON1_RxSI_BIT 2
#define UCON1_TxM_MASK 0x18U
#define UCON1_TxM_BIT 3
#define UCON1_DSR_MASK 0x20U
#define UCON1_DSR 0x20U
#define UCON1_DSR_BIT 5
#define UCON1_SBK_MASK 0x40U
#define UCON1_SBK 0x40U
#define UCON1_SBK_BIT 6
#define UCON1_LPB_MASK 0x80U
#define UCON1_LPB 0x80U
#define UCON1_LPB_BIT 7

#define USTAT1 (*(volatile unsigned *)0x3FFE008)
#define USTAT1_OV_MASK 0x1U
#define USTAT1_OV 0x1U
#define USTAT1_OV_BIT 0
#define USTAT1_PE_MASK 0x2U
#define USTAT1_PE 0x2U
#define USTAT1_PE_BIT 1
#define USTAT1_FE_MASK 0x4U
#define USTAT1_FE 0x4U
#define USTAT1_FE_BIT 2
#define USTAT1_BKD_MASK 0x8U
#define USTAT1_BKD 0x8U
#define USTAT1_BKD_BIT 3
#define USTAT1_DTR_MASK 0x10U
#define USTAT1_DTR 0x10U
#define USTAT1_DTR_BIT 4
#define USTAT1_RDR_MASK 0x20U
#define USTAT1_RDR 0x20U
#define USTAT1_RDR_BIT 5
#define USTAT1_TBE_MASK 0x40U
#define USTAT1_TBE 0x40U
#define USTAT1_TBE_BIT 6
#define USTAT1_TC_MASK 0x80U
#define USTAT1_TC 0x80U
#define USTAT1_TC_BIT 7

#define UTXBUF1 (*(volatile unsigned *)0x3FFE00C)

#define URXBUF1 (*(volatile unsigned *)0x3FFE010)

#define UBRDIV1 (*(volatile unsigned *)0x3FFE014)

#define IICCON (*(volatile unsigned *)0x3FFF000)
#define IICCON_BF_MASK 0x1U
#define IICCON_BF 0x1U
#define IICCON_BF_BIT 0
#define IICCON_IEN_MASK 0x2U
#define IICCON_IEN 0x2U
#define IICCON_IEN_BIT 1
#define IICCON_LRB_MASK 0x4U
#define IICCON_LRB 0x4U
#define IICCON_LRB_BIT 2
#define IICCON_ACK_MASK 0x8U
#define IICCON_ACK 0x8U
#define IICCON_ACK_BIT 3
#define IICCON_COND0_MASK 0x10U
#define IICCON_COND0 0x10U
#define IICCON_COND0_BIT 4
#define IICCON_COND1_MASK 0x20U
#define IICCON_COND1 0x20U
#define IICCON_COND1_BIT 5
#define IICCON_BUSY_MASK 0x40U
#define IICCON_BUSY 0x40U
#define IICCON_BUSY_BIT 6
#define IICCON_RESET_MASK 0x80U
#define IICCON_RESET 0x80U
#define IICCON_RESET_BIT 7

#define IICBUF (*(volatile unsigned *)0x3FFF004)

#define IICPS (*(volatile unsigned *)0x3FFF008)

#define IICCOUNT (*(volatile unsigned *)0x3FFF00C)


#endif
