// LH79520 register and bit definitions.
//
// Copyright (c) 2005 Rowley Associates Limited.
//
// This file may be distributed under the terms of the License Agreement
// provided with this software.
//
// THIS FILE IS PROVIDED AS IS WITH NO WARRANTY OF ANY KIND, INCLUDING THE
// WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.

#ifndef LH79520_h
#define LH79520_h

#define UART0_BASE 0xFFFC0000

#define UART0DR (*(volatile unsigned long *)0xFFFC0000)
#define UART0DR_OFFSET 0x0

#define UART0RSR (*(volatile unsigned long *)0xFFFC0004)
#define UART0RSR_OFFSET 0x4

#define UART0ECR (*(volatile unsigned long *)0xFFFC0004)
#define UART0ECR_OFFSET 0x4

#define UART0FR (*(volatile unsigned long *)0xFFFC0018)
#define UART0FR_OFFSET 0x18

#define UART0ILPR (*(volatile unsigned long *)0xFFFC0020)
#define UART0ILPR_OFFSET 0x20

#define UART0IBRD (*(volatile unsigned long *)0xFFFC0024)
#define UART0IBRD_OFFSET 0x24

#define UART0FBRD (*(volatile unsigned long *)0xFFFC0028)
#define UART0FBRD_OFFSET 0x28

#define UART0LCR_H (*(volatile unsigned long *)0xFFFC002C)
#define UART0LCR_H_OFFSET 0x2C

#define UART0CR (*(volatile unsigned long *)0xFFFC0030)
#define UART0CR_OFFSET 0x30

#define UART0IFLS (*(volatile unsigned long *)0xFFFC0034)
#define UART0IFLS_OFFSET 0x34

#define UART0IMSC (*(volatile unsigned long *)0xFFFC0038)
#define UART0IMSC_OFFSET 0x38

#define UART0RIS (*(volatile unsigned long *)0xFFFC003C)
#define UART0RIS_OFFSET 0x3C

#define UART0MIS (*(volatile unsigned long *)0xFFFC0040)
#define UART0MIS_OFFSET 0x40

#define UART0ICR (*(volatile unsigned long *)0xFFFC0044)
#define UART0ICR_OFFSET 0x44

#define UART0TCR (*(volatile unsigned long *)0xFFFC0080)
#define UART0TCR_OFFSET 0x80

#define UART1_BASE 0xFFFC1000

#define UART1DR (*(volatile unsigned long *)0xFFFC1000)
#define UART1DR_OFFSET 0x0

#define UART1RSR (*(volatile unsigned long *)0xFFFC1004)
#define UART1RSR_OFFSET 0x4

#define UART1ECR (*(volatile unsigned long *)0xFFFC1004)
#define UART1ECR_OFFSET 0x4

#define UART1FR (*(volatile unsigned long *)0xFFFC1018)
#define UART1FR_OFFSET 0x18

#define UART1ILPR (*(volatile unsigned long *)0xFFFC1020)
#define UART1ILPR_OFFSET 0x20

#define UART1IBRD (*(volatile unsigned long *)0xFFFC1024)
#define UART1IBRD_OFFSET 0x24

#define UART1FBRD (*(volatile unsigned long *)0xFFFC1028)
#define UART1FBRD_OFFSET 0x28

#define UART1LCR_H (*(volatile unsigned long *)0xFFFC102C)
#define UART1LCR_H_OFFSET 0x2C

#define UART1CR (*(volatile unsigned long *)0xFFFC1030)
#define UART1CR_OFFSET 0x30

#define UART1IFLS (*(volatile unsigned long *)0xFFFC1034)
#define UART1IFLS_OFFSET 0x34

#define UART1IMSC (*(volatile unsigned long *)0xFFFC1038)
#define UART1IMSC_OFFSET 0x38

#define UART1RIS (*(volatile unsigned long *)0xFFFC103C)
#define UART1RIS_OFFSET 0x3C

#define UART1MIS (*(volatile unsigned long *)0xFFFC1040)
#define UART1MIS_OFFSET 0x40

#define UART1ICR (*(volatile unsigned long *)0xFFFC1044)
#define UART1ICR_OFFSET 0x44

#define UART1TCR (*(volatile unsigned long *)0xFFFC1080)
#define UART1TCR_OFFSET 0x80

#define UART2_BASE 0xFFFC2000

#define UART2DR (*(volatile unsigned long *)0xFFFC2000)
#define UART2DR_OFFSET 0x0

#define UART2RSR (*(volatile unsigned long *)0xFFFC2004)
#define UART2RSR_OFFSET 0x4

#define UART2ECR (*(volatile unsigned long *)0xFFFC2004)
#define UART2ECR_OFFSET 0x4

#define UART2FR (*(volatile unsigned long *)0xFFFC2018)
#define UART2FR_OFFSET 0x18

#define UART2ILPR (*(volatile unsigned long *)0xFFFC2020)
#define UART2ILPR_OFFSET 0x20

#define UART2IBRD (*(volatile unsigned long *)0xFFFC2024)
#define UART2IBRD_OFFSET 0x24

#define UART2FBRD (*(volatile unsigned long *)0xFFFC2028)
#define UART2FBRD_OFFSET 0x28

#define UART2LCR_H (*(volatile unsigned long *)0xFFFC202C)
#define UART2LCR_H_OFFSET 0x2C

#define UART2CR (*(volatile unsigned long *)0xFFFC2030)
#define UART2CR_OFFSET 0x30

#define UART2IFLS (*(volatile unsigned long *)0xFFFC2034)
#define UART2IFLS_OFFSET 0x34

#define UART2IMSC (*(volatile unsigned long *)0xFFFC2038)
#define UART2IMSC_OFFSET 0x38

#define UART2RIS (*(volatile unsigned long *)0xFFFC203C)
#define UART2RIS_OFFSET 0x3C

#define UART2MIS (*(volatile unsigned long *)0xFFFC2040)
#define UART2MIS_OFFSET 0x40

#define UART2ICR (*(volatile unsigned long *)0xFFFC2044)
#define UART2ICR_OFFSET 0x44

#define UART2TCR (*(volatile unsigned long *)0xFFFC2080)
#define UART2TCR_OFFSET 0x80

#define PWM_BASE 0xFFFC3000

#define PWM0_TC (*(volatile unsigned long *)0xFFFC3000)
#define PWM0_TC_OFFSET 0x0

#define PWM0_DC (*(volatile unsigned long *)0xFFFC3004)
#define PWM0_DC_OFFSET 0x4

#define PWM0_EN (*(volatile unsigned long *)0xFFFC3008)
#define PWM0_EN_OFFSET 0x8

#define PWM0_INV (*(volatile unsigned long *)0xFFFC300C)
#define PWM0_INV_OFFSET 0xC

#define PWM0_SYNC (*(volatile unsigned long *)0xFFFC3010)
#define PWM0_SYNC_OFFSET 0x10

#define PWM1_TC (*(volatile unsigned long *)0xFFFC3020)
#define PWM1_TC_OFFSET 0x20

#define PWM1_DC (*(volatile unsigned long *)0xFFFC3024)
#define PWM1_DC_OFFSET 0x24

#define PWM1_EN (*(volatile unsigned long *)0xFFFC3028)
#define PWM1_EN_OFFSET 0x28

#define PWM1_INV (*(volatile unsigned long *)0xFFFC302C)
#define PWM1_INV_OFFSET 0x2C

#define TIMER0_BASE 0xFFFC4000

#define TIMER0Load (*(volatile unsigned long *)0xFFFC4000)
#define TIMER0Load_OFFSET 0x0

#define TIMER0Value (*(volatile unsigned long *)0xFFFC4004)
#define TIMER0Value_OFFSET 0x4

#define TIMER0Control (*(volatile unsigned long *)0xFFFC4008)
#define TIMER0Control_OFFSET 0x8

#define TIMER0Clear (*(volatile unsigned long *)0xFFFC400C)
#define TIMER0Clear_OFFSET 0xC

#define TIMER1_BASE 0xFFFC4020

#define TIMER1Load (*(volatile unsigned long *)0xFFFC4020)
#define TIMER1Load_OFFSET 0x0

#define TIMER1Value (*(volatile unsigned long *)0xFFFC4024)
#define TIMER1Value_OFFSET 0x4

#define TIMER1Control (*(volatile unsigned long *)0xFFFC4028)
#define TIMER1Control_OFFSET 0x8

#define TIMER1Clear (*(volatile unsigned long *)0xFFFC402C)
#define TIMER1Clear_OFFSET 0xC

#define TIMER2_BASE 0xFFFC5000

#define TIMER2Load (*(volatile unsigned long *)0xFFFC5000)
#define TIMER2Load_OFFSET 0x0

#define TIMER2Value (*(volatile unsigned long *)0xFFFC5004)
#define TIMER2Value_OFFSET 0x4

#define TIMER2Control (*(volatile unsigned long *)0xFFFC5008)
#define TIMER2Control_OFFSET 0x8

#define TIMER2Clear (*(volatile unsigned long *)0xFFFC500C)
#define TIMER2Clear_OFFSET 0xC

#define TIMER3_BASE 0xFFFC5020

#define TIMER3Load (*(volatile unsigned long *)0xFFFC5020)
#define TIMER3Load_OFFSET 0x0

#define TIMER3Value (*(volatile unsigned long *)0xFFFC5024)
#define TIMER3Value_OFFSET 0x4

#define TIMER3Control (*(volatile unsigned long *)0xFFFC5028)
#define TIMER3Control_OFFSET 0x8

#define TIMER3Clear (*(volatile unsigned long *)0xFFFC502C)
#define TIMER3Clear_OFFSET 0xC

#define SSP_BASE 0xFFFC6000

#define SSPCR0 (*(volatile unsigned long *)0xFFFC6000)
#define SSPCR0_OFFSET 0x0

#define SSPCR1 (*(volatile unsigned long *)0xFFFC6004)
#define SSPCR1_OFFSET 0x4

#define SSPDR (*(volatile unsigned long *)0xFFFC6008)
#define SSPDR_OFFSET 0x8

#define SSPSR (*(volatile unsigned long *)0xFFFC600C)
#define SSPSR_OFFSET 0xC

#define SSPCPSR (*(volatile unsigned long *)0xFFFC6010)
#define SSPCPSR_OFFSET 0x10

#define SSPIIR (*(volatile unsigned long *)0xFFFC6014)
#define SSPIIR_OFFSET 0x14

#define SSPICR (*(volatile unsigned long *)0xFFFC6014)
#define SSPICR_OFFSET 0x14

#define SSPRXTO (*(volatile unsigned long *)0xFFFC6018)
#define SSPRXTO_OFFSET 0x18

#define GPIO_BASE 0xFFFDC000

#define GPIOPGDR (*(volatile unsigned long *)0xFFFDC000)
#define GPIOPGDR_OFFSET 0x0

#define GPIOPHDR (*(volatile unsigned long *)0xFFFDC004)
#define GPIOPHDR_OFFSET 0x4

#define GPIOPGDDR (*(volatile unsigned long *)0xFFFDC008)
#define GPIOPGDDR_OFFSET 0x8

#define GPIOPHDDR (*(volatile unsigned long *)0xFFFDC00C)
#define GPIOPHDDR_OFFSET 0xC

#define GPIOPEDR (*(volatile unsigned long *)0xFFFDD000)
#define GPIOPEDR_OFFSET 0x1000

#define GPIOPFDR (*(volatile unsigned long *)0xFFFDD004)
#define GPIOPFDR_OFFSET 0x1004

#define GPIOPEDDR (*(volatile unsigned long *)0xFFFDD008)
#define GPIOPEDDR_OFFSET 0x1008

#define GPIOPFDDR (*(volatile unsigned long *)0xFFFDD00C)
#define GPIOPFDDR_OFFSET 0x100C

#define GPIOPCDR (*(volatile unsigned long *)0xFFFDE000)
#define GPIOPCDR_OFFSET 0x2000

#define GPIOPDDR (*(volatile unsigned long *)0xFFFDE004)
#define GPIOPDDR_OFFSET 0x2004

#define GPIOPCDDR (*(volatile unsigned long *)0xFFFDE008)
#define GPIOPCDDR_OFFSET 0x2008

#define GPIOPDDDR (*(volatile unsigned long *)0xFFFDE00C)
#define GPIOPDDDR_OFFSET 0x200C

#define GPIOPADR (*(volatile unsigned long *)0xFFFDF000)
#define GPIOPADR_OFFSET 0x3000

#define GPIOPBDR (*(volatile unsigned long *)0xFFFDF004)
#define GPIOPBDR_OFFSET 0x3004

#define GPIOPADDR (*(volatile unsigned long *)0xFFFDF008)
#define GPIOPADDR_OFFSET 0x3008

#define GPIOPBDDR (*(volatile unsigned long *)0xFFFDF00C)
#define GPIOPBDDR_OFFSET 0x300C

#define RTC_BASE 0xFFFE0000

#define RTCDR (*(volatile unsigned long *)0xFFFE0000)
#define RTCDR_OFFSET 0x0

#define RTCMR (*(volatile unsigned long *)0xFFFE0004)
#define RTCMR_OFFSET 0x4

#define RTCSTAT (*(volatile unsigned long *)0xFFFE0008)
#define RTCSTAT_OFFSET 0x8

#define RTCEOI (*(volatile unsigned long *)0xFFFE0008)
#define RTCEOI_OFFSET 0x8

#define RTCLR (*(volatile unsigned long *)0xFFFE000C)
#define RTCLR_OFFSET 0xC

#define RTCCR (*(volatile unsigned long *)0xFFFE0010)
#define RTCCR_OFFSET 0x10

#define DMA_BASE 0xFFFE1000

#define DMA0SourceLo (*(volatile unsigned long *)0xFFFE1000)
#define DMA0SourceLo_OFFSET 0x0

#define DMA0SourceHi (*(volatile unsigned long *)0xFFFE1004)
#define DMA0SourceHi_OFFSET 0x4

#define DMA0DestLo (*(volatile unsigned long *)0xFFFE1008)
#define DMA0DestLo_OFFSET 0x8

#define DMA0DestHi (*(volatile unsigned long *)0xFFFE100C)
#define DMA0DestHi_OFFSET 0xC

#define DMA0Max (*(volatile unsigned long *)0xFFFE1010)
#define DMA0Max_OFFSET 0x10

#define DMA0Ctrl (*(volatile unsigned long *)0xFFFE1014)
#define DMA0Ctrl_OFFSET 0x14

#define DMA0SoCurrHi (*(volatile unsigned long *)0xFFFE1018)
#define DMA0SoCurrHi_OFFSET 0x18

#define DMA0SoCurrLo (*(volatile unsigned long *)0xFFFE101C)
#define DMA0SoCurrLo_OFFSET 0x1C

#define DMA0DeCurrHi (*(volatile unsigned long *)0xFFFE1020)
#define DMA0DeCurrHi_OFFSET 0x20

#define DMA0DeCurrLo (*(volatile unsigned long *)0xFFFE1024)
#define DMA0DeCurrLo_OFFSET 0x24

#define DMA0Tcnt (*(volatile unsigned long *)0xFFFE1028)
#define DMA0Tcnt_OFFSET 0x28

#define DMA1SourceLo (*(volatile unsigned long *)0xFFFE1040)
#define DMA1SourceLo_OFFSET 0x40

#define DMA1SourceHi (*(volatile unsigned long *)0xFFFE1044)
#define DMA1SourceHi_OFFSET 0x44

#define DMA1DestLo (*(volatile unsigned long *)0xFFFE1048)
#define DMA1DestLo_OFFSET 0x48

#define DMA1DestHi (*(volatile unsigned long *)0xFFFE104C)
#define DMA1DestHi_OFFSET 0x4C

#define DMA1Max (*(volatile unsigned long *)0xFFFE1050)
#define DMA1Max_OFFSET 0x50

#define DMA1Ctrl (*(volatile unsigned long *)0xFFFE1054)
#define DMA1Ctrl_OFFSET 0x54

#define DMA1SoCurrHi (*(volatile unsigned long *)0xFFFE1058)
#define DMA1SoCurrHi_OFFSET 0x58

#define DMA1SoCurrLo (*(volatile unsigned long *)0xFFFE105C)
#define DMA1SoCurrLo_OFFSET 0x5C

#define DMA1DeCurrHi (*(volatile unsigned long *)0xFFFE1060)
#define DMA1DeCurrHi_OFFSET 0x60

#define DMA1DeCurrLo (*(volatile unsigned long *)0xFFFE1064)
#define DMA1DeCurrLo_OFFSET 0x64

#define DMA1Tcnt (*(volatile unsigned long *)0xFFFE1068)
#define DMA1Tcnt_OFFSET 0x68

#define DMA2SourceLo (*(volatile unsigned long *)0xFFFE1080)
#define DMA2SourceLo_OFFSET 0x80

#define DMA2SourceHi (*(volatile unsigned long *)0xFFFE1084)
#define DMA2SourceHi_OFFSET 0x84

#define DMA2DestLo (*(volatile unsigned long *)0xFFFE1088)
#define DMA2DestLo_OFFSET 0x88

#define DMA2DestHi (*(volatile unsigned long *)0xFFFE108C)
#define DMA2DestHi_OFFSET 0x8C

#define DMA2Max (*(volatile unsigned long *)0xFFFE1090)
#define DMA2Max_OFFSET 0x90

#define DMA2Ctrl (*(volatile unsigned long *)0xFFFE1094)
#define DMA2Ctrl_OFFSET 0x94

#define DMA2SoCurrHi (*(volatile unsigned long *)0xFFFE1098)
#define DMA2SoCurrHi_OFFSET 0x98

#define DMA2SoCurrLo (*(volatile unsigned long *)0xFFFE109C)
#define DMA2SoCurrLo_OFFSET 0x9C

#define DMA2DeCurrHi (*(volatile unsigned long *)0xFFFE10A0)
#define DMA2DeCurrHi_OFFSET 0xA0

#define DMA2DeCurrLo (*(volatile unsigned long *)0xFFFE10A4)
#define DMA2DeCurrLo_OFFSET 0xA4

#define DMA2Tcnt (*(volatile unsigned long *)0xFFFE10A8)
#define DMA2Tcnt_OFFSET 0xA8

#define DMA3SourceLo (*(volatile unsigned long *)0xFFFE10C0)
#define DMA3SourceLo_OFFSET 0xC0

#define DMA3SourceHi (*(volatile unsigned long *)0xFFFE10C4)
#define DMA3SourceHi_OFFSET 0xC4

#define DMA3DestLo (*(volatile unsigned long *)0xFFFE10C8)
#define DMA3DestLo_OFFSET 0xC8

#define DMA3DestHi (*(volatile unsigned long *)0xFFFE10CC)
#define DMA3DestHi_OFFSET 0xCC

#define DMA3Max (*(volatile unsigned long *)0xFFFE10D0)
#define DMA3Max_OFFSET 0xD0

#define DMA3Ctrl (*(volatile unsigned long *)0xFFFE10D4)
#define DMA3Ctrl_OFFSET 0xD4

#define DMA3SoCurrHi (*(volatile unsigned long *)0xFFFE10D8)
#define DMA3SoCurrHi_OFFSET 0xD8

#define DMA3SoCurrLo (*(volatile unsigned long *)0xFFFE10DC)
#define DMA3SoCurrLo_OFFSET 0xDC

#define DMA3DeCurrHi (*(volatile unsigned long *)0xFFFE10E0)
#define DMA3DeCurrHi_OFFSET 0xE0

#define DMA3DeCurrLo (*(volatile unsigned long *)0xFFFE10E4)
#define DMA3DeCurrLo_OFFSET 0xE4

#define DMA3Tcnt (*(volatile unsigned long *)0xFFFE10E8)
#define DMA3Tcnt_OFFSET 0xE8

#define DMAMask (*(volatile unsigned long *)0xFFFE10F0)
#define DMAMask_OFFSET 0xF0

#define DMAClr (*(volatile unsigned long *)0xFFFE10F4)
#define DMAClr_OFFSET 0xF4

#define DMAStatus (*(volatile unsigned long *)0xFFFE10F8)
#define DMAStatus_OFFSET 0xF8

#define RCPC_BASE 0xFFFE2000

#define RCPCCtrl (*(volatile unsigned long *)0xFFFE2000)
#define RCPCCtrl_OFFSET 0x0

#define RCPCRemapCtrl (*(volatile unsigned long *)0xFFFE2008)
#define RCPCRemapCtrl_OFFSET 0x8

#define SoftReset (*(volatile unsigned long *)0xFFFE200C)
#define SoftReset_OFFSET 0xC

#define ResetStatus (*(volatile unsigned long *)0xFFFE2010)
#define ResetStatus_OFFSET 0x10

#define ResetStatusClear (*(volatile unsigned long *)0xFFFE2014)
#define ResetStatusClear_OFFSET 0x14

#define HclkPrescale (*(volatile unsigned long *)0xFFFE2018)
#define HclkPrescale_OFFSET 0x18

#define CpuClkPrescale (*(volatile unsigned long *)0xFFFE201C)
#define CpuClkPrescale_OFFSET 0x1C

#define PeriphClkCtrl (*(volatile unsigned long *)0xFFFE2024)
#define PeriphClkCtrl_OFFSET 0x24

#define PeriphClkCtrl2 (*(volatile unsigned long *)0xFFFE2028)
#define PeriphClkCtrl2_OFFSET 0x28

#define AHBClkCtrl (*(volatile unsigned long *)0xFFFE202C)
#define AHBClkCtrl_OFFSET 0x2C

#define PeriphClkSelect (*(volatile unsigned long *)0xFFFE2030)
#define PeriphClkSelect_OFFSET 0x30

#define PeriphClkSelect2 (*(volatile unsigned long *)0xFFFE2034)
#define PeriphClkSelect2_OFFSET 0x34

#define PWM0Prescale (*(volatile unsigned long *)0xFFFE2038)
#define PWM0Prescale_OFFSET 0x38

#define PWM1Prescale (*(volatile unsigned long *)0xFFFE203C)
#define PWM1Prescale_OFFSET 0x3C

#define LCDClkPrescale (*(volatile unsigned long *)0xFFFE2040)
#define LCDClkPrescale_OFFSET 0x40

#define SSPClkPrescale (*(volatile unsigned long *)0xFFFE2044)
#define SSPClkPrescale_OFFSET 0x44

#define IntConfig (*(volatile unsigned long *)0xFFFE2080)
#define IntConfig_OFFSET 0x80

#define IntClear (*(volatile unsigned long *)0xFFFE2084)
#define IntClear_OFFSET 0x84

#define CoreClkConfig (*(volatile unsigned long *)0xFFFE2088)
#define CoreClkConfig_OFFSET 0x88

#define WDT_BASE 0xFFFE3000

#define WDCTLR (*(volatile unsigned long *)0xFFFE3000)
#define WDCTLR_OFFSET 0x0

#define WDCNTR (*(volatile unsigned long *)0xFFFE3004)
#define WDCNTR_OFFSET 0x4

#define WDTSTR (*(volatile unsigned long *)0xFFFE3008)
#define WDTSTR_OFFSET 0x8

#define WDCNT0 (*(volatile unsigned long *)0xFFFE300C)
#define WDCNT0_OFFSET 0xC

#define WDCNT1 (*(volatile unsigned long *)0xFFFE3010)
#define WDCNT1_OFFSET 0x10

#define WDCNT2 (*(volatile unsigned long *)0xFFFE3014)
#define WDCNT2_OFFSET 0x14

#define WDCNT3 (*(volatile unsigned long *)0xFFFE3018)
#define WDCNT3_OFFSET 0x18

#define HRTFTC_BASE 0xFFFE4000

#define HRTFTCSetup (*(volatile unsigned long *)0xFFFE4000)
#define HRTFTCSetup_OFFSET 0x0

#define HRTFTCControl (*(volatile unsigned long *)0xFFFE4004)
#define HRTFTCControl_OFFSET 0x4

#define HRTFTCTiming1 (*(volatile unsigned long *)0xFFFE4008)
#define HRTFTCTiming1_OFFSET 0x8

#define HRTFTCTiming2 (*(volatile unsigned long *)0xFFFE400C)
#define HRTFTCTiming2_OFFSET 0xC

#define IOCON_BASE 0xFFFE5000

#define MemMux (*(volatile unsigned long *)0xFFFE5000)
#define MemMux_OFFSET 0x0

#define LCDMux (*(volatile unsigned long *)0xFFFE5004)
#define LCDMux_OFFSET 0x4

#define MiscMux (*(volatile unsigned long *)0xFFFE5008)
#define MiscMux_OFFSET 0x8

#define DMAMux (*(volatile unsigned long *)0xFFFE500C)
#define DMAMux_OFFSET 0xC

#define UARTMux (*(volatile unsigned long *)0xFFFE5010)
#define UARTMux_OFFSET 0x10

#define SSPMux (*(volatile unsigned long *)0xFFFE5014)
#define SSPMux_OFFSET 0x14

#define SMC_BASE 0xFFFF1000

#define SMCBCR0 (*(volatile unsigned long *)0xFFFF1000)
#define SMCBCR0_OFFSET 0x0

#define SMCBCR1 (*(volatile unsigned long *)0xFFFF1004)
#define SMCBCR1_OFFSET 0x4

#define SMCBCR2 (*(volatile unsigned long *)0xFFFF1008)
#define SMCBCR2_OFFSET 0x8

#define SMCBCR3 (*(volatile unsigned long *)0xFFFF100C)
#define SMCBCR3_OFFSET 0xC

#define SMCBCR4 (*(volatile unsigned long *)0xFFFF1010)
#define SMCBCR4_OFFSET 0x10

#define SMCBCR5 (*(volatile unsigned long *)0xFFFF1014)
#define SMCBCR5_OFFSET 0x14

#define SMCBCR6 (*(volatile unsigned long *)0xFFFF1018)
#define SMCBCR6_OFFSET 0x18

#define SDRC_BASE 0xFFFF2000

#define SDRCConfig0 (*(volatile unsigned long *)0xFFFF2000)
#define SDRCConfig0_OFFSET 0x0

#define SDRCConfig1 (*(volatile unsigned long *)0xFFFF2004)
#define SDRCConfig1_OFFSET 0x4

#define SDRCRefTimer (*(volatile unsigned long *)0xFFFF2008)
#define SDRCRefTimer_OFFSET 0x8

#define SDRCWBTimeout (*(volatile unsigned long *)0xFFFF200C)
#define SDRCWBTimeout_OFFSET 0xC

#define LCD_BASE 0xFFFF4000

#define LCDTiming0 (*(volatile unsigned long *)0xFFFF4000)
#define LCDTiming0_OFFSET 0x0

#define LCDTiming1 (*(volatile unsigned long *)0xFFFF4004)
#define LCDTiming1_OFFSET 0x4

#define LCDTiming2 (*(volatile unsigned long *)0xFFFF4008)
#define LCDTiming2_OFFSET 0x8

#define LCDUPBASE (*(volatile unsigned long *)0xFFFF4010)
#define LCDUPBASE_OFFSET 0x10

#define LCDLPBASE (*(volatile unsigned long *)0xFFFF4014)
#define LCDLPBASE_OFFSET 0x14

#define LCDINTRENABLE (*(volatile unsigned long *)0xFFFF4018)
#define LCDINTRENABLE_OFFSET 0x18

#define LCDControl (*(volatile unsigned long *)0xFFFF401C)
#define LCDControl_OFFSET 0x1C

#define LCDStatus (*(volatile unsigned long *)0xFFFF4020)
#define LCDStatus_OFFSET 0x20

#define LCDInterrupt (*(volatile unsigned long *)0xFFFF4024)
#define LCDInterrupt_OFFSET 0x24

#define LCDUPCURR (*(volatile unsigned long *)0xFFFF4028)
#define LCDUPCURR_OFFSET 0x28

#define LCDLPCURR (*(volatile unsigned long *)0xFFFF402C)
#define LCDLPCURR_OFFSET 0x2C

#define VIC_BASE 0xFFFFF000

#define IRQStatus (*(volatile unsigned long *)0xFFFFF000)
#define IRQStatus_OFFSET 0x0

#define FIQStatus (*(volatile unsigned long *)0xFFFFF004)
#define FIQStatus_OFFSET 0x4

#define RawInterrupt (*(volatile unsigned long *)0xFFFFF008)
#define RawInterrupt_OFFSET 0x8

#define IntSelect (*(volatile unsigned long *)0xFFFFF00C)
#define IntSelect_OFFSET 0xC

#define IntEnable (*(volatile unsigned long *)0xFFFFF010)
#define IntEnable_OFFSET 0x10

#define IntEnableClear (*(volatile unsigned long *)0xFFFFF014)
#define IntEnableClear_OFFSET 0x14

#define SoftInt (*(volatile unsigned long *)0xFFFFF018)
#define SoftInt_OFFSET 0x18

#define SoftIntClear (*(volatile unsigned long *)0xFFFFF01C)
#define SoftIntClear_OFFSET 0x1C

#define VectorAddr (*(volatile unsigned long *)0xFFFFF030)
#define VectorAddr_OFFSET 0x30

#define DefVecAddr (*(volatile unsigned long *)0xFFFFF034)
#define DefVecAddr_OFFSET 0x34

#define VectAddr0 (*(volatile unsigned long *)0xFFFFF100)
#define VectAddr0_OFFSET 0x100

#define VectAddr1 (*(volatile unsigned long *)0xFFFFF104)
#define VectAddr1_OFFSET 0x104

#define VectAddr2 (*(volatile unsigned long *)0xFFFFF108)
#define VectAddr2_OFFSET 0x108

#define VectAddr3 (*(volatile unsigned long *)0xFFFFF10C)
#define VectAddr3_OFFSET 0x10C

#define VectAddr4 (*(volatile unsigned long *)0xFFFFF110)
#define VectAddr4_OFFSET 0x110

#define VectAddr5 (*(volatile unsigned long *)0xFFFFF114)
#define VectAddr5_OFFSET 0x114

#define VectAddr6 (*(volatile unsigned long *)0xFFFFF118)
#define VectAddr6_OFFSET 0x118

#define VectAddr7 (*(volatile unsigned long *)0xFFFFF11C)
#define VectAddr7_OFFSET 0x11C

#define VectAddr8 (*(volatile unsigned long *)0xFFFFF120)
#define VectAddr8_OFFSET 0x120

#define VectAddr9 (*(volatile unsigned long *)0xFFFFF124)
#define VectAddr9_OFFSET 0x124

#define VectAddr10 (*(volatile unsigned long *)0xFFFFF128)
#define VectAddr10_OFFSET 0x128

#define VectAddr11 (*(volatile unsigned long *)0xFFFFF12C)
#define VectAddr11_OFFSET 0x12C

#define VectAddr12 (*(volatile unsigned long *)0xFFFFF130)
#define VectAddr12_OFFSET 0x130

#define VectAddr13 (*(volatile unsigned long *)0xFFFFF134)
#define VectAddr13_OFFSET 0x134

#define VectAddr14 (*(volatile unsigned long *)0xFFFFF138)
#define VectAddr14_OFFSET 0x138

#define VectAddr15 (*(volatile unsigned long *)0xFFFFF13C)
#define VectAddr15_OFFSET 0x13C

#define VectCntl0 (*(volatile unsigned long *)0xFFFFF200)
#define VectCntl0_OFFSET 0x200

#define VectCntl1 (*(volatile unsigned long *)0xFFFFF204)
#define VectCntl1_OFFSET 0x204

#define VectCntl2 (*(volatile unsigned long *)0xFFFFF208)
#define VectCntl2_OFFSET 0x208

#define VectCntl3 (*(volatile unsigned long *)0xFFFFF20C)
#define VectCntl3_OFFSET 0x20C

#define VectCntl4 (*(volatile unsigned long *)0xFFFFF210)
#define VectCntl4_OFFSET 0x210

#define VectCntl5 (*(volatile unsigned long *)0xFFFFF214)
#define VectCntl5_OFFSET 0x214

#define VectCntl6 (*(volatile unsigned long *)0xFFFFF218)
#define VectCntl6_OFFSET 0x218

#define VectCntl7 (*(volatile unsigned long *)0xFFFFF21C)
#define VectCntl7_OFFSET 0x21C

#define VectCntl8 (*(volatile unsigned long *)0xFFFFF220)
#define VectCntl8_OFFSET 0x220

#define VectCntl9 (*(volatile unsigned long *)0xFFFFF224)
#define VectCntl9_OFFSET 0x224

#define VectCntl10 (*(volatile unsigned long *)0xFFFFF228)
#define VectCntl10_OFFSET 0x228

#define VectCntl11 (*(volatile unsigned long *)0xFFFFF22C)
#define VectCntl11_OFFSET 0x22C

#define VectCntl12 (*(volatile unsigned long *)0xFFFFF230)
#define VectCntl12_OFFSET 0x230

#define VectCntl13 (*(volatile unsigned long *)0xFFFFF234)
#define VectCntl13_OFFSET 0x234

#define VectCntl14 (*(volatile unsigned long *)0xFFFFF238)
#define VectCntl14_OFFSET 0x238

#define VectCntl15 (*(volatile unsigned long *)0xFFFFF23C)
#define VectCntl15_OFFSET 0x23C

#define ITOP1 (*(volatile unsigned long *)0xFFFFF30C)
#define ITOP1_OFFSET 0x30C


#endif
