// AT91SAM7A2 register and bit definitions.
//
// Copyright (c) 2005 Rowley Associates Limited.
//
// This file may be distributed under the terms of the License Agreement
// provided with this software.
//
// THIS FILE IS PROVIDED AS IS WITH NO WARRANTY OF ANY KIND, INCLUDING THE
// WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.

#ifndef AT91SAM7A2_h
#define AT91SAM7A2_h

#define AMC_BASE 0xFFE00000

#define AMC_CSR0 (*(volatile unsigned long *)0xFFE00000)
#define AMC_CSR0_OFFSET 0x0
#define AMC_CSR0_DBW_MASK 0x3U
#define AMC_CSR0_DBW_BIT 0
#define AMC_CSR0_NWS_MASK 0x1CU
#define AMC_CSR0_NWS_BIT 2
#define AMC_CSR0_WSE_MASK 0x20U
#define AMC_CSR0_WSE 0x20U
#define AMC_CSR0_WSE_BIT 5
#define AMC_CSR0_PAGES0_MASK 0x80U
#define AMC_CSR0_PAGES0 0x80U
#define AMC_CSR0_PAGES0_BIT 7
#define AMC_CSR0_PAGES1_MASK 0x100U
#define AMC_CSR0_PAGES1 0x100U
#define AMC_CSR0_PAGES1_BIT 8
#define AMC_CSR0_TDF_MASK 0xE00U
#define AMC_CSR0_TDF_BIT 9
#define AMC_CSR0_BAT_MASK 0x1000U
#define AMC_CSR0_BAT 0x1000U
#define AMC_CSR0_BAT_BIT 12
#define AMC_CSR0_CSEN_MASK 0x2000U
#define AMC_CSR0_CSEN 0x2000U
#define AMC_CSR0_CSEN_BIT 13
#define AMC_CSR0_BA_MASK 0x3FF00000U
#define AMC_CSR0_BA_BIT 20

#define AMC_CSR1 (*(volatile unsigned long *)0xFFE00004)
#define AMC_CSR1_OFFSET 0x4
#define AMC_CSR1_DBW_MASK 0x3U
#define AMC_CSR1_DBW_BIT 0
#define AMC_CSR1_NWS_MASK 0x1CU
#define AMC_CSR1_NWS_BIT 2
#define AMC_CSR1_WSE_MASK 0x20U
#define AMC_CSR1_WSE 0x20U
#define AMC_CSR1_WSE_BIT 5
#define AMC_CSR1_PAGES0_MASK 0x80U
#define AMC_CSR1_PAGES0 0x80U
#define AMC_CSR1_PAGES0_BIT 7
#define AMC_CSR1_PAGES1_MASK 0x100U
#define AMC_CSR1_PAGES1 0x100U
#define AMC_CSR1_PAGES1_BIT 8
#define AMC_CSR1_TDF_MASK 0xE00U
#define AMC_CSR1_TDF_BIT 9
#define AMC_CSR1_BAT_MASK 0x1000U
#define AMC_CSR1_BAT 0x1000U
#define AMC_CSR1_BAT_BIT 12
#define AMC_CSR1_CSEN_MASK 0x2000U
#define AMC_CSR1_CSEN 0x2000U
#define AMC_CSR1_CSEN_BIT 13
#define AMC_CSR1_BA_MASK 0x3FF00000U
#define AMC_CSR1_BA_BIT 20

#define AMC_CSR2 (*(volatile unsigned long *)0xFFE00008)
#define AMC_CSR2_OFFSET 0x8
#define AMC_CSR2_DBW_MASK 0x3U
#define AMC_CSR2_DBW_BIT 0
#define AMC_CSR2_NWS_MASK 0x1CU
#define AMC_CSR2_NWS_BIT 2
#define AMC_CSR2_WSE_MASK 0x20U
#define AMC_CSR2_WSE 0x20U
#define AMC_CSR2_WSE_BIT 5
#define AMC_CSR2_PAGES0_MASK 0x80U
#define AMC_CSR2_PAGES0 0x80U
#define AMC_CSR2_PAGES0_BIT 7
#define AMC_CSR2_PAGES1_MASK 0x100U
#define AMC_CSR2_PAGES1 0x100U
#define AMC_CSR2_PAGES1_BIT 8
#define AMC_CSR2_TDF_MASK 0xE00U
#define AMC_CSR2_TDF_BIT 9
#define AMC_CSR2_BAT_MASK 0x1000U
#define AMC_CSR2_BAT 0x1000U
#define AMC_CSR2_BAT_BIT 12
#define AMC_CSR2_CSEN_MASK 0x2000U
#define AMC_CSR2_CSEN 0x2000U
#define AMC_CSR2_CSEN_BIT 13
#define AMC_CSR2_BA_MASK 0x3FF00000U
#define AMC_CSR2_BA_BIT 20

#define AMC_CSR3 (*(volatile unsigned long *)0xFFE0001C)
#define AMC_CSR3_OFFSET 0x1C
#define AMC_CSR3_DBW_MASK 0x3U
#define AMC_CSR3_DBW_BIT 0
#define AMC_CSR3_NWS_MASK 0x1CU
#define AMC_CSR3_NWS_BIT 2
#define AMC_CSR3_WSE_MASK 0x20U
#define AMC_CSR3_WSE 0x20U
#define AMC_CSR3_WSE_BIT 5
#define AMC_CSR3_PAGES0_MASK 0x80U
#define AMC_CSR3_PAGES0 0x80U
#define AMC_CSR3_PAGES0_BIT 7
#define AMC_CSR3_PAGES1_MASK 0x100U
#define AMC_CSR3_PAGES1 0x100U
#define AMC_CSR3_PAGES1_BIT 8
#define AMC_CSR3_TDF_MASK 0xE00U
#define AMC_CSR3_TDF_BIT 9
#define AMC_CSR3_BAT_MASK 0x1000U
#define AMC_CSR3_BAT 0x1000U
#define AMC_CSR3_BAT_BIT 12
#define AMC_CSR3_CSEN_MASK 0x2000U
#define AMC_CSR3_CSEN 0x2000U
#define AMC_CSR3_CSEN_BIT 13
#define AMC_CSR3_BA_MASK 0x3FF00000U
#define AMC_CSR3_BA_BIT 20

#define AMC_RCR (*(volatile unsigned long *)0xFFE00020)
#define AMC_RCR_OFFSET 0x20
#define AMC_RCR_RCB_MASK 0x1U
#define AMC_RCR_RCB 0x1U
#define AMC_RCR_RCB_BIT 0

#define AMC_MCR (*(volatile unsigned long *)0xFFE00024)
#define AMC_MCR_OFFSET 0x24
#define AMC_MCR_ALE_MASK 0x7U
#define AMC_MCR_ALE_BIT 0
#define AMC_MCR_DRP_MASK 0x10U
#define AMC_MCR_DRP 0x10U
#define AMC_MCR_DRP_BIT 4

#define SFM_BASE 0xFFF00000

#define SFM_CIDR (*(volatile unsigned long *)0xFFF00000)
#define SFM_CIDR_OFFSET 0x0
#define SFM_CIDR_NVPMS_MASK 0xFU
#define SFM_CIDR_NVPMS_BIT 0
#define SFM_CIDR_NVDMS_MASK 0xF0U
#define SFM_CIDR_NVDMS_BIT 4
#define SFM_CIDR_IRS_MASK 0xF00U
#define SFM_CIDR_IRS_BIT 8
#define SFM_CIDR_NVPMT_MASK 0xF000U
#define SFM_CIDR_NVPMT_BIT 12
#define SFM_CIDR_ARCH_MASK 0xF0000U
#define SFM_CIDR_ARCH_BIT 16
#define SFM_CIDR_EXT_MASK 0x80000000U
#define SFM_CIDR_EXT 0x80000000U
#define SFM_CIDR_EXT_BIT 31

#define SFM_RSR (*(volatile unsigned long *)0xFFF00008)
#define SFM_RSR_OFFSET 0x8
#define SFM_RSR_RESET_MASK 0xFFU
#define SFM_RSR_RESET_BIT 0

#define WD_BASE 0xFFFA0000

#define WD_CR (*(volatile unsigned long *)0xFFFA0060)
#define WD_CR_OFFSET 0x60
#define WD_CR_RSTKEY_MASK 0xFFFFU
#define WD_CR_RSTKEY_BIT 0

#define WD_MR (*(volatile unsigned long *)0xFFFA0064)
#define WD_MR_OFFSET 0x64
#define WD_MR_WDPDIV_MASK 0x7U
#define WD_MR_WDPDIV_BIT 0
#define WD_MR_PCV_MASK 0xFFFF00U
#define WD_MR_PCV_BIT 8
#define WD_MR_CKEY_MASK 0xFF000000U
#define WD_MR_CKEY_BIT 24

#define WD_OMR (*(volatile unsigned long *)0xFFFA0068)
#define WD_OMR_OFFSET 0x68
#define WD_OMR_WDEN_MASK 0x1U
#define WD_OMR_WDEN 0x1U
#define WD_OMR_WDEN_BIT 0
#define WD_OMR_TSTEN_MASK 0x2U
#define WD_OMR_TSTEN 0x2U
#define WD_OMR_TSTEN_BIT 1
#define WD_OMR_OKEY_MASK 0xFFF0U
#define WD_OMR_OKEY_BIT 4

#define WD_CSR (*(volatile unsigned long *)0xFFFA006C)
#define WD_CSR_OFFSET 0x6C
#define WD_CSR_WDPEND_MASK 0x1U
#define WD_CSR_WDPEND 0x1U
#define WD_CSR_WDPEND_BIT 0
#define WD_CSR_WDOVF_MASK 0x2U
#define WD_CSR_WDOVF 0x2U
#define WD_CSR_WDOVF_BIT 1

#define WD_SR (*(volatile unsigned long *)0xFFFA006C)
#define WD_SR_OFFSET 0x6C
#define WD_SR_WDPEND_MASK 0x1U
#define WD_SR_WDPEND 0x1U
#define WD_SR_WDPEND_BIT 0
#define WD_SR_WDOVF_MASK 0x2U
#define WD_SR_WDOVF 0x2U
#define WD_SR_WDOVF_BIT 1
#define WD_SR_PENDING_MASK 0x100U
#define WD_SR_PENDING 0x100U
#define WD_SR_PENDING_BIT 8
#define WD_SR_RESTART_MASK 0x200U
#define WD_SR_RESTART 0x200U
#define WD_SR_RESTART_BIT 9

#define WD_IER (*(volatile unsigned long *)0xFFFA0074)
#define WD_IER_OFFSET 0x74
#define WD_IER_WDPEND_MASK 0x1U
#define WD_IER_WDPEND 0x1U
#define WD_IER_WDPEND_BIT 0
#define WD_IER_WDOVF_MASK 0x2U
#define WD_IER_WDOVF 0x2U
#define WD_IER_WDOVF_BIT 1

#define WD_IDR (*(volatile unsigned long *)0xFFFA0078)
#define WD_IDR_OFFSET 0x78
#define WD_IDR_WDPEND_MASK 0x1U
#define WD_IDR_WDPEND 0x1U
#define WD_IDR_WDPEND_BIT 0
#define WD_IDR_WDOVF_MASK 0x2U
#define WD_IDR_WDOVF 0x2U
#define WD_IDR_WDOVF_BIT 1

#define WD_IMR (*(volatile unsigned long *)0xFFFA007C)
#define WD_IMR_OFFSET 0x7C
#define WD_IMR_WDPEND_MASK 0x1U
#define WD_IMR_WDPEND 0x1U
#define WD_IMR_WDPEND_BIT 0
#define WD_IMR_WDOVF_MASK 0x2U
#define WD_IMR_WDOVF 0x2U
#define WD_IMR_WDOVF_BIT 1

#define WD_PWR (*(volatile unsigned long *)0xFFFA0080)
#define WD_PWR_OFFSET 0x80
#define WD_PWR_RSTALW_MASK 0x1U
#define WD_PWR_RSTALW 0x1U
#define WD_PWR_RSTALW_BIT 0
#define WD_PWR_PWL_MASK 0xFFFF00U
#define WD_PWR_PWL_BIT 8
#define WD_PWR_PWKEY_MASK 0xFF000000U
#define WD_PWR_PWKEY_BIT 24

#define WT_BASE 0xFFFA4000

#define WT_CR (*(volatile unsigned long *)0xFFFA4060)
#define WT_CR_OFFSET 0x60
#define WT_CR_SWRST_MASK 0x1U
#define WT_CR_SWRST 0x1U
#define WT_CR_SWRST_BIT 0
#define WT_CR_SECSEN_MASK 0x2U
#define WT_CR_SECSEN 0x2U
#define WT_CR_SECSEN_BIT 1
#define WT_CR_SECSDIS_MASK 0x4U
#define WT_CR_SECSDIS 0x4U
#define WT_CR_SECSDIS_BIT 2
#define WT_CR_ALARMEN_MASK 0x8U
#define WT_CR_ALARMEN 0x8U
#define WT_CR_ALARMEN_BIT 3
#define WT_CR_ALARMDIS_MASK 0x10U
#define WT_CR_ALARMDIS 0x10U
#define WT_CR_ALARMDIS_BIT 4

#define WT_MR (*(volatile unsigned long *)0xFFFA4064)
#define WT_MR_OFFSET 0x64
#define WT_MR_SECRST_MASK 0x1U
#define WT_MR_SECRST 0x1U
#define WT_MR_SECRST_BIT 0

#define WT_CSR (*(volatile unsigned long *)0xFFFA406C)
#define WT_CSR_OFFSET 0x6C
#define WT_CSR_ALARM_MASK 0x1U
#define WT_CSR_ALARM 0x1U
#define WT_CSR_ALARM_BIT 0
#define WT_CSR_SECSEN_MASK 0x2U
#define WT_CSR_SECSEN 0x2U
#define WT_CSR_SECSEN_BIT 1
#define WT_CSR_SECSDIS_MASK 0x4U
#define WT_CSR_SECSDIS 0x4U
#define WT_CSR_SECSDIS_BIT 2
#define WT_CSR_ALARMEN_MASK 0x8U
#define WT_CSR_ALARMEN 0x8U
#define WT_CSR_ALARMEN_BIT 3
#define WT_CSR_ALARMDIS_MASK 0x10U
#define WT_CSR_ALARMDIS 0x10U
#define WT_CSR_ALARMDIS_BIT 4

#define WT_SR (*(volatile unsigned long *)0xFFFA4070)
#define WT_SR_OFFSET 0x70
#define WT_SR_ALARM_MASK 0x1U
#define WT_SR_ALARM 0x1U
#define WT_SR_ALARM_BIT 0
#define WT_SR_SECSEN_MASK 0x2U
#define WT_SR_SECSEN 0x2U
#define WT_SR_SECSEN_BIT 1
#define WT_SR_SECSDIS_MASK 0x4U
#define WT_SR_SECSDIS 0x4U
#define WT_SR_SECSDIS_BIT 2
#define WT_SR_ALARMEN_MASK 0x8U
#define WT_SR_ALARMEN 0x8U
#define WT_SR_ALARMEN_BIT 3
#define WT_SR_ALARMDIS_MASK 0x10U
#define WT_SR_ALARMDIS 0x10U
#define WT_SR_ALARMDIS_BIT 4
#define WT_SR_WSEC_MASK 0x20U
#define WT_SR_WSEC 0x20U
#define WT_SR_WSEC_BIT 5
#define WT_SR_SECENS_MASK 0x100U
#define WT_SR_SECENS 0x100U
#define WT_SR_SECENS_BIT 8
#define WT_SR_ALARMENS_MASK 0x200U
#define WT_SR_ALARMENS 0x200U
#define WT_SR_ALARMENS_BIT 9

#define WT_IER (*(volatile unsigned long *)0xFFFA4074)
#define WT_IER_OFFSET 0x74
#define WT_IER_ALARM_MASK 0x1U
#define WT_IER_ALARM 0x1U
#define WT_IER_ALARM_BIT 0
#define WT_IER_SECSEN_MASK 0x2U
#define WT_IER_SECSEN 0x2U
#define WT_IER_SECSEN_BIT 1
#define WT_IER_SECSDIS_MASK 0x4U
#define WT_IER_SECSDIS 0x4U
#define WT_IER_SECSDIS_BIT 2
#define WT_IER_ALARMEN_MASK 0x8U
#define WT_IER_ALARMEN 0x8U
#define WT_IER_ALARMEN_BIT 3
#define WT_IER_ALARMDIS_MASK 0x10U
#define WT_IER_ALARMDIS 0x10U
#define WT_IER_ALARMDIS_BIT 4

#define WT_IDR (*(volatile unsigned long *)0xFFFA4078)
#define WT_IDR_OFFSET 0x78
#define WT_IDR_ALARM_MASK 0x1U
#define WT_IDR_ALARM 0x1U
#define WT_IDR_ALARM_BIT 0
#define WT_IDR_SECSEN_MASK 0x2U
#define WT_IDR_SECSEN 0x2U
#define WT_IDR_SECSEN_BIT 1
#define WT_IDR_SECSDIS_MASK 0x4U
#define WT_IDR_SECSDIS 0x4U
#define WT_IDR_SECSDIS_BIT 2
#define WT_IDR_ALARMEN_MASK 0x8U
#define WT_IDR_ALARMEN 0x8U
#define WT_IDR_ALARMEN_BIT 3
#define WT_IDR_ALARMDIS_MASK 0x10U
#define WT_IDR_ALARMDIS 0x10U
#define WT_IDR_ALARMDIS_BIT 4

#define WT_IMR (*(volatile unsigned long *)0xFFFA407C)
#define WT_IMR_OFFSET 0x7C
#define WT_IMR_ALARM_MASK 0x1U
#define WT_IMR_ALARM 0x1U
#define WT_IMR_ALARM_BIT 0
#define WT_IMR_SECSEN_MASK 0x2U
#define WT_IMR_SECSEN 0x2U
#define WT_IMR_SECSEN_BIT 1
#define WT_IMR_SECSDIS_MASK 0x4U
#define WT_IMR_SECSDIS 0x4U
#define WT_IMR_SECSDIS_BIT 2
#define WT_IMR_ALARMEN_MASK 0x8U
#define WT_IMR_ALARMEN 0x8U
#define WT_IMR_ALARMEN_BIT 3
#define WT_IMR_ALARMDIS_MASK 0x10U
#define WT_IMR_ALARMDIS 0x10U
#define WT_IMR_ALARMDIS_BIT 4

#define WT_SECS (*(volatile unsigned long *)0xFFFA4080)
#define WT_SECS_OFFSET 0x80
#define WT_SECS_SECONDS_MASK 0x0U
#define WT_SECS_SECONDS_BIT 0

#define WT_ALARM (*(volatile unsigned long *)0xFFFA4084)
#define WT_ALARM_OFFSET 0x84
#define WT_ALARM_ALARMREG_MASK 0x0U
#define WT_ALARM_ALARMREG_BIT 0

#define USART0_BASE 0xFFFA8000

#define US0_PER (*(volatile unsigned long *)0xFFFA8000)
#define US0_PER_OFFSET 0x0
#define US0_PER_SCK_MASK 0x10000U
#define US0_PER_SCK 0x10000U
#define US0_PER_SCK_BIT 16
#define US0_PER_TXD_MASK 0x20000U
#define US0_PER_TXD 0x20000U
#define US0_PER_TXD_BIT 17
#define US0_PER_RXD_MASK 0x40000U
#define US0_PER_RXD 0x40000U
#define US0_PER_RXD_BIT 18

#define US0_PDR (*(volatile unsigned long *)0xFFFA8004)
#define US0_PDR_OFFSET 0x4
#define US0_PDR_SCK_MASK 0x10000U
#define US0_PDR_SCK 0x10000U
#define US0_PDR_SCK_BIT 16
#define US0_PDR_TXD_MASK 0x20000U
#define US0_PDR_TXD 0x20000U
#define US0_PDR_TXD_BIT 17
#define US0_PDR_RXD_MASK 0x40000U
#define US0_PDR_RXD 0x40000U
#define US0_PDR_RXD_BIT 18

#define US0_PSR (*(volatile unsigned long *)0xFFFA8008)
#define US0_PSR_OFFSET 0x8
#define US0_PSR_SCK_MASK 0x10000U
#define US0_PSR_SCK 0x10000U
#define US0_PSR_SCK_BIT 16
#define US0_PSR_TXD_MASK 0x20000U
#define US0_PSR_TXD 0x20000U
#define US0_PSR_TXD_BIT 17
#define US0_PSR_RXD_MASK 0x40000U
#define US0_PSR_RXD 0x40000U
#define US0_PSR_RXD_BIT 18

#define US0_OER (*(volatile unsigned long *)0xFFFA8010)
#define US0_OER_OFFSET 0x10
#define US0_OER_SCK_MASK 0x10000U
#define US0_OER_SCK 0x10000U
#define US0_OER_SCK_BIT 16
#define US0_OER_TXD_MASK 0x20000U
#define US0_OER_TXD 0x20000U
#define US0_OER_TXD_BIT 17
#define US0_OER_RXD_MASK 0x40000U
#define US0_OER_RXD 0x40000U
#define US0_OER_RXD_BIT 18

#define US0_ODR (*(volatile unsigned long *)0xFFFA8014)
#define US0_ODR_OFFSET 0x14
#define US0_ODR_SCK_MASK 0x10000U
#define US0_ODR_SCK 0x10000U
#define US0_ODR_SCK_BIT 16
#define US0_ODR_TXD_MASK 0x20000U
#define US0_ODR_TXD 0x20000U
#define US0_ODR_TXD_BIT 17
#define US0_ODR_RXD_MASK 0x40000U
#define US0_ODR_RXD 0x40000U
#define US0_ODR_RXD_BIT 18

#define US0_OSR (*(volatile unsigned long *)0xFFFA8018)
#define US0_OSR_OFFSET 0x18
#define US0_OSR_SCK_MASK 0x10000U
#define US0_OSR_SCK 0x10000U
#define US0_OSR_SCK_BIT 16
#define US0_OSR_TXD_MASK 0x20000U
#define US0_OSR_TXD 0x20000U
#define US0_OSR_TXD_BIT 17
#define US0_OSR_RXD_MASK 0x40000U
#define US0_OSR_RXD 0x40000U
#define US0_OSR_RXD_BIT 18

#define US0_SODR (*(volatile unsigned long *)0xFFFA8030)
#define US0_SODR_OFFSET 0x30
#define US0_SODR_SCK_MASK 0x10000U
#define US0_SODR_SCK 0x10000U
#define US0_SODR_SCK_BIT 16
#define US0_SODR_TXD_MASK 0x20000U
#define US0_SODR_TXD 0x20000U
#define US0_SODR_TXD_BIT 17
#define US0_SODR_RXD_MASK 0x40000U
#define US0_SODR_RXD 0x40000U
#define US0_SODR_RXD_BIT 18

#define US0_CODR (*(volatile unsigned long *)0xFFFA8034)
#define US0_CODR_OFFSET 0x34
#define US0_CODR_SCK_MASK 0x10000U
#define US0_CODR_SCK 0x10000U
#define US0_CODR_SCK_BIT 16
#define US0_CODR_TXD_MASK 0x20000U
#define US0_CODR_TXD 0x20000U
#define US0_CODR_TXD_BIT 17
#define US0_CODR_RXD_MASK 0x40000U
#define US0_CODR_RXD 0x40000U
#define US0_CODR_RXD_BIT 18

#define US0_ODSR (*(volatile unsigned long *)0xFFFA8038)
#define US0_ODSR_OFFSET 0x38
#define US0_ODSR_SCK_MASK 0x10000U
#define US0_ODSR_SCK 0x10000U
#define US0_ODSR_SCK_BIT 16
#define US0_ODSR_TXD_MASK 0x20000U
#define US0_ODSR_TXD 0x20000U
#define US0_ODSR_TXD_BIT 17
#define US0_ODSR_RXD_MASK 0x40000U
#define US0_ODSR_RXD 0x40000U
#define US0_ODSR_RXD_BIT 18

#define US0_PDSR (*(volatile unsigned long *)0xFFFA803C)
#define US0_PDSR_OFFSET 0x3C
#define US0_PDSR_SCK_MASK 0x10000U
#define US0_PDSR_SCK 0x10000U
#define US0_PDSR_SCK_BIT 16
#define US0_PDSR_TXD_MASK 0x20000U
#define US0_PDSR_TXD 0x20000U
#define US0_PDSR_TXD_BIT 17
#define US0_PDSR_RXD_MASK 0x40000U
#define US0_PDSR_RXD 0x40000U
#define US0_PDSR_RXD_BIT 18

#define US0_MDER (*(volatile unsigned long *)0xFFFA8040)
#define US0_MDER_OFFSET 0x40
#define US0_MDER_SCK_MASK 0x10000U
#define US0_MDER_SCK 0x10000U
#define US0_MDER_SCK_BIT 16
#define US0_MDER_TXD_MASK 0x20000U
#define US0_MDER_TXD 0x20000U
#define US0_MDER_TXD_BIT 17
#define US0_MDER_RXD_MASK 0x40000U
#define US0_MDER_RXD 0x40000U
#define US0_MDER_RXD_BIT 18

#define US0_MDDR (*(volatile unsigned long *)0xFFFA8044)
#define US0_MDDR_OFFSET 0x44
#define US0_MDDR_SCK_MASK 0x10000U
#define US0_MDDR_SCK 0x10000U
#define US0_MDDR_SCK_BIT 16
#define US0_MDDR_TXD_MASK 0x20000U
#define US0_MDDR_TXD 0x20000U
#define US0_MDDR_TXD_BIT 17
#define US0_MDDR_RXD_MASK 0x40000U
#define US0_MDDR_RXD 0x40000U
#define US0_MDDR_RXD_BIT 18

#define US0_MDSR (*(volatile unsigned long *)0xFFFA8048)
#define US0_MDSR_OFFSET 0x48
#define US0_MDSR_SCK_MASK 0x10000U
#define US0_MDSR_SCK 0x10000U
#define US0_MDSR_SCK_BIT 16
#define US0_MDSR_TXD_MASK 0x20000U
#define US0_MDSR_TXD 0x20000U
#define US0_MDSR_TXD_BIT 17
#define US0_MDSR_RXD_MASK 0x40000U
#define US0_MDSR_RXD 0x40000U
#define US0_MDSR_RXD_BIT 18

#define US0_ECR (*(volatile unsigned long *)0xFFFA8050)
#define US0_ECR_OFFSET 0x50
#define US0_ECR_PIO_MASK 0x1U
#define US0_ECR_PIO 0x1U
#define US0_ECR_PIO_BIT 0
#define US0_ECR_USART_MASK 0x2U
#define US0_ECR_USART 0x2U
#define US0_ECR_USART_BIT 1

#define US0_DCR (*(volatile unsigned long *)0xFFFA8054)
#define US0_DCR_OFFSET 0x54
#define US0_DCR_PIO_MASK 0x1U
#define US0_DCR_PIO 0x1U
#define US0_DCR_PIO_BIT 0
#define US0_DCR_USART_MASK 0x2U
#define US0_DCR_USART 0x2U
#define US0_DCR_USART_BIT 1

#define US0_PMSR (*(volatile unsigned long *)0xFFFA8058)
#define US0_PMSR_OFFSET 0x58
#define US0_PMSR_PIO_MASK 0x1U
#define US0_PMSR_PIO 0x1U
#define US0_PMSR_PIO_BIT 0
#define US0_PMSR_USART_MASK 0x2U
#define US0_PMSR_USART 0x2U
#define US0_PMSR_USART_BIT 1

#define US0_CR (*(volatile unsigned long *)0xFFFA8060)
#define US0_CR_OFFSET 0x60
#define US0_CR_SWRST_MASK 0x1U
#define US0_CR_SWRST 0x1U
#define US0_CR_SWRST_BIT 0
#define US0_CR_RSTRX_MASK 0x4U
#define US0_CR_RSTRX 0x4U
#define US0_CR_RSTRX_BIT 2
#define US0_CR_RSTTX_MASK 0x8U
#define US0_CR_RSTTX 0x8U
#define US0_CR_RSTTX_BIT 3
#define US0_CR_RXEN_MASK 0x10U
#define US0_CR_RXEN 0x10U
#define US0_CR_RXEN_BIT 4
#define US0_CR_RXDIS_MASK 0x20U
#define US0_CR_RXDIS 0x20U
#define US0_CR_RXDIS_BIT 5
#define US0_CR_TXEN_MASK 0x40U
#define US0_CR_TXEN 0x40U
#define US0_CR_TXEN_BIT 6
#define US0_CR_TXDIS_MASK 0x80U
#define US0_CR_TXDIS 0x80U
#define US0_CR_TXDIS_BIT 7
#define US0_CR_RSTSTA_MASK 0x100U
#define US0_CR_RSTSTA 0x100U
#define US0_CR_RSTSTA_BIT 8
#define US0_CR_STTBRK_MASK 0x200U
#define US0_CR_STTBRK 0x200U
#define US0_CR_STTBRK_BIT 9
#define US0_CR_STPBRK_MASK 0x400U
#define US0_CR_STPBRK 0x400U
#define US0_CR_STPBRK_BIT 10
#define US0_CR_STTTO_MASK 0x800U
#define US0_CR_STTTO 0x800U
#define US0_CR_STTTO_BIT 11
#define US0_CR_SENDA_MASK 0x1000U
#define US0_CR_SENDA 0x1000U
#define US0_CR_SENDA_BIT 12
#define US0_CR_STHEADER_MASK 0x10000U
#define US0_CR_STHEADER 0x10000U
#define US0_CR_STHEADER_BIT 16
#define US0_CR_STRESP_MASK 0x20000U
#define US0_CR_STRESP 0x20000U
#define US0_CR_STRESP_BIT 17

#define US0_MR (*(volatile unsigned long *)0xFFFA8064)
#define US0_MR_OFFSET 0x64
#define US0_MR_LIN_MASK 0x1U
#define US0_MR_LIN 0x1U
#define US0_MR_LIN_BIT 0
#define US0_MR_SENDTIME_MASK 0xCU
#define US0_MR_SENDTIME_BIT 2
#define US0_MR_USCLKS_MASK 0x30U
#define US0_MR_USCLKS_BIT 4
#define US0_MR_CHRL_MASK 0xC0U
#define US0_MR_CHRL_BIT 6
#define US0_MR_SYNC_MASK 0x100U
#define US0_MR_SYNC 0x100U
#define US0_MR_SYNC_BIT 8
#define US0_MR_PAR_MASK 0xE00U
#define US0_MR_PAR_BIT 9
#define US0_MR_NBSTOP_MASK 0x3000U
#define US0_MR_NBSTOP_BIT 12
#define US0_MR_CHMODE_MASK 0xC000U
#define US0_MR_CHMODE_BIT 14
#define US0_MR_SMCARDPT_MASK 0x10000U
#define US0_MR_SMCARDPT 0x10000U
#define US0_MR_SMCARDPT_BIT 16
#define US0_MR_MODE9_MASK 0x20000U
#define US0_MR_MODE9 0x20000U
#define US0_MR_MODE9_BIT 17
#define US0_MR_CLKO_MASK 0x40000U
#define US0_MR_CLKO 0x40000U
#define US0_MR_CLKO_BIT 18

#define US0_CSR (*(volatile unsigned long *)0xFFFA806C)
#define US0_CSR_OFFSET 0x6C
#define US0_CSR_ENDHEADER_MASK 0x1000000U
#define US0_CSR_ENDHEADER 0x1000000U
#define US0_CSR_ENDHEADER_BIT 24
#define US0_CSR_ENDMESS_MASK 0x2000000U
#define US0_CSR_ENDMESS 0x2000000U
#define US0_CSR_ENDMESS_BIT 25
#define US0_CSR_NOTRESP_MASK 0x4000000U
#define US0_CSR_NOTRESP 0x4000000U
#define US0_CSR_NOTRESP_BIT 26
#define US0_CSR_BITERROR_MASK 0x8000000U
#define US0_CSR_BITERROR 0x8000000U
#define US0_CSR_BITERROR_BIT 27
#define US0_CSR_IPERROR_MASK 0x10000000U
#define US0_CSR_IPERROR 0x10000000U
#define US0_CSR_IPERROR_BIT 28
#define US0_CSR_CHECKSUM_MASK 0x20000000U
#define US0_CSR_CHECKSUM 0x20000000U
#define US0_CSR_CHECKSUM_BIT 29
#define US0_CSR_WAKEUP_MASK 0x40000000U
#define US0_CSR_WAKEUP 0x40000000U
#define US0_CSR_WAKEUP_BIT 30

#define US0_SR (*(volatile unsigned long *)0xFFFA8070)
#define US0_SR_OFFSET 0x70
#define US0_SR_RXRDY_MASK 0x1U
#define US0_SR_RXRDY 0x1U
#define US0_SR_RXRDY_BIT 0
#define US0_SR_TXRDY_MASK 0x2U
#define US0_SR_TXRDY 0x2U
#define US0_SR_TXRDY_BIT 1
#define US0_SR_RXBRK_MASK 0x4U
#define US0_SR_RXBRK 0x4U
#define US0_SR_RXBRK_BIT 2
#define US0_SR_ENDRX_MASK 0x8U
#define US0_SR_ENDRX 0x8U
#define US0_SR_ENDRX_BIT 3
#define US0_SR_ENDTX_MASK 0x10U
#define US0_SR_ENDTX 0x10U
#define US0_SR_ENDTX_BIT 4
#define US0_SR_USOVRE_MASK 0x20U
#define US0_SR_USOVRE 0x20U
#define US0_SR_USOVRE_BIT 5
#define US0_SR_FRAME_MASK 0x40U
#define US0_SR_FRAME 0x40U
#define US0_SR_FRAME_BIT 6
#define US0_SR_PARE_MASK 0x80U
#define US0_SR_PARE 0x80U
#define US0_SR_PARE_BIT 7
#define US0_SR_TIMEOUT_MASK 0x100U
#define US0_SR_TIMEOUT 0x100U
#define US0_SR_TIMEOUT_BIT 8
#define US0_SR_TXEMPTY_MASK 0x200U
#define US0_SR_TXEMPTY 0x200U
#define US0_SR_TXEMPTY_BIT 9
#define US0_SR_IDLE_MASK 0x400U
#define US0_SR_IDLE 0x400U
#define US0_SR_IDLE_BIT 10
#define US0_SR_IDLEFLAG_MASK 0x800U
#define US0_SR_IDLEFLAG 0x800U
#define US0_SR_IDLEFLAG_BIT 11
#define US0_SR_SCK_MASK 0x10000U
#define US0_SR_SCK 0x10000U
#define US0_SR_SCK_BIT 16
#define US0_SR_TXD_MASK 0x20000U
#define US0_SR_TXD 0x20000U
#define US0_SR_TXD_BIT 17
#define US0_SR_RXD_MASK 0x40000U
#define US0_SR_RXD 0x40000U
#define US0_SR_RXD_BIT 18
#define US0_SR_ENDHEADER_MASK 0x1000000U
#define US0_SR_ENDHEADER 0x1000000U
#define US0_SR_ENDHEADER_BIT 24
#define US0_SR_ENDMESS_MASK 0x2000000U
#define US0_SR_ENDMESS 0x2000000U
#define US0_SR_ENDMESS_BIT 25
#define US0_SR_NOTRESP_MASK 0x4000000U
#define US0_SR_NOTRESP 0x4000000U
#define US0_SR_NOTRESP_BIT 26
#define US0_SR_BITERROR_MASK 0x8000000U
#define US0_SR_BITERROR 0x8000000U
#define US0_SR_BITERROR_BIT 27
#define US0_SR_IPERROR_MASK 0x10000000U
#define US0_SR_IPERROR 0x10000000U
#define US0_SR_IPERROR_BIT 28
#define US0_SR_CHECKSUM_MASK 0x20000000U
#define US0_SR_CHECKSUM 0x20000000U
#define US0_SR_CHECKSUM_BIT 29
#define US0_SR_WAKEUP_MASK 0x40000000U
#define US0_SR_WAKEUP 0x40000000U
#define US0_SR_WAKEUP_BIT 30

#define US0_IER (*(volatile unsigned long *)0xFFFA8074)
#define US0_IER_OFFSET 0x74
#define US0_IER_RXRDY_MASK 0x1U
#define US0_IER_RXRDY 0x1U
#define US0_IER_RXRDY_BIT 0
#define US0_IER_TXRDY_MASK 0x2U
#define US0_IER_TXRDY 0x2U
#define US0_IER_TXRDY_BIT 1
#define US0_IER_RXBRK_MASK 0x4U
#define US0_IER_RXBRK 0x4U
#define US0_IER_RXBRK_BIT 2
#define US0_IER_ENDRX_MASK 0x8U
#define US0_IER_ENDRX 0x8U
#define US0_IER_ENDRX_BIT 3
#define US0_IER_ENDTX_MASK 0x10U
#define US0_IER_ENDTX 0x10U
#define US0_IER_ENDTX_BIT 4
#define US0_IER_USOVRE_MASK 0x20U
#define US0_IER_USOVRE 0x20U
#define US0_IER_USOVRE_BIT 5
#define US0_IER_FRAME_MASK 0x40U
#define US0_IER_FRAME 0x40U
#define US0_IER_FRAME_BIT 6
#define US0_IER_PARE_MASK 0x80U
#define US0_IER_PARE 0x80U
#define US0_IER_PARE_BIT 7
#define US0_IER_TIMEOUT_MASK 0x100U
#define US0_IER_TIMEOUT 0x100U
#define US0_IER_TIMEOUT_BIT 8
#define US0_IER_TXEMPTY_MASK 0x200U
#define US0_IER_TXEMPTY 0x200U
#define US0_IER_TXEMPTY_BIT 9
#define US0_IER_IDLE_MASK 0x400U
#define US0_IER_IDLE 0x400U
#define US0_IER_IDLE_BIT 10
#define US0_IER_IDLEFLAG_MASK 0x800U
#define US0_IER_IDLEFLAG 0x800U
#define US0_IER_IDLEFLAG_BIT 11
#define US0_IER_SCK_MASK 0x10000U
#define US0_IER_SCK 0x10000U
#define US0_IER_SCK_BIT 16
#define US0_IER_TXD_MASK 0x20000U
#define US0_IER_TXD 0x20000U
#define US0_IER_TXD_BIT 17
#define US0_IER_RXD_MASK 0x40000U
#define US0_IER_RXD 0x40000U
#define US0_IER_RXD_BIT 18
#define US0_IER_ENDHEADER_MASK 0x1000000U
#define US0_IER_ENDHEADER 0x1000000U
#define US0_IER_ENDHEADER_BIT 24
#define US0_IER_ENDMESS_MASK 0x2000000U
#define US0_IER_ENDMESS 0x2000000U
#define US0_IER_ENDMESS_BIT 25
#define US0_IER_NOTRESP_MASK 0x4000000U
#define US0_IER_NOTRESP 0x4000000U
#define US0_IER_NOTRESP_BIT 26
#define US0_IER_BITERROR_MASK 0x8000000U
#define US0_IER_BITERROR 0x8000000U
#define US0_IER_BITERROR_BIT 27
#define US0_IER_IPERROR_MASK 0x10000000U
#define US0_IER_IPERROR 0x10000000U
#define US0_IER_IPERROR_BIT 28
#define US0_IER_CHECKSUM_MASK 0x20000000U
#define US0_IER_CHECKSUM 0x20000000U
#define US0_IER_CHECKSUM_BIT 29
#define US0_IER_WAKEUP_MASK 0x40000000U
#define US0_IER_WAKEUP 0x40000000U
#define US0_IER_WAKEUP_BIT 30

#define US0_IDR (*(volatile unsigned long *)0xFFFA8078)
#define US0_IDR_OFFSET 0x78
#define US0_IDR_RXRDY_MASK 0x1U
#define US0_IDR_RXRDY 0x1U
#define US0_IDR_RXRDY_BIT 0
#define US0_IDR_TXRDY_MASK 0x2U
#define US0_IDR_TXRDY 0x2U
#define US0_IDR_TXRDY_BIT 1
#define US0_IDR_RXBRK_MASK 0x4U
#define US0_IDR_RXBRK 0x4U
#define US0_IDR_RXBRK_BIT 2
#define US0_IDR_ENDRX_MASK 0x8U
#define US0_IDR_ENDRX 0x8U
#define US0_IDR_ENDRX_BIT 3
#define US0_IDR_ENDTX_MASK 0x10U
#define US0_IDR_ENDTX 0x10U
#define US0_IDR_ENDTX_BIT 4
#define US0_IDR_USOVRE_MASK 0x20U
#define US0_IDR_USOVRE 0x20U
#define US0_IDR_USOVRE_BIT 5
#define US0_IDR_FRAME_MASK 0x40U
#define US0_IDR_FRAME 0x40U
#define US0_IDR_FRAME_BIT 6
#define US0_IDR_PARE_MASK 0x80U
#define US0_IDR_PARE 0x80U
#define US0_IDR_PARE_BIT 7
#define US0_IDR_TIMEOUT_MASK 0x100U
#define US0_IDR_TIMEOUT 0x100U
#define US0_IDR_TIMEOUT_BIT 8
#define US0_IDR_TXEMPTY_MASK 0x200U
#define US0_IDR_TXEMPTY 0x200U
#define US0_IDR_TXEMPTY_BIT 9
#define US0_IDR_IDLE_MASK 0x400U
#define US0_IDR_IDLE 0x400U
#define US0_IDR_IDLE_BIT 10
#define US0_IDR_IDLEFLAG_MASK 0x800U
#define US0_IDR_IDLEFLAG 0x800U
#define US0_IDR_IDLEFLAG_BIT 11
#define US0_IDR_SCK_MASK 0x10000U
#define US0_IDR_SCK 0x10000U
#define US0_IDR_SCK_BIT 16
#define US0_IDR_TXD_MASK 0x20000U
#define US0_IDR_TXD 0x20000U
#define US0_IDR_TXD_BIT 17
#define US0_IDR_RXD_MASK 0x40000U
#define US0_IDR_RXD 0x40000U
#define US0_IDR_RXD_BIT 18
#define US0_IDR_ENDHEADER_MASK 0x1000000U
#define US0_IDR_ENDHEADER 0x1000000U
#define US0_IDR_ENDHEADER_BIT 24
#define US0_IDR_ENDMESS_MASK 0x2000000U
#define US0_IDR_ENDMESS 0x2000000U
#define US0_IDR_ENDMESS_BIT 25
#define US0_IDR_NOTRESP_MASK 0x4000000U
#define US0_IDR_NOTRESP 0x4000000U
#define US0_IDR_NOTRESP_BIT 26
#define US0_IDR_BITERROR_MASK 0x8000000U
#define US0_IDR_BITERROR 0x8000000U
#define US0_IDR_BITERROR_BIT 27
#define US0_IDR_IPERROR_MASK 0x10000000U
#define US0_IDR_IPERROR 0x10000000U
#define US0_IDR_IPERROR_BIT 28
#define US0_IDR_CHECKSUM_MASK 0x20000000U
#define US0_IDR_CHECKSUM 0x20000000U
#define US0_IDR_CHECKSUM_BIT 29
#define US0_IDR_WAKEUP_MASK 0x40000000U
#define US0_IDR_WAKEUP 0x40000000U
#define US0_IDR_WAKEUP_BIT 30

#define US0_IMR (*(volatile unsigned long *)0xFFFA807C)
#define US0_IMR_OFFSET 0x7C
#define US0_IMR_RXRDY_MASK 0x1U
#define US0_IMR_RXRDY 0x1U
#define US0_IMR_RXRDY_BIT 0
#define US0_IMR_TXRDY_MASK 0x2U
#define US0_IMR_TXRDY 0x2U
#define US0_IMR_TXRDY_BIT 1
#define US0_IMR_RXBRK_MASK 0x4U
#define US0_IMR_RXBRK 0x4U
#define US0_IMR_RXBRK_BIT 2
#define US0_IMR_ENDRX_MASK 0x8U
#define US0_IMR_ENDRX 0x8U
#define US0_IMR_ENDRX_BIT 3
#define US0_IMR_ENDTX_MASK 0x10U
#define US0_IMR_ENDTX 0x10U
#define US0_IMR_ENDTX_BIT 4
#define US0_IMR_USOVRE_MASK 0x20U
#define US0_IMR_USOVRE 0x20U
#define US0_IMR_USOVRE_BIT 5
#define US0_IMR_FRAME_MASK 0x40U
#define US0_IMR_FRAME 0x40U
#define US0_IMR_FRAME_BIT 6
#define US0_IMR_PARE_MASK 0x80U
#define US0_IMR_PARE 0x80U
#define US0_IMR_PARE_BIT 7
#define US0_IMR_TIMEOUT_MASK 0x100U
#define US0_IMR_TIMEOUT 0x100U
#define US0_IMR_TIMEOUT_BIT 8
#define US0_IMR_TXEMPTY_MASK 0x200U
#define US0_IMR_TXEMPTY 0x200U
#define US0_IMR_TXEMPTY_BIT 9
#define US0_IMR_IDLE_MASK 0x400U
#define US0_IMR_IDLE 0x400U
#define US0_IMR_IDLE_BIT 10
#define US0_IMR_SCK_MASK 0x10000U
#define US0_IMR_SCK 0x10000U
#define US0_IMR_SCK_BIT 16
#define US0_IMR_TXD_MASK 0x20000U
#define US0_IMR_TXD 0x20000U
#define US0_IMR_TXD_BIT 17
#define US0_IMR_RXD_MASK 0x40000U
#define US0_IMR_RXD 0x40000U
#define US0_IMR_RXD_BIT 18
#define US0_IMR_ENDHEADER_MASK 0x1000000U
#define US0_IMR_ENDHEADER 0x1000000U
#define US0_IMR_ENDHEADER_BIT 24
#define US0_IMR_ENDMESS_MASK 0x2000000U
#define US0_IMR_ENDMESS 0x2000000U
#define US0_IMR_ENDMESS_BIT 25
#define US0_IMR_NOTRESP_MASK 0x4000000U
#define US0_IMR_NOTRESP 0x4000000U
#define US0_IMR_NOTRESP_BIT 26
#define US0_IMR_BITERROR_MASK 0x8000000U
#define US0_IMR_BITERROR 0x8000000U
#define US0_IMR_BITERROR_BIT 27
#define US0_IMR_IPERROR_MASK 0x10000000U
#define US0_IMR_IPERROR 0x10000000U
#define US0_IMR_IPERROR_BIT 28
#define US0_IMR_CHECKSUM_MASK 0x20000000U
#define US0_IMR_CHECKSUM 0x20000000U
#define US0_IMR_CHECKSUM_BIT 29
#define US0_IMR_WAKEUP_MASK 0x40000000U
#define US0_IMR_WAKEUP 0x40000000U
#define US0_IMR_WAKEUP_BIT 30

#define US0_RHR (*(volatile unsigned long *)0xFFFA8080)
#define US0_RHR_OFFSET 0x80
#define US0_RHR_RXCHR_MASK 0x1FFU
#define US0_RHR_RXCHR_BIT 0

#define US0_THR (*(volatile unsigned long *)0xFFFA8084)
#define US0_THR_OFFSET 0x84
#define US0_THR_TXCHR_MASK 0x1FFU
#define US0_THR_TXCHR_BIT 0

#define US0_BRGR (*(volatile unsigned long *)0xFFFA8088)
#define US0_BRGR_OFFSET 0x88
#define US0_BRGR_CD_MASK 0xFFFFU
#define US0_BRGR_CD_BIT 0

#define US0_RTOR (*(volatile unsigned long *)0xFFFA808C)
#define US0_RTOR_OFFSET 0x8C
#define US0_RTOR_TO_MASK 0xFFU
#define US0_RTOR_TO_BIT 0

#define US0_TTGR (*(volatile unsigned long *)0xFFFA8090)
#define US0_TTGR_OFFSET 0x90
#define US0_TTGR_TG_MASK 0xFFU
#define US0_TTGR_TG_BIT 0

#define US0_LIR (*(volatile unsigned long *)0xFFFA8094)
#define US0_LIR_OFFSET 0x94
#define US0_LIR_IDENTIFIER_MASK 0x3FU
#define US0_LIR_IDENTIFIER_BIT 0

#define US0_DFWR0 (*(volatile unsigned long *)0xFFFA8098)
#define US0_DFWR0_OFFSET 0x98
#define US0_DFWR0_DATA0_MASK 0xFFU
#define US0_DFWR0_DATA0_BIT 0
#define US0_DFWR0_DATA1_MASK 0xFF00U
#define US0_DFWR0_DATA1_BIT 8
#define US0_DFWR0_DATA2_MASK 0xFF0000U
#define US0_DFWR0_DATA2_BIT 16
#define US0_DFWR0_DATA3_MASK 0xFF000000U
#define US0_DFWR0_DATA3_BIT 24

#define US0_DFWR1 (*(volatile unsigned long *)0xFFFA809C)
#define US0_DFWR1_OFFSET 0x9C
#define US0_DFWR1_DATA4_MASK 0xFFU
#define US0_DFWR1_DATA4_BIT 0
#define US0_DFWR1_DATA5_MASK 0xFF00U
#define US0_DFWR1_DATA5_BIT 8
#define US0_DFWR1_DATA6_MASK 0xFF0000U
#define US0_DFWR1_DATA6_BIT 16
#define US0_DFWR1_DATA7_MASK 0xFF000000U
#define US0_DFWR1_DATA7_BIT 24

#define US0_DFRR0 (*(volatile unsigned long *)0xFFFA80A0)
#define US0_DFRR0_OFFSET 0xA0
#define US0_DFRR0_DATA0_MASK 0xFFU
#define US0_DFRR0_DATA0_BIT 0
#define US0_DFRR0_DATA1_MASK 0xFF00U
#define US0_DFRR0_DATA1_BIT 8
#define US0_DFRR0_DATA2_MASK 0xFF0000U
#define US0_DFRR0_DATA2_BIT 16
#define US0_DFRR0_DATA3_MASK 0xFF000000U
#define US0_DFRR0_DATA3_BIT 24

#define US0_DFRR1 (*(volatile unsigned long *)0xFFFA80A4)
#define US0_DFRR1_OFFSET 0xA4
#define US0_DFRR1_DATA4_MASK 0xFFU
#define US0_DFRR1_DATA4_BIT 0
#define US0_DFRR1_DATA5_MASK 0xFF00U
#define US0_DFRR1_DATA5_BIT 8
#define US0_DFRR1_DATA6_MASK 0xFF0000U
#define US0_DFRR1_DATA6_BIT 16
#define US0_DFRR1_DATA7_MASK 0xFF000000U
#define US0_DFRR1_DATA7_BIT 24

#define US0_SBLR (*(volatile unsigned long *)0xFFFA80A8)
#define US0_SBLR_OFFSET 0xA8
#define US0_SBLR_SYNCH_BRK_MASK 0x1FU
#define US0_SBLR_SYNCH_BRK_BIT 0

#define USART1_BASE 0xFFFAC000

#define US1_PER (*(volatile unsigned long *)0xFFFAC000)
#define US1_PER_OFFSET 0x0
#define US1_PER_SCK_MASK 0x10000U
#define US1_PER_SCK 0x10000U
#define US1_PER_SCK_BIT 16
#define US1_PER_TXD_MASK 0x20000U
#define US1_PER_TXD 0x20000U
#define US1_PER_TXD_BIT 17
#define US1_PER_RXD_MASK 0x40000U
#define US1_PER_RXD 0x40000U
#define US1_PER_RXD_BIT 18

#define US1_PDR (*(volatile unsigned long *)0xFFFAC004)
#define US1_PDR_OFFSET 0x4
#define US1_PDR_SCK_MASK 0x10000U
#define US1_PDR_SCK 0x10000U
#define US1_PDR_SCK_BIT 16
#define US1_PDR_TXD_MASK 0x20000U
#define US1_PDR_TXD 0x20000U
#define US1_PDR_TXD_BIT 17
#define US1_PDR_RXD_MASK 0x40000U
#define US1_PDR_RXD 0x40000U
#define US1_PDR_RXD_BIT 18

#define US1_PSR (*(volatile unsigned long *)0xFFFAC008)
#define US1_PSR_OFFSET 0x8
#define US1_PSR_SCK_MASK 0x10000U
#define US1_PSR_SCK 0x10000U
#define US1_PSR_SCK_BIT 16
#define US1_PSR_TXD_MASK 0x20000U
#define US1_PSR_TXD 0x20000U
#define US1_PSR_TXD_BIT 17
#define US1_PSR_RXD_MASK 0x40000U
#define US1_PSR_RXD 0x40000U
#define US1_PSR_RXD_BIT 18

#define US1_OER (*(volatile unsigned long *)0xFFFAC010)
#define US1_OER_OFFSET 0x10
#define US1_OER_SCK_MASK 0x10000U
#define US1_OER_SCK 0x10000U
#define US1_OER_SCK_BIT 16
#define US1_OER_TXD_MASK 0x20000U
#define US1_OER_TXD 0x20000U
#define US1_OER_TXD_BIT 17
#define US1_OER_RXD_MASK 0x40000U
#define US1_OER_RXD 0x40000U
#define US1_OER_RXD_BIT 18

#define US1_ODR (*(volatile unsigned long *)0xFFFAC014)
#define US1_ODR_OFFSET 0x14
#define US1_ODR_SCK_MASK 0x10000U
#define US1_ODR_SCK 0x10000U
#define US1_ODR_SCK_BIT 16
#define US1_ODR_TXD_MASK 0x20000U
#define US1_ODR_TXD 0x20000U
#define US1_ODR_TXD_BIT 17
#define US1_ODR_RXD_MASK 0x40000U
#define US1_ODR_RXD 0x40000U
#define US1_ODR_RXD_BIT 18

#define US1_OSR (*(volatile unsigned long *)0xFFFAC018)
#define US1_OSR_OFFSET 0x18
#define US1_OSR_SCK_MASK 0x10000U
#define US1_OSR_SCK 0x10000U
#define US1_OSR_SCK_BIT 16
#define US1_OSR_TXD_MASK 0x20000U
#define US1_OSR_TXD 0x20000U
#define US1_OSR_TXD_BIT 17
#define US1_OSR_RXD_MASK 0x40000U
#define US1_OSR_RXD 0x40000U
#define US1_OSR_RXD_BIT 18

#define US1_SODR (*(volatile unsigned long *)0xFFFAC030)
#define US1_SODR_OFFSET 0x30
#define US1_SODR_SCK_MASK 0x10000U
#define US1_SODR_SCK 0x10000U
#define US1_SODR_SCK_BIT 16
#define US1_SODR_TXD_MASK 0x20000U
#define US1_SODR_TXD 0x20000U
#define US1_SODR_TXD_BIT 17
#define US1_SODR_RXD_MASK 0x40000U
#define US1_SODR_RXD 0x40000U
#define US1_SODR_RXD_BIT 18

#define US1_CODR (*(volatile unsigned long *)0xFFFAC034)
#define US1_CODR_OFFSET 0x34
#define US1_CODR_SCK_MASK 0x10000U
#define US1_CODR_SCK 0x10000U
#define US1_CODR_SCK_BIT 16
#define US1_CODR_TXD_MASK 0x20000U
#define US1_CODR_TXD 0x20000U
#define US1_CODR_TXD_BIT 17
#define US1_CODR_RXD_MASK 0x40000U
#define US1_CODR_RXD 0x40000U
#define US1_CODR_RXD_BIT 18

#define US1_ODSR (*(volatile unsigned long *)0xFFFAC038)
#define US1_ODSR_OFFSET 0x38
#define US1_ODSR_SCK_MASK 0x10000U
#define US1_ODSR_SCK 0x10000U
#define US1_ODSR_SCK_BIT 16
#define US1_ODSR_TXD_MASK 0x20000U
#define US1_ODSR_TXD 0x20000U
#define US1_ODSR_TXD_BIT 17
#define US1_ODSR_RXD_MASK 0x40000U
#define US1_ODSR_RXD 0x40000U
#define US1_ODSR_RXD_BIT 18

#define US1_PDSR (*(volatile unsigned long *)0xFFFAC03C)
#define US1_PDSR_OFFSET 0x3C
#define US1_PDSR_SCK_MASK 0x10000U
#define US1_PDSR_SCK 0x10000U
#define US1_PDSR_SCK_BIT 16
#define US1_PDSR_TXD_MASK 0x20000U
#define US1_PDSR_TXD 0x20000U
#define US1_PDSR_TXD_BIT 17
#define US1_PDSR_RXD_MASK 0x40000U
#define US1_PDSR_RXD 0x40000U
#define US1_PDSR_RXD_BIT 18

#define US1_MDER (*(volatile unsigned long *)0xFFFAC040)
#define US1_MDER_OFFSET 0x40
#define US1_MDER_SCK_MASK 0x10000U
#define US1_MDER_SCK 0x10000U
#define US1_MDER_SCK_BIT 16
#define US1_MDER_TXD_MASK 0x20000U
#define US1_MDER_TXD 0x20000U
#define US1_MDER_TXD_BIT 17
#define US1_MDER_RXD_MASK 0x40000U
#define US1_MDER_RXD 0x40000U
#define US1_MDER_RXD_BIT 18

#define US1_MDDR (*(volatile unsigned long *)0xFFFAC044)
#define US1_MDDR_OFFSET 0x44
#define US1_MDDR_SCK_MASK 0x10000U
#define US1_MDDR_SCK 0x10000U
#define US1_MDDR_SCK_BIT 16
#define US1_MDDR_TXD_MASK 0x20000U
#define US1_MDDR_TXD 0x20000U
#define US1_MDDR_TXD_BIT 17
#define US1_MDDR_RXD_MASK 0x40000U
#define US1_MDDR_RXD 0x40000U
#define US1_MDDR_RXD_BIT 18

#define US1_MDSR (*(volatile unsigned long *)0xFFFAC048)
#define US1_MDSR_OFFSET 0x48
#define US1_MDSR_SCK_MASK 0x10000U
#define US1_MDSR_SCK 0x10000U
#define US1_MDSR_SCK_BIT 16
#define US1_MDSR_TXD_MASK 0x20000U
#define US1_MDSR_TXD 0x20000U
#define US1_MDSR_TXD_BIT 17
#define US1_MDSR_RXD_MASK 0x40000U
#define US1_MDSR_RXD 0x40000U
#define US1_MDSR_RXD_BIT 18

#define US1_ECR (*(volatile unsigned long *)0xFFFAC050)
#define US1_ECR_OFFSET 0x50
#define US1_ECR_PIO_MASK 0x1U
#define US1_ECR_PIO 0x1U
#define US1_ECR_PIO_BIT 0
#define US1_ECR_USART_MASK 0x2U
#define US1_ECR_USART 0x2U
#define US1_ECR_USART_BIT 1

#define US1_DCR (*(volatile unsigned long *)0xFFFAC054)
#define US1_DCR_OFFSET 0x54
#define US1_DCR_PIO_MASK 0x1U
#define US1_DCR_PIO 0x1U
#define US1_DCR_PIO_BIT 0
#define US1_DCR_USART_MASK 0x2U
#define US1_DCR_USART 0x2U
#define US1_DCR_USART_BIT 1

#define US1_PMSR (*(volatile unsigned long *)0xFFFAC058)
#define US1_PMSR_OFFSET 0x58
#define US1_PMSR_PIO_MASK 0x1U
#define US1_PMSR_PIO 0x1U
#define US1_PMSR_PIO_BIT 0
#define US1_PMSR_USART_MASK 0x2U
#define US1_PMSR_USART 0x2U
#define US1_PMSR_USART_BIT 1

#define US1_CR (*(volatile unsigned long *)0xFFFAC060)
#define US1_CR_OFFSET 0x60
#define US1_CR_SWRST_MASK 0x1U
#define US1_CR_SWRST 0x1U
#define US1_CR_SWRST_BIT 0
#define US1_CR_RSTRX_MASK 0x4U
#define US1_CR_RSTRX 0x4U
#define US1_CR_RSTRX_BIT 2
#define US1_CR_RSTTX_MASK 0x8U
#define US1_CR_RSTTX 0x8U
#define US1_CR_RSTTX_BIT 3
#define US1_CR_RXEN_MASK 0x10U
#define US1_CR_RXEN 0x10U
#define US1_CR_RXEN_BIT 4
#define US1_CR_RXDIS_MASK 0x20U
#define US1_CR_RXDIS 0x20U
#define US1_CR_RXDIS_BIT 5
#define US1_CR_TXEN_MASK 0x40U
#define US1_CR_TXEN 0x40U
#define US1_CR_TXEN_BIT 6
#define US1_CR_TXDIS_MASK 0x80U
#define US1_CR_TXDIS 0x80U
#define US1_CR_TXDIS_BIT 7
#define US1_CR_RSTSTA_MASK 0x100U
#define US1_CR_RSTSTA 0x100U
#define US1_CR_RSTSTA_BIT 8
#define US1_CR_STTBRK_MASK 0x200U
#define US1_CR_STTBRK 0x200U
#define US1_CR_STTBRK_BIT 9
#define US1_CR_STPBRK_MASK 0x400U
#define US1_CR_STPBRK 0x400U
#define US1_CR_STPBRK_BIT 10
#define US1_CR_STTTO_MASK 0x800U
#define US1_CR_STTTO 0x800U
#define US1_CR_STTTO_BIT 11
#define US1_CR_SENDA_MASK 0x1000U
#define US1_CR_SENDA 0x1000U
#define US1_CR_SENDA_BIT 12
#define US1_CR_STHEADER_MASK 0x10000U
#define US1_CR_STHEADER 0x10000U
#define US1_CR_STHEADER_BIT 16
#define US1_CR_STRESP_MASK 0x20000U
#define US1_CR_STRESP 0x20000U
#define US1_CR_STRESP_BIT 17

#define US1_MR (*(volatile unsigned long *)0xFFFAC064)
#define US1_MR_OFFSET 0x64
#define US1_MR_LIN_MASK 0x1U
#define US1_MR_LIN 0x1U
#define US1_MR_LIN_BIT 0
#define US1_MR_SENDTIME_MASK 0xCU
#define US1_MR_SENDTIME_BIT 2
#define US1_MR_USCLKS_MASK 0x30U
#define US1_MR_USCLKS_BIT 4
#define US1_MR_CHRL_MASK 0xC0U
#define US1_MR_CHRL_BIT 6
#define US1_MR_SYNC_MASK 0x100U
#define US1_MR_SYNC 0x100U
#define US1_MR_SYNC_BIT 8
#define US1_MR_PAR_MASK 0xE00U
#define US1_MR_PAR_BIT 9
#define US1_MR_NBSTOP_MASK 0x3000U
#define US1_MR_NBSTOP_BIT 12
#define US1_MR_CHMODE_MASK 0xC000U
#define US1_MR_CHMODE_BIT 14
#define US1_MR_SMCARDPT_MASK 0x10000U
#define US1_MR_SMCARDPT 0x10000U
#define US1_MR_SMCARDPT_BIT 16
#define US1_MR_MODE9_MASK 0x20000U
#define US1_MR_MODE9 0x20000U
#define US1_MR_MODE9_BIT 17
#define US1_MR_CLKO_MASK 0x40000U
#define US1_MR_CLKO 0x40000U
#define US1_MR_CLKO_BIT 18

#define US1_CSR (*(volatile unsigned long *)0xFFFAC06C)
#define US1_CSR_OFFSET 0x6C
#define US1_CSR_ENDHEADER_MASK 0x1000000U
#define US1_CSR_ENDHEADER 0x1000000U
#define US1_CSR_ENDHEADER_BIT 24
#define US1_CSR_ENDMESS_MASK 0x2000000U
#define US1_CSR_ENDMESS 0x2000000U
#define US1_CSR_ENDMESS_BIT 25
#define US1_CSR_NOTRESP_MASK 0x4000000U
#define US1_CSR_NOTRESP 0x4000000U
#define US1_CSR_NOTRESP_BIT 26
#define US1_CSR_BITERROR_MASK 0x8000000U
#define US1_CSR_BITERROR 0x8000000U
#define US1_CSR_BITERROR_BIT 27
#define US1_CSR_IPERROR_MASK 0x10000000U
#define US1_CSR_IPERROR 0x10000000U
#define US1_CSR_IPERROR_BIT 28
#define US1_CSR_CHECKSUM_MASK 0x20000000U
#define US1_CSR_CHECKSUM 0x20000000U
#define US1_CSR_CHECKSUM_BIT 29
#define US1_CSR_WAKEUP_MASK 0x40000000U
#define US1_CSR_WAKEUP 0x40000000U
#define US1_CSR_WAKEUP_BIT 30

#define US1_SR (*(volatile unsigned long *)0xFFFAC070)
#define US1_SR_OFFSET 0x70
#define US1_SR_RXRDY_MASK 0x1U
#define US1_SR_RXRDY 0x1U
#define US1_SR_RXRDY_BIT 0
#define US1_SR_TXRDY_MASK 0x2U
#define US1_SR_TXRDY 0x2U
#define US1_SR_TXRDY_BIT 1
#define US1_SR_RXBRK_MASK 0x4U
#define US1_SR_RXBRK 0x4U
#define US1_SR_RXBRK_BIT 2
#define US1_SR_ENDRX_MASK 0x8U
#define US1_SR_ENDRX 0x8U
#define US1_SR_ENDRX_BIT 3
#define US1_SR_ENDTX_MASK 0x10U
#define US1_SR_ENDTX 0x10U
#define US1_SR_ENDTX_BIT 4
#define US1_SR_USOVRE_MASK 0x20U
#define US1_SR_USOVRE 0x20U
#define US1_SR_USOVRE_BIT 5
#define US1_SR_FRAME_MASK 0x40U
#define US1_SR_FRAME 0x40U
#define US1_SR_FRAME_BIT 6
#define US1_SR_PARE_MASK 0x80U
#define US1_SR_PARE 0x80U
#define US1_SR_PARE_BIT 7
#define US1_SR_TIMEOUT_MASK 0x100U
#define US1_SR_TIMEOUT 0x100U
#define US1_SR_TIMEOUT_BIT 8
#define US1_SR_TXEMPTY_MASK 0x200U
#define US1_SR_TXEMPTY 0x200U
#define US1_SR_TXEMPTY_BIT 9
#define US1_SR_IDLE_MASK 0x400U
#define US1_SR_IDLE 0x400U
#define US1_SR_IDLE_BIT 10
#define US1_SR_IDLEFLAG_MASK 0x800U
#define US1_SR_IDLEFLAG 0x800U
#define US1_SR_IDLEFLAG_BIT 11
#define US1_SR_SCK_MASK 0x10000U
#define US1_SR_SCK 0x10000U
#define US1_SR_SCK_BIT 16
#define US1_SR_TXD_MASK 0x20000U
#define US1_SR_TXD 0x20000U
#define US1_SR_TXD_BIT 17
#define US1_SR_RXD_MASK 0x40000U
#define US1_SR_RXD 0x40000U
#define US1_SR_RXD_BIT 18
#define US1_SR_ENDHEADER_MASK 0x1000000U
#define US1_SR_ENDHEADER 0x1000000U
#define US1_SR_ENDHEADER_BIT 24
#define US1_SR_ENDMESS_MASK 0x2000000U
#define US1_SR_ENDMESS 0x2000000U
#define US1_SR_ENDMESS_BIT 25
#define US1_SR_NOTRESP_MASK 0x4000000U
#define US1_SR_NOTRESP 0x4000000U
#define US1_SR_NOTRESP_BIT 26
#define US1_SR_BITERROR_MASK 0x8000000U
#define US1_SR_BITERROR 0x8000000U
#define US1_SR_BITERROR_BIT 27
#define US1_SR_IPERROR_MASK 0x10000000U
#define US1_SR_IPERROR 0x10000000U
#define US1_SR_IPERROR_BIT 28
#define US1_SR_CHECKSUM_MASK 0x20000000U
#define US1_SR_CHECKSUM 0x20000000U
#define US1_SR_CHECKSUM_BIT 29
#define US1_SR_WAKEUP_MASK 0x40000000U
#define US1_SR_WAKEUP 0x40000000U
#define US1_SR_WAKEUP_BIT 30

#define US1_IER (*(volatile unsigned long *)0xFFFAC074)
#define US1_IER_OFFSET 0x74
#define US1_IER_RXRDY_MASK 0x1U
#define US1_IER_RXRDY 0x1U
#define US1_IER_RXRDY_BIT 0
#define US1_IER_TXRDY_MASK 0x2U
#define US1_IER_TXRDY 0x2U
#define US1_IER_TXRDY_BIT 1
#define US1_IER_RXBRK_MASK 0x4U
#define US1_IER_RXBRK 0x4U
#define US1_IER_RXBRK_BIT 2
#define US1_IER_ENDRX_MASK 0x8U
#define US1_IER_ENDRX 0x8U
#define US1_IER_ENDRX_BIT 3
#define US1_IER_ENDTX_MASK 0x10U
#define US1_IER_ENDTX 0x10U
#define US1_IER_ENDTX_BIT 4
#define US1_IER_USOVRE_MASK 0x20U
#define US1_IER_USOVRE 0x20U
#define US1_IER_USOVRE_BIT 5
#define US1_IER_FRAME_MASK 0x40U
#define US1_IER_FRAME 0x40U
#define US1_IER_FRAME_BIT 6
#define US1_IER_PARE_MASK 0x80U
#define US1_IER_PARE 0x80U
#define US1_IER_PARE_BIT 7
#define US1_IER_TIMEOUT_MASK 0x100U
#define US1_IER_TIMEOUT 0x100U
#define US1_IER_TIMEOUT_BIT 8
#define US1_IER_TXEMPTY_MASK 0x200U
#define US1_IER_TXEMPTY 0x200U
#define US1_IER_TXEMPTY_BIT 9
#define US1_IER_IDLE_MASK 0x400U
#define US1_IER_IDLE 0x400U
#define US1_IER_IDLE_BIT 10
#define US1_IER_IDLEFLAG_MASK 0x800U
#define US1_IER_IDLEFLAG 0x800U
#define US1_IER_IDLEFLAG_BIT 11
#define US1_IER_SCK_MASK 0x10000U
#define US1_IER_SCK 0x10000U
#define US1_IER_SCK_BIT 16
#define US1_IER_TXD_MASK 0x20000U
#define US1_IER_TXD 0x20000U
#define US1_IER_TXD_BIT 17
#define US1_IER_RXD_MASK 0x40000U
#define US1_IER_RXD 0x40000U
#define US1_IER_RXD_BIT 18
#define US1_IER_ENDHEADER_MASK 0x1000000U
#define US1_IER_ENDHEADER 0x1000000U
#define US1_IER_ENDHEADER_BIT 24
#define US1_IER_ENDMESS_MASK 0x2000000U
#define US1_IER_ENDMESS 0x2000000U
#define US1_IER_ENDMESS_BIT 25
#define US1_IER_NOTRESP_MASK 0x4000000U
#define US1_IER_NOTRESP 0x4000000U
#define US1_IER_NOTRESP_BIT 26
#define US1_IER_BITERROR_MASK 0x8000000U
#define US1_IER_BITERROR 0x8000000U
#define US1_IER_BITERROR_BIT 27
#define US1_IER_IPERROR_MASK 0x10000000U
#define US1_IER_IPERROR 0x10000000U
#define US1_IER_IPERROR_BIT 28
#define US1_IER_CHECKSUM_MASK 0x20000000U
#define US1_IER_CHECKSUM 0x20000000U
#define US1_IER_CHECKSUM_BIT 29
#define US1_IER_WAKEUP_MASK 0x40000000U
#define US1_IER_WAKEUP 0x40000000U
#define US1_IER_WAKEUP_BIT 30

#define US1_IDR (*(volatile unsigned long *)0xFFFAC078)
#define US1_IDR_OFFSET 0x78
#define US1_IDR_RXRDY_MASK 0x1U
#define US1_IDR_RXRDY 0x1U
#define US1_IDR_RXRDY_BIT 0
#define US1_IDR_TXRDY_MASK 0x2U
#define US1_IDR_TXRDY 0x2U
#define US1_IDR_TXRDY_BIT 1
#define US1_IDR_RXBRK_MASK 0x4U
#define US1_IDR_RXBRK 0x4U
#define US1_IDR_RXBRK_BIT 2
#define US1_IDR_ENDRX_MASK 0x8U
#define US1_IDR_ENDRX 0x8U
#define US1_IDR_ENDRX_BIT 3
#define US1_IDR_ENDTX_MASK 0x10U
#define US1_IDR_ENDTX 0x10U
#define US1_IDR_ENDTX_BIT 4
#define US1_IDR_USOVRE_MASK 0x20U
#define US1_IDR_USOVRE 0x20U
#define US1_IDR_USOVRE_BIT 5
#define US1_IDR_FRAME_MASK 0x40U
#define US1_IDR_FRAME 0x40U
#define US1_IDR_FRAME_BIT 6
#define US1_IDR_PARE_MASK 0x80U
#define US1_IDR_PARE 0x80U
#define US1_IDR_PARE_BIT 7
#define US1_IDR_TIMEOUT_MASK 0x100U
#define US1_IDR_TIMEOUT 0x100U
#define US1_IDR_TIMEOUT_BIT 8
#define US1_IDR_TXEMPTY_MASK 0x200U
#define US1_IDR_TXEMPTY 0x200U
#define US1_IDR_TXEMPTY_BIT 9
#define US1_IDR_IDLE_MASK 0x400U
#define US1_IDR_IDLE 0x400U
#define US1_IDR_IDLE_BIT 10
#define US1_IDR_IDLEFLAG_MASK 0x800U
#define US1_IDR_IDLEFLAG 0x800U
#define US1_IDR_IDLEFLAG_BIT 11
#define US1_IDR_SCK_MASK 0x10000U
#define US1_IDR_SCK 0x10000U
#define US1_IDR_SCK_BIT 16
#define US1_IDR_TXD_MASK 0x20000U
#define US1_IDR_TXD 0x20000U
#define US1_IDR_TXD_BIT 17
#define US1_IDR_RXD_MASK 0x40000U
#define US1_IDR_RXD 0x40000U
#define US1_IDR_RXD_BIT 18
#define US1_IDR_ENDHEADER_MASK 0x1000000U
#define US1_IDR_ENDHEADER 0x1000000U
#define US1_IDR_ENDHEADER_BIT 24
#define US1_IDR_ENDMESS_MASK 0x2000000U
#define US1_IDR_ENDMESS 0x2000000U
#define US1_IDR_ENDMESS_BIT 25
#define US1_IDR_NOTRESP_MASK 0x4000000U
#define US1_IDR_NOTRESP 0x4000000U
#define US1_IDR_NOTRESP_BIT 26
#define US1_IDR_BITERROR_MASK 0x8000000U
#define US1_IDR_BITERROR 0x8000000U
#define US1_IDR_BITERROR_BIT 27
#define US1_IDR_IPERROR_MASK 0x10000000U
#define US1_IDR_IPERROR 0x10000000U
#define US1_IDR_IPERROR_BIT 28
#define US1_IDR_CHECKSUM_MASK 0x20000000U
#define US1_IDR_CHECKSUM 0x20000000U
#define US1_IDR_CHECKSUM_BIT 29
#define US1_IDR_WAKEUP_MASK 0x40000000U
#define US1_IDR_WAKEUP 0x40000000U
#define US1_IDR_WAKEUP_BIT 30

#define US1_IMR (*(volatile unsigned long *)0xFFFAC07C)
#define US1_IMR_OFFSET 0x7C
#define US1_IMR_RXRDY_MASK 0x1U
#define US1_IMR_RXRDY 0x1U
#define US1_IMR_RXRDY_BIT 0
#define US1_IMR_TXRDY_MASK 0x2U
#define US1_IMR_TXRDY 0x2U
#define US1_IMR_TXRDY_BIT 1
#define US1_IMR_RXBRK_MASK 0x4U
#define US1_IMR_RXBRK 0x4U
#define US1_IMR_RXBRK_BIT 2
#define US1_IMR_ENDRX_MASK 0x8U
#define US1_IMR_ENDRX 0x8U
#define US1_IMR_ENDRX_BIT 3
#define US1_IMR_ENDTX_MASK 0x10U
#define US1_IMR_ENDTX 0x10U
#define US1_IMR_ENDTX_BIT 4
#define US1_IMR_USOVRE_MASK 0x20U
#define US1_IMR_USOVRE 0x20U
#define US1_IMR_USOVRE_BIT 5
#define US1_IMR_FRAME_MASK 0x40U
#define US1_IMR_FRAME 0x40U
#define US1_IMR_FRAME_BIT 6
#define US1_IMR_PARE_MASK 0x80U
#define US1_IMR_PARE 0x80U
#define US1_IMR_PARE_BIT 7
#define US1_IMR_TIMEOUT_MASK 0x100U
#define US1_IMR_TIMEOUT 0x100U
#define US1_IMR_TIMEOUT_BIT 8
#define US1_IMR_TXEMPTY_MASK 0x200U
#define US1_IMR_TXEMPTY 0x200U
#define US1_IMR_TXEMPTY_BIT 9
#define US1_IMR_IDLE_MASK 0x400U
#define US1_IMR_IDLE 0x400U
#define US1_IMR_IDLE_BIT 10
#define US1_IMR_SCK_MASK 0x10000U
#define US1_IMR_SCK 0x10000U
#define US1_IMR_SCK_BIT 16
#define US1_IMR_TXD_MASK 0x20000U
#define US1_IMR_TXD 0x20000U
#define US1_IMR_TXD_BIT 17
#define US1_IMR_RXD_MASK 0x40000U
#define US1_IMR_RXD 0x40000U
#define US1_IMR_RXD_BIT 18
#define US1_IMR_ENDHEADER_MASK 0x1000000U
#define US1_IMR_ENDHEADER 0x1000000U
#define US1_IMR_ENDHEADER_BIT 24
#define US1_IMR_ENDMESS_MASK 0x2000000U
#define US1_IMR_ENDMESS 0x2000000U
#define US1_IMR_ENDMESS_BIT 25
#define US1_IMR_NOTRESP_MASK 0x4000000U
#define US1_IMR_NOTRESP 0x4000000U
#define US1_IMR_NOTRESP_BIT 26
#define US1_IMR_BITERROR_MASK 0x8000000U
#define US1_IMR_BITERROR 0x8000000U
#define US1_IMR_BITERROR_BIT 27
#define US1_IMR_IPERROR_MASK 0x10000000U
#define US1_IMR_IPERROR 0x10000000U
#define US1_IMR_IPERROR_BIT 28
#define US1_IMR_CHECKSUM_MASK 0x20000000U
#define US1_IMR_CHECKSUM 0x20000000U
#define US1_IMR_CHECKSUM_BIT 29
#define US1_IMR_WAKEUP_MASK 0x40000000U
#define US1_IMR_WAKEUP 0x40000000U
#define US1_IMR_WAKEUP_BIT 30

#define US1_RHR (*(volatile unsigned long *)0xFFFAC080)
#define US1_RHR_OFFSET 0x80
#define US1_RHR_RXCHR_MASK 0x1FFU
#define US1_RHR_RXCHR_BIT 0

#define US1_THR (*(volatile unsigned long *)0xFFFAC084)
#define US1_THR_OFFSET 0x84
#define US1_THR_TXCHR_MASK 0x1FFU
#define US1_THR_TXCHR_BIT 0

#define US1_BRGR (*(volatile unsigned long *)0xFFFAC088)
#define US1_BRGR_OFFSET 0x88
#define US1_BRGR_CD_MASK 0xFFFFU
#define US1_BRGR_CD_BIT 0

#define US1_RTOR (*(volatile unsigned long *)0xFFFAC08C)
#define US1_RTOR_OFFSET 0x8C
#define US1_RTOR_TO_MASK 0xFFU
#define US1_RTOR_TO_BIT 0

#define US1_TTGR (*(volatile unsigned long *)0xFFFAC090)
#define US1_TTGR_OFFSET 0x90
#define US1_TTGR_TG_MASK 0xFFU
#define US1_TTGR_TG_BIT 0

#define US1_LIR (*(volatile unsigned long *)0xFFFAC094)
#define US1_LIR_OFFSET 0x94
#define US1_LIR_IDENTIFIER_MASK 0x3FU
#define US1_LIR_IDENTIFIER_BIT 0

#define US1_DFWR0 (*(volatile unsigned long *)0xFFFAC098)
#define US1_DFWR0_OFFSET 0x98
#define US1_DFWR0_DATA0_MASK 0xFFU
#define US1_DFWR0_DATA0_BIT 0
#define US1_DFWR0_DATA1_MASK 0xFF00U
#define US1_DFWR0_DATA1_BIT 8
#define US1_DFWR0_DATA2_MASK 0xFF0000U
#define US1_DFWR0_DATA2_BIT 16
#define US1_DFWR0_DATA3_MASK 0xFF000000U
#define US1_DFWR0_DATA3_BIT 24

#define US1_DFWR1 (*(volatile unsigned long *)0xFFFAC09C)
#define US1_DFWR1_OFFSET 0x9C
#define US1_DFWR1_DATA4_MASK 0xFFU
#define US1_DFWR1_DATA4_BIT 0
#define US1_DFWR1_DATA5_MASK 0xFF00U
#define US1_DFWR1_DATA5_BIT 8
#define US1_DFWR1_DATA6_MASK 0xFF0000U
#define US1_DFWR1_DATA6_BIT 16
#define US1_DFWR1_DATA7_MASK 0xFF000000U
#define US1_DFWR1_DATA7_BIT 24

#define US1_DFRR0 (*(volatile unsigned long *)0xFFFAC0A0)
#define US1_DFRR0_OFFSET 0xA0
#define US1_DFRR0_DATA0_MASK 0xFFU
#define US1_DFRR0_DATA0_BIT 0
#define US1_DFRR0_DATA1_MASK 0xFF00U
#define US1_DFRR0_DATA1_BIT 8
#define US1_DFRR0_DATA2_MASK 0xFF0000U
#define US1_DFRR0_DATA2_BIT 16
#define US1_DFRR0_DATA3_MASK 0xFF000000U
#define US1_DFRR0_DATA3_BIT 24

#define US1_DFRR1 (*(volatile unsigned long *)0xFFFAC0A4)
#define US1_DFRR1_OFFSET 0xA4
#define US1_DFRR1_DATA4_MASK 0xFFU
#define US1_DFRR1_DATA4_BIT 0
#define US1_DFRR1_DATA5_MASK 0xFF00U
#define US1_DFRR1_DATA5_BIT 8
#define US1_DFRR1_DATA6_MASK 0xFF0000U
#define US1_DFRR1_DATA6_BIT 16
#define US1_DFRR1_DATA7_MASK 0xFF000000U
#define US1_DFRR1_DATA7_BIT 24

#define US1_SBLR (*(volatile unsigned long *)0xFFFAC0A8)
#define US1_SBLR_OFFSET 0xA8
#define US1_SBLR_SYNCH_BRK_MASK 0x1FU
#define US1_SBLR_SYNCH_BRK_BIT 0

#define CAN3_BASE 0xFFFB0000

#define CAN3_ECR (*(volatile unsigned long *)0xFFFB0050)
#define CAN3_ECR_OFFSET 0x50
#define CAN3_ECR_CAN_MASK 0x2U
#define CAN3_ECR_CAN 0x2U
#define CAN3_ECR_CAN_BIT 1

#define CAN3_DCR (*(volatile unsigned long *)0xFFFB0054)
#define CAN3_DCR_OFFSET 0x54
#define CAN3_DCR_CAN_MASK 0x2U
#define CAN3_DCR_CAN 0x2U
#define CAN3_DCR_CAN_BIT 1

#define CAN3_PMSR (*(volatile unsigned long *)0xFFFB0058)
#define CAN3_PMSR_OFFSET 0x58
#define CAN3_PMSR_CAN_MASK 0x2U
#define CAN3_PMSR_CAN 0x2U
#define CAN3_PMSR_CAN_BIT 1

#define CAN3_CR (*(volatile unsigned long *)0xFFFB0060)
#define CAN3_CR_OFFSET 0x60
#define CAN3_CR_SWRST_MASK 0x1U
#define CAN3_CR_SWRST 0x1U
#define CAN3_CR_SWRST_BIT 0
#define CAN3_CR_CANEN_MASK 0x2U
#define CAN3_CR_CANEN 0x2U
#define CAN3_CR_CANEN_BIT 1
#define CAN3_CR_CANDIS_MASK 0x4U
#define CAN3_CR_CANDIS 0x4U
#define CAN3_CR_CANDIS_BIT 2
#define CAN3_CR_ABEN_MASK 0x8U
#define CAN3_CR_ABEN 0x8U
#define CAN3_CR_ABEN_BIT 3
#define CAN3_CR_ABDIS_MASK 0x10U
#define CAN3_CR_ABDIS 0x10U
#define CAN3_CR_ABDIS_BIT 4
#define CAN3_CR_OVEN_MASK 0x20U
#define CAN3_CR_OVEN 0x20U
#define CAN3_CR_OVEN_BIT 5
#define CAN3_CR_OVDIS_MASK 0x20U
#define CAN3_CR_OVDIS 0x20U
#define CAN3_CR_OVDIS_BIT 5

#define CAN3_MR (*(volatile unsigned long *)0xFFFB0064)
#define CAN3_MR_OFFSET 0x64
#define CAN3_MR_BD_MASK 0x3FU
#define CAN3_MR_BD_BIT 0
#define CAN3_MR_PROP_MASK 0x700U
#define CAN3_MR_PROP_BIT 8
#define CAN3_MR_SJW_MASK 0x3000U
#define CAN3_MR_SJW_BIT 12
#define CAN3_MR_SMP_MASK 0x4000U
#define CAN3_MR_SMP 0x4000U
#define CAN3_MR_SMP_BIT 14
#define CAN3_MR_PHSEG1_MASK 0x70000U
#define CAN3_MR_PHSEG1_BIT 16
#define CAN3_MR_PHSEG2_MASK 0x700000U
#define CAN3_MR_PHSEG2_BIT 20

#define CAN3_CSR (*(volatile unsigned long *)0xFFFB006C)
#define CAN3_CSR_OFFSET 0x6C
#define CAN3_CSR_ENDINIT_MASK 0x4U
#define CAN3_CSR_ENDINIT 0x4U
#define CAN3_CSR_ENDINIT_BIT 2

#define CAN3_SR (*(volatile unsigned long *)0xFFFB0070)
#define CAN3_SR_OFFSET 0x70
#define CAN3_SR_CANENA_MASK 0x1U
#define CAN3_SR_CANENA 0x1U
#define CAN3_SR_CANENA_BIT 0
#define CAN3_SR_CANINIT_MASK 0x2U
#define CAN3_SR_CANINIT 0x2U
#define CAN3_SR_CANINIT_BIT 1
#define CAN3_SR_ENDINIT_MASK 0x4U
#define CAN3_SR_ENDINIT 0x4U
#define CAN3_SR_ENDINIT_BIT 2
#define CAN3_SR_ERPAS_MASK 0x8U
#define CAN3_SR_ERPAS 0x8U
#define CAN3_SR_ERPAS_BIT 3
#define CAN3_SR_BUSOFF_MASK 0x10U
#define CAN3_SR_BUSOFF 0x10U
#define CAN3_SR_BUSOFF_BIT 4
#define CAN3_SR_ABRQ_MASK 0x20U
#define CAN3_SR_ABRQ 0x20U
#define CAN3_SR_ABRQ_BIT 5
#define CAN3_SR_ISS_MASK 0x80U
#define CAN3_SR_ISS 0x80U
#define CAN3_SR_ISS_BIT 7
#define CAN3_SR_REC_MASK 0xFF0000U
#define CAN3_SR_REC_BIT 16
#define CAN3_SR_TEC_MASK 0xFF000000U
#define CAN3_SR_TEC_BIT 24

#define CAN3_IER (*(volatile unsigned long *)0xFFFB0074)
#define CAN3_IER_OFFSET 0x74
#define CAN3_IER_ENDINIT_MASK 0x4U
#define CAN3_IER_ENDINIT 0x4U
#define CAN3_IER_ENDINIT_BIT 2
#define CAN3_IER_ERPAS_MASK 0x8U
#define CAN3_IER_ERPAS 0x8U
#define CAN3_IER_ERPAS_BIT 3
#define CAN3_IER_BUSOFF_MASK 0x10U
#define CAN3_IER_BUSOFF 0x10U
#define CAN3_IER_BUSOFF_BIT 4

#define CAN3_IDR (*(volatile unsigned long *)0xFFFB0078)
#define CAN3_IDR_OFFSET 0x78
#define CAN3_IDR_ENDINIT_MASK 0x4U
#define CAN3_IDR_ENDINIT 0x4U
#define CAN3_IDR_ENDINIT_BIT 2
#define CAN3_IDR_ERPAS_MASK 0x8U
#define CAN3_IDR_ERPAS 0x8U
#define CAN3_IDR_ERPAS_BIT 3
#define CAN3_IDR_BUSOFF_MASK 0x10U
#define CAN3_IDR_BUSOFF 0x10U
#define CAN3_IDR_BUSOFF_BIT 4

#define CAN3_IMR (*(volatile unsigned long *)0xFFFB007C)
#define CAN3_IMR_OFFSET 0x7C
#define CAN3_IMR_ENDINIT_MASK 0x4U
#define CAN3_IMR_ENDINIT 0x4U
#define CAN3_IMR_ENDINIT_BIT 2
#define CAN3_IMR_ERPAS_MASK 0x8U
#define CAN3_IMR_ERPAS 0x8U
#define CAN3_IMR_ERPAS_BIT 3
#define CAN3_IMR_BUSOFF_MASK 0x10U
#define CAN3_IMR_BUSOFF 0x10U
#define CAN3_IMR_BUSOFF_BIT 4

#define CAN3_CISR (*(volatile unsigned long *)0xFFFB0080)
#define CAN3_CISR_OFFSET 0x80
#define CAN3_CISR_CH0_MASK 0x1U
#define CAN3_CISR_CH0 0x1U
#define CAN3_CISR_CH0_BIT 0
#define CAN3_CISR_CH1_MASK 0x2U
#define CAN3_CISR_CH1 0x2U
#define CAN3_CISR_CH1_BIT 1
#define CAN3_CISR_CH2_MASK 0x4U
#define CAN3_CISR_CH2 0x4U
#define CAN3_CISR_CH2_BIT 2
#define CAN3_CISR_CH3_MASK 0x8U
#define CAN3_CISR_CH3 0x8U
#define CAN3_CISR_CH3_BIT 3
#define CAN3_CISR_CH4_MASK 0x10U
#define CAN3_CISR_CH4 0x10U
#define CAN3_CISR_CH4_BIT 4
#define CAN3_CISR_CH5_MASK 0x20U
#define CAN3_CISR_CH5 0x20U
#define CAN3_CISR_CH5_BIT 5
#define CAN3_CISR_CH6_MASK 0x40U
#define CAN3_CISR_CH6 0x40U
#define CAN3_CISR_CH6_BIT 6
#define CAN3_CISR_CH7_MASK 0x80U
#define CAN3_CISR_CH7 0x80U
#define CAN3_CISR_CH7_BIT 7
#define CAN3_CISR_CH8_MASK 0x100U
#define CAN3_CISR_CH8 0x100U
#define CAN3_CISR_CH8_BIT 8
#define CAN3_CISR_CH9_MASK 0x200U
#define CAN3_CISR_CH9 0x200U
#define CAN3_CISR_CH9_BIT 9
#define CAN3_CISR_CH10_MASK 0x400U
#define CAN3_CISR_CH10 0x400U
#define CAN3_CISR_CH10_BIT 10
#define CAN3_CISR_CH11_MASK 0x800U
#define CAN3_CISR_CH11 0x800U
#define CAN3_CISR_CH11_BIT 11
#define CAN3_CISR_CH12_MASK 0x1000U
#define CAN3_CISR_CH12 0x1000U
#define CAN3_CISR_CH12_BIT 12
#define CAN3_CISR_CH13_MASK 0x2000U
#define CAN3_CISR_CH13 0x2000U
#define CAN3_CISR_CH13_BIT 13
#define CAN3_CISR_CH14_MASK 0x4000U
#define CAN3_CISR_CH14 0x4000U
#define CAN3_CISR_CH14_BIT 14
#define CAN3_CISR_CH15_MASK 0x8000U
#define CAN3_CISR_CH15 0x8000U
#define CAN3_CISR_CH15_BIT 15

#define CAN3_ISSR (*(volatile unsigned long *)0xFFFB0084)
#define CAN3_ISSR_OFFSET 0x84
#define CAN3_ISSR_CH0_MASK 0x1U
#define CAN3_ISSR_CH0 0x1U
#define CAN3_ISSR_CH0_BIT 0
#define CAN3_ISSR_CH1_MASK 0x2U
#define CAN3_ISSR_CH1 0x2U
#define CAN3_ISSR_CH1_BIT 1
#define CAN3_ISSR_CH2_MASK 0x4U
#define CAN3_ISSR_CH2 0x4U
#define CAN3_ISSR_CH2_BIT 2
#define CAN3_ISSR_CH3_MASK 0x8U
#define CAN3_ISSR_CH3 0x8U
#define CAN3_ISSR_CH3_BIT 3
#define CAN3_ISSR_CH4_MASK 0x10U
#define CAN3_ISSR_CH4 0x10U
#define CAN3_ISSR_CH4_BIT 4
#define CAN3_ISSR_CH5_MASK 0x20U
#define CAN3_ISSR_CH5 0x20U
#define CAN3_ISSR_CH5_BIT 5
#define CAN3_ISSR_CH6_MASK 0x40U
#define CAN3_ISSR_CH6 0x40U
#define CAN3_ISSR_CH6_BIT 6
#define CAN3_ISSR_CH7_MASK 0x80U
#define CAN3_ISSR_CH7 0x80U
#define CAN3_ISSR_CH7_BIT 7
#define CAN3_ISSR_CH8_MASK 0x100U
#define CAN3_ISSR_CH8 0x100U
#define CAN3_ISSR_CH8_BIT 8
#define CAN3_ISSR_CH9_MASK 0x200U
#define CAN3_ISSR_CH9 0x200U
#define CAN3_ISSR_CH9_BIT 9
#define CAN3_ISSR_CH10_MASK 0x400U
#define CAN3_ISSR_CH10 0x400U
#define CAN3_ISSR_CH10_BIT 10
#define CAN3_ISSR_CH11_MASK 0x800U
#define CAN3_ISSR_CH11 0x800U
#define CAN3_ISSR_CH11_BIT 11
#define CAN3_ISSR_CH12_MASK 0x1000U
#define CAN3_ISSR_CH12 0x1000U
#define CAN3_ISSR_CH12_BIT 12
#define CAN3_ISSR_CH13_MASK 0x2000U
#define CAN3_ISSR_CH13 0x2000U
#define CAN3_ISSR_CH13_BIT 13
#define CAN3_ISSR_CH14_MASK 0x4000U
#define CAN3_ISSR_CH14 0x4000U
#define CAN3_ISSR_CH14_BIT 14
#define CAN3_ISSR_CH15_MASK 0x8000U
#define CAN3_ISSR_CH15 0x8000U
#define CAN3_ISSR_CH15_BIT 15

#define CAN3_SIER (*(volatile unsigned long *)0xFFFB0088)
#define CAN3_SIER_OFFSET 0x88
#define CAN3_SIER_CH0_MASK 0x1U
#define CAN3_SIER_CH0 0x1U
#define CAN3_SIER_CH0_BIT 0
#define CAN3_SIER_CH1_MASK 0x2U
#define CAN3_SIER_CH1 0x2U
#define CAN3_SIER_CH1_BIT 1
#define CAN3_SIER_CH2_MASK 0x4U
#define CAN3_SIER_CH2 0x4U
#define CAN3_SIER_CH2_BIT 2
#define CAN3_SIER_CH3_MASK 0x8U
#define CAN3_SIER_CH3 0x8U
#define CAN3_SIER_CH3_BIT 3
#define CAN3_SIER_CH4_MASK 0x10U
#define CAN3_SIER_CH4 0x10U
#define CAN3_SIER_CH4_BIT 4
#define CAN3_SIER_CH5_MASK 0x20U
#define CAN3_SIER_CH5 0x20U
#define CAN3_SIER_CH5_BIT 5
#define CAN3_SIER_CH6_MASK 0x40U
#define CAN3_SIER_CH6 0x40U
#define CAN3_SIER_CH6_BIT 6
#define CAN3_SIER_CH7_MASK 0x80U
#define CAN3_SIER_CH7 0x80U
#define CAN3_SIER_CH7_BIT 7
#define CAN3_SIER_CH8_MASK 0x100U
#define CAN3_SIER_CH8 0x100U
#define CAN3_SIER_CH8_BIT 8
#define CAN3_SIER_CH9_MASK 0x200U
#define CAN3_SIER_CH9 0x200U
#define CAN3_SIER_CH9_BIT 9
#define CAN3_SIER_CH10_MASK 0x400U
#define CAN3_SIER_CH10 0x400U
#define CAN3_SIER_CH10_BIT 10
#define CAN3_SIER_CH11_MASK 0x800U
#define CAN3_SIER_CH11 0x800U
#define CAN3_SIER_CH11_BIT 11
#define CAN3_SIER_CH12_MASK 0x1000U
#define CAN3_SIER_CH12 0x1000U
#define CAN3_SIER_CH12_BIT 12
#define CAN3_SIER_CH13_MASK 0x2000U
#define CAN3_SIER_CH13 0x2000U
#define CAN3_SIER_CH13_BIT 13
#define CAN3_SIER_CH14_MASK 0x4000U
#define CAN3_SIER_CH14 0x4000U
#define CAN3_SIER_CH14_BIT 14
#define CAN3_SIER_CH15_MASK 0x8000U
#define CAN3_SIER_CH15 0x8000U
#define CAN3_SIER_CH15_BIT 15

#define CAN3_SIDR (*(volatile unsigned long *)0xFFFB008C)
#define CAN3_SIDR_OFFSET 0x8C
#define CAN3_SIDR_CH0_MASK 0x1U
#define CAN3_SIDR_CH0 0x1U
#define CAN3_SIDR_CH0_BIT 0
#define CAN3_SIDR_CH1_MASK 0x2U
#define CAN3_SIDR_CH1 0x2U
#define CAN3_SIDR_CH1_BIT 1
#define CAN3_SIDR_CH2_MASK 0x4U
#define CAN3_SIDR_CH2 0x4U
#define CAN3_SIDR_CH2_BIT 2
#define CAN3_SIDR_CH3_MASK 0x8U
#define CAN3_SIDR_CH3 0x8U
#define CAN3_SIDR_CH3_BIT 3
#define CAN3_SIDR_CH4_MASK 0x10U
#define CAN3_SIDR_CH4 0x10U
#define CAN3_SIDR_CH4_BIT 4
#define CAN3_SIDR_CH5_MASK 0x20U
#define CAN3_SIDR_CH5 0x20U
#define CAN3_SIDR_CH5_BIT 5
#define CAN3_SIDR_CH6_MASK 0x40U
#define CAN3_SIDR_CH6 0x40U
#define CAN3_SIDR_CH6_BIT 6
#define CAN3_SIDR_CH7_MASK 0x80U
#define CAN3_SIDR_CH7 0x80U
#define CAN3_SIDR_CH7_BIT 7
#define CAN3_SIDR_CH8_MASK 0x100U
#define CAN3_SIDR_CH8 0x100U
#define CAN3_SIDR_CH8_BIT 8
#define CAN3_SIDR_CH9_MASK 0x200U
#define CAN3_SIDR_CH9 0x200U
#define CAN3_SIDR_CH9_BIT 9
#define CAN3_SIDR_CH10_MASK 0x400U
#define CAN3_SIDR_CH10 0x400U
#define CAN3_SIDR_CH10_BIT 10
#define CAN3_SIDR_CH11_MASK 0x800U
#define CAN3_SIDR_CH11 0x800U
#define CAN3_SIDR_CH11_BIT 11
#define CAN3_SIDR_CH12_MASK 0x1000U
#define CAN3_SIDR_CH12 0x1000U
#define CAN3_SIDR_CH12_BIT 12
#define CAN3_SIDR_CH13_MASK 0x2000U
#define CAN3_SIDR_CH13 0x2000U
#define CAN3_SIDR_CH13_BIT 13
#define CAN3_SIDR_CH14_MASK 0x4000U
#define CAN3_SIDR_CH14 0x4000U
#define CAN3_SIDR_CH14_BIT 14
#define CAN3_SIDR_CH15_MASK 0x8000U
#define CAN3_SIDR_CH15 0x8000U
#define CAN3_SIDR_CH15_BIT 15

#define CAN3_SIMR (*(volatile unsigned long *)0xFFFB0090)
#define CAN3_SIMR_OFFSET 0x90
#define CAN3_SIMR_CH0_MASK 0x1U
#define CAN3_SIMR_CH0 0x1U
#define CAN3_SIMR_CH0_BIT 0
#define CAN3_SIMR_CH1_MASK 0x2U
#define CAN3_SIMR_CH1 0x2U
#define CAN3_SIMR_CH1_BIT 1
#define CAN3_SIMR_CH2_MASK 0x4U
#define CAN3_SIMR_CH2 0x4U
#define CAN3_SIMR_CH2_BIT 2
#define CAN3_SIMR_CH3_MASK 0x8U
#define CAN3_SIMR_CH3 0x8U
#define CAN3_SIMR_CH3_BIT 3
#define CAN3_SIMR_CH4_MASK 0x10U
#define CAN3_SIMR_CH4 0x10U
#define CAN3_SIMR_CH4_BIT 4
#define CAN3_SIMR_CH5_MASK 0x20U
#define CAN3_SIMR_CH5 0x20U
#define CAN3_SIMR_CH5_BIT 5
#define CAN3_SIMR_CH6_MASK 0x40U
#define CAN3_SIMR_CH6 0x40U
#define CAN3_SIMR_CH6_BIT 6
#define CAN3_SIMR_CH7_MASK 0x80U
#define CAN3_SIMR_CH7 0x80U
#define CAN3_SIMR_CH7_BIT 7
#define CAN3_SIMR_CH8_MASK 0x100U
#define CAN3_SIMR_CH8 0x100U
#define CAN3_SIMR_CH8_BIT 8
#define CAN3_SIMR_CH9_MASK 0x200U
#define CAN3_SIMR_CH9 0x200U
#define CAN3_SIMR_CH9_BIT 9
#define CAN3_SIMR_CH10_MASK 0x400U
#define CAN3_SIMR_CH10 0x400U
#define CAN3_SIMR_CH10_BIT 10
#define CAN3_SIMR_CH11_MASK 0x800U
#define CAN3_SIMR_CH11 0x800U
#define CAN3_SIMR_CH11_BIT 11
#define CAN3_SIMR_CH12_MASK 0x1000U
#define CAN3_SIMR_CH12 0x1000U
#define CAN3_SIMR_CH12_BIT 12
#define CAN3_SIMR_CH13_MASK 0x2000U
#define CAN3_SIMR_CH13 0x2000U
#define CAN3_SIMR_CH13_BIT 13
#define CAN3_SIMR_CH14_MASK 0x4000U
#define CAN3_SIMR_CH14 0x4000U
#define CAN3_SIMR_CH14_BIT 14
#define CAN3_SIMR_CH15_MASK 0x8000U
#define CAN3_SIMR_CH15 0x8000U
#define CAN3_SIMR_CH15_BIT 15

#define CAN3_DRA0 (*(volatile unsigned long *)0xFFFB0100)
#define CAN3_DRA0_OFFSET 0x100
#define CAN3_DRA0_DATA0_MASK 0xFFU
#define CAN3_DRA0_DATA0_BIT 0
#define CAN3_DRA0_DATA1_MASK 0xFF00U
#define CAN3_DRA0_DATA1_BIT 8
#define CAN3_DRA0_DATA2_MASK 0xFF0000U
#define CAN3_DRA0_DATA2_BIT 16
#define CAN3_DRA0_DATA3_MASK 0xFF000000U
#define CAN3_DRA0_DATA3_BIT 24

#define CAN3_DRB0 (*(volatile unsigned long *)0xFFFB0104)
#define CAN3_DRB0_OFFSET 0x104
#define CAN3_DRB0_DATA4_MASK 0xFFU
#define CAN3_DRB0_DATA4_BIT 0
#define CAN3_DRB0_DATA5_MASK 0xFF00U
#define CAN3_DRB0_DATA5_BIT 8
#define CAN3_DRB0_DATA6_MASK 0xFF0000U
#define CAN3_DRB0_DATA6_BIT 16
#define CAN3_DRB0_DATA7_MASK 0xFF000000U
#define CAN3_DRB0_DATA7_BIT 24

#define CAN3_MSK0 (*(volatile unsigned long *)0xFFFB0108)
#define CAN3_MSK0_OFFSET 0x108
#define CAN3_MSK0_MASK_MASK 0x1FFFFFFFU
#define CAN3_MSK0_MASK_BIT 0
#define CAN3_MSK0_MRB_MASK 0x60000000U
#define CAN3_MSK0_MRB_BIT 29
#define CAN3_MSK0_MRTR_MASK 0x80000000U
#define CAN3_MSK0_MRTR 0x80000000U
#define CAN3_MSK0_MRTR_BIT 31

#define CAN3_IR0 (*(volatile unsigned long *)0xFFFB010C)
#define CAN3_IR0_OFFSET 0x10C
#define CAN3_IR0_ID_MASK 0x1FFFFFFFU
#define CAN3_IR0_ID_BIT 0
#define CAN3_IR0_RB_MASK 0x60000000U
#define CAN3_IR0_RB_BIT 29
#define CAN3_IR0_RTR_MASK 0x80000000U
#define CAN3_IR0_RTR 0x80000000U
#define CAN3_IR0_RTR_BIT 31

#define CAN3_CR0 (*(volatile unsigned long *)0xFFFB0110)
#define CAN3_CR0_OFFSET 0x110
#define CAN3_CR0_DLC_MASK 0xFU
#define CAN3_CR0_DLC_BIT 0
#define CAN3_CR0_IDE_MASK 0x10U
#define CAN3_CR0_IDE 0x10U
#define CAN3_CR0_IDE_BIT 4
#define CAN3_CR0_RPLYV_MASK 0x20U
#define CAN3_CR0_RPLYV 0x20U
#define CAN3_CR0_RPLYV_BIT 5
#define CAN3_CR0_PCB_MASK 0x40U
#define CAN3_CR0_PCB 0x40U
#define CAN3_CR0_PCB_BIT 6
#define CAN3_CR0_CHANEN_MASK 0x80U
#define CAN3_CR0_CHANEN 0x80U
#define CAN3_CR0_CHANEN_BIT 7
#define CAN3_CR0_OVERWRITE_MASK 0x100U
#define CAN3_CR0_OVERWRITE 0x100U
#define CAN3_CR0_OVERWRITE_BIT 8

#define CAN3_CR0 (*(volatile unsigned long *)0xFFFB0114)
#define CAN3_CR0_OFFSET 0x114
#define CAN3_CR0_STAMP_MASK 0x0U
#define CAN3_CR0_STAMP_BIT 0

#define CAN3_CSR0 (*(volatile unsigned long *)0xFFFB0118)
#define CAN3_CSR0_OFFSET 0x118
#define CAN3_CSR0_ACK_MASK 0x1U
#define CAN3_CSR0_ACK 0x1U
#define CAN3_CSR0_ACK_BIT 0
#define CAN3_CSR0_FRAME_MASK 0x2U
#define CAN3_CSR0_FRAME 0x2U
#define CAN3_CSR0_FRAME_BIT 1
#define CAN3_CSR0_CRC_MASK 0x4U
#define CAN3_CSR0_CRC 0x4U
#define CAN3_CSR0_CRC_BIT 2
#define CAN3_CSR0_STUFF_MASK 0x8U
#define CAN3_CSR0_STUFF 0x8U
#define CAN3_CSR0_STUFF_BIT 3
#define CAN3_CSR0_BUS_MASK 0x10U
#define CAN3_CSR0_BUS 0x10U
#define CAN3_CSR0_BUS_BIT 4
#define CAN3_CSR0_RXOK_MASK 0x20U
#define CAN3_CSR0_RXOK 0x20U
#define CAN3_CSR0_RXOK_BIT 5
#define CAN3_CSR0_TXOK_MASK 0x40U
#define CAN3_CSR0_TXOK 0x40U
#define CAN3_CSR0_TXOK_BIT 6
#define CAN3_CSR0_RFRAME_MASK 0x80U
#define CAN3_CSR0_RFRAME 0x80U
#define CAN3_CSR0_RFRAME_BIT 7
#define CAN3_CSR0_DLCW_MASK 0x200U
#define CAN3_CSR0_DLCW 0x200U
#define CAN3_CSR0_DLCW_BIT 9
#define CAN3_CSR0_FILLED_MASK 0x400U
#define CAN3_CSR0_FILLED 0x400U
#define CAN3_CSR0_FILLED_BIT 10
#define CAN3_CSR0_OVRUN_MASK 0x800U
#define CAN3_CSR0_OVRUN 0x800U
#define CAN3_CSR0_OVRUN_BIT 11

#define CAN3_SR0 (*(volatile unsigned long *)0xFFFB011C)
#define CAN3_SR0_OFFSET 0x11C
#define CAN3_SR0_ACK_MASK 0x1U
#define CAN3_SR0_ACK 0x1U
#define CAN3_SR0_ACK_BIT 0
#define CAN3_SR0_FRAME_MASK 0x2U
#define CAN3_SR0_FRAME 0x2U
#define CAN3_SR0_FRAME_BIT 1
#define CAN3_SR0_CRC_MASK 0x4U
#define CAN3_SR0_CRC 0x4U
#define CAN3_SR0_CRC_BIT 2
#define CAN3_SR0_STUFF_MASK 0x8U
#define CAN3_SR0_STUFF 0x8U
#define CAN3_SR0_STUFF_BIT 3
#define CAN3_SR0_BUS_MASK 0x10U
#define CAN3_SR0_BUS 0x10U
#define CAN3_SR0_BUS_BIT 4
#define CAN3_SR0_RXOK_MASK 0x20U
#define CAN3_SR0_RXOK 0x20U
#define CAN3_SR0_RXOK_BIT 5
#define CAN3_SR0_TXOK_MASK 0x40U
#define CAN3_SR0_TXOK 0x40U
#define CAN3_SR0_TXOK_BIT 6
#define CAN3_SR0_RFRAME_MASK 0x80U
#define CAN3_SR0_RFRAME 0x80U
#define CAN3_SR0_RFRAME_BIT 7
#define CAN3_SR0_DLCW_MASK 0x200U
#define CAN3_SR0_DLCW 0x200U
#define CAN3_SR0_DLCW_BIT 9
#define CAN3_SR0_FILLED_MASK 0x400U
#define CAN3_SR0_FILLED 0x400U
#define CAN3_SR0_FILLED_BIT 10
#define CAN3_SR0_OVRUN_MASK 0x800U
#define CAN3_SR0_OVRUN 0x800U
#define CAN3_SR0_OVRUN_BIT 11

#define CAN3_IER0 (*(volatile unsigned long *)0xFFFB0120)
#define CAN3_IER0_OFFSET 0x120
#define CAN3_IER0_ACK_MASK 0x1U
#define CAN3_IER0_ACK 0x1U
#define CAN3_IER0_ACK_BIT 0
#define CAN3_IER0_FRAME_MASK 0x2U
#define CAN3_IER0_FRAME 0x2U
#define CAN3_IER0_FRAME_BIT 1
#define CAN3_IER0_CRC_MASK 0x4U
#define CAN3_IER0_CRC 0x4U
#define CAN3_IER0_CRC_BIT 2
#define CAN3_IER0_STUFF_MASK 0x8U
#define CAN3_IER0_STUFF 0x8U
#define CAN3_IER0_STUFF_BIT 3
#define CAN3_IER0_BUS_MASK 0x10U
#define CAN3_IER0_BUS 0x10U
#define CAN3_IER0_BUS_BIT 4
#define CAN3_IER0_RXOK_MASK 0x20U
#define CAN3_IER0_RXOK 0x20U
#define CAN3_IER0_RXOK_BIT 5
#define CAN3_IER0_TXOK_MASK 0x40U
#define CAN3_IER0_TXOK 0x40U
#define CAN3_IER0_TXOK_BIT 6
#define CAN3_IER0_RFRAME_MASK 0x80U
#define CAN3_IER0_RFRAME 0x80U
#define CAN3_IER0_RFRAME_BIT 7

#define CAN3_IDR0 (*(volatile unsigned long *)0xFFFB0124)
#define CAN3_IDR0_OFFSET 0x124
#define CAN3_IDR0_ACK_MASK 0x1U
#define CAN3_IDR0_ACK 0x1U
#define CAN3_IDR0_ACK_BIT 0
#define CAN3_IDR0_FRAME_MASK 0x2U
#define CAN3_IDR0_FRAME 0x2U
#define CAN3_IDR0_FRAME_BIT 1
#define CAN3_IDR0_CRC_MASK 0x4U
#define CAN3_IDR0_CRC 0x4U
#define CAN3_IDR0_CRC_BIT 2
#define CAN3_IDR0_STUFF_MASK 0x8U
#define CAN3_IDR0_STUFF 0x8U
#define CAN3_IDR0_STUFF_BIT 3
#define CAN3_IDR0_BUS_MASK 0x10U
#define CAN3_IDR0_BUS 0x10U
#define CAN3_IDR0_BUS_BIT 4
#define CAN3_IDR0_RXOK_MASK 0x20U
#define CAN3_IDR0_RXOK 0x20U
#define CAN3_IDR0_RXOK_BIT 5
#define CAN3_IDR0_TXOK_MASK 0x40U
#define CAN3_IDR0_TXOK 0x40U
#define CAN3_IDR0_TXOK_BIT 6
#define CAN3_IDR0_RFRAME_MASK 0x80U
#define CAN3_IDR0_RFRAME 0x80U
#define CAN3_IDR0_RFRAME_BIT 7

#define CAN3_IMR0 (*(volatile unsigned long *)0xFFFB0128)
#define CAN3_IMR0_OFFSET 0x128
#define CAN3_IMR0_ACK_MASK 0x1U
#define CAN3_IMR0_ACK 0x1U
#define CAN3_IMR0_ACK_BIT 0
#define CAN3_IMR0_FRAME_MASK 0x2U
#define CAN3_IMR0_FRAME 0x2U
#define CAN3_IMR0_FRAME_BIT 1
#define CAN3_IMR0_CRC_MASK 0x4U
#define CAN3_IMR0_CRC 0x4U
#define CAN3_IMR0_CRC_BIT 2
#define CAN3_IMR0_STUFF_MASK 0x8U
#define CAN3_IMR0_STUFF 0x8U
#define CAN3_IMR0_STUFF_BIT 3
#define CAN3_IMR0_BUS_MASK 0x10U
#define CAN3_IMR0_BUS 0x10U
#define CAN3_IMR0_BUS_BIT 4
#define CAN3_IMR0_RXOK_MASK 0x20U
#define CAN3_IMR0_RXOK 0x20U
#define CAN3_IMR0_RXOK_BIT 5
#define CAN3_IMR0_TXOK_MASK 0x40U
#define CAN3_IMR0_TXOK 0x40U
#define CAN3_IMR0_TXOK_BIT 6
#define CAN3_IMR0_RFRAME_MASK 0x80U
#define CAN3_IMR0_RFRAME 0x80U
#define CAN3_IMR0_RFRAME_BIT 7

#define CAN3_DRA1 (*(volatile unsigned long *)0xFFFB0140)
#define CAN3_DRA1_OFFSET 0x140
#define CAN3_DRA1_DATA0_MASK 0xFFU
#define CAN3_DRA1_DATA0_BIT 0
#define CAN3_DRA1_DATA1_MASK 0xFF00U
#define CAN3_DRA1_DATA1_BIT 8
#define CAN3_DRA1_DATA2_MASK 0xFF0000U
#define CAN3_DRA1_DATA2_BIT 16
#define CAN3_DRA1_DATA3_MASK 0xFF000000U
#define CAN3_DRA1_DATA3_BIT 24

#define CAN3_DRB1 (*(volatile unsigned long *)0xFFFB0144)
#define CAN3_DRB1_OFFSET 0x144
#define CAN3_DRB1_DATA4_MASK 0xFFU
#define CAN3_DRB1_DATA4_BIT 0
#define CAN3_DRB1_DATA5_MASK 0xFF00U
#define CAN3_DRB1_DATA5_BIT 8
#define CAN3_DRB1_DATA6_MASK 0xFF0000U
#define CAN3_DRB1_DATA6_BIT 16
#define CAN3_DRB1_DATA7_MASK 0xFF000000U
#define CAN3_DRB1_DATA7_BIT 24

#define CAN3_MSK1 (*(volatile unsigned long *)0xFFFB0148)
#define CAN3_MSK1_OFFSET 0x148
#define CAN3_MSK1_MASK_MASK 0x1FFFFFFFU
#define CAN3_MSK1_MASK_BIT 0
#define CAN3_MSK1_MRB_MASK 0x60000000U
#define CAN3_MSK1_MRB_BIT 29
#define CAN3_MSK1_MRTR_MASK 0x80000000U
#define CAN3_MSK1_MRTR 0x80000000U
#define CAN3_MSK1_MRTR_BIT 31

#define CAN3_IR1 (*(volatile unsigned long *)0xFFFB014C)
#define CAN3_IR1_OFFSET 0x14C
#define CAN3_IR1_ID_MASK 0x1FFFFFFFU
#define CAN3_IR1_ID_BIT 0
#define CAN3_IR1_RB_MASK 0x60000000U
#define CAN3_IR1_RB_BIT 29
#define CAN3_IR1_RTR_MASK 0x80000000U
#define CAN3_IR1_RTR 0x80000000U
#define CAN3_IR1_RTR_BIT 31

#define CAN3_CR1 (*(volatile unsigned long *)0xFFFB0150)
#define CAN3_CR1_OFFSET 0x150
#define CAN3_CR1_DLC_MASK 0xFU
#define CAN3_CR1_DLC_BIT 0
#define CAN3_CR1_IDE_MASK 0x10U
#define CAN3_CR1_IDE 0x10U
#define CAN3_CR1_IDE_BIT 4
#define CAN3_CR1_RPLYV_MASK 0x20U
#define CAN3_CR1_RPLYV 0x20U
#define CAN3_CR1_RPLYV_BIT 5
#define CAN3_CR1_PCB_MASK 0x40U
#define CAN3_CR1_PCB 0x40U
#define CAN3_CR1_PCB_BIT 6
#define CAN3_CR1_CHANEN_MASK 0x80U
#define CAN3_CR1_CHANEN 0x80U
#define CAN3_CR1_CHANEN_BIT 7
#define CAN3_CR1_OVERWRITE_MASK 0x100U
#define CAN3_CR1_OVERWRITE 0x100U
#define CAN3_CR1_OVERWRITE_BIT 8

#define CAN3_CR1 (*(volatile unsigned long *)0xFFFB0154)
#define CAN3_CR1_OFFSET 0x154
#define CAN3_CR1_STAMP_MASK 0x0U
#define CAN3_CR1_STAMP_BIT 0

#define CAN3_CSR1 (*(volatile unsigned long *)0xFFFB0158)
#define CAN3_CSR1_OFFSET 0x158
#define CAN3_CSR1_ACK_MASK 0x1U
#define CAN3_CSR1_ACK 0x1U
#define CAN3_CSR1_ACK_BIT 0
#define CAN3_CSR1_FRAME_MASK 0x2U
#define CAN3_CSR1_FRAME 0x2U
#define CAN3_CSR1_FRAME_BIT 1
#define CAN3_CSR1_CRC_MASK 0x4U
#define CAN3_CSR1_CRC 0x4U
#define CAN3_CSR1_CRC_BIT 2
#define CAN3_CSR1_STUFF_MASK 0x8U
#define CAN3_CSR1_STUFF 0x8U
#define CAN3_CSR1_STUFF_BIT 3
#define CAN3_CSR1_BUS_MASK 0x10U
#define CAN3_CSR1_BUS 0x10U
#define CAN3_CSR1_BUS_BIT 4
#define CAN3_CSR1_RXOK_MASK 0x20U
#define CAN3_CSR1_RXOK 0x20U
#define CAN3_CSR1_RXOK_BIT 5
#define CAN3_CSR1_TXOK_MASK 0x40U
#define CAN3_CSR1_TXOK 0x40U
#define CAN3_CSR1_TXOK_BIT 6
#define CAN3_CSR1_RFRAME_MASK 0x80U
#define CAN3_CSR1_RFRAME 0x80U
#define CAN3_CSR1_RFRAME_BIT 7
#define CAN3_CSR1_DLCW_MASK 0x200U
#define CAN3_CSR1_DLCW 0x200U
#define CAN3_CSR1_DLCW_BIT 9
#define CAN3_CSR1_FILLED_MASK 0x400U
#define CAN3_CSR1_FILLED 0x400U
#define CAN3_CSR1_FILLED_BIT 10
#define CAN3_CSR1_OVRUN_MASK 0x800U
#define CAN3_CSR1_OVRUN 0x800U
#define CAN3_CSR1_OVRUN_BIT 11

#define CAN3_SR1 (*(volatile unsigned long *)0xFFFB015C)
#define CAN3_SR1_OFFSET 0x15C
#define CAN3_SR1_ACK_MASK 0x1U
#define CAN3_SR1_ACK 0x1U
#define CAN3_SR1_ACK_BIT 0
#define CAN3_SR1_FRAME_MASK 0x2U
#define CAN3_SR1_FRAME 0x2U
#define CAN3_SR1_FRAME_BIT 1
#define CAN3_SR1_CRC_MASK 0x4U
#define CAN3_SR1_CRC 0x4U
#define CAN3_SR1_CRC_BIT 2
#define CAN3_SR1_STUFF_MASK 0x8U
#define CAN3_SR1_STUFF 0x8U
#define CAN3_SR1_STUFF_BIT 3
#define CAN3_SR1_BUS_MASK 0x10U
#define CAN3_SR1_BUS 0x10U
#define CAN3_SR1_BUS_BIT 4
#define CAN3_SR1_RXOK_MASK 0x20U
#define CAN3_SR1_RXOK 0x20U
#define CAN3_SR1_RXOK_BIT 5
#define CAN3_SR1_TXOK_MASK 0x40U
#define CAN3_SR1_TXOK 0x40U
#define CAN3_SR1_TXOK_BIT 6
#define CAN3_SR1_RFRAME_MASK 0x80U
#define CAN3_SR1_RFRAME 0x80U
#define CAN3_SR1_RFRAME_BIT 7
#define CAN3_SR1_DLCW_MASK 0x200U
#define CAN3_SR1_DLCW 0x200U
#define CAN3_SR1_DLCW_BIT 9
#define CAN3_SR1_FILLED_MASK 0x400U
#define CAN3_SR1_FILLED 0x400U
#define CAN3_SR1_FILLED_BIT 10
#define CAN3_SR1_OVRUN_MASK 0x800U
#define CAN3_SR1_OVRUN 0x800U
#define CAN3_SR1_OVRUN_BIT 11

#define CAN3_IER1 (*(volatile unsigned long *)0xFFFB0160)
#define CAN3_IER1_OFFSET 0x160
#define CAN3_IER1_ACK_MASK 0x1U
#define CAN3_IER1_ACK 0x1U
#define CAN3_IER1_ACK_BIT 0
#define CAN3_IER1_FRAME_MASK 0x2U
#define CAN3_IER1_FRAME 0x2U
#define CAN3_IER1_FRAME_BIT 1
#define CAN3_IER1_CRC_MASK 0x4U
#define CAN3_IER1_CRC 0x4U
#define CAN3_IER1_CRC_BIT 2
#define CAN3_IER1_STUFF_MASK 0x8U
#define CAN3_IER1_STUFF 0x8U
#define CAN3_IER1_STUFF_BIT 3
#define CAN3_IER1_BUS_MASK 0x10U
#define CAN3_IER1_BUS 0x10U
#define CAN3_IER1_BUS_BIT 4
#define CAN3_IER1_RXOK_MASK 0x20U
#define CAN3_IER1_RXOK 0x20U
#define CAN3_IER1_RXOK_BIT 5
#define CAN3_IER1_TXOK_MASK 0x40U
#define CAN3_IER1_TXOK 0x40U
#define CAN3_IER1_TXOK_BIT 6
#define CAN3_IER1_RFRAME_MASK 0x80U
#define CAN3_IER1_RFRAME 0x80U
#define CAN3_IER1_RFRAME_BIT 7

#define CAN3_IDR1 (*(volatile unsigned long *)0xFFFB0164)
#define CAN3_IDR1_OFFSET 0x164
#define CAN3_IDR1_ACK_MASK 0x1U
#define CAN3_IDR1_ACK 0x1U
#define CAN3_IDR1_ACK_BIT 0
#define CAN3_IDR1_FRAME_MASK 0x2U
#define CAN3_IDR1_FRAME 0x2U
#define CAN3_IDR1_FRAME_BIT 1
#define CAN3_IDR1_CRC_MASK 0x4U
#define CAN3_IDR1_CRC 0x4U
#define CAN3_IDR1_CRC_BIT 2
#define CAN3_IDR1_STUFF_MASK 0x8U
#define CAN3_IDR1_STUFF 0x8U
#define CAN3_IDR1_STUFF_BIT 3
#define CAN3_IDR1_BUS_MASK 0x10U
#define CAN3_IDR1_BUS 0x10U
#define CAN3_IDR1_BUS_BIT 4
#define CAN3_IDR1_RXOK_MASK 0x20U
#define CAN3_IDR1_RXOK 0x20U
#define CAN3_IDR1_RXOK_BIT 5
#define CAN3_IDR1_TXOK_MASK 0x40U
#define CAN3_IDR1_TXOK 0x40U
#define CAN3_IDR1_TXOK_BIT 6
#define CAN3_IDR1_RFRAME_MASK 0x80U
#define CAN3_IDR1_RFRAME 0x80U
#define CAN3_IDR1_RFRAME_BIT 7

#define CAN3_IMR1 (*(volatile unsigned long *)0xFFFB0168)
#define CAN3_IMR1_OFFSET 0x168
#define CAN3_IMR1_ACK_MASK 0x1U
#define CAN3_IMR1_ACK 0x1U
#define CAN3_IMR1_ACK_BIT 0
#define CAN3_IMR1_FRAME_MASK 0x2U
#define CAN3_IMR1_FRAME 0x2U
#define CAN3_IMR1_FRAME_BIT 1
#define CAN3_IMR1_CRC_MASK 0x4U
#define CAN3_IMR1_CRC 0x4U
#define CAN3_IMR1_CRC_BIT 2
#define CAN3_IMR1_STUFF_MASK 0x8U
#define CAN3_IMR1_STUFF 0x8U
#define CAN3_IMR1_STUFF_BIT 3
#define CAN3_IMR1_BUS_MASK 0x10U
#define CAN3_IMR1_BUS 0x10U
#define CAN3_IMR1_BUS_BIT 4
#define CAN3_IMR1_RXOK_MASK 0x20U
#define CAN3_IMR1_RXOK 0x20U
#define CAN3_IMR1_RXOK_BIT 5
#define CAN3_IMR1_TXOK_MASK 0x40U
#define CAN3_IMR1_TXOK 0x40U
#define CAN3_IMR1_TXOK_BIT 6
#define CAN3_IMR1_RFRAME_MASK 0x80U
#define CAN3_IMR1_RFRAME 0x80U
#define CAN3_IMR1_RFRAME_BIT 7

#define CAN3_DRA2 (*(volatile unsigned long *)0xFFFB0180)
#define CAN3_DRA2_OFFSET 0x180
#define CAN3_DRA2_DATA0_MASK 0xFFU
#define CAN3_DRA2_DATA0_BIT 0
#define CAN3_DRA2_DATA1_MASK 0xFF00U
#define CAN3_DRA2_DATA1_BIT 8
#define CAN3_DRA2_DATA2_MASK 0xFF0000U
#define CAN3_DRA2_DATA2_BIT 16
#define CAN3_DRA2_DATA3_MASK 0xFF000000U
#define CAN3_DRA2_DATA3_BIT 24

#define CAN3_DRB2 (*(volatile unsigned long *)0xFFFB0184)
#define CAN3_DRB2_OFFSET 0x184
#define CAN3_DRB2_DATA4_MASK 0xFFU
#define CAN3_DRB2_DATA4_BIT 0
#define CAN3_DRB2_DATA5_MASK 0xFF00U
#define CAN3_DRB2_DATA5_BIT 8
#define CAN3_DRB2_DATA6_MASK 0xFF0000U
#define CAN3_DRB2_DATA6_BIT 16
#define CAN3_DRB2_DATA7_MASK 0xFF000000U
#define CAN3_DRB2_DATA7_BIT 24

#define CAN3_MSK2 (*(volatile unsigned long *)0xFFFB0188)
#define CAN3_MSK2_OFFSET 0x188
#define CAN3_MSK2_MASK_MASK 0x1FFFFFFFU
#define CAN3_MSK2_MASK_BIT 0
#define CAN3_MSK2_MRB_MASK 0x60000000U
#define CAN3_MSK2_MRB_BIT 29
#define CAN3_MSK2_MRTR_MASK 0x80000000U
#define CAN3_MSK2_MRTR 0x80000000U
#define CAN3_MSK2_MRTR_BIT 31

#define CAN3_IR2 (*(volatile unsigned long *)0xFFFB018C)
#define CAN3_IR2_OFFSET 0x18C
#define CAN3_IR2_ID_MASK 0x1FFFFFFFU
#define CAN3_IR2_ID_BIT 0
#define CAN3_IR2_RB_MASK 0x60000000U
#define CAN3_IR2_RB_BIT 29
#define CAN3_IR2_RTR_MASK 0x80000000U
#define CAN3_IR2_RTR 0x80000000U
#define CAN3_IR2_RTR_BIT 31

#define CAN3_CR2 (*(volatile unsigned long *)0xFFFB0190)
#define CAN3_CR2_OFFSET 0x190
#define CAN3_CR2_DLC_MASK 0xFU
#define CAN3_CR2_DLC_BIT 0
#define CAN3_CR2_IDE_MASK 0x10U
#define CAN3_CR2_IDE 0x10U
#define CAN3_CR2_IDE_BIT 4
#define CAN3_CR2_RPLYV_MASK 0x20U
#define CAN3_CR2_RPLYV 0x20U
#define CAN3_CR2_RPLYV_BIT 5
#define CAN3_CR2_PCB_MASK 0x40U
#define CAN3_CR2_PCB 0x40U
#define CAN3_CR2_PCB_BIT 6
#define CAN3_CR2_CHANEN_MASK 0x80U
#define CAN3_CR2_CHANEN 0x80U
#define CAN3_CR2_CHANEN_BIT 7
#define CAN3_CR2_OVERWRITE_MASK 0x100U
#define CAN3_CR2_OVERWRITE 0x100U
#define CAN3_CR2_OVERWRITE_BIT 8

#define CAN3_CR2 (*(volatile unsigned long *)0xFFFB0194)
#define CAN3_CR2_OFFSET 0x194
#define CAN3_CR2_STAMP_MASK 0x0U
#define CAN3_CR2_STAMP_BIT 0

#define CAN3_CSR2 (*(volatile unsigned long *)0xFFFB0198)
#define CAN3_CSR2_OFFSET 0x198
#define CAN3_CSR2_ACK_MASK 0x1U
#define CAN3_CSR2_ACK 0x1U
#define CAN3_CSR2_ACK_BIT 0
#define CAN3_CSR2_FRAME_MASK 0x2U
#define CAN3_CSR2_FRAME 0x2U
#define CAN3_CSR2_FRAME_BIT 1
#define CAN3_CSR2_CRC_MASK 0x4U
#define CAN3_CSR2_CRC 0x4U
#define CAN3_CSR2_CRC_BIT 2
#define CAN3_CSR2_STUFF_MASK 0x8U
#define CAN3_CSR2_STUFF 0x8U
#define CAN3_CSR2_STUFF_BIT 3
#define CAN3_CSR2_BUS_MASK 0x10U
#define CAN3_CSR2_BUS 0x10U
#define CAN3_CSR2_BUS_BIT 4
#define CAN3_CSR2_RXOK_MASK 0x20U
#define CAN3_CSR2_RXOK 0x20U
#define CAN3_CSR2_RXOK_BIT 5
#define CAN3_CSR2_TXOK_MASK 0x40U
#define CAN3_CSR2_TXOK 0x40U
#define CAN3_CSR2_TXOK_BIT 6
#define CAN3_CSR2_RFRAME_MASK 0x80U
#define CAN3_CSR2_RFRAME 0x80U
#define CAN3_CSR2_RFRAME_BIT 7
#define CAN3_CSR2_DLCW_MASK 0x200U
#define CAN3_CSR2_DLCW 0x200U
#define CAN3_CSR2_DLCW_BIT 9
#define CAN3_CSR2_FILLED_MASK 0x400U
#define CAN3_CSR2_FILLED 0x400U
#define CAN3_CSR2_FILLED_BIT 10
#define CAN3_CSR2_OVRUN_MASK 0x800U
#define CAN3_CSR2_OVRUN 0x800U
#define CAN3_CSR2_OVRUN_BIT 11

#define CAN3_SR2 (*(volatile unsigned long *)0xFFFB019C)
#define CAN3_SR2_OFFSET 0x19C
#define CAN3_SR2_ACK_MASK 0x1U
#define CAN3_SR2_ACK 0x1U
#define CAN3_SR2_ACK_BIT 0
#define CAN3_SR2_FRAME_MASK 0x2U
#define CAN3_SR2_FRAME 0x2U
#define CAN3_SR2_FRAME_BIT 1
#define CAN3_SR2_CRC_MASK 0x4U
#define CAN3_SR2_CRC 0x4U
#define CAN3_SR2_CRC_BIT 2
#define CAN3_SR2_STUFF_MASK 0x8U
#define CAN3_SR2_STUFF 0x8U
#define CAN3_SR2_STUFF_BIT 3
#define CAN3_SR2_BUS_MASK 0x10U
#define CAN3_SR2_BUS 0x10U
#define CAN3_SR2_BUS_BIT 4
#define CAN3_SR2_RXOK_MASK 0x20U
#define CAN3_SR2_RXOK 0x20U
#define CAN3_SR2_RXOK_BIT 5
#define CAN3_SR2_TXOK_MASK 0x40U
#define CAN3_SR2_TXOK 0x40U
#define CAN3_SR2_TXOK_BIT 6
#define CAN3_SR2_RFRAME_MASK 0x80U
#define CAN3_SR2_RFRAME 0x80U
#define CAN3_SR2_RFRAME_BIT 7
#define CAN3_SR2_DLCW_MASK 0x200U
#define CAN3_SR2_DLCW 0x200U
#define CAN3_SR2_DLCW_BIT 9
#define CAN3_SR2_FILLED_MASK 0x400U
#define CAN3_SR2_FILLED 0x400U
#define CAN3_SR2_FILLED_BIT 10
#define CAN3_SR2_OVRUN_MASK 0x800U
#define CAN3_SR2_OVRUN 0x800U
#define CAN3_SR2_OVRUN_BIT 11

#define CAN3_IER2 (*(volatile unsigned long *)0xFFFB01A0)
#define CAN3_IER2_OFFSET 0x1A0
#define CAN3_IER2_ACK_MASK 0x1U
#define CAN3_IER2_ACK 0x1U
#define CAN3_IER2_ACK_BIT 0
#define CAN3_IER2_FRAME_MASK 0x2U
#define CAN3_IER2_FRAME 0x2U
#define CAN3_IER2_FRAME_BIT 1
#define CAN3_IER2_CRC_MASK 0x4U
#define CAN3_IER2_CRC 0x4U
#define CAN3_IER2_CRC_BIT 2
#define CAN3_IER2_STUFF_MASK 0x8U
#define CAN3_IER2_STUFF 0x8U
#define CAN3_IER2_STUFF_BIT 3
#define CAN3_IER2_BUS_MASK 0x10U
#define CAN3_IER2_BUS 0x10U
#define CAN3_IER2_BUS_BIT 4
#define CAN3_IER2_RXOK_MASK 0x20U
#define CAN3_IER2_RXOK 0x20U
#define CAN3_IER2_RXOK_BIT 5
#define CAN3_IER2_TXOK_MASK 0x40U
#define CAN3_IER2_TXOK 0x40U
#define CAN3_IER2_TXOK_BIT 6
#define CAN3_IER2_RFRAME_MASK 0x80U
#define CAN3_IER2_RFRAME 0x80U
#define CAN3_IER2_RFRAME_BIT 7

#define CAN3_IDR2 (*(volatile unsigned long *)0xFFFB01A4)
#define CAN3_IDR2_OFFSET 0x1A4
#define CAN3_IDR2_ACK_MASK 0x1U
#define CAN3_IDR2_ACK 0x1U
#define CAN3_IDR2_ACK_BIT 0
#define CAN3_IDR2_FRAME_MASK 0x2U
#define CAN3_IDR2_FRAME 0x2U
#define CAN3_IDR2_FRAME_BIT 1
#define CAN3_IDR2_CRC_MASK 0x4U
#define CAN3_IDR2_CRC 0x4U
#define CAN3_IDR2_CRC_BIT 2
#define CAN3_IDR2_STUFF_MASK 0x8U
#define CAN3_IDR2_STUFF 0x8U
#define CAN3_IDR2_STUFF_BIT 3
#define CAN3_IDR2_BUS_MASK 0x10U
#define CAN3_IDR2_BUS 0x10U
#define CAN3_IDR2_BUS_BIT 4
#define CAN3_IDR2_RXOK_MASK 0x20U
#define CAN3_IDR2_RXOK 0x20U
#define CAN3_IDR2_RXOK_BIT 5
#define CAN3_IDR2_TXOK_MASK 0x40U
#define CAN3_IDR2_TXOK 0x40U
#define CAN3_IDR2_TXOK_BIT 6
#define CAN3_IDR2_RFRAME_MASK 0x80U
#define CAN3_IDR2_RFRAME 0x80U
#define CAN3_IDR2_RFRAME_BIT 7

#define CAN3_IMR2 (*(volatile unsigned long *)0xFFFB01A8)
#define CAN3_IMR2_OFFSET 0x1A8
#define CAN3_IMR2_ACK_MASK 0x1U
#define CAN3_IMR2_ACK 0x1U
#define CAN3_IMR2_ACK_BIT 0
#define CAN3_IMR2_FRAME_MASK 0x2U
#define CAN3_IMR2_FRAME 0x2U
#define CAN3_IMR2_FRAME_BIT 1
#define CAN3_IMR2_CRC_MASK 0x4U
#define CAN3_IMR2_CRC 0x4U
#define CAN3_IMR2_CRC_BIT 2
#define CAN3_IMR2_STUFF_MASK 0x8U
#define CAN3_IMR2_STUFF 0x8U
#define CAN3_IMR2_STUFF_BIT 3
#define CAN3_IMR2_BUS_MASK 0x10U
#define CAN3_IMR2_BUS 0x10U
#define CAN3_IMR2_BUS_BIT 4
#define CAN3_IMR2_RXOK_MASK 0x20U
#define CAN3_IMR2_RXOK 0x20U
#define CAN3_IMR2_RXOK_BIT 5
#define CAN3_IMR2_TXOK_MASK 0x40U
#define CAN3_IMR2_TXOK 0x40U
#define CAN3_IMR2_TXOK_BIT 6
#define CAN3_IMR2_RFRAME_MASK 0x80U
#define CAN3_IMR2_RFRAME 0x80U
#define CAN3_IMR2_RFRAME_BIT 7

#define CAN3_DRA3 (*(volatile unsigned long *)0xFFFB01C0)
#define CAN3_DRA3_OFFSET 0x1C0
#define CAN3_DRA3_DATA0_MASK 0xFFU
#define CAN3_DRA3_DATA0_BIT 0
#define CAN3_DRA3_DATA1_MASK 0xFF00U
#define CAN3_DRA3_DATA1_BIT 8
#define CAN3_DRA3_DATA2_MASK 0xFF0000U
#define CAN3_DRA3_DATA2_BIT 16
#define CAN3_DRA3_DATA3_MASK 0xFF000000U
#define CAN3_DRA3_DATA3_BIT 24

#define CAN3_DRB3 (*(volatile unsigned long *)0xFFFB01C4)
#define CAN3_DRB3_OFFSET 0x1C4
#define CAN3_DRB3_DATA4_MASK 0xFFU
#define CAN3_DRB3_DATA4_BIT 0
#define CAN3_DRB3_DATA5_MASK 0xFF00U
#define CAN3_DRB3_DATA5_BIT 8
#define CAN3_DRB3_DATA6_MASK 0xFF0000U
#define CAN3_DRB3_DATA6_BIT 16
#define CAN3_DRB3_DATA7_MASK 0xFF000000U
#define CAN3_DRB3_DATA7_BIT 24

#define CAN3_MSK3 (*(volatile unsigned long *)0xFFFB01C8)
#define CAN3_MSK3_OFFSET 0x1C8
#define CAN3_MSK3_MASK_MASK 0x1FFFFFFFU
#define CAN3_MSK3_MASK_BIT 0
#define CAN3_MSK3_MRB_MASK 0x60000000U
#define CAN3_MSK3_MRB_BIT 29
#define CAN3_MSK3_MRTR_MASK 0x80000000U
#define CAN3_MSK3_MRTR 0x80000000U
#define CAN3_MSK3_MRTR_BIT 31

#define CAN3_IR3 (*(volatile unsigned long *)0xFFFB01CC)
#define CAN3_IR3_OFFSET 0x1CC
#define CAN3_IR3_ID_MASK 0x1FFFFFFFU
#define CAN3_IR3_ID_BIT 0
#define CAN3_IR3_RB_MASK 0x60000000U
#define CAN3_IR3_RB_BIT 29
#define CAN3_IR3_RTR_MASK 0x80000000U
#define CAN3_IR3_RTR 0x80000000U
#define CAN3_IR3_RTR_BIT 31

#define CAN3_CR3 (*(volatile unsigned long *)0xFFFB01D0)
#define CAN3_CR3_OFFSET 0x1D0
#define CAN3_CR3_DLC_MASK 0xFU
#define CAN3_CR3_DLC_BIT 0
#define CAN3_CR3_IDE_MASK 0x10U
#define CAN3_CR3_IDE 0x10U
#define CAN3_CR3_IDE_BIT 4
#define CAN3_CR3_RPLYV_MASK 0x20U
#define CAN3_CR3_RPLYV 0x20U
#define CAN3_CR3_RPLYV_BIT 5
#define CAN3_CR3_PCB_MASK 0x40U
#define CAN3_CR3_PCB 0x40U
#define CAN3_CR3_PCB_BIT 6
#define CAN3_CR3_CHANEN_MASK 0x80U
#define CAN3_CR3_CHANEN 0x80U
#define CAN3_CR3_CHANEN_BIT 7
#define CAN3_CR3_OVERWRITE_MASK 0x100U
#define CAN3_CR3_OVERWRITE 0x100U
#define CAN3_CR3_OVERWRITE_BIT 8

#define CAN3_CR3 (*(volatile unsigned long *)0xFFFB01D4)
#define CAN3_CR3_OFFSET 0x1D4
#define CAN3_CR3_STAMP_MASK 0x0U
#define CAN3_CR3_STAMP_BIT 0

#define CAN3_CSR3 (*(volatile unsigned long *)0xFFFB01D8)
#define CAN3_CSR3_OFFSET 0x1D8
#define CAN3_CSR3_ACK_MASK 0x1U
#define CAN3_CSR3_ACK 0x1U
#define CAN3_CSR3_ACK_BIT 0
#define CAN3_CSR3_FRAME_MASK 0x2U
#define CAN3_CSR3_FRAME 0x2U
#define CAN3_CSR3_FRAME_BIT 1
#define CAN3_CSR3_CRC_MASK 0x4U
#define CAN3_CSR3_CRC 0x4U
#define CAN3_CSR3_CRC_BIT 2
#define CAN3_CSR3_STUFF_MASK 0x8U
#define CAN3_CSR3_STUFF 0x8U
#define CAN3_CSR3_STUFF_BIT 3
#define CAN3_CSR3_BUS_MASK 0x10U
#define CAN3_CSR3_BUS 0x10U
#define CAN3_CSR3_BUS_BIT 4
#define CAN3_CSR3_RXOK_MASK 0x20U
#define CAN3_CSR3_RXOK 0x20U
#define CAN3_CSR3_RXOK_BIT 5
#define CAN3_CSR3_TXOK_MASK 0x40U
#define CAN3_CSR3_TXOK 0x40U
#define CAN3_CSR3_TXOK_BIT 6
#define CAN3_CSR3_RFRAME_MASK 0x80U
#define CAN3_CSR3_RFRAME 0x80U
#define CAN3_CSR3_RFRAME_BIT 7
#define CAN3_CSR3_DLCW_MASK 0x200U
#define CAN3_CSR3_DLCW 0x200U
#define CAN3_CSR3_DLCW_BIT 9
#define CAN3_CSR3_FILLED_MASK 0x400U
#define CAN3_CSR3_FILLED 0x400U
#define CAN3_CSR3_FILLED_BIT 10
#define CAN3_CSR3_OVRUN_MASK 0x800U
#define CAN3_CSR3_OVRUN 0x800U
#define CAN3_CSR3_OVRUN_BIT 11

#define CAN3_SR3 (*(volatile unsigned long *)0xFFFB01DC)
#define CAN3_SR3_OFFSET 0x1DC
#define CAN3_SR3_ACK_MASK 0x1U
#define CAN3_SR3_ACK 0x1U
#define CAN3_SR3_ACK_BIT 0
#define CAN3_SR3_FRAME_MASK 0x2U
#define CAN3_SR3_FRAME 0x2U
#define CAN3_SR3_FRAME_BIT 1
#define CAN3_SR3_CRC_MASK 0x4U
#define CAN3_SR3_CRC 0x4U
#define CAN3_SR3_CRC_BIT 2
#define CAN3_SR3_STUFF_MASK 0x8U
#define CAN3_SR3_STUFF 0x8U
#define CAN3_SR3_STUFF_BIT 3
#define CAN3_SR3_BUS_MASK 0x10U
#define CAN3_SR3_BUS 0x10U
#define CAN3_SR3_BUS_BIT 4
#define CAN3_SR3_RXOK_MASK 0x20U
#define CAN3_SR3_RXOK 0x20U
#define CAN3_SR3_RXOK_BIT 5
#define CAN3_SR3_TXOK_MASK 0x40U
#define CAN3_SR3_TXOK 0x40U
#define CAN3_SR3_TXOK_BIT 6
#define CAN3_SR3_RFRAME_MASK 0x80U
#define CAN3_SR3_RFRAME 0x80U
#define CAN3_SR3_RFRAME_BIT 7
#define CAN3_SR3_DLCW_MASK 0x200U
#define CAN3_SR3_DLCW 0x200U
#define CAN3_SR3_DLCW_BIT 9
#define CAN3_SR3_FILLED_MASK 0x400U
#define CAN3_SR3_FILLED 0x400U
#define CAN3_SR3_FILLED_BIT 10
#define CAN3_SR3_OVRUN_MASK 0x800U
#define CAN3_SR3_OVRUN 0x800U
#define CAN3_SR3_OVRUN_BIT 11

#define CAN3_IER3 (*(volatile unsigned long *)0xFFFB01E0)
#define CAN3_IER3_OFFSET 0x1E0
#define CAN3_IER3_ACK_MASK 0x1U
#define CAN3_IER3_ACK 0x1U
#define CAN3_IER3_ACK_BIT 0
#define CAN3_IER3_FRAME_MASK 0x2U
#define CAN3_IER3_FRAME 0x2U
#define CAN3_IER3_FRAME_BIT 1
#define CAN3_IER3_CRC_MASK 0x4U
#define CAN3_IER3_CRC 0x4U
#define CAN3_IER3_CRC_BIT 2
#define CAN3_IER3_STUFF_MASK 0x8U
#define CAN3_IER3_STUFF 0x8U
#define CAN3_IER3_STUFF_BIT 3
#define CAN3_IER3_BUS_MASK 0x10U
#define CAN3_IER3_BUS 0x10U
#define CAN3_IER3_BUS_BIT 4
#define CAN3_IER3_RXOK_MASK 0x20U
#define CAN3_IER3_RXOK 0x20U
#define CAN3_IER3_RXOK_BIT 5
#define CAN3_IER3_TXOK_MASK 0x40U
#define CAN3_IER3_TXOK 0x40U
#define CAN3_IER3_TXOK_BIT 6
#define CAN3_IER3_RFRAME_MASK 0x80U
#define CAN3_IER3_RFRAME 0x80U
#define CAN3_IER3_RFRAME_BIT 7

#define CAN3_IDR3 (*(volatile unsigned long *)0xFFFB01E4)
#define CAN3_IDR3_OFFSET 0x1E4
#define CAN3_IDR3_ACK_MASK 0x1U
#define CAN3_IDR3_ACK 0x1U
#define CAN3_IDR3_ACK_BIT 0
#define CAN3_IDR3_FRAME_MASK 0x2U
#define CAN3_IDR3_FRAME 0x2U
#define CAN3_IDR3_FRAME_BIT 1
#define CAN3_IDR3_CRC_MASK 0x4U
#define CAN3_IDR3_CRC 0x4U
#define CAN3_IDR3_CRC_BIT 2
#define CAN3_IDR3_STUFF_MASK 0x8U
#define CAN3_IDR3_STUFF 0x8U
#define CAN3_IDR3_STUFF_BIT 3
#define CAN3_IDR3_BUS_MASK 0x10U
#define CAN3_IDR3_BUS 0x10U
#define CAN3_IDR3_BUS_BIT 4
#define CAN3_IDR3_RXOK_MASK 0x20U
#define CAN3_IDR3_RXOK 0x20U
#define CAN3_IDR3_RXOK_BIT 5
#define CAN3_IDR3_TXOK_MASK 0x40U
#define CAN3_IDR3_TXOK 0x40U
#define CAN3_IDR3_TXOK_BIT 6
#define CAN3_IDR3_RFRAME_MASK 0x80U
#define CAN3_IDR3_RFRAME 0x80U
#define CAN3_IDR3_RFRAME_BIT 7

#define CAN3_IMR3 (*(volatile unsigned long *)0xFFFB01E8)
#define CAN3_IMR3_OFFSET 0x1E8
#define CAN3_IMR3_ACK_MASK 0x1U
#define CAN3_IMR3_ACK 0x1U
#define CAN3_IMR3_ACK_BIT 0
#define CAN3_IMR3_FRAME_MASK 0x2U
#define CAN3_IMR3_FRAME 0x2U
#define CAN3_IMR3_FRAME_BIT 1
#define CAN3_IMR3_CRC_MASK 0x4U
#define CAN3_IMR3_CRC 0x4U
#define CAN3_IMR3_CRC_BIT 2
#define CAN3_IMR3_STUFF_MASK 0x8U
#define CAN3_IMR3_STUFF 0x8U
#define CAN3_IMR3_STUFF_BIT 3
#define CAN3_IMR3_BUS_MASK 0x10U
#define CAN3_IMR3_BUS 0x10U
#define CAN3_IMR3_BUS_BIT 4
#define CAN3_IMR3_RXOK_MASK 0x20U
#define CAN3_IMR3_RXOK 0x20U
#define CAN3_IMR3_RXOK_BIT 5
#define CAN3_IMR3_TXOK_MASK 0x40U
#define CAN3_IMR3_TXOK 0x40U
#define CAN3_IMR3_TXOK_BIT 6
#define CAN3_IMR3_RFRAME_MASK 0x80U
#define CAN3_IMR3_RFRAME 0x80U
#define CAN3_IMR3_RFRAME_BIT 7

#define CAN3_DRA4 (*(volatile unsigned long *)0xFFFB0200)
#define CAN3_DRA4_OFFSET 0x200
#define CAN3_DRA4_DATA0_MASK 0xFFU
#define CAN3_DRA4_DATA0_BIT 0
#define CAN3_DRA4_DATA1_MASK 0xFF00U
#define CAN3_DRA4_DATA1_BIT 8
#define CAN3_DRA4_DATA2_MASK 0xFF0000U
#define CAN3_DRA4_DATA2_BIT 16
#define CAN3_DRA4_DATA3_MASK 0xFF000000U
#define CAN3_DRA4_DATA3_BIT 24

#define CAN3_DRB4 (*(volatile unsigned long *)0xFFFB0204)
#define CAN3_DRB4_OFFSET 0x204
#define CAN3_DRB4_DATA4_MASK 0xFFU
#define CAN3_DRB4_DATA4_BIT 0
#define CAN3_DRB4_DATA5_MASK 0xFF00U
#define CAN3_DRB4_DATA5_BIT 8
#define CAN3_DRB4_DATA6_MASK 0xFF0000U
#define CAN3_DRB4_DATA6_BIT 16
#define CAN3_DRB4_DATA7_MASK 0xFF000000U
#define CAN3_DRB4_DATA7_BIT 24

#define CAN3_MSK4 (*(volatile unsigned long *)0xFFFB0208)
#define CAN3_MSK4_OFFSET 0x208
#define CAN3_MSK4_MASK_MASK 0x1FFFFFFFU
#define CAN3_MSK4_MASK_BIT 0
#define CAN3_MSK4_MRB_MASK 0x60000000U
#define CAN3_MSK4_MRB_BIT 29
#define CAN3_MSK4_MRTR_MASK 0x80000000U
#define CAN3_MSK4_MRTR 0x80000000U
#define CAN3_MSK4_MRTR_BIT 31

#define CAN3_IR4 (*(volatile unsigned long *)0xFFFB020C)
#define CAN3_IR4_OFFSET 0x20C
#define CAN3_IR4_ID_MASK 0x1FFFFFFFU
#define CAN3_IR4_ID_BIT 0
#define CAN3_IR4_RB_MASK 0x60000000U
#define CAN3_IR4_RB_BIT 29
#define CAN3_IR4_RTR_MASK 0x80000000U
#define CAN3_IR4_RTR 0x80000000U
#define CAN3_IR4_RTR_BIT 31

#define CAN3_CR4 (*(volatile unsigned long *)0xFFFB0210)
#define CAN3_CR4_OFFSET 0x210
#define CAN3_CR4_DLC_MASK 0xFU
#define CAN3_CR4_DLC_BIT 0
#define CAN3_CR4_IDE_MASK 0x10U
#define CAN3_CR4_IDE 0x10U
#define CAN3_CR4_IDE_BIT 4
#define CAN3_CR4_RPLYV_MASK 0x20U
#define CAN3_CR4_RPLYV 0x20U
#define CAN3_CR4_RPLYV_BIT 5
#define CAN3_CR4_PCB_MASK 0x40U
#define CAN3_CR4_PCB 0x40U
#define CAN3_CR4_PCB_BIT 6
#define CAN3_CR4_CHANEN_MASK 0x80U
#define CAN3_CR4_CHANEN 0x80U
#define CAN3_CR4_CHANEN_BIT 7
#define CAN3_CR4_OVERWRITE_MASK 0x100U
#define CAN3_CR4_OVERWRITE 0x100U
#define CAN3_CR4_OVERWRITE_BIT 8

#define CAN3_CR4 (*(volatile unsigned long *)0xFFFB0214)
#define CAN3_CR4_OFFSET 0x214
#define CAN3_CR4_STAMP_MASK 0x0U
#define CAN3_CR4_STAMP_BIT 0

#define CAN3_CSR4 (*(volatile unsigned long *)0xFFFB0218)
#define CAN3_CSR4_OFFSET 0x218
#define CAN3_CSR4_ACK_MASK 0x1U
#define CAN3_CSR4_ACK 0x1U
#define CAN3_CSR4_ACK_BIT 0
#define CAN3_CSR4_FRAME_MASK 0x2U
#define CAN3_CSR4_FRAME 0x2U
#define CAN3_CSR4_FRAME_BIT 1
#define CAN3_CSR4_CRC_MASK 0x4U
#define CAN3_CSR4_CRC 0x4U
#define CAN3_CSR4_CRC_BIT 2
#define CAN3_CSR4_STUFF_MASK 0x8U
#define CAN3_CSR4_STUFF 0x8U
#define CAN3_CSR4_STUFF_BIT 3
#define CAN3_CSR4_BUS_MASK 0x10U
#define CAN3_CSR4_BUS 0x10U
#define CAN3_CSR4_BUS_BIT 4
#define CAN3_CSR4_RXOK_MASK 0x20U
#define CAN3_CSR4_RXOK 0x20U
#define CAN3_CSR4_RXOK_BIT 5
#define CAN3_CSR4_TXOK_MASK 0x40U
#define CAN3_CSR4_TXOK 0x40U
#define CAN3_CSR4_TXOK_BIT 6
#define CAN3_CSR4_RFRAME_MASK 0x80U
#define CAN3_CSR4_RFRAME 0x80U
#define CAN3_CSR4_RFRAME_BIT 7
#define CAN3_CSR4_DLCW_MASK 0x200U
#define CAN3_CSR4_DLCW 0x200U
#define CAN3_CSR4_DLCW_BIT 9
#define CAN3_CSR4_FILLED_MASK 0x400U
#define CAN3_CSR4_FILLED 0x400U
#define CAN3_CSR4_FILLED_BIT 10
#define CAN3_CSR4_OVRUN_MASK 0x800U
#define CAN3_CSR4_OVRUN 0x800U
#define CAN3_CSR4_OVRUN_BIT 11

#define CAN3_SR4 (*(volatile unsigned long *)0xFFFB021C)
#define CAN3_SR4_OFFSET 0x21C
#define CAN3_SR4_ACK_MASK 0x1U
#define CAN3_SR4_ACK 0x1U
#define CAN3_SR4_ACK_BIT 0
#define CAN3_SR4_FRAME_MASK 0x2U
#define CAN3_SR4_FRAME 0x2U
#define CAN3_SR4_FRAME_BIT 1
#define CAN3_SR4_CRC_MASK 0x4U
#define CAN3_SR4_CRC 0x4U
#define CAN3_SR4_CRC_BIT 2
#define CAN3_SR4_STUFF_MASK 0x8U
#define CAN3_SR4_STUFF 0x8U
#define CAN3_SR4_STUFF_BIT 3
#define CAN3_SR4_BUS_MASK 0x10U
#define CAN3_SR4_BUS 0x10U
#define CAN3_SR4_BUS_BIT 4
#define CAN3_SR4_RXOK_MASK 0x20U
#define CAN3_SR4_RXOK 0x20U
#define CAN3_SR4_RXOK_BIT 5
#define CAN3_SR4_TXOK_MASK 0x40U
#define CAN3_SR4_TXOK 0x40U
#define CAN3_SR4_TXOK_BIT 6
#define CAN3_SR4_RFRAME_MASK 0x80U
#define CAN3_SR4_RFRAME 0x80U
#define CAN3_SR4_RFRAME_BIT 7
#define CAN3_SR4_DLCW_MASK 0x200U
#define CAN3_SR4_DLCW 0x200U
#define CAN3_SR4_DLCW_BIT 9
#define CAN3_SR4_FILLED_MASK 0x400U
#define CAN3_SR4_FILLED 0x400U
#define CAN3_SR4_FILLED_BIT 10
#define CAN3_SR4_OVRUN_MASK 0x800U
#define CAN3_SR4_OVRUN 0x800U
#define CAN3_SR4_OVRUN_BIT 11

#define CAN3_IER4 (*(volatile unsigned long *)0xFFFB0220)
#define CAN3_IER4_OFFSET 0x220
#define CAN3_IER4_ACK_MASK 0x1U
#define CAN3_IER4_ACK 0x1U
#define CAN3_IER4_ACK_BIT 0
#define CAN3_IER4_FRAME_MASK 0x2U
#define CAN3_IER4_FRAME 0x2U
#define CAN3_IER4_FRAME_BIT 1
#define CAN3_IER4_CRC_MASK 0x4U
#define CAN3_IER4_CRC 0x4U
#define CAN3_IER4_CRC_BIT 2
#define CAN3_IER4_STUFF_MASK 0x8U
#define CAN3_IER4_STUFF 0x8U
#define CAN3_IER4_STUFF_BIT 3
#define CAN3_IER4_BUS_MASK 0x10U
#define CAN3_IER4_BUS 0x10U
#define CAN3_IER4_BUS_BIT 4
#define CAN3_IER4_RXOK_MASK 0x20U
#define CAN3_IER4_RXOK 0x20U
#define CAN3_IER4_RXOK_BIT 5
#define CAN3_IER4_TXOK_MASK 0x40U
#define CAN3_IER4_TXOK 0x40U
#define CAN3_IER4_TXOK_BIT 6
#define CAN3_IER4_RFRAME_MASK 0x80U
#define CAN3_IER4_RFRAME 0x80U
#define CAN3_IER4_RFRAME_BIT 7

#define CAN3_IDR4 (*(volatile unsigned long *)0xFFFB0224)
#define CAN3_IDR4_OFFSET 0x224
#define CAN3_IDR4_ACK_MASK 0x1U
#define CAN3_IDR4_ACK 0x1U
#define CAN3_IDR4_ACK_BIT 0
#define CAN3_IDR4_FRAME_MASK 0x2U
#define CAN3_IDR4_FRAME 0x2U
#define CAN3_IDR4_FRAME_BIT 1
#define CAN3_IDR4_CRC_MASK 0x4U
#define CAN3_IDR4_CRC 0x4U
#define CAN3_IDR4_CRC_BIT 2
#define CAN3_IDR4_STUFF_MASK 0x8U
#define CAN3_IDR4_STUFF 0x8U
#define CAN3_IDR4_STUFF_BIT 3
#define CAN3_IDR4_BUS_MASK 0x10U
#define CAN3_IDR4_BUS 0x10U
#define CAN3_IDR4_BUS_BIT 4
#define CAN3_IDR4_RXOK_MASK 0x20U
#define CAN3_IDR4_RXOK 0x20U
#define CAN3_IDR4_RXOK_BIT 5
#define CAN3_IDR4_TXOK_MASK 0x40U
#define CAN3_IDR4_TXOK 0x40U
#define CAN3_IDR4_TXOK_BIT 6
#define CAN3_IDR4_RFRAME_MASK 0x80U
#define CAN3_IDR4_RFRAME 0x80U
#define CAN3_IDR4_RFRAME_BIT 7

#define CAN3_IMR4 (*(volatile unsigned long *)0xFFFB0228)
#define CAN3_IMR4_OFFSET 0x228
#define CAN3_IMR4_ACK_MASK 0x1U
#define CAN3_IMR4_ACK 0x1U
#define CAN3_IMR4_ACK_BIT 0
#define CAN3_IMR4_FRAME_MASK 0x2U
#define CAN3_IMR4_FRAME 0x2U
#define CAN3_IMR4_FRAME_BIT 1
#define CAN3_IMR4_CRC_MASK 0x4U
#define CAN3_IMR4_CRC 0x4U
#define CAN3_IMR4_CRC_BIT 2
#define CAN3_IMR4_STUFF_MASK 0x8U
#define CAN3_IMR4_STUFF 0x8U
#define CAN3_IMR4_STUFF_BIT 3
#define CAN3_IMR4_BUS_MASK 0x10U
#define CAN3_IMR4_BUS 0x10U
#define CAN3_IMR4_BUS_BIT 4
#define CAN3_IMR4_RXOK_MASK 0x20U
#define CAN3_IMR4_RXOK 0x20U
#define CAN3_IMR4_RXOK_BIT 5
#define CAN3_IMR4_TXOK_MASK 0x40U
#define CAN3_IMR4_TXOK 0x40U
#define CAN3_IMR4_TXOK_BIT 6
#define CAN3_IMR4_RFRAME_MASK 0x80U
#define CAN3_IMR4_RFRAME 0x80U
#define CAN3_IMR4_RFRAME_BIT 7

#define CAN3_DRA5 (*(volatile unsigned long *)0xFFFB0240)
#define CAN3_DRA5_OFFSET 0x240
#define CAN3_DRA5_DATA0_MASK 0xFFU
#define CAN3_DRA5_DATA0_BIT 0
#define CAN3_DRA5_DATA1_MASK 0xFF00U
#define CAN3_DRA5_DATA1_BIT 8
#define CAN3_DRA5_DATA2_MASK 0xFF0000U
#define CAN3_DRA5_DATA2_BIT 16
#define CAN3_DRA5_DATA3_MASK 0xFF000000U
#define CAN3_DRA5_DATA3_BIT 24

#define CAN3_DRB5 (*(volatile unsigned long *)0xFFFB0244)
#define CAN3_DRB5_OFFSET 0x244
#define CAN3_DRB5_DATA4_MASK 0xFFU
#define CAN3_DRB5_DATA4_BIT 0
#define CAN3_DRB5_DATA5_MASK 0xFF00U
#define CAN3_DRB5_DATA5_BIT 8
#define CAN3_DRB5_DATA6_MASK 0xFF0000U
#define CAN3_DRB5_DATA6_BIT 16
#define CAN3_DRB5_DATA7_MASK 0xFF000000U
#define CAN3_DRB5_DATA7_BIT 24

#define CAN3_MSK5 (*(volatile unsigned long *)0xFFFB0248)
#define CAN3_MSK5_OFFSET 0x248
#define CAN3_MSK5_MASK_MASK 0x1FFFFFFFU
#define CAN3_MSK5_MASK_BIT 0
#define CAN3_MSK5_MRB_MASK 0x60000000U
#define CAN3_MSK5_MRB_BIT 29
#define CAN3_MSK5_MRTR_MASK 0x80000000U
#define CAN3_MSK5_MRTR 0x80000000U
#define CAN3_MSK5_MRTR_BIT 31

#define CAN3_IR5 (*(volatile unsigned long *)0xFFFB024C)
#define CAN3_IR5_OFFSET 0x24C
#define CAN3_IR5_ID_MASK 0x1FFFFFFFU
#define CAN3_IR5_ID_BIT 0
#define CAN3_IR5_RB_MASK 0x60000000U
#define CAN3_IR5_RB_BIT 29
#define CAN3_IR5_RTR_MASK 0x80000000U
#define CAN3_IR5_RTR 0x80000000U
#define CAN3_IR5_RTR_BIT 31

#define CAN3_CR5 (*(volatile unsigned long *)0xFFFB0250)
#define CAN3_CR5_OFFSET 0x250
#define CAN3_CR5_DLC_MASK 0xFU
#define CAN3_CR5_DLC_BIT 0
#define CAN3_CR5_IDE_MASK 0x10U
#define CAN3_CR5_IDE 0x10U
#define CAN3_CR5_IDE_BIT 4
#define CAN3_CR5_RPLYV_MASK 0x20U
#define CAN3_CR5_RPLYV 0x20U
#define CAN3_CR5_RPLYV_BIT 5
#define CAN3_CR5_PCB_MASK 0x40U
#define CAN3_CR5_PCB 0x40U
#define CAN3_CR5_PCB_BIT 6
#define CAN3_CR5_CHANEN_MASK 0x80U
#define CAN3_CR5_CHANEN 0x80U
#define CAN3_CR5_CHANEN_BIT 7
#define CAN3_CR5_OVERWRITE_MASK 0x100U
#define CAN3_CR5_OVERWRITE 0x100U
#define CAN3_CR5_OVERWRITE_BIT 8

#define CAN3_CR5 (*(volatile unsigned long *)0xFFFB0254)
#define CAN3_CR5_OFFSET 0x254
#define CAN3_CR5_STAMP_MASK 0x0U
#define CAN3_CR5_STAMP_BIT 0

#define CAN3_CSR5 (*(volatile unsigned long *)0xFFFB0258)
#define CAN3_CSR5_OFFSET 0x258
#define CAN3_CSR5_ACK_MASK 0x1U
#define CAN3_CSR5_ACK 0x1U
#define CAN3_CSR5_ACK_BIT 0
#define CAN3_CSR5_FRAME_MASK 0x2U
#define CAN3_CSR5_FRAME 0x2U
#define CAN3_CSR5_FRAME_BIT 1
#define CAN3_CSR5_CRC_MASK 0x4U
#define CAN3_CSR5_CRC 0x4U
#define CAN3_CSR5_CRC_BIT 2
#define CAN3_CSR5_STUFF_MASK 0x8U
#define CAN3_CSR5_STUFF 0x8U
#define CAN3_CSR5_STUFF_BIT 3
#define CAN3_CSR5_BUS_MASK 0x10U
#define CAN3_CSR5_BUS 0x10U
#define CAN3_CSR5_BUS_BIT 4
#define CAN3_CSR5_RXOK_MASK 0x20U
#define CAN3_CSR5_RXOK 0x20U
#define CAN3_CSR5_RXOK_BIT 5
#define CAN3_CSR5_TXOK_MASK 0x40U
#define CAN3_CSR5_TXOK 0x40U
#define CAN3_CSR5_TXOK_BIT 6
#define CAN3_CSR5_RFRAME_MASK 0x80U
#define CAN3_CSR5_RFRAME 0x80U
#define CAN3_CSR5_RFRAME_BIT 7
#define CAN3_CSR5_DLCW_MASK 0x200U
#define CAN3_CSR5_DLCW 0x200U
#define CAN3_CSR5_DLCW_BIT 9
#define CAN3_CSR5_FILLED_MASK 0x400U
#define CAN3_CSR5_FILLED 0x400U
#define CAN3_CSR5_FILLED_BIT 10
#define CAN3_CSR5_OVRUN_MASK 0x800U
#define CAN3_CSR5_OVRUN 0x800U
#define CAN3_CSR5_OVRUN_BIT 11

#define CAN3_SR5 (*(volatile unsigned long *)0xFFFB025C)
#define CAN3_SR5_OFFSET 0x25C
#define CAN3_SR5_ACK_MASK 0x1U
#define CAN3_SR5_ACK 0x1U
#define CAN3_SR5_ACK_BIT 0
#define CAN3_SR5_FRAME_MASK 0x2U
#define CAN3_SR5_FRAME 0x2U
#define CAN3_SR5_FRAME_BIT 1
#define CAN3_SR5_CRC_MASK 0x4U
#define CAN3_SR5_CRC 0x4U
#define CAN3_SR5_CRC_BIT 2
#define CAN3_SR5_STUFF_MASK 0x8U
#define CAN3_SR5_STUFF 0x8U
#define CAN3_SR5_STUFF_BIT 3
#define CAN3_SR5_BUS_MASK 0x10U
#define CAN3_SR5_BUS 0x10U
#define CAN3_SR5_BUS_BIT 4
#define CAN3_SR5_RXOK_MASK 0x20U
#define CAN3_SR5_RXOK 0x20U
#define CAN3_SR5_RXOK_BIT 5
#define CAN3_SR5_TXOK_MASK 0x40U
#define CAN3_SR5_TXOK 0x40U
#define CAN3_SR5_TXOK_BIT 6
#define CAN3_SR5_RFRAME_MASK 0x80U
#define CAN3_SR5_RFRAME 0x80U
#define CAN3_SR5_RFRAME_BIT 7
#define CAN3_SR5_DLCW_MASK 0x200U
#define CAN3_SR5_DLCW 0x200U
#define CAN3_SR5_DLCW_BIT 9
#define CAN3_SR5_FILLED_MASK 0x400U
#define CAN3_SR5_FILLED 0x400U
#define CAN3_SR5_FILLED_BIT 10
#define CAN3_SR5_OVRUN_MASK 0x800U
#define CAN3_SR5_OVRUN 0x800U
#define CAN3_SR5_OVRUN_BIT 11

#define CAN3_IER5 (*(volatile unsigned long *)0xFFFB0260)
#define CAN3_IER5_OFFSET 0x260
#define CAN3_IER5_ACK_MASK 0x1U
#define CAN3_IER5_ACK 0x1U
#define CAN3_IER5_ACK_BIT 0
#define CAN3_IER5_FRAME_MASK 0x2U
#define CAN3_IER5_FRAME 0x2U
#define CAN3_IER5_FRAME_BIT 1
#define CAN3_IER5_CRC_MASK 0x4U
#define CAN3_IER5_CRC 0x4U
#define CAN3_IER5_CRC_BIT 2
#define CAN3_IER5_STUFF_MASK 0x8U
#define CAN3_IER5_STUFF 0x8U
#define CAN3_IER5_STUFF_BIT 3
#define CAN3_IER5_BUS_MASK 0x10U
#define CAN3_IER5_BUS 0x10U
#define CAN3_IER5_BUS_BIT 4
#define CAN3_IER5_RXOK_MASK 0x20U
#define CAN3_IER5_RXOK 0x20U
#define CAN3_IER5_RXOK_BIT 5
#define CAN3_IER5_TXOK_MASK 0x40U
#define CAN3_IER5_TXOK 0x40U
#define CAN3_IER5_TXOK_BIT 6
#define CAN3_IER5_RFRAME_MASK 0x80U
#define CAN3_IER5_RFRAME 0x80U
#define CAN3_IER5_RFRAME_BIT 7

#define CAN3_IDR5 (*(volatile unsigned long *)0xFFFB0264)
#define CAN3_IDR5_OFFSET 0x264
#define CAN3_IDR5_ACK_MASK 0x1U
#define CAN3_IDR5_ACK 0x1U
#define CAN3_IDR5_ACK_BIT 0
#define CAN3_IDR5_FRAME_MASK 0x2U
#define CAN3_IDR5_FRAME 0x2U
#define CAN3_IDR5_FRAME_BIT 1
#define CAN3_IDR5_CRC_MASK 0x4U
#define CAN3_IDR5_CRC 0x4U
#define CAN3_IDR5_CRC_BIT 2
#define CAN3_IDR5_STUFF_MASK 0x8U
#define CAN3_IDR5_STUFF 0x8U
#define CAN3_IDR5_STUFF_BIT 3
#define CAN3_IDR5_BUS_MASK 0x10U
#define CAN3_IDR5_BUS 0x10U
#define CAN3_IDR5_BUS_BIT 4
#define CAN3_IDR5_RXOK_MASK 0x20U
#define CAN3_IDR5_RXOK 0x20U
#define CAN3_IDR5_RXOK_BIT 5
#define CAN3_IDR5_TXOK_MASK 0x40U
#define CAN3_IDR5_TXOK 0x40U
#define CAN3_IDR5_TXOK_BIT 6
#define CAN3_IDR5_RFRAME_MASK 0x80U
#define CAN3_IDR5_RFRAME 0x80U
#define CAN3_IDR5_RFRAME_BIT 7

#define CAN3_IMR5 (*(volatile unsigned long *)0xFFFB0268)
#define CAN3_IMR5_OFFSET 0x268
#define CAN3_IMR5_ACK_MASK 0x1U
#define CAN3_IMR5_ACK 0x1U
#define CAN3_IMR5_ACK_BIT 0
#define CAN3_IMR5_FRAME_MASK 0x2U
#define CAN3_IMR5_FRAME 0x2U
#define CAN3_IMR5_FRAME_BIT 1
#define CAN3_IMR5_CRC_MASK 0x4U
#define CAN3_IMR5_CRC 0x4U
#define CAN3_IMR5_CRC_BIT 2
#define CAN3_IMR5_STUFF_MASK 0x8U
#define CAN3_IMR5_STUFF 0x8U
#define CAN3_IMR5_STUFF_BIT 3
#define CAN3_IMR5_BUS_MASK 0x10U
#define CAN3_IMR5_BUS 0x10U
#define CAN3_IMR5_BUS_BIT 4
#define CAN3_IMR5_RXOK_MASK 0x20U
#define CAN3_IMR5_RXOK 0x20U
#define CAN3_IMR5_RXOK_BIT 5
#define CAN3_IMR5_TXOK_MASK 0x40U
#define CAN3_IMR5_TXOK 0x40U
#define CAN3_IMR5_TXOK_BIT 6
#define CAN3_IMR5_RFRAME_MASK 0x80U
#define CAN3_IMR5_RFRAME 0x80U
#define CAN3_IMR5_RFRAME_BIT 7

#define CAN3_DRA6 (*(volatile unsigned long *)0xFFFB0280)
#define CAN3_DRA6_OFFSET 0x280
#define CAN3_DRA6_DATA0_MASK 0xFFU
#define CAN3_DRA6_DATA0_BIT 0
#define CAN3_DRA6_DATA1_MASK 0xFF00U
#define CAN3_DRA6_DATA1_BIT 8
#define CAN3_DRA6_DATA2_MASK 0xFF0000U
#define CAN3_DRA6_DATA2_BIT 16
#define CAN3_DRA6_DATA3_MASK 0xFF000000U
#define CAN3_DRA6_DATA3_BIT 24

#define CAN3_DRB6 (*(volatile unsigned long *)0xFFFB0284)
#define CAN3_DRB6_OFFSET 0x284
#define CAN3_DRB6_DATA4_MASK 0xFFU
#define CAN3_DRB6_DATA4_BIT 0
#define CAN3_DRB6_DATA5_MASK 0xFF00U
#define CAN3_DRB6_DATA5_BIT 8
#define CAN3_DRB6_DATA6_MASK 0xFF0000U
#define CAN3_DRB6_DATA6_BIT 16
#define CAN3_DRB6_DATA7_MASK 0xFF000000U
#define CAN3_DRB6_DATA7_BIT 24

#define CAN3_MSK6 (*(volatile unsigned long *)0xFFFB0288)
#define CAN3_MSK6_OFFSET 0x288
#define CAN3_MSK6_MASK_MASK 0x1FFFFFFFU
#define CAN3_MSK6_MASK_BIT 0
#define CAN3_MSK6_MRB_MASK 0x60000000U
#define CAN3_MSK6_MRB_BIT 29
#define CAN3_MSK6_MRTR_MASK 0x80000000U
#define CAN3_MSK6_MRTR 0x80000000U
#define CAN3_MSK6_MRTR_BIT 31

#define CAN3_IR6 (*(volatile unsigned long *)0xFFFB028C)
#define CAN3_IR6_OFFSET 0x28C
#define CAN3_IR6_ID_MASK 0x1FFFFFFFU
#define CAN3_IR6_ID_BIT 0
#define CAN3_IR6_RB_MASK 0x60000000U
#define CAN3_IR6_RB_BIT 29
#define CAN3_IR6_RTR_MASK 0x80000000U
#define CAN3_IR6_RTR 0x80000000U
#define CAN3_IR6_RTR_BIT 31

#define CAN3_CR6 (*(volatile unsigned long *)0xFFFB0290)
#define CAN3_CR6_OFFSET 0x290
#define CAN3_CR6_DLC_MASK 0xFU
#define CAN3_CR6_DLC_BIT 0
#define CAN3_CR6_IDE_MASK 0x10U
#define CAN3_CR6_IDE 0x10U
#define CAN3_CR6_IDE_BIT 4
#define CAN3_CR6_RPLYV_MASK 0x20U
#define CAN3_CR6_RPLYV 0x20U
#define CAN3_CR6_RPLYV_BIT 5
#define CAN3_CR6_PCB_MASK 0x40U
#define CAN3_CR6_PCB 0x40U
#define CAN3_CR6_PCB_BIT 6
#define CAN3_CR6_CHANEN_MASK 0x80U
#define CAN3_CR6_CHANEN 0x80U
#define CAN3_CR6_CHANEN_BIT 7
#define CAN3_CR6_OVERWRITE_MASK 0x100U
#define CAN3_CR6_OVERWRITE 0x100U
#define CAN3_CR6_OVERWRITE_BIT 8

#define CAN3_CR6 (*(volatile unsigned long *)0xFFFB0294)
#define CAN3_CR6_OFFSET 0x294
#define CAN3_CR6_STAMP_MASK 0x0U
#define CAN3_CR6_STAMP_BIT 0

#define CAN3_CSR6 (*(volatile unsigned long *)0xFFFB0298)
#define CAN3_CSR6_OFFSET 0x298
#define CAN3_CSR6_ACK_MASK 0x1U
#define CAN3_CSR6_ACK 0x1U
#define CAN3_CSR6_ACK_BIT 0
#define CAN3_CSR6_FRAME_MASK 0x2U
#define CAN3_CSR6_FRAME 0x2U
#define CAN3_CSR6_FRAME_BIT 1
#define CAN3_CSR6_CRC_MASK 0x4U
#define CAN3_CSR6_CRC 0x4U
#define CAN3_CSR6_CRC_BIT 2
#define CAN3_CSR6_STUFF_MASK 0x8U
#define CAN3_CSR6_STUFF 0x8U
#define CAN3_CSR6_STUFF_BIT 3
#define CAN3_CSR6_BUS_MASK 0x10U
#define CAN3_CSR6_BUS 0x10U
#define CAN3_CSR6_BUS_BIT 4
#define CAN3_CSR6_RXOK_MASK 0x20U
#define CAN3_CSR6_RXOK 0x20U
#define CAN3_CSR6_RXOK_BIT 5
#define CAN3_CSR6_TXOK_MASK 0x40U
#define CAN3_CSR6_TXOK 0x40U
#define CAN3_CSR6_TXOK_BIT 6
#define CAN3_CSR6_RFRAME_MASK 0x80U
#define CAN3_CSR6_RFRAME 0x80U
#define CAN3_CSR6_RFRAME_BIT 7
#define CAN3_CSR6_DLCW_MASK 0x200U
#define CAN3_CSR6_DLCW 0x200U
#define CAN3_CSR6_DLCW_BIT 9
#define CAN3_CSR6_FILLED_MASK 0x400U
#define CAN3_CSR6_FILLED 0x400U
#define CAN3_CSR6_FILLED_BIT 10
#define CAN3_CSR6_OVRUN_MASK 0x800U
#define CAN3_CSR6_OVRUN 0x800U
#define CAN3_CSR6_OVRUN_BIT 11

#define CAN3_SR6 (*(volatile unsigned long *)0xFFFB029C)
#define CAN3_SR6_OFFSET 0x29C
#define CAN3_SR6_ACK_MASK 0x1U
#define CAN3_SR6_ACK 0x1U
#define CAN3_SR6_ACK_BIT 0
#define CAN3_SR6_FRAME_MASK 0x2U
#define CAN3_SR6_FRAME 0x2U
#define CAN3_SR6_FRAME_BIT 1
#define CAN3_SR6_CRC_MASK 0x4U
#define CAN3_SR6_CRC 0x4U
#define CAN3_SR6_CRC_BIT 2
#define CAN3_SR6_STUFF_MASK 0x8U
#define CAN3_SR6_STUFF 0x8U
#define CAN3_SR6_STUFF_BIT 3
#define CAN3_SR6_BUS_MASK 0x10U
#define CAN3_SR6_BUS 0x10U
#define CAN3_SR6_BUS_BIT 4
#define CAN3_SR6_RXOK_MASK 0x20U
#define CAN3_SR6_RXOK 0x20U
#define CAN3_SR6_RXOK_BIT 5
#define CAN3_SR6_TXOK_MASK 0x40U
#define CAN3_SR6_TXOK 0x40U
#define CAN3_SR6_TXOK_BIT 6
#define CAN3_SR6_RFRAME_MASK 0x80U
#define CAN3_SR6_RFRAME 0x80U
#define CAN3_SR6_RFRAME_BIT 7
#define CAN3_SR6_DLCW_MASK 0x200U
#define CAN3_SR6_DLCW 0x200U
#define CAN3_SR6_DLCW_BIT 9
#define CAN3_SR6_FILLED_MASK 0x400U
#define CAN3_SR6_FILLED 0x400U
#define CAN3_SR6_FILLED_BIT 10
#define CAN3_SR6_OVRUN_MASK 0x800U
#define CAN3_SR6_OVRUN 0x800U
#define CAN3_SR6_OVRUN_BIT 11

#define CAN3_IER6 (*(volatile unsigned long *)0xFFFB02A0)
#define CAN3_IER6_OFFSET 0x2A0
#define CAN3_IER6_ACK_MASK 0x1U
#define CAN3_IER6_ACK 0x1U
#define CAN3_IER6_ACK_BIT 0
#define CAN3_IER6_FRAME_MASK 0x2U
#define CAN3_IER6_FRAME 0x2U
#define CAN3_IER6_FRAME_BIT 1
#define CAN3_IER6_CRC_MASK 0x4U
#define CAN3_IER6_CRC 0x4U
#define CAN3_IER6_CRC_BIT 2
#define CAN3_IER6_STUFF_MASK 0x8U
#define CAN3_IER6_STUFF 0x8U
#define CAN3_IER6_STUFF_BIT 3
#define CAN3_IER6_BUS_MASK 0x10U
#define CAN3_IER6_BUS 0x10U
#define CAN3_IER6_BUS_BIT 4
#define CAN3_IER6_RXOK_MASK 0x20U
#define CAN3_IER6_RXOK 0x20U
#define CAN3_IER6_RXOK_BIT 5
#define CAN3_IER6_TXOK_MASK 0x40U
#define CAN3_IER6_TXOK 0x40U
#define CAN3_IER6_TXOK_BIT 6
#define CAN3_IER6_RFRAME_MASK 0x80U
#define CAN3_IER6_RFRAME 0x80U
#define CAN3_IER6_RFRAME_BIT 7

#define CAN3_IDR6 (*(volatile unsigned long *)0xFFFB02A4)
#define CAN3_IDR6_OFFSET 0x2A4
#define CAN3_IDR6_ACK_MASK 0x1U
#define CAN3_IDR6_ACK 0x1U
#define CAN3_IDR6_ACK_BIT 0
#define CAN3_IDR6_FRAME_MASK 0x2U
#define CAN3_IDR6_FRAME 0x2U
#define CAN3_IDR6_FRAME_BIT 1
#define CAN3_IDR6_CRC_MASK 0x4U
#define CAN3_IDR6_CRC 0x4U
#define CAN3_IDR6_CRC_BIT 2
#define CAN3_IDR6_STUFF_MASK 0x8U
#define CAN3_IDR6_STUFF 0x8U
#define CAN3_IDR6_STUFF_BIT 3
#define CAN3_IDR6_BUS_MASK 0x10U
#define CAN3_IDR6_BUS 0x10U
#define CAN3_IDR6_BUS_BIT 4
#define CAN3_IDR6_RXOK_MASK 0x20U
#define CAN3_IDR6_RXOK 0x20U
#define CAN3_IDR6_RXOK_BIT 5
#define CAN3_IDR6_TXOK_MASK 0x40U
#define CAN3_IDR6_TXOK 0x40U
#define CAN3_IDR6_TXOK_BIT 6
#define CAN3_IDR6_RFRAME_MASK 0x80U
#define CAN3_IDR6_RFRAME 0x80U
#define CAN3_IDR6_RFRAME_BIT 7

#define CAN3_IMR6 (*(volatile unsigned long *)0xFFFB02A8)
#define CAN3_IMR6_OFFSET 0x2A8
#define CAN3_IMR6_ACK_MASK 0x1U
#define CAN3_IMR6_ACK 0x1U
#define CAN3_IMR6_ACK_BIT 0
#define CAN3_IMR6_FRAME_MASK 0x2U
#define CAN3_IMR6_FRAME 0x2U
#define CAN3_IMR6_FRAME_BIT 1
#define CAN3_IMR6_CRC_MASK 0x4U
#define CAN3_IMR6_CRC 0x4U
#define CAN3_IMR6_CRC_BIT 2
#define CAN3_IMR6_STUFF_MASK 0x8U
#define CAN3_IMR6_STUFF 0x8U
#define CAN3_IMR6_STUFF_BIT 3
#define CAN3_IMR6_BUS_MASK 0x10U
#define CAN3_IMR6_BUS 0x10U
#define CAN3_IMR6_BUS_BIT 4
#define CAN3_IMR6_RXOK_MASK 0x20U
#define CAN3_IMR6_RXOK 0x20U
#define CAN3_IMR6_RXOK_BIT 5
#define CAN3_IMR6_TXOK_MASK 0x40U
#define CAN3_IMR6_TXOK 0x40U
#define CAN3_IMR6_TXOK_BIT 6
#define CAN3_IMR6_RFRAME_MASK 0x80U
#define CAN3_IMR6_RFRAME 0x80U
#define CAN3_IMR6_RFRAME_BIT 7

#define CAN3_DRA7 (*(volatile unsigned long *)0xFFFB02C0)
#define CAN3_DRA7_OFFSET 0x2C0
#define CAN3_DRA7_DATA0_MASK 0xFFU
#define CAN3_DRA7_DATA0_BIT 0
#define CAN3_DRA7_DATA1_MASK 0xFF00U
#define CAN3_DRA7_DATA1_BIT 8
#define CAN3_DRA7_DATA2_MASK 0xFF0000U
#define CAN3_DRA7_DATA2_BIT 16
#define CAN3_DRA7_DATA3_MASK 0xFF000000U
#define CAN3_DRA7_DATA3_BIT 24

#define CAN3_DRB7 (*(volatile unsigned long *)0xFFFB02C4)
#define CAN3_DRB7_OFFSET 0x2C4
#define CAN3_DRB7_DATA4_MASK 0xFFU
#define CAN3_DRB7_DATA4_BIT 0
#define CAN3_DRB7_DATA5_MASK 0xFF00U
#define CAN3_DRB7_DATA5_BIT 8
#define CAN3_DRB7_DATA6_MASK 0xFF0000U
#define CAN3_DRB7_DATA6_BIT 16
#define CAN3_DRB7_DATA7_MASK 0xFF000000U
#define CAN3_DRB7_DATA7_BIT 24

#define CAN3_MSK7 (*(volatile unsigned long *)0xFFFB02C8)
#define CAN3_MSK7_OFFSET 0x2C8
#define CAN3_MSK7_MASK_MASK 0x1FFFFFFFU
#define CAN3_MSK7_MASK_BIT 0
#define CAN3_MSK7_MRB_MASK 0x60000000U
#define CAN3_MSK7_MRB_BIT 29
#define CAN3_MSK7_MRTR_MASK 0x80000000U
#define CAN3_MSK7_MRTR 0x80000000U
#define CAN3_MSK7_MRTR_BIT 31

#define CAN3_IR7 (*(volatile unsigned long *)0xFFFB02CC)
#define CAN3_IR7_OFFSET 0x2CC
#define CAN3_IR7_ID_MASK 0x1FFFFFFFU
#define CAN3_IR7_ID_BIT 0
#define CAN3_IR7_RB_MASK 0x60000000U
#define CAN3_IR7_RB_BIT 29
#define CAN3_IR7_RTR_MASK 0x80000000U
#define CAN3_IR7_RTR 0x80000000U
#define CAN3_IR7_RTR_BIT 31

#define CAN3_CR7 (*(volatile unsigned long *)0xFFFB02D0)
#define CAN3_CR7_OFFSET 0x2D0
#define CAN3_CR7_DLC_MASK 0xFU
#define CAN3_CR7_DLC_BIT 0
#define CAN3_CR7_IDE_MASK 0x10U
#define CAN3_CR7_IDE 0x10U
#define CAN3_CR7_IDE_BIT 4
#define CAN3_CR7_RPLYV_MASK 0x20U
#define CAN3_CR7_RPLYV 0x20U
#define CAN3_CR7_RPLYV_BIT 5
#define CAN3_CR7_PCB_MASK 0x40U
#define CAN3_CR7_PCB 0x40U
#define CAN3_CR7_PCB_BIT 6
#define CAN3_CR7_CHANEN_MASK 0x80U
#define CAN3_CR7_CHANEN 0x80U
#define CAN3_CR7_CHANEN_BIT 7
#define CAN3_CR7_OVERWRITE_MASK 0x100U
#define CAN3_CR7_OVERWRITE 0x100U
#define CAN3_CR7_OVERWRITE_BIT 8

#define CAN3_CR7 (*(volatile unsigned long *)0xFFFB02D4)
#define CAN3_CR7_OFFSET 0x2D4
#define CAN3_CR7_STAMP_MASK 0x0U
#define CAN3_CR7_STAMP_BIT 0

#define CAN3_CSR7 (*(volatile unsigned long *)0xFFFB02D8)
#define CAN3_CSR7_OFFSET 0x2D8
#define CAN3_CSR7_ACK_MASK 0x1U
#define CAN3_CSR7_ACK 0x1U
#define CAN3_CSR7_ACK_BIT 0
#define CAN3_CSR7_FRAME_MASK 0x2U
#define CAN3_CSR7_FRAME 0x2U
#define CAN3_CSR7_FRAME_BIT 1
#define CAN3_CSR7_CRC_MASK 0x4U
#define CAN3_CSR7_CRC 0x4U
#define CAN3_CSR7_CRC_BIT 2
#define CAN3_CSR7_STUFF_MASK 0x8U
#define CAN3_CSR7_STUFF 0x8U
#define CAN3_CSR7_STUFF_BIT 3
#define CAN3_CSR7_BUS_MASK 0x10U
#define CAN3_CSR7_BUS 0x10U
#define CAN3_CSR7_BUS_BIT 4
#define CAN3_CSR7_RXOK_MASK 0x20U
#define CAN3_CSR7_RXOK 0x20U
#define CAN3_CSR7_RXOK_BIT 5
#define CAN3_CSR7_TXOK_MASK 0x40U
#define CAN3_CSR7_TXOK 0x40U
#define CAN3_CSR7_TXOK_BIT 6
#define CAN3_CSR7_RFRAME_MASK 0x80U
#define CAN3_CSR7_RFRAME 0x80U
#define CAN3_CSR7_RFRAME_BIT 7
#define CAN3_CSR7_DLCW_MASK 0x200U
#define CAN3_CSR7_DLCW 0x200U
#define CAN3_CSR7_DLCW_BIT 9
#define CAN3_CSR7_FILLED_MASK 0x400U
#define CAN3_CSR7_FILLED 0x400U
#define CAN3_CSR7_FILLED_BIT 10
#define CAN3_CSR7_OVRUN_MASK 0x800U
#define CAN3_CSR7_OVRUN 0x800U
#define CAN3_CSR7_OVRUN_BIT 11

#define CAN3_SR7 (*(volatile unsigned long *)0xFFFB02DC)
#define CAN3_SR7_OFFSET 0x2DC
#define CAN3_SR7_ACK_MASK 0x1U
#define CAN3_SR7_ACK 0x1U
#define CAN3_SR7_ACK_BIT 0
#define CAN3_SR7_FRAME_MASK 0x2U
#define CAN3_SR7_FRAME 0x2U
#define CAN3_SR7_FRAME_BIT 1
#define CAN3_SR7_CRC_MASK 0x4U
#define CAN3_SR7_CRC 0x4U
#define CAN3_SR7_CRC_BIT 2
#define CAN3_SR7_STUFF_MASK 0x8U
#define CAN3_SR7_STUFF 0x8U
#define CAN3_SR7_STUFF_BIT 3
#define CAN3_SR7_BUS_MASK 0x10U
#define CAN3_SR7_BUS 0x10U
#define CAN3_SR7_BUS_BIT 4
#define CAN3_SR7_RXOK_MASK 0x20U
#define CAN3_SR7_RXOK 0x20U
#define CAN3_SR7_RXOK_BIT 5
#define CAN3_SR7_TXOK_MASK 0x40U
#define CAN3_SR7_TXOK 0x40U
#define CAN3_SR7_TXOK_BIT 6
#define CAN3_SR7_RFRAME_MASK 0x80U
#define CAN3_SR7_RFRAME 0x80U
#define CAN3_SR7_RFRAME_BIT 7
#define CAN3_SR7_DLCW_MASK 0x200U
#define CAN3_SR7_DLCW 0x200U
#define CAN3_SR7_DLCW_BIT 9
#define CAN3_SR7_FILLED_MASK 0x400U
#define CAN3_SR7_FILLED 0x400U
#define CAN3_SR7_FILLED_BIT 10
#define CAN3_SR7_OVRUN_MASK 0x800U
#define CAN3_SR7_OVRUN 0x800U
#define CAN3_SR7_OVRUN_BIT 11

#define CAN3_IER7 (*(volatile unsigned long *)0xFFFB02E0)
#define CAN3_IER7_OFFSET 0x2E0
#define CAN3_IER7_ACK_MASK 0x1U
#define CAN3_IER7_ACK 0x1U
#define CAN3_IER7_ACK_BIT 0
#define CAN3_IER7_FRAME_MASK 0x2U
#define CAN3_IER7_FRAME 0x2U
#define CAN3_IER7_FRAME_BIT 1
#define CAN3_IER7_CRC_MASK 0x4U
#define CAN3_IER7_CRC 0x4U
#define CAN3_IER7_CRC_BIT 2
#define CAN3_IER7_STUFF_MASK 0x8U
#define CAN3_IER7_STUFF 0x8U
#define CAN3_IER7_STUFF_BIT 3
#define CAN3_IER7_BUS_MASK 0x10U
#define CAN3_IER7_BUS 0x10U
#define CAN3_IER7_BUS_BIT 4
#define CAN3_IER7_RXOK_MASK 0x20U
#define CAN3_IER7_RXOK 0x20U
#define CAN3_IER7_RXOK_BIT 5
#define CAN3_IER7_TXOK_MASK 0x40U
#define CAN3_IER7_TXOK 0x40U
#define CAN3_IER7_TXOK_BIT 6
#define CAN3_IER7_RFRAME_MASK 0x80U
#define CAN3_IER7_RFRAME 0x80U
#define CAN3_IER7_RFRAME_BIT 7

#define CAN3_IDR7 (*(volatile unsigned long *)0xFFFB02E4)
#define CAN3_IDR7_OFFSET 0x2E4
#define CAN3_IDR7_ACK_MASK 0x1U
#define CAN3_IDR7_ACK 0x1U
#define CAN3_IDR7_ACK_BIT 0
#define CAN3_IDR7_FRAME_MASK 0x2U
#define CAN3_IDR7_FRAME 0x2U
#define CAN3_IDR7_FRAME_BIT 1
#define CAN3_IDR7_CRC_MASK 0x4U
#define CAN3_IDR7_CRC 0x4U
#define CAN3_IDR7_CRC_BIT 2
#define CAN3_IDR7_STUFF_MASK 0x8U
#define CAN3_IDR7_STUFF 0x8U
#define CAN3_IDR7_STUFF_BIT 3
#define CAN3_IDR7_BUS_MASK 0x10U
#define CAN3_IDR7_BUS 0x10U
#define CAN3_IDR7_BUS_BIT 4
#define CAN3_IDR7_RXOK_MASK 0x20U
#define CAN3_IDR7_RXOK 0x20U
#define CAN3_IDR7_RXOK_BIT 5
#define CAN3_IDR7_TXOK_MASK 0x40U
#define CAN3_IDR7_TXOK 0x40U
#define CAN3_IDR7_TXOK_BIT 6
#define CAN3_IDR7_RFRAME_MASK 0x80U
#define CAN3_IDR7_RFRAME 0x80U
#define CAN3_IDR7_RFRAME_BIT 7

#define CAN3_IMR7 (*(volatile unsigned long *)0xFFFB02E8)
#define CAN3_IMR7_OFFSET 0x2E8
#define CAN3_IMR7_ACK_MASK 0x1U
#define CAN3_IMR7_ACK 0x1U
#define CAN3_IMR7_ACK_BIT 0
#define CAN3_IMR7_FRAME_MASK 0x2U
#define CAN3_IMR7_FRAME 0x2U
#define CAN3_IMR7_FRAME_BIT 1
#define CAN3_IMR7_CRC_MASK 0x4U
#define CAN3_IMR7_CRC 0x4U
#define CAN3_IMR7_CRC_BIT 2
#define CAN3_IMR7_STUFF_MASK 0x8U
#define CAN3_IMR7_STUFF 0x8U
#define CAN3_IMR7_STUFF_BIT 3
#define CAN3_IMR7_BUS_MASK 0x10U
#define CAN3_IMR7_BUS 0x10U
#define CAN3_IMR7_BUS_BIT 4
#define CAN3_IMR7_RXOK_MASK 0x20U
#define CAN3_IMR7_RXOK 0x20U
#define CAN3_IMR7_RXOK_BIT 5
#define CAN3_IMR7_TXOK_MASK 0x40U
#define CAN3_IMR7_TXOK 0x40U
#define CAN3_IMR7_TXOK_BIT 6
#define CAN3_IMR7_RFRAME_MASK 0x80U
#define CAN3_IMR7_RFRAME 0x80U
#define CAN3_IMR7_RFRAME_BIT 7

#define CAN3_DRA8 (*(volatile unsigned long *)0xFFFB0300)
#define CAN3_DRA8_OFFSET 0x300
#define CAN3_DRA8_DATA0_MASK 0xFFU
#define CAN3_DRA8_DATA0_BIT 0
#define CAN3_DRA8_DATA1_MASK 0xFF00U
#define CAN3_DRA8_DATA1_BIT 8
#define CAN3_DRA8_DATA2_MASK 0xFF0000U
#define CAN3_DRA8_DATA2_BIT 16
#define CAN3_DRA8_DATA3_MASK 0xFF000000U
#define CAN3_DRA8_DATA3_BIT 24

#define CAN3_DRB8 (*(volatile unsigned long *)0xFFFB0304)
#define CAN3_DRB8_OFFSET 0x304
#define CAN3_DRB8_DATA4_MASK 0xFFU
#define CAN3_DRB8_DATA4_BIT 0
#define CAN3_DRB8_DATA5_MASK 0xFF00U
#define CAN3_DRB8_DATA5_BIT 8
#define CAN3_DRB8_DATA6_MASK 0xFF0000U
#define CAN3_DRB8_DATA6_BIT 16
#define CAN3_DRB8_DATA7_MASK 0xFF000000U
#define CAN3_DRB8_DATA7_BIT 24

#define CAN3_MSK8 (*(volatile unsigned long *)0xFFFB0308)
#define CAN3_MSK8_OFFSET 0x308
#define CAN3_MSK8_MASK_MASK 0x1FFFFFFFU
#define CAN3_MSK8_MASK_BIT 0
#define CAN3_MSK8_MRB_MASK 0x60000000U
#define CAN3_MSK8_MRB_BIT 29
#define CAN3_MSK8_MRTR_MASK 0x80000000U
#define CAN3_MSK8_MRTR 0x80000000U
#define CAN3_MSK8_MRTR_BIT 31

#define CAN3_IR8 (*(volatile unsigned long *)0xFFFB030C)
#define CAN3_IR8_OFFSET 0x30C
#define CAN3_IR8_ID_MASK 0x1FFFFFFFU
#define CAN3_IR8_ID_BIT 0
#define CAN3_IR8_RB_MASK 0x60000000U
#define CAN3_IR8_RB_BIT 29
#define CAN3_IR8_RTR_MASK 0x80000000U
#define CAN3_IR8_RTR 0x80000000U
#define CAN3_IR8_RTR_BIT 31

#define CAN3_CR8 (*(volatile unsigned long *)0xFFFB0310)
#define CAN3_CR8_OFFSET 0x310
#define CAN3_CR8_DLC_MASK 0xFU
#define CAN3_CR8_DLC_BIT 0
#define CAN3_CR8_IDE_MASK 0x10U
#define CAN3_CR8_IDE 0x10U
#define CAN3_CR8_IDE_BIT 4
#define CAN3_CR8_RPLYV_MASK 0x20U
#define CAN3_CR8_RPLYV 0x20U
#define CAN3_CR8_RPLYV_BIT 5
#define CAN3_CR8_PCB_MASK 0x40U
#define CAN3_CR8_PCB 0x40U
#define CAN3_CR8_PCB_BIT 6
#define CAN3_CR8_CHANEN_MASK 0x80U
#define CAN3_CR8_CHANEN 0x80U
#define CAN3_CR8_CHANEN_BIT 7
#define CAN3_CR8_OVERWRITE_MASK 0x100U
#define CAN3_CR8_OVERWRITE 0x100U
#define CAN3_CR8_OVERWRITE_BIT 8

#define CAN3_CR8 (*(volatile unsigned long *)0xFFFB0314)
#define CAN3_CR8_OFFSET 0x314
#define CAN3_CR8_STAMP_MASK 0x0U
#define CAN3_CR8_STAMP_BIT 0

#define CAN3_CSR8 (*(volatile unsigned long *)0xFFFB0318)
#define CAN3_CSR8_OFFSET 0x318
#define CAN3_CSR8_ACK_MASK 0x1U
#define CAN3_CSR8_ACK 0x1U
#define CAN3_CSR8_ACK_BIT 0
#define CAN3_CSR8_FRAME_MASK 0x2U
#define CAN3_CSR8_FRAME 0x2U
#define CAN3_CSR8_FRAME_BIT 1
#define CAN3_CSR8_CRC_MASK 0x4U
#define CAN3_CSR8_CRC 0x4U
#define CAN3_CSR8_CRC_BIT 2
#define CAN3_CSR8_STUFF_MASK 0x8U
#define CAN3_CSR8_STUFF 0x8U
#define CAN3_CSR8_STUFF_BIT 3
#define CAN3_CSR8_BUS_MASK 0x10U
#define CAN3_CSR8_BUS 0x10U
#define CAN3_CSR8_BUS_BIT 4
#define CAN3_CSR8_RXOK_MASK 0x20U
#define CAN3_CSR8_RXOK 0x20U
#define CAN3_CSR8_RXOK_BIT 5
#define CAN3_CSR8_TXOK_MASK 0x40U
#define CAN3_CSR8_TXOK 0x40U
#define CAN3_CSR8_TXOK_BIT 6
#define CAN3_CSR8_RFRAME_MASK 0x80U
#define CAN3_CSR8_RFRAME 0x80U
#define CAN3_CSR8_RFRAME_BIT 7
#define CAN3_CSR8_DLCW_MASK 0x200U
#define CAN3_CSR8_DLCW 0x200U
#define CAN3_CSR8_DLCW_BIT 9
#define CAN3_CSR8_FILLED_MASK 0x400U
#define CAN3_CSR8_FILLED 0x400U
#define CAN3_CSR8_FILLED_BIT 10
#define CAN3_CSR8_OVRUN_MASK 0x800U
#define CAN3_CSR8_OVRUN 0x800U
#define CAN3_CSR8_OVRUN_BIT 11

#define CAN3_SR8 (*(volatile unsigned long *)0xFFFB031C)
#define CAN3_SR8_OFFSET 0x31C
#define CAN3_SR8_ACK_MASK 0x1U
#define CAN3_SR8_ACK 0x1U
#define CAN3_SR8_ACK_BIT 0
#define CAN3_SR8_FRAME_MASK 0x2U
#define CAN3_SR8_FRAME 0x2U
#define CAN3_SR8_FRAME_BIT 1
#define CAN3_SR8_CRC_MASK 0x4U
#define CAN3_SR8_CRC 0x4U
#define CAN3_SR8_CRC_BIT 2
#define CAN3_SR8_STUFF_MASK 0x8U
#define CAN3_SR8_STUFF 0x8U
#define CAN3_SR8_STUFF_BIT 3
#define CAN3_SR8_BUS_MASK 0x10U
#define CAN3_SR8_BUS 0x10U
#define CAN3_SR8_BUS_BIT 4
#define CAN3_SR8_RXOK_MASK 0x20U
#define CAN3_SR8_RXOK 0x20U
#define CAN3_SR8_RXOK_BIT 5
#define CAN3_SR8_TXOK_MASK 0x40U
#define CAN3_SR8_TXOK 0x40U
#define CAN3_SR8_TXOK_BIT 6
#define CAN3_SR8_RFRAME_MASK 0x80U
#define CAN3_SR8_RFRAME 0x80U
#define CAN3_SR8_RFRAME_BIT 7
#define CAN3_SR8_DLCW_MASK 0x200U
#define CAN3_SR8_DLCW 0x200U
#define CAN3_SR8_DLCW_BIT 9
#define CAN3_SR8_FILLED_MASK 0x400U
#define CAN3_SR8_FILLED 0x400U
#define CAN3_SR8_FILLED_BIT 10
#define CAN3_SR8_OVRUN_MASK 0x800U
#define CAN3_SR8_OVRUN 0x800U
#define CAN3_SR8_OVRUN_BIT 11

#define CAN3_IER8 (*(volatile unsigned long *)0xFFFB0320)
#define CAN3_IER8_OFFSET 0x320
#define CAN3_IER8_ACK_MASK 0x1U
#define CAN3_IER8_ACK 0x1U
#define CAN3_IER8_ACK_BIT 0
#define CAN3_IER8_FRAME_MASK 0x2U
#define CAN3_IER8_FRAME 0x2U
#define CAN3_IER8_FRAME_BIT 1
#define CAN3_IER8_CRC_MASK 0x4U
#define CAN3_IER8_CRC 0x4U
#define CAN3_IER8_CRC_BIT 2
#define CAN3_IER8_STUFF_MASK 0x8U
#define CAN3_IER8_STUFF 0x8U
#define CAN3_IER8_STUFF_BIT 3
#define CAN3_IER8_BUS_MASK 0x10U
#define CAN3_IER8_BUS 0x10U
#define CAN3_IER8_BUS_BIT 4
#define CAN3_IER8_RXOK_MASK 0x20U
#define CAN3_IER8_RXOK 0x20U
#define CAN3_IER8_RXOK_BIT 5
#define CAN3_IER8_TXOK_MASK 0x40U
#define CAN3_IER8_TXOK 0x40U
#define CAN3_IER8_TXOK_BIT 6
#define CAN3_IER8_RFRAME_MASK 0x80U
#define CAN3_IER8_RFRAME 0x80U
#define CAN3_IER8_RFRAME_BIT 7

#define CAN3_IDR8 (*(volatile unsigned long *)0xFFFB0324)
#define CAN3_IDR8_OFFSET 0x324
#define CAN3_IDR8_ACK_MASK 0x1U
#define CAN3_IDR8_ACK 0x1U
#define CAN3_IDR8_ACK_BIT 0
#define CAN3_IDR8_FRAME_MASK 0x2U
#define CAN3_IDR8_FRAME 0x2U
#define CAN3_IDR8_FRAME_BIT 1
#define CAN3_IDR8_CRC_MASK 0x4U
#define CAN3_IDR8_CRC 0x4U
#define CAN3_IDR8_CRC_BIT 2
#define CAN3_IDR8_STUFF_MASK 0x8U
#define CAN3_IDR8_STUFF 0x8U
#define CAN3_IDR8_STUFF_BIT 3
#define CAN3_IDR8_BUS_MASK 0x10U
#define CAN3_IDR8_BUS 0x10U
#define CAN3_IDR8_BUS_BIT 4
#define CAN3_IDR8_RXOK_MASK 0x20U
#define CAN3_IDR8_RXOK 0x20U
#define CAN3_IDR8_RXOK_BIT 5
#define CAN3_IDR8_TXOK_MASK 0x40U
#define CAN3_IDR8_TXOK 0x40U
#define CAN3_IDR8_TXOK_BIT 6
#define CAN3_IDR8_RFRAME_MASK 0x80U
#define CAN3_IDR8_RFRAME 0x80U
#define CAN3_IDR8_RFRAME_BIT 7

#define CAN3_IMR8 (*(volatile unsigned long *)0xFFFB0328)
#define CAN3_IMR8_OFFSET 0x328
#define CAN3_IMR8_ACK_MASK 0x1U
#define CAN3_IMR8_ACK 0x1U
#define CAN3_IMR8_ACK_BIT 0
#define CAN3_IMR8_FRAME_MASK 0x2U
#define CAN3_IMR8_FRAME 0x2U
#define CAN3_IMR8_FRAME_BIT 1
#define CAN3_IMR8_CRC_MASK 0x4U
#define CAN3_IMR8_CRC 0x4U
#define CAN3_IMR8_CRC_BIT 2
#define CAN3_IMR8_STUFF_MASK 0x8U
#define CAN3_IMR8_STUFF 0x8U
#define CAN3_IMR8_STUFF_BIT 3
#define CAN3_IMR8_BUS_MASK 0x10U
#define CAN3_IMR8_BUS 0x10U
#define CAN3_IMR8_BUS_BIT 4
#define CAN3_IMR8_RXOK_MASK 0x20U
#define CAN3_IMR8_RXOK 0x20U
#define CAN3_IMR8_RXOK_BIT 5
#define CAN3_IMR8_TXOK_MASK 0x40U
#define CAN3_IMR8_TXOK 0x40U
#define CAN3_IMR8_TXOK_BIT 6
#define CAN3_IMR8_RFRAME_MASK 0x80U
#define CAN3_IMR8_RFRAME 0x80U
#define CAN3_IMR8_RFRAME_BIT 7

#define CAN3_DRA9 (*(volatile unsigned long *)0xFFFB0340)
#define CAN3_DRA9_OFFSET 0x340
#define CAN3_DRA9_DATA0_MASK 0xFFU
#define CAN3_DRA9_DATA0_BIT 0
#define CAN3_DRA9_DATA1_MASK 0xFF00U
#define CAN3_DRA9_DATA1_BIT 8
#define CAN3_DRA9_DATA2_MASK 0xFF0000U
#define CAN3_DRA9_DATA2_BIT 16
#define CAN3_DRA9_DATA3_MASK 0xFF000000U
#define CAN3_DRA9_DATA3_BIT 24

#define CAN3_DRB9 (*(volatile unsigned long *)0xFFFB0344)
#define CAN3_DRB9_OFFSET 0x344
#define CAN3_DRB9_DATA4_MASK 0xFFU
#define CAN3_DRB9_DATA4_BIT 0
#define CAN3_DRB9_DATA5_MASK 0xFF00U
#define CAN3_DRB9_DATA5_BIT 8
#define CAN3_DRB9_DATA6_MASK 0xFF0000U
#define CAN3_DRB9_DATA6_BIT 16
#define CAN3_DRB9_DATA7_MASK 0xFF000000U
#define CAN3_DRB9_DATA7_BIT 24

#define CAN3_MSK9 (*(volatile unsigned long *)0xFFFB0348)
#define CAN3_MSK9_OFFSET 0x348
#define CAN3_MSK9_MASK_MASK 0x1FFFFFFFU
#define CAN3_MSK9_MASK_BIT 0
#define CAN3_MSK9_MRB_MASK 0x60000000U
#define CAN3_MSK9_MRB_BIT 29
#define CAN3_MSK9_MRTR_MASK 0x80000000U
#define CAN3_MSK9_MRTR 0x80000000U
#define CAN3_MSK9_MRTR_BIT 31

#define CAN3_IR9 (*(volatile unsigned long *)0xFFFB034C)
#define CAN3_IR9_OFFSET 0x34C
#define CAN3_IR9_ID_MASK 0x1FFFFFFFU
#define CAN3_IR9_ID_BIT 0
#define CAN3_IR9_RB_MASK 0x60000000U
#define CAN3_IR9_RB_BIT 29
#define CAN3_IR9_RTR_MASK 0x80000000U
#define CAN3_IR9_RTR 0x80000000U
#define CAN3_IR9_RTR_BIT 31

#define CAN3_CR9 (*(volatile unsigned long *)0xFFFB0350)
#define CAN3_CR9_OFFSET 0x350
#define CAN3_CR9_DLC_MASK 0xFU
#define CAN3_CR9_DLC_BIT 0
#define CAN3_CR9_IDE_MASK 0x10U
#define CAN3_CR9_IDE 0x10U
#define CAN3_CR9_IDE_BIT 4
#define CAN3_CR9_RPLYV_MASK 0x20U
#define CAN3_CR9_RPLYV 0x20U
#define CAN3_CR9_RPLYV_BIT 5
#define CAN3_CR9_PCB_MASK 0x40U
#define CAN3_CR9_PCB 0x40U
#define CAN3_CR9_PCB_BIT 6
#define CAN3_CR9_CHANEN_MASK 0x80U
#define CAN3_CR9_CHANEN 0x80U
#define CAN3_CR9_CHANEN_BIT 7
#define CAN3_CR9_OVERWRITE_MASK 0x100U
#define CAN3_CR9_OVERWRITE 0x100U
#define CAN3_CR9_OVERWRITE_BIT 8

#define CAN3_CR9 (*(volatile unsigned long *)0xFFFB0354)
#define CAN3_CR9_OFFSET 0x354
#define CAN3_CR9_STAMP_MASK 0x0U
#define CAN3_CR9_STAMP_BIT 0

#define CAN3_CSR9 (*(volatile unsigned long *)0xFFFB0358)
#define CAN3_CSR9_OFFSET 0x358
#define CAN3_CSR9_ACK_MASK 0x1U
#define CAN3_CSR9_ACK 0x1U
#define CAN3_CSR9_ACK_BIT 0
#define CAN3_CSR9_FRAME_MASK 0x2U
#define CAN3_CSR9_FRAME 0x2U
#define CAN3_CSR9_FRAME_BIT 1
#define CAN3_CSR9_CRC_MASK 0x4U
#define CAN3_CSR9_CRC 0x4U
#define CAN3_CSR9_CRC_BIT 2
#define CAN3_CSR9_STUFF_MASK 0x8U
#define CAN3_CSR9_STUFF 0x8U
#define CAN3_CSR9_STUFF_BIT 3
#define CAN3_CSR9_BUS_MASK 0x10U
#define CAN3_CSR9_BUS 0x10U
#define CAN3_CSR9_BUS_BIT 4
#define CAN3_CSR9_RXOK_MASK 0x20U
#define CAN3_CSR9_RXOK 0x20U
#define CAN3_CSR9_RXOK_BIT 5
#define CAN3_CSR9_TXOK_MASK 0x40U
#define CAN3_CSR9_TXOK 0x40U
#define CAN3_CSR9_TXOK_BIT 6
#define CAN3_CSR9_RFRAME_MASK 0x80U
#define CAN3_CSR9_RFRAME 0x80U
#define CAN3_CSR9_RFRAME_BIT 7
#define CAN3_CSR9_DLCW_MASK 0x200U
#define CAN3_CSR9_DLCW 0x200U
#define CAN3_CSR9_DLCW_BIT 9
#define CAN3_CSR9_FILLED_MASK 0x400U
#define CAN3_CSR9_FILLED 0x400U
#define CAN3_CSR9_FILLED_BIT 10
#define CAN3_CSR9_OVRUN_MASK 0x800U
#define CAN3_CSR9_OVRUN 0x800U
#define CAN3_CSR9_OVRUN_BIT 11

#define CAN3_SR9 (*(volatile unsigned long *)0xFFFB035C)
#define CAN3_SR9_OFFSET 0x35C
#define CAN3_SR9_ACK_MASK 0x1U
#define CAN3_SR9_ACK 0x1U
#define CAN3_SR9_ACK_BIT 0
#define CAN3_SR9_FRAME_MASK 0x2U
#define CAN3_SR9_FRAME 0x2U
#define CAN3_SR9_FRAME_BIT 1
#define CAN3_SR9_CRC_MASK 0x4U
#define CAN3_SR9_CRC 0x4U
#define CAN3_SR9_CRC_BIT 2
#define CAN3_SR9_STUFF_MASK 0x8U
#define CAN3_SR9_STUFF 0x8U
#define CAN3_SR9_STUFF_BIT 3
#define CAN3_SR9_BUS_MASK 0x10U
#define CAN3_SR9_BUS 0x10U
#define CAN3_SR9_BUS_BIT 4
#define CAN3_SR9_RXOK_MASK 0x20U
#define CAN3_SR9_RXOK 0x20U
#define CAN3_SR9_RXOK_BIT 5
#define CAN3_SR9_TXOK_MASK 0x40U
#define CAN3_SR9_TXOK 0x40U
#define CAN3_SR9_TXOK_BIT 6
#define CAN3_SR9_RFRAME_MASK 0x80U
#define CAN3_SR9_RFRAME 0x80U
#define CAN3_SR9_RFRAME_BIT 7
#define CAN3_SR9_DLCW_MASK 0x200U
#define CAN3_SR9_DLCW 0x200U
#define CAN3_SR9_DLCW_BIT 9
#define CAN3_SR9_FILLED_MASK 0x400U
#define CAN3_SR9_FILLED 0x400U
#define CAN3_SR9_FILLED_BIT 10
#define CAN3_SR9_OVRUN_MASK 0x800U
#define CAN3_SR9_OVRUN 0x800U
#define CAN3_SR9_OVRUN_BIT 11

#define CAN3_IER9 (*(volatile unsigned long *)0xFFFB0360)
#define CAN3_IER9_OFFSET 0x360
#define CAN3_IER9_ACK_MASK 0x1U
#define CAN3_IER9_ACK 0x1U
#define CAN3_IER9_ACK_BIT 0
#define CAN3_IER9_FRAME_MASK 0x2U
#define CAN3_IER9_FRAME 0x2U
#define CAN3_IER9_FRAME_BIT 1
#define CAN3_IER9_CRC_MASK 0x4U
#define CAN3_IER9_CRC 0x4U
#define CAN3_IER9_CRC_BIT 2
#define CAN3_IER9_STUFF_MASK 0x8U
#define CAN3_IER9_STUFF 0x8U
#define CAN3_IER9_STUFF_BIT 3
#define CAN3_IER9_BUS_MASK 0x10U
#define CAN3_IER9_BUS 0x10U
#define CAN3_IER9_BUS_BIT 4
#define CAN3_IER9_RXOK_MASK 0x20U
#define CAN3_IER9_RXOK 0x20U
#define CAN3_IER9_RXOK_BIT 5
#define CAN3_IER9_TXOK_MASK 0x40U
#define CAN3_IER9_TXOK 0x40U
#define CAN3_IER9_TXOK_BIT 6
#define CAN3_IER9_RFRAME_MASK 0x80U
#define CAN3_IER9_RFRAME 0x80U
#define CAN3_IER9_RFRAME_BIT 7

#define CAN3_IDR9 (*(volatile unsigned long *)0xFFFB0364)
#define CAN3_IDR9_OFFSET 0x364
#define CAN3_IDR9_ACK_MASK 0x1U
#define CAN3_IDR9_ACK 0x1U
#define CAN3_IDR9_ACK_BIT 0
#define CAN3_IDR9_FRAME_MASK 0x2U
#define CAN3_IDR9_FRAME 0x2U
#define CAN3_IDR9_FRAME_BIT 1
#define CAN3_IDR9_CRC_MASK 0x4U
#define CAN3_IDR9_CRC 0x4U
#define CAN3_IDR9_CRC_BIT 2
#define CAN3_IDR9_STUFF_MASK 0x8U
#define CAN3_IDR9_STUFF 0x8U
#define CAN3_IDR9_STUFF_BIT 3
#define CAN3_IDR9_BUS_MASK 0x10U
#define CAN3_IDR9_BUS 0x10U
#define CAN3_IDR9_BUS_BIT 4
#define CAN3_IDR9_RXOK_MASK 0x20U
#define CAN3_IDR9_RXOK 0x20U
#define CAN3_IDR9_RXOK_BIT 5
#define CAN3_IDR9_TXOK_MASK 0x40U
#define CAN3_IDR9_TXOK 0x40U
#define CAN3_IDR9_TXOK_BIT 6
#define CAN3_IDR9_RFRAME_MASK 0x80U
#define CAN3_IDR9_RFRAME 0x80U
#define CAN3_IDR9_RFRAME_BIT 7

#define CAN3_IMR9 (*(volatile unsigned long *)0xFFFB0368)
#define CAN3_IMR9_OFFSET 0x368
#define CAN3_IMR9_ACK_MASK 0x1U
#define CAN3_IMR9_ACK 0x1U
#define CAN3_IMR9_ACK_BIT 0
#define CAN3_IMR9_FRAME_MASK 0x2U
#define CAN3_IMR9_FRAME 0x2U
#define CAN3_IMR9_FRAME_BIT 1
#define CAN3_IMR9_CRC_MASK 0x4U
#define CAN3_IMR9_CRC 0x4U
#define CAN3_IMR9_CRC_BIT 2
#define CAN3_IMR9_STUFF_MASK 0x8U
#define CAN3_IMR9_STUFF 0x8U
#define CAN3_IMR9_STUFF_BIT 3
#define CAN3_IMR9_BUS_MASK 0x10U
#define CAN3_IMR9_BUS 0x10U
#define CAN3_IMR9_BUS_BIT 4
#define CAN3_IMR9_RXOK_MASK 0x20U
#define CAN3_IMR9_RXOK 0x20U
#define CAN3_IMR9_RXOK_BIT 5
#define CAN3_IMR9_TXOK_MASK 0x40U
#define CAN3_IMR9_TXOK 0x40U
#define CAN3_IMR9_TXOK_BIT 6
#define CAN3_IMR9_RFRAME_MASK 0x80U
#define CAN3_IMR9_RFRAME 0x80U
#define CAN3_IMR9_RFRAME_BIT 7

#define CAN3_DRA10 (*(volatile unsigned long *)0xFFFB0380)
#define CAN3_DRA10_OFFSET 0x380
#define CAN3_DRA10_DATA0_MASK 0xFFU
#define CAN3_DRA10_DATA0_BIT 0
#define CAN3_DRA10_DATA1_MASK 0xFF00U
#define CAN3_DRA10_DATA1_BIT 8
#define CAN3_DRA10_DATA2_MASK 0xFF0000U
#define CAN3_DRA10_DATA2_BIT 16
#define CAN3_DRA10_DATA3_MASK 0xFF000000U
#define CAN3_DRA10_DATA3_BIT 24

#define CAN3_DRB10 (*(volatile unsigned long *)0xFFFB0384)
#define CAN3_DRB10_OFFSET 0x384
#define CAN3_DRB10_DATA4_MASK 0xFFU
#define CAN3_DRB10_DATA4_BIT 0
#define CAN3_DRB10_DATA5_MASK 0xFF00U
#define CAN3_DRB10_DATA5_BIT 8
#define CAN3_DRB10_DATA6_MASK 0xFF0000U
#define CAN3_DRB10_DATA6_BIT 16
#define CAN3_DRB10_DATA7_MASK 0xFF000000U
#define CAN3_DRB10_DATA7_BIT 24

#define CAN3_MSK10 (*(volatile unsigned long *)0xFFFB0388)
#define CAN3_MSK10_OFFSET 0x388
#define CAN3_MSK10_MASK_MASK 0x1FFFFFFFU
#define CAN3_MSK10_MASK_BIT 0
#define CAN3_MSK10_MRB_MASK 0x60000000U
#define CAN3_MSK10_MRB_BIT 29
#define CAN3_MSK10_MRTR_MASK 0x80000000U
#define CAN3_MSK10_MRTR 0x80000000U
#define CAN3_MSK10_MRTR_BIT 31

#define CAN3_IR10 (*(volatile unsigned long *)0xFFFB038C)
#define CAN3_IR10_OFFSET 0x38C
#define CAN3_IR10_ID_MASK 0x1FFFFFFFU
#define CAN3_IR10_ID_BIT 0
#define CAN3_IR10_RB_MASK 0x60000000U
#define CAN3_IR10_RB_BIT 29
#define CAN3_IR10_RTR_MASK 0x80000000U
#define CAN3_IR10_RTR 0x80000000U
#define CAN3_IR10_RTR_BIT 31

#define CAN3_CR10 (*(volatile unsigned long *)0xFFFB0390)
#define CAN3_CR10_OFFSET 0x390
#define CAN3_CR10_DLC_MASK 0xFU
#define CAN3_CR10_DLC_BIT 0
#define CAN3_CR10_IDE_MASK 0x10U
#define CAN3_CR10_IDE 0x10U
#define CAN3_CR10_IDE_BIT 4
#define CAN3_CR10_RPLYV_MASK 0x20U
#define CAN3_CR10_RPLYV 0x20U
#define CAN3_CR10_RPLYV_BIT 5
#define CAN3_CR10_PCB_MASK 0x40U
#define CAN3_CR10_PCB 0x40U
#define CAN3_CR10_PCB_BIT 6
#define CAN3_CR10_CHANEN_MASK 0x80U
#define CAN3_CR10_CHANEN 0x80U
#define CAN3_CR10_CHANEN_BIT 7
#define CAN3_CR10_OVERWRITE_MASK 0x100U
#define CAN3_CR10_OVERWRITE 0x100U
#define CAN3_CR10_OVERWRITE_BIT 8

#define CAN3_CR10 (*(volatile unsigned long *)0xFFFB0394)
#define CAN3_CR10_OFFSET 0x394
#define CAN3_CR10_STAMP_MASK 0x0U
#define CAN3_CR10_STAMP_BIT 0

#define CAN3_CSR10 (*(volatile unsigned long *)0xFFFB0398)
#define CAN3_CSR10_OFFSET 0x398
#define CAN3_CSR10_ACK_MASK 0x1U
#define CAN3_CSR10_ACK 0x1U
#define CAN3_CSR10_ACK_BIT 0
#define CAN3_CSR10_FRAME_MASK 0x2U
#define CAN3_CSR10_FRAME 0x2U
#define CAN3_CSR10_FRAME_BIT 1
#define CAN3_CSR10_CRC_MASK 0x4U
#define CAN3_CSR10_CRC 0x4U
#define CAN3_CSR10_CRC_BIT 2
#define CAN3_CSR10_STUFF_MASK 0x8U
#define CAN3_CSR10_STUFF 0x8U
#define CAN3_CSR10_STUFF_BIT 3
#define CAN3_CSR10_BUS_MASK 0x10U
#define CAN3_CSR10_BUS 0x10U
#define CAN3_CSR10_BUS_BIT 4
#define CAN3_CSR10_RXOK_MASK 0x20U
#define CAN3_CSR10_RXOK 0x20U
#define CAN3_CSR10_RXOK_BIT 5
#define CAN3_CSR10_TXOK_MASK 0x40U
#define CAN3_CSR10_TXOK 0x40U
#define CAN3_CSR10_TXOK_BIT 6
#define CAN3_CSR10_RFRAME_MASK 0x80U
#define CAN3_CSR10_RFRAME 0x80U
#define CAN3_CSR10_RFRAME_BIT 7
#define CAN3_CSR10_DLCW_MASK 0x200U
#define CAN3_CSR10_DLCW 0x200U
#define CAN3_CSR10_DLCW_BIT 9
#define CAN3_CSR10_FILLED_MASK 0x400U
#define CAN3_CSR10_FILLED 0x400U
#define CAN3_CSR10_FILLED_BIT 10
#define CAN3_CSR10_OVRUN_MASK 0x800U
#define CAN3_CSR10_OVRUN 0x800U
#define CAN3_CSR10_OVRUN_BIT 11

#define CAN3_SR10 (*(volatile unsigned long *)0xFFFB039C)
#define CAN3_SR10_OFFSET 0x39C
#define CAN3_SR10_ACK_MASK 0x1U
#define CAN3_SR10_ACK 0x1U
#define CAN3_SR10_ACK_BIT 0
#define CAN3_SR10_FRAME_MASK 0x2U
#define CAN3_SR10_FRAME 0x2U
#define CAN3_SR10_FRAME_BIT 1
#define CAN3_SR10_CRC_MASK 0x4U
#define CAN3_SR10_CRC 0x4U
#define CAN3_SR10_CRC_BIT 2
#define CAN3_SR10_STUFF_MASK 0x8U
#define CAN3_SR10_STUFF 0x8U
#define CAN3_SR10_STUFF_BIT 3
#define CAN3_SR10_BUS_MASK 0x10U
#define CAN3_SR10_BUS 0x10U
#define CAN3_SR10_BUS_BIT 4
#define CAN3_SR10_RXOK_MASK 0x20U
#define CAN3_SR10_RXOK 0x20U
#define CAN3_SR10_RXOK_BIT 5
#define CAN3_SR10_TXOK_MASK 0x40U
#define CAN3_SR10_TXOK 0x40U
#define CAN3_SR10_TXOK_BIT 6
#define CAN3_SR10_RFRAME_MASK 0x80U
#define CAN3_SR10_RFRAME 0x80U
#define CAN3_SR10_RFRAME_BIT 7
#define CAN3_SR10_DLCW_MASK 0x200U
#define CAN3_SR10_DLCW 0x200U
#define CAN3_SR10_DLCW_BIT 9
#define CAN3_SR10_FILLED_MASK 0x400U
#define CAN3_SR10_FILLED 0x400U
#define CAN3_SR10_FILLED_BIT 10
#define CAN3_SR10_OVRUN_MASK 0x800U
#define CAN3_SR10_OVRUN 0x800U
#define CAN3_SR10_OVRUN_BIT 11

#define CAN3_IER10 (*(volatile unsigned long *)0xFFFB03A0)
#define CAN3_IER10_OFFSET 0x3A0
#define CAN3_IER10_ACK_MASK 0x1U
#define CAN3_IER10_ACK 0x1U
#define CAN3_IER10_ACK_BIT 0
#define CAN3_IER10_FRAME_MASK 0x2U
#define CAN3_IER10_FRAME 0x2U
#define CAN3_IER10_FRAME_BIT 1
#define CAN3_IER10_CRC_MASK 0x4U
#define CAN3_IER10_CRC 0x4U
#define CAN3_IER10_CRC_BIT 2
#define CAN3_IER10_STUFF_MASK 0x8U
#define CAN3_IER10_STUFF 0x8U
#define CAN3_IER10_STUFF_BIT 3
#define CAN3_IER10_BUS_MASK 0x10U
#define CAN3_IER10_BUS 0x10U
#define CAN3_IER10_BUS_BIT 4
#define CAN3_IER10_RXOK_MASK 0x20U
#define CAN3_IER10_RXOK 0x20U
#define CAN3_IER10_RXOK_BIT 5
#define CAN3_IER10_TXOK_MASK 0x40U
#define CAN3_IER10_TXOK 0x40U
#define CAN3_IER10_TXOK_BIT 6
#define CAN3_IER10_RFRAME_MASK 0x80U
#define CAN3_IER10_RFRAME 0x80U
#define CAN3_IER10_RFRAME_BIT 7

#define CAN3_IDR10 (*(volatile unsigned long *)0xFFFB03A4)
#define CAN3_IDR10_OFFSET 0x3A4
#define CAN3_IDR10_ACK_MASK 0x1U
#define CAN3_IDR10_ACK 0x1U
#define CAN3_IDR10_ACK_BIT 0
#define CAN3_IDR10_FRAME_MASK 0x2U
#define CAN3_IDR10_FRAME 0x2U
#define CAN3_IDR10_FRAME_BIT 1
#define CAN3_IDR10_CRC_MASK 0x4U
#define CAN3_IDR10_CRC 0x4U
#define CAN3_IDR10_CRC_BIT 2
#define CAN3_IDR10_STUFF_MASK 0x8U
#define CAN3_IDR10_STUFF 0x8U
#define CAN3_IDR10_STUFF_BIT 3
#define CAN3_IDR10_BUS_MASK 0x10U
#define CAN3_IDR10_BUS 0x10U
#define CAN3_IDR10_BUS_BIT 4
#define CAN3_IDR10_RXOK_MASK 0x20U
#define CAN3_IDR10_RXOK 0x20U
#define CAN3_IDR10_RXOK_BIT 5
#define CAN3_IDR10_TXOK_MASK 0x40U
#define CAN3_IDR10_TXOK 0x40U
#define CAN3_IDR10_TXOK_BIT 6
#define CAN3_IDR10_RFRAME_MASK 0x80U
#define CAN3_IDR10_RFRAME 0x80U
#define CAN3_IDR10_RFRAME_BIT 7

#define CAN3_IMR10 (*(volatile unsigned long *)0xFFFB03A8)
#define CAN3_IMR10_OFFSET 0x3A8
#define CAN3_IMR10_ACK_MASK 0x1U
#define CAN3_IMR10_ACK 0x1U
#define CAN3_IMR10_ACK_BIT 0
#define CAN3_IMR10_FRAME_MASK 0x2U
#define CAN3_IMR10_FRAME 0x2U
#define CAN3_IMR10_FRAME_BIT 1
#define CAN3_IMR10_CRC_MASK 0x4U
#define CAN3_IMR10_CRC 0x4U
#define CAN3_IMR10_CRC_BIT 2
#define CAN3_IMR10_STUFF_MASK 0x8U
#define CAN3_IMR10_STUFF 0x8U
#define CAN3_IMR10_STUFF_BIT 3
#define CAN3_IMR10_BUS_MASK 0x10U
#define CAN3_IMR10_BUS 0x10U
#define CAN3_IMR10_BUS_BIT 4
#define CAN3_IMR10_RXOK_MASK 0x20U
#define CAN3_IMR10_RXOK 0x20U
#define CAN3_IMR10_RXOK_BIT 5
#define CAN3_IMR10_TXOK_MASK 0x40U
#define CAN3_IMR10_TXOK 0x40U
#define CAN3_IMR10_TXOK_BIT 6
#define CAN3_IMR10_RFRAME_MASK 0x80U
#define CAN3_IMR10_RFRAME 0x80U
#define CAN3_IMR10_RFRAME_BIT 7

#define CAN3_DRA11 (*(volatile unsigned long *)0xFFFB03C0)
#define CAN3_DRA11_OFFSET 0x3C0
#define CAN3_DRA11_DATA0_MASK 0xFFU
#define CAN3_DRA11_DATA0_BIT 0
#define CAN3_DRA11_DATA1_MASK 0xFF00U
#define CAN3_DRA11_DATA1_BIT 8
#define CAN3_DRA11_DATA2_MASK 0xFF0000U
#define CAN3_DRA11_DATA2_BIT 16
#define CAN3_DRA11_DATA3_MASK 0xFF000000U
#define CAN3_DRA11_DATA3_BIT 24

#define CAN3_DRB11 (*(volatile unsigned long *)0xFFFB03C4)
#define CAN3_DRB11_OFFSET 0x3C4
#define CAN3_DRB11_DATA4_MASK 0xFFU
#define CAN3_DRB11_DATA4_BIT 0
#define CAN3_DRB11_DATA5_MASK 0xFF00U
#define CAN3_DRB11_DATA5_BIT 8
#define CAN3_DRB11_DATA6_MASK 0xFF0000U
#define CAN3_DRB11_DATA6_BIT 16
#define CAN3_DRB11_DATA7_MASK 0xFF000000U
#define CAN3_DRB11_DATA7_BIT 24

#define CAN3_MSK11 (*(volatile unsigned long *)0xFFFB03C8)
#define CAN3_MSK11_OFFSET 0x3C8
#define CAN3_MSK11_MASK_MASK 0x1FFFFFFFU
#define CAN3_MSK11_MASK_BIT 0
#define CAN3_MSK11_MRB_MASK 0x60000000U
#define CAN3_MSK11_MRB_BIT 29
#define CAN3_MSK11_MRTR_MASK 0x80000000U
#define CAN3_MSK11_MRTR 0x80000000U
#define CAN3_MSK11_MRTR_BIT 31

#define CAN3_IR11 (*(volatile unsigned long *)0xFFFB03CC)
#define CAN3_IR11_OFFSET 0x3CC
#define CAN3_IR11_ID_MASK 0x1FFFFFFFU
#define CAN3_IR11_ID_BIT 0
#define CAN3_IR11_RB_MASK 0x60000000U
#define CAN3_IR11_RB_BIT 29
#define CAN3_IR11_RTR_MASK 0x80000000U
#define CAN3_IR11_RTR 0x80000000U
#define CAN3_IR11_RTR_BIT 31

#define CAN3_CR11 (*(volatile unsigned long *)0xFFFB03D0)
#define CAN3_CR11_OFFSET 0x3D0
#define CAN3_CR11_DLC_MASK 0xFU
#define CAN3_CR11_DLC_BIT 0
#define CAN3_CR11_IDE_MASK 0x10U
#define CAN3_CR11_IDE 0x10U
#define CAN3_CR11_IDE_BIT 4
#define CAN3_CR11_RPLYV_MASK 0x20U
#define CAN3_CR11_RPLYV 0x20U
#define CAN3_CR11_RPLYV_BIT 5
#define CAN3_CR11_PCB_MASK 0x40U
#define CAN3_CR11_PCB 0x40U
#define CAN3_CR11_PCB_BIT 6
#define CAN3_CR11_CHANEN_MASK 0x80U
#define CAN3_CR11_CHANEN 0x80U
#define CAN3_CR11_CHANEN_BIT 7
#define CAN3_CR11_OVERWRITE_MASK 0x100U
#define CAN3_CR11_OVERWRITE 0x100U
#define CAN3_CR11_OVERWRITE_BIT 8

#define CAN3_CR11 (*(volatile unsigned long *)0xFFFB03D4)
#define CAN3_CR11_OFFSET 0x3D4
#define CAN3_CR11_STAMP_MASK 0x0U
#define CAN3_CR11_STAMP_BIT 0

#define CAN3_CSR11 (*(volatile unsigned long *)0xFFFB03D8)
#define CAN3_CSR11_OFFSET 0x3D8
#define CAN3_CSR11_ACK_MASK 0x1U
#define CAN3_CSR11_ACK 0x1U
#define CAN3_CSR11_ACK_BIT 0
#define CAN3_CSR11_FRAME_MASK 0x2U
#define CAN3_CSR11_FRAME 0x2U
#define CAN3_CSR11_FRAME_BIT 1
#define CAN3_CSR11_CRC_MASK 0x4U
#define CAN3_CSR11_CRC 0x4U
#define CAN3_CSR11_CRC_BIT 2
#define CAN3_CSR11_STUFF_MASK 0x8U
#define CAN3_CSR11_STUFF 0x8U
#define CAN3_CSR11_STUFF_BIT 3
#define CAN3_CSR11_BUS_MASK 0x10U
#define CAN3_CSR11_BUS 0x10U
#define CAN3_CSR11_BUS_BIT 4
#define CAN3_CSR11_RXOK_MASK 0x20U
#define CAN3_CSR11_RXOK 0x20U
#define CAN3_CSR11_RXOK_BIT 5
#define CAN3_CSR11_TXOK_MASK 0x40U
#define CAN3_CSR11_TXOK 0x40U
#define CAN3_CSR11_TXOK_BIT 6
#define CAN3_CSR11_RFRAME_MASK 0x80U
#define CAN3_CSR11_RFRAME 0x80U
#define CAN3_CSR11_RFRAME_BIT 7
#define CAN3_CSR11_DLCW_MASK 0x200U
#define CAN3_CSR11_DLCW 0x200U
#define CAN3_CSR11_DLCW_BIT 9
#define CAN3_CSR11_FILLED_MASK 0x400U
#define CAN3_CSR11_FILLED 0x400U
#define CAN3_CSR11_FILLED_BIT 10
#define CAN3_CSR11_OVRUN_MASK 0x800U
#define CAN3_CSR11_OVRUN 0x800U
#define CAN3_CSR11_OVRUN_BIT 11

#define CAN3_SR11 (*(volatile unsigned long *)0xFFFB03DC)
#define CAN3_SR11_OFFSET 0x3DC
#define CAN3_SR11_ACK_MASK 0x1U
#define CAN3_SR11_ACK 0x1U
#define CAN3_SR11_ACK_BIT 0
#define CAN3_SR11_FRAME_MASK 0x2U
#define CAN3_SR11_FRAME 0x2U
#define CAN3_SR11_FRAME_BIT 1
#define CAN3_SR11_CRC_MASK 0x4U
#define CAN3_SR11_CRC 0x4U
#define CAN3_SR11_CRC_BIT 2
#define CAN3_SR11_STUFF_MASK 0x8U
#define CAN3_SR11_STUFF 0x8U
#define CAN3_SR11_STUFF_BIT 3
#define CAN3_SR11_BUS_MASK 0x10U
#define CAN3_SR11_BUS 0x10U
#define CAN3_SR11_BUS_BIT 4
#define CAN3_SR11_RXOK_MASK 0x20U
#define CAN3_SR11_RXOK 0x20U
#define CAN3_SR11_RXOK_BIT 5
#define CAN3_SR11_TXOK_MASK 0x40U
#define CAN3_SR11_TXOK 0x40U
#define CAN3_SR11_TXOK_BIT 6
#define CAN3_SR11_RFRAME_MASK 0x80U
#define CAN3_SR11_RFRAME 0x80U
#define CAN3_SR11_RFRAME_BIT 7
#define CAN3_SR11_DLCW_MASK 0x200U
#define CAN3_SR11_DLCW 0x200U
#define CAN3_SR11_DLCW_BIT 9
#define CAN3_SR11_FILLED_MASK 0x400U
#define CAN3_SR11_FILLED 0x400U
#define CAN3_SR11_FILLED_BIT 10
#define CAN3_SR11_OVRUN_MASK 0x800U
#define CAN3_SR11_OVRUN 0x800U
#define CAN3_SR11_OVRUN_BIT 11

#define CAN3_IER11 (*(volatile unsigned long *)0xFFFB03E0)
#define CAN3_IER11_OFFSET 0x3E0
#define CAN3_IER11_ACK_MASK 0x1U
#define CAN3_IER11_ACK 0x1U
#define CAN3_IER11_ACK_BIT 0
#define CAN3_IER11_FRAME_MASK 0x2U
#define CAN3_IER11_FRAME 0x2U
#define CAN3_IER11_FRAME_BIT 1
#define CAN3_IER11_CRC_MASK 0x4U
#define CAN3_IER11_CRC 0x4U
#define CAN3_IER11_CRC_BIT 2
#define CAN3_IER11_STUFF_MASK 0x8U
#define CAN3_IER11_STUFF 0x8U
#define CAN3_IER11_STUFF_BIT 3
#define CAN3_IER11_BUS_MASK 0x10U
#define CAN3_IER11_BUS 0x10U
#define CAN3_IER11_BUS_BIT 4
#define CAN3_IER11_RXOK_MASK 0x20U
#define CAN3_IER11_RXOK 0x20U
#define CAN3_IER11_RXOK_BIT 5
#define CAN3_IER11_TXOK_MASK 0x40U
#define CAN3_IER11_TXOK 0x40U
#define CAN3_IER11_TXOK_BIT 6
#define CAN3_IER11_RFRAME_MASK 0x80U
#define CAN3_IER11_RFRAME 0x80U
#define CAN3_IER11_RFRAME_BIT 7

#define CAN3_IDR11 (*(volatile unsigned long *)0xFFFB03E4)
#define CAN3_IDR11_OFFSET 0x3E4
#define CAN3_IDR11_ACK_MASK 0x1U
#define CAN3_IDR11_ACK 0x1U
#define CAN3_IDR11_ACK_BIT 0
#define CAN3_IDR11_FRAME_MASK 0x2U
#define CAN3_IDR11_FRAME 0x2U
#define CAN3_IDR11_FRAME_BIT 1
#define CAN3_IDR11_CRC_MASK 0x4U
#define CAN3_IDR11_CRC 0x4U
#define CAN3_IDR11_CRC_BIT 2
#define CAN3_IDR11_STUFF_MASK 0x8U
#define CAN3_IDR11_STUFF 0x8U
#define CAN3_IDR11_STUFF_BIT 3
#define CAN3_IDR11_BUS_MASK 0x10U
#define CAN3_IDR11_BUS 0x10U
#define CAN3_IDR11_BUS_BIT 4
#define CAN3_IDR11_RXOK_MASK 0x20U
#define CAN3_IDR11_RXOK 0x20U
#define CAN3_IDR11_RXOK_BIT 5
#define CAN3_IDR11_TXOK_MASK 0x40U
#define CAN3_IDR11_TXOK 0x40U
#define CAN3_IDR11_TXOK_BIT 6
#define CAN3_IDR11_RFRAME_MASK 0x80U
#define CAN3_IDR11_RFRAME 0x80U
#define CAN3_IDR11_RFRAME_BIT 7

#define CAN3_IMR11 (*(volatile unsigned long *)0xFFFB03E8)
#define CAN3_IMR11_OFFSET 0x3E8
#define CAN3_IMR11_ACK_MASK 0x1U
#define CAN3_IMR11_ACK 0x1U
#define CAN3_IMR11_ACK_BIT 0
#define CAN3_IMR11_FRAME_MASK 0x2U
#define CAN3_IMR11_FRAME 0x2U
#define CAN3_IMR11_FRAME_BIT 1
#define CAN3_IMR11_CRC_MASK 0x4U
#define CAN3_IMR11_CRC 0x4U
#define CAN3_IMR11_CRC_BIT 2
#define CAN3_IMR11_STUFF_MASK 0x8U
#define CAN3_IMR11_STUFF 0x8U
#define CAN3_IMR11_STUFF_BIT 3
#define CAN3_IMR11_BUS_MASK 0x10U
#define CAN3_IMR11_BUS 0x10U
#define CAN3_IMR11_BUS_BIT 4
#define CAN3_IMR11_RXOK_MASK 0x20U
#define CAN3_IMR11_RXOK 0x20U
#define CAN3_IMR11_RXOK_BIT 5
#define CAN3_IMR11_TXOK_MASK 0x40U
#define CAN3_IMR11_TXOK 0x40U
#define CAN3_IMR11_TXOK_BIT 6
#define CAN3_IMR11_RFRAME_MASK 0x80U
#define CAN3_IMR11_RFRAME 0x80U
#define CAN3_IMR11_RFRAME_BIT 7

#define CAN3_DRA12 (*(volatile unsigned long *)0xFFFB0400)
#define CAN3_DRA12_OFFSET 0x400
#define CAN3_DRA12_DATA0_MASK 0xFFU
#define CAN3_DRA12_DATA0_BIT 0
#define CAN3_DRA12_DATA1_MASK 0xFF00U
#define CAN3_DRA12_DATA1_BIT 8
#define CAN3_DRA12_DATA2_MASK 0xFF0000U
#define CAN3_DRA12_DATA2_BIT 16
#define CAN3_DRA12_DATA3_MASK 0xFF000000U
#define CAN3_DRA12_DATA3_BIT 24

#define CAN3_DRB12 (*(volatile unsigned long *)0xFFFB0404)
#define CAN3_DRB12_OFFSET 0x404
#define CAN3_DRB12_DATA4_MASK 0xFFU
#define CAN3_DRB12_DATA4_BIT 0
#define CAN3_DRB12_DATA5_MASK 0xFF00U
#define CAN3_DRB12_DATA5_BIT 8
#define CAN3_DRB12_DATA6_MASK 0xFF0000U
#define CAN3_DRB12_DATA6_BIT 16
#define CAN3_DRB12_DATA7_MASK 0xFF000000U
#define CAN3_DRB12_DATA7_BIT 24

#define CAN3_MSK12 (*(volatile unsigned long *)0xFFFB0408)
#define CAN3_MSK12_OFFSET 0x408
#define CAN3_MSK12_MASK_MASK 0x1FFFFFFFU
#define CAN3_MSK12_MASK_BIT 0
#define CAN3_MSK12_MRB_MASK 0x60000000U
#define CAN3_MSK12_MRB_BIT 29
#define CAN3_MSK12_MRTR_MASK 0x80000000U
#define CAN3_MSK12_MRTR 0x80000000U
#define CAN3_MSK12_MRTR_BIT 31

#define CAN3_IR12 (*(volatile unsigned long *)0xFFFB040C)
#define CAN3_IR12_OFFSET 0x40C
#define CAN3_IR12_ID_MASK 0x1FFFFFFFU
#define CAN3_IR12_ID_BIT 0
#define CAN3_IR12_RB_MASK 0x60000000U
#define CAN3_IR12_RB_BIT 29
#define CAN3_IR12_RTR_MASK 0x80000000U
#define CAN3_IR12_RTR 0x80000000U
#define CAN3_IR12_RTR_BIT 31

#define CAN3_CR12 (*(volatile unsigned long *)0xFFFB0410)
#define CAN3_CR12_OFFSET 0x410
#define CAN3_CR12_DLC_MASK 0xFU
#define CAN3_CR12_DLC_BIT 0
#define CAN3_CR12_IDE_MASK 0x10U
#define CAN3_CR12_IDE 0x10U
#define CAN3_CR12_IDE_BIT 4
#define CAN3_CR12_RPLYV_MASK 0x20U
#define CAN3_CR12_RPLYV 0x20U
#define CAN3_CR12_RPLYV_BIT 5
#define CAN3_CR12_PCB_MASK 0x40U
#define CAN3_CR12_PCB 0x40U
#define CAN3_CR12_PCB_BIT 6
#define CAN3_CR12_CHANEN_MASK 0x80U
#define CAN3_CR12_CHANEN 0x80U
#define CAN3_CR12_CHANEN_BIT 7
#define CAN3_CR12_OVERWRITE_MASK 0x100U
#define CAN3_CR12_OVERWRITE 0x100U
#define CAN3_CR12_OVERWRITE_BIT 8

#define CAN3_CR12 (*(volatile unsigned long *)0xFFFB0414)
#define CAN3_CR12_OFFSET 0x414
#define CAN3_CR12_STAMP_MASK 0x0U
#define CAN3_CR12_STAMP_BIT 0

#define CAN3_CSR12 (*(volatile unsigned long *)0xFFFB0418)
#define CAN3_CSR12_OFFSET 0x418
#define CAN3_CSR12_ACK_MASK 0x1U
#define CAN3_CSR12_ACK 0x1U
#define CAN3_CSR12_ACK_BIT 0
#define CAN3_CSR12_FRAME_MASK 0x2U
#define CAN3_CSR12_FRAME 0x2U
#define CAN3_CSR12_FRAME_BIT 1
#define CAN3_CSR12_CRC_MASK 0x4U
#define CAN3_CSR12_CRC 0x4U
#define CAN3_CSR12_CRC_BIT 2
#define CAN3_CSR12_STUFF_MASK 0x8U
#define CAN3_CSR12_STUFF 0x8U
#define CAN3_CSR12_STUFF_BIT 3
#define CAN3_CSR12_BUS_MASK 0x10U
#define CAN3_CSR12_BUS 0x10U
#define CAN3_CSR12_BUS_BIT 4
#define CAN3_CSR12_RXOK_MASK 0x20U
#define CAN3_CSR12_RXOK 0x20U
#define CAN3_CSR12_RXOK_BIT 5
#define CAN3_CSR12_TXOK_MASK 0x40U
#define CAN3_CSR12_TXOK 0x40U
#define CAN3_CSR12_TXOK_BIT 6
#define CAN3_CSR12_RFRAME_MASK 0x80U
#define CAN3_CSR12_RFRAME 0x80U
#define CAN3_CSR12_RFRAME_BIT 7
#define CAN3_CSR12_DLCW_MASK 0x200U
#define CAN3_CSR12_DLCW 0x200U
#define CAN3_CSR12_DLCW_BIT 9
#define CAN3_CSR12_FILLED_MASK 0x400U
#define CAN3_CSR12_FILLED 0x400U
#define CAN3_CSR12_FILLED_BIT 10
#define CAN3_CSR12_OVRUN_MASK 0x800U
#define CAN3_CSR12_OVRUN 0x800U
#define CAN3_CSR12_OVRUN_BIT 11

#define CAN3_SR12 (*(volatile unsigned long *)0xFFFB041C)
#define CAN3_SR12_OFFSET 0x41C
#define CAN3_SR12_ACK_MASK 0x1U
#define CAN3_SR12_ACK 0x1U
#define CAN3_SR12_ACK_BIT 0
#define CAN3_SR12_FRAME_MASK 0x2U
#define CAN3_SR12_FRAME 0x2U
#define CAN3_SR12_FRAME_BIT 1
#define CAN3_SR12_CRC_MASK 0x4U
#define CAN3_SR12_CRC 0x4U
#define CAN3_SR12_CRC_BIT 2
#define CAN3_SR12_STUFF_MASK 0x8U
#define CAN3_SR12_STUFF 0x8U
#define CAN3_SR12_STUFF_BIT 3
#define CAN3_SR12_BUS_MASK 0x10U
#define CAN3_SR12_BUS 0x10U
#define CAN3_SR12_BUS_BIT 4
#define CAN3_SR12_RXOK_MASK 0x20U
#define CAN3_SR12_RXOK 0x20U
#define CAN3_SR12_RXOK_BIT 5
#define CAN3_SR12_TXOK_MASK 0x40U
#define CAN3_SR12_TXOK 0x40U
#define CAN3_SR12_TXOK_BIT 6
#define CAN3_SR12_RFRAME_MASK 0x80U
#define CAN3_SR12_RFRAME 0x80U
#define CAN3_SR12_RFRAME_BIT 7
#define CAN3_SR12_DLCW_MASK 0x200U
#define CAN3_SR12_DLCW 0x200U
#define CAN3_SR12_DLCW_BIT 9
#define CAN3_SR12_FILLED_MASK 0x400U
#define CAN3_SR12_FILLED 0x400U
#define CAN3_SR12_FILLED_BIT 10
#define CAN3_SR12_OVRUN_MASK 0x800U
#define CAN3_SR12_OVRUN 0x800U
#define CAN3_SR12_OVRUN_BIT 11

#define CAN3_IER12 (*(volatile unsigned long *)0xFFFB0420)
#define CAN3_IER12_OFFSET 0x420
#define CAN3_IER12_ACK_MASK 0x1U
#define CAN3_IER12_ACK 0x1U
#define CAN3_IER12_ACK_BIT 0
#define CAN3_IER12_FRAME_MASK 0x2U
#define CAN3_IER12_FRAME 0x2U
#define CAN3_IER12_FRAME_BIT 1
#define CAN3_IER12_CRC_MASK 0x4U
#define CAN3_IER12_CRC 0x4U
#define CAN3_IER12_CRC_BIT 2
#define CAN3_IER12_STUFF_MASK 0x8U
#define CAN3_IER12_STUFF 0x8U
#define CAN3_IER12_STUFF_BIT 3
#define CAN3_IER12_BUS_MASK 0x10U
#define CAN3_IER12_BUS 0x10U
#define CAN3_IER12_BUS_BIT 4
#define CAN3_IER12_RXOK_MASK 0x20U
#define CAN3_IER12_RXOK 0x20U
#define CAN3_IER12_RXOK_BIT 5
#define CAN3_IER12_TXOK_MASK 0x40U
#define CAN3_IER12_TXOK 0x40U
#define CAN3_IER12_TXOK_BIT 6
#define CAN3_IER12_RFRAME_MASK 0x80U
#define CAN3_IER12_RFRAME 0x80U
#define CAN3_IER12_RFRAME_BIT 7

#define CAN3_IDR12 (*(volatile unsigned long *)0xFFFB0424)
#define CAN3_IDR12_OFFSET 0x424
#define CAN3_IDR12_ACK_MASK 0x1U
#define CAN3_IDR12_ACK 0x1U
#define CAN3_IDR12_ACK_BIT 0
#define CAN3_IDR12_FRAME_MASK 0x2U
#define CAN3_IDR12_FRAME 0x2U
#define CAN3_IDR12_FRAME_BIT 1
#define CAN3_IDR12_CRC_MASK 0x4U
#define CAN3_IDR12_CRC 0x4U
#define CAN3_IDR12_CRC_BIT 2
#define CAN3_IDR12_STUFF_MASK 0x8U
#define CAN3_IDR12_STUFF 0x8U
#define CAN3_IDR12_STUFF_BIT 3
#define CAN3_IDR12_BUS_MASK 0x10U
#define CAN3_IDR12_BUS 0x10U
#define CAN3_IDR12_BUS_BIT 4
#define CAN3_IDR12_RXOK_MASK 0x20U
#define CAN3_IDR12_RXOK 0x20U
#define CAN3_IDR12_RXOK_BIT 5
#define CAN3_IDR12_TXOK_MASK 0x40U
#define CAN3_IDR12_TXOK 0x40U
#define CAN3_IDR12_TXOK_BIT 6
#define CAN3_IDR12_RFRAME_MASK 0x80U
#define CAN3_IDR12_RFRAME 0x80U
#define CAN3_IDR12_RFRAME_BIT 7

#define CAN3_IMR12 (*(volatile unsigned long *)0xFFFB0428)
#define CAN3_IMR12_OFFSET 0x428
#define CAN3_IMR12_ACK_MASK 0x1U
#define CAN3_IMR12_ACK 0x1U
#define CAN3_IMR12_ACK_BIT 0
#define CAN3_IMR12_FRAME_MASK 0x2U
#define CAN3_IMR12_FRAME 0x2U
#define CAN3_IMR12_FRAME_BIT 1
#define CAN3_IMR12_CRC_MASK 0x4U
#define CAN3_IMR12_CRC 0x4U
#define CAN3_IMR12_CRC_BIT 2
#define CAN3_IMR12_STUFF_MASK 0x8U
#define CAN3_IMR12_STUFF 0x8U
#define CAN3_IMR12_STUFF_BIT 3
#define CAN3_IMR12_BUS_MASK 0x10U
#define CAN3_IMR12_BUS 0x10U
#define CAN3_IMR12_BUS_BIT 4
#define CAN3_IMR12_RXOK_MASK 0x20U
#define CAN3_IMR12_RXOK 0x20U
#define CAN3_IMR12_RXOK_BIT 5
#define CAN3_IMR12_TXOK_MASK 0x40U
#define CAN3_IMR12_TXOK 0x40U
#define CAN3_IMR12_TXOK_BIT 6
#define CAN3_IMR12_RFRAME_MASK 0x80U
#define CAN3_IMR12_RFRAME 0x80U
#define CAN3_IMR12_RFRAME_BIT 7

#define CAN3_DRA13 (*(volatile unsigned long *)0xFFFB0440)
#define CAN3_DRA13_OFFSET 0x440
#define CAN3_DRA13_DATA0_MASK 0xFFU
#define CAN3_DRA13_DATA0_BIT 0
#define CAN3_DRA13_DATA1_MASK 0xFF00U
#define CAN3_DRA13_DATA1_BIT 8
#define CAN3_DRA13_DATA2_MASK 0xFF0000U
#define CAN3_DRA13_DATA2_BIT 16
#define CAN3_DRA13_DATA3_MASK 0xFF000000U
#define CAN3_DRA13_DATA3_BIT 24

#define CAN3_DRB13 (*(volatile unsigned long *)0xFFFB0444)
#define CAN3_DRB13_OFFSET 0x444
#define CAN3_DRB13_DATA4_MASK 0xFFU
#define CAN3_DRB13_DATA4_BIT 0
#define CAN3_DRB13_DATA5_MASK 0xFF00U
#define CAN3_DRB13_DATA5_BIT 8
#define CAN3_DRB13_DATA6_MASK 0xFF0000U
#define CAN3_DRB13_DATA6_BIT 16
#define CAN3_DRB13_DATA7_MASK 0xFF000000U
#define CAN3_DRB13_DATA7_BIT 24

#define CAN3_MSK13 (*(volatile unsigned long *)0xFFFB0448)
#define CAN3_MSK13_OFFSET 0x448
#define CAN3_MSK13_MASK_MASK 0x1FFFFFFFU
#define CAN3_MSK13_MASK_BIT 0
#define CAN3_MSK13_MRB_MASK 0x60000000U
#define CAN3_MSK13_MRB_BIT 29
#define CAN3_MSK13_MRTR_MASK 0x80000000U
#define CAN3_MSK13_MRTR 0x80000000U
#define CAN3_MSK13_MRTR_BIT 31

#define CAN3_IR13 (*(volatile unsigned long *)0xFFFB044C)
#define CAN3_IR13_OFFSET 0x44C
#define CAN3_IR13_ID_MASK 0x1FFFFFFFU
#define CAN3_IR13_ID_BIT 0
#define CAN3_IR13_RB_MASK 0x60000000U
#define CAN3_IR13_RB_BIT 29
#define CAN3_IR13_RTR_MASK 0x80000000U
#define CAN3_IR13_RTR 0x80000000U
#define CAN3_IR13_RTR_BIT 31

#define CAN3_CR13 (*(volatile unsigned long *)0xFFFB0450)
#define CAN3_CR13_OFFSET 0x450
#define CAN3_CR13_DLC_MASK 0xFU
#define CAN3_CR13_DLC_BIT 0
#define CAN3_CR13_IDE_MASK 0x10U
#define CAN3_CR13_IDE 0x10U
#define CAN3_CR13_IDE_BIT 4
#define CAN3_CR13_RPLYV_MASK 0x20U
#define CAN3_CR13_RPLYV 0x20U
#define CAN3_CR13_RPLYV_BIT 5
#define CAN3_CR13_PCB_MASK 0x40U
#define CAN3_CR13_PCB 0x40U
#define CAN3_CR13_PCB_BIT 6
#define CAN3_CR13_CHANEN_MASK 0x80U
#define CAN3_CR13_CHANEN 0x80U
#define CAN3_CR13_CHANEN_BIT 7
#define CAN3_CR13_OVERWRITE_MASK 0x100U
#define CAN3_CR13_OVERWRITE 0x100U
#define CAN3_CR13_OVERWRITE_BIT 8

#define CAN3_CR13 (*(volatile unsigned long *)0xFFFB0454)
#define CAN3_CR13_OFFSET 0x454
#define CAN3_CR13_STAMP_MASK 0x0U
#define CAN3_CR13_STAMP_BIT 0

#define CAN3_CSR13 (*(volatile unsigned long *)0xFFFB0458)
#define CAN3_CSR13_OFFSET 0x458
#define CAN3_CSR13_ACK_MASK 0x1U
#define CAN3_CSR13_ACK 0x1U
#define CAN3_CSR13_ACK_BIT 0
#define CAN3_CSR13_FRAME_MASK 0x2U
#define CAN3_CSR13_FRAME 0x2U
#define CAN3_CSR13_FRAME_BIT 1
#define CAN3_CSR13_CRC_MASK 0x4U
#define CAN3_CSR13_CRC 0x4U
#define CAN3_CSR13_CRC_BIT 2
#define CAN3_CSR13_STUFF_MASK 0x8U
#define CAN3_CSR13_STUFF 0x8U
#define CAN3_CSR13_STUFF_BIT 3
#define CAN3_CSR13_BUS_MASK 0x10U
#define CAN3_CSR13_BUS 0x10U
#define CAN3_CSR13_BUS_BIT 4
#define CAN3_CSR13_RXOK_MASK 0x20U
#define CAN3_CSR13_RXOK 0x20U
#define CAN3_CSR13_RXOK_BIT 5
#define CAN3_CSR13_TXOK_MASK 0x40U
#define CAN3_CSR13_TXOK 0x40U
#define CAN3_CSR13_TXOK_BIT 6
#define CAN3_CSR13_RFRAME_MASK 0x80U
#define CAN3_CSR13_RFRAME 0x80U
#define CAN3_CSR13_RFRAME_BIT 7
#define CAN3_CSR13_DLCW_MASK 0x200U
#define CAN3_CSR13_DLCW 0x200U
#define CAN3_CSR13_DLCW_BIT 9
#define CAN3_CSR13_FILLED_MASK 0x400U
#define CAN3_CSR13_FILLED 0x400U
#define CAN3_CSR13_FILLED_BIT 10
#define CAN3_CSR13_OVRUN_MASK 0x800U
#define CAN3_CSR13_OVRUN 0x800U
#define CAN3_CSR13_OVRUN_BIT 11

#define CAN3_SR13 (*(volatile unsigned long *)0xFFFB045C)
#define CAN3_SR13_OFFSET 0x45C
#define CAN3_SR13_ACK_MASK 0x1U
#define CAN3_SR13_ACK 0x1U
#define CAN3_SR13_ACK_BIT 0
#define CAN3_SR13_FRAME_MASK 0x2U
#define CAN3_SR13_FRAME 0x2U
#define CAN3_SR13_FRAME_BIT 1
#define CAN3_SR13_CRC_MASK 0x4U
#define CAN3_SR13_CRC 0x4U
#define CAN3_SR13_CRC_BIT 2
#define CAN3_SR13_STUFF_MASK 0x8U
#define CAN3_SR13_STUFF 0x8U
#define CAN3_SR13_STUFF_BIT 3
#define CAN3_SR13_BUS_MASK 0x10U
#define CAN3_SR13_BUS 0x10U
#define CAN3_SR13_BUS_BIT 4
#define CAN3_SR13_RXOK_MASK 0x20U
#define CAN3_SR13_RXOK 0x20U
#define CAN3_SR13_RXOK_BIT 5
#define CAN3_SR13_TXOK_MASK 0x40U
#define CAN3_SR13_TXOK 0x40U
#define CAN3_SR13_TXOK_BIT 6
#define CAN3_SR13_RFRAME_MASK 0x80U
#define CAN3_SR13_RFRAME 0x80U
#define CAN3_SR13_RFRAME_BIT 7
#define CAN3_SR13_DLCW_MASK 0x200U
#define CAN3_SR13_DLCW 0x200U
#define CAN3_SR13_DLCW_BIT 9
#define CAN3_SR13_FILLED_MASK 0x400U
#define CAN3_SR13_FILLED 0x400U
#define CAN3_SR13_FILLED_BIT 10
#define CAN3_SR13_OVRUN_MASK 0x800U
#define CAN3_SR13_OVRUN 0x800U
#define CAN3_SR13_OVRUN_BIT 11

#define CAN3_IER13 (*(volatile unsigned long *)0xFFFB0460)
#define CAN3_IER13_OFFSET 0x460
#define CAN3_IER13_ACK_MASK 0x1U
#define CAN3_IER13_ACK 0x1U
#define CAN3_IER13_ACK_BIT 0
#define CAN3_IER13_FRAME_MASK 0x2U
#define CAN3_IER13_FRAME 0x2U
#define CAN3_IER13_FRAME_BIT 1
#define CAN3_IER13_CRC_MASK 0x4U
#define CAN3_IER13_CRC 0x4U
#define CAN3_IER13_CRC_BIT 2
#define CAN3_IER13_STUFF_MASK 0x8U
#define CAN3_IER13_STUFF 0x8U
#define CAN3_IER13_STUFF_BIT 3
#define CAN3_IER13_BUS_MASK 0x10U
#define CAN3_IER13_BUS 0x10U
#define CAN3_IER13_BUS_BIT 4
#define CAN3_IER13_RXOK_MASK 0x20U
#define CAN3_IER13_RXOK 0x20U
#define CAN3_IER13_RXOK_BIT 5
#define CAN3_IER13_TXOK_MASK 0x40U
#define CAN3_IER13_TXOK 0x40U
#define CAN3_IER13_TXOK_BIT 6
#define CAN3_IER13_RFRAME_MASK 0x80U
#define CAN3_IER13_RFRAME 0x80U
#define CAN3_IER13_RFRAME_BIT 7

#define CAN3_IDR13 (*(volatile unsigned long *)0xFFFB0464)
#define CAN3_IDR13_OFFSET 0x464
#define CAN3_IDR13_ACK_MASK 0x1U
#define CAN3_IDR13_ACK 0x1U
#define CAN3_IDR13_ACK_BIT 0
#define CAN3_IDR13_FRAME_MASK 0x2U
#define CAN3_IDR13_FRAME 0x2U
#define CAN3_IDR13_FRAME_BIT 1
#define CAN3_IDR13_CRC_MASK 0x4U
#define CAN3_IDR13_CRC 0x4U
#define CAN3_IDR13_CRC_BIT 2
#define CAN3_IDR13_STUFF_MASK 0x8U
#define CAN3_IDR13_STUFF 0x8U
#define CAN3_IDR13_STUFF_BIT 3
#define CAN3_IDR13_BUS_MASK 0x10U
#define CAN3_IDR13_BUS 0x10U
#define CAN3_IDR13_BUS_BIT 4
#define CAN3_IDR13_RXOK_MASK 0x20U
#define CAN3_IDR13_RXOK 0x20U
#define CAN3_IDR13_RXOK_BIT 5
#define CAN3_IDR13_TXOK_MASK 0x40U
#define CAN3_IDR13_TXOK 0x40U
#define CAN3_IDR13_TXOK_BIT 6
#define CAN3_IDR13_RFRAME_MASK 0x80U
#define CAN3_IDR13_RFRAME 0x80U
#define CAN3_IDR13_RFRAME_BIT 7

#define CAN3_IMR13 (*(volatile unsigned long *)0xFFFB0468)
#define CAN3_IMR13_OFFSET 0x468
#define CAN3_IMR13_ACK_MASK 0x1U
#define CAN3_IMR13_ACK 0x1U
#define CAN3_IMR13_ACK_BIT 0
#define CAN3_IMR13_FRAME_MASK 0x2U
#define CAN3_IMR13_FRAME 0x2U
#define CAN3_IMR13_FRAME_BIT 1
#define CAN3_IMR13_CRC_MASK 0x4U
#define CAN3_IMR13_CRC 0x4U
#define CAN3_IMR13_CRC_BIT 2
#define CAN3_IMR13_STUFF_MASK 0x8U
#define CAN3_IMR13_STUFF 0x8U
#define CAN3_IMR13_STUFF_BIT 3
#define CAN3_IMR13_BUS_MASK 0x10U
#define CAN3_IMR13_BUS 0x10U
#define CAN3_IMR13_BUS_BIT 4
#define CAN3_IMR13_RXOK_MASK 0x20U
#define CAN3_IMR13_RXOK 0x20U
#define CAN3_IMR13_RXOK_BIT 5
#define CAN3_IMR13_TXOK_MASK 0x40U
#define CAN3_IMR13_TXOK 0x40U
#define CAN3_IMR13_TXOK_BIT 6
#define CAN3_IMR13_RFRAME_MASK 0x80U
#define CAN3_IMR13_RFRAME 0x80U
#define CAN3_IMR13_RFRAME_BIT 7

#define CAN3_DRA14 (*(volatile unsigned long *)0xFFFB0480)
#define CAN3_DRA14_OFFSET 0x480
#define CAN3_DRA14_DATA0_MASK 0xFFU
#define CAN3_DRA14_DATA0_BIT 0
#define CAN3_DRA14_DATA1_MASK 0xFF00U
#define CAN3_DRA14_DATA1_BIT 8
#define CAN3_DRA14_DATA2_MASK 0xFF0000U
#define CAN3_DRA14_DATA2_BIT 16
#define CAN3_DRA14_DATA3_MASK 0xFF000000U
#define CAN3_DRA14_DATA3_BIT 24

#define CAN3_DRB14 (*(volatile unsigned long *)0xFFFB0484)
#define CAN3_DRB14_OFFSET 0x484
#define CAN3_DRB14_DATA4_MASK 0xFFU
#define CAN3_DRB14_DATA4_BIT 0
#define CAN3_DRB14_DATA5_MASK 0xFF00U
#define CAN3_DRB14_DATA5_BIT 8
#define CAN3_DRB14_DATA6_MASK 0xFF0000U
#define CAN3_DRB14_DATA6_BIT 16
#define CAN3_DRB14_DATA7_MASK 0xFF000000U
#define CAN3_DRB14_DATA7_BIT 24

#define CAN3_MSK14 (*(volatile unsigned long *)0xFFFB0488)
#define CAN3_MSK14_OFFSET 0x488
#define CAN3_MSK14_MASK_MASK 0x1FFFFFFFU
#define CAN3_MSK14_MASK_BIT 0
#define CAN3_MSK14_MRB_MASK 0x60000000U
#define CAN3_MSK14_MRB_BIT 29
#define CAN3_MSK14_MRTR_MASK 0x80000000U
#define CAN3_MSK14_MRTR 0x80000000U
#define CAN3_MSK14_MRTR_BIT 31

#define CAN3_IR14 (*(volatile unsigned long *)0xFFFB048C)
#define CAN3_IR14_OFFSET 0x48C
#define CAN3_IR14_ID_MASK 0x1FFFFFFFU
#define CAN3_IR14_ID_BIT 0
#define CAN3_IR14_RB_MASK 0x60000000U
#define CAN3_IR14_RB_BIT 29
#define CAN3_IR14_RTR_MASK 0x80000000U
#define CAN3_IR14_RTR 0x80000000U
#define CAN3_IR14_RTR_BIT 31

#define CAN3_CR14 (*(volatile unsigned long *)0xFFFB0490)
#define CAN3_CR14_OFFSET 0x490
#define CAN3_CR14_DLC_MASK 0xFU
#define CAN3_CR14_DLC_BIT 0
#define CAN3_CR14_IDE_MASK 0x10U
#define CAN3_CR14_IDE 0x10U
#define CAN3_CR14_IDE_BIT 4
#define CAN3_CR14_RPLYV_MASK 0x20U
#define CAN3_CR14_RPLYV 0x20U
#define CAN3_CR14_RPLYV_BIT 5
#define CAN3_CR14_PCB_MASK 0x40U
#define CAN3_CR14_PCB 0x40U
#define CAN3_CR14_PCB_BIT 6
#define CAN3_CR14_CHANEN_MASK 0x80U
#define CAN3_CR14_CHANEN 0x80U
#define CAN3_CR14_CHANEN_BIT 7
#define CAN3_CR14_OVERWRITE_MASK 0x100U
#define CAN3_CR14_OVERWRITE 0x100U
#define CAN3_CR14_OVERWRITE_BIT 8

#define CAN3_CR14 (*(volatile unsigned long *)0xFFFB0494)
#define CAN3_CR14_OFFSET 0x494
#define CAN3_CR14_STAMP_MASK 0x0U
#define CAN3_CR14_STAMP_BIT 0

#define CAN3_CSR14 (*(volatile unsigned long *)0xFFFB0498)
#define CAN3_CSR14_OFFSET 0x498
#define CAN3_CSR14_ACK_MASK 0x1U
#define CAN3_CSR14_ACK 0x1U
#define CAN3_CSR14_ACK_BIT 0
#define CAN3_CSR14_FRAME_MASK 0x2U
#define CAN3_CSR14_FRAME 0x2U
#define CAN3_CSR14_FRAME_BIT 1
#define CAN3_CSR14_CRC_MASK 0x4U
#define CAN3_CSR14_CRC 0x4U
#define CAN3_CSR14_CRC_BIT 2
#define CAN3_CSR14_STUFF_MASK 0x8U
#define CAN3_CSR14_STUFF 0x8U
#define CAN3_CSR14_STUFF_BIT 3
#define CAN3_CSR14_BUS_MASK 0x10U
#define CAN3_CSR14_BUS 0x10U
#define CAN3_CSR14_BUS_BIT 4
#define CAN3_CSR14_RXOK_MASK 0x20U
#define CAN3_CSR14_RXOK 0x20U
#define CAN3_CSR14_RXOK_BIT 5
#define CAN3_CSR14_TXOK_MASK 0x40U
#define CAN3_CSR14_TXOK 0x40U
#define CAN3_CSR14_TXOK_BIT 6
#define CAN3_CSR14_RFRAME_MASK 0x80U
#define CAN3_CSR14_RFRAME 0x80U
#define CAN3_CSR14_RFRAME_BIT 7
#define CAN3_CSR14_DLCW_MASK 0x200U
#define CAN3_CSR14_DLCW 0x200U
#define CAN3_CSR14_DLCW_BIT 9
#define CAN3_CSR14_FILLED_MASK 0x400U
#define CAN3_CSR14_FILLED 0x400U
#define CAN3_CSR14_FILLED_BIT 10
#define CAN3_CSR14_OVRUN_MASK 0x800U
#define CAN3_CSR14_OVRUN 0x800U
#define CAN3_CSR14_OVRUN_BIT 11

#define CAN3_SR14 (*(volatile unsigned long *)0xFFFB049C)
#define CAN3_SR14_OFFSET 0x49C
#define CAN3_SR14_ACK_MASK 0x1U
#define CAN3_SR14_ACK 0x1U
#define CAN3_SR14_ACK_BIT 0
#define CAN3_SR14_FRAME_MASK 0x2U
#define CAN3_SR14_FRAME 0x2U
#define CAN3_SR14_FRAME_BIT 1
#define CAN3_SR14_CRC_MASK 0x4U
#define CAN3_SR14_CRC 0x4U
#define CAN3_SR14_CRC_BIT 2
#define CAN3_SR14_STUFF_MASK 0x8U
#define CAN3_SR14_STUFF 0x8U
#define CAN3_SR14_STUFF_BIT 3
#define CAN3_SR14_BUS_MASK 0x10U
#define CAN3_SR14_BUS 0x10U
#define CAN3_SR14_BUS_BIT 4
#define CAN3_SR14_RXOK_MASK 0x20U
#define CAN3_SR14_RXOK 0x20U
#define CAN3_SR14_RXOK_BIT 5
#define CAN3_SR14_TXOK_MASK 0x40U
#define CAN3_SR14_TXOK 0x40U
#define CAN3_SR14_TXOK_BIT 6
#define CAN3_SR14_RFRAME_MASK 0x80U
#define CAN3_SR14_RFRAME 0x80U
#define CAN3_SR14_RFRAME_BIT 7
#define CAN3_SR14_DLCW_MASK 0x200U
#define CAN3_SR14_DLCW 0x200U
#define CAN3_SR14_DLCW_BIT 9
#define CAN3_SR14_FILLED_MASK 0x400U
#define CAN3_SR14_FILLED 0x400U
#define CAN3_SR14_FILLED_BIT 10
#define CAN3_SR14_OVRUN_MASK 0x800U
#define CAN3_SR14_OVRUN 0x800U
#define CAN3_SR14_OVRUN_BIT 11

#define CAN3_IER14 (*(volatile unsigned long *)0xFFFB04A0)
#define CAN3_IER14_OFFSET 0x4A0
#define CAN3_IER14_ACK_MASK 0x1U
#define CAN3_IER14_ACK 0x1U
#define CAN3_IER14_ACK_BIT 0
#define CAN3_IER14_FRAME_MASK 0x2U
#define CAN3_IER14_FRAME 0x2U
#define CAN3_IER14_FRAME_BIT 1
#define CAN3_IER14_CRC_MASK 0x4U
#define CAN3_IER14_CRC 0x4U
#define CAN3_IER14_CRC_BIT 2
#define CAN3_IER14_STUFF_MASK 0x8U
#define CAN3_IER14_STUFF 0x8U
#define CAN3_IER14_STUFF_BIT 3
#define CAN3_IER14_BUS_MASK 0x10U
#define CAN3_IER14_BUS 0x10U
#define CAN3_IER14_BUS_BIT 4
#define CAN3_IER14_RXOK_MASK 0x20U
#define CAN3_IER14_RXOK 0x20U
#define CAN3_IER14_RXOK_BIT 5
#define CAN3_IER14_TXOK_MASK 0x40U
#define CAN3_IER14_TXOK 0x40U
#define CAN3_IER14_TXOK_BIT 6
#define CAN3_IER14_RFRAME_MASK 0x80U
#define CAN3_IER14_RFRAME 0x80U
#define CAN3_IER14_RFRAME_BIT 7

#define CAN3_IDR14 (*(volatile unsigned long *)0xFFFB04A4)
#define CAN3_IDR14_OFFSET 0x4A4
#define CAN3_IDR14_ACK_MASK 0x1U
#define CAN3_IDR14_ACK 0x1U
#define CAN3_IDR14_ACK_BIT 0
#define CAN3_IDR14_FRAME_MASK 0x2U
#define CAN3_IDR14_FRAME 0x2U
#define CAN3_IDR14_FRAME_BIT 1
#define CAN3_IDR14_CRC_MASK 0x4U
#define CAN3_IDR14_CRC 0x4U
#define CAN3_IDR14_CRC_BIT 2
#define CAN3_IDR14_STUFF_MASK 0x8U
#define CAN3_IDR14_STUFF 0x8U
#define CAN3_IDR14_STUFF_BIT 3
#define CAN3_IDR14_BUS_MASK 0x10U
#define CAN3_IDR14_BUS 0x10U
#define CAN3_IDR14_BUS_BIT 4
#define CAN3_IDR14_RXOK_MASK 0x20U
#define CAN3_IDR14_RXOK 0x20U
#define CAN3_IDR14_RXOK_BIT 5
#define CAN3_IDR14_TXOK_MASK 0x40U
#define CAN3_IDR14_TXOK 0x40U
#define CAN3_IDR14_TXOK_BIT 6
#define CAN3_IDR14_RFRAME_MASK 0x80U
#define CAN3_IDR14_RFRAME 0x80U
#define CAN3_IDR14_RFRAME_BIT 7

#define CAN3_IMR14 (*(volatile unsigned long *)0xFFFB04A8)
#define CAN3_IMR14_OFFSET 0x4A8
#define CAN3_IMR14_ACK_MASK 0x1U
#define CAN3_IMR14_ACK 0x1U
#define CAN3_IMR14_ACK_BIT 0
#define CAN3_IMR14_FRAME_MASK 0x2U
#define CAN3_IMR14_FRAME 0x2U
#define CAN3_IMR14_FRAME_BIT 1
#define CAN3_IMR14_CRC_MASK 0x4U
#define CAN3_IMR14_CRC 0x4U
#define CAN3_IMR14_CRC_BIT 2
#define CAN3_IMR14_STUFF_MASK 0x8U
#define CAN3_IMR14_STUFF 0x8U
#define CAN3_IMR14_STUFF_BIT 3
#define CAN3_IMR14_BUS_MASK 0x10U
#define CAN3_IMR14_BUS 0x10U
#define CAN3_IMR14_BUS_BIT 4
#define CAN3_IMR14_RXOK_MASK 0x20U
#define CAN3_IMR14_RXOK 0x20U
#define CAN3_IMR14_RXOK_BIT 5
#define CAN3_IMR14_TXOK_MASK 0x40U
#define CAN3_IMR14_TXOK 0x40U
#define CAN3_IMR14_TXOK_BIT 6
#define CAN3_IMR14_RFRAME_MASK 0x80U
#define CAN3_IMR14_RFRAME 0x80U
#define CAN3_IMR14_RFRAME_BIT 7

#define CAN3_DRA15 (*(volatile unsigned long *)0xFFFB04C0)
#define CAN3_DRA15_OFFSET 0x4C0
#define CAN3_DRA15_DATA0_MASK 0xFFU
#define CAN3_DRA15_DATA0_BIT 0
#define CAN3_DRA15_DATA1_MASK 0xFF00U
#define CAN3_DRA15_DATA1_BIT 8
#define CAN3_DRA15_DATA2_MASK 0xFF0000U
#define CAN3_DRA15_DATA2_BIT 16
#define CAN3_DRA15_DATA3_MASK 0xFF000000U
#define CAN3_DRA15_DATA3_BIT 24

#define CAN3_DRB15 (*(volatile unsigned long *)0xFFFB04C4)
#define CAN3_DRB15_OFFSET 0x4C4
#define CAN3_DRB15_DATA4_MASK 0xFFU
#define CAN3_DRB15_DATA4_BIT 0
#define CAN3_DRB15_DATA5_MASK 0xFF00U
#define CAN3_DRB15_DATA5_BIT 8
#define CAN3_DRB15_DATA6_MASK 0xFF0000U
#define CAN3_DRB15_DATA6_BIT 16
#define CAN3_DRB15_DATA7_MASK 0xFF000000U
#define CAN3_DRB15_DATA7_BIT 24

#define CAN3_MSK15 (*(volatile unsigned long *)0xFFFB04C8)
#define CAN3_MSK15_OFFSET 0x4C8
#define CAN3_MSK15_MASK_MASK 0x1FFFFFFFU
#define CAN3_MSK15_MASK_BIT 0
#define CAN3_MSK15_MRB_MASK 0x60000000U
#define CAN3_MSK15_MRB_BIT 29
#define CAN3_MSK15_MRTR_MASK 0x80000000U
#define CAN3_MSK15_MRTR 0x80000000U
#define CAN3_MSK15_MRTR_BIT 31

#define CAN3_IR15 (*(volatile unsigned long *)0xFFFB04CC)
#define CAN3_IR15_OFFSET 0x4CC
#define CAN3_IR15_ID_MASK 0x1FFFFFFFU
#define CAN3_IR15_ID_BIT 0
#define CAN3_IR15_RB_MASK 0x60000000U
#define CAN3_IR15_RB_BIT 29
#define CAN3_IR15_RTR_MASK 0x80000000U
#define CAN3_IR15_RTR 0x80000000U
#define CAN3_IR15_RTR_BIT 31

#define CAN3_CR15 (*(volatile unsigned long *)0xFFFB04D0)
#define CAN3_CR15_OFFSET 0x4D0
#define CAN3_CR15_DLC_MASK 0xFU
#define CAN3_CR15_DLC_BIT 0
#define CAN3_CR15_IDE_MASK 0x10U
#define CAN3_CR15_IDE 0x10U
#define CAN3_CR15_IDE_BIT 4
#define CAN3_CR15_RPLYV_MASK 0x20U
#define CAN3_CR15_RPLYV 0x20U
#define CAN3_CR15_RPLYV_BIT 5
#define CAN3_CR15_PCB_MASK 0x40U
#define CAN3_CR15_PCB 0x40U
#define CAN3_CR15_PCB_BIT 6
#define CAN3_CR15_CHANEN_MASK 0x80U
#define CAN3_CR15_CHANEN 0x80U
#define CAN3_CR15_CHANEN_BIT 7
#define CAN3_CR15_OVERWRITE_MASK 0x100U
#define CAN3_CR15_OVERWRITE 0x100U
#define CAN3_CR15_OVERWRITE_BIT 8

#define CAN3_CR15 (*(volatile unsigned long *)0xFFFB04D4)
#define CAN3_CR15_OFFSET 0x4D4
#define CAN3_CR15_STAMP_MASK 0x0U
#define CAN3_CR15_STAMP_BIT 0

#define CAN3_CSR15 (*(volatile unsigned long *)0xFFFB04D8)
#define CAN3_CSR15_OFFSET 0x4D8
#define CAN3_CSR15_ACK_MASK 0x1U
#define CAN3_CSR15_ACK 0x1U
#define CAN3_CSR15_ACK_BIT 0
#define CAN3_CSR15_FRAME_MASK 0x2U
#define CAN3_CSR15_FRAME 0x2U
#define CAN3_CSR15_FRAME_BIT 1
#define CAN3_CSR15_CRC_MASK 0x4U
#define CAN3_CSR15_CRC 0x4U
#define CAN3_CSR15_CRC_BIT 2
#define CAN3_CSR15_STUFF_MASK 0x8U
#define CAN3_CSR15_STUFF 0x8U
#define CAN3_CSR15_STUFF_BIT 3
#define CAN3_CSR15_BUS_MASK 0x10U
#define CAN3_CSR15_BUS 0x10U
#define CAN3_CSR15_BUS_BIT 4
#define CAN3_CSR15_RXOK_MASK 0x20U
#define CAN3_CSR15_RXOK 0x20U
#define CAN3_CSR15_RXOK_BIT 5
#define CAN3_CSR15_TXOK_MASK 0x40U
#define CAN3_CSR15_TXOK 0x40U
#define CAN3_CSR15_TXOK_BIT 6
#define CAN3_CSR15_RFRAME_MASK 0x80U
#define CAN3_CSR15_RFRAME 0x80U
#define CAN3_CSR15_RFRAME_BIT 7
#define CAN3_CSR15_DLCW_MASK 0x200U
#define CAN3_CSR15_DLCW 0x200U
#define CAN3_CSR15_DLCW_BIT 9
#define CAN3_CSR15_FILLED_MASK 0x400U
#define CAN3_CSR15_FILLED 0x400U
#define CAN3_CSR15_FILLED_BIT 10
#define CAN3_CSR15_OVRUN_MASK 0x800U
#define CAN3_CSR15_OVRUN 0x800U
#define CAN3_CSR15_OVRUN_BIT 11

#define CAN3_SR15 (*(volatile unsigned long *)0xFFFB04DC)
#define CAN3_SR15_OFFSET 0x4DC
#define CAN3_SR15_ACK_MASK 0x1U
#define CAN3_SR15_ACK 0x1U
#define CAN3_SR15_ACK_BIT 0
#define CAN3_SR15_FRAME_MASK 0x2U
#define CAN3_SR15_FRAME 0x2U
#define CAN3_SR15_FRAME_BIT 1
#define CAN3_SR15_CRC_MASK 0x4U
#define CAN3_SR15_CRC 0x4U
#define CAN3_SR15_CRC_BIT 2
#define CAN3_SR15_STUFF_MASK 0x8U
#define CAN3_SR15_STUFF 0x8U
#define CAN3_SR15_STUFF_BIT 3
#define CAN3_SR15_BUS_MASK 0x10U
#define CAN3_SR15_BUS 0x10U
#define CAN3_SR15_BUS_BIT 4
#define CAN3_SR15_RXOK_MASK 0x20U
#define CAN3_SR15_RXOK 0x20U
#define CAN3_SR15_RXOK_BIT 5
#define CAN3_SR15_TXOK_MASK 0x40U
#define CAN3_SR15_TXOK 0x40U
#define CAN3_SR15_TXOK_BIT 6
#define CAN3_SR15_RFRAME_MASK 0x80U
#define CAN3_SR15_RFRAME 0x80U
#define CAN3_SR15_RFRAME_BIT 7
#define CAN3_SR15_DLCW_MASK 0x200U
#define CAN3_SR15_DLCW 0x200U
#define CAN3_SR15_DLCW_BIT 9
#define CAN3_SR15_FILLED_MASK 0x400U
#define CAN3_SR15_FILLED 0x400U
#define CAN3_SR15_FILLED_BIT 10
#define CAN3_SR15_OVRUN_MASK 0x800U
#define CAN3_SR15_OVRUN 0x800U
#define CAN3_SR15_OVRUN_BIT 11

#define CAN3_IER15 (*(volatile unsigned long *)0xFFFB04E0)
#define CAN3_IER15_OFFSET 0x4E0
#define CAN3_IER15_ACK_MASK 0x1U
#define CAN3_IER15_ACK 0x1U
#define CAN3_IER15_ACK_BIT 0
#define CAN3_IER15_FRAME_MASK 0x2U
#define CAN3_IER15_FRAME 0x2U
#define CAN3_IER15_FRAME_BIT 1
#define CAN3_IER15_CRC_MASK 0x4U
#define CAN3_IER15_CRC 0x4U
#define CAN3_IER15_CRC_BIT 2
#define CAN3_IER15_STUFF_MASK 0x8U
#define CAN3_IER15_STUFF 0x8U
#define CAN3_IER15_STUFF_BIT 3
#define CAN3_IER15_BUS_MASK 0x10U
#define CAN3_IER15_BUS 0x10U
#define CAN3_IER15_BUS_BIT 4
#define CAN3_IER15_RXOK_MASK 0x20U
#define CAN3_IER15_RXOK 0x20U
#define CAN3_IER15_RXOK_BIT 5
#define CAN3_IER15_TXOK_MASK 0x40U
#define CAN3_IER15_TXOK 0x40U
#define CAN3_IER15_TXOK_BIT 6
#define CAN3_IER15_RFRAME_MASK 0x80U
#define CAN3_IER15_RFRAME 0x80U
#define CAN3_IER15_RFRAME_BIT 7

#define CAN3_IDR15 (*(volatile unsigned long *)0xFFFB04E4)
#define CAN3_IDR15_OFFSET 0x4E4
#define CAN3_IDR15_ACK_MASK 0x1U
#define CAN3_IDR15_ACK 0x1U
#define CAN3_IDR15_ACK_BIT 0
#define CAN3_IDR15_FRAME_MASK 0x2U
#define CAN3_IDR15_FRAME 0x2U
#define CAN3_IDR15_FRAME_BIT 1
#define CAN3_IDR15_CRC_MASK 0x4U
#define CAN3_IDR15_CRC 0x4U
#define CAN3_IDR15_CRC_BIT 2
#define CAN3_IDR15_STUFF_MASK 0x8U
#define CAN3_IDR15_STUFF 0x8U
#define CAN3_IDR15_STUFF_BIT 3
#define CAN3_IDR15_BUS_MASK 0x10U
#define CAN3_IDR15_BUS 0x10U
#define CAN3_IDR15_BUS_BIT 4
#define CAN3_IDR15_RXOK_MASK 0x20U
#define CAN3_IDR15_RXOK 0x20U
#define CAN3_IDR15_RXOK_BIT 5
#define CAN3_IDR15_TXOK_MASK 0x40U
#define CAN3_IDR15_TXOK 0x40U
#define CAN3_IDR15_TXOK_BIT 6
#define CAN3_IDR15_RFRAME_MASK 0x80U
#define CAN3_IDR15_RFRAME 0x80U
#define CAN3_IDR15_RFRAME_BIT 7

#define CAN3_IMR15 (*(volatile unsigned long *)0xFFFB04E8)
#define CAN3_IMR15_OFFSET 0x4E8
#define CAN3_IMR15_ACK_MASK 0x1U
#define CAN3_IMR15_ACK 0x1U
#define CAN3_IMR15_ACK_BIT 0
#define CAN3_IMR15_FRAME_MASK 0x2U
#define CAN3_IMR15_FRAME 0x2U
#define CAN3_IMR15_FRAME_BIT 1
#define CAN3_IMR15_CRC_MASK 0x4U
#define CAN3_IMR15_CRC 0x4U
#define CAN3_IMR15_CRC_BIT 2
#define CAN3_IMR15_STUFF_MASK 0x8U
#define CAN3_IMR15_STUFF 0x8U
#define CAN3_IMR15_STUFF_BIT 3
#define CAN3_IMR15_BUS_MASK 0x10U
#define CAN3_IMR15_BUS 0x10U
#define CAN3_IMR15_BUS_BIT 4
#define CAN3_IMR15_RXOK_MASK 0x20U
#define CAN3_IMR15_RXOK 0x20U
#define CAN3_IMR15_RXOK_BIT 5
#define CAN3_IMR15_TXOK_MASK 0x40U
#define CAN3_IMR15_TXOK 0x40U
#define CAN3_IMR15_TXOK_BIT 6
#define CAN3_IMR15_RFRAME_MASK 0x80U
#define CAN3_IMR15_RFRAME 0x80U
#define CAN3_IMR15_RFRAME_BIT 7

#define SPI_BASE 0xFFFB4000

#define SPI_PER (*(volatile unsigned long *)0xFFFB4000)
#define SPI_PER_OFFSET 0x0
#define SPI_PER_SPCK_MASK 0x10000U
#define SPI_PER_SPCK 0x10000U
#define SPI_PER_SPCK_BIT 16
#define SPI_PER_MISO_MASK 0x20000U
#define SPI_PER_MISO 0x20000U
#define SPI_PER_MISO_BIT 17
#define SPI_PER_MOSI_MASK 0x40000U
#define SPI_PER_MOSI 0x40000U
#define SPI_PER_MOSI_BIT 18
#define SPI_PER_NPCS0_MASK 0x80000U
#define SPI_PER_NPCS0 0x80000U
#define SPI_PER_NPCS0_BIT 19
#define SPI_PER_NPCS1_MASK 0x100000U
#define SPI_PER_NPCS1 0x100000U
#define SPI_PER_NPCS1_BIT 20
#define SPI_PER_NPCS2_MASK 0x200000U
#define SPI_PER_NPCS2 0x200000U
#define SPI_PER_NPCS2_BIT 21
#define SPI_PER_NPCS3_MASK 0x400000U
#define SPI_PER_NPCS3 0x400000U
#define SPI_PER_NPCS3_BIT 22

#define SPI_PDR (*(volatile unsigned long *)0xFFFB4004)
#define SPI_PDR_OFFSET 0x4
#define SPI_PDR_SPCK_MASK 0x10000U
#define SPI_PDR_SPCK 0x10000U
#define SPI_PDR_SPCK_BIT 16
#define SPI_PDR_MISO_MASK 0x20000U
#define SPI_PDR_MISO 0x20000U
#define SPI_PDR_MISO_BIT 17
#define SPI_PDR_MOSI_MASK 0x40000U
#define SPI_PDR_MOSI 0x40000U
#define SPI_PDR_MOSI_BIT 18
#define SPI_PDR_NPCS0_MASK 0x80000U
#define SPI_PDR_NPCS0 0x80000U
#define SPI_PDR_NPCS0_BIT 19
#define SPI_PDR_NPCS1_MASK 0x100000U
#define SPI_PDR_NPCS1 0x100000U
#define SPI_PDR_NPCS1_BIT 20
#define SPI_PDR_NPCS2_MASK 0x200000U
#define SPI_PDR_NPCS2 0x200000U
#define SPI_PDR_NPCS2_BIT 21
#define SPI_PDR_NPCS3_MASK 0x400000U
#define SPI_PDR_NPCS3 0x400000U
#define SPI_PDR_NPCS3_BIT 22

#define SPI_PSR (*(volatile unsigned long *)0xFFFB4008)
#define SPI_PSR_OFFSET 0x8
#define SPI_PSR_SPCK_MASK 0x10000U
#define SPI_PSR_SPCK 0x10000U
#define SPI_PSR_SPCK_BIT 16
#define SPI_PSR_MISO_MASK 0x20000U
#define SPI_PSR_MISO 0x20000U
#define SPI_PSR_MISO_BIT 17
#define SPI_PSR_MOSI_MASK 0x40000U
#define SPI_PSR_MOSI 0x40000U
#define SPI_PSR_MOSI_BIT 18
#define SPI_PSR_NPCS0_MASK 0x80000U
#define SPI_PSR_NPCS0 0x80000U
#define SPI_PSR_NPCS0_BIT 19
#define SPI_PSR_NPCS1_MASK 0x100000U
#define SPI_PSR_NPCS1 0x100000U
#define SPI_PSR_NPCS1_BIT 20
#define SPI_PSR_NPCS2_MASK 0x200000U
#define SPI_PSR_NPCS2 0x200000U
#define SPI_PSR_NPCS2_BIT 21
#define SPI_PSR_NPCS3_MASK 0x400000U
#define SPI_PSR_NPCS3 0x400000U
#define SPI_PSR_NPCS3_BIT 22

#define SPI_OER (*(volatile unsigned long *)0xFFFB4010)
#define SPI_OER_OFFSET 0x10
#define SPI_OER_SPCK_MASK 0x10000U
#define SPI_OER_SPCK 0x10000U
#define SPI_OER_SPCK_BIT 16
#define SPI_OER_MISO_MASK 0x20000U
#define SPI_OER_MISO 0x20000U
#define SPI_OER_MISO_BIT 17
#define SPI_OER_MOSI_MASK 0x40000U
#define SPI_OER_MOSI 0x40000U
#define SPI_OER_MOSI_BIT 18
#define SPI_OER_NPCS0_MASK 0x80000U
#define SPI_OER_NPCS0 0x80000U
#define SPI_OER_NPCS0_BIT 19
#define SPI_OER_NPCS1_MASK 0x100000U
#define SPI_OER_NPCS1 0x100000U
#define SPI_OER_NPCS1_BIT 20
#define SPI_OER_NPCS2_MASK 0x200000U
#define SPI_OER_NPCS2 0x200000U
#define SPI_OER_NPCS2_BIT 21
#define SPI_OER_NPCS3_MASK 0x400000U
#define SPI_OER_NPCS3 0x400000U
#define SPI_OER_NPCS3_BIT 22

#define SPI_ODR (*(volatile unsigned long *)0xFFFB4014)
#define SPI_ODR_OFFSET 0x14
#define SPI_ODR_SPCK_MASK 0x10000U
#define SPI_ODR_SPCK 0x10000U
#define SPI_ODR_SPCK_BIT 16
#define SPI_ODR_MISO_MASK 0x20000U
#define SPI_ODR_MISO 0x20000U
#define SPI_ODR_MISO_BIT 17
#define SPI_ODR_MOSI_MASK 0x40000U
#define SPI_ODR_MOSI 0x40000U
#define SPI_ODR_MOSI_BIT 18
#define SPI_ODR_NPCS0_MASK 0x80000U
#define SPI_ODR_NPCS0 0x80000U
#define SPI_ODR_NPCS0_BIT 19
#define SPI_ODR_NPCS1_MASK 0x100000U
#define SPI_ODR_NPCS1 0x100000U
#define SPI_ODR_NPCS1_BIT 20
#define SPI_ODR_NPCS2_MASK 0x200000U
#define SPI_ODR_NPCS2 0x200000U
#define SPI_ODR_NPCS2_BIT 21
#define SPI_ODR_NPCS3_MASK 0x400000U
#define SPI_ODR_NPCS3 0x400000U
#define SPI_ODR_NPCS3_BIT 22

#define SPI_OSR (*(volatile unsigned long *)0xFFFB4018)
#define SPI_OSR_OFFSET 0x18
#define SPI_OSR_SPCK_MASK 0x10000U
#define SPI_OSR_SPCK 0x10000U
#define SPI_OSR_SPCK_BIT 16
#define SPI_OSR_MISO_MASK 0x20000U
#define SPI_OSR_MISO 0x20000U
#define SPI_OSR_MISO_BIT 17
#define SPI_OSR_MOSI_MASK 0x40000U
#define SPI_OSR_MOSI 0x40000U
#define SPI_OSR_MOSI_BIT 18
#define SPI_OSR_NPCS0_MASK 0x80000U
#define SPI_OSR_NPCS0 0x80000U
#define SPI_OSR_NPCS0_BIT 19
#define SPI_OSR_NPCS1_MASK 0x100000U
#define SPI_OSR_NPCS1 0x100000U
#define SPI_OSR_NPCS1_BIT 20
#define SPI_OSR_NPCS2_MASK 0x200000U
#define SPI_OSR_NPCS2 0x200000U
#define SPI_OSR_NPCS2_BIT 21
#define SPI_OSR_NPCS3_MASK 0x400000U
#define SPI_OSR_NPCS3 0x400000U
#define SPI_OSR_NPCS3_BIT 22

#define SPI_SODR (*(volatile unsigned long *)0xFFFB4030)
#define SPI_SODR_OFFSET 0x30
#define SPI_SODR_SPCK_MASK 0x10000U
#define SPI_SODR_SPCK 0x10000U
#define SPI_SODR_SPCK_BIT 16
#define SPI_SODR_MISO_MASK 0x20000U
#define SPI_SODR_MISO 0x20000U
#define SPI_SODR_MISO_BIT 17
#define SPI_SODR_MOSI_MASK 0x40000U
#define SPI_SODR_MOSI 0x40000U
#define SPI_SODR_MOSI_BIT 18
#define SPI_SODR_NPCS0_MASK 0x80000U
#define SPI_SODR_NPCS0 0x80000U
#define SPI_SODR_NPCS0_BIT 19
#define SPI_SODR_NPCS1_MASK 0x100000U
#define SPI_SODR_NPCS1 0x100000U
#define SPI_SODR_NPCS1_BIT 20
#define SPI_SODR_NPCS2_MASK 0x200000U
#define SPI_SODR_NPCS2 0x200000U
#define SPI_SODR_NPCS2_BIT 21
#define SPI_SODR_NPCS3_MASK 0x400000U
#define SPI_SODR_NPCS3 0x400000U
#define SPI_SODR_NPCS3_BIT 22

#define SPI_CODR (*(volatile unsigned long *)0xFFFB4034)
#define SPI_CODR_OFFSET 0x34
#define SPI_CODR_SPCK_MASK 0x10000U
#define SPI_CODR_SPCK 0x10000U
#define SPI_CODR_SPCK_BIT 16
#define SPI_CODR_MISO_MASK 0x20000U
#define SPI_CODR_MISO 0x20000U
#define SPI_CODR_MISO_BIT 17
#define SPI_CODR_MOSI_MASK 0x40000U
#define SPI_CODR_MOSI 0x40000U
#define SPI_CODR_MOSI_BIT 18
#define SPI_CODR_NPCS0_MASK 0x80000U
#define SPI_CODR_NPCS0 0x80000U
#define SPI_CODR_NPCS0_BIT 19
#define SPI_CODR_NPCS1_MASK 0x100000U
#define SPI_CODR_NPCS1 0x100000U
#define SPI_CODR_NPCS1_BIT 20
#define SPI_CODR_NPCS2_MASK 0x200000U
#define SPI_CODR_NPCS2 0x200000U
#define SPI_CODR_NPCS2_BIT 21
#define SPI_CODR_NPCS3_MASK 0x400000U
#define SPI_CODR_NPCS3 0x400000U
#define SPI_CODR_NPCS3_BIT 22

#define SPI_ODSR (*(volatile unsigned long *)0xFFFB4038)
#define SPI_ODSR_OFFSET 0x38
#define SPI_ODSR_SPCK_MASK 0x10000U
#define SPI_ODSR_SPCK 0x10000U
#define SPI_ODSR_SPCK_BIT 16
#define SPI_ODSR_MISO_MASK 0x20000U
#define SPI_ODSR_MISO 0x20000U
#define SPI_ODSR_MISO_BIT 17
#define SPI_ODSR_MOSI_MASK 0x40000U
#define SPI_ODSR_MOSI 0x40000U
#define SPI_ODSR_MOSI_BIT 18
#define SPI_ODSR_NPCS0_MASK 0x80000U
#define SPI_ODSR_NPCS0 0x80000U
#define SPI_ODSR_NPCS0_BIT 19
#define SPI_ODSR_NPCS1_MASK 0x100000U
#define SPI_ODSR_NPCS1 0x100000U
#define SPI_ODSR_NPCS1_BIT 20
#define SPI_ODSR_NPCS2_MASK 0x200000U
#define SPI_ODSR_NPCS2 0x200000U
#define SPI_ODSR_NPCS2_BIT 21
#define SPI_ODSR_NPCS3_MASK 0x400000U
#define SPI_ODSR_NPCS3 0x400000U
#define SPI_ODSR_NPCS3_BIT 22

#define SPI_PDSR (*(volatile unsigned long *)0xFFFB403C)
#define SPI_PDSR_OFFSET 0x3C
#define SPI_PDSR_SPCK_MASK 0x10000U
#define SPI_PDSR_SPCK 0x10000U
#define SPI_PDSR_SPCK_BIT 16
#define SPI_PDSR_MISO_MASK 0x20000U
#define SPI_PDSR_MISO 0x20000U
#define SPI_PDSR_MISO_BIT 17
#define SPI_PDSR_MOSI_MASK 0x40000U
#define SPI_PDSR_MOSI 0x40000U
#define SPI_PDSR_MOSI_BIT 18
#define SPI_PDSR_NPCS0_MASK 0x80000U
#define SPI_PDSR_NPCS0 0x80000U
#define SPI_PDSR_NPCS0_BIT 19
#define SPI_PDSR_NPCS1_MASK 0x100000U
#define SPI_PDSR_NPCS1 0x100000U
#define SPI_PDSR_NPCS1_BIT 20
#define SPI_PDSR_NPCS2_MASK 0x200000U
#define SPI_PDSR_NPCS2 0x200000U
#define SPI_PDSR_NPCS2_BIT 21
#define SPI_PDSR_NPCS3_MASK 0x400000U
#define SPI_PDSR_NPCS3 0x400000U
#define SPI_PDSR_NPCS3_BIT 22

#define SPI_MDER (*(volatile unsigned long *)0xFFFB4040)
#define SPI_MDER_OFFSET 0x40
#define SPI_MDER_SPCK_MASK 0x10000U
#define SPI_MDER_SPCK 0x10000U
#define SPI_MDER_SPCK_BIT 16
#define SPI_MDER_MISO_MASK 0x20000U
#define SPI_MDER_MISO 0x20000U
#define SPI_MDER_MISO_BIT 17
#define SPI_MDER_MOSI_MASK 0x40000U
#define SPI_MDER_MOSI 0x40000U
#define SPI_MDER_MOSI_BIT 18
#define SPI_MDER_NPCS0_MASK 0x80000U
#define SPI_MDER_NPCS0 0x80000U
#define SPI_MDER_NPCS0_BIT 19
#define SPI_MDER_NPCS1_MASK 0x100000U
#define SPI_MDER_NPCS1 0x100000U
#define SPI_MDER_NPCS1_BIT 20
#define SPI_MDER_NPCS2_MASK 0x200000U
#define SPI_MDER_NPCS2 0x200000U
#define SPI_MDER_NPCS2_BIT 21
#define SPI_MDER_NPCS3_MASK 0x400000U
#define SPI_MDER_NPCS3 0x400000U
#define SPI_MDER_NPCS3_BIT 22

#define SPI_MDDR (*(volatile unsigned long *)0xFFFB4044)
#define SPI_MDDR_OFFSET 0x44
#define SPI_MDDR_SPCK_MASK 0x10000U
#define SPI_MDDR_SPCK 0x10000U
#define SPI_MDDR_SPCK_BIT 16
#define SPI_MDDR_MISO_MASK 0x20000U
#define SPI_MDDR_MISO 0x20000U
#define SPI_MDDR_MISO_BIT 17
#define SPI_MDDR_MOSI_MASK 0x40000U
#define SPI_MDDR_MOSI 0x40000U
#define SPI_MDDR_MOSI_BIT 18
#define SPI_MDDR_NPCS0_MASK 0x80000U
#define SPI_MDDR_NPCS0 0x80000U
#define SPI_MDDR_NPCS0_BIT 19
#define SPI_MDDR_NPCS1_MASK 0x100000U
#define SPI_MDDR_NPCS1 0x100000U
#define SPI_MDDR_NPCS1_BIT 20
#define SPI_MDDR_NPCS2_MASK 0x200000U
#define SPI_MDDR_NPCS2 0x200000U
#define SPI_MDDR_NPCS2_BIT 21
#define SPI_MDDR_NPCS3_MASK 0x400000U
#define SPI_MDDR_NPCS3 0x400000U
#define SPI_MDDR_NPCS3_BIT 22

#define SPI_MDSR (*(volatile unsigned long *)0xFFFB4048)
#define SPI_MDSR_OFFSET 0x48
#define SPI_MDSR_SPCK_MASK 0x10000U
#define SPI_MDSR_SPCK 0x10000U
#define SPI_MDSR_SPCK_BIT 16
#define SPI_MDSR_MISO_MASK 0x20000U
#define SPI_MDSR_MISO 0x20000U
#define SPI_MDSR_MISO_BIT 17
#define SPI_MDSR_MOSI_MASK 0x40000U
#define SPI_MDSR_MOSI 0x40000U
#define SPI_MDSR_MOSI_BIT 18
#define SPI_MDSR_NPCS0_MASK 0x80000U
#define SPI_MDSR_NPCS0 0x80000U
#define SPI_MDSR_NPCS0_BIT 19
#define SPI_MDSR_NPCS1_MASK 0x100000U
#define SPI_MDSR_NPCS1 0x100000U
#define SPI_MDSR_NPCS1_BIT 20
#define SPI_MDSR_NPCS2_MASK 0x200000U
#define SPI_MDSR_NPCS2 0x200000U
#define SPI_MDSR_NPCS2_BIT 21
#define SPI_MDSR_NPCS3_MASK 0x400000U
#define SPI_MDSR_NPCS3 0x400000U
#define SPI_MDSR_NPCS3_BIT 22

#define SPI_ECR (*(volatile unsigned long *)0xFFFB4050)
#define SPI_ECR_OFFSET 0x50
#define SPI_ECR_PIO_MASK 0x1U
#define SPI_ECR_PIO 0x1U
#define SPI_ECR_PIO_BIT 0
#define SPI_ECR_SPI_MASK 0x2U
#define SPI_ECR_SPI 0x2U
#define SPI_ECR_SPI_BIT 1

#define SPI_DCR (*(volatile unsigned long *)0xFFFB4054)
#define SPI_DCR_OFFSET 0x54
#define SPI_DCR_PIO_MASK 0x1U
#define SPI_DCR_PIO 0x1U
#define SPI_DCR_PIO_BIT 0
#define SPI_DCR_SPI_MASK 0x2U
#define SPI_DCR_SPI 0x2U
#define SPI_DCR_SPI_BIT 1

#define SPI_PMSR (*(volatile unsigned long *)0xFFFB4058)
#define SPI_PMSR_OFFSET 0x58
#define SPI_PMSR_PIO_MASK 0x1U
#define SPI_PMSR_PIO 0x1U
#define SPI_PMSR_PIO_BIT 0
#define SPI_PMSR_SPI_MASK 0x2U
#define SPI_PMSR_SPI 0x2U
#define SPI_PMSR_SPI_BIT 1

#define SPI_CR (*(volatile unsigned long *)0xFFFB4060)
#define SPI_CR_OFFSET 0x60
#define SPI_CR_SWRST_MASK 0x1U
#define SPI_CR_SWRST 0x1U
#define SPI_CR_SWRST_BIT 0
#define SPI_CR_SPIEN_MASK 0x2U
#define SPI_CR_SPIEN 0x2U
#define SPI_CR_SPIEN_BIT 1
#define SPI_CR_SPIDIS_MASK 0x4U
#define SPI_CR_SPIDIS 0x4U
#define SPI_CR_SPIDIS_BIT 2

#define SPI_MR (*(volatile unsigned long *)0xFFFB4064)
#define SPI_MR_OFFSET 0x64
#define SPI_MR_MSTR_MASK 0x1U
#define SPI_MR_MSTR 0x1U
#define SPI_MR_MSTR_BIT 0
#define SPI_MR_PS_MASK 0x2U
#define SPI_MR_PS 0x2U
#define SPI_MR_PS_BIT 1
#define SPI_MR_PCSDEC_MASK 0x4U
#define SPI_MR_PCSDEC 0x4U
#define SPI_MR_PCSDEC_BIT 2
#define SPI_MR_DIV32_MASK 0x8U
#define SPI_MR_DIV32 0x8U
#define SPI_MR_DIV32_BIT 3
#define SPI_MR_LLB_MASK 0x80U
#define SPI_MR_LLB 0x80U
#define SPI_MR_LLB_BIT 7
#define SPI_MR_PCS_MASK 0xF0000U
#define SPI_MR_PCS_BIT 16
#define SPI_MR_DLYBCS_MASK 0x1000000U
#define SPI_MR_DLYBCS 0x1000000U
#define SPI_MR_DLYBCS_BIT 24

#define SPI_SR (*(volatile unsigned long *)0xFFFB4070)
#define SPI_SR_OFFSET 0x70
#define SPI_SR_RDRF_MASK 0x1U
#define SPI_SR_RDRF 0x1U
#define SPI_SR_RDRF_BIT 0
#define SPI_SR_TDRE_MASK 0x2U
#define SPI_SR_TDRE 0x2U
#define SPI_SR_TDRE_BIT 1
#define SPI_SR_MODF_MASK 0x4U
#define SPI_SR_MODF 0x4U
#define SPI_SR_MODF_BIT 2
#define SPI_SR_SPIOVRE_MASK 0x8U
#define SPI_SR_SPIOVRE 0x8U
#define SPI_SR_SPIOVRE_BIT 3
#define SPI_SR_REND_MASK 0x10U
#define SPI_SR_REND 0x10U
#define SPI_SR_REND_BIT 4
#define SPI_SR_TEND_MASK 0x20U
#define SPI_SR_TEND 0x20U
#define SPI_SR_TEND_BIT 5
#define SPI_SR_SPIENS_MASK 0x100U
#define SPI_SR_SPIENS 0x100U
#define SPI_SR_SPIENS_BIT 8
#define SPI_SR_SPCK_MASK 0x10000U
#define SPI_SR_SPCK 0x10000U
#define SPI_SR_SPCK_BIT 16
#define SPI_SR_MISO_MASK 0x20000U
#define SPI_SR_MISO 0x20000U
#define SPI_SR_MISO_BIT 17
#define SPI_SR_MOSI_MASK 0x40000U
#define SPI_SR_MOSI 0x40000U
#define SPI_SR_MOSI_BIT 18
#define SPI_SR_NPCS0_MASK 0x80000U
#define SPI_SR_NPCS0 0x80000U
#define SPI_SR_NPCS0_BIT 19
#define SPI_SR_NPCS1_MASK 0x100000U
#define SPI_SR_NPCS1 0x100000U
#define SPI_SR_NPCS1_BIT 20
#define SPI_SR_NPCS2_MASK 0x200000U
#define SPI_SR_NPCS2 0x200000U
#define SPI_SR_NPCS2_BIT 21
#define SPI_SR_NPCS3_MASK 0x400000U
#define SPI_SR_NPCS3 0x400000U
#define SPI_SR_NPCS3_BIT 22

#define SPI_IER (*(volatile unsigned long *)0xFFFB4074)
#define SPI_IER_OFFSET 0x74
#define SPI_IER_RDRF_MASK 0x1U
#define SPI_IER_RDRF 0x1U
#define SPI_IER_RDRF_BIT 0
#define SPI_IER_TDRE_MASK 0x2U
#define SPI_IER_TDRE 0x2U
#define SPI_IER_TDRE_BIT 1
#define SPI_IER_MODF_MASK 0x4U
#define SPI_IER_MODF 0x4U
#define SPI_IER_MODF_BIT 2
#define SPI_IER_SPIOVRE_MASK 0x8U
#define SPI_IER_SPIOVRE 0x8U
#define SPI_IER_SPIOVRE_BIT 3
#define SPI_IER_REND_MASK 0x10U
#define SPI_IER_REND 0x10U
#define SPI_IER_REND_BIT 4
#define SPI_IER_TEND_MASK 0x20U
#define SPI_IER_TEND 0x20U
#define SPI_IER_TEND_BIT 5
#define SPI_IER_SPCK_MASK 0x10000U
#define SPI_IER_SPCK 0x10000U
#define SPI_IER_SPCK_BIT 16
#define SPI_IER_MISO_MASK 0x20000U
#define SPI_IER_MISO 0x20000U
#define SPI_IER_MISO_BIT 17
#define SPI_IER_MOSI_MASK 0x40000U
#define SPI_IER_MOSI 0x40000U
#define SPI_IER_MOSI_BIT 18
#define SPI_IER_NPCS0_MASK 0x80000U
#define SPI_IER_NPCS0 0x80000U
#define SPI_IER_NPCS0_BIT 19
#define SPI_IER_NPCS1_MASK 0x100000U
#define SPI_IER_NPCS1 0x100000U
#define SPI_IER_NPCS1_BIT 20
#define SPI_IER_NPCS2_MASK 0x200000U
#define SPI_IER_NPCS2 0x200000U
#define SPI_IER_NPCS2_BIT 21
#define SPI_IER_NPCS3_MASK 0x400000U
#define SPI_IER_NPCS3 0x400000U
#define SPI_IER_NPCS3_BIT 22

#define SPI_IDR (*(volatile unsigned long *)0xFFFB4078)
#define SPI_IDR_OFFSET 0x78
#define SPI_IDR_RDRF_MASK 0x1U
#define SPI_IDR_RDRF 0x1U
#define SPI_IDR_RDRF_BIT 0
#define SPI_IDR_TDRE_MASK 0x2U
#define SPI_IDR_TDRE 0x2U
#define SPI_IDR_TDRE_BIT 1
#define SPI_IDR_MODF_MASK 0x4U
#define SPI_IDR_MODF 0x4U
#define SPI_IDR_MODF_BIT 2
#define SPI_IDR_SPIOVRE_MASK 0x8U
#define SPI_IDR_SPIOVRE 0x8U
#define SPI_IDR_SPIOVRE_BIT 3
#define SPI_IDR_REND_MASK 0x10U
#define SPI_IDR_REND 0x10U
#define SPI_IDR_REND_BIT 4
#define SPI_IDR_TEND_MASK 0x20U
#define SPI_IDR_TEND 0x20U
#define SPI_IDR_TEND_BIT 5
#define SPI_IDR_SPCK_MASK 0x10000U
#define SPI_IDR_SPCK 0x10000U
#define SPI_IDR_SPCK_BIT 16
#define SPI_IDR_MISO_MASK 0x20000U
#define SPI_IDR_MISO 0x20000U
#define SPI_IDR_MISO_BIT 17
#define SPI_IDR_MOSI_MASK 0x40000U
#define SPI_IDR_MOSI 0x40000U
#define SPI_IDR_MOSI_BIT 18
#define SPI_IDR_NPCS0_MASK 0x80000U
#define SPI_IDR_NPCS0 0x80000U
#define SPI_IDR_NPCS0_BIT 19
#define SPI_IDR_NPCS1_MASK 0x100000U
#define SPI_IDR_NPCS1 0x100000U
#define SPI_IDR_NPCS1_BIT 20
#define SPI_IDR_NPCS2_MASK 0x200000U
#define SPI_IDR_NPCS2 0x200000U
#define SPI_IDR_NPCS2_BIT 21
#define SPI_IDR_NPCS3_MASK 0x400000U
#define SPI_IDR_NPCS3 0x400000U
#define SPI_IDR_NPCS3_BIT 22

#define SPI_IMR (*(volatile unsigned long *)0xFFFB407C)
#define SPI_IMR_OFFSET 0x7C
#define SPI_IMR_RDRF_MASK 0x1U
#define SPI_IMR_RDRF 0x1U
#define SPI_IMR_RDRF_BIT 0
#define SPI_IMR_TDRE_MASK 0x2U
#define SPI_IMR_TDRE 0x2U
#define SPI_IMR_TDRE_BIT 1
#define SPI_IMR_MODF_MASK 0x4U
#define SPI_IMR_MODF 0x4U
#define SPI_IMR_MODF_BIT 2
#define SPI_IMR_SPIOVRE_MASK 0x8U
#define SPI_IMR_SPIOVRE 0x8U
#define SPI_IMR_SPIOVRE_BIT 3
#define SPI_IMR_REND_MASK 0x10U
#define SPI_IMR_REND 0x10U
#define SPI_IMR_REND_BIT 4
#define SPI_IMR_TEND_MASK 0x20U
#define SPI_IMR_TEND 0x20U
#define SPI_IMR_TEND_BIT 5
#define SPI_IMR_SPCK_MASK 0x10000U
#define SPI_IMR_SPCK 0x10000U
#define SPI_IMR_SPCK_BIT 16
#define SPI_IMR_MISO_MASK 0x20000U
#define SPI_IMR_MISO 0x20000U
#define SPI_IMR_MISO_BIT 17
#define SPI_IMR_MOSI_MASK 0x40000U
#define SPI_IMR_MOSI 0x40000U
#define SPI_IMR_MOSI_BIT 18
#define SPI_IMR_NPCS0_MASK 0x80000U
#define SPI_IMR_NPCS0 0x80000U
#define SPI_IMR_NPCS0_BIT 19
#define SPI_IMR_NPCS1_MASK 0x100000U
#define SPI_IMR_NPCS1 0x100000U
#define SPI_IMR_NPCS1_BIT 20
#define SPI_IMR_NPCS2_MASK 0x200000U
#define SPI_IMR_NPCS2 0x200000U
#define SPI_IMR_NPCS2_BIT 21
#define SPI_IMR_NPCS3_MASK 0x400000U
#define SPI_IMR_NPCS3 0x400000U
#define SPI_IMR_NPCS3_BIT 22

#define SPI_RDR (*(volatile unsigned long *)0xFFFB4080)
#define SPI_RDR_OFFSET 0x80
#define SPI_RDR_RD_MASK 0xFFFFU
#define SPI_RDR_RD_BIT 0
#define SPI_RDR_PCS_MASK 0xF0000U
#define SPI_RDR_PCS_BIT 16

#define SPI_TDR (*(volatile unsigned long *)0xFFFB4084)
#define SPI_TDR_OFFSET 0x84
#define SPI_TDR_TD_MASK 0xFFFFU
#define SPI_TDR_TD_BIT 0
#define SPI_TDR_PCS_MASK 0xF0000U
#define SPI_TDR_PCS_BIT 16

#define SPI_CSR0 (*(volatile unsigned long *)0xFFFB4090)
#define SPI_CSR0_OFFSET 0x90
#define SPI_CSR0_CPOL_MASK 0x1U
#define SPI_CSR0_CPOL 0x1U
#define SPI_CSR0_CPOL_BIT 0
#define SPI_CSR0_NCPHA_MASK 0x1U
#define SPI_CSR0_NCPHA 0x1U
#define SPI_CSR0_NCPHA_BIT 0
#define SPI_CSR0_BITS_MASK 0xF0U
#define SPI_CSR0_BITS_BIT 4
#define SPI_CSR0_SCBR_MASK 0xFF00U
#define SPI_CSR0_SCBR_BIT 8
#define SPI_CSR0_DLYBS_MASK 0xFF0000U
#define SPI_CSR0_DLYBS_BIT 16
#define SPI_CSR0_DLYBCT_MASK 0xFF000000U
#define SPI_CSR0_DLYBCT_BIT 24

#define SPI_CSR1 (*(volatile unsigned long *)0xFFFB4094)
#define SPI_CSR1_OFFSET 0x94
#define SPI_CSR1_CPOL_MASK 0x1U
#define SPI_CSR1_CPOL 0x1U
#define SPI_CSR1_CPOL_BIT 0
#define SPI_CSR1_NCPHA_MASK 0x1U
#define SPI_CSR1_NCPHA 0x1U
#define SPI_CSR1_NCPHA_BIT 0
#define SPI_CSR1_BITS_MASK 0xF0U
#define SPI_CSR1_BITS_BIT 4
#define SPI_CSR1_SCBR_MASK 0xFF00U
#define SPI_CSR1_SCBR_BIT 8
#define SPI_CSR1_DLYBS_MASK 0xFF0000U
#define SPI_CSR1_DLYBS_BIT 16
#define SPI_CSR1_DLYBCT_MASK 0xFF000000U
#define SPI_CSR1_DLYBCT_BIT 24

#define SPI_CSR2 (*(volatile unsigned long *)0xFFFB4098)
#define SPI_CSR2_OFFSET 0x98
#define SPI_CSR2_CPOL_MASK 0x1U
#define SPI_CSR2_CPOL 0x1U
#define SPI_CSR2_CPOL_BIT 0
#define SPI_CSR2_NCPHA_MASK 0x1U
#define SPI_CSR2_NCPHA 0x1U
#define SPI_CSR2_NCPHA_BIT 0
#define SPI_CSR2_BITS_MASK 0xF0U
#define SPI_CSR2_BITS_BIT 4
#define SPI_CSR2_SCBR_MASK 0xFF00U
#define SPI_CSR2_SCBR_BIT 8
#define SPI_CSR2_DLYBS_MASK 0xFF0000U
#define SPI_CSR2_DLYBS_BIT 16
#define SPI_CSR2_DLYBCT_MASK 0xFF000000U
#define SPI_CSR2_DLYBCT_BIT 24

#define SPI_CSR3 (*(volatile unsigned long *)0xFFFB409C)
#define SPI_CSR3_OFFSET 0x9C
#define SPI_CSR3_CPOL_MASK 0x1U
#define SPI_CSR3_CPOL 0x1U
#define SPI_CSR3_CPOL_BIT 0
#define SPI_CSR3_NCPHA_MASK 0x1U
#define SPI_CSR3_NCPHA 0x1U
#define SPI_CSR3_NCPHA_BIT 0
#define SPI_CSR3_BITS_MASK 0xF0U
#define SPI_CSR3_BITS_BIT 4
#define SPI_CSR3_SCBR_MASK 0xFF00U
#define SPI_CSR3_SCBR_BIT 8
#define SPI_CSR3_DLYBS_MASK 0xFF0000U
#define SPI_CSR3_DLYBS_BIT 16
#define SPI_CSR3_DLYBCT_MASK 0xFF000000U
#define SPI_CSR3_DLYBCT_BIT 24

#define CAN1_BASE 0xFFFB8000

#define CAN1_ECR (*(volatile unsigned long *)0xFFFB8050)
#define CAN1_ECR_OFFSET 0x50
#define CAN1_ECR_CAN_MASK 0x2U
#define CAN1_ECR_CAN 0x2U
#define CAN1_ECR_CAN_BIT 1

#define CAN1_DCR (*(volatile unsigned long *)0xFFFB8054)
#define CAN1_DCR_OFFSET 0x54
#define CAN1_DCR_CAN_MASK 0x2U
#define CAN1_DCR_CAN 0x2U
#define CAN1_DCR_CAN_BIT 1

#define CAN1_PMSR (*(volatile unsigned long *)0xFFFB8058)
#define CAN1_PMSR_OFFSET 0x58
#define CAN1_PMSR_CAN_MASK 0x2U
#define CAN1_PMSR_CAN 0x2U
#define CAN1_PMSR_CAN_BIT 1

#define CAN1_CR (*(volatile unsigned long *)0xFFFB8060)
#define CAN1_CR_OFFSET 0x60
#define CAN1_CR_SWRST_MASK 0x1U
#define CAN1_CR_SWRST 0x1U
#define CAN1_CR_SWRST_BIT 0
#define CAN1_CR_CANEN_MASK 0x2U
#define CAN1_CR_CANEN 0x2U
#define CAN1_CR_CANEN_BIT 1
#define CAN1_CR_CANDIS_MASK 0x4U
#define CAN1_CR_CANDIS 0x4U
#define CAN1_CR_CANDIS_BIT 2
#define CAN1_CR_ABEN_MASK 0x8U
#define CAN1_CR_ABEN 0x8U
#define CAN1_CR_ABEN_BIT 3
#define CAN1_CR_ABDIS_MASK 0x10U
#define CAN1_CR_ABDIS 0x10U
#define CAN1_CR_ABDIS_BIT 4
#define CAN1_CR_OVEN_MASK 0x20U
#define CAN1_CR_OVEN 0x20U
#define CAN1_CR_OVEN_BIT 5
#define CAN1_CR_OVDIS_MASK 0x20U
#define CAN1_CR_OVDIS 0x20U
#define CAN1_CR_OVDIS_BIT 5

#define CAN1_MR (*(volatile unsigned long *)0xFFFB8064)
#define CAN1_MR_OFFSET 0x64
#define CAN1_MR_BD_MASK 0x3FU
#define CAN1_MR_BD_BIT 0
#define CAN1_MR_PROP_MASK 0x700U
#define CAN1_MR_PROP_BIT 8
#define CAN1_MR_SJW_MASK 0x3000U
#define CAN1_MR_SJW_BIT 12
#define CAN1_MR_SMP_MASK 0x4000U
#define CAN1_MR_SMP 0x4000U
#define CAN1_MR_SMP_BIT 14
#define CAN1_MR_PHSEG1_MASK 0x70000U
#define CAN1_MR_PHSEG1_BIT 16
#define CAN1_MR_PHSEG2_MASK 0x700000U
#define CAN1_MR_PHSEG2_BIT 20

#define CAN1_CSR (*(volatile unsigned long *)0xFFFB806C)
#define CAN1_CSR_OFFSET 0x6C
#define CAN1_CSR_ENDINIT_MASK 0x4U
#define CAN1_CSR_ENDINIT 0x4U
#define CAN1_CSR_ENDINIT_BIT 2

#define CAN1_SR (*(volatile unsigned long *)0xFFFB8070)
#define CAN1_SR_OFFSET 0x70
#define CAN1_SR_CANENA_MASK 0x1U
#define CAN1_SR_CANENA 0x1U
#define CAN1_SR_CANENA_BIT 0
#define CAN1_SR_CANINIT_MASK 0x2U
#define CAN1_SR_CANINIT 0x2U
#define CAN1_SR_CANINIT_BIT 1
#define CAN1_SR_ENDINIT_MASK 0x4U
#define CAN1_SR_ENDINIT 0x4U
#define CAN1_SR_ENDINIT_BIT 2
#define CAN1_SR_ERPAS_MASK 0x8U
#define CAN1_SR_ERPAS 0x8U
#define CAN1_SR_ERPAS_BIT 3
#define CAN1_SR_BUSOFF_MASK 0x10U
#define CAN1_SR_BUSOFF 0x10U
#define CAN1_SR_BUSOFF_BIT 4
#define CAN1_SR_ABRQ_MASK 0x20U
#define CAN1_SR_ABRQ 0x20U
#define CAN1_SR_ABRQ_BIT 5
#define CAN1_SR_ISS_MASK 0x80U
#define CAN1_SR_ISS 0x80U
#define CAN1_SR_ISS_BIT 7
#define CAN1_SR_REC_MASK 0xFF0000U
#define CAN1_SR_REC_BIT 16
#define CAN1_SR_TEC_MASK 0xFF000000U
#define CAN1_SR_TEC_BIT 24

#define CAN1_IER (*(volatile unsigned long *)0xFFFB8074)
#define CAN1_IER_OFFSET 0x74
#define CAN1_IER_ENDINIT_MASK 0x4U
#define CAN1_IER_ENDINIT 0x4U
#define CAN1_IER_ENDINIT_BIT 2
#define CAN1_IER_ERPAS_MASK 0x8U
#define CAN1_IER_ERPAS 0x8U
#define CAN1_IER_ERPAS_BIT 3
#define CAN1_IER_BUSOFF_MASK 0x10U
#define CAN1_IER_BUSOFF 0x10U
#define CAN1_IER_BUSOFF_BIT 4

#define CAN1_IDR (*(volatile unsigned long *)0xFFFB8078)
#define CAN1_IDR_OFFSET 0x78
#define CAN1_IDR_ENDINIT_MASK 0x4U
#define CAN1_IDR_ENDINIT 0x4U
#define CAN1_IDR_ENDINIT_BIT 2
#define CAN1_IDR_ERPAS_MASK 0x8U
#define CAN1_IDR_ERPAS 0x8U
#define CAN1_IDR_ERPAS_BIT 3
#define CAN1_IDR_BUSOFF_MASK 0x10U
#define CAN1_IDR_BUSOFF 0x10U
#define CAN1_IDR_BUSOFF_BIT 4

#define CAN1_IMR (*(volatile unsigned long *)0xFFFB807C)
#define CAN1_IMR_OFFSET 0x7C
#define CAN1_IMR_ENDINIT_MASK 0x4U
#define CAN1_IMR_ENDINIT 0x4U
#define CAN1_IMR_ENDINIT_BIT 2
#define CAN1_IMR_ERPAS_MASK 0x8U
#define CAN1_IMR_ERPAS 0x8U
#define CAN1_IMR_ERPAS_BIT 3
#define CAN1_IMR_BUSOFF_MASK 0x10U
#define CAN1_IMR_BUSOFF 0x10U
#define CAN1_IMR_BUSOFF_BIT 4

#define CAN1_CISR (*(volatile unsigned long *)0xFFFB8080)
#define CAN1_CISR_OFFSET 0x80
#define CAN1_CISR_CH0_MASK 0x1U
#define CAN1_CISR_CH0 0x1U
#define CAN1_CISR_CH0_BIT 0
#define CAN1_CISR_CH1_MASK 0x2U
#define CAN1_CISR_CH1 0x2U
#define CAN1_CISR_CH1_BIT 1
#define CAN1_CISR_CH2_MASK 0x4U
#define CAN1_CISR_CH2 0x4U
#define CAN1_CISR_CH2_BIT 2
#define CAN1_CISR_CH3_MASK 0x8U
#define CAN1_CISR_CH3 0x8U
#define CAN1_CISR_CH3_BIT 3
#define CAN1_CISR_CH4_MASK 0x10U
#define CAN1_CISR_CH4 0x10U
#define CAN1_CISR_CH4_BIT 4
#define CAN1_CISR_CH5_MASK 0x20U
#define CAN1_CISR_CH5 0x20U
#define CAN1_CISR_CH5_BIT 5
#define CAN1_CISR_CH6_MASK 0x40U
#define CAN1_CISR_CH6 0x40U
#define CAN1_CISR_CH6_BIT 6
#define CAN1_CISR_CH7_MASK 0x80U
#define CAN1_CISR_CH7 0x80U
#define CAN1_CISR_CH7_BIT 7
#define CAN1_CISR_CH8_MASK 0x100U
#define CAN1_CISR_CH8 0x100U
#define CAN1_CISR_CH8_BIT 8
#define CAN1_CISR_CH9_MASK 0x200U
#define CAN1_CISR_CH9 0x200U
#define CAN1_CISR_CH9_BIT 9
#define CAN1_CISR_CH10_MASK 0x400U
#define CAN1_CISR_CH10 0x400U
#define CAN1_CISR_CH10_BIT 10
#define CAN1_CISR_CH11_MASK 0x800U
#define CAN1_CISR_CH11 0x800U
#define CAN1_CISR_CH11_BIT 11
#define CAN1_CISR_CH12_MASK 0x1000U
#define CAN1_CISR_CH12 0x1000U
#define CAN1_CISR_CH12_BIT 12
#define CAN1_CISR_CH13_MASK 0x2000U
#define CAN1_CISR_CH13 0x2000U
#define CAN1_CISR_CH13_BIT 13
#define CAN1_CISR_CH14_MASK 0x4000U
#define CAN1_CISR_CH14 0x4000U
#define CAN1_CISR_CH14_BIT 14
#define CAN1_CISR_CH15_MASK 0x8000U
#define CAN1_CISR_CH15 0x8000U
#define CAN1_CISR_CH15_BIT 15

#define CAN1_ISSR (*(volatile unsigned long *)0xFFFB8084)
#define CAN1_ISSR_OFFSET 0x84
#define CAN1_ISSR_CH0_MASK 0x1U
#define CAN1_ISSR_CH0 0x1U
#define CAN1_ISSR_CH0_BIT 0
#define CAN1_ISSR_CH1_MASK 0x2U
#define CAN1_ISSR_CH1 0x2U
#define CAN1_ISSR_CH1_BIT 1
#define CAN1_ISSR_CH2_MASK 0x4U
#define CAN1_ISSR_CH2 0x4U
#define CAN1_ISSR_CH2_BIT 2
#define CAN1_ISSR_CH3_MASK 0x8U
#define CAN1_ISSR_CH3 0x8U
#define CAN1_ISSR_CH3_BIT 3
#define CAN1_ISSR_CH4_MASK 0x10U
#define CAN1_ISSR_CH4 0x10U
#define CAN1_ISSR_CH4_BIT 4
#define CAN1_ISSR_CH5_MASK 0x20U
#define CAN1_ISSR_CH5 0x20U
#define CAN1_ISSR_CH5_BIT 5
#define CAN1_ISSR_CH6_MASK 0x40U
#define CAN1_ISSR_CH6 0x40U
#define CAN1_ISSR_CH6_BIT 6
#define CAN1_ISSR_CH7_MASK 0x80U
#define CAN1_ISSR_CH7 0x80U
#define CAN1_ISSR_CH7_BIT 7
#define CAN1_ISSR_CH8_MASK 0x100U
#define CAN1_ISSR_CH8 0x100U
#define CAN1_ISSR_CH8_BIT 8
#define CAN1_ISSR_CH9_MASK 0x200U
#define CAN1_ISSR_CH9 0x200U
#define CAN1_ISSR_CH9_BIT 9
#define CAN1_ISSR_CH10_MASK 0x400U
#define CAN1_ISSR_CH10 0x400U
#define CAN1_ISSR_CH10_BIT 10
#define CAN1_ISSR_CH11_MASK 0x800U
#define CAN1_ISSR_CH11 0x800U
#define CAN1_ISSR_CH11_BIT 11
#define CAN1_ISSR_CH12_MASK 0x1000U
#define CAN1_ISSR_CH12 0x1000U
#define CAN1_ISSR_CH12_BIT 12
#define CAN1_ISSR_CH13_MASK 0x2000U
#define CAN1_ISSR_CH13 0x2000U
#define CAN1_ISSR_CH13_BIT 13
#define CAN1_ISSR_CH14_MASK 0x4000U
#define CAN1_ISSR_CH14 0x4000U
#define CAN1_ISSR_CH14_BIT 14
#define CAN1_ISSR_CH15_MASK 0x8000U
#define CAN1_ISSR_CH15 0x8000U
#define CAN1_ISSR_CH15_BIT 15

#define CAN1_SIER (*(volatile unsigned long *)0xFFFB8088)
#define CAN1_SIER_OFFSET 0x88
#define CAN1_SIER_CH0_MASK 0x1U
#define CAN1_SIER_CH0 0x1U
#define CAN1_SIER_CH0_BIT 0
#define CAN1_SIER_CH1_MASK 0x2U
#define CAN1_SIER_CH1 0x2U
#define CAN1_SIER_CH1_BIT 1
#define CAN1_SIER_CH2_MASK 0x4U
#define CAN1_SIER_CH2 0x4U
#define CAN1_SIER_CH2_BIT 2
#define CAN1_SIER_CH3_MASK 0x8U
#define CAN1_SIER_CH3 0x8U
#define CAN1_SIER_CH3_BIT 3
#define CAN1_SIER_CH4_MASK 0x10U
#define CAN1_SIER_CH4 0x10U
#define CAN1_SIER_CH4_BIT 4
#define CAN1_SIER_CH5_MASK 0x20U
#define CAN1_SIER_CH5 0x20U
#define CAN1_SIER_CH5_BIT 5
#define CAN1_SIER_CH6_MASK 0x40U
#define CAN1_SIER_CH6 0x40U
#define CAN1_SIER_CH6_BIT 6
#define CAN1_SIER_CH7_MASK 0x80U
#define CAN1_SIER_CH7 0x80U
#define CAN1_SIER_CH7_BIT 7
#define CAN1_SIER_CH8_MASK 0x100U
#define CAN1_SIER_CH8 0x100U
#define CAN1_SIER_CH8_BIT 8
#define CAN1_SIER_CH9_MASK 0x200U
#define CAN1_SIER_CH9 0x200U
#define CAN1_SIER_CH9_BIT 9
#define CAN1_SIER_CH10_MASK 0x400U
#define CAN1_SIER_CH10 0x400U
#define CAN1_SIER_CH10_BIT 10
#define CAN1_SIER_CH11_MASK 0x800U
#define CAN1_SIER_CH11 0x800U
#define CAN1_SIER_CH11_BIT 11
#define CAN1_SIER_CH12_MASK 0x1000U
#define CAN1_SIER_CH12 0x1000U
#define CAN1_SIER_CH12_BIT 12
#define CAN1_SIER_CH13_MASK 0x2000U
#define CAN1_SIER_CH13 0x2000U
#define CAN1_SIER_CH13_BIT 13
#define CAN1_SIER_CH14_MASK 0x4000U
#define CAN1_SIER_CH14 0x4000U
#define CAN1_SIER_CH14_BIT 14
#define CAN1_SIER_CH15_MASK 0x8000U
#define CAN1_SIER_CH15 0x8000U
#define CAN1_SIER_CH15_BIT 15

#define CAN1_SIDR (*(volatile unsigned long *)0xFFFB808C)
#define CAN1_SIDR_OFFSET 0x8C
#define CAN1_SIDR_CH0_MASK 0x1U
#define CAN1_SIDR_CH0 0x1U
#define CAN1_SIDR_CH0_BIT 0
#define CAN1_SIDR_CH1_MASK 0x2U
#define CAN1_SIDR_CH1 0x2U
#define CAN1_SIDR_CH1_BIT 1
#define CAN1_SIDR_CH2_MASK 0x4U
#define CAN1_SIDR_CH2 0x4U
#define CAN1_SIDR_CH2_BIT 2
#define CAN1_SIDR_CH3_MASK 0x8U
#define CAN1_SIDR_CH3 0x8U
#define CAN1_SIDR_CH3_BIT 3
#define CAN1_SIDR_CH4_MASK 0x10U
#define CAN1_SIDR_CH4 0x10U
#define CAN1_SIDR_CH4_BIT 4
#define CAN1_SIDR_CH5_MASK 0x20U
#define CAN1_SIDR_CH5 0x20U
#define CAN1_SIDR_CH5_BIT 5
#define CAN1_SIDR_CH6_MASK 0x40U
#define CAN1_SIDR_CH6 0x40U
#define CAN1_SIDR_CH6_BIT 6
#define CAN1_SIDR_CH7_MASK 0x80U
#define CAN1_SIDR_CH7 0x80U
#define CAN1_SIDR_CH7_BIT 7
#define CAN1_SIDR_CH8_MASK 0x100U
#define CAN1_SIDR_CH8 0x100U
#define CAN1_SIDR_CH8_BIT 8
#define CAN1_SIDR_CH9_MASK 0x200U
#define CAN1_SIDR_CH9 0x200U
#define CAN1_SIDR_CH9_BIT 9
#define CAN1_SIDR_CH10_MASK 0x400U
#define CAN1_SIDR_CH10 0x400U
#define CAN1_SIDR_CH10_BIT 10
#define CAN1_SIDR_CH11_MASK 0x800U
#define CAN1_SIDR_CH11 0x800U
#define CAN1_SIDR_CH11_BIT 11
#define CAN1_SIDR_CH12_MASK 0x1000U
#define CAN1_SIDR_CH12 0x1000U
#define CAN1_SIDR_CH12_BIT 12
#define CAN1_SIDR_CH13_MASK 0x2000U
#define CAN1_SIDR_CH13 0x2000U
#define CAN1_SIDR_CH13_BIT 13
#define CAN1_SIDR_CH14_MASK 0x4000U
#define CAN1_SIDR_CH14 0x4000U
#define CAN1_SIDR_CH14_BIT 14
#define CAN1_SIDR_CH15_MASK 0x8000U
#define CAN1_SIDR_CH15 0x8000U
#define CAN1_SIDR_CH15_BIT 15

#define CAN1_SIMR (*(volatile unsigned long *)0xFFFB8090)
#define CAN1_SIMR_OFFSET 0x90
#define CAN1_SIMR_CH0_MASK 0x1U
#define CAN1_SIMR_CH0 0x1U
#define CAN1_SIMR_CH0_BIT 0
#define CAN1_SIMR_CH1_MASK 0x2U
#define CAN1_SIMR_CH1 0x2U
#define CAN1_SIMR_CH1_BIT 1
#define CAN1_SIMR_CH2_MASK 0x4U
#define CAN1_SIMR_CH2 0x4U
#define CAN1_SIMR_CH2_BIT 2
#define CAN1_SIMR_CH3_MASK 0x8U
#define CAN1_SIMR_CH3 0x8U
#define CAN1_SIMR_CH3_BIT 3
#define CAN1_SIMR_CH4_MASK 0x10U
#define CAN1_SIMR_CH4 0x10U
#define CAN1_SIMR_CH4_BIT 4
#define CAN1_SIMR_CH5_MASK 0x20U
#define CAN1_SIMR_CH5 0x20U
#define CAN1_SIMR_CH5_BIT 5
#define CAN1_SIMR_CH6_MASK 0x40U
#define CAN1_SIMR_CH6 0x40U
#define CAN1_SIMR_CH6_BIT 6
#define CAN1_SIMR_CH7_MASK 0x80U
#define CAN1_SIMR_CH7 0x80U
#define CAN1_SIMR_CH7_BIT 7
#define CAN1_SIMR_CH8_MASK 0x100U
#define CAN1_SIMR_CH8 0x100U
#define CAN1_SIMR_CH8_BIT 8
#define CAN1_SIMR_CH9_MASK 0x200U
#define CAN1_SIMR_CH9 0x200U
#define CAN1_SIMR_CH9_BIT 9
#define CAN1_SIMR_CH10_MASK 0x400U
#define CAN1_SIMR_CH10 0x400U
#define CAN1_SIMR_CH10_BIT 10
#define CAN1_SIMR_CH11_MASK 0x800U
#define CAN1_SIMR_CH11 0x800U
#define CAN1_SIMR_CH11_BIT 11
#define CAN1_SIMR_CH12_MASK 0x1000U
#define CAN1_SIMR_CH12 0x1000U
#define CAN1_SIMR_CH12_BIT 12
#define CAN1_SIMR_CH13_MASK 0x2000U
#define CAN1_SIMR_CH13 0x2000U
#define CAN1_SIMR_CH13_BIT 13
#define CAN1_SIMR_CH14_MASK 0x4000U
#define CAN1_SIMR_CH14 0x4000U
#define CAN1_SIMR_CH14_BIT 14
#define CAN1_SIMR_CH15_MASK 0x8000U
#define CAN1_SIMR_CH15 0x8000U
#define CAN1_SIMR_CH15_BIT 15

#define CAN1_DRA0 (*(volatile unsigned long *)0xFFFB8100)
#define CAN1_DRA0_OFFSET 0x100
#define CAN1_DRA0_DATA0_MASK 0xFFU
#define CAN1_DRA0_DATA0_BIT 0
#define CAN1_DRA0_DATA1_MASK 0xFF00U
#define CAN1_DRA0_DATA1_BIT 8
#define CAN1_DRA0_DATA2_MASK 0xFF0000U
#define CAN1_DRA0_DATA2_BIT 16
#define CAN1_DRA0_DATA3_MASK 0xFF000000U
#define CAN1_DRA0_DATA3_BIT 24

#define CAN1_DRB0 (*(volatile unsigned long *)0xFFFB8104)
#define CAN1_DRB0_OFFSET 0x104
#define CAN1_DRB0_DATA4_MASK 0xFFU
#define CAN1_DRB0_DATA4_BIT 0
#define CAN1_DRB0_DATA5_MASK 0xFF00U
#define CAN1_DRB0_DATA5_BIT 8
#define CAN1_DRB0_DATA6_MASK 0xFF0000U
#define CAN1_DRB0_DATA6_BIT 16
#define CAN1_DRB0_DATA7_MASK 0xFF000000U
#define CAN1_DRB0_DATA7_BIT 24

#define CAN1_MSK0 (*(volatile unsigned long *)0xFFFB8108)
#define CAN1_MSK0_OFFSET 0x108
#define CAN1_MSK0_MASK_MASK 0x1FFFFFFFU
#define CAN1_MSK0_MASK_BIT 0
#define CAN1_MSK0_MRB_MASK 0x60000000U
#define CAN1_MSK0_MRB_BIT 29
#define CAN1_MSK0_MRTR_MASK 0x80000000U
#define CAN1_MSK0_MRTR 0x80000000U
#define CAN1_MSK0_MRTR_BIT 31

#define CAN1_IR0 (*(volatile unsigned long *)0xFFFB810C)
#define CAN1_IR0_OFFSET 0x10C
#define CAN1_IR0_ID_MASK 0x1FFFFFFFU
#define CAN1_IR0_ID_BIT 0
#define CAN1_IR0_RB_MASK 0x60000000U
#define CAN1_IR0_RB_BIT 29
#define CAN1_IR0_RTR_MASK 0x80000000U
#define CAN1_IR0_RTR 0x80000000U
#define CAN1_IR0_RTR_BIT 31

#define CAN1_CR0 (*(volatile unsigned long *)0xFFFB8110)
#define CAN1_CR0_OFFSET 0x110
#define CAN1_CR0_DLC_MASK 0xFU
#define CAN1_CR0_DLC_BIT 0
#define CAN1_CR0_IDE_MASK 0x10U
#define CAN1_CR0_IDE 0x10U
#define CAN1_CR0_IDE_BIT 4
#define CAN1_CR0_RPLYV_MASK 0x20U
#define CAN1_CR0_RPLYV 0x20U
#define CAN1_CR0_RPLYV_BIT 5
#define CAN1_CR0_PCB_MASK 0x40U
#define CAN1_CR0_PCB 0x40U
#define CAN1_CR0_PCB_BIT 6
#define CAN1_CR0_CHANEN_MASK 0x80U
#define CAN1_CR0_CHANEN 0x80U
#define CAN1_CR0_CHANEN_BIT 7
#define CAN1_CR0_OVERWRITE_MASK 0x100U
#define CAN1_CR0_OVERWRITE 0x100U
#define CAN1_CR0_OVERWRITE_BIT 8

#define CAN1_CR0 (*(volatile unsigned long *)0xFFFB8114)
#define CAN1_CR0_OFFSET 0x114
#define CAN1_CR0_STAMP_MASK 0x0U
#define CAN1_CR0_STAMP_BIT 0

#define CAN1_CSR0 (*(volatile unsigned long *)0xFFFB8118)
#define CAN1_CSR0_OFFSET 0x118
#define CAN1_CSR0_ACK_MASK 0x1U
#define CAN1_CSR0_ACK 0x1U
#define CAN1_CSR0_ACK_BIT 0
#define CAN1_CSR0_FRAME_MASK 0x2U
#define CAN1_CSR0_FRAME 0x2U
#define CAN1_CSR0_FRAME_BIT 1
#define CAN1_CSR0_CRC_MASK 0x4U
#define CAN1_CSR0_CRC 0x4U
#define CAN1_CSR0_CRC_BIT 2
#define CAN1_CSR0_STUFF_MASK 0x8U
#define CAN1_CSR0_STUFF 0x8U
#define CAN1_CSR0_STUFF_BIT 3
#define CAN1_CSR0_BUS_MASK 0x10U
#define CAN1_CSR0_BUS 0x10U
#define CAN1_CSR0_BUS_BIT 4
#define CAN1_CSR0_RXOK_MASK 0x20U
#define CAN1_CSR0_RXOK 0x20U
#define CAN1_CSR0_RXOK_BIT 5
#define CAN1_CSR0_TXOK_MASK 0x40U
#define CAN1_CSR0_TXOK 0x40U
#define CAN1_CSR0_TXOK_BIT 6
#define CAN1_CSR0_RFRAME_MASK 0x80U
#define CAN1_CSR0_RFRAME 0x80U
#define CAN1_CSR0_RFRAME_BIT 7
#define CAN1_CSR0_DLCW_MASK 0x200U
#define CAN1_CSR0_DLCW 0x200U
#define CAN1_CSR0_DLCW_BIT 9
#define CAN1_CSR0_FILLED_MASK 0x400U
#define CAN1_CSR0_FILLED 0x400U
#define CAN1_CSR0_FILLED_BIT 10
#define CAN1_CSR0_OVRUN_MASK 0x800U
#define CAN1_CSR0_OVRUN 0x800U
#define CAN1_CSR0_OVRUN_BIT 11

#define CAN1_SR0 (*(volatile unsigned long *)0xFFFB811C)
#define CAN1_SR0_OFFSET 0x11C
#define CAN1_SR0_ACK_MASK 0x1U
#define CAN1_SR0_ACK 0x1U
#define CAN1_SR0_ACK_BIT 0
#define CAN1_SR0_FRAME_MASK 0x2U
#define CAN1_SR0_FRAME 0x2U
#define CAN1_SR0_FRAME_BIT 1
#define CAN1_SR0_CRC_MASK 0x4U
#define CAN1_SR0_CRC 0x4U
#define CAN1_SR0_CRC_BIT 2
#define CAN1_SR0_STUFF_MASK 0x8U
#define CAN1_SR0_STUFF 0x8U
#define CAN1_SR0_STUFF_BIT 3
#define CAN1_SR0_BUS_MASK 0x10U
#define CAN1_SR0_BUS 0x10U
#define CAN1_SR0_BUS_BIT 4
#define CAN1_SR0_RXOK_MASK 0x20U
#define CAN1_SR0_RXOK 0x20U
#define CAN1_SR0_RXOK_BIT 5
#define CAN1_SR0_TXOK_MASK 0x40U
#define CAN1_SR0_TXOK 0x40U
#define CAN1_SR0_TXOK_BIT 6
#define CAN1_SR0_RFRAME_MASK 0x80U
#define CAN1_SR0_RFRAME 0x80U
#define CAN1_SR0_RFRAME_BIT 7
#define CAN1_SR0_DLCW_MASK 0x200U
#define CAN1_SR0_DLCW 0x200U
#define CAN1_SR0_DLCW_BIT 9
#define CAN1_SR0_FILLED_MASK 0x400U
#define CAN1_SR0_FILLED 0x400U
#define CAN1_SR0_FILLED_BIT 10
#define CAN1_SR0_OVRUN_MASK 0x800U
#define CAN1_SR0_OVRUN 0x800U
#define CAN1_SR0_OVRUN_BIT 11

#define CAN1_IER0 (*(volatile unsigned long *)0xFFFB8120)
#define CAN1_IER0_OFFSET 0x120
#define CAN1_IER0_ACK_MASK 0x1U
#define CAN1_IER0_ACK 0x1U
#define CAN1_IER0_ACK_BIT 0
#define CAN1_IER0_FRAME_MASK 0x2U
#define CAN1_IER0_FRAME 0x2U
#define CAN1_IER0_FRAME_BIT 1
#define CAN1_IER0_CRC_MASK 0x4U
#define CAN1_IER0_CRC 0x4U
#define CAN1_IER0_CRC_BIT 2
#define CAN1_IER0_STUFF_MASK 0x8U
#define CAN1_IER0_STUFF 0x8U
#define CAN1_IER0_STUFF_BIT 3
#define CAN1_IER0_BUS_MASK 0x10U
#define CAN1_IER0_BUS 0x10U
#define CAN1_IER0_BUS_BIT 4
#define CAN1_IER0_RXOK_MASK 0x20U
#define CAN1_IER0_RXOK 0x20U
#define CAN1_IER0_RXOK_BIT 5
#define CAN1_IER0_TXOK_MASK 0x40U
#define CAN1_IER0_TXOK 0x40U
#define CAN1_IER0_TXOK_BIT 6
#define CAN1_IER0_RFRAME_MASK 0x80U
#define CAN1_IER0_RFRAME 0x80U
#define CAN1_IER0_RFRAME_BIT 7

#define CAN1_IDR0 (*(volatile unsigned long *)0xFFFB8124)
#define CAN1_IDR0_OFFSET 0x124
#define CAN1_IDR0_ACK_MASK 0x1U
#define CAN1_IDR0_ACK 0x1U
#define CAN1_IDR0_ACK_BIT 0
#define CAN1_IDR0_FRAME_MASK 0x2U
#define CAN1_IDR0_FRAME 0x2U
#define CAN1_IDR0_FRAME_BIT 1
#define CAN1_IDR0_CRC_MASK 0x4U
#define CAN1_IDR0_CRC 0x4U
#define CAN1_IDR0_CRC_BIT 2
#define CAN1_IDR0_STUFF_MASK 0x8U
#define CAN1_IDR0_STUFF 0x8U
#define CAN1_IDR0_STUFF_BIT 3
#define CAN1_IDR0_BUS_MASK 0x10U
#define CAN1_IDR0_BUS 0x10U
#define CAN1_IDR0_BUS_BIT 4
#define CAN1_IDR0_RXOK_MASK 0x20U
#define CAN1_IDR0_RXOK 0x20U
#define CAN1_IDR0_RXOK_BIT 5
#define CAN1_IDR0_TXOK_MASK 0x40U
#define CAN1_IDR0_TXOK 0x40U
#define CAN1_IDR0_TXOK_BIT 6
#define CAN1_IDR0_RFRAME_MASK 0x80U
#define CAN1_IDR0_RFRAME 0x80U
#define CAN1_IDR0_RFRAME_BIT 7

#define CAN1_IMR0 (*(volatile unsigned long *)0xFFFB8128)
#define CAN1_IMR0_OFFSET 0x128
#define CAN1_IMR0_ACK_MASK 0x1U
#define CAN1_IMR0_ACK 0x1U
#define CAN1_IMR0_ACK_BIT 0
#define CAN1_IMR0_FRAME_MASK 0x2U
#define CAN1_IMR0_FRAME 0x2U
#define CAN1_IMR0_FRAME_BIT 1
#define CAN1_IMR0_CRC_MASK 0x4U
#define CAN1_IMR0_CRC 0x4U
#define CAN1_IMR0_CRC_BIT 2
#define CAN1_IMR0_STUFF_MASK 0x8U
#define CAN1_IMR0_STUFF 0x8U
#define CAN1_IMR0_STUFF_BIT 3
#define CAN1_IMR0_BUS_MASK 0x10U
#define CAN1_IMR0_BUS 0x10U
#define CAN1_IMR0_BUS_BIT 4
#define CAN1_IMR0_RXOK_MASK 0x20U
#define CAN1_IMR0_RXOK 0x20U
#define CAN1_IMR0_RXOK_BIT 5
#define CAN1_IMR0_TXOK_MASK 0x40U
#define CAN1_IMR0_TXOK 0x40U
#define CAN1_IMR0_TXOK_BIT 6
#define CAN1_IMR0_RFRAME_MASK 0x80U
#define CAN1_IMR0_RFRAME 0x80U
#define CAN1_IMR0_RFRAME_BIT 7

#define CAN1_DRA1 (*(volatile unsigned long *)0xFFFB8140)
#define CAN1_DRA1_OFFSET 0x140
#define CAN1_DRA1_DATA0_MASK 0xFFU
#define CAN1_DRA1_DATA0_BIT 0
#define CAN1_DRA1_DATA1_MASK 0xFF00U
#define CAN1_DRA1_DATA1_BIT 8
#define CAN1_DRA1_DATA2_MASK 0xFF0000U
#define CAN1_DRA1_DATA2_BIT 16
#define CAN1_DRA1_DATA3_MASK 0xFF000000U
#define CAN1_DRA1_DATA3_BIT 24

#define CAN1_DRB1 (*(volatile unsigned long *)0xFFFB8144)
#define CAN1_DRB1_OFFSET 0x144
#define CAN1_DRB1_DATA4_MASK 0xFFU
#define CAN1_DRB1_DATA4_BIT 0
#define CAN1_DRB1_DATA5_MASK 0xFF00U
#define CAN1_DRB1_DATA5_BIT 8
#define CAN1_DRB1_DATA6_MASK 0xFF0000U
#define CAN1_DRB1_DATA6_BIT 16
#define CAN1_DRB1_DATA7_MASK 0xFF000000U
#define CAN1_DRB1_DATA7_BIT 24

#define CAN1_MSK1 (*(volatile unsigned long *)0xFFFB8148)
#define CAN1_MSK1_OFFSET 0x148
#define CAN1_MSK1_MASK_MASK 0x1FFFFFFFU
#define CAN1_MSK1_MASK_BIT 0
#define CAN1_MSK1_MRB_MASK 0x60000000U
#define CAN1_MSK1_MRB_BIT 29
#define CAN1_MSK1_MRTR_MASK 0x80000000U
#define CAN1_MSK1_MRTR 0x80000000U
#define CAN1_MSK1_MRTR_BIT 31

#define CAN1_IR1 (*(volatile unsigned long *)0xFFFB814C)
#define CAN1_IR1_OFFSET 0x14C
#define CAN1_IR1_ID_MASK 0x1FFFFFFFU
#define CAN1_IR1_ID_BIT 0
#define CAN1_IR1_RB_MASK 0x60000000U
#define CAN1_IR1_RB_BIT 29
#define CAN1_IR1_RTR_MASK 0x80000000U
#define CAN1_IR1_RTR 0x80000000U
#define CAN1_IR1_RTR_BIT 31

#define CAN1_CR1 (*(volatile unsigned long *)0xFFFB8150)
#define CAN1_CR1_OFFSET 0x150
#define CAN1_CR1_DLC_MASK 0xFU
#define CAN1_CR1_DLC_BIT 0
#define CAN1_CR1_IDE_MASK 0x10U
#define CAN1_CR1_IDE 0x10U
#define CAN1_CR1_IDE_BIT 4
#define CAN1_CR1_RPLYV_MASK 0x20U
#define CAN1_CR1_RPLYV 0x20U
#define CAN1_CR1_RPLYV_BIT 5
#define CAN1_CR1_PCB_MASK 0x40U
#define CAN1_CR1_PCB 0x40U
#define CAN1_CR1_PCB_BIT 6
#define CAN1_CR1_CHANEN_MASK 0x80U
#define CAN1_CR1_CHANEN 0x80U
#define CAN1_CR1_CHANEN_BIT 7
#define CAN1_CR1_OVERWRITE_MASK 0x100U
#define CAN1_CR1_OVERWRITE 0x100U
#define CAN1_CR1_OVERWRITE_BIT 8

#define CAN1_CR1 (*(volatile unsigned long *)0xFFFB8154)
#define CAN1_CR1_OFFSET 0x154
#define CAN1_CR1_STAMP_MASK 0x0U
#define CAN1_CR1_STAMP_BIT 0

#define CAN1_CSR1 (*(volatile unsigned long *)0xFFFB8158)
#define CAN1_CSR1_OFFSET 0x158
#define CAN1_CSR1_ACK_MASK 0x1U
#define CAN1_CSR1_ACK 0x1U
#define CAN1_CSR1_ACK_BIT 0
#define CAN1_CSR1_FRAME_MASK 0x2U
#define CAN1_CSR1_FRAME 0x2U
#define CAN1_CSR1_FRAME_BIT 1
#define CAN1_CSR1_CRC_MASK 0x4U
#define CAN1_CSR1_CRC 0x4U
#define CAN1_CSR1_CRC_BIT 2
#define CAN1_CSR1_STUFF_MASK 0x8U
#define CAN1_CSR1_STUFF 0x8U
#define CAN1_CSR1_STUFF_BIT 3
#define CAN1_CSR1_BUS_MASK 0x10U
#define CAN1_CSR1_BUS 0x10U
#define CAN1_CSR1_BUS_BIT 4
#define CAN1_CSR1_RXOK_MASK 0x20U
#define CAN1_CSR1_RXOK 0x20U
#define CAN1_CSR1_RXOK_BIT 5
#define CAN1_CSR1_TXOK_MASK 0x40U
#define CAN1_CSR1_TXOK 0x40U
#define CAN1_CSR1_TXOK_BIT 6
#define CAN1_CSR1_RFRAME_MASK 0x80U
#define CAN1_CSR1_RFRAME 0x80U
#define CAN1_CSR1_RFRAME_BIT 7
#define CAN1_CSR1_DLCW_MASK 0x200U
#define CAN1_CSR1_DLCW 0x200U
#define CAN1_CSR1_DLCW_BIT 9
#define CAN1_CSR1_FILLED_MASK 0x400U
#define CAN1_CSR1_FILLED 0x400U
#define CAN1_CSR1_FILLED_BIT 10
#define CAN1_CSR1_OVRUN_MASK 0x800U
#define CAN1_CSR1_OVRUN 0x800U
#define CAN1_CSR1_OVRUN_BIT 11

#define CAN1_SR1 (*(volatile unsigned long *)0xFFFB815C)
#define CAN1_SR1_OFFSET 0x15C
#define CAN1_SR1_ACK_MASK 0x1U
#define CAN1_SR1_ACK 0x1U
#define CAN1_SR1_ACK_BIT 0
#define CAN1_SR1_FRAME_MASK 0x2U
#define CAN1_SR1_FRAME 0x2U
#define CAN1_SR1_FRAME_BIT 1
#define CAN1_SR1_CRC_MASK 0x4U
#define CAN1_SR1_CRC 0x4U
#define CAN1_SR1_CRC_BIT 2
#define CAN1_SR1_STUFF_MASK 0x8U
#define CAN1_SR1_STUFF 0x8U
#define CAN1_SR1_STUFF_BIT 3
#define CAN1_SR1_BUS_MASK 0x10U
#define CAN1_SR1_BUS 0x10U
#define CAN1_SR1_BUS_BIT 4
#define CAN1_SR1_RXOK_MASK 0x20U
#define CAN1_SR1_RXOK 0x20U
#define CAN1_SR1_RXOK_BIT 5
#define CAN1_SR1_TXOK_MASK 0x40U
#define CAN1_SR1_TXOK 0x40U
#define CAN1_SR1_TXOK_BIT 6
#define CAN1_SR1_RFRAME_MASK 0x80U
#define CAN1_SR1_RFRAME 0x80U
#define CAN1_SR1_RFRAME_BIT 7
#define CAN1_SR1_DLCW_MASK 0x200U
#define CAN1_SR1_DLCW 0x200U
#define CAN1_SR1_DLCW_BIT 9
#define CAN1_SR1_FILLED_MASK 0x400U
#define CAN1_SR1_FILLED 0x400U
#define CAN1_SR1_FILLED_BIT 10
#define CAN1_SR1_OVRUN_MASK 0x800U
#define CAN1_SR1_OVRUN 0x800U
#define CAN1_SR1_OVRUN_BIT 11

#define CAN1_IER1 (*(volatile unsigned long *)0xFFFB8160)
#define CAN1_IER1_OFFSET 0x160
#define CAN1_IER1_ACK_MASK 0x1U
#define CAN1_IER1_ACK 0x1U
#define CAN1_IER1_ACK_BIT 0
#define CAN1_IER1_FRAME_MASK 0x2U
#define CAN1_IER1_FRAME 0x2U
#define CAN1_IER1_FRAME_BIT 1
#define CAN1_IER1_CRC_MASK 0x4U
#define CAN1_IER1_CRC 0x4U
#define CAN1_IER1_CRC_BIT 2
#define CAN1_IER1_STUFF_MASK 0x8U
#define CAN1_IER1_STUFF 0x8U
#define CAN1_IER1_STUFF_BIT 3
#define CAN1_IER1_BUS_MASK 0x10U
#define CAN1_IER1_BUS 0x10U
#define CAN1_IER1_BUS_BIT 4
#define CAN1_IER1_RXOK_MASK 0x20U
#define CAN1_IER1_RXOK 0x20U
#define CAN1_IER1_RXOK_BIT 5
#define CAN1_IER1_TXOK_MASK 0x40U
#define CAN1_IER1_TXOK 0x40U
#define CAN1_IER1_TXOK_BIT 6
#define CAN1_IER1_RFRAME_MASK 0x80U
#define CAN1_IER1_RFRAME 0x80U
#define CAN1_IER1_RFRAME_BIT 7

#define CAN1_IDR1 (*(volatile unsigned long *)0xFFFB8164)
#define CAN1_IDR1_OFFSET 0x164
#define CAN1_IDR1_ACK_MASK 0x1U
#define CAN1_IDR1_ACK 0x1U
#define CAN1_IDR1_ACK_BIT 0
#define CAN1_IDR1_FRAME_MASK 0x2U
#define CAN1_IDR1_FRAME 0x2U
#define CAN1_IDR1_FRAME_BIT 1
#define CAN1_IDR1_CRC_MASK 0x4U
#define CAN1_IDR1_CRC 0x4U
#define CAN1_IDR1_CRC_BIT 2
#define CAN1_IDR1_STUFF_MASK 0x8U
#define CAN1_IDR1_STUFF 0x8U
#define CAN1_IDR1_STUFF_BIT 3
#define CAN1_IDR1_BUS_MASK 0x10U
#define CAN1_IDR1_BUS 0x10U
#define CAN1_IDR1_BUS_BIT 4
#define CAN1_IDR1_RXOK_MASK 0x20U
#define CAN1_IDR1_RXOK 0x20U
#define CAN1_IDR1_RXOK_BIT 5
#define CAN1_IDR1_TXOK_MASK 0x40U
#define CAN1_IDR1_TXOK 0x40U
#define CAN1_IDR1_TXOK_BIT 6
#define CAN1_IDR1_RFRAME_MASK 0x80U
#define CAN1_IDR1_RFRAME 0x80U
#define CAN1_IDR1_RFRAME_BIT 7

#define CAN1_IMR1 (*(volatile unsigned long *)0xFFFB8168)
#define CAN1_IMR1_OFFSET 0x168
#define CAN1_IMR1_ACK_MASK 0x1U
#define CAN1_IMR1_ACK 0x1U
#define CAN1_IMR1_ACK_BIT 0
#define CAN1_IMR1_FRAME_MASK 0x2U
#define CAN1_IMR1_FRAME 0x2U
#define CAN1_IMR1_FRAME_BIT 1
#define CAN1_IMR1_CRC_MASK 0x4U
#define CAN1_IMR1_CRC 0x4U
#define CAN1_IMR1_CRC_BIT 2
#define CAN1_IMR1_STUFF_MASK 0x8U
#define CAN1_IMR1_STUFF 0x8U
#define CAN1_IMR1_STUFF_BIT 3
#define CAN1_IMR1_BUS_MASK 0x10U
#define CAN1_IMR1_BUS 0x10U
#define CAN1_IMR1_BUS_BIT 4
#define CAN1_IMR1_RXOK_MASK 0x20U
#define CAN1_IMR1_RXOK 0x20U
#define CAN1_IMR1_RXOK_BIT 5
#define CAN1_IMR1_TXOK_MASK 0x40U
#define CAN1_IMR1_TXOK 0x40U
#define CAN1_IMR1_TXOK_BIT 6
#define CAN1_IMR1_RFRAME_MASK 0x80U
#define CAN1_IMR1_RFRAME 0x80U
#define CAN1_IMR1_RFRAME_BIT 7

#define CAN1_DRA2 (*(volatile unsigned long *)0xFFFB8180)
#define CAN1_DRA2_OFFSET 0x180
#define CAN1_DRA2_DATA0_MASK 0xFFU
#define CAN1_DRA2_DATA0_BIT 0
#define CAN1_DRA2_DATA1_MASK 0xFF00U
#define CAN1_DRA2_DATA1_BIT 8
#define CAN1_DRA2_DATA2_MASK 0xFF0000U
#define CAN1_DRA2_DATA2_BIT 16
#define CAN1_DRA2_DATA3_MASK 0xFF000000U
#define CAN1_DRA2_DATA3_BIT 24

#define CAN1_DRB2 (*(volatile unsigned long *)0xFFFB8184)
#define CAN1_DRB2_OFFSET 0x184
#define CAN1_DRB2_DATA4_MASK 0xFFU
#define CAN1_DRB2_DATA4_BIT 0
#define CAN1_DRB2_DATA5_MASK 0xFF00U
#define CAN1_DRB2_DATA5_BIT 8
#define CAN1_DRB2_DATA6_MASK 0xFF0000U
#define CAN1_DRB2_DATA6_BIT 16
#define CAN1_DRB2_DATA7_MASK 0xFF000000U
#define CAN1_DRB2_DATA7_BIT 24

#define CAN1_MSK2 (*(volatile unsigned long *)0xFFFB8188)
#define CAN1_MSK2_OFFSET 0x188
#define CAN1_MSK2_MASK_MASK 0x1FFFFFFFU
#define CAN1_MSK2_MASK_BIT 0
#define CAN1_MSK2_MRB_MASK 0x60000000U
#define CAN1_MSK2_MRB_BIT 29
#define CAN1_MSK2_MRTR_MASK 0x80000000U
#define CAN1_MSK2_MRTR 0x80000000U
#define CAN1_MSK2_MRTR_BIT 31

#define CAN1_IR2 (*(volatile unsigned long *)0xFFFB818C)
#define CAN1_IR2_OFFSET 0x18C
#define CAN1_IR2_ID_MASK 0x1FFFFFFFU
#define CAN1_IR2_ID_BIT 0
#define CAN1_IR2_RB_MASK 0x60000000U
#define CAN1_IR2_RB_BIT 29
#define CAN1_IR2_RTR_MASK 0x80000000U
#define CAN1_IR2_RTR 0x80000000U
#define CAN1_IR2_RTR_BIT 31

#define CAN1_CR2 (*(volatile unsigned long *)0xFFFB8190)
#define CAN1_CR2_OFFSET 0x190
#define CAN1_CR2_DLC_MASK 0xFU
#define CAN1_CR2_DLC_BIT 0
#define CAN1_CR2_IDE_MASK 0x10U
#define CAN1_CR2_IDE 0x10U
#define CAN1_CR2_IDE_BIT 4
#define CAN1_CR2_RPLYV_MASK 0x20U
#define CAN1_CR2_RPLYV 0x20U
#define CAN1_CR2_RPLYV_BIT 5
#define CAN1_CR2_PCB_MASK 0x40U
#define CAN1_CR2_PCB 0x40U
#define CAN1_CR2_PCB_BIT 6
#define CAN1_CR2_CHANEN_MASK 0x80U
#define CAN1_CR2_CHANEN 0x80U
#define CAN1_CR2_CHANEN_BIT 7
#define CAN1_CR2_OVERWRITE_MASK 0x100U
#define CAN1_CR2_OVERWRITE 0x100U
#define CAN1_CR2_OVERWRITE_BIT 8

#define CAN1_CR2 (*(volatile unsigned long *)0xFFFB8194)
#define CAN1_CR2_OFFSET 0x194
#define CAN1_CR2_STAMP_MASK 0x0U
#define CAN1_CR2_STAMP_BIT 0

#define CAN1_CSR2 (*(volatile unsigned long *)0xFFFB8198)
#define CAN1_CSR2_OFFSET 0x198
#define CAN1_CSR2_ACK_MASK 0x1U
#define CAN1_CSR2_ACK 0x1U
#define CAN1_CSR2_ACK_BIT 0
#define CAN1_CSR2_FRAME_MASK 0x2U
#define CAN1_CSR2_FRAME 0x2U
#define CAN1_CSR2_FRAME_BIT 1
#define CAN1_CSR2_CRC_MASK 0x4U
#define CAN1_CSR2_CRC 0x4U
#define CAN1_CSR2_CRC_BIT 2
#define CAN1_CSR2_STUFF_MASK 0x8U
#define CAN1_CSR2_STUFF 0x8U
#define CAN1_CSR2_STUFF_BIT 3
#define CAN1_CSR2_BUS_MASK 0x10U
#define CAN1_CSR2_BUS 0x10U
#define CAN1_CSR2_BUS_BIT 4
#define CAN1_CSR2_RXOK_MASK 0x20U
#define CAN1_CSR2_RXOK 0x20U
#define CAN1_CSR2_RXOK_BIT 5
#define CAN1_CSR2_TXOK_MASK 0x40U
#define CAN1_CSR2_TXOK 0x40U
#define CAN1_CSR2_TXOK_BIT 6
#define CAN1_CSR2_RFRAME_MASK 0x80U
#define CAN1_CSR2_RFRAME 0x80U
#define CAN1_CSR2_RFRAME_BIT 7
#define CAN1_CSR2_DLCW_MASK 0x200U
#define CAN1_CSR2_DLCW 0x200U
#define CAN1_CSR2_DLCW_BIT 9
#define CAN1_CSR2_FILLED_MASK 0x400U
#define CAN1_CSR2_FILLED 0x400U
#define CAN1_CSR2_FILLED_BIT 10
#define CAN1_CSR2_OVRUN_MASK 0x800U
#define CAN1_CSR2_OVRUN 0x800U
#define CAN1_CSR2_OVRUN_BIT 11

#define CAN1_SR2 (*(volatile unsigned long *)0xFFFB819C)
#define CAN1_SR2_OFFSET 0x19C
#define CAN1_SR2_ACK_MASK 0x1U
#define CAN1_SR2_ACK 0x1U
#define CAN1_SR2_ACK_BIT 0
#define CAN1_SR2_FRAME_MASK 0x2U
#define CAN1_SR2_FRAME 0x2U
#define CAN1_SR2_FRAME_BIT 1
#define CAN1_SR2_CRC_MASK 0x4U
#define CAN1_SR2_CRC 0x4U
#define CAN1_SR2_CRC_BIT 2
#define CAN1_SR2_STUFF_MASK 0x8U
#define CAN1_SR2_STUFF 0x8U
#define CAN1_SR2_STUFF_BIT 3
#define CAN1_SR2_BUS_MASK 0x10U
#define CAN1_SR2_BUS 0x10U
#define CAN1_SR2_BUS_BIT 4
#define CAN1_SR2_RXOK_MASK 0x20U
#define CAN1_SR2_RXOK 0x20U
#define CAN1_SR2_RXOK_BIT 5
#define CAN1_SR2_TXOK_MASK 0x40U
#define CAN1_SR2_TXOK 0x40U
#define CAN1_SR2_TXOK_BIT 6
#define CAN1_SR2_RFRAME_MASK 0x80U
#define CAN1_SR2_RFRAME 0x80U
#define CAN1_SR2_RFRAME_BIT 7
#define CAN1_SR2_DLCW_MASK 0x200U
#define CAN1_SR2_DLCW 0x200U
#define CAN1_SR2_DLCW_BIT 9
#define CAN1_SR2_FILLED_MASK 0x400U
#define CAN1_SR2_FILLED 0x400U
#define CAN1_SR2_FILLED_BIT 10
#define CAN1_SR2_OVRUN_MASK 0x800U
#define CAN1_SR2_OVRUN 0x800U
#define CAN1_SR2_OVRUN_BIT 11

#define CAN1_IER2 (*(volatile unsigned long *)0xFFFB81A0)
#define CAN1_IER2_OFFSET 0x1A0
#define CAN1_IER2_ACK_MASK 0x1U
#define CAN1_IER2_ACK 0x1U
#define CAN1_IER2_ACK_BIT 0
#define CAN1_IER2_FRAME_MASK 0x2U
#define CAN1_IER2_FRAME 0x2U
#define CAN1_IER2_FRAME_BIT 1
#define CAN1_IER2_CRC_MASK 0x4U
#define CAN1_IER2_CRC 0x4U
#define CAN1_IER2_CRC_BIT 2
#define CAN1_IER2_STUFF_MASK 0x8U
#define CAN1_IER2_STUFF 0x8U
#define CAN1_IER2_STUFF_BIT 3
#define CAN1_IER2_BUS_MASK 0x10U
#define CAN1_IER2_BUS 0x10U
#define CAN1_IER2_BUS_BIT 4
#define CAN1_IER2_RXOK_MASK 0x20U
#define CAN1_IER2_RXOK 0x20U
#define CAN1_IER2_RXOK_BIT 5
#define CAN1_IER2_TXOK_MASK 0x40U
#define CAN1_IER2_TXOK 0x40U
#define CAN1_IER2_TXOK_BIT 6
#define CAN1_IER2_RFRAME_MASK 0x80U
#define CAN1_IER2_RFRAME 0x80U
#define CAN1_IER2_RFRAME_BIT 7

#define CAN1_IDR2 (*(volatile unsigned long *)0xFFFB81A4)
#define CAN1_IDR2_OFFSET 0x1A4
#define CAN1_IDR2_ACK_MASK 0x1U
#define CAN1_IDR2_ACK 0x1U
#define CAN1_IDR2_ACK_BIT 0
#define CAN1_IDR2_FRAME_MASK 0x2U
#define CAN1_IDR2_FRAME 0x2U
#define CAN1_IDR2_FRAME_BIT 1
#define CAN1_IDR2_CRC_MASK 0x4U
#define CAN1_IDR2_CRC 0x4U
#define CAN1_IDR2_CRC_BIT 2
#define CAN1_IDR2_STUFF_MASK 0x8U
#define CAN1_IDR2_STUFF 0x8U
#define CAN1_IDR2_STUFF_BIT 3
#define CAN1_IDR2_BUS_MASK 0x10U
#define CAN1_IDR2_BUS 0x10U
#define CAN1_IDR2_BUS_BIT 4
#define CAN1_IDR2_RXOK_MASK 0x20U
#define CAN1_IDR2_RXOK 0x20U
#define CAN1_IDR2_RXOK_BIT 5
#define CAN1_IDR2_TXOK_MASK 0x40U
#define CAN1_IDR2_TXOK 0x40U
#define CAN1_IDR2_TXOK_BIT 6
#define CAN1_IDR2_RFRAME_MASK 0x80U
#define CAN1_IDR2_RFRAME 0x80U
#define CAN1_IDR2_RFRAME_BIT 7

#define CAN1_IMR2 (*(volatile unsigned long *)0xFFFB81A8)
#define CAN1_IMR2_OFFSET 0x1A8
#define CAN1_IMR2_ACK_MASK 0x1U
#define CAN1_IMR2_ACK 0x1U
#define CAN1_IMR2_ACK_BIT 0
#define CAN1_IMR2_FRAME_MASK 0x2U
#define CAN1_IMR2_FRAME 0x2U
#define CAN1_IMR2_FRAME_BIT 1
#define CAN1_IMR2_CRC_MASK 0x4U
#define CAN1_IMR2_CRC 0x4U
#define CAN1_IMR2_CRC_BIT 2
#define CAN1_IMR2_STUFF_MASK 0x8U
#define CAN1_IMR2_STUFF 0x8U
#define CAN1_IMR2_STUFF_BIT 3
#define CAN1_IMR2_BUS_MASK 0x10U
#define CAN1_IMR2_BUS 0x10U
#define CAN1_IMR2_BUS_BIT 4
#define CAN1_IMR2_RXOK_MASK 0x20U
#define CAN1_IMR2_RXOK 0x20U
#define CAN1_IMR2_RXOK_BIT 5
#define CAN1_IMR2_TXOK_MASK 0x40U
#define CAN1_IMR2_TXOK 0x40U
#define CAN1_IMR2_TXOK_BIT 6
#define CAN1_IMR2_RFRAME_MASK 0x80U
#define CAN1_IMR2_RFRAME 0x80U
#define CAN1_IMR2_RFRAME_BIT 7

#define CAN1_DRA3 (*(volatile unsigned long *)0xFFFB81C0)
#define CAN1_DRA3_OFFSET 0x1C0
#define CAN1_DRA3_DATA0_MASK 0xFFU
#define CAN1_DRA3_DATA0_BIT 0
#define CAN1_DRA3_DATA1_MASK 0xFF00U
#define CAN1_DRA3_DATA1_BIT 8
#define CAN1_DRA3_DATA2_MASK 0xFF0000U
#define CAN1_DRA3_DATA2_BIT 16
#define CAN1_DRA3_DATA3_MASK 0xFF000000U
#define CAN1_DRA3_DATA3_BIT 24

#define CAN1_DRB3 (*(volatile unsigned long *)0xFFFB81C4)
#define CAN1_DRB3_OFFSET 0x1C4
#define CAN1_DRB3_DATA4_MASK 0xFFU
#define CAN1_DRB3_DATA4_BIT 0
#define CAN1_DRB3_DATA5_MASK 0xFF00U
#define CAN1_DRB3_DATA5_BIT 8
#define CAN1_DRB3_DATA6_MASK 0xFF0000U
#define CAN1_DRB3_DATA6_BIT 16
#define CAN1_DRB3_DATA7_MASK 0xFF000000U
#define CAN1_DRB3_DATA7_BIT 24

#define CAN1_MSK3 (*(volatile unsigned long *)0xFFFB81C8)
#define CAN1_MSK3_OFFSET 0x1C8
#define CAN1_MSK3_MASK_MASK 0x1FFFFFFFU
#define CAN1_MSK3_MASK_BIT 0
#define CAN1_MSK3_MRB_MASK 0x60000000U
#define CAN1_MSK3_MRB_BIT 29
#define CAN1_MSK3_MRTR_MASK 0x80000000U
#define CAN1_MSK3_MRTR 0x80000000U
#define CAN1_MSK3_MRTR_BIT 31

#define CAN1_IR3 (*(volatile unsigned long *)0xFFFB81CC)
#define CAN1_IR3_OFFSET 0x1CC
#define CAN1_IR3_ID_MASK 0x1FFFFFFFU
#define CAN1_IR3_ID_BIT 0
#define CAN1_IR3_RB_MASK 0x60000000U
#define CAN1_IR3_RB_BIT 29
#define CAN1_IR3_RTR_MASK 0x80000000U
#define CAN1_IR3_RTR 0x80000000U
#define CAN1_IR3_RTR_BIT 31

#define CAN1_CR3 (*(volatile unsigned long *)0xFFFB81D0)
#define CAN1_CR3_OFFSET 0x1D0
#define CAN1_CR3_DLC_MASK 0xFU
#define CAN1_CR3_DLC_BIT 0
#define CAN1_CR3_IDE_MASK 0x10U
#define CAN1_CR3_IDE 0x10U
#define CAN1_CR3_IDE_BIT 4
#define CAN1_CR3_RPLYV_MASK 0x20U
#define CAN1_CR3_RPLYV 0x20U
#define CAN1_CR3_RPLYV_BIT 5
#define CAN1_CR3_PCB_MASK 0x40U
#define CAN1_CR3_PCB 0x40U
#define CAN1_CR3_PCB_BIT 6
#define CAN1_CR3_CHANEN_MASK 0x80U
#define CAN1_CR3_CHANEN 0x80U
#define CAN1_CR3_CHANEN_BIT 7
#define CAN1_CR3_OVERWRITE_MASK 0x100U
#define CAN1_CR3_OVERWRITE 0x100U
#define CAN1_CR3_OVERWRITE_BIT 8

#define CAN1_CR3 (*(volatile unsigned long *)0xFFFB81D4)
#define CAN1_CR3_OFFSET 0x1D4
#define CAN1_CR3_STAMP_MASK 0x0U
#define CAN1_CR3_STAMP_BIT 0

#define CAN1_CSR3 (*(volatile unsigned long *)0xFFFB81D8)
#define CAN1_CSR3_OFFSET 0x1D8
#define CAN1_CSR3_ACK_MASK 0x1U
#define CAN1_CSR3_ACK 0x1U
#define CAN1_CSR3_ACK_BIT 0
#define CAN1_CSR3_FRAME_MASK 0x2U
#define CAN1_CSR3_FRAME 0x2U
#define CAN1_CSR3_FRAME_BIT 1
#define CAN1_CSR3_CRC_MASK 0x4U
#define CAN1_CSR3_CRC 0x4U
#define CAN1_CSR3_CRC_BIT 2
#define CAN1_CSR3_STUFF_MASK 0x8U
#define CAN1_CSR3_STUFF 0x8U
#define CAN1_CSR3_STUFF_BIT 3
#define CAN1_CSR3_BUS_MASK 0x10U
#define CAN1_CSR3_BUS 0x10U
#define CAN1_CSR3_BUS_BIT 4
#define CAN1_CSR3_RXOK_MASK 0x20U
#define CAN1_CSR3_RXOK 0x20U
#define CAN1_CSR3_RXOK_BIT 5
#define CAN1_CSR3_TXOK_MASK 0x40U
#define CAN1_CSR3_TXOK 0x40U
#define CAN1_CSR3_TXOK_BIT 6
#define CAN1_CSR3_RFRAME_MASK 0x80U
#define CAN1_CSR3_RFRAME 0x80U
#define CAN1_CSR3_RFRAME_BIT 7
#define CAN1_CSR3_DLCW_MASK 0x200U
#define CAN1_CSR3_DLCW 0x200U
#define CAN1_CSR3_DLCW_BIT 9
#define CAN1_CSR3_FILLED_MASK 0x400U
#define CAN1_CSR3_FILLED 0x400U
#define CAN1_CSR3_FILLED_BIT 10
#define CAN1_CSR3_OVRUN_MASK 0x800U
#define CAN1_CSR3_OVRUN 0x800U
#define CAN1_CSR3_OVRUN_BIT 11

#define CAN1_SR3 (*(volatile unsigned long *)0xFFFB81DC)
#define CAN1_SR3_OFFSET 0x1DC
#define CAN1_SR3_ACK_MASK 0x1U
#define CAN1_SR3_ACK 0x1U
#define CAN1_SR3_ACK_BIT 0
#define CAN1_SR3_FRAME_MASK 0x2U
#define CAN1_SR3_FRAME 0x2U
#define CAN1_SR3_FRAME_BIT 1
#define CAN1_SR3_CRC_MASK 0x4U
#define CAN1_SR3_CRC 0x4U
#define CAN1_SR3_CRC_BIT 2
#define CAN1_SR3_STUFF_MASK 0x8U
#define CAN1_SR3_STUFF 0x8U
#define CAN1_SR3_STUFF_BIT 3
#define CAN1_SR3_BUS_MASK 0x10U
#define CAN1_SR3_BUS 0x10U
#define CAN1_SR3_BUS_BIT 4
#define CAN1_SR3_RXOK_MASK 0x20U
#define CAN1_SR3_RXOK 0x20U
#define CAN1_SR3_RXOK_BIT 5
#define CAN1_SR3_TXOK_MASK 0x40U
#define CAN1_SR3_TXOK 0x40U
#define CAN1_SR3_TXOK_BIT 6
#define CAN1_SR3_RFRAME_MASK 0x80U
#define CAN1_SR3_RFRAME 0x80U
#define CAN1_SR3_RFRAME_BIT 7
#define CAN1_SR3_DLCW_MASK 0x200U
#define CAN1_SR3_DLCW 0x200U
#define CAN1_SR3_DLCW_BIT 9
#define CAN1_SR3_FILLED_MASK 0x400U
#define CAN1_SR3_FILLED 0x400U
#define CAN1_SR3_FILLED_BIT 10
#define CAN1_SR3_OVRUN_MASK 0x800U
#define CAN1_SR3_OVRUN 0x800U
#define CAN1_SR3_OVRUN_BIT 11

#define CAN1_IER3 (*(volatile unsigned long *)0xFFFB81E0)
#define CAN1_IER3_OFFSET 0x1E0
#define CAN1_IER3_ACK_MASK 0x1U
#define CAN1_IER3_ACK 0x1U
#define CAN1_IER3_ACK_BIT 0
#define CAN1_IER3_FRAME_MASK 0x2U
#define CAN1_IER3_FRAME 0x2U
#define CAN1_IER3_FRAME_BIT 1
#define CAN1_IER3_CRC_MASK 0x4U
#define CAN1_IER3_CRC 0x4U
#define CAN1_IER3_CRC_BIT 2
#define CAN1_IER3_STUFF_MASK 0x8U
#define CAN1_IER3_STUFF 0x8U
#define CAN1_IER3_STUFF_BIT 3
#define CAN1_IER3_BUS_MASK 0x10U
#define CAN1_IER3_BUS 0x10U
#define CAN1_IER3_BUS_BIT 4
#define CAN1_IER3_RXOK_MASK 0x20U
#define CAN1_IER3_RXOK 0x20U
#define CAN1_IER3_RXOK_BIT 5
#define CAN1_IER3_TXOK_MASK 0x40U
#define CAN1_IER3_TXOK 0x40U
#define CAN1_IER3_TXOK_BIT 6
#define CAN1_IER3_RFRAME_MASK 0x80U
#define CAN1_IER3_RFRAME 0x80U
#define CAN1_IER3_RFRAME_BIT 7

#define CAN1_IDR3 (*(volatile unsigned long *)0xFFFB81E4)
#define CAN1_IDR3_OFFSET 0x1E4
#define CAN1_IDR3_ACK_MASK 0x1U
#define CAN1_IDR3_ACK 0x1U
#define CAN1_IDR3_ACK_BIT 0
#define CAN1_IDR3_FRAME_MASK 0x2U
#define CAN1_IDR3_FRAME 0x2U
#define CAN1_IDR3_FRAME_BIT 1
#define CAN1_IDR3_CRC_MASK 0x4U
#define CAN1_IDR3_CRC 0x4U
#define CAN1_IDR3_CRC_BIT 2
#define CAN1_IDR3_STUFF_MASK 0x8U
#define CAN1_IDR3_STUFF 0x8U
#define CAN1_IDR3_STUFF_BIT 3
#define CAN1_IDR3_BUS_MASK 0x10U
#define CAN1_IDR3_BUS 0x10U
#define CAN1_IDR3_BUS_BIT 4
#define CAN1_IDR3_RXOK_MASK 0x20U
#define CAN1_IDR3_RXOK 0x20U
#define CAN1_IDR3_RXOK_BIT 5
#define CAN1_IDR3_TXOK_MASK 0x40U
#define CAN1_IDR3_TXOK 0x40U
#define CAN1_IDR3_TXOK_BIT 6
#define CAN1_IDR3_RFRAME_MASK 0x80U
#define CAN1_IDR3_RFRAME 0x80U
#define CAN1_IDR3_RFRAME_BIT 7

#define CAN1_IMR3 (*(volatile unsigned long *)0xFFFB81E8)
#define CAN1_IMR3_OFFSET 0x1E8
#define CAN1_IMR3_ACK_MASK 0x1U
#define CAN1_IMR3_ACK 0x1U
#define CAN1_IMR3_ACK_BIT 0
#define CAN1_IMR3_FRAME_MASK 0x2U
#define CAN1_IMR3_FRAME 0x2U
#define CAN1_IMR3_FRAME_BIT 1
#define CAN1_IMR3_CRC_MASK 0x4U
#define CAN1_IMR3_CRC 0x4U
#define CAN1_IMR3_CRC_BIT 2
#define CAN1_IMR3_STUFF_MASK 0x8U
#define CAN1_IMR3_STUFF 0x8U
#define CAN1_IMR3_STUFF_BIT 3
#define CAN1_IMR3_BUS_MASK 0x10U
#define CAN1_IMR3_BUS 0x10U
#define CAN1_IMR3_BUS_BIT 4
#define CAN1_IMR3_RXOK_MASK 0x20U
#define CAN1_IMR3_RXOK 0x20U
#define CAN1_IMR3_RXOK_BIT 5
#define CAN1_IMR3_TXOK_MASK 0x40U
#define CAN1_IMR3_TXOK 0x40U
#define CAN1_IMR3_TXOK_BIT 6
#define CAN1_IMR3_RFRAME_MASK 0x80U
#define CAN1_IMR3_RFRAME 0x80U
#define CAN1_IMR3_RFRAME_BIT 7

#define CAN1_DRA4 (*(volatile unsigned long *)0xFFFB8200)
#define CAN1_DRA4_OFFSET 0x200
#define CAN1_DRA4_DATA0_MASK 0xFFU
#define CAN1_DRA4_DATA0_BIT 0
#define CAN1_DRA4_DATA1_MASK 0xFF00U
#define CAN1_DRA4_DATA1_BIT 8
#define CAN1_DRA4_DATA2_MASK 0xFF0000U
#define CAN1_DRA4_DATA2_BIT 16
#define CAN1_DRA4_DATA3_MASK 0xFF000000U
#define CAN1_DRA4_DATA3_BIT 24

#define CAN1_DRB4 (*(volatile unsigned long *)0xFFFB8204)
#define CAN1_DRB4_OFFSET 0x204
#define CAN1_DRB4_DATA4_MASK 0xFFU
#define CAN1_DRB4_DATA4_BIT 0
#define CAN1_DRB4_DATA5_MASK 0xFF00U
#define CAN1_DRB4_DATA5_BIT 8
#define CAN1_DRB4_DATA6_MASK 0xFF0000U
#define CAN1_DRB4_DATA6_BIT 16
#define CAN1_DRB4_DATA7_MASK 0xFF000000U
#define CAN1_DRB4_DATA7_BIT 24

#define CAN1_MSK4 (*(volatile unsigned long *)0xFFFB8208)
#define CAN1_MSK4_OFFSET 0x208
#define CAN1_MSK4_MASK_MASK 0x1FFFFFFFU
#define CAN1_MSK4_MASK_BIT 0
#define CAN1_MSK4_MRB_MASK 0x60000000U
#define CAN1_MSK4_MRB_BIT 29
#define CAN1_MSK4_MRTR_MASK 0x80000000U
#define CAN1_MSK4_MRTR 0x80000000U
#define CAN1_MSK4_MRTR_BIT 31

#define CAN1_IR4 (*(volatile unsigned long *)0xFFFB820C)
#define CAN1_IR4_OFFSET 0x20C
#define CAN1_IR4_ID_MASK 0x1FFFFFFFU
#define CAN1_IR4_ID_BIT 0
#define CAN1_IR4_RB_MASK 0x60000000U
#define CAN1_IR4_RB_BIT 29
#define CAN1_IR4_RTR_MASK 0x80000000U
#define CAN1_IR4_RTR 0x80000000U
#define CAN1_IR4_RTR_BIT 31

#define CAN1_CR4 (*(volatile unsigned long *)0xFFFB8210)
#define CAN1_CR4_OFFSET 0x210
#define CAN1_CR4_DLC_MASK 0xFU
#define CAN1_CR4_DLC_BIT 0
#define CAN1_CR4_IDE_MASK 0x10U
#define CAN1_CR4_IDE 0x10U
#define CAN1_CR4_IDE_BIT 4
#define CAN1_CR4_RPLYV_MASK 0x20U
#define CAN1_CR4_RPLYV 0x20U
#define CAN1_CR4_RPLYV_BIT 5
#define CAN1_CR4_PCB_MASK 0x40U
#define CAN1_CR4_PCB 0x40U
#define CAN1_CR4_PCB_BIT 6
#define CAN1_CR4_CHANEN_MASK 0x80U
#define CAN1_CR4_CHANEN 0x80U
#define CAN1_CR4_CHANEN_BIT 7
#define CAN1_CR4_OVERWRITE_MASK 0x100U
#define CAN1_CR4_OVERWRITE 0x100U
#define CAN1_CR4_OVERWRITE_BIT 8

#define CAN1_CR4 (*(volatile unsigned long *)0xFFFB8214)
#define CAN1_CR4_OFFSET 0x214
#define CAN1_CR4_STAMP_MASK 0x0U
#define CAN1_CR4_STAMP_BIT 0

#define CAN1_CSR4 (*(volatile unsigned long *)0xFFFB8218)
#define CAN1_CSR4_OFFSET 0x218
#define CAN1_CSR4_ACK_MASK 0x1U
#define CAN1_CSR4_ACK 0x1U
#define CAN1_CSR4_ACK_BIT 0
#define CAN1_CSR4_FRAME_MASK 0x2U
#define CAN1_CSR4_FRAME 0x2U
#define CAN1_CSR4_FRAME_BIT 1
#define CAN1_CSR4_CRC_MASK 0x4U
#define CAN1_CSR4_CRC 0x4U
#define CAN1_CSR4_CRC_BIT 2
#define CAN1_CSR4_STUFF_MASK 0x8U
#define CAN1_CSR4_STUFF 0x8U
#define CAN1_CSR4_STUFF_BIT 3
#define CAN1_CSR4_BUS_MASK 0x10U
#define CAN1_CSR4_BUS 0x10U
#define CAN1_CSR4_BUS_BIT 4
#define CAN1_CSR4_RXOK_MASK 0x20U
#define CAN1_CSR4_RXOK 0x20U
#define CAN1_CSR4_RXOK_BIT 5
#define CAN1_CSR4_TXOK_MASK 0x40U
#define CAN1_CSR4_TXOK 0x40U
#define CAN1_CSR4_TXOK_BIT 6
#define CAN1_CSR4_RFRAME_MASK 0x80U
#define CAN1_CSR4_RFRAME 0x80U
#define CAN1_CSR4_RFRAME_BIT 7
#define CAN1_CSR4_DLCW_MASK 0x200U
#define CAN1_CSR4_DLCW 0x200U
#define CAN1_CSR4_DLCW_BIT 9
#define CAN1_CSR4_FILLED_MASK 0x400U
#define CAN1_CSR4_FILLED 0x400U
#define CAN1_CSR4_FILLED_BIT 10
#define CAN1_CSR4_OVRUN_MASK 0x800U
#define CAN1_CSR4_OVRUN 0x800U
#define CAN1_CSR4_OVRUN_BIT 11

#define CAN1_SR4 (*(volatile unsigned long *)0xFFFB821C)
#define CAN1_SR4_OFFSET 0x21C
#define CAN1_SR4_ACK_MASK 0x1U
#define CAN1_SR4_ACK 0x1U
#define CAN1_SR4_ACK_BIT 0
#define CAN1_SR4_FRAME_MASK 0x2U
#define CAN1_SR4_FRAME 0x2U
#define CAN1_SR4_FRAME_BIT 1
#define CAN1_SR4_CRC_MASK 0x4U
#define CAN1_SR4_CRC 0x4U
#define CAN1_SR4_CRC_BIT 2
#define CAN1_SR4_STUFF_MASK 0x8U
#define CAN1_SR4_STUFF 0x8U
#define CAN1_SR4_STUFF_BIT 3
#define CAN1_SR4_BUS_MASK 0x10U
#define CAN1_SR4_BUS 0x10U
#define CAN1_SR4_BUS_BIT 4
#define CAN1_SR4_RXOK_MASK 0x20U
#define CAN1_SR4_RXOK 0x20U
#define CAN1_SR4_RXOK_BIT 5
#define CAN1_SR4_TXOK_MASK 0x40U
#define CAN1_SR4_TXOK 0x40U
#define CAN1_SR4_TXOK_BIT 6
#define CAN1_SR4_RFRAME_MASK 0x80U
#define CAN1_SR4_RFRAME 0x80U
#define CAN1_SR4_RFRAME_BIT 7
#define CAN1_SR4_DLCW_MASK 0x200U
#define CAN1_SR4_DLCW 0x200U
#define CAN1_SR4_DLCW_BIT 9
#define CAN1_SR4_FILLED_MASK 0x400U
#define CAN1_SR4_FILLED 0x400U
#define CAN1_SR4_FILLED_BIT 10
#define CAN1_SR4_OVRUN_MASK 0x800U
#define CAN1_SR4_OVRUN 0x800U
#define CAN1_SR4_OVRUN_BIT 11

#define CAN1_IER4 (*(volatile unsigned long *)0xFFFB8220)
#define CAN1_IER4_OFFSET 0x220
#define CAN1_IER4_ACK_MASK 0x1U
#define CAN1_IER4_ACK 0x1U
#define CAN1_IER4_ACK_BIT 0
#define CAN1_IER4_FRAME_MASK 0x2U
#define CAN1_IER4_FRAME 0x2U
#define CAN1_IER4_FRAME_BIT 1
#define CAN1_IER4_CRC_MASK 0x4U
#define CAN1_IER4_CRC 0x4U
#define CAN1_IER4_CRC_BIT 2
#define CAN1_IER4_STUFF_MASK 0x8U
#define CAN1_IER4_STUFF 0x8U
#define CAN1_IER4_STUFF_BIT 3
#define CAN1_IER4_BUS_MASK 0x10U
#define CAN1_IER4_BUS 0x10U
#define CAN1_IER4_BUS_BIT 4
#define CAN1_IER4_RXOK_MASK 0x20U
#define CAN1_IER4_RXOK 0x20U
#define CAN1_IER4_RXOK_BIT 5
#define CAN1_IER4_TXOK_MASK 0x40U
#define CAN1_IER4_TXOK 0x40U
#define CAN1_IER4_TXOK_BIT 6
#define CAN1_IER4_RFRAME_MASK 0x80U
#define CAN1_IER4_RFRAME 0x80U
#define CAN1_IER4_RFRAME_BIT 7

#define CAN1_IDR4 (*(volatile unsigned long *)0xFFFB8224)
#define CAN1_IDR4_OFFSET 0x224
#define CAN1_IDR4_ACK_MASK 0x1U
#define CAN1_IDR4_ACK 0x1U
#define CAN1_IDR4_ACK_BIT 0
#define CAN1_IDR4_FRAME_MASK 0x2U
#define CAN1_IDR4_FRAME 0x2U
#define CAN1_IDR4_FRAME_BIT 1
#define CAN1_IDR4_CRC_MASK 0x4U
#define CAN1_IDR4_CRC 0x4U
#define CAN1_IDR4_CRC_BIT 2
#define CAN1_IDR4_STUFF_MASK 0x8U
#define CAN1_IDR4_STUFF 0x8U
#define CAN1_IDR4_STUFF_BIT 3
#define CAN1_IDR4_BUS_MASK 0x10U
#define CAN1_IDR4_BUS 0x10U
#define CAN1_IDR4_BUS_BIT 4
#define CAN1_IDR4_RXOK_MASK 0x20U
#define CAN1_IDR4_RXOK 0x20U
#define CAN1_IDR4_RXOK_BIT 5
#define CAN1_IDR4_TXOK_MASK 0x40U
#define CAN1_IDR4_TXOK 0x40U
#define CAN1_IDR4_TXOK_BIT 6
#define CAN1_IDR4_RFRAME_MASK 0x80U
#define CAN1_IDR4_RFRAME 0x80U
#define CAN1_IDR4_RFRAME_BIT 7

#define CAN1_IMR4 (*(volatile unsigned long *)0xFFFB8228)
#define CAN1_IMR4_OFFSET 0x228
#define CAN1_IMR4_ACK_MASK 0x1U
#define CAN1_IMR4_ACK 0x1U
#define CAN1_IMR4_ACK_BIT 0
#define CAN1_IMR4_FRAME_MASK 0x2U
#define CAN1_IMR4_FRAME 0x2U
#define CAN1_IMR4_FRAME_BIT 1
#define CAN1_IMR4_CRC_MASK 0x4U
#define CAN1_IMR4_CRC 0x4U
#define CAN1_IMR4_CRC_BIT 2
#define CAN1_IMR4_STUFF_MASK 0x8U
#define CAN1_IMR4_STUFF 0x8U
#define CAN1_IMR4_STUFF_BIT 3
#define CAN1_IMR4_BUS_MASK 0x10U
#define CAN1_IMR4_BUS 0x10U
#define CAN1_IMR4_BUS_BIT 4
#define CAN1_IMR4_RXOK_MASK 0x20U
#define CAN1_IMR4_RXOK 0x20U
#define CAN1_IMR4_RXOK_BIT 5
#define CAN1_IMR4_TXOK_MASK 0x40U
#define CAN1_IMR4_TXOK 0x40U
#define CAN1_IMR4_TXOK_BIT 6
#define CAN1_IMR4_RFRAME_MASK 0x80U
#define CAN1_IMR4_RFRAME 0x80U
#define CAN1_IMR4_RFRAME_BIT 7

#define CAN1_DRA5 (*(volatile unsigned long *)0xFFFB8240)
#define CAN1_DRA5_OFFSET 0x240
#define CAN1_DRA5_DATA0_MASK 0xFFU
#define CAN1_DRA5_DATA0_BIT 0
#define CAN1_DRA5_DATA1_MASK 0xFF00U
#define CAN1_DRA5_DATA1_BIT 8
#define CAN1_DRA5_DATA2_MASK 0xFF0000U
#define CAN1_DRA5_DATA2_BIT 16
#define CAN1_DRA5_DATA3_MASK 0xFF000000U
#define CAN1_DRA5_DATA3_BIT 24

#define CAN1_DRB5 (*(volatile unsigned long *)0xFFFB8244)
#define CAN1_DRB5_OFFSET 0x244
#define CAN1_DRB5_DATA4_MASK 0xFFU
#define CAN1_DRB5_DATA4_BIT 0
#define CAN1_DRB5_DATA5_MASK 0xFF00U
#define CAN1_DRB5_DATA5_BIT 8
#define CAN1_DRB5_DATA6_MASK 0xFF0000U
#define CAN1_DRB5_DATA6_BIT 16
#define CAN1_DRB5_DATA7_MASK 0xFF000000U
#define CAN1_DRB5_DATA7_BIT 24

#define CAN1_MSK5 (*(volatile unsigned long *)0xFFFB8248)
#define CAN1_MSK5_OFFSET 0x248
#define CAN1_MSK5_MASK_MASK 0x1FFFFFFFU
#define CAN1_MSK5_MASK_BIT 0
#define CAN1_MSK5_MRB_MASK 0x60000000U
#define CAN1_MSK5_MRB_BIT 29
#define CAN1_MSK5_MRTR_MASK 0x80000000U
#define CAN1_MSK5_MRTR 0x80000000U
#define CAN1_MSK5_MRTR_BIT 31

#define CAN1_IR5 (*(volatile unsigned long *)0xFFFB824C)
#define CAN1_IR5_OFFSET 0x24C
#define CAN1_IR5_ID_MASK 0x1FFFFFFFU
#define CAN1_IR5_ID_BIT 0
#define CAN1_IR5_RB_MASK 0x60000000U
#define CAN1_IR5_RB_BIT 29
#define CAN1_IR5_RTR_MASK 0x80000000U
#define CAN1_IR5_RTR 0x80000000U
#define CAN1_IR5_RTR_BIT 31

#define CAN1_CR5 (*(volatile unsigned long *)0xFFFB8250)
#define CAN1_CR5_OFFSET 0x250
#define CAN1_CR5_DLC_MASK 0xFU
#define CAN1_CR5_DLC_BIT 0
#define CAN1_CR5_IDE_MASK 0x10U
#define CAN1_CR5_IDE 0x10U
#define CAN1_CR5_IDE_BIT 4
#define CAN1_CR5_RPLYV_MASK 0x20U
#define CAN1_CR5_RPLYV 0x20U
#define CAN1_CR5_RPLYV_BIT 5
#define CAN1_CR5_PCB_MASK 0x40U
#define CAN1_CR5_PCB 0x40U
#define CAN1_CR5_PCB_BIT 6
#define CAN1_CR5_CHANEN_MASK 0x80U
#define CAN1_CR5_CHANEN 0x80U
#define CAN1_CR5_CHANEN_BIT 7
#define CAN1_CR5_OVERWRITE_MASK 0x100U
#define CAN1_CR5_OVERWRITE 0x100U
#define CAN1_CR5_OVERWRITE_BIT 8

#define CAN1_CR5 (*(volatile unsigned long *)0xFFFB8254)
#define CAN1_CR5_OFFSET 0x254
#define CAN1_CR5_STAMP_MASK 0x0U
#define CAN1_CR5_STAMP_BIT 0

#define CAN1_CSR5 (*(volatile unsigned long *)0xFFFB8258)
#define CAN1_CSR5_OFFSET 0x258
#define CAN1_CSR5_ACK_MASK 0x1U
#define CAN1_CSR5_ACK 0x1U
#define CAN1_CSR5_ACK_BIT 0
#define CAN1_CSR5_FRAME_MASK 0x2U
#define CAN1_CSR5_FRAME 0x2U
#define CAN1_CSR5_FRAME_BIT 1
#define CAN1_CSR5_CRC_MASK 0x4U
#define CAN1_CSR5_CRC 0x4U
#define CAN1_CSR5_CRC_BIT 2
#define CAN1_CSR5_STUFF_MASK 0x8U
#define CAN1_CSR5_STUFF 0x8U
#define CAN1_CSR5_STUFF_BIT 3
#define CAN1_CSR5_BUS_MASK 0x10U
#define CAN1_CSR5_BUS 0x10U
#define CAN1_CSR5_BUS_BIT 4
#define CAN1_CSR5_RXOK_MASK 0x20U
#define CAN1_CSR5_RXOK 0x20U
#define CAN1_CSR5_RXOK_BIT 5
#define CAN1_CSR5_TXOK_MASK 0x40U
#define CAN1_CSR5_TXOK 0x40U
#define CAN1_CSR5_TXOK_BIT 6
#define CAN1_CSR5_RFRAME_MASK 0x80U
#define CAN1_CSR5_RFRAME 0x80U
#define CAN1_CSR5_RFRAME_BIT 7
#define CAN1_CSR5_DLCW_MASK 0x200U
#define CAN1_CSR5_DLCW 0x200U
#define CAN1_CSR5_DLCW_BIT 9
#define CAN1_CSR5_FILLED_MASK 0x400U
#define CAN1_CSR5_FILLED 0x400U
#define CAN1_CSR5_FILLED_BIT 10
#define CAN1_CSR5_OVRUN_MASK 0x800U
#define CAN1_CSR5_OVRUN 0x800U
#define CAN1_CSR5_OVRUN_BIT 11

#define CAN1_SR5 (*(volatile unsigned long *)0xFFFB825C)
#define CAN1_SR5_OFFSET 0x25C
#define CAN1_SR5_ACK_MASK 0x1U
#define CAN1_SR5_ACK 0x1U
#define CAN1_SR5_ACK_BIT 0
#define CAN1_SR5_FRAME_MASK 0x2U
#define CAN1_SR5_FRAME 0x2U
#define CAN1_SR5_FRAME_BIT 1
#define CAN1_SR5_CRC_MASK 0x4U
#define CAN1_SR5_CRC 0x4U
#define CAN1_SR5_CRC_BIT 2
#define CAN1_SR5_STUFF_MASK 0x8U
#define CAN1_SR5_STUFF 0x8U
#define CAN1_SR5_STUFF_BIT 3
#define CAN1_SR5_BUS_MASK 0x10U
#define CAN1_SR5_BUS 0x10U
#define CAN1_SR5_BUS_BIT 4
#define CAN1_SR5_RXOK_MASK 0x20U
#define CAN1_SR5_RXOK 0x20U
#define CAN1_SR5_RXOK_BIT 5
#define CAN1_SR5_TXOK_MASK 0x40U
#define CAN1_SR5_TXOK 0x40U
#define CAN1_SR5_TXOK_BIT 6
#define CAN1_SR5_RFRAME_MASK 0x80U
#define CAN1_SR5_RFRAME 0x80U
#define CAN1_SR5_RFRAME_BIT 7
#define CAN1_SR5_DLCW_MASK 0x200U
#define CAN1_SR5_DLCW 0x200U
#define CAN1_SR5_DLCW_BIT 9
#define CAN1_SR5_FILLED_MASK 0x400U
#define CAN1_SR5_FILLED 0x400U
#define CAN1_SR5_FILLED_BIT 10
#define CAN1_SR5_OVRUN_MASK 0x800U
#define CAN1_SR5_OVRUN 0x800U
#define CAN1_SR5_OVRUN_BIT 11

#define CAN1_IER5 (*(volatile unsigned long *)0xFFFB8260)
#define CAN1_IER5_OFFSET 0x260
#define CAN1_IER5_ACK_MASK 0x1U
#define CAN1_IER5_ACK 0x1U
#define CAN1_IER5_ACK_BIT 0
#define CAN1_IER5_FRAME_MASK 0x2U
#define CAN1_IER5_FRAME 0x2U
#define CAN1_IER5_FRAME_BIT 1
#define CAN1_IER5_CRC_MASK 0x4U
#define CAN1_IER5_CRC 0x4U
#define CAN1_IER5_CRC_BIT 2
#define CAN1_IER5_STUFF_MASK 0x8U
#define CAN1_IER5_STUFF 0x8U
#define CAN1_IER5_STUFF_BIT 3
#define CAN1_IER5_BUS_MASK 0x10U
#define CAN1_IER5_BUS 0x10U
#define CAN1_IER5_BUS_BIT 4
#define CAN1_IER5_RXOK_MASK 0x20U
#define CAN1_IER5_RXOK 0x20U
#define CAN1_IER5_RXOK_BIT 5
#define CAN1_IER5_TXOK_MASK 0x40U
#define CAN1_IER5_TXOK 0x40U
#define CAN1_IER5_TXOK_BIT 6
#define CAN1_IER5_RFRAME_MASK 0x80U
#define CAN1_IER5_RFRAME 0x80U
#define CAN1_IER5_RFRAME_BIT 7

#define CAN1_IDR5 (*(volatile unsigned long *)0xFFFB8264)
#define CAN1_IDR5_OFFSET 0x264
#define CAN1_IDR5_ACK_MASK 0x1U
#define CAN1_IDR5_ACK 0x1U
#define CAN1_IDR5_ACK_BIT 0
#define CAN1_IDR5_FRAME_MASK 0x2U
#define CAN1_IDR5_FRAME 0x2U
#define CAN1_IDR5_FRAME_BIT 1
#define CAN1_IDR5_CRC_MASK 0x4U
#define CAN1_IDR5_CRC 0x4U
#define CAN1_IDR5_CRC_BIT 2
#define CAN1_IDR5_STUFF_MASK 0x8U
#define CAN1_IDR5_STUFF 0x8U
#define CAN1_IDR5_STUFF_BIT 3
#define CAN1_IDR5_BUS_MASK 0x10U
#define CAN1_IDR5_BUS 0x10U
#define CAN1_IDR5_BUS_BIT 4
#define CAN1_IDR5_RXOK_MASK 0x20U
#define CAN1_IDR5_RXOK 0x20U
#define CAN1_IDR5_RXOK_BIT 5
#define CAN1_IDR5_TXOK_MASK 0x40U
#define CAN1_IDR5_TXOK 0x40U
#define CAN1_IDR5_TXOK_BIT 6
#define CAN1_IDR5_RFRAME_MASK 0x80U
#define CAN1_IDR5_RFRAME 0x80U
#define CAN1_IDR5_RFRAME_BIT 7

#define CAN1_IMR5 (*(volatile unsigned long *)0xFFFB8268)
#define CAN1_IMR5_OFFSET 0x268
#define CAN1_IMR5_ACK_MASK 0x1U
#define CAN1_IMR5_ACK 0x1U
#define CAN1_IMR5_ACK_BIT 0
#define CAN1_IMR5_FRAME_MASK 0x2U
#define CAN1_IMR5_FRAME 0x2U
#define CAN1_IMR5_FRAME_BIT 1
#define CAN1_IMR5_CRC_MASK 0x4U
#define CAN1_IMR5_CRC 0x4U
#define CAN1_IMR5_CRC_BIT 2
#define CAN1_IMR5_STUFF_MASK 0x8U
#define CAN1_IMR5_STUFF 0x8U
#define CAN1_IMR5_STUFF_BIT 3
#define CAN1_IMR5_BUS_MASK 0x10U
#define CAN1_IMR5_BUS 0x10U
#define CAN1_IMR5_BUS_BIT 4
#define CAN1_IMR5_RXOK_MASK 0x20U
#define CAN1_IMR5_RXOK 0x20U
#define CAN1_IMR5_RXOK_BIT 5
#define CAN1_IMR5_TXOK_MASK 0x40U
#define CAN1_IMR5_TXOK 0x40U
#define CAN1_IMR5_TXOK_BIT 6
#define CAN1_IMR5_RFRAME_MASK 0x80U
#define CAN1_IMR5_RFRAME 0x80U
#define CAN1_IMR5_RFRAME_BIT 7

#define CAN1_DRA6 (*(volatile unsigned long *)0xFFFB8280)
#define CAN1_DRA6_OFFSET 0x280
#define CAN1_DRA6_DATA0_MASK 0xFFU
#define CAN1_DRA6_DATA0_BIT 0
#define CAN1_DRA6_DATA1_MASK 0xFF00U
#define CAN1_DRA6_DATA1_BIT 8
#define CAN1_DRA6_DATA2_MASK 0xFF0000U
#define CAN1_DRA6_DATA2_BIT 16
#define CAN1_DRA6_DATA3_MASK 0xFF000000U
#define CAN1_DRA6_DATA3_BIT 24

#define CAN1_DRB6 (*(volatile unsigned long *)0xFFFB8284)
#define CAN1_DRB6_OFFSET 0x284
#define CAN1_DRB6_DATA4_MASK 0xFFU
#define CAN1_DRB6_DATA4_BIT 0
#define CAN1_DRB6_DATA5_MASK 0xFF00U
#define CAN1_DRB6_DATA5_BIT 8
#define CAN1_DRB6_DATA6_MASK 0xFF0000U
#define CAN1_DRB6_DATA6_BIT 16
#define CAN1_DRB6_DATA7_MASK 0xFF000000U
#define CAN1_DRB6_DATA7_BIT 24

#define CAN1_MSK6 (*(volatile unsigned long *)0xFFFB8288)
#define CAN1_MSK6_OFFSET 0x288
#define CAN1_MSK6_MASK_MASK 0x1FFFFFFFU
#define CAN1_MSK6_MASK_BIT 0
#define CAN1_MSK6_MRB_MASK 0x60000000U
#define CAN1_MSK6_MRB_BIT 29
#define CAN1_MSK6_MRTR_MASK 0x80000000U
#define CAN1_MSK6_MRTR 0x80000000U
#define CAN1_MSK6_MRTR_BIT 31

#define CAN1_IR6 (*(volatile unsigned long *)0xFFFB828C)
#define CAN1_IR6_OFFSET 0x28C
#define CAN1_IR6_ID_MASK 0x1FFFFFFFU
#define CAN1_IR6_ID_BIT 0
#define CAN1_IR6_RB_MASK 0x60000000U
#define CAN1_IR6_RB_BIT 29
#define CAN1_IR6_RTR_MASK 0x80000000U
#define CAN1_IR6_RTR 0x80000000U
#define CAN1_IR6_RTR_BIT 31

#define CAN1_CR6 (*(volatile unsigned long *)0xFFFB8290)
#define CAN1_CR6_OFFSET 0x290
#define CAN1_CR6_DLC_MASK 0xFU
#define CAN1_CR6_DLC_BIT 0
#define CAN1_CR6_IDE_MASK 0x10U
#define CAN1_CR6_IDE 0x10U
#define CAN1_CR6_IDE_BIT 4
#define CAN1_CR6_RPLYV_MASK 0x20U
#define CAN1_CR6_RPLYV 0x20U
#define CAN1_CR6_RPLYV_BIT 5
#define CAN1_CR6_PCB_MASK 0x40U
#define CAN1_CR6_PCB 0x40U
#define CAN1_CR6_PCB_BIT 6
#define CAN1_CR6_CHANEN_MASK 0x80U
#define CAN1_CR6_CHANEN 0x80U
#define CAN1_CR6_CHANEN_BIT 7
#define CAN1_CR6_OVERWRITE_MASK 0x100U
#define CAN1_CR6_OVERWRITE 0x100U
#define CAN1_CR6_OVERWRITE_BIT 8

#define CAN1_CR6 (*(volatile unsigned long *)0xFFFB8294)
#define CAN1_CR6_OFFSET 0x294
#define CAN1_CR6_STAMP_MASK 0x0U
#define CAN1_CR6_STAMP_BIT 0

#define CAN1_CSR6 (*(volatile unsigned long *)0xFFFB8298)
#define CAN1_CSR6_OFFSET 0x298
#define CAN1_CSR6_ACK_MASK 0x1U
#define CAN1_CSR6_ACK 0x1U
#define CAN1_CSR6_ACK_BIT 0
#define CAN1_CSR6_FRAME_MASK 0x2U
#define CAN1_CSR6_FRAME 0x2U
#define CAN1_CSR6_FRAME_BIT 1
#define CAN1_CSR6_CRC_MASK 0x4U
#define CAN1_CSR6_CRC 0x4U
#define CAN1_CSR6_CRC_BIT 2
#define CAN1_CSR6_STUFF_MASK 0x8U
#define CAN1_CSR6_STUFF 0x8U
#define CAN1_CSR6_STUFF_BIT 3
#define CAN1_CSR6_BUS_MASK 0x10U
#define CAN1_CSR6_BUS 0x10U
#define CAN1_CSR6_BUS_BIT 4
#define CAN1_CSR6_RXOK_MASK 0x20U
#define CAN1_CSR6_RXOK 0x20U
#define CAN1_CSR6_RXOK_BIT 5
#define CAN1_CSR6_TXOK_MASK 0x40U
#define CAN1_CSR6_TXOK 0x40U
#define CAN1_CSR6_TXOK_BIT 6
#define CAN1_CSR6_RFRAME_MASK 0x80U
#define CAN1_CSR6_RFRAME 0x80U
#define CAN1_CSR6_RFRAME_BIT 7
#define CAN1_CSR6_DLCW_MASK 0x200U
#define CAN1_CSR6_DLCW 0x200U
#define CAN1_CSR6_DLCW_BIT 9
#define CAN1_CSR6_FILLED_MASK 0x400U
#define CAN1_CSR6_FILLED 0x400U
#define CAN1_CSR6_FILLED_BIT 10
#define CAN1_CSR6_OVRUN_MASK 0x800U
#define CAN1_CSR6_OVRUN 0x800U
#define CAN1_CSR6_OVRUN_BIT 11

#define CAN1_SR6 (*(volatile unsigned long *)0xFFFB829C)
#define CAN1_SR6_OFFSET 0x29C
#define CAN1_SR6_ACK_MASK 0x1U
#define CAN1_SR6_ACK 0x1U
#define CAN1_SR6_ACK_BIT 0
#define CAN1_SR6_FRAME_MASK 0x2U
#define CAN1_SR6_FRAME 0x2U
#define CAN1_SR6_FRAME_BIT 1
#define CAN1_SR6_CRC_MASK 0x4U
#define CAN1_SR6_CRC 0x4U
#define CAN1_SR6_CRC_BIT 2
#define CAN1_SR6_STUFF_MASK 0x8U
#define CAN1_SR6_STUFF 0x8U
#define CAN1_SR6_STUFF_BIT 3
#define CAN1_SR6_BUS_MASK 0x10U
#define CAN1_SR6_BUS 0x10U
#define CAN1_SR6_BUS_BIT 4
#define CAN1_SR6_RXOK_MASK 0x20U
#define CAN1_SR6_RXOK 0x20U
#define CAN1_SR6_RXOK_BIT 5
#define CAN1_SR6_TXOK_MASK 0x40U
#define CAN1_SR6_TXOK 0x40U
#define CAN1_SR6_TXOK_BIT 6
#define CAN1_SR6_RFRAME_MASK 0x80U
#define CAN1_SR6_RFRAME 0x80U
#define CAN1_SR6_RFRAME_BIT 7
#define CAN1_SR6_DLCW_MASK 0x200U
#define CAN1_SR6_DLCW 0x200U
#define CAN1_SR6_DLCW_BIT 9
#define CAN1_SR6_FILLED_MASK 0x400U
#define CAN1_SR6_FILLED 0x400U
#define CAN1_SR6_FILLED_BIT 10
#define CAN1_SR6_OVRUN_MASK 0x800U
#define CAN1_SR6_OVRUN 0x800U
#define CAN1_SR6_OVRUN_BIT 11

#define CAN1_IER6 (*(volatile unsigned long *)0xFFFB82A0)
#define CAN1_IER6_OFFSET 0x2A0
#define CAN1_IER6_ACK_MASK 0x1U
#define CAN1_IER6_ACK 0x1U
#define CAN1_IER6_ACK_BIT 0
#define CAN1_IER6_FRAME_MASK 0x2U
#define CAN1_IER6_FRAME 0x2U
#define CAN1_IER6_FRAME_BIT 1
#define CAN1_IER6_CRC_MASK 0x4U
#define CAN1_IER6_CRC 0x4U
#define CAN1_IER6_CRC_BIT 2
#define CAN1_IER6_STUFF_MASK 0x8U
#define CAN1_IER6_STUFF 0x8U
#define CAN1_IER6_STUFF_BIT 3
#define CAN1_IER6_BUS_MASK 0x10U
#define CAN1_IER6_BUS 0x10U
#define CAN1_IER6_BUS_BIT 4
#define CAN1_IER6_RXOK_MASK 0x20U
#define CAN1_IER6_RXOK 0x20U
#define CAN1_IER6_RXOK_BIT 5
#define CAN1_IER6_TXOK_MASK 0x40U
#define CAN1_IER6_TXOK 0x40U
#define CAN1_IER6_TXOK_BIT 6
#define CAN1_IER6_RFRAME_MASK 0x80U
#define CAN1_IER6_RFRAME 0x80U
#define CAN1_IER6_RFRAME_BIT 7

#define CAN1_IDR6 (*(volatile unsigned long *)0xFFFB82A4)
#define CAN1_IDR6_OFFSET 0x2A4
#define CAN1_IDR6_ACK_MASK 0x1U
#define CAN1_IDR6_ACK 0x1U
#define CAN1_IDR6_ACK_BIT 0
#define CAN1_IDR6_FRAME_MASK 0x2U
#define CAN1_IDR6_FRAME 0x2U
#define CAN1_IDR6_FRAME_BIT 1
#define CAN1_IDR6_CRC_MASK 0x4U
#define CAN1_IDR6_CRC 0x4U
#define CAN1_IDR6_CRC_BIT 2
#define CAN1_IDR6_STUFF_MASK 0x8U
#define CAN1_IDR6_STUFF 0x8U
#define CAN1_IDR6_STUFF_BIT 3
#define CAN1_IDR6_BUS_MASK 0x10U
#define CAN1_IDR6_BUS 0x10U
#define CAN1_IDR6_BUS_BIT 4
#define CAN1_IDR6_RXOK_MASK 0x20U
#define CAN1_IDR6_RXOK 0x20U
#define CAN1_IDR6_RXOK_BIT 5
#define CAN1_IDR6_TXOK_MASK 0x40U
#define CAN1_IDR6_TXOK 0x40U
#define CAN1_IDR6_TXOK_BIT 6
#define CAN1_IDR6_RFRAME_MASK 0x80U
#define CAN1_IDR6_RFRAME 0x80U
#define CAN1_IDR6_RFRAME_BIT 7

#define CAN1_IMR6 (*(volatile unsigned long *)0xFFFB82A8)
#define CAN1_IMR6_OFFSET 0x2A8
#define CAN1_IMR6_ACK_MASK 0x1U
#define CAN1_IMR6_ACK 0x1U
#define CAN1_IMR6_ACK_BIT 0
#define CAN1_IMR6_FRAME_MASK 0x2U
#define CAN1_IMR6_FRAME 0x2U
#define CAN1_IMR6_FRAME_BIT 1
#define CAN1_IMR6_CRC_MASK 0x4U
#define CAN1_IMR6_CRC 0x4U
#define CAN1_IMR6_CRC_BIT 2
#define CAN1_IMR6_STUFF_MASK 0x8U
#define CAN1_IMR6_STUFF 0x8U
#define CAN1_IMR6_STUFF_BIT 3
#define CAN1_IMR6_BUS_MASK 0x10U
#define CAN1_IMR6_BUS 0x10U
#define CAN1_IMR6_BUS_BIT 4
#define CAN1_IMR6_RXOK_MASK 0x20U
#define CAN1_IMR6_RXOK 0x20U
#define CAN1_IMR6_RXOK_BIT 5
#define CAN1_IMR6_TXOK_MASK 0x40U
#define CAN1_IMR6_TXOK 0x40U
#define CAN1_IMR6_TXOK_BIT 6
#define CAN1_IMR6_RFRAME_MASK 0x80U
#define CAN1_IMR6_RFRAME 0x80U
#define CAN1_IMR6_RFRAME_BIT 7

#define CAN1_DRA7 (*(volatile unsigned long *)0xFFFB82C0)
#define CAN1_DRA7_OFFSET 0x2C0
#define CAN1_DRA7_DATA0_MASK 0xFFU
#define CAN1_DRA7_DATA0_BIT 0
#define CAN1_DRA7_DATA1_MASK 0xFF00U
#define CAN1_DRA7_DATA1_BIT 8
#define CAN1_DRA7_DATA2_MASK 0xFF0000U
#define CAN1_DRA7_DATA2_BIT 16
#define CAN1_DRA7_DATA3_MASK 0xFF000000U
#define CAN1_DRA7_DATA3_BIT 24

#define CAN1_DRB7 (*(volatile unsigned long *)0xFFFB82C4)
#define CAN1_DRB7_OFFSET 0x2C4
#define CAN1_DRB7_DATA4_MASK 0xFFU
#define CAN1_DRB7_DATA4_BIT 0
#define CAN1_DRB7_DATA5_MASK 0xFF00U
#define CAN1_DRB7_DATA5_BIT 8
#define CAN1_DRB7_DATA6_MASK 0xFF0000U
#define CAN1_DRB7_DATA6_BIT 16
#define CAN1_DRB7_DATA7_MASK 0xFF000000U
#define CAN1_DRB7_DATA7_BIT 24

#define CAN1_MSK7 (*(volatile unsigned long *)0xFFFB82C8)
#define CAN1_MSK7_OFFSET 0x2C8
#define CAN1_MSK7_MASK_MASK 0x1FFFFFFFU
#define CAN1_MSK7_MASK_BIT 0
#define CAN1_MSK7_MRB_MASK 0x60000000U
#define CAN1_MSK7_MRB_BIT 29
#define CAN1_MSK7_MRTR_MASK 0x80000000U
#define CAN1_MSK7_MRTR 0x80000000U
#define CAN1_MSK7_MRTR_BIT 31

#define CAN1_IR7 (*(volatile unsigned long *)0xFFFB82CC)
#define CAN1_IR7_OFFSET 0x2CC
#define CAN1_IR7_ID_MASK 0x1FFFFFFFU
#define CAN1_IR7_ID_BIT 0
#define CAN1_IR7_RB_MASK 0x60000000U
#define CAN1_IR7_RB_BIT 29
#define CAN1_IR7_RTR_MASK 0x80000000U
#define CAN1_IR7_RTR 0x80000000U
#define CAN1_IR7_RTR_BIT 31

#define CAN1_CR7 (*(volatile unsigned long *)0xFFFB82D0)
#define CAN1_CR7_OFFSET 0x2D0
#define CAN1_CR7_DLC_MASK 0xFU
#define CAN1_CR7_DLC_BIT 0
#define CAN1_CR7_IDE_MASK 0x10U
#define CAN1_CR7_IDE 0x10U
#define CAN1_CR7_IDE_BIT 4
#define CAN1_CR7_RPLYV_MASK 0x20U
#define CAN1_CR7_RPLYV 0x20U
#define CAN1_CR7_RPLYV_BIT 5
#define CAN1_CR7_PCB_MASK 0x40U
#define CAN1_CR7_PCB 0x40U
#define CAN1_CR7_PCB_BIT 6
#define CAN1_CR7_CHANEN_MASK 0x80U
#define CAN1_CR7_CHANEN 0x80U
#define CAN1_CR7_CHANEN_BIT 7
#define CAN1_CR7_OVERWRITE_MASK 0x100U
#define CAN1_CR7_OVERWRITE 0x100U
#define CAN1_CR7_OVERWRITE_BIT 8

#define CAN1_CR7 (*(volatile unsigned long *)0xFFFB82D4)
#define CAN1_CR7_OFFSET 0x2D4
#define CAN1_CR7_STAMP_MASK 0x0U
#define CAN1_CR7_STAMP_BIT 0

#define CAN1_CSR7 (*(volatile unsigned long *)0xFFFB82D8)
#define CAN1_CSR7_OFFSET 0x2D8
#define CAN1_CSR7_ACK_MASK 0x1U
#define CAN1_CSR7_ACK 0x1U
#define CAN1_CSR7_ACK_BIT 0
#define CAN1_CSR7_FRAME_MASK 0x2U
#define CAN1_CSR7_FRAME 0x2U
#define CAN1_CSR7_FRAME_BIT 1
#define CAN1_CSR7_CRC_MASK 0x4U
#define CAN1_CSR7_CRC 0x4U
#define CAN1_CSR7_CRC_BIT 2
#define CAN1_CSR7_STUFF_MASK 0x8U
#define CAN1_CSR7_STUFF 0x8U
#define CAN1_CSR7_STUFF_BIT 3
#define CAN1_CSR7_BUS_MASK 0x10U
#define CAN1_CSR7_BUS 0x10U
#define CAN1_CSR7_BUS_BIT 4
#define CAN1_CSR7_RXOK_MASK 0x20U
#define CAN1_CSR7_RXOK 0x20U
#define CAN1_CSR7_RXOK_BIT 5
#define CAN1_CSR7_TXOK_MASK 0x40U
#define CAN1_CSR7_TXOK 0x40U
#define CAN1_CSR7_TXOK_BIT 6
#define CAN1_CSR7_RFRAME_MASK 0x80U
#define CAN1_CSR7_RFRAME 0x80U
#define CAN1_CSR7_RFRAME_BIT 7
#define CAN1_CSR7_DLCW_MASK 0x200U
#define CAN1_CSR7_DLCW 0x200U
#define CAN1_CSR7_DLCW_BIT 9
#define CAN1_CSR7_FILLED_MASK 0x400U
#define CAN1_CSR7_FILLED 0x400U
#define CAN1_CSR7_FILLED_BIT 10
#define CAN1_CSR7_OVRUN_MASK 0x800U
#define CAN1_CSR7_OVRUN 0x800U
#define CAN1_CSR7_OVRUN_BIT 11

#define CAN1_SR7 (*(volatile unsigned long *)0xFFFB82DC)
#define CAN1_SR7_OFFSET 0x2DC
#define CAN1_SR7_ACK_MASK 0x1U
#define CAN1_SR7_ACK 0x1U
#define CAN1_SR7_ACK_BIT 0
#define CAN1_SR7_FRAME_MASK 0x2U
#define CAN1_SR7_FRAME 0x2U
#define CAN1_SR7_FRAME_BIT 1
#define CAN1_SR7_CRC_MASK 0x4U
#define CAN1_SR7_CRC 0x4U
#define CAN1_SR7_CRC_BIT 2
#define CAN1_SR7_STUFF_MASK 0x8U
#define CAN1_SR7_STUFF 0x8U
#define CAN1_SR7_STUFF_BIT 3
#define CAN1_SR7_BUS_MASK 0x10U
#define CAN1_SR7_BUS 0x10U
#define CAN1_SR7_BUS_BIT 4
#define CAN1_SR7_RXOK_MASK 0x20U
#define CAN1_SR7_RXOK 0x20U
#define CAN1_SR7_RXOK_BIT 5
#define CAN1_SR7_TXOK_MASK 0x40U
#define CAN1_SR7_TXOK 0x40U
#define CAN1_SR7_TXOK_BIT 6
#define CAN1_SR7_RFRAME_MASK 0x80U
#define CAN1_SR7_RFRAME 0x80U
#define CAN1_SR7_RFRAME_BIT 7
#define CAN1_SR7_DLCW_MASK 0x200U
#define CAN1_SR7_DLCW 0x200U
#define CAN1_SR7_DLCW_BIT 9
#define CAN1_SR7_FILLED_MASK 0x400U
#define CAN1_SR7_FILLED 0x400U
#define CAN1_SR7_FILLED_BIT 10
#define CAN1_SR7_OVRUN_MASK 0x800U
#define CAN1_SR7_OVRUN 0x800U
#define CAN1_SR7_OVRUN_BIT 11

#define CAN1_IER7 (*(volatile unsigned long *)0xFFFB82E0)
#define CAN1_IER7_OFFSET 0x2E0
#define CAN1_IER7_ACK_MASK 0x1U
#define CAN1_IER7_ACK 0x1U
#define CAN1_IER7_ACK_BIT 0
#define CAN1_IER7_FRAME_MASK 0x2U
#define CAN1_IER7_FRAME 0x2U
#define CAN1_IER7_FRAME_BIT 1
#define CAN1_IER7_CRC_MASK 0x4U
#define CAN1_IER7_CRC 0x4U
#define CAN1_IER7_CRC_BIT 2
#define CAN1_IER7_STUFF_MASK 0x8U
#define CAN1_IER7_STUFF 0x8U
#define CAN1_IER7_STUFF_BIT 3
#define CAN1_IER7_BUS_MASK 0x10U
#define CAN1_IER7_BUS 0x10U
#define CAN1_IER7_BUS_BIT 4
#define CAN1_IER7_RXOK_MASK 0x20U
#define CAN1_IER7_RXOK 0x20U
#define CAN1_IER7_RXOK_BIT 5
#define CAN1_IER7_TXOK_MASK 0x40U
#define CAN1_IER7_TXOK 0x40U
#define CAN1_IER7_TXOK_BIT 6
#define CAN1_IER7_RFRAME_MASK 0x80U
#define CAN1_IER7_RFRAME 0x80U
#define CAN1_IER7_RFRAME_BIT 7

#define CAN1_IDR7 (*(volatile unsigned long *)0xFFFB82E4)
#define CAN1_IDR7_OFFSET 0x2E4
#define CAN1_IDR7_ACK_MASK 0x1U
#define CAN1_IDR7_ACK 0x1U
#define CAN1_IDR7_ACK_BIT 0
#define CAN1_IDR7_FRAME_MASK 0x2U
#define CAN1_IDR7_FRAME 0x2U
#define CAN1_IDR7_FRAME_BIT 1
#define CAN1_IDR7_CRC_MASK 0x4U
#define CAN1_IDR7_CRC 0x4U
#define CAN1_IDR7_CRC_BIT 2
#define CAN1_IDR7_STUFF_MASK 0x8U
#define CAN1_IDR7_STUFF 0x8U
#define CAN1_IDR7_STUFF_BIT 3
#define CAN1_IDR7_BUS_MASK 0x10U
#define CAN1_IDR7_BUS 0x10U
#define CAN1_IDR7_BUS_BIT 4
#define CAN1_IDR7_RXOK_MASK 0x20U
#define CAN1_IDR7_RXOK 0x20U
#define CAN1_IDR7_RXOK_BIT 5
#define CAN1_IDR7_TXOK_MASK 0x40U
#define CAN1_IDR7_TXOK 0x40U
#define CAN1_IDR7_TXOK_BIT 6
#define CAN1_IDR7_RFRAME_MASK 0x80U
#define CAN1_IDR7_RFRAME 0x80U
#define CAN1_IDR7_RFRAME_BIT 7

#define CAN1_IMR7 (*(volatile unsigned long *)0xFFFB82E8)
#define CAN1_IMR7_OFFSET 0x2E8
#define CAN1_IMR7_ACK_MASK 0x1U
#define CAN1_IMR7_ACK 0x1U
#define CAN1_IMR7_ACK_BIT 0
#define CAN1_IMR7_FRAME_MASK 0x2U
#define CAN1_IMR7_FRAME 0x2U
#define CAN1_IMR7_FRAME_BIT 1
#define CAN1_IMR7_CRC_MASK 0x4U
#define CAN1_IMR7_CRC 0x4U
#define CAN1_IMR7_CRC_BIT 2
#define CAN1_IMR7_STUFF_MASK 0x8U
#define CAN1_IMR7_STUFF 0x8U
#define CAN1_IMR7_STUFF_BIT 3
#define CAN1_IMR7_BUS_MASK 0x10U
#define CAN1_IMR7_BUS 0x10U
#define CAN1_IMR7_BUS_BIT 4
#define CAN1_IMR7_RXOK_MASK 0x20U
#define CAN1_IMR7_RXOK 0x20U
#define CAN1_IMR7_RXOK_BIT 5
#define CAN1_IMR7_TXOK_MASK 0x40U
#define CAN1_IMR7_TXOK 0x40U
#define CAN1_IMR7_TXOK_BIT 6
#define CAN1_IMR7_RFRAME_MASK 0x80U
#define CAN1_IMR7_RFRAME 0x80U
#define CAN1_IMR7_RFRAME_BIT 7

#define CAN1_DRA8 (*(volatile unsigned long *)0xFFFB8300)
#define CAN1_DRA8_OFFSET 0x300
#define CAN1_DRA8_DATA0_MASK 0xFFU
#define CAN1_DRA8_DATA0_BIT 0
#define CAN1_DRA8_DATA1_MASK 0xFF00U
#define CAN1_DRA8_DATA1_BIT 8
#define CAN1_DRA8_DATA2_MASK 0xFF0000U
#define CAN1_DRA8_DATA2_BIT 16
#define CAN1_DRA8_DATA3_MASK 0xFF000000U
#define CAN1_DRA8_DATA3_BIT 24

#define CAN1_DRB8 (*(volatile unsigned long *)0xFFFB8304)
#define CAN1_DRB8_OFFSET 0x304
#define CAN1_DRB8_DATA4_MASK 0xFFU
#define CAN1_DRB8_DATA4_BIT 0
#define CAN1_DRB8_DATA5_MASK 0xFF00U
#define CAN1_DRB8_DATA5_BIT 8
#define CAN1_DRB8_DATA6_MASK 0xFF0000U
#define CAN1_DRB8_DATA6_BIT 16
#define CAN1_DRB8_DATA7_MASK 0xFF000000U
#define CAN1_DRB8_DATA7_BIT 24

#define CAN1_MSK8 (*(volatile unsigned long *)0xFFFB8308)
#define CAN1_MSK8_OFFSET 0x308
#define CAN1_MSK8_MASK_MASK 0x1FFFFFFFU
#define CAN1_MSK8_MASK_BIT 0
#define CAN1_MSK8_MRB_MASK 0x60000000U
#define CAN1_MSK8_MRB_BIT 29
#define CAN1_MSK8_MRTR_MASK 0x80000000U
#define CAN1_MSK8_MRTR 0x80000000U
#define CAN1_MSK8_MRTR_BIT 31

#define CAN1_IR8 (*(volatile unsigned long *)0xFFFB830C)
#define CAN1_IR8_OFFSET 0x30C
#define CAN1_IR8_ID_MASK 0x1FFFFFFFU
#define CAN1_IR8_ID_BIT 0
#define CAN1_IR8_RB_MASK 0x60000000U
#define CAN1_IR8_RB_BIT 29
#define CAN1_IR8_RTR_MASK 0x80000000U
#define CAN1_IR8_RTR 0x80000000U
#define CAN1_IR8_RTR_BIT 31

#define CAN1_CR8 (*(volatile unsigned long *)0xFFFB8310)
#define CAN1_CR8_OFFSET 0x310
#define CAN1_CR8_DLC_MASK 0xFU
#define CAN1_CR8_DLC_BIT 0
#define CAN1_CR8_IDE_MASK 0x10U
#define CAN1_CR8_IDE 0x10U
#define CAN1_CR8_IDE_BIT 4
#define CAN1_CR8_RPLYV_MASK 0x20U
#define CAN1_CR8_RPLYV 0x20U
#define CAN1_CR8_RPLYV_BIT 5
#define CAN1_CR8_PCB_MASK 0x40U
#define CAN1_CR8_PCB 0x40U
#define CAN1_CR8_PCB_BIT 6
#define CAN1_CR8_CHANEN_MASK 0x80U
#define CAN1_CR8_CHANEN 0x80U
#define CAN1_CR8_CHANEN_BIT 7
#define CAN1_CR8_OVERWRITE_MASK 0x100U
#define CAN1_CR8_OVERWRITE 0x100U
#define CAN1_CR8_OVERWRITE_BIT 8

#define CAN1_CR8 (*(volatile unsigned long *)0xFFFB8314)
#define CAN1_CR8_OFFSET 0x314
#define CAN1_CR8_STAMP_MASK 0x0U
#define CAN1_CR8_STAMP_BIT 0

#define CAN1_CSR8 (*(volatile unsigned long *)0xFFFB8318)
#define CAN1_CSR8_OFFSET 0x318
#define CAN1_CSR8_ACK_MASK 0x1U
#define CAN1_CSR8_ACK 0x1U
#define CAN1_CSR8_ACK_BIT 0
#define CAN1_CSR8_FRAME_MASK 0x2U
#define CAN1_CSR8_FRAME 0x2U
#define CAN1_CSR8_FRAME_BIT 1
#define CAN1_CSR8_CRC_MASK 0x4U
#define CAN1_CSR8_CRC 0x4U
#define CAN1_CSR8_CRC_BIT 2
#define CAN1_CSR8_STUFF_MASK 0x8U
#define CAN1_CSR8_STUFF 0x8U
#define CAN1_CSR8_STUFF_BIT 3
#define CAN1_CSR8_BUS_MASK 0x10U
#define CAN1_CSR8_BUS 0x10U
#define CAN1_CSR8_BUS_BIT 4
#define CAN1_CSR8_RXOK_MASK 0x20U
#define CAN1_CSR8_RXOK 0x20U
#define CAN1_CSR8_RXOK_BIT 5
#define CAN1_CSR8_TXOK_MASK 0x40U
#define CAN1_CSR8_TXOK 0x40U
#define CAN1_CSR8_TXOK_BIT 6
#define CAN1_CSR8_RFRAME_MASK 0x80U
#define CAN1_CSR8_RFRAME 0x80U
#define CAN1_CSR8_RFRAME_BIT 7
#define CAN1_CSR8_DLCW_MASK 0x200U
#define CAN1_CSR8_DLCW 0x200U
#define CAN1_CSR8_DLCW_BIT 9
#define CAN1_CSR8_FILLED_MASK 0x400U
#define CAN1_CSR8_FILLED 0x400U
#define CAN1_CSR8_FILLED_BIT 10
#define CAN1_CSR8_OVRUN_MASK 0x800U
#define CAN1_CSR8_OVRUN 0x800U
#define CAN1_CSR8_OVRUN_BIT 11

#define CAN1_SR8 (*(volatile unsigned long *)0xFFFB831C)
#define CAN1_SR8_OFFSET 0x31C
#define CAN1_SR8_ACK_MASK 0x1U
#define CAN1_SR8_ACK 0x1U
#define CAN1_SR8_ACK_BIT 0
#define CAN1_SR8_FRAME_MASK 0x2U
#define CAN1_SR8_FRAME 0x2U
#define CAN1_SR8_FRAME_BIT 1
#define CAN1_SR8_CRC_MASK 0x4U
#define CAN1_SR8_CRC 0x4U
#define CAN1_SR8_CRC_BIT 2
#define CAN1_SR8_STUFF_MASK 0x8U
#define CAN1_SR8_STUFF 0x8U
#define CAN1_SR8_STUFF_BIT 3
#define CAN1_SR8_BUS_MASK 0x10U
#define CAN1_SR8_BUS 0x10U
#define CAN1_SR8_BUS_BIT 4
#define CAN1_SR8_RXOK_MASK 0x20U
#define CAN1_SR8_RXOK 0x20U
#define CAN1_SR8_RXOK_BIT 5
#define CAN1_SR8_TXOK_MASK 0x40U
#define CAN1_SR8_TXOK 0x40U
#define CAN1_SR8_TXOK_BIT 6
#define CAN1_SR8_RFRAME_MASK 0x80U
#define CAN1_SR8_RFRAME 0x80U
#define CAN1_SR8_RFRAME_BIT 7
#define CAN1_SR8_DLCW_MASK 0x200U
#define CAN1_SR8_DLCW 0x200U
#define CAN1_SR8_DLCW_BIT 9
#define CAN1_SR8_FILLED_MASK 0x400U
#define CAN1_SR8_FILLED 0x400U
#define CAN1_SR8_FILLED_BIT 10
#define CAN1_SR8_OVRUN_MASK 0x800U
#define CAN1_SR8_OVRUN 0x800U
#define CAN1_SR8_OVRUN_BIT 11

#define CAN1_IER8 (*(volatile unsigned long *)0xFFFB8320)
#define CAN1_IER8_OFFSET 0x320
#define CAN1_IER8_ACK_MASK 0x1U
#define CAN1_IER8_ACK 0x1U
#define CAN1_IER8_ACK_BIT 0
#define CAN1_IER8_FRAME_MASK 0x2U
#define CAN1_IER8_FRAME 0x2U
#define CAN1_IER8_FRAME_BIT 1
#define CAN1_IER8_CRC_MASK 0x4U
#define CAN1_IER8_CRC 0x4U
#define CAN1_IER8_CRC_BIT 2
#define CAN1_IER8_STUFF_MASK 0x8U
#define CAN1_IER8_STUFF 0x8U
#define CAN1_IER8_STUFF_BIT 3
#define CAN1_IER8_BUS_MASK 0x10U
#define CAN1_IER8_BUS 0x10U
#define CAN1_IER8_BUS_BIT 4
#define CAN1_IER8_RXOK_MASK 0x20U
#define CAN1_IER8_RXOK 0x20U
#define CAN1_IER8_RXOK_BIT 5
#define CAN1_IER8_TXOK_MASK 0x40U
#define CAN1_IER8_TXOK 0x40U
#define CAN1_IER8_TXOK_BIT 6
#define CAN1_IER8_RFRAME_MASK 0x80U
#define CAN1_IER8_RFRAME 0x80U
#define CAN1_IER8_RFRAME_BIT 7

#define CAN1_IDR8 (*(volatile unsigned long *)0xFFFB8324)
#define CAN1_IDR8_OFFSET 0x324
#define CAN1_IDR8_ACK_MASK 0x1U
#define CAN1_IDR8_ACK 0x1U
#define CAN1_IDR8_ACK_BIT 0
#define CAN1_IDR8_FRAME_MASK 0x2U
#define CAN1_IDR8_FRAME 0x2U
#define CAN1_IDR8_FRAME_BIT 1
#define CAN1_IDR8_CRC_MASK 0x4U
#define CAN1_IDR8_CRC 0x4U
#define CAN1_IDR8_CRC_BIT 2
#define CAN1_IDR8_STUFF_MASK 0x8U
#define CAN1_IDR8_STUFF 0x8U
#define CAN1_IDR8_STUFF_BIT 3
#define CAN1_IDR8_BUS_MASK 0x10U
#define CAN1_IDR8_BUS 0x10U
#define CAN1_IDR8_BUS_BIT 4
#define CAN1_IDR8_RXOK_MASK 0x20U
#define CAN1_IDR8_RXOK 0x20U
#define CAN1_IDR8_RXOK_BIT 5
#define CAN1_IDR8_TXOK_MASK 0x40U
#define CAN1_IDR8_TXOK 0x40U
#define CAN1_IDR8_TXOK_BIT 6
#define CAN1_IDR8_RFRAME_MASK 0x80U
#define CAN1_IDR8_RFRAME 0x80U
#define CAN1_IDR8_RFRAME_BIT 7

#define CAN1_IMR8 (*(volatile unsigned long *)0xFFFB8328)
#define CAN1_IMR8_OFFSET 0x328
#define CAN1_IMR8_ACK_MASK 0x1U
#define CAN1_IMR8_ACK 0x1U
#define CAN1_IMR8_ACK_BIT 0
#define CAN1_IMR8_FRAME_MASK 0x2U
#define CAN1_IMR8_FRAME 0x2U
#define CAN1_IMR8_FRAME_BIT 1
#define CAN1_IMR8_CRC_MASK 0x4U
#define CAN1_IMR8_CRC 0x4U
#define CAN1_IMR8_CRC_BIT 2
#define CAN1_IMR8_STUFF_MASK 0x8U
#define CAN1_IMR8_STUFF 0x8U
#define CAN1_IMR8_STUFF_BIT 3
#define CAN1_IMR8_BUS_MASK 0x10U
#define CAN1_IMR8_BUS 0x10U
#define CAN1_IMR8_BUS_BIT 4
#define CAN1_IMR8_RXOK_MASK 0x20U
#define CAN1_IMR8_RXOK 0x20U
#define CAN1_IMR8_RXOK_BIT 5
#define CAN1_IMR8_TXOK_MASK 0x40U
#define CAN1_IMR8_TXOK 0x40U
#define CAN1_IMR8_TXOK_BIT 6
#define CAN1_IMR8_RFRAME_MASK 0x80U
#define CAN1_IMR8_RFRAME 0x80U
#define CAN1_IMR8_RFRAME_BIT 7

#define CAN1_DRA9 (*(volatile unsigned long *)0xFFFB8340)
#define CAN1_DRA9_OFFSET 0x340
#define CAN1_DRA9_DATA0_MASK 0xFFU
#define CAN1_DRA9_DATA0_BIT 0
#define CAN1_DRA9_DATA1_MASK 0xFF00U
#define CAN1_DRA9_DATA1_BIT 8
#define CAN1_DRA9_DATA2_MASK 0xFF0000U
#define CAN1_DRA9_DATA2_BIT 16
#define CAN1_DRA9_DATA3_MASK 0xFF000000U
#define CAN1_DRA9_DATA3_BIT 24

#define CAN1_DRB9 (*(volatile unsigned long *)0xFFFB8344)
#define CAN1_DRB9_OFFSET 0x344
#define CAN1_DRB9_DATA4_MASK 0xFFU
#define CAN1_DRB9_DATA4_BIT 0
#define CAN1_DRB9_DATA5_MASK 0xFF00U
#define CAN1_DRB9_DATA5_BIT 8
#define CAN1_DRB9_DATA6_MASK 0xFF0000U
#define CAN1_DRB9_DATA6_BIT 16
#define CAN1_DRB9_DATA7_MASK 0xFF000000U
#define CAN1_DRB9_DATA7_BIT 24

#define CAN1_MSK9 (*(volatile unsigned long *)0xFFFB8348)
#define CAN1_MSK9_OFFSET 0x348
#define CAN1_MSK9_MASK_MASK 0x1FFFFFFFU
#define CAN1_MSK9_MASK_BIT 0
#define CAN1_MSK9_MRB_MASK 0x60000000U
#define CAN1_MSK9_MRB_BIT 29
#define CAN1_MSK9_MRTR_MASK 0x80000000U
#define CAN1_MSK9_MRTR 0x80000000U
#define CAN1_MSK9_MRTR_BIT 31

#define CAN1_IR9 (*(volatile unsigned long *)0xFFFB834C)
#define CAN1_IR9_OFFSET 0x34C
#define CAN1_IR9_ID_MASK 0x1FFFFFFFU
#define CAN1_IR9_ID_BIT 0
#define CAN1_IR9_RB_MASK 0x60000000U
#define CAN1_IR9_RB_BIT 29
#define CAN1_IR9_RTR_MASK 0x80000000U
#define CAN1_IR9_RTR 0x80000000U
#define CAN1_IR9_RTR_BIT 31

#define CAN1_CR9 (*(volatile unsigned long *)0xFFFB8350)
#define CAN1_CR9_OFFSET 0x350
#define CAN1_CR9_DLC_MASK 0xFU
#define CAN1_CR9_DLC_BIT 0
#define CAN1_CR9_IDE_MASK 0x10U
#define CAN1_CR9_IDE 0x10U
#define CAN1_CR9_IDE_BIT 4
#define CAN1_CR9_RPLYV_MASK 0x20U
#define CAN1_CR9_RPLYV 0x20U
#define CAN1_CR9_RPLYV_BIT 5
#define CAN1_CR9_PCB_MASK 0x40U
#define CAN1_CR9_PCB 0x40U
#define CAN1_CR9_PCB_BIT 6
#define CAN1_CR9_CHANEN_MASK 0x80U
#define CAN1_CR9_CHANEN 0x80U
#define CAN1_CR9_CHANEN_BIT 7
#define CAN1_CR9_OVERWRITE_MASK 0x100U
#define CAN1_CR9_OVERWRITE 0x100U
#define CAN1_CR9_OVERWRITE_BIT 8

#define CAN1_CR9 (*(volatile unsigned long *)0xFFFB8354)
#define CAN1_CR9_OFFSET 0x354
#define CAN1_CR9_STAMP_MASK 0x0U
#define CAN1_CR9_STAMP_BIT 0

#define CAN1_CSR9 (*(volatile unsigned long *)0xFFFB8358)
#define CAN1_CSR9_OFFSET 0x358
#define CAN1_CSR9_ACK_MASK 0x1U
#define CAN1_CSR9_ACK 0x1U
#define CAN1_CSR9_ACK_BIT 0
#define CAN1_CSR9_FRAME_MASK 0x2U
#define CAN1_CSR9_FRAME 0x2U
#define CAN1_CSR9_FRAME_BIT 1
#define CAN1_CSR9_CRC_MASK 0x4U
#define CAN1_CSR9_CRC 0x4U
#define CAN1_CSR9_CRC_BIT 2
#define CAN1_CSR9_STUFF_MASK 0x8U
#define CAN1_CSR9_STUFF 0x8U
#define CAN1_CSR9_STUFF_BIT 3
#define CAN1_CSR9_BUS_MASK 0x10U
#define CAN1_CSR9_BUS 0x10U
#define CAN1_CSR9_BUS_BIT 4
#define CAN1_CSR9_RXOK_MASK 0x20U
#define CAN1_CSR9_RXOK 0x20U
#define CAN1_CSR9_RXOK_BIT 5
#define CAN1_CSR9_TXOK_MASK 0x40U
#define CAN1_CSR9_TXOK 0x40U
#define CAN1_CSR9_TXOK_BIT 6
#define CAN1_CSR9_RFRAME_MASK 0x80U
#define CAN1_CSR9_RFRAME 0x80U
#define CAN1_CSR9_RFRAME_BIT 7
#define CAN1_CSR9_DLCW_MASK 0x200U
#define CAN1_CSR9_DLCW 0x200U
#define CAN1_CSR9_DLCW_BIT 9
#define CAN1_CSR9_FILLED_MASK 0x400U
#define CAN1_CSR9_FILLED 0x400U
#define CAN1_CSR9_FILLED_BIT 10
#define CAN1_CSR9_OVRUN_MASK 0x800U
#define CAN1_CSR9_OVRUN 0x800U
#define CAN1_CSR9_OVRUN_BIT 11

#define CAN1_SR9 (*(volatile unsigned long *)0xFFFB835C)
#define CAN1_SR9_OFFSET 0x35C
#define CAN1_SR9_ACK_MASK 0x1U
#define CAN1_SR9_ACK 0x1U
#define CAN1_SR9_ACK_BIT 0
#define CAN1_SR9_FRAME_MASK 0x2U
#define CAN1_SR9_FRAME 0x2U
#define CAN1_SR9_FRAME_BIT 1
#define CAN1_SR9_CRC_MASK 0x4U
#define CAN1_SR9_CRC 0x4U
#define CAN1_SR9_CRC_BIT 2
#define CAN1_SR9_STUFF_MASK 0x8U
#define CAN1_SR9_STUFF 0x8U
#define CAN1_SR9_STUFF_BIT 3
#define CAN1_SR9_BUS_MASK 0x10U
#define CAN1_SR9_BUS 0x10U
#define CAN1_SR9_BUS_BIT 4
#define CAN1_SR9_RXOK_MASK 0x20U
#define CAN1_SR9_RXOK 0x20U
#define CAN1_SR9_RXOK_BIT 5
#define CAN1_SR9_TXOK_MASK 0x40U
#define CAN1_SR9_TXOK 0x40U
#define CAN1_SR9_TXOK_BIT 6
#define CAN1_SR9_RFRAME_MASK 0x80U
#define CAN1_SR9_RFRAME 0x80U
#define CAN1_SR9_RFRAME_BIT 7
#define CAN1_SR9_DLCW_MASK 0x200U
#define CAN1_SR9_DLCW 0x200U
#define CAN1_SR9_DLCW_BIT 9
#define CAN1_SR9_FILLED_MASK 0x400U
#define CAN1_SR9_FILLED 0x400U
#define CAN1_SR9_FILLED_BIT 10
#define CAN1_SR9_OVRUN_MASK 0x800U
#define CAN1_SR9_OVRUN 0x800U
#define CAN1_SR9_OVRUN_BIT 11

#define CAN1_IER9 (*(volatile unsigned long *)0xFFFB8360)
#define CAN1_IER9_OFFSET 0x360
#define CAN1_IER9_ACK_MASK 0x1U
#define CAN1_IER9_ACK 0x1U
#define CAN1_IER9_ACK_BIT 0
#define CAN1_IER9_FRAME_MASK 0x2U
#define CAN1_IER9_FRAME 0x2U
#define CAN1_IER9_FRAME_BIT 1
#define CAN1_IER9_CRC_MASK 0x4U
#define CAN1_IER9_CRC 0x4U
#define CAN1_IER9_CRC_BIT 2
#define CAN1_IER9_STUFF_MASK 0x8U
#define CAN1_IER9_STUFF 0x8U
#define CAN1_IER9_STUFF_BIT 3
#define CAN1_IER9_BUS_MASK 0x10U
#define CAN1_IER9_BUS 0x10U
#define CAN1_IER9_BUS_BIT 4
#define CAN1_IER9_RXOK_MASK 0x20U
#define CAN1_IER9_RXOK 0x20U
#define CAN1_IER9_RXOK_BIT 5
#define CAN1_IER9_TXOK_MASK 0x40U
#define CAN1_IER9_TXOK 0x40U
#define CAN1_IER9_TXOK_BIT 6
#define CAN1_IER9_RFRAME_MASK 0x80U
#define CAN1_IER9_RFRAME 0x80U
#define CAN1_IER9_RFRAME_BIT 7

#define CAN1_IDR9 (*(volatile unsigned long *)0xFFFB8364)
#define CAN1_IDR9_OFFSET 0x364
#define CAN1_IDR9_ACK_MASK 0x1U
#define CAN1_IDR9_ACK 0x1U
#define CAN1_IDR9_ACK_BIT 0
#define CAN1_IDR9_FRAME_MASK 0x2U
#define CAN1_IDR9_FRAME 0x2U
#define CAN1_IDR9_FRAME_BIT 1
#define CAN1_IDR9_CRC_MASK 0x4U
#define CAN1_IDR9_CRC 0x4U
#define CAN1_IDR9_CRC_BIT 2
#define CAN1_IDR9_STUFF_MASK 0x8U
#define CAN1_IDR9_STUFF 0x8U
#define CAN1_IDR9_STUFF_BIT 3
#define CAN1_IDR9_BUS_MASK 0x10U
#define CAN1_IDR9_BUS 0x10U
#define CAN1_IDR9_BUS_BIT 4
#define CAN1_IDR9_RXOK_MASK 0x20U
#define CAN1_IDR9_RXOK 0x20U
#define CAN1_IDR9_RXOK_BIT 5
#define CAN1_IDR9_TXOK_MASK 0x40U
#define CAN1_IDR9_TXOK 0x40U
#define CAN1_IDR9_TXOK_BIT 6
#define CAN1_IDR9_RFRAME_MASK 0x80U
#define CAN1_IDR9_RFRAME 0x80U
#define CAN1_IDR9_RFRAME_BIT 7

#define CAN1_IMR9 (*(volatile unsigned long *)0xFFFB8368)
#define CAN1_IMR9_OFFSET 0x368
#define CAN1_IMR9_ACK_MASK 0x1U
#define CAN1_IMR9_ACK 0x1U
#define CAN1_IMR9_ACK_BIT 0
#define CAN1_IMR9_FRAME_MASK 0x2U
#define CAN1_IMR9_FRAME 0x2U
#define CAN1_IMR9_FRAME_BIT 1
#define CAN1_IMR9_CRC_MASK 0x4U
#define CAN1_IMR9_CRC 0x4U
#define CAN1_IMR9_CRC_BIT 2
#define CAN1_IMR9_STUFF_MASK 0x8U
#define CAN1_IMR9_STUFF 0x8U
#define CAN1_IMR9_STUFF_BIT 3
#define CAN1_IMR9_BUS_MASK 0x10U
#define CAN1_IMR9_BUS 0x10U
#define CAN1_IMR9_BUS_BIT 4
#define CAN1_IMR9_RXOK_MASK 0x20U
#define CAN1_IMR9_RXOK 0x20U
#define CAN1_IMR9_RXOK_BIT 5
#define CAN1_IMR9_TXOK_MASK 0x40U
#define CAN1_IMR9_TXOK 0x40U
#define CAN1_IMR9_TXOK_BIT 6
#define CAN1_IMR9_RFRAME_MASK 0x80U
#define CAN1_IMR9_RFRAME 0x80U
#define CAN1_IMR9_RFRAME_BIT 7

#define CAN1_DRA10 (*(volatile unsigned long *)0xFFFB8380)
#define CAN1_DRA10_OFFSET 0x380
#define CAN1_DRA10_DATA0_MASK 0xFFU
#define CAN1_DRA10_DATA0_BIT 0
#define CAN1_DRA10_DATA1_MASK 0xFF00U
#define CAN1_DRA10_DATA1_BIT 8
#define CAN1_DRA10_DATA2_MASK 0xFF0000U
#define CAN1_DRA10_DATA2_BIT 16
#define CAN1_DRA10_DATA3_MASK 0xFF000000U
#define CAN1_DRA10_DATA3_BIT 24

#define CAN1_DRB10 (*(volatile unsigned long *)0xFFFB8384)
#define CAN1_DRB10_OFFSET 0x384
#define CAN1_DRB10_DATA4_MASK 0xFFU
#define CAN1_DRB10_DATA4_BIT 0
#define CAN1_DRB10_DATA5_MASK 0xFF00U
#define CAN1_DRB10_DATA5_BIT 8
#define CAN1_DRB10_DATA6_MASK 0xFF0000U
#define CAN1_DRB10_DATA6_BIT 16
#define CAN1_DRB10_DATA7_MASK 0xFF000000U
#define CAN1_DRB10_DATA7_BIT 24

#define CAN1_MSK10 (*(volatile unsigned long *)0xFFFB8388)
#define CAN1_MSK10_OFFSET 0x388
#define CAN1_MSK10_MASK_MASK 0x1FFFFFFFU
#define CAN1_MSK10_MASK_BIT 0
#define CAN1_MSK10_MRB_MASK 0x60000000U
#define CAN1_MSK10_MRB_BIT 29
#define CAN1_MSK10_MRTR_MASK 0x80000000U
#define CAN1_MSK10_MRTR 0x80000000U
#define CAN1_MSK10_MRTR_BIT 31

#define CAN1_IR10 (*(volatile unsigned long *)0xFFFB838C)
#define CAN1_IR10_OFFSET 0x38C
#define CAN1_IR10_ID_MASK 0x1FFFFFFFU
#define CAN1_IR10_ID_BIT 0
#define CAN1_IR10_RB_MASK 0x60000000U
#define CAN1_IR10_RB_BIT 29
#define CAN1_IR10_RTR_MASK 0x80000000U
#define CAN1_IR10_RTR 0x80000000U
#define CAN1_IR10_RTR_BIT 31

#define CAN1_CR10 (*(volatile unsigned long *)0xFFFB8390)
#define CAN1_CR10_OFFSET 0x390
#define CAN1_CR10_DLC_MASK 0xFU
#define CAN1_CR10_DLC_BIT 0
#define CAN1_CR10_IDE_MASK 0x10U
#define CAN1_CR10_IDE 0x10U
#define CAN1_CR10_IDE_BIT 4
#define CAN1_CR10_RPLYV_MASK 0x20U
#define CAN1_CR10_RPLYV 0x20U
#define CAN1_CR10_RPLYV_BIT 5
#define CAN1_CR10_PCB_MASK 0x40U
#define CAN1_CR10_PCB 0x40U
#define CAN1_CR10_PCB_BIT 6
#define CAN1_CR10_CHANEN_MASK 0x80U
#define CAN1_CR10_CHANEN 0x80U
#define CAN1_CR10_CHANEN_BIT 7
#define CAN1_CR10_OVERWRITE_MASK 0x100U
#define CAN1_CR10_OVERWRITE 0x100U
#define CAN1_CR10_OVERWRITE_BIT 8

#define CAN1_CR10 (*(volatile unsigned long *)0xFFFB8394)
#define CAN1_CR10_OFFSET 0x394
#define CAN1_CR10_STAMP_MASK 0x0U
#define CAN1_CR10_STAMP_BIT 0

#define CAN1_CSR10 (*(volatile unsigned long *)0xFFFB8398)
#define CAN1_CSR10_OFFSET 0x398
#define CAN1_CSR10_ACK_MASK 0x1U
#define CAN1_CSR10_ACK 0x1U
#define CAN1_CSR10_ACK_BIT 0
#define CAN1_CSR10_FRAME_MASK 0x2U
#define CAN1_CSR10_FRAME 0x2U
#define CAN1_CSR10_FRAME_BIT 1
#define CAN1_CSR10_CRC_MASK 0x4U
#define CAN1_CSR10_CRC 0x4U
#define CAN1_CSR10_CRC_BIT 2
#define CAN1_CSR10_STUFF_MASK 0x8U
#define CAN1_CSR10_STUFF 0x8U
#define CAN1_CSR10_STUFF_BIT 3
#define CAN1_CSR10_BUS_MASK 0x10U
#define CAN1_CSR10_BUS 0x10U
#define CAN1_CSR10_BUS_BIT 4
#define CAN1_CSR10_RXOK_MASK 0x20U
#define CAN1_CSR10_RXOK 0x20U
#define CAN1_CSR10_RXOK_BIT 5
#define CAN1_CSR10_TXOK_MASK 0x40U
#define CAN1_CSR10_TXOK 0x40U
#define CAN1_CSR10_TXOK_BIT 6
#define CAN1_CSR10_RFRAME_MASK 0x80U
#define CAN1_CSR10_RFRAME 0x80U
#define CAN1_CSR10_RFRAME_BIT 7
#define CAN1_CSR10_DLCW_MASK 0x200U
#define CAN1_CSR10_DLCW 0x200U
#define CAN1_CSR10_DLCW_BIT 9
#define CAN1_CSR10_FILLED_MASK 0x400U
#define CAN1_CSR10_FILLED 0x400U
#define CAN1_CSR10_FILLED_BIT 10
#define CAN1_CSR10_OVRUN_MASK 0x800U
#define CAN1_CSR10_OVRUN 0x800U
#define CAN1_CSR10_OVRUN_BIT 11

#define CAN1_SR10 (*(volatile unsigned long *)0xFFFB839C)
#define CAN1_SR10_OFFSET 0x39C
#define CAN1_SR10_ACK_MASK 0x1U
#define CAN1_SR10_ACK 0x1U
#define CAN1_SR10_ACK_BIT 0
#define CAN1_SR10_FRAME_MASK 0x2U
#define CAN1_SR10_FRAME 0x2U
#define CAN1_SR10_FRAME_BIT 1
#define CAN1_SR10_CRC_MASK 0x4U
#define CAN1_SR10_CRC 0x4U
#define CAN1_SR10_CRC_BIT 2
#define CAN1_SR10_STUFF_MASK 0x8U
#define CAN1_SR10_STUFF 0x8U
#define CAN1_SR10_STUFF_BIT 3
#define CAN1_SR10_BUS_MASK 0x10U
#define CAN1_SR10_BUS 0x10U
#define CAN1_SR10_BUS_BIT 4
#define CAN1_SR10_RXOK_MASK 0x20U
#define CAN1_SR10_RXOK 0x20U
#define CAN1_SR10_RXOK_BIT 5
#define CAN1_SR10_TXOK_MASK 0x40U
#define CAN1_SR10_TXOK 0x40U
#define CAN1_SR10_TXOK_BIT 6
#define CAN1_SR10_RFRAME_MASK 0x80U
#define CAN1_SR10_RFRAME 0x80U
#define CAN1_SR10_RFRAME_BIT 7
#define CAN1_SR10_DLCW_MASK 0x200U
#define CAN1_SR10_DLCW 0x200U
#define CAN1_SR10_DLCW_BIT 9
#define CAN1_SR10_FILLED_MASK 0x400U
#define CAN1_SR10_FILLED 0x400U
#define CAN1_SR10_FILLED_BIT 10
#define CAN1_SR10_OVRUN_MASK 0x800U
#define CAN1_SR10_OVRUN 0x800U
#define CAN1_SR10_OVRUN_BIT 11

#define CAN1_IER10 (*(volatile unsigned long *)0xFFFB83A0)
#define CAN1_IER10_OFFSET 0x3A0
#define CAN1_IER10_ACK_MASK 0x1U
#define CAN1_IER10_ACK 0x1U
#define CAN1_IER10_ACK_BIT 0
#define CAN1_IER10_FRAME_MASK 0x2U
#define CAN1_IER10_FRAME 0x2U
#define CAN1_IER10_FRAME_BIT 1
#define CAN1_IER10_CRC_MASK 0x4U
#define CAN1_IER10_CRC 0x4U
#define CAN1_IER10_CRC_BIT 2
#define CAN1_IER10_STUFF_MASK 0x8U
#define CAN1_IER10_STUFF 0x8U
#define CAN1_IER10_STUFF_BIT 3
#define CAN1_IER10_BUS_MASK 0x10U
#define CAN1_IER10_BUS 0x10U
#define CAN1_IER10_BUS_BIT 4
#define CAN1_IER10_RXOK_MASK 0x20U
#define CAN1_IER10_RXOK 0x20U
#define CAN1_IER10_RXOK_BIT 5
#define CAN1_IER10_TXOK_MASK 0x40U
#define CAN1_IER10_TXOK 0x40U
#define CAN1_IER10_TXOK_BIT 6
#define CAN1_IER10_RFRAME_MASK 0x80U
#define CAN1_IER10_RFRAME 0x80U
#define CAN1_IER10_RFRAME_BIT 7

#define CAN1_IDR10 (*(volatile unsigned long *)0xFFFB83A4)
#define CAN1_IDR10_OFFSET 0x3A4
#define CAN1_IDR10_ACK_MASK 0x1U
#define CAN1_IDR10_ACK 0x1U
#define CAN1_IDR10_ACK_BIT 0
#define CAN1_IDR10_FRAME_MASK 0x2U
#define CAN1_IDR10_FRAME 0x2U
#define CAN1_IDR10_FRAME_BIT 1
#define CAN1_IDR10_CRC_MASK 0x4U
#define CAN1_IDR10_CRC 0x4U
#define CAN1_IDR10_CRC_BIT 2
#define CAN1_IDR10_STUFF_MASK 0x8U
#define CAN1_IDR10_STUFF 0x8U
#define CAN1_IDR10_STUFF_BIT 3
#define CAN1_IDR10_BUS_MASK 0x10U
#define CAN1_IDR10_BUS 0x10U
#define CAN1_IDR10_BUS_BIT 4
#define CAN1_IDR10_RXOK_MASK 0x20U
#define CAN1_IDR10_RXOK 0x20U
#define CAN1_IDR10_RXOK_BIT 5
#define CAN1_IDR10_TXOK_MASK 0x40U
#define CAN1_IDR10_TXOK 0x40U
#define CAN1_IDR10_TXOK_BIT 6
#define CAN1_IDR10_RFRAME_MASK 0x80U
#define CAN1_IDR10_RFRAME 0x80U
#define CAN1_IDR10_RFRAME_BIT 7

#define CAN1_IMR10 (*(volatile unsigned long *)0xFFFB83A8)
#define CAN1_IMR10_OFFSET 0x3A8
#define CAN1_IMR10_ACK_MASK 0x1U
#define CAN1_IMR10_ACK 0x1U
#define CAN1_IMR10_ACK_BIT 0
#define CAN1_IMR10_FRAME_MASK 0x2U
#define CAN1_IMR10_FRAME 0x2U
#define CAN1_IMR10_FRAME_BIT 1
#define CAN1_IMR10_CRC_MASK 0x4U
#define CAN1_IMR10_CRC 0x4U
#define CAN1_IMR10_CRC_BIT 2
#define CAN1_IMR10_STUFF_MASK 0x8U
#define CAN1_IMR10_STUFF 0x8U
#define CAN1_IMR10_STUFF_BIT 3
#define CAN1_IMR10_BUS_MASK 0x10U
#define CAN1_IMR10_BUS 0x10U
#define CAN1_IMR10_BUS_BIT 4
#define CAN1_IMR10_RXOK_MASK 0x20U
#define CAN1_IMR10_RXOK 0x20U
#define CAN1_IMR10_RXOK_BIT 5
#define CAN1_IMR10_TXOK_MASK 0x40U
#define CAN1_IMR10_TXOK 0x40U
#define CAN1_IMR10_TXOK_BIT 6
#define CAN1_IMR10_RFRAME_MASK 0x80U
#define CAN1_IMR10_RFRAME 0x80U
#define CAN1_IMR10_RFRAME_BIT 7

#define CAN1_DRA11 (*(volatile unsigned long *)0xFFFB83C0)
#define CAN1_DRA11_OFFSET 0x3C0
#define CAN1_DRA11_DATA0_MASK 0xFFU
#define CAN1_DRA11_DATA0_BIT 0
#define CAN1_DRA11_DATA1_MASK 0xFF00U
#define CAN1_DRA11_DATA1_BIT 8
#define CAN1_DRA11_DATA2_MASK 0xFF0000U
#define CAN1_DRA11_DATA2_BIT 16
#define CAN1_DRA11_DATA3_MASK 0xFF000000U
#define CAN1_DRA11_DATA3_BIT 24

#define CAN1_DRB11 (*(volatile unsigned long *)0xFFFB83C4)
#define CAN1_DRB11_OFFSET 0x3C4
#define CAN1_DRB11_DATA4_MASK 0xFFU
#define CAN1_DRB11_DATA4_BIT 0
#define CAN1_DRB11_DATA5_MASK 0xFF00U
#define CAN1_DRB11_DATA5_BIT 8
#define CAN1_DRB11_DATA6_MASK 0xFF0000U
#define CAN1_DRB11_DATA6_BIT 16
#define CAN1_DRB11_DATA7_MASK 0xFF000000U
#define CAN1_DRB11_DATA7_BIT 24

#define CAN1_MSK11 (*(volatile unsigned long *)0xFFFB83C8)
#define CAN1_MSK11_OFFSET 0x3C8
#define CAN1_MSK11_MASK_MASK 0x1FFFFFFFU
#define CAN1_MSK11_MASK_BIT 0
#define CAN1_MSK11_MRB_MASK 0x60000000U
#define CAN1_MSK11_MRB_BIT 29
#define CAN1_MSK11_MRTR_MASK 0x80000000U
#define CAN1_MSK11_MRTR 0x80000000U
#define CAN1_MSK11_MRTR_BIT 31

#define CAN1_IR11 (*(volatile unsigned long *)0xFFFB83CC)
#define CAN1_IR11_OFFSET 0x3CC
#define CAN1_IR11_ID_MASK 0x1FFFFFFFU
#define CAN1_IR11_ID_BIT 0
#define CAN1_IR11_RB_MASK 0x60000000U
#define CAN1_IR11_RB_BIT 29
#define CAN1_IR11_RTR_MASK 0x80000000U
#define CAN1_IR11_RTR 0x80000000U
#define CAN1_IR11_RTR_BIT 31

#define CAN1_CR11 (*(volatile unsigned long *)0xFFFB83D0)
#define CAN1_CR11_OFFSET 0x3D0
#define CAN1_CR11_DLC_MASK 0xFU
#define CAN1_CR11_DLC_BIT 0
#define CAN1_CR11_IDE_MASK 0x10U
#define CAN1_CR11_IDE 0x10U
#define CAN1_CR11_IDE_BIT 4
#define CAN1_CR11_RPLYV_MASK 0x20U
#define CAN1_CR11_RPLYV 0x20U
#define CAN1_CR11_RPLYV_BIT 5
#define CAN1_CR11_PCB_MASK 0x40U
#define CAN1_CR11_PCB 0x40U
#define CAN1_CR11_PCB_BIT 6
#define CAN1_CR11_CHANEN_MASK 0x80U
#define CAN1_CR11_CHANEN 0x80U
#define CAN1_CR11_CHANEN_BIT 7
#define CAN1_CR11_OVERWRITE_MASK 0x100U
#define CAN1_CR11_OVERWRITE 0x100U
#define CAN1_CR11_OVERWRITE_BIT 8

#define CAN1_CR11 (*(volatile unsigned long *)0xFFFB83D4)
#define CAN1_CR11_OFFSET 0x3D4
#define CAN1_CR11_STAMP_MASK 0x0U
#define CAN1_CR11_STAMP_BIT 0

#define CAN1_CSR11 (*(volatile unsigned long *)0xFFFB83D8)
#define CAN1_CSR11_OFFSET 0x3D8
#define CAN1_CSR11_ACK_MASK 0x1U
#define CAN1_CSR11_ACK 0x1U
#define CAN1_CSR11_ACK_BIT 0
#define CAN1_CSR11_FRAME_MASK 0x2U
#define CAN1_CSR11_FRAME 0x2U
#define CAN1_CSR11_FRAME_BIT 1
#define CAN1_CSR11_CRC_MASK 0x4U
#define CAN1_CSR11_CRC 0x4U
#define CAN1_CSR11_CRC_BIT 2
#define CAN1_CSR11_STUFF_MASK 0x8U
#define CAN1_CSR11_STUFF 0x8U
#define CAN1_CSR11_STUFF_BIT 3
#define CAN1_CSR11_BUS_MASK 0x10U
#define CAN1_CSR11_BUS 0x10U
#define CAN1_CSR11_BUS_BIT 4
#define CAN1_CSR11_RXOK_MASK 0x20U
#define CAN1_CSR11_RXOK 0x20U
#define CAN1_CSR11_RXOK_BIT 5
#define CAN1_CSR11_TXOK_MASK 0x40U
#define CAN1_CSR11_TXOK 0x40U
#define CAN1_CSR11_TXOK_BIT 6
#define CAN1_CSR11_RFRAME_MASK 0x80U
#define CAN1_CSR11_RFRAME 0x80U
#define CAN1_CSR11_RFRAME_BIT 7
#define CAN1_CSR11_DLCW_MASK 0x200U
#define CAN1_CSR11_DLCW 0x200U
#define CAN1_CSR11_DLCW_BIT 9
#define CAN1_CSR11_FILLED_MASK 0x400U
#define CAN1_CSR11_FILLED 0x400U
#define CAN1_CSR11_FILLED_BIT 10
#define CAN1_CSR11_OVRUN_MASK 0x800U
#define CAN1_CSR11_OVRUN 0x800U
#define CAN1_CSR11_OVRUN_BIT 11

#define CAN1_SR11 (*(volatile unsigned long *)0xFFFB83DC)
#define CAN1_SR11_OFFSET 0x3DC
#define CAN1_SR11_ACK_MASK 0x1U
#define CAN1_SR11_ACK 0x1U
#define CAN1_SR11_ACK_BIT 0
#define CAN1_SR11_FRAME_MASK 0x2U
#define CAN1_SR11_FRAME 0x2U
#define CAN1_SR11_FRAME_BIT 1
#define CAN1_SR11_CRC_MASK 0x4U
#define CAN1_SR11_CRC 0x4U
#define CAN1_SR11_CRC_BIT 2
#define CAN1_SR11_STUFF_MASK 0x8U
#define CAN1_SR11_STUFF 0x8U
#define CAN1_SR11_STUFF_BIT 3
#define CAN1_SR11_BUS_MASK 0x10U
#define CAN1_SR11_BUS 0x10U
#define CAN1_SR11_BUS_BIT 4
#define CAN1_SR11_RXOK_MASK 0x20U
#define CAN1_SR11_RXOK 0x20U
#define CAN1_SR11_RXOK_BIT 5
#define CAN1_SR11_TXOK_MASK 0x40U
#define CAN1_SR11_TXOK 0x40U
#define CAN1_SR11_TXOK_BIT 6
#define CAN1_SR11_RFRAME_MASK 0x80U
#define CAN1_SR11_RFRAME 0x80U
#define CAN1_SR11_RFRAME_BIT 7
#define CAN1_SR11_DLCW_MASK 0x200U
#define CAN1_SR11_DLCW 0x200U
#define CAN1_SR11_DLCW_BIT 9
#define CAN1_SR11_FILLED_MASK 0x400U
#define CAN1_SR11_FILLED 0x400U
#define CAN1_SR11_FILLED_BIT 10
#define CAN1_SR11_OVRUN_MASK 0x800U
#define CAN1_SR11_OVRUN 0x800U
#define CAN1_SR11_OVRUN_BIT 11

#define CAN1_IER11 (*(volatile unsigned long *)0xFFFB83E0)
#define CAN1_IER11_OFFSET 0x3E0
#define CAN1_IER11_ACK_MASK 0x1U
#define CAN1_IER11_ACK 0x1U
#define CAN1_IER11_ACK_BIT 0
#define CAN1_IER11_FRAME_MASK 0x2U
#define CAN1_IER11_FRAME 0x2U
#define CAN1_IER11_FRAME_BIT 1
#define CAN1_IER11_CRC_MASK 0x4U
#define CAN1_IER11_CRC 0x4U
#define CAN1_IER11_CRC_BIT 2
#define CAN1_IER11_STUFF_MASK 0x8U
#define CAN1_IER11_STUFF 0x8U
#define CAN1_IER11_STUFF_BIT 3
#define CAN1_IER11_BUS_MASK 0x10U
#define CAN1_IER11_BUS 0x10U
#define CAN1_IER11_BUS_BIT 4
#define CAN1_IER11_RXOK_MASK 0x20U
#define CAN1_IER11_RXOK 0x20U
#define CAN1_IER11_RXOK_BIT 5
#define CAN1_IER11_TXOK_MASK 0x40U
#define CAN1_IER11_TXOK 0x40U
#define CAN1_IER11_TXOK_BIT 6
#define CAN1_IER11_RFRAME_MASK 0x80U
#define CAN1_IER11_RFRAME 0x80U
#define CAN1_IER11_RFRAME_BIT 7

#define CAN1_IDR11 (*(volatile unsigned long *)0xFFFB83E4)
#define CAN1_IDR11_OFFSET 0x3E4
#define CAN1_IDR11_ACK_MASK 0x1U
#define CAN1_IDR11_ACK 0x1U
#define CAN1_IDR11_ACK_BIT 0
#define CAN1_IDR11_FRAME_MASK 0x2U
#define CAN1_IDR11_FRAME 0x2U
#define CAN1_IDR11_FRAME_BIT 1
#define CAN1_IDR11_CRC_MASK 0x4U
#define CAN1_IDR11_CRC 0x4U
#define CAN1_IDR11_CRC_BIT 2
#define CAN1_IDR11_STUFF_MASK 0x8U
#define CAN1_IDR11_STUFF 0x8U
#define CAN1_IDR11_STUFF_BIT 3
#define CAN1_IDR11_BUS_MASK 0x10U
#define CAN1_IDR11_BUS 0x10U
#define CAN1_IDR11_BUS_BIT 4
#define CAN1_IDR11_RXOK_MASK 0x20U
#define CAN1_IDR11_RXOK 0x20U
#define CAN1_IDR11_RXOK_BIT 5
#define CAN1_IDR11_TXOK_MASK 0x40U
#define CAN1_IDR11_TXOK 0x40U
#define CAN1_IDR11_TXOK_BIT 6
#define CAN1_IDR11_RFRAME_MASK 0x80U
#define CAN1_IDR11_RFRAME 0x80U
#define CAN1_IDR11_RFRAME_BIT 7

#define CAN1_IMR11 (*(volatile unsigned long *)0xFFFB83E8)
#define CAN1_IMR11_OFFSET 0x3E8
#define CAN1_IMR11_ACK_MASK 0x1U
#define CAN1_IMR11_ACK 0x1U
#define CAN1_IMR11_ACK_BIT 0
#define CAN1_IMR11_FRAME_MASK 0x2U
#define CAN1_IMR11_FRAME 0x2U
#define CAN1_IMR11_FRAME_BIT 1
#define CAN1_IMR11_CRC_MASK 0x4U
#define CAN1_IMR11_CRC 0x4U
#define CAN1_IMR11_CRC_BIT 2
#define CAN1_IMR11_STUFF_MASK 0x8U
#define CAN1_IMR11_STUFF 0x8U
#define CAN1_IMR11_STUFF_BIT 3
#define CAN1_IMR11_BUS_MASK 0x10U
#define CAN1_IMR11_BUS 0x10U
#define CAN1_IMR11_BUS_BIT 4
#define CAN1_IMR11_RXOK_MASK 0x20U
#define CAN1_IMR11_RXOK 0x20U
#define CAN1_IMR11_RXOK_BIT 5
#define CAN1_IMR11_TXOK_MASK 0x40U
#define CAN1_IMR11_TXOK 0x40U
#define CAN1_IMR11_TXOK_BIT 6
#define CAN1_IMR11_RFRAME_MASK 0x80U
#define CAN1_IMR11_RFRAME 0x80U
#define CAN1_IMR11_RFRAME_BIT 7

#define CAN1_DRA12 (*(volatile unsigned long *)0xFFFB8400)
#define CAN1_DRA12_OFFSET 0x400
#define CAN1_DRA12_DATA0_MASK 0xFFU
#define CAN1_DRA12_DATA0_BIT 0
#define CAN1_DRA12_DATA1_MASK 0xFF00U
#define CAN1_DRA12_DATA1_BIT 8
#define CAN1_DRA12_DATA2_MASK 0xFF0000U
#define CAN1_DRA12_DATA2_BIT 16
#define CAN1_DRA12_DATA3_MASK 0xFF000000U
#define CAN1_DRA12_DATA3_BIT 24

#define CAN1_DRB12 (*(volatile unsigned long *)0xFFFB8404)
#define CAN1_DRB12_OFFSET 0x404
#define CAN1_DRB12_DATA4_MASK 0xFFU
#define CAN1_DRB12_DATA4_BIT 0
#define CAN1_DRB12_DATA5_MASK 0xFF00U
#define CAN1_DRB12_DATA5_BIT 8
#define CAN1_DRB12_DATA6_MASK 0xFF0000U
#define CAN1_DRB12_DATA6_BIT 16
#define CAN1_DRB12_DATA7_MASK 0xFF000000U
#define CAN1_DRB12_DATA7_BIT 24

#define CAN1_MSK12 (*(volatile unsigned long *)0xFFFB8408)
#define CAN1_MSK12_OFFSET 0x408
#define CAN1_MSK12_MASK_MASK 0x1FFFFFFFU
#define CAN1_MSK12_MASK_BIT 0
#define CAN1_MSK12_MRB_MASK 0x60000000U
#define CAN1_MSK12_MRB_BIT 29
#define CAN1_MSK12_MRTR_MASK 0x80000000U
#define CAN1_MSK12_MRTR 0x80000000U
#define CAN1_MSK12_MRTR_BIT 31

#define CAN1_IR12 (*(volatile unsigned long *)0xFFFB840C)
#define CAN1_IR12_OFFSET 0x40C
#define CAN1_IR12_ID_MASK 0x1FFFFFFFU
#define CAN1_IR12_ID_BIT 0
#define CAN1_IR12_RB_MASK 0x60000000U
#define CAN1_IR12_RB_BIT 29
#define CAN1_IR12_RTR_MASK 0x80000000U
#define CAN1_IR12_RTR 0x80000000U
#define CAN1_IR12_RTR_BIT 31

#define CAN1_CR12 (*(volatile unsigned long *)0xFFFB8410)
#define CAN1_CR12_OFFSET 0x410
#define CAN1_CR12_DLC_MASK 0xFU
#define CAN1_CR12_DLC_BIT 0
#define CAN1_CR12_IDE_MASK 0x10U
#define CAN1_CR12_IDE 0x10U
#define CAN1_CR12_IDE_BIT 4
#define CAN1_CR12_RPLYV_MASK 0x20U
#define CAN1_CR12_RPLYV 0x20U
#define CAN1_CR12_RPLYV_BIT 5
#define CAN1_CR12_PCB_MASK 0x40U
#define CAN1_CR12_PCB 0x40U
#define CAN1_CR12_PCB_BIT 6
#define CAN1_CR12_CHANEN_MASK 0x80U
#define CAN1_CR12_CHANEN 0x80U
#define CAN1_CR12_CHANEN_BIT 7
#define CAN1_CR12_OVERWRITE_MASK 0x100U
#define CAN1_CR12_OVERWRITE 0x100U
#define CAN1_CR12_OVERWRITE_BIT 8

#define CAN1_CR12 (*(volatile unsigned long *)0xFFFB8414)
#define CAN1_CR12_OFFSET 0x414
#define CAN1_CR12_STAMP_MASK 0x0U
#define CAN1_CR12_STAMP_BIT 0

#define CAN1_CSR12 (*(volatile unsigned long *)0xFFFB8418)
#define CAN1_CSR12_OFFSET 0x418
#define CAN1_CSR12_ACK_MASK 0x1U
#define CAN1_CSR12_ACK 0x1U
#define CAN1_CSR12_ACK_BIT 0
#define CAN1_CSR12_FRAME_MASK 0x2U
#define CAN1_CSR12_FRAME 0x2U
#define CAN1_CSR12_FRAME_BIT 1
#define CAN1_CSR12_CRC_MASK 0x4U
#define CAN1_CSR12_CRC 0x4U
#define CAN1_CSR12_CRC_BIT 2
#define CAN1_CSR12_STUFF_MASK 0x8U
#define CAN1_CSR12_STUFF 0x8U
#define CAN1_CSR12_STUFF_BIT 3
#define CAN1_CSR12_BUS_MASK 0x10U
#define CAN1_CSR12_BUS 0x10U
#define CAN1_CSR12_BUS_BIT 4
#define CAN1_CSR12_RXOK_MASK 0x20U
#define CAN1_CSR12_RXOK 0x20U
#define CAN1_CSR12_RXOK_BIT 5
#define CAN1_CSR12_TXOK_MASK 0x40U
#define CAN1_CSR12_TXOK 0x40U
#define CAN1_CSR12_TXOK_BIT 6
#define CAN1_CSR12_RFRAME_MASK 0x80U
#define CAN1_CSR12_RFRAME 0x80U
#define CAN1_CSR12_RFRAME_BIT 7
#define CAN1_CSR12_DLCW_MASK 0x200U
#define CAN1_CSR12_DLCW 0x200U
#define CAN1_CSR12_DLCW_BIT 9
#define CAN1_CSR12_FILLED_MASK 0x400U
#define CAN1_CSR12_FILLED 0x400U
#define CAN1_CSR12_FILLED_BIT 10
#define CAN1_CSR12_OVRUN_MASK 0x800U
#define CAN1_CSR12_OVRUN 0x800U
#define CAN1_CSR12_OVRUN_BIT 11

#define CAN1_SR12 (*(volatile unsigned long *)0xFFFB841C)
#define CAN1_SR12_OFFSET 0x41C
#define CAN1_SR12_ACK_MASK 0x1U
#define CAN1_SR12_ACK 0x1U
#define CAN1_SR12_ACK_BIT 0
#define CAN1_SR12_FRAME_MASK 0x2U
#define CAN1_SR12_FRAME 0x2U
#define CAN1_SR12_FRAME_BIT 1
#define CAN1_SR12_CRC_MASK 0x4U
#define CAN1_SR12_CRC 0x4U
#define CAN1_SR12_CRC_BIT 2
#define CAN1_SR12_STUFF_MASK 0x8U
#define CAN1_SR12_STUFF 0x8U
#define CAN1_SR12_STUFF_BIT 3
#define CAN1_SR12_BUS_MASK 0x10U
#define CAN1_SR12_BUS 0x10U
#define CAN1_SR12_BUS_BIT 4
#define CAN1_SR12_RXOK_MASK 0x20U
#define CAN1_SR12_RXOK 0x20U
#define CAN1_SR12_RXOK_BIT 5
#define CAN1_SR12_TXOK_MASK 0x40U
#define CAN1_SR12_TXOK 0x40U
#define CAN1_SR12_TXOK_BIT 6
#define CAN1_SR12_RFRAME_MASK 0x80U
#define CAN1_SR12_RFRAME 0x80U
#define CAN1_SR12_RFRAME_BIT 7
#define CAN1_SR12_DLCW_MASK 0x200U
#define CAN1_SR12_DLCW 0x200U
#define CAN1_SR12_DLCW_BIT 9
#define CAN1_SR12_FILLED_MASK 0x400U
#define CAN1_SR12_FILLED 0x400U
#define CAN1_SR12_FILLED_BIT 10
#define CAN1_SR12_OVRUN_MASK 0x800U
#define CAN1_SR12_OVRUN 0x800U
#define CAN1_SR12_OVRUN_BIT 11

#define CAN1_IER12 (*(volatile unsigned long *)0xFFFB8420)
#define CAN1_IER12_OFFSET 0x420
#define CAN1_IER12_ACK_MASK 0x1U
#define CAN1_IER12_ACK 0x1U
#define CAN1_IER12_ACK_BIT 0
#define CAN1_IER12_FRAME_MASK 0x2U
#define CAN1_IER12_FRAME 0x2U
#define CAN1_IER12_FRAME_BIT 1
#define CAN1_IER12_CRC_MASK 0x4U
#define CAN1_IER12_CRC 0x4U
#define CAN1_IER12_CRC_BIT 2
#define CAN1_IER12_STUFF_MASK 0x8U
#define CAN1_IER12_STUFF 0x8U
#define CAN1_IER12_STUFF_BIT 3
#define CAN1_IER12_BUS_MASK 0x10U
#define CAN1_IER12_BUS 0x10U
#define CAN1_IER12_BUS_BIT 4
#define CAN1_IER12_RXOK_MASK 0x20U
#define CAN1_IER12_RXOK 0x20U
#define CAN1_IER12_RXOK_BIT 5
#define CAN1_IER12_TXOK_MASK 0x40U
#define CAN1_IER12_TXOK 0x40U
#define CAN1_IER12_TXOK_BIT 6
#define CAN1_IER12_RFRAME_MASK 0x80U
#define CAN1_IER12_RFRAME 0x80U
#define CAN1_IER12_RFRAME_BIT 7

#define CAN1_IDR12 (*(volatile unsigned long *)0xFFFB8424)
#define CAN1_IDR12_OFFSET 0x424
#define CAN1_IDR12_ACK_MASK 0x1U
#define CAN1_IDR12_ACK 0x1U
#define CAN1_IDR12_ACK_BIT 0
#define CAN1_IDR12_FRAME_MASK 0x2U
#define CAN1_IDR12_FRAME 0x2U
#define CAN1_IDR12_FRAME_BIT 1
#define CAN1_IDR12_CRC_MASK 0x4U
#define CAN1_IDR12_CRC 0x4U
#define CAN1_IDR12_CRC_BIT 2
#define CAN1_IDR12_STUFF_MASK 0x8U
#define CAN1_IDR12_STUFF 0x8U
#define CAN1_IDR12_STUFF_BIT 3
#define CAN1_IDR12_BUS_MASK 0x10U
#define CAN1_IDR12_BUS 0x10U
#define CAN1_IDR12_BUS_BIT 4
#define CAN1_IDR12_RXOK_MASK 0x20U
#define CAN1_IDR12_RXOK 0x20U
#define CAN1_IDR12_RXOK_BIT 5
#define CAN1_IDR12_TXOK_MASK 0x40U
#define CAN1_IDR12_TXOK 0x40U
#define CAN1_IDR12_TXOK_BIT 6
#define CAN1_IDR12_RFRAME_MASK 0x80U
#define CAN1_IDR12_RFRAME 0x80U
#define CAN1_IDR12_RFRAME_BIT 7

#define CAN1_IMR12 (*(volatile unsigned long *)0xFFFB8428)
#define CAN1_IMR12_OFFSET 0x428
#define CAN1_IMR12_ACK_MASK 0x1U
#define CAN1_IMR12_ACK 0x1U
#define CAN1_IMR12_ACK_BIT 0
#define CAN1_IMR12_FRAME_MASK 0x2U
#define CAN1_IMR12_FRAME 0x2U
#define CAN1_IMR12_FRAME_BIT 1
#define CAN1_IMR12_CRC_MASK 0x4U
#define CAN1_IMR12_CRC 0x4U
#define CAN1_IMR12_CRC_BIT 2
#define CAN1_IMR12_STUFF_MASK 0x8U
#define CAN1_IMR12_STUFF 0x8U
#define CAN1_IMR12_STUFF_BIT 3
#define CAN1_IMR12_BUS_MASK 0x10U
#define CAN1_IMR12_BUS 0x10U
#define CAN1_IMR12_BUS_BIT 4
#define CAN1_IMR12_RXOK_MASK 0x20U
#define CAN1_IMR12_RXOK 0x20U
#define CAN1_IMR12_RXOK_BIT 5
#define CAN1_IMR12_TXOK_MASK 0x40U
#define CAN1_IMR12_TXOK 0x40U
#define CAN1_IMR12_TXOK_BIT 6
#define CAN1_IMR12_RFRAME_MASK 0x80U
#define CAN1_IMR12_RFRAME 0x80U
#define CAN1_IMR12_RFRAME_BIT 7

#define CAN1_DRA13 (*(volatile unsigned long *)0xFFFB8440)
#define CAN1_DRA13_OFFSET 0x440
#define CAN1_DRA13_DATA0_MASK 0xFFU
#define CAN1_DRA13_DATA0_BIT 0
#define CAN1_DRA13_DATA1_MASK 0xFF00U
#define CAN1_DRA13_DATA1_BIT 8
#define CAN1_DRA13_DATA2_MASK 0xFF0000U
#define CAN1_DRA13_DATA2_BIT 16
#define CAN1_DRA13_DATA3_MASK 0xFF000000U
#define CAN1_DRA13_DATA3_BIT 24

#define CAN1_DRB13 (*(volatile unsigned long *)0xFFFB8444)
#define CAN1_DRB13_OFFSET 0x444
#define CAN1_DRB13_DATA4_MASK 0xFFU
#define CAN1_DRB13_DATA4_BIT 0
#define CAN1_DRB13_DATA5_MASK 0xFF00U
#define CAN1_DRB13_DATA5_BIT 8
#define CAN1_DRB13_DATA6_MASK 0xFF0000U
#define CAN1_DRB13_DATA6_BIT 16
#define CAN1_DRB13_DATA7_MASK 0xFF000000U
#define CAN1_DRB13_DATA7_BIT 24

#define CAN1_MSK13 (*(volatile unsigned long *)0xFFFB8448)
#define CAN1_MSK13_OFFSET 0x448
#define CAN1_MSK13_MASK_MASK 0x1FFFFFFFU
#define CAN1_MSK13_MASK_BIT 0
#define CAN1_MSK13_MRB_MASK 0x60000000U
#define CAN1_MSK13_MRB_BIT 29
#define CAN1_MSK13_MRTR_MASK 0x80000000U
#define CAN1_MSK13_MRTR 0x80000000U
#define CAN1_MSK13_MRTR_BIT 31

#define CAN1_IR13 (*(volatile unsigned long *)0xFFFB844C)
#define CAN1_IR13_OFFSET 0x44C
#define CAN1_IR13_ID_MASK 0x1FFFFFFFU
#define CAN1_IR13_ID_BIT 0
#define CAN1_IR13_RB_MASK 0x60000000U
#define CAN1_IR13_RB_BIT 29
#define CAN1_IR13_RTR_MASK 0x80000000U
#define CAN1_IR13_RTR 0x80000000U
#define CAN1_IR13_RTR_BIT 31

#define CAN1_CR13 (*(volatile unsigned long *)0xFFFB8450)
#define CAN1_CR13_OFFSET 0x450
#define CAN1_CR13_DLC_MASK 0xFU
#define CAN1_CR13_DLC_BIT 0
#define CAN1_CR13_IDE_MASK 0x10U
#define CAN1_CR13_IDE 0x10U
#define CAN1_CR13_IDE_BIT 4
#define CAN1_CR13_RPLYV_MASK 0x20U
#define CAN1_CR13_RPLYV 0x20U
#define CAN1_CR13_RPLYV_BIT 5
#define CAN1_CR13_PCB_MASK 0x40U
#define CAN1_CR13_PCB 0x40U
#define CAN1_CR13_PCB_BIT 6
#define CAN1_CR13_CHANEN_MASK 0x80U
#define CAN1_CR13_CHANEN 0x80U
#define CAN1_CR13_CHANEN_BIT 7
#define CAN1_CR13_OVERWRITE_MASK 0x100U
#define CAN1_CR13_OVERWRITE 0x100U
#define CAN1_CR13_OVERWRITE_BIT 8

#define CAN1_CR13 (*(volatile unsigned long *)0xFFFB8454)
#define CAN1_CR13_OFFSET 0x454
#define CAN1_CR13_STAMP_MASK 0x0U
#define CAN1_CR13_STAMP_BIT 0

#define CAN1_CSR13 (*(volatile unsigned long *)0xFFFB8458)
#define CAN1_CSR13_OFFSET 0x458
#define CAN1_CSR13_ACK_MASK 0x1U
#define CAN1_CSR13_ACK 0x1U
#define CAN1_CSR13_ACK_BIT 0
#define CAN1_CSR13_FRAME_MASK 0x2U
#define CAN1_CSR13_FRAME 0x2U
#define CAN1_CSR13_FRAME_BIT 1
#define CAN1_CSR13_CRC_MASK 0x4U
#define CAN1_CSR13_CRC 0x4U
#define CAN1_CSR13_CRC_BIT 2
#define CAN1_CSR13_STUFF_MASK 0x8U
#define CAN1_CSR13_STUFF 0x8U
#define CAN1_CSR13_STUFF_BIT 3
#define CAN1_CSR13_BUS_MASK 0x10U
#define CAN1_CSR13_BUS 0x10U
#define CAN1_CSR13_BUS_BIT 4
#define CAN1_CSR13_RXOK_MASK 0x20U
#define CAN1_CSR13_RXOK 0x20U
#define CAN1_CSR13_RXOK_BIT 5
#define CAN1_CSR13_TXOK_MASK 0x40U
#define CAN1_CSR13_TXOK 0x40U
#define CAN1_CSR13_TXOK_BIT 6
#define CAN1_CSR13_RFRAME_MASK 0x80U
#define CAN1_CSR13_RFRAME 0x80U
#define CAN1_CSR13_RFRAME_BIT 7
#define CAN1_CSR13_DLCW_MASK 0x200U
#define CAN1_CSR13_DLCW 0x200U
#define CAN1_CSR13_DLCW_BIT 9
#define CAN1_CSR13_FILLED_MASK 0x400U
#define CAN1_CSR13_FILLED 0x400U
#define CAN1_CSR13_FILLED_BIT 10
#define CAN1_CSR13_OVRUN_MASK 0x800U
#define CAN1_CSR13_OVRUN 0x800U
#define CAN1_CSR13_OVRUN_BIT 11

#define CAN1_SR13 (*(volatile unsigned long *)0xFFFB845C)
#define CAN1_SR13_OFFSET 0x45C
#define CAN1_SR13_ACK_MASK 0x1U
#define CAN1_SR13_ACK 0x1U
#define CAN1_SR13_ACK_BIT 0
#define CAN1_SR13_FRAME_MASK 0x2U
#define CAN1_SR13_FRAME 0x2U
#define CAN1_SR13_FRAME_BIT 1
#define CAN1_SR13_CRC_MASK 0x4U
#define CAN1_SR13_CRC 0x4U
#define CAN1_SR13_CRC_BIT 2
#define CAN1_SR13_STUFF_MASK 0x8U
#define CAN1_SR13_STUFF 0x8U
#define CAN1_SR13_STUFF_BIT 3
#define CAN1_SR13_BUS_MASK 0x10U
#define CAN1_SR13_BUS 0x10U
#define CAN1_SR13_BUS_BIT 4
#define CAN1_SR13_RXOK_MASK 0x20U
#define CAN1_SR13_RXOK 0x20U
#define CAN1_SR13_RXOK_BIT 5
#define CAN1_SR13_TXOK_MASK 0x40U
#define CAN1_SR13_TXOK 0x40U
#define CAN1_SR13_TXOK_BIT 6
#define CAN1_SR13_RFRAME_MASK 0x80U
#define CAN1_SR13_RFRAME 0x80U
#define CAN1_SR13_RFRAME_BIT 7
#define CAN1_SR13_DLCW_MASK 0x200U
#define CAN1_SR13_DLCW 0x200U
#define CAN1_SR13_DLCW_BIT 9
#define CAN1_SR13_FILLED_MASK 0x400U
#define CAN1_SR13_FILLED 0x400U
#define CAN1_SR13_FILLED_BIT 10
#define CAN1_SR13_OVRUN_MASK 0x800U
#define CAN1_SR13_OVRUN 0x800U
#define CAN1_SR13_OVRUN_BIT 11

#define CAN1_IER13 (*(volatile unsigned long *)0xFFFB8460)
#define CAN1_IER13_OFFSET 0x460
#define CAN1_IER13_ACK_MASK 0x1U
#define CAN1_IER13_ACK 0x1U
#define CAN1_IER13_ACK_BIT 0
#define CAN1_IER13_FRAME_MASK 0x2U
#define CAN1_IER13_FRAME 0x2U
#define CAN1_IER13_FRAME_BIT 1
#define CAN1_IER13_CRC_MASK 0x4U
#define CAN1_IER13_CRC 0x4U
#define CAN1_IER13_CRC_BIT 2
#define CAN1_IER13_STUFF_MASK 0x8U
#define CAN1_IER13_STUFF 0x8U
#define CAN1_IER13_STUFF_BIT 3
#define CAN1_IER13_BUS_MASK 0x10U
#define CAN1_IER13_BUS 0x10U
#define CAN1_IER13_BUS_BIT 4
#define CAN1_IER13_RXOK_MASK 0x20U
#define CAN1_IER13_RXOK 0x20U
#define CAN1_IER13_RXOK_BIT 5
#define CAN1_IER13_TXOK_MASK 0x40U
#define CAN1_IER13_TXOK 0x40U
#define CAN1_IER13_TXOK_BIT 6
#define CAN1_IER13_RFRAME_MASK 0x80U
#define CAN1_IER13_RFRAME 0x80U
#define CAN1_IER13_RFRAME_BIT 7

#define CAN1_IDR13 (*(volatile unsigned long *)0xFFFB8464)
#define CAN1_IDR13_OFFSET 0x464
#define CAN1_IDR13_ACK_MASK 0x1U
#define CAN1_IDR13_ACK 0x1U
#define CAN1_IDR13_ACK_BIT 0
#define CAN1_IDR13_FRAME_MASK 0x2U
#define CAN1_IDR13_FRAME 0x2U
#define CAN1_IDR13_FRAME_BIT 1
#define CAN1_IDR13_CRC_MASK 0x4U
#define CAN1_IDR13_CRC 0x4U
#define CAN1_IDR13_CRC_BIT 2
#define CAN1_IDR13_STUFF_MASK 0x8U
#define CAN1_IDR13_STUFF 0x8U
#define CAN1_IDR13_STUFF_BIT 3
#define CAN1_IDR13_BUS_MASK 0x10U
#define CAN1_IDR13_BUS 0x10U
#define CAN1_IDR13_BUS_BIT 4
#define CAN1_IDR13_RXOK_MASK 0x20U
#define CAN1_IDR13_RXOK 0x20U
#define CAN1_IDR13_RXOK_BIT 5
#define CAN1_IDR13_TXOK_MASK 0x40U
#define CAN1_IDR13_TXOK 0x40U
#define CAN1_IDR13_TXOK_BIT 6
#define CAN1_IDR13_RFRAME_MASK 0x80U
#define CAN1_IDR13_RFRAME 0x80U
#define CAN1_IDR13_RFRAME_BIT 7

#define CAN1_IMR13 (*(volatile unsigned long *)0xFFFB8468)
#define CAN1_IMR13_OFFSET 0x468
#define CAN1_IMR13_ACK_MASK 0x1U
#define CAN1_IMR13_ACK 0x1U
#define CAN1_IMR13_ACK_BIT 0
#define CAN1_IMR13_FRAME_MASK 0x2U
#define CAN1_IMR13_FRAME 0x2U
#define CAN1_IMR13_FRAME_BIT 1
#define CAN1_IMR13_CRC_MASK 0x4U
#define CAN1_IMR13_CRC 0x4U
#define CAN1_IMR13_CRC_BIT 2
#define CAN1_IMR13_STUFF_MASK 0x8U
#define CAN1_IMR13_STUFF 0x8U
#define CAN1_IMR13_STUFF_BIT 3
#define CAN1_IMR13_BUS_MASK 0x10U
#define CAN1_IMR13_BUS 0x10U
#define CAN1_IMR13_BUS_BIT 4
#define CAN1_IMR13_RXOK_MASK 0x20U
#define CAN1_IMR13_RXOK 0x20U
#define CAN1_IMR13_RXOK_BIT 5
#define CAN1_IMR13_TXOK_MASK 0x40U
#define CAN1_IMR13_TXOK 0x40U
#define CAN1_IMR13_TXOK_BIT 6
#define CAN1_IMR13_RFRAME_MASK 0x80U
#define CAN1_IMR13_RFRAME 0x80U
#define CAN1_IMR13_RFRAME_BIT 7

#define CAN1_DRA14 (*(volatile unsigned long *)0xFFFB8480)
#define CAN1_DRA14_OFFSET 0x480
#define CAN1_DRA14_DATA0_MASK 0xFFU
#define CAN1_DRA14_DATA0_BIT 0
#define CAN1_DRA14_DATA1_MASK 0xFF00U
#define CAN1_DRA14_DATA1_BIT 8
#define CAN1_DRA14_DATA2_MASK 0xFF0000U
#define CAN1_DRA14_DATA2_BIT 16
#define CAN1_DRA14_DATA3_MASK 0xFF000000U
#define CAN1_DRA14_DATA3_BIT 24

#define CAN1_DRB14 (*(volatile unsigned long *)0xFFFB8484)
#define CAN1_DRB14_OFFSET 0x484
#define CAN1_DRB14_DATA4_MASK 0xFFU
#define CAN1_DRB14_DATA4_BIT 0
#define CAN1_DRB14_DATA5_MASK 0xFF00U
#define CAN1_DRB14_DATA5_BIT 8
#define CAN1_DRB14_DATA6_MASK 0xFF0000U
#define CAN1_DRB14_DATA6_BIT 16
#define CAN1_DRB14_DATA7_MASK 0xFF000000U
#define CAN1_DRB14_DATA7_BIT 24

#define CAN1_MSK14 (*(volatile unsigned long *)0xFFFB8488)
#define CAN1_MSK14_OFFSET 0x488
#define CAN1_MSK14_MASK_MASK 0x1FFFFFFFU
#define CAN1_MSK14_MASK_BIT 0
#define CAN1_MSK14_MRB_MASK 0x60000000U
#define CAN1_MSK14_MRB_BIT 29
#define CAN1_MSK14_MRTR_MASK 0x80000000U
#define CAN1_MSK14_MRTR 0x80000000U
#define CAN1_MSK14_MRTR_BIT 31

#define CAN1_IR14 (*(volatile unsigned long *)0xFFFB848C)
#define CAN1_IR14_OFFSET 0x48C
#define CAN1_IR14_ID_MASK 0x1FFFFFFFU
#define CAN1_IR14_ID_BIT 0
#define CAN1_IR14_RB_MASK 0x60000000U
#define CAN1_IR14_RB_BIT 29
#define CAN1_IR14_RTR_MASK 0x80000000U
#define CAN1_IR14_RTR 0x80000000U
#define CAN1_IR14_RTR_BIT 31

#define CAN1_CR14 (*(volatile unsigned long *)0xFFFB8490)
#define CAN1_CR14_OFFSET 0x490
#define CAN1_CR14_DLC_MASK 0xFU
#define CAN1_CR14_DLC_BIT 0
#define CAN1_CR14_IDE_MASK 0x10U
#define CAN1_CR14_IDE 0x10U
#define CAN1_CR14_IDE_BIT 4
#define CAN1_CR14_RPLYV_MASK 0x20U
#define CAN1_CR14_RPLYV 0x20U
#define CAN1_CR14_RPLYV_BIT 5
#define CAN1_CR14_PCB_MASK 0x40U
#define CAN1_CR14_PCB 0x40U
#define CAN1_CR14_PCB_BIT 6
#define CAN1_CR14_CHANEN_MASK 0x80U
#define CAN1_CR14_CHANEN 0x80U
#define CAN1_CR14_CHANEN_BIT 7
#define CAN1_CR14_OVERWRITE_MASK 0x100U
#define CAN1_CR14_OVERWRITE 0x100U
#define CAN1_CR14_OVERWRITE_BIT 8

#define CAN1_CR14 (*(volatile unsigned long *)0xFFFB8494)
#define CAN1_CR14_OFFSET 0x494
#define CAN1_CR14_STAMP_MASK 0x0U
#define CAN1_CR14_STAMP_BIT 0

#define CAN1_CSR14 (*(volatile unsigned long *)0xFFFB8498)
#define CAN1_CSR14_OFFSET 0x498
#define CAN1_CSR14_ACK_MASK 0x1U
#define CAN1_CSR14_ACK 0x1U
#define CAN1_CSR14_ACK_BIT 0
#define CAN1_CSR14_FRAME_MASK 0x2U
#define CAN1_CSR14_FRAME 0x2U
#define CAN1_CSR14_FRAME_BIT 1
#define CAN1_CSR14_CRC_MASK 0x4U
#define CAN1_CSR14_CRC 0x4U
#define CAN1_CSR14_CRC_BIT 2
#define CAN1_CSR14_STUFF_MASK 0x8U
#define CAN1_CSR14_STUFF 0x8U
#define CAN1_CSR14_STUFF_BIT 3
#define CAN1_CSR14_BUS_MASK 0x10U
#define CAN1_CSR14_BUS 0x10U
#define CAN1_CSR14_BUS_BIT 4
#define CAN1_CSR14_RXOK_MASK 0x20U
#define CAN1_CSR14_RXOK 0x20U
#define CAN1_CSR14_RXOK_BIT 5
#define CAN1_CSR14_TXOK_MASK 0x40U
#define CAN1_CSR14_TXOK 0x40U
#define CAN1_CSR14_TXOK_BIT 6
#define CAN1_CSR14_RFRAME_MASK 0x80U
#define CAN1_CSR14_RFRAME 0x80U
#define CAN1_CSR14_RFRAME_BIT 7
#define CAN1_CSR14_DLCW_MASK 0x200U
#define CAN1_CSR14_DLCW 0x200U
#define CAN1_CSR14_DLCW_BIT 9
#define CAN1_CSR14_FILLED_MASK 0x400U
#define CAN1_CSR14_FILLED 0x400U
#define CAN1_CSR14_FILLED_BIT 10
#define CAN1_CSR14_OVRUN_MASK 0x800U
#define CAN1_CSR14_OVRUN 0x800U
#define CAN1_CSR14_OVRUN_BIT 11

#define CAN1_SR14 (*(volatile unsigned long *)0xFFFB849C)
#define CAN1_SR14_OFFSET 0x49C
#define CAN1_SR14_ACK_MASK 0x1U
#define CAN1_SR14_ACK 0x1U
#define CAN1_SR14_ACK_BIT 0
#define CAN1_SR14_FRAME_MASK 0x2U
#define CAN1_SR14_FRAME 0x2U
#define CAN1_SR14_FRAME_BIT 1
#define CAN1_SR14_CRC_MASK 0x4U
#define CAN1_SR14_CRC 0x4U
#define CAN1_SR14_CRC_BIT 2
#define CAN1_SR14_STUFF_MASK 0x8U
#define CAN1_SR14_STUFF 0x8U
#define CAN1_SR14_STUFF_BIT 3
#define CAN1_SR14_BUS_MASK 0x10U
#define CAN1_SR14_BUS 0x10U
#define CAN1_SR14_BUS_BIT 4
#define CAN1_SR14_RXOK_MASK 0x20U
#define CAN1_SR14_RXOK 0x20U
#define CAN1_SR14_RXOK_BIT 5
#define CAN1_SR14_TXOK_MASK 0x40U
#define CAN1_SR14_TXOK 0x40U
#define CAN1_SR14_TXOK_BIT 6
#define CAN1_SR14_RFRAME_MASK 0x80U
#define CAN1_SR14_RFRAME 0x80U
#define CAN1_SR14_RFRAME_BIT 7
#define CAN1_SR14_DLCW_MASK 0x200U
#define CAN1_SR14_DLCW 0x200U
#define CAN1_SR14_DLCW_BIT 9
#define CAN1_SR14_FILLED_MASK 0x400U
#define CAN1_SR14_FILLED 0x400U
#define CAN1_SR14_FILLED_BIT 10
#define CAN1_SR14_OVRUN_MASK 0x800U
#define CAN1_SR14_OVRUN 0x800U
#define CAN1_SR14_OVRUN_BIT 11

#define CAN1_IER14 (*(volatile unsigned long *)0xFFFB84A0)
#define CAN1_IER14_OFFSET 0x4A0
#define CAN1_IER14_ACK_MASK 0x1U
#define CAN1_IER14_ACK 0x1U
#define CAN1_IER14_ACK_BIT 0
#define CAN1_IER14_FRAME_MASK 0x2U
#define CAN1_IER14_FRAME 0x2U
#define CAN1_IER14_FRAME_BIT 1
#define CAN1_IER14_CRC_MASK 0x4U
#define CAN1_IER14_CRC 0x4U
#define CAN1_IER14_CRC_BIT 2
#define CAN1_IER14_STUFF_MASK 0x8U
#define CAN1_IER14_STUFF 0x8U
#define CAN1_IER14_STUFF_BIT 3
#define CAN1_IER14_BUS_MASK 0x10U
#define CAN1_IER14_BUS 0x10U
#define CAN1_IER14_BUS_BIT 4
#define CAN1_IER14_RXOK_MASK 0x20U
#define CAN1_IER14_RXOK 0x20U
#define CAN1_IER14_RXOK_BIT 5
#define CAN1_IER14_TXOK_MASK 0x40U
#define CAN1_IER14_TXOK 0x40U
#define CAN1_IER14_TXOK_BIT 6
#define CAN1_IER14_RFRAME_MASK 0x80U
#define CAN1_IER14_RFRAME 0x80U
#define CAN1_IER14_RFRAME_BIT 7

#define CAN1_IDR14 (*(volatile unsigned long *)0xFFFB84A4)
#define CAN1_IDR14_OFFSET 0x4A4
#define CAN1_IDR14_ACK_MASK 0x1U
#define CAN1_IDR14_ACK 0x1U
#define CAN1_IDR14_ACK_BIT 0
#define CAN1_IDR14_FRAME_MASK 0x2U
#define CAN1_IDR14_FRAME 0x2U
#define CAN1_IDR14_FRAME_BIT 1
#define CAN1_IDR14_CRC_MASK 0x4U
#define CAN1_IDR14_CRC 0x4U
#define CAN1_IDR14_CRC_BIT 2
#define CAN1_IDR14_STUFF_MASK 0x8U
#define CAN1_IDR14_STUFF 0x8U
#define CAN1_IDR14_STUFF_BIT 3
#define CAN1_IDR14_BUS_MASK 0x10U
#define CAN1_IDR14_BUS 0x10U
#define CAN1_IDR14_BUS_BIT 4
#define CAN1_IDR14_RXOK_MASK 0x20U
#define CAN1_IDR14_RXOK 0x20U
#define CAN1_IDR14_RXOK_BIT 5
#define CAN1_IDR14_TXOK_MASK 0x40U
#define CAN1_IDR14_TXOK 0x40U
#define CAN1_IDR14_TXOK_BIT 6
#define CAN1_IDR14_RFRAME_MASK 0x80U
#define CAN1_IDR14_RFRAME 0x80U
#define CAN1_IDR14_RFRAME_BIT 7

#define CAN1_IMR14 (*(volatile unsigned long *)0xFFFB84A8)
#define CAN1_IMR14_OFFSET 0x4A8
#define CAN1_IMR14_ACK_MASK 0x1U
#define CAN1_IMR14_ACK 0x1U
#define CAN1_IMR14_ACK_BIT 0
#define CAN1_IMR14_FRAME_MASK 0x2U
#define CAN1_IMR14_FRAME 0x2U
#define CAN1_IMR14_FRAME_BIT 1
#define CAN1_IMR14_CRC_MASK 0x4U
#define CAN1_IMR14_CRC 0x4U
#define CAN1_IMR14_CRC_BIT 2
#define CAN1_IMR14_STUFF_MASK 0x8U
#define CAN1_IMR14_STUFF 0x8U
#define CAN1_IMR14_STUFF_BIT 3
#define CAN1_IMR14_BUS_MASK 0x10U
#define CAN1_IMR14_BUS 0x10U
#define CAN1_IMR14_BUS_BIT 4
#define CAN1_IMR14_RXOK_MASK 0x20U
#define CAN1_IMR14_RXOK 0x20U
#define CAN1_IMR14_RXOK_BIT 5
#define CAN1_IMR14_TXOK_MASK 0x40U
#define CAN1_IMR14_TXOK 0x40U
#define CAN1_IMR14_TXOK_BIT 6
#define CAN1_IMR14_RFRAME_MASK 0x80U
#define CAN1_IMR14_RFRAME 0x80U
#define CAN1_IMR14_RFRAME_BIT 7

#define CAN1_DRA15 (*(volatile unsigned long *)0xFFFB84C0)
#define CAN1_DRA15_OFFSET 0x4C0
#define CAN1_DRA15_DATA0_MASK 0xFFU
#define CAN1_DRA15_DATA0_BIT 0
#define CAN1_DRA15_DATA1_MASK 0xFF00U
#define CAN1_DRA15_DATA1_BIT 8
#define CAN1_DRA15_DATA2_MASK 0xFF0000U
#define CAN1_DRA15_DATA2_BIT 16
#define CAN1_DRA15_DATA3_MASK 0xFF000000U
#define CAN1_DRA15_DATA3_BIT 24

#define CAN1_DRB15 (*(volatile unsigned long *)0xFFFB84C4)
#define CAN1_DRB15_OFFSET 0x4C4
#define CAN1_DRB15_DATA4_MASK 0xFFU
#define CAN1_DRB15_DATA4_BIT 0
#define CAN1_DRB15_DATA5_MASK 0xFF00U
#define CAN1_DRB15_DATA5_BIT 8
#define CAN1_DRB15_DATA6_MASK 0xFF0000U
#define CAN1_DRB15_DATA6_BIT 16
#define CAN1_DRB15_DATA7_MASK 0xFF000000U
#define CAN1_DRB15_DATA7_BIT 24

#define CAN1_MSK15 (*(volatile unsigned long *)0xFFFB84C8)
#define CAN1_MSK15_OFFSET 0x4C8
#define CAN1_MSK15_MASK_MASK 0x1FFFFFFFU
#define CAN1_MSK15_MASK_BIT 0
#define CAN1_MSK15_MRB_MASK 0x60000000U
#define CAN1_MSK15_MRB_BIT 29
#define CAN1_MSK15_MRTR_MASK 0x80000000U
#define CAN1_MSK15_MRTR 0x80000000U
#define CAN1_MSK15_MRTR_BIT 31

#define CAN1_IR15 (*(volatile unsigned long *)0xFFFB84CC)
#define CAN1_IR15_OFFSET 0x4CC
#define CAN1_IR15_ID_MASK 0x1FFFFFFFU
#define CAN1_IR15_ID_BIT 0
#define CAN1_IR15_RB_MASK 0x60000000U
#define CAN1_IR15_RB_BIT 29
#define CAN1_IR15_RTR_MASK 0x80000000U
#define CAN1_IR15_RTR 0x80000000U
#define CAN1_IR15_RTR_BIT 31

#define CAN1_CR15 (*(volatile unsigned long *)0xFFFB84D0)
#define CAN1_CR15_OFFSET 0x4D0
#define CAN1_CR15_DLC_MASK 0xFU
#define CAN1_CR15_DLC_BIT 0
#define CAN1_CR15_IDE_MASK 0x10U
#define CAN1_CR15_IDE 0x10U
#define CAN1_CR15_IDE_BIT 4
#define CAN1_CR15_RPLYV_MASK 0x20U
#define CAN1_CR15_RPLYV 0x20U
#define CAN1_CR15_RPLYV_BIT 5
#define CAN1_CR15_PCB_MASK 0x40U
#define CAN1_CR15_PCB 0x40U
#define CAN1_CR15_PCB_BIT 6
#define CAN1_CR15_CHANEN_MASK 0x80U
#define CAN1_CR15_CHANEN 0x80U
#define CAN1_CR15_CHANEN_BIT 7
#define CAN1_CR15_OVERWRITE_MASK 0x100U
#define CAN1_CR15_OVERWRITE 0x100U
#define CAN1_CR15_OVERWRITE_BIT 8

#define CAN1_CR15 (*(volatile unsigned long *)0xFFFB84D4)
#define CAN1_CR15_OFFSET 0x4D4
#define CAN1_CR15_STAMP_MASK 0x0U
#define CAN1_CR15_STAMP_BIT 0

#define CAN1_CSR15 (*(volatile unsigned long *)0xFFFB84D8)
#define CAN1_CSR15_OFFSET 0x4D8
#define CAN1_CSR15_ACK_MASK 0x1U
#define CAN1_CSR15_ACK 0x1U
#define CAN1_CSR15_ACK_BIT 0
#define CAN1_CSR15_FRAME_MASK 0x2U
#define CAN1_CSR15_FRAME 0x2U
#define CAN1_CSR15_FRAME_BIT 1
#define CAN1_CSR15_CRC_MASK 0x4U
#define CAN1_CSR15_CRC 0x4U
#define CAN1_CSR15_CRC_BIT 2
#define CAN1_CSR15_STUFF_MASK 0x8U
#define CAN1_CSR15_STUFF 0x8U
#define CAN1_CSR15_STUFF_BIT 3
#define CAN1_CSR15_BUS_MASK 0x10U
#define CAN1_CSR15_BUS 0x10U
#define CAN1_CSR15_BUS_BIT 4
#define CAN1_CSR15_RXOK_MASK 0x20U
#define CAN1_CSR15_RXOK 0x20U
#define CAN1_CSR15_RXOK_BIT 5
#define CAN1_CSR15_TXOK_MASK 0x40U
#define CAN1_CSR15_TXOK 0x40U
#define CAN1_CSR15_TXOK_BIT 6
#define CAN1_CSR15_RFRAME_MASK 0x80U
#define CAN1_CSR15_RFRAME 0x80U
#define CAN1_CSR15_RFRAME_BIT 7
#define CAN1_CSR15_DLCW_MASK 0x200U
#define CAN1_CSR15_DLCW 0x200U
#define CAN1_CSR15_DLCW_BIT 9
#define CAN1_CSR15_FILLED_MASK 0x400U
#define CAN1_CSR15_FILLED 0x400U
#define CAN1_CSR15_FILLED_BIT 10
#define CAN1_CSR15_OVRUN_MASK 0x800U
#define CAN1_CSR15_OVRUN 0x800U
#define CAN1_CSR15_OVRUN_BIT 11

#define CAN1_SR15 (*(volatile unsigned long *)0xFFFB84DC)
#define CAN1_SR15_OFFSET 0x4DC
#define CAN1_SR15_ACK_MASK 0x1U
#define CAN1_SR15_ACK 0x1U
#define CAN1_SR15_ACK_BIT 0
#define CAN1_SR15_FRAME_MASK 0x2U
#define CAN1_SR15_FRAME 0x2U
#define CAN1_SR15_FRAME_BIT 1
#define CAN1_SR15_CRC_MASK 0x4U
#define CAN1_SR15_CRC 0x4U
#define CAN1_SR15_CRC_BIT 2
#define CAN1_SR15_STUFF_MASK 0x8U
#define CAN1_SR15_STUFF 0x8U
#define CAN1_SR15_STUFF_BIT 3
#define CAN1_SR15_BUS_MASK 0x10U
#define CAN1_SR15_BUS 0x10U
#define CAN1_SR15_BUS_BIT 4
#define CAN1_SR15_RXOK_MASK 0x20U
#define CAN1_SR15_RXOK 0x20U
#define CAN1_SR15_RXOK_BIT 5
#define CAN1_SR15_TXOK_MASK 0x40U
#define CAN1_SR15_TXOK 0x40U
#define CAN1_SR15_TXOK_BIT 6
#define CAN1_SR15_RFRAME_MASK 0x80U
#define CAN1_SR15_RFRAME 0x80U
#define CAN1_SR15_RFRAME_BIT 7
#define CAN1_SR15_DLCW_MASK 0x200U
#define CAN1_SR15_DLCW 0x200U
#define CAN1_SR15_DLCW_BIT 9
#define CAN1_SR15_FILLED_MASK 0x400U
#define CAN1_SR15_FILLED 0x400U
#define CAN1_SR15_FILLED_BIT 10
#define CAN1_SR15_OVRUN_MASK 0x800U
#define CAN1_SR15_OVRUN 0x800U
#define CAN1_SR15_OVRUN_BIT 11

#define CAN1_IER15 (*(volatile unsigned long *)0xFFFB84E0)
#define CAN1_IER15_OFFSET 0x4E0
#define CAN1_IER15_ACK_MASK 0x1U
#define CAN1_IER15_ACK 0x1U
#define CAN1_IER15_ACK_BIT 0
#define CAN1_IER15_FRAME_MASK 0x2U
#define CAN1_IER15_FRAME 0x2U
#define CAN1_IER15_FRAME_BIT 1
#define CAN1_IER15_CRC_MASK 0x4U
#define CAN1_IER15_CRC 0x4U
#define CAN1_IER15_CRC_BIT 2
#define CAN1_IER15_STUFF_MASK 0x8U
#define CAN1_IER15_STUFF 0x8U
#define CAN1_IER15_STUFF_BIT 3
#define CAN1_IER15_BUS_MASK 0x10U
#define CAN1_IER15_BUS 0x10U
#define CAN1_IER15_BUS_BIT 4
#define CAN1_IER15_RXOK_MASK 0x20U
#define CAN1_IER15_RXOK 0x20U
#define CAN1_IER15_RXOK_BIT 5
#define CAN1_IER15_TXOK_MASK 0x40U
#define CAN1_IER15_TXOK 0x40U
#define CAN1_IER15_TXOK_BIT 6
#define CAN1_IER15_RFRAME_MASK 0x80U
#define CAN1_IER15_RFRAME 0x80U
#define CAN1_IER15_RFRAME_BIT 7

#define CAN1_IDR15 (*(volatile unsigned long *)0xFFFB84E4)
#define CAN1_IDR15_OFFSET 0x4E4
#define CAN1_IDR15_ACK_MASK 0x1U
#define CAN1_IDR15_ACK 0x1U
#define CAN1_IDR15_ACK_BIT 0
#define CAN1_IDR15_FRAME_MASK 0x2U
#define CAN1_IDR15_FRAME 0x2U
#define CAN1_IDR15_FRAME_BIT 1
#define CAN1_IDR15_CRC_MASK 0x4U
#define CAN1_IDR15_CRC 0x4U
#define CAN1_IDR15_CRC_BIT 2
#define CAN1_IDR15_STUFF_MASK 0x8U
#define CAN1_IDR15_STUFF 0x8U
#define CAN1_IDR15_STUFF_BIT 3
#define CAN1_IDR15_BUS_MASK 0x10U
#define CAN1_IDR15_BUS 0x10U
#define CAN1_IDR15_BUS_BIT 4
#define CAN1_IDR15_RXOK_MASK 0x20U
#define CAN1_IDR15_RXOK 0x20U
#define CAN1_IDR15_RXOK_BIT 5
#define CAN1_IDR15_TXOK_MASK 0x40U
#define CAN1_IDR15_TXOK 0x40U
#define CAN1_IDR15_TXOK_BIT 6
#define CAN1_IDR15_RFRAME_MASK 0x80U
#define CAN1_IDR15_RFRAME 0x80U
#define CAN1_IDR15_RFRAME_BIT 7

#define CAN1_IMR15 (*(volatile unsigned long *)0xFFFB84E8)
#define CAN1_IMR15_OFFSET 0x4E8
#define CAN1_IMR15_ACK_MASK 0x1U
#define CAN1_IMR15_ACK 0x1U
#define CAN1_IMR15_ACK_BIT 0
#define CAN1_IMR15_FRAME_MASK 0x2U
#define CAN1_IMR15_FRAME 0x2U
#define CAN1_IMR15_FRAME_BIT 1
#define CAN1_IMR15_CRC_MASK 0x4U
#define CAN1_IMR15_CRC 0x4U
#define CAN1_IMR15_CRC_BIT 2
#define CAN1_IMR15_STUFF_MASK 0x8U
#define CAN1_IMR15_STUFF 0x8U
#define CAN1_IMR15_STUFF_BIT 3
#define CAN1_IMR15_BUS_MASK 0x10U
#define CAN1_IMR15_BUS 0x10U
#define CAN1_IMR15_BUS_BIT 4
#define CAN1_IMR15_RXOK_MASK 0x20U
#define CAN1_IMR15_RXOK 0x20U
#define CAN1_IMR15_RXOK_BIT 5
#define CAN1_IMR15_TXOK_MASK 0x40U
#define CAN1_IMR15_TXOK 0x40U
#define CAN1_IMR15_TXOK_BIT 6
#define CAN1_IMR15_RFRAME_MASK 0x80U
#define CAN1_IMR15_RFRAME 0x80U
#define CAN1_IMR15_RFRAME_BIT 7

#define CAN2_BASE 0xFFFBC000

#define CAN2_ECR (*(volatile unsigned long *)0xFFFBC050)
#define CAN2_ECR_OFFSET 0x50
#define CAN2_ECR_CAN_MASK 0x2U
#define CAN2_ECR_CAN 0x2U
#define CAN2_ECR_CAN_BIT 1

#define CAN2_DCR (*(volatile unsigned long *)0xFFFBC054)
#define CAN2_DCR_OFFSET 0x54
#define CAN2_DCR_CAN_MASK 0x2U
#define CAN2_DCR_CAN 0x2U
#define CAN2_DCR_CAN_BIT 1

#define CAN2_PMSR (*(volatile unsigned long *)0xFFFBC058)
#define CAN2_PMSR_OFFSET 0x58
#define CAN2_PMSR_CAN_MASK 0x2U
#define CAN2_PMSR_CAN 0x2U
#define CAN2_PMSR_CAN_BIT 1

#define CAN2_CR (*(volatile unsigned long *)0xFFFBC060)
#define CAN2_CR_OFFSET 0x60
#define CAN2_CR_SWRST_MASK 0x1U
#define CAN2_CR_SWRST 0x1U
#define CAN2_CR_SWRST_BIT 0
#define CAN2_CR_CANEN_MASK 0x2U
#define CAN2_CR_CANEN 0x2U
#define CAN2_CR_CANEN_BIT 1
#define CAN2_CR_CANDIS_MASK 0x4U
#define CAN2_CR_CANDIS 0x4U
#define CAN2_CR_CANDIS_BIT 2
#define CAN2_CR_ABEN_MASK 0x8U
#define CAN2_CR_ABEN 0x8U
#define CAN2_CR_ABEN_BIT 3
#define CAN2_CR_ABDIS_MASK 0x10U
#define CAN2_CR_ABDIS 0x10U
#define CAN2_CR_ABDIS_BIT 4
#define CAN2_CR_OVEN_MASK 0x20U
#define CAN2_CR_OVEN 0x20U
#define CAN2_CR_OVEN_BIT 5
#define CAN2_CR_OVDIS_MASK 0x20U
#define CAN2_CR_OVDIS 0x20U
#define CAN2_CR_OVDIS_BIT 5

#define CAN2_MR (*(volatile unsigned long *)0xFFFBC064)
#define CAN2_MR_OFFSET 0x64
#define CAN2_MR_BD_MASK 0x3FU
#define CAN2_MR_BD_BIT 0
#define CAN2_MR_PROP_MASK 0x700U
#define CAN2_MR_PROP_BIT 8
#define CAN2_MR_SJW_MASK 0x3000U
#define CAN2_MR_SJW_BIT 12
#define CAN2_MR_SMP_MASK 0x4000U
#define CAN2_MR_SMP 0x4000U
#define CAN2_MR_SMP_BIT 14
#define CAN2_MR_PHSEG1_MASK 0x70000U
#define CAN2_MR_PHSEG1_BIT 16
#define CAN2_MR_PHSEG2_MASK 0x700000U
#define CAN2_MR_PHSEG2_BIT 20

#define CAN2_CSR (*(volatile unsigned long *)0xFFFBC06C)
#define CAN2_CSR_OFFSET 0x6C
#define CAN2_CSR_ENDINIT_MASK 0x4U
#define CAN2_CSR_ENDINIT 0x4U
#define CAN2_CSR_ENDINIT_BIT 2

#define CAN2_SR (*(volatile unsigned long *)0xFFFBC070)
#define CAN2_SR_OFFSET 0x70
#define CAN2_SR_CANENA_MASK 0x1U
#define CAN2_SR_CANENA 0x1U
#define CAN2_SR_CANENA_BIT 0
#define CAN2_SR_CANINIT_MASK 0x2U
#define CAN2_SR_CANINIT 0x2U
#define CAN2_SR_CANINIT_BIT 1
#define CAN2_SR_ENDINIT_MASK 0x4U
#define CAN2_SR_ENDINIT 0x4U
#define CAN2_SR_ENDINIT_BIT 2
#define CAN2_SR_ERPAS_MASK 0x8U
#define CAN2_SR_ERPAS 0x8U
#define CAN2_SR_ERPAS_BIT 3
#define CAN2_SR_BUSOFF_MASK 0x10U
#define CAN2_SR_BUSOFF 0x10U
#define CAN2_SR_BUSOFF_BIT 4
#define CAN2_SR_ABRQ_MASK 0x20U
#define CAN2_SR_ABRQ 0x20U
#define CAN2_SR_ABRQ_BIT 5
#define CAN2_SR_ISS_MASK 0x80U
#define CAN2_SR_ISS 0x80U
#define CAN2_SR_ISS_BIT 7
#define CAN2_SR_REC_MASK 0xFF0000U
#define CAN2_SR_REC_BIT 16
#define CAN2_SR_TEC_MASK 0xFF000000U
#define CAN2_SR_TEC_BIT 24

#define CAN2_IER (*(volatile unsigned long *)0xFFFBC074)
#define CAN2_IER_OFFSET 0x74
#define CAN2_IER_ENDINIT_MASK 0x4U
#define CAN2_IER_ENDINIT 0x4U
#define CAN2_IER_ENDINIT_BIT 2
#define CAN2_IER_ERPAS_MASK 0x8U
#define CAN2_IER_ERPAS 0x8U
#define CAN2_IER_ERPAS_BIT 3
#define CAN2_IER_BUSOFF_MASK 0x10U
#define CAN2_IER_BUSOFF 0x10U
#define CAN2_IER_BUSOFF_BIT 4

#define CAN2_IDR (*(volatile unsigned long *)0xFFFBC078)
#define CAN2_IDR_OFFSET 0x78
#define CAN2_IDR_ENDINIT_MASK 0x4U
#define CAN2_IDR_ENDINIT 0x4U
#define CAN2_IDR_ENDINIT_BIT 2
#define CAN2_IDR_ERPAS_MASK 0x8U
#define CAN2_IDR_ERPAS 0x8U
#define CAN2_IDR_ERPAS_BIT 3
#define CAN2_IDR_BUSOFF_MASK 0x10U
#define CAN2_IDR_BUSOFF 0x10U
#define CAN2_IDR_BUSOFF_BIT 4

#define CAN2_IMR (*(volatile unsigned long *)0xFFFBC07C)
#define CAN2_IMR_OFFSET 0x7C
#define CAN2_IMR_ENDINIT_MASK 0x4U
#define CAN2_IMR_ENDINIT 0x4U
#define CAN2_IMR_ENDINIT_BIT 2
#define CAN2_IMR_ERPAS_MASK 0x8U
#define CAN2_IMR_ERPAS 0x8U
#define CAN2_IMR_ERPAS_BIT 3
#define CAN2_IMR_BUSOFF_MASK 0x10U
#define CAN2_IMR_BUSOFF 0x10U
#define CAN2_IMR_BUSOFF_BIT 4

#define CAN2_CISR (*(volatile unsigned long *)0xFFFBC080)
#define CAN2_CISR_OFFSET 0x80
#define CAN2_CISR_CH0_MASK 0x1U
#define CAN2_CISR_CH0 0x1U
#define CAN2_CISR_CH0_BIT 0
#define CAN2_CISR_CH1_MASK 0x2U
#define CAN2_CISR_CH1 0x2U
#define CAN2_CISR_CH1_BIT 1
#define CAN2_CISR_CH2_MASK 0x4U
#define CAN2_CISR_CH2 0x4U
#define CAN2_CISR_CH2_BIT 2
#define CAN2_CISR_CH3_MASK 0x8U
#define CAN2_CISR_CH3 0x8U
#define CAN2_CISR_CH3_BIT 3
#define CAN2_CISR_CH4_MASK 0x10U
#define CAN2_CISR_CH4 0x10U
#define CAN2_CISR_CH4_BIT 4
#define CAN2_CISR_CH5_MASK 0x20U
#define CAN2_CISR_CH5 0x20U
#define CAN2_CISR_CH5_BIT 5
#define CAN2_CISR_CH6_MASK 0x40U
#define CAN2_CISR_CH6 0x40U
#define CAN2_CISR_CH6_BIT 6
#define CAN2_CISR_CH7_MASK 0x80U
#define CAN2_CISR_CH7 0x80U
#define CAN2_CISR_CH7_BIT 7
#define CAN2_CISR_CH8_MASK 0x100U
#define CAN2_CISR_CH8 0x100U
#define CAN2_CISR_CH8_BIT 8
#define CAN2_CISR_CH9_MASK 0x200U
#define CAN2_CISR_CH9 0x200U
#define CAN2_CISR_CH9_BIT 9
#define CAN2_CISR_CH10_MASK 0x400U
#define CAN2_CISR_CH10 0x400U
#define CAN2_CISR_CH10_BIT 10
#define CAN2_CISR_CH11_MASK 0x800U
#define CAN2_CISR_CH11 0x800U
#define CAN2_CISR_CH11_BIT 11
#define CAN2_CISR_CH12_MASK 0x1000U
#define CAN2_CISR_CH12 0x1000U
#define CAN2_CISR_CH12_BIT 12
#define CAN2_CISR_CH13_MASK 0x2000U
#define CAN2_CISR_CH13 0x2000U
#define CAN2_CISR_CH13_BIT 13
#define CAN2_CISR_CH14_MASK 0x4000U
#define CAN2_CISR_CH14 0x4000U
#define CAN2_CISR_CH14_BIT 14
#define CAN2_CISR_CH15_MASK 0x8000U
#define CAN2_CISR_CH15 0x8000U
#define CAN2_CISR_CH15_BIT 15
#define CAN2_CISR_CH16_MASK 0x10000U
#define CAN2_CISR_CH16 0x10000U
#define CAN2_CISR_CH16_BIT 16
#define CAN2_CISR_CH17_MASK 0x20000U
#define CAN2_CISR_CH17 0x20000U
#define CAN2_CISR_CH17_BIT 17
#define CAN2_CISR_CH18_MASK 0x40000U
#define CAN2_CISR_CH18 0x40000U
#define CAN2_CISR_CH18_BIT 18
#define CAN2_CISR_CH19_MASK 0x80000U
#define CAN2_CISR_CH19 0x80000U
#define CAN2_CISR_CH19_BIT 19
#define CAN2_CISR_CH20_MASK 0x100000U
#define CAN2_CISR_CH20 0x100000U
#define CAN2_CISR_CH20_BIT 20
#define CAN2_CISR_CH21_MASK 0x200000U
#define CAN2_CISR_CH21 0x200000U
#define CAN2_CISR_CH21_BIT 21
#define CAN2_CISR_CH22_MASK 0x400000U
#define CAN2_CISR_CH22 0x400000U
#define CAN2_CISR_CH22_BIT 22
#define CAN2_CISR_CH23_MASK 0x800000U
#define CAN2_CISR_CH23 0x800000U
#define CAN2_CISR_CH23_BIT 23
#define CAN2_CISR_CH24_MASK 0x1000000U
#define CAN2_CISR_CH24 0x1000000U
#define CAN2_CISR_CH24_BIT 24
#define CAN2_CISR_CH25_MASK 0x2000000U
#define CAN2_CISR_CH25 0x2000000U
#define CAN2_CISR_CH25_BIT 25
#define CAN2_CISR_CH26_MASK 0x4000000U
#define CAN2_CISR_CH26 0x4000000U
#define CAN2_CISR_CH26_BIT 26
#define CAN2_CISR_CH27_MASK 0x8000000U
#define CAN2_CISR_CH27 0x8000000U
#define CAN2_CISR_CH27_BIT 27
#define CAN2_CISR_CH28_MASK 0x10000000U
#define CAN2_CISR_CH28 0x10000000U
#define CAN2_CISR_CH28_BIT 28
#define CAN2_CISR_CH29_MASK 0x20000000U
#define CAN2_CISR_CH29 0x20000000U
#define CAN2_CISR_CH29_BIT 29
#define CAN2_CISR_CH30_MASK 0x40000000U
#define CAN2_CISR_CH30 0x40000000U
#define CAN2_CISR_CH30_BIT 30
#define CAN2_CISR_CH31_MASK 0x80000000U
#define CAN2_CISR_CH31 0x80000000U
#define CAN2_CISR_CH31_BIT 31

#define CAN2_ISSR (*(volatile unsigned long *)0xFFFBC084)
#define CAN2_ISSR_OFFSET 0x84
#define CAN2_ISSR_CH0_MASK 0x1U
#define CAN2_ISSR_CH0 0x1U
#define CAN2_ISSR_CH0_BIT 0
#define CAN2_ISSR_CH1_MASK 0x2U
#define CAN2_ISSR_CH1 0x2U
#define CAN2_ISSR_CH1_BIT 1
#define CAN2_ISSR_CH2_MASK 0x4U
#define CAN2_ISSR_CH2 0x4U
#define CAN2_ISSR_CH2_BIT 2
#define CAN2_ISSR_CH3_MASK 0x8U
#define CAN2_ISSR_CH3 0x8U
#define CAN2_ISSR_CH3_BIT 3
#define CAN2_ISSR_CH4_MASK 0x10U
#define CAN2_ISSR_CH4 0x10U
#define CAN2_ISSR_CH4_BIT 4
#define CAN2_ISSR_CH5_MASK 0x20U
#define CAN2_ISSR_CH5 0x20U
#define CAN2_ISSR_CH5_BIT 5
#define CAN2_ISSR_CH6_MASK 0x40U
#define CAN2_ISSR_CH6 0x40U
#define CAN2_ISSR_CH6_BIT 6
#define CAN2_ISSR_CH7_MASK 0x80U
#define CAN2_ISSR_CH7 0x80U
#define CAN2_ISSR_CH7_BIT 7
#define CAN2_ISSR_CH8_MASK 0x100U
#define CAN2_ISSR_CH8 0x100U
#define CAN2_ISSR_CH8_BIT 8
#define CAN2_ISSR_CH9_MASK 0x200U
#define CAN2_ISSR_CH9 0x200U
#define CAN2_ISSR_CH9_BIT 9
#define CAN2_ISSR_CH10_MASK 0x400U
#define CAN2_ISSR_CH10 0x400U
#define CAN2_ISSR_CH10_BIT 10
#define CAN2_ISSR_CH11_MASK 0x800U
#define CAN2_ISSR_CH11 0x800U
#define CAN2_ISSR_CH11_BIT 11
#define CAN2_ISSR_CH12_MASK 0x1000U
#define CAN2_ISSR_CH12 0x1000U
#define CAN2_ISSR_CH12_BIT 12
#define CAN2_ISSR_CH13_MASK 0x2000U
#define CAN2_ISSR_CH13 0x2000U
#define CAN2_ISSR_CH13_BIT 13
#define CAN2_ISSR_CH14_MASK 0x4000U
#define CAN2_ISSR_CH14 0x4000U
#define CAN2_ISSR_CH14_BIT 14
#define CAN2_ISSR_CH15_MASK 0x8000U
#define CAN2_ISSR_CH15 0x8000U
#define CAN2_ISSR_CH15_BIT 15
#define CAN2_ISSR_CH16_MASK 0x10000U
#define CAN2_ISSR_CH16 0x10000U
#define CAN2_ISSR_CH16_BIT 16
#define CAN2_ISSR_CH17_MASK 0x20000U
#define CAN2_ISSR_CH17 0x20000U
#define CAN2_ISSR_CH17_BIT 17
#define CAN2_ISSR_CH18_MASK 0x40000U
#define CAN2_ISSR_CH18 0x40000U
#define CAN2_ISSR_CH18_BIT 18
#define CAN2_ISSR_CH19_MASK 0x80000U
#define CAN2_ISSR_CH19 0x80000U
#define CAN2_ISSR_CH19_BIT 19
#define CAN2_ISSR_CH20_MASK 0x100000U
#define CAN2_ISSR_CH20 0x100000U
#define CAN2_ISSR_CH20_BIT 20
#define CAN2_ISSR_CH21_MASK 0x200000U
#define CAN2_ISSR_CH21 0x200000U
#define CAN2_ISSR_CH21_BIT 21
#define CAN2_ISSR_CH22_MASK 0x400000U
#define CAN2_ISSR_CH22 0x400000U
#define CAN2_ISSR_CH22_BIT 22
#define CAN2_ISSR_CH23_MASK 0x800000U
#define CAN2_ISSR_CH23 0x800000U
#define CAN2_ISSR_CH23_BIT 23
#define CAN2_ISSR_CH24_MASK 0x1000000U
#define CAN2_ISSR_CH24 0x1000000U
#define CAN2_ISSR_CH24_BIT 24
#define CAN2_ISSR_CH25_MASK 0x2000000U
#define CAN2_ISSR_CH25 0x2000000U
#define CAN2_ISSR_CH25_BIT 25
#define CAN2_ISSR_CH26_MASK 0x4000000U
#define CAN2_ISSR_CH26 0x4000000U
#define CAN2_ISSR_CH26_BIT 26
#define CAN2_ISSR_CH27_MASK 0x8000000U
#define CAN2_ISSR_CH27 0x8000000U
#define CAN2_ISSR_CH27_BIT 27
#define CAN2_ISSR_CH28_MASK 0x10000000U
#define CAN2_ISSR_CH28 0x10000000U
#define CAN2_ISSR_CH28_BIT 28
#define CAN2_ISSR_CH29_MASK 0x20000000U
#define CAN2_ISSR_CH29 0x20000000U
#define CAN2_ISSR_CH29_BIT 29
#define CAN2_ISSR_CH30_MASK 0x40000000U
#define CAN2_ISSR_CH30 0x40000000U
#define CAN2_ISSR_CH30_BIT 30
#define CAN2_ISSR_CH31_MASK 0x80000000U
#define CAN2_ISSR_CH31 0x80000000U
#define CAN2_ISSR_CH31_BIT 31

#define CAN2_SIER (*(volatile unsigned long *)0xFFFBC088)
#define CAN2_SIER_OFFSET 0x88
#define CAN2_SIER_CH0_MASK 0x1U
#define CAN2_SIER_CH0 0x1U
#define CAN2_SIER_CH0_BIT 0
#define CAN2_SIER_CH1_MASK 0x2U
#define CAN2_SIER_CH1 0x2U
#define CAN2_SIER_CH1_BIT 1
#define CAN2_SIER_CH2_MASK 0x4U
#define CAN2_SIER_CH2 0x4U
#define CAN2_SIER_CH2_BIT 2
#define CAN2_SIER_CH3_MASK 0x8U
#define CAN2_SIER_CH3 0x8U
#define CAN2_SIER_CH3_BIT 3
#define CAN2_SIER_CH4_MASK 0x10U
#define CAN2_SIER_CH4 0x10U
#define CAN2_SIER_CH4_BIT 4
#define CAN2_SIER_CH5_MASK 0x20U
#define CAN2_SIER_CH5 0x20U
#define CAN2_SIER_CH5_BIT 5
#define CAN2_SIER_CH6_MASK 0x40U
#define CAN2_SIER_CH6 0x40U
#define CAN2_SIER_CH6_BIT 6
#define CAN2_SIER_CH7_MASK 0x80U
#define CAN2_SIER_CH7 0x80U
#define CAN2_SIER_CH7_BIT 7
#define CAN2_SIER_CH8_MASK 0x100U
#define CAN2_SIER_CH8 0x100U
#define CAN2_SIER_CH8_BIT 8
#define CAN2_SIER_CH9_MASK 0x200U
#define CAN2_SIER_CH9 0x200U
#define CAN2_SIER_CH9_BIT 9
#define CAN2_SIER_CH10_MASK 0x400U
#define CAN2_SIER_CH10 0x400U
#define CAN2_SIER_CH10_BIT 10
#define CAN2_SIER_CH11_MASK 0x800U
#define CAN2_SIER_CH11 0x800U
#define CAN2_SIER_CH11_BIT 11
#define CAN2_SIER_CH12_MASK 0x1000U
#define CAN2_SIER_CH12 0x1000U
#define CAN2_SIER_CH12_BIT 12
#define CAN2_SIER_CH13_MASK 0x2000U
#define CAN2_SIER_CH13 0x2000U
#define CAN2_SIER_CH13_BIT 13
#define CAN2_SIER_CH14_MASK 0x4000U
#define CAN2_SIER_CH14 0x4000U
#define CAN2_SIER_CH14_BIT 14
#define CAN2_SIER_CH15_MASK 0x8000U
#define CAN2_SIER_CH15 0x8000U
#define CAN2_SIER_CH15_BIT 15
#define CAN2_SIER_CH16_MASK 0x10000U
#define CAN2_SIER_CH16 0x10000U
#define CAN2_SIER_CH16_BIT 16
#define CAN2_SIER_CH17_MASK 0x20000U
#define CAN2_SIER_CH17 0x20000U
#define CAN2_SIER_CH17_BIT 17
#define CAN2_SIER_CH18_MASK 0x40000U
#define CAN2_SIER_CH18 0x40000U
#define CAN2_SIER_CH18_BIT 18
#define CAN2_SIER_CH19_MASK 0x80000U
#define CAN2_SIER_CH19 0x80000U
#define CAN2_SIER_CH19_BIT 19
#define CAN2_SIER_CH20_MASK 0x100000U
#define CAN2_SIER_CH20 0x100000U
#define CAN2_SIER_CH20_BIT 20
#define CAN2_SIER_CH21_MASK 0x200000U
#define CAN2_SIER_CH21 0x200000U
#define CAN2_SIER_CH21_BIT 21
#define CAN2_SIER_CH22_MASK 0x400000U
#define CAN2_SIER_CH22 0x400000U
#define CAN2_SIER_CH22_BIT 22
#define CAN2_SIER_CH23_MASK 0x800000U
#define CAN2_SIER_CH23 0x800000U
#define CAN2_SIER_CH23_BIT 23
#define CAN2_SIER_CH24_MASK 0x1000000U
#define CAN2_SIER_CH24 0x1000000U
#define CAN2_SIER_CH24_BIT 24
#define CAN2_SIER_CH25_MASK 0x2000000U
#define CAN2_SIER_CH25 0x2000000U
#define CAN2_SIER_CH25_BIT 25
#define CAN2_SIER_CH26_MASK 0x4000000U
#define CAN2_SIER_CH26 0x4000000U
#define CAN2_SIER_CH26_BIT 26
#define CAN2_SIER_CH27_MASK 0x8000000U
#define CAN2_SIER_CH27 0x8000000U
#define CAN2_SIER_CH27_BIT 27
#define CAN2_SIER_CH28_MASK 0x10000000U
#define CAN2_SIER_CH28 0x10000000U
#define CAN2_SIER_CH28_BIT 28
#define CAN2_SIER_CH29_MASK 0x20000000U
#define CAN2_SIER_CH29 0x20000000U
#define CAN2_SIER_CH29_BIT 29
#define CAN2_SIER_CH30_MASK 0x40000000U
#define CAN2_SIER_CH30 0x40000000U
#define CAN2_SIER_CH30_BIT 30
#define CAN2_SIER_CH31_MASK 0x80000000U
#define CAN2_SIER_CH31 0x80000000U
#define CAN2_SIER_CH31_BIT 31

#define CAN2_SIDR (*(volatile unsigned long *)0xFFFBC08C)
#define CAN2_SIDR_OFFSET 0x8C
#define CAN2_SIDR_CH0_MASK 0x1U
#define CAN2_SIDR_CH0 0x1U
#define CAN2_SIDR_CH0_BIT 0
#define CAN2_SIDR_CH1_MASK 0x2U
#define CAN2_SIDR_CH1 0x2U
#define CAN2_SIDR_CH1_BIT 1
#define CAN2_SIDR_CH2_MASK 0x4U
#define CAN2_SIDR_CH2 0x4U
#define CAN2_SIDR_CH2_BIT 2
#define CAN2_SIDR_CH3_MASK 0x8U
#define CAN2_SIDR_CH3 0x8U
#define CAN2_SIDR_CH3_BIT 3
#define CAN2_SIDR_CH4_MASK 0x10U
#define CAN2_SIDR_CH4 0x10U
#define CAN2_SIDR_CH4_BIT 4
#define CAN2_SIDR_CH5_MASK 0x20U
#define CAN2_SIDR_CH5 0x20U
#define CAN2_SIDR_CH5_BIT 5
#define CAN2_SIDR_CH6_MASK 0x40U
#define CAN2_SIDR_CH6 0x40U
#define CAN2_SIDR_CH6_BIT 6
#define CAN2_SIDR_CH7_MASK 0x80U
#define CAN2_SIDR_CH7 0x80U
#define CAN2_SIDR_CH7_BIT 7
#define CAN2_SIDR_CH8_MASK 0x100U
#define CAN2_SIDR_CH8 0x100U
#define CAN2_SIDR_CH8_BIT 8
#define CAN2_SIDR_CH9_MASK 0x200U
#define CAN2_SIDR_CH9 0x200U
#define CAN2_SIDR_CH9_BIT 9
#define CAN2_SIDR_CH10_MASK 0x400U
#define CAN2_SIDR_CH10 0x400U
#define CAN2_SIDR_CH10_BIT 10
#define CAN2_SIDR_CH11_MASK 0x800U
#define CAN2_SIDR_CH11 0x800U
#define CAN2_SIDR_CH11_BIT 11
#define CAN2_SIDR_CH12_MASK 0x1000U
#define CAN2_SIDR_CH12 0x1000U
#define CAN2_SIDR_CH12_BIT 12
#define CAN2_SIDR_CH13_MASK 0x2000U
#define CAN2_SIDR_CH13 0x2000U
#define CAN2_SIDR_CH13_BIT 13
#define CAN2_SIDR_CH14_MASK 0x4000U
#define CAN2_SIDR_CH14 0x4000U
#define CAN2_SIDR_CH14_BIT 14
#define CAN2_SIDR_CH15_MASK 0x8000U
#define CAN2_SIDR_CH15 0x8000U
#define CAN2_SIDR_CH15_BIT 15
#define CAN2_SIDR_CH16_MASK 0x10000U
#define CAN2_SIDR_CH16 0x10000U
#define CAN2_SIDR_CH16_BIT 16
#define CAN2_SIDR_CH17_MASK 0x20000U
#define CAN2_SIDR_CH17 0x20000U
#define CAN2_SIDR_CH17_BIT 17
#define CAN2_SIDR_CH18_MASK 0x40000U
#define CAN2_SIDR_CH18 0x40000U
#define CAN2_SIDR_CH18_BIT 18
#define CAN2_SIDR_CH19_MASK 0x80000U
#define CAN2_SIDR_CH19 0x80000U
#define CAN2_SIDR_CH19_BIT 19
#define CAN2_SIDR_CH20_MASK 0x100000U
#define CAN2_SIDR_CH20 0x100000U
#define CAN2_SIDR_CH20_BIT 20
#define CAN2_SIDR_CH21_MASK 0x200000U
#define CAN2_SIDR_CH21 0x200000U
#define CAN2_SIDR_CH21_BIT 21
#define CAN2_SIDR_CH22_MASK 0x400000U
#define CAN2_SIDR_CH22 0x400000U
#define CAN2_SIDR_CH22_BIT 22
#define CAN2_SIDR_CH23_MASK 0x800000U
#define CAN2_SIDR_CH23 0x800000U
#define CAN2_SIDR_CH23_BIT 23
#define CAN2_SIDR_CH24_MASK 0x1000000U
#define CAN2_SIDR_CH24 0x1000000U
#define CAN2_SIDR_CH24_BIT 24
#define CAN2_SIDR_CH25_MASK 0x2000000U
#define CAN2_SIDR_CH25 0x2000000U
#define CAN2_SIDR_CH25_BIT 25
#define CAN2_SIDR_CH26_MASK 0x4000000U
#define CAN2_SIDR_CH26 0x4000000U
#define CAN2_SIDR_CH26_BIT 26
#define CAN2_SIDR_CH27_MASK 0x8000000U
#define CAN2_SIDR_CH27 0x8000000U
#define CAN2_SIDR_CH27_BIT 27
#define CAN2_SIDR_CH28_MASK 0x10000000U
#define CAN2_SIDR_CH28 0x10000000U
#define CAN2_SIDR_CH28_BIT 28
#define CAN2_SIDR_CH29_MASK 0x20000000U
#define CAN2_SIDR_CH29 0x20000000U
#define CAN2_SIDR_CH29_BIT 29
#define CAN2_SIDR_CH30_MASK 0x40000000U
#define CAN2_SIDR_CH30 0x40000000U
#define CAN2_SIDR_CH30_BIT 30
#define CAN2_SIDR_CH31_MASK 0x80000000U
#define CAN2_SIDR_CH31 0x80000000U
#define CAN2_SIDR_CH31_BIT 31

#define CAN2_SIMR (*(volatile unsigned long *)0xFFFBC090)
#define CAN2_SIMR_OFFSET 0x90
#define CAN2_SIMR_CH0_MASK 0x1U
#define CAN2_SIMR_CH0 0x1U
#define CAN2_SIMR_CH0_BIT 0
#define CAN2_SIMR_CH1_MASK 0x2U
#define CAN2_SIMR_CH1 0x2U
#define CAN2_SIMR_CH1_BIT 1
#define CAN2_SIMR_CH2_MASK 0x4U
#define CAN2_SIMR_CH2 0x4U
#define CAN2_SIMR_CH2_BIT 2
#define CAN2_SIMR_CH3_MASK 0x8U
#define CAN2_SIMR_CH3 0x8U
#define CAN2_SIMR_CH3_BIT 3
#define CAN2_SIMR_CH4_MASK 0x10U
#define CAN2_SIMR_CH4 0x10U
#define CAN2_SIMR_CH4_BIT 4
#define CAN2_SIMR_CH5_MASK 0x20U
#define CAN2_SIMR_CH5 0x20U
#define CAN2_SIMR_CH5_BIT 5
#define CAN2_SIMR_CH6_MASK 0x40U
#define CAN2_SIMR_CH6 0x40U
#define CAN2_SIMR_CH6_BIT 6
#define CAN2_SIMR_CH7_MASK 0x80U
#define CAN2_SIMR_CH7 0x80U
#define CAN2_SIMR_CH7_BIT 7
#define CAN2_SIMR_CH8_MASK 0x100U
#define CAN2_SIMR_CH8 0x100U
#define CAN2_SIMR_CH8_BIT 8
#define CAN2_SIMR_CH9_MASK 0x200U
#define CAN2_SIMR_CH9 0x200U
#define CAN2_SIMR_CH9_BIT 9
#define CAN2_SIMR_CH10_MASK 0x400U
#define CAN2_SIMR_CH10 0x400U
#define CAN2_SIMR_CH10_BIT 10
#define CAN2_SIMR_CH11_MASK 0x800U
#define CAN2_SIMR_CH11 0x800U
#define CAN2_SIMR_CH11_BIT 11
#define CAN2_SIMR_CH12_MASK 0x1000U
#define CAN2_SIMR_CH12 0x1000U
#define CAN2_SIMR_CH12_BIT 12
#define CAN2_SIMR_CH13_MASK 0x2000U
#define CAN2_SIMR_CH13 0x2000U
#define CAN2_SIMR_CH13_BIT 13
#define CAN2_SIMR_CH14_MASK 0x4000U
#define CAN2_SIMR_CH14 0x4000U
#define CAN2_SIMR_CH14_BIT 14
#define CAN2_SIMR_CH15_MASK 0x8000U
#define CAN2_SIMR_CH15 0x8000U
#define CAN2_SIMR_CH15_BIT 15
#define CAN2_SIMR_CH16_MASK 0x10000U
#define CAN2_SIMR_CH16 0x10000U
#define CAN2_SIMR_CH16_BIT 16
#define CAN2_SIMR_CH17_MASK 0x20000U
#define CAN2_SIMR_CH17 0x20000U
#define CAN2_SIMR_CH17_BIT 17
#define CAN2_SIMR_CH18_MASK 0x40000U
#define CAN2_SIMR_CH18 0x40000U
#define CAN2_SIMR_CH18_BIT 18
#define CAN2_SIMR_CH19_MASK 0x80000U
#define CAN2_SIMR_CH19 0x80000U
#define CAN2_SIMR_CH19_BIT 19
#define CAN2_SIMR_CH20_MASK 0x100000U
#define CAN2_SIMR_CH20 0x100000U
#define CAN2_SIMR_CH20_BIT 20
#define CAN2_SIMR_CH21_MASK 0x200000U
#define CAN2_SIMR_CH21 0x200000U
#define CAN2_SIMR_CH21_BIT 21
#define CAN2_SIMR_CH22_MASK 0x400000U
#define CAN2_SIMR_CH22 0x400000U
#define CAN2_SIMR_CH22_BIT 22
#define CAN2_SIMR_CH23_MASK 0x800000U
#define CAN2_SIMR_CH23 0x800000U
#define CAN2_SIMR_CH23_BIT 23
#define CAN2_SIMR_CH24_MASK 0x1000000U
#define CAN2_SIMR_CH24 0x1000000U
#define CAN2_SIMR_CH24_BIT 24
#define CAN2_SIMR_CH25_MASK 0x2000000U
#define CAN2_SIMR_CH25 0x2000000U
#define CAN2_SIMR_CH25_BIT 25
#define CAN2_SIMR_CH26_MASK 0x4000000U
#define CAN2_SIMR_CH26 0x4000000U
#define CAN2_SIMR_CH26_BIT 26
#define CAN2_SIMR_CH27_MASK 0x8000000U
#define CAN2_SIMR_CH27 0x8000000U
#define CAN2_SIMR_CH27_BIT 27
#define CAN2_SIMR_CH28_MASK 0x10000000U
#define CAN2_SIMR_CH28 0x10000000U
#define CAN2_SIMR_CH28_BIT 28
#define CAN2_SIMR_CH29_MASK 0x20000000U
#define CAN2_SIMR_CH29 0x20000000U
#define CAN2_SIMR_CH29_BIT 29
#define CAN2_SIMR_CH30_MASK 0x40000000U
#define CAN2_SIMR_CH30 0x40000000U
#define CAN2_SIMR_CH30_BIT 30
#define CAN2_SIMR_CH31_MASK 0x80000000U
#define CAN2_SIMR_CH31 0x80000000U
#define CAN2_SIMR_CH31_BIT 31

#define CAN2_DRA0 (*(volatile unsigned long *)0xFFFBC100)
#define CAN2_DRA0_OFFSET 0x100
#define CAN2_DRA0_DATA0_MASK 0xFFU
#define CAN2_DRA0_DATA0_BIT 0
#define CAN2_DRA0_DATA1_MASK 0xFF00U
#define CAN2_DRA0_DATA1_BIT 8
#define CAN2_DRA0_DATA2_MASK 0xFF0000U
#define CAN2_DRA0_DATA2_BIT 16
#define CAN2_DRA0_DATA3_MASK 0xFF000000U
#define CAN2_DRA0_DATA3_BIT 24

#define CAN2_DRB0 (*(volatile unsigned long *)0xFFFBC104)
#define CAN2_DRB0_OFFSET 0x104
#define CAN2_DRB0_DATA4_MASK 0xFFU
#define CAN2_DRB0_DATA4_BIT 0
#define CAN2_DRB0_DATA5_MASK 0xFF00U
#define CAN2_DRB0_DATA5_BIT 8
#define CAN2_DRB0_DATA6_MASK 0xFF0000U
#define CAN2_DRB0_DATA6_BIT 16
#define CAN2_DRB0_DATA7_MASK 0xFF000000U
#define CAN2_DRB0_DATA7_BIT 24

#define CAN2_MSK0 (*(volatile unsigned long *)0xFFFBC108)
#define CAN2_MSK0_OFFSET 0x108
#define CAN2_MSK0_MASK_MASK 0x1FFFFFFFU
#define CAN2_MSK0_MASK_BIT 0
#define CAN2_MSK0_MRB_MASK 0x60000000U
#define CAN2_MSK0_MRB_BIT 29
#define CAN2_MSK0_MRTR_MASK 0x80000000U
#define CAN2_MSK0_MRTR 0x80000000U
#define CAN2_MSK0_MRTR_BIT 31

#define CAN2_IR0 (*(volatile unsigned long *)0xFFFBC10C)
#define CAN2_IR0_OFFSET 0x10C
#define CAN2_IR0_ID_MASK 0x1FFFFFFFU
#define CAN2_IR0_ID_BIT 0
#define CAN2_IR0_RB_MASK 0x60000000U
#define CAN2_IR0_RB_BIT 29
#define CAN2_IR0_RTR_MASK 0x80000000U
#define CAN2_IR0_RTR 0x80000000U
#define CAN2_IR0_RTR_BIT 31

#define CAN2_CR0 (*(volatile unsigned long *)0xFFFBC110)
#define CAN2_CR0_OFFSET 0x110
#define CAN2_CR0_DLC_MASK 0xFU
#define CAN2_CR0_DLC_BIT 0
#define CAN2_CR0_IDE_MASK 0x10U
#define CAN2_CR0_IDE 0x10U
#define CAN2_CR0_IDE_BIT 4
#define CAN2_CR0_RPLYV_MASK 0x20U
#define CAN2_CR0_RPLYV 0x20U
#define CAN2_CR0_RPLYV_BIT 5
#define CAN2_CR0_PCB_MASK 0x40U
#define CAN2_CR0_PCB 0x40U
#define CAN2_CR0_PCB_BIT 6
#define CAN2_CR0_CHANEN_MASK 0x80U
#define CAN2_CR0_CHANEN 0x80U
#define CAN2_CR0_CHANEN_BIT 7
#define CAN2_CR0_OVERWRITE_MASK 0x100U
#define CAN2_CR0_OVERWRITE 0x100U
#define CAN2_CR0_OVERWRITE_BIT 8

#define CAN2_CR0 (*(volatile unsigned long *)0xFFFBC114)
#define CAN2_CR0_OFFSET 0x114
#define CAN2_CR0_STAMP_MASK 0x0U
#define CAN2_CR0_STAMP_BIT 0

#define CAN2_CSR0 (*(volatile unsigned long *)0xFFFBC118)
#define CAN2_CSR0_OFFSET 0x118
#define CAN2_CSR0_ACK_MASK 0x1U
#define CAN2_CSR0_ACK 0x1U
#define CAN2_CSR0_ACK_BIT 0
#define CAN2_CSR0_FRAME_MASK 0x2U
#define CAN2_CSR0_FRAME 0x2U
#define CAN2_CSR0_FRAME_BIT 1
#define CAN2_CSR0_CRC_MASK 0x4U
#define CAN2_CSR0_CRC 0x4U
#define CAN2_CSR0_CRC_BIT 2
#define CAN2_CSR0_STUFF_MASK 0x8U
#define CAN2_CSR0_STUFF 0x8U
#define CAN2_CSR0_STUFF_BIT 3
#define CAN2_CSR0_BUS_MASK 0x10U
#define CAN2_CSR0_BUS 0x10U
#define CAN2_CSR0_BUS_BIT 4
#define CAN2_CSR0_RXOK_MASK 0x20U
#define CAN2_CSR0_RXOK 0x20U
#define CAN2_CSR0_RXOK_BIT 5
#define CAN2_CSR0_TXOK_MASK 0x40U
#define CAN2_CSR0_TXOK 0x40U
#define CAN2_CSR0_TXOK_BIT 6
#define CAN2_CSR0_RFRAME_MASK 0x80U
#define CAN2_CSR0_RFRAME 0x80U
#define CAN2_CSR0_RFRAME_BIT 7
#define CAN2_CSR0_DLCW_MASK 0x200U
#define CAN2_CSR0_DLCW 0x200U
#define CAN2_CSR0_DLCW_BIT 9
#define CAN2_CSR0_FILLED_MASK 0x400U
#define CAN2_CSR0_FILLED 0x400U
#define CAN2_CSR0_FILLED_BIT 10
#define CAN2_CSR0_OVRUN_MASK 0x800U
#define CAN2_CSR0_OVRUN 0x800U
#define CAN2_CSR0_OVRUN_BIT 11

#define CAN2_SR0 (*(volatile unsigned long *)0xFFFBC11C)
#define CAN2_SR0_OFFSET 0x11C
#define CAN2_SR0_ACK_MASK 0x1U
#define CAN2_SR0_ACK 0x1U
#define CAN2_SR0_ACK_BIT 0
#define CAN2_SR0_FRAME_MASK 0x2U
#define CAN2_SR0_FRAME 0x2U
#define CAN2_SR0_FRAME_BIT 1
#define CAN2_SR0_CRC_MASK 0x4U
#define CAN2_SR0_CRC 0x4U
#define CAN2_SR0_CRC_BIT 2
#define CAN2_SR0_STUFF_MASK 0x8U
#define CAN2_SR0_STUFF 0x8U
#define CAN2_SR0_STUFF_BIT 3
#define CAN2_SR0_BUS_MASK 0x10U
#define CAN2_SR0_BUS 0x10U
#define CAN2_SR0_BUS_BIT 4
#define CAN2_SR0_RXOK_MASK 0x20U
#define CAN2_SR0_RXOK 0x20U
#define CAN2_SR0_RXOK_BIT 5
#define CAN2_SR0_TXOK_MASK 0x40U
#define CAN2_SR0_TXOK 0x40U
#define CAN2_SR0_TXOK_BIT 6
#define CAN2_SR0_RFRAME_MASK 0x80U
#define CAN2_SR0_RFRAME 0x80U
#define CAN2_SR0_RFRAME_BIT 7
#define CAN2_SR0_DLCW_MASK 0x200U
#define CAN2_SR0_DLCW 0x200U
#define CAN2_SR0_DLCW_BIT 9
#define CAN2_SR0_FILLED_MASK 0x400U
#define CAN2_SR0_FILLED 0x400U
#define CAN2_SR0_FILLED_BIT 10
#define CAN2_SR0_OVRUN_MASK 0x800U
#define CAN2_SR0_OVRUN 0x800U
#define CAN2_SR0_OVRUN_BIT 11

#define CAN2_IER0 (*(volatile unsigned long *)0xFFFBC120)
#define CAN2_IER0_OFFSET 0x120
#define CAN2_IER0_ACK_MASK 0x1U
#define CAN2_IER0_ACK 0x1U
#define CAN2_IER0_ACK_BIT 0
#define CAN2_IER0_FRAME_MASK 0x2U
#define CAN2_IER0_FRAME 0x2U
#define CAN2_IER0_FRAME_BIT 1
#define CAN2_IER0_CRC_MASK 0x4U
#define CAN2_IER0_CRC 0x4U
#define CAN2_IER0_CRC_BIT 2
#define CAN2_IER0_STUFF_MASK 0x8U
#define CAN2_IER0_STUFF 0x8U
#define CAN2_IER0_STUFF_BIT 3
#define CAN2_IER0_BUS_MASK 0x10U
#define CAN2_IER0_BUS 0x10U
#define CAN2_IER0_BUS_BIT 4
#define CAN2_IER0_RXOK_MASK 0x20U
#define CAN2_IER0_RXOK 0x20U
#define CAN2_IER0_RXOK_BIT 5
#define CAN2_IER0_TXOK_MASK 0x40U
#define CAN2_IER0_TXOK 0x40U
#define CAN2_IER0_TXOK_BIT 6
#define CAN2_IER0_RFRAME_MASK 0x80U
#define CAN2_IER0_RFRAME 0x80U
#define CAN2_IER0_RFRAME_BIT 7

#define CAN2_IDR0 (*(volatile unsigned long *)0xFFFBC124)
#define CAN2_IDR0_OFFSET 0x124
#define CAN2_IDR0_ACK_MASK 0x1U
#define CAN2_IDR0_ACK 0x1U
#define CAN2_IDR0_ACK_BIT 0
#define CAN2_IDR0_FRAME_MASK 0x2U
#define CAN2_IDR0_FRAME 0x2U
#define CAN2_IDR0_FRAME_BIT 1
#define CAN2_IDR0_CRC_MASK 0x4U
#define CAN2_IDR0_CRC 0x4U
#define CAN2_IDR0_CRC_BIT 2
#define CAN2_IDR0_STUFF_MASK 0x8U
#define CAN2_IDR0_STUFF 0x8U
#define CAN2_IDR0_STUFF_BIT 3
#define CAN2_IDR0_BUS_MASK 0x10U
#define CAN2_IDR0_BUS 0x10U
#define CAN2_IDR0_BUS_BIT 4
#define CAN2_IDR0_RXOK_MASK 0x20U
#define CAN2_IDR0_RXOK 0x20U
#define CAN2_IDR0_RXOK_BIT 5
#define CAN2_IDR0_TXOK_MASK 0x40U
#define CAN2_IDR0_TXOK 0x40U
#define CAN2_IDR0_TXOK_BIT 6
#define CAN2_IDR0_RFRAME_MASK 0x80U
#define CAN2_IDR0_RFRAME 0x80U
#define CAN2_IDR0_RFRAME_BIT 7

#define CAN2_IMR0 (*(volatile unsigned long *)0xFFFBC128)
#define CAN2_IMR0_OFFSET 0x128
#define CAN2_IMR0_ACK_MASK 0x1U
#define CAN2_IMR0_ACK 0x1U
#define CAN2_IMR0_ACK_BIT 0
#define CAN2_IMR0_FRAME_MASK 0x2U
#define CAN2_IMR0_FRAME 0x2U
#define CAN2_IMR0_FRAME_BIT 1
#define CAN2_IMR0_CRC_MASK 0x4U
#define CAN2_IMR0_CRC 0x4U
#define CAN2_IMR0_CRC_BIT 2
#define CAN2_IMR0_STUFF_MASK 0x8U
#define CAN2_IMR0_STUFF 0x8U
#define CAN2_IMR0_STUFF_BIT 3
#define CAN2_IMR0_BUS_MASK 0x10U
#define CAN2_IMR0_BUS 0x10U
#define CAN2_IMR0_BUS_BIT 4
#define CAN2_IMR0_RXOK_MASK 0x20U
#define CAN2_IMR0_RXOK 0x20U
#define CAN2_IMR0_RXOK_BIT 5
#define CAN2_IMR0_TXOK_MASK 0x40U
#define CAN2_IMR0_TXOK 0x40U
#define CAN2_IMR0_TXOK_BIT 6
#define CAN2_IMR0_RFRAME_MASK 0x80U
#define CAN2_IMR0_RFRAME 0x80U
#define CAN2_IMR0_RFRAME_BIT 7

#define CAN2_DRA1 (*(volatile unsigned long *)0xFFFBC140)
#define CAN2_DRA1_OFFSET 0x140
#define CAN2_DRA1_DATA0_MASK 0xFFU
#define CAN2_DRA1_DATA0_BIT 0
#define CAN2_DRA1_DATA1_MASK 0xFF00U
#define CAN2_DRA1_DATA1_BIT 8
#define CAN2_DRA1_DATA2_MASK 0xFF0000U
#define CAN2_DRA1_DATA2_BIT 16
#define CAN2_DRA1_DATA3_MASK 0xFF000000U
#define CAN2_DRA1_DATA3_BIT 24

#define CAN2_DRB1 (*(volatile unsigned long *)0xFFFBC144)
#define CAN2_DRB1_OFFSET 0x144
#define CAN2_DRB1_DATA4_MASK 0xFFU
#define CAN2_DRB1_DATA4_BIT 0
#define CAN2_DRB1_DATA5_MASK 0xFF00U
#define CAN2_DRB1_DATA5_BIT 8
#define CAN2_DRB1_DATA6_MASK 0xFF0000U
#define CAN2_DRB1_DATA6_BIT 16
#define CAN2_DRB1_DATA7_MASK 0xFF000000U
#define CAN2_DRB1_DATA7_BIT 24

#define CAN2_MSK1 (*(volatile unsigned long *)0xFFFBC148)
#define CAN2_MSK1_OFFSET 0x148
#define CAN2_MSK1_MASK_MASK 0x1FFFFFFFU
#define CAN2_MSK1_MASK_BIT 0
#define CAN2_MSK1_MRB_MASK 0x60000000U
#define CAN2_MSK1_MRB_BIT 29
#define CAN2_MSK1_MRTR_MASK 0x80000000U
#define CAN2_MSK1_MRTR 0x80000000U
#define CAN2_MSK1_MRTR_BIT 31

#define CAN2_IR1 (*(volatile unsigned long *)0xFFFBC14C)
#define CAN2_IR1_OFFSET 0x14C
#define CAN2_IR1_ID_MASK 0x1FFFFFFFU
#define CAN2_IR1_ID_BIT 0
#define CAN2_IR1_RB_MASK 0x60000000U
#define CAN2_IR1_RB_BIT 29
#define CAN2_IR1_RTR_MASK 0x80000000U
#define CAN2_IR1_RTR 0x80000000U
#define CAN2_IR1_RTR_BIT 31

#define CAN2_CR1 (*(volatile unsigned long *)0xFFFBC150)
#define CAN2_CR1_OFFSET 0x150
#define CAN2_CR1_DLC_MASK 0xFU
#define CAN2_CR1_DLC_BIT 0
#define CAN2_CR1_IDE_MASK 0x10U
#define CAN2_CR1_IDE 0x10U
#define CAN2_CR1_IDE_BIT 4
#define CAN2_CR1_RPLYV_MASK 0x20U
#define CAN2_CR1_RPLYV 0x20U
#define CAN2_CR1_RPLYV_BIT 5
#define CAN2_CR1_PCB_MASK 0x40U
#define CAN2_CR1_PCB 0x40U
#define CAN2_CR1_PCB_BIT 6
#define CAN2_CR1_CHANEN_MASK 0x80U
#define CAN2_CR1_CHANEN 0x80U
#define CAN2_CR1_CHANEN_BIT 7
#define CAN2_CR1_OVERWRITE_MASK 0x100U
#define CAN2_CR1_OVERWRITE 0x100U
#define CAN2_CR1_OVERWRITE_BIT 8

#define CAN2_CR1 (*(volatile unsigned long *)0xFFFBC154)
#define CAN2_CR1_OFFSET 0x154
#define CAN2_CR1_STAMP_MASK 0x0U
#define CAN2_CR1_STAMP_BIT 0

#define CAN2_CSR1 (*(volatile unsigned long *)0xFFFBC158)
#define CAN2_CSR1_OFFSET 0x158
#define CAN2_CSR1_ACK_MASK 0x1U
#define CAN2_CSR1_ACK 0x1U
#define CAN2_CSR1_ACK_BIT 0
#define CAN2_CSR1_FRAME_MASK 0x2U
#define CAN2_CSR1_FRAME 0x2U
#define CAN2_CSR1_FRAME_BIT 1
#define CAN2_CSR1_CRC_MASK 0x4U
#define CAN2_CSR1_CRC 0x4U
#define CAN2_CSR1_CRC_BIT 2
#define CAN2_CSR1_STUFF_MASK 0x8U
#define CAN2_CSR1_STUFF 0x8U
#define CAN2_CSR1_STUFF_BIT 3
#define CAN2_CSR1_BUS_MASK 0x10U
#define CAN2_CSR1_BUS 0x10U
#define CAN2_CSR1_BUS_BIT 4
#define CAN2_CSR1_RXOK_MASK 0x20U
#define CAN2_CSR1_RXOK 0x20U
#define CAN2_CSR1_RXOK_BIT 5
#define CAN2_CSR1_TXOK_MASK 0x40U
#define CAN2_CSR1_TXOK 0x40U
#define CAN2_CSR1_TXOK_BIT 6
#define CAN2_CSR1_RFRAME_MASK 0x80U
#define CAN2_CSR1_RFRAME 0x80U
#define CAN2_CSR1_RFRAME_BIT 7
#define CAN2_CSR1_DLCW_MASK 0x200U
#define CAN2_CSR1_DLCW 0x200U
#define CAN2_CSR1_DLCW_BIT 9
#define CAN2_CSR1_FILLED_MASK 0x400U
#define CAN2_CSR1_FILLED 0x400U
#define CAN2_CSR1_FILLED_BIT 10
#define CAN2_CSR1_OVRUN_MASK 0x800U
#define CAN2_CSR1_OVRUN 0x800U
#define CAN2_CSR1_OVRUN_BIT 11

#define CAN2_SR1 (*(volatile unsigned long *)0xFFFBC15C)
#define CAN2_SR1_OFFSET 0x15C
#define CAN2_SR1_ACK_MASK 0x1U
#define CAN2_SR1_ACK 0x1U
#define CAN2_SR1_ACK_BIT 0
#define CAN2_SR1_FRAME_MASK 0x2U
#define CAN2_SR1_FRAME 0x2U
#define CAN2_SR1_FRAME_BIT 1
#define CAN2_SR1_CRC_MASK 0x4U
#define CAN2_SR1_CRC 0x4U
#define CAN2_SR1_CRC_BIT 2
#define CAN2_SR1_STUFF_MASK 0x8U
#define CAN2_SR1_STUFF 0x8U
#define CAN2_SR1_STUFF_BIT 3
#define CAN2_SR1_BUS_MASK 0x10U
#define CAN2_SR1_BUS 0x10U
#define CAN2_SR1_BUS_BIT 4
#define CAN2_SR1_RXOK_MASK 0x20U
#define CAN2_SR1_RXOK 0x20U
#define CAN2_SR1_RXOK_BIT 5
#define CAN2_SR1_TXOK_MASK 0x40U
#define CAN2_SR1_TXOK 0x40U
#define CAN2_SR1_TXOK_BIT 6
#define CAN2_SR1_RFRAME_MASK 0x80U
#define CAN2_SR1_RFRAME 0x80U
#define CAN2_SR1_RFRAME_BIT 7
#define CAN2_SR1_DLCW_MASK 0x200U
#define CAN2_SR1_DLCW 0x200U
#define CAN2_SR1_DLCW_BIT 9
#define CAN2_SR1_FILLED_MASK 0x400U
#define CAN2_SR1_FILLED 0x400U
#define CAN2_SR1_FILLED_BIT 10
#define CAN2_SR1_OVRUN_MASK 0x800U
#define CAN2_SR1_OVRUN 0x800U
#define CAN2_SR1_OVRUN_BIT 11

#define CAN2_IER1 (*(volatile unsigned long *)0xFFFBC160)
#define CAN2_IER1_OFFSET 0x160
#define CAN2_IER1_ACK_MASK 0x1U
#define CAN2_IER1_ACK 0x1U
#define CAN2_IER1_ACK_BIT 0
#define CAN2_IER1_FRAME_MASK 0x2U
#define CAN2_IER1_FRAME 0x2U
#define CAN2_IER1_FRAME_BIT 1
#define CAN2_IER1_CRC_MASK 0x4U
#define CAN2_IER1_CRC 0x4U
#define CAN2_IER1_CRC_BIT 2
#define CAN2_IER1_STUFF_MASK 0x8U
#define CAN2_IER1_STUFF 0x8U
#define CAN2_IER1_STUFF_BIT 3
#define CAN2_IER1_BUS_MASK 0x10U
#define CAN2_IER1_BUS 0x10U
#define CAN2_IER1_BUS_BIT 4
#define CAN2_IER1_RXOK_MASK 0x20U
#define CAN2_IER1_RXOK 0x20U
#define CAN2_IER1_RXOK_BIT 5
#define CAN2_IER1_TXOK_MASK 0x40U
#define CAN2_IER1_TXOK 0x40U
#define CAN2_IER1_TXOK_BIT 6
#define CAN2_IER1_RFRAME_MASK 0x80U
#define CAN2_IER1_RFRAME 0x80U
#define CAN2_IER1_RFRAME_BIT 7

#define CAN2_IDR1 (*(volatile unsigned long *)0xFFFBC164)
#define CAN2_IDR1_OFFSET 0x164
#define CAN2_IDR1_ACK_MASK 0x1U
#define CAN2_IDR1_ACK 0x1U
#define CAN2_IDR1_ACK_BIT 0
#define CAN2_IDR1_FRAME_MASK 0x2U
#define CAN2_IDR1_FRAME 0x2U
#define CAN2_IDR1_FRAME_BIT 1
#define CAN2_IDR1_CRC_MASK 0x4U
#define CAN2_IDR1_CRC 0x4U
#define CAN2_IDR1_CRC_BIT 2
#define CAN2_IDR1_STUFF_MASK 0x8U
#define CAN2_IDR1_STUFF 0x8U
#define CAN2_IDR1_STUFF_BIT 3
#define CAN2_IDR1_BUS_MASK 0x10U
#define CAN2_IDR1_BUS 0x10U
#define CAN2_IDR1_BUS_BIT 4
#define CAN2_IDR1_RXOK_MASK 0x20U
#define CAN2_IDR1_RXOK 0x20U
#define CAN2_IDR1_RXOK_BIT 5
#define CAN2_IDR1_TXOK_MASK 0x40U
#define CAN2_IDR1_TXOK 0x40U
#define CAN2_IDR1_TXOK_BIT 6
#define CAN2_IDR1_RFRAME_MASK 0x80U
#define CAN2_IDR1_RFRAME 0x80U
#define CAN2_IDR1_RFRAME_BIT 7

#define CAN2_IMR1 (*(volatile unsigned long *)0xFFFBC168)
#define CAN2_IMR1_OFFSET 0x168
#define CAN2_IMR1_ACK_MASK 0x1U
#define CAN2_IMR1_ACK 0x1U
#define CAN2_IMR1_ACK_BIT 0
#define CAN2_IMR1_FRAME_MASK 0x2U
#define CAN2_IMR1_FRAME 0x2U
#define CAN2_IMR1_FRAME_BIT 1
#define CAN2_IMR1_CRC_MASK 0x4U
#define CAN2_IMR1_CRC 0x4U
#define CAN2_IMR1_CRC_BIT 2
#define CAN2_IMR1_STUFF_MASK 0x8U
#define CAN2_IMR1_STUFF 0x8U
#define CAN2_IMR1_STUFF_BIT 3
#define CAN2_IMR1_BUS_MASK 0x10U
#define CAN2_IMR1_BUS 0x10U
#define CAN2_IMR1_BUS_BIT 4
#define CAN2_IMR1_RXOK_MASK 0x20U
#define CAN2_IMR1_RXOK 0x20U
#define CAN2_IMR1_RXOK_BIT 5
#define CAN2_IMR1_TXOK_MASK 0x40U
#define CAN2_IMR1_TXOK 0x40U
#define CAN2_IMR1_TXOK_BIT 6
#define CAN2_IMR1_RFRAME_MASK 0x80U
#define CAN2_IMR1_RFRAME 0x80U
#define CAN2_IMR1_RFRAME_BIT 7

#define CAN2_DRA2 (*(volatile unsigned long *)0xFFFBC180)
#define CAN2_DRA2_OFFSET 0x180
#define CAN2_DRA2_DATA0_MASK 0xFFU
#define CAN2_DRA2_DATA0_BIT 0
#define CAN2_DRA2_DATA1_MASK 0xFF00U
#define CAN2_DRA2_DATA1_BIT 8
#define CAN2_DRA2_DATA2_MASK 0xFF0000U
#define CAN2_DRA2_DATA2_BIT 16
#define CAN2_DRA2_DATA3_MASK 0xFF000000U
#define CAN2_DRA2_DATA3_BIT 24

#define CAN2_DRB2 (*(volatile unsigned long *)0xFFFBC184)
#define CAN2_DRB2_OFFSET 0x184
#define CAN2_DRB2_DATA4_MASK 0xFFU
#define CAN2_DRB2_DATA4_BIT 0
#define CAN2_DRB2_DATA5_MASK 0xFF00U
#define CAN2_DRB2_DATA5_BIT 8
#define CAN2_DRB2_DATA6_MASK 0xFF0000U
#define CAN2_DRB2_DATA6_BIT 16
#define CAN2_DRB2_DATA7_MASK 0xFF000000U
#define CAN2_DRB2_DATA7_BIT 24

#define CAN2_MSK2 (*(volatile unsigned long *)0xFFFBC188)
#define CAN2_MSK2_OFFSET 0x188
#define CAN2_MSK2_MASK_MASK 0x1FFFFFFFU
#define CAN2_MSK2_MASK_BIT 0
#define CAN2_MSK2_MRB_MASK 0x60000000U
#define CAN2_MSK2_MRB_BIT 29
#define CAN2_MSK2_MRTR_MASK 0x80000000U
#define CAN2_MSK2_MRTR 0x80000000U
#define CAN2_MSK2_MRTR_BIT 31

#define CAN2_IR2 (*(volatile unsigned long *)0xFFFBC18C)
#define CAN2_IR2_OFFSET 0x18C
#define CAN2_IR2_ID_MASK 0x1FFFFFFFU
#define CAN2_IR2_ID_BIT 0
#define CAN2_IR2_RB_MASK 0x60000000U
#define CAN2_IR2_RB_BIT 29
#define CAN2_IR2_RTR_MASK 0x80000000U
#define CAN2_IR2_RTR 0x80000000U
#define CAN2_IR2_RTR_BIT 31

#define CAN2_CR2 (*(volatile unsigned long *)0xFFFBC190)
#define CAN2_CR2_OFFSET 0x190
#define CAN2_CR2_DLC_MASK 0xFU
#define CAN2_CR2_DLC_BIT 0
#define CAN2_CR2_IDE_MASK 0x10U
#define CAN2_CR2_IDE 0x10U
#define CAN2_CR2_IDE_BIT 4
#define CAN2_CR2_RPLYV_MASK 0x20U
#define CAN2_CR2_RPLYV 0x20U
#define CAN2_CR2_RPLYV_BIT 5
#define CAN2_CR2_PCB_MASK 0x40U
#define CAN2_CR2_PCB 0x40U
#define CAN2_CR2_PCB_BIT 6
#define CAN2_CR2_CHANEN_MASK 0x80U
#define CAN2_CR2_CHANEN 0x80U
#define CAN2_CR2_CHANEN_BIT 7
#define CAN2_CR2_OVERWRITE_MASK 0x100U
#define CAN2_CR2_OVERWRITE 0x100U
#define CAN2_CR2_OVERWRITE_BIT 8

#define CAN2_CR2 (*(volatile unsigned long *)0xFFFBC194)
#define CAN2_CR2_OFFSET 0x194
#define CAN2_CR2_STAMP_MASK 0x0U
#define CAN2_CR2_STAMP_BIT 0

#define CAN2_CSR2 (*(volatile unsigned long *)0xFFFBC198)
#define CAN2_CSR2_OFFSET 0x198
#define CAN2_CSR2_ACK_MASK 0x1U
#define CAN2_CSR2_ACK 0x1U
#define CAN2_CSR2_ACK_BIT 0
#define CAN2_CSR2_FRAME_MASK 0x2U
#define CAN2_CSR2_FRAME 0x2U
#define CAN2_CSR2_FRAME_BIT 1
#define CAN2_CSR2_CRC_MASK 0x4U
#define CAN2_CSR2_CRC 0x4U
#define CAN2_CSR2_CRC_BIT 2
#define CAN2_CSR2_STUFF_MASK 0x8U
#define CAN2_CSR2_STUFF 0x8U
#define CAN2_CSR2_STUFF_BIT 3
#define CAN2_CSR2_BUS_MASK 0x10U
#define CAN2_CSR2_BUS 0x10U
#define CAN2_CSR2_BUS_BIT 4
#define CAN2_CSR2_RXOK_MASK 0x20U
#define CAN2_CSR2_RXOK 0x20U
#define CAN2_CSR2_RXOK_BIT 5
#define CAN2_CSR2_TXOK_MASK 0x40U
#define CAN2_CSR2_TXOK 0x40U
#define CAN2_CSR2_TXOK_BIT 6
#define CAN2_CSR2_RFRAME_MASK 0x80U
#define CAN2_CSR2_RFRAME 0x80U
#define CAN2_CSR2_RFRAME_BIT 7
#define CAN2_CSR2_DLCW_MASK 0x200U
#define CAN2_CSR2_DLCW 0x200U
#define CAN2_CSR2_DLCW_BIT 9
#define CAN2_CSR2_FILLED_MASK 0x400U
#define CAN2_CSR2_FILLED 0x400U
#define CAN2_CSR2_FILLED_BIT 10
#define CAN2_CSR2_OVRUN_MASK 0x800U
#define CAN2_CSR2_OVRUN 0x800U
#define CAN2_CSR2_OVRUN_BIT 11

#define CAN2_SR2 (*(volatile unsigned long *)0xFFFBC19C)
#define CAN2_SR2_OFFSET 0x19C
#define CAN2_SR2_ACK_MASK 0x1U
#define CAN2_SR2_ACK 0x1U
#define CAN2_SR2_ACK_BIT 0
#define CAN2_SR2_FRAME_MASK 0x2U
#define CAN2_SR2_FRAME 0x2U
#define CAN2_SR2_FRAME_BIT 1
#define CAN2_SR2_CRC_MASK 0x4U
#define CAN2_SR2_CRC 0x4U
#define CAN2_SR2_CRC_BIT 2
#define CAN2_SR2_STUFF_MASK 0x8U
#define CAN2_SR2_STUFF 0x8U
#define CAN2_SR2_STUFF_BIT 3
#define CAN2_SR2_BUS_MASK 0x10U
#define CAN2_SR2_BUS 0x10U
#define CAN2_SR2_BUS_BIT 4
#define CAN2_SR2_RXOK_MASK 0x20U
#define CAN2_SR2_RXOK 0x20U
#define CAN2_SR2_RXOK_BIT 5
#define CAN2_SR2_TXOK_MASK 0x40U
#define CAN2_SR2_TXOK 0x40U
#define CAN2_SR2_TXOK_BIT 6
#define CAN2_SR2_RFRAME_MASK 0x80U
#define CAN2_SR2_RFRAME 0x80U
#define CAN2_SR2_RFRAME_BIT 7
#define CAN2_SR2_DLCW_MASK 0x200U
#define CAN2_SR2_DLCW 0x200U
#define CAN2_SR2_DLCW_BIT 9
#define CAN2_SR2_FILLED_MASK 0x400U
#define CAN2_SR2_FILLED 0x400U
#define CAN2_SR2_FILLED_BIT 10
#define CAN2_SR2_OVRUN_MASK 0x800U
#define CAN2_SR2_OVRUN 0x800U
#define CAN2_SR2_OVRUN_BIT 11

#define CAN2_IER2 (*(volatile unsigned long *)0xFFFBC1A0)
#define CAN2_IER2_OFFSET 0x1A0
#define CAN2_IER2_ACK_MASK 0x1U
#define CAN2_IER2_ACK 0x1U
#define CAN2_IER2_ACK_BIT 0
#define CAN2_IER2_FRAME_MASK 0x2U
#define CAN2_IER2_FRAME 0x2U
#define CAN2_IER2_FRAME_BIT 1
#define CAN2_IER2_CRC_MASK 0x4U
#define CAN2_IER2_CRC 0x4U
#define CAN2_IER2_CRC_BIT 2
#define CAN2_IER2_STUFF_MASK 0x8U
#define CAN2_IER2_STUFF 0x8U
#define CAN2_IER2_STUFF_BIT 3
#define CAN2_IER2_BUS_MASK 0x10U
#define CAN2_IER2_BUS 0x10U
#define CAN2_IER2_BUS_BIT 4
#define CAN2_IER2_RXOK_MASK 0x20U
#define CAN2_IER2_RXOK 0x20U
#define CAN2_IER2_RXOK_BIT 5
#define CAN2_IER2_TXOK_MASK 0x40U
#define CAN2_IER2_TXOK 0x40U
#define CAN2_IER2_TXOK_BIT 6
#define CAN2_IER2_RFRAME_MASK 0x80U
#define CAN2_IER2_RFRAME 0x80U
#define CAN2_IER2_RFRAME_BIT 7

#define CAN2_IDR2 (*(volatile unsigned long *)0xFFFBC1A4)
#define CAN2_IDR2_OFFSET 0x1A4
#define CAN2_IDR2_ACK_MASK 0x1U
#define CAN2_IDR2_ACK 0x1U
#define CAN2_IDR2_ACK_BIT 0
#define CAN2_IDR2_FRAME_MASK 0x2U
#define CAN2_IDR2_FRAME 0x2U
#define CAN2_IDR2_FRAME_BIT 1
#define CAN2_IDR2_CRC_MASK 0x4U
#define CAN2_IDR2_CRC 0x4U
#define CAN2_IDR2_CRC_BIT 2
#define CAN2_IDR2_STUFF_MASK 0x8U
#define CAN2_IDR2_STUFF 0x8U
#define CAN2_IDR2_STUFF_BIT 3
#define CAN2_IDR2_BUS_MASK 0x10U
#define CAN2_IDR2_BUS 0x10U
#define CAN2_IDR2_BUS_BIT 4
#define CAN2_IDR2_RXOK_MASK 0x20U
#define CAN2_IDR2_RXOK 0x20U
#define CAN2_IDR2_RXOK_BIT 5
#define CAN2_IDR2_TXOK_MASK 0x40U
#define CAN2_IDR2_TXOK 0x40U
#define CAN2_IDR2_TXOK_BIT 6
#define CAN2_IDR2_RFRAME_MASK 0x80U
#define CAN2_IDR2_RFRAME 0x80U
#define CAN2_IDR2_RFRAME_BIT 7

#define CAN2_IMR2 (*(volatile unsigned long *)0xFFFBC1A8)
#define CAN2_IMR2_OFFSET 0x1A8
#define CAN2_IMR2_ACK_MASK 0x1U
#define CAN2_IMR2_ACK 0x1U
#define CAN2_IMR2_ACK_BIT 0
#define CAN2_IMR2_FRAME_MASK 0x2U
#define CAN2_IMR2_FRAME 0x2U
#define CAN2_IMR2_FRAME_BIT 1
#define CAN2_IMR2_CRC_MASK 0x4U
#define CAN2_IMR2_CRC 0x4U
#define CAN2_IMR2_CRC_BIT 2
#define CAN2_IMR2_STUFF_MASK 0x8U
#define CAN2_IMR2_STUFF 0x8U
#define CAN2_IMR2_STUFF_BIT 3
#define CAN2_IMR2_BUS_MASK 0x10U
#define CAN2_IMR2_BUS 0x10U
#define CAN2_IMR2_BUS_BIT 4
#define CAN2_IMR2_RXOK_MASK 0x20U
#define CAN2_IMR2_RXOK 0x20U
#define CAN2_IMR2_RXOK_BIT 5
#define CAN2_IMR2_TXOK_MASK 0x40U
#define CAN2_IMR2_TXOK 0x40U
#define CAN2_IMR2_TXOK_BIT 6
#define CAN2_IMR2_RFRAME_MASK 0x80U
#define CAN2_IMR2_RFRAME 0x80U
#define CAN2_IMR2_RFRAME_BIT 7

#define CAN2_DRA3 (*(volatile unsigned long *)0xFFFBC1C0)
#define CAN2_DRA3_OFFSET 0x1C0
#define CAN2_DRA3_DATA0_MASK 0xFFU
#define CAN2_DRA3_DATA0_BIT 0
#define CAN2_DRA3_DATA1_MASK 0xFF00U
#define CAN2_DRA3_DATA1_BIT 8
#define CAN2_DRA3_DATA2_MASK 0xFF0000U
#define CAN2_DRA3_DATA2_BIT 16
#define CAN2_DRA3_DATA3_MASK 0xFF000000U
#define CAN2_DRA3_DATA3_BIT 24

#define CAN2_DRB3 (*(volatile unsigned long *)0xFFFBC1C4)
#define CAN2_DRB3_OFFSET 0x1C4
#define CAN2_DRB3_DATA4_MASK 0xFFU
#define CAN2_DRB3_DATA4_BIT 0
#define CAN2_DRB3_DATA5_MASK 0xFF00U
#define CAN2_DRB3_DATA5_BIT 8
#define CAN2_DRB3_DATA6_MASK 0xFF0000U
#define CAN2_DRB3_DATA6_BIT 16
#define CAN2_DRB3_DATA7_MASK 0xFF000000U
#define CAN2_DRB3_DATA7_BIT 24

#define CAN2_MSK3 (*(volatile unsigned long *)0xFFFBC1C8)
#define CAN2_MSK3_OFFSET 0x1C8
#define CAN2_MSK3_MASK_MASK 0x1FFFFFFFU
#define CAN2_MSK3_MASK_BIT 0
#define CAN2_MSK3_MRB_MASK 0x60000000U
#define CAN2_MSK3_MRB_BIT 29
#define CAN2_MSK3_MRTR_MASK 0x80000000U
#define CAN2_MSK3_MRTR 0x80000000U
#define CAN2_MSK3_MRTR_BIT 31

#define CAN2_IR3 (*(volatile unsigned long *)0xFFFBC1CC)
#define CAN2_IR3_OFFSET 0x1CC
#define CAN2_IR3_ID_MASK 0x1FFFFFFFU
#define CAN2_IR3_ID_BIT 0
#define CAN2_IR3_RB_MASK 0x60000000U
#define CAN2_IR3_RB_BIT 29
#define CAN2_IR3_RTR_MASK 0x80000000U
#define CAN2_IR3_RTR 0x80000000U
#define CAN2_IR3_RTR_BIT 31

#define CAN2_CR3 (*(volatile unsigned long *)0xFFFBC1D0)
#define CAN2_CR3_OFFSET 0x1D0
#define CAN2_CR3_DLC_MASK 0xFU
#define CAN2_CR3_DLC_BIT 0
#define CAN2_CR3_IDE_MASK 0x10U
#define CAN2_CR3_IDE 0x10U
#define CAN2_CR3_IDE_BIT 4
#define CAN2_CR3_RPLYV_MASK 0x20U
#define CAN2_CR3_RPLYV 0x20U
#define CAN2_CR3_RPLYV_BIT 5
#define CAN2_CR3_PCB_MASK 0x40U
#define CAN2_CR3_PCB 0x40U
#define CAN2_CR3_PCB_BIT 6
#define CAN2_CR3_CHANEN_MASK 0x80U
#define CAN2_CR3_CHANEN 0x80U
#define CAN2_CR3_CHANEN_BIT 7
#define CAN2_CR3_OVERWRITE_MASK 0x100U
#define CAN2_CR3_OVERWRITE 0x100U
#define CAN2_CR3_OVERWRITE_BIT 8

#define CAN2_CR3 (*(volatile unsigned long *)0xFFFBC1D4)
#define CAN2_CR3_OFFSET 0x1D4
#define CAN2_CR3_STAMP_MASK 0x0U
#define CAN2_CR3_STAMP_BIT 0

#define CAN2_CSR3 (*(volatile unsigned long *)0xFFFBC1D8)
#define CAN2_CSR3_OFFSET 0x1D8
#define CAN2_CSR3_ACK_MASK 0x1U
#define CAN2_CSR3_ACK 0x1U
#define CAN2_CSR3_ACK_BIT 0
#define CAN2_CSR3_FRAME_MASK 0x2U
#define CAN2_CSR3_FRAME 0x2U
#define CAN2_CSR3_FRAME_BIT 1
#define CAN2_CSR3_CRC_MASK 0x4U
#define CAN2_CSR3_CRC 0x4U
#define CAN2_CSR3_CRC_BIT 2
#define CAN2_CSR3_STUFF_MASK 0x8U
#define CAN2_CSR3_STUFF 0x8U
#define CAN2_CSR3_STUFF_BIT 3
#define CAN2_CSR3_BUS_MASK 0x10U
#define CAN2_CSR3_BUS 0x10U
#define CAN2_CSR3_BUS_BIT 4
#define CAN2_CSR3_RXOK_MASK 0x20U
#define CAN2_CSR3_RXOK 0x20U
#define CAN2_CSR3_RXOK_BIT 5
#define CAN2_CSR3_TXOK_MASK 0x40U
#define CAN2_CSR3_TXOK 0x40U
#define CAN2_CSR3_TXOK_BIT 6
#define CAN2_CSR3_RFRAME_MASK 0x80U
#define CAN2_CSR3_RFRAME 0x80U
#define CAN2_CSR3_RFRAME_BIT 7
#define CAN2_CSR3_DLCW_MASK 0x200U
#define CAN2_CSR3_DLCW 0x200U
#define CAN2_CSR3_DLCW_BIT 9
#define CAN2_CSR3_FILLED_MASK 0x400U
#define CAN2_CSR3_FILLED 0x400U
#define CAN2_CSR3_FILLED_BIT 10
#define CAN2_CSR3_OVRUN_MASK 0x800U
#define CAN2_CSR3_OVRUN 0x800U
#define CAN2_CSR3_OVRUN_BIT 11

#define CAN2_SR3 (*(volatile unsigned long *)0xFFFBC1DC)
#define CAN2_SR3_OFFSET 0x1DC
#define CAN2_SR3_ACK_MASK 0x1U
#define CAN2_SR3_ACK 0x1U
#define CAN2_SR3_ACK_BIT 0
#define CAN2_SR3_FRAME_MASK 0x2U
#define CAN2_SR3_FRAME 0x2U
#define CAN2_SR3_FRAME_BIT 1
#define CAN2_SR3_CRC_MASK 0x4U
#define CAN2_SR3_CRC 0x4U
#define CAN2_SR3_CRC_BIT 2
#define CAN2_SR3_STUFF_MASK 0x8U
#define CAN2_SR3_STUFF 0x8U
#define CAN2_SR3_STUFF_BIT 3
#define CAN2_SR3_BUS_MASK 0x10U
#define CAN2_SR3_BUS 0x10U
#define CAN2_SR3_BUS_BIT 4
#define CAN2_SR3_RXOK_MASK 0x20U
#define CAN2_SR3_RXOK 0x20U
#define CAN2_SR3_RXOK_BIT 5
#define CAN2_SR3_TXOK_MASK 0x40U
#define CAN2_SR3_TXOK 0x40U
#define CAN2_SR3_TXOK_BIT 6
#define CAN2_SR3_RFRAME_MASK 0x80U
#define CAN2_SR3_RFRAME 0x80U
#define CAN2_SR3_RFRAME_BIT 7
#define CAN2_SR3_DLCW_MASK 0x200U
#define CAN2_SR3_DLCW 0x200U
#define CAN2_SR3_DLCW_BIT 9
#define CAN2_SR3_FILLED_MASK 0x400U
#define CAN2_SR3_FILLED 0x400U
#define CAN2_SR3_FILLED_BIT 10
#define CAN2_SR3_OVRUN_MASK 0x800U
#define CAN2_SR3_OVRUN 0x800U
#define CAN2_SR3_OVRUN_BIT 11

#define CAN2_IER3 (*(volatile unsigned long *)0xFFFBC1E0)
#define CAN2_IER3_OFFSET 0x1E0
#define CAN2_IER3_ACK_MASK 0x1U
#define CAN2_IER3_ACK 0x1U
#define CAN2_IER3_ACK_BIT 0
#define CAN2_IER3_FRAME_MASK 0x2U
#define CAN2_IER3_FRAME 0x2U
#define CAN2_IER3_FRAME_BIT 1
#define CAN2_IER3_CRC_MASK 0x4U
#define CAN2_IER3_CRC 0x4U
#define CAN2_IER3_CRC_BIT 2
#define CAN2_IER3_STUFF_MASK 0x8U
#define CAN2_IER3_STUFF 0x8U
#define CAN2_IER3_STUFF_BIT 3
#define CAN2_IER3_BUS_MASK 0x10U
#define CAN2_IER3_BUS 0x10U
#define CAN2_IER3_BUS_BIT 4
#define CAN2_IER3_RXOK_MASK 0x20U
#define CAN2_IER3_RXOK 0x20U
#define CAN2_IER3_RXOK_BIT 5
#define CAN2_IER3_TXOK_MASK 0x40U
#define CAN2_IER3_TXOK 0x40U
#define CAN2_IER3_TXOK_BIT 6
#define CAN2_IER3_RFRAME_MASK 0x80U
#define CAN2_IER3_RFRAME 0x80U
#define CAN2_IER3_RFRAME_BIT 7

#define CAN2_IDR3 (*(volatile unsigned long *)0xFFFBC1E4)
#define CAN2_IDR3_OFFSET 0x1E4
#define CAN2_IDR3_ACK_MASK 0x1U
#define CAN2_IDR3_ACK 0x1U
#define CAN2_IDR3_ACK_BIT 0
#define CAN2_IDR3_FRAME_MASK 0x2U
#define CAN2_IDR3_FRAME 0x2U
#define CAN2_IDR3_FRAME_BIT 1
#define CAN2_IDR3_CRC_MASK 0x4U
#define CAN2_IDR3_CRC 0x4U
#define CAN2_IDR3_CRC_BIT 2
#define CAN2_IDR3_STUFF_MASK 0x8U
#define CAN2_IDR3_STUFF 0x8U
#define CAN2_IDR3_STUFF_BIT 3
#define CAN2_IDR3_BUS_MASK 0x10U
#define CAN2_IDR3_BUS 0x10U
#define CAN2_IDR3_BUS_BIT 4
#define CAN2_IDR3_RXOK_MASK 0x20U
#define CAN2_IDR3_RXOK 0x20U
#define CAN2_IDR3_RXOK_BIT 5
#define CAN2_IDR3_TXOK_MASK 0x40U
#define CAN2_IDR3_TXOK 0x40U
#define CAN2_IDR3_TXOK_BIT 6
#define CAN2_IDR3_RFRAME_MASK 0x80U
#define CAN2_IDR3_RFRAME 0x80U
#define CAN2_IDR3_RFRAME_BIT 7

#define CAN2_IMR3 (*(volatile unsigned long *)0xFFFBC1E8)
#define CAN2_IMR3_OFFSET 0x1E8
#define CAN2_IMR3_ACK_MASK 0x1U
#define CAN2_IMR3_ACK 0x1U
#define CAN2_IMR3_ACK_BIT 0
#define CAN2_IMR3_FRAME_MASK 0x2U
#define CAN2_IMR3_FRAME 0x2U
#define CAN2_IMR3_FRAME_BIT 1
#define CAN2_IMR3_CRC_MASK 0x4U
#define CAN2_IMR3_CRC 0x4U
#define CAN2_IMR3_CRC_BIT 2
#define CAN2_IMR3_STUFF_MASK 0x8U
#define CAN2_IMR3_STUFF 0x8U
#define CAN2_IMR3_STUFF_BIT 3
#define CAN2_IMR3_BUS_MASK 0x10U
#define CAN2_IMR3_BUS 0x10U
#define CAN2_IMR3_BUS_BIT 4
#define CAN2_IMR3_RXOK_MASK 0x20U
#define CAN2_IMR3_RXOK 0x20U
#define CAN2_IMR3_RXOK_BIT 5
#define CAN2_IMR3_TXOK_MASK 0x40U
#define CAN2_IMR3_TXOK 0x40U
#define CAN2_IMR3_TXOK_BIT 6
#define CAN2_IMR3_RFRAME_MASK 0x80U
#define CAN2_IMR3_RFRAME 0x80U
#define CAN2_IMR3_RFRAME_BIT 7

#define CAN2_DRA4 (*(volatile unsigned long *)0xFFFBC200)
#define CAN2_DRA4_OFFSET 0x200
#define CAN2_DRA4_DATA0_MASK 0xFFU
#define CAN2_DRA4_DATA0_BIT 0
#define CAN2_DRA4_DATA1_MASK 0xFF00U
#define CAN2_DRA4_DATA1_BIT 8
#define CAN2_DRA4_DATA2_MASK 0xFF0000U
#define CAN2_DRA4_DATA2_BIT 16
#define CAN2_DRA4_DATA3_MASK 0xFF000000U
#define CAN2_DRA4_DATA3_BIT 24

#define CAN2_DRB4 (*(volatile unsigned long *)0xFFFBC204)
#define CAN2_DRB4_OFFSET 0x204
#define CAN2_DRB4_DATA4_MASK 0xFFU
#define CAN2_DRB4_DATA4_BIT 0
#define CAN2_DRB4_DATA5_MASK 0xFF00U
#define CAN2_DRB4_DATA5_BIT 8
#define CAN2_DRB4_DATA6_MASK 0xFF0000U
#define CAN2_DRB4_DATA6_BIT 16
#define CAN2_DRB4_DATA7_MASK 0xFF000000U
#define CAN2_DRB4_DATA7_BIT 24

#define CAN2_MSK4 (*(volatile unsigned long *)0xFFFBC208)
#define CAN2_MSK4_OFFSET 0x208
#define CAN2_MSK4_MASK_MASK 0x1FFFFFFFU
#define CAN2_MSK4_MASK_BIT 0
#define CAN2_MSK4_MRB_MASK 0x60000000U
#define CAN2_MSK4_MRB_BIT 29
#define CAN2_MSK4_MRTR_MASK 0x80000000U
#define CAN2_MSK4_MRTR 0x80000000U
#define CAN2_MSK4_MRTR_BIT 31

#define CAN2_IR4 (*(volatile unsigned long *)0xFFFBC20C)
#define CAN2_IR4_OFFSET 0x20C
#define CAN2_IR4_ID_MASK 0x1FFFFFFFU
#define CAN2_IR4_ID_BIT 0
#define CAN2_IR4_RB_MASK 0x60000000U
#define CAN2_IR4_RB_BIT 29
#define CAN2_IR4_RTR_MASK 0x80000000U
#define CAN2_IR4_RTR 0x80000000U
#define CAN2_IR4_RTR_BIT 31

#define CAN2_CR4 (*(volatile unsigned long *)0xFFFBC210)
#define CAN2_CR4_OFFSET 0x210
#define CAN2_CR4_DLC_MASK 0xFU
#define CAN2_CR4_DLC_BIT 0
#define CAN2_CR4_IDE_MASK 0x10U
#define CAN2_CR4_IDE 0x10U
#define CAN2_CR4_IDE_BIT 4
#define CAN2_CR4_RPLYV_MASK 0x20U
#define CAN2_CR4_RPLYV 0x20U
#define CAN2_CR4_RPLYV_BIT 5
#define CAN2_CR4_PCB_MASK 0x40U
#define CAN2_CR4_PCB 0x40U
#define CAN2_CR4_PCB_BIT 6
#define CAN2_CR4_CHANEN_MASK 0x80U
#define CAN2_CR4_CHANEN 0x80U
#define CAN2_CR4_CHANEN_BIT 7
#define CAN2_CR4_OVERWRITE_MASK 0x100U
#define CAN2_CR4_OVERWRITE 0x100U
#define CAN2_CR4_OVERWRITE_BIT 8

#define CAN2_CR4 (*(volatile unsigned long *)0xFFFBC214)
#define CAN2_CR4_OFFSET 0x214
#define CAN2_CR4_STAMP_MASK 0x0U
#define CAN2_CR4_STAMP_BIT 0

#define CAN2_CSR4 (*(volatile unsigned long *)0xFFFBC218)
#define CAN2_CSR4_OFFSET 0x218
#define CAN2_CSR4_ACK_MASK 0x1U
#define CAN2_CSR4_ACK 0x1U
#define CAN2_CSR4_ACK_BIT 0
#define CAN2_CSR4_FRAME_MASK 0x2U
#define CAN2_CSR4_FRAME 0x2U
#define CAN2_CSR4_FRAME_BIT 1
#define CAN2_CSR4_CRC_MASK 0x4U
#define CAN2_CSR4_CRC 0x4U
#define CAN2_CSR4_CRC_BIT 2
#define CAN2_CSR4_STUFF_MASK 0x8U
#define CAN2_CSR4_STUFF 0x8U
#define CAN2_CSR4_STUFF_BIT 3
#define CAN2_CSR4_BUS_MASK 0x10U
#define CAN2_CSR4_BUS 0x10U
#define CAN2_CSR4_BUS_BIT 4
#define CAN2_CSR4_RXOK_MASK 0x20U
#define CAN2_CSR4_RXOK 0x20U
#define CAN2_CSR4_RXOK_BIT 5
#define CAN2_CSR4_TXOK_MASK 0x40U
#define CAN2_CSR4_TXOK 0x40U
#define CAN2_CSR4_TXOK_BIT 6
#define CAN2_CSR4_RFRAME_MASK 0x80U
#define CAN2_CSR4_RFRAME 0x80U
#define CAN2_CSR4_RFRAME_BIT 7
#define CAN2_CSR4_DLCW_MASK 0x200U
#define CAN2_CSR4_DLCW 0x200U
#define CAN2_CSR4_DLCW_BIT 9
#define CAN2_CSR4_FILLED_MASK 0x400U
#define CAN2_CSR4_FILLED 0x400U
#define CAN2_CSR4_FILLED_BIT 10
#define CAN2_CSR4_OVRUN_MASK 0x800U
#define CAN2_CSR4_OVRUN 0x800U
#define CAN2_CSR4_OVRUN_BIT 11

#define CAN2_SR4 (*(volatile unsigned long *)0xFFFBC21C)
#define CAN2_SR4_OFFSET 0x21C
#define CAN2_SR4_ACK_MASK 0x1U
#define CAN2_SR4_ACK 0x1U
#define CAN2_SR4_ACK_BIT 0
#define CAN2_SR4_FRAME_MASK 0x2U
#define CAN2_SR4_FRAME 0x2U
#define CAN2_SR4_FRAME_BIT 1
#define CAN2_SR4_CRC_MASK 0x4U
#define CAN2_SR4_CRC 0x4U
#define CAN2_SR4_CRC_BIT 2
#define CAN2_SR4_STUFF_MASK 0x8U
#define CAN2_SR4_STUFF 0x8U
#define CAN2_SR4_STUFF_BIT 3
#define CAN2_SR4_BUS_MASK 0x10U
#define CAN2_SR4_BUS 0x10U
#define CAN2_SR4_BUS_BIT 4
#define CAN2_SR4_RXOK_MASK 0x20U
#define CAN2_SR4_RXOK 0x20U
#define CAN2_SR4_RXOK_BIT 5
#define CAN2_SR4_TXOK_MASK 0x40U
#define CAN2_SR4_TXOK 0x40U
#define CAN2_SR4_TXOK_BIT 6
#define CAN2_SR4_RFRAME_MASK 0x80U
#define CAN2_SR4_RFRAME 0x80U
#define CAN2_SR4_RFRAME_BIT 7
#define CAN2_SR4_DLCW_MASK 0x200U
#define CAN2_SR4_DLCW 0x200U
#define CAN2_SR4_DLCW_BIT 9
#define CAN2_SR4_FILLED_MASK 0x400U
#define CAN2_SR4_FILLED 0x400U
#define CAN2_SR4_FILLED_BIT 10
#define CAN2_SR4_OVRUN_MASK 0x800U
#define CAN2_SR4_OVRUN 0x800U
#define CAN2_SR4_OVRUN_BIT 11

#define CAN2_IER4 (*(volatile unsigned long *)0xFFFBC220)
#define CAN2_IER4_OFFSET 0x220
#define CAN2_IER4_ACK_MASK 0x1U
#define CAN2_IER4_ACK 0x1U
#define CAN2_IER4_ACK_BIT 0
#define CAN2_IER4_FRAME_MASK 0x2U
#define CAN2_IER4_FRAME 0x2U
#define CAN2_IER4_FRAME_BIT 1
#define CAN2_IER4_CRC_MASK 0x4U
#define CAN2_IER4_CRC 0x4U
#define CAN2_IER4_CRC_BIT 2
#define CAN2_IER4_STUFF_MASK 0x8U
#define CAN2_IER4_STUFF 0x8U
#define CAN2_IER4_STUFF_BIT 3
#define CAN2_IER4_BUS_MASK 0x10U
#define CAN2_IER4_BUS 0x10U
#define CAN2_IER4_BUS_BIT 4
#define CAN2_IER4_RXOK_MASK 0x20U
#define CAN2_IER4_RXOK 0x20U
#define CAN2_IER4_RXOK_BIT 5
#define CAN2_IER4_TXOK_MASK 0x40U
#define CAN2_IER4_TXOK 0x40U
#define CAN2_IER4_TXOK_BIT 6
#define CAN2_IER4_RFRAME_MASK 0x80U
#define CAN2_IER4_RFRAME 0x80U
#define CAN2_IER4_RFRAME_BIT 7

#define CAN2_IDR4 (*(volatile unsigned long *)0xFFFBC224)
#define CAN2_IDR4_OFFSET 0x224
#define CAN2_IDR4_ACK_MASK 0x1U
#define CAN2_IDR4_ACK 0x1U
#define CAN2_IDR4_ACK_BIT 0
#define CAN2_IDR4_FRAME_MASK 0x2U
#define CAN2_IDR4_FRAME 0x2U
#define CAN2_IDR4_FRAME_BIT 1
#define CAN2_IDR4_CRC_MASK 0x4U
#define CAN2_IDR4_CRC 0x4U
#define CAN2_IDR4_CRC_BIT 2
#define CAN2_IDR4_STUFF_MASK 0x8U
#define CAN2_IDR4_STUFF 0x8U
#define CAN2_IDR4_STUFF_BIT 3
#define CAN2_IDR4_BUS_MASK 0x10U
#define CAN2_IDR4_BUS 0x10U
#define CAN2_IDR4_BUS_BIT 4
#define CAN2_IDR4_RXOK_MASK 0x20U
#define CAN2_IDR4_RXOK 0x20U
#define CAN2_IDR4_RXOK_BIT 5
#define CAN2_IDR4_TXOK_MASK 0x40U
#define CAN2_IDR4_TXOK 0x40U
#define CAN2_IDR4_TXOK_BIT 6
#define CAN2_IDR4_RFRAME_MASK 0x80U
#define CAN2_IDR4_RFRAME 0x80U
#define CAN2_IDR4_RFRAME_BIT 7

#define CAN2_IMR4 (*(volatile unsigned long *)0xFFFBC228)
#define CAN2_IMR4_OFFSET 0x228
#define CAN2_IMR4_ACK_MASK 0x1U
#define CAN2_IMR4_ACK 0x1U
#define CAN2_IMR4_ACK_BIT 0
#define CAN2_IMR4_FRAME_MASK 0x2U
#define CAN2_IMR4_FRAME 0x2U
#define CAN2_IMR4_FRAME_BIT 1
#define CAN2_IMR4_CRC_MASK 0x4U
#define CAN2_IMR4_CRC 0x4U
#define CAN2_IMR4_CRC_BIT 2
#define CAN2_IMR4_STUFF_MASK 0x8U
#define CAN2_IMR4_STUFF 0x8U
#define CAN2_IMR4_STUFF_BIT 3
#define CAN2_IMR4_BUS_MASK 0x10U
#define CAN2_IMR4_BUS 0x10U
#define CAN2_IMR4_BUS_BIT 4
#define CAN2_IMR4_RXOK_MASK 0x20U
#define CAN2_IMR4_RXOK 0x20U
#define CAN2_IMR4_RXOK_BIT 5
#define CAN2_IMR4_TXOK_MASK 0x40U
#define CAN2_IMR4_TXOK 0x40U
#define CAN2_IMR4_TXOK_BIT 6
#define CAN2_IMR4_RFRAME_MASK 0x80U
#define CAN2_IMR4_RFRAME 0x80U
#define CAN2_IMR4_RFRAME_BIT 7

#define CAN2_DRA5 (*(volatile unsigned long *)0xFFFBC240)
#define CAN2_DRA5_OFFSET 0x240
#define CAN2_DRA5_DATA0_MASK 0xFFU
#define CAN2_DRA5_DATA0_BIT 0
#define CAN2_DRA5_DATA1_MASK 0xFF00U
#define CAN2_DRA5_DATA1_BIT 8
#define CAN2_DRA5_DATA2_MASK 0xFF0000U
#define CAN2_DRA5_DATA2_BIT 16
#define CAN2_DRA5_DATA3_MASK 0xFF000000U
#define CAN2_DRA5_DATA3_BIT 24

#define CAN2_DRB5 (*(volatile unsigned long *)0xFFFBC244)
#define CAN2_DRB5_OFFSET 0x244
#define CAN2_DRB5_DATA4_MASK 0xFFU
#define CAN2_DRB5_DATA4_BIT 0
#define CAN2_DRB5_DATA5_MASK 0xFF00U
#define CAN2_DRB5_DATA5_BIT 8
#define CAN2_DRB5_DATA6_MASK 0xFF0000U
#define CAN2_DRB5_DATA6_BIT 16
#define CAN2_DRB5_DATA7_MASK 0xFF000000U
#define CAN2_DRB5_DATA7_BIT 24

#define CAN2_MSK5 (*(volatile unsigned long *)0xFFFBC248)
#define CAN2_MSK5_OFFSET 0x248
#define CAN2_MSK5_MASK_MASK 0x1FFFFFFFU
#define CAN2_MSK5_MASK_BIT 0
#define CAN2_MSK5_MRB_MASK 0x60000000U
#define CAN2_MSK5_MRB_BIT 29
#define CAN2_MSK5_MRTR_MASK 0x80000000U
#define CAN2_MSK5_MRTR 0x80000000U
#define CAN2_MSK5_MRTR_BIT 31

#define CAN2_IR5 (*(volatile unsigned long *)0xFFFBC24C)
#define CAN2_IR5_OFFSET 0x24C
#define CAN2_IR5_ID_MASK 0x1FFFFFFFU
#define CAN2_IR5_ID_BIT 0
#define CAN2_IR5_RB_MASK 0x60000000U
#define CAN2_IR5_RB_BIT 29
#define CAN2_IR5_RTR_MASK 0x80000000U
#define CAN2_IR5_RTR 0x80000000U
#define CAN2_IR5_RTR_BIT 31

#define CAN2_CR5 (*(volatile unsigned long *)0xFFFBC250)
#define CAN2_CR5_OFFSET 0x250
#define CAN2_CR5_DLC_MASK 0xFU
#define CAN2_CR5_DLC_BIT 0
#define CAN2_CR5_IDE_MASK 0x10U
#define CAN2_CR5_IDE 0x10U
#define CAN2_CR5_IDE_BIT 4
#define CAN2_CR5_RPLYV_MASK 0x20U
#define CAN2_CR5_RPLYV 0x20U
#define CAN2_CR5_RPLYV_BIT 5
#define CAN2_CR5_PCB_MASK 0x40U
#define CAN2_CR5_PCB 0x40U
#define CAN2_CR5_PCB_BIT 6
#define CAN2_CR5_CHANEN_MASK 0x80U
#define CAN2_CR5_CHANEN 0x80U
#define CAN2_CR5_CHANEN_BIT 7
#define CAN2_CR5_OVERWRITE_MASK 0x100U
#define CAN2_CR5_OVERWRITE 0x100U
#define CAN2_CR5_OVERWRITE_BIT 8

#define CAN2_CR5 (*(volatile unsigned long *)0xFFFBC254)
#define CAN2_CR5_OFFSET 0x254
#define CAN2_CR5_STAMP_MASK 0x0U
#define CAN2_CR5_STAMP_BIT 0

#define CAN2_CSR5 (*(volatile unsigned long *)0xFFFBC258)
#define CAN2_CSR5_OFFSET 0x258
#define CAN2_CSR5_ACK_MASK 0x1U
#define CAN2_CSR5_ACK 0x1U
#define CAN2_CSR5_ACK_BIT 0
#define CAN2_CSR5_FRAME_MASK 0x2U
#define CAN2_CSR5_FRAME 0x2U
#define CAN2_CSR5_FRAME_BIT 1
#define CAN2_CSR5_CRC_MASK 0x4U
#define CAN2_CSR5_CRC 0x4U
#define CAN2_CSR5_CRC_BIT 2
#define CAN2_CSR5_STUFF_MASK 0x8U
#define CAN2_CSR5_STUFF 0x8U
#define CAN2_CSR5_STUFF_BIT 3
#define CAN2_CSR5_BUS_MASK 0x10U
#define CAN2_CSR5_BUS 0x10U
#define CAN2_CSR5_BUS_BIT 4
#define CAN2_CSR5_RXOK_MASK 0x20U
#define CAN2_CSR5_RXOK 0x20U
#define CAN2_CSR5_RXOK_BIT 5
#define CAN2_CSR5_TXOK_MASK 0x40U
#define CAN2_CSR5_TXOK 0x40U
#define CAN2_CSR5_TXOK_BIT 6
#define CAN2_CSR5_RFRAME_MASK 0x80U
#define CAN2_CSR5_RFRAME 0x80U
#define CAN2_CSR5_RFRAME_BIT 7
#define CAN2_CSR5_DLCW_MASK 0x200U
#define CAN2_CSR5_DLCW 0x200U
#define CAN2_CSR5_DLCW_BIT 9
#define CAN2_CSR5_FILLED_MASK 0x400U
#define CAN2_CSR5_FILLED 0x400U
#define CAN2_CSR5_FILLED_BIT 10
#define CAN2_CSR5_OVRUN_MASK 0x800U
#define CAN2_CSR5_OVRUN 0x800U
#define CAN2_CSR5_OVRUN_BIT 11

#define CAN2_SR5 (*(volatile unsigned long *)0xFFFBC25C)
#define CAN2_SR5_OFFSET 0x25C
#define CAN2_SR5_ACK_MASK 0x1U
#define CAN2_SR5_ACK 0x1U
#define CAN2_SR5_ACK_BIT 0
#define CAN2_SR5_FRAME_MASK 0x2U
#define CAN2_SR5_FRAME 0x2U
#define CAN2_SR5_FRAME_BIT 1
#define CAN2_SR5_CRC_MASK 0x4U
#define CAN2_SR5_CRC 0x4U
#define CAN2_SR5_CRC_BIT 2
#define CAN2_SR5_STUFF_MASK 0x8U
#define CAN2_SR5_STUFF 0x8U
#define CAN2_SR5_STUFF_BIT 3
#define CAN2_SR5_BUS_MASK 0x10U
#define CAN2_SR5_BUS 0x10U
#define CAN2_SR5_BUS_BIT 4
#define CAN2_SR5_RXOK_MASK 0x20U
#define CAN2_SR5_RXOK 0x20U
#define CAN2_SR5_RXOK_BIT 5
#define CAN2_SR5_TXOK_MASK 0x40U
#define CAN2_SR5_TXOK 0x40U
#define CAN2_SR5_TXOK_BIT 6
#define CAN2_SR5_RFRAME_MASK 0x80U
#define CAN2_SR5_RFRAME 0x80U
#define CAN2_SR5_RFRAME_BIT 7
#define CAN2_SR5_DLCW_MASK 0x200U
#define CAN2_SR5_DLCW 0x200U
#define CAN2_SR5_DLCW_BIT 9
#define CAN2_SR5_FILLED_MASK 0x400U
#define CAN2_SR5_FILLED 0x400U
#define CAN2_SR5_FILLED_BIT 10
#define CAN2_SR5_OVRUN_MASK 0x800U
#define CAN2_SR5_OVRUN 0x800U
#define CAN2_SR5_OVRUN_BIT 11

#define CAN2_IER5 (*(volatile unsigned long *)0xFFFBC260)
#define CAN2_IER5_OFFSET 0x260
#define CAN2_IER5_ACK_MASK 0x1U
#define CAN2_IER5_ACK 0x1U
#define CAN2_IER5_ACK_BIT 0
#define CAN2_IER5_FRAME_MASK 0x2U
#define CAN2_IER5_FRAME 0x2U
#define CAN2_IER5_FRAME_BIT 1
#define CAN2_IER5_CRC_MASK 0x4U
#define CAN2_IER5_CRC 0x4U
#define CAN2_IER5_CRC_BIT 2
#define CAN2_IER5_STUFF_MASK 0x8U
#define CAN2_IER5_STUFF 0x8U
#define CAN2_IER5_STUFF_BIT 3
#define CAN2_IER5_BUS_MASK 0x10U
#define CAN2_IER5_BUS 0x10U
#define CAN2_IER5_BUS_BIT 4
#define CAN2_IER5_RXOK_MASK 0x20U
#define CAN2_IER5_RXOK 0x20U
#define CAN2_IER5_RXOK_BIT 5
#define CAN2_IER5_TXOK_MASK 0x40U
#define CAN2_IER5_TXOK 0x40U
#define CAN2_IER5_TXOK_BIT 6
#define CAN2_IER5_RFRAME_MASK 0x80U
#define CAN2_IER5_RFRAME 0x80U
#define CAN2_IER5_RFRAME_BIT 7

#define CAN2_IDR5 (*(volatile unsigned long *)0xFFFBC264)
#define CAN2_IDR5_OFFSET 0x264
#define CAN2_IDR5_ACK_MASK 0x1U
#define CAN2_IDR5_ACK 0x1U
#define CAN2_IDR5_ACK_BIT 0
#define CAN2_IDR5_FRAME_MASK 0x2U
#define CAN2_IDR5_FRAME 0x2U
#define CAN2_IDR5_FRAME_BIT 1
#define CAN2_IDR5_CRC_MASK 0x4U
#define CAN2_IDR5_CRC 0x4U
#define CAN2_IDR5_CRC_BIT 2
#define CAN2_IDR5_STUFF_MASK 0x8U
#define CAN2_IDR5_STUFF 0x8U
#define CAN2_IDR5_STUFF_BIT 3
#define CAN2_IDR5_BUS_MASK 0x10U
#define CAN2_IDR5_BUS 0x10U
#define CAN2_IDR5_BUS_BIT 4
#define CAN2_IDR5_RXOK_MASK 0x20U
#define CAN2_IDR5_RXOK 0x20U
#define CAN2_IDR5_RXOK_BIT 5
#define CAN2_IDR5_TXOK_MASK 0x40U
#define CAN2_IDR5_TXOK 0x40U
#define CAN2_IDR5_TXOK_BIT 6
#define CAN2_IDR5_RFRAME_MASK 0x80U
#define CAN2_IDR5_RFRAME 0x80U
#define CAN2_IDR5_RFRAME_BIT 7

#define CAN2_IMR5 (*(volatile unsigned long *)0xFFFBC268)
#define CAN2_IMR5_OFFSET 0x268
#define CAN2_IMR5_ACK_MASK 0x1U
#define CAN2_IMR5_ACK 0x1U
#define CAN2_IMR5_ACK_BIT 0
#define CAN2_IMR5_FRAME_MASK 0x2U
#define CAN2_IMR5_FRAME 0x2U
#define CAN2_IMR5_FRAME_BIT 1
#define CAN2_IMR5_CRC_MASK 0x4U
#define CAN2_IMR5_CRC 0x4U
#define CAN2_IMR5_CRC_BIT 2
#define CAN2_IMR5_STUFF_MASK 0x8U
#define CAN2_IMR5_STUFF 0x8U
#define CAN2_IMR5_STUFF_BIT 3
#define CAN2_IMR5_BUS_MASK 0x10U
#define CAN2_IMR5_BUS 0x10U
#define CAN2_IMR5_BUS_BIT 4
#define CAN2_IMR5_RXOK_MASK 0x20U
#define CAN2_IMR5_RXOK 0x20U
#define CAN2_IMR5_RXOK_BIT 5
#define CAN2_IMR5_TXOK_MASK 0x40U
#define CAN2_IMR5_TXOK 0x40U
#define CAN2_IMR5_TXOK_BIT 6
#define CAN2_IMR5_RFRAME_MASK 0x80U
#define CAN2_IMR5_RFRAME 0x80U
#define CAN2_IMR5_RFRAME_BIT 7

#define CAN2_DRA6 (*(volatile unsigned long *)0xFFFBC280)
#define CAN2_DRA6_OFFSET 0x280
#define CAN2_DRA6_DATA0_MASK 0xFFU
#define CAN2_DRA6_DATA0_BIT 0
#define CAN2_DRA6_DATA1_MASK 0xFF00U
#define CAN2_DRA6_DATA1_BIT 8
#define CAN2_DRA6_DATA2_MASK 0xFF0000U
#define CAN2_DRA6_DATA2_BIT 16
#define CAN2_DRA6_DATA3_MASK 0xFF000000U
#define CAN2_DRA6_DATA3_BIT 24

#define CAN2_DRB6 (*(volatile unsigned long *)0xFFFBC284)
#define CAN2_DRB6_OFFSET 0x284
#define CAN2_DRB6_DATA4_MASK 0xFFU
#define CAN2_DRB6_DATA4_BIT 0
#define CAN2_DRB6_DATA5_MASK 0xFF00U
#define CAN2_DRB6_DATA5_BIT 8
#define CAN2_DRB6_DATA6_MASK 0xFF0000U
#define CAN2_DRB6_DATA6_BIT 16
#define CAN2_DRB6_DATA7_MASK 0xFF000000U
#define CAN2_DRB6_DATA7_BIT 24

#define CAN2_MSK6 (*(volatile unsigned long *)0xFFFBC288)
#define CAN2_MSK6_OFFSET 0x288
#define CAN2_MSK6_MASK_MASK 0x1FFFFFFFU
#define CAN2_MSK6_MASK_BIT 0
#define CAN2_MSK6_MRB_MASK 0x60000000U
#define CAN2_MSK6_MRB_BIT 29
#define CAN2_MSK6_MRTR_MASK 0x80000000U
#define CAN2_MSK6_MRTR 0x80000000U
#define CAN2_MSK6_MRTR_BIT 31

#define CAN2_IR6 (*(volatile unsigned long *)0xFFFBC28C)
#define CAN2_IR6_OFFSET 0x28C
#define CAN2_IR6_ID_MASK 0x1FFFFFFFU
#define CAN2_IR6_ID_BIT 0
#define CAN2_IR6_RB_MASK 0x60000000U
#define CAN2_IR6_RB_BIT 29
#define CAN2_IR6_RTR_MASK 0x80000000U
#define CAN2_IR6_RTR 0x80000000U
#define CAN2_IR6_RTR_BIT 31

#define CAN2_CR6 (*(volatile unsigned long *)0xFFFBC290)
#define CAN2_CR6_OFFSET 0x290
#define CAN2_CR6_DLC_MASK 0xFU
#define CAN2_CR6_DLC_BIT 0
#define CAN2_CR6_IDE_MASK 0x10U
#define CAN2_CR6_IDE 0x10U
#define CAN2_CR6_IDE_BIT 4
#define CAN2_CR6_RPLYV_MASK 0x20U
#define CAN2_CR6_RPLYV 0x20U
#define CAN2_CR6_RPLYV_BIT 5
#define CAN2_CR6_PCB_MASK 0x40U
#define CAN2_CR6_PCB 0x40U
#define CAN2_CR6_PCB_BIT 6
#define CAN2_CR6_CHANEN_MASK 0x80U
#define CAN2_CR6_CHANEN 0x80U
#define CAN2_CR6_CHANEN_BIT 7
#define CAN2_CR6_OVERWRITE_MASK 0x100U
#define CAN2_CR6_OVERWRITE 0x100U
#define CAN2_CR6_OVERWRITE_BIT 8

#define CAN2_CR6 (*(volatile unsigned long *)0xFFFBC294)
#define CAN2_CR6_OFFSET 0x294
#define CAN2_CR6_STAMP_MASK 0x0U
#define CAN2_CR6_STAMP_BIT 0

#define CAN2_CSR6 (*(volatile unsigned long *)0xFFFBC298)
#define CAN2_CSR6_OFFSET 0x298
#define CAN2_CSR6_ACK_MASK 0x1U
#define CAN2_CSR6_ACK 0x1U
#define CAN2_CSR6_ACK_BIT 0
#define CAN2_CSR6_FRAME_MASK 0x2U
#define CAN2_CSR6_FRAME 0x2U
#define CAN2_CSR6_FRAME_BIT 1
#define CAN2_CSR6_CRC_MASK 0x4U
#define CAN2_CSR6_CRC 0x4U
#define CAN2_CSR6_CRC_BIT 2
#define CAN2_CSR6_STUFF_MASK 0x8U
#define CAN2_CSR6_STUFF 0x8U
#define CAN2_CSR6_STUFF_BIT 3
#define CAN2_CSR6_BUS_MASK 0x10U
#define CAN2_CSR6_BUS 0x10U
#define CAN2_CSR6_BUS_BIT 4
#define CAN2_CSR6_RXOK_MASK 0x20U
#define CAN2_CSR6_RXOK 0x20U
#define CAN2_CSR6_RXOK_BIT 5
#define CAN2_CSR6_TXOK_MASK 0x40U
#define CAN2_CSR6_TXOK 0x40U
#define CAN2_CSR6_TXOK_BIT 6
#define CAN2_CSR6_RFRAME_MASK 0x80U
#define CAN2_CSR6_RFRAME 0x80U
#define CAN2_CSR6_RFRAME_BIT 7
#define CAN2_CSR6_DLCW_MASK 0x200U
#define CAN2_CSR6_DLCW 0x200U
#define CAN2_CSR6_DLCW_BIT 9
#define CAN2_CSR6_FILLED_MASK 0x400U
#define CAN2_CSR6_FILLED 0x400U
#define CAN2_CSR6_FILLED_BIT 10
#define CAN2_CSR6_OVRUN_MASK 0x800U
#define CAN2_CSR6_OVRUN 0x800U
#define CAN2_CSR6_OVRUN_BIT 11

#define CAN2_SR6 (*(volatile unsigned long *)0xFFFBC29C)
#define CAN2_SR6_OFFSET 0x29C
#define CAN2_SR6_ACK_MASK 0x1U
#define CAN2_SR6_ACK 0x1U
#define CAN2_SR6_ACK_BIT 0
#define CAN2_SR6_FRAME_MASK 0x2U
#define CAN2_SR6_FRAME 0x2U
#define CAN2_SR6_FRAME_BIT 1
#define CAN2_SR6_CRC_MASK 0x4U
#define CAN2_SR6_CRC 0x4U
#define CAN2_SR6_CRC_BIT 2
#define CAN2_SR6_STUFF_MASK 0x8U
#define CAN2_SR6_STUFF 0x8U
#define CAN2_SR6_STUFF_BIT 3
#define CAN2_SR6_BUS_MASK 0x10U
#define CAN2_SR6_BUS 0x10U
#define CAN2_SR6_BUS_BIT 4
#define CAN2_SR6_RXOK_MASK 0x20U
#define CAN2_SR6_RXOK 0x20U
#define CAN2_SR6_RXOK_BIT 5
#define CAN2_SR6_TXOK_MASK 0x40U
#define CAN2_SR6_TXOK 0x40U
#define CAN2_SR6_TXOK_BIT 6
#define CAN2_SR6_RFRAME_MASK 0x80U
#define CAN2_SR6_RFRAME 0x80U
#define CAN2_SR6_RFRAME_BIT 7
#define CAN2_SR6_DLCW_MASK 0x200U
#define CAN2_SR6_DLCW 0x200U
#define CAN2_SR6_DLCW_BIT 9
#define CAN2_SR6_FILLED_MASK 0x400U
#define CAN2_SR6_FILLED 0x400U
#define CAN2_SR6_FILLED_BIT 10
#define CAN2_SR6_OVRUN_MASK 0x800U
#define CAN2_SR6_OVRUN 0x800U
#define CAN2_SR6_OVRUN_BIT 11

#define CAN2_IER6 (*(volatile unsigned long *)0xFFFBC2A0)
#define CAN2_IER6_OFFSET 0x2A0
#define CAN2_IER6_ACK_MASK 0x1U
#define CAN2_IER6_ACK 0x1U
#define CAN2_IER6_ACK_BIT 0
#define CAN2_IER6_FRAME_MASK 0x2U
#define CAN2_IER6_FRAME 0x2U
#define CAN2_IER6_FRAME_BIT 1
#define CAN2_IER6_CRC_MASK 0x4U
#define CAN2_IER6_CRC 0x4U
#define CAN2_IER6_CRC_BIT 2
#define CAN2_IER6_STUFF_MASK 0x8U
#define CAN2_IER6_STUFF 0x8U
#define CAN2_IER6_STUFF_BIT 3
#define CAN2_IER6_BUS_MASK 0x10U
#define CAN2_IER6_BUS 0x10U
#define CAN2_IER6_BUS_BIT 4
#define CAN2_IER6_RXOK_MASK 0x20U
#define CAN2_IER6_RXOK 0x20U
#define CAN2_IER6_RXOK_BIT 5
#define CAN2_IER6_TXOK_MASK 0x40U
#define CAN2_IER6_TXOK 0x40U
#define CAN2_IER6_TXOK_BIT 6
#define CAN2_IER6_RFRAME_MASK 0x80U
#define CAN2_IER6_RFRAME 0x80U
#define CAN2_IER6_RFRAME_BIT 7

#define CAN2_IDR6 (*(volatile unsigned long *)0xFFFBC2A4)
#define CAN2_IDR6_OFFSET 0x2A4
#define CAN2_IDR6_ACK_MASK 0x1U
#define CAN2_IDR6_ACK 0x1U
#define CAN2_IDR6_ACK_BIT 0
#define CAN2_IDR6_FRAME_MASK 0x2U
#define CAN2_IDR6_FRAME 0x2U
#define CAN2_IDR6_FRAME_BIT 1
#define CAN2_IDR6_CRC_MASK 0x4U
#define CAN2_IDR6_CRC 0x4U
#define CAN2_IDR6_CRC_BIT 2
#define CAN2_IDR6_STUFF_MASK 0x8U
#define CAN2_IDR6_STUFF 0x8U
#define CAN2_IDR6_STUFF_BIT 3
#define CAN2_IDR6_BUS_MASK 0x10U
#define CAN2_IDR6_BUS 0x10U
#define CAN2_IDR6_BUS_BIT 4
#define CAN2_IDR6_RXOK_MASK 0x20U
#define CAN2_IDR6_RXOK 0x20U
#define CAN2_IDR6_RXOK_BIT 5
#define CAN2_IDR6_TXOK_MASK 0x40U
#define CAN2_IDR6_TXOK 0x40U
#define CAN2_IDR6_TXOK_BIT 6
#define CAN2_IDR6_RFRAME_MASK 0x80U
#define CAN2_IDR6_RFRAME 0x80U
#define CAN2_IDR6_RFRAME_BIT 7

#define CAN2_IMR6 (*(volatile unsigned long *)0xFFFBC2A8)
#define CAN2_IMR6_OFFSET 0x2A8
#define CAN2_IMR6_ACK_MASK 0x1U
#define CAN2_IMR6_ACK 0x1U
#define CAN2_IMR6_ACK_BIT 0
#define CAN2_IMR6_FRAME_MASK 0x2U
#define CAN2_IMR6_FRAME 0x2U
#define CAN2_IMR6_FRAME_BIT 1
#define CAN2_IMR6_CRC_MASK 0x4U
#define CAN2_IMR6_CRC 0x4U
#define CAN2_IMR6_CRC_BIT 2
#define CAN2_IMR6_STUFF_MASK 0x8U
#define CAN2_IMR6_STUFF 0x8U
#define CAN2_IMR6_STUFF_BIT 3
#define CAN2_IMR6_BUS_MASK 0x10U
#define CAN2_IMR6_BUS 0x10U
#define CAN2_IMR6_BUS_BIT 4
#define CAN2_IMR6_RXOK_MASK 0x20U
#define CAN2_IMR6_RXOK 0x20U
#define CAN2_IMR6_RXOK_BIT 5
#define CAN2_IMR6_TXOK_MASK 0x40U
#define CAN2_IMR6_TXOK 0x40U
#define CAN2_IMR6_TXOK_BIT 6
#define CAN2_IMR6_RFRAME_MASK 0x80U
#define CAN2_IMR6_RFRAME 0x80U
#define CAN2_IMR6_RFRAME_BIT 7

#define CAN2_DRA7 (*(volatile unsigned long *)0xFFFBC2C0)
#define CAN2_DRA7_OFFSET 0x2C0
#define CAN2_DRA7_DATA0_MASK 0xFFU
#define CAN2_DRA7_DATA0_BIT 0
#define CAN2_DRA7_DATA1_MASK 0xFF00U
#define CAN2_DRA7_DATA1_BIT 8
#define CAN2_DRA7_DATA2_MASK 0xFF0000U
#define CAN2_DRA7_DATA2_BIT 16
#define CAN2_DRA7_DATA3_MASK 0xFF000000U
#define CAN2_DRA7_DATA3_BIT 24

#define CAN2_DRB7 (*(volatile unsigned long *)0xFFFBC2C4)
#define CAN2_DRB7_OFFSET 0x2C4
#define CAN2_DRB7_DATA4_MASK 0xFFU
#define CAN2_DRB7_DATA4_BIT 0
#define CAN2_DRB7_DATA5_MASK 0xFF00U
#define CAN2_DRB7_DATA5_BIT 8
#define CAN2_DRB7_DATA6_MASK 0xFF0000U
#define CAN2_DRB7_DATA6_BIT 16
#define CAN2_DRB7_DATA7_MASK 0xFF000000U
#define CAN2_DRB7_DATA7_BIT 24

#define CAN2_MSK7 (*(volatile unsigned long *)0xFFFBC2C8)
#define CAN2_MSK7_OFFSET 0x2C8
#define CAN2_MSK7_MASK_MASK 0x1FFFFFFFU
#define CAN2_MSK7_MASK_BIT 0
#define CAN2_MSK7_MRB_MASK 0x60000000U
#define CAN2_MSK7_MRB_BIT 29
#define CAN2_MSK7_MRTR_MASK 0x80000000U
#define CAN2_MSK7_MRTR 0x80000000U
#define CAN2_MSK7_MRTR_BIT 31

#define CAN2_IR7 (*(volatile unsigned long *)0xFFFBC2CC)
#define CAN2_IR7_OFFSET 0x2CC
#define CAN2_IR7_ID_MASK 0x1FFFFFFFU
#define CAN2_IR7_ID_BIT 0
#define CAN2_IR7_RB_MASK 0x60000000U
#define CAN2_IR7_RB_BIT 29
#define CAN2_IR7_RTR_MASK 0x80000000U
#define CAN2_IR7_RTR 0x80000000U
#define CAN2_IR7_RTR_BIT 31

#define CAN2_CR7 (*(volatile unsigned long *)0xFFFBC2D0)
#define CAN2_CR7_OFFSET 0x2D0
#define CAN2_CR7_DLC_MASK 0xFU
#define CAN2_CR7_DLC_BIT 0
#define CAN2_CR7_IDE_MASK 0x10U
#define CAN2_CR7_IDE 0x10U
#define CAN2_CR7_IDE_BIT 4
#define CAN2_CR7_RPLYV_MASK 0x20U
#define CAN2_CR7_RPLYV 0x20U
#define CAN2_CR7_RPLYV_BIT 5
#define CAN2_CR7_PCB_MASK 0x40U
#define CAN2_CR7_PCB 0x40U
#define CAN2_CR7_PCB_BIT 6
#define CAN2_CR7_CHANEN_MASK 0x80U
#define CAN2_CR7_CHANEN 0x80U
#define CAN2_CR7_CHANEN_BIT 7
#define CAN2_CR7_OVERWRITE_MASK 0x100U
#define CAN2_CR7_OVERWRITE 0x100U
#define CAN2_CR7_OVERWRITE_BIT 8

#define CAN2_CR7 (*(volatile unsigned long *)0xFFFBC2D4)
#define CAN2_CR7_OFFSET 0x2D4
#define CAN2_CR7_STAMP_MASK 0x0U
#define CAN2_CR7_STAMP_BIT 0

#define CAN2_CSR7 (*(volatile unsigned long *)0xFFFBC2D8)
#define CAN2_CSR7_OFFSET 0x2D8
#define CAN2_CSR7_ACK_MASK 0x1U
#define CAN2_CSR7_ACK 0x1U
#define CAN2_CSR7_ACK_BIT 0
#define CAN2_CSR7_FRAME_MASK 0x2U
#define CAN2_CSR7_FRAME 0x2U
#define CAN2_CSR7_FRAME_BIT 1
#define CAN2_CSR7_CRC_MASK 0x4U
#define CAN2_CSR7_CRC 0x4U
#define CAN2_CSR7_CRC_BIT 2
#define CAN2_CSR7_STUFF_MASK 0x8U
#define CAN2_CSR7_STUFF 0x8U
#define CAN2_CSR7_STUFF_BIT 3
#define CAN2_CSR7_BUS_MASK 0x10U
#define CAN2_CSR7_BUS 0x10U
#define CAN2_CSR7_BUS_BIT 4
#define CAN2_CSR7_RXOK_MASK 0x20U
#define CAN2_CSR7_RXOK 0x20U
#define CAN2_CSR7_RXOK_BIT 5
#define CAN2_CSR7_TXOK_MASK 0x40U
#define CAN2_CSR7_TXOK 0x40U
#define CAN2_CSR7_TXOK_BIT 6
#define CAN2_CSR7_RFRAME_MASK 0x80U
#define CAN2_CSR7_RFRAME 0x80U
#define CAN2_CSR7_RFRAME_BIT 7
#define CAN2_CSR7_DLCW_MASK 0x200U
#define CAN2_CSR7_DLCW 0x200U
#define CAN2_CSR7_DLCW_BIT 9
#define CAN2_CSR7_FILLED_MASK 0x400U
#define CAN2_CSR7_FILLED 0x400U
#define CAN2_CSR7_FILLED_BIT 10
#define CAN2_CSR7_OVRUN_MASK 0x800U
#define CAN2_CSR7_OVRUN 0x800U
#define CAN2_CSR7_OVRUN_BIT 11

#define CAN2_SR7 (*(volatile unsigned long *)0xFFFBC2DC)
#define CAN2_SR7_OFFSET 0x2DC
#define CAN2_SR7_ACK_MASK 0x1U
#define CAN2_SR7_ACK 0x1U
#define CAN2_SR7_ACK_BIT 0
#define CAN2_SR7_FRAME_MASK 0x2U
#define CAN2_SR7_FRAME 0x2U
#define CAN2_SR7_FRAME_BIT 1
#define CAN2_SR7_CRC_MASK 0x4U
#define CAN2_SR7_CRC 0x4U
#define CAN2_SR7_CRC_BIT 2
#define CAN2_SR7_STUFF_MASK 0x8U
#define CAN2_SR7_STUFF 0x8U
#define CAN2_SR7_STUFF_BIT 3
#define CAN2_SR7_BUS_MASK 0x10U
#define CAN2_SR7_BUS 0x10U
#define CAN2_SR7_BUS_BIT 4
#define CAN2_SR7_RXOK_MASK 0x20U
#define CAN2_SR7_RXOK 0x20U
#define CAN2_SR7_RXOK_BIT 5
#define CAN2_SR7_TXOK_MASK 0x40U
#define CAN2_SR7_TXOK 0x40U
#define CAN2_SR7_TXOK_BIT 6
#define CAN2_SR7_RFRAME_MASK 0x80U
#define CAN2_SR7_RFRAME 0x80U
#define CAN2_SR7_RFRAME_BIT 7
#define CAN2_SR7_DLCW_MASK 0x200U
#define CAN2_SR7_DLCW 0x200U
#define CAN2_SR7_DLCW_BIT 9
#define CAN2_SR7_FILLED_MASK 0x400U
#define CAN2_SR7_FILLED 0x400U
#define CAN2_SR7_FILLED_BIT 10
#define CAN2_SR7_OVRUN_MASK 0x800U
#define CAN2_SR7_OVRUN 0x800U
#define CAN2_SR7_OVRUN_BIT 11

#define CAN2_IER7 (*(volatile unsigned long *)0xFFFBC2E0)
#define CAN2_IER7_OFFSET 0x2E0
#define CAN2_IER7_ACK_MASK 0x1U
#define CAN2_IER7_ACK 0x1U
#define CAN2_IER7_ACK_BIT 0
#define CAN2_IER7_FRAME_MASK 0x2U
#define CAN2_IER7_FRAME 0x2U
#define CAN2_IER7_FRAME_BIT 1
#define CAN2_IER7_CRC_MASK 0x4U
#define CAN2_IER7_CRC 0x4U
#define CAN2_IER7_CRC_BIT 2
#define CAN2_IER7_STUFF_MASK 0x8U
#define CAN2_IER7_STUFF 0x8U
#define CAN2_IER7_STUFF_BIT 3
#define CAN2_IER7_BUS_MASK 0x10U
#define CAN2_IER7_BUS 0x10U
#define CAN2_IER7_BUS_BIT 4
#define CAN2_IER7_RXOK_MASK 0x20U
#define CAN2_IER7_RXOK 0x20U
#define CAN2_IER7_RXOK_BIT 5
#define CAN2_IER7_TXOK_MASK 0x40U
#define CAN2_IER7_TXOK 0x40U
#define CAN2_IER7_TXOK_BIT 6
#define CAN2_IER7_RFRAME_MASK 0x80U
#define CAN2_IER7_RFRAME 0x80U
#define CAN2_IER7_RFRAME_BIT 7

#define CAN2_IDR7 (*(volatile unsigned long *)0xFFFBC2E4)
#define CAN2_IDR7_OFFSET 0x2E4
#define CAN2_IDR7_ACK_MASK 0x1U
#define CAN2_IDR7_ACK 0x1U
#define CAN2_IDR7_ACK_BIT 0
#define CAN2_IDR7_FRAME_MASK 0x2U
#define CAN2_IDR7_FRAME 0x2U
#define CAN2_IDR7_FRAME_BIT 1
#define CAN2_IDR7_CRC_MASK 0x4U
#define CAN2_IDR7_CRC 0x4U
#define CAN2_IDR7_CRC_BIT 2
#define CAN2_IDR7_STUFF_MASK 0x8U
#define CAN2_IDR7_STUFF 0x8U
#define CAN2_IDR7_STUFF_BIT 3
#define CAN2_IDR7_BUS_MASK 0x10U
#define CAN2_IDR7_BUS 0x10U
#define CAN2_IDR7_BUS_BIT 4
#define CAN2_IDR7_RXOK_MASK 0x20U
#define CAN2_IDR7_RXOK 0x20U
#define CAN2_IDR7_RXOK_BIT 5
#define CAN2_IDR7_TXOK_MASK 0x40U
#define CAN2_IDR7_TXOK 0x40U
#define CAN2_IDR7_TXOK_BIT 6
#define CAN2_IDR7_RFRAME_MASK 0x80U
#define CAN2_IDR7_RFRAME 0x80U
#define CAN2_IDR7_RFRAME_BIT 7

#define CAN2_IMR7 (*(volatile unsigned long *)0xFFFBC2E8)
#define CAN2_IMR7_OFFSET 0x2E8
#define CAN2_IMR7_ACK_MASK 0x1U
#define CAN2_IMR7_ACK 0x1U
#define CAN2_IMR7_ACK_BIT 0
#define CAN2_IMR7_FRAME_MASK 0x2U
#define CAN2_IMR7_FRAME 0x2U
#define CAN2_IMR7_FRAME_BIT 1
#define CAN2_IMR7_CRC_MASK 0x4U
#define CAN2_IMR7_CRC 0x4U
#define CAN2_IMR7_CRC_BIT 2
#define CAN2_IMR7_STUFF_MASK 0x8U
#define CAN2_IMR7_STUFF 0x8U
#define CAN2_IMR7_STUFF_BIT 3
#define CAN2_IMR7_BUS_MASK 0x10U
#define CAN2_IMR7_BUS 0x10U
#define CAN2_IMR7_BUS_BIT 4
#define CAN2_IMR7_RXOK_MASK 0x20U
#define CAN2_IMR7_RXOK 0x20U
#define CAN2_IMR7_RXOK_BIT 5
#define CAN2_IMR7_TXOK_MASK 0x40U
#define CAN2_IMR7_TXOK 0x40U
#define CAN2_IMR7_TXOK_BIT 6
#define CAN2_IMR7_RFRAME_MASK 0x80U
#define CAN2_IMR7_RFRAME 0x80U
#define CAN2_IMR7_RFRAME_BIT 7

#define CAN2_DRA8 (*(volatile unsigned long *)0xFFFBC300)
#define CAN2_DRA8_OFFSET 0x300
#define CAN2_DRA8_DATA0_MASK 0xFFU
#define CAN2_DRA8_DATA0_BIT 0
#define CAN2_DRA8_DATA1_MASK 0xFF00U
#define CAN2_DRA8_DATA1_BIT 8
#define CAN2_DRA8_DATA2_MASK 0xFF0000U
#define CAN2_DRA8_DATA2_BIT 16
#define CAN2_DRA8_DATA3_MASK 0xFF000000U
#define CAN2_DRA8_DATA3_BIT 24

#define CAN2_DRB8 (*(volatile unsigned long *)0xFFFBC304)
#define CAN2_DRB8_OFFSET 0x304
#define CAN2_DRB8_DATA4_MASK 0xFFU
#define CAN2_DRB8_DATA4_BIT 0
#define CAN2_DRB8_DATA5_MASK 0xFF00U
#define CAN2_DRB8_DATA5_BIT 8
#define CAN2_DRB8_DATA6_MASK 0xFF0000U
#define CAN2_DRB8_DATA6_BIT 16
#define CAN2_DRB8_DATA7_MASK 0xFF000000U
#define CAN2_DRB8_DATA7_BIT 24

#define CAN2_MSK8 (*(volatile unsigned long *)0xFFFBC308)
#define CAN2_MSK8_OFFSET 0x308
#define CAN2_MSK8_MASK_MASK 0x1FFFFFFFU
#define CAN2_MSK8_MASK_BIT 0
#define CAN2_MSK8_MRB_MASK 0x60000000U
#define CAN2_MSK8_MRB_BIT 29
#define CAN2_MSK8_MRTR_MASK 0x80000000U
#define CAN2_MSK8_MRTR 0x80000000U
#define CAN2_MSK8_MRTR_BIT 31

#define CAN2_IR8 (*(volatile unsigned long *)0xFFFBC30C)
#define CAN2_IR8_OFFSET 0x30C
#define CAN2_IR8_ID_MASK 0x1FFFFFFFU
#define CAN2_IR8_ID_BIT 0
#define CAN2_IR8_RB_MASK 0x60000000U
#define CAN2_IR8_RB_BIT 29
#define CAN2_IR8_RTR_MASK 0x80000000U
#define CAN2_IR8_RTR 0x80000000U
#define CAN2_IR8_RTR_BIT 31

#define CAN2_CR8 (*(volatile unsigned long *)0xFFFBC310)
#define CAN2_CR8_OFFSET 0x310
#define CAN2_CR8_DLC_MASK 0xFU
#define CAN2_CR8_DLC_BIT 0
#define CAN2_CR8_IDE_MASK 0x10U
#define CAN2_CR8_IDE 0x10U
#define CAN2_CR8_IDE_BIT 4
#define CAN2_CR8_RPLYV_MASK 0x20U
#define CAN2_CR8_RPLYV 0x20U
#define CAN2_CR8_RPLYV_BIT 5
#define CAN2_CR8_PCB_MASK 0x40U
#define CAN2_CR8_PCB 0x40U
#define CAN2_CR8_PCB_BIT 6
#define CAN2_CR8_CHANEN_MASK 0x80U
#define CAN2_CR8_CHANEN 0x80U
#define CAN2_CR8_CHANEN_BIT 7
#define CAN2_CR8_OVERWRITE_MASK 0x100U
#define CAN2_CR8_OVERWRITE 0x100U
#define CAN2_CR8_OVERWRITE_BIT 8

#define CAN2_CR8 (*(volatile unsigned long *)0xFFFBC314)
#define CAN2_CR8_OFFSET 0x314
#define CAN2_CR8_STAMP_MASK 0x0U
#define CAN2_CR8_STAMP_BIT 0

#define CAN2_CSR8 (*(volatile unsigned long *)0xFFFBC318)
#define CAN2_CSR8_OFFSET 0x318
#define CAN2_CSR8_ACK_MASK 0x1U
#define CAN2_CSR8_ACK 0x1U
#define CAN2_CSR8_ACK_BIT 0
#define CAN2_CSR8_FRAME_MASK 0x2U
#define CAN2_CSR8_FRAME 0x2U
#define CAN2_CSR8_FRAME_BIT 1
#define CAN2_CSR8_CRC_MASK 0x4U
#define CAN2_CSR8_CRC 0x4U
#define CAN2_CSR8_CRC_BIT 2
#define CAN2_CSR8_STUFF_MASK 0x8U
#define CAN2_CSR8_STUFF 0x8U
#define CAN2_CSR8_STUFF_BIT 3
#define CAN2_CSR8_BUS_MASK 0x10U
#define CAN2_CSR8_BUS 0x10U
#define CAN2_CSR8_BUS_BIT 4
#define CAN2_CSR8_RXOK_MASK 0x20U
#define CAN2_CSR8_RXOK 0x20U
#define CAN2_CSR8_RXOK_BIT 5
#define CAN2_CSR8_TXOK_MASK 0x40U
#define CAN2_CSR8_TXOK 0x40U
#define CAN2_CSR8_TXOK_BIT 6
#define CAN2_CSR8_RFRAME_MASK 0x80U
#define CAN2_CSR8_RFRAME 0x80U
#define CAN2_CSR8_RFRAME_BIT 7
#define CAN2_CSR8_DLCW_MASK 0x200U
#define CAN2_CSR8_DLCW 0x200U
#define CAN2_CSR8_DLCW_BIT 9
#define CAN2_CSR8_FILLED_MASK 0x400U
#define CAN2_CSR8_FILLED 0x400U
#define CAN2_CSR8_FILLED_BIT 10
#define CAN2_CSR8_OVRUN_MASK 0x800U
#define CAN2_CSR8_OVRUN 0x800U
#define CAN2_CSR8_OVRUN_BIT 11

#define CAN2_SR8 (*(volatile unsigned long *)0xFFFBC31C)
#define CAN2_SR8_OFFSET 0x31C
#define CAN2_SR8_ACK_MASK 0x1U
#define CAN2_SR8_ACK 0x1U
#define CAN2_SR8_ACK_BIT 0
#define CAN2_SR8_FRAME_MASK 0x2U
#define CAN2_SR8_FRAME 0x2U
#define CAN2_SR8_FRAME_BIT 1
#define CAN2_SR8_CRC_MASK 0x4U
#define CAN2_SR8_CRC 0x4U
#define CAN2_SR8_CRC_BIT 2
#define CAN2_SR8_STUFF_MASK 0x8U
#define CAN2_SR8_STUFF 0x8U
#define CAN2_SR8_STUFF_BIT 3
#define CAN2_SR8_BUS_MASK 0x10U
#define CAN2_SR8_BUS 0x10U
#define CAN2_SR8_BUS_BIT 4
#define CAN2_SR8_RXOK_MASK 0x20U
#define CAN2_SR8_RXOK 0x20U
#define CAN2_SR8_RXOK_BIT 5
#define CAN2_SR8_TXOK_MASK 0x40U
#define CAN2_SR8_TXOK 0x40U
#define CAN2_SR8_TXOK_BIT 6
#define CAN2_SR8_RFRAME_MASK 0x80U
#define CAN2_SR8_RFRAME 0x80U
#define CAN2_SR8_RFRAME_BIT 7
#define CAN2_SR8_DLCW_MASK 0x200U
#define CAN2_SR8_DLCW 0x200U
#define CAN2_SR8_DLCW_BIT 9
#define CAN2_SR8_FILLED_MASK 0x400U
#define CAN2_SR8_FILLED 0x400U
#define CAN2_SR8_FILLED_BIT 10
#define CAN2_SR8_OVRUN_MASK 0x800U
#define CAN2_SR8_OVRUN 0x800U
#define CAN2_SR8_OVRUN_BIT 11

#define CAN2_IER8 (*(volatile unsigned long *)0xFFFBC320)
#define CAN2_IER8_OFFSET 0x320
#define CAN2_IER8_ACK_MASK 0x1U
#define CAN2_IER8_ACK 0x1U
#define CAN2_IER8_ACK_BIT 0
#define CAN2_IER8_FRAME_MASK 0x2U
#define CAN2_IER8_FRAME 0x2U
#define CAN2_IER8_FRAME_BIT 1
#define CAN2_IER8_CRC_MASK 0x4U
#define CAN2_IER8_CRC 0x4U
#define CAN2_IER8_CRC_BIT 2
#define CAN2_IER8_STUFF_MASK 0x8U
#define CAN2_IER8_STUFF 0x8U
#define CAN2_IER8_STUFF_BIT 3
#define CAN2_IER8_BUS_MASK 0x10U
#define CAN2_IER8_BUS 0x10U
#define CAN2_IER8_BUS_BIT 4
#define CAN2_IER8_RXOK_MASK 0x20U
#define CAN2_IER8_RXOK 0x20U
#define CAN2_IER8_RXOK_BIT 5
#define CAN2_IER8_TXOK_MASK 0x40U
#define CAN2_IER8_TXOK 0x40U
#define CAN2_IER8_TXOK_BIT 6
#define CAN2_IER8_RFRAME_MASK 0x80U
#define CAN2_IER8_RFRAME 0x80U
#define CAN2_IER8_RFRAME_BIT 7

#define CAN2_IDR8 (*(volatile unsigned long *)0xFFFBC324)
#define CAN2_IDR8_OFFSET 0x324
#define CAN2_IDR8_ACK_MASK 0x1U
#define CAN2_IDR8_ACK 0x1U
#define CAN2_IDR8_ACK_BIT 0
#define CAN2_IDR8_FRAME_MASK 0x2U
#define CAN2_IDR8_FRAME 0x2U
#define CAN2_IDR8_FRAME_BIT 1
#define CAN2_IDR8_CRC_MASK 0x4U
#define CAN2_IDR8_CRC 0x4U
#define CAN2_IDR8_CRC_BIT 2
#define CAN2_IDR8_STUFF_MASK 0x8U
#define CAN2_IDR8_STUFF 0x8U
#define CAN2_IDR8_STUFF_BIT 3
#define CAN2_IDR8_BUS_MASK 0x10U
#define CAN2_IDR8_BUS 0x10U
#define CAN2_IDR8_BUS_BIT 4
#define CAN2_IDR8_RXOK_MASK 0x20U
#define CAN2_IDR8_RXOK 0x20U
#define CAN2_IDR8_RXOK_BIT 5
#define CAN2_IDR8_TXOK_MASK 0x40U
#define CAN2_IDR8_TXOK 0x40U
#define CAN2_IDR8_TXOK_BIT 6
#define CAN2_IDR8_RFRAME_MASK 0x80U
#define CAN2_IDR8_RFRAME 0x80U
#define CAN2_IDR8_RFRAME_BIT 7

#define CAN2_IMR8 (*(volatile unsigned long *)0xFFFBC328)
#define CAN2_IMR8_OFFSET 0x328
#define CAN2_IMR8_ACK_MASK 0x1U
#define CAN2_IMR8_ACK 0x1U
#define CAN2_IMR8_ACK_BIT 0
#define CAN2_IMR8_FRAME_MASK 0x2U
#define CAN2_IMR8_FRAME 0x2U
#define CAN2_IMR8_FRAME_BIT 1
#define CAN2_IMR8_CRC_MASK 0x4U
#define CAN2_IMR8_CRC 0x4U
#define CAN2_IMR8_CRC_BIT 2
#define CAN2_IMR8_STUFF_MASK 0x8U
#define CAN2_IMR8_STUFF 0x8U
#define CAN2_IMR8_STUFF_BIT 3
#define CAN2_IMR8_BUS_MASK 0x10U
#define CAN2_IMR8_BUS 0x10U
#define CAN2_IMR8_BUS_BIT 4
#define CAN2_IMR8_RXOK_MASK 0x20U
#define CAN2_IMR8_RXOK 0x20U
#define CAN2_IMR8_RXOK_BIT 5
#define CAN2_IMR8_TXOK_MASK 0x40U
#define CAN2_IMR8_TXOK 0x40U
#define CAN2_IMR8_TXOK_BIT 6
#define CAN2_IMR8_RFRAME_MASK 0x80U
#define CAN2_IMR8_RFRAME 0x80U
#define CAN2_IMR8_RFRAME_BIT 7

#define CAN2_DRA9 (*(volatile unsigned long *)0xFFFBC340)
#define CAN2_DRA9_OFFSET 0x340
#define CAN2_DRA9_DATA0_MASK 0xFFU
#define CAN2_DRA9_DATA0_BIT 0
#define CAN2_DRA9_DATA1_MASK 0xFF00U
#define CAN2_DRA9_DATA1_BIT 8
#define CAN2_DRA9_DATA2_MASK 0xFF0000U
#define CAN2_DRA9_DATA2_BIT 16
#define CAN2_DRA9_DATA3_MASK 0xFF000000U
#define CAN2_DRA9_DATA3_BIT 24

#define CAN2_DRB9 (*(volatile unsigned long *)0xFFFBC344)
#define CAN2_DRB9_OFFSET 0x344
#define CAN2_DRB9_DATA4_MASK 0xFFU
#define CAN2_DRB9_DATA4_BIT 0
#define CAN2_DRB9_DATA5_MASK 0xFF00U
#define CAN2_DRB9_DATA5_BIT 8
#define CAN2_DRB9_DATA6_MASK 0xFF0000U
#define CAN2_DRB9_DATA6_BIT 16
#define CAN2_DRB9_DATA7_MASK 0xFF000000U
#define CAN2_DRB9_DATA7_BIT 24

#define CAN2_MSK9 (*(volatile unsigned long *)0xFFFBC348)
#define CAN2_MSK9_OFFSET 0x348
#define CAN2_MSK9_MASK_MASK 0x1FFFFFFFU
#define CAN2_MSK9_MASK_BIT 0
#define CAN2_MSK9_MRB_MASK 0x60000000U
#define CAN2_MSK9_MRB_BIT 29
#define CAN2_MSK9_MRTR_MASK 0x80000000U
#define CAN2_MSK9_MRTR 0x80000000U
#define CAN2_MSK9_MRTR_BIT 31

#define CAN2_IR9 (*(volatile unsigned long *)0xFFFBC34C)
#define CAN2_IR9_OFFSET 0x34C
#define CAN2_IR9_ID_MASK 0x1FFFFFFFU
#define CAN2_IR9_ID_BIT 0
#define CAN2_IR9_RB_MASK 0x60000000U
#define CAN2_IR9_RB_BIT 29
#define CAN2_IR9_RTR_MASK 0x80000000U
#define CAN2_IR9_RTR 0x80000000U
#define CAN2_IR9_RTR_BIT 31

#define CAN2_CR9 (*(volatile unsigned long *)0xFFFBC350)
#define CAN2_CR9_OFFSET 0x350
#define CAN2_CR9_DLC_MASK 0xFU
#define CAN2_CR9_DLC_BIT 0
#define CAN2_CR9_IDE_MASK 0x10U
#define CAN2_CR9_IDE 0x10U
#define CAN2_CR9_IDE_BIT 4
#define CAN2_CR9_RPLYV_MASK 0x20U
#define CAN2_CR9_RPLYV 0x20U
#define CAN2_CR9_RPLYV_BIT 5
#define CAN2_CR9_PCB_MASK 0x40U
#define CAN2_CR9_PCB 0x40U
#define CAN2_CR9_PCB_BIT 6
#define CAN2_CR9_CHANEN_MASK 0x80U
#define CAN2_CR9_CHANEN 0x80U
#define CAN2_CR9_CHANEN_BIT 7
#define CAN2_CR9_OVERWRITE_MASK 0x100U
#define CAN2_CR9_OVERWRITE 0x100U
#define CAN2_CR9_OVERWRITE_BIT 8

#define CAN2_CR9 (*(volatile unsigned long *)0xFFFBC354)
#define CAN2_CR9_OFFSET 0x354
#define CAN2_CR9_STAMP_MASK 0x0U
#define CAN2_CR9_STAMP_BIT 0

#define CAN2_CSR9 (*(volatile unsigned long *)0xFFFBC358)
#define CAN2_CSR9_OFFSET 0x358
#define CAN2_CSR9_ACK_MASK 0x1U
#define CAN2_CSR9_ACK 0x1U
#define CAN2_CSR9_ACK_BIT 0
#define CAN2_CSR9_FRAME_MASK 0x2U
#define CAN2_CSR9_FRAME 0x2U
#define CAN2_CSR9_FRAME_BIT 1
#define CAN2_CSR9_CRC_MASK 0x4U
#define CAN2_CSR9_CRC 0x4U
#define CAN2_CSR9_CRC_BIT 2
#define CAN2_CSR9_STUFF_MASK 0x8U
#define CAN2_CSR9_STUFF 0x8U
#define CAN2_CSR9_STUFF_BIT 3
#define CAN2_CSR9_BUS_MASK 0x10U
#define CAN2_CSR9_BUS 0x10U
#define CAN2_CSR9_BUS_BIT 4
#define CAN2_CSR9_RXOK_MASK 0x20U
#define CAN2_CSR9_RXOK 0x20U
#define CAN2_CSR9_RXOK_BIT 5
#define CAN2_CSR9_TXOK_MASK 0x40U
#define CAN2_CSR9_TXOK 0x40U
#define CAN2_CSR9_TXOK_BIT 6
#define CAN2_CSR9_RFRAME_MASK 0x80U
#define CAN2_CSR9_RFRAME 0x80U
#define CAN2_CSR9_RFRAME_BIT 7
#define CAN2_CSR9_DLCW_MASK 0x200U
#define CAN2_CSR9_DLCW 0x200U
#define CAN2_CSR9_DLCW_BIT 9
#define CAN2_CSR9_FILLED_MASK 0x400U
#define CAN2_CSR9_FILLED 0x400U
#define CAN2_CSR9_FILLED_BIT 10
#define CAN2_CSR9_OVRUN_MASK 0x800U
#define CAN2_CSR9_OVRUN 0x800U
#define CAN2_CSR9_OVRUN_BIT 11

#define CAN2_SR9 (*(volatile unsigned long *)0xFFFBC35C)
#define CAN2_SR9_OFFSET 0x35C
#define CAN2_SR9_ACK_MASK 0x1U
#define CAN2_SR9_ACK 0x1U
#define CAN2_SR9_ACK_BIT 0
#define CAN2_SR9_FRAME_MASK 0x2U
#define CAN2_SR9_FRAME 0x2U
#define CAN2_SR9_FRAME_BIT 1
#define CAN2_SR9_CRC_MASK 0x4U
#define CAN2_SR9_CRC 0x4U
#define CAN2_SR9_CRC_BIT 2
#define CAN2_SR9_STUFF_MASK 0x8U
#define CAN2_SR9_STUFF 0x8U
#define CAN2_SR9_STUFF_BIT 3
#define CAN2_SR9_BUS_MASK 0x10U
#define CAN2_SR9_BUS 0x10U
#define CAN2_SR9_BUS_BIT 4
#define CAN2_SR9_RXOK_MASK 0x20U
#define CAN2_SR9_RXOK 0x20U
#define CAN2_SR9_RXOK_BIT 5
#define CAN2_SR9_TXOK_MASK 0x40U
#define CAN2_SR9_TXOK 0x40U
#define CAN2_SR9_TXOK_BIT 6
#define CAN2_SR9_RFRAME_MASK 0x80U
#define CAN2_SR9_RFRAME 0x80U
#define CAN2_SR9_RFRAME_BIT 7
#define CAN2_SR9_DLCW_MASK 0x200U
#define CAN2_SR9_DLCW 0x200U
#define CAN2_SR9_DLCW_BIT 9
#define CAN2_SR9_FILLED_MASK 0x400U
#define CAN2_SR9_FILLED 0x400U
#define CAN2_SR9_FILLED_BIT 10
#define CAN2_SR9_OVRUN_MASK 0x800U
#define CAN2_SR9_OVRUN 0x800U
#define CAN2_SR9_OVRUN_BIT 11

#define CAN2_IER9 (*(volatile unsigned long *)0xFFFBC360)
#define CAN2_IER9_OFFSET 0x360
#define CAN2_IER9_ACK_MASK 0x1U
#define CAN2_IER9_ACK 0x1U
#define CAN2_IER9_ACK_BIT 0
#define CAN2_IER9_FRAME_MASK 0x2U
#define CAN2_IER9_FRAME 0x2U
#define CAN2_IER9_FRAME_BIT 1
#define CAN2_IER9_CRC_MASK 0x4U
#define CAN2_IER9_CRC 0x4U
#define CAN2_IER9_CRC_BIT 2
#define CAN2_IER9_STUFF_MASK 0x8U
#define CAN2_IER9_STUFF 0x8U
#define CAN2_IER9_STUFF_BIT 3
#define CAN2_IER9_BUS_MASK 0x10U
#define CAN2_IER9_BUS 0x10U
#define CAN2_IER9_BUS_BIT 4
#define CAN2_IER9_RXOK_MASK 0x20U
#define CAN2_IER9_RXOK 0x20U
#define CAN2_IER9_RXOK_BIT 5
#define CAN2_IER9_TXOK_MASK 0x40U
#define CAN2_IER9_TXOK 0x40U
#define CAN2_IER9_TXOK_BIT 6
#define CAN2_IER9_RFRAME_MASK 0x80U
#define CAN2_IER9_RFRAME 0x80U
#define CAN2_IER9_RFRAME_BIT 7

#define CAN2_IDR9 (*(volatile unsigned long *)0xFFFBC364)
#define CAN2_IDR9_OFFSET 0x364
#define CAN2_IDR9_ACK_MASK 0x1U
#define CAN2_IDR9_ACK 0x1U
#define CAN2_IDR9_ACK_BIT 0
#define CAN2_IDR9_FRAME_MASK 0x2U
#define CAN2_IDR9_FRAME 0x2U
#define CAN2_IDR9_FRAME_BIT 1
#define CAN2_IDR9_CRC_MASK 0x4U
#define CAN2_IDR9_CRC 0x4U
#define CAN2_IDR9_CRC_BIT 2
#define CAN2_IDR9_STUFF_MASK 0x8U
#define CAN2_IDR9_STUFF 0x8U
#define CAN2_IDR9_STUFF_BIT 3
#define CAN2_IDR9_BUS_MASK 0x10U
#define CAN2_IDR9_BUS 0x10U
#define CAN2_IDR9_BUS_BIT 4
#define CAN2_IDR9_RXOK_MASK 0x20U
#define CAN2_IDR9_RXOK 0x20U
#define CAN2_IDR9_RXOK_BIT 5
#define CAN2_IDR9_TXOK_MASK 0x40U
#define CAN2_IDR9_TXOK 0x40U
#define CAN2_IDR9_TXOK_BIT 6
#define CAN2_IDR9_RFRAME_MASK 0x80U
#define CAN2_IDR9_RFRAME 0x80U
#define CAN2_IDR9_RFRAME_BIT 7

#define CAN2_IMR9 (*(volatile unsigned long *)0xFFFBC368)
#define CAN2_IMR9_OFFSET 0x368
#define CAN2_IMR9_ACK_MASK 0x1U
#define CAN2_IMR9_ACK 0x1U
#define CAN2_IMR9_ACK_BIT 0
#define CAN2_IMR9_FRAME_MASK 0x2U
#define CAN2_IMR9_FRAME 0x2U
#define CAN2_IMR9_FRAME_BIT 1
#define CAN2_IMR9_CRC_MASK 0x4U
#define CAN2_IMR9_CRC 0x4U
#define CAN2_IMR9_CRC_BIT 2
#define CAN2_IMR9_STUFF_MASK 0x8U
#define CAN2_IMR9_STUFF 0x8U
#define CAN2_IMR9_STUFF_BIT 3
#define CAN2_IMR9_BUS_MASK 0x10U
#define CAN2_IMR9_BUS 0x10U
#define CAN2_IMR9_BUS_BIT 4
#define CAN2_IMR9_RXOK_MASK 0x20U
#define CAN2_IMR9_RXOK 0x20U
#define CAN2_IMR9_RXOK_BIT 5
#define CAN2_IMR9_TXOK_MASK 0x40U
#define CAN2_IMR9_TXOK 0x40U
#define CAN2_IMR9_TXOK_BIT 6
#define CAN2_IMR9_RFRAME_MASK 0x80U
#define CAN2_IMR9_RFRAME 0x80U
#define CAN2_IMR9_RFRAME_BIT 7

#define CAN2_DRA10 (*(volatile unsigned long *)0xFFFBC380)
#define CAN2_DRA10_OFFSET 0x380
#define CAN2_DRA10_DATA0_MASK 0xFFU
#define CAN2_DRA10_DATA0_BIT 0
#define CAN2_DRA10_DATA1_MASK 0xFF00U
#define CAN2_DRA10_DATA1_BIT 8
#define CAN2_DRA10_DATA2_MASK 0xFF0000U
#define CAN2_DRA10_DATA2_BIT 16
#define CAN2_DRA10_DATA3_MASK 0xFF000000U
#define CAN2_DRA10_DATA3_BIT 24

#define CAN2_DRB10 (*(volatile unsigned long *)0xFFFBC384)
#define CAN2_DRB10_OFFSET 0x384
#define CAN2_DRB10_DATA4_MASK 0xFFU
#define CAN2_DRB10_DATA4_BIT 0
#define CAN2_DRB10_DATA5_MASK 0xFF00U
#define CAN2_DRB10_DATA5_BIT 8
#define CAN2_DRB10_DATA6_MASK 0xFF0000U
#define CAN2_DRB10_DATA6_BIT 16
#define CAN2_DRB10_DATA7_MASK 0xFF000000U
#define CAN2_DRB10_DATA7_BIT 24

#define CAN2_MSK10 (*(volatile unsigned long *)0xFFFBC388)
#define CAN2_MSK10_OFFSET 0x388
#define CAN2_MSK10_MASK_MASK 0x1FFFFFFFU
#define CAN2_MSK10_MASK_BIT 0
#define CAN2_MSK10_MRB_MASK 0x60000000U
#define CAN2_MSK10_MRB_BIT 29
#define CAN2_MSK10_MRTR_MASK 0x80000000U
#define CAN2_MSK10_MRTR 0x80000000U
#define CAN2_MSK10_MRTR_BIT 31

#define CAN2_IR10 (*(volatile unsigned long *)0xFFFBC38C)
#define CAN2_IR10_OFFSET 0x38C
#define CAN2_IR10_ID_MASK 0x1FFFFFFFU
#define CAN2_IR10_ID_BIT 0
#define CAN2_IR10_RB_MASK 0x60000000U
#define CAN2_IR10_RB_BIT 29
#define CAN2_IR10_RTR_MASK 0x80000000U
#define CAN2_IR10_RTR 0x80000000U
#define CAN2_IR10_RTR_BIT 31

#define CAN2_CR10 (*(volatile unsigned long *)0xFFFBC390)
#define CAN2_CR10_OFFSET 0x390
#define CAN2_CR10_DLC_MASK 0xFU
#define CAN2_CR10_DLC_BIT 0
#define CAN2_CR10_IDE_MASK 0x10U
#define CAN2_CR10_IDE 0x10U
#define CAN2_CR10_IDE_BIT 4
#define CAN2_CR10_RPLYV_MASK 0x20U
#define CAN2_CR10_RPLYV 0x20U
#define CAN2_CR10_RPLYV_BIT 5
#define CAN2_CR10_PCB_MASK 0x40U
#define CAN2_CR10_PCB 0x40U
#define CAN2_CR10_PCB_BIT 6
#define CAN2_CR10_CHANEN_MASK 0x80U
#define CAN2_CR10_CHANEN 0x80U
#define CAN2_CR10_CHANEN_BIT 7
#define CAN2_CR10_OVERWRITE_MASK 0x100U
#define CAN2_CR10_OVERWRITE 0x100U
#define CAN2_CR10_OVERWRITE_BIT 8

#define CAN2_CR10 (*(volatile unsigned long *)0xFFFBC394)
#define CAN2_CR10_OFFSET 0x394
#define CAN2_CR10_STAMP_MASK 0x0U
#define CAN2_CR10_STAMP_BIT 0

#define CAN2_CSR10 (*(volatile unsigned long *)0xFFFBC398)
#define CAN2_CSR10_OFFSET 0x398
#define CAN2_CSR10_ACK_MASK 0x1U
#define CAN2_CSR10_ACK 0x1U
#define CAN2_CSR10_ACK_BIT 0
#define CAN2_CSR10_FRAME_MASK 0x2U
#define CAN2_CSR10_FRAME 0x2U
#define CAN2_CSR10_FRAME_BIT 1
#define CAN2_CSR10_CRC_MASK 0x4U
#define CAN2_CSR10_CRC 0x4U
#define CAN2_CSR10_CRC_BIT 2
#define CAN2_CSR10_STUFF_MASK 0x8U
#define CAN2_CSR10_STUFF 0x8U
#define CAN2_CSR10_STUFF_BIT 3
#define CAN2_CSR10_BUS_MASK 0x10U
#define CAN2_CSR10_BUS 0x10U
#define CAN2_CSR10_BUS_BIT 4
#define CAN2_CSR10_RXOK_MASK 0x20U
#define CAN2_CSR10_RXOK 0x20U
#define CAN2_CSR10_RXOK_BIT 5
#define CAN2_CSR10_TXOK_MASK 0x40U
#define CAN2_CSR10_TXOK 0x40U
#define CAN2_CSR10_TXOK_BIT 6
#define CAN2_CSR10_RFRAME_MASK 0x80U
#define CAN2_CSR10_RFRAME 0x80U
#define CAN2_CSR10_RFRAME_BIT 7
#define CAN2_CSR10_DLCW_MASK 0x200U
#define CAN2_CSR10_DLCW 0x200U
#define CAN2_CSR10_DLCW_BIT 9
#define CAN2_CSR10_FILLED_MASK 0x400U
#define CAN2_CSR10_FILLED 0x400U
#define CAN2_CSR10_FILLED_BIT 10
#define CAN2_CSR10_OVRUN_MASK 0x800U
#define CAN2_CSR10_OVRUN 0x800U
#define CAN2_CSR10_OVRUN_BIT 11

#define CAN2_SR10 (*(volatile unsigned long *)0xFFFBC39C)
#define CAN2_SR10_OFFSET 0x39C
#define CAN2_SR10_ACK_MASK 0x1U
#define CAN2_SR10_ACK 0x1U
#define CAN2_SR10_ACK_BIT 0
#define CAN2_SR10_FRAME_MASK 0x2U
#define CAN2_SR10_FRAME 0x2U
#define CAN2_SR10_FRAME_BIT 1
#define CAN2_SR10_CRC_MASK 0x4U
#define CAN2_SR10_CRC 0x4U
#define CAN2_SR10_CRC_BIT 2
#define CAN2_SR10_STUFF_MASK 0x8U
#define CAN2_SR10_STUFF 0x8U
#define CAN2_SR10_STUFF_BIT 3
#define CAN2_SR10_BUS_MASK 0x10U
#define CAN2_SR10_BUS 0x10U
#define CAN2_SR10_BUS_BIT 4
#define CAN2_SR10_RXOK_MASK 0x20U
#define CAN2_SR10_RXOK 0x20U
#define CAN2_SR10_RXOK_BIT 5
#define CAN2_SR10_TXOK_MASK 0x40U
#define CAN2_SR10_TXOK 0x40U
#define CAN2_SR10_TXOK_BIT 6
#define CAN2_SR10_RFRAME_MASK 0x80U
#define CAN2_SR10_RFRAME 0x80U
#define CAN2_SR10_RFRAME_BIT 7
#define CAN2_SR10_DLCW_MASK 0x200U
#define CAN2_SR10_DLCW 0x200U
#define CAN2_SR10_DLCW_BIT 9
#define CAN2_SR10_FILLED_MASK 0x400U
#define CAN2_SR10_FILLED 0x400U
#define CAN2_SR10_FILLED_BIT 10
#define CAN2_SR10_OVRUN_MASK 0x800U
#define CAN2_SR10_OVRUN 0x800U
#define CAN2_SR10_OVRUN_BIT 11

#define CAN2_IER10 (*(volatile unsigned long *)0xFFFBC3A0)
#define CAN2_IER10_OFFSET 0x3A0
#define CAN2_IER10_ACK_MASK 0x1U
#define CAN2_IER10_ACK 0x1U
#define CAN2_IER10_ACK_BIT 0
#define CAN2_IER10_FRAME_MASK 0x2U
#define CAN2_IER10_FRAME 0x2U
#define CAN2_IER10_FRAME_BIT 1
#define CAN2_IER10_CRC_MASK 0x4U
#define CAN2_IER10_CRC 0x4U
#define CAN2_IER10_CRC_BIT 2
#define CAN2_IER10_STUFF_MASK 0x8U
#define CAN2_IER10_STUFF 0x8U
#define CAN2_IER10_STUFF_BIT 3
#define CAN2_IER10_BUS_MASK 0x10U
#define CAN2_IER10_BUS 0x10U
#define CAN2_IER10_BUS_BIT 4
#define CAN2_IER10_RXOK_MASK 0x20U
#define CAN2_IER10_RXOK 0x20U
#define CAN2_IER10_RXOK_BIT 5
#define CAN2_IER10_TXOK_MASK 0x40U
#define CAN2_IER10_TXOK 0x40U
#define CAN2_IER10_TXOK_BIT 6
#define CAN2_IER10_RFRAME_MASK 0x80U
#define CAN2_IER10_RFRAME 0x80U
#define CAN2_IER10_RFRAME_BIT 7

#define CAN2_IDR10 (*(volatile unsigned long *)0xFFFBC3A4)
#define CAN2_IDR10_OFFSET 0x3A4
#define CAN2_IDR10_ACK_MASK 0x1U
#define CAN2_IDR10_ACK 0x1U
#define CAN2_IDR10_ACK_BIT 0
#define CAN2_IDR10_FRAME_MASK 0x2U
#define CAN2_IDR10_FRAME 0x2U
#define CAN2_IDR10_FRAME_BIT 1
#define CAN2_IDR10_CRC_MASK 0x4U
#define CAN2_IDR10_CRC 0x4U
#define CAN2_IDR10_CRC_BIT 2
#define CAN2_IDR10_STUFF_MASK 0x8U
#define CAN2_IDR10_STUFF 0x8U
#define CAN2_IDR10_STUFF_BIT 3
#define CAN2_IDR10_BUS_MASK 0x10U
#define CAN2_IDR10_BUS 0x10U
#define CAN2_IDR10_BUS_BIT 4
#define CAN2_IDR10_RXOK_MASK 0x20U
#define CAN2_IDR10_RXOK 0x20U
#define CAN2_IDR10_RXOK_BIT 5
#define CAN2_IDR10_TXOK_MASK 0x40U
#define CAN2_IDR10_TXOK 0x40U
#define CAN2_IDR10_TXOK_BIT 6
#define CAN2_IDR10_RFRAME_MASK 0x80U
#define CAN2_IDR10_RFRAME 0x80U
#define CAN2_IDR10_RFRAME_BIT 7

#define CAN2_IMR10 (*(volatile unsigned long *)0xFFFBC3A8)
#define CAN2_IMR10_OFFSET 0x3A8
#define CAN2_IMR10_ACK_MASK 0x1U
#define CAN2_IMR10_ACK 0x1U
#define CAN2_IMR10_ACK_BIT 0
#define CAN2_IMR10_FRAME_MASK 0x2U
#define CAN2_IMR10_FRAME 0x2U
#define CAN2_IMR10_FRAME_BIT 1
#define CAN2_IMR10_CRC_MASK 0x4U
#define CAN2_IMR10_CRC 0x4U
#define CAN2_IMR10_CRC_BIT 2
#define CAN2_IMR10_STUFF_MASK 0x8U
#define CAN2_IMR10_STUFF 0x8U
#define CAN2_IMR10_STUFF_BIT 3
#define CAN2_IMR10_BUS_MASK 0x10U
#define CAN2_IMR10_BUS 0x10U
#define CAN2_IMR10_BUS_BIT 4
#define CAN2_IMR10_RXOK_MASK 0x20U
#define CAN2_IMR10_RXOK 0x20U
#define CAN2_IMR10_RXOK_BIT 5
#define CAN2_IMR10_TXOK_MASK 0x40U
#define CAN2_IMR10_TXOK 0x40U
#define CAN2_IMR10_TXOK_BIT 6
#define CAN2_IMR10_RFRAME_MASK 0x80U
#define CAN2_IMR10_RFRAME 0x80U
#define CAN2_IMR10_RFRAME_BIT 7

#define CAN2_DRA11 (*(volatile unsigned long *)0xFFFBC3C0)
#define CAN2_DRA11_OFFSET 0x3C0
#define CAN2_DRA11_DATA0_MASK 0xFFU
#define CAN2_DRA11_DATA0_BIT 0
#define CAN2_DRA11_DATA1_MASK 0xFF00U
#define CAN2_DRA11_DATA1_BIT 8
#define CAN2_DRA11_DATA2_MASK 0xFF0000U
#define CAN2_DRA11_DATA2_BIT 16
#define CAN2_DRA11_DATA3_MASK 0xFF000000U
#define CAN2_DRA11_DATA3_BIT 24

#define CAN2_DRB11 (*(volatile unsigned long *)0xFFFBC3C4)
#define CAN2_DRB11_OFFSET 0x3C4
#define CAN2_DRB11_DATA4_MASK 0xFFU
#define CAN2_DRB11_DATA4_BIT 0
#define CAN2_DRB11_DATA5_MASK 0xFF00U
#define CAN2_DRB11_DATA5_BIT 8
#define CAN2_DRB11_DATA6_MASK 0xFF0000U
#define CAN2_DRB11_DATA6_BIT 16
#define CAN2_DRB11_DATA7_MASK 0xFF000000U
#define CAN2_DRB11_DATA7_BIT 24

#define CAN2_MSK11 (*(volatile unsigned long *)0xFFFBC3C8)
#define CAN2_MSK11_OFFSET 0x3C8
#define CAN2_MSK11_MASK_MASK 0x1FFFFFFFU
#define CAN2_MSK11_MASK_BIT 0
#define CAN2_MSK11_MRB_MASK 0x60000000U
#define CAN2_MSK11_MRB_BIT 29
#define CAN2_MSK11_MRTR_MASK 0x80000000U
#define CAN2_MSK11_MRTR 0x80000000U
#define CAN2_MSK11_MRTR_BIT 31

#define CAN2_IR11 (*(volatile unsigned long *)0xFFFBC3CC)
#define CAN2_IR11_OFFSET 0x3CC
#define CAN2_IR11_ID_MASK 0x1FFFFFFFU
#define CAN2_IR11_ID_BIT 0
#define CAN2_IR11_RB_MASK 0x60000000U
#define CAN2_IR11_RB_BIT 29
#define CAN2_IR11_RTR_MASK 0x80000000U
#define CAN2_IR11_RTR 0x80000000U
#define CAN2_IR11_RTR_BIT 31

#define CAN2_CR11 (*(volatile unsigned long *)0xFFFBC3D0)
#define CAN2_CR11_OFFSET 0x3D0
#define CAN2_CR11_DLC_MASK 0xFU
#define CAN2_CR11_DLC_BIT 0
#define CAN2_CR11_IDE_MASK 0x10U
#define CAN2_CR11_IDE 0x10U
#define CAN2_CR11_IDE_BIT 4
#define CAN2_CR11_RPLYV_MASK 0x20U
#define CAN2_CR11_RPLYV 0x20U
#define CAN2_CR11_RPLYV_BIT 5
#define CAN2_CR11_PCB_MASK 0x40U
#define CAN2_CR11_PCB 0x40U
#define CAN2_CR11_PCB_BIT 6
#define CAN2_CR11_CHANEN_MASK 0x80U
#define CAN2_CR11_CHANEN 0x80U
#define CAN2_CR11_CHANEN_BIT 7
#define CAN2_CR11_OVERWRITE_MASK 0x100U
#define CAN2_CR11_OVERWRITE 0x100U
#define CAN2_CR11_OVERWRITE_BIT 8

#define CAN2_CR11 (*(volatile unsigned long *)0xFFFBC3D4)
#define CAN2_CR11_OFFSET 0x3D4
#define CAN2_CR11_STAMP_MASK 0x0U
#define CAN2_CR11_STAMP_BIT 0

#define CAN2_CSR11 (*(volatile unsigned long *)0xFFFBC3D8)
#define CAN2_CSR11_OFFSET 0x3D8
#define CAN2_CSR11_ACK_MASK 0x1U
#define CAN2_CSR11_ACK 0x1U
#define CAN2_CSR11_ACK_BIT 0
#define CAN2_CSR11_FRAME_MASK 0x2U
#define CAN2_CSR11_FRAME 0x2U
#define CAN2_CSR11_FRAME_BIT 1
#define CAN2_CSR11_CRC_MASK 0x4U
#define CAN2_CSR11_CRC 0x4U
#define CAN2_CSR11_CRC_BIT 2
#define CAN2_CSR11_STUFF_MASK 0x8U
#define CAN2_CSR11_STUFF 0x8U
#define CAN2_CSR11_STUFF_BIT 3
#define CAN2_CSR11_BUS_MASK 0x10U
#define CAN2_CSR11_BUS 0x10U
#define CAN2_CSR11_BUS_BIT 4
#define CAN2_CSR11_RXOK_MASK 0x20U
#define CAN2_CSR11_RXOK 0x20U
#define CAN2_CSR11_RXOK_BIT 5
#define CAN2_CSR11_TXOK_MASK 0x40U
#define CAN2_CSR11_TXOK 0x40U
#define CAN2_CSR11_TXOK_BIT 6
#define CAN2_CSR11_RFRAME_MASK 0x80U
#define CAN2_CSR11_RFRAME 0x80U
#define CAN2_CSR11_RFRAME_BIT 7
#define CAN2_CSR11_DLCW_MASK 0x200U
#define CAN2_CSR11_DLCW 0x200U
#define CAN2_CSR11_DLCW_BIT 9
#define CAN2_CSR11_FILLED_MASK 0x400U
#define CAN2_CSR11_FILLED 0x400U
#define CAN2_CSR11_FILLED_BIT 10
#define CAN2_CSR11_OVRUN_MASK 0x800U
#define CAN2_CSR11_OVRUN 0x800U
#define CAN2_CSR11_OVRUN_BIT 11

#define CAN2_SR11 (*(volatile unsigned long *)0xFFFBC3DC)
#define CAN2_SR11_OFFSET 0x3DC
#define CAN2_SR11_ACK_MASK 0x1U
#define CAN2_SR11_ACK 0x1U
#define CAN2_SR11_ACK_BIT 0
#define CAN2_SR11_FRAME_MASK 0x2U
#define CAN2_SR11_FRAME 0x2U
#define CAN2_SR11_FRAME_BIT 1
#define CAN2_SR11_CRC_MASK 0x4U
#define CAN2_SR11_CRC 0x4U
#define CAN2_SR11_CRC_BIT 2
#define CAN2_SR11_STUFF_MASK 0x8U
#define CAN2_SR11_STUFF 0x8U
#define CAN2_SR11_STUFF_BIT 3
#define CAN2_SR11_BUS_MASK 0x10U
#define CAN2_SR11_BUS 0x10U
#define CAN2_SR11_BUS_BIT 4
#define CAN2_SR11_RXOK_MASK 0x20U
#define CAN2_SR11_RXOK 0x20U
#define CAN2_SR11_RXOK_BIT 5
#define CAN2_SR11_TXOK_MASK 0x40U
#define CAN2_SR11_TXOK 0x40U
#define CAN2_SR11_TXOK_BIT 6
#define CAN2_SR11_RFRAME_MASK 0x80U
#define CAN2_SR11_RFRAME 0x80U
#define CAN2_SR11_RFRAME_BIT 7
#define CAN2_SR11_DLCW_MASK 0x200U
#define CAN2_SR11_DLCW 0x200U
#define CAN2_SR11_DLCW_BIT 9
#define CAN2_SR11_FILLED_MASK 0x400U
#define CAN2_SR11_FILLED 0x400U
#define CAN2_SR11_FILLED_BIT 10
#define CAN2_SR11_OVRUN_MASK 0x800U
#define CAN2_SR11_OVRUN 0x800U
#define CAN2_SR11_OVRUN_BIT 11

#define CAN2_IER11 (*(volatile unsigned long *)0xFFFBC3E0)
#define CAN2_IER11_OFFSET 0x3E0
#define CAN2_IER11_ACK_MASK 0x1U
#define CAN2_IER11_ACK 0x1U
#define CAN2_IER11_ACK_BIT 0
#define CAN2_IER11_FRAME_MASK 0x2U
#define CAN2_IER11_FRAME 0x2U
#define CAN2_IER11_FRAME_BIT 1
#define CAN2_IER11_CRC_MASK 0x4U
#define CAN2_IER11_CRC 0x4U
#define CAN2_IER11_CRC_BIT 2
#define CAN2_IER11_STUFF_MASK 0x8U
#define CAN2_IER11_STUFF 0x8U
#define CAN2_IER11_STUFF_BIT 3
#define CAN2_IER11_BUS_MASK 0x10U
#define CAN2_IER11_BUS 0x10U
#define CAN2_IER11_BUS_BIT 4
#define CAN2_IER11_RXOK_MASK 0x20U
#define CAN2_IER11_RXOK 0x20U
#define CAN2_IER11_RXOK_BIT 5
#define CAN2_IER11_TXOK_MASK 0x40U
#define CAN2_IER11_TXOK 0x40U
#define CAN2_IER11_TXOK_BIT 6
#define CAN2_IER11_RFRAME_MASK 0x80U
#define CAN2_IER11_RFRAME 0x80U
#define CAN2_IER11_RFRAME_BIT 7

#define CAN2_IDR11 (*(volatile unsigned long *)0xFFFBC3E4)
#define CAN2_IDR11_OFFSET 0x3E4
#define CAN2_IDR11_ACK_MASK 0x1U
#define CAN2_IDR11_ACK 0x1U
#define CAN2_IDR11_ACK_BIT 0
#define CAN2_IDR11_FRAME_MASK 0x2U
#define CAN2_IDR11_FRAME 0x2U
#define CAN2_IDR11_FRAME_BIT 1
#define CAN2_IDR11_CRC_MASK 0x4U
#define CAN2_IDR11_CRC 0x4U
#define CAN2_IDR11_CRC_BIT 2
#define CAN2_IDR11_STUFF_MASK 0x8U
#define CAN2_IDR11_STUFF 0x8U
#define CAN2_IDR11_STUFF_BIT 3
#define CAN2_IDR11_BUS_MASK 0x10U
#define CAN2_IDR11_BUS 0x10U
#define CAN2_IDR11_BUS_BIT 4
#define CAN2_IDR11_RXOK_MASK 0x20U
#define CAN2_IDR11_RXOK 0x20U
#define CAN2_IDR11_RXOK_BIT 5
#define CAN2_IDR11_TXOK_MASK 0x40U
#define CAN2_IDR11_TXOK 0x40U
#define CAN2_IDR11_TXOK_BIT 6
#define CAN2_IDR11_RFRAME_MASK 0x80U
#define CAN2_IDR11_RFRAME 0x80U
#define CAN2_IDR11_RFRAME_BIT 7

#define CAN2_IMR11 (*(volatile unsigned long *)0xFFFBC3E8)
#define CAN2_IMR11_OFFSET 0x3E8
#define CAN2_IMR11_ACK_MASK 0x1U
#define CAN2_IMR11_ACK 0x1U
#define CAN2_IMR11_ACK_BIT 0
#define CAN2_IMR11_FRAME_MASK 0x2U
#define CAN2_IMR11_FRAME 0x2U
#define CAN2_IMR11_FRAME_BIT 1
#define CAN2_IMR11_CRC_MASK 0x4U
#define CAN2_IMR11_CRC 0x4U
#define CAN2_IMR11_CRC_BIT 2
#define CAN2_IMR11_STUFF_MASK 0x8U
#define CAN2_IMR11_STUFF 0x8U
#define CAN2_IMR11_STUFF_BIT 3
#define CAN2_IMR11_BUS_MASK 0x10U
#define CAN2_IMR11_BUS 0x10U
#define CAN2_IMR11_BUS_BIT 4
#define CAN2_IMR11_RXOK_MASK 0x20U
#define CAN2_IMR11_RXOK 0x20U
#define CAN2_IMR11_RXOK_BIT 5
#define CAN2_IMR11_TXOK_MASK 0x40U
#define CAN2_IMR11_TXOK 0x40U
#define CAN2_IMR11_TXOK_BIT 6
#define CAN2_IMR11_RFRAME_MASK 0x80U
#define CAN2_IMR11_RFRAME 0x80U
#define CAN2_IMR11_RFRAME_BIT 7

#define CAN2_DRA12 (*(volatile unsigned long *)0xFFFBC400)
#define CAN2_DRA12_OFFSET 0x400
#define CAN2_DRA12_DATA0_MASK 0xFFU
#define CAN2_DRA12_DATA0_BIT 0
#define CAN2_DRA12_DATA1_MASK 0xFF00U
#define CAN2_DRA12_DATA1_BIT 8
#define CAN2_DRA12_DATA2_MASK 0xFF0000U
#define CAN2_DRA12_DATA2_BIT 16
#define CAN2_DRA12_DATA3_MASK 0xFF000000U
#define CAN2_DRA12_DATA3_BIT 24

#define CAN2_DRB12 (*(volatile unsigned long *)0xFFFBC404)
#define CAN2_DRB12_OFFSET 0x404
#define CAN2_DRB12_DATA4_MASK 0xFFU
#define CAN2_DRB12_DATA4_BIT 0
#define CAN2_DRB12_DATA5_MASK 0xFF00U
#define CAN2_DRB12_DATA5_BIT 8
#define CAN2_DRB12_DATA6_MASK 0xFF0000U
#define CAN2_DRB12_DATA6_BIT 16
#define CAN2_DRB12_DATA7_MASK 0xFF000000U
#define CAN2_DRB12_DATA7_BIT 24

#define CAN2_MSK12 (*(volatile unsigned long *)0xFFFBC408)
#define CAN2_MSK12_OFFSET 0x408
#define CAN2_MSK12_MASK_MASK 0x1FFFFFFFU
#define CAN2_MSK12_MASK_BIT 0
#define CAN2_MSK12_MRB_MASK 0x60000000U
#define CAN2_MSK12_MRB_BIT 29
#define CAN2_MSK12_MRTR_MASK 0x80000000U
#define CAN2_MSK12_MRTR 0x80000000U
#define CAN2_MSK12_MRTR_BIT 31

#define CAN2_IR12 (*(volatile unsigned long *)0xFFFBC40C)
#define CAN2_IR12_OFFSET 0x40C
#define CAN2_IR12_ID_MASK 0x1FFFFFFFU
#define CAN2_IR12_ID_BIT 0
#define CAN2_IR12_RB_MASK 0x60000000U
#define CAN2_IR12_RB_BIT 29
#define CAN2_IR12_RTR_MASK 0x80000000U
#define CAN2_IR12_RTR 0x80000000U
#define CAN2_IR12_RTR_BIT 31

#define CAN2_CR12 (*(volatile unsigned long *)0xFFFBC410)
#define CAN2_CR12_OFFSET 0x410
#define CAN2_CR12_DLC_MASK 0xFU
#define CAN2_CR12_DLC_BIT 0
#define CAN2_CR12_IDE_MASK 0x10U
#define CAN2_CR12_IDE 0x10U
#define CAN2_CR12_IDE_BIT 4
#define CAN2_CR12_RPLYV_MASK 0x20U
#define CAN2_CR12_RPLYV 0x20U
#define CAN2_CR12_RPLYV_BIT 5
#define CAN2_CR12_PCB_MASK 0x40U
#define CAN2_CR12_PCB 0x40U
#define CAN2_CR12_PCB_BIT 6
#define CAN2_CR12_CHANEN_MASK 0x80U
#define CAN2_CR12_CHANEN 0x80U
#define CAN2_CR12_CHANEN_BIT 7
#define CAN2_CR12_OVERWRITE_MASK 0x100U
#define CAN2_CR12_OVERWRITE 0x100U
#define CAN2_CR12_OVERWRITE_BIT 8

#define CAN2_CR12 (*(volatile unsigned long *)0xFFFBC414)
#define CAN2_CR12_OFFSET 0x414
#define CAN2_CR12_STAMP_MASK 0x0U
#define CAN2_CR12_STAMP_BIT 0

#define CAN2_CSR12 (*(volatile unsigned long *)0xFFFBC418)
#define CAN2_CSR12_OFFSET 0x418
#define CAN2_CSR12_ACK_MASK 0x1U
#define CAN2_CSR12_ACK 0x1U
#define CAN2_CSR12_ACK_BIT 0
#define CAN2_CSR12_FRAME_MASK 0x2U
#define CAN2_CSR12_FRAME 0x2U
#define CAN2_CSR12_FRAME_BIT 1
#define CAN2_CSR12_CRC_MASK 0x4U
#define CAN2_CSR12_CRC 0x4U
#define CAN2_CSR12_CRC_BIT 2
#define CAN2_CSR12_STUFF_MASK 0x8U
#define CAN2_CSR12_STUFF 0x8U
#define CAN2_CSR12_STUFF_BIT 3
#define CAN2_CSR12_BUS_MASK 0x10U
#define CAN2_CSR12_BUS 0x10U
#define CAN2_CSR12_BUS_BIT 4
#define CAN2_CSR12_RXOK_MASK 0x20U
#define CAN2_CSR12_RXOK 0x20U
#define CAN2_CSR12_RXOK_BIT 5
#define CAN2_CSR12_TXOK_MASK 0x40U
#define CAN2_CSR12_TXOK 0x40U
#define CAN2_CSR12_TXOK_BIT 6
#define CAN2_CSR12_RFRAME_MASK 0x80U
#define CAN2_CSR12_RFRAME 0x80U
#define CAN2_CSR12_RFRAME_BIT 7
#define CAN2_CSR12_DLCW_MASK 0x200U
#define CAN2_CSR12_DLCW 0x200U
#define CAN2_CSR12_DLCW_BIT 9
#define CAN2_CSR12_FILLED_MASK 0x400U
#define CAN2_CSR12_FILLED 0x400U
#define CAN2_CSR12_FILLED_BIT 10
#define CAN2_CSR12_OVRUN_MASK 0x800U
#define CAN2_CSR12_OVRUN 0x800U
#define CAN2_CSR12_OVRUN_BIT 11

#define CAN2_SR12 (*(volatile unsigned long *)0xFFFBC41C)
#define CAN2_SR12_OFFSET 0x41C
#define CAN2_SR12_ACK_MASK 0x1U
#define CAN2_SR12_ACK 0x1U
#define CAN2_SR12_ACK_BIT 0
#define CAN2_SR12_FRAME_MASK 0x2U
#define CAN2_SR12_FRAME 0x2U
#define CAN2_SR12_FRAME_BIT 1
#define CAN2_SR12_CRC_MASK 0x4U
#define CAN2_SR12_CRC 0x4U
#define CAN2_SR12_CRC_BIT 2
#define CAN2_SR12_STUFF_MASK 0x8U
#define CAN2_SR12_STUFF 0x8U
#define CAN2_SR12_STUFF_BIT 3
#define CAN2_SR12_BUS_MASK 0x10U
#define CAN2_SR12_BUS 0x10U
#define CAN2_SR12_BUS_BIT 4
#define CAN2_SR12_RXOK_MASK 0x20U
#define CAN2_SR12_RXOK 0x20U
#define CAN2_SR12_RXOK_BIT 5
#define CAN2_SR12_TXOK_MASK 0x40U
#define CAN2_SR12_TXOK 0x40U
#define CAN2_SR12_TXOK_BIT 6
#define CAN2_SR12_RFRAME_MASK 0x80U
#define CAN2_SR12_RFRAME 0x80U
#define CAN2_SR12_RFRAME_BIT 7
#define CAN2_SR12_DLCW_MASK 0x200U
#define CAN2_SR12_DLCW 0x200U
#define CAN2_SR12_DLCW_BIT 9
#define CAN2_SR12_FILLED_MASK 0x400U
#define CAN2_SR12_FILLED 0x400U
#define CAN2_SR12_FILLED_BIT 10
#define CAN2_SR12_OVRUN_MASK 0x800U
#define CAN2_SR12_OVRUN 0x800U
#define CAN2_SR12_OVRUN_BIT 11

#define CAN2_IER12 (*(volatile unsigned long *)0xFFFBC420)
#define CAN2_IER12_OFFSET 0x420
#define CAN2_IER12_ACK_MASK 0x1U
#define CAN2_IER12_ACK 0x1U
#define CAN2_IER12_ACK_BIT 0
#define CAN2_IER12_FRAME_MASK 0x2U
#define CAN2_IER12_FRAME 0x2U
#define CAN2_IER12_FRAME_BIT 1
#define CAN2_IER12_CRC_MASK 0x4U
#define CAN2_IER12_CRC 0x4U
#define CAN2_IER12_CRC_BIT 2
#define CAN2_IER12_STUFF_MASK 0x8U
#define CAN2_IER12_STUFF 0x8U
#define CAN2_IER12_STUFF_BIT 3
#define CAN2_IER12_BUS_MASK 0x10U
#define CAN2_IER12_BUS 0x10U
#define CAN2_IER12_BUS_BIT 4
#define CAN2_IER12_RXOK_MASK 0x20U
#define CAN2_IER12_RXOK 0x20U
#define CAN2_IER12_RXOK_BIT 5
#define CAN2_IER12_TXOK_MASK 0x40U
#define CAN2_IER12_TXOK 0x40U
#define CAN2_IER12_TXOK_BIT 6
#define CAN2_IER12_RFRAME_MASK 0x80U
#define CAN2_IER12_RFRAME 0x80U
#define CAN2_IER12_RFRAME_BIT 7

#define CAN2_IDR12 (*(volatile unsigned long *)0xFFFBC424)
#define CAN2_IDR12_OFFSET 0x424
#define CAN2_IDR12_ACK_MASK 0x1U
#define CAN2_IDR12_ACK 0x1U
#define CAN2_IDR12_ACK_BIT 0
#define CAN2_IDR12_FRAME_MASK 0x2U
#define CAN2_IDR12_FRAME 0x2U
#define CAN2_IDR12_FRAME_BIT 1
#define CAN2_IDR12_CRC_MASK 0x4U
#define CAN2_IDR12_CRC 0x4U
#define CAN2_IDR12_CRC_BIT 2
#define CAN2_IDR12_STUFF_MASK 0x8U
#define CAN2_IDR12_STUFF 0x8U
#define CAN2_IDR12_STUFF_BIT 3
#define CAN2_IDR12_BUS_MASK 0x10U
#define CAN2_IDR12_BUS 0x10U
#define CAN2_IDR12_BUS_BIT 4
#define CAN2_IDR12_RXOK_MASK 0x20U
#define CAN2_IDR12_RXOK 0x20U
#define CAN2_IDR12_RXOK_BIT 5
#define CAN2_IDR12_TXOK_MASK 0x40U
#define CAN2_IDR12_TXOK 0x40U
#define CAN2_IDR12_TXOK_BIT 6
#define CAN2_IDR12_RFRAME_MASK 0x80U
#define CAN2_IDR12_RFRAME 0x80U
#define CAN2_IDR12_RFRAME_BIT 7

#define CAN2_IMR12 (*(volatile unsigned long *)0xFFFBC428)
#define CAN2_IMR12_OFFSET 0x428
#define CAN2_IMR12_ACK_MASK 0x1U
#define CAN2_IMR12_ACK 0x1U
#define CAN2_IMR12_ACK_BIT 0
#define CAN2_IMR12_FRAME_MASK 0x2U
#define CAN2_IMR12_FRAME 0x2U
#define CAN2_IMR12_FRAME_BIT 1
#define CAN2_IMR12_CRC_MASK 0x4U
#define CAN2_IMR12_CRC 0x4U
#define CAN2_IMR12_CRC_BIT 2
#define CAN2_IMR12_STUFF_MASK 0x8U
#define CAN2_IMR12_STUFF 0x8U
#define CAN2_IMR12_STUFF_BIT 3
#define CAN2_IMR12_BUS_MASK 0x10U
#define CAN2_IMR12_BUS 0x10U
#define CAN2_IMR12_BUS_BIT 4
#define CAN2_IMR12_RXOK_MASK 0x20U
#define CAN2_IMR12_RXOK 0x20U
#define CAN2_IMR12_RXOK_BIT 5
#define CAN2_IMR12_TXOK_MASK 0x40U
#define CAN2_IMR12_TXOK 0x40U
#define CAN2_IMR12_TXOK_BIT 6
#define CAN2_IMR12_RFRAME_MASK 0x80U
#define CAN2_IMR12_RFRAME 0x80U
#define CAN2_IMR12_RFRAME_BIT 7

#define CAN2_DRA13 (*(volatile unsigned long *)0xFFFBC440)
#define CAN2_DRA13_OFFSET 0x440
#define CAN2_DRA13_DATA0_MASK 0xFFU
#define CAN2_DRA13_DATA0_BIT 0
#define CAN2_DRA13_DATA1_MASK 0xFF00U
#define CAN2_DRA13_DATA1_BIT 8
#define CAN2_DRA13_DATA2_MASK 0xFF0000U
#define CAN2_DRA13_DATA2_BIT 16
#define CAN2_DRA13_DATA3_MASK 0xFF000000U
#define CAN2_DRA13_DATA3_BIT 24

#define CAN2_DRB13 (*(volatile unsigned long *)0xFFFBC444)
#define CAN2_DRB13_OFFSET 0x444
#define CAN2_DRB13_DATA4_MASK 0xFFU
#define CAN2_DRB13_DATA4_BIT 0
#define CAN2_DRB13_DATA5_MASK 0xFF00U
#define CAN2_DRB13_DATA5_BIT 8
#define CAN2_DRB13_DATA6_MASK 0xFF0000U
#define CAN2_DRB13_DATA6_BIT 16
#define CAN2_DRB13_DATA7_MASK 0xFF000000U
#define CAN2_DRB13_DATA7_BIT 24

#define CAN2_MSK13 (*(volatile unsigned long *)0xFFFBC448)
#define CAN2_MSK13_OFFSET 0x448
#define CAN2_MSK13_MASK_MASK 0x1FFFFFFFU
#define CAN2_MSK13_MASK_BIT 0
#define CAN2_MSK13_MRB_MASK 0x60000000U
#define CAN2_MSK13_MRB_BIT 29
#define CAN2_MSK13_MRTR_MASK 0x80000000U
#define CAN2_MSK13_MRTR 0x80000000U
#define CAN2_MSK13_MRTR_BIT 31

#define CAN2_IR13 (*(volatile unsigned long *)0xFFFBC44C)
#define CAN2_IR13_OFFSET 0x44C
#define CAN2_IR13_ID_MASK 0x1FFFFFFFU
#define CAN2_IR13_ID_BIT 0
#define CAN2_IR13_RB_MASK 0x60000000U
#define CAN2_IR13_RB_BIT 29
#define CAN2_IR13_RTR_MASK 0x80000000U
#define CAN2_IR13_RTR 0x80000000U
#define CAN2_IR13_RTR_BIT 31

#define CAN2_CR13 (*(volatile unsigned long *)0xFFFBC450)
#define CAN2_CR13_OFFSET 0x450
#define CAN2_CR13_DLC_MASK 0xFU
#define CAN2_CR13_DLC_BIT 0
#define CAN2_CR13_IDE_MASK 0x10U
#define CAN2_CR13_IDE 0x10U
#define CAN2_CR13_IDE_BIT 4
#define CAN2_CR13_RPLYV_MASK 0x20U
#define CAN2_CR13_RPLYV 0x20U
#define CAN2_CR13_RPLYV_BIT 5
#define CAN2_CR13_PCB_MASK 0x40U
#define CAN2_CR13_PCB 0x40U
#define CAN2_CR13_PCB_BIT 6
#define CAN2_CR13_CHANEN_MASK 0x80U
#define CAN2_CR13_CHANEN 0x80U
#define CAN2_CR13_CHANEN_BIT 7
#define CAN2_CR13_OVERWRITE_MASK 0x100U
#define CAN2_CR13_OVERWRITE 0x100U
#define CAN2_CR13_OVERWRITE_BIT 8

#define CAN2_CR13 (*(volatile unsigned long *)0xFFFBC454)
#define CAN2_CR13_OFFSET 0x454
#define CAN2_CR13_STAMP_MASK 0x0U
#define CAN2_CR13_STAMP_BIT 0

#define CAN2_CSR13 (*(volatile unsigned long *)0xFFFBC458)
#define CAN2_CSR13_OFFSET 0x458
#define CAN2_CSR13_ACK_MASK 0x1U
#define CAN2_CSR13_ACK 0x1U
#define CAN2_CSR13_ACK_BIT 0
#define CAN2_CSR13_FRAME_MASK 0x2U
#define CAN2_CSR13_FRAME 0x2U
#define CAN2_CSR13_FRAME_BIT 1
#define CAN2_CSR13_CRC_MASK 0x4U
#define CAN2_CSR13_CRC 0x4U
#define CAN2_CSR13_CRC_BIT 2
#define CAN2_CSR13_STUFF_MASK 0x8U
#define CAN2_CSR13_STUFF 0x8U
#define CAN2_CSR13_STUFF_BIT 3
#define CAN2_CSR13_BUS_MASK 0x10U
#define CAN2_CSR13_BUS 0x10U
#define CAN2_CSR13_BUS_BIT 4
#define CAN2_CSR13_RXOK_MASK 0x20U
#define CAN2_CSR13_RXOK 0x20U
#define CAN2_CSR13_RXOK_BIT 5
#define CAN2_CSR13_TXOK_MASK 0x40U
#define CAN2_CSR13_TXOK 0x40U
#define CAN2_CSR13_TXOK_BIT 6
#define CAN2_CSR13_RFRAME_MASK 0x80U
#define CAN2_CSR13_RFRAME 0x80U
#define CAN2_CSR13_RFRAME_BIT 7
#define CAN2_CSR13_DLCW_MASK 0x200U
#define CAN2_CSR13_DLCW 0x200U
#define CAN2_CSR13_DLCW_BIT 9
#define CAN2_CSR13_FILLED_MASK 0x400U
#define CAN2_CSR13_FILLED 0x400U
#define CAN2_CSR13_FILLED_BIT 10
#define CAN2_CSR13_OVRUN_MASK 0x800U
#define CAN2_CSR13_OVRUN 0x800U
#define CAN2_CSR13_OVRUN_BIT 11

#define CAN2_SR13 (*(volatile unsigned long *)0xFFFBC45C)
#define CAN2_SR13_OFFSET 0x45C
#define CAN2_SR13_ACK_MASK 0x1U
#define CAN2_SR13_ACK 0x1U
#define CAN2_SR13_ACK_BIT 0
#define CAN2_SR13_FRAME_MASK 0x2U
#define CAN2_SR13_FRAME 0x2U
#define CAN2_SR13_FRAME_BIT 1
#define CAN2_SR13_CRC_MASK 0x4U
#define CAN2_SR13_CRC 0x4U
#define CAN2_SR13_CRC_BIT 2
#define CAN2_SR13_STUFF_MASK 0x8U
#define CAN2_SR13_STUFF 0x8U
#define CAN2_SR13_STUFF_BIT 3
#define CAN2_SR13_BUS_MASK 0x10U
#define CAN2_SR13_BUS 0x10U
#define CAN2_SR13_BUS_BIT 4
#define CAN2_SR13_RXOK_MASK 0x20U
#define CAN2_SR13_RXOK 0x20U
#define CAN2_SR13_RXOK_BIT 5
#define CAN2_SR13_TXOK_MASK 0x40U
#define CAN2_SR13_TXOK 0x40U
#define CAN2_SR13_TXOK_BIT 6
#define CAN2_SR13_RFRAME_MASK 0x80U
#define CAN2_SR13_RFRAME 0x80U
#define CAN2_SR13_RFRAME_BIT 7
#define CAN2_SR13_DLCW_MASK 0x200U
#define CAN2_SR13_DLCW 0x200U
#define CAN2_SR13_DLCW_BIT 9
#define CAN2_SR13_FILLED_MASK 0x400U
#define CAN2_SR13_FILLED 0x400U
#define CAN2_SR13_FILLED_BIT 10
#define CAN2_SR13_OVRUN_MASK 0x800U
#define CAN2_SR13_OVRUN 0x800U
#define CAN2_SR13_OVRUN_BIT 11

#define CAN2_IER13 (*(volatile unsigned long *)0xFFFBC460)
#define CAN2_IER13_OFFSET 0x460
#define CAN2_IER13_ACK_MASK 0x1U
#define CAN2_IER13_ACK 0x1U
#define CAN2_IER13_ACK_BIT 0
#define CAN2_IER13_FRAME_MASK 0x2U
#define CAN2_IER13_FRAME 0x2U
#define CAN2_IER13_FRAME_BIT 1
#define CAN2_IER13_CRC_MASK 0x4U
#define CAN2_IER13_CRC 0x4U
#define CAN2_IER13_CRC_BIT 2
#define CAN2_IER13_STUFF_MASK 0x8U
#define CAN2_IER13_STUFF 0x8U
#define CAN2_IER13_STUFF_BIT 3
#define CAN2_IER13_BUS_MASK 0x10U
#define CAN2_IER13_BUS 0x10U
#define CAN2_IER13_BUS_BIT 4
#define CAN2_IER13_RXOK_MASK 0x20U
#define CAN2_IER13_RXOK 0x20U
#define CAN2_IER13_RXOK_BIT 5
#define CAN2_IER13_TXOK_MASK 0x40U
#define CAN2_IER13_TXOK 0x40U
#define CAN2_IER13_TXOK_BIT 6
#define CAN2_IER13_RFRAME_MASK 0x80U
#define CAN2_IER13_RFRAME 0x80U
#define CAN2_IER13_RFRAME_BIT 7

#define CAN2_IDR13 (*(volatile unsigned long *)0xFFFBC464)
#define CAN2_IDR13_OFFSET 0x464
#define CAN2_IDR13_ACK_MASK 0x1U
#define CAN2_IDR13_ACK 0x1U
#define CAN2_IDR13_ACK_BIT 0
#define CAN2_IDR13_FRAME_MASK 0x2U
#define CAN2_IDR13_FRAME 0x2U
#define CAN2_IDR13_FRAME_BIT 1
#define CAN2_IDR13_CRC_MASK 0x4U
#define CAN2_IDR13_CRC 0x4U
#define CAN2_IDR13_CRC_BIT 2
#define CAN2_IDR13_STUFF_MASK 0x8U
#define CAN2_IDR13_STUFF 0x8U
#define CAN2_IDR13_STUFF_BIT 3
#define CAN2_IDR13_BUS_MASK 0x10U
#define CAN2_IDR13_BUS 0x10U
#define CAN2_IDR13_BUS_BIT 4
#define CAN2_IDR13_RXOK_MASK 0x20U
#define CAN2_IDR13_RXOK 0x20U
#define CAN2_IDR13_RXOK_BIT 5
#define CAN2_IDR13_TXOK_MASK 0x40U
#define CAN2_IDR13_TXOK 0x40U
#define CAN2_IDR13_TXOK_BIT 6
#define CAN2_IDR13_RFRAME_MASK 0x80U
#define CAN2_IDR13_RFRAME 0x80U
#define CAN2_IDR13_RFRAME_BIT 7

#define CAN2_IMR13 (*(volatile unsigned long *)0xFFFBC468)
#define CAN2_IMR13_OFFSET 0x468
#define CAN2_IMR13_ACK_MASK 0x1U
#define CAN2_IMR13_ACK 0x1U
#define CAN2_IMR13_ACK_BIT 0
#define CAN2_IMR13_FRAME_MASK 0x2U
#define CAN2_IMR13_FRAME 0x2U
#define CAN2_IMR13_FRAME_BIT 1
#define CAN2_IMR13_CRC_MASK 0x4U
#define CAN2_IMR13_CRC 0x4U
#define CAN2_IMR13_CRC_BIT 2
#define CAN2_IMR13_STUFF_MASK 0x8U
#define CAN2_IMR13_STUFF 0x8U
#define CAN2_IMR13_STUFF_BIT 3
#define CAN2_IMR13_BUS_MASK 0x10U
#define CAN2_IMR13_BUS 0x10U
#define CAN2_IMR13_BUS_BIT 4
#define CAN2_IMR13_RXOK_MASK 0x20U
#define CAN2_IMR13_RXOK 0x20U
#define CAN2_IMR13_RXOK_BIT 5
#define CAN2_IMR13_TXOK_MASK 0x40U
#define CAN2_IMR13_TXOK 0x40U
#define CAN2_IMR13_TXOK_BIT 6
#define CAN2_IMR13_RFRAME_MASK 0x80U
#define CAN2_IMR13_RFRAME 0x80U
#define CAN2_IMR13_RFRAME_BIT 7

#define CAN2_DRA14 (*(volatile unsigned long *)0xFFFBC480)
#define CAN2_DRA14_OFFSET 0x480
#define CAN2_DRA14_DATA0_MASK 0xFFU
#define CAN2_DRA14_DATA0_BIT 0
#define CAN2_DRA14_DATA1_MASK 0xFF00U
#define CAN2_DRA14_DATA1_BIT 8
#define CAN2_DRA14_DATA2_MASK 0xFF0000U
#define CAN2_DRA14_DATA2_BIT 16
#define CAN2_DRA14_DATA3_MASK 0xFF000000U
#define CAN2_DRA14_DATA3_BIT 24

#define CAN2_DRB14 (*(volatile unsigned long *)0xFFFBC484)
#define CAN2_DRB14_OFFSET 0x484
#define CAN2_DRB14_DATA4_MASK 0xFFU
#define CAN2_DRB14_DATA4_BIT 0
#define CAN2_DRB14_DATA5_MASK 0xFF00U
#define CAN2_DRB14_DATA5_BIT 8
#define CAN2_DRB14_DATA6_MASK 0xFF0000U
#define CAN2_DRB14_DATA6_BIT 16
#define CAN2_DRB14_DATA7_MASK 0xFF000000U
#define CAN2_DRB14_DATA7_BIT 24

#define CAN2_MSK14 (*(volatile unsigned long *)0xFFFBC488)
#define CAN2_MSK14_OFFSET 0x488
#define CAN2_MSK14_MASK_MASK 0x1FFFFFFFU
#define CAN2_MSK14_MASK_BIT 0
#define CAN2_MSK14_MRB_MASK 0x60000000U
#define CAN2_MSK14_MRB_BIT 29
#define CAN2_MSK14_MRTR_MASK 0x80000000U
#define CAN2_MSK14_MRTR 0x80000000U
#define CAN2_MSK14_MRTR_BIT 31

#define CAN2_IR14 (*(volatile unsigned long *)0xFFFBC48C)
#define CAN2_IR14_OFFSET 0x48C
#define CAN2_IR14_ID_MASK 0x1FFFFFFFU
#define CAN2_IR14_ID_BIT 0
#define CAN2_IR14_RB_MASK 0x60000000U
#define CAN2_IR14_RB_BIT 29
#define CAN2_IR14_RTR_MASK 0x80000000U
#define CAN2_IR14_RTR 0x80000000U
#define CAN2_IR14_RTR_BIT 31

#define CAN2_CR14 (*(volatile unsigned long *)0xFFFBC490)
#define CAN2_CR14_OFFSET 0x490
#define CAN2_CR14_DLC_MASK 0xFU
#define CAN2_CR14_DLC_BIT 0
#define CAN2_CR14_IDE_MASK 0x10U
#define CAN2_CR14_IDE 0x10U
#define CAN2_CR14_IDE_BIT 4
#define CAN2_CR14_RPLYV_MASK 0x20U
#define CAN2_CR14_RPLYV 0x20U
#define CAN2_CR14_RPLYV_BIT 5
#define CAN2_CR14_PCB_MASK 0x40U
#define CAN2_CR14_PCB 0x40U
#define CAN2_CR14_PCB_BIT 6
#define CAN2_CR14_CHANEN_MASK 0x80U
#define CAN2_CR14_CHANEN 0x80U
#define CAN2_CR14_CHANEN_BIT 7
#define CAN2_CR14_OVERWRITE_MASK 0x100U
#define CAN2_CR14_OVERWRITE 0x100U
#define CAN2_CR14_OVERWRITE_BIT 8

#define CAN2_CR14 (*(volatile unsigned long *)0xFFFBC494)
#define CAN2_CR14_OFFSET 0x494
#define CAN2_CR14_STAMP_MASK 0x0U
#define CAN2_CR14_STAMP_BIT 0

#define CAN2_CSR14 (*(volatile unsigned long *)0xFFFBC498)
#define CAN2_CSR14_OFFSET 0x498
#define CAN2_CSR14_ACK_MASK 0x1U
#define CAN2_CSR14_ACK 0x1U
#define CAN2_CSR14_ACK_BIT 0
#define CAN2_CSR14_FRAME_MASK 0x2U
#define CAN2_CSR14_FRAME 0x2U
#define CAN2_CSR14_FRAME_BIT 1
#define CAN2_CSR14_CRC_MASK 0x4U
#define CAN2_CSR14_CRC 0x4U
#define CAN2_CSR14_CRC_BIT 2
#define CAN2_CSR14_STUFF_MASK 0x8U
#define CAN2_CSR14_STUFF 0x8U
#define CAN2_CSR14_STUFF_BIT 3
#define CAN2_CSR14_BUS_MASK 0x10U
#define CAN2_CSR14_BUS 0x10U
#define CAN2_CSR14_BUS_BIT 4
#define CAN2_CSR14_RXOK_MASK 0x20U
#define CAN2_CSR14_RXOK 0x20U
#define CAN2_CSR14_RXOK_BIT 5
#define CAN2_CSR14_TXOK_MASK 0x40U
#define CAN2_CSR14_TXOK 0x40U
#define CAN2_CSR14_TXOK_BIT 6
#define CAN2_CSR14_RFRAME_MASK 0x80U
#define CAN2_CSR14_RFRAME 0x80U
#define CAN2_CSR14_RFRAME_BIT 7
#define CAN2_CSR14_DLCW_MASK 0x200U
#define CAN2_CSR14_DLCW 0x200U
#define CAN2_CSR14_DLCW_BIT 9
#define CAN2_CSR14_FILLED_MASK 0x400U
#define CAN2_CSR14_FILLED 0x400U
#define CAN2_CSR14_FILLED_BIT 10
#define CAN2_CSR14_OVRUN_MASK 0x800U
#define CAN2_CSR14_OVRUN 0x800U
#define CAN2_CSR14_OVRUN_BIT 11

#define CAN2_SR14 (*(volatile unsigned long *)0xFFFBC49C)
#define CAN2_SR14_OFFSET 0x49C
#define CAN2_SR14_ACK_MASK 0x1U
#define CAN2_SR14_ACK 0x1U
#define CAN2_SR14_ACK_BIT 0
#define CAN2_SR14_FRAME_MASK 0x2U
#define CAN2_SR14_FRAME 0x2U
#define CAN2_SR14_FRAME_BIT 1
#define CAN2_SR14_CRC_MASK 0x4U
#define CAN2_SR14_CRC 0x4U
#define CAN2_SR14_CRC_BIT 2
#define CAN2_SR14_STUFF_MASK 0x8U
#define CAN2_SR14_STUFF 0x8U
#define CAN2_SR14_STUFF_BIT 3
#define CAN2_SR14_BUS_MASK 0x10U
#define CAN2_SR14_BUS 0x10U
#define CAN2_SR14_BUS_BIT 4
#define CAN2_SR14_RXOK_MASK 0x20U
#define CAN2_SR14_RXOK 0x20U
#define CAN2_SR14_RXOK_BIT 5
#define CAN2_SR14_TXOK_MASK 0x40U
#define CAN2_SR14_TXOK 0x40U
#define CAN2_SR14_TXOK_BIT 6
#define CAN2_SR14_RFRAME_MASK 0x80U
#define CAN2_SR14_RFRAME 0x80U
#define CAN2_SR14_RFRAME_BIT 7
#define CAN2_SR14_DLCW_MASK 0x200U
#define CAN2_SR14_DLCW 0x200U
#define CAN2_SR14_DLCW_BIT 9
#define CAN2_SR14_FILLED_MASK 0x400U
#define CAN2_SR14_FILLED 0x400U
#define CAN2_SR14_FILLED_BIT 10
#define CAN2_SR14_OVRUN_MASK 0x800U
#define CAN2_SR14_OVRUN 0x800U
#define CAN2_SR14_OVRUN_BIT 11

#define CAN2_IER14 (*(volatile unsigned long *)0xFFFBC4A0)
#define CAN2_IER14_OFFSET 0x4A0
#define CAN2_IER14_ACK_MASK 0x1U
#define CAN2_IER14_ACK 0x1U
#define CAN2_IER14_ACK_BIT 0
#define CAN2_IER14_FRAME_MASK 0x2U
#define CAN2_IER14_FRAME 0x2U
#define CAN2_IER14_FRAME_BIT 1
#define CAN2_IER14_CRC_MASK 0x4U
#define CAN2_IER14_CRC 0x4U
#define CAN2_IER14_CRC_BIT 2
#define CAN2_IER14_STUFF_MASK 0x8U
#define CAN2_IER14_STUFF 0x8U
#define CAN2_IER14_STUFF_BIT 3
#define CAN2_IER14_BUS_MASK 0x10U
#define CAN2_IER14_BUS 0x10U
#define CAN2_IER14_BUS_BIT 4
#define CAN2_IER14_RXOK_MASK 0x20U
#define CAN2_IER14_RXOK 0x20U
#define CAN2_IER14_RXOK_BIT 5
#define CAN2_IER14_TXOK_MASK 0x40U
#define CAN2_IER14_TXOK 0x40U
#define CAN2_IER14_TXOK_BIT 6
#define CAN2_IER14_RFRAME_MASK 0x80U
#define CAN2_IER14_RFRAME 0x80U
#define CAN2_IER14_RFRAME_BIT 7

#define CAN2_IDR14 (*(volatile unsigned long *)0xFFFBC4A4)
#define CAN2_IDR14_OFFSET 0x4A4
#define CAN2_IDR14_ACK_MASK 0x1U
#define CAN2_IDR14_ACK 0x1U
#define CAN2_IDR14_ACK_BIT 0
#define CAN2_IDR14_FRAME_MASK 0x2U
#define CAN2_IDR14_FRAME 0x2U
#define CAN2_IDR14_FRAME_BIT 1
#define CAN2_IDR14_CRC_MASK 0x4U
#define CAN2_IDR14_CRC 0x4U
#define CAN2_IDR14_CRC_BIT 2
#define CAN2_IDR14_STUFF_MASK 0x8U
#define CAN2_IDR14_STUFF 0x8U
#define CAN2_IDR14_STUFF_BIT 3
#define CAN2_IDR14_BUS_MASK 0x10U
#define CAN2_IDR14_BUS 0x10U
#define CAN2_IDR14_BUS_BIT 4
#define CAN2_IDR14_RXOK_MASK 0x20U
#define CAN2_IDR14_RXOK 0x20U
#define CAN2_IDR14_RXOK_BIT 5
#define CAN2_IDR14_TXOK_MASK 0x40U
#define CAN2_IDR14_TXOK 0x40U
#define CAN2_IDR14_TXOK_BIT 6
#define CAN2_IDR14_RFRAME_MASK 0x80U
#define CAN2_IDR14_RFRAME 0x80U
#define CAN2_IDR14_RFRAME_BIT 7

#define CAN2_IMR14 (*(volatile unsigned long *)0xFFFBC4A8)
#define CAN2_IMR14_OFFSET 0x4A8
#define CAN2_IMR14_ACK_MASK 0x1U
#define CAN2_IMR14_ACK 0x1U
#define CAN2_IMR14_ACK_BIT 0
#define CAN2_IMR14_FRAME_MASK 0x2U
#define CAN2_IMR14_FRAME 0x2U
#define CAN2_IMR14_FRAME_BIT 1
#define CAN2_IMR14_CRC_MASK 0x4U
#define CAN2_IMR14_CRC 0x4U
#define CAN2_IMR14_CRC_BIT 2
#define CAN2_IMR14_STUFF_MASK 0x8U
#define CAN2_IMR14_STUFF 0x8U
#define CAN2_IMR14_STUFF_BIT 3
#define CAN2_IMR14_BUS_MASK 0x10U
#define CAN2_IMR14_BUS 0x10U
#define CAN2_IMR14_BUS_BIT 4
#define CAN2_IMR14_RXOK_MASK 0x20U
#define CAN2_IMR14_RXOK 0x20U
#define CAN2_IMR14_RXOK_BIT 5
#define CAN2_IMR14_TXOK_MASK 0x40U
#define CAN2_IMR14_TXOK 0x40U
#define CAN2_IMR14_TXOK_BIT 6
#define CAN2_IMR14_RFRAME_MASK 0x80U
#define CAN2_IMR14_RFRAME 0x80U
#define CAN2_IMR14_RFRAME_BIT 7

#define CAN2_DRA15 (*(volatile unsigned long *)0xFFFBC4C0)
#define CAN2_DRA15_OFFSET 0x4C0
#define CAN2_DRA15_DATA0_MASK 0xFFU
#define CAN2_DRA15_DATA0_BIT 0
#define CAN2_DRA15_DATA1_MASK 0xFF00U
#define CAN2_DRA15_DATA1_BIT 8
#define CAN2_DRA15_DATA2_MASK 0xFF0000U
#define CAN2_DRA15_DATA2_BIT 16
#define CAN2_DRA15_DATA3_MASK 0xFF000000U
#define CAN2_DRA15_DATA3_BIT 24

#define CAN2_DRB15 (*(volatile unsigned long *)0xFFFBC4C4)
#define CAN2_DRB15_OFFSET 0x4C4
#define CAN2_DRB15_DATA4_MASK 0xFFU
#define CAN2_DRB15_DATA4_BIT 0
#define CAN2_DRB15_DATA5_MASK 0xFF00U
#define CAN2_DRB15_DATA5_BIT 8
#define CAN2_DRB15_DATA6_MASK 0xFF0000U
#define CAN2_DRB15_DATA6_BIT 16
#define CAN2_DRB15_DATA7_MASK 0xFF000000U
#define CAN2_DRB15_DATA7_BIT 24

#define CAN2_MSK15 (*(volatile unsigned long *)0xFFFBC4C8)
#define CAN2_MSK15_OFFSET 0x4C8
#define CAN2_MSK15_MASK_MASK 0x1FFFFFFFU
#define CAN2_MSK15_MASK_BIT 0
#define CAN2_MSK15_MRB_MASK 0x60000000U
#define CAN2_MSK15_MRB_BIT 29
#define CAN2_MSK15_MRTR_MASK 0x80000000U
#define CAN2_MSK15_MRTR 0x80000000U
#define CAN2_MSK15_MRTR_BIT 31

#define CAN2_IR15 (*(volatile unsigned long *)0xFFFBC4CC)
#define CAN2_IR15_OFFSET 0x4CC
#define CAN2_IR15_ID_MASK 0x1FFFFFFFU
#define CAN2_IR15_ID_BIT 0
#define CAN2_IR15_RB_MASK 0x60000000U
#define CAN2_IR15_RB_BIT 29
#define CAN2_IR15_RTR_MASK 0x80000000U
#define CAN2_IR15_RTR 0x80000000U
#define CAN2_IR15_RTR_BIT 31

#define CAN2_CR15 (*(volatile unsigned long *)0xFFFBC4D0)
#define CAN2_CR15_OFFSET 0x4D0
#define CAN2_CR15_DLC_MASK 0xFU
#define CAN2_CR15_DLC_BIT 0
#define CAN2_CR15_IDE_MASK 0x10U
#define CAN2_CR15_IDE 0x10U
#define CAN2_CR15_IDE_BIT 4
#define CAN2_CR15_RPLYV_MASK 0x20U
#define CAN2_CR15_RPLYV 0x20U
#define CAN2_CR15_RPLYV_BIT 5
#define CAN2_CR15_PCB_MASK 0x40U
#define CAN2_CR15_PCB 0x40U
#define CAN2_CR15_PCB_BIT 6
#define CAN2_CR15_CHANEN_MASK 0x80U
#define CAN2_CR15_CHANEN 0x80U
#define CAN2_CR15_CHANEN_BIT 7
#define CAN2_CR15_OVERWRITE_MASK 0x100U
#define CAN2_CR15_OVERWRITE 0x100U
#define CAN2_CR15_OVERWRITE_BIT 8

#define CAN2_CR15 (*(volatile unsigned long *)0xFFFBC4D4)
#define CAN2_CR15_OFFSET 0x4D4
#define CAN2_CR15_STAMP_MASK 0x0U
#define CAN2_CR15_STAMP_BIT 0

#define CAN2_CSR15 (*(volatile unsigned long *)0xFFFBC4D8)
#define CAN2_CSR15_OFFSET 0x4D8
#define CAN2_CSR15_ACK_MASK 0x1U
#define CAN2_CSR15_ACK 0x1U
#define CAN2_CSR15_ACK_BIT 0
#define CAN2_CSR15_FRAME_MASK 0x2U
#define CAN2_CSR15_FRAME 0x2U
#define CAN2_CSR15_FRAME_BIT 1
#define CAN2_CSR15_CRC_MASK 0x4U
#define CAN2_CSR15_CRC 0x4U
#define CAN2_CSR15_CRC_BIT 2
#define CAN2_CSR15_STUFF_MASK 0x8U
#define CAN2_CSR15_STUFF 0x8U
#define CAN2_CSR15_STUFF_BIT 3
#define CAN2_CSR15_BUS_MASK 0x10U
#define CAN2_CSR15_BUS 0x10U
#define CAN2_CSR15_BUS_BIT 4
#define CAN2_CSR15_RXOK_MASK 0x20U
#define CAN2_CSR15_RXOK 0x20U
#define CAN2_CSR15_RXOK_BIT 5
#define CAN2_CSR15_TXOK_MASK 0x40U
#define CAN2_CSR15_TXOK 0x40U
#define CAN2_CSR15_TXOK_BIT 6
#define CAN2_CSR15_RFRAME_MASK 0x80U
#define CAN2_CSR15_RFRAME 0x80U
#define CAN2_CSR15_RFRAME_BIT 7
#define CAN2_CSR15_DLCW_MASK 0x200U
#define CAN2_CSR15_DLCW 0x200U
#define CAN2_CSR15_DLCW_BIT 9
#define CAN2_CSR15_FILLED_MASK 0x400U
#define CAN2_CSR15_FILLED 0x400U
#define CAN2_CSR15_FILLED_BIT 10
#define CAN2_CSR15_OVRUN_MASK 0x800U
#define CAN2_CSR15_OVRUN 0x800U
#define CAN2_CSR15_OVRUN_BIT 11

#define CAN2_SR15 (*(volatile unsigned long *)0xFFFBC4DC)
#define CAN2_SR15_OFFSET 0x4DC
#define CAN2_SR15_ACK_MASK 0x1U
#define CAN2_SR15_ACK 0x1U
#define CAN2_SR15_ACK_BIT 0
#define CAN2_SR15_FRAME_MASK 0x2U
#define CAN2_SR15_FRAME 0x2U
#define CAN2_SR15_FRAME_BIT 1
#define CAN2_SR15_CRC_MASK 0x4U
#define CAN2_SR15_CRC 0x4U
#define CAN2_SR15_CRC_BIT 2
#define CAN2_SR15_STUFF_MASK 0x8U
#define CAN2_SR15_STUFF 0x8U
#define CAN2_SR15_STUFF_BIT 3
#define CAN2_SR15_BUS_MASK 0x10U
#define CAN2_SR15_BUS 0x10U
#define CAN2_SR15_BUS_BIT 4
#define CAN2_SR15_RXOK_MASK 0x20U
#define CAN2_SR15_RXOK 0x20U
#define CAN2_SR15_RXOK_BIT 5
#define CAN2_SR15_TXOK_MASK 0x40U
#define CAN2_SR15_TXOK 0x40U
#define CAN2_SR15_TXOK_BIT 6
#define CAN2_SR15_RFRAME_MASK 0x80U
#define CAN2_SR15_RFRAME 0x80U
#define CAN2_SR15_RFRAME_BIT 7
#define CAN2_SR15_DLCW_MASK 0x200U
#define CAN2_SR15_DLCW 0x200U
#define CAN2_SR15_DLCW_BIT 9
#define CAN2_SR15_FILLED_MASK 0x400U
#define CAN2_SR15_FILLED 0x400U
#define CAN2_SR15_FILLED_BIT 10
#define CAN2_SR15_OVRUN_MASK 0x800U
#define CAN2_SR15_OVRUN 0x800U
#define CAN2_SR15_OVRUN_BIT 11

#define CAN2_IER15 (*(volatile unsigned long *)0xFFFBC4E0)
#define CAN2_IER15_OFFSET 0x4E0
#define CAN2_IER15_ACK_MASK 0x1U
#define CAN2_IER15_ACK 0x1U
#define CAN2_IER15_ACK_BIT 0
#define CAN2_IER15_FRAME_MASK 0x2U
#define CAN2_IER15_FRAME 0x2U
#define CAN2_IER15_FRAME_BIT 1
#define CAN2_IER15_CRC_MASK 0x4U
#define CAN2_IER15_CRC 0x4U
#define CAN2_IER15_CRC_BIT 2
#define CAN2_IER15_STUFF_MASK 0x8U
#define CAN2_IER15_STUFF 0x8U
#define CAN2_IER15_STUFF_BIT 3
#define CAN2_IER15_BUS_MASK 0x10U
#define CAN2_IER15_BUS 0x10U
#define CAN2_IER15_BUS_BIT 4
#define CAN2_IER15_RXOK_MASK 0x20U
#define CAN2_IER15_RXOK 0x20U
#define CAN2_IER15_RXOK_BIT 5
#define CAN2_IER15_TXOK_MASK 0x40U
#define CAN2_IER15_TXOK 0x40U
#define CAN2_IER15_TXOK_BIT 6
#define CAN2_IER15_RFRAME_MASK 0x80U
#define CAN2_IER15_RFRAME 0x80U
#define CAN2_IER15_RFRAME_BIT 7

#define CAN2_IDR15 (*(volatile unsigned long *)0xFFFBC4E4)
#define CAN2_IDR15_OFFSET 0x4E4
#define CAN2_IDR15_ACK_MASK 0x1U
#define CAN2_IDR15_ACK 0x1U
#define CAN2_IDR15_ACK_BIT 0
#define CAN2_IDR15_FRAME_MASK 0x2U
#define CAN2_IDR15_FRAME 0x2U
#define CAN2_IDR15_FRAME_BIT 1
#define CAN2_IDR15_CRC_MASK 0x4U
#define CAN2_IDR15_CRC 0x4U
#define CAN2_IDR15_CRC_BIT 2
#define CAN2_IDR15_STUFF_MASK 0x8U
#define CAN2_IDR15_STUFF 0x8U
#define CAN2_IDR15_STUFF_BIT 3
#define CAN2_IDR15_BUS_MASK 0x10U
#define CAN2_IDR15_BUS 0x10U
#define CAN2_IDR15_BUS_BIT 4
#define CAN2_IDR15_RXOK_MASK 0x20U
#define CAN2_IDR15_RXOK 0x20U
#define CAN2_IDR15_RXOK_BIT 5
#define CAN2_IDR15_TXOK_MASK 0x40U
#define CAN2_IDR15_TXOK 0x40U
#define CAN2_IDR15_TXOK_BIT 6
#define CAN2_IDR15_RFRAME_MASK 0x80U
#define CAN2_IDR15_RFRAME 0x80U
#define CAN2_IDR15_RFRAME_BIT 7

#define CAN2_IMR15 (*(volatile unsigned long *)0xFFFBC4E8)
#define CAN2_IMR15_OFFSET 0x4E8
#define CAN2_IMR15_ACK_MASK 0x1U
#define CAN2_IMR15_ACK 0x1U
#define CAN2_IMR15_ACK_BIT 0
#define CAN2_IMR15_FRAME_MASK 0x2U
#define CAN2_IMR15_FRAME 0x2U
#define CAN2_IMR15_FRAME_BIT 1
#define CAN2_IMR15_CRC_MASK 0x4U
#define CAN2_IMR15_CRC 0x4U
#define CAN2_IMR15_CRC_BIT 2
#define CAN2_IMR15_STUFF_MASK 0x8U
#define CAN2_IMR15_STUFF 0x8U
#define CAN2_IMR15_STUFF_BIT 3
#define CAN2_IMR15_BUS_MASK 0x10U
#define CAN2_IMR15_BUS 0x10U
#define CAN2_IMR15_BUS_BIT 4
#define CAN2_IMR15_RXOK_MASK 0x20U
#define CAN2_IMR15_RXOK 0x20U
#define CAN2_IMR15_RXOK_BIT 5
#define CAN2_IMR15_TXOK_MASK 0x40U
#define CAN2_IMR15_TXOK 0x40U
#define CAN2_IMR15_TXOK_BIT 6
#define CAN2_IMR15_RFRAME_MASK 0x80U
#define CAN2_IMR15_RFRAME 0x80U
#define CAN2_IMR15_RFRAME_BIT 7

#define CAN2_DRA16 (*(volatile unsigned long *)0xFFFBC500)
#define CAN2_DRA16_OFFSET 0x500
#define CAN2_DRA16_DATA0_MASK 0xFFU
#define CAN2_DRA16_DATA0_BIT 0
#define CAN2_DRA16_DATA1_MASK 0xFF00U
#define CAN2_DRA16_DATA1_BIT 8
#define CAN2_DRA16_DATA2_MASK 0xFF0000U
#define CAN2_DRA16_DATA2_BIT 16
#define CAN2_DRA16_DATA3_MASK 0xFF000000U
#define CAN2_DRA16_DATA3_BIT 24

#define CAN2_DRB16 (*(volatile unsigned long *)0xFFFBC504)
#define CAN2_DRB16_OFFSET 0x504
#define CAN2_DRB16_DATA4_MASK 0xFFU
#define CAN2_DRB16_DATA4_BIT 0
#define CAN2_DRB16_DATA5_MASK 0xFF00U
#define CAN2_DRB16_DATA5_BIT 8
#define CAN2_DRB16_DATA6_MASK 0xFF0000U
#define CAN2_DRB16_DATA6_BIT 16
#define CAN2_DRB16_DATA7_MASK 0xFF000000U
#define CAN2_DRB16_DATA7_BIT 24

#define CAN2_MSK16 (*(volatile unsigned long *)0xFFFBC508)
#define CAN2_MSK16_OFFSET 0x508
#define CAN2_MSK16_MASK_MASK 0x1FFFFFFFU
#define CAN2_MSK16_MASK_BIT 0
#define CAN2_MSK16_MRB_MASK 0x60000000U
#define CAN2_MSK16_MRB_BIT 29
#define CAN2_MSK16_MRTR_MASK 0x80000000U
#define CAN2_MSK16_MRTR 0x80000000U
#define CAN2_MSK16_MRTR_BIT 31

#define CAN2_IR16 (*(volatile unsigned long *)0xFFFBC50C)
#define CAN2_IR16_OFFSET 0x50C
#define CAN2_IR16_ID_MASK 0x1FFFFFFFU
#define CAN2_IR16_ID_BIT 0
#define CAN2_IR16_RB_MASK 0x60000000U
#define CAN2_IR16_RB_BIT 29
#define CAN2_IR16_RTR_MASK 0x80000000U
#define CAN2_IR16_RTR 0x80000000U
#define CAN2_IR16_RTR_BIT 31

#define CAN2_CR16 (*(volatile unsigned long *)0xFFFBC510)
#define CAN2_CR16_OFFSET 0x510
#define CAN2_CR16_DLC_MASK 0xFU
#define CAN2_CR16_DLC_BIT 0
#define CAN2_CR16_IDE_MASK 0x10U
#define CAN2_CR16_IDE 0x10U
#define CAN2_CR16_IDE_BIT 4
#define CAN2_CR16_RPLYV_MASK 0x20U
#define CAN2_CR16_RPLYV 0x20U
#define CAN2_CR16_RPLYV_BIT 5
#define CAN2_CR16_PCB_MASK 0x40U
#define CAN2_CR16_PCB 0x40U
#define CAN2_CR16_PCB_BIT 6
#define CAN2_CR16_CHANEN_MASK 0x80U
#define CAN2_CR16_CHANEN 0x80U
#define CAN2_CR16_CHANEN_BIT 7
#define CAN2_CR16_OVERWRITE_MASK 0x100U
#define CAN2_CR16_OVERWRITE 0x100U
#define CAN2_CR16_OVERWRITE_BIT 8

#define CAN2_CR16 (*(volatile unsigned long *)0xFFFBC514)
#define CAN2_CR16_OFFSET 0x514
#define CAN2_CR16_STAMP_MASK 0x0U
#define CAN2_CR16_STAMP_BIT 0

#define CAN2_CSR16 (*(volatile unsigned long *)0xFFFBC518)
#define CAN2_CSR16_OFFSET 0x518
#define CAN2_CSR16_ACK_MASK 0x1U
#define CAN2_CSR16_ACK 0x1U
#define CAN2_CSR16_ACK_BIT 0
#define CAN2_CSR16_FRAME_MASK 0x2U
#define CAN2_CSR16_FRAME 0x2U
#define CAN2_CSR16_FRAME_BIT 1
#define CAN2_CSR16_CRC_MASK 0x4U
#define CAN2_CSR16_CRC 0x4U
#define CAN2_CSR16_CRC_BIT 2
#define CAN2_CSR16_STUFF_MASK 0x8U
#define CAN2_CSR16_STUFF 0x8U
#define CAN2_CSR16_STUFF_BIT 3
#define CAN2_CSR16_BUS_MASK 0x10U
#define CAN2_CSR16_BUS 0x10U
#define CAN2_CSR16_BUS_BIT 4
#define CAN2_CSR16_RXOK_MASK 0x20U
#define CAN2_CSR16_RXOK 0x20U
#define CAN2_CSR16_RXOK_BIT 5
#define CAN2_CSR16_TXOK_MASK 0x40U
#define CAN2_CSR16_TXOK 0x40U
#define CAN2_CSR16_TXOK_BIT 6
#define CAN2_CSR16_RFRAME_MASK 0x80U
#define CAN2_CSR16_RFRAME 0x80U
#define CAN2_CSR16_RFRAME_BIT 7
#define CAN2_CSR16_DLCW_MASK 0x200U
#define CAN2_CSR16_DLCW 0x200U
#define CAN2_CSR16_DLCW_BIT 9
#define CAN2_CSR16_FILLED_MASK 0x400U
#define CAN2_CSR16_FILLED 0x400U
#define CAN2_CSR16_FILLED_BIT 10
#define CAN2_CSR16_OVRUN_MASK 0x800U
#define CAN2_CSR16_OVRUN 0x800U
#define CAN2_CSR16_OVRUN_BIT 11

#define CAN2_SR16 (*(volatile unsigned long *)0xFFFBC51C)
#define CAN2_SR16_OFFSET 0x51C
#define CAN2_SR16_ACK_MASK 0x1U
#define CAN2_SR16_ACK 0x1U
#define CAN2_SR16_ACK_BIT 0
#define CAN2_SR16_FRAME_MASK 0x2U
#define CAN2_SR16_FRAME 0x2U
#define CAN2_SR16_FRAME_BIT 1
#define CAN2_SR16_CRC_MASK 0x4U
#define CAN2_SR16_CRC 0x4U
#define CAN2_SR16_CRC_BIT 2
#define CAN2_SR16_STUFF_MASK 0x8U
#define CAN2_SR16_STUFF 0x8U
#define CAN2_SR16_STUFF_BIT 3
#define CAN2_SR16_BUS_MASK 0x10U
#define CAN2_SR16_BUS 0x10U
#define CAN2_SR16_BUS_BIT 4
#define CAN2_SR16_RXOK_MASK 0x20U
#define CAN2_SR16_RXOK 0x20U
#define CAN2_SR16_RXOK_BIT 5
#define CAN2_SR16_TXOK_MASK 0x40U
#define CAN2_SR16_TXOK 0x40U
#define CAN2_SR16_TXOK_BIT 6
#define CAN2_SR16_RFRAME_MASK 0x80U
#define CAN2_SR16_RFRAME 0x80U
#define CAN2_SR16_RFRAME_BIT 7
#define CAN2_SR16_DLCW_MASK 0x200U
#define CAN2_SR16_DLCW 0x200U
#define CAN2_SR16_DLCW_BIT 9
#define CAN2_SR16_FILLED_MASK 0x400U
#define CAN2_SR16_FILLED 0x400U
#define CAN2_SR16_FILLED_BIT 10
#define CAN2_SR16_OVRUN_MASK 0x800U
#define CAN2_SR16_OVRUN 0x800U
#define CAN2_SR16_OVRUN_BIT 11

#define CAN2_IER16 (*(volatile unsigned long *)0xFFFBC520)
#define CAN2_IER16_OFFSET 0x520
#define CAN2_IER16_ACK_MASK 0x1U
#define CAN2_IER16_ACK 0x1U
#define CAN2_IER16_ACK_BIT 0
#define CAN2_IER16_FRAME_MASK 0x2U
#define CAN2_IER16_FRAME 0x2U
#define CAN2_IER16_FRAME_BIT 1
#define CAN2_IER16_CRC_MASK 0x4U
#define CAN2_IER16_CRC 0x4U
#define CAN2_IER16_CRC_BIT 2
#define CAN2_IER16_STUFF_MASK 0x8U
#define CAN2_IER16_STUFF 0x8U
#define CAN2_IER16_STUFF_BIT 3
#define CAN2_IER16_BUS_MASK 0x10U
#define CAN2_IER16_BUS 0x10U
#define CAN2_IER16_BUS_BIT 4
#define CAN2_IER16_RXOK_MASK 0x20U
#define CAN2_IER16_RXOK 0x20U
#define CAN2_IER16_RXOK_BIT 5
#define CAN2_IER16_TXOK_MASK 0x40U
#define CAN2_IER16_TXOK 0x40U
#define CAN2_IER16_TXOK_BIT 6
#define CAN2_IER16_RFRAME_MASK 0x80U
#define CAN2_IER16_RFRAME 0x80U
#define CAN2_IER16_RFRAME_BIT 7

#define CAN2_IDR16 (*(volatile unsigned long *)0xFFFBC524)
#define CAN2_IDR16_OFFSET 0x524
#define CAN2_IDR16_ACK_MASK 0x1U
#define CAN2_IDR16_ACK 0x1U
#define CAN2_IDR16_ACK_BIT 0
#define CAN2_IDR16_FRAME_MASK 0x2U
#define CAN2_IDR16_FRAME 0x2U
#define CAN2_IDR16_FRAME_BIT 1
#define CAN2_IDR16_CRC_MASK 0x4U
#define CAN2_IDR16_CRC 0x4U
#define CAN2_IDR16_CRC_BIT 2
#define CAN2_IDR16_STUFF_MASK 0x8U
#define CAN2_IDR16_STUFF 0x8U
#define CAN2_IDR16_STUFF_BIT 3
#define CAN2_IDR16_BUS_MASK 0x10U
#define CAN2_IDR16_BUS 0x10U
#define CAN2_IDR16_BUS_BIT 4
#define CAN2_IDR16_RXOK_MASK 0x20U
#define CAN2_IDR16_RXOK 0x20U
#define CAN2_IDR16_RXOK_BIT 5
#define CAN2_IDR16_TXOK_MASK 0x40U
#define CAN2_IDR16_TXOK 0x40U
#define CAN2_IDR16_TXOK_BIT 6
#define CAN2_IDR16_RFRAME_MASK 0x80U
#define CAN2_IDR16_RFRAME 0x80U
#define CAN2_IDR16_RFRAME_BIT 7

#define CAN2_IMR16 (*(volatile unsigned long *)0xFFFBC528)
#define CAN2_IMR16_OFFSET 0x528
#define CAN2_IMR16_ACK_MASK 0x1U
#define CAN2_IMR16_ACK 0x1U
#define CAN2_IMR16_ACK_BIT 0
#define CAN2_IMR16_FRAME_MASK 0x2U
#define CAN2_IMR16_FRAME 0x2U
#define CAN2_IMR16_FRAME_BIT 1
#define CAN2_IMR16_CRC_MASK 0x4U
#define CAN2_IMR16_CRC 0x4U
#define CAN2_IMR16_CRC_BIT 2
#define CAN2_IMR16_STUFF_MASK 0x8U
#define CAN2_IMR16_STUFF 0x8U
#define CAN2_IMR16_STUFF_BIT 3
#define CAN2_IMR16_BUS_MASK 0x10U
#define CAN2_IMR16_BUS 0x10U
#define CAN2_IMR16_BUS_BIT 4
#define CAN2_IMR16_RXOK_MASK 0x20U
#define CAN2_IMR16_RXOK 0x20U
#define CAN2_IMR16_RXOK_BIT 5
#define CAN2_IMR16_TXOK_MASK 0x40U
#define CAN2_IMR16_TXOK 0x40U
#define CAN2_IMR16_TXOK_BIT 6
#define CAN2_IMR16_RFRAME_MASK 0x80U
#define CAN2_IMR16_RFRAME 0x80U
#define CAN2_IMR16_RFRAME_BIT 7

#define CAN2_DRA17 (*(volatile unsigned long *)0xFFFBC540)
#define CAN2_DRA17_OFFSET 0x540
#define CAN2_DRA17_DATA0_MASK 0xFFU
#define CAN2_DRA17_DATA0_BIT 0
#define CAN2_DRA17_DATA1_MASK 0xFF00U
#define CAN2_DRA17_DATA1_BIT 8
#define CAN2_DRA17_DATA2_MASK 0xFF0000U
#define CAN2_DRA17_DATA2_BIT 16
#define CAN2_DRA17_DATA3_MASK 0xFF000000U
#define CAN2_DRA17_DATA3_BIT 24

#define CAN2_DRB17 (*(volatile unsigned long *)0xFFFBC544)
#define CAN2_DRB17_OFFSET 0x544
#define CAN2_DRB17_DATA4_MASK 0xFFU
#define CAN2_DRB17_DATA4_BIT 0
#define CAN2_DRB17_DATA5_MASK 0xFF00U
#define CAN2_DRB17_DATA5_BIT 8
#define CAN2_DRB17_DATA6_MASK 0xFF0000U
#define CAN2_DRB17_DATA6_BIT 16
#define CAN2_DRB17_DATA7_MASK 0xFF000000U
#define CAN2_DRB17_DATA7_BIT 24

#define CAN2_MSK17 (*(volatile unsigned long *)0xFFFBC548)
#define CAN2_MSK17_OFFSET 0x548
#define CAN2_MSK17_MASK_MASK 0x1FFFFFFFU
#define CAN2_MSK17_MASK_BIT 0
#define CAN2_MSK17_MRB_MASK 0x60000000U
#define CAN2_MSK17_MRB_BIT 29
#define CAN2_MSK17_MRTR_MASK 0x80000000U
#define CAN2_MSK17_MRTR 0x80000000U
#define CAN2_MSK17_MRTR_BIT 31

#define CAN2_IR17 (*(volatile unsigned long *)0xFFFBC54C)
#define CAN2_IR17_OFFSET 0x54C
#define CAN2_IR17_ID_MASK 0x1FFFFFFFU
#define CAN2_IR17_ID_BIT 0
#define CAN2_IR17_RB_MASK 0x60000000U
#define CAN2_IR17_RB_BIT 29
#define CAN2_IR17_RTR_MASK 0x80000000U
#define CAN2_IR17_RTR 0x80000000U
#define CAN2_IR17_RTR_BIT 31

#define CAN2_CR17 (*(volatile unsigned long *)0xFFFBC550)
#define CAN2_CR17_OFFSET 0x550
#define CAN2_CR17_DLC_MASK 0xFU
#define CAN2_CR17_DLC_BIT 0
#define CAN2_CR17_IDE_MASK 0x10U
#define CAN2_CR17_IDE 0x10U
#define CAN2_CR17_IDE_BIT 4
#define CAN2_CR17_RPLYV_MASK 0x20U
#define CAN2_CR17_RPLYV 0x20U
#define CAN2_CR17_RPLYV_BIT 5
#define CAN2_CR17_PCB_MASK 0x40U
#define CAN2_CR17_PCB 0x40U
#define CAN2_CR17_PCB_BIT 6
#define CAN2_CR17_CHANEN_MASK 0x80U
#define CAN2_CR17_CHANEN 0x80U
#define CAN2_CR17_CHANEN_BIT 7
#define CAN2_CR17_OVERWRITE_MASK 0x100U
#define CAN2_CR17_OVERWRITE 0x100U
#define CAN2_CR17_OVERWRITE_BIT 8

#define CAN2_CR17 (*(volatile unsigned long *)0xFFFBC554)
#define CAN2_CR17_OFFSET 0x554
#define CAN2_CR17_STAMP_MASK 0x0U
#define CAN2_CR17_STAMP_BIT 0

#define CAN2_CSR17 (*(volatile unsigned long *)0xFFFBC558)
#define CAN2_CSR17_OFFSET 0x558
#define CAN2_CSR17_ACK_MASK 0x1U
#define CAN2_CSR17_ACK 0x1U
#define CAN2_CSR17_ACK_BIT 0
#define CAN2_CSR17_FRAME_MASK 0x2U
#define CAN2_CSR17_FRAME 0x2U
#define CAN2_CSR17_FRAME_BIT 1
#define CAN2_CSR17_CRC_MASK 0x4U
#define CAN2_CSR17_CRC 0x4U
#define CAN2_CSR17_CRC_BIT 2
#define CAN2_CSR17_STUFF_MASK 0x8U
#define CAN2_CSR17_STUFF 0x8U
#define CAN2_CSR17_STUFF_BIT 3
#define CAN2_CSR17_BUS_MASK 0x10U
#define CAN2_CSR17_BUS 0x10U
#define CAN2_CSR17_BUS_BIT 4
#define CAN2_CSR17_RXOK_MASK 0x20U
#define CAN2_CSR17_RXOK 0x20U
#define CAN2_CSR17_RXOK_BIT 5
#define CAN2_CSR17_TXOK_MASK 0x40U
#define CAN2_CSR17_TXOK 0x40U
#define CAN2_CSR17_TXOK_BIT 6
#define CAN2_CSR17_RFRAME_MASK 0x80U
#define CAN2_CSR17_RFRAME 0x80U
#define CAN2_CSR17_RFRAME_BIT 7
#define CAN2_CSR17_DLCW_MASK 0x200U
#define CAN2_CSR17_DLCW 0x200U
#define CAN2_CSR17_DLCW_BIT 9
#define CAN2_CSR17_FILLED_MASK 0x400U
#define CAN2_CSR17_FILLED 0x400U
#define CAN2_CSR17_FILLED_BIT 10
#define CAN2_CSR17_OVRUN_MASK 0x800U
#define CAN2_CSR17_OVRUN 0x800U
#define CAN2_CSR17_OVRUN_BIT 11

#define CAN2_SR17 (*(volatile unsigned long *)0xFFFBC55C)
#define CAN2_SR17_OFFSET 0x55C
#define CAN2_SR17_ACK_MASK 0x1U
#define CAN2_SR17_ACK 0x1U
#define CAN2_SR17_ACK_BIT 0
#define CAN2_SR17_FRAME_MASK 0x2U
#define CAN2_SR17_FRAME 0x2U
#define CAN2_SR17_FRAME_BIT 1
#define CAN2_SR17_CRC_MASK 0x4U
#define CAN2_SR17_CRC 0x4U
#define CAN2_SR17_CRC_BIT 2
#define CAN2_SR17_STUFF_MASK 0x8U
#define CAN2_SR17_STUFF 0x8U
#define CAN2_SR17_STUFF_BIT 3
#define CAN2_SR17_BUS_MASK 0x10U
#define CAN2_SR17_BUS 0x10U
#define CAN2_SR17_BUS_BIT 4
#define CAN2_SR17_RXOK_MASK 0x20U
#define CAN2_SR17_RXOK 0x20U
#define CAN2_SR17_RXOK_BIT 5
#define CAN2_SR17_TXOK_MASK 0x40U
#define CAN2_SR17_TXOK 0x40U
#define CAN2_SR17_TXOK_BIT 6
#define CAN2_SR17_RFRAME_MASK 0x80U
#define CAN2_SR17_RFRAME 0x80U
#define CAN2_SR17_RFRAME_BIT 7
#define CAN2_SR17_DLCW_MASK 0x200U
#define CAN2_SR17_DLCW 0x200U
#define CAN2_SR17_DLCW_BIT 9
#define CAN2_SR17_FILLED_MASK 0x400U
#define CAN2_SR17_FILLED 0x400U
#define CAN2_SR17_FILLED_BIT 10
#define CAN2_SR17_OVRUN_MASK 0x800U
#define CAN2_SR17_OVRUN 0x800U
#define CAN2_SR17_OVRUN_BIT 11

#define CAN2_IER17 (*(volatile unsigned long *)0xFFFBC560)
#define CAN2_IER17_OFFSET 0x560
#define CAN2_IER17_ACK_MASK 0x1U
#define CAN2_IER17_ACK 0x1U
#define CAN2_IER17_ACK_BIT 0
#define CAN2_IER17_FRAME_MASK 0x2U
#define CAN2_IER17_FRAME 0x2U
#define CAN2_IER17_FRAME_BIT 1
#define CAN2_IER17_CRC_MASK 0x4U
#define CAN2_IER17_CRC 0x4U
#define CAN2_IER17_CRC_BIT 2
#define CAN2_IER17_STUFF_MASK 0x8U
#define CAN2_IER17_STUFF 0x8U
#define CAN2_IER17_STUFF_BIT 3
#define CAN2_IER17_BUS_MASK 0x10U
#define CAN2_IER17_BUS 0x10U
#define CAN2_IER17_BUS_BIT 4
#define CAN2_IER17_RXOK_MASK 0x20U
#define CAN2_IER17_RXOK 0x20U
#define CAN2_IER17_RXOK_BIT 5
#define CAN2_IER17_TXOK_MASK 0x40U
#define CAN2_IER17_TXOK 0x40U
#define CAN2_IER17_TXOK_BIT 6
#define CAN2_IER17_RFRAME_MASK 0x80U
#define CAN2_IER17_RFRAME 0x80U
#define CAN2_IER17_RFRAME_BIT 7

#define CAN2_IDR17 (*(volatile unsigned long *)0xFFFBC564)
#define CAN2_IDR17_OFFSET 0x564
#define CAN2_IDR17_ACK_MASK 0x1U
#define CAN2_IDR17_ACK 0x1U
#define CAN2_IDR17_ACK_BIT 0
#define CAN2_IDR17_FRAME_MASK 0x2U
#define CAN2_IDR17_FRAME 0x2U
#define CAN2_IDR17_FRAME_BIT 1
#define CAN2_IDR17_CRC_MASK 0x4U
#define CAN2_IDR17_CRC 0x4U
#define CAN2_IDR17_CRC_BIT 2
#define CAN2_IDR17_STUFF_MASK 0x8U
#define CAN2_IDR17_STUFF 0x8U
#define CAN2_IDR17_STUFF_BIT 3
#define CAN2_IDR17_BUS_MASK 0x10U
#define CAN2_IDR17_BUS 0x10U
#define CAN2_IDR17_BUS_BIT 4
#define CAN2_IDR17_RXOK_MASK 0x20U
#define CAN2_IDR17_RXOK 0x20U
#define CAN2_IDR17_RXOK_BIT 5
#define CAN2_IDR17_TXOK_MASK 0x40U
#define CAN2_IDR17_TXOK 0x40U
#define CAN2_IDR17_TXOK_BIT 6
#define CAN2_IDR17_RFRAME_MASK 0x80U
#define CAN2_IDR17_RFRAME 0x80U
#define CAN2_IDR17_RFRAME_BIT 7

#define CAN2_IMR17 (*(volatile unsigned long *)0xFFFBC568)
#define CAN2_IMR17_OFFSET 0x568
#define CAN2_IMR17_ACK_MASK 0x1U
#define CAN2_IMR17_ACK 0x1U
#define CAN2_IMR17_ACK_BIT 0
#define CAN2_IMR17_FRAME_MASK 0x2U
#define CAN2_IMR17_FRAME 0x2U
#define CAN2_IMR17_FRAME_BIT 1
#define CAN2_IMR17_CRC_MASK 0x4U
#define CAN2_IMR17_CRC 0x4U
#define CAN2_IMR17_CRC_BIT 2
#define CAN2_IMR17_STUFF_MASK 0x8U
#define CAN2_IMR17_STUFF 0x8U
#define CAN2_IMR17_STUFF_BIT 3
#define CAN2_IMR17_BUS_MASK 0x10U
#define CAN2_IMR17_BUS 0x10U
#define CAN2_IMR17_BUS_BIT 4
#define CAN2_IMR17_RXOK_MASK 0x20U
#define CAN2_IMR17_RXOK 0x20U
#define CAN2_IMR17_RXOK_BIT 5
#define CAN2_IMR17_TXOK_MASK 0x40U
#define CAN2_IMR17_TXOK 0x40U
#define CAN2_IMR17_TXOK_BIT 6
#define CAN2_IMR17_RFRAME_MASK 0x80U
#define CAN2_IMR17_RFRAME 0x80U
#define CAN2_IMR17_RFRAME_BIT 7

#define CAN2_DRA18 (*(volatile unsigned long *)0xFFFBC580)
#define CAN2_DRA18_OFFSET 0x580
#define CAN2_DRA18_DATA0_MASK 0xFFU
#define CAN2_DRA18_DATA0_BIT 0
#define CAN2_DRA18_DATA1_MASK 0xFF00U
#define CAN2_DRA18_DATA1_BIT 8
#define CAN2_DRA18_DATA2_MASK 0xFF0000U
#define CAN2_DRA18_DATA2_BIT 16
#define CAN2_DRA18_DATA3_MASK 0xFF000000U
#define CAN2_DRA18_DATA3_BIT 24

#define CAN2_DRB18 (*(volatile unsigned long *)0xFFFBC584)
#define CAN2_DRB18_OFFSET 0x584
#define CAN2_DRB18_DATA4_MASK 0xFFU
#define CAN2_DRB18_DATA4_BIT 0
#define CAN2_DRB18_DATA5_MASK 0xFF00U
#define CAN2_DRB18_DATA5_BIT 8
#define CAN2_DRB18_DATA6_MASK 0xFF0000U
#define CAN2_DRB18_DATA6_BIT 16
#define CAN2_DRB18_DATA7_MASK 0xFF000000U
#define CAN2_DRB18_DATA7_BIT 24

#define CAN2_MSK18 (*(volatile unsigned long *)0xFFFBC588)
#define CAN2_MSK18_OFFSET 0x588
#define CAN2_MSK18_MASK_MASK 0x1FFFFFFFU
#define CAN2_MSK18_MASK_BIT 0
#define CAN2_MSK18_MRB_MASK 0x60000000U
#define CAN2_MSK18_MRB_BIT 29
#define CAN2_MSK18_MRTR_MASK 0x80000000U
#define CAN2_MSK18_MRTR 0x80000000U
#define CAN2_MSK18_MRTR_BIT 31

#define CAN2_IR18 (*(volatile unsigned long *)0xFFFBC58C)
#define CAN2_IR18_OFFSET 0x58C
#define CAN2_IR18_ID_MASK 0x1FFFFFFFU
#define CAN2_IR18_ID_BIT 0
#define CAN2_IR18_RB_MASK 0x60000000U
#define CAN2_IR18_RB_BIT 29
#define CAN2_IR18_RTR_MASK 0x80000000U
#define CAN2_IR18_RTR 0x80000000U
#define CAN2_IR18_RTR_BIT 31

#define CAN2_CR18 (*(volatile unsigned long *)0xFFFBC590)
#define CAN2_CR18_OFFSET 0x590
#define CAN2_CR18_DLC_MASK 0xFU
#define CAN2_CR18_DLC_BIT 0
#define CAN2_CR18_IDE_MASK 0x10U
#define CAN2_CR18_IDE 0x10U
#define CAN2_CR18_IDE_BIT 4
#define CAN2_CR18_RPLYV_MASK 0x20U
#define CAN2_CR18_RPLYV 0x20U
#define CAN2_CR18_RPLYV_BIT 5
#define CAN2_CR18_PCB_MASK 0x40U
#define CAN2_CR18_PCB 0x40U
#define CAN2_CR18_PCB_BIT 6
#define CAN2_CR18_CHANEN_MASK 0x80U
#define CAN2_CR18_CHANEN 0x80U
#define CAN2_CR18_CHANEN_BIT 7
#define CAN2_CR18_OVERWRITE_MASK 0x100U
#define CAN2_CR18_OVERWRITE 0x100U
#define CAN2_CR18_OVERWRITE_BIT 8

#define CAN2_CR18 (*(volatile unsigned long *)0xFFFBC594)
#define CAN2_CR18_OFFSET 0x594
#define CAN2_CR18_STAMP_MASK 0x0U
#define CAN2_CR18_STAMP_BIT 0

#define CAN2_CSR18 (*(volatile unsigned long *)0xFFFBC598)
#define CAN2_CSR18_OFFSET 0x598
#define CAN2_CSR18_ACK_MASK 0x1U
#define CAN2_CSR18_ACK 0x1U
#define CAN2_CSR18_ACK_BIT 0
#define CAN2_CSR18_FRAME_MASK 0x2U
#define CAN2_CSR18_FRAME 0x2U
#define CAN2_CSR18_FRAME_BIT 1
#define CAN2_CSR18_CRC_MASK 0x4U
#define CAN2_CSR18_CRC 0x4U
#define CAN2_CSR18_CRC_BIT 2
#define CAN2_CSR18_STUFF_MASK 0x8U
#define CAN2_CSR18_STUFF 0x8U
#define CAN2_CSR18_STUFF_BIT 3
#define CAN2_CSR18_BUS_MASK 0x10U
#define CAN2_CSR18_BUS 0x10U
#define CAN2_CSR18_BUS_BIT 4
#define CAN2_CSR18_RXOK_MASK 0x20U
#define CAN2_CSR18_RXOK 0x20U
#define CAN2_CSR18_RXOK_BIT 5
#define CAN2_CSR18_TXOK_MASK 0x40U
#define CAN2_CSR18_TXOK 0x40U
#define CAN2_CSR18_TXOK_BIT 6
#define CAN2_CSR18_RFRAME_MASK 0x80U
#define CAN2_CSR18_RFRAME 0x80U
#define CAN2_CSR18_RFRAME_BIT 7
#define CAN2_CSR18_DLCW_MASK 0x200U
#define CAN2_CSR18_DLCW 0x200U
#define CAN2_CSR18_DLCW_BIT 9
#define CAN2_CSR18_FILLED_MASK 0x400U
#define CAN2_CSR18_FILLED 0x400U
#define CAN2_CSR18_FILLED_BIT 10
#define CAN2_CSR18_OVRUN_MASK 0x800U
#define CAN2_CSR18_OVRUN 0x800U
#define CAN2_CSR18_OVRUN_BIT 11

#define CAN2_SR18 (*(volatile unsigned long *)0xFFFBC59C)
#define CAN2_SR18_OFFSET 0x59C
#define CAN2_SR18_ACK_MASK 0x1U
#define CAN2_SR18_ACK 0x1U
#define CAN2_SR18_ACK_BIT 0
#define CAN2_SR18_FRAME_MASK 0x2U
#define CAN2_SR18_FRAME 0x2U
#define CAN2_SR18_FRAME_BIT 1
#define CAN2_SR18_CRC_MASK 0x4U
#define CAN2_SR18_CRC 0x4U
#define CAN2_SR18_CRC_BIT 2
#define CAN2_SR18_STUFF_MASK 0x8U
#define CAN2_SR18_STUFF 0x8U
#define CAN2_SR18_STUFF_BIT 3
#define CAN2_SR18_BUS_MASK 0x10U
#define CAN2_SR18_BUS 0x10U
#define CAN2_SR18_BUS_BIT 4
#define CAN2_SR18_RXOK_MASK 0x20U
#define CAN2_SR18_RXOK 0x20U
#define CAN2_SR18_RXOK_BIT 5
#define CAN2_SR18_TXOK_MASK 0x40U
#define CAN2_SR18_TXOK 0x40U
#define CAN2_SR18_TXOK_BIT 6
#define CAN2_SR18_RFRAME_MASK 0x80U
#define CAN2_SR18_RFRAME 0x80U
#define CAN2_SR18_RFRAME_BIT 7
#define CAN2_SR18_DLCW_MASK 0x200U
#define CAN2_SR18_DLCW 0x200U
#define CAN2_SR18_DLCW_BIT 9
#define CAN2_SR18_FILLED_MASK 0x400U
#define CAN2_SR18_FILLED 0x400U
#define CAN2_SR18_FILLED_BIT 10
#define CAN2_SR18_OVRUN_MASK 0x800U
#define CAN2_SR18_OVRUN 0x800U
#define CAN2_SR18_OVRUN_BIT 11

#define CAN2_IER18 (*(volatile unsigned long *)0xFFFBC5A0)
#define CAN2_IER18_OFFSET 0x5A0
#define CAN2_IER18_ACK_MASK 0x1U
#define CAN2_IER18_ACK 0x1U
#define CAN2_IER18_ACK_BIT 0
#define CAN2_IER18_FRAME_MASK 0x2U
#define CAN2_IER18_FRAME 0x2U
#define CAN2_IER18_FRAME_BIT 1
#define CAN2_IER18_CRC_MASK 0x4U
#define CAN2_IER18_CRC 0x4U
#define CAN2_IER18_CRC_BIT 2
#define CAN2_IER18_STUFF_MASK 0x8U
#define CAN2_IER18_STUFF 0x8U
#define CAN2_IER18_STUFF_BIT 3
#define CAN2_IER18_BUS_MASK 0x10U
#define CAN2_IER18_BUS 0x10U
#define CAN2_IER18_BUS_BIT 4
#define CAN2_IER18_RXOK_MASK 0x20U
#define CAN2_IER18_RXOK 0x20U
#define CAN2_IER18_RXOK_BIT 5
#define CAN2_IER18_TXOK_MASK 0x40U
#define CAN2_IER18_TXOK 0x40U
#define CAN2_IER18_TXOK_BIT 6
#define CAN2_IER18_RFRAME_MASK 0x80U
#define CAN2_IER18_RFRAME 0x80U
#define CAN2_IER18_RFRAME_BIT 7

#define CAN2_IDR18 (*(volatile unsigned long *)0xFFFBC5A4)
#define CAN2_IDR18_OFFSET 0x5A4
#define CAN2_IDR18_ACK_MASK 0x1U
#define CAN2_IDR18_ACK 0x1U
#define CAN2_IDR18_ACK_BIT 0
#define CAN2_IDR18_FRAME_MASK 0x2U
#define CAN2_IDR18_FRAME 0x2U
#define CAN2_IDR18_FRAME_BIT 1
#define CAN2_IDR18_CRC_MASK 0x4U
#define CAN2_IDR18_CRC 0x4U
#define CAN2_IDR18_CRC_BIT 2
#define CAN2_IDR18_STUFF_MASK 0x8U
#define CAN2_IDR18_STUFF 0x8U
#define CAN2_IDR18_STUFF_BIT 3
#define CAN2_IDR18_BUS_MASK 0x10U
#define CAN2_IDR18_BUS 0x10U
#define CAN2_IDR18_BUS_BIT 4
#define CAN2_IDR18_RXOK_MASK 0x20U
#define CAN2_IDR18_RXOK 0x20U
#define CAN2_IDR18_RXOK_BIT 5
#define CAN2_IDR18_TXOK_MASK 0x40U
#define CAN2_IDR18_TXOK 0x40U
#define CAN2_IDR18_TXOK_BIT 6
#define CAN2_IDR18_RFRAME_MASK 0x80U
#define CAN2_IDR18_RFRAME 0x80U
#define CAN2_IDR18_RFRAME_BIT 7

#define CAN2_IMR18 (*(volatile unsigned long *)0xFFFBC5A8)
#define CAN2_IMR18_OFFSET 0x5A8
#define CAN2_IMR18_ACK_MASK 0x1U
#define CAN2_IMR18_ACK 0x1U
#define CAN2_IMR18_ACK_BIT 0
#define CAN2_IMR18_FRAME_MASK 0x2U
#define CAN2_IMR18_FRAME 0x2U
#define CAN2_IMR18_FRAME_BIT 1
#define CAN2_IMR18_CRC_MASK 0x4U
#define CAN2_IMR18_CRC 0x4U
#define CAN2_IMR18_CRC_BIT 2
#define CAN2_IMR18_STUFF_MASK 0x8U
#define CAN2_IMR18_STUFF 0x8U
#define CAN2_IMR18_STUFF_BIT 3
#define CAN2_IMR18_BUS_MASK 0x10U
#define CAN2_IMR18_BUS 0x10U
#define CAN2_IMR18_BUS_BIT 4
#define CAN2_IMR18_RXOK_MASK 0x20U
#define CAN2_IMR18_RXOK 0x20U
#define CAN2_IMR18_RXOK_BIT 5
#define CAN2_IMR18_TXOK_MASK 0x40U
#define CAN2_IMR18_TXOK 0x40U
#define CAN2_IMR18_TXOK_BIT 6
#define CAN2_IMR18_RFRAME_MASK 0x80U
#define CAN2_IMR18_RFRAME 0x80U
#define CAN2_IMR18_RFRAME_BIT 7

#define CAN2_DRA19 (*(volatile unsigned long *)0xFFFBC5C0)
#define CAN2_DRA19_OFFSET 0x5C0
#define CAN2_DRA19_DATA0_MASK 0xFFU
#define CAN2_DRA19_DATA0_BIT 0
#define CAN2_DRA19_DATA1_MASK 0xFF00U
#define CAN2_DRA19_DATA1_BIT 8
#define CAN2_DRA19_DATA2_MASK 0xFF0000U
#define CAN2_DRA19_DATA2_BIT 16
#define CAN2_DRA19_DATA3_MASK 0xFF000000U
#define CAN2_DRA19_DATA3_BIT 24

#define CAN2_DRB19 (*(volatile unsigned long *)0xFFFBC5C4)
#define CAN2_DRB19_OFFSET 0x5C4
#define CAN2_DRB19_DATA4_MASK 0xFFU
#define CAN2_DRB19_DATA4_BIT 0
#define CAN2_DRB19_DATA5_MASK 0xFF00U
#define CAN2_DRB19_DATA5_BIT 8
#define CAN2_DRB19_DATA6_MASK 0xFF0000U
#define CAN2_DRB19_DATA6_BIT 16
#define CAN2_DRB19_DATA7_MASK 0xFF000000U
#define CAN2_DRB19_DATA7_BIT 24

#define CAN2_MSK19 (*(volatile unsigned long *)0xFFFBC5C8)
#define CAN2_MSK19_OFFSET 0x5C8
#define CAN2_MSK19_MASK_MASK 0x1FFFFFFFU
#define CAN2_MSK19_MASK_BIT 0
#define CAN2_MSK19_MRB_MASK 0x60000000U
#define CAN2_MSK19_MRB_BIT 29
#define CAN2_MSK19_MRTR_MASK 0x80000000U
#define CAN2_MSK19_MRTR 0x80000000U
#define CAN2_MSK19_MRTR_BIT 31

#define CAN2_IR19 (*(volatile unsigned long *)0xFFFBC5CC)
#define CAN2_IR19_OFFSET 0x5CC
#define CAN2_IR19_ID_MASK 0x1FFFFFFFU
#define CAN2_IR19_ID_BIT 0
#define CAN2_IR19_RB_MASK 0x60000000U
#define CAN2_IR19_RB_BIT 29
#define CAN2_IR19_RTR_MASK 0x80000000U
#define CAN2_IR19_RTR 0x80000000U
#define CAN2_IR19_RTR_BIT 31

#define CAN2_CR19 (*(volatile unsigned long *)0xFFFBC5D0)
#define CAN2_CR19_OFFSET 0x5D0
#define CAN2_CR19_DLC_MASK 0xFU
#define CAN2_CR19_DLC_BIT 0
#define CAN2_CR19_IDE_MASK 0x10U
#define CAN2_CR19_IDE 0x10U
#define CAN2_CR19_IDE_BIT 4
#define CAN2_CR19_RPLYV_MASK 0x20U
#define CAN2_CR19_RPLYV 0x20U
#define CAN2_CR19_RPLYV_BIT 5
#define CAN2_CR19_PCB_MASK 0x40U
#define CAN2_CR19_PCB 0x40U
#define CAN2_CR19_PCB_BIT 6
#define CAN2_CR19_CHANEN_MASK 0x80U
#define CAN2_CR19_CHANEN 0x80U
#define CAN2_CR19_CHANEN_BIT 7
#define CAN2_CR19_OVERWRITE_MASK 0x100U
#define CAN2_CR19_OVERWRITE 0x100U
#define CAN2_CR19_OVERWRITE_BIT 8

#define CAN2_CR19 (*(volatile unsigned long *)0xFFFBC5D4)
#define CAN2_CR19_OFFSET 0x5D4
#define CAN2_CR19_STAMP_MASK 0x0U
#define CAN2_CR19_STAMP_BIT 0

#define CAN2_CSR19 (*(volatile unsigned long *)0xFFFBC5D8)
#define CAN2_CSR19_OFFSET 0x5D8
#define CAN2_CSR19_ACK_MASK 0x1U
#define CAN2_CSR19_ACK 0x1U
#define CAN2_CSR19_ACK_BIT 0
#define CAN2_CSR19_FRAME_MASK 0x2U
#define CAN2_CSR19_FRAME 0x2U
#define CAN2_CSR19_FRAME_BIT 1
#define CAN2_CSR19_CRC_MASK 0x4U
#define CAN2_CSR19_CRC 0x4U
#define CAN2_CSR19_CRC_BIT 2
#define CAN2_CSR19_STUFF_MASK 0x8U
#define CAN2_CSR19_STUFF 0x8U
#define CAN2_CSR19_STUFF_BIT 3
#define CAN2_CSR19_BUS_MASK 0x10U
#define CAN2_CSR19_BUS 0x10U
#define CAN2_CSR19_BUS_BIT 4
#define CAN2_CSR19_RXOK_MASK 0x20U
#define CAN2_CSR19_RXOK 0x20U
#define CAN2_CSR19_RXOK_BIT 5
#define CAN2_CSR19_TXOK_MASK 0x40U
#define CAN2_CSR19_TXOK 0x40U
#define CAN2_CSR19_TXOK_BIT 6
#define CAN2_CSR19_RFRAME_MASK 0x80U
#define CAN2_CSR19_RFRAME 0x80U
#define CAN2_CSR19_RFRAME_BIT 7
#define CAN2_CSR19_DLCW_MASK 0x200U
#define CAN2_CSR19_DLCW 0x200U
#define CAN2_CSR19_DLCW_BIT 9
#define CAN2_CSR19_FILLED_MASK 0x400U
#define CAN2_CSR19_FILLED 0x400U
#define CAN2_CSR19_FILLED_BIT 10
#define CAN2_CSR19_OVRUN_MASK 0x800U
#define CAN2_CSR19_OVRUN 0x800U
#define CAN2_CSR19_OVRUN_BIT 11

#define CAN2_SR19 (*(volatile unsigned long *)0xFFFBC5DC)
#define CAN2_SR19_OFFSET 0x5DC
#define CAN2_SR19_ACK_MASK 0x1U
#define CAN2_SR19_ACK 0x1U
#define CAN2_SR19_ACK_BIT 0
#define CAN2_SR19_FRAME_MASK 0x2U
#define CAN2_SR19_FRAME 0x2U
#define CAN2_SR19_FRAME_BIT 1
#define CAN2_SR19_CRC_MASK 0x4U
#define CAN2_SR19_CRC 0x4U
#define CAN2_SR19_CRC_BIT 2
#define CAN2_SR19_STUFF_MASK 0x8U
#define CAN2_SR19_STUFF 0x8U
#define CAN2_SR19_STUFF_BIT 3
#define CAN2_SR19_BUS_MASK 0x10U
#define CAN2_SR19_BUS 0x10U
#define CAN2_SR19_BUS_BIT 4
#define CAN2_SR19_RXOK_MASK 0x20U
#define CAN2_SR19_RXOK 0x20U
#define CAN2_SR19_RXOK_BIT 5
#define CAN2_SR19_TXOK_MASK 0x40U
#define CAN2_SR19_TXOK 0x40U
#define CAN2_SR19_TXOK_BIT 6
#define CAN2_SR19_RFRAME_MASK 0x80U
#define CAN2_SR19_RFRAME 0x80U
#define CAN2_SR19_RFRAME_BIT 7
#define CAN2_SR19_DLCW_MASK 0x200U
#define CAN2_SR19_DLCW 0x200U
#define CAN2_SR19_DLCW_BIT 9
#define CAN2_SR19_FILLED_MASK 0x400U
#define CAN2_SR19_FILLED 0x400U
#define CAN2_SR19_FILLED_BIT 10
#define CAN2_SR19_OVRUN_MASK 0x800U
#define CAN2_SR19_OVRUN 0x800U
#define CAN2_SR19_OVRUN_BIT 11

#define CAN2_IER19 (*(volatile unsigned long *)0xFFFBC5E0)
#define CAN2_IER19_OFFSET 0x5E0
#define CAN2_IER19_ACK_MASK 0x1U
#define CAN2_IER19_ACK 0x1U
#define CAN2_IER19_ACK_BIT 0
#define CAN2_IER19_FRAME_MASK 0x2U
#define CAN2_IER19_FRAME 0x2U
#define CAN2_IER19_FRAME_BIT 1
#define CAN2_IER19_CRC_MASK 0x4U
#define CAN2_IER19_CRC 0x4U
#define CAN2_IER19_CRC_BIT 2
#define CAN2_IER19_STUFF_MASK 0x8U
#define CAN2_IER19_STUFF 0x8U
#define CAN2_IER19_STUFF_BIT 3
#define CAN2_IER19_BUS_MASK 0x10U
#define CAN2_IER19_BUS 0x10U
#define CAN2_IER19_BUS_BIT 4
#define CAN2_IER19_RXOK_MASK 0x20U
#define CAN2_IER19_RXOK 0x20U
#define CAN2_IER19_RXOK_BIT 5
#define CAN2_IER19_TXOK_MASK 0x40U
#define CAN2_IER19_TXOK 0x40U
#define CAN2_IER19_TXOK_BIT 6
#define CAN2_IER19_RFRAME_MASK 0x80U
#define CAN2_IER19_RFRAME 0x80U
#define CAN2_IER19_RFRAME_BIT 7

#define CAN2_IDR19 (*(volatile unsigned long *)0xFFFBC5E4)
#define CAN2_IDR19_OFFSET 0x5E4
#define CAN2_IDR19_ACK_MASK 0x1U
#define CAN2_IDR19_ACK 0x1U
#define CAN2_IDR19_ACK_BIT 0
#define CAN2_IDR19_FRAME_MASK 0x2U
#define CAN2_IDR19_FRAME 0x2U
#define CAN2_IDR19_FRAME_BIT 1
#define CAN2_IDR19_CRC_MASK 0x4U
#define CAN2_IDR19_CRC 0x4U
#define CAN2_IDR19_CRC_BIT 2
#define CAN2_IDR19_STUFF_MASK 0x8U
#define CAN2_IDR19_STUFF 0x8U
#define CAN2_IDR19_STUFF_BIT 3
#define CAN2_IDR19_BUS_MASK 0x10U
#define CAN2_IDR19_BUS 0x10U
#define CAN2_IDR19_BUS_BIT 4
#define CAN2_IDR19_RXOK_MASK 0x20U
#define CAN2_IDR19_RXOK 0x20U
#define CAN2_IDR19_RXOK_BIT 5
#define CAN2_IDR19_TXOK_MASK 0x40U
#define CAN2_IDR19_TXOK 0x40U
#define CAN2_IDR19_TXOK_BIT 6
#define CAN2_IDR19_RFRAME_MASK 0x80U
#define CAN2_IDR19_RFRAME 0x80U
#define CAN2_IDR19_RFRAME_BIT 7

#define CAN2_IMR19 (*(volatile unsigned long *)0xFFFBC5E8)
#define CAN2_IMR19_OFFSET 0x5E8
#define CAN2_IMR19_ACK_MASK 0x1U
#define CAN2_IMR19_ACK 0x1U
#define CAN2_IMR19_ACK_BIT 0
#define CAN2_IMR19_FRAME_MASK 0x2U
#define CAN2_IMR19_FRAME 0x2U
#define CAN2_IMR19_FRAME_BIT 1
#define CAN2_IMR19_CRC_MASK 0x4U
#define CAN2_IMR19_CRC 0x4U
#define CAN2_IMR19_CRC_BIT 2
#define CAN2_IMR19_STUFF_MASK 0x8U
#define CAN2_IMR19_STUFF 0x8U
#define CAN2_IMR19_STUFF_BIT 3
#define CAN2_IMR19_BUS_MASK 0x10U
#define CAN2_IMR19_BUS 0x10U
#define CAN2_IMR19_BUS_BIT 4
#define CAN2_IMR19_RXOK_MASK 0x20U
#define CAN2_IMR19_RXOK 0x20U
#define CAN2_IMR19_RXOK_BIT 5
#define CAN2_IMR19_TXOK_MASK 0x40U
#define CAN2_IMR19_TXOK 0x40U
#define CAN2_IMR19_TXOK_BIT 6
#define CAN2_IMR19_RFRAME_MASK 0x80U
#define CAN2_IMR19_RFRAME 0x80U
#define CAN2_IMR19_RFRAME_BIT 7

#define CAN2_DRA20 (*(volatile unsigned long *)0xFFFBC600)
#define CAN2_DRA20_OFFSET 0x600
#define CAN2_DRA20_DATA0_MASK 0xFFU
#define CAN2_DRA20_DATA0_BIT 0
#define CAN2_DRA20_DATA1_MASK 0xFF00U
#define CAN2_DRA20_DATA1_BIT 8
#define CAN2_DRA20_DATA2_MASK 0xFF0000U
#define CAN2_DRA20_DATA2_BIT 16
#define CAN2_DRA20_DATA3_MASK 0xFF000000U
#define CAN2_DRA20_DATA3_BIT 24

#define CAN2_DRB20 (*(volatile unsigned long *)0xFFFBC604)
#define CAN2_DRB20_OFFSET 0x604
#define CAN2_DRB20_DATA4_MASK 0xFFU
#define CAN2_DRB20_DATA4_BIT 0
#define CAN2_DRB20_DATA5_MASK 0xFF00U
#define CAN2_DRB20_DATA5_BIT 8
#define CAN2_DRB20_DATA6_MASK 0xFF0000U
#define CAN2_DRB20_DATA6_BIT 16
#define CAN2_DRB20_DATA7_MASK 0xFF000000U
#define CAN2_DRB20_DATA7_BIT 24

#define CAN2_MSK20 (*(volatile unsigned long *)0xFFFBC608)
#define CAN2_MSK20_OFFSET 0x608
#define CAN2_MSK20_MASK_MASK 0x1FFFFFFFU
#define CAN2_MSK20_MASK_BIT 0
#define CAN2_MSK20_MRB_MASK 0x60000000U
#define CAN2_MSK20_MRB_BIT 29
#define CAN2_MSK20_MRTR_MASK 0x80000000U
#define CAN2_MSK20_MRTR 0x80000000U
#define CAN2_MSK20_MRTR_BIT 31

#define CAN2_IR20 (*(volatile unsigned long *)0xFFFBC60C)
#define CAN2_IR20_OFFSET 0x60C
#define CAN2_IR20_ID_MASK 0x1FFFFFFFU
#define CAN2_IR20_ID_BIT 0
#define CAN2_IR20_RB_MASK 0x60000000U
#define CAN2_IR20_RB_BIT 29
#define CAN2_IR20_RTR_MASK 0x80000000U
#define CAN2_IR20_RTR 0x80000000U
#define CAN2_IR20_RTR_BIT 31

#define CAN2_CR20 (*(volatile unsigned long *)0xFFFBC610)
#define CAN2_CR20_OFFSET 0x610
#define CAN2_CR20_DLC_MASK 0xFU
#define CAN2_CR20_DLC_BIT 0
#define CAN2_CR20_IDE_MASK 0x10U
#define CAN2_CR20_IDE 0x10U
#define CAN2_CR20_IDE_BIT 4
#define CAN2_CR20_RPLYV_MASK 0x20U
#define CAN2_CR20_RPLYV 0x20U
#define CAN2_CR20_RPLYV_BIT 5
#define CAN2_CR20_PCB_MASK 0x40U
#define CAN2_CR20_PCB 0x40U
#define CAN2_CR20_PCB_BIT 6
#define CAN2_CR20_CHANEN_MASK 0x80U
#define CAN2_CR20_CHANEN 0x80U
#define CAN2_CR20_CHANEN_BIT 7
#define CAN2_CR20_OVERWRITE_MASK 0x100U
#define CAN2_CR20_OVERWRITE 0x100U
#define CAN2_CR20_OVERWRITE_BIT 8

#define CAN2_CR20 (*(volatile unsigned long *)0xFFFBC614)
#define CAN2_CR20_OFFSET 0x614
#define CAN2_CR20_STAMP_MASK 0x0U
#define CAN2_CR20_STAMP_BIT 0

#define CAN2_CSR20 (*(volatile unsigned long *)0xFFFBC618)
#define CAN2_CSR20_OFFSET 0x618
#define CAN2_CSR20_ACK_MASK 0x1U
#define CAN2_CSR20_ACK 0x1U
#define CAN2_CSR20_ACK_BIT 0
#define CAN2_CSR20_FRAME_MASK 0x2U
#define CAN2_CSR20_FRAME 0x2U
#define CAN2_CSR20_FRAME_BIT 1
#define CAN2_CSR20_CRC_MASK 0x4U
#define CAN2_CSR20_CRC 0x4U
#define CAN2_CSR20_CRC_BIT 2
#define CAN2_CSR20_STUFF_MASK 0x8U
#define CAN2_CSR20_STUFF 0x8U
#define CAN2_CSR20_STUFF_BIT 3
#define CAN2_CSR20_BUS_MASK 0x10U
#define CAN2_CSR20_BUS 0x10U
#define CAN2_CSR20_BUS_BIT 4
#define CAN2_CSR20_RXOK_MASK 0x20U
#define CAN2_CSR20_RXOK 0x20U
#define CAN2_CSR20_RXOK_BIT 5
#define CAN2_CSR20_TXOK_MASK 0x40U
#define CAN2_CSR20_TXOK 0x40U
#define CAN2_CSR20_TXOK_BIT 6
#define CAN2_CSR20_RFRAME_MASK 0x80U
#define CAN2_CSR20_RFRAME 0x80U
#define CAN2_CSR20_RFRAME_BIT 7
#define CAN2_CSR20_DLCW_MASK 0x200U
#define CAN2_CSR20_DLCW 0x200U
#define CAN2_CSR20_DLCW_BIT 9
#define CAN2_CSR20_FILLED_MASK 0x400U
#define CAN2_CSR20_FILLED 0x400U
#define CAN2_CSR20_FILLED_BIT 10
#define CAN2_CSR20_OVRUN_MASK 0x800U
#define CAN2_CSR20_OVRUN 0x800U
#define CAN2_CSR20_OVRUN_BIT 11

#define CAN2_SR20 (*(volatile unsigned long *)0xFFFBC61C)
#define CAN2_SR20_OFFSET 0x61C
#define CAN2_SR20_ACK_MASK 0x1U
#define CAN2_SR20_ACK 0x1U
#define CAN2_SR20_ACK_BIT 0
#define CAN2_SR20_FRAME_MASK 0x2U
#define CAN2_SR20_FRAME 0x2U
#define CAN2_SR20_FRAME_BIT 1
#define CAN2_SR20_CRC_MASK 0x4U
#define CAN2_SR20_CRC 0x4U
#define CAN2_SR20_CRC_BIT 2
#define CAN2_SR20_STUFF_MASK 0x8U
#define CAN2_SR20_STUFF 0x8U
#define CAN2_SR20_STUFF_BIT 3
#define CAN2_SR20_BUS_MASK 0x10U
#define CAN2_SR20_BUS 0x10U
#define CAN2_SR20_BUS_BIT 4
#define CAN2_SR20_RXOK_MASK 0x20U
#define CAN2_SR20_RXOK 0x20U
#define CAN2_SR20_RXOK_BIT 5
#define CAN2_SR20_TXOK_MASK 0x40U
#define CAN2_SR20_TXOK 0x40U
#define CAN2_SR20_TXOK_BIT 6
#define CAN2_SR20_RFRAME_MASK 0x80U
#define CAN2_SR20_RFRAME 0x80U
#define CAN2_SR20_RFRAME_BIT 7
#define CAN2_SR20_DLCW_MASK 0x200U
#define CAN2_SR20_DLCW 0x200U
#define CAN2_SR20_DLCW_BIT 9
#define CAN2_SR20_FILLED_MASK 0x400U
#define CAN2_SR20_FILLED 0x400U
#define CAN2_SR20_FILLED_BIT 10
#define CAN2_SR20_OVRUN_MASK 0x800U
#define CAN2_SR20_OVRUN 0x800U
#define CAN2_SR20_OVRUN_BIT 11

#define CAN2_IER20 (*(volatile unsigned long *)0xFFFBC620)
#define CAN2_IER20_OFFSET 0x620
#define CAN2_IER20_ACK_MASK 0x1U
#define CAN2_IER20_ACK 0x1U
#define CAN2_IER20_ACK_BIT 0
#define CAN2_IER20_FRAME_MASK 0x2U
#define CAN2_IER20_FRAME 0x2U
#define CAN2_IER20_FRAME_BIT 1
#define CAN2_IER20_CRC_MASK 0x4U
#define CAN2_IER20_CRC 0x4U
#define CAN2_IER20_CRC_BIT 2
#define CAN2_IER20_STUFF_MASK 0x8U
#define CAN2_IER20_STUFF 0x8U
#define CAN2_IER20_STUFF_BIT 3
#define CAN2_IER20_BUS_MASK 0x10U
#define CAN2_IER20_BUS 0x10U
#define CAN2_IER20_BUS_BIT 4
#define CAN2_IER20_RXOK_MASK 0x20U
#define CAN2_IER20_RXOK 0x20U
#define CAN2_IER20_RXOK_BIT 5
#define CAN2_IER20_TXOK_MASK 0x40U
#define CAN2_IER20_TXOK 0x40U
#define CAN2_IER20_TXOK_BIT 6
#define CAN2_IER20_RFRAME_MASK 0x80U
#define CAN2_IER20_RFRAME 0x80U
#define CAN2_IER20_RFRAME_BIT 7

#define CAN2_IDR20 (*(volatile unsigned long *)0xFFFBC624)
#define CAN2_IDR20_OFFSET 0x624
#define CAN2_IDR20_ACK_MASK 0x1U
#define CAN2_IDR20_ACK 0x1U
#define CAN2_IDR20_ACK_BIT 0
#define CAN2_IDR20_FRAME_MASK 0x2U
#define CAN2_IDR20_FRAME 0x2U
#define CAN2_IDR20_FRAME_BIT 1
#define CAN2_IDR20_CRC_MASK 0x4U
#define CAN2_IDR20_CRC 0x4U
#define CAN2_IDR20_CRC_BIT 2
#define CAN2_IDR20_STUFF_MASK 0x8U
#define CAN2_IDR20_STUFF 0x8U
#define CAN2_IDR20_STUFF_BIT 3
#define CAN2_IDR20_BUS_MASK 0x10U
#define CAN2_IDR20_BUS 0x10U
#define CAN2_IDR20_BUS_BIT 4
#define CAN2_IDR20_RXOK_MASK 0x20U
#define CAN2_IDR20_RXOK 0x20U
#define CAN2_IDR20_RXOK_BIT 5
#define CAN2_IDR20_TXOK_MASK 0x40U
#define CAN2_IDR20_TXOK 0x40U
#define CAN2_IDR20_TXOK_BIT 6
#define CAN2_IDR20_RFRAME_MASK 0x80U
#define CAN2_IDR20_RFRAME 0x80U
#define CAN2_IDR20_RFRAME_BIT 7

#define CAN2_IMR20 (*(volatile unsigned long *)0xFFFBC628)
#define CAN2_IMR20_OFFSET 0x628
#define CAN2_IMR20_ACK_MASK 0x1U
#define CAN2_IMR20_ACK 0x1U
#define CAN2_IMR20_ACK_BIT 0
#define CAN2_IMR20_FRAME_MASK 0x2U
#define CAN2_IMR20_FRAME 0x2U
#define CAN2_IMR20_FRAME_BIT 1
#define CAN2_IMR20_CRC_MASK 0x4U
#define CAN2_IMR20_CRC 0x4U
#define CAN2_IMR20_CRC_BIT 2
#define CAN2_IMR20_STUFF_MASK 0x8U
#define CAN2_IMR20_STUFF 0x8U
#define CAN2_IMR20_STUFF_BIT 3
#define CAN2_IMR20_BUS_MASK 0x10U
#define CAN2_IMR20_BUS 0x10U
#define CAN2_IMR20_BUS_BIT 4
#define CAN2_IMR20_RXOK_MASK 0x20U
#define CAN2_IMR20_RXOK 0x20U
#define CAN2_IMR20_RXOK_BIT 5
#define CAN2_IMR20_TXOK_MASK 0x40U
#define CAN2_IMR20_TXOK 0x40U
#define CAN2_IMR20_TXOK_BIT 6
#define CAN2_IMR20_RFRAME_MASK 0x80U
#define CAN2_IMR20_RFRAME 0x80U
#define CAN2_IMR20_RFRAME_BIT 7

#define CAN2_DRA21 (*(volatile unsigned long *)0xFFFBC640)
#define CAN2_DRA21_OFFSET 0x640
#define CAN2_DRA21_DATA0_MASK 0xFFU
#define CAN2_DRA21_DATA0_BIT 0
#define CAN2_DRA21_DATA1_MASK 0xFF00U
#define CAN2_DRA21_DATA1_BIT 8
#define CAN2_DRA21_DATA2_MASK 0xFF0000U
#define CAN2_DRA21_DATA2_BIT 16
#define CAN2_DRA21_DATA3_MASK 0xFF000000U
#define CAN2_DRA21_DATA3_BIT 24

#define CAN2_DRB21 (*(volatile unsigned long *)0xFFFBC644)
#define CAN2_DRB21_OFFSET 0x644
#define CAN2_DRB21_DATA4_MASK 0xFFU
#define CAN2_DRB21_DATA4_BIT 0
#define CAN2_DRB21_DATA5_MASK 0xFF00U
#define CAN2_DRB21_DATA5_BIT 8
#define CAN2_DRB21_DATA6_MASK 0xFF0000U
#define CAN2_DRB21_DATA6_BIT 16
#define CAN2_DRB21_DATA7_MASK 0xFF000000U
#define CAN2_DRB21_DATA7_BIT 24

#define CAN2_MSK21 (*(volatile unsigned long *)0xFFFBC648)
#define CAN2_MSK21_OFFSET 0x648
#define CAN2_MSK21_MASK_MASK 0x1FFFFFFFU
#define CAN2_MSK21_MASK_BIT 0
#define CAN2_MSK21_MRB_MASK 0x60000000U
#define CAN2_MSK21_MRB_BIT 29
#define CAN2_MSK21_MRTR_MASK 0x80000000U
#define CAN2_MSK21_MRTR 0x80000000U
#define CAN2_MSK21_MRTR_BIT 31

#define CAN2_IR21 (*(volatile unsigned long *)0xFFFBC64C)
#define CAN2_IR21_OFFSET 0x64C
#define CAN2_IR21_ID_MASK 0x1FFFFFFFU
#define CAN2_IR21_ID_BIT 0
#define CAN2_IR21_RB_MASK 0x60000000U
#define CAN2_IR21_RB_BIT 29
#define CAN2_IR21_RTR_MASK 0x80000000U
#define CAN2_IR21_RTR 0x80000000U
#define CAN2_IR21_RTR_BIT 31

#define CAN2_CR21 (*(volatile unsigned long *)0xFFFBC650)
#define CAN2_CR21_OFFSET 0x650
#define CAN2_CR21_DLC_MASK 0xFU
#define CAN2_CR21_DLC_BIT 0
#define CAN2_CR21_IDE_MASK 0x10U
#define CAN2_CR21_IDE 0x10U
#define CAN2_CR21_IDE_BIT 4
#define CAN2_CR21_RPLYV_MASK 0x20U
#define CAN2_CR21_RPLYV 0x20U
#define CAN2_CR21_RPLYV_BIT 5
#define CAN2_CR21_PCB_MASK 0x40U
#define CAN2_CR21_PCB 0x40U
#define CAN2_CR21_PCB_BIT 6
#define CAN2_CR21_CHANEN_MASK 0x80U
#define CAN2_CR21_CHANEN 0x80U
#define CAN2_CR21_CHANEN_BIT 7
#define CAN2_CR21_OVERWRITE_MASK 0x100U
#define CAN2_CR21_OVERWRITE 0x100U
#define CAN2_CR21_OVERWRITE_BIT 8

#define CAN2_CR21 (*(volatile unsigned long *)0xFFFBC654)
#define CAN2_CR21_OFFSET 0x654
#define CAN2_CR21_STAMP_MASK 0x0U
#define CAN2_CR21_STAMP_BIT 0

#define CAN2_CSR21 (*(volatile unsigned long *)0xFFFBC658)
#define CAN2_CSR21_OFFSET 0x658
#define CAN2_CSR21_ACK_MASK 0x1U
#define CAN2_CSR21_ACK 0x1U
#define CAN2_CSR21_ACK_BIT 0
#define CAN2_CSR21_FRAME_MASK 0x2U
#define CAN2_CSR21_FRAME 0x2U
#define CAN2_CSR21_FRAME_BIT 1
#define CAN2_CSR21_CRC_MASK 0x4U
#define CAN2_CSR21_CRC 0x4U
#define CAN2_CSR21_CRC_BIT 2
#define CAN2_CSR21_STUFF_MASK 0x8U
#define CAN2_CSR21_STUFF 0x8U
#define CAN2_CSR21_STUFF_BIT 3
#define CAN2_CSR21_BUS_MASK 0x10U
#define CAN2_CSR21_BUS 0x10U
#define CAN2_CSR21_BUS_BIT 4
#define CAN2_CSR21_RXOK_MASK 0x20U
#define CAN2_CSR21_RXOK 0x20U
#define CAN2_CSR21_RXOK_BIT 5
#define CAN2_CSR21_TXOK_MASK 0x40U
#define CAN2_CSR21_TXOK 0x40U
#define CAN2_CSR21_TXOK_BIT 6
#define CAN2_CSR21_RFRAME_MASK 0x80U
#define CAN2_CSR21_RFRAME 0x80U
#define CAN2_CSR21_RFRAME_BIT 7
#define CAN2_CSR21_DLCW_MASK 0x200U
#define CAN2_CSR21_DLCW 0x200U
#define CAN2_CSR21_DLCW_BIT 9
#define CAN2_CSR21_FILLED_MASK 0x400U
#define CAN2_CSR21_FILLED 0x400U
#define CAN2_CSR21_FILLED_BIT 10
#define CAN2_CSR21_OVRUN_MASK 0x800U
#define CAN2_CSR21_OVRUN 0x800U
#define CAN2_CSR21_OVRUN_BIT 11

#define CAN2_SR21 (*(volatile unsigned long *)0xFFFBC65C)
#define CAN2_SR21_OFFSET 0x65C
#define CAN2_SR21_ACK_MASK 0x1U
#define CAN2_SR21_ACK 0x1U
#define CAN2_SR21_ACK_BIT 0
#define CAN2_SR21_FRAME_MASK 0x2U
#define CAN2_SR21_FRAME 0x2U
#define CAN2_SR21_FRAME_BIT 1
#define CAN2_SR21_CRC_MASK 0x4U
#define CAN2_SR21_CRC 0x4U
#define CAN2_SR21_CRC_BIT 2
#define CAN2_SR21_STUFF_MASK 0x8U
#define CAN2_SR21_STUFF 0x8U
#define CAN2_SR21_STUFF_BIT 3
#define CAN2_SR21_BUS_MASK 0x10U
#define CAN2_SR21_BUS 0x10U
#define CAN2_SR21_BUS_BIT 4
#define CAN2_SR21_RXOK_MASK 0x20U
#define CAN2_SR21_RXOK 0x20U
#define CAN2_SR21_RXOK_BIT 5
#define CAN2_SR21_TXOK_MASK 0x40U
#define CAN2_SR21_TXOK 0x40U
#define CAN2_SR21_TXOK_BIT 6
#define CAN2_SR21_RFRAME_MASK 0x80U
#define CAN2_SR21_RFRAME 0x80U
#define CAN2_SR21_RFRAME_BIT 7
#define CAN2_SR21_DLCW_MASK 0x200U
#define CAN2_SR21_DLCW 0x200U
#define CAN2_SR21_DLCW_BIT 9
#define CAN2_SR21_FILLED_MASK 0x400U
#define CAN2_SR21_FILLED 0x400U
#define CAN2_SR21_FILLED_BIT 10
#define CAN2_SR21_OVRUN_MASK 0x800U
#define CAN2_SR21_OVRUN 0x800U
#define CAN2_SR21_OVRUN_BIT 11

#define CAN2_IER21 (*(volatile unsigned long *)0xFFFBC660)
#define CAN2_IER21_OFFSET 0x660
#define CAN2_IER21_ACK_MASK 0x1U
#define CAN2_IER21_ACK 0x1U
#define CAN2_IER21_ACK_BIT 0
#define CAN2_IER21_FRAME_MASK 0x2U
#define CAN2_IER21_FRAME 0x2U
#define CAN2_IER21_FRAME_BIT 1
#define CAN2_IER21_CRC_MASK 0x4U
#define CAN2_IER21_CRC 0x4U
#define CAN2_IER21_CRC_BIT 2
#define CAN2_IER21_STUFF_MASK 0x8U
#define CAN2_IER21_STUFF 0x8U
#define CAN2_IER21_STUFF_BIT 3
#define CAN2_IER21_BUS_MASK 0x10U
#define CAN2_IER21_BUS 0x10U
#define CAN2_IER21_BUS_BIT 4
#define CAN2_IER21_RXOK_MASK 0x20U
#define CAN2_IER21_RXOK 0x20U
#define CAN2_IER21_RXOK_BIT 5
#define CAN2_IER21_TXOK_MASK 0x40U
#define CAN2_IER21_TXOK 0x40U
#define CAN2_IER21_TXOK_BIT 6
#define CAN2_IER21_RFRAME_MASK 0x80U
#define CAN2_IER21_RFRAME 0x80U
#define CAN2_IER21_RFRAME_BIT 7

#define CAN2_IDR21 (*(volatile unsigned long *)0xFFFBC664)
#define CAN2_IDR21_OFFSET 0x664
#define CAN2_IDR21_ACK_MASK 0x1U
#define CAN2_IDR21_ACK 0x1U
#define CAN2_IDR21_ACK_BIT 0
#define CAN2_IDR21_FRAME_MASK 0x2U
#define CAN2_IDR21_FRAME 0x2U
#define CAN2_IDR21_FRAME_BIT 1
#define CAN2_IDR21_CRC_MASK 0x4U
#define CAN2_IDR21_CRC 0x4U
#define CAN2_IDR21_CRC_BIT 2
#define CAN2_IDR21_STUFF_MASK 0x8U
#define CAN2_IDR21_STUFF 0x8U
#define CAN2_IDR21_STUFF_BIT 3
#define CAN2_IDR21_BUS_MASK 0x10U
#define CAN2_IDR21_BUS 0x10U
#define CAN2_IDR21_BUS_BIT 4
#define CAN2_IDR21_RXOK_MASK 0x20U
#define CAN2_IDR21_RXOK 0x20U
#define CAN2_IDR21_RXOK_BIT 5
#define CAN2_IDR21_TXOK_MASK 0x40U
#define CAN2_IDR21_TXOK 0x40U
#define CAN2_IDR21_TXOK_BIT 6
#define CAN2_IDR21_RFRAME_MASK 0x80U
#define CAN2_IDR21_RFRAME 0x80U
#define CAN2_IDR21_RFRAME_BIT 7

#define CAN2_IMR21 (*(volatile unsigned long *)0xFFFBC668)
#define CAN2_IMR21_OFFSET 0x668
#define CAN2_IMR21_ACK_MASK 0x1U
#define CAN2_IMR21_ACK 0x1U
#define CAN2_IMR21_ACK_BIT 0
#define CAN2_IMR21_FRAME_MASK 0x2U
#define CAN2_IMR21_FRAME 0x2U
#define CAN2_IMR21_FRAME_BIT 1
#define CAN2_IMR21_CRC_MASK 0x4U
#define CAN2_IMR21_CRC 0x4U
#define CAN2_IMR21_CRC_BIT 2
#define CAN2_IMR21_STUFF_MASK 0x8U
#define CAN2_IMR21_STUFF 0x8U
#define CAN2_IMR21_STUFF_BIT 3
#define CAN2_IMR21_BUS_MASK 0x10U
#define CAN2_IMR21_BUS 0x10U
#define CAN2_IMR21_BUS_BIT 4
#define CAN2_IMR21_RXOK_MASK 0x20U
#define CAN2_IMR21_RXOK 0x20U
#define CAN2_IMR21_RXOK_BIT 5
#define CAN2_IMR21_TXOK_MASK 0x40U
#define CAN2_IMR21_TXOK 0x40U
#define CAN2_IMR21_TXOK_BIT 6
#define CAN2_IMR21_RFRAME_MASK 0x80U
#define CAN2_IMR21_RFRAME 0x80U
#define CAN2_IMR21_RFRAME_BIT 7

#define CAN2_DRA22 (*(volatile unsigned long *)0xFFFBC680)
#define CAN2_DRA22_OFFSET 0x680
#define CAN2_DRA22_DATA0_MASK 0xFFU
#define CAN2_DRA22_DATA0_BIT 0
#define CAN2_DRA22_DATA1_MASK 0xFF00U
#define CAN2_DRA22_DATA1_BIT 8
#define CAN2_DRA22_DATA2_MASK 0xFF0000U
#define CAN2_DRA22_DATA2_BIT 16
#define CAN2_DRA22_DATA3_MASK 0xFF000000U
#define CAN2_DRA22_DATA3_BIT 24

#define CAN2_DRB22 (*(volatile unsigned long *)0xFFFBC684)
#define CAN2_DRB22_OFFSET 0x684
#define CAN2_DRB22_DATA4_MASK 0xFFU
#define CAN2_DRB22_DATA4_BIT 0
#define CAN2_DRB22_DATA5_MASK 0xFF00U
#define CAN2_DRB22_DATA5_BIT 8
#define CAN2_DRB22_DATA6_MASK 0xFF0000U
#define CAN2_DRB22_DATA6_BIT 16
#define CAN2_DRB22_DATA7_MASK 0xFF000000U
#define CAN2_DRB22_DATA7_BIT 24

#define CAN2_MSK22 (*(volatile unsigned long *)0xFFFBC688)
#define CAN2_MSK22_OFFSET 0x688
#define CAN2_MSK22_MASK_MASK 0x1FFFFFFFU
#define CAN2_MSK22_MASK_BIT 0
#define CAN2_MSK22_MRB_MASK 0x60000000U
#define CAN2_MSK22_MRB_BIT 29
#define CAN2_MSK22_MRTR_MASK 0x80000000U
#define CAN2_MSK22_MRTR 0x80000000U
#define CAN2_MSK22_MRTR_BIT 31

#define CAN2_IR22 (*(volatile unsigned long *)0xFFFBC68C)
#define CAN2_IR22_OFFSET 0x68C
#define CAN2_IR22_ID_MASK 0x1FFFFFFFU
#define CAN2_IR22_ID_BIT 0
#define CAN2_IR22_RB_MASK 0x60000000U
#define CAN2_IR22_RB_BIT 29
#define CAN2_IR22_RTR_MASK 0x80000000U
#define CAN2_IR22_RTR 0x80000000U
#define CAN2_IR22_RTR_BIT 31

#define CAN2_CR22 (*(volatile unsigned long *)0xFFFBC690)
#define CAN2_CR22_OFFSET 0x690
#define CAN2_CR22_DLC_MASK 0xFU
#define CAN2_CR22_DLC_BIT 0
#define CAN2_CR22_IDE_MASK 0x10U
#define CAN2_CR22_IDE 0x10U
#define CAN2_CR22_IDE_BIT 4
#define CAN2_CR22_RPLYV_MASK 0x20U
#define CAN2_CR22_RPLYV 0x20U
#define CAN2_CR22_RPLYV_BIT 5
#define CAN2_CR22_PCB_MASK 0x40U
#define CAN2_CR22_PCB 0x40U
#define CAN2_CR22_PCB_BIT 6
#define CAN2_CR22_CHANEN_MASK 0x80U
#define CAN2_CR22_CHANEN 0x80U
#define CAN2_CR22_CHANEN_BIT 7
#define CAN2_CR22_OVERWRITE_MASK 0x100U
#define CAN2_CR22_OVERWRITE 0x100U
#define CAN2_CR22_OVERWRITE_BIT 8

#define CAN2_CR22 (*(volatile unsigned long *)0xFFFBC694)
#define CAN2_CR22_OFFSET 0x694
#define CAN2_CR22_STAMP_MASK 0x0U
#define CAN2_CR22_STAMP_BIT 0

#define CAN2_CSR22 (*(volatile unsigned long *)0xFFFBC698)
#define CAN2_CSR22_OFFSET 0x698
#define CAN2_CSR22_ACK_MASK 0x1U
#define CAN2_CSR22_ACK 0x1U
#define CAN2_CSR22_ACK_BIT 0
#define CAN2_CSR22_FRAME_MASK 0x2U
#define CAN2_CSR22_FRAME 0x2U
#define CAN2_CSR22_FRAME_BIT 1
#define CAN2_CSR22_CRC_MASK 0x4U
#define CAN2_CSR22_CRC 0x4U
#define CAN2_CSR22_CRC_BIT 2
#define CAN2_CSR22_STUFF_MASK 0x8U
#define CAN2_CSR22_STUFF 0x8U
#define CAN2_CSR22_STUFF_BIT 3
#define CAN2_CSR22_BUS_MASK 0x10U
#define CAN2_CSR22_BUS 0x10U
#define CAN2_CSR22_BUS_BIT 4
#define CAN2_CSR22_RXOK_MASK 0x20U
#define CAN2_CSR22_RXOK 0x20U
#define CAN2_CSR22_RXOK_BIT 5
#define CAN2_CSR22_TXOK_MASK 0x40U
#define CAN2_CSR22_TXOK 0x40U
#define CAN2_CSR22_TXOK_BIT 6
#define CAN2_CSR22_RFRAME_MASK 0x80U
#define CAN2_CSR22_RFRAME 0x80U
#define CAN2_CSR22_RFRAME_BIT 7
#define CAN2_CSR22_DLCW_MASK 0x200U
#define CAN2_CSR22_DLCW 0x200U
#define CAN2_CSR22_DLCW_BIT 9
#define CAN2_CSR22_FILLED_MASK 0x400U
#define CAN2_CSR22_FILLED 0x400U
#define CAN2_CSR22_FILLED_BIT 10
#define CAN2_CSR22_OVRUN_MASK 0x800U
#define CAN2_CSR22_OVRUN 0x800U
#define CAN2_CSR22_OVRUN_BIT 11

#define CAN2_SR22 (*(volatile unsigned long *)0xFFFBC69C)
#define CAN2_SR22_OFFSET 0x69C
#define CAN2_SR22_ACK_MASK 0x1U
#define CAN2_SR22_ACK 0x1U
#define CAN2_SR22_ACK_BIT 0
#define CAN2_SR22_FRAME_MASK 0x2U
#define CAN2_SR22_FRAME 0x2U
#define CAN2_SR22_FRAME_BIT 1
#define CAN2_SR22_CRC_MASK 0x4U
#define CAN2_SR22_CRC 0x4U
#define CAN2_SR22_CRC_BIT 2
#define CAN2_SR22_STUFF_MASK 0x8U
#define CAN2_SR22_STUFF 0x8U
#define CAN2_SR22_STUFF_BIT 3
#define CAN2_SR22_BUS_MASK 0x10U
#define CAN2_SR22_BUS 0x10U
#define CAN2_SR22_BUS_BIT 4
#define CAN2_SR22_RXOK_MASK 0x20U
#define CAN2_SR22_RXOK 0x20U
#define CAN2_SR22_RXOK_BIT 5
#define CAN2_SR22_TXOK_MASK 0x40U
#define CAN2_SR22_TXOK 0x40U
#define CAN2_SR22_TXOK_BIT 6
#define CAN2_SR22_RFRAME_MASK 0x80U
#define CAN2_SR22_RFRAME 0x80U
#define CAN2_SR22_RFRAME_BIT 7
#define CAN2_SR22_DLCW_MASK 0x200U
#define CAN2_SR22_DLCW 0x200U
#define CAN2_SR22_DLCW_BIT 9
#define CAN2_SR22_FILLED_MASK 0x400U
#define CAN2_SR22_FILLED 0x400U
#define CAN2_SR22_FILLED_BIT 10
#define CAN2_SR22_OVRUN_MASK 0x800U
#define CAN2_SR22_OVRUN 0x800U
#define CAN2_SR22_OVRUN_BIT 11

#define CAN2_IER22 (*(volatile unsigned long *)0xFFFBC6A0)
#define CAN2_IER22_OFFSET 0x6A0
#define CAN2_IER22_ACK_MASK 0x1U
#define CAN2_IER22_ACK 0x1U
#define CAN2_IER22_ACK_BIT 0
#define CAN2_IER22_FRAME_MASK 0x2U
#define CAN2_IER22_FRAME 0x2U
#define CAN2_IER22_FRAME_BIT 1
#define CAN2_IER22_CRC_MASK 0x4U
#define CAN2_IER22_CRC 0x4U
#define CAN2_IER22_CRC_BIT 2
#define CAN2_IER22_STUFF_MASK 0x8U
#define CAN2_IER22_STUFF 0x8U
#define CAN2_IER22_STUFF_BIT 3
#define CAN2_IER22_BUS_MASK 0x10U
#define CAN2_IER22_BUS 0x10U
#define CAN2_IER22_BUS_BIT 4
#define CAN2_IER22_RXOK_MASK 0x20U
#define CAN2_IER22_RXOK 0x20U
#define CAN2_IER22_RXOK_BIT 5
#define CAN2_IER22_TXOK_MASK 0x40U
#define CAN2_IER22_TXOK 0x40U
#define CAN2_IER22_TXOK_BIT 6
#define CAN2_IER22_RFRAME_MASK 0x80U
#define CAN2_IER22_RFRAME 0x80U
#define CAN2_IER22_RFRAME_BIT 7

#define CAN2_IDR22 (*(volatile unsigned long *)0xFFFBC6A4)
#define CAN2_IDR22_OFFSET 0x6A4
#define CAN2_IDR22_ACK_MASK 0x1U
#define CAN2_IDR22_ACK 0x1U
#define CAN2_IDR22_ACK_BIT 0
#define CAN2_IDR22_FRAME_MASK 0x2U
#define CAN2_IDR22_FRAME 0x2U
#define CAN2_IDR22_FRAME_BIT 1
#define CAN2_IDR22_CRC_MASK 0x4U
#define CAN2_IDR22_CRC 0x4U
#define CAN2_IDR22_CRC_BIT 2
#define CAN2_IDR22_STUFF_MASK 0x8U
#define CAN2_IDR22_STUFF 0x8U
#define CAN2_IDR22_STUFF_BIT 3
#define CAN2_IDR22_BUS_MASK 0x10U
#define CAN2_IDR22_BUS 0x10U
#define CAN2_IDR22_BUS_BIT 4
#define CAN2_IDR22_RXOK_MASK 0x20U
#define CAN2_IDR22_RXOK 0x20U
#define CAN2_IDR22_RXOK_BIT 5
#define CAN2_IDR22_TXOK_MASK 0x40U
#define CAN2_IDR22_TXOK 0x40U
#define CAN2_IDR22_TXOK_BIT 6
#define CAN2_IDR22_RFRAME_MASK 0x80U
#define CAN2_IDR22_RFRAME 0x80U
#define CAN2_IDR22_RFRAME_BIT 7

#define CAN2_IMR22 (*(volatile unsigned long *)0xFFFBC6A8)
#define CAN2_IMR22_OFFSET 0x6A8
#define CAN2_IMR22_ACK_MASK 0x1U
#define CAN2_IMR22_ACK 0x1U
#define CAN2_IMR22_ACK_BIT 0
#define CAN2_IMR22_FRAME_MASK 0x2U
#define CAN2_IMR22_FRAME 0x2U
#define CAN2_IMR22_FRAME_BIT 1
#define CAN2_IMR22_CRC_MASK 0x4U
#define CAN2_IMR22_CRC 0x4U
#define CAN2_IMR22_CRC_BIT 2
#define CAN2_IMR22_STUFF_MASK 0x8U
#define CAN2_IMR22_STUFF 0x8U
#define CAN2_IMR22_STUFF_BIT 3
#define CAN2_IMR22_BUS_MASK 0x10U
#define CAN2_IMR22_BUS 0x10U
#define CAN2_IMR22_BUS_BIT 4
#define CAN2_IMR22_RXOK_MASK 0x20U
#define CAN2_IMR22_RXOK 0x20U
#define CAN2_IMR22_RXOK_BIT 5
#define CAN2_IMR22_TXOK_MASK 0x40U
#define CAN2_IMR22_TXOK 0x40U
#define CAN2_IMR22_TXOK_BIT 6
#define CAN2_IMR22_RFRAME_MASK 0x80U
#define CAN2_IMR22_RFRAME 0x80U
#define CAN2_IMR22_RFRAME_BIT 7

#define CAN2_DRA23 (*(volatile unsigned long *)0xFFFBC6C0)
#define CAN2_DRA23_OFFSET 0x6C0
#define CAN2_DRA23_DATA0_MASK 0xFFU
#define CAN2_DRA23_DATA0_BIT 0
#define CAN2_DRA23_DATA1_MASK 0xFF00U
#define CAN2_DRA23_DATA1_BIT 8
#define CAN2_DRA23_DATA2_MASK 0xFF0000U
#define CAN2_DRA23_DATA2_BIT 16
#define CAN2_DRA23_DATA3_MASK 0xFF000000U
#define CAN2_DRA23_DATA3_BIT 24

#define CAN2_DRB23 (*(volatile unsigned long *)0xFFFBC6C4)
#define CAN2_DRB23_OFFSET 0x6C4
#define CAN2_DRB23_DATA4_MASK 0xFFU
#define CAN2_DRB23_DATA4_BIT 0
#define CAN2_DRB23_DATA5_MASK 0xFF00U
#define CAN2_DRB23_DATA5_BIT 8
#define CAN2_DRB23_DATA6_MASK 0xFF0000U
#define CAN2_DRB23_DATA6_BIT 16
#define CAN2_DRB23_DATA7_MASK 0xFF000000U
#define CAN2_DRB23_DATA7_BIT 24

#define CAN2_MSK23 (*(volatile unsigned long *)0xFFFBC6C8)
#define CAN2_MSK23_OFFSET 0x6C8
#define CAN2_MSK23_MASK_MASK 0x1FFFFFFFU
#define CAN2_MSK23_MASK_BIT 0
#define CAN2_MSK23_MRB_MASK 0x60000000U
#define CAN2_MSK23_MRB_BIT 29
#define CAN2_MSK23_MRTR_MASK 0x80000000U
#define CAN2_MSK23_MRTR 0x80000000U
#define CAN2_MSK23_MRTR_BIT 31

#define CAN2_IR23 (*(volatile unsigned long *)0xFFFBC6CC)
#define CAN2_IR23_OFFSET 0x6CC
#define CAN2_IR23_ID_MASK 0x1FFFFFFFU
#define CAN2_IR23_ID_BIT 0
#define CAN2_IR23_RB_MASK 0x60000000U
#define CAN2_IR23_RB_BIT 29
#define CAN2_IR23_RTR_MASK 0x80000000U
#define CAN2_IR23_RTR 0x80000000U
#define CAN2_IR23_RTR_BIT 31

#define CAN2_CR23 (*(volatile unsigned long *)0xFFFBC6D0)
#define CAN2_CR23_OFFSET 0x6D0
#define CAN2_CR23_DLC_MASK 0xFU
#define CAN2_CR23_DLC_BIT 0
#define CAN2_CR23_IDE_MASK 0x10U
#define CAN2_CR23_IDE 0x10U
#define CAN2_CR23_IDE_BIT 4
#define CAN2_CR23_RPLYV_MASK 0x20U
#define CAN2_CR23_RPLYV 0x20U
#define CAN2_CR23_RPLYV_BIT 5
#define CAN2_CR23_PCB_MASK 0x40U
#define CAN2_CR23_PCB 0x40U
#define CAN2_CR23_PCB_BIT 6
#define CAN2_CR23_CHANEN_MASK 0x80U
#define CAN2_CR23_CHANEN 0x80U
#define CAN2_CR23_CHANEN_BIT 7
#define CAN2_CR23_OVERWRITE_MASK 0x100U
#define CAN2_CR23_OVERWRITE 0x100U
#define CAN2_CR23_OVERWRITE_BIT 8

#define CAN2_CR23 (*(volatile unsigned long *)0xFFFBC6D4)
#define CAN2_CR23_OFFSET 0x6D4
#define CAN2_CR23_STAMP_MASK 0x0U
#define CAN2_CR23_STAMP_BIT 0

#define CAN2_CSR23 (*(volatile unsigned long *)0xFFFBC6D8)
#define CAN2_CSR23_OFFSET 0x6D8
#define CAN2_CSR23_ACK_MASK 0x1U
#define CAN2_CSR23_ACK 0x1U
#define CAN2_CSR23_ACK_BIT 0
#define CAN2_CSR23_FRAME_MASK 0x2U
#define CAN2_CSR23_FRAME 0x2U
#define CAN2_CSR23_FRAME_BIT 1
#define CAN2_CSR23_CRC_MASK 0x4U
#define CAN2_CSR23_CRC 0x4U
#define CAN2_CSR23_CRC_BIT 2
#define CAN2_CSR23_STUFF_MASK 0x8U
#define CAN2_CSR23_STUFF 0x8U
#define CAN2_CSR23_STUFF_BIT 3
#define CAN2_CSR23_BUS_MASK 0x10U
#define CAN2_CSR23_BUS 0x10U
#define CAN2_CSR23_BUS_BIT 4
#define CAN2_CSR23_RXOK_MASK 0x20U
#define CAN2_CSR23_RXOK 0x20U
#define CAN2_CSR23_RXOK_BIT 5
#define CAN2_CSR23_TXOK_MASK 0x40U
#define CAN2_CSR23_TXOK 0x40U
#define CAN2_CSR23_TXOK_BIT 6
#define CAN2_CSR23_RFRAME_MASK 0x80U
#define CAN2_CSR23_RFRAME 0x80U
#define CAN2_CSR23_RFRAME_BIT 7
#define CAN2_CSR23_DLCW_MASK 0x200U
#define CAN2_CSR23_DLCW 0x200U
#define CAN2_CSR23_DLCW_BIT 9
#define CAN2_CSR23_FILLED_MASK 0x400U
#define CAN2_CSR23_FILLED 0x400U
#define CAN2_CSR23_FILLED_BIT 10
#define CAN2_CSR23_OVRUN_MASK 0x800U
#define CAN2_CSR23_OVRUN 0x800U
#define CAN2_CSR23_OVRUN_BIT 11

#define CAN2_SR23 (*(volatile unsigned long *)0xFFFBC6DC)
#define CAN2_SR23_OFFSET 0x6DC
#define CAN2_SR23_ACK_MASK 0x1U
#define CAN2_SR23_ACK 0x1U
#define CAN2_SR23_ACK_BIT 0
#define CAN2_SR23_FRAME_MASK 0x2U
#define CAN2_SR23_FRAME 0x2U
#define CAN2_SR23_FRAME_BIT 1
#define CAN2_SR23_CRC_MASK 0x4U
#define CAN2_SR23_CRC 0x4U
#define CAN2_SR23_CRC_BIT 2
#define CAN2_SR23_STUFF_MASK 0x8U
#define CAN2_SR23_STUFF 0x8U
#define CAN2_SR23_STUFF_BIT 3
#define CAN2_SR23_BUS_MASK 0x10U
#define CAN2_SR23_BUS 0x10U
#define CAN2_SR23_BUS_BIT 4
#define CAN2_SR23_RXOK_MASK 0x20U
#define CAN2_SR23_RXOK 0x20U
#define CAN2_SR23_RXOK_BIT 5
#define CAN2_SR23_TXOK_MASK 0x40U
#define CAN2_SR23_TXOK 0x40U
#define CAN2_SR23_TXOK_BIT 6
#define CAN2_SR23_RFRAME_MASK 0x80U
#define CAN2_SR23_RFRAME 0x80U
#define CAN2_SR23_RFRAME_BIT 7
#define CAN2_SR23_DLCW_MASK 0x200U
#define CAN2_SR23_DLCW 0x200U
#define CAN2_SR23_DLCW_BIT 9
#define CAN2_SR23_FILLED_MASK 0x400U
#define CAN2_SR23_FILLED 0x400U
#define CAN2_SR23_FILLED_BIT 10
#define CAN2_SR23_OVRUN_MASK 0x800U
#define CAN2_SR23_OVRUN 0x800U
#define CAN2_SR23_OVRUN_BIT 11

#define CAN2_IER23 (*(volatile unsigned long *)0xFFFBC6E0)
#define CAN2_IER23_OFFSET 0x6E0
#define CAN2_IER23_ACK_MASK 0x1U
#define CAN2_IER23_ACK 0x1U
#define CAN2_IER23_ACK_BIT 0
#define CAN2_IER23_FRAME_MASK 0x2U
#define CAN2_IER23_FRAME 0x2U
#define CAN2_IER23_FRAME_BIT 1
#define CAN2_IER23_CRC_MASK 0x4U
#define CAN2_IER23_CRC 0x4U
#define CAN2_IER23_CRC_BIT 2
#define CAN2_IER23_STUFF_MASK 0x8U
#define CAN2_IER23_STUFF 0x8U
#define CAN2_IER23_STUFF_BIT 3
#define CAN2_IER23_BUS_MASK 0x10U
#define CAN2_IER23_BUS 0x10U
#define CAN2_IER23_BUS_BIT 4
#define CAN2_IER23_RXOK_MASK 0x20U
#define CAN2_IER23_RXOK 0x20U
#define CAN2_IER23_RXOK_BIT 5
#define CAN2_IER23_TXOK_MASK 0x40U
#define CAN2_IER23_TXOK 0x40U
#define CAN2_IER23_TXOK_BIT 6
#define CAN2_IER23_RFRAME_MASK 0x80U
#define CAN2_IER23_RFRAME 0x80U
#define CAN2_IER23_RFRAME_BIT 7

#define CAN2_IDR23 (*(volatile unsigned long *)0xFFFBC6E4)
#define CAN2_IDR23_OFFSET 0x6E4
#define CAN2_IDR23_ACK_MASK 0x1U
#define CAN2_IDR23_ACK 0x1U
#define CAN2_IDR23_ACK_BIT 0
#define CAN2_IDR23_FRAME_MASK 0x2U
#define CAN2_IDR23_FRAME 0x2U
#define CAN2_IDR23_FRAME_BIT 1
#define CAN2_IDR23_CRC_MASK 0x4U
#define CAN2_IDR23_CRC 0x4U
#define CAN2_IDR23_CRC_BIT 2
#define CAN2_IDR23_STUFF_MASK 0x8U
#define CAN2_IDR23_STUFF 0x8U
#define CAN2_IDR23_STUFF_BIT 3
#define CAN2_IDR23_BUS_MASK 0x10U
#define CAN2_IDR23_BUS 0x10U
#define CAN2_IDR23_BUS_BIT 4
#define CAN2_IDR23_RXOK_MASK 0x20U
#define CAN2_IDR23_RXOK 0x20U
#define CAN2_IDR23_RXOK_BIT 5
#define CAN2_IDR23_TXOK_MASK 0x40U
#define CAN2_IDR23_TXOK 0x40U
#define CAN2_IDR23_TXOK_BIT 6
#define CAN2_IDR23_RFRAME_MASK 0x80U
#define CAN2_IDR23_RFRAME 0x80U
#define CAN2_IDR23_RFRAME_BIT 7

#define CAN2_IMR23 (*(volatile unsigned long *)0xFFFBC6E8)
#define CAN2_IMR23_OFFSET 0x6E8
#define CAN2_IMR23_ACK_MASK 0x1U
#define CAN2_IMR23_ACK 0x1U
#define CAN2_IMR23_ACK_BIT 0
#define CAN2_IMR23_FRAME_MASK 0x2U
#define CAN2_IMR23_FRAME 0x2U
#define CAN2_IMR23_FRAME_BIT 1
#define CAN2_IMR23_CRC_MASK 0x4U
#define CAN2_IMR23_CRC 0x4U
#define CAN2_IMR23_CRC_BIT 2
#define CAN2_IMR23_STUFF_MASK 0x8U
#define CAN2_IMR23_STUFF 0x8U
#define CAN2_IMR23_STUFF_BIT 3
#define CAN2_IMR23_BUS_MASK 0x10U
#define CAN2_IMR23_BUS 0x10U
#define CAN2_IMR23_BUS_BIT 4
#define CAN2_IMR23_RXOK_MASK 0x20U
#define CAN2_IMR23_RXOK 0x20U
#define CAN2_IMR23_RXOK_BIT 5
#define CAN2_IMR23_TXOK_MASK 0x40U
#define CAN2_IMR23_TXOK 0x40U
#define CAN2_IMR23_TXOK_BIT 6
#define CAN2_IMR23_RFRAME_MASK 0x80U
#define CAN2_IMR23_RFRAME 0x80U
#define CAN2_IMR23_RFRAME_BIT 7

#define CAN2_DRA24 (*(volatile unsigned long *)0xFFFBC700)
#define CAN2_DRA24_OFFSET 0x700
#define CAN2_DRA24_DATA0_MASK 0xFFU
#define CAN2_DRA24_DATA0_BIT 0
#define CAN2_DRA24_DATA1_MASK 0xFF00U
#define CAN2_DRA24_DATA1_BIT 8
#define CAN2_DRA24_DATA2_MASK 0xFF0000U
#define CAN2_DRA24_DATA2_BIT 16
#define CAN2_DRA24_DATA3_MASK 0xFF000000U
#define CAN2_DRA24_DATA3_BIT 24

#define CAN2_DRB24 (*(volatile unsigned long *)0xFFFBC704)
#define CAN2_DRB24_OFFSET 0x704
#define CAN2_DRB24_DATA4_MASK 0xFFU
#define CAN2_DRB24_DATA4_BIT 0
#define CAN2_DRB24_DATA5_MASK 0xFF00U
#define CAN2_DRB24_DATA5_BIT 8
#define CAN2_DRB24_DATA6_MASK 0xFF0000U
#define CAN2_DRB24_DATA6_BIT 16
#define CAN2_DRB24_DATA7_MASK 0xFF000000U
#define CAN2_DRB24_DATA7_BIT 24

#define CAN2_MSK24 (*(volatile unsigned long *)0xFFFBC708)
#define CAN2_MSK24_OFFSET 0x708
#define CAN2_MSK24_MASK_MASK 0x1FFFFFFFU
#define CAN2_MSK24_MASK_BIT 0
#define CAN2_MSK24_MRB_MASK 0x60000000U
#define CAN2_MSK24_MRB_BIT 29
#define CAN2_MSK24_MRTR_MASK 0x80000000U
#define CAN2_MSK24_MRTR 0x80000000U
#define CAN2_MSK24_MRTR_BIT 31

#define CAN2_IR24 (*(volatile unsigned long *)0xFFFBC70C)
#define CAN2_IR24_OFFSET 0x70C
#define CAN2_IR24_ID_MASK 0x1FFFFFFFU
#define CAN2_IR24_ID_BIT 0
#define CAN2_IR24_RB_MASK 0x60000000U
#define CAN2_IR24_RB_BIT 29
#define CAN2_IR24_RTR_MASK 0x80000000U
#define CAN2_IR24_RTR 0x80000000U
#define CAN2_IR24_RTR_BIT 31

#define CAN2_CR24 (*(volatile unsigned long *)0xFFFBC710)
#define CAN2_CR24_OFFSET 0x710
#define CAN2_CR24_DLC_MASK 0xFU
#define CAN2_CR24_DLC_BIT 0
#define CAN2_CR24_IDE_MASK 0x10U
#define CAN2_CR24_IDE 0x10U
#define CAN2_CR24_IDE_BIT 4
#define CAN2_CR24_RPLYV_MASK 0x20U
#define CAN2_CR24_RPLYV 0x20U
#define CAN2_CR24_RPLYV_BIT 5
#define CAN2_CR24_PCB_MASK 0x40U
#define CAN2_CR24_PCB 0x40U
#define CAN2_CR24_PCB_BIT 6
#define CAN2_CR24_CHANEN_MASK 0x80U
#define CAN2_CR24_CHANEN 0x80U
#define CAN2_CR24_CHANEN_BIT 7
#define CAN2_CR24_OVERWRITE_MASK 0x100U
#define CAN2_CR24_OVERWRITE 0x100U
#define CAN2_CR24_OVERWRITE_BIT 8

#define CAN2_CR24 (*(volatile unsigned long *)0xFFFBC714)
#define CAN2_CR24_OFFSET 0x714
#define CAN2_CR24_STAMP_MASK 0x0U
#define CAN2_CR24_STAMP_BIT 0

#define CAN2_CSR24 (*(volatile unsigned long *)0xFFFBC718)
#define CAN2_CSR24_OFFSET 0x718
#define CAN2_CSR24_ACK_MASK 0x1U
#define CAN2_CSR24_ACK 0x1U
#define CAN2_CSR24_ACK_BIT 0
#define CAN2_CSR24_FRAME_MASK 0x2U
#define CAN2_CSR24_FRAME 0x2U
#define CAN2_CSR24_FRAME_BIT 1
#define CAN2_CSR24_CRC_MASK 0x4U
#define CAN2_CSR24_CRC 0x4U
#define CAN2_CSR24_CRC_BIT 2
#define CAN2_CSR24_STUFF_MASK 0x8U
#define CAN2_CSR24_STUFF 0x8U
#define CAN2_CSR24_STUFF_BIT 3
#define CAN2_CSR24_BUS_MASK 0x10U
#define CAN2_CSR24_BUS 0x10U
#define CAN2_CSR24_BUS_BIT 4
#define CAN2_CSR24_RXOK_MASK 0x20U
#define CAN2_CSR24_RXOK 0x20U
#define CAN2_CSR24_RXOK_BIT 5
#define CAN2_CSR24_TXOK_MASK 0x40U
#define CAN2_CSR24_TXOK 0x40U
#define CAN2_CSR24_TXOK_BIT 6
#define CAN2_CSR24_RFRAME_MASK 0x80U
#define CAN2_CSR24_RFRAME 0x80U
#define CAN2_CSR24_RFRAME_BIT 7
#define CAN2_CSR24_DLCW_MASK 0x200U
#define CAN2_CSR24_DLCW 0x200U
#define CAN2_CSR24_DLCW_BIT 9
#define CAN2_CSR24_FILLED_MASK 0x400U
#define CAN2_CSR24_FILLED 0x400U
#define CAN2_CSR24_FILLED_BIT 10
#define CAN2_CSR24_OVRUN_MASK 0x800U
#define CAN2_CSR24_OVRUN 0x800U
#define CAN2_CSR24_OVRUN_BIT 11

#define CAN2_SR24 (*(volatile unsigned long *)0xFFFBC71C)
#define CAN2_SR24_OFFSET 0x71C
#define CAN2_SR24_ACK_MASK 0x1U
#define CAN2_SR24_ACK 0x1U
#define CAN2_SR24_ACK_BIT 0
#define CAN2_SR24_FRAME_MASK 0x2U
#define CAN2_SR24_FRAME 0x2U
#define CAN2_SR24_FRAME_BIT 1
#define CAN2_SR24_CRC_MASK 0x4U
#define CAN2_SR24_CRC 0x4U
#define CAN2_SR24_CRC_BIT 2
#define CAN2_SR24_STUFF_MASK 0x8U
#define CAN2_SR24_STUFF 0x8U
#define CAN2_SR24_STUFF_BIT 3
#define CAN2_SR24_BUS_MASK 0x10U
#define CAN2_SR24_BUS 0x10U
#define CAN2_SR24_BUS_BIT 4
#define CAN2_SR24_RXOK_MASK 0x20U
#define CAN2_SR24_RXOK 0x20U
#define CAN2_SR24_RXOK_BIT 5
#define CAN2_SR24_TXOK_MASK 0x40U
#define CAN2_SR24_TXOK 0x40U
#define CAN2_SR24_TXOK_BIT 6
#define CAN2_SR24_RFRAME_MASK 0x80U
#define CAN2_SR24_RFRAME 0x80U
#define CAN2_SR24_RFRAME_BIT 7
#define CAN2_SR24_DLCW_MASK 0x200U
#define CAN2_SR24_DLCW 0x200U
#define CAN2_SR24_DLCW_BIT 9
#define CAN2_SR24_FILLED_MASK 0x400U
#define CAN2_SR24_FILLED 0x400U
#define CAN2_SR24_FILLED_BIT 10
#define CAN2_SR24_OVRUN_MASK 0x800U
#define CAN2_SR24_OVRUN 0x800U
#define CAN2_SR24_OVRUN_BIT 11

#define CAN2_IER24 (*(volatile unsigned long *)0xFFFBC720)
#define CAN2_IER24_OFFSET 0x720
#define CAN2_IER24_ACK_MASK 0x1U
#define CAN2_IER24_ACK 0x1U
#define CAN2_IER24_ACK_BIT 0
#define CAN2_IER24_FRAME_MASK 0x2U
#define CAN2_IER24_FRAME 0x2U
#define CAN2_IER24_FRAME_BIT 1
#define CAN2_IER24_CRC_MASK 0x4U
#define CAN2_IER24_CRC 0x4U
#define CAN2_IER24_CRC_BIT 2
#define CAN2_IER24_STUFF_MASK 0x8U
#define CAN2_IER24_STUFF 0x8U
#define CAN2_IER24_STUFF_BIT 3
#define CAN2_IER24_BUS_MASK 0x10U
#define CAN2_IER24_BUS 0x10U
#define CAN2_IER24_BUS_BIT 4
#define CAN2_IER24_RXOK_MASK 0x20U
#define CAN2_IER24_RXOK 0x20U
#define CAN2_IER24_RXOK_BIT 5
#define CAN2_IER24_TXOK_MASK 0x40U
#define CAN2_IER24_TXOK 0x40U
#define CAN2_IER24_TXOK_BIT 6
#define CAN2_IER24_RFRAME_MASK 0x80U
#define CAN2_IER24_RFRAME 0x80U
#define CAN2_IER24_RFRAME_BIT 7

#define CAN2_IDR24 (*(volatile unsigned long *)0xFFFBC724)
#define CAN2_IDR24_OFFSET 0x724
#define CAN2_IDR24_ACK_MASK 0x1U
#define CAN2_IDR24_ACK 0x1U
#define CAN2_IDR24_ACK_BIT 0
#define CAN2_IDR24_FRAME_MASK 0x2U
#define CAN2_IDR24_FRAME 0x2U
#define CAN2_IDR24_FRAME_BIT 1
#define CAN2_IDR24_CRC_MASK 0x4U
#define CAN2_IDR24_CRC 0x4U
#define CAN2_IDR24_CRC_BIT 2
#define CAN2_IDR24_STUFF_MASK 0x8U
#define CAN2_IDR24_STUFF 0x8U
#define CAN2_IDR24_STUFF_BIT 3
#define CAN2_IDR24_BUS_MASK 0x10U
#define CAN2_IDR24_BUS 0x10U
#define CAN2_IDR24_BUS_BIT 4
#define CAN2_IDR24_RXOK_MASK 0x20U
#define CAN2_IDR24_RXOK 0x20U
#define CAN2_IDR24_RXOK_BIT 5
#define CAN2_IDR24_TXOK_MASK 0x40U
#define CAN2_IDR24_TXOK 0x40U
#define CAN2_IDR24_TXOK_BIT 6
#define CAN2_IDR24_RFRAME_MASK 0x80U
#define CAN2_IDR24_RFRAME 0x80U
#define CAN2_IDR24_RFRAME_BIT 7

#define CAN2_IMR24 (*(volatile unsigned long *)0xFFFBC728)
#define CAN2_IMR24_OFFSET 0x728
#define CAN2_IMR24_ACK_MASK 0x1U
#define CAN2_IMR24_ACK 0x1U
#define CAN2_IMR24_ACK_BIT 0
#define CAN2_IMR24_FRAME_MASK 0x2U
#define CAN2_IMR24_FRAME 0x2U
#define CAN2_IMR24_FRAME_BIT 1
#define CAN2_IMR24_CRC_MASK 0x4U
#define CAN2_IMR24_CRC 0x4U
#define CAN2_IMR24_CRC_BIT 2
#define CAN2_IMR24_STUFF_MASK 0x8U
#define CAN2_IMR24_STUFF 0x8U
#define CAN2_IMR24_STUFF_BIT 3
#define CAN2_IMR24_BUS_MASK 0x10U
#define CAN2_IMR24_BUS 0x10U
#define CAN2_IMR24_BUS_BIT 4
#define CAN2_IMR24_RXOK_MASK 0x20U
#define CAN2_IMR24_RXOK 0x20U
#define CAN2_IMR24_RXOK_BIT 5
#define CAN2_IMR24_TXOK_MASK 0x40U
#define CAN2_IMR24_TXOK 0x40U
#define CAN2_IMR24_TXOK_BIT 6
#define CAN2_IMR24_RFRAME_MASK 0x80U
#define CAN2_IMR24_RFRAME 0x80U
#define CAN2_IMR24_RFRAME_BIT 7

#define CAN2_DRA25 (*(volatile unsigned long *)0xFFFBC740)
#define CAN2_DRA25_OFFSET 0x740
#define CAN2_DRA25_DATA0_MASK 0xFFU
#define CAN2_DRA25_DATA0_BIT 0
#define CAN2_DRA25_DATA1_MASK 0xFF00U
#define CAN2_DRA25_DATA1_BIT 8
#define CAN2_DRA25_DATA2_MASK 0xFF0000U
#define CAN2_DRA25_DATA2_BIT 16
#define CAN2_DRA25_DATA3_MASK 0xFF000000U
#define CAN2_DRA25_DATA3_BIT 24

#define CAN2_DRB25 (*(volatile unsigned long *)0xFFFBC744)
#define CAN2_DRB25_OFFSET 0x744
#define CAN2_DRB25_DATA4_MASK 0xFFU
#define CAN2_DRB25_DATA4_BIT 0
#define CAN2_DRB25_DATA5_MASK 0xFF00U
#define CAN2_DRB25_DATA5_BIT 8
#define CAN2_DRB25_DATA6_MASK 0xFF0000U
#define CAN2_DRB25_DATA6_BIT 16
#define CAN2_DRB25_DATA7_MASK 0xFF000000U
#define CAN2_DRB25_DATA7_BIT 24

#define CAN2_MSK25 (*(volatile unsigned long *)0xFFFBC748)
#define CAN2_MSK25_OFFSET 0x748
#define CAN2_MSK25_MASK_MASK 0x1FFFFFFFU
#define CAN2_MSK25_MASK_BIT 0
#define CAN2_MSK25_MRB_MASK 0x60000000U
#define CAN2_MSK25_MRB_BIT 29
#define CAN2_MSK25_MRTR_MASK 0x80000000U
#define CAN2_MSK25_MRTR 0x80000000U
#define CAN2_MSK25_MRTR_BIT 31

#define CAN2_IR25 (*(volatile unsigned long *)0xFFFBC74C)
#define CAN2_IR25_OFFSET 0x74C
#define CAN2_IR25_ID_MASK 0x1FFFFFFFU
#define CAN2_IR25_ID_BIT 0
#define CAN2_IR25_RB_MASK 0x60000000U
#define CAN2_IR25_RB_BIT 29
#define CAN2_IR25_RTR_MASK 0x80000000U
#define CAN2_IR25_RTR 0x80000000U
#define CAN2_IR25_RTR_BIT 31

#define CAN2_CR25 (*(volatile unsigned long *)0xFFFBC750)
#define CAN2_CR25_OFFSET 0x750
#define CAN2_CR25_DLC_MASK 0xFU
#define CAN2_CR25_DLC_BIT 0
#define CAN2_CR25_IDE_MASK 0x10U
#define CAN2_CR25_IDE 0x10U
#define CAN2_CR25_IDE_BIT 4
#define CAN2_CR25_RPLYV_MASK 0x20U
#define CAN2_CR25_RPLYV 0x20U
#define CAN2_CR25_RPLYV_BIT 5
#define CAN2_CR25_PCB_MASK 0x40U
#define CAN2_CR25_PCB 0x40U
#define CAN2_CR25_PCB_BIT 6
#define CAN2_CR25_CHANEN_MASK 0x80U
#define CAN2_CR25_CHANEN 0x80U
#define CAN2_CR25_CHANEN_BIT 7
#define CAN2_CR25_OVERWRITE_MASK 0x100U
#define CAN2_CR25_OVERWRITE 0x100U
#define CAN2_CR25_OVERWRITE_BIT 8

#define CAN2_CR25 (*(volatile unsigned long *)0xFFFBC754)
#define CAN2_CR25_OFFSET 0x754
#define CAN2_CR25_STAMP_MASK 0x0U
#define CAN2_CR25_STAMP_BIT 0

#define CAN2_CSR25 (*(volatile unsigned long *)0xFFFBC758)
#define CAN2_CSR25_OFFSET 0x758
#define CAN2_CSR25_ACK_MASK 0x1U
#define CAN2_CSR25_ACK 0x1U
#define CAN2_CSR25_ACK_BIT 0
#define CAN2_CSR25_FRAME_MASK 0x2U
#define CAN2_CSR25_FRAME 0x2U
#define CAN2_CSR25_FRAME_BIT 1
#define CAN2_CSR25_CRC_MASK 0x4U
#define CAN2_CSR25_CRC 0x4U
#define CAN2_CSR25_CRC_BIT 2
#define CAN2_CSR25_STUFF_MASK 0x8U
#define CAN2_CSR25_STUFF 0x8U
#define CAN2_CSR25_STUFF_BIT 3
#define CAN2_CSR25_BUS_MASK 0x10U
#define CAN2_CSR25_BUS 0x10U
#define CAN2_CSR25_BUS_BIT 4
#define CAN2_CSR25_RXOK_MASK 0x20U
#define CAN2_CSR25_RXOK 0x20U
#define CAN2_CSR25_RXOK_BIT 5
#define CAN2_CSR25_TXOK_MASK 0x40U
#define CAN2_CSR25_TXOK 0x40U
#define CAN2_CSR25_TXOK_BIT 6
#define CAN2_CSR25_RFRAME_MASK 0x80U
#define CAN2_CSR25_RFRAME 0x80U
#define CAN2_CSR25_RFRAME_BIT 7
#define CAN2_CSR25_DLCW_MASK 0x200U
#define CAN2_CSR25_DLCW 0x200U
#define CAN2_CSR25_DLCW_BIT 9
#define CAN2_CSR25_FILLED_MASK 0x400U
#define CAN2_CSR25_FILLED 0x400U
#define CAN2_CSR25_FILLED_BIT 10
#define CAN2_CSR25_OVRUN_MASK 0x800U
#define CAN2_CSR25_OVRUN 0x800U
#define CAN2_CSR25_OVRUN_BIT 11

#define CAN2_SR25 (*(volatile unsigned long *)0xFFFBC75C)
#define CAN2_SR25_OFFSET 0x75C
#define CAN2_SR25_ACK_MASK 0x1U
#define CAN2_SR25_ACK 0x1U
#define CAN2_SR25_ACK_BIT 0
#define CAN2_SR25_FRAME_MASK 0x2U
#define CAN2_SR25_FRAME 0x2U
#define CAN2_SR25_FRAME_BIT 1
#define CAN2_SR25_CRC_MASK 0x4U
#define CAN2_SR25_CRC 0x4U
#define CAN2_SR25_CRC_BIT 2
#define CAN2_SR25_STUFF_MASK 0x8U
#define CAN2_SR25_STUFF 0x8U
#define CAN2_SR25_STUFF_BIT 3
#define CAN2_SR25_BUS_MASK 0x10U
#define CAN2_SR25_BUS 0x10U
#define CAN2_SR25_BUS_BIT 4
#define CAN2_SR25_RXOK_MASK 0x20U
#define CAN2_SR25_RXOK 0x20U
#define CAN2_SR25_RXOK_BIT 5
#define CAN2_SR25_TXOK_MASK 0x40U
#define CAN2_SR25_TXOK 0x40U
#define CAN2_SR25_TXOK_BIT 6
#define CAN2_SR25_RFRAME_MASK 0x80U
#define CAN2_SR25_RFRAME 0x80U
#define CAN2_SR25_RFRAME_BIT 7
#define CAN2_SR25_DLCW_MASK 0x200U
#define CAN2_SR25_DLCW 0x200U
#define CAN2_SR25_DLCW_BIT 9
#define CAN2_SR25_FILLED_MASK 0x400U
#define CAN2_SR25_FILLED 0x400U
#define CAN2_SR25_FILLED_BIT 10
#define CAN2_SR25_OVRUN_MASK 0x800U
#define CAN2_SR25_OVRUN 0x800U
#define CAN2_SR25_OVRUN_BIT 11

#define CAN2_IER25 (*(volatile unsigned long *)0xFFFBC760)
#define CAN2_IER25_OFFSET 0x760
#define CAN2_IER25_ACK_MASK 0x1U
#define CAN2_IER25_ACK 0x1U
#define CAN2_IER25_ACK_BIT 0
#define CAN2_IER25_FRAME_MASK 0x2U
#define CAN2_IER25_FRAME 0x2U
#define CAN2_IER25_FRAME_BIT 1
#define CAN2_IER25_CRC_MASK 0x4U
#define CAN2_IER25_CRC 0x4U
#define CAN2_IER25_CRC_BIT 2
#define CAN2_IER25_STUFF_MASK 0x8U
#define CAN2_IER25_STUFF 0x8U
#define CAN2_IER25_STUFF_BIT 3
#define CAN2_IER25_BUS_MASK 0x10U
#define CAN2_IER25_BUS 0x10U
#define CAN2_IER25_BUS_BIT 4
#define CAN2_IER25_RXOK_MASK 0x20U
#define CAN2_IER25_RXOK 0x20U
#define CAN2_IER25_RXOK_BIT 5
#define CAN2_IER25_TXOK_MASK 0x40U
#define CAN2_IER25_TXOK 0x40U
#define CAN2_IER25_TXOK_BIT 6
#define CAN2_IER25_RFRAME_MASK 0x80U
#define CAN2_IER25_RFRAME 0x80U
#define CAN2_IER25_RFRAME_BIT 7

#define CAN2_IDR25 (*(volatile unsigned long *)0xFFFBC764)
#define CAN2_IDR25_OFFSET 0x764
#define CAN2_IDR25_ACK_MASK 0x1U
#define CAN2_IDR25_ACK 0x1U
#define CAN2_IDR25_ACK_BIT 0
#define CAN2_IDR25_FRAME_MASK 0x2U
#define CAN2_IDR25_FRAME 0x2U
#define CAN2_IDR25_FRAME_BIT 1
#define CAN2_IDR25_CRC_MASK 0x4U
#define CAN2_IDR25_CRC 0x4U
#define CAN2_IDR25_CRC_BIT 2
#define CAN2_IDR25_STUFF_MASK 0x8U
#define CAN2_IDR25_STUFF 0x8U
#define CAN2_IDR25_STUFF_BIT 3
#define CAN2_IDR25_BUS_MASK 0x10U
#define CAN2_IDR25_BUS 0x10U
#define CAN2_IDR25_BUS_BIT 4
#define CAN2_IDR25_RXOK_MASK 0x20U
#define CAN2_IDR25_RXOK 0x20U
#define CAN2_IDR25_RXOK_BIT 5
#define CAN2_IDR25_TXOK_MASK 0x40U
#define CAN2_IDR25_TXOK 0x40U
#define CAN2_IDR25_TXOK_BIT 6
#define CAN2_IDR25_RFRAME_MASK 0x80U
#define CAN2_IDR25_RFRAME 0x80U
#define CAN2_IDR25_RFRAME_BIT 7

#define CAN2_IMR25 (*(volatile unsigned long *)0xFFFBC768)
#define CAN2_IMR25_OFFSET 0x768
#define CAN2_IMR25_ACK_MASK 0x1U
#define CAN2_IMR25_ACK 0x1U
#define CAN2_IMR25_ACK_BIT 0
#define CAN2_IMR25_FRAME_MASK 0x2U
#define CAN2_IMR25_FRAME 0x2U
#define CAN2_IMR25_FRAME_BIT 1
#define CAN2_IMR25_CRC_MASK 0x4U
#define CAN2_IMR25_CRC 0x4U
#define CAN2_IMR25_CRC_BIT 2
#define CAN2_IMR25_STUFF_MASK 0x8U
#define CAN2_IMR25_STUFF 0x8U
#define CAN2_IMR25_STUFF_BIT 3
#define CAN2_IMR25_BUS_MASK 0x10U
#define CAN2_IMR25_BUS 0x10U
#define CAN2_IMR25_BUS_BIT 4
#define CAN2_IMR25_RXOK_MASK 0x20U
#define CAN2_IMR25_RXOK 0x20U
#define CAN2_IMR25_RXOK_BIT 5
#define CAN2_IMR25_TXOK_MASK 0x40U
#define CAN2_IMR25_TXOK 0x40U
#define CAN2_IMR25_TXOK_BIT 6
#define CAN2_IMR25_RFRAME_MASK 0x80U
#define CAN2_IMR25_RFRAME 0x80U
#define CAN2_IMR25_RFRAME_BIT 7

#define CAN2_DRA26 (*(volatile unsigned long *)0xFFFBC780)
#define CAN2_DRA26_OFFSET 0x780
#define CAN2_DRA26_DATA0_MASK 0xFFU
#define CAN2_DRA26_DATA0_BIT 0
#define CAN2_DRA26_DATA1_MASK 0xFF00U
#define CAN2_DRA26_DATA1_BIT 8
#define CAN2_DRA26_DATA2_MASK 0xFF0000U
#define CAN2_DRA26_DATA2_BIT 16
#define CAN2_DRA26_DATA3_MASK 0xFF000000U
#define CAN2_DRA26_DATA3_BIT 24

#define CAN2_DRB26 (*(volatile unsigned long *)0xFFFBC784)
#define CAN2_DRB26_OFFSET 0x784
#define CAN2_DRB26_DATA4_MASK 0xFFU
#define CAN2_DRB26_DATA4_BIT 0
#define CAN2_DRB26_DATA5_MASK 0xFF00U
#define CAN2_DRB26_DATA5_BIT 8
#define CAN2_DRB26_DATA6_MASK 0xFF0000U
#define CAN2_DRB26_DATA6_BIT 16
#define CAN2_DRB26_DATA7_MASK 0xFF000000U
#define CAN2_DRB26_DATA7_BIT 24

#define CAN2_MSK26 (*(volatile unsigned long *)0xFFFBC788)
#define CAN2_MSK26_OFFSET 0x788
#define CAN2_MSK26_MASK_MASK 0x1FFFFFFFU
#define CAN2_MSK26_MASK_BIT 0
#define CAN2_MSK26_MRB_MASK 0x60000000U
#define CAN2_MSK26_MRB_BIT 29
#define CAN2_MSK26_MRTR_MASK 0x80000000U
#define CAN2_MSK26_MRTR 0x80000000U
#define CAN2_MSK26_MRTR_BIT 31

#define CAN2_IR26 (*(volatile unsigned long *)0xFFFBC78C)
#define CAN2_IR26_OFFSET 0x78C
#define CAN2_IR26_ID_MASK 0x1FFFFFFFU
#define CAN2_IR26_ID_BIT 0
#define CAN2_IR26_RB_MASK 0x60000000U
#define CAN2_IR26_RB_BIT 29
#define CAN2_IR26_RTR_MASK 0x80000000U
#define CAN2_IR26_RTR 0x80000000U
#define CAN2_IR26_RTR_BIT 31

#define CAN2_CR26 (*(volatile unsigned long *)0xFFFBC790)
#define CAN2_CR26_OFFSET 0x790
#define CAN2_CR26_DLC_MASK 0xFU
#define CAN2_CR26_DLC_BIT 0
#define CAN2_CR26_IDE_MASK 0x10U
#define CAN2_CR26_IDE 0x10U
#define CAN2_CR26_IDE_BIT 4
#define CAN2_CR26_RPLYV_MASK 0x20U
#define CAN2_CR26_RPLYV 0x20U
#define CAN2_CR26_RPLYV_BIT 5
#define CAN2_CR26_PCB_MASK 0x40U
#define CAN2_CR26_PCB 0x40U
#define CAN2_CR26_PCB_BIT 6
#define CAN2_CR26_CHANEN_MASK 0x80U
#define CAN2_CR26_CHANEN 0x80U
#define CAN2_CR26_CHANEN_BIT 7
#define CAN2_CR26_OVERWRITE_MASK 0x100U
#define CAN2_CR26_OVERWRITE 0x100U
#define CAN2_CR26_OVERWRITE_BIT 8

#define CAN2_CR26 (*(volatile unsigned long *)0xFFFBC794)
#define CAN2_CR26_OFFSET 0x794
#define CAN2_CR26_STAMP_MASK 0x0U
#define CAN2_CR26_STAMP_BIT 0

#define CAN2_CSR26 (*(volatile unsigned long *)0xFFFBC798)
#define CAN2_CSR26_OFFSET 0x798
#define CAN2_CSR26_ACK_MASK 0x1U
#define CAN2_CSR26_ACK 0x1U
#define CAN2_CSR26_ACK_BIT 0
#define CAN2_CSR26_FRAME_MASK 0x2U
#define CAN2_CSR26_FRAME 0x2U
#define CAN2_CSR26_FRAME_BIT 1
#define CAN2_CSR26_CRC_MASK 0x4U
#define CAN2_CSR26_CRC 0x4U
#define CAN2_CSR26_CRC_BIT 2
#define CAN2_CSR26_STUFF_MASK 0x8U
#define CAN2_CSR26_STUFF 0x8U
#define CAN2_CSR26_STUFF_BIT 3
#define CAN2_CSR26_BUS_MASK 0x10U
#define CAN2_CSR26_BUS 0x10U
#define CAN2_CSR26_BUS_BIT 4
#define CAN2_CSR26_RXOK_MASK 0x20U
#define CAN2_CSR26_RXOK 0x20U
#define CAN2_CSR26_RXOK_BIT 5
#define CAN2_CSR26_TXOK_MASK 0x40U
#define CAN2_CSR26_TXOK 0x40U
#define CAN2_CSR26_TXOK_BIT 6
#define CAN2_CSR26_RFRAME_MASK 0x80U
#define CAN2_CSR26_RFRAME 0x80U
#define CAN2_CSR26_RFRAME_BIT 7
#define CAN2_CSR26_DLCW_MASK 0x200U
#define CAN2_CSR26_DLCW 0x200U
#define CAN2_CSR26_DLCW_BIT 9
#define CAN2_CSR26_FILLED_MASK 0x400U
#define CAN2_CSR26_FILLED 0x400U
#define CAN2_CSR26_FILLED_BIT 10
#define CAN2_CSR26_OVRUN_MASK 0x800U
#define CAN2_CSR26_OVRUN 0x800U
#define CAN2_CSR26_OVRUN_BIT 11

#define CAN2_SR26 (*(volatile unsigned long *)0xFFFBC79C)
#define CAN2_SR26_OFFSET 0x79C
#define CAN2_SR26_ACK_MASK 0x1U
#define CAN2_SR26_ACK 0x1U
#define CAN2_SR26_ACK_BIT 0
#define CAN2_SR26_FRAME_MASK 0x2U
#define CAN2_SR26_FRAME 0x2U
#define CAN2_SR26_FRAME_BIT 1
#define CAN2_SR26_CRC_MASK 0x4U
#define CAN2_SR26_CRC 0x4U
#define CAN2_SR26_CRC_BIT 2
#define CAN2_SR26_STUFF_MASK 0x8U
#define CAN2_SR26_STUFF 0x8U
#define CAN2_SR26_STUFF_BIT 3
#define CAN2_SR26_BUS_MASK 0x10U
#define CAN2_SR26_BUS 0x10U
#define CAN2_SR26_BUS_BIT 4
#define CAN2_SR26_RXOK_MASK 0x20U
#define CAN2_SR26_RXOK 0x20U
#define CAN2_SR26_RXOK_BIT 5
#define CAN2_SR26_TXOK_MASK 0x40U
#define CAN2_SR26_TXOK 0x40U
#define CAN2_SR26_TXOK_BIT 6
#define CAN2_SR26_RFRAME_MASK 0x80U
#define CAN2_SR26_RFRAME 0x80U
#define CAN2_SR26_RFRAME_BIT 7
#define CAN2_SR26_DLCW_MASK 0x200U
#define CAN2_SR26_DLCW 0x200U
#define CAN2_SR26_DLCW_BIT 9
#define CAN2_SR26_FILLED_MASK 0x400U
#define CAN2_SR26_FILLED 0x400U
#define CAN2_SR26_FILLED_BIT 10
#define CAN2_SR26_OVRUN_MASK 0x800U
#define CAN2_SR26_OVRUN 0x800U
#define CAN2_SR26_OVRUN_BIT 11

#define CAN2_IER26 (*(volatile unsigned long *)0xFFFBC7A0)
#define CAN2_IER26_OFFSET 0x7A0
#define CAN2_IER26_ACK_MASK 0x1U
#define CAN2_IER26_ACK 0x1U
#define CAN2_IER26_ACK_BIT 0
#define CAN2_IER26_FRAME_MASK 0x2U
#define CAN2_IER26_FRAME 0x2U
#define CAN2_IER26_FRAME_BIT 1
#define CAN2_IER26_CRC_MASK 0x4U
#define CAN2_IER26_CRC 0x4U
#define CAN2_IER26_CRC_BIT 2
#define CAN2_IER26_STUFF_MASK 0x8U
#define CAN2_IER26_STUFF 0x8U
#define CAN2_IER26_STUFF_BIT 3
#define CAN2_IER26_BUS_MASK 0x10U
#define CAN2_IER26_BUS 0x10U
#define CAN2_IER26_BUS_BIT 4
#define CAN2_IER26_RXOK_MASK 0x20U
#define CAN2_IER26_RXOK 0x20U
#define CAN2_IER26_RXOK_BIT 5
#define CAN2_IER26_TXOK_MASK 0x40U
#define CAN2_IER26_TXOK 0x40U
#define CAN2_IER26_TXOK_BIT 6
#define CAN2_IER26_RFRAME_MASK 0x80U
#define CAN2_IER26_RFRAME 0x80U
#define CAN2_IER26_RFRAME_BIT 7

#define CAN2_IDR26 (*(volatile unsigned long *)0xFFFBC7A4)
#define CAN2_IDR26_OFFSET 0x7A4
#define CAN2_IDR26_ACK_MASK 0x1U
#define CAN2_IDR26_ACK 0x1U
#define CAN2_IDR26_ACK_BIT 0
#define CAN2_IDR26_FRAME_MASK 0x2U
#define CAN2_IDR26_FRAME 0x2U
#define CAN2_IDR26_FRAME_BIT 1
#define CAN2_IDR26_CRC_MASK 0x4U
#define CAN2_IDR26_CRC 0x4U
#define CAN2_IDR26_CRC_BIT 2
#define CAN2_IDR26_STUFF_MASK 0x8U
#define CAN2_IDR26_STUFF 0x8U
#define CAN2_IDR26_STUFF_BIT 3
#define CAN2_IDR26_BUS_MASK 0x10U
#define CAN2_IDR26_BUS 0x10U
#define CAN2_IDR26_BUS_BIT 4
#define CAN2_IDR26_RXOK_MASK 0x20U
#define CAN2_IDR26_RXOK 0x20U
#define CAN2_IDR26_RXOK_BIT 5
#define CAN2_IDR26_TXOK_MASK 0x40U
#define CAN2_IDR26_TXOK 0x40U
#define CAN2_IDR26_TXOK_BIT 6
#define CAN2_IDR26_RFRAME_MASK 0x80U
#define CAN2_IDR26_RFRAME 0x80U
#define CAN2_IDR26_RFRAME_BIT 7

#define CAN2_IMR26 (*(volatile unsigned long *)0xFFFBC7A8)
#define CAN2_IMR26_OFFSET 0x7A8
#define CAN2_IMR26_ACK_MASK 0x1U
#define CAN2_IMR26_ACK 0x1U
#define CAN2_IMR26_ACK_BIT 0
#define CAN2_IMR26_FRAME_MASK 0x2U
#define CAN2_IMR26_FRAME 0x2U
#define CAN2_IMR26_FRAME_BIT 1
#define CAN2_IMR26_CRC_MASK 0x4U
#define CAN2_IMR26_CRC 0x4U
#define CAN2_IMR26_CRC_BIT 2
#define CAN2_IMR26_STUFF_MASK 0x8U
#define CAN2_IMR26_STUFF 0x8U
#define CAN2_IMR26_STUFF_BIT 3
#define CAN2_IMR26_BUS_MASK 0x10U
#define CAN2_IMR26_BUS 0x10U
#define CAN2_IMR26_BUS_BIT 4
#define CAN2_IMR26_RXOK_MASK 0x20U
#define CAN2_IMR26_RXOK 0x20U
#define CAN2_IMR26_RXOK_BIT 5
#define CAN2_IMR26_TXOK_MASK 0x40U
#define CAN2_IMR26_TXOK 0x40U
#define CAN2_IMR26_TXOK_BIT 6
#define CAN2_IMR26_RFRAME_MASK 0x80U
#define CAN2_IMR26_RFRAME 0x80U
#define CAN2_IMR26_RFRAME_BIT 7

#define CAN2_DRA27 (*(volatile unsigned long *)0xFFFBC7C0)
#define CAN2_DRA27_OFFSET 0x7C0
#define CAN2_DRA27_DATA0_MASK 0xFFU
#define CAN2_DRA27_DATA0_BIT 0
#define CAN2_DRA27_DATA1_MASK 0xFF00U
#define CAN2_DRA27_DATA1_BIT 8
#define CAN2_DRA27_DATA2_MASK 0xFF0000U
#define CAN2_DRA27_DATA2_BIT 16
#define CAN2_DRA27_DATA3_MASK 0xFF000000U
#define CAN2_DRA27_DATA3_BIT 24

#define CAN2_DRB27 (*(volatile unsigned long *)0xFFFBC7C4)
#define CAN2_DRB27_OFFSET 0x7C4
#define CAN2_DRB27_DATA4_MASK 0xFFU
#define CAN2_DRB27_DATA4_BIT 0
#define CAN2_DRB27_DATA5_MASK 0xFF00U
#define CAN2_DRB27_DATA5_BIT 8
#define CAN2_DRB27_DATA6_MASK 0xFF0000U
#define CAN2_DRB27_DATA6_BIT 16
#define CAN2_DRB27_DATA7_MASK 0xFF000000U
#define CAN2_DRB27_DATA7_BIT 24

#define CAN2_MSK27 (*(volatile unsigned long *)0xFFFBC7C8)
#define CAN2_MSK27_OFFSET 0x7C8
#define CAN2_MSK27_MASK_MASK 0x1FFFFFFFU
#define CAN2_MSK27_MASK_BIT 0
#define CAN2_MSK27_MRB_MASK 0x60000000U
#define CAN2_MSK27_MRB_BIT 29
#define CAN2_MSK27_MRTR_MASK 0x80000000U
#define CAN2_MSK27_MRTR 0x80000000U
#define CAN2_MSK27_MRTR_BIT 31

#define CAN2_IR27 (*(volatile unsigned long *)0xFFFBC7CC)
#define CAN2_IR27_OFFSET 0x7CC
#define CAN2_IR27_ID_MASK 0x1FFFFFFFU
#define CAN2_IR27_ID_BIT 0
#define CAN2_IR27_RB_MASK 0x60000000U
#define CAN2_IR27_RB_BIT 29
#define CAN2_IR27_RTR_MASK 0x80000000U
#define CAN2_IR27_RTR 0x80000000U
#define CAN2_IR27_RTR_BIT 31

#define CAN2_CR27 (*(volatile unsigned long *)0xFFFBC7D0)
#define CAN2_CR27_OFFSET 0x7D0
#define CAN2_CR27_DLC_MASK 0xFU
#define CAN2_CR27_DLC_BIT 0
#define CAN2_CR27_IDE_MASK 0x10U
#define CAN2_CR27_IDE 0x10U
#define CAN2_CR27_IDE_BIT 4
#define CAN2_CR27_RPLYV_MASK 0x20U
#define CAN2_CR27_RPLYV 0x20U
#define CAN2_CR27_RPLYV_BIT 5
#define CAN2_CR27_PCB_MASK 0x40U
#define CAN2_CR27_PCB 0x40U
#define CAN2_CR27_PCB_BIT 6
#define CAN2_CR27_CHANEN_MASK 0x80U
#define CAN2_CR27_CHANEN 0x80U
#define CAN2_CR27_CHANEN_BIT 7
#define CAN2_CR27_OVERWRITE_MASK 0x100U
#define CAN2_CR27_OVERWRITE 0x100U
#define CAN2_CR27_OVERWRITE_BIT 8

#define CAN2_CR27 (*(volatile unsigned long *)0xFFFBC7D4)
#define CAN2_CR27_OFFSET 0x7D4
#define CAN2_CR27_STAMP_MASK 0x0U
#define CAN2_CR27_STAMP_BIT 0

#define CAN2_CSR27 (*(volatile unsigned long *)0xFFFBC7D8)
#define CAN2_CSR27_OFFSET 0x7D8
#define CAN2_CSR27_ACK_MASK 0x1U
#define CAN2_CSR27_ACK 0x1U
#define CAN2_CSR27_ACK_BIT 0
#define CAN2_CSR27_FRAME_MASK 0x2U
#define CAN2_CSR27_FRAME 0x2U
#define CAN2_CSR27_FRAME_BIT 1
#define CAN2_CSR27_CRC_MASK 0x4U
#define CAN2_CSR27_CRC 0x4U
#define CAN2_CSR27_CRC_BIT 2
#define CAN2_CSR27_STUFF_MASK 0x8U
#define CAN2_CSR27_STUFF 0x8U
#define CAN2_CSR27_STUFF_BIT 3
#define CAN2_CSR27_BUS_MASK 0x10U
#define CAN2_CSR27_BUS 0x10U
#define CAN2_CSR27_BUS_BIT 4
#define CAN2_CSR27_RXOK_MASK 0x20U
#define CAN2_CSR27_RXOK 0x20U
#define CAN2_CSR27_RXOK_BIT 5
#define CAN2_CSR27_TXOK_MASK 0x40U
#define CAN2_CSR27_TXOK 0x40U
#define CAN2_CSR27_TXOK_BIT 6
#define CAN2_CSR27_RFRAME_MASK 0x80U
#define CAN2_CSR27_RFRAME 0x80U
#define CAN2_CSR27_RFRAME_BIT 7
#define CAN2_CSR27_DLCW_MASK 0x200U
#define CAN2_CSR27_DLCW 0x200U
#define CAN2_CSR27_DLCW_BIT 9
#define CAN2_CSR27_FILLED_MASK 0x400U
#define CAN2_CSR27_FILLED 0x400U
#define CAN2_CSR27_FILLED_BIT 10
#define CAN2_CSR27_OVRUN_MASK 0x800U
#define CAN2_CSR27_OVRUN 0x800U
#define CAN2_CSR27_OVRUN_BIT 11

#define CAN2_SR27 (*(volatile unsigned long *)0xFFFBC7DC)
#define CAN2_SR27_OFFSET 0x7DC
#define CAN2_SR27_ACK_MASK 0x1U
#define CAN2_SR27_ACK 0x1U
#define CAN2_SR27_ACK_BIT 0
#define CAN2_SR27_FRAME_MASK 0x2U
#define CAN2_SR27_FRAME 0x2U
#define CAN2_SR27_FRAME_BIT 1
#define CAN2_SR27_CRC_MASK 0x4U
#define CAN2_SR27_CRC 0x4U
#define CAN2_SR27_CRC_BIT 2
#define CAN2_SR27_STUFF_MASK 0x8U
#define CAN2_SR27_STUFF 0x8U
#define CAN2_SR27_STUFF_BIT 3
#define CAN2_SR27_BUS_MASK 0x10U
#define CAN2_SR27_BUS 0x10U
#define CAN2_SR27_BUS_BIT 4
#define CAN2_SR27_RXOK_MASK 0x20U
#define CAN2_SR27_RXOK 0x20U
#define CAN2_SR27_RXOK_BIT 5
#define CAN2_SR27_TXOK_MASK 0x40U
#define CAN2_SR27_TXOK 0x40U
#define CAN2_SR27_TXOK_BIT 6
#define CAN2_SR27_RFRAME_MASK 0x80U
#define CAN2_SR27_RFRAME 0x80U
#define CAN2_SR27_RFRAME_BIT 7
#define CAN2_SR27_DLCW_MASK 0x200U
#define CAN2_SR27_DLCW 0x200U
#define CAN2_SR27_DLCW_BIT 9
#define CAN2_SR27_FILLED_MASK 0x400U
#define CAN2_SR27_FILLED 0x400U
#define CAN2_SR27_FILLED_BIT 10
#define CAN2_SR27_OVRUN_MASK 0x800U
#define CAN2_SR27_OVRUN 0x800U
#define CAN2_SR27_OVRUN_BIT 11

#define CAN2_IER27 (*(volatile unsigned long *)0xFFFBC7E0)
#define CAN2_IER27_OFFSET 0x7E0
#define CAN2_IER27_ACK_MASK 0x1U
#define CAN2_IER27_ACK 0x1U
#define CAN2_IER27_ACK_BIT 0
#define CAN2_IER27_FRAME_MASK 0x2U
#define CAN2_IER27_FRAME 0x2U
#define CAN2_IER27_FRAME_BIT 1
#define CAN2_IER27_CRC_MASK 0x4U
#define CAN2_IER27_CRC 0x4U
#define CAN2_IER27_CRC_BIT 2
#define CAN2_IER27_STUFF_MASK 0x8U
#define CAN2_IER27_STUFF 0x8U
#define CAN2_IER27_STUFF_BIT 3
#define CAN2_IER27_BUS_MASK 0x10U
#define CAN2_IER27_BUS 0x10U
#define CAN2_IER27_BUS_BIT 4
#define CAN2_IER27_RXOK_MASK 0x20U
#define CAN2_IER27_RXOK 0x20U
#define CAN2_IER27_RXOK_BIT 5
#define CAN2_IER27_TXOK_MASK 0x40U
#define CAN2_IER27_TXOK 0x40U
#define CAN2_IER27_TXOK_BIT 6
#define CAN2_IER27_RFRAME_MASK 0x80U
#define CAN2_IER27_RFRAME 0x80U
#define CAN2_IER27_RFRAME_BIT 7

#define CAN2_IDR27 (*(volatile unsigned long *)0xFFFBC7E4)
#define CAN2_IDR27_OFFSET 0x7E4
#define CAN2_IDR27_ACK_MASK 0x1U
#define CAN2_IDR27_ACK 0x1U
#define CAN2_IDR27_ACK_BIT 0
#define CAN2_IDR27_FRAME_MASK 0x2U
#define CAN2_IDR27_FRAME 0x2U
#define CAN2_IDR27_FRAME_BIT 1
#define CAN2_IDR27_CRC_MASK 0x4U
#define CAN2_IDR27_CRC 0x4U
#define CAN2_IDR27_CRC_BIT 2
#define CAN2_IDR27_STUFF_MASK 0x8U
#define CAN2_IDR27_STUFF 0x8U
#define CAN2_IDR27_STUFF_BIT 3
#define CAN2_IDR27_BUS_MASK 0x10U
#define CAN2_IDR27_BUS 0x10U
#define CAN2_IDR27_BUS_BIT 4
#define CAN2_IDR27_RXOK_MASK 0x20U
#define CAN2_IDR27_RXOK 0x20U
#define CAN2_IDR27_RXOK_BIT 5
#define CAN2_IDR27_TXOK_MASK 0x40U
#define CAN2_IDR27_TXOK 0x40U
#define CAN2_IDR27_TXOK_BIT 6
#define CAN2_IDR27_RFRAME_MASK 0x80U
#define CAN2_IDR27_RFRAME 0x80U
#define CAN2_IDR27_RFRAME_BIT 7

#define CAN2_IMR27 (*(volatile unsigned long *)0xFFFBC7E8)
#define CAN2_IMR27_OFFSET 0x7E8
#define CAN2_IMR27_ACK_MASK 0x1U
#define CAN2_IMR27_ACK 0x1U
#define CAN2_IMR27_ACK_BIT 0
#define CAN2_IMR27_FRAME_MASK 0x2U
#define CAN2_IMR27_FRAME 0x2U
#define CAN2_IMR27_FRAME_BIT 1
#define CAN2_IMR27_CRC_MASK 0x4U
#define CAN2_IMR27_CRC 0x4U
#define CAN2_IMR27_CRC_BIT 2
#define CAN2_IMR27_STUFF_MASK 0x8U
#define CAN2_IMR27_STUFF 0x8U
#define CAN2_IMR27_STUFF_BIT 3
#define CAN2_IMR27_BUS_MASK 0x10U
#define CAN2_IMR27_BUS 0x10U
#define CAN2_IMR27_BUS_BIT 4
#define CAN2_IMR27_RXOK_MASK 0x20U
#define CAN2_IMR27_RXOK 0x20U
#define CAN2_IMR27_RXOK_BIT 5
#define CAN2_IMR27_TXOK_MASK 0x40U
#define CAN2_IMR27_TXOK 0x40U
#define CAN2_IMR27_TXOK_BIT 6
#define CAN2_IMR27_RFRAME_MASK 0x80U
#define CAN2_IMR27_RFRAME 0x80U
#define CAN2_IMR27_RFRAME_BIT 7

#define CAN2_DRA28 (*(volatile unsigned long *)0xFFFBC800)
#define CAN2_DRA28_OFFSET 0x800
#define CAN2_DRA28_DATA0_MASK 0xFFU
#define CAN2_DRA28_DATA0_BIT 0
#define CAN2_DRA28_DATA1_MASK 0xFF00U
#define CAN2_DRA28_DATA1_BIT 8
#define CAN2_DRA28_DATA2_MASK 0xFF0000U
#define CAN2_DRA28_DATA2_BIT 16
#define CAN2_DRA28_DATA3_MASK 0xFF000000U
#define CAN2_DRA28_DATA3_BIT 24

#define CAN2_DRB28 (*(volatile unsigned long *)0xFFFBC804)
#define CAN2_DRB28_OFFSET 0x804
#define CAN2_DRB28_DATA4_MASK 0xFFU
#define CAN2_DRB28_DATA4_BIT 0
#define CAN2_DRB28_DATA5_MASK 0xFF00U
#define CAN2_DRB28_DATA5_BIT 8
#define CAN2_DRB28_DATA6_MASK 0xFF0000U
#define CAN2_DRB28_DATA6_BIT 16
#define CAN2_DRB28_DATA7_MASK 0xFF000000U
#define CAN2_DRB28_DATA7_BIT 24

#define CAN2_MSK28 (*(volatile unsigned long *)0xFFFBC808)
#define CAN2_MSK28_OFFSET 0x808
#define CAN2_MSK28_MASK_MASK 0x1FFFFFFFU
#define CAN2_MSK28_MASK_BIT 0
#define CAN2_MSK28_MRB_MASK 0x60000000U
#define CAN2_MSK28_MRB_BIT 29
#define CAN2_MSK28_MRTR_MASK 0x80000000U
#define CAN2_MSK28_MRTR 0x80000000U
#define CAN2_MSK28_MRTR_BIT 31

#define CAN2_IR28 (*(volatile unsigned long *)0xFFFBC80C)
#define CAN2_IR28_OFFSET 0x80C
#define CAN2_IR28_ID_MASK 0x1FFFFFFFU
#define CAN2_IR28_ID_BIT 0
#define CAN2_IR28_RB_MASK 0x60000000U
#define CAN2_IR28_RB_BIT 29
#define CAN2_IR28_RTR_MASK 0x80000000U
#define CAN2_IR28_RTR 0x80000000U
#define CAN2_IR28_RTR_BIT 31

#define CAN2_CR28 (*(volatile unsigned long *)0xFFFBC810)
#define CAN2_CR28_OFFSET 0x810
#define CAN2_CR28_DLC_MASK 0xFU
#define CAN2_CR28_DLC_BIT 0
#define CAN2_CR28_IDE_MASK 0x10U
#define CAN2_CR28_IDE 0x10U
#define CAN2_CR28_IDE_BIT 4
#define CAN2_CR28_RPLYV_MASK 0x20U
#define CAN2_CR28_RPLYV 0x20U
#define CAN2_CR28_RPLYV_BIT 5
#define CAN2_CR28_PCB_MASK 0x40U
#define CAN2_CR28_PCB 0x40U
#define CAN2_CR28_PCB_BIT 6
#define CAN2_CR28_CHANEN_MASK 0x80U
#define CAN2_CR28_CHANEN 0x80U
#define CAN2_CR28_CHANEN_BIT 7
#define CAN2_CR28_OVERWRITE_MASK 0x100U
#define CAN2_CR28_OVERWRITE 0x100U
#define CAN2_CR28_OVERWRITE_BIT 8

#define CAN2_CR28 (*(volatile unsigned long *)0xFFFBC814)
#define CAN2_CR28_OFFSET 0x814
#define CAN2_CR28_STAMP_MASK 0x0U
#define CAN2_CR28_STAMP_BIT 0

#define CAN2_CSR28 (*(volatile unsigned long *)0xFFFBC818)
#define CAN2_CSR28_OFFSET 0x818
#define CAN2_CSR28_ACK_MASK 0x1U
#define CAN2_CSR28_ACK 0x1U
#define CAN2_CSR28_ACK_BIT 0
#define CAN2_CSR28_FRAME_MASK 0x2U
#define CAN2_CSR28_FRAME 0x2U
#define CAN2_CSR28_FRAME_BIT 1
#define CAN2_CSR28_CRC_MASK 0x4U
#define CAN2_CSR28_CRC 0x4U
#define CAN2_CSR28_CRC_BIT 2
#define CAN2_CSR28_STUFF_MASK 0x8U
#define CAN2_CSR28_STUFF 0x8U
#define CAN2_CSR28_STUFF_BIT 3
#define CAN2_CSR28_BUS_MASK 0x10U
#define CAN2_CSR28_BUS 0x10U
#define CAN2_CSR28_BUS_BIT 4
#define CAN2_CSR28_RXOK_MASK 0x20U
#define CAN2_CSR28_RXOK 0x20U
#define CAN2_CSR28_RXOK_BIT 5
#define CAN2_CSR28_TXOK_MASK 0x40U
#define CAN2_CSR28_TXOK 0x40U
#define CAN2_CSR28_TXOK_BIT 6
#define CAN2_CSR28_RFRAME_MASK 0x80U
#define CAN2_CSR28_RFRAME 0x80U
#define CAN2_CSR28_RFRAME_BIT 7
#define CAN2_CSR28_DLCW_MASK 0x200U
#define CAN2_CSR28_DLCW 0x200U
#define CAN2_CSR28_DLCW_BIT 9
#define CAN2_CSR28_FILLED_MASK 0x400U
#define CAN2_CSR28_FILLED 0x400U
#define CAN2_CSR28_FILLED_BIT 10
#define CAN2_CSR28_OVRUN_MASK 0x800U
#define CAN2_CSR28_OVRUN 0x800U
#define CAN2_CSR28_OVRUN_BIT 11

#define CAN2_SR28 (*(volatile unsigned long *)0xFFFBC81C)
#define CAN2_SR28_OFFSET 0x81C
#define CAN2_SR28_ACK_MASK 0x1U
#define CAN2_SR28_ACK 0x1U
#define CAN2_SR28_ACK_BIT 0
#define CAN2_SR28_FRAME_MASK 0x2U
#define CAN2_SR28_FRAME 0x2U
#define CAN2_SR28_FRAME_BIT 1
#define CAN2_SR28_CRC_MASK 0x4U
#define CAN2_SR28_CRC 0x4U
#define CAN2_SR28_CRC_BIT 2
#define CAN2_SR28_STUFF_MASK 0x8U
#define CAN2_SR28_STUFF 0x8U
#define CAN2_SR28_STUFF_BIT 3
#define CAN2_SR28_BUS_MASK 0x10U
#define CAN2_SR28_BUS 0x10U
#define CAN2_SR28_BUS_BIT 4
#define CAN2_SR28_RXOK_MASK 0x20U
#define CAN2_SR28_RXOK 0x20U
#define CAN2_SR28_RXOK_BIT 5
#define CAN2_SR28_TXOK_MASK 0x40U
#define CAN2_SR28_TXOK 0x40U
#define CAN2_SR28_TXOK_BIT 6
#define CAN2_SR28_RFRAME_MASK 0x80U
#define CAN2_SR28_RFRAME 0x80U
#define CAN2_SR28_RFRAME_BIT 7
#define CAN2_SR28_DLCW_MASK 0x200U
#define CAN2_SR28_DLCW 0x200U
#define CAN2_SR28_DLCW_BIT 9
#define CAN2_SR28_FILLED_MASK 0x400U
#define CAN2_SR28_FILLED 0x400U
#define CAN2_SR28_FILLED_BIT 10
#define CAN2_SR28_OVRUN_MASK 0x800U
#define CAN2_SR28_OVRUN 0x800U
#define CAN2_SR28_OVRUN_BIT 11

#define CAN2_IER28 (*(volatile unsigned long *)0xFFFBC820)
#define CAN2_IER28_OFFSET 0x820
#define CAN2_IER28_ACK_MASK 0x1U
#define CAN2_IER28_ACK 0x1U
#define CAN2_IER28_ACK_BIT 0
#define CAN2_IER28_FRAME_MASK 0x2U
#define CAN2_IER28_FRAME 0x2U
#define CAN2_IER28_FRAME_BIT 1
#define CAN2_IER28_CRC_MASK 0x4U
#define CAN2_IER28_CRC 0x4U
#define CAN2_IER28_CRC_BIT 2
#define CAN2_IER28_STUFF_MASK 0x8U
#define CAN2_IER28_STUFF 0x8U
#define CAN2_IER28_STUFF_BIT 3
#define CAN2_IER28_BUS_MASK 0x10U
#define CAN2_IER28_BUS 0x10U
#define CAN2_IER28_BUS_BIT 4
#define CAN2_IER28_RXOK_MASK 0x20U
#define CAN2_IER28_RXOK 0x20U
#define CAN2_IER28_RXOK_BIT 5
#define CAN2_IER28_TXOK_MASK 0x40U
#define CAN2_IER28_TXOK 0x40U
#define CAN2_IER28_TXOK_BIT 6
#define CAN2_IER28_RFRAME_MASK 0x80U
#define CAN2_IER28_RFRAME 0x80U
#define CAN2_IER28_RFRAME_BIT 7

#define CAN2_IDR28 (*(volatile unsigned long *)0xFFFBC824)
#define CAN2_IDR28_OFFSET 0x824
#define CAN2_IDR28_ACK_MASK 0x1U
#define CAN2_IDR28_ACK 0x1U
#define CAN2_IDR28_ACK_BIT 0
#define CAN2_IDR28_FRAME_MASK 0x2U
#define CAN2_IDR28_FRAME 0x2U
#define CAN2_IDR28_FRAME_BIT 1
#define CAN2_IDR28_CRC_MASK 0x4U
#define CAN2_IDR28_CRC 0x4U
#define CAN2_IDR28_CRC_BIT 2
#define CAN2_IDR28_STUFF_MASK 0x8U
#define CAN2_IDR28_STUFF 0x8U
#define CAN2_IDR28_STUFF_BIT 3
#define CAN2_IDR28_BUS_MASK 0x10U
#define CAN2_IDR28_BUS 0x10U
#define CAN2_IDR28_BUS_BIT 4
#define CAN2_IDR28_RXOK_MASK 0x20U
#define CAN2_IDR28_RXOK 0x20U
#define CAN2_IDR28_RXOK_BIT 5
#define CAN2_IDR28_TXOK_MASK 0x40U
#define CAN2_IDR28_TXOK 0x40U
#define CAN2_IDR28_TXOK_BIT 6
#define CAN2_IDR28_RFRAME_MASK 0x80U
#define CAN2_IDR28_RFRAME 0x80U
#define CAN2_IDR28_RFRAME_BIT 7

#define CAN2_IMR28 (*(volatile unsigned long *)0xFFFBC828)
#define CAN2_IMR28_OFFSET 0x828
#define CAN2_IMR28_ACK_MASK 0x1U
#define CAN2_IMR28_ACK 0x1U
#define CAN2_IMR28_ACK_BIT 0
#define CAN2_IMR28_FRAME_MASK 0x2U
#define CAN2_IMR28_FRAME 0x2U
#define CAN2_IMR28_FRAME_BIT 1
#define CAN2_IMR28_CRC_MASK 0x4U
#define CAN2_IMR28_CRC 0x4U
#define CAN2_IMR28_CRC_BIT 2
#define CAN2_IMR28_STUFF_MASK 0x8U
#define CAN2_IMR28_STUFF 0x8U
#define CAN2_IMR28_STUFF_BIT 3
#define CAN2_IMR28_BUS_MASK 0x10U
#define CAN2_IMR28_BUS 0x10U
#define CAN2_IMR28_BUS_BIT 4
#define CAN2_IMR28_RXOK_MASK 0x20U
#define CAN2_IMR28_RXOK 0x20U
#define CAN2_IMR28_RXOK_BIT 5
#define CAN2_IMR28_TXOK_MASK 0x40U
#define CAN2_IMR28_TXOK 0x40U
#define CAN2_IMR28_TXOK_BIT 6
#define CAN2_IMR28_RFRAME_MASK 0x80U
#define CAN2_IMR28_RFRAME 0x80U
#define CAN2_IMR28_RFRAME_BIT 7

#define CAN2_DRA29 (*(volatile unsigned long *)0xFFFBC840)
#define CAN2_DRA29_OFFSET 0x840
#define CAN2_DRA29_DATA0_MASK 0xFFU
#define CAN2_DRA29_DATA0_BIT 0
#define CAN2_DRA29_DATA1_MASK 0xFF00U
#define CAN2_DRA29_DATA1_BIT 8
#define CAN2_DRA29_DATA2_MASK 0xFF0000U
#define CAN2_DRA29_DATA2_BIT 16
#define CAN2_DRA29_DATA3_MASK 0xFF000000U
#define CAN2_DRA29_DATA3_BIT 24

#define CAN2_DRB29 (*(volatile unsigned long *)0xFFFBC844)
#define CAN2_DRB29_OFFSET 0x844
#define CAN2_DRB29_DATA4_MASK 0xFFU
#define CAN2_DRB29_DATA4_BIT 0
#define CAN2_DRB29_DATA5_MASK 0xFF00U
#define CAN2_DRB29_DATA5_BIT 8
#define CAN2_DRB29_DATA6_MASK 0xFF0000U
#define CAN2_DRB29_DATA6_BIT 16
#define CAN2_DRB29_DATA7_MASK 0xFF000000U
#define CAN2_DRB29_DATA7_BIT 24

#define CAN2_MSK29 (*(volatile unsigned long *)0xFFFBC848)
#define CAN2_MSK29_OFFSET 0x848
#define CAN2_MSK29_MASK_MASK 0x1FFFFFFFU
#define CAN2_MSK29_MASK_BIT 0
#define CAN2_MSK29_MRB_MASK 0x60000000U
#define CAN2_MSK29_MRB_BIT 29
#define CAN2_MSK29_MRTR_MASK 0x80000000U
#define CAN2_MSK29_MRTR 0x80000000U
#define CAN2_MSK29_MRTR_BIT 31

#define CAN2_IR29 (*(volatile unsigned long *)0xFFFBC84C)
#define CAN2_IR29_OFFSET 0x84C
#define CAN2_IR29_ID_MASK 0x1FFFFFFFU
#define CAN2_IR29_ID_BIT 0
#define CAN2_IR29_RB_MASK 0x60000000U
#define CAN2_IR29_RB_BIT 29
#define CAN2_IR29_RTR_MASK 0x80000000U
#define CAN2_IR29_RTR 0x80000000U
#define CAN2_IR29_RTR_BIT 31

#define CAN2_CR29 (*(volatile unsigned long *)0xFFFBC850)
#define CAN2_CR29_OFFSET 0x850
#define CAN2_CR29_DLC_MASK 0xFU
#define CAN2_CR29_DLC_BIT 0
#define CAN2_CR29_IDE_MASK 0x10U
#define CAN2_CR29_IDE 0x10U
#define CAN2_CR29_IDE_BIT 4
#define CAN2_CR29_RPLYV_MASK 0x20U
#define CAN2_CR29_RPLYV 0x20U
#define CAN2_CR29_RPLYV_BIT 5
#define CAN2_CR29_PCB_MASK 0x40U
#define CAN2_CR29_PCB 0x40U
#define CAN2_CR29_PCB_BIT 6
#define CAN2_CR29_CHANEN_MASK 0x80U
#define CAN2_CR29_CHANEN 0x80U
#define CAN2_CR29_CHANEN_BIT 7
#define CAN2_CR29_OVERWRITE_MASK 0x100U
#define CAN2_CR29_OVERWRITE 0x100U
#define CAN2_CR29_OVERWRITE_BIT 8

#define CAN2_CR29 (*(volatile unsigned long *)0xFFFBC854)
#define CAN2_CR29_OFFSET 0x854
#define CAN2_CR29_STAMP_MASK 0x0U
#define CAN2_CR29_STAMP_BIT 0

#define CAN2_CSR29 (*(volatile unsigned long *)0xFFFBC858)
#define CAN2_CSR29_OFFSET 0x858
#define CAN2_CSR29_ACK_MASK 0x1U
#define CAN2_CSR29_ACK 0x1U
#define CAN2_CSR29_ACK_BIT 0
#define CAN2_CSR29_FRAME_MASK 0x2U
#define CAN2_CSR29_FRAME 0x2U
#define CAN2_CSR29_FRAME_BIT 1
#define CAN2_CSR29_CRC_MASK 0x4U
#define CAN2_CSR29_CRC 0x4U
#define CAN2_CSR29_CRC_BIT 2
#define CAN2_CSR29_STUFF_MASK 0x8U
#define CAN2_CSR29_STUFF 0x8U
#define CAN2_CSR29_STUFF_BIT 3
#define CAN2_CSR29_BUS_MASK 0x10U
#define CAN2_CSR29_BUS 0x10U
#define CAN2_CSR29_BUS_BIT 4
#define CAN2_CSR29_RXOK_MASK 0x20U
#define CAN2_CSR29_RXOK 0x20U
#define CAN2_CSR29_RXOK_BIT 5
#define CAN2_CSR29_TXOK_MASK 0x40U
#define CAN2_CSR29_TXOK 0x40U
#define CAN2_CSR29_TXOK_BIT 6
#define CAN2_CSR29_RFRAME_MASK 0x80U
#define CAN2_CSR29_RFRAME 0x80U
#define CAN2_CSR29_RFRAME_BIT 7
#define CAN2_CSR29_DLCW_MASK 0x200U
#define CAN2_CSR29_DLCW 0x200U
#define CAN2_CSR29_DLCW_BIT 9
#define CAN2_CSR29_FILLED_MASK 0x400U
#define CAN2_CSR29_FILLED 0x400U
#define CAN2_CSR29_FILLED_BIT 10
#define CAN2_CSR29_OVRUN_MASK 0x800U
#define CAN2_CSR29_OVRUN 0x800U
#define CAN2_CSR29_OVRUN_BIT 11

#define CAN2_SR29 (*(volatile unsigned long *)0xFFFBC85C)
#define CAN2_SR29_OFFSET 0x85C
#define CAN2_SR29_ACK_MASK 0x1U
#define CAN2_SR29_ACK 0x1U
#define CAN2_SR29_ACK_BIT 0
#define CAN2_SR29_FRAME_MASK 0x2U
#define CAN2_SR29_FRAME 0x2U
#define CAN2_SR29_FRAME_BIT 1
#define CAN2_SR29_CRC_MASK 0x4U
#define CAN2_SR29_CRC 0x4U
#define CAN2_SR29_CRC_BIT 2
#define CAN2_SR29_STUFF_MASK 0x8U
#define CAN2_SR29_STUFF 0x8U
#define CAN2_SR29_STUFF_BIT 3
#define CAN2_SR29_BUS_MASK 0x10U
#define CAN2_SR29_BUS 0x10U
#define CAN2_SR29_BUS_BIT 4
#define CAN2_SR29_RXOK_MASK 0x20U
#define CAN2_SR29_RXOK 0x20U
#define CAN2_SR29_RXOK_BIT 5
#define CAN2_SR29_TXOK_MASK 0x40U
#define CAN2_SR29_TXOK 0x40U
#define CAN2_SR29_TXOK_BIT 6
#define CAN2_SR29_RFRAME_MASK 0x80U
#define CAN2_SR29_RFRAME 0x80U
#define CAN2_SR29_RFRAME_BIT 7
#define CAN2_SR29_DLCW_MASK 0x200U
#define CAN2_SR29_DLCW 0x200U
#define CAN2_SR29_DLCW_BIT 9
#define CAN2_SR29_FILLED_MASK 0x400U
#define CAN2_SR29_FILLED 0x400U
#define CAN2_SR29_FILLED_BIT 10
#define CAN2_SR29_OVRUN_MASK 0x800U
#define CAN2_SR29_OVRUN 0x800U
#define CAN2_SR29_OVRUN_BIT 11

#define CAN2_IER29 (*(volatile unsigned long *)0xFFFBC860)
#define CAN2_IER29_OFFSET 0x860
#define CAN2_IER29_ACK_MASK 0x1U
#define CAN2_IER29_ACK 0x1U
#define CAN2_IER29_ACK_BIT 0
#define CAN2_IER29_FRAME_MASK 0x2U
#define CAN2_IER29_FRAME 0x2U
#define CAN2_IER29_FRAME_BIT 1
#define CAN2_IER29_CRC_MASK 0x4U
#define CAN2_IER29_CRC 0x4U
#define CAN2_IER29_CRC_BIT 2
#define CAN2_IER29_STUFF_MASK 0x8U
#define CAN2_IER29_STUFF 0x8U
#define CAN2_IER29_STUFF_BIT 3
#define CAN2_IER29_BUS_MASK 0x10U
#define CAN2_IER29_BUS 0x10U
#define CAN2_IER29_BUS_BIT 4
#define CAN2_IER29_RXOK_MASK 0x20U
#define CAN2_IER29_RXOK 0x20U
#define CAN2_IER29_RXOK_BIT 5
#define CAN2_IER29_TXOK_MASK 0x40U
#define CAN2_IER29_TXOK 0x40U
#define CAN2_IER29_TXOK_BIT 6
#define CAN2_IER29_RFRAME_MASK 0x80U
#define CAN2_IER29_RFRAME 0x80U
#define CAN2_IER29_RFRAME_BIT 7

#define CAN2_IDR29 (*(volatile unsigned long *)0xFFFBC864)
#define CAN2_IDR29_OFFSET 0x864
#define CAN2_IDR29_ACK_MASK 0x1U
#define CAN2_IDR29_ACK 0x1U
#define CAN2_IDR29_ACK_BIT 0
#define CAN2_IDR29_FRAME_MASK 0x2U
#define CAN2_IDR29_FRAME 0x2U
#define CAN2_IDR29_FRAME_BIT 1
#define CAN2_IDR29_CRC_MASK 0x4U
#define CAN2_IDR29_CRC 0x4U
#define CAN2_IDR29_CRC_BIT 2
#define CAN2_IDR29_STUFF_MASK 0x8U
#define CAN2_IDR29_STUFF 0x8U
#define CAN2_IDR29_STUFF_BIT 3
#define CAN2_IDR29_BUS_MASK 0x10U
#define CAN2_IDR29_BUS 0x10U
#define CAN2_IDR29_BUS_BIT 4
#define CAN2_IDR29_RXOK_MASK 0x20U
#define CAN2_IDR29_RXOK 0x20U
#define CAN2_IDR29_RXOK_BIT 5
#define CAN2_IDR29_TXOK_MASK 0x40U
#define CAN2_IDR29_TXOK 0x40U
#define CAN2_IDR29_TXOK_BIT 6
#define CAN2_IDR29_RFRAME_MASK 0x80U
#define CAN2_IDR29_RFRAME 0x80U
#define CAN2_IDR29_RFRAME_BIT 7

#define CAN2_IMR29 (*(volatile unsigned long *)0xFFFBC868)
#define CAN2_IMR29_OFFSET 0x868
#define CAN2_IMR29_ACK_MASK 0x1U
#define CAN2_IMR29_ACK 0x1U
#define CAN2_IMR29_ACK_BIT 0
#define CAN2_IMR29_FRAME_MASK 0x2U
#define CAN2_IMR29_FRAME 0x2U
#define CAN2_IMR29_FRAME_BIT 1
#define CAN2_IMR29_CRC_MASK 0x4U
#define CAN2_IMR29_CRC 0x4U
#define CAN2_IMR29_CRC_BIT 2
#define CAN2_IMR29_STUFF_MASK 0x8U
#define CAN2_IMR29_STUFF 0x8U
#define CAN2_IMR29_STUFF_BIT 3
#define CAN2_IMR29_BUS_MASK 0x10U
#define CAN2_IMR29_BUS 0x10U
#define CAN2_IMR29_BUS_BIT 4
#define CAN2_IMR29_RXOK_MASK 0x20U
#define CAN2_IMR29_RXOK 0x20U
#define CAN2_IMR29_RXOK_BIT 5
#define CAN2_IMR29_TXOK_MASK 0x40U
#define CAN2_IMR29_TXOK 0x40U
#define CAN2_IMR29_TXOK_BIT 6
#define CAN2_IMR29_RFRAME_MASK 0x80U
#define CAN2_IMR29_RFRAME 0x80U
#define CAN2_IMR29_RFRAME_BIT 7

#define CAN2_DRA30 (*(volatile unsigned long *)0xFFFBC880)
#define CAN2_DRA30_OFFSET 0x880
#define CAN2_DRA30_DATA0_MASK 0xFFU
#define CAN2_DRA30_DATA0_BIT 0
#define CAN2_DRA30_DATA1_MASK 0xFF00U
#define CAN2_DRA30_DATA1_BIT 8
#define CAN2_DRA30_DATA2_MASK 0xFF0000U
#define CAN2_DRA30_DATA2_BIT 16
#define CAN2_DRA30_DATA3_MASK 0xFF000000U
#define CAN2_DRA30_DATA3_BIT 24

#define CAN2_DRB30 (*(volatile unsigned long *)0xFFFBC884)
#define CAN2_DRB30_OFFSET 0x884
#define CAN2_DRB30_DATA4_MASK 0xFFU
#define CAN2_DRB30_DATA4_BIT 0
#define CAN2_DRB30_DATA5_MASK 0xFF00U
#define CAN2_DRB30_DATA5_BIT 8
#define CAN2_DRB30_DATA6_MASK 0xFF0000U
#define CAN2_DRB30_DATA6_BIT 16
#define CAN2_DRB30_DATA7_MASK 0xFF000000U
#define CAN2_DRB30_DATA7_BIT 24

#define CAN2_MSK30 (*(volatile unsigned long *)0xFFFBC888)
#define CAN2_MSK30_OFFSET 0x888
#define CAN2_MSK30_MASK_MASK 0x1FFFFFFFU
#define CAN2_MSK30_MASK_BIT 0
#define CAN2_MSK30_MRB_MASK 0x60000000U
#define CAN2_MSK30_MRB_BIT 29
#define CAN2_MSK30_MRTR_MASK 0x80000000U
#define CAN2_MSK30_MRTR 0x80000000U
#define CAN2_MSK30_MRTR_BIT 31

#define CAN2_IR30 (*(volatile unsigned long *)0xFFFBC88C)
#define CAN2_IR30_OFFSET 0x88C
#define CAN2_IR30_ID_MASK 0x1FFFFFFFU
#define CAN2_IR30_ID_BIT 0
#define CAN2_IR30_RB_MASK 0x60000000U
#define CAN2_IR30_RB_BIT 29
#define CAN2_IR30_RTR_MASK 0x80000000U
#define CAN2_IR30_RTR 0x80000000U
#define CAN2_IR30_RTR_BIT 31

#define CAN2_CR30 (*(volatile unsigned long *)0xFFFBC890)
#define CAN2_CR30_OFFSET 0x890
#define CAN2_CR30_DLC_MASK 0xFU
#define CAN2_CR30_DLC_BIT 0
#define CAN2_CR30_IDE_MASK 0x10U
#define CAN2_CR30_IDE 0x10U
#define CAN2_CR30_IDE_BIT 4
#define CAN2_CR30_RPLYV_MASK 0x20U
#define CAN2_CR30_RPLYV 0x20U
#define CAN2_CR30_RPLYV_BIT 5
#define CAN2_CR30_PCB_MASK 0x40U
#define CAN2_CR30_PCB 0x40U
#define CAN2_CR30_PCB_BIT 6
#define CAN2_CR30_CHANEN_MASK 0x80U
#define CAN2_CR30_CHANEN 0x80U
#define CAN2_CR30_CHANEN_BIT 7
#define CAN2_CR30_OVERWRITE_MASK 0x100U
#define CAN2_CR30_OVERWRITE 0x100U
#define CAN2_CR30_OVERWRITE_BIT 8

#define CAN2_CR30 (*(volatile unsigned long *)0xFFFBC894)
#define CAN2_CR30_OFFSET 0x894
#define CAN2_CR30_STAMP_MASK 0x0U
#define CAN2_CR30_STAMP_BIT 0

#define CAN2_CSR30 (*(volatile unsigned long *)0xFFFBC898)
#define CAN2_CSR30_OFFSET 0x898
#define CAN2_CSR30_ACK_MASK 0x1U
#define CAN2_CSR30_ACK 0x1U
#define CAN2_CSR30_ACK_BIT 0
#define CAN2_CSR30_FRAME_MASK 0x2U
#define CAN2_CSR30_FRAME 0x2U
#define CAN2_CSR30_FRAME_BIT 1
#define CAN2_CSR30_CRC_MASK 0x4U
#define CAN2_CSR30_CRC 0x4U
#define CAN2_CSR30_CRC_BIT 2
#define CAN2_CSR30_STUFF_MASK 0x8U
#define CAN2_CSR30_STUFF 0x8U
#define CAN2_CSR30_STUFF_BIT 3
#define CAN2_CSR30_BUS_MASK 0x10U
#define CAN2_CSR30_BUS 0x10U
#define CAN2_CSR30_BUS_BIT 4
#define CAN2_CSR30_RXOK_MASK 0x20U
#define CAN2_CSR30_RXOK 0x20U
#define CAN2_CSR30_RXOK_BIT 5
#define CAN2_CSR30_TXOK_MASK 0x40U
#define CAN2_CSR30_TXOK 0x40U
#define CAN2_CSR30_TXOK_BIT 6
#define CAN2_CSR30_RFRAME_MASK 0x80U
#define CAN2_CSR30_RFRAME 0x80U
#define CAN2_CSR30_RFRAME_BIT 7
#define CAN2_CSR30_DLCW_MASK 0x200U
#define CAN2_CSR30_DLCW 0x200U
#define CAN2_CSR30_DLCW_BIT 9
#define CAN2_CSR30_FILLED_MASK 0x400U
#define CAN2_CSR30_FILLED 0x400U
#define CAN2_CSR30_FILLED_BIT 10
#define CAN2_CSR30_OVRUN_MASK 0x800U
#define CAN2_CSR30_OVRUN 0x800U
#define CAN2_CSR30_OVRUN_BIT 11

#define CAN2_SR30 (*(volatile unsigned long *)0xFFFBC89C)
#define CAN2_SR30_OFFSET 0x89C
#define CAN2_SR30_ACK_MASK 0x1U
#define CAN2_SR30_ACK 0x1U
#define CAN2_SR30_ACK_BIT 0
#define CAN2_SR30_FRAME_MASK 0x2U
#define CAN2_SR30_FRAME 0x2U
#define CAN2_SR30_FRAME_BIT 1
#define CAN2_SR30_CRC_MASK 0x4U
#define CAN2_SR30_CRC 0x4U
#define CAN2_SR30_CRC_BIT 2
#define CAN2_SR30_STUFF_MASK 0x8U
#define CAN2_SR30_STUFF 0x8U
#define CAN2_SR30_STUFF_BIT 3
#define CAN2_SR30_BUS_MASK 0x10U
#define CAN2_SR30_BUS 0x10U
#define CAN2_SR30_BUS_BIT 4
#define CAN2_SR30_RXOK_MASK 0x20U
#define CAN2_SR30_RXOK 0x20U
#define CAN2_SR30_RXOK_BIT 5
#define CAN2_SR30_TXOK_MASK 0x40U
#define CAN2_SR30_TXOK 0x40U
#define CAN2_SR30_TXOK_BIT 6
#define CAN2_SR30_RFRAME_MASK 0x80U
#define CAN2_SR30_RFRAME 0x80U
#define CAN2_SR30_RFRAME_BIT 7
#define CAN2_SR30_DLCW_MASK 0x200U
#define CAN2_SR30_DLCW 0x200U
#define CAN2_SR30_DLCW_BIT 9
#define CAN2_SR30_FILLED_MASK 0x400U
#define CAN2_SR30_FILLED 0x400U
#define CAN2_SR30_FILLED_BIT 10
#define CAN2_SR30_OVRUN_MASK 0x800U
#define CAN2_SR30_OVRUN 0x800U
#define CAN2_SR30_OVRUN_BIT 11

#define CAN2_IER30 (*(volatile unsigned long *)0xFFFBC8A0)
#define CAN2_IER30_OFFSET 0x8A0
#define CAN2_IER30_ACK_MASK 0x1U
#define CAN2_IER30_ACK 0x1U
#define CAN2_IER30_ACK_BIT 0
#define CAN2_IER30_FRAME_MASK 0x2U
#define CAN2_IER30_FRAME 0x2U
#define CAN2_IER30_FRAME_BIT 1
#define CAN2_IER30_CRC_MASK 0x4U
#define CAN2_IER30_CRC 0x4U
#define CAN2_IER30_CRC_BIT 2
#define CAN2_IER30_STUFF_MASK 0x8U
#define CAN2_IER30_STUFF 0x8U
#define CAN2_IER30_STUFF_BIT 3
#define CAN2_IER30_BUS_MASK 0x10U
#define CAN2_IER30_BUS 0x10U
#define CAN2_IER30_BUS_BIT 4
#define CAN2_IER30_RXOK_MASK 0x20U
#define CAN2_IER30_RXOK 0x20U
#define CAN2_IER30_RXOK_BIT 5
#define CAN2_IER30_TXOK_MASK 0x40U
#define CAN2_IER30_TXOK 0x40U
#define CAN2_IER30_TXOK_BIT 6
#define CAN2_IER30_RFRAME_MASK 0x80U
#define CAN2_IER30_RFRAME 0x80U
#define CAN2_IER30_RFRAME_BIT 7

#define CAN2_IDR30 (*(volatile unsigned long *)0xFFFBC8A4)
#define CAN2_IDR30_OFFSET 0x8A4
#define CAN2_IDR30_ACK_MASK 0x1U
#define CAN2_IDR30_ACK 0x1U
#define CAN2_IDR30_ACK_BIT 0
#define CAN2_IDR30_FRAME_MASK 0x2U
#define CAN2_IDR30_FRAME 0x2U
#define CAN2_IDR30_FRAME_BIT 1
#define CAN2_IDR30_CRC_MASK 0x4U
#define CAN2_IDR30_CRC 0x4U
#define CAN2_IDR30_CRC_BIT 2
#define CAN2_IDR30_STUFF_MASK 0x8U
#define CAN2_IDR30_STUFF 0x8U
#define CAN2_IDR30_STUFF_BIT 3
#define CAN2_IDR30_BUS_MASK 0x10U
#define CAN2_IDR30_BUS 0x10U
#define CAN2_IDR30_BUS_BIT 4
#define CAN2_IDR30_RXOK_MASK 0x20U
#define CAN2_IDR30_RXOK 0x20U
#define CAN2_IDR30_RXOK_BIT 5
#define CAN2_IDR30_TXOK_MASK 0x40U
#define CAN2_IDR30_TXOK 0x40U
#define CAN2_IDR30_TXOK_BIT 6
#define CAN2_IDR30_RFRAME_MASK 0x80U
#define CAN2_IDR30_RFRAME 0x80U
#define CAN2_IDR30_RFRAME_BIT 7

#define CAN2_IMR30 (*(volatile unsigned long *)0xFFFBC8A8)
#define CAN2_IMR30_OFFSET 0x8A8
#define CAN2_IMR30_ACK_MASK 0x1U
#define CAN2_IMR30_ACK 0x1U
#define CAN2_IMR30_ACK_BIT 0
#define CAN2_IMR30_FRAME_MASK 0x2U
#define CAN2_IMR30_FRAME 0x2U
#define CAN2_IMR30_FRAME_BIT 1
#define CAN2_IMR30_CRC_MASK 0x4U
#define CAN2_IMR30_CRC 0x4U
#define CAN2_IMR30_CRC_BIT 2
#define CAN2_IMR30_STUFF_MASK 0x8U
#define CAN2_IMR30_STUFF 0x8U
#define CAN2_IMR30_STUFF_BIT 3
#define CAN2_IMR30_BUS_MASK 0x10U
#define CAN2_IMR30_BUS 0x10U
#define CAN2_IMR30_BUS_BIT 4
#define CAN2_IMR30_RXOK_MASK 0x20U
#define CAN2_IMR30_RXOK 0x20U
#define CAN2_IMR30_RXOK_BIT 5
#define CAN2_IMR30_TXOK_MASK 0x40U
#define CAN2_IMR30_TXOK 0x40U
#define CAN2_IMR30_TXOK_BIT 6
#define CAN2_IMR30_RFRAME_MASK 0x80U
#define CAN2_IMR30_RFRAME 0x80U
#define CAN2_IMR30_RFRAME_BIT 7

#define CAN2_DRA31 (*(volatile unsigned long *)0xFFFBC8C0)
#define CAN2_DRA31_OFFSET 0x8C0
#define CAN2_DRA31_DATA0_MASK 0xFFU
#define CAN2_DRA31_DATA0_BIT 0
#define CAN2_DRA31_DATA1_MASK 0xFF00U
#define CAN2_DRA31_DATA1_BIT 8
#define CAN2_DRA31_DATA2_MASK 0xFF0000U
#define CAN2_DRA31_DATA2_BIT 16
#define CAN2_DRA31_DATA3_MASK 0xFF000000U
#define CAN2_DRA31_DATA3_BIT 24

#define CAN2_DRB31 (*(volatile unsigned long *)0xFFFBC8C4)
#define CAN2_DRB31_OFFSET 0x8C4
#define CAN2_DRB31_DATA4_MASK 0xFFU
#define CAN2_DRB31_DATA4_BIT 0
#define CAN2_DRB31_DATA5_MASK 0xFF00U
#define CAN2_DRB31_DATA5_BIT 8
#define CAN2_DRB31_DATA6_MASK 0xFF0000U
#define CAN2_DRB31_DATA6_BIT 16
#define CAN2_DRB31_DATA7_MASK 0xFF000000U
#define CAN2_DRB31_DATA7_BIT 24

#define CAN2_MSK31 (*(volatile unsigned long *)0xFFFBC8C8)
#define CAN2_MSK31_OFFSET 0x8C8
#define CAN2_MSK31_MASK_MASK 0x1FFFFFFFU
#define CAN2_MSK31_MASK_BIT 0
#define CAN2_MSK31_MRB_MASK 0x60000000U
#define CAN2_MSK31_MRB_BIT 29
#define CAN2_MSK31_MRTR_MASK 0x80000000U
#define CAN2_MSK31_MRTR 0x80000000U
#define CAN2_MSK31_MRTR_BIT 31

#define CAN2_IR31 (*(volatile unsigned long *)0xFFFBC8CC)
#define CAN2_IR31_OFFSET 0x8CC
#define CAN2_IR31_ID_MASK 0x1FFFFFFFU
#define CAN2_IR31_ID_BIT 0
#define CAN2_IR31_RB_MASK 0x60000000U
#define CAN2_IR31_RB_BIT 29
#define CAN2_IR31_RTR_MASK 0x80000000U
#define CAN2_IR31_RTR 0x80000000U
#define CAN2_IR31_RTR_BIT 31

#define CAN2_CR31 (*(volatile unsigned long *)0xFFFBC8D0)
#define CAN2_CR31_OFFSET 0x8D0
#define CAN2_CR31_DLC_MASK 0xFU
#define CAN2_CR31_DLC_BIT 0
#define CAN2_CR31_IDE_MASK 0x10U
#define CAN2_CR31_IDE 0x10U
#define CAN2_CR31_IDE_BIT 4
#define CAN2_CR31_RPLYV_MASK 0x20U
#define CAN2_CR31_RPLYV 0x20U
#define CAN2_CR31_RPLYV_BIT 5
#define CAN2_CR31_PCB_MASK 0x40U
#define CAN2_CR31_PCB 0x40U
#define CAN2_CR31_PCB_BIT 6
#define CAN2_CR31_CHANEN_MASK 0x80U
#define CAN2_CR31_CHANEN 0x80U
#define CAN2_CR31_CHANEN_BIT 7
#define CAN2_CR31_OVERWRITE_MASK 0x100U
#define CAN2_CR31_OVERWRITE 0x100U
#define CAN2_CR31_OVERWRITE_BIT 8

#define CAN2_CR31 (*(volatile unsigned long *)0xFFFBC8D4)
#define CAN2_CR31_OFFSET 0x8D4
#define CAN2_CR31_STAMP_MASK 0x0U
#define CAN2_CR31_STAMP_BIT 0

#define CAN2_CSR31 (*(volatile unsigned long *)0xFFFBC8D8)
#define CAN2_CSR31_OFFSET 0x8D8
#define CAN2_CSR31_ACK_MASK 0x1U
#define CAN2_CSR31_ACK 0x1U
#define CAN2_CSR31_ACK_BIT 0
#define CAN2_CSR31_FRAME_MASK 0x2U
#define CAN2_CSR31_FRAME 0x2U
#define CAN2_CSR31_FRAME_BIT 1
#define CAN2_CSR31_CRC_MASK 0x4U
#define CAN2_CSR31_CRC 0x4U
#define CAN2_CSR31_CRC_BIT 2
#define CAN2_CSR31_STUFF_MASK 0x8U
#define CAN2_CSR31_STUFF 0x8U
#define CAN2_CSR31_STUFF_BIT 3
#define CAN2_CSR31_BUS_MASK 0x10U
#define CAN2_CSR31_BUS 0x10U
#define CAN2_CSR31_BUS_BIT 4
#define CAN2_CSR31_RXOK_MASK 0x20U
#define CAN2_CSR31_RXOK 0x20U
#define CAN2_CSR31_RXOK_BIT 5
#define CAN2_CSR31_TXOK_MASK 0x40U
#define CAN2_CSR31_TXOK 0x40U
#define CAN2_CSR31_TXOK_BIT 6
#define CAN2_CSR31_RFRAME_MASK 0x80U
#define CAN2_CSR31_RFRAME 0x80U
#define CAN2_CSR31_RFRAME_BIT 7
#define CAN2_CSR31_DLCW_MASK 0x200U
#define CAN2_CSR31_DLCW 0x200U
#define CAN2_CSR31_DLCW_BIT 9
#define CAN2_CSR31_FILLED_MASK 0x400U
#define CAN2_CSR31_FILLED 0x400U
#define CAN2_CSR31_FILLED_BIT 10
#define CAN2_CSR31_OVRUN_MASK 0x800U
#define CAN2_CSR31_OVRUN 0x800U
#define CAN2_CSR31_OVRUN_BIT 11

#define CAN2_SR31 (*(volatile unsigned long *)0xFFFBC8DC)
#define CAN2_SR31_OFFSET 0x8DC
#define CAN2_SR31_ACK_MASK 0x1U
#define CAN2_SR31_ACK 0x1U
#define CAN2_SR31_ACK_BIT 0
#define CAN2_SR31_FRAME_MASK 0x2U
#define CAN2_SR31_FRAME 0x2U
#define CAN2_SR31_FRAME_BIT 1
#define CAN2_SR31_CRC_MASK 0x4U
#define CAN2_SR31_CRC 0x4U
#define CAN2_SR31_CRC_BIT 2
#define CAN2_SR31_STUFF_MASK 0x8U
#define CAN2_SR31_STUFF 0x8U
#define CAN2_SR31_STUFF_BIT 3
#define CAN2_SR31_BUS_MASK 0x10U
#define CAN2_SR31_BUS 0x10U
#define CAN2_SR31_BUS_BIT 4
#define CAN2_SR31_RXOK_MASK 0x20U
#define CAN2_SR31_RXOK 0x20U
#define CAN2_SR31_RXOK_BIT 5
#define CAN2_SR31_TXOK_MASK 0x40U
#define CAN2_SR31_TXOK 0x40U
#define CAN2_SR31_TXOK_BIT 6
#define CAN2_SR31_RFRAME_MASK 0x80U
#define CAN2_SR31_RFRAME 0x80U
#define CAN2_SR31_RFRAME_BIT 7
#define CAN2_SR31_DLCW_MASK 0x200U
#define CAN2_SR31_DLCW 0x200U
#define CAN2_SR31_DLCW_BIT 9
#define CAN2_SR31_FILLED_MASK 0x400U
#define CAN2_SR31_FILLED 0x400U
#define CAN2_SR31_FILLED_BIT 10
#define CAN2_SR31_OVRUN_MASK 0x800U
#define CAN2_SR31_OVRUN 0x800U
#define CAN2_SR31_OVRUN_BIT 11

#define CAN2_IER31 (*(volatile unsigned long *)0xFFFBC8E0)
#define CAN2_IER31_OFFSET 0x8E0
#define CAN2_IER31_ACK_MASK 0x1U
#define CAN2_IER31_ACK 0x1U
#define CAN2_IER31_ACK_BIT 0
#define CAN2_IER31_FRAME_MASK 0x2U
#define CAN2_IER31_FRAME 0x2U
#define CAN2_IER31_FRAME_BIT 1
#define CAN2_IER31_CRC_MASK 0x4U
#define CAN2_IER31_CRC 0x4U
#define CAN2_IER31_CRC_BIT 2
#define CAN2_IER31_STUFF_MASK 0x8U
#define CAN2_IER31_STUFF 0x8U
#define CAN2_IER31_STUFF_BIT 3
#define CAN2_IER31_BUS_MASK 0x10U
#define CAN2_IER31_BUS 0x10U
#define CAN2_IER31_BUS_BIT 4
#define CAN2_IER31_RXOK_MASK 0x20U
#define CAN2_IER31_RXOK 0x20U
#define CAN2_IER31_RXOK_BIT 5
#define CAN2_IER31_TXOK_MASK 0x40U
#define CAN2_IER31_TXOK 0x40U
#define CAN2_IER31_TXOK_BIT 6
#define CAN2_IER31_RFRAME_MASK 0x80U
#define CAN2_IER31_RFRAME 0x80U
#define CAN2_IER31_RFRAME_BIT 7

#define CAN2_IDR31 (*(volatile unsigned long *)0xFFFBC8E4)
#define CAN2_IDR31_OFFSET 0x8E4
#define CAN2_IDR31_ACK_MASK 0x1U
#define CAN2_IDR31_ACK 0x1U
#define CAN2_IDR31_ACK_BIT 0
#define CAN2_IDR31_FRAME_MASK 0x2U
#define CAN2_IDR31_FRAME 0x2U
#define CAN2_IDR31_FRAME_BIT 1
#define CAN2_IDR31_CRC_MASK 0x4U
#define CAN2_IDR31_CRC 0x4U
#define CAN2_IDR31_CRC_BIT 2
#define CAN2_IDR31_STUFF_MASK 0x8U
#define CAN2_IDR31_STUFF 0x8U
#define CAN2_IDR31_STUFF_BIT 3
#define CAN2_IDR31_BUS_MASK 0x10U
#define CAN2_IDR31_BUS 0x10U
#define CAN2_IDR31_BUS_BIT 4
#define CAN2_IDR31_RXOK_MASK 0x20U
#define CAN2_IDR31_RXOK 0x20U
#define CAN2_IDR31_RXOK_BIT 5
#define CAN2_IDR31_TXOK_MASK 0x40U
#define CAN2_IDR31_TXOK 0x40U
#define CAN2_IDR31_TXOK_BIT 6
#define CAN2_IDR31_RFRAME_MASK 0x80U
#define CAN2_IDR31_RFRAME 0x80U
#define CAN2_IDR31_RFRAME_BIT 7

#define CAN2_IMR31 (*(volatile unsigned long *)0xFFFBC8E8)
#define CAN2_IMR31_OFFSET 0x8E8
#define CAN2_IMR31_ACK_MASK 0x1U
#define CAN2_IMR31_ACK 0x1U
#define CAN2_IMR31_ACK_BIT 0
#define CAN2_IMR31_FRAME_MASK 0x2U
#define CAN2_IMR31_FRAME 0x2U
#define CAN2_IMR31_FRAME_BIT 1
#define CAN2_IMR31_CRC_MASK 0x4U
#define CAN2_IMR31_CRC 0x4U
#define CAN2_IMR31_CRC_BIT 2
#define CAN2_IMR31_STUFF_MASK 0x8U
#define CAN2_IMR31_STUFF 0x8U
#define CAN2_IMR31_STUFF_BIT 3
#define CAN2_IMR31_BUS_MASK 0x10U
#define CAN2_IMR31_BUS 0x10U
#define CAN2_IMR31_BUS_BIT 4
#define CAN2_IMR31_RXOK_MASK 0x20U
#define CAN2_IMR31_RXOK 0x20U
#define CAN2_IMR31_RXOK_BIT 5
#define CAN2_IMR31_TXOK_MASK 0x40U
#define CAN2_IMR31_TXOK 0x40U
#define CAN2_IMR31_TXOK_BIT 6
#define CAN2_IMR31_RFRAME_MASK 0x80U
#define CAN2_IMR31_RFRAME 0x80U
#define CAN2_IMR31_RFRAME_BIT 7

#define ADC0_BASE 0xFFFC0000

#define ADC0_ECR (*(volatile unsigned long *)0xFFFC0050)
#define ADC0_ECR_OFFSET 0x50
#define ADC0_ECR_ADC_MASK 0x2U
#define ADC0_ECR_ADC 0x2U
#define ADC0_ECR_ADC_BIT 1

#define ADC0_DCR (*(volatile unsigned long *)0xFFFC0054)
#define ADC0_DCR_OFFSET 0x54
#define ADC0_DCR_ADC_MASK 0x2U
#define ADC0_DCR_ADC 0x2U
#define ADC0_DCR_ADC_BIT 1

#define ADC0_PMSR (*(volatile unsigned long *)0xFFFC0058)
#define ADC0_PMSR_OFFSET 0x58
#define ADC0_PMSR_ADC_MASK 0x2U
#define ADC0_PMSR_ADC 0x2U
#define ADC0_PMSR_ADC_BIT 1

#define ADC0_CR (*(volatile unsigned long *)0xFFFC0060)
#define ADC0_CR_OFFSET 0x60
#define ADC0_CR_SWRST_MASK 0x1U
#define ADC0_CR_SWRST 0x1U
#define ADC0_CR_SWRST_BIT 0
#define ADC0_CR_ADCEN_MASK 0x2U
#define ADC0_CR_ADCEN 0x2U
#define ADC0_CR_ADCEN_BIT 1
#define ADC0_CR_ADCDIS_MASK 0x4U
#define ADC0_CR_ADCDIS 0x4U
#define ADC0_CR_ADCDIS_BIT 2
#define ADC0_CR_START_MASK 0x8U
#define ADC0_CR_START 0x8U
#define ADC0_CR_START_BIT 3
#define ADC0_CR_STOP_MASK 0x10U
#define ADC0_CR_STOP 0x10U
#define ADC0_CR_STOP_BIT 4

#define ADC0_MR (*(volatile unsigned long *)0xFFFC0064)
#define ADC0_MR_OFFSET 0x64
#define ADC0_MR_PRLVAL_MASK 0x1FU
#define ADC0_MR_PRLVAL_BIT 0
#define ADC0_MR_STOPEN_MASK 0x40U
#define ADC0_MR_STOPEN 0x40U
#define ADC0_MR_STOPEN_BIT 6
#define ADC0_MR_STARTUPTIME_MASK 0xFF00U
#define ADC0_MR_STARTUPTIME_BIT 8
#define ADC0_MR_NBRCH_MASK 0x70000U
#define ADC0_MR_NBRCH_BIT 16
#define ADC0_MR_CONTCV_MASK 0x80000U
#define ADC0_MR_CONTCV 0x80000U
#define ADC0_MR_CONTCV_BIT 19

#define ADC0_CMR (*(volatile unsigned long *)0xFFFC0068)
#define ADC0_CMR_OFFSET 0x68
#define ADC0_CMR_CV1_MASK 0x7U
#define ADC0_CMR_CV1_BIT 0
#define ADC0_CMR_CV2_MASK 0x70U
#define ADC0_CMR_CV2_BIT 4
#define ADC0_CMR_CV3_MASK 0x700U
#define ADC0_CMR_CV3_BIT 8
#define ADC0_CMR_CV4_MASK 0x7000U
#define ADC0_CMR_CV4_BIT 12
#define ADC0_CMR_CV5_MASK 0x70000U
#define ADC0_CMR_CV5_BIT 16
#define ADC0_CMR_CV6_MASK 0x700000U
#define ADC0_CMR_CV6_BIT 20
#define ADC0_CMR_CV7_MASK 0x7000000U
#define ADC0_CMR_CV7_BIT 24
#define ADC0_CMR_CV8_MASK 0x70000000U
#define ADC0_CMR_CV8_BIT 28

#define ADC0_CSR (*(volatile unsigned long *)0xFFFC006C)
#define ADC0_CSR_OFFSET 0x6C
#define ADC0_CSR_OVR_MASK 0x4U
#define ADC0_CSR_OVR 0x4U
#define ADC0_CSR_OVR_BIT 2
#define ADC0_CSR_TEND_MASK 0x8U
#define ADC0_CSR_TEND 0x8U
#define ADC0_CSR_TEND_BIT 3

#define ADC0_SR (*(volatile unsigned long *)0xFFFC0070)
#define ADC0_SR_OFFSET 0x70
#define ADC0_SR_EOC_MASK 0x1U
#define ADC0_SR_EOC 0x1U
#define ADC0_SR_EOC_BIT 0
#define ADC0_SR_READY_MASK 0x2U
#define ADC0_SR_READY 0x2U
#define ADC0_SR_READY_BIT 1
#define ADC0_SR_OVR_MASK 0x4U
#define ADC0_SR_OVR 0x4U
#define ADC0_SR_OVR_BIT 2
#define ADC0_SR_TEND_MASK 0x8U
#define ADC0_SR_TEND 0x8U
#define ADC0_SR_TEND_BIT 3
#define ADC0_SR_ADCENS_MASK 0x100U
#define ADC0_SR_ADCENS 0x100U
#define ADC0_SR_ADCENS_BIT 8
#define ADC0_SR_CTCVS_MASK 0x200U
#define ADC0_SR_CTCVS 0x200U
#define ADC0_SR_CTCVS_BIT 9

#define ADC0_IER (*(volatile unsigned long *)0xFFFC0074)
#define ADC0_IER_OFFSET 0x74
#define ADC0_IER_EOC_MASK 0x1U
#define ADC0_IER_EOC 0x1U
#define ADC0_IER_EOC_BIT 0
#define ADC0_IER_READY_MASK 0x2U
#define ADC0_IER_READY 0x2U
#define ADC0_IER_READY_BIT 1
#define ADC0_IER_OVR_MASK 0x4U
#define ADC0_IER_OVR 0x4U
#define ADC0_IER_OVR_BIT 2
#define ADC0_IER_TEND_MASK 0x8U
#define ADC0_IER_TEND 0x8U
#define ADC0_IER_TEND_BIT 3

#define ADC0_IDR (*(volatile unsigned long *)0xFFFC0078)
#define ADC0_IDR_OFFSET 0x78
#define ADC0_IDR_EOC_MASK 0x1U
#define ADC0_IDR_EOC 0x1U
#define ADC0_IDR_EOC_BIT 0
#define ADC0_IDR_READY_MASK 0x2U
#define ADC0_IDR_READY 0x2U
#define ADC0_IDR_READY_BIT 1
#define ADC0_IDR_OVR_MASK 0x4U
#define ADC0_IDR_OVR 0x4U
#define ADC0_IDR_OVR_BIT 2
#define ADC0_IDR_TEND_MASK 0x8U
#define ADC0_IDR_TEND 0x8U
#define ADC0_IDR_TEND_BIT 3

#define ADC0_IMR (*(volatile unsigned long *)0xFFFC007C)
#define ADC0_IMR_OFFSET 0x7C
#define ADC0_IMR_EOC_MASK 0x1U
#define ADC0_IMR_EOC 0x1U
#define ADC0_IMR_EOC_BIT 0
#define ADC0_IMR_READY_MASK 0x2U
#define ADC0_IMR_READY 0x2U
#define ADC0_IMR_READY_BIT 1
#define ADC0_IMR_OVR_MASK 0x4U
#define ADC0_IMR_OVR 0x4U
#define ADC0_IMR_OVR_BIT 2
#define ADC0_IMR_TEND_MASK 0x8U
#define ADC0_IMR_TEND 0x8U
#define ADC0_IMR_TEND_BIT 3

#define ADC0_CDR (*(volatile unsigned long *)0xFFFC0080)
#define ADC0_CDR_OFFSET 0x80
#define ADC0_CDR_DATA_MASK 0x3FFU
#define ADC0_CDR_DATA_BIT 0

#define ADC1_BASE 0xFFFC4000

#define ADC1_ECR (*(volatile unsigned long *)0xFFFC4050)
#define ADC1_ECR_OFFSET 0x50
#define ADC1_ECR_ADC_MASK 0x2U
#define ADC1_ECR_ADC 0x2U
#define ADC1_ECR_ADC_BIT 1

#define ADC1_DCR (*(volatile unsigned long *)0xFFFC4054)
#define ADC1_DCR_OFFSET 0x54
#define ADC1_DCR_ADC_MASK 0x2U
#define ADC1_DCR_ADC 0x2U
#define ADC1_DCR_ADC_BIT 1

#define ADC1_PMSR (*(volatile unsigned long *)0xFFFC4058)
#define ADC1_PMSR_OFFSET 0x58
#define ADC1_PMSR_ADC_MASK 0x2U
#define ADC1_PMSR_ADC 0x2U
#define ADC1_PMSR_ADC_BIT 1

#define ADC1_CR (*(volatile unsigned long *)0xFFFC4060)
#define ADC1_CR_OFFSET 0x60
#define ADC1_CR_SWRST_MASK 0x1U
#define ADC1_CR_SWRST 0x1U
#define ADC1_CR_SWRST_BIT 0
#define ADC1_CR_ADCEN_MASK 0x2U
#define ADC1_CR_ADCEN 0x2U
#define ADC1_CR_ADCEN_BIT 1
#define ADC1_CR_ADCDIS_MASK 0x4U
#define ADC1_CR_ADCDIS 0x4U
#define ADC1_CR_ADCDIS_BIT 2
#define ADC1_CR_START_MASK 0x8U
#define ADC1_CR_START 0x8U
#define ADC1_CR_START_BIT 3
#define ADC1_CR_STOP_MASK 0x10U
#define ADC1_CR_STOP 0x10U
#define ADC1_CR_STOP_BIT 4

#define ADC1_MR (*(volatile unsigned long *)0xFFFC4064)
#define ADC1_MR_OFFSET 0x64
#define ADC1_MR_PRLVAL_MASK 0x1FU
#define ADC1_MR_PRLVAL_BIT 0
#define ADC1_MR_STOPEN_MASK 0x40U
#define ADC1_MR_STOPEN 0x40U
#define ADC1_MR_STOPEN_BIT 6
#define ADC1_MR_STARTUPTIME_MASK 0xFF00U
#define ADC1_MR_STARTUPTIME_BIT 8
#define ADC1_MR_NBRCH_MASK 0x70000U
#define ADC1_MR_NBRCH_BIT 16
#define ADC1_MR_CONTCV_MASK 0x80000U
#define ADC1_MR_CONTCV 0x80000U
#define ADC1_MR_CONTCV_BIT 19

#define ADC1_CMR (*(volatile unsigned long *)0xFFFC4068)
#define ADC1_CMR_OFFSET 0x68
#define ADC1_CMR_CV1_MASK 0x7U
#define ADC1_CMR_CV1_BIT 0
#define ADC1_CMR_CV2_MASK 0x70U
#define ADC1_CMR_CV2_BIT 4
#define ADC1_CMR_CV3_MASK 0x700U
#define ADC1_CMR_CV3_BIT 8
#define ADC1_CMR_CV4_MASK 0x7000U
#define ADC1_CMR_CV4_BIT 12
#define ADC1_CMR_CV5_MASK 0x70000U
#define ADC1_CMR_CV5_BIT 16
#define ADC1_CMR_CV6_MASK 0x700000U
#define ADC1_CMR_CV6_BIT 20
#define ADC1_CMR_CV7_MASK 0x7000000U
#define ADC1_CMR_CV7_BIT 24
#define ADC1_CMR_CV8_MASK 0x70000000U
#define ADC1_CMR_CV8_BIT 28

#define ADC1_CSR (*(volatile unsigned long *)0xFFFC406C)
#define ADC1_CSR_OFFSET 0x6C
#define ADC1_CSR_OVR_MASK 0x4U
#define ADC1_CSR_OVR 0x4U
#define ADC1_CSR_OVR_BIT 2
#define ADC1_CSR_TEND_MASK 0x8U
#define ADC1_CSR_TEND 0x8U
#define ADC1_CSR_TEND_BIT 3

#define ADC1_SR (*(volatile unsigned long *)0xFFFC4070)
#define ADC1_SR_OFFSET 0x70
#define ADC1_SR_EOC_MASK 0x1U
#define ADC1_SR_EOC 0x1U
#define ADC1_SR_EOC_BIT 0
#define ADC1_SR_READY_MASK 0x2U
#define ADC1_SR_READY 0x2U
#define ADC1_SR_READY_BIT 1
#define ADC1_SR_OVR_MASK 0x4U
#define ADC1_SR_OVR 0x4U
#define ADC1_SR_OVR_BIT 2
#define ADC1_SR_TEND_MASK 0x8U
#define ADC1_SR_TEND 0x8U
#define ADC1_SR_TEND_BIT 3
#define ADC1_SR_ADCENS_MASK 0x100U
#define ADC1_SR_ADCENS 0x100U
#define ADC1_SR_ADCENS_BIT 8
#define ADC1_SR_CTCVS_MASK 0x200U
#define ADC1_SR_CTCVS 0x200U
#define ADC1_SR_CTCVS_BIT 9

#define ADC1_IER (*(volatile unsigned long *)0xFFFC4074)
#define ADC1_IER_OFFSET 0x74
#define ADC1_IER_EOC_MASK 0x1U
#define ADC1_IER_EOC 0x1U
#define ADC1_IER_EOC_BIT 0
#define ADC1_IER_READY_MASK 0x2U
#define ADC1_IER_READY 0x2U
#define ADC1_IER_READY_BIT 1
#define ADC1_IER_OVR_MASK 0x4U
#define ADC1_IER_OVR 0x4U
#define ADC1_IER_OVR_BIT 2
#define ADC1_IER_TEND_MASK 0x8U
#define ADC1_IER_TEND 0x8U
#define ADC1_IER_TEND_BIT 3

#define ADC1_IDR (*(volatile unsigned long *)0xFFFC4078)
#define ADC1_IDR_OFFSET 0x78
#define ADC1_IDR_EOC_MASK 0x1U
#define ADC1_IDR_EOC 0x1U
#define ADC1_IDR_EOC_BIT 0
#define ADC1_IDR_READY_MASK 0x2U
#define ADC1_IDR_READY 0x2U
#define ADC1_IDR_READY_BIT 1
#define ADC1_IDR_OVR_MASK 0x4U
#define ADC1_IDR_OVR 0x4U
#define ADC1_IDR_OVR_BIT 2
#define ADC1_IDR_TEND_MASK 0x8U
#define ADC1_IDR_TEND 0x8U
#define ADC1_IDR_TEND_BIT 3

#define ADC1_IMR (*(volatile unsigned long *)0xFFFC407C)
#define ADC1_IMR_OFFSET 0x7C
#define ADC1_IMR_EOC_MASK 0x1U
#define ADC1_IMR_EOC 0x1U
#define ADC1_IMR_EOC_BIT 0
#define ADC1_IMR_READY_MASK 0x2U
#define ADC1_IMR_READY 0x2U
#define ADC1_IMR_READY_BIT 1
#define ADC1_IMR_OVR_MASK 0x4U
#define ADC1_IMR_OVR 0x4U
#define ADC1_IMR_OVR_BIT 2
#define ADC1_IMR_TEND_MASK 0x8U
#define ADC1_IMR_TEND 0x8U
#define ADC1_IMR_TEND_BIT 3

#define ADC1_CDR (*(volatile unsigned long *)0xFFFC4080)
#define ADC1_CDR_OFFSET 0x80
#define ADC1_CDR_DATA_MASK 0x3FFU
#define ADC1_CDR_DATA_BIT 0

#define GPT0_BASE 0xFFFC8000

#define GPT0C0_PER (*(volatile unsigned long *)0xFFFC8000)
#define GPT0C0_PER_OFFSET 0x0
#define GPT0C0_PER_TIOB_MASK 0x10000U
#define GPT0C0_PER_TIOB 0x10000U
#define GPT0C0_PER_TIOB_BIT 16
#define GPT0C0_PER_TIOA_MASK 0x20000U
#define GPT0C0_PER_TIOA 0x20000U
#define GPT0C0_PER_TIOA_BIT 17
#define GPT0C0_PER_TCLK_MASK 0x40000U
#define GPT0C0_PER_TCLK 0x40000U
#define GPT0C0_PER_TCLK_BIT 18

#define GPT0C0_PDR (*(volatile unsigned long *)0xFFFC8004)
#define GPT0C0_PDR_OFFSET 0x4
#define GPT0C0_PDR_TIOB_MASK 0x10000U
#define GPT0C0_PDR_TIOB 0x10000U
#define GPT0C0_PDR_TIOB_BIT 16
#define GPT0C0_PDR_TIOA_MASK 0x20000U
#define GPT0C0_PDR_TIOA 0x20000U
#define GPT0C0_PDR_TIOA_BIT 17
#define GPT0C0_PDR_TCLK_MASK 0x40000U
#define GPT0C0_PDR_TCLK 0x40000U
#define GPT0C0_PDR_TCLK_BIT 18

#define GPT0C0_PSR (*(volatile unsigned long *)0xFFFC8008)
#define GPT0C0_PSR_OFFSET 0x8
#define GPT0C0_PSR_TIOB_MASK 0x10000U
#define GPT0C0_PSR_TIOB 0x10000U
#define GPT0C0_PSR_TIOB_BIT 16
#define GPT0C0_PSR_TIOA_MASK 0x20000U
#define GPT0C0_PSR_TIOA 0x20000U
#define GPT0C0_PSR_TIOA_BIT 17
#define GPT0C0_PSR_TCLK_MASK 0x40000U
#define GPT0C0_PSR_TCLK 0x40000U
#define GPT0C0_PSR_TCLK_BIT 18

#define GPT0C0_OER (*(volatile unsigned long *)0xFFFC8010)
#define GPT0C0_OER_OFFSET 0x10
#define GPT0C0_OER_TIOB_MASK 0x10000U
#define GPT0C0_OER_TIOB 0x10000U
#define GPT0C0_OER_TIOB_BIT 16
#define GPT0C0_OER_TIOA_MASK 0x20000U
#define GPT0C0_OER_TIOA 0x20000U
#define GPT0C0_OER_TIOA_BIT 17
#define GPT0C0_OER_TCLK_MASK 0x40000U
#define GPT0C0_OER_TCLK 0x40000U
#define GPT0C0_OER_TCLK_BIT 18

#define GPT0C0_ODR (*(volatile unsigned long *)0xFFFC8014)
#define GPT0C0_ODR_OFFSET 0x14
#define GPT0C0_ODR_TIOB_MASK 0x10000U
#define GPT0C0_ODR_TIOB 0x10000U
#define GPT0C0_ODR_TIOB_BIT 16
#define GPT0C0_ODR_TIOA_MASK 0x20000U
#define GPT0C0_ODR_TIOA 0x20000U
#define GPT0C0_ODR_TIOA_BIT 17
#define GPT0C0_ODR_TCLK_MASK 0x40000U
#define GPT0C0_ODR_TCLK 0x40000U
#define GPT0C0_ODR_TCLK_BIT 18

#define GPT0C0_OSR (*(volatile unsigned long *)0xFFFC8018)
#define GPT0C0_OSR_OFFSET 0x18
#define GPT0C0_OSR_TIOB_MASK 0x10000U
#define GPT0C0_OSR_TIOB 0x10000U
#define GPT0C0_OSR_TIOB_BIT 16
#define GPT0C0_OSR_TIOA_MASK 0x20000U
#define GPT0C0_OSR_TIOA 0x20000U
#define GPT0C0_OSR_TIOA_BIT 17
#define GPT0C0_OSR_TCLK_MASK 0x40000U
#define GPT0C0_OSR_TCLK 0x40000U
#define GPT0C0_OSR_TCLK_BIT 18

#define GPT0C0_SODR (*(volatile unsigned long *)0xFFFC8030)
#define GPT0C0_SODR_OFFSET 0x30
#define GPT0C0_SODR_TIOB_MASK 0x10000U
#define GPT0C0_SODR_TIOB 0x10000U
#define GPT0C0_SODR_TIOB_BIT 16
#define GPT0C0_SODR_TIOA_MASK 0x20000U
#define GPT0C0_SODR_TIOA 0x20000U
#define GPT0C0_SODR_TIOA_BIT 17
#define GPT0C0_SODR_TCLK_MASK 0x40000U
#define GPT0C0_SODR_TCLK 0x40000U
#define GPT0C0_SODR_TCLK_BIT 18

#define GPT0C0_CODR (*(volatile unsigned long *)0xFFFC8034)
#define GPT0C0_CODR_OFFSET 0x34
#define GPT0C0_CODR_TIOB_MASK 0x10000U
#define GPT0C0_CODR_TIOB 0x10000U
#define GPT0C0_CODR_TIOB_BIT 16
#define GPT0C0_CODR_TIOA_MASK 0x20000U
#define GPT0C0_CODR_TIOA 0x20000U
#define GPT0C0_CODR_TIOA_BIT 17
#define GPT0C0_CODR_TCLK_MASK 0x40000U
#define GPT0C0_CODR_TCLK 0x40000U
#define GPT0C0_CODR_TCLK_BIT 18

#define GPT0C0_ODSR (*(volatile unsigned long *)0xFFFC8038)
#define GPT0C0_ODSR_OFFSET 0x38
#define GPT0C0_ODSR_TIOB_MASK 0x10000U
#define GPT0C0_ODSR_TIOB 0x10000U
#define GPT0C0_ODSR_TIOB_BIT 16
#define GPT0C0_ODSR_TIOA_MASK 0x20000U
#define GPT0C0_ODSR_TIOA 0x20000U
#define GPT0C0_ODSR_TIOA_BIT 17
#define GPT0C0_ODSR_TCLK_MASK 0x40000U
#define GPT0C0_ODSR_TCLK 0x40000U
#define GPT0C0_ODSR_TCLK_BIT 18

#define GPT0C0_PDSR (*(volatile unsigned long *)0xFFFC803C)
#define GPT0C0_PDSR_OFFSET 0x3C
#define GPT0C0_PDSR_TIOB_MASK 0x10000U
#define GPT0C0_PDSR_TIOB 0x10000U
#define GPT0C0_PDSR_TIOB_BIT 16
#define GPT0C0_PDSR_TIOA_MASK 0x20000U
#define GPT0C0_PDSR_TIOA 0x20000U
#define GPT0C0_PDSR_TIOA_BIT 17
#define GPT0C0_PDSR_TCLK_MASK 0x40000U
#define GPT0C0_PDSR_TCLK 0x40000U
#define GPT0C0_PDSR_TCLK_BIT 18

#define GPT0C0_MDER (*(volatile unsigned long *)0xFFFC8040)
#define GPT0C0_MDER_OFFSET 0x40
#define GPT0C0_MDER_TIOB_MASK 0x10000U
#define GPT0C0_MDER_TIOB 0x10000U
#define GPT0C0_MDER_TIOB_BIT 16
#define GPT0C0_MDER_TIOA_MASK 0x20000U
#define GPT0C0_MDER_TIOA 0x20000U
#define GPT0C0_MDER_TIOA_BIT 17
#define GPT0C0_MDER_TCLK_MASK 0x40000U
#define GPT0C0_MDER_TCLK 0x40000U
#define GPT0C0_MDER_TCLK_BIT 18

#define GPT0C0_MDDR (*(volatile unsigned long *)0xFFFC8044)
#define GPT0C0_MDDR_OFFSET 0x44
#define GPT0C0_MDDR_TIOB_MASK 0x10000U
#define GPT0C0_MDDR_TIOB 0x10000U
#define GPT0C0_MDDR_TIOB_BIT 16
#define GPT0C0_MDDR_TIOA_MASK 0x20000U
#define GPT0C0_MDDR_TIOA 0x20000U
#define GPT0C0_MDDR_TIOA_BIT 17
#define GPT0C0_MDDR_TCLK_MASK 0x40000U
#define GPT0C0_MDDR_TCLK 0x40000U
#define GPT0C0_MDDR_TCLK_BIT 18

#define GPT0C0_MDSR (*(volatile unsigned long *)0xFFFC8048)
#define GPT0C0_MDSR_OFFSET 0x48
#define GPT0C0_MDSR_TIOB_MASK 0x10000U
#define GPT0C0_MDSR_TIOB 0x10000U
#define GPT0C0_MDSR_TIOB_BIT 16
#define GPT0C0_MDSR_TIOA_MASK 0x20000U
#define GPT0C0_MDSR_TIOA 0x20000U
#define GPT0C0_MDSR_TIOA_BIT 17
#define GPT0C0_MDSR_TCLK_MASK 0x40000U
#define GPT0C0_MDSR_TCLK 0x40000U
#define GPT0C0_MDSR_TCLK_BIT 18

#define GPT0C0_ECR (*(volatile unsigned long *)0xFFFC8050)
#define GPT0C0_ECR_OFFSET 0x50
#define GPT0C0_ECR_PIO_MASK 0x1U
#define GPT0C0_ECR_PIO 0x1U
#define GPT0C0_ECR_PIO_BIT 0
#define GPT0C0_ECR_GPT_MASK 0x2U
#define GPT0C0_ECR_GPT 0x2U
#define GPT0C0_ECR_GPT_BIT 1

#define GPT0C0_DCR (*(volatile unsigned long *)0xFFFC8054)
#define GPT0C0_DCR_OFFSET 0x54
#define GPT0C0_DCR_PIO_MASK 0x1U
#define GPT0C0_DCR_PIO 0x1U
#define GPT0C0_DCR_PIO_BIT 0
#define GPT0C0_DCR_GPT_MASK 0x2U
#define GPT0C0_DCR_GPT 0x2U
#define GPT0C0_DCR_GPT_BIT 1

#define GPT0C0_PMSR (*(volatile unsigned long *)0xFFFC8058)
#define GPT0C0_PMSR_OFFSET 0x58
#define GPT0C0_PMSR_PIO_MASK 0x1U
#define GPT0C0_PMSR_PIO 0x1U
#define GPT0C0_PMSR_PIO_BIT 0
#define GPT0C0_PMSR_GPT_MASK 0x2U
#define GPT0C0_PMSR_GPT 0x2U
#define GPT0C0_PMSR_GPT_BIT 1

#define GPT0C0_CR (*(volatile unsigned long *)0xFFFC8060)
#define GPT0C0_CR_OFFSET 0x60
#define GPT0C0_CR_SWRST_MASK 0x1U
#define GPT0C0_CR_SWRST 0x1U
#define GPT0C0_CR_SWRST_BIT 0
#define GPT0C0_CR_CLKEN_MASK 0x2U
#define GPT0C0_CR_CLKEN 0x2U
#define GPT0C0_CR_CLKEN_BIT 1
#define GPT0C0_CR_CLKDIS_MASK 0x4U
#define GPT0C0_CR_CLKDIS 0x4U
#define GPT0C0_CR_CLKDIS_BIT 2
#define GPT0C0_CR_SWTRG_MASK 0x8U
#define GPT0C0_CR_SWTRG 0x8U
#define GPT0C0_CR_SWTRG_BIT 3

#define GPT0C0_MR (*(volatile unsigned long *)0xFFFC8064)
#define GPT0C0_MR_OFFSET 0x64
#define GPT0C0_MR_CLKS_MASK 0x7U
#define GPT0C0_MR_CLKS_BIT 0
#define GPT0C0_MR_CLKI_MASK 0x8U
#define GPT0C0_MR_CLKI 0x8U
#define GPT0C0_MR_CLKI_BIT 3
#define GPT0C0_MR_BURST_MASK 0x30U
#define GPT0C0_MR_BURST_BIT 4
#define GPT0C0_MR_LDBSTOP_MASK 0x40U
#define GPT0C0_MR_LDBSTOP 0x40U
#define GPT0C0_MR_LDBSTOP_BIT 6
#define GPT0C0_MR_LDBIS_MASK 0x80U
#define GPT0C0_MR_LDBIS 0x80U
#define GPT0C0_MR_LDBIS_BIT 7
#define GPT0C0_MR_ETRGEDG_MASK 0x300U
#define GPT0C0_MR_ETRGEDG_BIT 8
#define GPT0C0_MR_ABETRG_MASK 0x400U
#define GPT0C0_MR_ABETRG 0x400U
#define GPT0C0_MR_ABETRG_BIT 10
#define GPT0C0_MR_CPCTRG_MASK 0x4000U
#define GPT0C0_MR_CPCTRG 0x4000U
#define GPT0C0_MR_CPCTRG_BIT 14
#define GPT0C0_MR_WAVE_MASK 0x8000U
#define GPT0C0_MR_WAVE 0x8000U
#define GPT0C0_MR_WAVE_BIT 15
#define GPT0C0_MR_LDRA_MASK 0x30000U
#define GPT0C0_MR_LDRA_BIT 16
#define GPT0C0_MR_LDRB_MASK 0xC0000U
#define GPT0C0_MR_LDRB_BIT 18

#define GPT0C0_MR_WFM (*(volatile unsigned long *)0xFFFC8064)
#define GPT0C0_MR_WFM_OFFSET 0x64
#define GPT0C0_MR_WFM_CLKS_MASK 0x7U
#define GPT0C0_MR_WFM_CLKS_BIT 0
#define GPT0C0_MR_WFM_CLKI_MASK 0x8U
#define GPT0C0_MR_WFM_CLKI 0x8U
#define GPT0C0_MR_WFM_CLKI_BIT 3
#define GPT0C0_MR_WFM_BURST_MASK 0x30U
#define GPT0C0_MR_WFM_BURST_BIT 4
#define GPT0C0_MR_WFM_CPCSTOP_MASK 0x40U
#define GPT0C0_MR_WFM_CPCSTOP 0x40U
#define GPT0C0_MR_WFM_CPCSTOP_BIT 6
#define GPT0C0_MR_WFM_CPCDIS_MASK 0x80U
#define GPT0C0_MR_WFM_CPCDIS 0x80U
#define GPT0C0_MR_WFM_CPCDIS_BIT 7
#define GPT0C0_MR_WFM_EEVTEDG_MASK 0x300U
#define GPT0C0_MR_WFM_EEVTEDG_BIT 8
#define GPT0C0_MR_WFM_EEVT_MASK 0xC00U
#define GPT0C0_MR_WFM_EEVT_BIT 10
#define GPT0C0_MR_WFM_ENETRG_MASK 0x1000U
#define GPT0C0_MR_WFM_ENETRG 0x1000U
#define GPT0C0_MR_WFM_ENETRG_BIT 12
#define GPT0C0_MR_WFM_CPCTRG_MASK 0x4000U
#define GPT0C0_MR_WFM_CPCTRG 0x4000U
#define GPT0C0_MR_WFM_CPCTRG_BIT 14
#define GPT0C0_MR_WFM_WAVE_MASK 0x18000U
#define GPT0C0_MR_WFM_WAVE_BIT 15
#define GPT0C0_MR_WFM_ACPA_MASK 0x30000U
#define GPT0C0_MR_WFM_ACPA_BIT 16
#define GPT0C0_MR_WFM_ACPC_MASK 0xC0000U
#define GPT0C0_MR_WFM_ACPC_BIT 18
#define GPT0C0_MR_WFM_AEEVT_MASK 0x300000U
#define GPT0C0_MR_WFM_AEEVT_BIT 20
#define GPT0C0_MR_WFM_ASWTRG_MASK 0xC00000U
#define GPT0C0_MR_WFM_ASWTRG_BIT 22
#define GPT0C0_MR_WFM_BCPB_MASK 0x3000000U
#define GPT0C0_MR_WFM_BCPB_BIT 24
#define GPT0C0_MR_WFM_BCPC_MASK 0xC000000U
#define GPT0C0_MR_WFM_BCPC_BIT 26
#define GPT0C0_MR_WFM_BEEVT_MASK 0x30000000U
#define GPT0C0_MR_WFM_BEEVT_BIT 28
#define GPT0C0_MR_WFM_BSWTRG_MASK 0xC0000000U
#define GPT0C0_MR_WFM_BSWTRG_BIT 30

#define GPT0C0_SR (*(volatile unsigned long *)0xFFFC8070)
#define GPT0C0_SR_OFFSET 0x70
#define GPT0C0_SR_COVFS_MASK 0x1U
#define GPT0C0_SR_COVFS 0x1U
#define GPT0C0_SR_COVFS_BIT 0
#define GPT0C0_SR_LOVRS_MASK 0x2U
#define GPT0C0_SR_LOVRS 0x2U
#define GPT0C0_SR_LOVRS_BIT 1
#define GPT0C0_SR_CPCS_MASK 0x10U
#define GPT0C0_SR_CPCS 0x10U
#define GPT0C0_SR_CPCS_BIT 4
#define GPT0C0_SR_LDRAS_MASK 0x20U
#define GPT0C0_SR_LDRAS 0x20U
#define GPT0C0_SR_LDRAS_BIT 5
#define GPT0C0_SR_LDRBS_MASK 0x40U
#define GPT0C0_SR_LDRBS 0x40U
#define GPT0C0_SR_LDRBS_BIT 6
#define GPT0C0_SR_ETRGS_MASK 0x80U
#define GPT0C0_SR_ETRGS 0x80U
#define GPT0C0_SR_ETRGS_BIT 7
#define GPT0C0_SR_CLKSTA_MASK 0x100U
#define GPT0C0_SR_CLKSTA 0x100U
#define GPT0C0_SR_CLKSTA_BIT 8
#define GPT0C0_SR_MTIOA_MASK 0x200U
#define GPT0C0_SR_MTIOA 0x200U
#define GPT0C0_SR_MTIOA_BIT 9
#define GPT0C0_SR_MTIOB_MASK 0x400U
#define GPT0C0_SR_MTIOB 0x400U
#define GPT0C0_SR_MTIOB_BIT 10
#define GPT0C0_SR_TIOBS_MASK 0x10000U
#define GPT0C0_SR_TIOBS 0x10000U
#define GPT0C0_SR_TIOBS_BIT 16
#define GPT0C0_SR_TIOAS_MASK 0x20000U
#define GPT0C0_SR_TIOAS 0x20000U
#define GPT0C0_SR_TIOAS_BIT 17
#define GPT0C0_SR_TCLKS_MASK 0x40000U
#define GPT0C0_SR_TCLKS 0x40000U
#define GPT0C0_SR_TCLKS_BIT 18

#define GPT0C0_SR_WFM (*(volatile unsigned long *)0xFFFC8070)
#define GPT0C0_SR_WFM_OFFSET 0x70
#define GPT0C0_SR_WFM_COVFS_MASK 0x1U
#define GPT0C0_SR_WFM_COVFS 0x1U
#define GPT0C0_SR_WFM_COVFS_BIT 0
#define GPT0C0_SR_WFM_CPAS_MASK 0x4U
#define GPT0C0_SR_WFM_CPAS 0x4U
#define GPT0C0_SR_WFM_CPAS_BIT 2
#define GPT0C0_SR_WFM_CPBS_MASK 0x8U
#define GPT0C0_SR_WFM_CPBS 0x8U
#define GPT0C0_SR_WFM_CPBS_BIT 3
#define GPT0C0_SR_WFM_CPCS_MASK 0x10U
#define GPT0C0_SR_WFM_CPCS 0x10U
#define GPT0C0_SR_WFM_CPCS_BIT 4
#define GPT0C0_SR_WFM_ETRGS_MASK 0x80U
#define GPT0C0_SR_WFM_ETRGS 0x80U
#define GPT0C0_SR_WFM_ETRGS_BIT 7
#define GPT0C0_SR_WFM_CLKSTA_MASK 0x100U
#define GPT0C0_SR_WFM_CLKSTA 0x100U
#define GPT0C0_SR_WFM_CLKSTA_BIT 8
#define GPT0C0_SR_WFM_MTIOA_MASK 0x200U
#define GPT0C0_SR_WFM_MTIOA 0x200U
#define GPT0C0_SR_WFM_MTIOA_BIT 9
#define GPT0C0_SR_WFM_MTIOB_MASK 0x400U
#define GPT0C0_SR_WFM_MTIOB 0x400U
#define GPT0C0_SR_WFM_MTIOB_BIT 10
#define GPT0C0_SR_WFM_TIOBS_MASK 0x10000U
#define GPT0C0_SR_WFM_TIOBS 0x10000U
#define GPT0C0_SR_WFM_TIOBS_BIT 16
#define GPT0C0_SR_WFM_TIOAS_MASK 0x20000U
#define GPT0C0_SR_WFM_TIOAS 0x20000U
#define GPT0C0_SR_WFM_TIOAS_BIT 17
#define GPT0C0_SR_WFM_TCLKS_MASK 0x40000U
#define GPT0C0_SR_WFM_TCLKS 0x40000U
#define GPT0C0_SR_WFM_TCLKS_BIT 18

#define GPT0C0_IER (*(volatile unsigned long *)0xFFFC8074)
#define GPT0C0_IER_OFFSET 0x74
#define GPT0C0_IER_COVFS_MASK 0x1U
#define GPT0C0_IER_COVFS 0x1U
#define GPT0C0_IER_COVFS_BIT 0
#define GPT0C0_IER_LOVRS_MASK 0x2U
#define GPT0C0_IER_LOVRS 0x2U
#define GPT0C0_IER_LOVRS_BIT 1
#define GPT0C0_IER_CPCS_MASK 0x10U
#define GPT0C0_IER_CPCS 0x10U
#define GPT0C0_IER_CPCS_BIT 4
#define GPT0C0_IER_LDRAS_MASK 0x20U
#define GPT0C0_IER_LDRAS 0x20U
#define GPT0C0_IER_LDRAS_BIT 5
#define GPT0C0_IER_LDRBS_MASK 0x40U
#define GPT0C0_IER_LDRBS 0x40U
#define GPT0C0_IER_LDRBS_BIT 6
#define GPT0C0_IER_ETRGS_MASK 0x80U
#define GPT0C0_IER_ETRGS 0x80U
#define GPT0C0_IER_ETRGS_BIT 7
#define GPT0C0_IER_TIOBS_MASK 0x10000U
#define GPT0C0_IER_TIOBS 0x10000U
#define GPT0C0_IER_TIOBS_BIT 16
#define GPT0C0_IER_TIOAS_MASK 0x20000U
#define GPT0C0_IER_TIOAS 0x20000U
#define GPT0C0_IER_TIOAS_BIT 17
#define GPT0C0_IER_TCLKS_MASK 0x40000U
#define GPT0C0_IER_TCLKS 0x40000U
#define GPT0C0_IER_TCLKS_BIT 18

#define GPT0C0_IER_WFM (*(volatile unsigned long *)0xFFFC8074)
#define GPT0C0_IER_WFM_OFFSET 0x74
#define GPT0C0_IER_WFM_COVFS_MASK 0x1U
#define GPT0C0_IER_WFM_COVFS 0x1U
#define GPT0C0_IER_WFM_COVFS_BIT 0
#define GPT0C0_IER_WFM_CPAS_MASK 0x4U
#define GPT0C0_IER_WFM_CPAS 0x4U
#define GPT0C0_IER_WFM_CPAS_BIT 2
#define GPT0C0_IER_WFM_CPBS_MASK 0x8U
#define GPT0C0_IER_WFM_CPBS 0x8U
#define GPT0C0_IER_WFM_CPBS_BIT 3
#define GPT0C0_IER_WFM_CPCS_MASK 0x10U
#define GPT0C0_IER_WFM_CPCS 0x10U
#define GPT0C0_IER_WFM_CPCS_BIT 4
#define GPT0C0_IER_WFM_ETRGS_MASK 0x80U
#define GPT0C0_IER_WFM_ETRGS 0x80U
#define GPT0C0_IER_WFM_ETRGS_BIT 7
#define GPT0C0_IER_WFM_TIOBS_MASK 0x10000U
#define GPT0C0_IER_WFM_TIOBS 0x10000U
#define GPT0C0_IER_WFM_TIOBS_BIT 16
#define GPT0C0_IER_WFM_TIOAS_MASK 0x20000U
#define GPT0C0_IER_WFM_TIOAS 0x20000U
#define GPT0C0_IER_WFM_TIOAS_BIT 17
#define GPT0C0_IER_WFM_TCLKS_MASK 0x40000U
#define GPT0C0_IER_WFM_TCLKS 0x40000U
#define GPT0C0_IER_WFM_TCLKS_BIT 18

#define GPT0C0_IDR (*(volatile unsigned long *)0xFFFC8078)
#define GPT0C0_IDR_OFFSET 0x78
#define GPT0C0_IDR_COVFS_MASK 0x1U
#define GPT0C0_IDR_COVFS 0x1U
#define GPT0C0_IDR_COVFS_BIT 0
#define GPT0C0_IDR_LOVRS_MASK 0x2U
#define GPT0C0_IDR_LOVRS 0x2U
#define GPT0C0_IDR_LOVRS_BIT 1
#define GPT0C0_IDR_CPCS_MASK 0x10U
#define GPT0C0_IDR_CPCS 0x10U
#define GPT0C0_IDR_CPCS_BIT 4
#define GPT0C0_IDR_LDRAS_MASK 0x20U
#define GPT0C0_IDR_LDRAS 0x20U
#define GPT0C0_IDR_LDRAS_BIT 5
#define GPT0C0_IDR_LDRBS_MASK 0x40U
#define GPT0C0_IDR_LDRBS 0x40U
#define GPT0C0_IDR_LDRBS_BIT 6
#define GPT0C0_IDR_ETRGS_MASK 0x80U
#define GPT0C0_IDR_ETRGS 0x80U
#define GPT0C0_IDR_ETRGS_BIT 7
#define GPT0C0_IDR_TIOBS_MASK 0x10000U
#define GPT0C0_IDR_TIOBS 0x10000U
#define GPT0C0_IDR_TIOBS_BIT 16
#define GPT0C0_IDR_TIOAS_MASK 0x20000U
#define GPT0C0_IDR_TIOAS 0x20000U
#define GPT0C0_IDR_TIOAS_BIT 17
#define GPT0C0_IDR_TCLKS_MASK 0x40000U
#define GPT0C0_IDR_TCLKS 0x40000U
#define GPT0C0_IDR_TCLKS_BIT 18

#define GPT0C0_IDR_WFM (*(volatile unsigned long *)0xFFFC8078)
#define GPT0C0_IDR_WFM_OFFSET 0x78
#define GPT0C0_IDR_WFM_COVFS_MASK 0x1U
#define GPT0C0_IDR_WFM_COVFS 0x1U
#define GPT0C0_IDR_WFM_COVFS_BIT 0
#define GPT0C0_IDR_WFM_CPAS_MASK 0x4U
#define GPT0C0_IDR_WFM_CPAS 0x4U
#define GPT0C0_IDR_WFM_CPAS_BIT 2
#define GPT0C0_IDR_WFM_CPBS_MASK 0x8U
#define GPT0C0_IDR_WFM_CPBS 0x8U
#define GPT0C0_IDR_WFM_CPBS_BIT 3
#define GPT0C0_IDR_WFM_CPCS_MASK 0x10U
#define GPT0C0_IDR_WFM_CPCS 0x10U
#define GPT0C0_IDR_WFM_CPCS_BIT 4
#define GPT0C0_IDR_WFM_ETRGS_MASK 0x80U
#define GPT0C0_IDR_WFM_ETRGS 0x80U
#define GPT0C0_IDR_WFM_ETRGS_BIT 7
#define GPT0C0_IDR_WFM_TIOBS_MASK 0x10000U
#define GPT0C0_IDR_WFM_TIOBS 0x10000U
#define GPT0C0_IDR_WFM_TIOBS_BIT 16
#define GPT0C0_IDR_WFM_TIOAS_MASK 0x20000U
#define GPT0C0_IDR_WFM_TIOAS 0x20000U
#define GPT0C0_IDR_WFM_TIOAS_BIT 17
#define GPT0C0_IDR_WFM_TCLKS_MASK 0x40000U
#define GPT0C0_IDR_WFM_TCLKS 0x40000U
#define GPT0C0_IDR_WFM_TCLKS_BIT 18

#define GPT0C0_IMR (*(volatile unsigned long *)0xFFFC807C)
#define GPT0C0_IMR_OFFSET 0x7C
#define GPT0C0_IMR_COVFS_MASK 0x1U
#define GPT0C0_IMR_COVFS 0x1U
#define GPT0C0_IMR_COVFS_BIT 0
#define GPT0C0_IMR_LOVRS_MASK 0x2U
#define GPT0C0_IMR_LOVRS 0x2U
#define GPT0C0_IMR_LOVRS_BIT 1
#define GPT0C0_IMR_CPCS_MASK 0x10U
#define GPT0C0_IMR_CPCS 0x10U
#define GPT0C0_IMR_CPCS_BIT 4
#define GPT0C0_IMR_LDRAS_MASK 0x20U
#define GPT0C0_IMR_LDRAS 0x20U
#define GPT0C0_IMR_LDRAS_BIT 5
#define GPT0C0_IMR_LDRBS_MASK 0x40U
#define GPT0C0_IMR_LDRBS 0x40U
#define GPT0C0_IMR_LDRBS_BIT 6
#define GPT0C0_IMR_ETRGS_MASK 0x80U
#define GPT0C0_IMR_ETRGS 0x80U
#define GPT0C0_IMR_ETRGS_BIT 7
#define GPT0C0_IMR_TIOBS_MASK 0x10000U
#define GPT0C0_IMR_TIOBS 0x10000U
#define GPT0C0_IMR_TIOBS_BIT 16
#define GPT0C0_IMR_TIOAS_MASK 0x20000U
#define GPT0C0_IMR_TIOAS 0x20000U
#define GPT0C0_IMR_TIOAS_BIT 17
#define GPT0C0_IMR_TCLKS_MASK 0x40000U
#define GPT0C0_IMR_TCLKS 0x40000U
#define GPT0C0_IMR_TCLKS_BIT 18

#define GPT0C0_IMR_WFM (*(volatile unsigned long *)0xFFFC807C)
#define GPT0C0_IMR_WFM_OFFSET 0x7C
#define GPT0C0_IMR_WFM_COVFS_MASK 0x1U
#define GPT0C0_IMR_WFM_COVFS 0x1U
#define GPT0C0_IMR_WFM_COVFS_BIT 0
#define GPT0C0_IMR_WFM_CPAS_MASK 0x4U
#define GPT0C0_IMR_WFM_CPAS 0x4U
#define GPT0C0_IMR_WFM_CPAS_BIT 2
#define GPT0C0_IMR_WFM_CPBS_MASK 0x8U
#define GPT0C0_IMR_WFM_CPBS 0x8U
#define GPT0C0_IMR_WFM_CPBS_BIT 3
#define GPT0C0_IMR_WFM_CPCS_MASK 0x10U
#define GPT0C0_IMR_WFM_CPCS 0x10U
#define GPT0C0_IMR_WFM_CPCS_BIT 4
#define GPT0C0_IMR_WFM_ETRGS_MASK 0x80U
#define GPT0C0_IMR_WFM_ETRGS 0x80U
#define GPT0C0_IMR_WFM_ETRGS_BIT 7
#define GPT0C0_IMR_WFM_TIOBS_MASK 0x10000U
#define GPT0C0_IMR_WFM_TIOBS 0x10000U
#define GPT0C0_IMR_WFM_TIOBS_BIT 16
#define GPT0C0_IMR_WFM_TIOAS_MASK 0x20000U
#define GPT0C0_IMR_WFM_TIOAS 0x20000U
#define GPT0C0_IMR_WFM_TIOAS_BIT 17
#define GPT0C0_IMR_WFM_TCLKS_MASK 0x40000U
#define GPT0C0_IMR_WFM_TCLKS 0x40000U
#define GPT0C0_IMR_WFM_TCLKS_BIT 18

#define GPT0C0_CV (*(volatile unsigned long *)0xFFFC8080)
#define GPT0C0_CV_OFFSET 0x80
#define GPT0C0_CV_CV_MASK 0xFFFFU
#define GPT0C0_CV_CV_BIT 0

#define GPT0C0_RA (*(volatile unsigned long *)0xFFFC8084)
#define GPT0C0_RA_OFFSET 0x84
#define GPT0C0_RA_RA_MASK 0xFFFFU
#define GPT0C0_RA_RA_BIT 0

#define GPT0C0_RB (*(volatile unsigned long *)0xFFFC8088)
#define GPT0C0_RB_OFFSET 0x88
#define GPT0C0_RB_RB_MASK 0xFFFFU
#define GPT0C0_RB_RB_BIT 0

#define GPT0C0_RC (*(volatile unsigned long *)0xFFFC808C)
#define GPT0C0_RC_OFFSET 0x8C
#define GPT0C0_RC_RC_MASK 0xFFFFU
#define GPT0C0_RC_RC_BIT 0

#define GPT0C1_PER (*(volatile unsigned long *)0xFFFC8100)
#define GPT0C1_PER_OFFSET 0x100
#define GPT0C1_PER_TIOB_MASK 0x10000U
#define GPT0C1_PER_TIOB 0x10000U
#define GPT0C1_PER_TIOB_BIT 16
#define GPT0C1_PER_TIOA_MASK 0x20000U
#define GPT0C1_PER_TIOA 0x20000U
#define GPT0C1_PER_TIOA_BIT 17
#define GPT0C1_PER_TCLK_MASK 0x40000U
#define GPT0C1_PER_TCLK 0x40000U
#define GPT0C1_PER_TCLK_BIT 18

#define GPT0C1_PDR (*(volatile unsigned long *)0xFFFC8104)
#define GPT0C1_PDR_OFFSET 0x104
#define GPT0C1_PDR_TIOB_MASK 0x10000U
#define GPT0C1_PDR_TIOB 0x10000U
#define GPT0C1_PDR_TIOB_BIT 16
#define GPT0C1_PDR_TIOA_MASK 0x20000U
#define GPT0C1_PDR_TIOA 0x20000U
#define GPT0C1_PDR_TIOA_BIT 17
#define GPT0C1_PDR_TCLK_MASK 0x40000U
#define GPT0C1_PDR_TCLK 0x40000U
#define GPT0C1_PDR_TCLK_BIT 18

#define GPT0C1_PSR (*(volatile unsigned long *)0xFFFC8108)
#define GPT0C1_PSR_OFFSET 0x108
#define GPT0C1_PSR_TIOB_MASK 0x10000U
#define GPT0C1_PSR_TIOB 0x10000U
#define GPT0C1_PSR_TIOB_BIT 16
#define GPT0C1_PSR_TIOA_MASK 0x20000U
#define GPT0C1_PSR_TIOA 0x20000U
#define GPT0C1_PSR_TIOA_BIT 17
#define GPT0C1_PSR_TCLK_MASK 0x40000U
#define GPT0C1_PSR_TCLK 0x40000U
#define GPT0C1_PSR_TCLK_BIT 18

#define GPT0C1_OER (*(volatile unsigned long *)0xFFFC8110)
#define GPT0C1_OER_OFFSET 0x110
#define GPT0C1_OER_TIOB_MASK 0x10000U
#define GPT0C1_OER_TIOB 0x10000U
#define GPT0C1_OER_TIOB_BIT 16
#define GPT0C1_OER_TIOA_MASK 0x20000U
#define GPT0C1_OER_TIOA 0x20000U
#define GPT0C1_OER_TIOA_BIT 17
#define GPT0C1_OER_TCLK_MASK 0x40000U
#define GPT0C1_OER_TCLK 0x40000U
#define GPT0C1_OER_TCLK_BIT 18

#define GPT0C1_ODR (*(volatile unsigned long *)0xFFFC8114)
#define GPT0C1_ODR_OFFSET 0x114
#define GPT0C1_ODR_TIOB_MASK 0x10000U
#define GPT0C1_ODR_TIOB 0x10000U
#define GPT0C1_ODR_TIOB_BIT 16
#define GPT0C1_ODR_TIOA_MASK 0x20000U
#define GPT0C1_ODR_TIOA 0x20000U
#define GPT0C1_ODR_TIOA_BIT 17
#define GPT0C1_ODR_TCLK_MASK 0x40000U
#define GPT0C1_ODR_TCLK 0x40000U
#define GPT0C1_ODR_TCLK_BIT 18

#define GPT0C1_OSR (*(volatile unsigned long *)0xFFFC8118)
#define GPT0C1_OSR_OFFSET 0x118
#define GPT0C1_OSR_TIOB_MASK 0x10000U
#define GPT0C1_OSR_TIOB 0x10000U
#define GPT0C1_OSR_TIOB_BIT 16
#define GPT0C1_OSR_TIOA_MASK 0x20000U
#define GPT0C1_OSR_TIOA 0x20000U
#define GPT0C1_OSR_TIOA_BIT 17
#define GPT0C1_OSR_TCLK_MASK 0x40000U
#define GPT0C1_OSR_TCLK 0x40000U
#define GPT0C1_OSR_TCLK_BIT 18

#define GPT0C1_SODR (*(volatile unsigned long *)0xFFFC8130)
#define GPT0C1_SODR_OFFSET 0x130
#define GPT0C1_SODR_TIOB_MASK 0x10000U
#define GPT0C1_SODR_TIOB 0x10000U
#define GPT0C1_SODR_TIOB_BIT 16
#define GPT0C1_SODR_TIOA_MASK 0x20000U
#define GPT0C1_SODR_TIOA 0x20000U
#define GPT0C1_SODR_TIOA_BIT 17
#define GPT0C1_SODR_TCLK_MASK 0x40000U
#define GPT0C1_SODR_TCLK 0x40000U
#define GPT0C1_SODR_TCLK_BIT 18

#define GPT0C1_CODR (*(volatile unsigned long *)0xFFFC8134)
#define GPT0C1_CODR_OFFSET 0x134
#define GPT0C1_CODR_TIOB_MASK 0x10000U
#define GPT0C1_CODR_TIOB 0x10000U
#define GPT0C1_CODR_TIOB_BIT 16
#define GPT0C1_CODR_TIOA_MASK 0x20000U
#define GPT0C1_CODR_TIOA 0x20000U
#define GPT0C1_CODR_TIOA_BIT 17
#define GPT0C1_CODR_TCLK_MASK 0x40000U
#define GPT0C1_CODR_TCLK 0x40000U
#define GPT0C1_CODR_TCLK_BIT 18

#define GPT0C1_ODSR (*(volatile unsigned long *)0xFFFC8138)
#define GPT0C1_ODSR_OFFSET 0x138
#define GPT0C1_ODSR_TIOB_MASK 0x10000U
#define GPT0C1_ODSR_TIOB 0x10000U
#define GPT0C1_ODSR_TIOB_BIT 16
#define GPT0C1_ODSR_TIOA_MASK 0x20000U
#define GPT0C1_ODSR_TIOA 0x20000U
#define GPT0C1_ODSR_TIOA_BIT 17
#define GPT0C1_ODSR_TCLK_MASK 0x40000U
#define GPT0C1_ODSR_TCLK 0x40000U
#define GPT0C1_ODSR_TCLK_BIT 18

#define GPT0C1_PDSR (*(volatile unsigned long *)0xFFFC813C)
#define GPT0C1_PDSR_OFFSET 0x13C
#define GPT0C1_PDSR_TIOB_MASK 0x10000U
#define GPT0C1_PDSR_TIOB 0x10000U
#define GPT0C1_PDSR_TIOB_BIT 16
#define GPT0C1_PDSR_TIOA_MASK 0x20000U
#define GPT0C1_PDSR_TIOA 0x20000U
#define GPT0C1_PDSR_TIOA_BIT 17
#define GPT0C1_PDSR_TCLK_MASK 0x40000U
#define GPT0C1_PDSR_TCLK 0x40000U
#define GPT0C1_PDSR_TCLK_BIT 18

#define GPT0C1_MDER (*(volatile unsigned long *)0xFFFC8140)
#define GPT0C1_MDER_OFFSET 0x140
#define GPT0C1_MDER_TIOB_MASK 0x10000U
#define GPT0C1_MDER_TIOB 0x10000U
#define GPT0C1_MDER_TIOB_BIT 16
#define GPT0C1_MDER_TIOA_MASK 0x20000U
#define GPT0C1_MDER_TIOA 0x20000U
#define GPT0C1_MDER_TIOA_BIT 17
#define GPT0C1_MDER_TCLK_MASK 0x40000U
#define GPT0C1_MDER_TCLK 0x40000U
#define GPT0C1_MDER_TCLK_BIT 18

#define GPT0C1_MDDR (*(volatile unsigned long *)0xFFFC8144)
#define GPT0C1_MDDR_OFFSET 0x144
#define GPT0C1_MDDR_TIOB_MASK 0x10000U
#define GPT0C1_MDDR_TIOB 0x10000U
#define GPT0C1_MDDR_TIOB_BIT 16
#define GPT0C1_MDDR_TIOA_MASK 0x20000U
#define GPT0C1_MDDR_TIOA 0x20000U
#define GPT0C1_MDDR_TIOA_BIT 17
#define GPT0C1_MDDR_TCLK_MASK 0x40000U
#define GPT0C1_MDDR_TCLK 0x40000U
#define GPT0C1_MDDR_TCLK_BIT 18

#define GPT0C1_MDSR (*(volatile unsigned long *)0xFFFC8148)
#define GPT0C1_MDSR_OFFSET 0x148
#define GPT0C1_MDSR_TIOB_MASK 0x10000U
#define GPT0C1_MDSR_TIOB 0x10000U
#define GPT0C1_MDSR_TIOB_BIT 16
#define GPT0C1_MDSR_TIOA_MASK 0x20000U
#define GPT0C1_MDSR_TIOA 0x20000U
#define GPT0C1_MDSR_TIOA_BIT 17
#define GPT0C1_MDSR_TCLK_MASK 0x40000U
#define GPT0C1_MDSR_TCLK 0x40000U
#define GPT0C1_MDSR_TCLK_BIT 18

#define GPT0C1_ECR (*(volatile unsigned long *)0xFFFC8150)
#define GPT0C1_ECR_OFFSET 0x150
#define GPT0C1_ECR_PIO_MASK 0x1U
#define GPT0C1_ECR_PIO 0x1U
#define GPT0C1_ECR_PIO_BIT 0
#define GPT0C1_ECR_GPT_MASK 0x2U
#define GPT0C1_ECR_GPT 0x2U
#define GPT0C1_ECR_GPT_BIT 1

#define GPT0C1_DCR (*(volatile unsigned long *)0xFFFC8154)
#define GPT0C1_DCR_OFFSET 0x154
#define GPT0C1_DCR_PIO_MASK 0x1U
#define GPT0C1_DCR_PIO 0x1U
#define GPT0C1_DCR_PIO_BIT 0
#define GPT0C1_DCR_GPT_MASK 0x2U
#define GPT0C1_DCR_GPT 0x2U
#define GPT0C1_DCR_GPT_BIT 1

#define GPT0C1_PMSR (*(volatile unsigned long *)0xFFFC8158)
#define GPT0C1_PMSR_OFFSET 0x158
#define GPT0C1_PMSR_PIO_MASK 0x1U
#define GPT0C1_PMSR_PIO 0x1U
#define GPT0C1_PMSR_PIO_BIT 0
#define GPT0C1_PMSR_GPT_MASK 0x2U
#define GPT0C1_PMSR_GPT 0x2U
#define GPT0C1_PMSR_GPT_BIT 1

#define GPT0C1_CR (*(volatile unsigned long *)0xFFFC8160)
#define GPT0C1_CR_OFFSET 0x160
#define GPT0C1_CR_SWRST_MASK 0x1U
#define GPT0C1_CR_SWRST 0x1U
#define GPT0C1_CR_SWRST_BIT 0
#define GPT0C1_CR_CLKEN_MASK 0x2U
#define GPT0C1_CR_CLKEN 0x2U
#define GPT0C1_CR_CLKEN_BIT 1
#define GPT0C1_CR_CLKDIS_MASK 0x4U
#define GPT0C1_CR_CLKDIS 0x4U
#define GPT0C1_CR_CLKDIS_BIT 2
#define GPT0C1_CR_SWTRG_MASK 0x8U
#define GPT0C1_CR_SWTRG 0x8U
#define GPT0C1_CR_SWTRG_BIT 3

#define GPT0C1_MR (*(volatile unsigned long *)0xFFFC8164)
#define GPT0C1_MR_OFFSET 0x164
#define GPT0C1_MR_CLKS_MASK 0x7U
#define GPT0C1_MR_CLKS_BIT 0
#define GPT0C1_MR_CLKI_MASK 0x8U
#define GPT0C1_MR_CLKI 0x8U
#define GPT0C1_MR_CLKI_BIT 3
#define GPT0C1_MR_BURST_MASK 0x30U
#define GPT0C1_MR_BURST_BIT 4
#define GPT0C1_MR_LDBSTOP_MASK 0x40U
#define GPT0C1_MR_LDBSTOP 0x40U
#define GPT0C1_MR_LDBSTOP_BIT 6
#define GPT0C1_MR_LDBIS_MASK 0x80U
#define GPT0C1_MR_LDBIS 0x80U
#define GPT0C1_MR_LDBIS_BIT 7
#define GPT0C1_MR_ETRGEDG_MASK 0x300U
#define GPT0C1_MR_ETRGEDG_BIT 8
#define GPT0C1_MR_ABETRG_MASK 0x400U
#define GPT0C1_MR_ABETRG 0x400U
#define GPT0C1_MR_ABETRG_BIT 10
#define GPT0C1_MR_CPCTRG_MASK 0x4000U
#define GPT0C1_MR_CPCTRG 0x4000U
#define GPT0C1_MR_CPCTRG_BIT 14
#define GPT0C1_MR_WAVE_MASK 0x8000U
#define GPT0C1_MR_WAVE 0x8000U
#define GPT0C1_MR_WAVE_BIT 15
#define GPT0C1_MR_LDRA_MASK 0x30000U
#define GPT0C1_MR_LDRA_BIT 16
#define GPT0C1_MR_LDRB_MASK 0xC0000U
#define GPT0C1_MR_LDRB_BIT 18

#define GPT0C1_MR_WFM (*(volatile unsigned long *)0xFFFC8164)
#define GPT0C1_MR_WFM_OFFSET 0x164
#define GPT0C1_MR_WFM_CLKS_MASK 0x7U
#define GPT0C1_MR_WFM_CLKS_BIT 0
#define GPT0C1_MR_WFM_CLKI_MASK 0x8U
#define GPT0C1_MR_WFM_CLKI 0x8U
#define GPT0C1_MR_WFM_CLKI_BIT 3
#define GPT0C1_MR_WFM_BURST_MASK 0x30U
#define GPT0C1_MR_WFM_BURST_BIT 4
#define GPT0C1_MR_WFM_CPCSTOP_MASK 0x40U
#define GPT0C1_MR_WFM_CPCSTOP 0x40U
#define GPT0C1_MR_WFM_CPCSTOP_BIT 6
#define GPT0C1_MR_WFM_CPCDIS_MASK 0x80U
#define GPT0C1_MR_WFM_CPCDIS 0x80U
#define GPT0C1_MR_WFM_CPCDIS_BIT 7
#define GPT0C1_MR_WFM_EEVTEDG_MASK 0x300U
#define GPT0C1_MR_WFM_EEVTEDG_BIT 8
#define GPT0C1_MR_WFM_EEVT_MASK 0xC00U
#define GPT0C1_MR_WFM_EEVT_BIT 10
#define GPT0C1_MR_WFM_ENETRG_MASK 0x1000U
#define GPT0C1_MR_WFM_ENETRG 0x1000U
#define GPT0C1_MR_WFM_ENETRG_BIT 12
#define GPT0C1_MR_WFM_CPCTRG_MASK 0x4000U
#define GPT0C1_MR_WFM_CPCTRG 0x4000U
#define GPT0C1_MR_WFM_CPCTRG_BIT 14
#define GPT0C1_MR_WFM_WAVE_MASK 0x18000U
#define GPT0C1_MR_WFM_WAVE_BIT 15
#define GPT0C1_MR_WFM_ACPA_MASK 0x30000U
#define GPT0C1_MR_WFM_ACPA_BIT 16
#define GPT0C1_MR_WFM_ACPC_MASK 0xC0000U
#define GPT0C1_MR_WFM_ACPC_BIT 18
#define GPT0C1_MR_WFM_AEEVT_MASK 0x300000U
#define GPT0C1_MR_WFM_AEEVT_BIT 20
#define GPT0C1_MR_WFM_ASWTRG_MASK 0xC00000U
#define GPT0C1_MR_WFM_ASWTRG_BIT 22
#define GPT0C1_MR_WFM_BCPB_MASK 0x3000000U
#define GPT0C1_MR_WFM_BCPB_BIT 24
#define GPT0C1_MR_WFM_BCPC_MASK 0xC000000U
#define GPT0C1_MR_WFM_BCPC_BIT 26
#define GPT0C1_MR_WFM_BEEVT_MASK 0x30000000U
#define GPT0C1_MR_WFM_BEEVT_BIT 28
#define GPT0C1_MR_WFM_BSWTRG_MASK 0xC0000000U
#define GPT0C1_MR_WFM_BSWTRG_BIT 30

#define GPT0C1_SR (*(volatile unsigned long *)0xFFFC8170)
#define GPT0C1_SR_OFFSET 0x170
#define GPT0C1_SR_COVFS_MASK 0x1U
#define GPT0C1_SR_COVFS 0x1U
#define GPT0C1_SR_COVFS_BIT 0
#define GPT0C1_SR_LOVRS_MASK 0x2U
#define GPT0C1_SR_LOVRS 0x2U
#define GPT0C1_SR_LOVRS_BIT 1
#define GPT0C1_SR_CPCS_MASK 0x10U
#define GPT0C1_SR_CPCS 0x10U
#define GPT0C1_SR_CPCS_BIT 4
#define GPT0C1_SR_LDRAS_MASK 0x20U
#define GPT0C1_SR_LDRAS 0x20U
#define GPT0C1_SR_LDRAS_BIT 5
#define GPT0C1_SR_LDRBS_MASK 0x40U
#define GPT0C1_SR_LDRBS 0x40U
#define GPT0C1_SR_LDRBS_BIT 6
#define GPT0C1_SR_ETRGS_MASK 0x80U
#define GPT0C1_SR_ETRGS 0x80U
#define GPT0C1_SR_ETRGS_BIT 7
#define GPT0C1_SR_CLKSTA_MASK 0x100U
#define GPT0C1_SR_CLKSTA 0x100U
#define GPT0C1_SR_CLKSTA_BIT 8
#define GPT0C1_SR_MTIOA_MASK 0x200U
#define GPT0C1_SR_MTIOA 0x200U
#define GPT0C1_SR_MTIOA_BIT 9
#define GPT0C1_SR_MTIOB_MASK 0x400U
#define GPT0C1_SR_MTIOB 0x400U
#define GPT0C1_SR_MTIOB_BIT 10
#define GPT0C1_SR_TIOBS_MASK 0x10000U
#define GPT0C1_SR_TIOBS 0x10000U
#define GPT0C1_SR_TIOBS_BIT 16
#define GPT0C1_SR_TIOAS_MASK 0x20000U
#define GPT0C1_SR_TIOAS 0x20000U
#define GPT0C1_SR_TIOAS_BIT 17
#define GPT0C1_SR_TCLKS_MASK 0x40000U
#define GPT0C1_SR_TCLKS 0x40000U
#define GPT0C1_SR_TCLKS_BIT 18

#define GPT0C1_SR_WFM (*(volatile unsigned long *)0xFFFC8170)
#define GPT0C1_SR_WFM_OFFSET 0x170
#define GPT0C1_SR_WFM_COVFS_MASK 0x1U
#define GPT0C1_SR_WFM_COVFS 0x1U
#define GPT0C1_SR_WFM_COVFS_BIT 0
#define GPT0C1_SR_WFM_CPAS_MASK 0x4U
#define GPT0C1_SR_WFM_CPAS 0x4U
#define GPT0C1_SR_WFM_CPAS_BIT 2
#define GPT0C1_SR_WFM_CPBS_MASK 0x8U
#define GPT0C1_SR_WFM_CPBS 0x8U
#define GPT0C1_SR_WFM_CPBS_BIT 3
#define GPT0C1_SR_WFM_CPCS_MASK 0x10U
#define GPT0C1_SR_WFM_CPCS 0x10U
#define GPT0C1_SR_WFM_CPCS_BIT 4
#define GPT0C1_SR_WFM_ETRGS_MASK 0x80U
#define GPT0C1_SR_WFM_ETRGS 0x80U
#define GPT0C1_SR_WFM_ETRGS_BIT 7
#define GPT0C1_SR_WFM_CLKSTA_MASK 0x100U
#define GPT0C1_SR_WFM_CLKSTA 0x100U
#define GPT0C1_SR_WFM_CLKSTA_BIT 8
#define GPT0C1_SR_WFM_MTIOA_MASK 0x200U
#define GPT0C1_SR_WFM_MTIOA 0x200U
#define GPT0C1_SR_WFM_MTIOA_BIT 9
#define GPT0C1_SR_WFM_MTIOB_MASK 0x400U
#define GPT0C1_SR_WFM_MTIOB 0x400U
#define GPT0C1_SR_WFM_MTIOB_BIT 10
#define GPT0C1_SR_WFM_TIOBS_MASK 0x10000U
#define GPT0C1_SR_WFM_TIOBS 0x10000U
#define GPT0C1_SR_WFM_TIOBS_BIT 16
#define GPT0C1_SR_WFM_TIOAS_MASK 0x20000U
#define GPT0C1_SR_WFM_TIOAS 0x20000U
#define GPT0C1_SR_WFM_TIOAS_BIT 17
#define GPT0C1_SR_WFM_TCLKS_MASK 0x40000U
#define GPT0C1_SR_WFM_TCLKS 0x40000U
#define GPT0C1_SR_WFM_TCLKS_BIT 18

#define GPT0C1_IER (*(volatile unsigned long *)0xFFFC8174)
#define GPT0C1_IER_OFFSET 0x174
#define GPT0C1_IER_COVFS_MASK 0x1U
#define GPT0C1_IER_COVFS 0x1U
#define GPT0C1_IER_COVFS_BIT 0
#define GPT0C1_IER_LOVRS_MASK 0x2U
#define GPT0C1_IER_LOVRS 0x2U
#define GPT0C1_IER_LOVRS_BIT 1
#define GPT0C1_IER_CPCS_MASK 0x10U
#define GPT0C1_IER_CPCS 0x10U
#define GPT0C1_IER_CPCS_BIT 4
#define GPT0C1_IER_LDRAS_MASK 0x20U
#define GPT0C1_IER_LDRAS 0x20U
#define GPT0C1_IER_LDRAS_BIT 5
#define GPT0C1_IER_LDRBS_MASK 0x40U
#define GPT0C1_IER_LDRBS 0x40U
#define GPT0C1_IER_LDRBS_BIT 6
#define GPT0C1_IER_ETRGS_MASK 0x80U
#define GPT0C1_IER_ETRGS 0x80U
#define GPT0C1_IER_ETRGS_BIT 7
#define GPT0C1_IER_TIOBS_MASK 0x10000U
#define GPT0C1_IER_TIOBS 0x10000U
#define GPT0C1_IER_TIOBS_BIT 16
#define GPT0C1_IER_TIOAS_MASK 0x20000U
#define GPT0C1_IER_TIOAS 0x20000U
#define GPT0C1_IER_TIOAS_BIT 17
#define GPT0C1_IER_TCLKS_MASK 0x40000U
#define GPT0C1_IER_TCLKS 0x40000U
#define GPT0C1_IER_TCLKS_BIT 18

#define GPT0C1_IER_WFM (*(volatile unsigned long *)0xFFFC8174)
#define GPT0C1_IER_WFM_OFFSET 0x174
#define GPT0C1_IER_WFM_COVFS_MASK 0x1U
#define GPT0C1_IER_WFM_COVFS 0x1U
#define GPT0C1_IER_WFM_COVFS_BIT 0
#define GPT0C1_IER_WFM_CPAS_MASK 0x4U
#define GPT0C1_IER_WFM_CPAS 0x4U
#define GPT0C1_IER_WFM_CPAS_BIT 2
#define GPT0C1_IER_WFM_CPBS_MASK 0x8U
#define GPT0C1_IER_WFM_CPBS 0x8U
#define GPT0C1_IER_WFM_CPBS_BIT 3
#define GPT0C1_IER_WFM_CPCS_MASK 0x10U
#define GPT0C1_IER_WFM_CPCS 0x10U
#define GPT0C1_IER_WFM_CPCS_BIT 4
#define GPT0C1_IER_WFM_ETRGS_MASK 0x80U
#define GPT0C1_IER_WFM_ETRGS 0x80U
#define GPT0C1_IER_WFM_ETRGS_BIT 7
#define GPT0C1_IER_WFM_TIOBS_MASK 0x10000U
#define GPT0C1_IER_WFM_TIOBS 0x10000U
#define GPT0C1_IER_WFM_TIOBS_BIT 16
#define GPT0C1_IER_WFM_TIOAS_MASK 0x20000U
#define GPT0C1_IER_WFM_TIOAS 0x20000U
#define GPT0C1_IER_WFM_TIOAS_BIT 17
#define GPT0C1_IER_WFM_TCLKS_MASK 0x40000U
#define GPT0C1_IER_WFM_TCLKS 0x40000U
#define GPT0C1_IER_WFM_TCLKS_BIT 18

#define GPT0C1_IDR (*(volatile unsigned long *)0xFFFC8178)
#define GPT0C1_IDR_OFFSET 0x178
#define GPT0C1_IDR_COVFS_MASK 0x1U
#define GPT0C1_IDR_COVFS 0x1U
#define GPT0C1_IDR_COVFS_BIT 0
#define GPT0C1_IDR_LOVRS_MASK 0x2U
#define GPT0C1_IDR_LOVRS 0x2U
#define GPT0C1_IDR_LOVRS_BIT 1
#define GPT0C1_IDR_CPCS_MASK 0x10U
#define GPT0C1_IDR_CPCS 0x10U
#define GPT0C1_IDR_CPCS_BIT 4
#define GPT0C1_IDR_LDRAS_MASK 0x20U
#define GPT0C1_IDR_LDRAS 0x20U
#define GPT0C1_IDR_LDRAS_BIT 5
#define GPT0C1_IDR_LDRBS_MASK 0x40U
#define GPT0C1_IDR_LDRBS 0x40U
#define GPT0C1_IDR_LDRBS_BIT 6
#define GPT0C1_IDR_ETRGS_MASK 0x80U
#define GPT0C1_IDR_ETRGS 0x80U
#define GPT0C1_IDR_ETRGS_BIT 7
#define GPT0C1_IDR_TIOBS_MASK 0x10000U
#define GPT0C1_IDR_TIOBS 0x10000U
#define GPT0C1_IDR_TIOBS_BIT 16
#define GPT0C1_IDR_TIOAS_MASK 0x20000U
#define GPT0C1_IDR_TIOAS 0x20000U
#define GPT0C1_IDR_TIOAS_BIT 17
#define GPT0C1_IDR_TCLKS_MASK 0x40000U
#define GPT0C1_IDR_TCLKS 0x40000U
#define GPT0C1_IDR_TCLKS_BIT 18

#define GPT0C1_IDR_WFM (*(volatile unsigned long *)0xFFFC8178)
#define GPT0C1_IDR_WFM_OFFSET 0x178
#define GPT0C1_IDR_WFM_COVFS_MASK 0x1U
#define GPT0C1_IDR_WFM_COVFS 0x1U
#define GPT0C1_IDR_WFM_COVFS_BIT 0
#define GPT0C1_IDR_WFM_CPAS_MASK 0x4U
#define GPT0C1_IDR_WFM_CPAS 0x4U
#define GPT0C1_IDR_WFM_CPAS_BIT 2
#define GPT0C1_IDR_WFM_CPBS_MASK 0x8U
#define GPT0C1_IDR_WFM_CPBS 0x8U
#define GPT0C1_IDR_WFM_CPBS_BIT 3
#define GPT0C1_IDR_WFM_CPCS_MASK 0x10U
#define GPT0C1_IDR_WFM_CPCS 0x10U
#define GPT0C1_IDR_WFM_CPCS_BIT 4
#define GPT0C1_IDR_WFM_ETRGS_MASK 0x80U
#define GPT0C1_IDR_WFM_ETRGS 0x80U
#define GPT0C1_IDR_WFM_ETRGS_BIT 7
#define GPT0C1_IDR_WFM_TIOBS_MASK 0x10000U
#define GPT0C1_IDR_WFM_TIOBS 0x10000U
#define GPT0C1_IDR_WFM_TIOBS_BIT 16
#define GPT0C1_IDR_WFM_TIOAS_MASK 0x20000U
#define GPT0C1_IDR_WFM_TIOAS 0x20000U
#define GPT0C1_IDR_WFM_TIOAS_BIT 17
#define GPT0C1_IDR_WFM_TCLKS_MASK 0x40000U
#define GPT0C1_IDR_WFM_TCLKS 0x40000U
#define GPT0C1_IDR_WFM_TCLKS_BIT 18

#define GPT0C1_IMR (*(volatile unsigned long *)0xFFFC817C)
#define GPT0C1_IMR_OFFSET 0x17C
#define GPT0C1_IMR_COVFS_MASK 0x1U
#define GPT0C1_IMR_COVFS 0x1U
#define GPT0C1_IMR_COVFS_BIT 0
#define GPT0C1_IMR_LOVRS_MASK 0x2U
#define GPT0C1_IMR_LOVRS 0x2U
#define GPT0C1_IMR_LOVRS_BIT 1
#define GPT0C1_IMR_CPCS_MASK 0x10U
#define GPT0C1_IMR_CPCS 0x10U
#define GPT0C1_IMR_CPCS_BIT 4
#define GPT0C1_IMR_LDRAS_MASK 0x20U
#define GPT0C1_IMR_LDRAS 0x20U
#define GPT0C1_IMR_LDRAS_BIT 5
#define GPT0C1_IMR_LDRBS_MASK 0x40U
#define GPT0C1_IMR_LDRBS 0x40U
#define GPT0C1_IMR_LDRBS_BIT 6
#define GPT0C1_IMR_ETRGS_MASK 0x80U
#define GPT0C1_IMR_ETRGS 0x80U
#define GPT0C1_IMR_ETRGS_BIT 7
#define GPT0C1_IMR_TIOBS_MASK 0x10000U
#define GPT0C1_IMR_TIOBS 0x10000U
#define GPT0C1_IMR_TIOBS_BIT 16
#define GPT0C1_IMR_TIOAS_MASK 0x20000U
#define GPT0C1_IMR_TIOAS 0x20000U
#define GPT0C1_IMR_TIOAS_BIT 17
#define GPT0C1_IMR_TCLKS_MASK 0x40000U
#define GPT0C1_IMR_TCLKS 0x40000U
#define GPT0C1_IMR_TCLKS_BIT 18

#define GPT0C1_IMR_WFM (*(volatile unsigned long *)0xFFFC817C)
#define GPT0C1_IMR_WFM_OFFSET 0x17C
#define GPT0C1_IMR_WFM_COVFS_MASK 0x1U
#define GPT0C1_IMR_WFM_COVFS 0x1U
#define GPT0C1_IMR_WFM_COVFS_BIT 0
#define GPT0C1_IMR_WFM_CPAS_MASK 0x4U
#define GPT0C1_IMR_WFM_CPAS 0x4U
#define GPT0C1_IMR_WFM_CPAS_BIT 2
#define GPT0C1_IMR_WFM_CPBS_MASK 0x8U
#define GPT0C1_IMR_WFM_CPBS 0x8U
#define GPT0C1_IMR_WFM_CPBS_BIT 3
#define GPT0C1_IMR_WFM_CPCS_MASK 0x10U
#define GPT0C1_IMR_WFM_CPCS 0x10U
#define GPT0C1_IMR_WFM_CPCS_BIT 4
#define GPT0C1_IMR_WFM_ETRGS_MASK 0x80U
#define GPT0C1_IMR_WFM_ETRGS 0x80U
#define GPT0C1_IMR_WFM_ETRGS_BIT 7
#define GPT0C1_IMR_WFM_TIOBS_MASK 0x10000U
#define GPT0C1_IMR_WFM_TIOBS 0x10000U
#define GPT0C1_IMR_WFM_TIOBS_BIT 16
#define GPT0C1_IMR_WFM_TIOAS_MASK 0x20000U
#define GPT0C1_IMR_WFM_TIOAS 0x20000U
#define GPT0C1_IMR_WFM_TIOAS_BIT 17
#define GPT0C1_IMR_WFM_TCLKS_MASK 0x40000U
#define GPT0C1_IMR_WFM_TCLKS 0x40000U
#define GPT0C1_IMR_WFM_TCLKS_BIT 18

#define GPT0C1_CV (*(volatile unsigned long *)0xFFFC8180)
#define GPT0C1_CV_OFFSET 0x180
#define GPT0C1_CV_CV_MASK 0xFFFFU
#define GPT0C1_CV_CV_BIT 0

#define GPT0C1_RA (*(volatile unsigned long *)0xFFFC8184)
#define GPT0C1_RA_OFFSET 0x184
#define GPT0C1_RA_RA_MASK 0xFFFFU
#define GPT0C1_RA_RA_BIT 0

#define GPT0C1_RB (*(volatile unsigned long *)0xFFFC8188)
#define GPT0C1_RB_OFFSET 0x188
#define GPT0C1_RB_RB_MASK 0xFFFFU
#define GPT0C1_RB_RB_BIT 0

#define GPT0C1_RC (*(volatile unsigned long *)0xFFFC818C)
#define GPT0C1_RC_OFFSET 0x18C
#define GPT0C1_RC_RC_MASK 0xFFFFU
#define GPT0C1_RC_RC_BIT 0

#define GPT0C2_PER (*(volatile unsigned long *)0xFFFC8200)
#define GPT0C2_PER_OFFSET 0x200
#define GPT0C2_PER_TIOB_MASK 0x10000U
#define GPT0C2_PER_TIOB 0x10000U
#define GPT0C2_PER_TIOB_BIT 16
#define GPT0C2_PER_TIOA_MASK 0x20000U
#define GPT0C2_PER_TIOA 0x20000U
#define GPT0C2_PER_TIOA_BIT 17
#define GPT0C2_PER_TCLK_MASK 0x40000U
#define GPT0C2_PER_TCLK 0x40000U
#define GPT0C2_PER_TCLK_BIT 18

#define GPT0C2_PDR (*(volatile unsigned long *)0xFFFC8204)
#define GPT0C2_PDR_OFFSET 0x204
#define GPT0C2_PDR_TIOB_MASK 0x10000U
#define GPT0C2_PDR_TIOB 0x10000U
#define GPT0C2_PDR_TIOB_BIT 16
#define GPT0C2_PDR_TIOA_MASK 0x20000U
#define GPT0C2_PDR_TIOA 0x20000U
#define GPT0C2_PDR_TIOA_BIT 17
#define GPT0C2_PDR_TCLK_MASK 0x40000U
#define GPT0C2_PDR_TCLK 0x40000U
#define GPT0C2_PDR_TCLK_BIT 18

#define GPT0C2_PSR (*(volatile unsigned long *)0xFFFC8208)
#define GPT0C2_PSR_OFFSET 0x208
#define GPT0C2_PSR_TIOB_MASK 0x10000U
#define GPT0C2_PSR_TIOB 0x10000U
#define GPT0C2_PSR_TIOB_BIT 16
#define GPT0C2_PSR_TIOA_MASK 0x20000U
#define GPT0C2_PSR_TIOA 0x20000U
#define GPT0C2_PSR_TIOA_BIT 17
#define GPT0C2_PSR_TCLK_MASK 0x40000U
#define GPT0C2_PSR_TCLK 0x40000U
#define GPT0C2_PSR_TCLK_BIT 18

#define GPT0C2_OER (*(volatile unsigned long *)0xFFFC8210)
#define GPT0C2_OER_OFFSET 0x210
#define GPT0C2_OER_TIOB_MASK 0x10000U
#define GPT0C2_OER_TIOB 0x10000U
#define GPT0C2_OER_TIOB_BIT 16
#define GPT0C2_OER_TIOA_MASK 0x20000U
#define GPT0C2_OER_TIOA 0x20000U
#define GPT0C2_OER_TIOA_BIT 17
#define GPT0C2_OER_TCLK_MASK 0x40000U
#define GPT0C2_OER_TCLK 0x40000U
#define GPT0C2_OER_TCLK_BIT 18

#define GPT0C2_ODR (*(volatile unsigned long *)0xFFFC8214)
#define GPT0C2_ODR_OFFSET 0x214
#define GPT0C2_ODR_TIOB_MASK 0x10000U
#define GPT0C2_ODR_TIOB 0x10000U
#define GPT0C2_ODR_TIOB_BIT 16
#define GPT0C2_ODR_TIOA_MASK 0x20000U
#define GPT0C2_ODR_TIOA 0x20000U
#define GPT0C2_ODR_TIOA_BIT 17
#define GPT0C2_ODR_TCLK_MASK 0x40000U
#define GPT0C2_ODR_TCLK 0x40000U
#define GPT0C2_ODR_TCLK_BIT 18

#define GPT0C2_OSR (*(volatile unsigned long *)0xFFFC8218)
#define GPT0C2_OSR_OFFSET 0x218
#define GPT0C2_OSR_TIOB_MASK 0x10000U
#define GPT0C2_OSR_TIOB 0x10000U
#define GPT0C2_OSR_TIOB_BIT 16
#define GPT0C2_OSR_TIOA_MASK 0x20000U
#define GPT0C2_OSR_TIOA 0x20000U
#define GPT0C2_OSR_TIOA_BIT 17
#define GPT0C2_OSR_TCLK_MASK 0x40000U
#define GPT0C2_OSR_TCLK 0x40000U
#define GPT0C2_OSR_TCLK_BIT 18

#define GPT0C2_SODR (*(volatile unsigned long *)0xFFFC8230)
#define GPT0C2_SODR_OFFSET 0x230
#define GPT0C2_SODR_TIOB_MASK 0x10000U
#define GPT0C2_SODR_TIOB 0x10000U
#define GPT0C2_SODR_TIOB_BIT 16
#define GPT0C2_SODR_TIOA_MASK 0x20000U
#define GPT0C2_SODR_TIOA 0x20000U
#define GPT0C2_SODR_TIOA_BIT 17
#define GPT0C2_SODR_TCLK_MASK 0x40000U
#define GPT0C2_SODR_TCLK 0x40000U
#define GPT0C2_SODR_TCLK_BIT 18

#define GPT0C2_CODR (*(volatile unsigned long *)0xFFFC8234)
#define GPT0C2_CODR_OFFSET 0x234
#define GPT0C2_CODR_TIOB_MASK 0x10000U
#define GPT0C2_CODR_TIOB 0x10000U
#define GPT0C2_CODR_TIOB_BIT 16
#define GPT0C2_CODR_TIOA_MASK 0x20000U
#define GPT0C2_CODR_TIOA 0x20000U
#define GPT0C2_CODR_TIOA_BIT 17
#define GPT0C2_CODR_TCLK_MASK 0x40000U
#define GPT0C2_CODR_TCLK 0x40000U
#define GPT0C2_CODR_TCLK_BIT 18

#define GPT0C2_ODSR (*(volatile unsigned long *)0xFFFC8238)
#define GPT0C2_ODSR_OFFSET 0x238
#define GPT0C2_ODSR_TIOB_MASK 0x10000U
#define GPT0C2_ODSR_TIOB 0x10000U
#define GPT0C2_ODSR_TIOB_BIT 16
#define GPT0C2_ODSR_TIOA_MASK 0x20000U
#define GPT0C2_ODSR_TIOA 0x20000U
#define GPT0C2_ODSR_TIOA_BIT 17
#define GPT0C2_ODSR_TCLK_MASK 0x40000U
#define GPT0C2_ODSR_TCLK 0x40000U
#define GPT0C2_ODSR_TCLK_BIT 18

#define GPT0C2_PDSR (*(volatile unsigned long *)0xFFFC823C)
#define GPT0C2_PDSR_OFFSET 0x23C
#define GPT0C2_PDSR_TIOB_MASK 0x10000U
#define GPT0C2_PDSR_TIOB 0x10000U
#define GPT0C2_PDSR_TIOB_BIT 16
#define GPT0C2_PDSR_TIOA_MASK 0x20000U
#define GPT0C2_PDSR_TIOA 0x20000U
#define GPT0C2_PDSR_TIOA_BIT 17
#define GPT0C2_PDSR_TCLK_MASK 0x40000U
#define GPT0C2_PDSR_TCLK 0x40000U
#define GPT0C2_PDSR_TCLK_BIT 18

#define GPT0C2_MDER (*(volatile unsigned long *)0xFFFC8240)
#define GPT0C2_MDER_OFFSET 0x240
#define GPT0C2_MDER_TIOB_MASK 0x10000U
#define GPT0C2_MDER_TIOB 0x10000U
#define GPT0C2_MDER_TIOB_BIT 16
#define GPT0C2_MDER_TIOA_MASK 0x20000U
#define GPT0C2_MDER_TIOA 0x20000U
#define GPT0C2_MDER_TIOA_BIT 17
#define GPT0C2_MDER_TCLK_MASK 0x40000U
#define GPT0C2_MDER_TCLK 0x40000U
#define GPT0C2_MDER_TCLK_BIT 18

#define GPT0C2_MDDR (*(volatile unsigned long *)0xFFFC8244)
#define GPT0C2_MDDR_OFFSET 0x244
#define GPT0C2_MDDR_TIOB_MASK 0x10000U
#define GPT0C2_MDDR_TIOB 0x10000U
#define GPT0C2_MDDR_TIOB_BIT 16
#define GPT0C2_MDDR_TIOA_MASK 0x20000U
#define GPT0C2_MDDR_TIOA 0x20000U
#define GPT0C2_MDDR_TIOA_BIT 17
#define GPT0C2_MDDR_TCLK_MASK 0x40000U
#define GPT0C2_MDDR_TCLK 0x40000U
#define GPT0C2_MDDR_TCLK_BIT 18

#define GPT0C2_MDSR (*(volatile unsigned long *)0xFFFC8248)
#define GPT0C2_MDSR_OFFSET 0x248
#define GPT0C2_MDSR_TIOB_MASK 0x10000U
#define GPT0C2_MDSR_TIOB 0x10000U
#define GPT0C2_MDSR_TIOB_BIT 16
#define GPT0C2_MDSR_TIOA_MASK 0x20000U
#define GPT0C2_MDSR_TIOA 0x20000U
#define GPT0C2_MDSR_TIOA_BIT 17
#define GPT0C2_MDSR_TCLK_MASK 0x40000U
#define GPT0C2_MDSR_TCLK 0x40000U
#define GPT0C2_MDSR_TCLK_BIT 18

#define GPT0C2_ECR (*(volatile unsigned long *)0xFFFC8250)
#define GPT0C2_ECR_OFFSET 0x250
#define GPT0C2_ECR_PIO_MASK 0x1U
#define GPT0C2_ECR_PIO 0x1U
#define GPT0C2_ECR_PIO_BIT 0
#define GPT0C2_ECR_GPT_MASK 0x2U
#define GPT0C2_ECR_GPT 0x2U
#define GPT0C2_ECR_GPT_BIT 1

#define GPT0C2_DCR (*(volatile unsigned long *)0xFFFC8254)
#define GPT0C2_DCR_OFFSET 0x254
#define GPT0C2_DCR_PIO_MASK 0x1U
#define GPT0C2_DCR_PIO 0x1U
#define GPT0C2_DCR_PIO_BIT 0
#define GPT0C2_DCR_GPT_MASK 0x2U
#define GPT0C2_DCR_GPT 0x2U
#define GPT0C2_DCR_GPT_BIT 1

#define GPT0C2_PMSR (*(volatile unsigned long *)0xFFFC8258)
#define GPT0C2_PMSR_OFFSET 0x258
#define GPT0C2_PMSR_PIO_MASK 0x1U
#define GPT0C2_PMSR_PIO 0x1U
#define GPT0C2_PMSR_PIO_BIT 0
#define GPT0C2_PMSR_GPT_MASK 0x2U
#define GPT0C2_PMSR_GPT 0x2U
#define GPT0C2_PMSR_GPT_BIT 1

#define GPT0C2_CR (*(volatile unsigned long *)0xFFFC8260)
#define GPT0C2_CR_OFFSET 0x260
#define GPT0C2_CR_SWRST_MASK 0x1U
#define GPT0C2_CR_SWRST 0x1U
#define GPT0C2_CR_SWRST_BIT 0
#define GPT0C2_CR_CLKEN_MASK 0x2U
#define GPT0C2_CR_CLKEN 0x2U
#define GPT0C2_CR_CLKEN_BIT 1
#define GPT0C2_CR_CLKDIS_MASK 0x4U
#define GPT0C2_CR_CLKDIS 0x4U
#define GPT0C2_CR_CLKDIS_BIT 2
#define GPT0C2_CR_SWTRG_MASK 0x8U
#define GPT0C2_CR_SWTRG 0x8U
#define GPT0C2_CR_SWTRG_BIT 3

#define GPT0C2_MR (*(volatile unsigned long *)0xFFFC8264)
#define GPT0C2_MR_OFFSET 0x264
#define GPT0C2_MR_CLKS_MASK 0x7U
#define GPT0C2_MR_CLKS_BIT 0
#define GPT0C2_MR_CLKI_MASK 0x8U
#define GPT0C2_MR_CLKI 0x8U
#define GPT0C2_MR_CLKI_BIT 3
#define GPT0C2_MR_BURST_MASK 0x30U
#define GPT0C2_MR_BURST_BIT 4
#define GPT0C2_MR_LDBSTOP_MASK 0x40U
#define GPT0C2_MR_LDBSTOP 0x40U
#define GPT0C2_MR_LDBSTOP_BIT 6
#define GPT0C2_MR_LDBIS_MASK 0x80U
#define GPT0C2_MR_LDBIS 0x80U
#define GPT0C2_MR_LDBIS_BIT 7
#define GPT0C2_MR_ETRGEDG_MASK 0x300U
#define GPT0C2_MR_ETRGEDG_BIT 8
#define GPT0C2_MR_ABETRG_MASK 0x400U
#define GPT0C2_MR_ABETRG 0x400U
#define GPT0C2_MR_ABETRG_BIT 10
#define GPT0C2_MR_CPCTRG_MASK 0x4000U
#define GPT0C2_MR_CPCTRG 0x4000U
#define GPT0C2_MR_CPCTRG_BIT 14
#define GPT0C2_MR_WAVE_MASK 0x8000U
#define GPT0C2_MR_WAVE 0x8000U
#define GPT0C2_MR_WAVE_BIT 15
#define GPT0C2_MR_LDRA_MASK 0x30000U
#define GPT0C2_MR_LDRA_BIT 16
#define GPT0C2_MR_LDRB_MASK 0xC0000U
#define GPT0C2_MR_LDRB_BIT 18

#define GPT0C2_MR_WFM (*(volatile unsigned long *)0xFFFC8264)
#define GPT0C2_MR_WFM_OFFSET 0x264
#define GPT0C2_MR_WFM_CLKS_MASK 0x7U
#define GPT0C2_MR_WFM_CLKS_BIT 0
#define GPT0C2_MR_WFM_CLKI_MASK 0x8U
#define GPT0C2_MR_WFM_CLKI 0x8U
#define GPT0C2_MR_WFM_CLKI_BIT 3
#define GPT0C2_MR_WFM_BURST_MASK 0x30U
#define GPT0C2_MR_WFM_BURST_BIT 4
#define GPT0C2_MR_WFM_CPCSTOP_MASK 0x40U
#define GPT0C2_MR_WFM_CPCSTOP 0x40U
#define GPT0C2_MR_WFM_CPCSTOP_BIT 6
#define GPT0C2_MR_WFM_CPCDIS_MASK 0x80U
#define GPT0C2_MR_WFM_CPCDIS 0x80U
#define GPT0C2_MR_WFM_CPCDIS_BIT 7
#define GPT0C2_MR_WFM_EEVTEDG_MASK 0x300U
#define GPT0C2_MR_WFM_EEVTEDG_BIT 8
#define GPT0C2_MR_WFM_EEVT_MASK 0xC00U
#define GPT0C2_MR_WFM_EEVT_BIT 10
#define GPT0C2_MR_WFM_ENETRG_MASK 0x1000U
#define GPT0C2_MR_WFM_ENETRG 0x1000U
#define GPT0C2_MR_WFM_ENETRG_BIT 12
#define GPT0C2_MR_WFM_CPCTRG_MASK 0x4000U
#define GPT0C2_MR_WFM_CPCTRG 0x4000U
#define GPT0C2_MR_WFM_CPCTRG_BIT 14
#define GPT0C2_MR_WFM_WAVE_MASK 0x18000U
#define GPT0C2_MR_WFM_WAVE_BIT 15
#define GPT0C2_MR_WFM_ACPA_MASK 0x30000U
#define GPT0C2_MR_WFM_ACPA_BIT 16
#define GPT0C2_MR_WFM_ACPC_MASK 0xC0000U
#define GPT0C2_MR_WFM_ACPC_BIT 18
#define GPT0C2_MR_WFM_AEEVT_MASK 0x300000U
#define GPT0C2_MR_WFM_AEEVT_BIT 20
#define GPT0C2_MR_WFM_ASWTRG_MASK 0xC00000U
#define GPT0C2_MR_WFM_ASWTRG_BIT 22
#define GPT0C2_MR_WFM_BCPB_MASK 0x3000000U
#define GPT0C2_MR_WFM_BCPB_BIT 24
#define GPT0C2_MR_WFM_BCPC_MASK 0xC000000U
#define GPT0C2_MR_WFM_BCPC_BIT 26
#define GPT0C2_MR_WFM_BEEVT_MASK 0x30000000U
#define GPT0C2_MR_WFM_BEEVT_BIT 28
#define GPT0C2_MR_WFM_BSWTRG_MASK 0xC0000000U
#define GPT0C2_MR_WFM_BSWTRG_BIT 30

#define GPT0C2_SR (*(volatile unsigned long *)0xFFFC8270)
#define GPT0C2_SR_OFFSET 0x270
#define GPT0C2_SR_COVFS_MASK 0x1U
#define GPT0C2_SR_COVFS 0x1U
#define GPT0C2_SR_COVFS_BIT 0
#define GPT0C2_SR_LOVRS_MASK 0x2U
#define GPT0C2_SR_LOVRS 0x2U
#define GPT0C2_SR_LOVRS_BIT 1
#define GPT0C2_SR_CPCS_MASK 0x10U
#define GPT0C2_SR_CPCS 0x10U
#define GPT0C2_SR_CPCS_BIT 4
#define GPT0C2_SR_LDRAS_MASK 0x20U
#define GPT0C2_SR_LDRAS 0x20U
#define GPT0C2_SR_LDRAS_BIT 5
#define GPT0C2_SR_LDRBS_MASK 0x40U
#define GPT0C2_SR_LDRBS 0x40U
#define GPT0C2_SR_LDRBS_BIT 6
#define GPT0C2_SR_ETRGS_MASK 0x80U
#define GPT0C2_SR_ETRGS 0x80U
#define GPT0C2_SR_ETRGS_BIT 7
#define GPT0C2_SR_CLKSTA_MASK 0x100U
#define GPT0C2_SR_CLKSTA 0x100U
#define GPT0C2_SR_CLKSTA_BIT 8
#define GPT0C2_SR_MTIOA_MASK 0x200U
#define GPT0C2_SR_MTIOA 0x200U
#define GPT0C2_SR_MTIOA_BIT 9
#define GPT0C2_SR_MTIOB_MASK 0x400U
#define GPT0C2_SR_MTIOB 0x400U
#define GPT0C2_SR_MTIOB_BIT 10
#define GPT0C2_SR_TIOBS_MASK 0x10000U
#define GPT0C2_SR_TIOBS 0x10000U
#define GPT0C2_SR_TIOBS_BIT 16
#define GPT0C2_SR_TIOAS_MASK 0x20000U
#define GPT0C2_SR_TIOAS 0x20000U
#define GPT0C2_SR_TIOAS_BIT 17
#define GPT0C2_SR_TCLKS_MASK 0x40000U
#define GPT0C2_SR_TCLKS 0x40000U
#define GPT0C2_SR_TCLKS_BIT 18

#define GPT0C2_SR_WFM (*(volatile unsigned long *)0xFFFC8270)
#define GPT0C2_SR_WFM_OFFSET 0x270
#define GPT0C2_SR_WFM_COVFS_MASK 0x1U
#define GPT0C2_SR_WFM_COVFS 0x1U
#define GPT0C2_SR_WFM_COVFS_BIT 0
#define GPT0C2_SR_WFM_CPAS_MASK 0x4U
#define GPT0C2_SR_WFM_CPAS 0x4U
#define GPT0C2_SR_WFM_CPAS_BIT 2
#define GPT0C2_SR_WFM_CPBS_MASK 0x8U
#define GPT0C2_SR_WFM_CPBS 0x8U
#define GPT0C2_SR_WFM_CPBS_BIT 3
#define GPT0C2_SR_WFM_CPCS_MASK 0x10U
#define GPT0C2_SR_WFM_CPCS 0x10U
#define GPT0C2_SR_WFM_CPCS_BIT 4
#define GPT0C2_SR_WFM_ETRGS_MASK 0x80U
#define GPT0C2_SR_WFM_ETRGS 0x80U
#define GPT0C2_SR_WFM_ETRGS_BIT 7
#define GPT0C2_SR_WFM_CLKSTA_MASK 0x100U
#define GPT0C2_SR_WFM_CLKSTA 0x100U
#define GPT0C2_SR_WFM_CLKSTA_BIT 8
#define GPT0C2_SR_WFM_MTIOA_MASK 0x200U
#define GPT0C2_SR_WFM_MTIOA 0x200U
#define GPT0C2_SR_WFM_MTIOA_BIT 9
#define GPT0C2_SR_WFM_MTIOB_MASK 0x400U
#define GPT0C2_SR_WFM_MTIOB 0x400U
#define GPT0C2_SR_WFM_MTIOB_BIT 10
#define GPT0C2_SR_WFM_TIOBS_MASK 0x10000U
#define GPT0C2_SR_WFM_TIOBS 0x10000U
#define GPT0C2_SR_WFM_TIOBS_BIT 16
#define GPT0C2_SR_WFM_TIOAS_MASK 0x20000U
#define GPT0C2_SR_WFM_TIOAS 0x20000U
#define GPT0C2_SR_WFM_TIOAS_BIT 17
#define GPT0C2_SR_WFM_TCLKS_MASK 0x40000U
#define GPT0C2_SR_WFM_TCLKS 0x40000U
#define GPT0C2_SR_WFM_TCLKS_BIT 18

#define GPT0C2_IER (*(volatile unsigned long *)0xFFFC8274)
#define GPT0C2_IER_OFFSET 0x274
#define GPT0C2_IER_COVFS_MASK 0x1U
#define GPT0C2_IER_COVFS 0x1U
#define GPT0C2_IER_COVFS_BIT 0
#define GPT0C2_IER_LOVRS_MASK 0x2U
#define GPT0C2_IER_LOVRS 0x2U
#define GPT0C2_IER_LOVRS_BIT 1
#define GPT0C2_IER_CPCS_MASK 0x10U
#define GPT0C2_IER_CPCS 0x10U
#define GPT0C2_IER_CPCS_BIT 4
#define GPT0C2_IER_LDRAS_MASK 0x20U
#define GPT0C2_IER_LDRAS 0x20U
#define GPT0C2_IER_LDRAS_BIT 5
#define GPT0C2_IER_LDRBS_MASK 0x40U
#define GPT0C2_IER_LDRBS 0x40U
#define GPT0C2_IER_LDRBS_BIT 6
#define GPT0C2_IER_ETRGS_MASK 0x80U
#define GPT0C2_IER_ETRGS 0x80U
#define GPT0C2_IER_ETRGS_BIT 7
#define GPT0C2_IER_TIOBS_MASK 0x10000U
#define GPT0C2_IER_TIOBS 0x10000U
#define GPT0C2_IER_TIOBS_BIT 16
#define GPT0C2_IER_TIOAS_MASK 0x20000U
#define GPT0C2_IER_TIOAS 0x20000U
#define GPT0C2_IER_TIOAS_BIT 17
#define GPT0C2_IER_TCLKS_MASK 0x40000U
#define GPT0C2_IER_TCLKS 0x40000U
#define GPT0C2_IER_TCLKS_BIT 18

#define GPT0C2_IER_WFM (*(volatile unsigned long *)0xFFFC8274)
#define GPT0C2_IER_WFM_OFFSET 0x274
#define GPT0C2_IER_WFM_COVFS_MASK 0x1U
#define GPT0C2_IER_WFM_COVFS 0x1U
#define GPT0C2_IER_WFM_COVFS_BIT 0
#define GPT0C2_IER_WFM_CPAS_MASK 0x4U
#define GPT0C2_IER_WFM_CPAS 0x4U
#define GPT0C2_IER_WFM_CPAS_BIT 2
#define GPT0C2_IER_WFM_CPBS_MASK 0x8U
#define GPT0C2_IER_WFM_CPBS 0x8U
#define GPT0C2_IER_WFM_CPBS_BIT 3
#define GPT0C2_IER_WFM_CPCS_MASK 0x10U
#define GPT0C2_IER_WFM_CPCS 0x10U
#define GPT0C2_IER_WFM_CPCS_BIT 4
#define GPT0C2_IER_WFM_ETRGS_MASK 0x80U
#define GPT0C2_IER_WFM_ETRGS 0x80U
#define GPT0C2_IER_WFM_ETRGS_BIT 7
#define GPT0C2_IER_WFM_TIOBS_MASK 0x10000U
#define GPT0C2_IER_WFM_TIOBS 0x10000U
#define GPT0C2_IER_WFM_TIOBS_BIT 16
#define GPT0C2_IER_WFM_TIOAS_MASK 0x20000U
#define GPT0C2_IER_WFM_TIOAS 0x20000U
#define GPT0C2_IER_WFM_TIOAS_BIT 17
#define GPT0C2_IER_WFM_TCLKS_MASK 0x40000U
#define GPT0C2_IER_WFM_TCLKS 0x40000U
#define GPT0C2_IER_WFM_TCLKS_BIT 18

#define GPT0C2_IDR (*(volatile unsigned long *)0xFFFC8278)
#define GPT0C2_IDR_OFFSET 0x278
#define GPT0C2_IDR_COVFS_MASK 0x1U
#define GPT0C2_IDR_COVFS 0x1U
#define GPT0C2_IDR_COVFS_BIT 0
#define GPT0C2_IDR_LOVRS_MASK 0x2U
#define GPT0C2_IDR_LOVRS 0x2U
#define GPT0C2_IDR_LOVRS_BIT 1
#define GPT0C2_IDR_CPCS_MASK 0x10U
#define GPT0C2_IDR_CPCS 0x10U
#define GPT0C2_IDR_CPCS_BIT 4
#define GPT0C2_IDR_LDRAS_MASK 0x20U
#define GPT0C2_IDR_LDRAS 0x20U
#define GPT0C2_IDR_LDRAS_BIT 5
#define GPT0C2_IDR_LDRBS_MASK 0x40U
#define GPT0C2_IDR_LDRBS 0x40U
#define GPT0C2_IDR_LDRBS_BIT 6
#define GPT0C2_IDR_ETRGS_MASK 0x80U
#define GPT0C2_IDR_ETRGS 0x80U
#define GPT0C2_IDR_ETRGS_BIT 7
#define GPT0C2_IDR_TIOBS_MASK 0x10000U
#define GPT0C2_IDR_TIOBS 0x10000U
#define GPT0C2_IDR_TIOBS_BIT 16
#define GPT0C2_IDR_TIOAS_MASK 0x20000U
#define GPT0C2_IDR_TIOAS 0x20000U
#define GPT0C2_IDR_TIOAS_BIT 17
#define GPT0C2_IDR_TCLKS_MASK 0x40000U
#define GPT0C2_IDR_TCLKS 0x40000U
#define GPT0C2_IDR_TCLKS_BIT 18

#define GPT0C2_IDR_WFM (*(volatile unsigned long *)0xFFFC8278)
#define GPT0C2_IDR_WFM_OFFSET 0x278
#define GPT0C2_IDR_WFM_COVFS_MASK 0x1U
#define GPT0C2_IDR_WFM_COVFS 0x1U
#define GPT0C2_IDR_WFM_COVFS_BIT 0
#define GPT0C2_IDR_WFM_CPAS_MASK 0x4U
#define GPT0C2_IDR_WFM_CPAS 0x4U
#define GPT0C2_IDR_WFM_CPAS_BIT 2
#define GPT0C2_IDR_WFM_CPBS_MASK 0x8U
#define GPT0C2_IDR_WFM_CPBS 0x8U
#define GPT0C2_IDR_WFM_CPBS_BIT 3
#define GPT0C2_IDR_WFM_CPCS_MASK 0x10U
#define GPT0C2_IDR_WFM_CPCS 0x10U
#define GPT0C2_IDR_WFM_CPCS_BIT 4
#define GPT0C2_IDR_WFM_ETRGS_MASK 0x80U
#define GPT0C2_IDR_WFM_ETRGS 0x80U
#define GPT0C2_IDR_WFM_ETRGS_BIT 7
#define GPT0C2_IDR_WFM_TIOBS_MASK 0x10000U
#define GPT0C2_IDR_WFM_TIOBS 0x10000U
#define GPT0C2_IDR_WFM_TIOBS_BIT 16
#define GPT0C2_IDR_WFM_TIOAS_MASK 0x20000U
#define GPT0C2_IDR_WFM_TIOAS 0x20000U
#define GPT0C2_IDR_WFM_TIOAS_BIT 17
#define GPT0C2_IDR_WFM_TCLKS_MASK 0x40000U
#define GPT0C2_IDR_WFM_TCLKS 0x40000U
#define GPT0C2_IDR_WFM_TCLKS_BIT 18

#define GPT0C2_IMR (*(volatile unsigned long *)0xFFFC827C)
#define GPT0C2_IMR_OFFSET 0x27C
#define GPT0C2_IMR_COVFS_MASK 0x1U
#define GPT0C2_IMR_COVFS 0x1U
#define GPT0C2_IMR_COVFS_BIT 0
#define GPT0C2_IMR_LOVRS_MASK 0x2U
#define GPT0C2_IMR_LOVRS 0x2U
#define GPT0C2_IMR_LOVRS_BIT 1
#define GPT0C2_IMR_CPCS_MASK 0x10U
#define GPT0C2_IMR_CPCS 0x10U
#define GPT0C2_IMR_CPCS_BIT 4
#define GPT0C2_IMR_LDRAS_MASK 0x20U
#define GPT0C2_IMR_LDRAS 0x20U
#define GPT0C2_IMR_LDRAS_BIT 5
#define GPT0C2_IMR_LDRBS_MASK 0x40U
#define GPT0C2_IMR_LDRBS 0x40U
#define GPT0C2_IMR_LDRBS_BIT 6
#define GPT0C2_IMR_ETRGS_MASK 0x80U
#define GPT0C2_IMR_ETRGS 0x80U
#define GPT0C2_IMR_ETRGS_BIT 7
#define GPT0C2_IMR_TIOBS_MASK 0x10000U
#define GPT0C2_IMR_TIOBS 0x10000U
#define GPT0C2_IMR_TIOBS_BIT 16
#define GPT0C2_IMR_TIOAS_MASK 0x20000U
#define GPT0C2_IMR_TIOAS 0x20000U
#define GPT0C2_IMR_TIOAS_BIT 17
#define GPT0C2_IMR_TCLKS_MASK 0x40000U
#define GPT0C2_IMR_TCLKS 0x40000U
#define GPT0C2_IMR_TCLKS_BIT 18

#define GPT0C2_IMR_WFM (*(volatile unsigned long *)0xFFFC827C)
#define GPT0C2_IMR_WFM_OFFSET 0x27C
#define GPT0C2_IMR_WFM_COVFS_MASK 0x1U
#define GPT0C2_IMR_WFM_COVFS 0x1U
#define GPT0C2_IMR_WFM_COVFS_BIT 0
#define GPT0C2_IMR_WFM_CPAS_MASK 0x4U
#define GPT0C2_IMR_WFM_CPAS 0x4U
#define GPT0C2_IMR_WFM_CPAS_BIT 2
#define GPT0C2_IMR_WFM_CPBS_MASK 0x8U
#define GPT0C2_IMR_WFM_CPBS 0x8U
#define GPT0C2_IMR_WFM_CPBS_BIT 3
#define GPT0C2_IMR_WFM_CPCS_MASK 0x10U
#define GPT0C2_IMR_WFM_CPCS 0x10U
#define GPT0C2_IMR_WFM_CPCS_BIT 4
#define GPT0C2_IMR_WFM_ETRGS_MASK 0x80U
#define GPT0C2_IMR_WFM_ETRGS 0x80U
#define GPT0C2_IMR_WFM_ETRGS_BIT 7
#define GPT0C2_IMR_WFM_TIOBS_MASK 0x10000U
#define GPT0C2_IMR_WFM_TIOBS 0x10000U
#define GPT0C2_IMR_WFM_TIOBS_BIT 16
#define GPT0C2_IMR_WFM_TIOAS_MASK 0x20000U
#define GPT0C2_IMR_WFM_TIOAS 0x20000U
#define GPT0C2_IMR_WFM_TIOAS_BIT 17
#define GPT0C2_IMR_WFM_TCLKS_MASK 0x40000U
#define GPT0C2_IMR_WFM_TCLKS 0x40000U
#define GPT0C2_IMR_WFM_TCLKS_BIT 18

#define GPT0C2_CV (*(volatile unsigned long *)0xFFFC8280)
#define GPT0C2_CV_OFFSET 0x280
#define GPT0C2_CV_CV_MASK 0xFFFFU
#define GPT0C2_CV_CV_BIT 0

#define GPT0C2_RA (*(volatile unsigned long *)0xFFFC8284)
#define GPT0C2_RA_OFFSET 0x284
#define GPT0C2_RA_RA_MASK 0xFFFFU
#define GPT0C2_RA_RA_BIT 0

#define GPT0C2_RB (*(volatile unsigned long *)0xFFFC8288)
#define GPT0C2_RB_OFFSET 0x288
#define GPT0C2_RB_RB_MASK 0xFFFFU
#define GPT0C2_RB_RB_BIT 0

#define GPT0C2_RC (*(volatile unsigned long *)0xFFFC828C)
#define GPT0C2_RC_OFFSET 0x28C
#define GPT0C2_RC_RC_MASK 0xFFFFU
#define GPT0C2_RC_RC_BIT 0

#define GPT0_BCR (*(volatile unsigned long *)0xFFFC8300)
#define GPT0_BCR_OFFSET 0x300
#define GPT0_BCR_SWRST_MASK 0x1U
#define GPT0_BCR_SWRST 0x1U
#define GPT0_BCR_SWRST_BIT 0
#define GPT0_BCR_TCSYNC_MASK 0x2U
#define GPT0_BCR_TCSYNC 0x2U
#define GPT0_BCR_TCSYNC_BIT 1

#define GPT0_BMR (*(volatile unsigned long *)0xFFFC8304)
#define GPT0_BMR_OFFSET 0x304
#define GPT0_BMR_TC0XC0S_MASK 0x3U
#define GPT0_BMR_TC0XC0S_BIT 0
#define GPT0_BMR_TC1XC1S_MASK 0xCU
#define GPT0_BMR_TC1XC1S_BIT 2
#define GPT0_BMR_TC2XC2S_MASK 0x30U
#define GPT0_BMR_TC2XC2S_BIT 4

#define GPT1_BASE 0xFFFCC000

#define GPT1_PER (*(volatile unsigned long *)0xFFFCC000)
#define GPT1_PER_OFFSET 0x0
#define GPT1_PER_TIOB_MASK 0x10000U
#define GPT1_PER_TIOB 0x10000U
#define GPT1_PER_TIOB_BIT 16
#define GPT1_PER_TIOA_MASK 0x20000U
#define GPT1_PER_TIOA 0x20000U
#define GPT1_PER_TIOA_BIT 17
#define GPT1_PER_TCLK_MASK 0x40000U
#define GPT1_PER_TCLK 0x40000U
#define GPT1_PER_TCLK_BIT 18

#define GPT1_PDR (*(volatile unsigned long *)0xFFFCC004)
#define GPT1_PDR_OFFSET 0x4
#define GPT1_PDR_TIOB_MASK 0x10000U
#define GPT1_PDR_TIOB 0x10000U
#define GPT1_PDR_TIOB_BIT 16
#define GPT1_PDR_TIOA_MASK 0x20000U
#define GPT1_PDR_TIOA 0x20000U
#define GPT1_PDR_TIOA_BIT 17
#define GPT1_PDR_TCLK_MASK 0x40000U
#define GPT1_PDR_TCLK 0x40000U
#define GPT1_PDR_TCLK_BIT 18

#define GPT1_PSR (*(volatile unsigned long *)0xFFFCC008)
#define GPT1_PSR_OFFSET 0x8
#define GPT1_PSR_TIOB_MASK 0x10000U
#define GPT1_PSR_TIOB 0x10000U
#define GPT1_PSR_TIOB_BIT 16
#define GPT1_PSR_TIOA_MASK 0x20000U
#define GPT1_PSR_TIOA 0x20000U
#define GPT1_PSR_TIOA_BIT 17
#define GPT1_PSR_TCLK_MASK 0x40000U
#define GPT1_PSR_TCLK 0x40000U
#define GPT1_PSR_TCLK_BIT 18

#define GPT1_OER (*(volatile unsigned long *)0xFFFCC010)
#define GPT1_OER_OFFSET 0x10
#define GPT1_OER_TIOB_MASK 0x10000U
#define GPT1_OER_TIOB 0x10000U
#define GPT1_OER_TIOB_BIT 16
#define GPT1_OER_TIOA_MASK 0x20000U
#define GPT1_OER_TIOA 0x20000U
#define GPT1_OER_TIOA_BIT 17
#define GPT1_OER_TCLK_MASK 0x40000U
#define GPT1_OER_TCLK 0x40000U
#define GPT1_OER_TCLK_BIT 18

#define GPT1_ODR (*(volatile unsigned long *)0xFFFCC014)
#define GPT1_ODR_OFFSET 0x14
#define GPT1_ODR_TIOB_MASK 0x10000U
#define GPT1_ODR_TIOB 0x10000U
#define GPT1_ODR_TIOB_BIT 16
#define GPT1_ODR_TIOA_MASK 0x20000U
#define GPT1_ODR_TIOA 0x20000U
#define GPT1_ODR_TIOA_BIT 17
#define GPT1_ODR_TCLK_MASK 0x40000U
#define GPT1_ODR_TCLK 0x40000U
#define GPT1_ODR_TCLK_BIT 18

#define GPT1_OSR (*(volatile unsigned long *)0xFFFCC018)
#define GPT1_OSR_OFFSET 0x18
#define GPT1_OSR_TIOB_MASK 0x10000U
#define GPT1_OSR_TIOB 0x10000U
#define GPT1_OSR_TIOB_BIT 16
#define GPT1_OSR_TIOA_MASK 0x20000U
#define GPT1_OSR_TIOA 0x20000U
#define GPT1_OSR_TIOA_BIT 17
#define GPT1_OSR_TCLK_MASK 0x40000U
#define GPT1_OSR_TCLK 0x40000U
#define GPT1_OSR_TCLK_BIT 18

#define GPT1_SODR (*(volatile unsigned long *)0xFFFCC030)
#define GPT1_SODR_OFFSET 0x30
#define GPT1_SODR_TIOB_MASK 0x10000U
#define GPT1_SODR_TIOB 0x10000U
#define GPT1_SODR_TIOB_BIT 16
#define GPT1_SODR_TIOA_MASK 0x20000U
#define GPT1_SODR_TIOA 0x20000U
#define GPT1_SODR_TIOA_BIT 17
#define GPT1_SODR_TCLK_MASK 0x40000U
#define GPT1_SODR_TCLK 0x40000U
#define GPT1_SODR_TCLK_BIT 18

#define GPT1_CODR (*(volatile unsigned long *)0xFFFCC034)
#define GPT1_CODR_OFFSET 0x34
#define GPT1_CODR_TIOB_MASK 0x10000U
#define GPT1_CODR_TIOB 0x10000U
#define GPT1_CODR_TIOB_BIT 16
#define GPT1_CODR_TIOA_MASK 0x20000U
#define GPT1_CODR_TIOA 0x20000U
#define GPT1_CODR_TIOA_BIT 17
#define GPT1_CODR_TCLK_MASK 0x40000U
#define GPT1_CODR_TCLK 0x40000U
#define GPT1_CODR_TCLK_BIT 18

#define GPT1_ODSR (*(volatile unsigned long *)0xFFFCC038)
#define GPT1_ODSR_OFFSET 0x38
#define GPT1_ODSR_TIOB_MASK 0x10000U
#define GPT1_ODSR_TIOB 0x10000U
#define GPT1_ODSR_TIOB_BIT 16
#define GPT1_ODSR_TIOA_MASK 0x20000U
#define GPT1_ODSR_TIOA 0x20000U
#define GPT1_ODSR_TIOA_BIT 17
#define GPT1_ODSR_TCLK_MASK 0x40000U
#define GPT1_ODSR_TCLK 0x40000U
#define GPT1_ODSR_TCLK_BIT 18

#define GPT1_PDSR (*(volatile unsigned long *)0xFFFCC03C)
#define GPT1_PDSR_OFFSET 0x3C
#define GPT1_PDSR_TIOB_MASK 0x10000U
#define GPT1_PDSR_TIOB 0x10000U
#define GPT1_PDSR_TIOB_BIT 16
#define GPT1_PDSR_TIOA_MASK 0x20000U
#define GPT1_PDSR_TIOA 0x20000U
#define GPT1_PDSR_TIOA_BIT 17
#define GPT1_PDSR_TCLK_MASK 0x40000U
#define GPT1_PDSR_TCLK 0x40000U
#define GPT1_PDSR_TCLK_BIT 18

#define GPT1_MDER (*(volatile unsigned long *)0xFFFCC040)
#define GPT1_MDER_OFFSET 0x40
#define GPT1_MDER_TIOB_MASK 0x10000U
#define GPT1_MDER_TIOB 0x10000U
#define GPT1_MDER_TIOB_BIT 16
#define GPT1_MDER_TIOA_MASK 0x20000U
#define GPT1_MDER_TIOA 0x20000U
#define GPT1_MDER_TIOA_BIT 17
#define GPT1_MDER_TCLK_MASK 0x40000U
#define GPT1_MDER_TCLK 0x40000U
#define GPT1_MDER_TCLK_BIT 18

#define GPT1_MDDR (*(volatile unsigned long *)0xFFFCC044)
#define GPT1_MDDR_OFFSET 0x44
#define GPT1_MDDR_TIOB_MASK 0x10000U
#define GPT1_MDDR_TIOB 0x10000U
#define GPT1_MDDR_TIOB_BIT 16
#define GPT1_MDDR_TIOA_MASK 0x20000U
#define GPT1_MDDR_TIOA 0x20000U
#define GPT1_MDDR_TIOA_BIT 17
#define GPT1_MDDR_TCLK_MASK 0x40000U
#define GPT1_MDDR_TCLK 0x40000U
#define GPT1_MDDR_TCLK_BIT 18

#define GPT1_MDSR (*(volatile unsigned long *)0xFFFCC048)
#define GPT1_MDSR_OFFSET 0x48
#define GPT1_MDSR_TIOB_MASK 0x10000U
#define GPT1_MDSR_TIOB 0x10000U
#define GPT1_MDSR_TIOB_BIT 16
#define GPT1_MDSR_TIOA_MASK 0x20000U
#define GPT1_MDSR_TIOA 0x20000U
#define GPT1_MDSR_TIOA_BIT 17
#define GPT1_MDSR_TCLK_MASK 0x40000U
#define GPT1_MDSR_TCLK 0x40000U
#define GPT1_MDSR_TCLK_BIT 18

#define GPT1_ECR (*(volatile unsigned long *)0xFFFCC050)
#define GPT1_ECR_OFFSET 0x50
#define GPT1_ECR_PIO_MASK 0x1U
#define GPT1_ECR_PIO 0x1U
#define GPT1_ECR_PIO_BIT 0
#define GPT1_ECR_GPT_MASK 0x2U
#define GPT1_ECR_GPT 0x2U
#define GPT1_ECR_GPT_BIT 1

#define GPT1_DCR (*(volatile unsigned long *)0xFFFCC054)
#define GPT1_DCR_OFFSET 0x54
#define GPT1_DCR_PIO_MASK 0x1U
#define GPT1_DCR_PIO 0x1U
#define GPT1_DCR_PIO_BIT 0
#define GPT1_DCR_GPT_MASK 0x2U
#define GPT1_DCR_GPT 0x2U
#define GPT1_DCR_GPT_BIT 1

#define GPT1_PMSR (*(volatile unsigned long *)0xFFFCC058)
#define GPT1_PMSR_OFFSET 0x58
#define GPT1_PMSR_PIO_MASK 0x1U
#define GPT1_PMSR_PIO 0x1U
#define GPT1_PMSR_PIO_BIT 0
#define GPT1_PMSR_GPT_MASK 0x2U
#define GPT1_PMSR_GPT 0x2U
#define GPT1_PMSR_GPT_BIT 1

#define GPT1_CR (*(volatile unsigned long *)0xFFFCC060)
#define GPT1_CR_OFFSET 0x60
#define GPT1_CR_SWRST_MASK 0x1U
#define GPT1_CR_SWRST 0x1U
#define GPT1_CR_SWRST_BIT 0
#define GPT1_CR_CLKEN_MASK 0x2U
#define GPT1_CR_CLKEN 0x2U
#define GPT1_CR_CLKEN_BIT 1
#define GPT1_CR_CLKDIS_MASK 0x4U
#define GPT1_CR_CLKDIS 0x4U
#define GPT1_CR_CLKDIS_BIT 2
#define GPT1_CR_SWTRG_MASK 0x8U
#define GPT1_CR_SWTRG 0x8U
#define GPT1_CR_SWTRG_BIT 3

#define GPT1_MR (*(volatile unsigned long *)0xFFFCC064)
#define GPT1_MR_OFFSET 0x64
#define GPT1_MR_CLKS_MASK 0x7U
#define GPT1_MR_CLKS_BIT 0
#define GPT1_MR_CLKI_MASK 0x8U
#define GPT1_MR_CLKI 0x8U
#define GPT1_MR_CLKI_BIT 3
#define GPT1_MR_BURST_MASK 0x30U
#define GPT1_MR_BURST_BIT 4
#define GPT1_MR_LDBSTOP_MASK 0x40U
#define GPT1_MR_LDBSTOP 0x40U
#define GPT1_MR_LDBSTOP_BIT 6
#define GPT1_MR_LDBIS_MASK 0x80U
#define GPT1_MR_LDBIS 0x80U
#define GPT1_MR_LDBIS_BIT 7
#define GPT1_MR_ETRGEDG_MASK 0x300U
#define GPT1_MR_ETRGEDG_BIT 8
#define GPT1_MR_ABETRG_MASK 0x400U
#define GPT1_MR_ABETRG 0x400U
#define GPT1_MR_ABETRG_BIT 10
#define GPT1_MR_CPCTRG_MASK 0x4000U
#define GPT1_MR_CPCTRG 0x4000U
#define GPT1_MR_CPCTRG_BIT 14
#define GPT1_MR_WAVE_MASK 0x8000U
#define GPT1_MR_WAVE 0x8000U
#define GPT1_MR_WAVE_BIT 15
#define GPT1_MR_LDRA_MASK 0x30000U
#define GPT1_MR_LDRA_BIT 16
#define GPT1_MR_LDRB_MASK 0xC0000U
#define GPT1_MR_LDRB_BIT 18

#define GPT1_MR_WFM (*(volatile unsigned long *)0xFFFCC064)
#define GPT1_MR_WFM_OFFSET 0x64
#define GPT1_MR_WFM_CLKS_MASK 0x7U
#define GPT1_MR_WFM_CLKS_BIT 0
#define GPT1_MR_WFM_CLKI_MASK 0x8U
#define GPT1_MR_WFM_CLKI 0x8U
#define GPT1_MR_WFM_CLKI_BIT 3
#define GPT1_MR_WFM_BURST_MASK 0x30U
#define GPT1_MR_WFM_BURST_BIT 4
#define GPT1_MR_WFM_CPCSTOP_MASK 0x40U
#define GPT1_MR_WFM_CPCSTOP 0x40U
#define GPT1_MR_WFM_CPCSTOP_BIT 6
#define GPT1_MR_WFM_CPCDIS_MASK 0x80U
#define GPT1_MR_WFM_CPCDIS 0x80U
#define GPT1_MR_WFM_CPCDIS_BIT 7
#define GPT1_MR_WFM_EEVTEDG_MASK 0x300U
#define GPT1_MR_WFM_EEVTEDG_BIT 8
#define GPT1_MR_WFM_EEVT_MASK 0xC00U
#define GPT1_MR_WFM_EEVT_BIT 10
#define GPT1_MR_WFM_ENETRG_MASK 0x1000U
#define GPT1_MR_WFM_ENETRG 0x1000U
#define GPT1_MR_WFM_ENETRG_BIT 12
#define GPT1_MR_WFM_CPCTRG_MASK 0x4000U
#define GPT1_MR_WFM_CPCTRG 0x4000U
#define GPT1_MR_WFM_CPCTRG_BIT 14
#define GPT1_MR_WFM_WAVE_MASK 0x18000U
#define GPT1_MR_WFM_WAVE_BIT 15
#define GPT1_MR_WFM_ACPA_MASK 0x30000U
#define GPT1_MR_WFM_ACPA_BIT 16
#define GPT1_MR_WFM_ACPC_MASK 0xC0000U
#define GPT1_MR_WFM_ACPC_BIT 18
#define GPT1_MR_WFM_AEEVT_MASK 0x300000U
#define GPT1_MR_WFM_AEEVT_BIT 20
#define GPT1_MR_WFM_ASWTRG_MASK 0xC00000U
#define GPT1_MR_WFM_ASWTRG_BIT 22
#define GPT1_MR_WFM_BCPB_MASK 0x3000000U
#define GPT1_MR_WFM_BCPB_BIT 24
#define GPT1_MR_WFM_BCPC_MASK 0xC000000U
#define GPT1_MR_WFM_BCPC_BIT 26
#define GPT1_MR_WFM_BEEVT_MASK 0x30000000U
#define GPT1_MR_WFM_BEEVT_BIT 28
#define GPT1_MR_WFM_BSWTRG_MASK 0xC0000000U
#define GPT1_MR_WFM_BSWTRG_BIT 30

#define GPT1_SR (*(volatile unsigned long *)0xFFFCC070)
#define GPT1_SR_OFFSET 0x70
#define GPT1_SR_COVFS_MASK 0x1U
#define GPT1_SR_COVFS 0x1U
#define GPT1_SR_COVFS_BIT 0
#define GPT1_SR_LOVRS_MASK 0x2U
#define GPT1_SR_LOVRS 0x2U
#define GPT1_SR_LOVRS_BIT 1
#define GPT1_SR_CPCS_MASK 0x10U
#define GPT1_SR_CPCS 0x10U
#define GPT1_SR_CPCS_BIT 4
#define GPT1_SR_LDRAS_MASK 0x20U
#define GPT1_SR_LDRAS 0x20U
#define GPT1_SR_LDRAS_BIT 5
#define GPT1_SR_LDRBS_MASK 0x40U
#define GPT1_SR_LDRBS 0x40U
#define GPT1_SR_LDRBS_BIT 6
#define GPT1_SR_ETRGS_MASK 0x80U
#define GPT1_SR_ETRGS 0x80U
#define GPT1_SR_ETRGS_BIT 7
#define GPT1_SR_CLKSTA_MASK 0x100U
#define GPT1_SR_CLKSTA 0x100U
#define GPT1_SR_CLKSTA_BIT 8
#define GPT1_SR_MTIOA_MASK 0x200U
#define GPT1_SR_MTIOA 0x200U
#define GPT1_SR_MTIOA_BIT 9
#define GPT1_SR_MTIOB_MASK 0x400U
#define GPT1_SR_MTIOB 0x400U
#define GPT1_SR_MTIOB_BIT 10
#define GPT1_SR_TIOBS_MASK 0x10000U
#define GPT1_SR_TIOBS 0x10000U
#define GPT1_SR_TIOBS_BIT 16
#define GPT1_SR_TIOAS_MASK 0x20000U
#define GPT1_SR_TIOAS 0x20000U
#define GPT1_SR_TIOAS_BIT 17
#define GPT1_SR_TCLKS_MASK 0x40000U
#define GPT1_SR_TCLKS 0x40000U
#define GPT1_SR_TCLKS_BIT 18

#define GPT1_SR_WFM (*(volatile unsigned long *)0xFFFCC070)
#define GPT1_SR_WFM_OFFSET 0x70
#define GPT1_SR_WFM_COVFS_MASK 0x1U
#define GPT1_SR_WFM_COVFS 0x1U
#define GPT1_SR_WFM_COVFS_BIT 0
#define GPT1_SR_WFM_CPAS_MASK 0x4U
#define GPT1_SR_WFM_CPAS 0x4U
#define GPT1_SR_WFM_CPAS_BIT 2
#define GPT1_SR_WFM_CPBS_MASK 0x8U
#define GPT1_SR_WFM_CPBS 0x8U
#define GPT1_SR_WFM_CPBS_BIT 3
#define GPT1_SR_WFM_CPCS_MASK 0x10U
#define GPT1_SR_WFM_CPCS 0x10U
#define GPT1_SR_WFM_CPCS_BIT 4
#define GPT1_SR_WFM_ETRGS_MASK 0x80U
#define GPT1_SR_WFM_ETRGS 0x80U
#define GPT1_SR_WFM_ETRGS_BIT 7
#define GPT1_SR_WFM_CLKSTA_MASK 0x100U
#define GPT1_SR_WFM_CLKSTA 0x100U
#define GPT1_SR_WFM_CLKSTA_BIT 8
#define GPT1_SR_WFM_MTIOA_MASK 0x200U
#define GPT1_SR_WFM_MTIOA 0x200U
#define GPT1_SR_WFM_MTIOA_BIT 9
#define GPT1_SR_WFM_MTIOB_MASK 0x400U
#define GPT1_SR_WFM_MTIOB 0x400U
#define GPT1_SR_WFM_MTIOB_BIT 10
#define GPT1_SR_WFM_TIOBS_MASK 0x10000U
#define GPT1_SR_WFM_TIOBS 0x10000U
#define GPT1_SR_WFM_TIOBS_BIT 16
#define GPT1_SR_WFM_TIOAS_MASK 0x20000U
#define GPT1_SR_WFM_TIOAS 0x20000U
#define GPT1_SR_WFM_TIOAS_BIT 17
#define GPT1_SR_WFM_TCLKS_MASK 0x40000U
#define GPT1_SR_WFM_TCLKS 0x40000U
#define GPT1_SR_WFM_TCLKS_BIT 18

#define GPT1_IER (*(volatile unsigned long *)0xFFFCC074)
#define GPT1_IER_OFFSET 0x74
#define GPT1_IER_COVFS_MASK 0x1U
#define GPT1_IER_COVFS 0x1U
#define GPT1_IER_COVFS_BIT 0
#define GPT1_IER_LOVRS_MASK 0x2U
#define GPT1_IER_LOVRS 0x2U
#define GPT1_IER_LOVRS_BIT 1
#define GPT1_IER_CPCS_MASK 0x10U
#define GPT1_IER_CPCS 0x10U
#define GPT1_IER_CPCS_BIT 4
#define GPT1_IER_LDRAS_MASK 0x20U
#define GPT1_IER_LDRAS 0x20U
#define GPT1_IER_LDRAS_BIT 5
#define GPT1_IER_LDRBS_MASK 0x40U
#define GPT1_IER_LDRBS 0x40U
#define GPT1_IER_LDRBS_BIT 6
#define GPT1_IER_ETRGS_MASK 0x80U
#define GPT1_IER_ETRGS 0x80U
#define GPT1_IER_ETRGS_BIT 7
#define GPT1_IER_TIOBS_MASK 0x10000U
#define GPT1_IER_TIOBS 0x10000U
#define GPT1_IER_TIOBS_BIT 16
#define GPT1_IER_TIOAS_MASK 0x20000U
#define GPT1_IER_TIOAS 0x20000U
#define GPT1_IER_TIOAS_BIT 17
#define GPT1_IER_TCLKS_MASK 0x40000U
#define GPT1_IER_TCLKS 0x40000U
#define GPT1_IER_TCLKS_BIT 18

#define GPT1_IER_WFM (*(volatile unsigned long *)0xFFFCC074)
#define GPT1_IER_WFM_OFFSET 0x74
#define GPT1_IER_WFM_COVFS_MASK 0x1U
#define GPT1_IER_WFM_COVFS 0x1U
#define GPT1_IER_WFM_COVFS_BIT 0
#define GPT1_IER_WFM_CPAS_MASK 0x4U
#define GPT1_IER_WFM_CPAS 0x4U
#define GPT1_IER_WFM_CPAS_BIT 2
#define GPT1_IER_WFM_CPBS_MASK 0x8U
#define GPT1_IER_WFM_CPBS 0x8U
#define GPT1_IER_WFM_CPBS_BIT 3
#define GPT1_IER_WFM_CPCS_MASK 0x10U
#define GPT1_IER_WFM_CPCS 0x10U
#define GPT1_IER_WFM_CPCS_BIT 4
#define GPT1_IER_WFM_ETRGS_MASK 0x80U
#define GPT1_IER_WFM_ETRGS 0x80U
#define GPT1_IER_WFM_ETRGS_BIT 7
#define GPT1_IER_WFM_TIOBS_MASK 0x10000U
#define GPT1_IER_WFM_TIOBS 0x10000U
#define GPT1_IER_WFM_TIOBS_BIT 16
#define GPT1_IER_WFM_TIOAS_MASK 0x20000U
#define GPT1_IER_WFM_TIOAS 0x20000U
#define GPT1_IER_WFM_TIOAS_BIT 17
#define GPT1_IER_WFM_TCLKS_MASK 0x40000U
#define GPT1_IER_WFM_TCLKS 0x40000U
#define GPT1_IER_WFM_TCLKS_BIT 18

#define GPT1_IDR (*(volatile unsigned long *)0xFFFCC078)
#define GPT1_IDR_OFFSET 0x78
#define GPT1_IDR_COVFS_MASK 0x1U
#define GPT1_IDR_COVFS 0x1U
#define GPT1_IDR_COVFS_BIT 0
#define GPT1_IDR_LOVRS_MASK 0x2U
#define GPT1_IDR_LOVRS 0x2U
#define GPT1_IDR_LOVRS_BIT 1
#define GPT1_IDR_CPCS_MASK 0x10U
#define GPT1_IDR_CPCS 0x10U
#define GPT1_IDR_CPCS_BIT 4
#define GPT1_IDR_LDRAS_MASK 0x20U
#define GPT1_IDR_LDRAS 0x20U
#define GPT1_IDR_LDRAS_BIT 5
#define GPT1_IDR_LDRBS_MASK 0x40U
#define GPT1_IDR_LDRBS 0x40U
#define GPT1_IDR_LDRBS_BIT 6
#define GPT1_IDR_ETRGS_MASK 0x80U
#define GPT1_IDR_ETRGS 0x80U
#define GPT1_IDR_ETRGS_BIT 7
#define GPT1_IDR_TIOBS_MASK 0x10000U
#define GPT1_IDR_TIOBS 0x10000U
#define GPT1_IDR_TIOBS_BIT 16
#define GPT1_IDR_TIOAS_MASK 0x20000U
#define GPT1_IDR_TIOAS 0x20000U
#define GPT1_IDR_TIOAS_BIT 17
#define GPT1_IDR_TCLKS_MASK 0x40000U
#define GPT1_IDR_TCLKS 0x40000U
#define GPT1_IDR_TCLKS_BIT 18

#define GPT1_IDR_WFM (*(volatile unsigned long *)0xFFFCC078)
#define GPT1_IDR_WFM_OFFSET 0x78
#define GPT1_IDR_WFM_COVFS_MASK 0x1U
#define GPT1_IDR_WFM_COVFS 0x1U
#define GPT1_IDR_WFM_COVFS_BIT 0
#define GPT1_IDR_WFM_CPAS_MASK 0x4U
#define GPT1_IDR_WFM_CPAS 0x4U
#define GPT1_IDR_WFM_CPAS_BIT 2
#define GPT1_IDR_WFM_CPBS_MASK 0x8U
#define GPT1_IDR_WFM_CPBS 0x8U
#define GPT1_IDR_WFM_CPBS_BIT 3
#define GPT1_IDR_WFM_CPCS_MASK 0x10U
#define GPT1_IDR_WFM_CPCS 0x10U
#define GPT1_IDR_WFM_CPCS_BIT 4
#define GPT1_IDR_WFM_ETRGS_MASK 0x80U
#define GPT1_IDR_WFM_ETRGS 0x80U
#define GPT1_IDR_WFM_ETRGS_BIT 7
#define GPT1_IDR_WFM_TIOBS_MASK 0x10000U
#define GPT1_IDR_WFM_TIOBS 0x10000U
#define GPT1_IDR_WFM_TIOBS_BIT 16
#define GPT1_IDR_WFM_TIOAS_MASK 0x20000U
#define GPT1_IDR_WFM_TIOAS 0x20000U
#define GPT1_IDR_WFM_TIOAS_BIT 17
#define GPT1_IDR_WFM_TCLKS_MASK 0x40000U
#define GPT1_IDR_WFM_TCLKS 0x40000U
#define GPT1_IDR_WFM_TCLKS_BIT 18

#define GPT1_IMR (*(volatile unsigned long *)0xFFFCC07C)
#define GPT1_IMR_OFFSET 0x7C
#define GPT1_IMR_COVFS_MASK 0x1U
#define GPT1_IMR_COVFS 0x1U
#define GPT1_IMR_COVFS_BIT 0
#define GPT1_IMR_LOVRS_MASK 0x2U
#define GPT1_IMR_LOVRS 0x2U
#define GPT1_IMR_LOVRS_BIT 1
#define GPT1_IMR_CPCS_MASK 0x10U
#define GPT1_IMR_CPCS 0x10U
#define GPT1_IMR_CPCS_BIT 4
#define GPT1_IMR_LDRAS_MASK 0x20U
#define GPT1_IMR_LDRAS 0x20U
#define GPT1_IMR_LDRAS_BIT 5
#define GPT1_IMR_LDRBS_MASK 0x40U
#define GPT1_IMR_LDRBS 0x40U
#define GPT1_IMR_LDRBS_BIT 6
#define GPT1_IMR_ETRGS_MASK 0x80U
#define GPT1_IMR_ETRGS 0x80U
#define GPT1_IMR_ETRGS_BIT 7
#define GPT1_IMR_TIOBS_MASK 0x10000U
#define GPT1_IMR_TIOBS 0x10000U
#define GPT1_IMR_TIOBS_BIT 16
#define GPT1_IMR_TIOAS_MASK 0x20000U
#define GPT1_IMR_TIOAS 0x20000U
#define GPT1_IMR_TIOAS_BIT 17
#define GPT1_IMR_TCLKS_MASK 0x40000U
#define GPT1_IMR_TCLKS 0x40000U
#define GPT1_IMR_TCLKS_BIT 18

#define GPT1_IMR_WFM (*(volatile unsigned long *)0xFFFCC07C)
#define GPT1_IMR_WFM_OFFSET 0x7C
#define GPT1_IMR_WFM_COVFS_MASK 0x1U
#define GPT1_IMR_WFM_COVFS 0x1U
#define GPT1_IMR_WFM_COVFS_BIT 0
#define GPT1_IMR_WFM_CPAS_MASK 0x4U
#define GPT1_IMR_WFM_CPAS 0x4U
#define GPT1_IMR_WFM_CPAS_BIT 2
#define GPT1_IMR_WFM_CPBS_MASK 0x8U
#define GPT1_IMR_WFM_CPBS 0x8U
#define GPT1_IMR_WFM_CPBS_BIT 3
#define GPT1_IMR_WFM_CPCS_MASK 0x10U
#define GPT1_IMR_WFM_CPCS 0x10U
#define GPT1_IMR_WFM_CPCS_BIT 4
#define GPT1_IMR_WFM_ETRGS_MASK 0x80U
#define GPT1_IMR_WFM_ETRGS 0x80U
#define GPT1_IMR_WFM_ETRGS_BIT 7
#define GPT1_IMR_WFM_TIOBS_MASK 0x10000U
#define GPT1_IMR_WFM_TIOBS 0x10000U
#define GPT1_IMR_WFM_TIOBS_BIT 16
#define GPT1_IMR_WFM_TIOAS_MASK 0x20000U
#define GPT1_IMR_WFM_TIOAS 0x20000U
#define GPT1_IMR_WFM_TIOAS_BIT 17
#define GPT1_IMR_WFM_TCLKS_MASK 0x40000U
#define GPT1_IMR_WFM_TCLKS 0x40000U
#define GPT1_IMR_WFM_TCLKS_BIT 18

#define GPT1_CV (*(volatile unsigned long *)0xFFFCC080)
#define GPT1_CV_OFFSET 0x80
#define GPT1_CV_CV_MASK 0xFFFFU
#define GPT1_CV_CV_BIT 0

#define GPT1_RA (*(volatile unsigned long *)0xFFFCC084)
#define GPT1_RA_OFFSET 0x84
#define GPT1_RA_RA_MASK 0xFFFFU
#define GPT1_RA_RA_BIT 0

#define GPT1_RB (*(volatile unsigned long *)0xFFFCC088)
#define GPT1_RB_OFFSET 0x88
#define GPT1_RB_RB_MASK 0xFFFFU
#define GPT1_RB_RB_BIT 0

#define GPT1_RC (*(volatile unsigned long *)0xFFFCC08C)
#define GPT1_RC_OFFSET 0x8C
#define GPT1_RC_RC_MASK 0xFFFFU
#define GPT1_RC_RC_BIT 0

#define GPT1_BCR (*(volatile unsigned long *)0xFFFCC300)
#define GPT1_BCR_OFFSET 0x300
#define GPT1_BCR_SWRST_MASK 0x1U
#define GPT1_BCR_SWRST 0x1U
#define GPT1_BCR_SWRST_BIT 0
#define GPT1_BCR_TCSYNC_MASK 0x2U
#define GPT1_BCR_TCSYNC 0x2U
#define GPT1_BCR_TCSYNC_BIT 1

#define GPT1_BMR (*(volatile unsigned long *)0xFFFCC304)
#define GPT1_BMR_OFFSET 0x304
#define GPT1_BMR_TC0XC0S_MASK 0x3U
#define GPT1_BMR_TC0XC0S_BIT 0
#define GPT1_BMR_TC1XC1S_MASK 0xCU
#define GPT1_BMR_TC1XC1S_BIT 2
#define GPT1_BMR_TC2XC2S_MASK 0x30U
#define GPT1_BMR_TC2XC2S_BIT 4

#define PWM_BASE 0xFFFD0000

#define PWM_ECR (*(volatile unsigned long *)0xFFFD0050)
#define PWM_ECR_OFFSET 0x50
#define PWM_ECR_PWM_MASK 0x2U
#define PWM_ECR_PWM 0x2U
#define PWM_ECR_PWM_BIT 1

#define PWM_DCR (*(volatile unsigned long *)0xFFFD0054)
#define PWM_DCR_OFFSET 0x54
#define PWM_DCR_PWM_MASK 0x2U
#define PWM_DCR_PWM 0x2U
#define PWM_DCR_PWM_BIT 1

#define PWM_PMSR (*(volatile unsigned long *)0xFFFD0058)
#define PWM_PMSR_OFFSET 0x58
#define PWM_PMSR_PWM_MASK 0x2U
#define PWM_PMSR_PWM 0x2U
#define PWM_PMSR_PWM_BIT 1

#define PWM_CR (*(volatile unsigned long *)0xFFFD0060)
#define PWM_CR_OFFSET 0x60
#define PWM_CR_SWRST_MASK 0x1U
#define PWM_CR_SWRST 0x1U
#define PWM_CR_SWRST_BIT 0
#define PWM_CR_PWMEN0_MASK 0x2U
#define PWM_CR_PWMEN0 0x2U
#define PWM_CR_PWMEN0_BIT 1
#define PWM_CR_PWMDIS0_MASK 0x4U
#define PWM_CR_PWMDIS0 0x4U
#define PWM_CR_PWMDIS0_BIT 2
#define PWM_CR_PWMEN1_MASK 0x8U
#define PWM_CR_PWMEN1 0x8U
#define PWM_CR_PWMEN1_BIT 3
#define PWM_CR_PWMDIS1_MASK 0x10U
#define PWM_CR_PWMDIS1 0x10U
#define PWM_CR_PWMDIS1_BIT 4
#define PWM_CR_PWMEN2_MASK 0x20U
#define PWM_CR_PWMEN2 0x20U
#define PWM_CR_PWMEN2_BIT 5
#define PWM_CR_PWMDIS2_MASK 0x40U
#define PWM_CR_PWMDIS2 0x40U
#define PWM_CR_PWMDIS2_BIT 6
#define PWM_CR_PWMEN3_MASK 0x80U
#define PWM_CR_PWMEN3 0x80U
#define PWM_CR_PWMEN3_BIT 7
#define PWM_CR_PWMDIS3_MASK 0x100U
#define PWM_CR_PWMDIS3 0x100U
#define PWM_CR_PWMDIS3_BIT 8

#define PWM_MR (*(volatile unsigned long *)0xFFFD0064)
#define PWM_MR_OFFSET 0x64
#define PWM_MR_PRESCAL0_MASK 0xFU
#define PWM_MR_PRESCAL0_BIT 0
#define PWM_MR_PL0_MASK 0x10U
#define PWM_MR_PL0 0x10U
#define PWM_MR_PL0_BIT 4
#define PWM_MR_PRESCAL1_MASK 0xF00U
#define PWM_MR_PRESCAL1_BIT 8
#define PWM_MR_PL1_MASK 0x1000U
#define PWM_MR_PL1 0x1000U
#define PWM_MR_PL1_BIT 12
#define PWM_MR_PRESCAL2_MASK 0xF0000U
#define PWM_MR_PRESCAL2_BIT 16
#define PWM_MR_PL2_MASK 0x100000U
#define PWM_MR_PL2 0x100000U
#define PWM_MR_PL2_BIT 20
#define PWM_MR_PRESCAL3_MASK 0xF000000U
#define PWM_MR_PRESCAL3_BIT 24
#define PWM_MR_PL3_MASK 0x10000000U
#define PWM_MR_PL3 0x10000000U
#define PWM_MR_PL3_BIT 28

#define PWM_CSR (*(volatile unsigned long *)0xFFFD006C)
#define PWM_CSR_OFFSET 0x6C
#define PWM_CSR_PSTA0_MASK 0x1U
#define PWM_CSR_PSTA0 0x1U
#define PWM_CSR_PSTA0_BIT 0
#define PWM_CSR_PEND0_MASK 0x2U
#define PWM_CSR_PEND0 0x2U
#define PWM_CSR_PEND0_BIT 1
#define PWM_CSR_PSTA1_MASK 0x4U
#define PWM_CSR_PSTA1 0x4U
#define PWM_CSR_PSTA1_BIT 2
#define PWM_CSR_PEND1_MASK 0x8U
#define PWM_CSR_PEND1 0x8U
#define PWM_CSR_PEND1_BIT 3
#define PWM_CSR_PSTA2_MASK 0x10U
#define PWM_CSR_PSTA2 0x10U
#define PWM_CSR_PSTA2_BIT 4
#define PWM_CSR_PEND2_MASK 0x20U
#define PWM_CSR_PEND2 0x20U
#define PWM_CSR_PEND2_BIT 5
#define PWM_CSR_PSTA3_MASK 0x40U
#define PWM_CSR_PSTA3 0x40U
#define PWM_CSR_PSTA3_BIT 6
#define PWM_CSR_PEND3_MASK 0x80U
#define PWM_CSR_PEND3 0x80U
#define PWM_CSR_PEND3_BIT 7

#define PWM_SR (*(volatile unsigned long *)0xFFFD0070)
#define PWM_SR_OFFSET 0x70
#define PWM_SR_PSTA0_MASK 0x1U
#define PWM_SR_PSTA0 0x1U
#define PWM_SR_PSTA0_BIT 0
#define PWM_SR_PEND0_MASK 0x2U
#define PWM_SR_PEND0 0x2U
#define PWM_SR_PEND0_BIT 1
#define PWM_SR_PSTA1_MASK 0x4U
#define PWM_SR_PSTA1 0x4U
#define PWM_SR_PSTA1_BIT 2
#define PWM_SR_PEND1_MASK 0x8U
#define PWM_SR_PEND1 0x8U
#define PWM_SR_PEND1_BIT 3
#define PWM_SR_PSTA2_MASK 0x10U
#define PWM_SR_PSTA2 0x10U
#define PWM_SR_PSTA2_BIT 4
#define PWM_SR_PEND2_MASK 0x20U
#define PWM_SR_PEND2 0x20U
#define PWM_SR_PEND2_BIT 5
#define PWM_SR_PSTA3_MASK 0x40U
#define PWM_SR_PSTA3 0x40U
#define PWM_SR_PSTA3_BIT 6
#define PWM_SR_PEND3_MASK 0x80U
#define PWM_SR_PEND3 0x80U
#define PWM_SR_PEND3_BIT 7
#define PWM_SR_PWMENS0_MASK 0x100U
#define PWM_SR_PWMENS0 0x100U
#define PWM_SR_PWMENS0_BIT 8
#define PWM_SR_PWMENS1_MASK 0x200U
#define PWM_SR_PWMENS1 0x200U
#define PWM_SR_PWMENS1_BIT 9
#define PWM_SR_PWMENS2_MASK 0x400U
#define PWM_SR_PWMENS2 0x400U
#define PWM_SR_PWMENS2_BIT 10
#define PWM_SR_PWMENS3_MASK 0x800U
#define PWM_SR_PWMENS3 0x800U
#define PWM_SR_PWMENS3_BIT 11

#define PWM_IER (*(volatile unsigned long *)0xFFFD0074)
#define PWM_IER_OFFSET 0x74
#define PWM_IER_PSTA0_MASK 0x1U
#define PWM_IER_PSTA0 0x1U
#define PWM_IER_PSTA0_BIT 0
#define PWM_IER_PEND0_MASK 0x2U
#define PWM_IER_PEND0 0x2U
#define PWM_IER_PEND0_BIT 1
#define PWM_IER_PSTA1_MASK 0x4U
#define PWM_IER_PSTA1 0x4U
#define PWM_IER_PSTA1_BIT 2
#define PWM_IER_PEND1_MASK 0x8U
#define PWM_IER_PEND1 0x8U
#define PWM_IER_PEND1_BIT 3
#define PWM_IER_PSTA2_MASK 0x10U
#define PWM_IER_PSTA2 0x10U
#define PWM_IER_PSTA2_BIT 4
#define PWM_IER_PEND2_MASK 0x20U
#define PWM_IER_PEND2 0x20U
#define PWM_IER_PEND2_BIT 5
#define PWM_IER_PSTA3_MASK 0x40U
#define PWM_IER_PSTA3 0x40U
#define PWM_IER_PSTA3_BIT 6
#define PWM_IER_PEND3_MASK 0x80U
#define PWM_IER_PEND3 0x80U
#define PWM_IER_PEND3_BIT 7

#define PWM_IDR (*(volatile unsigned long *)0xFFFD0078)
#define PWM_IDR_OFFSET 0x78
#define PWM_IDR_PSTA0_MASK 0x1U
#define PWM_IDR_PSTA0 0x1U
#define PWM_IDR_PSTA0_BIT 0
#define PWM_IDR_PEND0_MASK 0x2U
#define PWM_IDR_PEND0 0x2U
#define PWM_IDR_PEND0_BIT 1
#define PWM_IDR_PSTA1_MASK 0x4U
#define PWM_IDR_PSTA1 0x4U
#define PWM_IDR_PSTA1_BIT 2
#define PWM_IDR_PEND1_MASK 0x8U
#define PWM_IDR_PEND1 0x8U
#define PWM_IDR_PEND1_BIT 3
#define PWM_IDR_PSTA2_MASK 0x10U
#define PWM_IDR_PSTA2 0x10U
#define PWM_IDR_PSTA2_BIT 4
#define PWM_IDR_PEND2_MASK 0x20U
#define PWM_IDR_PEND2 0x20U
#define PWM_IDR_PEND2_BIT 5
#define PWM_IDR_PSTA3_MASK 0x40U
#define PWM_IDR_PSTA3 0x40U
#define PWM_IDR_PSTA3_BIT 6
#define PWM_IDR_PEND3_MASK 0x80U
#define PWM_IDR_PEND3 0x80U
#define PWM_IDR_PEND3_BIT 7

#define PWM_IMR (*(volatile unsigned long *)0xFFFD007C)
#define PWM_IMR_OFFSET 0x7C
#define PWM_IMR_PSTA0_MASK 0x1U
#define PWM_IMR_PSTA0 0x1U
#define PWM_IMR_PSTA0_BIT 0
#define PWM_IMR_PEND0_MASK 0x2U
#define PWM_IMR_PEND0 0x2U
#define PWM_IMR_PEND0_BIT 1
#define PWM_IMR_PSTA1_MASK 0x4U
#define PWM_IMR_PSTA1 0x4U
#define PWM_IMR_PSTA1_BIT 2
#define PWM_IMR_PEND1_MASK 0x8U
#define PWM_IMR_PEND1 0x8U
#define PWM_IMR_PEND1_BIT 3
#define PWM_IMR_PSTA2_MASK 0x10U
#define PWM_IMR_PSTA2 0x10U
#define PWM_IMR_PSTA2_BIT 4
#define PWM_IMR_PEND2_MASK 0x20U
#define PWM_IMR_PEND2 0x20U
#define PWM_IMR_PEND2_BIT 5
#define PWM_IMR_PSTA3_MASK 0x40U
#define PWM_IMR_PSTA3 0x40U
#define PWM_IMR_PSTA3_BIT 6
#define PWM_IMR_PEND3_MASK 0x80U
#define PWM_IMR_PEND3 0x80U
#define PWM_IMR_PEND3_BIT 7

#define PWM_DLY_0 (*(volatile unsigned long *)0xFFFD0080)
#define PWM_DLY_0_OFFSET 0x80
#define PWM_DLY_0_DELAY_MASK 0xFFFFU
#define PWM_DLY_0_DELAY_BIT 0

#define PWM_PUL_0 (*(volatile unsigned long *)0xFFFD0084)
#define PWM_PUL_0_OFFSET 0x84
#define PWM_PUL_0_PULSE_MASK 0xFFFFU
#define PWM_PUL_0_PULSE_BIT 0

#define PWM_DLY_1 (*(volatile unsigned long *)0xFFFD0088)
#define PWM_DLY_1_OFFSET 0x88
#define PWM_DLY_1_DELAY_MASK 0xFFFFU
#define PWM_DLY_1_DELAY_BIT 0

#define PWM_PUL_1 (*(volatile unsigned long *)0xFFFD008C)
#define PWM_PUL_1_OFFSET 0x8C
#define PWM_PUL_1_PULSE_MASK 0xFFFFU
#define PWM_PUL_1_PULSE_BIT 0

#define PWM_DLY_2 (*(volatile unsigned long *)0xFFFD0090)
#define PWM_DLY_2_OFFSET 0x90
#define PWM_DLY_2_DELAY_MASK 0xFFFFU
#define PWM_DLY_2_DELAY_BIT 0

#define PWM_PUL_2 (*(volatile unsigned long *)0xFFFD0094)
#define PWM_PUL_2_OFFSET 0x94
#define PWM_PUL_2_PULSE_MASK 0xFFFFU
#define PWM_PUL_2_PULSE_BIT 0

#define PWM_DLY_3 (*(volatile unsigned long *)0xFFFD0098)
#define PWM_DLY_3_OFFSET 0x98
#define PWM_DLY_3_DELAY_MASK 0xFFFFU
#define PWM_DLY_3_DELAY_BIT 0

#define PWM_PUL_3 (*(volatile unsigned long *)0xFFFD009C)
#define PWM_PUL_3_OFFSET 0x9C
#define PWM_PUL_3_PULSE_MASK 0xFFFFU
#define PWM_PUL_3_PULSE_BIT 0

#define CAN0_BASE 0xFFFD4000

#define CAN0_ECR (*(volatile unsigned long *)0xFFFD4050)
#define CAN0_ECR_OFFSET 0x50
#define CAN0_ECR_CAN_MASK 0x2U
#define CAN0_ECR_CAN 0x2U
#define CAN0_ECR_CAN_BIT 1

#define CAN0_DCR (*(volatile unsigned long *)0xFFFD4054)
#define CAN0_DCR_OFFSET 0x54
#define CAN0_DCR_CAN_MASK 0x2U
#define CAN0_DCR_CAN 0x2U
#define CAN0_DCR_CAN_BIT 1

#define CAN0_PMSR (*(volatile unsigned long *)0xFFFD4058)
#define CAN0_PMSR_OFFSET 0x58
#define CAN0_PMSR_CAN_MASK 0x2U
#define CAN0_PMSR_CAN 0x2U
#define CAN0_PMSR_CAN_BIT 1

#define CAN0_CR (*(volatile unsigned long *)0xFFFD4060)
#define CAN0_CR_OFFSET 0x60
#define CAN0_CR_SWRST_MASK 0x1U
#define CAN0_CR_SWRST 0x1U
#define CAN0_CR_SWRST_BIT 0
#define CAN0_CR_CANEN_MASK 0x2U
#define CAN0_CR_CANEN 0x2U
#define CAN0_CR_CANEN_BIT 1
#define CAN0_CR_CANDIS_MASK 0x4U
#define CAN0_CR_CANDIS 0x4U
#define CAN0_CR_CANDIS_BIT 2
#define CAN0_CR_ABEN_MASK 0x8U
#define CAN0_CR_ABEN 0x8U
#define CAN0_CR_ABEN_BIT 3
#define CAN0_CR_ABDIS_MASK 0x10U
#define CAN0_CR_ABDIS 0x10U
#define CAN0_CR_ABDIS_BIT 4
#define CAN0_CR_OVEN_MASK 0x20U
#define CAN0_CR_OVEN 0x20U
#define CAN0_CR_OVEN_BIT 5
#define CAN0_CR_OVDIS_MASK 0x20U
#define CAN0_CR_OVDIS 0x20U
#define CAN0_CR_OVDIS_BIT 5

#define CAN0_MR (*(volatile unsigned long *)0xFFFD4064)
#define CAN0_MR_OFFSET 0x64
#define CAN0_MR_BD_MASK 0x3FU
#define CAN0_MR_BD_BIT 0
#define CAN0_MR_PROP_MASK 0x700U
#define CAN0_MR_PROP_BIT 8
#define CAN0_MR_SJW_MASK 0x3000U
#define CAN0_MR_SJW_BIT 12
#define CAN0_MR_SMP_MASK 0x4000U
#define CAN0_MR_SMP 0x4000U
#define CAN0_MR_SMP_BIT 14
#define CAN0_MR_PHSEG1_MASK 0x70000U
#define CAN0_MR_PHSEG1_BIT 16
#define CAN0_MR_PHSEG2_MASK 0x700000U
#define CAN0_MR_PHSEG2_BIT 20

#define CAN0_CSR (*(volatile unsigned long *)0xFFFD406C)
#define CAN0_CSR_OFFSET 0x6C
#define CAN0_CSR_ENDINIT_MASK 0x4U
#define CAN0_CSR_ENDINIT 0x4U
#define CAN0_CSR_ENDINIT_BIT 2

#define CAN0_SR (*(volatile unsigned long *)0xFFFD4070)
#define CAN0_SR_OFFSET 0x70
#define CAN0_SR_CANENA_MASK 0x1U
#define CAN0_SR_CANENA 0x1U
#define CAN0_SR_CANENA_BIT 0
#define CAN0_SR_CANINIT_MASK 0x2U
#define CAN0_SR_CANINIT 0x2U
#define CAN0_SR_CANINIT_BIT 1
#define CAN0_SR_ENDINIT_MASK 0x4U
#define CAN0_SR_ENDINIT 0x4U
#define CAN0_SR_ENDINIT_BIT 2
#define CAN0_SR_ERPAS_MASK 0x8U
#define CAN0_SR_ERPAS 0x8U
#define CAN0_SR_ERPAS_BIT 3
#define CAN0_SR_BUSOFF_MASK 0x10U
#define CAN0_SR_BUSOFF 0x10U
#define CAN0_SR_BUSOFF_BIT 4
#define CAN0_SR_ABRQ_MASK 0x20U
#define CAN0_SR_ABRQ 0x20U
#define CAN0_SR_ABRQ_BIT 5
#define CAN0_SR_ISS_MASK 0x80U
#define CAN0_SR_ISS 0x80U
#define CAN0_SR_ISS_BIT 7
#define CAN0_SR_REC_MASK 0xFF0000U
#define CAN0_SR_REC_BIT 16
#define CAN0_SR_TEC_MASK 0xFF000000U
#define CAN0_SR_TEC_BIT 24

#define CAN0_IER (*(volatile unsigned long *)0xFFFD4074)
#define CAN0_IER_OFFSET 0x74
#define CAN0_IER_ENDINIT_MASK 0x4U
#define CAN0_IER_ENDINIT 0x4U
#define CAN0_IER_ENDINIT_BIT 2
#define CAN0_IER_ERPAS_MASK 0x8U
#define CAN0_IER_ERPAS 0x8U
#define CAN0_IER_ERPAS_BIT 3
#define CAN0_IER_BUSOFF_MASK 0x10U
#define CAN0_IER_BUSOFF 0x10U
#define CAN0_IER_BUSOFF_BIT 4

#define CAN0_IDR (*(volatile unsigned long *)0xFFFD4078)
#define CAN0_IDR_OFFSET 0x78
#define CAN0_IDR_ENDINIT_MASK 0x4U
#define CAN0_IDR_ENDINIT 0x4U
#define CAN0_IDR_ENDINIT_BIT 2
#define CAN0_IDR_ERPAS_MASK 0x8U
#define CAN0_IDR_ERPAS 0x8U
#define CAN0_IDR_ERPAS_BIT 3
#define CAN0_IDR_BUSOFF_MASK 0x10U
#define CAN0_IDR_BUSOFF 0x10U
#define CAN0_IDR_BUSOFF_BIT 4

#define CAN0_IMR (*(volatile unsigned long *)0xFFFD407C)
#define CAN0_IMR_OFFSET 0x7C
#define CAN0_IMR_ENDINIT_MASK 0x4U
#define CAN0_IMR_ENDINIT 0x4U
#define CAN0_IMR_ENDINIT_BIT 2
#define CAN0_IMR_ERPAS_MASK 0x8U
#define CAN0_IMR_ERPAS 0x8U
#define CAN0_IMR_ERPAS_BIT 3
#define CAN0_IMR_BUSOFF_MASK 0x10U
#define CAN0_IMR_BUSOFF 0x10U
#define CAN0_IMR_BUSOFF_BIT 4

#define CAN0_CISR (*(volatile unsigned long *)0xFFFD4080)
#define CAN0_CISR_OFFSET 0x80
#define CAN0_CISR_CH0_MASK 0x1U
#define CAN0_CISR_CH0 0x1U
#define CAN0_CISR_CH0_BIT 0
#define CAN0_CISR_CH1_MASK 0x2U
#define CAN0_CISR_CH1 0x2U
#define CAN0_CISR_CH1_BIT 1
#define CAN0_CISR_CH2_MASK 0x4U
#define CAN0_CISR_CH2 0x4U
#define CAN0_CISR_CH2_BIT 2
#define CAN0_CISR_CH3_MASK 0x8U
#define CAN0_CISR_CH3 0x8U
#define CAN0_CISR_CH3_BIT 3
#define CAN0_CISR_CH4_MASK 0x10U
#define CAN0_CISR_CH4 0x10U
#define CAN0_CISR_CH4_BIT 4
#define CAN0_CISR_CH5_MASK 0x20U
#define CAN0_CISR_CH5 0x20U
#define CAN0_CISR_CH5_BIT 5
#define CAN0_CISR_CH6_MASK 0x40U
#define CAN0_CISR_CH6 0x40U
#define CAN0_CISR_CH6_BIT 6
#define CAN0_CISR_CH7_MASK 0x80U
#define CAN0_CISR_CH7 0x80U
#define CAN0_CISR_CH7_BIT 7
#define CAN0_CISR_CH8_MASK 0x100U
#define CAN0_CISR_CH8 0x100U
#define CAN0_CISR_CH8_BIT 8
#define CAN0_CISR_CH9_MASK 0x200U
#define CAN0_CISR_CH9 0x200U
#define CAN0_CISR_CH9_BIT 9
#define CAN0_CISR_CH10_MASK 0x400U
#define CAN0_CISR_CH10 0x400U
#define CAN0_CISR_CH10_BIT 10
#define CAN0_CISR_CH11_MASK 0x800U
#define CAN0_CISR_CH11 0x800U
#define CAN0_CISR_CH11_BIT 11
#define CAN0_CISR_CH12_MASK 0x1000U
#define CAN0_CISR_CH12 0x1000U
#define CAN0_CISR_CH12_BIT 12
#define CAN0_CISR_CH13_MASK 0x2000U
#define CAN0_CISR_CH13 0x2000U
#define CAN0_CISR_CH13_BIT 13
#define CAN0_CISR_CH14_MASK 0x4000U
#define CAN0_CISR_CH14 0x4000U
#define CAN0_CISR_CH14_BIT 14
#define CAN0_CISR_CH15_MASK 0x8000U
#define CAN0_CISR_CH15 0x8000U
#define CAN0_CISR_CH15_BIT 15

#define CAN0_ISSR (*(volatile unsigned long *)0xFFFD4084)
#define CAN0_ISSR_OFFSET 0x84
#define CAN0_ISSR_CH0_MASK 0x1U
#define CAN0_ISSR_CH0 0x1U
#define CAN0_ISSR_CH0_BIT 0
#define CAN0_ISSR_CH1_MASK 0x2U
#define CAN0_ISSR_CH1 0x2U
#define CAN0_ISSR_CH1_BIT 1
#define CAN0_ISSR_CH2_MASK 0x4U
#define CAN0_ISSR_CH2 0x4U
#define CAN0_ISSR_CH2_BIT 2
#define CAN0_ISSR_CH3_MASK 0x8U
#define CAN0_ISSR_CH3 0x8U
#define CAN0_ISSR_CH3_BIT 3
#define CAN0_ISSR_CH4_MASK 0x10U
#define CAN0_ISSR_CH4 0x10U
#define CAN0_ISSR_CH4_BIT 4
#define CAN0_ISSR_CH5_MASK 0x20U
#define CAN0_ISSR_CH5 0x20U
#define CAN0_ISSR_CH5_BIT 5
#define CAN0_ISSR_CH6_MASK 0x40U
#define CAN0_ISSR_CH6 0x40U
#define CAN0_ISSR_CH6_BIT 6
#define CAN0_ISSR_CH7_MASK 0x80U
#define CAN0_ISSR_CH7 0x80U
#define CAN0_ISSR_CH7_BIT 7
#define CAN0_ISSR_CH8_MASK 0x100U
#define CAN0_ISSR_CH8 0x100U
#define CAN0_ISSR_CH8_BIT 8
#define CAN0_ISSR_CH9_MASK 0x200U
#define CAN0_ISSR_CH9 0x200U
#define CAN0_ISSR_CH9_BIT 9
#define CAN0_ISSR_CH10_MASK 0x400U
#define CAN0_ISSR_CH10 0x400U
#define CAN0_ISSR_CH10_BIT 10
#define CAN0_ISSR_CH11_MASK 0x800U
#define CAN0_ISSR_CH11 0x800U
#define CAN0_ISSR_CH11_BIT 11
#define CAN0_ISSR_CH12_MASK 0x1000U
#define CAN0_ISSR_CH12 0x1000U
#define CAN0_ISSR_CH12_BIT 12
#define CAN0_ISSR_CH13_MASK 0x2000U
#define CAN0_ISSR_CH13 0x2000U
#define CAN0_ISSR_CH13_BIT 13
#define CAN0_ISSR_CH14_MASK 0x4000U
#define CAN0_ISSR_CH14 0x4000U
#define CAN0_ISSR_CH14_BIT 14
#define CAN0_ISSR_CH15_MASK 0x8000U
#define CAN0_ISSR_CH15 0x8000U
#define CAN0_ISSR_CH15_BIT 15

#define CAN0_SIER (*(volatile unsigned long *)0xFFFD4088)
#define CAN0_SIER_OFFSET 0x88
#define CAN0_SIER_CH0_MASK 0x1U
#define CAN0_SIER_CH0 0x1U
#define CAN0_SIER_CH0_BIT 0
#define CAN0_SIER_CH1_MASK 0x2U
#define CAN0_SIER_CH1 0x2U
#define CAN0_SIER_CH1_BIT 1
#define CAN0_SIER_CH2_MASK 0x4U
#define CAN0_SIER_CH2 0x4U
#define CAN0_SIER_CH2_BIT 2
#define CAN0_SIER_CH3_MASK 0x8U
#define CAN0_SIER_CH3 0x8U
#define CAN0_SIER_CH3_BIT 3
#define CAN0_SIER_CH4_MASK 0x10U
#define CAN0_SIER_CH4 0x10U
#define CAN0_SIER_CH4_BIT 4
#define CAN0_SIER_CH5_MASK 0x20U
#define CAN0_SIER_CH5 0x20U
#define CAN0_SIER_CH5_BIT 5
#define CAN0_SIER_CH6_MASK 0x40U
#define CAN0_SIER_CH6 0x40U
#define CAN0_SIER_CH6_BIT 6
#define CAN0_SIER_CH7_MASK 0x80U
#define CAN0_SIER_CH7 0x80U
#define CAN0_SIER_CH7_BIT 7
#define CAN0_SIER_CH8_MASK 0x100U
#define CAN0_SIER_CH8 0x100U
#define CAN0_SIER_CH8_BIT 8
#define CAN0_SIER_CH9_MASK 0x200U
#define CAN0_SIER_CH9 0x200U
#define CAN0_SIER_CH9_BIT 9
#define CAN0_SIER_CH10_MASK 0x400U
#define CAN0_SIER_CH10 0x400U
#define CAN0_SIER_CH10_BIT 10
#define CAN0_SIER_CH11_MASK 0x800U
#define CAN0_SIER_CH11 0x800U
#define CAN0_SIER_CH11_BIT 11
#define CAN0_SIER_CH12_MASK 0x1000U
#define CAN0_SIER_CH12 0x1000U
#define CAN0_SIER_CH12_BIT 12
#define CAN0_SIER_CH13_MASK 0x2000U
#define CAN0_SIER_CH13 0x2000U
#define CAN0_SIER_CH13_BIT 13
#define CAN0_SIER_CH14_MASK 0x4000U
#define CAN0_SIER_CH14 0x4000U
#define CAN0_SIER_CH14_BIT 14
#define CAN0_SIER_CH15_MASK 0x8000U
#define CAN0_SIER_CH15 0x8000U
#define CAN0_SIER_CH15_BIT 15

#define CAN0_SIDR (*(volatile unsigned long *)0xFFFD408C)
#define CAN0_SIDR_OFFSET 0x8C
#define CAN0_SIDR_CH0_MASK 0x1U
#define CAN0_SIDR_CH0 0x1U
#define CAN0_SIDR_CH0_BIT 0
#define CAN0_SIDR_CH1_MASK 0x2U
#define CAN0_SIDR_CH1 0x2U
#define CAN0_SIDR_CH1_BIT 1
#define CAN0_SIDR_CH2_MASK 0x4U
#define CAN0_SIDR_CH2 0x4U
#define CAN0_SIDR_CH2_BIT 2
#define CAN0_SIDR_CH3_MASK 0x8U
#define CAN0_SIDR_CH3 0x8U
#define CAN0_SIDR_CH3_BIT 3
#define CAN0_SIDR_CH4_MASK 0x10U
#define CAN0_SIDR_CH4 0x10U
#define CAN0_SIDR_CH4_BIT 4
#define CAN0_SIDR_CH5_MASK 0x20U
#define CAN0_SIDR_CH5 0x20U
#define CAN0_SIDR_CH5_BIT 5
#define CAN0_SIDR_CH6_MASK 0x40U
#define CAN0_SIDR_CH6 0x40U
#define CAN0_SIDR_CH6_BIT 6
#define CAN0_SIDR_CH7_MASK 0x80U
#define CAN0_SIDR_CH7 0x80U
#define CAN0_SIDR_CH7_BIT 7
#define CAN0_SIDR_CH8_MASK 0x100U
#define CAN0_SIDR_CH8 0x100U
#define CAN0_SIDR_CH8_BIT 8
#define CAN0_SIDR_CH9_MASK 0x200U
#define CAN0_SIDR_CH9 0x200U
#define CAN0_SIDR_CH9_BIT 9
#define CAN0_SIDR_CH10_MASK 0x400U
#define CAN0_SIDR_CH10 0x400U
#define CAN0_SIDR_CH10_BIT 10
#define CAN0_SIDR_CH11_MASK 0x800U
#define CAN0_SIDR_CH11 0x800U
#define CAN0_SIDR_CH11_BIT 11
#define CAN0_SIDR_CH12_MASK 0x1000U
#define CAN0_SIDR_CH12 0x1000U
#define CAN0_SIDR_CH12_BIT 12
#define CAN0_SIDR_CH13_MASK 0x2000U
#define CAN0_SIDR_CH13 0x2000U
#define CAN0_SIDR_CH13_BIT 13
#define CAN0_SIDR_CH14_MASK 0x4000U
#define CAN0_SIDR_CH14 0x4000U
#define CAN0_SIDR_CH14_BIT 14
#define CAN0_SIDR_CH15_MASK 0x8000U
#define CAN0_SIDR_CH15 0x8000U
#define CAN0_SIDR_CH15_BIT 15

#define CAN0_SIMR (*(volatile unsigned long *)0xFFFD4090)
#define CAN0_SIMR_OFFSET 0x90
#define CAN0_SIMR_CH0_MASK 0x1U
#define CAN0_SIMR_CH0 0x1U
#define CAN0_SIMR_CH0_BIT 0
#define CAN0_SIMR_CH1_MASK 0x2U
#define CAN0_SIMR_CH1 0x2U
#define CAN0_SIMR_CH1_BIT 1
#define CAN0_SIMR_CH2_MASK 0x4U
#define CAN0_SIMR_CH2 0x4U
#define CAN0_SIMR_CH2_BIT 2
#define CAN0_SIMR_CH3_MASK 0x8U
#define CAN0_SIMR_CH3 0x8U
#define CAN0_SIMR_CH3_BIT 3
#define CAN0_SIMR_CH4_MASK 0x10U
#define CAN0_SIMR_CH4 0x10U
#define CAN0_SIMR_CH4_BIT 4
#define CAN0_SIMR_CH5_MASK 0x20U
#define CAN0_SIMR_CH5 0x20U
#define CAN0_SIMR_CH5_BIT 5
#define CAN0_SIMR_CH6_MASK 0x40U
#define CAN0_SIMR_CH6 0x40U
#define CAN0_SIMR_CH6_BIT 6
#define CAN0_SIMR_CH7_MASK 0x80U
#define CAN0_SIMR_CH7 0x80U
#define CAN0_SIMR_CH7_BIT 7
#define CAN0_SIMR_CH8_MASK 0x100U
#define CAN0_SIMR_CH8 0x100U
#define CAN0_SIMR_CH8_BIT 8
#define CAN0_SIMR_CH9_MASK 0x200U
#define CAN0_SIMR_CH9 0x200U
#define CAN0_SIMR_CH9_BIT 9
#define CAN0_SIMR_CH10_MASK 0x400U
#define CAN0_SIMR_CH10 0x400U
#define CAN0_SIMR_CH10_BIT 10
#define CAN0_SIMR_CH11_MASK 0x800U
#define CAN0_SIMR_CH11 0x800U
#define CAN0_SIMR_CH11_BIT 11
#define CAN0_SIMR_CH12_MASK 0x1000U
#define CAN0_SIMR_CH12 0x1000U
#define CAN0_SIMR_CH12_BIT 12
#define CAN0_SIMR_CH13_MASK 0x2000U
#define CAN0_SIMR_CH13 0x2000U
#define CAN0_SIMR_CH13_BIT 13
#define CAN0_SIMR_CH14_MASK 0x4000U
#define CAN0_SIMR_CH14 0x4000U
#define CAN0_SIMR_CH14_BIT 14
#define CAN0_SIMR_CH15_MASK 0x8000U
#define CAN0_SIMR_CH15 0x8000U
#define CAN0_SIMR_CH15_BIT 15

#define CAN0_DRA0 (*(volatile unsigned long *)0xFFFD4100)
#define CAN0_DRA0_OFFSET 0x100
#define CAN0_DRA0_DATA0_MASK 0xFFU
#define CAN0_DRA0_DATA0_BIT 0
#define CAN0_DRA0_DATA1_MASK 0xFF00U
#define CAN0_DRA0_DATA1_BIT 8
#define CAN0_DRA0_DATA2_MASK 0xFF0000U
#define CAN0_DRA0_DATA2_BIT 16
#define CAN0_DRA0_DATA3_MASK 0xFF000000U
#define CAN0_DRA0_DATA3_BIT 24

#define CAN0_DRB0 (*(volatile unsigned long *)0xFFFD4104)
#define CAN0_DRB0_OFFSET 0x104
#define CAN0_DRB0_DATA4_MASK 0xFFU
#define CAN0_DRB0_DATA4_BIT 0
#define CAN0_DRB0_DATA5_MASK 0xFF00U
#define CAN0_DRB0_DATA5_BIT 8
#define CAN0_DRB0_DATA6_MASK 0xFF0000U
#define CAN0_DRB0_DATA6_BIT 16
#define CAN0_DRB0_DATA7_MASK 0xFF000000U
#define CAN0_DRB0_DATA7_BIT 24

#define CAN0_MSK0 (*(volatile unsigned long *)0xFFFD4108)
#define CAN0_MSK0_OFFSET 0x108
#define CAN0_MSK0_MASK_MASK 0x1FFFFFFFU
#define CAN0_MSK0_MASK_BIT 0
#define CAN0_MSK0_MRB_MASK 0x60000000U
#define CAN0_MSK0_MRB_BIT 29
#define CAN0_MSK0_MRTR_MASK 0x80000000U
#define CAN0_MSK0_MRTR 0x80000000U
#define CAN0_MSK0_MRTR_BIT 31

#define CAN0_IR0 (*(volatile unsigned long *)0xFFFD410C)
#define CAN0_IR0_OFFSET 0x10C
#define CAN0_IR0_ID_MASK 0x1FFFFFFFU
#define CAN0_IR0_ID_BIT 0
#define CAN0_IR0_RB_MASK 0x60000000U
#define CAN0_IR0_RB_BIT 29
#define CAN0_IR0_RTR_MASK 0x80000000U
#define CAN0_IR0_RTR 0x80000000U
#define CAN0_IR0_RTR_BIT 31

#define CAN0_CR0 (*(volatile unsigned long *)0xFFFD4110)
#define CAN0_CR0_OFFSET 0x110
#define CAN0_CR0_DLC_MASK 0xFU
#define CAN0_CR0_DLC_BIT 0
#define CAN0_CR0_IDE_MASK 0x10U
#define CAN0_CR0_IDE 0x10U
#define CAN0_CR0_IDE_BIT 4
#define CAN0_CR0_RPLYV_MASK 0x20U
#define CAN0_CR0_RPLYV 0x20U
#define CAN0_CR0_RPLYV_BIT 5
#define CAN0_CR0_PCB_MASK 0x40U
#define CAN0_CR0_PCB 0x40U
#define CAN0_CR0_PCB_BIT 6
#define CAN0_CR0_CHANEN_MASK 0x80U
#define CAN0_CR0_CHANEN 0x80U
#define CAN0_CR0_CHANEN_BIT 7
#define CAN0_CR0_OVERWRITE_MASK 0x100U
#define CAN0_CR0_OVERWRITE 0x100U
#define CAN0_CR0_OVERWRITE_BIT 8

#define CAN0_CR0 (*(volatile unsigned long *)0xFFFD4114)
#define CAN0_CR0_OFFSET 0x114
#define CAN0_CR0_STAMP_MASK 0x0U
#define CAN0_CR0_STAMP_BIT 0

#define CAN0_CSR0 (*(volatile unsigned long *)0xFFFD4118)
#define CAN0_CSR0_OFFSET 0x118
#define CAN0_CSR0_ACK_MASK 0x1U
#define CAN0_CSR0_ACK 0x1U
#define CAN0_CSR0_ACK_BIT 0
#define CAN0_CSR0_FRAME_MASK 0x2U
#define CAN0_CSR0_FRAME 0x2U
#define CAN0_CSR0_FRAME_BIT 1
#define CAN0_CSR0_CRC_MASK 0x4U
#define CAN0_CSR0_CRC 0x4U
#define CAN0_CSR0_CRC_BIT 2
#define CAN0_CSR0_STUFF_MASK 0x8U
#define CAN0_CSR0_STUFF 0x8U
#define CAN0_CSR0_STUFF_BIT 3
#define CAN0_CSR0_BUS_MASK 0x10U
#define CAN0_CSR0_BUS 0x10U
#define CAN0_CSR0_BUS_BIT 4
#define CAN0_CSR0_RXOK_MASK 0x20U
#define CAN0_CSR0_RXOK 0x20U
#define CAN0_CSR0_RXOK_BIT 5
#define CAN0_CSR0_TXOK_MASK 0x40U
#define CAN0_CSR0_TXOK 0x40U
#define CAN0_CSR0_TXOK_BIT 6
#define CAN0_CSR0_RFRAME_MASK 0x80U
#define CAN0_CSR0_RFRAME 0x80U
#define CAN0_CSR0_RFRAME_BIT 7
#define CAN0_CSR0_DLCW_MASK 0x200U
#define CAN0_CSR0_DLCW 0x200U
#define CAN0_CSR0_DLCW_BIT 9
#define CAN0_CSR0_FILLED_MASK 0x400U
#define CAN0_CSR0_FILLED 0x400U
#define CAN0_CSR0_FILLED_BIT 10
#define CAN0_CSR0_OVRUN_MASK 0x800U
#define CAN0_CSR0_OVRUN 0x800U
#define CAN0_CSR0_OVRUN_BIT 11

#define CAN0_SR0 (*(volatile unsigned long *)0xFFFD411C)
#define CAN0_SR0_OFFSET 0x11C
#define CAN0_SR0_ACK_MASK 0x1U
#define CAN0_SR0_ACK 0x1U
#define CAN0_SR0_ACK_BIT 0
#define CAN0_SR0_FRAME_MASK 0x2U
#define CAN0_SR0_FRAME 0x2U
#define CAN0_SR0_FRAME_BIT 1
#define CAN0_SR0_CRC_MASK 0x4U
#define CAN0_SR0_CRC 0x4U
#define CAN0_SR0_CRC_BIT 2
#define CAN0_SR0_STUFF_MASK 0x8U
#define CAN0_SR0_STUFF 0x8U
#define CAN0_SR0_STUFF_BIT 3
#define CAN0_SR0_BUS_MASK 0x10U
#define CAN0_SR0_BUS 0x10U
#define CAN0_SR0_BUS_BIT 4
#define CAN0_SR0_RXOK_MASK 0x20U
#define CAN0_SR0_RXOK 0x20U
#define CAN0_SR0_RXOK_BIT 5
#define CAN0_SR0_TXOK_MASK 0x40U
#define CAN0_SR0_TXOK 0x40U
#define CAN0_SR0_TXOK_BIT 6
#define CAN0_SR0_RFRAME_MASK 0x80U
#define CAN0_SR0_RFRAME 0x80U
#define CAN0_SR0_RFRAME_BIT 7
#define CAN0_SR0_DLCW_MASK 0x200U
#define CAN0_SR0_DLCW 0x200U
#define CAN0_SR0_DLCW_BIT 9
#define CAN0_SR0_FILLED_MASK 0x400U
#define CAN0_SR0_FILLED 0x400U
#define CAN0_SR0_FILLED_BIT 10
#define CAN0_SR0_OVRUN_MASK 0x800U
#define CAN0_SR0_OVRUN 0x800U
#define CAN0_SR0_OVRUN_BIT 11

#define CAN0_IER0 (*(volatile unsigned long *)0xFFFD4120)
#define CAN0_IER0_OFFSET 0x120
#define CAN0_IER0_ACK_MASK 0x1U
#define CAN0_IER0_ACK 0x1U
#define CAN0_IER0_ACK_BIT 0
#define CAN0_IER0_FRAME_MASK 0x2U
#define CAN0_IER0_FRAME 0x2U
#define CAN0_IER0_FRAME_BIT 1
#define CAN0_IER0_CRC_MASK 0x4U
#define CAN0_IER0_CRC 0x4U
#define CAN0_IER0_CRC_BIT 2
#define CAN0_IER0_STUFF_MASK 0x8U
#define CAN0_IER0_STUFF 0x8U
#define CAN0_IER0_STUFF_BIT 3
#define CAN0_IER0_BUS_MASK 0x10U
#define CAN0_IER0_BUS 0x10U
#define CAN0_IER0_BUS_BIT 4
#define CAN0_IER0_RXOK_MASK 0x20U
#define CAN0_IER0_RXOK 0x20U
#define CAN0_IER0_RXOK_BIT 5
#define CAN0_IER0_TXOK_MASK 0x40U
#define CAN0_IER0_TXOK 0x40U
#define CAN0_IER0_TXOK_BIT 6
#define CAN0_IER0_RFRAME_MASK 0x80U
#define CAN0_IER0_RFRAME 0x80U
#define CAN0_IER0_RFRAME_BIT 7

#define CAN0_IDR0 (*(volatile unsigned long *)0xFFFD4124)
#define CAN0_IDR0_OFFSET 0x124
#define CAN0_IDR0_ACK_MASK 0x1U
#define CAN0_IDR0_ACK 0x1U
#define CAN0_IDR0_ACK_BIT 0
#define CAN0_IDR0_FRAME_MASK 0x2U
#define CAN0_IDR0_FRAME 0x2U
#define CAN0_IDR0_FRAME_BIT 1
#define CAN0_IDR0_CRC_MASK 0x4U
#define CAN0_IDR0_CRC 0x4U
#define CAN0_IDR0_CRC_BIT 2
#define CAN0_IDR0_STUFF_MASK 0x8U
#define CAN0_IDR0_STUFF 0x8U
#define CAN0_IDR0_STUFF_BIT 3
#define CAN0_IDR0_BUS_MASK 0x10U
#define CAN0_IDR0_BUS 0x10U
#define CAN0_IDR0_BUS_BIT 4
#define CAN0_IDR0_RXOK_MASK 0x20U
#define CAN0_IDR0_RXOK 0x20U
#define CAN0_IDR0_RXOK_BIT 5
#define CAN0_IDR0_TXOK_MASK 0x40U
#define CAN0_IDR0_TXOK 0x40U
#define CAN0_IDR0_TXOK_BIT 6
#define CAN0_IDR0_RFRAME_MASK 0x80U
#define CAN0_IDR0_RFRAME 0x80U
#define CAN0_IDR0_RFRAME_BIT 7

#define CAN0_IMR0 (*(volatile unsigned long *)0xFFFD4128)
#define CAN0_IMR0_OFFSET 0x128
#define CAN0_IMR0_ACK_MASK 0x1U
#define CAN0_IMR0_ACK 0x1U
#define CAN0_IMR0_ACK_BIT 0
#define CAN0_IMR0_FRAME_MASK 0x2U
#define CAN0_IMR0_FRAME 0x2U
#define CAN0_IMR0_FRAME_BIT 1
#define CAN0_IMR0_CRC_MASK 0x4U
#define CAN0_IMR0_CRC 0x4U
#define CAN0_IMR0_CRC_BIT 2
#define CAN0_IMR0_STUFF_MASK 0x8U
#define CAN0_IMR0_STUFF 0x8U
#define CAN0_IMR0_STUFF_BIT 3
#define CAN0_IMR0_BUS_MASK 0x10U
#define CAN0_IMR0_BUS 0x10U
#define CAN0_IMR0_BUS_BIT 4
#define CAN0_IMR0_RXOK_MASK 0x20U
#define CAN0_IMR0_RXOK 0x20U
#define CAN0_IMR0_RXOK_BIT 5
#define CAN0_IMR0_TXOK_MASK 0x40U
#define CAN0_IMR0_TXOK 0x40U
#define CAN0_IMR0_TXOK_BIT 6
#define CAN0_IMR0_RFRAME_MASK 0x80U
#define CAN0_IMR0_RFRAME 0x80U
#define CAN0_IMR0_RFRAME_BIT 7

#define CAN0_DRA1 (*(volatile unsigned long *)0xFFFD4140)
#define CAN0_DRA1_OFFSET 0x140
#define CAN0_DRA1_DATA0_MASK 0xFFU
#define CAN0_DRA1_DATA0_BIT 0
#define CAN0_DRA1_DATA1_MASK 0xFF00U
#define CAN0_DRA1_DATA1_BIT 8
#define CAN0_DRA1_DATA2_MASK 0xFF0000U
#define CAN0_DRA1_DATA2_BIT 16
#define CAN0_DRA1_DATA3_MASK 0xFF000000U
#define CAN0_DRA1_DATA3_BIT 24

#define CAN0_DRB1 (*(volatile unsigned long *)0xFFFD4144)
#define CAN0_DRB1_OFFSET 0x144
#define CAN0_DRB1_DATA4_MASK 0xFFU
#define CAN0_DRB1_DATA4_BIT 0
#define CAN0_DRB1_DATA5_MASK 0xFF00U
#define CAN0_DRB1_DATA5_BIT 8
#define CAN0_DRB1_DATA6_MASK 0xFF0000U
#define CAN0_DRB1_DATA6_BIT 16
#define CAN0_DRB1_DATA7_MASK 0xFF000000U
#define CAN0_DRB1_DATA7_BIT 24

#define CAN0_MSK1 (*(volatile unsigned long *)0xFFFD4148)
#define CAN0_MSK1_OFFSET 0x148
#define CAN0_MSK1_MASK_MASK 0x1FFFFFFFU
#define CAN0_MSK1_MASK_BIT 0
#define CAN0_MSK1_MRB_MASK 0x60000000U
#define CAN0_MSK1_MRB_BIT 29
#define CAN0_MSK1_MRTR_MASK 0x80000000U
#define CAN0_MSK1_MRTR 0x80000000U
#define CAN0_MSK1_MRTR_BIT 31

#define CAN0_IR1 (*(volatile unsigned long *)0xFFFD414C)
#define CAN0_IR1_OFFSET 0x14C
#define CAN0_IR1_ID_MASK 0x1FFFFFFFU
#define CAN0_IR1_ID_BIT 0
#define CAN0_IR1_RB_MASK 0x60000000U
#define CAN0_IR1_RB_BIT 29
#define CAN0_IR1_RTR_MASK 0x80000000U
#define CAN0_IR1_RTR 0x80000000U
#define CAN0_IR1_RTR_BIT 31

#define CAN0_CR1 (*(volatile unsigned long *)0xFFFD4150)
#define CAN0_CR1_OFFSET 0x150
#define CAN0_CR1_DLC_MASK 0xFU
#define CAN0_CR1_DLC_BIT 0
#define CAN0_CR1_IDE_MASK 0x10U
#define CAN0_CR1_IDE 0x10U
#define CAN0_CR1_IDE_BIT 4
#define CAN0_CR1_RPLYV_MASK 0x20U
#define CAN0_CR1_RPLYV 0x20U
#define CAN0_CR1_RPLYV_BIT 5
#define CAN0_CR1_PCB_MASK 0x40U
#define CAN0_CR1_PCB 0x40U
#define CAN0_CR1_PCB_BIT 6
#define CAN0_CR1_CHANEN_MASK 0x80U
#define CAN0_CR1_CHANEN 0x80U
#define CAN0_CR1_CHANEN_BIT 7
#define CAN0_CR1_OVERWRITE_MASK 0x100U
#define CAN0_CR1_OVERWRITE 0x100U
#define CAN0_CR1_OVERWRITE_BIT 8

#define CAN0_CR1 (*(volatile unsigned long *)0xFFFD4154)
#define CAN0_CR1_OFFSET 0x154
#define CAN0_CR1_STAMP_MASK 0x0U
#define CAN0_CR1_STAMP_BIT 0

#define CAN0_CSR1 (*(volatile unsigned long *)0xFFFD4158)
#define CAN0_CSR1_OFFSET 0x158
#define CAN0_CSR1_ACK_MASK 0x1U
#define CAN0_CSR1_ACK 0x1U
#define CAN0_CSR1_ACK_BIT 0
#define CAN0_CSR1_FRAME_MASK 0x2U
#define CAN0_CSR1_FRAME 0x2U
#define CAN0_CSR1_FRAME_BIT 1
#define CAN0_CSR1_CRC_MASK 0x4U
#define CAN0_CSR1_CRC 0x4U
#define CAN0_CSR1_CRC_BIT 2
#define CAN0_CSR1_STUFF_MASK 0x8U
#define CAN0_CSR1_STUFF 0x8U
#define CAN0_CSR1_STUFF_BIT 3
#define CAN0_CSR1_BUS_MASK 0x10U
#define CAN0_CSR1_BUS 0x10U
#define CAN0_CSR1_BUS_BIT 4
#define CAN0_CSR1_RXOK_MASK 0x20U
#define CAN0_CSR1_RXOK 0x20U
#define CAN0_CSR1_RXOK_BIT 5
#define CAN0_CSR1_TXOK_MASK 0x40U
#define CAN0_CSR1_TXOK 0x40U
#define CAN0_CSR1_TXOK_BIT 6
#define CAN0_CSR1_RFRAME_MASK 0x80U
#define CAN0_CSR1_RFRAME 0x80U
#define CAN0_CSR1_RFRAME_BIT 7
#define CAN0_CSR1_DLCW_MASK 0x200U
#define CAN0_CSR1_DLCW 0x200U
#define CAN0_CSR1_DLCW_BIT 9
#define CAN0_CSR1_FILLED_MASK 0x400U
#define CAN0_CSR1_FILLED 0x400U
#define CAN0_CSR1_FILLED_BIT 10
#define CAN0_CSR1_OVRUN_MASK 0x800U
#define CAN0_CSR1_OVRUN 0x800U
#define CAN0_CSR1_OVRUN_BIT 11

#define CAN0_SR1 (*(volatile unsigned long *)0xFFFD415C)
#define CAN0_SR1_OFFSET 0x15C
#define CAN0_SR1_ACK_MASK 0x1U
#define CAN0_SR1_ACK 0x1U
#define CAN0_SR1_ACK_BIT 0
#define CAN0_SR1_FRAME_MASK 0x2U
#define CAN0_SR1_FRAME 0x2U
#define CAN0_SR1_FRAME_BIT 1
#define CAN0_SR1_CRC_MASK 0x4U
#define CAN0_SR1_CRC 0x4U
#define CAN0_SR1_CRC_BIT 2
#define CAN0_SR1_STUFF_MASK 0x8U
#define CAN0_SR1_STUFF 0x8U
#define CAN0_SR1_STUFF_BIT 3
#define CAN0_SR1_BUS_MASK 0x10U
#define CAN0_SR1_BUS 0x10U
#define CAN0_SR1_BUS_BIT 4
#define CAN0_SR1_RXOK_MASK 0x20U
#define CAN0_SR1_RXOK 0x20U
#define CAN0_SR1_RXOK_BIT 5
#define CAN0_SR1_TXOK_MASK 0x40U
#define CAN0_SR1_TXOK 0x40U
#define CAN0_SR1_TXOK_BIT 6
#define CAN0_SR1_RFRAME_MASK 0x80U
#define CAN0_SR1_RFRAME 0x80U
#define CAN0_SR1_RFRAME_BIT 7
#define CAN0_SR1_DLCW_MASK 0x200U
#define CAN0_SR1_DLCW 0x200U
#define CAN0_SR1_DLCW_BIT 9
#define CAN0_SR1_FILLED_MASK 0x400U
#define CAN0_SR1_FILLED 0x400U
#define CAN0_SR1_FILLED_BIT 10
#define CAN0_SR1_OVRUN_MASK 0x800U
#define CAN0_SR1_OVRUN 0x800U
#define CAN0_SR1_OVRUN_BIT 11

#define CAN0_IER1 (*(volatile unsigned long *)0xFFFD4160)
#define CAN0_IER1_OFFSET 0x160
#define CAN0_IER1_ACK_MASK 0x1U
#define CAN0_IER1_ACK 0x1U
#define CAN0_IER1_ACK_BIT 0
#define CAN0_IER1_FRAME_MASK 0x2U
#define CAN0_IER1_FRAME 0x2U
#define CAN0_IER1_FRAME_BIT 1
#define CAN0_IER1_CRC_MASK 0x4U
#define CAN0_IER1_CRC 0x4U
#define CAN0_IER1_CRC_BIT 2
#define CAN0_IER1_STUFF_MASK 0x8U
#define CAN0_IER1_STUFF 0x8U
#define CAN0_IER1_STUFF_BIT 3
#define CAN0_IER1_BUS_MASK 0x10U
#define CAN0_IER1_BUS 0x10U
#define CAN0_IER1_BUS_BIT 4
#define CAN0_IER1_RXOK_MASK 0x20U
#define CAN0_IER1_RXOK 0x20U
#define CAN0_IER1_RXOK_BIT 5
#define CAN0_IER1_TXOK_MASK 0x40U
#define CAN0_IER1_TXOK 0x40U
#define CAN0_IER1_TXOK_BIT 6
#define CAN0_IER1_RFRAME_MASK 0x80U
#define CAN0_IER1_RFRAME 0x80U
#define CAN0_IER1_RFRAME_BIT 7

#define CAN0_IDR1 (*(volatile unsigned long *)0xFFFD4164)
#define CAN0_IDR1_OFFSET 0x164
#define CAN0_IDR1_ACK_MASK 0x1U
#define CAN0_IDR1_ACK 0x1U
#define CAN0_IDR1_ACK_BIT 0
#define CAN0_IDR1_FRAME_MASK 0x2U
#define CAN0_IDR1_FRAME 0x2U
#define CAN0_IDR1_FRAME_BIT 1
#define CAN0_IDR1_CRC_MASK 0x4U
#define CAN0_IDR1_CRC 0x4U
#define CAN0_IDR1_CRC_BIT 2
#define CAN0_IDR1_STUFF_MASK 0x8U
#define CAN0_IDR1_STUFF 0x8U
#define CAN0_IDR1_STUFF_BIT 3
#define CAN0_IDR1_BUS_MASK 0x10U
#define CAN0_IDR1_BUS 0x10U
#define CAN0_IDR1_BUS_BIT 4
#define CAN0_IDR1_RXOK_MASK 0x20U
#define CAN0_IDR1_RXOK 0x20U
#define CAN0_IDR1_RXOK_BIT 5
#define CAN0_IDR1_TXOK_MASK 0x40U
#define CAN0_IDR1_TXOK 0x40U
#define CAN0_IDR1_TXOK_BIT 6
#define CAN0_IDR1_RFRAME_MASK 0x80U
#define CAN0_IDR1_RFRAME 0x80U
#define CAN0_IDR1_RFRAME_BIT 7

#define CAN0_IMR1 (*(volatile unsigned long *)0xFFFD4168)
#define CAN0_IMR1_OFFSET 0x168
#define CAN0_IMR1_ACK_MASK 0x1U
#define CAN0_IMR1_ACK 0x1U
#define CAN0_IMR1_ACK_BIT 0
#define CAN0_IMR1_FRAME_MASK 0x2U
#define CAN0_IMR1_FRAME 0x2U
#define CAN0_IMR1_FRAME_BIT 1
#define CAN0_IMR1_CRC_MASK 0x4U
#define CAN0_IMR1_CRC 0x4U
#define CAN0_IMR1_CRC_BIT 2
#define CAN0_IMR1_STUFF_MASK 0x8U
#define CAN0_IMR1_STUFF 0x8U
#define CAN0_IMR1_STUFF_BIT 3
#define CAN0_IMR1_BUS_MASK 0x10U
#define CAN0_IMR1_BUS 0x10U
#define CAN0_IMR1_BUS_BIT 4
#define CAN0_IMR1_RXOK_MASK 0x20U
#define CAN0_IMR1_RXOK 0x20U
#define CAN0_IMR1_RXOK_BIT 5
#define CAN0_IMR1_TXOK_MASK 0x40U
#define CAN0_IMR1_TXOK 0x40U
#define CAN0_IMR1_TXOK_BIT 6
#define CAN0_IMR1_RFRAME_MASK 0x80U
#define CAN0_IMR1_RFRAME 0x80U
#define CAN0_IMR1_RFRAME_BIT 7

#define CAN0_DRA2 (*(volatile unsigned long *)0xFFFD4180)
#define CAN0_DRA2_OFFSET 0x180
#define CAN0_DRA2_DATA0_MASK 0xFFU
#define CAN0_DRA2_DATA0_BIT 0
#define CAN0_DRA2_DATA1_MASK 0xFF00U
#define CAN0_DRA2_DATA1_BIT 8
#define CAN0_DRA2_DATA2_MASK 0xFF0000U
#define CAN0_DRA2_DATA2_BIT 16
#define CAN0_DRA2_DATA3_MASK 0xFF000000U
#define CAN0_DRA2_DATA3_BIT 24

#define CAN0_DRB2 (*(volatile unsigned long *)0xFFFD4184)
#define CAN0_DRB2_OFFSET 0x184
#define CAN0_DRB2_DATA4_MASK 0xFFU
#define CAN0_DRB2_DATA4_BIT 0
#define CAN0_DRB2_DATA5_MASK 0xFF00U
#define CAN0_DRB2_DATA5_BIT 8
#define CAN0_DRB2_DATA6_MASK 0xFF0000U
#define CAN0_DRB2_DATA6_BIT 16
#define CAN0_DRB2_DATA7_MASK 0xFF000000U
#define CAN0_DRB2_DATA7_BIT 24

#define CAN0_MSK2 (*(volatile unsigned long *)0xFFFD4188)
#define CAN0_MSK2_OFFSET 0x188
#define CAN0_MSK2_MASK_MASK 0x1FFFFFFFU
#define CAN0_MSK2_MASK_BIT 0
#define CAN0_MSK2_MRB_MASK 0x60000000U
#define CAN0_MSK2_MRB_BIT 29
#define CAN0_MSK2_MRTR_MASK 0x80000000U
#define CAN0_MSK2_MRTR 0x80000000U
#define CAN0_MSK2_MRTR_BIT 31

#define CAN0_IR2 (*(volatile unsigned long *)0xFFFD418C)
#define CAN0_IR2_OFFSET 0x18C
#define CAN0_IR2_ID_MASK 0x1FFFFFFFU
#define CAN0_IR2_ID_BIT 0
#define CAN0_IR2_RB_MASK 0x60000000U
#define CAN0_IR2_RB_BIT 29
#define CAN0_IR2_RTR_MASK 0x80000000U
#define CAN0_IR2_RTR 0x80000000U
#define CAN0_IR2_RTR_BIT 31

#define CAN0_CR2 (*(volatile unsigned long *)0xFFFD4190)
#define CAN0_CR2_OFFSET 0x190
#define CAN0_CR2_DLC_MASK 0xFU
#define CAN0_CR2_DLC_BIT 0
#define CAN0_CR2_IDE_MASK 0x10U
#define CAN0_CR2_IDE 0x10U
#define CAN0_CR2_IDE_BIT 4
#define CAN0_CR2_RPLYV_MASK 0x20U
#define CAN0_CR2_RPLYV 0x20U
#define CAN0_CR2_RPLYV_BIT 5
#define CAN0_CR2_PCB_MASK 0x40U
#define CAN0_CR2_PCB 0x40U
#define CAN0_CR2_PCB_BIT 6
#define CAN0_CR2_CHANEN_MASK 0x80U
#define CAN0_CR2_CHANEN 0x80U
#define CAN0_CR2_CHANEN_BIT 7
#define CAN0_CR2_OVERWRITE_MASK 0x100U
#define CAN0_CR2_OVERWRITE 0x100U
#define CAN0_CR2_OVERWRITE_BIT 8

#define CAN0_CR2 (*(volatile unsigned long *)0xFFFD4194)
#define CAN0_CR2_OFFSET 0x194
#define CAN0_CR2_STAMP_MASK 0x0U
#define CAN0_CR2_STAMP_BIT 0

#define CAN0_CSR2 (*(volatile unsigned long *)0xFFFD4198)
#define CAN0_CSR2_OFFSET 0x198
#define CAN0_CSR2_ACK_MASK 0x1U
#define CAN0_CSR2_ACK 0x1U
#define CAN0_CSR2_ACK_BIT 0
#define CAN0_CSR2_FRAME_MASK 0x2U
#define CAN0_CSR2_FRAME 0x2U
#define CAN0_CSR2_FRAME_BIT 1
#define CAN0_CSR2_CRC_MASK 0x4U
#define CAN0_CSR2_CRC 0x4U
#define CAN0_CSR2_CRC_BIT 2
#define CAN0_CSR2_STUFF_MASK 0x8U
#define CAN0_CSR2_STUFF 0x8U
#define CAN0_CSR2_STUFF_BIT 3
#define CAN0_CSR2_BUS_MASK 0x10U
#define CAN0_CSR2_BUS 0x10U
#define CAN0_CSR2_BUS_BIT 4
#define CAN0_CSR2_RXOK_MASK 0x20U
#define CAN0_CSR2_RXOK 0x20U
#define CAN0_CSR2_RXOK_BIT 5
#define CAN0_CSR2_TXOK_MASK 0x40U
#define CAN0_CSR2_TXOK 0x40U
#define CAN0_CSR2_TXOK_BIT 6
#define CAN0_CSR2_RFRAME_MASK 0x80U
#define CAN0_CSR2_RFRAME 0x80U
#define CAN0_CSR2_RFRAME_BIT 7
#define CAN0_CSR2_DLCW_MASK 0x200U
#define CAN0_CSR2_DLCW 0x200U
#define CAN0_CSR2_DLCW_BIT 9
#define CAN0_CSR2_FILLED_MASK 0x400U
#define CAN0_CSR2_FILLED 0x400U
#define CAN0_CSR2_FILLED_BIT 10
#define CAN0_CSR2_OVRUN_MASK 0x800U
#define CAN0_CSR2_OVRUN 0x800U
#define CAN0_CSR2_OVRUN_BIT 11

#define CAN0_SR2 (*(volatile unsigned long *)0xFFFD419C)
#define CAN0_SR2_OFFSET 0x19C
#define CAN0_SR2_ACK_MASK 0x1U
#define CAN0_SR2_ACK 0x1U
#define CAN0_SR2_ACK_BIT 0
#define CAN0_SR2_FRAME_MASK 0x2U
#define CAN0_SR2_FRAME 0x2U
#define CAN0_SR2_FRAME_BIT 1
#define CAN0_SR2_CRC_MASK 0x4U
#define CAN0_SR2_CRC 0x4U
#define CAN0_SR2_CRC_BIT 2
#define CAN0_SR2_STUFF_MASK 0x8U
#define CAN0_SR2_STUFF 0x8U
#define CAN0_SR2_STUFF_BIT 3
#define CAN0_SR2_BUS_MASK 0x10U
#define CAN0_SR2_BUS 0x10U
#define CAN0_SR2_BUS_BIT 4
#define CAN0_SR2_RXOK_MASK 0x20U
#define CAN0_SR2_RXOK 0x20U
#define CAN0_SR2_RXOK_BIT 5
#define CAN0_SR2_TXOK_MASK 0x40U
#define CAN0_SR2_TXOK 0x40U
#define CAN0_SR2_TXOK_BIT 6
#define CAN0_SR2_RFRAME_MASK 0x80U
#define CAN0_SR2_RFRAME 0x80U
#define CAN0_SR2_RFRAME_BIT 7
#define CAN0_SR2_DLCW_MASK 0x200U
#define CAN0_SR2_DLCW 0x200U
#define CAN0_SR2_DLCW_BIT 9
#define CAN0_SR2_FILLED_MASK 0x400U
#define CAN0_SR2_FILLED 0x400U
#define CAN0_SR2_FILLED_BIT 10
#define CAN0_SR2_OVRUN_MASK 0x800U
#define CAN0_SR2_OVRUN 0x800U
#define CAN0_SR2_OVRUN_BIT 11

#define CAN0_IER2 (*(volatile unsigned long *)0xFFFD41A0)
#define CAN0_IER2_OFFSET 0x1A0
#define CAN0_IER2_ACK_MASK 0x1U
#define CAN0_IER2_ACK 0x1U
#define CAN0_IER2_ACK_BIT 0
#define CAN0_IER2_FRAME_MASK 0x2U
#define CAN0_IER2_FRAME 0x2U
#define CAN0_IER2_FRAME_BIT 1
#define CAN0_IER2_CRC_MASK 0x4U
#define CAN0_IER2_CRC 0x4U
#define CAN0_IER2_CRC_BIT 2
#define CAN0_IER2_STUFF_MASK 0x8U
#define CAN0_IER2_STUFF 0x8U
#define CAN0_IER2_STUFF_BIT 3
#define CAN0_IER2_BUS_MASK 0x10U
#define CAN0_IER2_BUS 0x10U
#define CAN0_IER2_BUS_BIT 4
#define CAN0_IER2_RXOK_MASK 0x20U
#define CAN0_IER2_RXOK 0x20U
#define CAN0_IER2_RXOK_BIT 5
#define CAN0_IER2_TXOK_MASK 0x40U
#define CAN0_IER2_TXOK 0x40U
#define CAN0_IER2_TXOK_BIT 6
#define CAN0_IER2_RFRAME_MASK 0x80U
#define CAN0_IER2_RFRAME 0x80U
#define CAN0_IER2_RFRAME_BIT 7

#define CAN0_IDR2 (*(volatile unsigned long *)0xFFFD41A4)
#define CAN0_IDR2_OFFSET 0x1A4
#define CAN0_IDR2_ACK_MASK 0x1U
#define CAN0_IDR2_ACK 0x1U
#define CAN0_IDR2_ACK_BIT 0
#define CAN0_IDR2_FRAME_MASK 0x2U
#define CAN0_IDR2_FRAME 0x2U
#define CAN0_IDR2_FRAME_BIT 1
#define CAN0_IDR2_CRC_MASK 0x4U
#define CAN0_IDR2_CRC 0x4U
#define CAN0_IDR2_CRC_BIT 2
#define CAN0_IDR2_STUFF_MASK 0x8U
#define CAN0_IDR2_STUFF 0x8U
#define CAN0_IDR2_STUFF_BIT 3
#define CAN0_IDR2_BUS_MASK 0x10U
#define CAN0_IDR2_BUS 0x10U
#define CAN0_IDR2_BUS_BIT 4
#define CAN0_IDR2_RXOK_MASK 0x20U
#define CAN0_IDR2_RXOK 0x20U
#define CAN0_IDR2_RXOK_BIT 5
#define CAN0_IDR2_TXOK_MASK 0x40U
#define CAN0_IDR2_TXOK 0x40U
#define CAN0_IDR2_TXOK_BIT 6
#define CAN0_IDR2_RFRAME_MASK 0x80U
#define CAN0_IDR2_RFRAME 0x80U
#define CAN0_IDR2_RFRAME_BIT 7

#define CAN0_IMR2 (*(volatile unsigned long *)0xFFFD41A8)
#define CAN0_IMR2_OFFSET 0x1A8
#define CAN0_IMR2_ACK_MASK 0x1U
#define CAN0_IMR2_ACK 0x1U
#define CAN0_IMR2_ACK_BIT 0
#define CAN0_IMR2_FRAME_MASK 0x2U
#define CAN0_IMR2_FRAME 0x2U
#define CAN0_IMR2_FRAME_BIT 1
#define CAN0_IMR2_CRC_MASK 0x4U
#define CAN0_IMR2_CRC 0x4U
#define CAN0_IMR2_CRC_BIT 2
#define CAN0_IMR2_STUFF_MASK 0x8U
#define CAN0_IMR2_STUFF 0x8U
#define CAN0_IMR2_STUFF_BIT 3
#define CAN0_IMR2_BUS_MASK 0x10U
#define CAN0_IMR2_BUS 0x10U
#define CAN0_IMR2_BUS_BIT 4
#define CAN0_IMR2_RXOK_MASK 0x20U
#define CAN0_IMR2_RXOK 0x20U
#define CAN0_IMR2_RXOK_BIT 5
#define CAN0_IMR2_TXOK_MASK 0x40U
#define CAN0_IMR2_TXOK 0x40U
#define CAN0_IMR2_TXOK_BIT 6
#define CAN0_IMR2_RFRAME_MASK 0x80U
#define CAN0_IMR2_RFRAME 0x80U
#define CAN0_IMR2_RFRAME_BIT 7

#define CAN0_DRA3 (*(volatile unsigned long *)0xFFFD41C0)
#define CAN0_DRA3_OFFSET 0x1C0
#define CAN0_DRA3_DATA0_MASK 0xFFU
#define CAN0_DRA3_DATA0_BIT 0
#define CAN0_DRA3_DATA1_MASK 0xFF00U
#define CAN0_DRA3_DATA1_BIT 8
#define CAN0_DRA3_DATA2_MASK 0xFF0000U
#define CAN0_DRA3_DATA2_BIT 16
#define CAN0_DRA3_DATA3_MASK 0xFF000000U
#define CAN0_DRA3_DATA3_BIT 24

#define CAN0_DRB3 (*(volatile unsigned long *)0xFFFD41C4)
#define CAN0_DRB3_OFFSET 0x1C4
#define CAN0_DRB3_DATA4_MASK 0xFFU
#define CAN0_DRB3_DATA4_BIT 0
#define CAN0_DRB3_DATA5_MASK 0xFF00U
#define CAN0_DRB3_DATA5_BIT 8
#define CAN0_DRB3_DATA6_MASK 0xFF0000U
#define CAN0_DRB3_DATA6_BIT 16
#define CAN0_DRB3_DATA7_MASK 0xFF000000U
#define CAN0_DRB3_DATA7_BIT 24

#define CAN0_MSK3 (*(volatile unsigned long *)0xFFFD41C8)
#define CAN0_MSK3_OFFSET 0x1C8
#define CAN0_MSK3_MASK_MASK 0x1FFFFFFFU
#define CAN0_MSK3_MASK_BIT 0
#define CAN0_MSK3_MRB_MASK 0x60000000U
#define CAN0_MSK3_MRB_BIT 29
#define CAN0_MSK3_MRTR_MASK 0x80000000U
#define CAN0_MSK3_MRTR 0x80000000U
#define CAN0_MSK3_MRTR_BIT 31

#define CAN0_IR3 (*(volatile unsigned long *)0xFFFD41CC)
#define CAN0_IR3_OFFSET 0x1CC
#define CAN0_IR3_ID_MASK 0x1FFFFFFFU
#define CAN0_IR3_ID_BIT 0
#define CAN0_IR3_RB_MASK 0x60000000U
#define CAN0_IR3_RB_BIT 29
#define CAN0_IR3_RTR_MASK 0x80000000U
#define CAN0_IR3_RTR 0x80000000U
#define CAN0_IR3_RTR_BIT 31

#define CAN0_CR3 (*(volatile unsigned long *)0xFFFD41D0)
#define CAN0_CR3_OFFSET 0x1D0
#define CAN0_CR3_DLC_MASK 0xFU
#define CAN0_CR3_DLC_BIT 0
#define CAN0_CR3_IDE_MASK 0x10U
#define CAN0_CR3_IDE 0x10U
#define CAN0_CR3_IDE_BIT 4
#define CAN0_CR3_RPLYV_MASK 0x20U
#define CAN0_CR3_RPLYV 0x20U
#define CAN0_CR3_RPLYV_BIT 5
#define CAN0_CR3_PCB_MASK 0x40U
#define CAN0_CR3_PCB 0x40U
#define CAN0_CR3_PCB_BIT 6
#define CAN0_CR3_CHANEN_MASK 0x80U
#define CAN0_CR3_CHANEN 0x80U
#define CAN0_CR3_CHANEN_BIT 7
#define CAN0_CR3_OVERWRITE_MASK 0x100U
#define CAN0_CR3_OVERWRITE 0x100U
#define CAN0_CR3_OVERWRITE_BIT 8

#define CAN0_CR3 (*(volatile unsigned long *)0xFFFD41D4)
#define CAN0_CR3_OFFSET 0x1D4
#define CAN0_CR3_STAMP_MASK 0x0U
#define CAN0_CR3_STAMP_BIT 0

#define CAN0_CSR3 (*(volatile unsigned long *)0xFFFD41D8)
#define CAN0_CSR3_OFFSET 0x1D8
#define CAN0_CSR3_ACK_MASK 0x1U
#define CAN0_CSR3_ACK 0x1U
#define CAN0_CSR3_ACK_BIT 0
#define CAN0_CSR3_FRAME_MASK 0x2U
#define CAN0_CSR3_FRAME 0x2U
#define CAN0_CSR3_FRAME_BIT 1
#define CAN0_CSR3_CRC_MASK 0x4U
#define CAN0_CSR3_CRC 0x4U
#define CAN0_CSR3_CRC_BIT 2
#define CAN0_CSR3_STUFF_MASK 0x8U
#define CAN0_CSR3_STUFF 0x8U
#define CAN0_CSR3_STUFF_BIT 3
#define CAN0_CSR3_BUS_MASK 0x10U
#define CAN0_CSR3_BUS 0x10U
#define CAN0_CSR3_BUS_BIT 4
#define CAN0_CSR3_RXOK_MASK 0x20U
#define CAN0_CSR3_RXOK 0x20U
#define CAN0_CSR3_RXOK_BIT 5
#define CAN0_CSR3_TXOK_MASK 0x40U
#define CAN0_CSR3_TXOK 0x40U
#define CAN0_CSR3_TXOK_BIT 6
#define CAN0_CSR3_RFRAME_MASK 0x80U
#define CAN0_CSR3_RFRAME 0x80U
#define CAN0_CSR3_RFRAME_BIT 7
#define CAN0_CSR3_DLCW_MASK 0x200U
#define CAN0_CSR3_DLCW 0x200U
#define CAN0_CSR3_DLCW_BIT 9
#define CAN0_CSR3_FILLED_MASK 0x400U
#define CAN0_CSR3_FILLED 0x400U
#define CAN0_CSR3_FILLED_BIT 10
#define CAN0_CSR3_OVRUN_MASK 0x800U
#define CAN0_CSR3_OVRUN 0x800U
#define CAN0_CSR3_OVRUN_BIT 11

#define CAN0_SR3 (*(volatile unsigned long *)0xFFFD41DC)
#define CAN0_SR3_OFFSET 0x1DC
#define CAN0_SR3_ACK_MASK 0x1U
#define CAN0_SR3_ACK 0x1U
#define CAN0_SR3_ACK_BIT 0
#define CAN0_SR3_FRAME_MASK 0x2U
#define CAN0_SR3_FRAME 0x2U
#define CAN0_SR3_FRAME_BIT 1
#define CAN0_SR3_CRC_MASK 0x4U
#define CAN0_SR3_CRC 0x4U
#define CAN0_SR3_CRC_BIT 2
#define CAN0_SR3_STUFF_MASK 0x8U
#define CAN0_SR3_STUFF 0x8U
#define CAN0_SR3_STUFF_BIT 3
#define CAN0_SR3_BUS_MASK 0x10U
#define CAN0_SR3_BUS 0x10U
#define CAN0_SR3_BUS_BIT 4
#define CAN0_SR3_RXOK_MASK 0x20U
#define CAN0_SR3_RXOK 0x20U
#define CAN0_SR3_RXOK_BIT 5
#define CAN0_SR3_TXOK_MASK 0x40U
#define CAN0_SR3_TXOK 0x40U
#define CAN0_SR3_TXOK_BIT 6
#define CAN0_SR3_RFRAME_MASK 0x80U
#define CAN0_SR3_RFRAME 0x80U
#define CAN0_SR3_RFRAME_BIT 7
#define CAN0_SR3_DLCW_MASK 0x200U
#define CAN0_SR3_DLCW 0x200U
#define CAN0_SR3_DLCW_BIT 9
#define CAN0_SR3_FILLED_MASK 0x400U
#define CAN0_SR3_FILLED 0x400U
#define CAN0_SR3_FILLED_BIT 10
#define CAN0_SR3_OVRUN_MASK 0x800U
#define CAN0_SR3_OVRUN 0x800U
#define CAN0_SR3_OVRUN_BIT 11

#define CAN0_IER3 (*(volatile unsigned long *)0xFFFD41E0)
#define CAN0_IER3_OFFSET 0x1E0
#define CAN0_IER3_ACK_MASK 0x1U
#define CAN0_IER3_ACK 0x1U
#define CAN0_IER3_ACK_BIT 0
#define CAN0_IER3_FRAME_MASK 0x2U
#define CAN0_IER3_FRAME 0x2U
#define CAN0_IER3_FRAME_BIT 1
#define CAN0_IER3_CRC_MASK 0x4U
#define CAN0_IER3_CRC 0x4U
#define CAN0_IER3_CRC_BIT 2
#define CAN0_IER3_STUFF_MASK 0x8U
#define CAN0_IER3_STUFF 0x8U
#define CAN0_IER3_STUFF_BIT 3
#define CAN0_IER3_BUS_MASK 0x10U
#define CAN0_IER3_BUS 0x10U
#define CAN0_IER3_BUS_BIT 4
#define CAN0_IER3_RXOK_MASK 0x20U
#define CAN0_IER3_RXOK 0x20U
#define CAN0_IER3_RXOK_BIT 5
#define CAN0_IER3_TXOK_MASK 0x40U
#define CAN0_IER3_TXOK 0x40U
#define CAN0_IER3_TXOK_BIT 6
#define CAN0_IER3_RFRAME_MASK 0x80U
#define CAN0_IER3_RFRAME 0x80U
#define CAN0_IER3_RFRAME_BIT 7

#define CAN0_IDR3 (*(volatile unsigned long *)0xFFFD41E4)
#define CAN0_IDR3_OFFSET 0x1E4
#define CAN0_IDR3_ACK_MASK 0x1U
#define CAN0_IDR3_ACK 0x1U
#define CAN0_IDR3_ACK_BIT 0
#define CAN0_IDR3_FRAME_MASK 0x2U
#define CAN0_IDR3_FRAME 0x2U
#define CAN0_IDR3_FRAME_BIT 1
#define CAN0_IDR3_CRC_MASK 0x4U
#define CAN0_IDR3_CRC 0x4U
#define CAN0_IDR3_CRC_BIT 2
#define CAN0_IDR3_STUFF_MASK 0x8U
#define CAN0_IDR3_STUFF 0x8U
#define CAN0_IDR3_STUFF_BIT 3
#define CAN0_IDR3_BUS_MASK 0x10U
#define CAN0_IDR3_BUS 0x10U
#define CAN0_IDR3_BUS_BIT 4
#define CAN0_IDR3_RXOK_MASK 0x20U
#define CAN0_IDR3_RXOK 0x20U
#define CAN0_IDR3_RXOK_BIT 5
#define CAN0_IDR3_TXOK_MASK 0x40U
#define CAN0_IDR3_TXOK 0x40U
#define CAN0_IDR3_TXOK_BIT 6
#define CAN0_IDR3_RFRAME_MASK 0x80U
#define CAN0_IDR3_RFRAME 0x80U
#define CAN0_IDR3_RFRAME_BIT 7

#define CAN0_IMR3 (*(volatile unsigned long *)0xFFFD41E8)
#define CAN0_IMR3_OFFSET 0x1E8
#define CAN0_IMR3_ACK_MASK 0x1U
#define CAN0_IMR3_ACK 0x1U
#define CAN0_IMR3_ACK_BIT 0
#define CAN0_IMR3_FRAME_MASK 0x2U
#define CAN0_IMR3_FRAME 0x2U
#define CAN0_IMR3_FRAME_BIT 1
#define CAN0_IMR3_CRC_MASK 0x4U
#define CAN0_IMR3_CRC 0x4U
#define CAN0_IMR3_CRC_BIT 2
#define CAN0_IMR3_STUFF_MASK 0x8U
#define CAN0_IMR3_STUFF 0x8U
#define CAN0_IMR3_STUFF_BIT 3
#define CAN0_IMR3_BUS_MASK 0x10U
#define CAN0_IMR3_BUS 0x10U
#define CAN0_IMR3_BUS_BIT 4
#define CAN0_IMR3_RXOK_MASK 0x20U
#define CAN0_IMR3_RXOK 0x20U
#define CAN0_IMR3_RXOK_BIT 5
#define CAN0_IMR3_TXOK_MASK 0x40U
#define CAN0_IMR3_TXOK 0x40U
#define CAN0_IMR3_TXOK_BIT 6
#define CAN0_IMR3_RFRAME_MASK 0x80U
#define CAN0_IMR3_RFRAME 0x80U
#define CAN0_IMR3_RFRAME_BIT 7

#define CAN0_DRA4 (*(volatile unsigned long *)0xFFFD4200)
#define CAN0_DRA4_OFFSET 0x200
#define CAN0_DRA4_DATA0_MASK 0xFFU
#define CAN0_DRA4_DATA0_BIT 0
#define CAN0_DRA4_DATA1_MASK 0xFF00U
#define CAN0_DRA4_DATA1_BIT 8
#define CAN0_DRA4_DATA2_MASK 0xFF0000U
#define CAN0_DRA4_DATA2_BIT 16
#define CAN0_DRA4_DATA3_MASK 0xFF000000U
#define CAN0_DRA4_DATA3_BIT 24

#define CAN0_DRB4 (*(volatile unsigned long *)0xFFFD4204)
#define CAN0_DRB4_OFFSET 0x204
#define CAN0_DRB4_DATA4_MASK 0xFFU
#define CAN0_DRB4_DATA4_BIT 0
#define CAN0_DRB4_DATA5_MASK 0xFF00U
#define CAN0_DRB4_DATA5_BIT 8
#define CAN0_DRB4_DATA6_MASK 0xFF0000U
#define CAN0_DRB4_DATA6_BIT 16
#define CAN0_DRB4_DATA7_MASK 0xFF000000U
#define CAN0_DRB4_DATA7_BIT 24

#define CAN0_MSK4 (*(volatile unsigned long *)0xFFFD4208)
#define CAN0_MSK4_OFFSET 0x208
#define CAN0_MSK4_MASK_MASK 0x1FFFFFFFU
#define CAN0_MSK4_MASK_BIT 0
#define CAN0_MSK4_MRB_MASK 0x60000000U
#define CAN0_MSK4_MRB_BIT 29
#define CAN0_MSK4_MRTR_MASK 0x80000000U
#define CAN0_MSK4_MRTR 0x80000000U
#define CAN0_MSK4_MRTR_BIT 31

#define CAN0_IR4 (*(volatile unsigned long *)0xFFFD420C)
#define CAN0_IR4_OFFSET 0x20C
#define CAN0_IR4_ID_MASK 0x1FFFFFFFU
#define CAN0_IR4_ID_BIT 0
#define CAN0_IR4_RB_MASK 0x60000000U
#define CAN0_IR4_RB_BIT 29
#define CAN0_IR4_RTR_MASK 0x80000000U
#define CAN0_IR4_RTR 0x80000000U
#define CAN0_IR4_RTR_BIT 31

#define CAN0_CR4 (*(volatile unsigned long *)0xFFFD4210)
#define CAN0_CR4_OFFSET 0x210
#define CAN0_CR4_DLC_MASK 0xFU
#define CAN0_CR4_DLC_BIT 0
#define CAN0_CR4_IDE_MASK 0x10U
#define CAN0_CR4_IDE 0x10U
#define CAN0_CR4_IDE_BIT 4
#define CAN0_CR4_RPLYV_MASK 0x20U
#define CAN0_CR4_RPLYV 0x20U
#define CAN0_CR4_RPLYV_BIT 5
#define CAN0_CR4_PCB_MASK 0x40U
#define CAN0_CR4_PCB 0x40U
#define CAN0_CR4_PCB_BIT 6
#define CAN0_CR4_CHANEN_MASK 0x80U
#define CAN0_CR4_CHANEN 0x80U
#define CAN0_CR4_CHANEN_BIT 7
#define CAN0_CR4_OVERWRITE_MASK 0x100U
#define CAN0_CR4_OVERWRITE 0x100U
#define CAN0_CR4_OVERWRITE_BIT 8

#define CAN0_CR4 (*(volatile unsigned long *)0xFFFD4214)
#define CAN0_CR4_OFFSET 0x214
#define CAN0_CR4_STAMP_MASK 0x0U
#define CAN0_CR4_STAMP_BIT 0

#define CAN0_CSR4 (*(volatile unsigned long *)0xFFFD4218)
#define CAN0_CSR4_OFFSET 0x218
#define CAN0_CSR4_ACK_MASK 0x1U
#define CAN0_CSR4_ACK 0x1U
#define CAN0_CSR4_ACK_BIT 0
#define CAN0_CSR4_FRAME_MASK 0x2U
#define CAN0_CSR4_FRAME 0x2U
#define CAN0_CSR4_FRAME_BIT 1
#define CAN0_CSR4_CRC_MASK 0x4U
#define CAN0_CSR4_CRC 0x4U
#define CAN0_CSR4_CRC_BIT 2
#define CAN0_CSR4_STUFF_MASK 0x8U
#define CAN0_CSR4_STUFF 0x8U
#define CAN0_CSR4_STUFF_BIT 3
#define CAN0_CSR4_BUS_MASK 0x10U
#define CAN0_CSR4_BUS 0x10U
#define CAN0_CSR4_BUS_BIT 4
#define CAN0_CSR4_RXOK_MASK 0x20U
#define CAN0_CSR4_RXOK 0x20U
#define CAN0_CSR4_RXOK_BIT 5
#define CAN0_CSR4_TXOK_MASK 0x40U
#define CAN0_CSR4_TXOK 0x40U
#define CAN0_CSR4_TXOK_BIT 6
#define CAN0_CSR4_RFRAME_MASK 0x80U
#define CAN0_CSR4_RFRAME 0x80U
#define CAN0_CSR4_RFRAME_BIT 7
#define CAN0_CSR4_DLCW_MASK 0x200U
#define CAN0_CSR4_DLCW 0x200U
#define CAN0_CSR4_DLCW_BIT 9
#define CAN0_CSR4_FILLED_MASK 0x400U
#define CAN0_CSR4_FILLED 0x400U
#define CAN0_CSR4_FILLED_BIT 10
#define CAN0_CSR4_OVRUN_MASK 0x800U
#define CAN0_CSR4_OVRUN 0x800U
#define CAN0_CSR4_OVRUN_BIT 11

#define CAN0_SR4 (*(volatile unsigned long *)0xFFFD421C)
#define CAN0_SR4_OFFSET 0x21C
#define CAN0_SR4_ACK_MASK 0x1U
#define CAN0_SR4_ACK 0x1U
#define CAN0_SR4_ACK_BIT 0
#define CAN0_SR4_FRAME_MASK 0x2U
#define CAN0_SR4_FRAME 0x2U
#define CAN0_SR4_FRAME_BIT 1
#define CAN0_SR4_CRC_MASK 0x4U
#define CAN0_SR4_CRC 0x4U
#define CAN0_SR4_CRC_BIT 2
#define CAN0_SR4_STUFF_MASK 0x8U
#define CAN0_SR4_STUFF 0x8U
#define CAN0_SR4_STUFF_BIT 3
#define CAN0_SR4_BUS_MASK 0x10U
#define CAN0_SR4_BUS 0x10U
#define CAN0_SR4_BUS_BIT 4
#define CAN0_SR4_RXOK_MASK 0x20U
#define CAN0_SR4_RXOK 0x20U
#define CAN0_SR4_RXOK_BIT 5
#define CAN0_SR4_TXOK_MASK 0x40U
#define CAN0_SR4_TXOK 0x40U
#define CAN0_SR4_TXOK_BIT 6
#define CAN0_SR4_RFRAME_MASK 0x80U
#define CAN0_SR4_RFRAME 0x80U
#define CAN0_SR4_RFRAME_BIT 7
#define CAN0_SR4_DLCW_MASK 0x200U
#define CAN0_SR4_DLCW 0x200U
#define CAN0_SR4_DLCW_BIT 9
#define CAN0_SR4_FILLED_MASK 0x400U
#define CAN0_SR4_FILLED 0x400U
#define CAN0_SR4_FILLED_BIT 10
#define CAN0_SR4_OVRUN_MASK 0x800U
#define CAN0_SR4_OVRUN 0x800U
#define CAN0_SR4_OVRUN_BIT 11

#define CAN0_IER4 (*(volatile unsigned long *)0xFFFD4220)
#define CAN0_IER4_OFFSET 0x220
#define CAN0_IER4_ACK_MASK 0x1U
#define CAN0_IER4_ACK 0x1U
#define CAN0_IER4_ACK_BIT 0
#define CAN0_IER4_FRAME_MASK 0x2U
#define CAN0_IER4_FRAME 0x2U
#define CAN0_IER4_FRAME_BIT 1
#define CAN0_IER4_CRC_MASK 0x4U
#define CAN0_IER4_CRC 0x4U
#define CAN0_IER4_CRC_BIT 2
#define CAN0_IER4_STUFF_MASK 0x8U
#define CAN0_IER4_STUFF 0x8U
#define CAN0_IER4_STUFF_BIT 3
#define CAN0_IER4_BUS_MASK 0x10U
#define CAN0_IER4_BUS 0x10U
#define CAN0_IER4_BUS_BIT 4
#define CAN0_IER4_RXOK_MASK 0x20U
#define CAN0_IER4_RXOK 0x20U
#define CAN0_IER4_RXOK_BIT 5
#define CAN0_IER4_TXOK_MASK 0x40U
#define CAN0_IER4_TXOK 0x40U
#define CAN0_IER4_TXOK_BIT 6
#define CAN0_IER4_RFRAME_MASK 0x80U
#define CAN0_IER4_RFRAME 0x80U
#define CAN0_IER4_RFRAME_BIT 7

#define CAN0_IDR4 (*(volatile unsigned long *)0xFFFD4224)
#define CAN0_IDR4_OFFSET 0x224
#define CAN0_IDR4_ACK_MASK 0x1U
#define CAN0_IDR4_ACK 0x1U
#define CAN0_IDR4_ACK_BIT 0
#define CAN0_IDR4_FRAME_MASK 0x2U
#define CAN0_IDR4_FRAME 0x2U
#define CAN0_IDR4_FRAME_BIT 1
#define CAN0_IDR4_CRC_MASK 0x4U
#define CAN0_IDR4_CRC 0x4U
#define CAN0_IDR4_CRC_BIT 2
#define CAN0_IDR4_STUFF_MASK 0x8U
#define CAN0_IDR4_STUFF 0x8U
#define CAN0_IDR4_STUFF_BIT 3
#define CAN0_IDR4_BUS_MASK 0x10U
#define CAN0_IDR4_BUS 0x10U
#define CAN0_IDR4_BUS_BIT 4
#define CAN0_IDR4_RXOK_MASK 0x20U
#define CAN0_IDR4_RXOK 0x20U
#define CAN0_IDR4_RXOK_BIT 5
#define CAN0_IDR4_TXOK_MASK 0x40U
#define CAN0_IDR4_TXOK 0x40U
#define CAN0_IDR4_TXOK_BIT 6
#define CAN0_IDR4_RFRAME_MASK 0x80U
#define CAN0_IDR4_RFRAME 0x80U
#define CAN0_IDR4_RFRAME_BIT 7

#define CAN0_IMR4 (*(volatile unsigned long *)0xFFFD4228)
#define CAN0_IMR4_OFFSET 0x228
#define CAN0_IMR4_ACK_MASK 0x1U
#define CAN0_IMR4_ACK 0x1U
#define CAN0_IMR4_ACK_BIT 0
#define CAN0_IMR4_FRAME_MASK 0x2U
#define CAN0_IMR4_FRAME 0x2U
#define CAN0_IMR4_FRAME_BIT 1
#define CAN0_IMR4_CRC_MASK 0x4U
#define CAN0_IMR4_CRC 0x4U
#define CAN0_IMR4_CRC_BIT 2
#define CAN0_IMR4_STUFF_MASK 0x8U
#define CAN0_IMR4_STUFF 0x8U
#define CAN0_IMR4_STUFF_BIT 3
#define CAN0_IMR4_BUS_MASK 0x10U
#define CAN0_IMR4_BUS 0x10U
#define CAN0_IMR4_BUS_BIT 4
#define CAN0_IMR4_RXOK_MASK 0x20U
#define CAN0_IMR4_RXOK 0x20U
#define CAN0_IMR4_RXOK_BIT 5
#define CAN0_IMR4_TXOK_MASK 0x40U
#define CAN0_IMR4_TXOK 0x40U
#define CAN0_IMR4_TXOK_BIT 6
#define CAN0_IMR4_RFRAME_MASK 0x80U
#define CAN0_IMR4_RFRAME 0x80U
#define CAN0_IMR4_RFRAME_BIT 7

#define CAN0_DRA5 (*(volatile unsigned long *)0xFFFD4240)
#define CAN0_DRA5_OFFSET 0x240
#define CAN0_DRA5_DATA0_MASK 0xFFU
#define CAN0_DRA5_DATA0_BIT 0
#define CAN0_DRA5_DATA1_MASK 0xFF00U
#define CAN0_DRA5_DATA1_BIT 8
#define CAN0_DRA5_DATA2_MASK 0xFF0000U
#define CAN0_DRA5_DATA2_BIT 16
#define CAN0_DRA5_DATA3_MASK 0xFF000000U
#define CAN0_DRA5_DATA3_BIT 24

#define CAN0_DRB5 (*(volatile unsigned long *)0xFFFD4244)
#define CAN0_DRB5_OFFSET 0x244
#define CAN0_DRB5_DATA4_MASK 0xFFU
#define CAN0_DRB5_DATA4_BIT 0
#define CAN0_DRB5_DATA5_MASK 0xFF00U
#define CAN0_DRB5_DATA5_BIT 8
#define CAN0_DRB5_DATA6_MASK 0xFF0000U
#define CAN0_DRB5_DATA6_BIT 16
#define CAN0_DRB5_DATA7_MASK 0xFF000000U
#define CAN0_DRB5_DATA7_BIT 24

#define CAN0_MSK5 (*(volatile unsigned long *)0xFFFD4248)
#define CAN0_MSK5_OFFSET 0x248
#define CAN0_MSK5_MASK_MASK 0x1FFFFFFFU
#define CAN0_MSK5_MASK_BIT 0
#define CAN0_MSK5_MRB_MASK 0x60000000U
#define CAN0_MSK5_MRB_BIT 29
#define CAN0_MSK5_MRTR_MASK 0x80000000U
#define CAN0_MSK5_MRTR 0x80000000U
#define CAN0_MSK5_MRTR_BIT 31

#define CAN0_IR5 (*(volatile unsigned long *)0xFFFD424C)
#define CAN0_IR5_OFFSET 0x24C
#define CAN0_IR5_ID_MASK 0x1FFFFFFFU
#define CAN0_IR5_ID_BIT 0
#define CAN0_IR5_RB_MASK 0x60000000U
#define CAN0_IR5_RB_BIT 29
#define CAN0_IR5_RTR_MASK 0x80000000U
#define CAN0_IR5_RTR 0x80000000U
#define CAN0_IR5_RTR_BIT 31

#define CAN0_CR5 (*(volatile unsigned long *)0xFFFD4250)
#define CAN0_CR5_OFFSET 0x250
#define CAN0_CR5_DLC_MASK 0xFU
#define CAN0_CR5_DLC_BIT 0
#define CAN0_CR5_IDE_MASK 0x10U
#define CAN0_CR5_IDE 0x10U
#define CAN0_CR5_IDE_BIT 4
#define CAN0_CR5_RPLYV_MASK 0x20U
#define CAN0_CR5_RPLYV 0x20U
#define CAN0_CR5_RPLYV_BIT 5
#define CAN0_CR5_PCB_MASK 0x40U
#define CAN0_CR5_PCB 0x40U
#define CAN0_CR5_PCB_BIT 6
#define CAN0_CR5_CHANEN_MASK 0x80U
#define CAN0_CR5_CHANEN 0x80U
#define CAN0_CR5_CHANEN_BIT 7
#define CAN0_CR5_OVERWRITE_MASK 0x100U
#define CAN0_CR5_OVERWRITE 0x100U
#define CAN0_CR5_OVERWRITE_BIT 8

#define CAN0_CR5 (*(volatile unsigned long *)0xFFFD4254)
#define CAN0_CR5_OFFSET 0x254
#define CAN0_CR5_STAMP_MASK 0x0U
#define CAN0_CR5_STAMP_BIT 0

#define CAN0_CSR5 (*(volatile unsigned long *)0xFFFD4258)
#define CAN0_CSR5_OFFSET 0x258
#define CAN0_CSR5_ACK_MASK 0x1U
#define CAN0_CSR5_ACK 0x1U
#define CAN0_CSR5_ACK_BIT 0
#define CAN0_CSR5_FRAME_MASK 0x2U
#define CAN0_CSR5_FRAME 0x2U
#define CAN0_CSR5_FRAME_BIT 1
#define CAN0_CSR5_CRC_MASK 0x4U
#define CAN0_CSR5_CRC 0x4U
#define CAN0_CSR5_CRC_BIT 2
#define CAN0_CSR5_STUFF_MASK 0x8U
#define CAN0_CSR5_STUFF 0x8U
#define CAN0_CSR5_STUFF_BIT 3
#define CAN0_CSR5_BUS_MASK 0x10U
#define CAN0_CSR5_BUS 0x10U
#define CAN0_CSR5_BUS_BIT 4
#define CAN0_CSR5_RXOK_MASK 0x20U
#define CAN0_CSR5_RXOK 0x20U
#define CAN0_CSR5_RXOK_BIT 5
#define CAN0_CSR5_TXOK_MASK 0x40U
#define CAN0_CSR5_TXOK 0x40U
#define CAN0_CSR5_TXOK_BIT 6
#define CAN0_CSR5_RFRAME_MASK 0x80U
#define CAN0_CSR5_RFRAME 0x80U
#define CAN0_CSR5_RFRAME_BIT 7
#define CAN0_CSR5_DLCW_MASK 0x200U
#define CAN0_CSR5_DLCW 0x200U
#define CAN0_CSR5_DLCW_BIT 9
#define CAN0_CSR5_FILLED_MASK 0x400U
#define CAN0_CSR5_FILLED 0x400U
#define CAN0_CSR5_FILLED_BIT 10
#define CAN0_CSR5_OVRUN_MASK 0x800U
#define CAN0_CSR5_OVRUN 0x800U
#define CAN0_CSR5_OVRUN_BIT 11

#define CAN0_SR5 (*(volatile unsigned long *)0xFFFD425C)
#define CAN0_SR5_OFFSET 0x25C
#define CAN0_SR5_ACK_MASK 0x1U
#define CAN0_SR5_ACK 0x1U
#define CAN0_SR5_ACK_BIT 0
#define CAN0_SR5_FRAME_MASK 0x2U
#define CAN0_SR5_FRAME 0x2U
#define CAN0_SR5_FRAME_BIT 1
#define CAN0_SR5_CRC_MASK 0x4U
#define CAN0_SR5_CRC 0x4U
#define CAN0_SR5_CRC_BIT 2
#define CAN0_SR5_STUFF_MASK 0x8U
#define CAN0_SR5_STUFF 0x8U
#define CAN0_SR5_STUFF_BIT 3
#define CAN0_SR5_BUS_MASK 0x10U
#define CAN0_SR5_BUS 0x10U
#define CAN0_SR5_BUS_BIT 4
#define CAN0_SR5_RXOK_MASK 0x20U
#define CAN0_SR5_RXOK 0x20U
#define CAN0_SR5_RXOK_BIT 5
#define CAN0_SR5_TXOK_MASK 0x40U
#define CAN0_SR5_TXOK 0x40U
#define CAN0_SR5_TXOK_BIT 6
#define CAN0_SR5_RFRAME_MASK 0x80U
#define CAN0_SR5_RFRAME 0x80U
#define CAN0_SR5_RFRAME_BIT 7
#define CAN0_SR5_DLCW_MASK 0x200U
#define CAN0_SR5_DLCW 0x200U
#define CAN0_SR5_DLCW_BIT 9
#define CAN0_SR5_FILLED_MASK 0x400U
#define CAN0_SR5_FILLED 0x400U
#define CAN0_SR5_FILLED_BIT 10
#define CAN0_SR5_OVRUN_MASK 0x800U
#define CAN0_SR5_OVRUN 0x800U
#define CAN0_SR5_OVRUN_BIT 11

#define CAN0_IER5 (*(volatile unsigned long *)0xFFFD4260)
#define CAN0_IER5_OFFSET 0x260
#define CAN0_IER5_ACK_MASK 0x1U
#define CAN0_IER5_ACK 0x1U
#define CAN0_IER5_ACK_BIT 0
#define CAN0_IER5_FRAME_MASK 0x2U
#define CAN0_IER5_FRAME 0x2U
#define CAN0_IER5_FRAME_BIT 1
#define CAN0_IER5_CRC_MASK 0x4U
#define CAN0_IER5_CRC 0x4U
#define CAN0_IER5_CRC_BIT 2
#define CAN0_IER5_STUFF_MASK 0x8U
#define CAN0_IER5_STUFF 0x8U
#define CAN0_IER5_STUFF_BIT 3
#define CAN0_IER5_BUS_MASK 0x10U
#define CAN0_IER5_BUS 0x10U
#define CAN0_IER5_BUS_BIT 4
#define CAN0_IER5_RXOK_MASK 0x20U
#define CAN0_IER5_RXOK 0x20U
#define CAN0_IER5_RXOK_BIT 5
#define CAN0_IER5_TXOK_MASK 0x40U
#define CAN0_IER5_TXOK 0x40U
#define CAN0_IER5_TXOK_BIT 6
#define CAN0_IER5_RFRAME_MASK 0x80U
#define CAN0_IER5_RFRAME 0x80U
#define CAN0_IER5_RFRAME_BIT 7

#define CAN0_IDR5 (*(volatile unsigned long *)0xFFFD4264)
#define CAN0_IDR5_OFFSET 0x264
#define CAN0_IDR5_ACK_MASK 0x1U
#define CAN0_IDR5_ACK 0x1U
#define CAN0_IDR5_ACK_BIT 0
#define CAN0_IDR5_FRAME_MASK 0x2U
#define CAN0_IDR5_FRAME 0x2U
#define CAN0_IDR5_FRAME_BIT 1
#define CAN0_IDR5_CRC_MASK 0x4U
#define CAN0_IDR5_CRC 0x4U
#define CAN0_IDR5_CRC_BIT 2
#define CAN0_IDR5_STUFF_MASK 0x8U
#define CAN0_IDR5_STUFF 0x8U
#define CAN0_IDR5_STUFF_BIT 3
#define CAN0_IDR5_BUS_MASK 0x10U
#define CAN0_IDR5_BUS 0x10U
#define CAN0_IDR5_BUS_BIT 4
#define CAN0_IDR5_RXOK_MASK 0x20U
#define CAN0_IDR5_RXOK 0x20U
#define CAN0_IDR5_RXOK_BIT 5
#define CAN0_IDR5_TXOK_MASK 0x40U
#define CAN0_IDR5_TXOK 0x40U
#define CAN0_IDR5_TXOK_BIT 6
#define CAN0_IDR5_RFRAME_MASK 0x80U
#define CAN0_IDR5_RFRAME 0x80U
#define CAN0_IDR5_RFRAME_BIT 7

#define CAN0_IMR5 (*(volatile unsigned long *)0xFFFD4268)
#define CAN0_IMR5_OFFSET 0x268
#define CAN0_IMR5_ACK_MASK 0x1U
#define CAN0_IMR5_ACK 0x1U
#define CAN0_IMR5_ACK_BIT 0
#define CAN0_IMR5_FRAME_MASK 0x2U
#define CAN0_IMR5_FRAME 0x2U
#define CAN0_IMR5_FRAME_BIT 1
#define CAN0_IMR5_CRC_MASK 0x4U
#define CAN0_IMR5_CRC 0x4U
#define CAN0_IMR5_CRC_BIT 2
#define CAN0_IMR5_STUFF_MASK 0x8U
#define CAN0_IMR5_STUFF 0x8U
#define CAN0_IMR5_STUFF_BIT 3
#define CAN0_IMR5_BUS_MASK 0x10U
#define CAN0_IMR5_BUS 0x10U
#define CAN0_IMR5_BUS_BIT 4
#define CAN0_IMR5_RXOK_MASK 0x20U
#define CAN0_IMR5_RXOK 0x20U
#define CAN0_IMR5_RXOK_BIT 5
#define CAN0_IMR5_TXOK_MASK 0x40U
#define CAN0_IMR5_TXOK 0x40U
#define CAN0_IMR5_TXOK_BIT 6
#define CAN0_IMR5_RFRAME_MASK 0x80U
#define CAN0_IMR5_RFRAME 0x80U
#define CAN0_IMR5_RFRAME_BIT 7

#define CAN0_DRA6 (*(volatile unsigned long *)0xFFFD4280)
#define CAN0_DRA6_OFFSET 0x280
#define CAN0_DRA6_DATA0_MASK 0xFFU
#define CAN0_DRA6_DATA0_BIT 0
#define CAN0_DRA6_DATA1_MASK 0xFF00U
#define CAN0_DRA6_DATA1_BIT 8
#define CAN0_DRA6_DATA2_MASK 0xFF0000U
#define CAN0_DRA6_DATA2_BIT 16
#define CAN0_DRA6_DATA3_MASK 0xFF000000U
#define CAN0_DRA6_DATA3_BIT 24

#define CAN0_DRB6 (*(volatile unsigned long *)0xFFFD4284)
#define CAN0_DRB6_OFFSET 0x284
#define CAN0_DRB6_DATA4_MASK 0xFFU
#define CAN0_DRB6_DATA4_BIT 0
#define CAN0_DRB6_DATA5_MASK 0xFF00U
#define CAN0_DRB6_DATA5_BIT 8
#define CAN0_DRB6_DATA6_MASK 0xFF0000U
#define CAN0_DRB6_DATA6_BIT 16
#define CAN0_DRB6_DATA7_MASK 0xFF000000U
#define CAN0_DRB6_DATA7_BIT 24

#define CAN0_MSK6 (*(volatile unsigned long *)0xFFFD4288)
#define CAN0_MSK6_OFFSET 0x288
#define CAN0_MSK6_MASK_MASK 0x1FFFFFFFU
#define CAN0_MSK6_MASK_BIT 0
#define CAN0_MSK6_MRB_MASK 0x60000000U
#define CAN0_MSK6_MRB_BIT 29
#define CAN0_MSK6_MRTR_MASK 0x80000000U
#define CAN0_MSK6_MRTR 0x80000000U
#define CAN0_MSK6_MRTR_BIT 31

#define CAN0_IR6 (*(volatile unsigned long *)0xFFFD428C)
#define CAN0_IR6_OFFSET 0x28C
#define CAN0_IR6_ID_MASK 0x1FFFFFFFU
#define CAN0_IR6_ID_BIT 0
#define CAN0_IR6_RB_MASK 0x60000000U
#define CAN0_IR6_RB_BIT 29
#define CAN0_IR6_RTR_MASK 0x80000000U
#define CAN0_IR6_RTR 0x80000000U
#define CAN0_IR6_RTR_BIT 31

#define CAN0_CR6 (*(volatile unsigned long *)0xFFFD4290)
#define CAN0_CR6_OFFSET 0x290
#define CAN0_CR6_DLC_MASK 0xFU
#define CAN0_CR6_DLC_BIT 0
#define CAN0_CR6_IDE_MASK 0x10U
#define CAN0_CR6_IDE 0x10U
#define CAN0_CR6_IDE_BIT 4
#define CAN0_CR6_RPLYV_MASK 0x20U
#define CAN0_CR6_RPLYV 0x20U
#define CAN0_CR6_RPLYV_BIT 5
#define CAN0_CR6_PCB_MASK 0x40U
#define CAN0_CR6_PCB 0x40U
#define CAN0_CR6_PCB_BIT 6
#define CAN0_CR6_CHANEN_MASK 0x80U
#define CAN0_CR6_CHANEN 0x80U
#define CAN0_CR6_CHANEN_BIT 7
#define CAN0_CR6_OVERWRITE_MASK 0x100U
#define CAN0_CR6_OVERWRITE 0x100U
#define CAN0_CR6_OVERWRITE_BIT 8

#define CAN0_CR6 (*(volatile unsigned long *)0xFFFD4294)
#define CAN0_CR6_OFFSET 0x294
#define CAN0_CR6_STAMP_MASK 0x0U
#define CAN0_CR6_STAMP_BIT 0

#define CAN0_CSR6 (*(volatile unsigned long *)0xFFFD4298)
#define CAN0_CSR6_OFFSET 0x298
#define CAN0_CSR6_ACK_MASK 0x1U
#define CAN0_CSR6_ACK 0x1U
#define CAN0_CSR6_ACK_BIT 0
#define CAN0_CSR6_FRAME_MASK 0x2U
#define CAN0_CSR6_FRAME 0x2U
#define CAN0_CSR6_FRAME_BIT 1
#define CAN0_CSR6_CRC_MASK 0x4U
#define CAN0_CSR6_CRC 0x4U
#define CAN0_CSR6_CRC_BIT 2
#define CAN0_CSR6_STUFF_MASK 0x8U
#define CAN0_CSR6_STUFF 0x8U
#define CAN0_CSR6_STUFF_BIT 3
#define CAN0_CSR6_BUS_MASK 0x10U
#define CAN0_CSR6_BUS 0x10U
#define CAN0_CSR6_BUS_BIT 4
#define CAN0_CSR6_RXOK_MASK 0x20U
#define CAN0_CSR6_RXOK 0x20U
#define CAN0_CSR6_RXOK_BIT 5
#define CAN0_CSR6_TXOK_MASK 0x40U
#define CAN0_CSR6_TXOK 0x40U
#define CAN0_CSR6_TXOK_BIT 6
#define CAN0_CSR6_RFRAME_MASK 0x80U
#define CAN0_CSR6_RFRAME 0x80U
#define CAN0_CSR6_RFRAME_BIT 7
#define CAN0_CSR6_DLCW_MASK 0x200U
#define CAN0_CSR6_DLCW 0x200U
#define CAN0_CSR6_DLCW_BIT 9
#define CAN0_CSR6_FILLED_MASK 0x400U
#define CAN0_CSR6_FILLED 0x400U
#define CAN0_CSR6_FILLED_BIT 10
#define CAN0_CSR6_OVRUN_MASK 0x800U
#define CAN0_CSR6_OVRUN 0x800U
#define CAN0_CSR6_OVRUN_BIT 11

#define CAN0_SR6 (*(volatile unsigned long *)0xFFFD429C)
#define CAN0_SR6_OFFSET 0x29C
#define CAN0_SR6_ACK_MASK 0x1U
#define CAN0_SR6_ACK 0x1U
#define CAN0_SR6_ACK_BIT 0
#define CAN0_SR6_FRAME_MASK 0x2U
#define CAN0_SR6_FRAME 0x2U
#define CAN0_SR6_FRAME_BIT 1
#define CAN0_SR6_CRC_MASK 0x4U
#define CAN0_SR6_CRC 0x4U
#define CAN0_SR6_CRC_BIT 2
#define CAN0_SR6_STUFF_MASK 0x8U
#define CAN0_SR6_STUFF 0x8U
#define CAN0_SR6_STUFF_BIT 3
#define CAN0_SR6_BUS_MASK 0x10U
#define CAN0_SR6_BUS 0x10U
#define CAN0_SR6_BUS_BIT 4
#define CAN0_SR6_RXOK_MASK 0x20U
#define CAN0_SR6_RXOK 0x20U
#define CAN0_SR6_RXOK_BIT 5
#define CAN0_SR6_TXOK_MASK 0x40U
#define CAN0_SR6_TXOK 0x40U
#define CAN0_SR6_TXOK_BIT 6
#define CAN0_SR6_RFRAME_MASK 0x80U
#define CAN0_SR6_RFRAME 0x80U
#define CAN0_SR6_RFRAME_BIT 7
#define CAN0_SR6_DLCW_MASK 0x200U
#define CAN0_SR6_DLCW 0x200U
#define CAN0_SR6_DLCW_BIT 9
#define CAN0_SR6_FILLED_MASK 0x400U
#define CAN0_SR6_FILLED 0x400U
#define CAN0_SR6_FILLED_BIT 10
#define CAN0_SR6_OVRUN_MASK 0x800U
#define CAN0_SR6_OVRUN 0x800U
#define CAN0_SR6_OVRUN_BIT 11

#define CAN0_IER6 (*(volatile unsigned long *)0xFFFD42A0)
#define CAN0_IER6_OFFSET 0x2A0
#define CAN0_IER6_ACK_MASK 0x1U
#define CAN0_IER6_ACK 0x1U
#define CAN0_IER6_ACK_BIT 0
#define CAN0_IER6_FRAME_MASK 0x2U
#define CAN0_IER6_FRAME 0x2U
#define CAN0_IER6_FRAME_BIT 1
#define CAN0_IER6_CRC_MASK 0x4U
#define CAN0_IER6_CRC 0x4U
#define CAN0_IER6_CRC_BIT 2
#define CAN0_IER6_STUFF_MASK 0x8U
#define CAN0_IER6_STUFF 0x8U
#define CAN0_IER6_STUFF_BIT 3
#define CAN0_IER6_BUS_MASK 0x10U
#define CAN0_IER6_BUS 0x10U
#define CAN0_IER6_BUS_BIT 4
#define CAN0_IER6_RXOK_MASK 0x20U
#define CAN0_IER6_RXOK 0x20U
#define CAN0_IER6_RXOK_BIT 5
#define CAN0_IER6_TXOK_MASK 0x40U
#define CAN0_IER6_TXOK 0x40U
#define CAN0_IER6_TXOK_BIT 6
#define CAN0_IER6_RFRAME_MASK 0x80U
#define CAN0_IER6_RFRAME 0x80U
#define CAN0_IER6_RFRAME_BIT 7

#define CAN0_IDR6 (*(volatile unsigned long *)0xFFFD42A4)
#define CAN0_IDR6_OFFSET 0x2A4
#define CAN0_IDR6_ACK_MASK 0x1U
#define CAN0_IDR6_ACK 0x1U
#define CAN0_IDR6_ACK_BIT 0
#define CAN0_IDR6_FRAME_MASK 0x2U
#define CAN0_IDR6_FRAME 0x2U
#define CAN0_IDR6_FRAME_BIT 1
#define CAN0_IDR6_CRC_MASK 0x4U
#define CAN0_IDR6_CRC 0x4U
#define CAN0_IDR6_CRC_BIT 2
#define CAN0_IDR6_STUFF_MASK 0x8U
#define CAN0_IDR6_STUFF 0x8U
#define CAN0_IDR6_STUFF_BIT 3
#define CAN0_IDR6_BUS_MASK 0x10U
#define CAN0_IDR6_BUS 0x10U
#define CAN0_IDR6_BUS_BIT 4
#define CAN0_IDR6_RXOK_MASK 0x20U
#define CAN0_IDR6_RXOK 0x20U
#define CAN0_IDR6_RXOK_BIT 5
#define CAN0_IDR6_TXOK_MASK 0x40U
#define CAN0_IDR6_TXOK 0x40U
#define CAN0_IDR6_TXOK_BIT 6
#define CAN0_IDR6_RFRAME_MASK 0x80U
#define CAN0_IDR6_RFRAME 0x80U
#define CAN0_IDR6_RFRAME_BIT 7

#define CAN0_IMR6 (*(volatile unsigned long *)0xFFFD42A8)
#define CAN0_IMR6_OFFSET 0x2A8
#define CAN0_IMR6_ACK_MASK 0x1U
#define CAN0_IMR6_ACK 0x1U
#define CAN0_IMR6_ACK_BIT 0
#define CAN0_IMR6_FRAME_MASK 0x2U
#define CAN0_IMR6_FRAME 0x2U
#define CAN0_IMR6_FRAME_BIT 1
#define CAN0_IMR6_CRC_MASK 0x4U
#define CAN0_IMR6_CRC 0x4U
#define CAN0_IMR6_CRC_BIT 2
#define CAN0_IMR6_STUFF_MASK 0x8U
#define CAN0_IMR6_STUFF 0x8U
#define CAN0_IMR6_STUFF_BIT 3
#define CAN0_IMR6_BUS_MASK 0x10U
#define CAN0_IMR6_BUS 0x10U
#define CAN0_IMR6_BUS_BIT 4
#define CAN0_IMR6_RXOK_MASK 0x20U
#define CAN0_IMR6_RXOK 0x20U
#define CAN0_IMR6_RXOK_BIT 5
#define CAN0_IMR6_TXOK_MASK 0x40U
#define CAN0_IMR6_TXOK 0x40U
#define CAN0_IMR6_TXOK_BIT 6
#define CAN0_IMR6_RFRAME_MASK 0x80U
#define CAN0_IMR6_RFRAME 0x80U
#define CAN0_IMR6_RFRAME_BIT 7

#define CAN0_DRA7 (*(volatile unsigned long *)0xFFFD42C0)
#define CAN0_DRA7_OFFSET 0x2C0
#define CAN0_DRA7_DATA0_MASK 0xFFU
#define CAN0_DRA7_DATA0_BIT 0
#define CAN0_DRA7_DATA1_MASK 0xFF00U
#define CAN0_DRA7_DATA1_BIT 8
#define CAN0_DRA7_DATA2_MASK 0xFF0000U
#define CAN0_DRA7_DATA2_BIT 16
#define CAN0_DRA7_DATA3_MASK 0xFF000000U
#define CAN0_DRA7_DATA3_BIT 24

#define CAN0_DRB7 (*(volatile unsigned long *)0xFFFD42C4)
#define CAN0_DRB7_OFFSET 0x2C4
#define CAN0_DRB7_DATA4_MASK 0xFFU
#define CAN0_DRB7_DATA4_BIT 0
#define CAN0_DRB7_DATA5_MASK 0xFF00U
#define CAN0_DRB7_DATA5_BIT 8
#define CAN0_DRB7_DATA6_MASK 0xFF0000U
#define CAN0_DRB7_DATA6_BIT 16
#define CAN0_DRB7_DATA7_MASK 0xFF000000U
#define CAN0_DRB7_DATA7_BIT 24

#define CAN0_MSK7 (*(volatile unsigned long *)0xFFFD42C8)
#define CAN0_MSK7_OFFSET 0x2C8
#define CAN0_MSK7_MASK_MASK 0x1FFFFFFFU
#define CAN0_MSK7_MASK_BIT 0
#define CAN0_MSK7_MRB_MASK 0x60000000U
#define CAN0_MSK7_MRB_BIT 29
#define CAN0_MSK7_MRTR_MASK 0x80000000U
#define CAN0_MSK7_MRTR 0x80000000U
#define CAN0_MSK7_MRTR_BIT 31

#define CAN0_IR7 (*(volatile unsigned long *)0xFFFD42CC)
#define CAN0_IR7_OFFSET 0x2CC
#define CAN0_IR7_ID_MASK 0x1FFFFFFFU
#define CAN0_IR7_ID_BIT 0
#define CAN0_IR7_RB_MASK 0x60000000U
#define CAN0_IR7_RB_BIT 29
#define CAN0_IR7_RTR_MASK 0x80000000U
#define CAN0_IR7_RTR 0x80000000U
#define CAN0_IR7_RTR_BIT 31

#define CAN0_CR7 (*(volatile unsigned long *)0xFFFD42D0)
#define CAN0_CR7_OFFSET 0x2D0
#define CAN0_CR7_DLC_MASK 0xFU
#define CAN0_CR7_DLC_BIT 0
#define CAN0_CR7_IDE_MASK 0x10U
#define CAN0_CR7_IDE 0x10U
#define CAN0_CR7_IDE_BIT 4
#define CAN0_CR7_RPLYV_MASK 0x20U
#define CAN0_CR7_RPLYV 0x20U
#define CAN0_CR7_RPLYV_BIT 5
#define CAN0_CR7_PCB_MASK 0x40U
#define CAN0_CR7_PCB 0x40U
#define CAN0_CR7_PCB_BIT 6
#define CAN0_CR7_CHANEN_MASK 0x80U
#define CAN0_CR7_CHANEN 0x80U
#define CAN0_CR7_CHANEN_BIT 7
#define CAN0_CR7_OVERWRITE_MASK 0x100U
#define CAN0_CR7_OVERWRITE 0x100U
#define CAN0_CR7_OVERWRITE_BIT 8

#define CAN0_CR7 (*(volatile unsigned long *)0xFFFD42D4)
#define CAN0_CR7_OFFSET 0x2D4
#define CAN0_CR7_STAMP_MASK 0x0U
#define CAN0_CR7_STAMP_BIT 0

#define CAN0_CSR7 (*(volatile unsigned long *)0xFFFD42D8)
#define CAN0_CSR7_OFFSET 0x2D8
#define CAN0_CSR7_ACK_MASK 0x1U
#define CAN0_CSR7_ACK 0x1U
#define CAN0_CSR7_ACK_BIT 0
#define CAN0_CSR7_FRAME_MASK 0x2U
#define CAN0_CSR7_FRAME 0x2U
#define CAN0_CSR7_FRAME_BIT 1
#define CAN0_CSR7_CRC_MASK 0x4U
#define CAN0_CSR7_CRC 0x4U
#define CAN0_CSR7_CRC_BIT 2
#define CAN0_CSR7_STUFF_MASK 0x8U
#define CAN0_CSR7_STUFF 0x8U
#define CAN0_CSR7_STUFF_BIT 3
#define CAN0_CSR7_BUS_MASK 0x10U
#define CAN0_CSR7_BUS 0x10U
#define CAN0_CSR7_BUS_BIT 4
#define CAN0_CSR7_RXOK_MASK 0x20U
#define CAN0_CSR7_RXOK 0x20U
#define CAN0_CSR7_RXOK_BIT 5
#define CAN0_CSR7_TXOK_MASK 0x40U
#define CAN0_CSR7_TXOK 0x40U
#define CAN0_CSR7_TXOK_BIT 6
#define CAN0_CSR7_RFRAME_MASK 0x80U
#define CAN0_CSR7_RFRAME 0x80U
#define CAN0_CSR7_RFRAME_BIT 7
#define CAN0_CSR7_DLCW_MASK 0x200U
#define CAN0_CSR7_DLCW 0x200U
#define CAN0_CSR7_DLCW_BIT 9
#define CAN0_CSR7_FILLED_MASK 0x400U
#define CAN0_CSR7_FILLED 0x400U
#define CAN0_CSR7_FILLED_BIT 10
#define CAN0_CSR7_OVRUN_MASK 0x800U
#define CAN0_CSR7_OVRUN 0x800U
#define CAN0_CSR7_OVRUN_BIT 11

#define CAN0_SR7 (*(volatile unsigned long *)0xFFFD42DC)
#define CAN0_SR7_OFFSET 0x2DC
#define CAN0_SR7_ACK_MASK 0x1U
#define CAN0_SR7_ACK 0x1U
#define CAN0_SR7_ACK_BIT 0
#define CAN0_SR7_FRAME_MASK 0x2U
#define CAN0_SR7_FRAME 0x2U
#define CAN0_SR7_FRAME_BIT 1
#define CAN0_SR7_CRC_MASK 0x4U
#define CAN0_SR7_CRC 0x4U
#define CAN0_SR7_CRC_BIT 2
#define CAN0_SR7_STUFF_MASK 0x8U
#define CAN0_SR7_STUFF 0x8U
#define CAN0_SR7_STUFF_BIT 3
#define CAN0_SR7_BUS_MASK 0x10U
#define CAN0_SR7_BUS 0x10U
#define CAN0_SR7_BUS_BIT 4
#define CAN0_SR7_RXOK_MASK 0x20U
#define CAN0_SR7_RXOK 0x20U
#define CAN0_SR7_RXOK_BIT 5
#define CAN0_SR7_TXOK_MASK 0x40U
#define CAN0_SR7_TXOK 0x40U
#define CAN0_SR7_TXOK_BIT 6
#define CAN0_SR7_RFRAME_MASK 0x80U
#define CAN0_SR7_RFRAME 0x80U
#define CAN0_SR7_RFRAME_BIT 7
#define CAN0_SR7_DLCW_MASK 0x200U
#define CAN0_SR7_DLCW 0x200U
#define CAN0_SR7_DLCW_BIT 9
#define CAN0_SR7_FILLED_MASK 0x400U
#define CAN0_SR7_FILLED 0x400U
#define CAN0_SR7_FILLED_BIT 10
#define CAN0_SR7_OVRUN_MASK 0x800U
#define CAN0_SR7_OVRUN 0x800U
#define CAN0_SR7_OVRUN_BIT 11

#define CAN0_IER7 (*(volatile unsigned long *)0xFFFD42E0)
#define CAN0_IER7_OFFSET 0x2E0
#define CAN0_IER7_ACK_MASK 0x1U
#define CAN0_IER7_ACK 0x1U
#define CAN0_IER7_ACK_BIT 0
#define CAN0_IER7_FRAME_MASK 0x2U
#define CAN0_IER7_FRAME 0x2U
#define CAN0_IER7_FRAME_BIT 1
#define CAN0_IER7_CRC_MASK 0x4U
#define CAN0_IER7_CRC 0x4U
#define CAN0_IER7_CRC_BIT 2
#define CAN0_IER7_STUFF_MASK 0x8U
#define CAN0_IER7_STUFF 0x8U
#define CAN0_IER7_STUFF_BIT 3
#define CAN0_IER7_BUS_MASK 0x10U
#define CAN0_IER7_BUS 0x10U
#define CAN0_IER7_BUS_BIT 4
#define CAN0_IER7_RXOK_MASK 0x20U
#define CAN0_IER7_RXOK 0x20U
#define CAN0_IER7_RXOK_BIT 5
#define CAN0_IER7_TXOK_MASK 0x40U
#define CAN0_IER7_TXOK 0x40U
#define CAN0_IER7_TXOK_BIT 6
#define CAN0_IER7_RFRAME_MASK 0x80U
#define CAN0_IER7_RFRAME 0x80U
#define CAN0_IER7_RFRAME_BIT 7

#define CAN0_IDR7 (*(volatile unsigned long *)0xFFFD42E4)
#define CAN0_IDR7_OFFSET 0x2E4
#define CAN0_IDR7_ACK_MASK 0x1U
#define CAN0_IDR7_ACK 0x1U
#define CAN0_IDR7_ACK_BIT 0
#define CAN0_IDR7_FRAME_MASK 0x2U
#define CAN0_IDR7_FRAME 0x2U
#define CAN0_IDR7_FRAME_BIT 1
#define CAN0_IDR7_CRC_MASK 0x4U
#define CAN0_IDR7_CRC 0x4U
#define CAN0_IDR7_CRC_BIT 2
#define CAN0_IDR7_STUFF_MASK 0x8U
#define CAN0_IDR7_STUFF 0x8U
#define CAN0_IDR7_STUFF_BIT 3
#define CAN0_IDR7_BUS_MASK 0x10U
#define CAN0_IDR7_BUS 0x10U
#define CAN0_IDR7_BUS_BIT 4
#define CAN0_IDR7_RXOK_MASK 0x20U
#define CAN0_IDR7_RXOK 0x20U
#define CAN0_IDR7_RXOK_BIT 5
#define CAN0_IDR7_TXOK_MASK 0x40U
#define CAN0_IDR7_TXOK 0x40U
#define CAN0_IDR7_TXOK_BIT 6
#define CAN0_IDR7_RFRAME_MASK 0x80U
#define CAN0_IDR7_RFRAME 0x80U
#define CAN0_IDR7_RFRAME_BIT 7

#define CAN0_IMR7 (*(volatile unsigned long *)0xFFFD42E8)
#define CAN0_IMR7_OFFSET 0x2E8
#define CAN0_IMR7_ACK_MASK 0x1U
#define CAN0_IMR7_ACK 0x1U
#define CAN0_IMR7_ACK_BIT 0
#define CAN0_IMR7_FRAME_MASK 0x2U
#define CAN0_IMR7_FRAME 0x2U
#define CAN0_IMR7_FRAME_BIT 1
#define CAN0_IMR7_CRC_MASK 0x4U
#define CAN0_IMR7_CRC 0x4U
#define CAN0_IMR7_CRC_BIT 2
#define CAN0_IMR7_STUFF_MASK 0x8U
#define CAN0_IMR7_STUFF 0x8U
#define CAN0_IMR7_STUFF_BIT 3
#define CAN0_IMR7_BUS_MASK 0x10U
#define CAN0_IMR7_BUS 0x10U
#define CAN0_IMR7_BUS_BIT 4
#define CAN0_IMR7_RXOK_MASK 0x20U
#define CAN0_IMR7_RXOK 0x20U
#define CAN0_IMR7_RXOK_BIT 5
#define CAN0_IMR7_TXOK_MASK 0x40U
#define CAN0_IMR7_TXOK 0x40U
#define CAN0_IMR7_TXOK_BIT 6
#define CAN0_IMR7_RFRAME_MASK 0x80U
#define CAN0_IMR7_RFRAME 0x80U
#define CAN0_IMR7_RFRAME_BIT 7

#define CAN0_DRA8 (*(volatile unsigned long *)0xFFFD4300)
#define CAN0_DRA8_OFFSET 0x300
#define CAN0_DRA8_DATA0_MASK 0xFFU
#define CAN0_DRA8_DATA0_BIT 0
#define CAN0_DRA8_DATA1_MASK 0xFF00U
#define CAN0_DRA8_DATA1_BIT 8
#define CAN0_DRA8_DATA2_MASK 0xFF0000U
#define CAN0_DRA8_DATA2_BIT 16
#define CAN0_DRA8_DATA3_MASK 0xFF000000U
#define CAN0_DRA8_DATA3_BIT 24

#define CAN0_DRB8 (*(volatile unsigned long *)0xFFFD4304)
#define CAN0_DRB8_OFFSET 0x304
#define CAN0_DRB8_DATA4_MASK 0xFFU
#define CAN0_DRB8_DATA4_BIT 0
#define CAN0_DRB8_DATA5_MASK 0xFF00U
#define CAN0_DRB8_DATA5_BIT 8
#define CAN0_DRB8_DATA6_MASK 0xFF0000U
#define CAN0_DRB8_DATA6_BIT 16
#define CAN0_DRB8_DATA7_MASK 0xFF000000U
#define CAN0_DRB8_DATA7_BIT 24

#define CAN0_MSK8 (*(volatile unsigned long *)0xFFFD4308)
#define CAN0_MSK8_OFFSET 0x308
#define CAN0_MSK8_MASK_MASK 0x1FFFFFFFU
#define CAN0_MSK8_MASK_BIT 0
#define CAN0_MSK8_MRB_MASK 0x60000000U
#define CAN0_MSK8_MRB_BIT 29
#define CAN0_MSK8_MRTR_MASK 0x80000000U
#define CAN0_MSK8_MRTR 0x80000000U
#define CAN0_MSK8_MRTR_BIT 31

#define CAN0_IR8 (*(volatile unsigned long *)0xFFFD430C)
#define CAN0_IR8_OFFSET 0x30C
#define CAN0_IR8_ID_MASK 0x1FFFFFFFU
#define CAN0_IR8_ID_BIT 0
#define CAN0_IR8_RB_MASK 0x60000000U
#define CAN0_IR8_RB_BIT 29
#define CAN0_IR8_RTR_MASK 0x80000000U
#define CAN0_IR8_RTR 0x80000000U
#define CAN0_IR8_RTR_BIT 31

#define CAN0_CR8 (*(volatile unsigned long *)0xFFFD4310)
#define CAN0_CR8_OFFSET 0x310
#define CAN0_CR8_DLC_MASK 0xFU
#define CAN0_CR8_DLC_BIT 0
#define CAN0_CR8_IDE_MASK 0x10U
#define CAN0_CR8_IDE 0x10U
#define CAN0_CR8_IDE_BIT 4
#define CAN0_CR8_RPLYV_MASK 0x20U
#define CAN0_CR8_RPLYV 0x20U
#define CAN0_CR8_RPLYV_BIT 5
#define CAN0_CR8_PCB_MASK 0x40U
#define CAN0_CR8_PCB 0x40U
#define CAN0_CR8_PCB_BIT 6
#define CAN0_CR8_CHANEN_MASK 0x80U
#define CAN0_CR8_CHANEN 0x80U
#define CAN0_CR8_CHANEN_BIT 7
#define CAN0_CR8_OVERWRITE_MASK 0x100U
#define CAN0_CR8_OVERWRITE 0x100U
#define CAN0_CR8_OVERWRITE_BIT 8

#define CAN0_CR8 (*(volatile unsigned long *)0xFFFD4314)
#define CAN0_CR8_OFFSET 0x314
#define CAN0_CR8_STAMP_MASK 0x0U
#define CAN0_CR8_STAMP_BIT 0

#define CAN0_CSR8 (*(volatile unsigned long *)0xFFFD4318)
#define CAN0_CSR8_OFFSET 0x318
#define CAN0_CSR8_ACK_MASK 0x1U
#define CAN0_CSR8_ACK 0x1U
#define CAN0_CSR8_ACK_BIT 0
#define CAN0_CSR8_FRAME_MASK 0x2U
#define CAN0_CSR8_FRAME 0x2U
#define CAN0_CSR8_FRAME_BIT 1
#define CAN0_CSR8_CRC_MASK 0x4U
#define CAN0_CSR8_CRC 0x4U
#define CAN0_CSR8_CRC_BIT 2
#define CAN0_CSR8_STUFF_MASK 0x8U
#define CAN0_CSR8_STUFF 0x8U
#define CAN0_CSR8_STUFF_BIT 3
#define CAN0_CSR8_BUS_MASK 0x10U
#define CAN0_CSR8_BUS 0x10U
#define CAN0_CSR8_BUS_BIT 4
#define CAN0_CSR8_RXOK_MASK 0x20U
#define CAN0_CSR8_RXOK 0x20U
#define CAN0_CSR8_RXOK_BIT 5
#define CAN0_CSR8_TXOK_MASK 0x40U
#define CAN0_CSR8_TXOK 0x40U
#define CAN0_CSR8_TXOK_BIT 6
#define CAN0_CSR8_RFRAME_MASK 0x80U
#define CAN0_CSR8_RFRAME 0x80U
#define CAN0_CSR8_RFRAME_BIT 7
#define CAN0_CSR8_DLCW_MASK 0x200U
#define CAN0_CSR8_DLCW 0x200U
#define CAN0_CSR8_DLCW_BIT 9
#define CAN0_CSR8_FILLED_MASK 0x400U
#define CAN0_CSR8_FILLED 0x400U
#define CAN0_CSR8_FILLED_BIT 10
#define CAN0_CSR8_OVRUN_MASK 0x800U
#define CAN0_CSR8_OVRUN 0x800U
#define CAN0_CSR8_OVRUN_BIT 11

#define CAN0_SR8 (*(volatile unsigned long *)0xFFFD431C)
#define CAN0_SR8_OFFSET 0x31C
#define CAN0_SR8_ACK_MASK 0x1U
#define CAN0_SR8_ACK 0x1U
#define CAN0_SR8_ACK_BIT 0
#define CAN0_SR8_FRAME_MASK 0x2U
#define CAN0_SR8_FRAME 0x2U
#define CAN0_SR8_FRAME_BIT 1
#define CAN0_SR8_CRC_MASK 0x4U
#define CAN0_SR8_CRC 0x4U
#define CAN0_SR8_CRC_BIT 2
#define CAN0_SR8_STUFF_MASK 0x8U
#define CAN0_SR8_STUFF 0x8U
#define CAN0_SR8_STUFF_BIT 3
#define CAN0_SR8_BUS_MASK 0x10U
#define CAN0_SR8_BUS 0x10U
#define CAN0_SR8_BUS_BIT 4
#define CAN0_SR8_RXOK_MASK 0x20U
#define CAN0_SR8_RXOK 0x20U
#define CAN0_SR8_RXOK_BIT 5
#define CAN0_SR8_TXOK_MASK 0x40U
#define CAN0_SR8_TXOK 0x40U
#define CAN0_SR8_TXOK_BIT 6
#define CAN0_SR8_RFRAME_MASK 0x80U
#define CAN0_SR8_RFRAME 0x80U
#define CAN0_SR8_RFRAME_BIT 7
#define CAN0_SR8_DLCW_MASK 0x200U
#define CAN0_SR8_DLCW 0x200U
#define CAN0_SR8_DLCW_BIT 9
#define CAN0_SR8_FILLED_MASK 0x400U
#define CAN0_SR8_FILLED 0x400U
#define CAN0_SR8_FILLED_BIT 10
#define CAN0_SR8_OVRUN_MASK 0x800U
#define CAN0_SR8_OVRUN 0x800U
#define CAN0_SR8_OVRUN_BIT 11

#define CAN0_IER8 (*(volatile unsigned long *)0xFFFD4320)
#define CAN0_IER8_OFFSET 0x320
#define CAN0_IER8_ACK_MASK 0x1U
#define CAN0_IER8_ACK 0x1U
#define CAN0_IER8_ACK_BIT 0
#define CAN0_IER8_FRAME_MASK 0x2U
#define CAN0_IER8_FRAME 0x2U
#define CAN0_IER8_FRAME_BIT 1
#define CAN0_IER8_CRC_MASK 0x4U
#define CAN0_IER8_CRC 0x4U
#define CAN0_IER8_CRC_BIT 2
#define CAN0_IER8_STUFF_MASK 0x8U
#define CAN0_IER8_STUFF 0x8U
#define CAN0_IER8_STUFF_BIT 3
#define CAN0_IER8_BUS_MASK 0x10U
#define CAN0_IER8_BUS 0x10U
#define CAN0_IER8_BUS_BIT 4
#define CAN0_IER8_RXOK_MASK 0x20U
#define CAN0_IER8_RXOK 0x20U
#define CAN0_IER8_RXOK_BIT 5
#define CAN0_IER8_TXOK_MASK 0x40U
#define CAN0_IER8_TXOK 0x40U
#define CAN0_IER8_TXOK_BIT 6
#define CAN0_IER8_RFRAME_MASK 0x80U
#define CAN0_IER8_RFRAME 0x80U
#define CAN0_IER8_RFRAME_BIT 7

#define CAN0_IDR8 (*(volatile unsigned long *)0xFFFD4324)
#define CAN0_IDR8_OFFSET 0x324
#define CAN0_IDR8_ACK_MASK 0x1U
#define CAN0_IDR8_ACK 0x1U
#define CAN0_IDR8_ACK_BIT 0
#define CAN0_IDR8_FRAME_MASK 0x2U
#define CAN0_IDR8_FRAME 0x2U
#define CAN0_IDR8_FRAME_BIT 1
#define CAN0_IDR8_CRC_MASK 0x4U
#define CAN0_IDR8_CRC 0x4U
#define CAN0_IDR8_CRC_BIT 2
#define CAN0_IDR8_STUFF_MASK 0x8U
#define CAN0_IDR8_STUFF 0x8U
#define CAN0_IDR8_STUFF_BIT 3
#define CAN0_IDR8_BUS_MASK 0x10U
#define CAN0_IDR8_BUS 0x10U
#define CAN0_IDR8_BUS_BIT 4
#define CAN0_IDR8_RXOK_MASK 0x20U
#define CAN0_IDR8_RXOK 0x20U
#define CAN0_IDR8_RXOK_BIT 5
#define CAN0_IDR8_TXOK_MASK 0x40U
#define CAN0_IDR8_TXOK 0x40U
#define CAN0_IDR8_TXOK_BIT 6
#define CAN0_IDR8_RFRAME_MASK 0x80U
#define CAN0_IDR8_RFRAME 0x80U
#define CAN0_IDR8_RFRAME_BIT 7

#define CAN0_IMR8 (*(volatile unsigned long *)0xFFFD4328)
#define CAN0_IMR8_OFFSET 0x328
#define CAN0_IMR8_ACK_MASK 0x1U
#define CAN0_IMR8_ACK 0x1U
#define CAN0_IMR8_ACK_BIT 0
#define CAN0_IMR8_FRAME_MASK 0x2U
#define CAN0_IMR8_FRAME 0x2U
#define CAN0_IMR8_FRAME_BIT 1
#define CAN0_IMR8_CRC_MASK 0x4U
#define CAN0_IMR8_CRC 0x4U
#define CAN0_IMR8_CRC_BIT 2
#define CAN0_IMR8_STUFF_MASK 0x8U
#define CAN0_IMR8_STUFF 0x8U
#define CAN0_IMR8_STUFF_BIT 3
#define CAN0_IMR8_BUS_MASK 0x10U
#define CAN0_IMR8_BUS 0x10U
#define CAN0_IMR8_BUS_BIT 4
#define CAN0_IMR8_RXOK_MASK 0x20U
#define CAN0_IMR8_RXOK 0x20U
#define CAN0_IMR8_RXOK_BIT 5
#define CAN0_IMR8_TXOK_MASK 0x40U
#define CAN0_IMR8_TXOK 0x40U
#define CAN0_IMR8_TXOK_BIT 6
#define CAN0_IMR8_RFRAME_MASK 0x80U
#define CAN0_IMR8_RFRAME 0x80U
#define CAN0_IMR8_RFRAME_BIT 7

#define CAN0_DRA9 (*(volatile unsigned long *)0xFFFD4340)
#define CAN0_DRA9_OFFSET 0x340
#define CAN0_DRA9_DATA0_MASK 0xFFU
#define CAN0_DRA9_DATA0_BIT 0
#define CAN0_DRA9_DATA1_MASK 0xFF00U
#define CAN0_DRA9_DATA1_BIT 8
#define CAN0_DRA9_DATA2_MASK 0xFF0000U
#define CAN0_DRA9_DATA2_BIT 16
#define CAN0_DRA9_DATA3_MASK 0xFF000000U
#define CAN0_DRA9_DATA3_BIT 24

#define CAN0_DRB9 (*(volatile unsigned long *)0xFFFD4344)
#define CAN0_DRB9_OFFSET 0x344
#define CAN0_DRB9_DATA4_MASK 0xFFU
#define CAN0_DRB9_DATA4_BIT 0
#define CAN0_DRB9_DATA5_MASK 0xFF00U
#define CAN0_DRB9_DATA5_BIT 8
#define CAN0_DRB9_DATA6_MASK 0xFF0000U
#define CAN0_DRB9_DATA6_BIT 16
#define CAN0_DRB9_DATA7_MASK 0xFF000000U
#define CAN0_DRB9_DATA7_BIT 24

#define CAN0_MSK9 (*(volatile unsigned long *)0xFFFD4348)
#define CAN0_MSK9_OFFSET 0x348
#define CAN0_MSK9_MASK_MASK 0x1FFFFFFFU
#define CAN0_MSK9_MASK_BIT 0
#define CAN0_MSK9_MRB_MASK 0x60000000U
#define CAN0_MSK9_MRB_BIT 29
#define CAN0_MSK9_MRTR_MASK 0x80000000U
#define CAN0_MSK9_MRTR 0x80000000U
#define CAN0_MSK9_MRTR_BIT 31

#define CAN0_IR9 (*(volatile unsigned long *)0xFFFD434C)
#define CAN0_IR9_OFFSET 0x34C
#define CAN0_IR9_ID_MASK 0x1FFFFFFFU
#define CAN0_IR9_ID_BIT 0
#define CAN0_IR9_RB_MASK 0x60000000U
#define CAN0_IR9_RB_BIT 29
#define CAN0_IR9_RTR_MASK 0x80000000U
#define CAN0_IR9_RTR 0x80000000U
#define CAN0_IR9_RTR_BIT 31

#define CAN0_CR9 (*(volatile unsigned long *)0xFFFD4350)
#define CAN0_CR9_OFFSET 0x350
#define CAN0_CR9_DLC_MASK 0xFU
#define CAN0_CR9_DLC_BIT 0
#define CAN0_CR9_IDE_MASK 0x10U
#define CAN0_CR9_IDE 0x10U
#define CAN0_CR9_IDE_BIT 4
#define CAN0_CR9_RPLYV_MASK 0x20U
#define CAN0_CR9_RPLYV 0x20U
#define CAN0_CR9_RPLYV_BIT 5
#define CAN0_CR9_PCB_MASK 0x40U
#define CAN0_CR9_PCB 0x40U
#define CAN0_CR9_PCB_BIT 6
#define CAN0_CR9_CHANEN_MASK 0x80U
#define CAN0_CR9_CHANEN 0x80U
#define CAN0_CR9_CHANEN_BIT 7
#define CAN0_CR9_OVERWRITE_MASK 0x100U
#define CAN0_CR9_OVERWRITE 0x100U
#define CAN0_CR9_OVERWRITE_BIT 8

#define CAN0_CR9 (*(volatile unsigned long *)0xFFFD4354)
#define CAN0_CR9_OFFSET 0x354
#define CAN0_CR9_STAMP_MASK 0x0U
#define CAN0_CR9_STAMP_BIT 0

#define CAN0_CSR9 (*(volatile unsigned long *)0xFFFD4358)
#define CAN0_CSR9_OFFSET 0x358
#define CAN0_CSR9_ACK_MASK 0x1U
#define CAN0_CSR9_ACK 0x1U
#define CAN0_CSR9_ACK_BIT 0
#define CAN0_CSR9_FRAME_MASK 0x2U
#define CAN0_CSR9_FRAME 0x2U
#define CAN0_CSR9_FRAME_BIT 1
#define CAN0_CSR9_CRC_MASK 0x4U
#define CAN0_CSR9_CRC 0x4U
#define CAN0_CSR9_CRC_BIT 2
#define CAN0_CSR9_STUFF_MASK 0x8U
#define CAN0_CSR9_STUFF 0x8U
#define CAN0_CSR9_STUFF_BIT 3
#define CAN0_CSR9_BUS_MASK 0x10U
#define CAN0_CSR9_BUS 0x10U
#define CAN0_CSR9_BUS_BIT 4
#define CAN0_CSR9_RXOK_MASK 0x20U
#define CAN0_CSR9_RXOK 0x20U
#define CAN0_CSR9_RXOK_BIT 5
#define CAN0_CSR9_TXOK_MASK 0x40U
#define CAN0_CSR9_TXOK 0x40U
#define CAN0_CSR9_TXOK_BIT 6
#define CAN0_CSR9_RFRAME_MASK 0x80U
#define CAN0_CSR9_RFRAME 0x80U
#define CAN0_CSR9_RFRAME_BIT 7
#define CAN0_CSR9_DLCW_MASK 0x200U
#define CAN0_CSR9_DLCW 0x200U
#define CAN0_CSR9_DLCW_BIT 9
#define CAN0_CSR9_FILLED_MASK 0x400U
#define CAN0_CSR9_FILLED 0x400U
#define CAN0_CSR9_FILLED_BIT 10
#define CAN0_CSR9_OVRUN_MASK 0x800U
#define CAN0_CSR9_OVRUN 0x800U
#define CAN0_CSR9_OVRUN_BIT 11

#define CAN0_SR9 (*(volatile unsigned long *)0xFFFD435C)
#define CAN0_SR9_OFFSET 0x35C
#define CAN0_SR9_ACK_MASK 0x1U
#define CAN0_SR9_ACK 0x1U
#define CAN0_SR9_ACK_BIT 0
#define CAN0_SR9_FRAME_MASK 0x2U
#define CAN0_SR9_FRAME 0x2U
#define CAN0_SR9_FRAME_BIT 1
#define CAN0_SR9_CRC_MASK 0x4U
#define CAN0_SR9_CRC 0x4U
#define CAN0_SR9_CRC_BIT 2
#define CAN0_SR9_STUFF_MASK 0x8U
#define CAN0_SR9_STUFF 0x8U
#define CAN0_SR9_STUFF_BIT 3
#define CAN0_SR9_BUS_MASK 0x10U
#define CAN0_SR9_BUS 0x10U
#define CAN0_SR9_BUS_BIT 4
#define CAN0_SR9_RXOK_MASK 0x20U
#define CAN0_SR9_RXOK 0x20U
#define CAN0_SR9_RXOK_BIT 5
#define CAN0_SR9_TXOK_MASK 0x40U
#define CAN0_SR9_TXOK 0x40U
#define CAN0_SR9_TXOK_BIT 6
#define CAN0_SR9_RFRAME_MASK 0x80U
#define CAN0_SR9_RFRAME 0x80U
#define CAN0_SR9_RFRAME_BIT 7
#define CAN0_SR9_DLCW_MASK 0x200U
#define CAN0_SR9_DLCW 0x200U
#define CAN0_SR9_DLCW_BIT 9
#define CAN0_SR9_FILLED_MASK 0x400U
#define CAN0_SR9_FILLED 0x400U
#define CAN0_SR9_FILLED_BIT 10
#define CAN0_SR9_OVRUN_MASK 0x800U
#define CAN0_SR9_OVRUN 0x800U
#define CAN0_SR9_OVRUN_BIT 11

#define CAN0_IER9 (*(volatile unsigned long *)0xFFFD4360)
#define CAN0_IER9_OFFSET 0x360
#define CAN0_IER9_ACK_MASK 0x1U
#define CAN0_IER9_ACK 0x1U
#define CAN0_IER9_ACK_BIT 0
#define CAN0_IER9_FRAME_MASK 0x2U
#define CAN0_IER9_FRAME 0x2U
#define CAN0_IER9_FRAME_BIT 1
#define CAN0_IER9_CRC_MASK 0x4U
#define CAN0_IER9_CRC 0x4U
#define CAN0_IER9_CRC_BIT 2
#define CAN0_IER9_STUFF_MASK 0x8U
#define CAN0_IER9_STUFF 0x8U
#define CAN0_IER9_STUFF_BIT 3
#define CAN0_IER9_BUS_MASK 0x10U
#define CAN0_IER9_BUS 0x10U
#define CAN0_IER9_BUS_BIT 4
#define CAN0_IER9_RXOK_MASK 0x20U
#define CAN0_IER9_RXOK 0x20U
#define CAN0_IER9_RXOK_BIT 5
#define CAN0_IER9_TXOK_MASK 0x40U
#define CAN0_IER9_TXOK 0x40U
#define CAN0_IER9_TXOK_BIT 6
#define CAN0_IER9_RFRAME_MASK 0x80U
#define CAN0_IER9_RFRAME 0x80U
#define CAN0_IER9_RFRAME_BIT 7

#define CAN0_IDR9 (*(volatile unsigned long *)0xFFFD4364)
#define CAN0_IDR9_OFFSET 0x364
#define CAN0_IDR9_ACK_MASK 0x1U
#define CAN0_IDR9_ACK 0x1U
#define CAN0_IDR9_ACK_BIT 0
#define CAN0_IDR9_FRAME_MASK 0x2U
#define CAN0_IDR9_FRAME 0x2U
#define CAN0_IDR9_FRAME_BIT 1
#define CAN0_IDR9_CRC_MASK 0x4U
#define CAN0_IDR9_CRC 0x4U
#define CAN0_IDR9_CRC_BIT 2
#define CAN0_IDR9_STUFF_MASK 0x8U
#define CAN0_IDR9_STUFF 0x8U
#define CAN0_IDR9_STUFF_BIT 3
#define CAN0_IDR9_BUS_MASK 0x10U
#define CAN0_IDR9_BUS 0x10U
#define CAN0_IDR9_BUS_BIT 4
#define CAN0_IDR9_RXOK_MASK 0x20U
#define CAN0_IDR9_RXOK 0x20U
#define CAN0_IDR9_RXOK_BIT 5
#define CAN0_IDR9_TXOK_MASK 0x40U
#define CAN0_IDR9_TXOK 0x40U
#define CAN0_IDR9_TXOK_BIT 6
#define CAN0_IDR9_RFRAME_MASK 0x80U
#define CAN0_IDR9_RFRAME 0x80U
#define CAN0_IDR9_RFRAME_BIT 7

#define CAN0_IMR9 (*(volatile unsigned long *)0xFFFD4368)
#define CAN0_IMR9_OFFSET 0x368
#define CAN0_IMR9_ACK_MASK 0x1U
#define CAN0_IMR9_ACK 0x1U
#define CAN0_IMR9_ACK_BIT 0
#define CAN0_IMR9_FRAME_MASK 0x2U
#define CAN0_IMR9_FRAME 0x2U
#define CAN0_IMR9_FRAME_BIT 1
#define CAN0_IMR9_CRC_MASK 0x4U
#define CAN0_IMR9_CRC 0x4U
#define CAN0_IMR9_CRC_BIT 2
#define CAN0_IMR9_STUFF_MASK 0x8U
#define CAN0_IMR9_STUFF 0x8U
#define CAN0_IMR9_STUFF_BIT 3
#define CAN0_IMR9_BUS_MASK 0x10U
#define CAN0_IMR9_BUS 0x10U
#define CAN0_IMR9_BUS_BIT 4
#define CAN0_IMR9_RXOK_MASK 0x20U
#define CAN0_IMR9_RXOK 0x20U
#define CAN0_IMR9_RXOK_BIT 5
#define CAN0_IMR9_TXOK_MASK 0x40U
#define CAN0_IMR9_TXOK 0x40U
#define CAN0_IMR9_TXOK_BIT 6
#define CAN0_IMR9_RFRAME_MASK 0x80U
#define CAN0_IMR9_RFRAME 0x80U
#define CAN0_IMR9_RFRAME_BIT 7

#define CAN0_DRA10 (*(volatile unsigned long *)0xFFFD4380)
#define CAN0_DRA10_OFFSET 0x380
#define CAN0_DRA10_DATA0_MASK 0xFFU
#define CAN0_DRA10_DATA0_BIT 0
#define CAN0_DRA10_DATA1_MASK 0xFF00U
#define CAN0_DRA10_DATA1_BIT 8
#define CAN0_DRA10_DATA2_MASK 0xFF0000U
#define CAN0_DRA10_DATA2_BIT 16
#define CAN0_DRA10_DATA3_MASK 0xFF000000U
#define CAN0_DRA10_DATA3_BIT 24

#define CAN0_DRB10 (*(volatile unsigned long *)0xFFFD4384)
#define CAN0_DRB10_OFFSET 0x384
#define CAN0_DRB10_DATA4_MASK 0xFFU
#define CAN0_DRB10_DATA4_BIT 0
#define CAN0_DRB10_DATA5_MASK 0xFF00U
#define CAN0_DRB10_DATA5_BIT 8
#define CAN0_DRB10_DATA6_MASK 0xFF0000U
#define CAN0_DRB10_DATA6_BIT 16
#define CAN0_DRB10_DATA7_MASK 0xFF000000U
#define CAN0_DRB10_DATA7_BIT 24

#define CAN0_MSK10 (*(volatile unsigned long *)0xFFFD4388)
#define CAN0_MSK10_OFFSET 0x388
#define CAN0_MSK10_MASK_MASK 0x1FFFFFFFU
#define CAN0_MSK10_MASK_BIT 0
#define CAN0_MSK10_MRB_MASK 0x60000000U
#define CAN0_MSK10_MRB_BIT 29
#define CAN0_MSK10_MRTR_MASK 0x80000000U
#define CAN0_MSK10_MRTR 0x80000000U
#define CAN0_MSK10_MRTR_BIT 31

#define CAN0_IR10 (*(volatile unsigned long *)0xFFFD438C)
#define CAN0_IR10_OFFSET 0x38C
#define CAN0_IR10_ID_MASK 0x1FFFFFFFU
#define CAN0_IR10_ID_BIT 0
#define CAN0_IR10_RB_MASK 0x60000000U
#define CAN0_IR10_RB_BIT 29
#define CAN0_IR10_RTR_MASK 0x80000000U
#define CAN0_IR10_RTR 0x80000000U
#define CAN0_IR10_RTR_BIT 31

#define CAN0_CR10 (*(volatile unsigned long *)0xFFFD4390)
#define CAN0_CR10_OFFSET 0x390
#define CAN0_CR10_DLC_MASK 0xFU
#define CAN0_CR10_DLC_BIT 0
#define CAN0_CR10_IDE_MASK 0x10U
#define CAN0_CR10_IDE 0x10U
#define CAN0_CR10_IDE_BIT 4
#define CAN0_CR10_RPLYV_MASK 0x20U
#define CAN0_CR10_RPLYV 0x20U
#define CAN0_CR10_RPLYV_BIT 5
#define CAN0_CR10_PCB_MASK 0x40U
#define CAN0_CR10_PCB 0x40U
#define CAN0_CR10_PCB_BIT 6
#define CAN0_CR10_CHANEN_MASK 0x80U
#define CAN0_CR10_CHANEN 0x80U
#define CAN0_CR10_CHANEN_BIT 7
#define CAN0_CR10_OVERWRITE_MASK 0x100U
#define CAN0_CR10_OVERWRITE 0x100U
#define CAN0_CR10_OVERWRITE_BIT 8

#define CAN0_CR10 (*(volatile unsigned long *)0xFFFD4394)
#define CAN0_CR10_OFFSET 0x394
#define CAN0_CR10_STAMP_MASK 0x0U
#define CAN0_CR10_STAMP_BIT 0

#define CAN0_CSR10 (*(volatile unsigned long *)0xFFFD4398)
#define CAN0_CSR10_OFFSET 0x398
#define CAN0_CSR10_ACK_MASK 0x1U
#define CAN0_CSR10_ACK 0x1U
#define CAN0_CSR10_ACK_BIT 0
#define CAN0_CSR10_FRAME_MASK 0x2U
#define CAN0_CSR10_FRAME 0x2U
#define CAN0_CSR10_FRAME_BIT 1
#define CAN0_CSR10_CRC_MASK 0x4U
#define CAN0_CSR10_CRC 0x4U
#define CAN0_CSR10_CRC_BIT 2
#define CAN0_CSR10_STUFF_MASK 0x8U
#define CAN0_CSR10_STUFF 0x8U
#define CAN0_CSR10_STUFF_BIT 3
#define CAN0_CSR10_BUS_MASK 0x10U
#define CAN0_CSR10_BUS 0x10U
#define CAN0_CSR10_BUS_BIT 4
#define CAN0_CSR10_RXOK_MASK 0x20U
#define CAN0_CSR10_RXOK 0x20U
#define CAN0_CSR10_RXOK_BIT 5
#define CAN0_CSR10_TXOK_MASK 0x40U
#define CAN0_CSR10_TXOK 0x40U
#define CAN0_CSR10_TXOK_BIT 6
#define CAN0_CSR10_RFRAME_MASK 0x80U
#define CAN0_CSR10_RFRAME 0x80U
#define CAN0_CSR10_RFRAME_BIT 7
#define CAN0_CSR10_DLCW_MASK 0x200U
#define CAN0_CSR10_DLCW 0x200U
#define CAN0_CSR10_DLCW_BIT 9
#define CAN0_CSR10_FILLED_MASK 0x400U
#define CAN0_CSR10_FILLED 0x400U
#define CAN0_CSR10_FILLED_BIT 10
#define CAN0_CSR10_OVRUN_MASK 0x800U
#define CAN0_CSR10_OVRUN 0x800U
#define CAN0_CSR10_OVRUN_BIT 11

#define CAN0_SR10 (*(volatile unsigned long *)0xFFFD439C)
#define CAN0_SR10_OFFSET 0x39C
#define CAN0_SR10_ACK_MASK 0x1U
#define CAN0_SR10_ACK 0x1U
#define CAN0_SR10_ACK_BIT 0
#define CAN0_SR10_FRAME_MASK 0x2U
#define CAN0_SR10_FRAME 0x2U
#define CAN0_SR10_FRAME_BIT 1
#define CAN0_SR10_CRC_MASK 0x4U
#define CAN0_SR10_CRC 0x4U
#define CAN0_SR10_CRC_BIT 2
#define CAN0_SR10_STUFF_MASK 0x8U
#define CAN0_SR10_STUFF 0x8U
#define CAN0_SR10_STUFF_BIT 3
#define CAN0_SR10_BUS_MASK 0x10U
#define CAN0_SR10_BUS 0x10U
#define CAN0_SR10_BUS_BIT 4
#define CAN0_SR10_RXOK_MASK 0x20U
#define CAN0_SR10_RXOK 0x20U
#define CAN0_SR10_RXOK_BIT 5
#define CAN0_SR10_TXOK_MASK 0x40U
#define CAN0_SR10_TXOK 0x40U
#define CAN0_SR10_TXOK_BIT 6
#define CAN0_SR10_RFRAME_MASK 0x80U
#define CAN0_SR10_RFRAME 0x80U
#define CAN0_SR10_RFRAME_BIT 7
#define CAN0_SR10_DLCW_MASK 0x200U
#define CAN0_SR10_DLCW 0x200U
#define CAN0_SR10_DLCW_BIT 9
#define CAN0_SR10_FILLED_MASK 0x400U
#define CAN0_SR10_FILLED 0x400U
#define CAN0_SR10_FILLED_BIT 10
#define CAN0_SR10_OVRUN_MASK 0x800U
#define CAN0_SR10_OVRUN 0x800U
#define CAN0_SR10_OVRUN_BIT 11

#define CAN0_IER10 (*(volatile unsigned long *)0xFFFD43A0)
#define CAN0_IER10_OFFSET 0x3A0
#define CAN0_IER10_ACK_MASK 0x1U
#define CAN0_IER10_ACK 0x1U
#define CAN0_IER10_ACK_BIT 0
#define CAN0_IER10_FRAME_MASK 0x2U
#define CAN0_IER10_FRAME 0x2U
#define CAN0_IER10_FRAME_BIT 1
#define CAN0_IER10_CRC_MASK 0x4U
#define CAN0_IER10_CRC 0x4U
#define CAN0_IER10_CRC_BIT 2
#define CAN0_IER10_STUFF_MASK 0x8U
#define CAN0_IER10_STUFF 0x8U
#define CAN0_IER10_STUFF_BIT 3
#define CAN0_IER10_BUS_MASK 0x10U
#define CAN0_IER10_BUS 0x10U
#define CAN0_IER10_BUS_BIT 4
#define CAN0_IER10_RXOK_MASK 0x20U
#define CAN0_IER10_RXOK 0x20U
#define CAN0_IER10_RXOK_BIT 5
#define CAN0_IER10_TXOK_MASK 0x40U
#define CAN0_IER10_TXOK 0x40U
#define CAN0_IER10_TXOK_BIT 6
#define CAN0_IER10_RFRAME_MASK 0x80U
#define CAN0_IER10_RFRAME 0x80U
#define CAN0_IER10_RFRAME_BIT 7

#define CAN0_IDR10 (*(volatile unsigned long *)0xFFFD43A4)
#define CAN0_IDR10_OFFSET 0x3A4
#define CAN0_IDR10_ACK_MASK 0x1U
#define CAN0_IDR10_ACK 0x1U
#define CAN0_IDR10_ACK_BIT 0
#define CAN0_IDR10_FRAME_MASK 0x2U
#define CAN0_IDR10_FRAME 0x2U
#define CAN0_IDR10_FRAME_BIT 1
#define CAN0_IDR10_CRC_MASK 0x4U
#define CAN0_IDR10_CRC 0x4U
#define CAN0_IDR10_CRC_BIT 2
#define CAN0_IDR10_STUFF_MASK 0x8U
#define CAN0_IDR10_STUFF 0x8U
#define CAN0_IDR10_STUFF_BIT 3
#define CAN0_IDR10_BUS_MASK 0x10U
#define CAN0_IDR10_BUS 0x10U
#define CAN0_IDR10_BUS_BIT 4
#define CAN0_IDR10_RXOK_MASK 0x20U
#define CAN0_IDR10_RXOK 0x20U
#define CAN0_IDR10_RXOK_BIT 5
#define CAN0_IDR10_TXOK_MASK 0x40U
#define CAN0_IDR10_TXOK 0x40U
#define CAN0_IDR10_TXOK_BIT 6
#define CAN0_IDR10_RFRAME_MASK 0x80U
#define CAN0_IDR10_RFRAME 0x80U
#define CAN0_IDR10_RFRAME_BIT 7

#define CAN0_IMR10 (*(volatile unsigned long *)0xFFFD43A8)
#define CAN0_IMR10_OFFSET 0x3A8
#define CAN0_IMR10_ACK_MASK 0x1U
#define CAN0_IMR10_ACK 0x1U
#define CAN0_IMR10_ACK_BIT 0
#define CAN0_IMR10_FRAME_MASK 0x2U
#define CAN0_IMR10_FRAME 0x2U
#define CAN0_IMR10_FRAME_BIT 1
#define CAN0_IMR10_CRC_MASK 0x4U
#define CAN0_IMR10_CRC 0x4U
#define CAN0_IMR10_CRC_BIT 2
#define CAN0_IMR10_STUFF_MASK 0x8U
#define CAN0_IMR10_STUFF 0x8U
#define CAN0_IMR10_STUFF_BIT 3
#define CAN0_IMR10_BUS_MASK 0x10U
#define CAN0_IMR10_BUS 0x10U
#define CAN0_IMR10_BUS_BIT 4
#define CAN0_IMR10_RXOK_MASK 0x20U
#define CAN0_IMR10_RXOK 0x20U
#define CAN0_IMR10_RXOK_BIT 5
#define CAN0_IMR10_TXOK_MASK 0x40U
#define CAN0_IMR10_TXOK 0x40U
#define CAN0_IMR10_TXOK_BIT 6
#define CAN0_IMR10_RFRAME_MASK 0x80U
#define CAN0_IMR10_RFRAME 0x80U
#define CAN0_IMR10_RFRAME_BIT 7

#define CAN0_DRA11 (*(volatile unsigned long *)0xFFFD43C0)
#define CAN0_DRA11_OFFSET 0x3C0
#define CAN0_DRA11_DATA0_MASK 0xFFU
#define CAN0_DRA11_DATA0_BIT 0
#define CAN0_DRA11_DATA1_MASK 0xFF00U
#define CAN0_DRA11_DATA1_BIT 8
#define CAN0_DRA11_DATA2_MASK 0xFF0000U
#define CAN0_DRA11_DATA2_BIT 16
#define CAN0_DRA11_DATA3_MASK 0xFF000000U
#define CAN0_DRA11_DATA3_BIT 24

#define CAN0_DRB11 (*(volatile unsigned long *)0xFFFD43C4)
#define CAN0_DRB11_OFFSET 0x3C4
#define CAN0_DRB11_DATA4_MASK 0xFFU
#define CAN0_DRB11_DATA4_BIT 0
#define CAN0_DRB11_DATA5_MASK 0xFF00U
#define CAN0_DRB11_DATA5_BIT 8
#define CAN0_DRB11_DATA6_MASK 0xFF0000U
#define CAN0_DRB11_DATA6_BIT 16
#define CAN0_DRB11_DATA7_MASK 0xFF000000U
#define CAN0_DRB11_DATA7_BIT 24

#define CAN0_MSK11 (*(volatile unsigned long *)0xFFFD43C8)
#define CAN0_MSK11_OFFSET 0x3C8
#define CAN0_MSK11_MASK_MASK 0x1FFFFFFFU
#define CAN0_MSK11_MASK_BIT 0
#define CAN0_MSK11_MRB_MASK 0x60000000U
#define CAN0_MSK11_MRB_BIT 29
#define CAN0_MSK11_MRTR_MASK 0x80000000U
#define CAN0_MSK11_MRTR 0x80000000U
#define CAN0_MSK11_MRTR_BIT 31

#define CAN0_IR11 (*(volatile unsigned long *)0xFFFD43CC)
#define CAN0_IR11_OFFSET 0x3CC
#define CAN0_IR11_ID_MASK 0x1FFFFFFFU
#define CAN0_IR11_ID_BIT 0
#define CAN0_IR11_RB_MASK 0x60000000U
#define CAN0_IR11_RB_BIT 29
#define CAN0_IR11_RTR_MASK 0x80000000U
#define CAN0_IR11_RTR 0x80000000U
#define CAN0_IR11_RTR_BIT 31

#define CAN0_CR11 (*(volatile unsigned long *)0xFFFD43D0)
#define CAN0_CR11_OFFSET 0x3D0
#define CAN0_CR11_DLC_MASK 0xFU
#define CAN0_CR11_DLC_BIT 0
#define CAN0_CR11_IDE_MASK 0x10U
#define CAN0_CR11_IDE 0x10U
#define CAN0_CR11_IDE_BIT 4
#define CAN0_CR11_RPLYV_MASK 0x20U
#define CAN0_CR11_RPLYV 0x20U
#define CAN0_CR11_RPLYV_BIT 5
#define CAN0_CR11_PCB_MASK 0x40U
#define CAN0_CR11_PCB 0x40U
#define CAN0_CR11_PCB_BIT 6
#define CAN0_CR11_CHANEN_MASK 0x80U
#define CAN0_CR11_CHANEN 0x80U
#define CAN0_CR11_CHANEN_BIT 7
#define CAN0_CR11_OVERWRITE_MASK 0x100U
#define CAN0_CR11_OVERWRITE 0x100U
#define CAN0_CR11_OVERWRITE_BIT 8

#define CAN0_CR11 (*(volatile unsigned long *)0xFFFD43D4)
#define CAN0_CR11_OFFSET 0x3D4
#define CAN0_CR11_STAMP_MASK 0x0U
#define CAN0_CR11_STAMP_BIT 0

#define CAN0_CSR11 (*(volatile unsigned long *)0xFFFD43D8)
#define CAN0_CSR11_OFFSET 0x3D8
#define CAN0_CSR11_ACK_MASK 0x1U
#define CAN0_CSR11_ACK 0x1U
#define CAN0_CSR11_ACK_BIT 0
#define CAN0_CSR11_FRAME_MASK 0x2U
#define CAN0_CSR11_FRAME 0x2U
#define CAN0_CSR11_FRAME_BIT 1
#define CAN0_CSR11_CRC_MASK 0x4U
#define CAN0_CSR11_CRC 0x4U
#define CAN0_CSR11_CRC_BIT 2
#define CAN0_CSR11_STUFF_MASK 0x8U
#define CAN0_CSR11_STUFF 0x8U
#define CAN0_CSR11_STUFF_BIT 3
#define CAN0_CSR11_BUS_MASK 0x10U
#define CAN0_CSR11_BUS 0x10U
#define CAN0_CSR11_BUS_BIT 4
#define CAN0_CSR11_RXOK_MASK 0x20U
#define CAN0_CSR11_RXOK 0x20U
#define CAN0_CSR11_RXOK_BIT 5
#define CAN0_CSR11_TXOK_MASK 0x40U
#define CAN0_CSR11_TXOK 0x40U
#define CAN0_CSR11_TXOK_BIT 6
#define CAN0_CSR11_RFRAME_MASK 0x80U
#define CAN0_CSR11_RFRAME 0x80U
#define CAN0_CSR11_RFRAME_BIT 7
#define CAN0_CSR11_DLCW_MASK 0x200U
#define CAN0_CSR11_DLCW 0x200U
#define CAN0_CSR11_DLCW_BIT 9
#define CAN0_CSR11_FILLED_MASK 0x400U
#define CAN0_CSR11_FILLED 0x400U
#define CAN0_CSR11_FILLED_BIT 10
#define CAN0_CSR11_OVRUN_MASK 0x800U
#define CAN0_CSR11_OVRUN 0x800U
#define CAN0_CSR11_OVRUN_BIT 11

#define CAN0_SR11 (*(volatile unsigned long *)0xFFFD43DC)
#define CAN0_SR11_OFFSET 0x3DC
#define CAN0_SR11_ACK_MASK 0x1U
#define CAN0_SR11_ACK 0x1U
#define CAN0_SR11_ACK_BIT 0
#define CAN0_SR11_FRAME_MASK 0x2U
#define CAN0_SR11_FRAME 0x2U
#define CAN0_SR11_FRAME_BIT 1
#define CAN0_SR11_CRC_MASK 0x4U
#define CAN0_SR11_CRC 0x4U
#define CAN0_SR11_CRC_BIT 2
#define CAN0_SR11_STUFF_MASK 0x8U
#define CAN0_SR11_STUFF 0x8U
#define CAN0_SR11_STUFF_BIT 3
#define CAN0_SR11_BUS_MASK 0x10U
#define CAN0_SR11_BUS 0x10U
#define CAN0_SR11_BUS_BIT 4
#define CAN0_SR11_RXOK_MASK 0x20U
#define CAN0_SR11_RXOK 0x20U
#define CAN0_SR11_RXOK_BIT 5
#define CAN0_SR11_TXOK_MASK 0x40U
#define CAN0_SR11_TXOK 0x40U
#define CAN0_SR11_TXOK_BIT 6
#define CAN0_SR11_RFRAME_MASK 0x80U
#define CAN0_SR11_RFRAME 0x80U
#define CAN0_SR11_RFRAME_BIT 7
#define CAN0_SR11_DLCW_MASK 0x200U
#define CAN0_SR11_DLCW 0x200U
#define CAN0_SR11_DLCW_BIT 9
#define CAN0_SR11_FILLED_MASK 0x400U
#define CAN0_SR11_FILLED 0x400U
#define CAN0_SR11_FILLED_BIT 10
#define CAN0_SR11_OVRUN_MASK 0x800U
#define CAN0_SR11_OVRUN 0x800U
#define CAN0_SR11_OVRUN_BIT 11

#define CAN0_IER11 (*(volatile unsigned long *)0xFFFD43E0)
#define CAN0_IER11_OFFSET 0x3E0
#define CAN0_IER11_ACK_MASK 0x1U
#define CAN0_IER11_ACK 0x1U
#define CAN0_IER11_ACK_BIT 0
#define CAN0_IER11_FRAME_MASK 0x2U
#define CAN0_IER11_FRAME 0x2U
#define CAN0_IER11_FRAME_BIT 1
#define CAN0_IER11_CRC_MASK 0x4U
#define CAN0_IER11_CRC 0x4U
#define CAN0_IER11_CRC_BIT 2
#define CAN0_IER11_STUFF_MASK 0x8U
#define CAN0_IER11_STUFF 0x8U
#define CAN0_IER11_STUFF_BIT 3
#define CAN0_IER11_BUS_MASK 0x10U
#define CAN0_IER11_BUS 0x10U
#define CAN0_IER11_BUS_BIT 4
#define CAN0_IER11_RXOK_MASK 0x20U
#define CAN0_IER11_RXOK 0x20U
#define CAN0_IER11_RXOK_BIT 5
#define CAN0_IER11_TXOK_MASK 0x40U
#define CAN0_IER11_TXOK 0x40U
#define CAN0_IER11_TXOK_BIT 6
#define CAN0_IER11_RFRAME_MASK 0x80U
#define CAN0_IER11_RFRAME 0x80U
#define CAN0_IER11_RFRAME_BIT 7

#define CAN0_IDR11 (*(volatile unsigned long *)0xFFFD43E4)
#define CAN0_IDR11_OFFSET 0x3E4
#define CAN0_IDR11_ACK_MASK 0x1U
#define CAN0_IDR11_ACK 0x1U
#define CAN0_IDR11_ACK_BIT 0
#define CAN0_IDR11_FRAME_MASK 0x2U
#define CAN0_IDR11_FRAME 0x2U
#define CAN0_IDR11_FRAME_BIT 1
#define CAN0_IDR11_CRC_MASK 0x4U
#define CAN0_IDR11_CRC 0x4U
#define CAN0_IDR11_CRC_BIT 2
#define CAN0_IDR11_STUFF_MASK 0x8U
#define CAN0_IDR11_STUFF 0x8U
#define CAN0_IDR11_STUFF_BIT 3
#define CAN0_IDR11_BUS_MASK 0x10U
#define CAN0_IDR11_BUS 0x10U
#define CAN0_IDR11_BUS_BIT 4
#define CAN0_IDR11_RXOK_MASK 0x20U
#define CAN0_IDR11_RXOK 0x20U
#define CAN0_IDR11_RXOK_BIT 5
#define CAN0_IDR11_TXOK_MASK 0x40U
#define CAN0_IDR11_TXOK 0x40U
#define CAN0_IDR11_TXOK_BIT 6
#define CAN0_IDR11_RFRAME_MASK 0x80U
#define CAN0_IDR11_RFRAME 0x80U
#define CAN0_IDR11_RFRAME_BIT 7

#define CAN0_IMR11 (*(volatile unsigned long *)0xFFFD43E8)
#define CAN0_IMR11_OFFSET 0x3E8
#define CAN0_IMR11_ACK_MASK 0x1U
#define CAN0_IMR11_ACK 0x1U
#define CAN0_IMR11_ACK_BIT 0
#define CAN0_IMR11_FRAME_MASK 0x2U
#define CAN0_IMR11_FRAME 0x2U
#define CAN0_IMR11_FRAME_BIT 1
#define CAN0_IMR11_CRC_MASK 0x4U
#define CAN0_IMR11_CRC 0x4U
#define CAN0_IMR11_CRC_BIT 2
#define CAN0_IMR11_STUFF_MASK 0x8U
#define CAN0_IMR11_STUFF 0x8U
#define CAN0_IMR11_STUFF_BIT 3
#define CAN0_IMR11_BUS_MASK 0x10U
#define CAN0_IMR11_BUS 0x10U
#define CAN0_IMR11_BUS_BIT 4
#define CAN0_IMR11_RXOK_MASK 0x20U
#define CAN0_IMR11_RXOK 0x20U
#define CAN0_IMR11_RXOK_BIT 5
#define CAN0_IMR11_TXOK_MASK 0x40U
#define CAN0_IMR11_TXOK 0x40U
#define CAN0_IMR11_TXOK_BIT 6
#define CAN0_IMR11_RFRAME_MASK 0x80U
#define CAN0_IMR11_RFRAME 0x80U
#define CAN0_IMR11_RFRAME_BIT 7

#define CAN0_DRA12 (*(volatile unsigned long *)0xFFFD4400)
#define CAN0_DRA12_OFFSET 0x400
#define CAN0_DRA12_DATA0_MASK 0xFFU
#define CAN0_DRA12_DATA0_BIT 0
#define CAN0_DRA12_DATA1_MASK 0xFF00U
#define CAN0_DRA12_DATA1_BIT 8
#define CAN0_DRA12_DATA2_MASK 0xFF0000U
#define CAN0_DRA12_DATA2_BIT 16
#define CAN0_DRA12_DATA3_MASK 0xFF000000U
#define CAN0_DRA12_DATA3_BIT 24

#define CAN0_DRB12 (*(volatile unsigned long *)0xFFFD4404)
#define CAN0_DRB12_OFFSET 0x404
#define CAN0_DRB12_DATA4_MASK 0xFFU
#define CAN0_DRB12_DATA4_BIT 0
#define CAN0_DRB12_DATA5_MASK 0xFF00U
#define CAN0_DRB12_DATA5_BIT 8
#define CAN0_DRB12_DATA6_MASK 0xFF0000U
#define CAN0_DRB12_DATA6_BIT 16
#define CAN0_DRB12_DATA7_MASK 0xFF000000U
#define CAN0_DRB12_DATA7_BIT 24

#define CAN0_MSK12 (*(volatile unsigned long *)0xFFFD4408)
#define CAN0_MSK12_OFFSET 0x408
#define CAN0_MSK12_MASK_MASK 0x1FFFFFFFU
#define CAN0_MSK12_MASK_BIT 0
#define CAN0_MSK12_MRB_MASK 0x60000000U
#define CAN0_MSK12_MRB_BIT 29
#define CAN0_MSK12_MRTR_MASK 0x80000000U
#define CAN0_MSK12_MRTR 0x80000000U
#define CAN0_MSK12_MRTR_BIT 31

#define CAN0_IR12 (*(volatile unsigned long *)0xFFFD440C)
#define CAN0_IR12_OFFSET 0x40C
#define CAN0_IR12_ID_MASK 0x1FFFFFFFU
#define CAN0_IR12_ID_BIT 0
#define CAN0_IR12_RB_MASK 0x60000000U
#define CAN0_IR12_RB_BIT 29
#define CAN0_IR12_RTR_MASK 0x80000000U
#define CAN0_IR12_RTR 0x80000000U
#define CAN0_IR12_RTR_BIT 31

#define CAN0_CR12 (*(volatile unsigned long *)0xFFFD4410)
#define CAN0_CR12_OFFSET 0x410
#define CAN0_CR12_DLC_MASK 0xFU
#define CAN0_CR12_DLC_BIT 0
#define CAN0_CR12_IDE_MASK 0x10U
#define CAN0_CR12_IDE 0x10U
#define CAN0_CR12_IDE_BIT 4
#define CAN0_CR12_RPLYV_MASK 0x20U
#define CAN0_CR12_RPLYV 0x20U
#define CAN0_CR12_RPLYV_BIT 5
#define CAN0_CR12_PCB_MASK 0x40U
#define CAN0_CR12_PCB 0x40U
#define CAN0_CR12_PCB_BIT 6
#define CAN0_CR12_CHANEN_MASK 0x80U
#define CAN0_CR12_CHANEN 0x80U
#define CAN0_CR12_CHANEN_BIT 7
#define CAN0_CR12_OVERWRITE_MASK 0x100U
#define CAN0_CR12_OVERWRITE 0x100U
#define CAN0_CR12_OVERWRITE_BIT 8

#define CAN0_CR12 (*(volatile unsigned long *)0xFFFD4414)
#define CAN0_CR12_OFFSET 0x414
#define CAN0_CR12_STAMP_MASK 0x0U
#define CAN0_CR12_STAMP_BIT 0

#define CAN0_CSR12 (*(volatile unsigned long *)0xFFFD4418)
#define CAN0_CSR12_OFFSET 0x418
#define CAN0_CSR12_ACK_MASK 0x1U
#define CAN0_CSR12_ACK 0x1U
#define CAN0_CSR12_ACK_BIT 0
#define CAN0_CSR12_FRAME_MASK 0x2U
#define CAN0_CSR12_FRAME 0x2U
#define CAN0_CSR12_FRAME_BIT 1
#define CAN0_CSR12_CRC_MASK 0x4U
#define CAN0_CSR12_CRC 0x4U
#define CAN0_CSR12_CRC_BIT 2
#define CAN0_CSR12_STUFF_MASK 0x8U
#define CAN0_CSR12_STUFF 0x8U
#define CAN0_CSR12_STUFF_BIT 3
#define CAN0_CSR12_BUS_MASK 0x10U
#define CAN0_CSR12_BUS 0x10U
#define CAN0_CSR12_BUS_BIT 4
#define CAN0_CSR12_RXOK_MASK 0x20U
#define CAN0_CSR12_RXOK 0x20U
#define CAN0_CSR12_RXOK_BIT 5
#define CAN0_CSR12_TXOK_MASK 0x40U
#define CAN0_CSR12_TXOK 0x40U
#define CAN0_CSR12_TXOK_BIT 6
#define CAN0_CSR12_RFRAME_MASK 0x80U
#define CAN0_CSR12_RFRAME 0x80U
#define CAN0_CSR12_RFRAME_BIT 7
#define CAN0_CSR12_DLCW_MASK 0x200U
#define CAN0_CSR12_DLCW 0x200U
#define CAN0_CSR12_DLCW_BIT 9
#define CAN0_CSR12_FILLED_MASK 0x400U
#define CAN0_CSR12_FILLED 0x400U
#define CAN0_CSR12_FILLED_BIT 10
#define CAN0_CSR12_OVRUN_MASK 0x800U
#define CAN0_CSR12_OVRUN 0x800U
#define CAN0_CSR12_OVRUN_BIT 11

#define CAN0_SR12 (*(volatile unsigned long *)0xFFFD441C)
#define CAN0_SR12_OFFSET 0x41C
#define CAN0_SR12_ACK_MASK 0x1U
#define CAN0_SR12_ACK 0x1U
#define CAN0_SR12_ACK_BIT 0
#define CAN0_SR12_FRAME_MASK 0x2U
#define CAN0_SR12_FRAME 0x2U
#define CAN0_SR12_FRAME_BIT 1
#define CAN0_SR12_CRC_MASK 0x4U
#define CAN0_SR12_CRC 0x4U
#define CAN0_SR12_CRC_BIT 2
#define CAN0_SR12_STUFF_MASK 0x8U
#define CAN0_SR12_STUFF 0x8U
#define CAN0_SR12_STUFF_BIT 3
#define CAN0_SR12_BUS_MASK 0x10U
#define CAN0_SR12_BUS 0x10U
#define CAN0_SR12_BUS_BIT 4
#define CAN0_SR12_RXOK_MASK 0x20U
#define CAN0_SR12_RXOK 0x20U
#define CAN0_SR12_RXOK_BIT 5
#define CAN0_SR12_TXOK_MASK 0x40U
#define CAN0_SR12_TXOK 0x40U
#define CAN0_SR12_TXOK_BIT 6
#define CAN0_SR12_RFRAME_MASK 0x80U
#define CAN0_SR12_RFRAME 0x80U
#define CAN0_SR12_RFRAME_BIT 7
#define CAN0_SR12_DLCW_MASK 0x200U
#define CAN0_SR12_DLCW 0x200U
#define CAN0_SR12_DLCW_BIT 9
#define CAN0_SR12_FILLED_MASK 0x400U
#define CAN0_SR12_FILLED 0x400U
#define CAN0_SR12_FILLED_BIT 10
#define CAN0_SR12_OVRUN_MASK 0x800U
#define CAN0_SR12_OVRUN 0x800U
#define CAN0_SR12_OVRUN_BIT 11

#define CAN0_IER12 (*(volatile unsigned long *)0xFFFD4420)
#define CAN0_IER12_OFFSET 0x420
#define CAN0_IER12_ACK_MASK 0x1U
#define CAN0_IER12_ACK 0x1U
#define CAN0_IER12_ACK_BIT 0
#define CAN0_IER12_FRAME_MASK 0x2U
#define CAN0_IER12_FRAME 0x2U
#define CAN0_IER12_FRAME_BIT 1
#define CAN0_IER12_CRC_MASK 0x4U
#define CAN0_IER12_CRC 0x4U
#define CAN0_IER12_CRC_BIT 2
#define CAN0_IER12_STUFF_MASK 0x8U
#define CAN0_IER12_STUFF 0x8U
#define CAN0_IER12_STUFF_BIT 3
#define CAN0_IER12_BUS_MASK 0x10U
#define CAN0_IER12_BUS 0x10U
#define CAN0_IER12_BUS_BIT 4
#define CAN0_IER12_RXOK_MASK 0x20U
#define CAN0_IER12_RXOK 0x20U
#define CAN0_IER12_RXOK_BIT 5
#define CAN0_IER12_TXOK_MASK 0x40U
#define CAN0_IER12_TXOK 0x40U
#define CAN0_IER12_TXOK_BIT 6
#define CAN0_IER12_RFRAME_MASK 0x80U
#define CAN0_IER12_RFRAME 0x80U
#define CAN0_IER12_RFRAME_BIT 7

#define CAN0_IDR12 (*(volatile unsigned long *)0xFFFD4424)
#define CAN0_IDR12_OFFSET 0x424
#define CAN0_IDR12_ACK_MASK 0x1U
#define CAN0_IDR12_ACK 0x1U
#define CAN0_IDR12_ACK_BIT 0
#define CAN0_IDR12_FRAME_MASK 0x2U
#define CAN0_IDR12_FRAME 0x2U
#define CAN0_IDR12_FRAME_BIT 1
#define CAN0_IDR12_CRC_MASK 0x4U
#define CAN0_IDR12_CRC 0x4U
#define CAN0_IDR12_CRC_BIT 2
#define CAN0_IDR12_STUFF_MASK 0x8U
#define CAN0_IDR12_STUFF 0x8U
#define CAN0_IDR12_STUFF_BIT 3
#define CAN0_IDR12_BUS_MASK 0x10U
#define CAN0_IDR12_BUS 0x10U
#define CAN0_IDR12_BUS_BIT 4
#define CAN0_IDR12_RXOK_MASK 0x20U
#define CAN0_IDR12_RXOK 0x20U
#define CAN0_IDR12_RXOK_BIT 5
#define CAN0_IDR12_TXOK_MASK 0x40U
#define CAN0_IDR12_TXOK 0x40U
#define CAN0_IDR12_TXOK_BIT 6
#define CAN0_IDR12_RFRAME_MASK 0x80U
#define CAN0_IDR12_RFRAME 0x80U
#define CAN0_IDR12_RFRAME_BIT 7

#define CAN0_IMR12 (*(volatile unsigned long *)0xFFFD4428)
#define CAN0_IMR12_OFFSET 0x428
#define CAN0_IMR12_ACK_MASK 0x1U
#define CAN0_IMR12_ACK 0x1U
#define CAN0_IMR12_ACK_BIT 0
#define CAN0_IMR12_FRAME_MASK 0x2U
#define CAN0_IMR12_FRAME 0x2U
#define CAN0_IMR12_FRAME_BIT 1
#define CAN0_IMR12_CRC_MASK 0x4U
#define CAN0_IMR12_CRC 0x4U
#define CAN0_IMR12_CRC_BIT 2
#define CAN0_IMR12_STUFF_MASK 0x8U
#define CAN0_IMR12_STUFF 0x8U
#define CAN0_IMR12_STUFF_BIT 3
#define CAN0_IMR12_BUS_MASK 0x10U
#define CAN0_IMR12_BUS 0x10U
#define CAN0_IMR12_BUS_BIT 4
#define CAN0_IMR12_RXOK_MASK 0x20U
#define CAN0_IMR12_RXOK 0x20U
#define CAN0_IMR12_RXOK_BIT 5
#define CAN0_IMR12_TXOK_MASK 0x40U
#define CAN0_IMR12_TXOK 0x40U
#define CAN0_IMR12_TXOK_BIT 6
#define CAN0_IMR12_RFRAME_MASK 0x80U
#define CAN0_IMR12_RFRAME 0x80U
#define CAN0_IMR12_RFRAME_BIT 7

#define CAN0_DRA13 (*(volatile unsigned long *)0xFFFD4440)
#define CAN0_DRA13_OFFSET 0x440
#define CAN0_DRA13_DATA0_MASK 0xFFU
#define CAN0_DRA13_DATA0_BIT 0
#define CAN0_DRA13_DATA1_MASK 0xFF00U
#define CAN0_DRA13_DATA1_BIT 8
#define CAN0_DRA13_DATA2_MASK 0xFF0000U
#define CAN0_DRA13_DATA2_BIT 16
#define CAN0_DRA13_DATA3_MASK 0xFF000000U
#define CAN0_DRA13_DATA3_BIT 24

#define CAN0_DRB13 (*(volatile unsigned long *)0xFFFD4444)
#define CAN0_DRB13_OFFSET 0x444
#define CAN0_DRB13_DATA4_MASK 0xFFU
#define CAN0_DRB13_DATA4_BIT 0
#define CAN0_DRB13_DATA5_MASK 0xFF00U
#define CAN0_DRB13_DATA5_BIT 8
#define CAN0_DRB13_DATA6_MASK 0xFF0000U
#define CAN0_DRB13_DATA6_BIT 16
#define CAN0_DRB13_DATA7_MASK 0xFF000000U
#define CAN0_DRB13_DATA7_BIT 24

#define CAN0_MSK13 (*(volatile unsigned long *)0xFFFD4448)
#define CAN0_MSK13_OFFSET 0x448
#define CAN0_MSK13_MASK_MASK 0x1FFFFFFFU
#define CAN0_MSK13_MASK_BIT 0
#define CAN0_MSK13_MRB_MASK 0x60000000U
#define CAN0_MSK13_MRB_BIT 29
#define CAN0_MSK13_MRTR_MASK 0x80000000U
#define CAN0_MSK13_MRTR 0x80000000U
#define CAN0_MSK13_MRTR_BIT 31

#define CAN0_IR13 (*(volatile unsigned long *)0xFFFD444C)
#define CAN0_IR13_OFFSET 0x44C
#define CAN0_IR13_ID_MASK 0x1FFFFFFFU
#define CAN0_IR13_ID_BIT 0
#define CAN0_IR13_RB_MASK 0x60000000U
#define CAN0_IR13_RB_BIT 29
#define CAN0_IR13_RTR_MASK 0x80000000U
#define CAN0_IR13_RTR 0x80000000U
#define CAN0_IR13_RTR_BIT 31

#define CAN0_CR13 (*(volatile unsigned long *)0xFFFD4450)
#define CAN0_CR13_OFFSET 0x450
#define CAN0_CR13_DLC_MASK 0xFU
#define CAN0_CR13_DLC_BIT 0
#define CAN0_CR13_IDE_MASK 0x10U
#define CAN0_CR13_IDE 0x10U
#define CAN0_CR13_IDE_BIT 4
#define CAN0_CR13_RPLYV_MASK 0x20U
#define CAN0_CR13_RPLYV 0x20U
#define CAN0_CR13_RPLYV_BIT 5
#define CAN0_CR13_PCB_MASK 0x40U
#define CAN0_CR13_PCB 0x40U
#define CAN0_CR13_PCB_BIT 6
#define CAN0_CR13_CHANEN_MASK 0x80U
#define CAN0_CR13_CHANEN 0x80U
#define CAN0_CR13_CHANEN_BIT 7
#define CAN0_CR13_OVERWRITE_MASK 0x100U
#define CAN0_CR13_OVERWRITE 0x100U
#define CAN0_CR13_OVERWRITE_BIT 8

#define CAN0_CR13 (*(volatile unsigned long *)0xFFFD4454)
#define CAN0_CR13_OFFSET 0x454
#define CAN0_CR13_STAMP_MASK 0x0U
#define CAN0_CR13_STAMP_BIT 0

#define CAN0_CSR13 (*(volatile unsigned long *)0xFFFD4458)
#define CAN0_CSR13_OFFSET 0x458
#define CAN0_CSR13_ACK_MASK 0x1U
#define CAN0_CSR13_ACK 0x1U
#define CAN0_CSR13_ACK_BIT 0
#define CAN0_CSR13_FRAME_MASK 0x2U
#define CAN0_CSR13_FRAME 0x2U
#define CAN0_CSR13_FRAME_BIT 1
#define CAN0_CSR13_CRC_MASK 0x4U
#define CAN0_CSR13_CRC 0x4U
#define CAN0_CSR13_CRC_BIT 2
#define CAN0_CSR13_STUFF_MASK 0x8U
#define CAN0_CSR13_STUFF 0x8U
#define CAN0_CSR13_STUFF_BIT 3
#define CAN0_CSR13_BUS_MASK 0x10U
#define CAN0_CSR13_BUS 0x10U
#define CAN0_CSR13_BUS_BIT 4
#define CAN0_CSR13_RXOK_MASK 0x20U
#define CAN0_CSR13_RXOK 0x20U
#define CAN0_CSR13_RXOK_BIT 5
#define CAN0_CSR13_TXOK_MASK 0x40U
#define CAN0_CSR13_TXOK 0x40U
#define CAN0_CSR13_TXOK_BIT 6
#define CAN0_CSR13_RFRAME_MASK 0x80U
#define CAN0_CSR13_RFRAME 0x80U
#define CAN0_CSR13_RFRAME_BIT 7
#define CAN0_CSR13_DLCW_MASK 0x200U
#define CAN0_CSR13_DLCW 0x200U
#define CAN0_CSR13_DLCW_BIT 9
#define CAN0_CSR13_FILLED_MASK 0x400U
#define CAN0_CSR13_FILLED 0x400U
#define CAN0_CSR13_FILLED_BIT 10
#define CAN0_CSR13_OVRUN_MASK 0x800U
#define CAN0_CSR13_OVRUN 0x800U
#define CAN0_CSR13_OVRUN_BIT 11

#define CAN0_SR13 (*(volatile unsigned long *)0xFFFD445C)
#define CAN0_SR13_OFFSET 0x45C
#define CAN0_SR13_ACK_MASK 0x1U
#define CAN0_SR13_ACK 0x1U
#define CAN0_SR13_ACK_BIT 0
#define CAN0_SR13_FRAME_MASK 0x2U
#define CAN0_SR13_FRAME 0x2U
#define CAN0_SR13_FRAME_BIT 1
#define CAN0_SR13_CRC_MASK 0x4U
#define CAN0_SR13_CRC 0x4U
#define CAN0_SR13_CRC_BIT 2
#define CAN0_SR13_STUFF_MASK 0x8U
#define CAN0_SR13_STUFF 0x8U
#define CAN0_SR13_STUFF_BIT 3
#define CAN0_SR13_BUS_MASK 0x10U
#define CAN0_SR13_BUS 0x10U
#define CAN0_SR13_BUS_BIT 4
#define CAN0_SR13_RXOK_MASK 0x20U
#define CAN0_SR13_RXOK 0x20U
#define CAN0_SR13_RXOK_BIT 5
#define CAN0_SR13_TXOK_MASK 0x40U
#define CAN0_SR13_TXOK 0x40U
#define CAN0_SR13_TXOK_BIT 6
#define CAN0_SR13_RFRAME_MASK 0x80U
#define CAN0_SR13_RFRAME 0x80U
#define CAN0_SR13_RFRAME_BIT 7
#define CAN0_SR13_DLCW_MASK 0x200U
#define CAN0_SR13_DLCW 0x200U
#define CAN0_SR13_DLCW_BIT 9
#define CAN0_SR13_FILLED_MASK 0x400U
#define CAN0_SR13_FILLED 0x400U
#define CAN0_SR13_FILLED_BIT 10
#define CAN0_SR13_OVRUN_MASK 0x800U
#define CAN0_SR13_OVRUN 0x800U
#define CAN0_SR13_OVRUN_BIT 11

#define CAN0_IER13 (*(volatile unsigned long *)0xFFFD4460)
#define CAN0_IER13_OFFSET 0x460
#define CAN0_IER13_ACK_MASK 0x1U
#define CAN0_IER13_ACK 0x1U
#define CAN0_IER13_ACK_BIT 0
#define CAN0_IER13_FRAME_MASK 0x2U
#define CAN0_IER13_FRAME 0x2U
#define CAN0_IER13_FRAME_BIT 1
#define CAN0_IER13_CRC_MASK 0x4U
#define CAN0_IER13_CRC 0x4U
#define CAN0_IER13_CRC_BIT 2
#define CAN0_IER13_STUFF_MASK 0x8U
#define CAN0_IER13_STUFF 0x8U
#define CAN0_IER13_STUFF_BIT 3
#define CAN0_IER13_BUS_MASK 0x10U
#define CAN0_IER13_BUS 0x10U
#define CAN0_IER13_BUS_BIT 4
#define CAN0_IER13_RXOK_MASK 0x20U
#define CAN0_IER13_RXOK 0x20U
#define CAN0_IER13_RXOK_BIT 5
#define CAN0_IER13_TXOK_MASK 0x40U
#define CAN0_IER13_TXOK 0x40U
#define CAN0_IER13_TXOK_BIT 6
#define CAN0_IER13_RFRAME_MASK 0x80U
#define CAN0_IER13_RFRAME 0x80U
#define CAN0_IER13_RFRAME_BIT 7

#define CAN0_IDR13 (*(volatile unsigned long *)0xFFFD4464)
#define CAN0_IDR13_OFFSET 0x464
#define CAN0_IDR13_ACK_MASK 0x1U
#define CAN0_IDR13_ACK 0x1U
#define CAN0_IDR13_ACK_BIT 0
#define CAN0_IDR13_FRAME_MASK 0x2U
#define CAN0_IDR13_FRAME 0x2U
#define CAN0_IDR13_FRAME_BIT 1
#define CAN0_IDR13_CRC_MASK 0x4U
#define CAN0_IDR13_CRC 0x4U
#define CAN0_IDR13_CRC_BIT 2
#define CAN0_IDR13_STUFF_MASK 0x8U
#define CAN0_IDR13_STUFF 0x8U
#define CAN0_IDR13_STUFF_BIT 3
#define CAN0_IDR13_BUS_MASK 0x10U
#define CAN0_IDR13_BUS 0x10U
#define CAN0_IDR13_BUS_BIT 4
#define CAN0_IDR13_RXOK_MASK 0x20U
#define CAN0_IDR13_RXOK 0x20U
#define CAN0_IDR13_RXOK_BIT 5
#define CAN0_IDR13_TXOK_MASK 0x40U
#define CAN0_IDR13_TXOK 0x40U
#define CAN0_IDR13_TXOK_BIT 6
#define CAN0_IDR13_RFRAME_MASK 0x80U
#define CAN0_IDR13_RFRAME 0x80U
#define CAN0_IDR13_RFRAME_BIT 7

#define CAN0_IMR13 (*(volatile unsigned long *)0xFFFD4468)
#define CAN0_IMR13_OFFSET 0x468
#define CAN0_IMR13_ACK_MASK 0x1U
#define CAN0_IMR13_ACK 0x1U
#define CAN0_IMR13_ACK_BIT 0
#define CAN0_IMR13_FRAME_MASK 0x2U
#define CAN0_IMR13_FRAME 0x2U
#define CAN0_IMR13_FRAME_BIT 1
#define CAN0_IMR13_CRC_MASK 0x4U
#define CAN0_IMR13_CRC 0x4U
#define CAN0_IMR13_CRC_BIT 2
#define CAN0_IMR13_STUFF_MASK 0x8U
#define CAN0_IMR13_STUFF 0x8U
#define CAN0_IMR13_STUFF_BIT 3
#define CAN0_IMR13_BUS_MASK 0x10U
#define CAN0_IMR13_BUS 0x10U
#define CAN0_IMR13_BUS_BIT 4
#define CAN0_IMR13_RXOK_MASK 0x20U
#define CAN0_IMR13_RXOK 0x20U
#define CAN0_IMR13_RXOK_BIT 5
#define CAN0_IMR13_TXOK_MASK 0x40U
#define CAN0_IMR13_TXOK 0x40U
#define CAN0_IMR13_TXOK_BIT 6
#define CAN0_IMR13_RFRAME_MASK 0x80U
#define CAN0_IMR13_RFRAME 0x80U
#define CAN0_IMR13_RFRAME_BIT 7

#define CAN0_DRA14 (*(volatile unsigned long *)0xFFFD4480)
#define CAN0_DRA14_OFFSET 0x480
#define CAN0_DRA14_DATA0_MASK 0xFFU
#define CAN0_DRA14_DATA0_BIT 0
#define CAN0_DRA14_DATA1_MASK 0xFF00U
#define CAN0_DRA14_DATA1_BIT 8
#define CAN0_DRA14_DATA2_MASK 0xFF0000U
#define CAN0_DRA14_DATA2_BIT 16
#define CAN0_DRA14_DATA3_MASK 0xFF000000U
#define CAN0_DRA14_DATA3_BIT 24

#define CAN0_DRB14 (*(volatile unsigned long *)0xFFFD4484)
#define CAN0_DRB14_OFFSET 0x484
#define CAN0_DRB14_DATA4_MASK 0xFFU
#define CAN0_DRB14_DATA4_BIT 0
#define CAN0_DRB14_DATA5_MASK 0xFF00U
#define CAN0_DRB14_DATA5_BIT 8
#define CAN0_DRB14_DATA6_MASK 0xFF0000U
#define CAN0_DRB14_DATA6_BIT 16
#define CAN0_DRB14_DATA7_MASK 0xFF000000U
#define CAN0_DRB14_DATA7_BIT 24

#define CAN0_MSK14 (*(volatile unsigned long *)0xFFFD4488)
#define CAN0_MSK14_OFFSET 0x488
#define CAN0_MSK14_MASK_MASK 0x1FFFFFFFU
#define CAN0_MSK14_MASK_BIT 0
#define CAN0_MSK14_MRB_MASK 0x60000000U
#define CAN0_MSK14_MRB_BIT 29
#define CAN0_MSK14_MRTR_MASK 0x80000000U
#define CAN0_MSK14_MRTR 0x80000000U
#define CAN0_MSK14_MRTR_BIT 31

#define CAN0_IR14 (*(volatile unsigned long *)0xFFFD448C)
#define CAN0_IR14_OFFSET 0x48C
#define CAN0_IR14_ID_MASK 0x1FFFFFFFU
#define CAN0_IR14_ID_BIT 0
#define CAN0_IR14_RB_MASK 0x60000000U
#define CAN0_IR14_RB_BIT 29
#define CAN0_IR14_RTR_MASK 0x80000000U
#define CAN0_IR14_RTR 0x80000000U
#define CAN0_IR14_RTR_BIT 31

#define CAN0_CR14 (*(volatile unsigned long *)0xFFFD4490)
#define CAN0_CR14_OFFSET 0x490
#define CAN0_CR14_DLC_MASK 0xFU
#define CAN0_CR14_DLC_BIT 0
#define CAN0_CR14_IDE_MASK 0x10U
#define CAN0_CR14_IDE 0x10U
#define CAN0_CR14_IDE_BIT 4
#define CAN0_CR14_RPLYV_MASK 0x20U
#define CAN0_CR14_RPLYV 0x20U
#define CAN0_CR14_RPLYV_BIT 5
#define CAN0_CR14_PCB_MASK 0x40U
#define CAN0_CR14_PCB 0x40U
#define CAN0_CR14_PCB_BIT 6
#define CAN0_CR14_CHANEN_MASK 0x80U
#define CAN0_CR14_CHANEN 0x80U
#define CAN0_CR14_CHANEN_BIT 7
#define CAN0_CR14_OVERWRITE_MASK 0x100U
#define CAN0_CR14_OVERWRITE 0x100U
#define CAN0_CR14_OVERWRITE_BIT 8

#define CAN0_CR14 (*(volatile unsigned long *)0xFFFD4494)
#define CAN0_CR14_OFFSET 0x494
#define CAN0_CR14_STAMP_MASK 0x0U
#define CAN0_CR14_STAMP_BIT 0

#define CAN0_CSR14 (*(volatile unsigned long *)0xFFFD4498)
#define CAN0_CSR14_OFFSET 0x498
#define CAN0_CSR14_ACK_MASK 0x1U
#define CAN0_CSR14_ACK 0x1U
#define CAN0_CSR14_ACK_BIT 0
#define CAN0_CSR14_FRAME_MASK 0x2U
#define CAN0_CSR14_FRAME 0x2U
#define CAN0_CSR14_FRAME_BIT 1
#define CAN0_CSR14_CRC_MASK 0x4U
#define CAN0_CSR14_CRC 0x4U
#define CAN0_CSR14_CRC_BIT 2
#define CAN0_CSR14_STUFF_MASK 0x8U
#define CAN0_CSR14_STUFF 0x8U
#define CAN0_CSR14_STUFF_BIT 3
#define CAN0_CSR14_BUS_MASK 0x10U
#define CAN0_CSR14_BUS 0x10U
#define CAN0_CSR14_BUS_BIT 4
#define CAN0_CSR14_RXOK_MASK 0x20U
#define CAN0_CSR14_RXOK 0x20U
#define CAN0_CSR14_RXOK_BIT 5
#define CAN0_CSR14_TXOK_MASK 0x40U
#define CAN0_CSR14_TXOK 0x40U
#define CAN0_CSR14_TXOK_BIT 6
#define CAN0_CSR14_RFRAME_MASK 0x80U
#define CAN0_CSR14_RFRAME 0x80U
#define CAN0_CSR14_RFRAME_BIT 7
#define CAN0_CSR14_DLCW_MASK 0x200U
#define CAN0_CSR14_DLCW 0x200U
#define CAN0_CSR14_DLCW_BIT 9
#define CAN0_CSR14_FILLED_MASK 0x400U
#define CAN0_CSR14_FILLED 0x400U
#define CAN0_CSR14_FILLED_BIT 10
#define CAN0_CSR14_OVRUN_MASK 0x800U
#define CAN0_CSR14_OVRUN 0x800U
#define CAN0_CSR14_OVRUN_BIT 11

#define CAN0_SR14 (*(volatile unsigned long *)0xFFFD449C)
#define CAN0_SR14_OFFSET 0x49C
#define CAN0_SR14_ACK_MASK 0x1U
#define CAN0_SR14_ACK 0x1U
#define CAN0_SR14_ACK_BIT 0
#define CAN0_SR14_FRAME_MASK 0x2U
#define CAN0_SR14_FRAME 0x2U
#define CAN0_SR14_FRAME_BIT 1
#define CAN0_SR14_CRC_MASK 0x4U
#define CAN0_SR14_CRC 0x4U
#define CAN0_SR14_CRC_BIT 2
#define CAN0_SR14_STUFF_MASK 0x8U
#define CAN0_SR14_STUFF 0x8U
#define CAN0_SR14_STUFF_BIT 3
#define CAN0_SR14_BUS_MASK 0x10U
#define CAN0_SR14_BUS 0x10U
#define CAN0_SR14_BUS_BIT 4
#define CAN0_SR14_RXOK_MASK 0x20U
#define CAN0_SR14_RXOK 0x20U
#define CAN0_SR14_RXOK_BIT 5
#define CAN0_SR14_TXOK_MASK 0x40U
#define CAN0_SR14_TXOK 0x40U
#define CAN0_SR14_TXOK_BIT 6
#define CAN0_SR14_RFRAME_MASK 0x80U
#define CAN0_SR14_RFRAME 0x80U
#define CAN0_SR14_RFRAME_BIT 7
#define CAN0_SR14_DLCW_MASK 0x200U
#define CAN0_SR14_DLCW 0x200U
#define CAN0_SR14_DLCW_BIT 9
#define CAN0_SR14_FILLED_MASK 0x400U
#define CAN0_SR14_FILLED 0x400U
#define CAN0_SR14_FILLED_BIT 10
#define CAN0_SR14_OVRUN_MASK 0x800U
#define CAN0_SR14_OVRUN 0x800U
#define CAN0_SR14_OVRUN_BIT 11

#define CAN0_IER14 (*(volatile unsigned long *)0xFFFD44A0)
#define CAN0_IER14_OFFSET 0x4A0
#define CAN0_IER14_ACK_MASK 0x1U
#define CAN0_IER14_ACK 0x1U
#define CAN0_IER14_ACK_BIT 0
#define CAN0_IER14_FRAME_MASK 0x2U
#define CAN0_IER14_FRAME 0x2U
#define CAN0_IER14_FRAME_BIT 1
#define CAN0_IER14_CRC_MASK 0x4U
#define CAN0_IER14_CRC 0x4U
#define CAN0_IER14_CRC_BIT 2
#define CAN0_IER14_STUFF_MASK 0x8U
#define CAN0_IER14_STUFF 0x8U
#define CAN0_IER14_STUFF_BIT 3
#define CAN0_IER14_BUS_MASK 0x10U
#define CAN0_IER14_BUS 0x10U
#define CAN0_IER14_BUS_BIT 4
#define CAN0_IER14_RXOK_MASK 0x20U
#define CAN0_IER14_RXOK 0x20U
#define CAN0_IER14_RXOK_BIT 5
#define CAN0_IER14_TXOK_MASK 0x40U
#define CAN0_IER14_TXOK 0x40U
#define CAN0_IER14_TXOK_BIT 6
#define CAN0_IER14_RFRAME_MASK 0x80U
#define CAN0_IER14_RFRAME 0x80U
#define CAN0_IER14_RFRAME_BIT 7

#define CAN0_IDR14 (*(volatile unsigned long *)0xFFFD44A4)
#define CAN0_IDR14_OFFSET 0x4A4
#define CAN0_IDR14_ACK_MASK 0x1U
#define CAN0_IDR14_ACK 0x1U
#define CAN0_IDR14_ACK_BIT 0
#define CAN0_IDR14_FRAME_MASK 0x2U
#define CAN0_IDR14_FRAME 0x2U
#define CAN0_IDR14_FRAME_BIT 1
#define CAN0_IDR14_CRC_MASK 0x4U
#define CAN0_IDR14_CRC 0x4U
#define CAN0_IDR14_CRC_BIT 2
#define CAN0_IDR14_STUFF_MASK 0x8U
#define CAN0_IDR14_STUFF 0x8U
#define CAN0_IDR14_STUFF_BIT 3
#define CAN0_IDR14_BUS_MASK 0x10U
#define CAN0_IDR14_BUS 0x10U
#define CAN0_IDR14_BUS_BIT 4
#define CAN0_IDR14_RXOK_MASK 0x20U
#define CAN0_IDR14_RXOK 0x20U
#define CAN0_IDR14_RXOK_BIT 5
#define CAN0_IDR14_TXOK_MASK 0x40U
#define CAN0_IDR14_TXOK 0x40U
#define CAN0_IDR14_TXOK_BIT 6
#define CAN0_IDR14_RFRAME_MASK 0x80U
#define CAN0_IDR14_RFRAME 0x80U
#define CAN0_IDR14_RFRAME_BIT 7

#define CAN0_IMR14 (*(volatile unsigned long *)0xFFFD44A8)
#define CAN0_IMR14_OFFSET 0x4A8
#define CAN0_IMR14_ACK_MASK 0x1U
#define CAN0_IMR14_ACK 0x1U
#define CAN0_IMR14_ACK_BIT 0
#define CAN0_IMR14_FRAME_MASK 0x2U
#define CAN0_IMR14_FRAME 0x2U
#define CAN0_IMR14_FRAME_BIT 1
#define CAN0_IMR14_CRC_MASK 0x4U
#define CAN0_IMR14_CRC 0x4U
#define CAN0_IMR14_CRC_BIT 2
#define CAN0_IMR14_STUFF_MASK 0x8U
#define CAN0_IMR14_STUFF 0x8U
#define CAN0_IMR14_STUFF_BIT 3
#define CAN0_IMR14_BUS_MASK 0x10U
#define CAN0_IMR14_BUS 0x10U
#define CAN0_IMR14_BUS_BIT 4
#define CAN0_IMR14_RXOK_MASK 0x20U
#define CAN0_IMR14_RXOK 0x20U
#define CAN0_IMR14_RXOK_BIT 5
#define CAN0_IMR14_TXOK_MASK 0x40U
#define CAN0_IMR14_TXOK 0x40U
#define CAN0_IMR14_TXOK_BIT 6
#define CAN0_IMR14_RFRAME_MASK 0x80U
#define CAN0_IMR14_RFRAME 0x80U
#define CAN0_IMR14_RFRAME_BIT 7

#define CAN0_DRA15 (*(volatile unsigned long *)0xFFFD44C0)
#define CAN0_DRA15_OFFSET 0x4C0
#define CAN0_DRA15_DATA0_MASK 0xFFU
#define CAN0_DRA15_DATA0_BIT 0
#define CAN0_DRA15_DATA1_MASK 0xFF00U
#define CAN0_DRA15_DATA1_BIT 8
#define CAN0_DRA15_DATA2_MASK 0xFF0000U
#define CAN0_DRA15_DATA2_BIT 16
#define CAN0_DRA15_DATA3_MASK 0xFF000000U
#define CAN0_DRA15_DATA3_BIT 24

#define CAN0_DRB15 (*(volatile unsigned long *)0xFFFD44C4)
#define CAN0_DRB15_OFFSET 0x4C4
#define CAN0_DRB15_DATA4_MASK 0xFFU
#define CAN0_DRB15_DATA4_BIT 0
#define CAN0_DRB15_DATA5_MASK 0xFF00U
#define CAN0_DRB15_DATA5_BIT 8
#define CAN0_DRB15_DATA6_MASK 0xFF0000U
#define CAN0_DRB15_DATA6_BIT 16
#define CAN0_DRB15_DATA7_MASK 0xFF000000U
#define CAN0_DRB15_DATA7_BIT 24

#define CAN0_MSK15 (*(volatile unsigned long *)0xFFFD44C8)
#define CAN0_MSK15_OFFSET 0x4C8
#define CAN0_MSK15_MASK_MASK 0x1FFFFFFFU
#define CAN0_MSK15_MASK_BIT 0
#define CAN0_MSK15_MRB_MASK 0x60000000U
#define CAN0_MSK15_MRB_BIT 29
#define CAN0_MSK15_MRTR_MASK 0x80000000U
#define CAN0_MSK15_MRTR 0x80000000U
#define CAN0_MSK15_MRTR_BIT 31

#define CAN0_IR15 (*(volatile unsigned long *)0xFFFD44CC)
#define CAN0_IR15_OFFSET 0x4CC
#define CAN0_IR15_ID_MASK 0x1FFFFFFFU
#define CAN0_IR15_ID_BIT 0
#define CAN0_IR15_RB_MASK 0x60000000U
#define CAN0_IR15_RB_BIT 29
#define CAN0_IR15_RTR_MASK 0x80000000U
#define CAN0_IR15_RTR 0x80000000U
#define CAN0_IR15_RTR_BIT 31

#define CAN0_CR15 (*(volatile unsigned long *)0xFFFD44D0)
#define CAN0_CR15_OFFSET 0x4D0
#define CAN0_CR15_DLC_MASK 0xFU
#define CAN0_CR15_DLC_BIT 0
#define CAN0_CR15_IDE_MASK 0x10U
#define CAN0_CR15_IDE 0x10U
#define CAN0_CR15_IDE_BIT 4
#define CAN0_CR15_RPLYV_MASK 0x20U
#define CAN0_CR15_RPLYV 0x20U
#define CAN0_CR15_RPLYV_BIT 5
#define CAN0_CR15_PCB_MASK 0x40U
#define CAN0_CR15_PCB 0x40U
#define CAN0_CR15_PCB_BIT 6
#define CAN0_CR15_CHANEN_MASK 0x80U
#define CAN0_CR15_CHANEN 0x80U
#define CAN0_CR15_CHANEN_BIT 7
#define CAN0_CR15_OVERWRITE_MASK 0x100U
#define CAN0_CR15_OVERWRITE 0x100U
#define CAN0_CR15_OVERWRITE_BIT 8

#define CAN0_CR15 (*(volatile unsigned long *)0xFFFD44D4)
#define CAN0_CR15_OFFSET 0x4D4
#define CAN0_CR15_STAMP_MASK 0x0U
#define CAN0_CR15_STAMP_BIT 0

#define CAN0_CSR15 (*(volatile unsigned long *)0xFFFD44D8)
#define CAN0_CSR15_OFFSET 0x4D8
#define CAN0_CSR15_ACK_MASK 0x1U
#define CAN0_CSR15_ACK 0x1U
#define CAN0_CSR15_ACK_BIT 0
#define CAN0_CSR15_FRAME_MASK 0x2U
#define CAN0_CSR15_FRAME 0x2U
#define CAN0_CSR15_FRAME_BIT 1
#define CAN0_CSR15_CRC_MASK 0x4U
#define CAN0_CSR15_CRC 0x4U
#define CAN0_CSR15_CRC_BIT 2
#define CAN0_CSR15_STUFF_MASK 0x8U
#define CAN0_CSR15_STUFF 0x8U
#define CAN0_CSR15_STUFF_BIT 3
#define CAN0_CSR15_BUS_MASK 0x10U
#define CAN0_CSR15_BUS 0x10U
#define CAN0_CSR15_BUS_BIT 4
#define CAN0_CSR15_RXOK_MASK 0x20U
#define CAN0_CSR15_RXOK 0x20U
#define CAN0_CSR15_RXOK_BIT 5
#define CAN0_CSR15_TXOK_MASK 0x40U
#define CAN0_CSR15_TXOK 0x40U
#define CAN0_CSR15_TXOK_BIT 6
#define CAN0_CSR15_RFRAME_MASK 0x80U
#define CAN0_CSR15_RFRAME 0x80U
#define CAN0_CSR15_RFRAME_BIT 7
#define CAN0_CSR15_DLCW_MASK 0x200U
#define CAN0_CSR15_DLCW 0x200U
#define CAN0_CSR15_DLCW_BIT 9
#define CAN0_CSR15_FILLED_MASK 0x400U
#define CAN0_CSR15_FILLED 0x400U
#define CAN0_CSR15_FILLED_BIT 10
#define CAN0_CSR15_OVRUN_MASK 0x800U
#define CAN0_CSR15_OVRUN 0x800U
#define CAN0_CSR15_OVRUN_BIT 11

#define CAN0_SR15 (*(volatile unsigned long *)0xFFFD44DC)
#define CAN0_SR15_OFFSET 0x4DC
#define CAN0_SR15_ACK_MASK 0x1U
#define CAN0_SR15_ACK 0x1U
#define CAN0_SR15_ACK_BIT 0
#define CAN0_SR15_FRAME_MASK 0x2U
#define CAN0_SR15_FRAME 0x2U
#define CAN0_SR15_FRAME_BIT 1
#define CAN0_SR15_CRC_MASK 0x4U
#define CAN0_SR15_CRC 0x4U
#define CAN0_SR15_CRC_BIT 2
#define CAN0_SR15_STUFF_MASK 0x8U
#define CAN0_SR15_STUFF 0x8U
#define CAN0_SR15_STUFF_BIT 3
#define CAN0_SR15_BUS_MASK 0x10U
#define CAN0_SR15_BUS 0x10U
#define CAN0_SR15_BUS_BIT 4
#define CAN0_SR15_RXOK_MASK 0x20U
#define CAN0_SR15_RXOK 0x20U
#define CAN0_SR15_RXOK_BIT 5
#define CAN0_SR15_TXOK_MASK 0x40U
#define CAN0_SR15_TXOK 0x40U
#define CAN0_SR15_TXOK_BIT 6
#define CAN0_SR15_RFRAME_MASK 0x80U
#define CAN0_SR15_RFRAME 0x80U
#define CAN0_SR15_RFRAME_BIT 7
#define CAN0_SR15_DLCW_MASK 0x200U
#define CAN0_SR15_DLCW 0x200U
#define CAN0_SR15_DLCW_BIT 9
#define CAN0_SR15_FILLED_MASK 0x400U
#define CAN0_SR15_FILLED 0x400U
#define CAN0_SR15_FILLED_BIT 10
#define CAN0_SR15_OVRUN_MASK 0x800U
#define CAN0_SR15_OVRUN 0x800U
#define CAN0_SR15_OVRUN_BIT 11

#define CAN0_IER15 (*(volatile unsigned long *)0xFFFD44E0)
#define CAN0_IER15_OFFSET 0x4E0
#define CAN0_IER15_ACK_MASK 0x1U
#define CAN0_IER15_ACK 0x1U
#define CAN0_IER15_ACK_BIT 0
#define CAN0_IER15_FRAME_MASK 0x2U
#define CAN0_IER15_FRAME 0x2U
#define CAN0_IER15_FRAME_BIT 1
#define CAN0_IER15_CRC_MASK 0x4U
#define CAN0_IER15_CRC 0x4U
#define CAN0_IER15_CRC_BIT 2
#define CAN0_IER15_STUFF_MASK 0x8U
#define CAN0_IER15_STUFF 0x8U
#define CAN0_IER15_STUFF_BIT 3
#define CAN0_IER15_BUS_MASK 0x10U
#define CAN0_IER15_BUS 0x10U
#define CAN0_IER15_BUS_BIT 4
#define CAN0_IER15_RXOK_MASK 0x20U
#define CAN0_IER15_RXOK 0x20U
#define CAN0_IER15_RXOK_BIT 5
#define CAN0_IER15_TXOK_MASK 0x40U
#define CAN0_IER15_TXOK 0x40U
#define CAN0_IER15_TXOK_BIT 6
#define CAN0_IER15_RFRAME_MASK 0x80U
#define CAN0_IER15_RFRAME 0x80U
#define CAN0_IER15_RFRAME_BIT 7

#define CAN0_IDR15 (*(volatile unsigned long *)0xFFFD44E4)
#define CAN0_IDR15_OFFSET 0x4E4
#define CAN0_IDR15_ACK_MASK 0x1U
#define CAN0_IDR15_ACK 0x1U
#define CAN0_IDR15_ACK_BIT 0
#define CAN0_IDR15_FRAME_MASK 0x2U
#define CAN0_IDR15_FRAME 0x2U
#define CAN0_IDR15_FRAME_BIT 1
#define CAN0_IDR15_CRC_MASK 0x4U
#define CAN0_IDR15_CRC 0x4U
#define CAN0_IDR15_CRC_BIT 2
#define CAN0_IDR15_STUFF_MASK 0x8U
#define CAN0_IDR15_STUFF 0x8U
#define CAN0_IDR15_STUFF_BIT 3
#define CAN0_IDR15_BUS_MASK 0x10U
#define CAN0_IDR15_BUS 0x10U
#define CAN0_IDR15_BUS_BIT 4
#define CAN0_IDR15_RXOK_MASK 0x20U
#define CAN0_IDR15_RXOK 0x20U
#define CAN0_IDR15_RXOK_BIT 5
#define CAN0_IDR15_TXOK_MASK 0x40U
#define CAN0_IDR15_TXOK 0x40U
#define CAN0_IDR15_TXOK_BIT 6
#define CAN0_IDR15_RFRAME_MASK 0x80U
#define CAN0_IDR15_RFRAME 0x80U
#define CAN0_IDR15_RFRAME_BIT 7

#define CAN0_IMR15 (*(volatile unsigned long *)0xFFFD44E8)
#define CAN0_IMR15_OFFSET 0x4E8
#define CAN0_IMR15_ACK_MASK 0x1U
#define CAN0_IMR15_ACK 0x1U
#define CAN0_IMR15_ACK_BIT 0
#define CAN0_IMR15_FRAME_MASK 0x2U
#define CAN0_IMR15_FRAME 0x2U
#define CAN0_IMR15_FRAME_BIT 1
#define CAN0_IMR15_CRC_MASK 0x4U
#define CAN0_IMR15_CRC 0x4U
#define CAN0_IMR15_CRC_BIT 2
#define CAN0_IMR15_STUFF_MASK 0x8U
#define CAN0_IMR15_STUFF 0x8U
#define CAN0_IMR15_STUFF_BIT 3
#define CAN0_IMR15_BUS_MASK 0x10U
#define CAN0_IMR15_BUS 0x10U
#define CAN0_IMR15_BUS_BIT 4
#define CAN0_IMR15_RXOK_MASK 0x20U
#define CAN0_IMR15_RXOK 0x20U
#define CAN0_IMR15_RXOK_BIT 5
#define CAN0_IMR15_TXOK_MASK 0x40U
#define CAN0_IMR15_TXOK 0x40U
#define CAN0_IMR15_TXOK_BIT 6
#define CAN0_IMR15_RFRAME_MASK 0x80U
#define CAN0_IMR15_RFRAME 0x80U
#define CAN0_IMR15_RFRAME_BIT 7

#define UPIO_BASE 0xFFFD8000

#define UPIO_OER (*(volatile unsigned long *)0xFFFD8010)
#define UPIO_OER_OFFSET 0x10
#define UPIO_OER_P0_MASK 0x1U
#define UPIO_OER_P0 0x1U
#define UPIO_OER_P0_BIT 0
#define UPIO_OER_P1_MASK 0x2U
#define UPIO_OER_P1 0x2U
#define UPIO_OER_P1_BIT 1
#define UPIO_OER_P2_MASK 0x4U
#define UPIO_OER_P2 0x4U
#define UPIO_OER_P2_BIT 2
#define UPIO_OER_P3_MASK 0x8U
#define UPIO_OER_P3 0x8U
#define UPIO_OER_P3_BIT 3
#define UPIO_OER_P4_MASK 0x10U
#define UPIO_OER_P4 0x10U
#define UPIO_OER_P4_BIT 4
#define UPIO_OER_P5_MASK 0x20U
#define UPIO_OER_P5 0x20U
#define UPIO_OER_P5_BIT 5
#define UPIO_OER_P6_MASK 0x40U
#define UPIO_OER_P6 0x40U
#define UPIO_OER_P6_BIT 6
#define UPIO_OER_P7_MASK 0x80U
#define UPIO_OER_P7 0x80U
#define UPIO_OER_P7_BIT 7
#define UPIO_OER_P8_MASK 0x100U
#define UPIO_OER_P8 0x100U
#define UPIO_OER_P8_BIT 8
#define UPIO_OER_P9_MASK 0x200U
#define UPIO_OER_P9 0x200U
#define UPIO_OER_P9_BIT 9
#define UPIO_OER_P10_MASK 0x400U
#define UPIO_OER_P10 0x400U
#define UPIO_OER_P10_BIT 10
#define UPIO_OER_P11_MASK 0x800U
#define UPIO_OER_P11 0x800U
#define UPIO_OER_P11_BIT 11
#define UPIO_OER_P12_MASK 0x1000U
#define UPIO_OER_P12 0x1000U
#define UPIO_OER_P12_BIT 12
#define UPIO_OER_P13_MASK 0x2000U
#define UPIO_OER_P13 0x2000U
#define UPIO_OER_P13_BIT 13
#define UPIO_OER_P14_MASK 0x4000U
#define UPIO_OER_P14 0x4000U
#define UPIO_OER_P14_BIT 14
#define UPIO_OER_P15_MASK 0x8000U
#define UPIO_OER_P15 0x8000U
#define UPIO_OER_P15_BIT 15
#define UPIO_OER_P16_MASK 0x10000U
#define UPIO_OER_P16 0x10000U
#define UPIO_OER_P16_BIT 16
#define UPIO_OER_P17_MASK 0x20000U
#define UPIO_OER_P17 0x20000U
#define UPIO_OER_P17_BIT 17
#define UPIO_OER_P18_MASK 0x40000U
#define UPIO_OER_P18 0x40000U
#define UPIO_OER_P18_BIT 18
#define UPIO_OER_P19_MASK 0x80000U
#define UPIO_OER_P19 0x80000U
#define UPIO_OER_P19_BIT 19
#define UPIO_OER_P20_MASK 0x100000U
#define UPIO_OER_P20 0x100000U
#define UPIO_OER_P20_BIT 20
#define UPIO_OER_P21_MASK 0x200000U
#define UPIO_OER_P21 0x200000U
#define UPIO_OER_P21_BIT 21
#define UPIO_OER_P22_MASK 0x400000U
#define UPIO_OER_P22 0x400000U
#define UPIO_OER_P22_BIT 22
#define UPIO_OER_P23_MASK 0x800000U
#define UPIO_OER_P23 0x800000U
#define UPIO_OER_P23_BIT 23
#define UPIO_OER_P24_MASK 0x1000000U
#define UPIO_OER_P24 0x1000000U
#define UPIO_OER_P24_BIT 24
#define UPIO_OER_P25_MASK 0x2000000U
#define UPIO_OER_P25 0x2000000U
#define UPIO_OER_P25_BIT 25
#define UPIO_OER_P26_MASK 0x4000000U
#define UPIO_OER_P26 0x4000000U
#define UPIO_OER_P26_BIT 26
#define UPIO_OER_P27_MASK 0x8000000U
#define UPIO_OER_P27 0x8000000U
#define UPIO_OER_P27_BIT 27
#define UPIO_OER_P28_MASK 0x10000000U
#define UPIO_OER_P28 0x10000000U
#define UPIO_OER_P28_BIT 28
#define UPIO_OER_P29_MASK 0x20000000U
#define UPIO_OER_P29 0x20000000U
#define UPIO_OER_P29_BIT 29
#define UPIO_OER_P30_MASK 0x40000000U
#define UPIO_OER_P30 0x40000000U
#define UPIO_OER_P30_BIT 30
#define UPIO_OER_P31_MASK 0x80000000U
#define UPIO_OER_P31 0x80000000U
#define UPIO_OER_P31_BIT 31

#define UPIO_ODR (*(volatile unsigned long *)0xFFFD8014)
#define UPIO_ODR_OFFSET 0x14
#define UPIO_ODR_P0_MASK 0x1U
#define UPIO_ODR_P0 0x1U
#define UPIO_ODR_P0_BIT 0
#define UPIO_ODR_P1_MASK 0x2U
#define UPIO_ODR_P1 0x2U
#define UPIO_ODR_P1_BIT 1
#define UPIO_ODR_P2_MASK 0x4U
#define UPIO_ODR_P2 0x4U
#define UPIO_ODR_P2_BIT 2
#define UPIO_ODR_P3_MASK 0x8U
#define UPIO_ODR_P3 0x8U
#define UPIO_ODR_P3_BIT 3
#define UPIO_ODR_P4_MASK 0x10U
#define UPIO_ODR_P4 0x10U
#define UPIO_ODR_P4_BIT 4
#define UPIO_ODR_P5_MASK 0x20U
#define UPIO_ODR_P5 0x20U
#define UPIO_ODR_P5_BIT 5
#define UPIO_ODR_P6_MASK 0x40U
#define UPIO_ODR_P6 0x40U
#define UPIO_ODR_P6_BIT 6
#define UPIO_ODR_P7_MASK 0x80U
#define UPIO_ODR_P7 0x80U
#define UPIO_ODR_P7_BIT 7
#define UPIO_ODR_P8_MASK 0x100U
#define UPIO_ODR_P8 0x100U
#define UPIO_ODR_P8_BIT 8
#define UPIO_ODR_P9_MASK 0x200U
#define UPIO_ODR_P9 0x200U
#define UPIO_ODR_P9_BIT 9
#define UPIO_ODR_P10_MASK 0x400U
#define UPIO_ODR_P10 0x400U
#define UPIO_ODR_P10_BIT 10
#define UPIO_ODR_P11_MASK 0x800U
#define UPIO_ODR_P11 0x800U
#define UPIO_ODR_P11_BIT 11
#define UPIO_ODR_P12_MASK 0x1000U
#define UPIO_ODR_P12 0x1000U
#define UPIO_ODR_P12_BIT 12
#define UPIO_ODR_P13_MASK 0x2000U
#define UPIO_ODR_P13 0x2000U
#define UPIO_ODR_P13_BIT 13
#define UPIO_ODR_P14_MASK 0x4000U
#define UPIO_ODR_P14 0x4000U
#define UPIO_ODR_P14_BIT 14
#define UPIO_ODR_P15_MASK 0x8000U
#define UPIO_ODR_P15 0x8000U
#define UPIO_ODR_P15_BIT 15
#define UPIO_ODR_P16_MASK 0x10000U
#define UPIO_ODR_P16 0x10000U
#define UPIO_ODR_P16_BIT 16
#define UPIO_ODR_P17_MASK 0x20000U
#define UPIO_ODR_P17 0x20000U
#define UPIO_ODR_P17_BIT 17
#define UPIO_ODR_P18_MASK 0x40000U
#define UPIO_ODR_P18 0x40000U
#define UPIO_ODR_P18_BIT 18
#define UPIO_ODR_P19_MASK 0x80000U
#define UPIO_ODR_P19 0x80000U
#define UPIO_ODR_P19_BIT 19
#define UPIO_ODR_P20_MASK 0x100000U
#define UPIO_ODR_P20 0x100000U
#define UPIO_ODR_P20_BIT 20
#define UPIO_ODR_P21_MASK 0x200000U
#define UPIO_ODR_P21 0x200000U
#define UPIO_ODR_P21_BIT 21
#define UPIO_ODR_P22_MASK 0x400000U
#define UPIO_ODR_P22 0x400000U
#define UPIO_ODR_P22_BIT 22
#define UPIO_ODR_P23_MASK 0x800000U
#define UPIO_ODR_P23 0x800000U
#define UPIO_ODR_P23_BIT 23
#define UPIO_ODR_P24_MASK 0x1000000U
#define UPIO_ODR_P24 0x1000000U
#define UPIO_ODR_P24_BIT 24
#define UPIO_ODR_P25_MASK 0x2000000U
#define UPIO_ODR_P25 0x2000000U
#define UPIO_ODR_P25_BIT 25
#define UPIO_ODR_P26_MASK 0x4000000U
#define UPIO_ODR_P26 0x4000000U
#define UPIO_ODR_P26_BIT 26
#define UPIO_ODR_P27_MASK 0x8000000U
#define UPIO_ODR_P27 0x8000000U
#define UPIO_ODR_P27_BIT 27
#define UPIO_ODR_P28_MASK 0x10000000U
#define UPIO_ODR_P28 0x10000000U
#define UPIO_ODR_P28_BIT 28
#define UPIO_ODR_P29_MASK 0x20000000U
#define UPIO_ODR_P29 0x20000000U
#define UPIO_ODR_P29_BIT 29
#define UPIO_ODR_P30_MASK 0x40000000U
#define UPIO_ODR_P30 0x40000000U
#define UPIO_ODR_P30_BIT 30
#define UPIO_ODR_P31_MASK 0x80000000U
#define UPIO_ODR_P31 0x80000000U
#define UPIO_ODR_P31_BIT 31

#define UPIO_OSR (*(volatile unsigned long *)0xFFFD8018)
#define UPIO_OSR_OFFSET 0x18
#define UPIO_OSR_P0_MASK 0x1U
#define UPIO_OSR_P0 0x1U
#define UPIO_OSR_P0_BIT 0
#define UPIO_OSR_P1_MASK 0x2U
#define UPIO_OSR_P1 0x2U
#define UPIO_OSR_P1_BIT 1
#define UPIO_OSR_P2_MASK 0x4U
#define UPIO_OSR_P2 0x4U
#define UPIO_OSR_P2_BIT 2
#define UPIO_OSR_P3_MASK 0x8U
#define UPIO_OSR_P3 0x8U
#define UPIO_OSR_P3_BIT 3
#define UPIO_OSR_P4_MASK 0x10U
#define UPIO_OSR_P4 0x10U
#define UPIO_OSR_P4_BIT 4
#define UPIO_OSR_P5_MASK 0x20U
#define UPIO_OSR_P5 0x20U
#define UPIO_OSR_P5_BIT 5
#define UPIO_OSR_P6_MASK 0x40U
#define UPIO_OSR_P6 0x40U
#define UPIO_OSR_P6_BIT 6
#define UPIO_OSR_P7_MASK 0x80U
#define UPIO_OSR_P7 0x80U
#define UPIO_OSR_P7_BIT 7
#define UPIO_OSR_P8_MASK 0x100U
#define UPIO_OSR_P8 0x100U
#define UPIO_OSR_P8_BIT 8
#define UPIO_OSR_P9_MASK 0x200U
#define UPIO_OSR_P9 0x200U
#define UPIO_OSR_P9_BIT 9
#define UPIO_OSR_P10_MASK 0x400U
#define UPIO_OSR_P10 0x400U
#define UPIO_OSR_P10_BIT 10
#define UPIO_OSR_P11_MASK 0x800U
#define UPIO_OSR_P11 0x800U
#define UPIO_OSR_P11_BIT 11
#define UPIO_OSR_P12_MASK 0x1000U
#define UPIO_OSR_P12 0x1000U
#define UPIO_OSR_P12_BIT 12
#define UPIO_OSR_P13_MASK 0x2000U
#define UPIO_OSR_P13 0x2000U
#define UPIO_OSR_P13_BIT 13
#define UPIO_OSR_P14_MASK 0x4000U
#define UPIO_OSR_P14 0x4000U
#define UPIO_OSR_P14_BIT 14
#define UPIO_OSR_P15_MASK 0x8000U
#define UPIO_OSR_P15 0x8000U
#define UPIO_OSR_P15_BIT 15
#define UPIO_OSR_P16_MASK 0x10000U
#define UPIO_OSR_P16 0x10000U
#define UPIO_OSR_P16_BIT 16
#define UPIO_OSR_P17_MASK 0x20000U
#define UPIO_OSR_P17 0x20000U
#define UPIO_OSR_P17_BIT 17
#define UPIO_OSR_P18_MASK 0x40000U
#define UPIO_OSR_P18 0x40000U
#define UPIO_OSR_P18_BIT 18
#define UPIO_OSR_P19_MASK 0x80000U
#define UPIO_OSR_P19 0x80000U
#define UPIO_OSR_P19_BIT 19
#define UPIO_OSR_P20_MASK 0x100000U
#define UPIO_OSR_P20 0x100000U
#define UPIO_OSR_P20_BIT 20
#define UPIO_OSR_P21_MASK 0x200000U
#define UPIO_OSR_P21 0x200000U
#define UPIO_OSR_P21_BIT 21
#define UPIO_OSR_P22_MASK 0x400000U
#define UPIO_OSR_P22 0x400000U
#define UPIO_OSR_P22_BIT 22
#define UPIO_OSR_P23_MASK 0x800000U
#define UPIO_OSR_P23 0x800000U
#define UPIO_OSR_P23_BIT 23
#define UPIO_OSR_P24_MASK 0x1000000U
#define UPIO_OSR_P24 0x1000000U
#define UPIO_OSR_P24_BIT 24
#define UPIO_OSR_P25_MASK 0x2000000U
#define UPIO_OSR_P25 0x2000000U
#define UPIO_OSR_P25_BIT 25
#define UPIO_OSR_P26_MASK 0x4000000U
#define UPIO_OSR_P26 0x4000000U
#define UPIO_OSR_P26_BIT 26
#define UPIO_OSR_P27_MASK 0x8000000U
#define UPIO_OSR_P27 0x8000000U
#define UPIO_OSR_P27_BIT 27
#define UPIO_OSR_P28_MASK 0x10000000U
#define UPIO_OSR_P28 0x10000000U
#define UPIO_OSR_P28_BIT 28
#define UPIO_OSR_P29_MASK 0x20000000U
#define UPIO_OSR_P29 0x20000000U
#define UPIO_OSR_P29_BIT 29
#define UPIO_OSR_P30_MASK 0x40000000U
#define UPIO_OSR_P30 0x40000000U
#define UPIO_OSR_P30_BIT 30
#define UPIO_OSR_P31_MASK 0x80000000U
#define UPIO_OSR_P31 0x80000000U
#define UPIO_OSR_P31_BIT 31

#define UPIO_SODR (*(volatile unsigned long *)0xFFFD8030)
#define UPIO_SODR_OFFSET 0x30
#define UPIO_SODR_P0_MASK 0x1U
#define UPIO_SODR_P0 0x1U
#define UPIO_SODR_P0_BIT 0
#define UPIO_SODR_P1_MASK 0x2U
#define UPIO_SODR_P1 0x2U
#define UPIO_SODR_P1_BIT 1
#define UPIO_SODR_P2_MASK 0x4U
#define UPIO_SODR_P2 0x4U
#define UPIO_SODR_P2_BIT 2
#define UPIO_SODR_P3_MASK 0x8U
#define UPIO_SODR_P3 0x8U
#define UPIO_SODR_P3_BIT 3
#define UPIO_SODR_P4_MASK 0x10U
#define UPIO_SODR_P4 0x10U
#define UPIO_SODR_P4_BIT 4
#define UPIO_SODR_P5_MASK 0x20U
#define UPIO_SODR_P5 0x20U
#define UPIO_SODR_P5_BIT 5
#define UPIO_SODR_P6_MASK 0x40U
#define UPIO_SODR_P6 0x40U
#define UPIO_SODR_P6_BIT 6
#define UPIO_SODR_P7_MASK 0x80U
#define UPIO_SODR_P7 0x80U
#define UPIO_SODR_P7_BIT 7
#define UPIO_SODR_P8_MASK 0x100U
#define UPIO_SODR_P8 0x100U
#define UPIO_SODR_P8_BIT 8
#define UPIO_SODR_P9_MASK 0x200U
#define UPIO_SODR_P9 0x200U
#define UPIO_SODR_P9_BIT 9
#define UPIO_SODR_P10_MASK 0x400U
#define UPIO_SODR_P10 0x400U
#define UPIO_SODR_P10_BIT 10
#define UPIO_SODR_P11_MASK 0x800U
#define UPIO_SODR_P11 0x800U
#define UPIO_SODR_P11_BIT 11
#define UPIO_SODR_P12_MASK 0x1000U
#define UPIO_SODR_P12 0x1000U
#define UPIO_SODR_P12_BIT 12
#define UPIO_SODR_P13_MASK 0x2000U
#define UPIO_SODR_P13 0x2000U
#define UPIO_SODR_P13_BIT 13
#define UPIO_SODR_P14_MASK 0x4000U
#define UPIO_SODR_P14 0x4000U
#define UPIO_SODR_P14_BIT 14
#define UPIO_SODR_P15_MASK 0x8000U
#define UPIO_SODR_P15 0x8000U
#define UPIO_SODR_P15_BIT 15
#define UPIO_SODR_P16_MASK 0x10000U
#define UPIO_SODR_P16 0x10000U
#define UPIO_SODR_P16_BIT 16
#define UPIO_SODR_P17_MASK 0x20000U
#define UPIO_SODR_P17 0x20000U
#define UPIO_SODR_P17_BIT 17
#define UPIO_SODR_P18_MASK 0x40000U
#define UPIO_SODR_P18 0x40000U
#define UPIO_SODR_P18_BIT 18
#define UPIO_SODR_P19_MASK 0x80000U
#define UPIO_SODR_P19 0x80000U
#define UPIO_SODR_P19_BIT 19
#define UPIO_SODR_P20_MASK 0x100000U
#define UPIO_SODR_P20 0x100000U
#define UPIO_SODR_P20_BIT 20
#define UPIO_SODR_P21_MASK 0x200000U
#define UPIO_SODR_P21 0x200000U
#define UPIO_SODR_P21_BIT 21
#define UPIO_SODR_P22_MASK 0x400000U
#define UPIO_SODR_P22 0x400000U
#define UPIO_SODR_P22_BIT 22
#define UPIO_SODR_P23_MASK 0x800000U
#define UPIO_SODR_P23 0x800000U
#define UPIO_SODR_P23_BIT 23
#define UPIO_SODR_P24_MASK 0x1000000U
#define UPIO_SODR_P24 0x1000000U
#define UPIO_SODR_P24_BIT 24
#define UPIO_SODR_P25_MASK 0x2000000U
#define UPIO_SODR_P25 0x2000000U
#define UPIO_SODR_P25_BIT 25
#define UPIO_SODR_P26_MASK 0x4000000U
#define UPIO_SODR_P26 0x4000000U
#define UPIO_SODR_P26_BIT 26
#define UPIO_SODR_P27_MASK 0x8000000U
#define UPIO_SODR_P27 0x8000000U
#define UPIO_SODR_P27_BIT 27
#define UPIO_SODR_P28_MASK 0x10000000U
#define UPIO_SODR_P28 0x10000000U
#define UPIO_SODR_P28_BIT 28
#define UPIO_SODR_P29_MASK 0x20000000U
#define UPIO_SODR_P29 0x20000000U
#define UPIO_SODR_P29_BIT 29
#define UPIO_SODR_P30_MASK 0x40000000U
#define UPIO_SODR_P30 0x40000000U
#define UPIO_SODR_P30_BIT 30
#define UPIO_SODR_P31_MASK 0x80000000U
#define UPIO_SODR_P31 0x80000000U
#define UPIO_SODR_P31_BIT 31

#define UPIO_CODR (*(volatile unsigned long *)0xFFFD8034)
#define UPIO_CODR_OFFSET 0x34
#define UPIO_CODR_P0_MASK 0x1U
#define UPIO_CODR_P0 0x1U
#define UPIO_CODR_P0_BIT 0
#define UPIO_CODR_P1_MASK 0x2U
#define UPIO_CODR_P1 0x2U
#define UPIO_CODR_P1_BIT 1
#define UPIO_CODR_P2_MASK 0x4U
#define UPIO_CODR_P2 0x4U
#define UPIO_CODR_P2_BIT 2
#define UPIO_CODR_P3_MASK 0x8U
#define UPIO_CODR_P3 0x8U
#define UPIO_CODR_P3_BIT 3
#define UPIO_CODR_P4_MASK 0x10U
#define UPIO_CODR_P4 0x10U
#define UPIO_CODR_P4_BIT 4
#define UPIO_CODR_P5_MASK 0x20U
#define UPIO_CODR_P5 0x20U
#define UPIO_CODR_P5_BIT 5
#define UPIO_CODR_P6_MASK 0x40U
#define UPIO_CODR_P6 0x40U
#define UPIO_CODR_P6_BIT 6
#define UPIO_CODR_P7_MASK 0x80U
#define UPIO_CODR_P7 0x80U
#define UPIO_CODR_P7_BIT 7
#define UPIO_CODR_P8_MASK 0x100U
#define UPIO_CODR_P8 0x100U
#define UPIO_CODR_P8_BIT 8
#define UPIO_CODR_P9_MASK 0x200U
#define UPIO_CODR_P9 0x200U
#define UPIO_CODR_P9_BIT 9
#define UPIO_CODR_P10_MASK 0x400U
#define UPIO_CODR_P10 0x400U
#define UPIO_CODR_P10_BIT 10
#define UPIO_CODR_P11_MASK 0x800U
#define UPIO_CODR_P11 0x800U
#define UPIO_CODR_P11_BIT 11
#define UPIO_CODR_P12_MASK 0x1000U
#define UPIO_CODR_P12 0x1000U
#define UPIO_CODR_P12_BIT 12
#define UPIO_CODR_P13_MASK 0x2000U
#define UPIO_CODR_P13 0x2000U
#define UPIO_CODR_P13_BIT 13
#define UPIO_CODR_P14_MASK 0x4000U
#define UPIO_CODR_P14 0x4000U
#define UPIO_CODR_P14_BIT 14
#define UPIO_CODR_P15_MASK 0x8000U
#define UPIO_CODR_P15 0x8000U
#define UPIO_CODR_P15_BIT 15
#define UPIO_CODR_P16_MASK 0x10000U
#define UPIO_CODR_P16 0x10000U
#define UPIO_CODR_P16_BIT 16
#define UPIO_CODR_P17_MASK 0x20000U
#define UPIO_CODR_P17 0x20000U
#define UPIO_CODR_P17_BIT 17
#define UPIO_CODR_P18_MASK 0x40000U
#define UPIO_CODR_P18 0x40000U
#define UPIO_CODR_P18_BIT 18
#define UPIO_CODR_P19_MASK 0x80000U
#define UPIO_CODR_P19 0x80000U
#define UPIO_CODR_P19_BIT 19
#define UPIO_CODR_P20_MASK 0x100000U
#define UPIO_CODR_P20 0x100000U
#define UPIO_CODR_P20_BIT 20
#define UPIO_CODR_P21_MASK 0x200000U
#define UPIO_CODR_P21 0x200000U
#define UPIO_CODR_P21_BIT 21
#define UPIO_CODR_P22_MASK 0x400000U
#define UPIO_CODR_P22 0x400000U
#define UPIO_CODR_P22_BIT 22
#define UPIO_CODR_P23_MASK 0x800000U
#define UPIO_CODR_P23 0x800000U
#define UPIO_CODR_P23_BIT 23
#define UPIO_CODR_P24_MASK 0x1000000U
#define UPIO_CODR_P24 0x1000000U
#define UPIO_CODR_P24_BIT 24
#define UPIO_CODR_P25_MASK 0x2000000U
#define UPIO_CODR_P25 0x2000000U
#define UPIO_CODR_P25_BIT 25
#define UPIO_CODR_P26_MASK 0x4000000U
#define UPIO_CODR_P26 0x4000000U
#define UPIO_CODR_P26_BIT 26
#define UPIO_CODR_P27_MASK 0x8000000U
#define UPIO_CODR_P27 0x8000000U
#define UPIO_CODR_P27_BIT 27
#define UPIO_CODR_P28_MASK 0x10000000U
#define UPIO_CODR_P28 0x10000000U
#define UPIO_CODR_P28_BIT 28
#define UPIO_CODR_P29_MASK 0x20000000U
#define UPIO_CODR_P29 0x20000000U
#define UPIO_CODR_P29_BIT 29
#define UPIO_CODR_P30_MASK 0x40000000U
#define UPIO_CODR_P30 0x40000000U
#define UPIO_CODR_P30_BIT 30
#define UPIO_CODR_P31_MASK 0x80000000U
#define UPIO_CODR_P31 0x80000000U
#define UPIO_CODR_P31_BIT 31

#define UPIO_ODSR (*(volatile unsigned long *)0xFFFD8038)
#define UPIO_ODSR_OFFSET 0x38
#define UPIO_ODSR_P0_MASK 0x1U
#define UPIO_ODSR_P0 0x1U
#define UPIO_ODSR_P0_BIT 0
#define UPIO_ODSR_P1_MASK 0x2U
#define UPIO_ODSR_P1 0x2U
#define UPIO_ODSR_P1_BIT 1
#define UPIO_ODSR_P2_MASK 0x4U
#define UPIO_ODSR_P2 0x4U
#define UPIO_ODSR_P2_BIT 2
#define UPIO_ODSR_P3_MASK 0x8U
#define UPIO_ODSR_P3 0x8U
#define UPIO_ODSR_P3_BIT 3
#define UPIO_ODSR_P4_MASK 0x10U
#define UPIO_ODSR_P4 0x10U
#define UPIO_ODSR_P4_BIT 4
#define UPIO_ODSR_P5_MASK 0x20U
#define UPIO_ODSR_P5 0x20U
#define UPIO_ODSR_P5_BIT 5
#define UPIO_ODSR_P6_MASK 0x40U
#define UPIO_ODSR_P6 0x40U
#define UPIO_ODSR_P6_BIT 6
#define UPIO_ODSR_P7_MASK 0x80U
#define UPIO_ODSR_P7 0x80U
#define UPIO_ODSR_P7_BIT 7
#define UPIO_ODSR_P8_MASK 0x100U
#define UPIO_ODSR_P8 0x100U
#define UPIO_ODSR_P8_BIT 8
#define UPIO_ODSR_P9_MASK 0x200U
#define UPIO_ODSR_P9 0x200U
#define UPIO_ODSR_P9_BIT 9
#define UPIO_ODSR_P10_MASK 0x400U
#define UPIO_ODSR_P10 0x400U
#define UPIO_ODSR_P10_BIT 10
#define UPIO_ODSR_P11_MASK 0x800U
#define UPIO_ODSR_P11 0x800U
#define UPIO_ODSR_P11_BIT 11
#define UPIO_ODSR_P12_MASK 0x1000U
#define UPIO_ODSR_P12 0x1000U
#define UPIO_ODSR_P12_BIT 12
#define UPIO_ODSR_P13_MASK 0x2000U
#define UPIO_ODSR_P13 0x2000U
#define UPIO_ODSR_P13_BIT 13
#define UPIO_ODSR_P14_MASK 0x4000U
#define UPIO_ODSR_P14 0x4000U
#define UPIO_ODSR_P14_BIT 14
#define UPIO_ODSR_P15_MASK 0x8000U
#define UPIO_ODSR_P15 0x8000U
#define UPIO_ODSR_P15_BIT 15
#define UPIO_ODSR_P16_MASK 0x10000U
#define UPIO_ODSR_P16 0x10000U
#define UPIO_ODSR_P16_BIT 16
#define UPIO_ODSR_P17_MASK 0x20000U
#define UPIO_ODSR_P17 0x20000U
#define UPIO_ODSR_P17_BIT 17
#define UPIO_ODSR_P18_MASK 0x40000U
#define UPIO_ODSR_P18 0x40000U
#define UPIO_ODSR_P18_BIT 18
#define UPIO_ODSR_P19_MASK 0x80000U
#define UPIO_ODSR_P19 0x80000U
#define UPIO_ODSR_P19_BIT 19
#define UPIO_ODSR_P20_MASK 0x100000U
#define UPIO_ODSR_P20 0x100000U
#define UPIO_ODSR_P20_BIT 20
#define UPIO_ODSR_P21_MASK 0x200000U
#define UPIO_ODSR_P21 0x200000U
#define UPIO_ODSR_P21_BIT 21
#define UPIO_ODSR_P22_MASK 0x400000U
#define UPIO_ODSR_P22 0x400000U
#define UPIO_ODSR_P22_BIT 22
#define UPIO_ODSR_P23_MASK 0x800000U
#define UPIO_ODSR_P23 0x800000U
#define UPIO_ODSR_P23_BIT 23
#define UPIO_ODSR_P24_MASK 0x1000000U
#define UPIO_ODSR_P24 0x1000000U
#define UPIO_ODSR_P24_BIT 24
#define UPIO_ODSR_P25_MASK 0x2000000U
#define UPIO_ODSR_P25 0x2000000U
#define UPIO_ODSR_P25_BIT 25
#define UPIO_ODSR_P26_MASK 0x4000000U
#define UPIO_ODSR_P26 0x4000000U
#define UPIO_ODSR_P26_BIT 26
#define UPIO_ODSR_P27_MASK 0x8000000U
#define UPIO_ODSR_P27 0x8000000U
#define UPIO_ODSR_P27_BIT 27
#define UPIO_ODSR_P28_MASK 0x10000000U
#define UPIO_ODSR_P28 0x10000000U
#define UPIO_ODSR_P28_BIT 28
#define UPIO_ODSR_P29_MASK 0x20000000U
#define UPIO_ODSR_P29 0x20000000U
#define UPIO_ODSR_P29_BIT 29
#define UPIO_ODSR_P30_MASK 0x40000000U
#define UPIO_ODSR_P30 0x40000000U
#define UPIO_ODSR_P30_BIT 30
#define UPIO_ODSR_P31_MASK 0x80000000U
#define UPIO_ODSR_P31 0x80000000U
#define UPIO_ODSR_P31_BIT 31

#define UPIO_PDSR (*(volatile unsigned long *)0xFFFD803C)
#define UPIO_PDSR_OFFSET 0x3C
#define UPIO_PDSR_P0_MASK 0x1U
#define UPIO_PDSR_P0 0x1U
#define UPIO_PDSR_P0_BIT 0
#define UPIO_PDSR_P1_MASK 0x2U
#define UPIO_PDSR_P1 0x2U
#define UPIO_PDSR_P1_BIT 1
#define UPIO_PDSR_P2_MASK 0x4U
#define UPIO_PDSR_P2 0x4U
#define UPIO_PDSR_P2_BIT 2
#define UPIO_PDSR_P3_MASK 0x8U
#define UPIO_PDSR_P3 0x8U
#define UPIO_PDSR_P3_BIT 3
#define UPIO_PDSR_P4_MASK 0x10U
#define UPIO_PDSR_P4 0x10U
#define UPIO_PDSR_P4_BIT 4
#define UPIO_PDSR_P5_MASK 0x20U
#define UPIO_PDSR_P5 0x20U
#define UPIO_PDSR_P5_BIT 5
#define UPIO_PDSR_P6_MASK 0x40U
#define UPIO_PDSR_P6 0x40U
#define UPIO_PDSR_P6_BIT 6
#define UPIO_PDSR_P7_MASK 0x80U
#define UPIO_PDSR_P7 0x80U
#define UPIO_PDSR_P7_BIT 7
#define UPIO_PDSR_P8_MASK 0x100U
#define UPIO_PDSR_P8 0x100U
#define UPIO_PDSR_P8_BIT 8
#define UPIO_PDSR_P9_MASK 0x200U
#define UPIO_PDSR_P9 0x200U
#define UPIO_PDSR_P9_BIT 9
#define UPIO_PDSR_P10_MASK 0x400U
#define UPIO_PDSR_P10 0x400U
#define UPIO_PDSR_P10_BIT 10
#define UPIO_PDSR_P11_MASK 0x800U
#define UPIO_PDSR_P11 0x800U
#define UPIO_PDSR_P11_BIT 11
#define UPIO_PDSR_P12_MASK 0x1000U
#define UPIO_PDSR_P12 0x1000U
#define UPIO_PDSR_P12_BIT 12
#define UPIO_PDSR_P13_MASK 0x2000U
#define UPIO_PDSR_P13 0x2000U
#define UPIO_PDSR_P13_BIT 13
#define UPIO_PDSR_P14_MASK 0x4000U
#define UPIO_PDSR_P14 0x4000U
#define UPIO_PDSR_P14_BIT 14
#define UPIO_PDSR_P15_MASK 0x8000U
#define UPIO_PDSR_P15 0x8000U
#define UPIO_PDSR_P15_BIT 15
#define UPIO_PDSR_P16_MASK 0x10000U
#define UPIO_PDSR_P16 0x10000U
#define UPIO_PDSR_P16_BIT 16
#define UPIO_PDSR_P17_MASK 0x20000U
#define UPIO_PDSR_P17 0x20000U
#define UPIO_PDSR_P17_BIT 17
#define UPIO_PDSR_P18_MASK 0x40000U
#define UPIO_PDSR_P18 0x40000U
#define UPIO_PDSR_P18_BIT 18
#define UPIO_PDSR_P19_MASK 0x80000U
#define UPIO_PDSR_P19 0x80000U
#define UPIO_PDSR_P19_BIT 19
#define UPIO_PDSR_P20_MASK 0x100000U
#define UPIO_PDSR_P20 0x100000U
#define UPIO_PDSR_P20_BIT 20
#define UPIO_PDSR_P21_MASK 0x200000U
#define UPIO_PDSR_P21 0x200000U
#define UPIO_PDSR_P21_BIT 21
#define UPIO_PDSR_P22_MASK 0x400000U
#define UPIO_PDSR_P22 0x400000U
#define UPIO_PDSR_P22_BIT 22
#define UPIO_PDSR_P23_MASK 0x800000U
#define UPIO_PDSR_P23 0x800000U
#define UPIO_PDSR_P23_BIT 23
#define UPIO_PDSR_P24_MASK 0x1000000U
#define UPIO_PDSR_P24 0x1000000U
#define UPIO_PDSR_P24_BIT 24
#define UPIO_PDSR_P25_MASK 0x2000000U
#define UPIO_PDSR_P25 0x2000000U
#define UPIO_PDSR_P25_BIT 25
#define UPIO_PDSR_P26_MASK 0x4000000U
#define UPIO_PDSR_P26 0x4000000U
#define UPIO_PDSR_P26_BIT 26
#define UPIO_PDSR_P27_MASK 0x8000000U
#define UPIO_PDSR_P27 0x8000000U
#define UPIO_PDSR_P27_BIT 27
#define UPIO_PDSR_P28_MASK 0x10000000U
#define UPIO_PDSR_P28 0x10000000U
#define UPIO_PDSR_P28_BIT 28
#define UPIO_PDSR_P29_MASK 0x20000000U
#define UPIO_PDSR_P29 0x20000000U
#define UPIO_PDSR_P29_BIT 29
#define UPIO_PDSR_P30_MASK 0x40000000U
#define UPIO_PDSR_P30 0x40000000U
#define UPIO_PDSR_P30_BIT 30
#define UPIO_PDSR_P31_MASK 0x80000000U
#define UPIO_PDSR_P31 0x80000000U
#define UPIO_PDSR_P31_BIT 31

#define UPIO_MDER (*(volatile unsigned long *)0xFFFD8040)
#define UPIO_MDER_OFFSET 0x40
#define UPIO_MDER_P0_MASK 0x1U
#define UPIO_MDER_P0 0x1U
#define UPIO_MDER_P0_BIT 0
#define UPIO_MDER_P1_MASK 0x2U
#define UPIO_MDER_P1 0x2U
#define UPIO_MDER_P1_BIT 1
#define UPIO_MDER_P2_MASK 0x4U
#define UPIO_MDER_P2 0x4U
#define UPIO_MDER_P2_BIT 2
#define UPIO_MDER_P3_MASK 0x8U
#define UPIO_MDER_P3 0x8U
#define UPIO_MDER_P3_BIT 3
#define UPIO_MDER_P4_MASK 0x10U
#define UPIO_MDER_P4 0x10U
#define UPIO_MDER_P4_BIT 4
#define UPIO_MDER_P5_MASK 0x20U
#define UPIO_MDER_P5 0x20U
#define UPIO_MDER_P5_BIT 5
#define UPIO_MDER_P6_MASK 0x40U
#define UPIO_MDER_P6 0x40U
#define UPIO_MDER_P6_BIT 6
#define UPIO_MDER_P7_MASK 0x80U
#define UPIO_MDER_P7 0x80U
#define UPIO_MDER_P7_BIT 7
#define UPIO_MDER_P8_MASK 0x100U
#define UPIO_MDER_P8 0x100U
#define UPIO_MDER_P8_BIT 8
#define UPIO_MDER_P9_MASK 0x200U
#define UPIO_MDER_P9 0x200U
#define UPIO_MDER_P9_BIT 9
#define UPIO_MDER_P10_MASK 0x400U
#define UPIO_MDER_P10 0x400U
#define UPIO_MDER_P10_BIT 10
#define UPIO_MDER_P11_MASK 0x800U
#define UPIO_MDER_P11 0x800U
#define UPIO_MDER_P11_BIT 11
#define UPIO_MDER_P12_MASK 0x1000U
#define UPIO_MDER_P12 0x1000U
#define UPIO_MDER_P12_BIT 12
#define UPIO_MDER_P13_MASK 0x2000U
#define UPIO_MDER_P13 0x2000U
#define UPIO_MDER_P13_BIT 13
#define UPIO_MDER_P14_MASK 0x4000U
#define UPIO_MDER_P14 0x4000U
#define UPIO_MDER_P14_BIT 14
#define UPIO_MDER_P15_MASK 0x8000U
#define UPIO_MDER_P15 0x8000U
#define UPIO_MDER_P15_BIT 15
#define UPIO_MDER_P16_MASK 0x10000U
#define UPIO_MDER_P16 0x10000U
#define UPIO_MDER_P16_BIT 16
#define UPIO_MDER_P17_MASK 0x20000U
#define UPIO_MDER_P17 0x20000U
#define UPIO_MDER_P17_BIT 17
#define UPIO_MDER_P18_MASK 0x40000U
#define UPIO_MDER_P18 0x40000U
#define UPIO_MDER_P18_BIT 18
#define UPIO_MDER_P19_MASK 0x80000U
#define UPIO_MDER_P19 0x80000U
#define UPIO_MDER_P19_BIT 19
#define UPIO_MDER_P20_MASK 0x100000U
#define UPIO_MDER_P20 0x100000U
#define UPIO_MDER_P20_BIT 20
#define UPIO_MDER_P21_MASK 0x200000U
#define UPIO_MDER_P21 0x200000U
#define UPIO_MDER_P21_BIT 21
#define UPIO_MDER_P22_MASK 0x400000U
#define UPIO_MDER_P22 0x400000U
#define UPIO_MDER_P22_BIT 22
#define UPIO_MDER_P23_MASK 0x800000U
#define UPIO_MDER_P23 0x800000U
#define UPIO_MDER_P23_BIT 23
#define UPIO_MDER_P24_MASK 0x1000000U
#define UPIO_MDER_P24 0x1000000U
#define UPIO_MDER_P24_BIT 24
#define UPIO_MDER_P25_MASK 0x2000000U
#define UPIO_MDER_P25 0x2000000U
#define UPIO_MDER_P25_BIT 25
#define UPIO_MDER_P26_MASK 0x4000000U
#define UPIO_MDER_P26 0x4000000U
#define UPIO_MDER_P26_BIT 26
#define UPIO_MDER_P27_MASK 0x8000000U
#define UPIO_MDER_P27 0x8000000U
#define UPIO_MDER_P27_BIT 27
#define UPIO_MDER_P28_MASK 0x10000000U
#define UPIO_MDER_P28 0x10000000U
#define UPIO_MDER_P28_BIT 28
#define UPIO_MDER_P29_MASK 0x20000000U
#define UPIO_MDER_P29 0x20000000U
#define UPIO_MDER_P29_BIT 29
#define UPIO_MDER_P30_MASK 0x40000000U
#define UPIO_MDER_P30 0x40000000U
#define UPIO_MDER_P30_BIT 30
#define UPIO_MDER_P31_MASK 0x80000000U
#define UPIO_MDER_P31 0x80000000U
#define UPIO_MDER_P31_BIT 31

#define UPIO_MDDR (*(volatile unsigned long *)0xFFFD8044)
#define UPIO_MDDR_OFFSET 0x44
#define UPIO_MDDR_P0_MASK 0x1U
#define UPIO_MDDR_P0 0x1U
#define UPIO_MDDR_P0_BIT 0
#define UPIO_MDDR_P1_MASK 0x2U
#define UPIO_MDDR_P1 0x2U
#define UPIO_MDDR_P1_BIT 1
#define UPIO_MDDR_P2_MASK 0x4U
#define UPIO_MDDR_P2 0x4U
#define UPIO_MDDR_P2_BIT 2
#define UPIO_MDDR_P3_MASK 0x8U
#define UPIO_MDDR_P3 0x8U
#define UPIO_MDDR_P3_BIT 3
#define UPIO_MDDR_P4_MASK 0x10U
#define UPIO_MDDR_P4 0x10U
#define UPIO_MDDR_P4_BIT 4
#define UPIO_MDDR_P5_MASK 0x20U
#define UPIO_MDDR_P5 0x20U
#define UPIO_MDDR_P5_BIT 5
#define UPIO_MDDR_P6_MASK 0x40U
#define UPIO_MDDR_P6 0x40U
#define UPIO_MDDR_P6_BIT 6
#define UPIO_MDDR_P7_MASK 0x80U
#define UPIO_MDDR_P7 0x80U
#define UPIO_MDDR_P7_BIT 7
#define UPIO_MDDR_P8_MASK 0x100U
#define UPIO_MDDR_P8 0x100U
#define UPIO_MDDR_P8_BIT 8
#define UPIO_MDDR_P9_MASK 0x200U
#define UPIO_MDDR_P9 0x200U
#define UPIO_MDDR_P9_BIT 9
#define UPIO_MDDR_P10_MASK 0x400U
#define UPIO_MDDR_P10 0x400U
#define UPIO_MDDR_P10_BIT 10
#define UPIO_MDDR_P11_MASK 0x800U
#define UPIO_MDDR_P11 0x800U
#define UPIO_MDDR_P11_BIT 11
#define UPIO_MDDR_P12_MASK 0x1000U
#define UPIO_MDDR_P12 0x1000U
#define UPIO_MDDR_P12_BIT 12
#define UPIO_MDDR_P13_MASK 0x2000U
#define UPIO_MDDR_P13 0x2000U
#define UPIO_MDDR_P13_BIT 13
#define UPIO_MDDR_P14_MASK 0x4000U
#define UPIO_MDDR_P14 0x4000U
#define UPIO_MDDR_P14_BIT 14
#define UPIO_MDDR_P15_MASK 0x8000U
#define UPIO_MDDR_P15 0x8000U
#define UPIO_MDDR_P15_BIT 15
#define UPIO_MDDR_P16_MASK 0x10000U
#define UPIO_MDDR_P16 0x10000U
#define UPIO_MDDR_P16_BIT 16
#define UPIO_MDDR_P17_MASK 0x20000U
#define UPIO_MDDR_P17 0x20000U
#define UPIO_MDDR_P17_BIT 17
#define UPIO_MDDR_P18_MASK 0x40000U
#define UPIO_MDDR_P18 0x40000U
#define UPIO_MDDR_P18_BIT 18
#define UPIO_MDDR_P19_MASK 0x80000U
#define UPIO_MDDR_P19 0x80000U
#define UPIO_MDDR_P19_BIT 19
#define UPIO_MDDR_P20_MASK 0x100000U
#define UPIO_MDDR_P20 0x100000U
#define UPIO_MDDR_P20_BIT 20
#define UPIO_MDDR_P21_MASK 0x200000U
#define UPIO_MDDR_P21 0x200000U
#define UPIO_MDDR_P21_BIT 21
#define UPIO_MDDR_P22_MASK 0x400000U
#define UPIO_MDDR_P22 0x400000U
#define UPIO_MDDR_P22_BIT 22
#define UPIO_MDDR_P23_MASK 0x800000U
#define UPIO_MDDR_P23 0x800000U
#define UPIO_MDDR_P23_BIT 23
#define UPIO_MDDR_P24_MASK 0x1000000U
#define UPIO_MDDR_P24 0x1000000U
#define UPIO_MDDR_P24_BIT 24
#define UPIO_MDDR_P25_MASK 0x2000000U
#define UPIO_MDDR_P25 0x2000000U
#define UPIO_MDDR_P25_BIT 25
#define UPIO_MDDR_P26_MASK 0x4000000U
#define UPIO_MDDR_P26 0x4000000U
#define UPIO_MDDR_P26_BIT 26
#define UPIO_MDDR_P27_MASK 0x8000000U
#define UPIO_MDDR_P27 0x8000000U
#define UPIO_MDDR_P27_BIT 27
#define UPIO_MDDR_P28_MASK 0x10000000U
#define UPIO_MDDR_P28 0x10000000U
#define UPIO_MDDR_P28_BIT 28
#define UPIO_MDDR_P29_MASK 0x20000000U
#define UPIO_MDDR_P29 0x20000000U
#define UPIO_MDDR_P29_BIT 29
#define UPIO_MDDR_P30_MASK 0x40000000U
#define UPIO_MDDR_P30 0x40000000U
#define UPIO_MDDR_P30_BIT 30
#define UPIO_MDDR_P31_MASK 0x80000000U
#define UPIO_MDDR_P31 0x80000000U
#define UPIO_MDDR_P31_BIT 31

#define UPIO_MDSR (*(volatile unsigned long *)0xFFFD8048)
#define UPIO_MDSR_OFFSET 0x48
#define UPIO_MDSR_P0_MASK 0x1U
#define UPIO_MDSR_P0 0x1U
#define UPIO_MDSR_P0_BIT 0
#define UPIO_MDSR_P1_MASK 0x2U
#define UPIO_MDSR_P1 0x2U
#define UPIO_MDSR_P1_BIT 1
#define UPIO_MDSR_P2_MASK 0x4U
#define UPIO_MDSR_P2 0x4U
#define UPIO_MDSR_P2_BIT 2
#define UPIO_MDSR_P3_MASK 0x8U
#define UPIO_MDSR_P3 0x8U
#define UPIO_MDSR_P3_BIT 3
#define UPIO_MDSR_P4_MASK 0x10U
#define UPIO_MDSR_P4 0x10U
#define UPIO_MDSR_P4_BIT 4
#define UPIO_MDSR_P5_MASK 0x20U
#define UPIO_MDSR_P5 0x20U
#define UPIO_MDSR_P5_BIT 5
#define UPIO_MDSR_P6_MASK 0x40U
#define UPIO_MDSR_P6 0x40U
#define UPIO_MDSR_P6_BIT 6
#define UPIO_MDSR_P7_MASK 0x80U
#define UPIO_MDSR_P7 0x80U
#define UPIO_MDSR_P7_BIT 7
#define UPIO_MDSR_P8_MASK 0x100U
#define UPIO_MDSR_P8 0x100U
#define UPIO_MDSR_P8_BIT 8
#define UPIO_MDSR_P9_MASK 0x200U
#define UPIO_MDSR_P9 0x200U
#define UPIO_MDSR_P9_BIT 9
#define UPIO_MDSR_P10_MASK 0x400U
#define UPIO_MDSR_P10 0x400U
#define UPIO_MDSR_P10_BIT 10
#define UPIO_MDSR_P11_MASK 0x800U
#define UPIO_MDSR_P11 0x800U
#define UPIO_MDSR_P11_BIT 11
#define UPIO_MDSR_P12_MASK 0x1000U
#define UPIO_MDSR_P12 0x1000U
#define UPIO_MDSR_P12_BIT 12
#define UPIO_MDSR_P13_MASK 0x2000U
#define UPIO_MDSR_P13 0x2000U
#define UPIO_MDSR_P13_BIT 13
#define UPIO_MDSR_P14_MASK 0x4000U
#define UPIO_MDSR_P14 0x4000U
#define UPIO_MDSR_P14_BIT 14
#define UPIO_MDSR_P15_MASK 0x8000U
#define UPIO_MDSR_P15 0x8000U
#define UPIO_MDSR_P15_BIT 15
#define UPIO_MDSR_P16_MASK 0x10000U
#define UPIO_MDSR_P16 0x10000U
#define UPIO_MDSR_P16_BIT 16
#define UPIO_MDSR_P17_MASK 0x20000U
#define UPIO_MDSR_P17 0x20000U
#define UPIO_MDSR_P17_BIT 17
#define UPIO_MDSR_P18_MASK 0x40000U
#define UPIO_MDSR_P18 0x40000U
#define UPIO_MDSR_P18_BIT 18
#define UPIO_MDSR_P19_MASK 0x80000U
#define UPIO_MDSR_P19 0x80000U
#define UPIO_MDSR_P19_BIT 19
#define UPIO_MDSR_P20_MASK 0x100000U
#define UPIO_MDSR_P20 0x100000U
#define UPIO_MDSR_P20_BIT 20
#define UPIO_MDSR_P21_MASK 0x200000U
#define UPIO_MDSR_P21 0x200000U
#define UPIO_MDSR_P21_BIT 21
#define UPIO_MDSR_P22_MASK 0x400000U
#define UPIO_MDSR_P22 0x400000U
#define UPIO_MDSR_P22_BIT 22
#define UPIO_MDSR_P23_MASK 0x800000U
#define UPIO_MDSR_P23 0x800000U
#define UPIO_MDSR_P23_BIT 23
#define UPIO_MDSR_P24_MASK 0x1000000U
#define UPIO_MDSR_P24 0x1000000U
#define UPIO_MDSR_P24_BIT 24
#define UPIO_MDSR_P25_MASK 0x2000000U
#define UPIO_MDSR_P25 0x2000000U
#define UPIO_MDSR_P25_BIT 25
#define UPIO_MDSR_P26_MASK 0x4000000U
#define UPIO_MDSR_P26 0x4000000U
#define UPIO_MDSR_P26_BIT 26
#define UPIO_MDSR_P27_MASK 0x8000000U
#define UPIO_MDSR_P27 0x8000000U
#define UPIO_MDSR_P27_BIT 27
#define UPIO_MDSR_P28_MASK 0x10000000U
#define UPIO_MDSR_P28 0x10000000U
#define UPIO_MDSR_P28_BIT 28
#define UPIO_MDSR_P29_MASK 0x20000000U
#define UPIO_MDSR_P29 0x20000000U
#define UPIO_MDSR_P29_BIT 29
#define UPIO_MDSR_P30_MASK 0x40000000U
#define UPIO_MDSR_P30 0x40000000U
#define UPIO_MDSR_P30_BIT 30
#define UPIO_MDSR_P31_MASK 0x80000000U
#define UPIO_MDSR_P31 0x80000000U
#define UPIO_MDSR_P31_BIT 31

#define UPIO_ECR (*(volatile unsigned long *)0xFFFD8050)
#define UPIO_ECR_OFFSET 0x50
#define UPIO_ECR_PIO_MASK 0x1U
#define UPIO_ECR_PIO 0x1U
#define UPIO_ECR_PIO_BIT 0

#define UPIO_DCR (*(volatile unsigned long *)0xFFFD8054)
#define UPIO_DCR_OFFSET 0x54
#define UPIO_DCR_PIO_MASK 0x1U
#define UPIO_DCR_PIO 0x1U
#define UPIO_DCR_PIO_BIT 0

#define UPIO_PMSR (*(volatile unsigned long *)0xFFFD8058)
#define UPIO_PMSR_OFFSET 0x58
#define UPIO_PMSR_PIO_MASK 0x1U
#define UPIO_PMSR_PIO 0x1U
#define UPIO_PMSR_PIO_BIT 0

#define UPIO_CR (*(volatile unsigned long *)0xFFFD8060)
#define UPIO_CR_OFFSET 0x60
#define UPIO_CR_SWRST_MASK 0x1U
#define UPIO_CR_SWRST 0x1U
#define UPIO_CR_SWRST_BIT 0

#define UPIO_CR (*(volatile unsigned long *)0xFFFD8064)
#define UPIO_CR_OFFSET 0x64
#define UPIO_CR_NWAIT_SLCT_MASK 0x40000000U
#define UPIO_CR_NWAIT_SLCT 0x40000000U
#define UPIO_CR_NWAIT_SLCT_BIT 30
#define UPIO_CR_CLK_SLCT_MASK 0x80000000U
#define UPIO_CR_CLK_SLCT 0x80000000U
#define UPIO_CR_CLK_SLCT_BIT 31

#define UPIO_SR (*(volatile unsigned long *)0xFFFD8070)
#define UPIO_SR_OFFSET 0x70
#define UPIO_SR_P0_MASK 0x1U
#define UPIO_SR_P0 0x1U
#define UPIO_SR_P0_BIT 0
#define UPIO_SR_P1_MASK 0x2U
#define UPIO_SR_P1 0x2U
#define UPIO_SR_P1_BIT 1
#define UPIO_SR_P2_MASK 0x4U
#define UPIO_SR_P2 0x4U
#define UPIO_SR_P2_BIT 2
#define UPIO_SR_P3_MASK 0x8U
#define UPIO_SR_P3 0x8U
#define UPIO_SR_P3_BIT 3
#define UPIO_SR_P4_MASK 0x10U
#define UPIO_SR_P4 0x10U
#define UPIO_SR_P4_BIT 4
#define UPIO_SR_P5_MASK 0x20U
#define UPIO_SR_P5 0x20U
#define UPIO_SR_P5_BIT 5
#define UPIO_SR_P6_MASK 0x40U
#define UPIO_SR_P6 0x40U
#define UPIO_SR_P6_BIT 6
#define UPIO_SR_P7_MASK 0x80U
#define UPIO_SR_P7 0x80U
#define UPIO_SR_P7_BIT 7
#define UPIO_SR_P8_MASK 0x100U
#define UPIO_SR_P8 0x100U
#define UPIO_SR_P8_BIT 8
#define UPIO_SR_P9_MASK 0x200U
#define UPIO_SR_P9 0x200U
#define UPIO_SR_P9_BIT 9
#define UPIO_SR_P10_MASK 0x400U
#define UPIO_SR_P10 0x400U
#define UPIO_SR_P10_BIT 10
#define UPIO_SR_P11_MASK 0x800U
#define UPIO_SR_P11 0x800U
#define UPIO_SR_P11_BIT 11
#define UPIO_SR_P12_MASK 0x1000U
#define UPIO_SR_P12 0x1000U
#define UPIO_SR_P12_BIT 12
#define UPIO_SR_P13_MASK 0x2000U
#define UPIO_SR_P13 0x2000U
#define UPIO_SR_P13_BIT 13
#define UPIO_SR_P14_MASK 0x4000U
#define UPIO_SR_P14 0x4000U
#define UPIO_SR_P14_BIT 14
#define UPIO_SR_P15_MASK 0x8000U
#define UPIO_SR_P15 0x8000U
#define UPIO_SR_P15_BIT 15
#define UPIO_SR_P16_MASK 0x10000U
#define UPIO_SR_P16 0x10000U
#define UPIO_SR_P16_BIT 16
#define UPIO_SR_P17_MASK 0x20000U
#define UPIO_SR_P17 0x20000U
#define UPIO_SR_P17_BIT 17
#define UPIO_SR_P18_MASK 0x40000U
#define UPIO_SR_P18 0x40000U
#define UPIO_SR_P18_BIT 18
#define UPIO_SR_P19_MASK 0x80000U
#define UPIO_SR_P19 0x80000U
#define UPIO_SR_P19_BIT 19
#define UPIO_SR_P20_MASK 0x100000U
#define UPIO_SR_P20 0x100000U
#define UPIO_SR_P20_BIT 20
#define UPIO_SR_P21_MASK 0x200000U
#define UPIO_SR_P21 0x200000U
#define UPIO_SR_P21_BIT 21
#define UPIO_SR_P22_MASK 0x400000U
#define UPIO_SR_P22 0x400000U
#define UPIO_SR_P22_BIT 22
#define UPIO_SR_P23_MASK 0x800000U
#define UPIO_SR_P23 0x800000U
#define UPIO_SR_P23_BIT 23
#define UPIO_SR_P24_MASK 0x1000000U
#define UPIO_SR_P24 0x1000000U
#define UPIO_SR_P24_BIT 24
#define UPIO_SR_P25_MASK 0x2000000U
#define UPIO_SR_P25 0x2000000U
#define UPIO_SR_P25_BIT 25
#define UPIO_SR_P26_MASK 0x4000000U
#define UPIO_SR_P26 0x4000000U
#define UPIO_SR_P26_BIT 26
#define UPIO_SR_P27_MASK 0x8000000U
#define UPIO_SR_P27 0x8000000U
#define UPIO_SR_P27_BIT 27
#define UPIO_SR_P28_MASK 0x10000000U
#define UPIO_SR_P28 0x10000000U
#define UPIO_SR_P28_BIT 28
#define UPIO_SR_P29_MASK 0x20000000U
#define UPIO_SR_P29 0x20000000U
#define UPIO_SR_P29_BIT 29
#define UPIO_SR_P30_MASK 0x40000000U
#define UPIO_SR_P30 0x40000000U
#define UPIO_SR_P30_BIT 30
#define UPIO_SR_P31_MASK 0x80000000U
#define UPIO_SR_P31 0x80000000U
#define UPIO_SR_P31_BIT 31

#define UPIO_IER (*(volatile unsigned long *)0xFFFD8074)
#define UPIO_IER_OFFSET 0x74
#define UPIO_IER_P0_MASK 0x1U
#define UPIO_IER_P0 0x1U
#define UPIO_IER_P0_BIT 0
#define UPIO_IER_P1_MASK 0x2U
#define UPIO_IER_P1 0x2U
#define UPIO_IER_P1_BIT 1
#define UPIO_IER_P2_MASK 0x4U
#define UPIO_IER_P2 0x4U
#define UPIO_IER_P2_BIT 2
#define UPIO_IER_P3_MASK 0x8U
#define UPIO_IER_P3 0x8U
#define UPIO_IER_P3_BIT 3
#define UPIO_IER_P4_MASK 0x10U
#define UPIO_IER_P4 0x10U
#define UPIO_IER_P4_BIT 4
#define UPIO_IER_P5_MASK 0x20U
#define UPIO_IER_P5 0x20U
#define UPIO_IER_P5_BIT 5
#define UPIO_IER_P6_MASK 0x40U
#define UPIO_IER_P6 0x40U
#define UPIO_IER_P6_BIT 6
#define UPIO_IER_P7_MASK 0x80U
#define UPIO_IER_P7 0x80U
#define UPIO_IER_P7_BIT 7
#define UPIO_IER_P8_MASK 0x100U
#define UPIO_IER_P8 0x100U
#define UPIO_IER_P8_BIT 8
#define UPIO_IER_P9_MASK 0x200U
#define UPIO_IER_P9 0x200U
#define UPIO_IER_P9_BIT 9
#define UPIO_IER_P10_MASK 0x400U
#define UPIO_IER_P10 0x400U
#define UPIO_IER_P10_BIT 10
#define UPIO_IER_P11_MASK 0x800U
#define UPIO_IER_P11 0x800U
#define UPIO_IER_P11_BIT 11
#define UPIO_IER_P12_MASK 0x1000U
#define UPIO_IER_P12 0x1000U
#define UPIO_IER_P12_BIT 12
#define UPIO_IER_P13_MASK 0x2000U
#define UPIO_IER_P13 0x2000U
#define UPIO_IER_P13_BIT 13
#define UPIO_IER_P14_MASK 0x4000U
#define UPIO_IER_P14 0x4000U
#define UPIO_IER_P14_BIT 14
#define UPIO_IER_P15_MASK 0x8000U
#define UPIO_IER_P15 0x8000U
#define UPIO_IER_P15_BIT 15
#define UPIO_IER_P16_MASK 0x10000U
#define UPIO_IER_P16 0x10000U
#define UPIO_IER_P16_BIT 16
#define UPIO_IER_P17_MASK 0x20000U
#define UPIO_IER_P17 0x20000U
#define UPIO_IER_P17_BIT 17
#define UPIO_IER_P18_MASK 0x40000U
#define UPIO_IER_P18 0x40000U
#define UPIO_IER_P18_BIT 18
#define UPIO_IER_P19_MASK 0x80000U
#define UPIO_IER_P19 0x80000U
#define UPIO_IER_P19_BIT 19
#define UPIO_IER_P20_MASK 0x100000U
#define UPIO_IER_P20 0x100000U
#define UPIO_IER_P20_BIT 20
#define UPIO_IER_P21_MASK 0x200000U
#define UPIO_IER_P21 0x200000U
#define UPIO_IER_P21_BIT 21
#define UPIO_IER_P22_MASK 0x400000U
#define UPIO_IER_P22 0x400000U
#define UPIO_IER_P22_BIT 22
#define UPIO_IER_P23_MASK 0x800000U
#define UPIO_IER_P23 0x800000U
#define UPIO_IER_P23_BIT 23
#define UPIO_IER_P24_MASK 0x1000000U
#define UPIO_IER_P24 0x1000000U
#define UPIO_IER_P24_BIT 24
#define UPIO_IER_P25_MASK 0x2000000U
#define UPIO_IER_P25 0x2000000U
#define UPIO_IER_P25_BIT 25
#define UPIO_IER_P26_MASK 0x4000000U
#define UPIO_IER_P26 0x4000000U
#define UPIO_IER_P26_BIT 26
#define UPIO_IER_P27_MASK 0x8000000U
#define UPIO_IER_P27 0x8000000U
#define UPIO_IER_P27_BIT 27
#define UPIO_IER_P28_MASK 0x10000000U
#define UPIO_IER_P28 0x10000000U
#define UPIO_IER_P28_BIT 28
#define UPIO_IER_P29_MASK 0x20000000U
#define UPIO_IER_P29 0x20000000U
#define UPIO_IER_P29_BIT 29
#define UPIO_IER_P30_MASK 0x40000000U
#define UPIO_IER_P30 0x40000000U
#define UPIO_IER_P30_BIT 30
#define UPIO_IER_P31_MASK 0x80000000U
#define UPIO_IER_P31 0x80000000U
#define UPIO_IER_P31_BIT 31

#define UPIO_IDR (*(volatile unsigned long *)0xFFFD8078)
#define UPIO_IDR_OFFSET 0x78
#define UPIO_IDR_P0_MASK 0x1U
#define UPIO_IDR_P0 0x1U
#define UPIO_IDR_P0_BIT 0
#define UPIO_IDR_P1_MASK 0x2U
#define UPIO_IDR_P1 0x2U
#define UPIO_IDR_P1_BIT 1
#define UPIO_IDR_P2_MASK 0x4U
#define UPIO_IDR_P2 0x4U
#define UPIO_IDR_P2_BIT 2
#define UPIO_IDR_P3_MASK 0x8U
#define UPIO_IDR_P3 0x8U
#define UPIO_IDR_P3_BIT 3
#define UPIO_IDR_P4_MASK 0x10U
#define UPIO_IDR_P4 0x10U
#define UPIO_IDR_P4_BIT 4
#define UPIO_IDR_P5_MASK 0x20U
#define UPIO_IDR_P5 0x20U
#define UPIO_IDR_P5_BIT 5
#define UPIO_IDR_P6_MASK 0x40U
#define UPIO_IDR_P6 0x40U
#define UPIO_IDR_P6_BIT 6
#define UPIO_IDR_P7_MASK 0x80U
#define UPIO_IDR_P7 0x80U
#define UPIO_IDR_P7_BIT 7
#define UPIO_IDR_P8_MASK 0x100U
#define UPIO_IDR_P8 0x100U
#define UPIO_IDR_P8_BIT 8
#define UPIO_IDR_P9_MASK 0x200U
#define UPIO_IDR_P9 0x200U
#define UPIO_IDR_P9_BIT 9
#define UPIO_IDR_P10_MASK 0x400U
#define UPIO_IDR_P10 0x400U
#define UPIO_IDR_P10_BIT 10
#define UPIO_IDR_P11_MASK 0x800U
#define UPIO_IDR_P11 0x800U
#define UPIO_IDR_P11_BIT 11
#define UPIO_IDR_P12_MASK 0x1000U
#define UPIO_IDR_P12 0x1000U
#define UPIO_IDR_P12_BIT 12
#define UPIO_IDR_P13_MASK 0x2000U
#define UPIO_IDR_P13 0x2000U
#define UPIO_IDR_P13_BIT 13
#define UPIO_IDR_P14_MASK 0x4000U
#define UPIO_IDR_P14 0x4000U
#define UPIO_IDR_P14_BIT 14
#define UPIO_IDR_P15_MASK 0x8000U
#define UPIO_IDR_P15 0x8000U
#define UPIO_IDR_P15_BIT 15
#define UPIO_IDR_P16_MASK 0x10000U
#define UPIO_IDR_P16 0x10000U
#define UPIO_IDR_P16_BIT 16
#define UPIO_IDR_P17_MASK 0x20000U
#define UPIO_IDR_P17 0x20000U
#define UPIO_IDR_P17_BIT 17
#define UPIO_IDR_P18_MASK 0x40000U
#define UPIO_IDR_P18 0x40000U
#define UPIO_IDR_P18_BIT 18
#define UPIO_IDR_P19_MASK 0x80000U
#define UPIO_IDR_P19 0x80000U
#define UPIO_IDR_P19_BIT 19
#define UPIO_IDR_P20_MASK 0x100000U
#define UPIO_IDR_P20 0x100000U
#define UPIO_IDR_P20_BIT 20
#define UPIO_IDR_P21_MASK 0x200000U
#define UPIO_IDR_P21 0x200000U
#define UPIO_IDR_P21_BIT 21
#define UPIO_IDR_P22_MASK 0x400000U
#define UPIO_IDR_P22 0x400000U
#define UPIO_IDR_P22_BIT 22
#define UPIO_IDR_P23_MASK 0x800000U
#define UPIO_IDR_P23 0x800000U
#define UPIO_IDR_P23_BIT 23
#define UPIO_IDR_P24_MASK 0x1000000U
#define UPIO_IDR_P24 0x1000000U
#define UPIO_IDR_P24_BIT 24
#define UPIO_IDR_P25_MASK 0x2000000U
#define UPIO_IDR_P25 0x2000000U
#define UPIO_IDR_P25_BIT 25
#define UPIO_IDR_P26_MASK 0x4000000U
#define UPIO_IDR_P26 0x4000000U
#define UPIO_IDR_P26_BIT 26
#define UPIO_IDR_P27_MASK 0x8000000U
#define UPIO_IDR_P27 0x8000000U
#define UPIO_IDR_P27_BIT 27
#define UPIO_IDR_P28_MASK 0x10000000U
#define UPIO_IDR_P28 0x10000000U
#define UPIO_IDR_P28_BIT 28
#define UPIO_IDR_P29_MASK 0x20000000U
#define UPIO_IDR_P29 0x20000000U
#define UPIO_IDR_P29_BIT 29
#define UPIO_IDR_P30_MASK 0x40000000U
#define UPIO_IDR_P30 0x40000000U
#define UPIO_IDR_P30_BIT 30
#define UPIO_IDR_P31_MASK 0x80000000U
#define UPIO_IDR_P31 0x80000000U
#define UPIO_IDR_P31_BIT 31

#define UPIO_IMR (*(volatile unsigned long *)0xFFFD807C)
#define UPIO_IMR_OFFSET 0x7C
#define UPIO_IMR_P0_MASK 0x1U
#define UPIO_IMR_P0 0x1U
#define UPIO_IMR_P0_BIT 0
#define UPIO_IMR_P1_MASK 0x2U
#define UPIO_IMR_P1 0x2U
#define UPIO_IMR_P1_BIT 1
#define UPIO_IMR_P2_MASK 0x4U
#define UPIO_IMR_P2 0x4U
#define UPIO_IMR_P2_BIT 2
#define UPIO_IMR_P3_MASK 0x8U
#define UPIO_IMR_P3 0x8U
#define UPIO_IMR_P3_BIT 3
#define UPIO_IMR_P4_MASK 0x10U
#define UPIO_IMR_P4 0x10U
#define UPIO_IMR_P4_BIT 4
#define UPIO_IMR_P5_MASK 0x20U
#define UPIO_IMR_P5 0x20U
#define UPIO_IMR_P5_BIT 5
#define UPIO_IMR_P6_MASK 0x40U
#define UPIO_IMR_P6 0x40U
#define UPIO_IMR_P6_BIT 6
#define UPIO_IMR_P7_MASK 0x80U
#define UPIO_IMR_P7 0x80U
#define UPIO_IMR_P7_BIT 7
#define UPIO_IMR_P8_MASK 0x100U
#define UPIO_IMR_P8 0x100U
#define UPIO_IMR_P8_BIT 8
#define UPIO_IMR_P9_MASK 0x200U
#define UPIO_IMR_P9 0x200U
#define UPIO_IMR_P9_BIT 9
#define UPIO_IMR_P10_MASK 0x400U
#define UPIO_IMR_P10 0x400U
#define UPIO_IMR_P10_BIT 10
#define UPIO_IMR_P11_MASK 0x800U
#define UPIO_IMR_P11 0x800U
#define UPIO_IMR_P11_BIT 11
#define UPIO_IMR_P12_MASK 0x1000U
#define UPIO_IMR_P12 0x1000U
#define UPIO_IMR_P12_BIT 12
#define UPIO_IMR_P13_MASK 0x2000U
#define UPIO_IMR_P13 0x2000U
#define UPIO_IMR_P13_BIT 13
#define UPIO_IMR_P14_MASK 0x4000U
#define UPIO_IMR_P14 0x4000U
#define UPIO_IMR_P14_BIT 14
#define UPIO_IMR_P15_MASK 0x8000U
#define UPIO_IMR_P15 0x8000U
#define UPIO_IMR_P15_BIT 15
#define UPIO_IMR_P16_MASK 0x10000U
#define UPIO_IMR_P16 0x10000U
#define UPIO_IMR_P16_BIT 16
#define UPIO_IMR_P17_MASK 0x20000U
#define UPIO_IMR_P17 0x20000U
#define UPIO_IMR_P17_BIT 17
#define UPIO_IMR_P18_MASK 0x40000U
#define UPIO_IMR_P18 0x40000U
#define UPIO_IMR_P18_BIT 18
#define UPIO_IMR_P19_MASK 0x80000U
#define UPIO_IMR_P19 0x80000U
#define UPIO_IMR_P19_BIT 19
#define UPIO_IMR_P20_MASK 0x100000U
#define UPIO_IMR_P20 0x100000U
#define UPIO_IMR_P20_BIT 20
#define UPIO_IMR_P21_MASK 0x200000U
#define UPIO_IMR_P21 0x200000U
#define UPIO_IMR_P21_BIT 21
#define UPIO_IMR_P22_MASK 0x400000U
#define UPIO_IMR_P22 0x400000U
#define UPIO_IMR_P22_BIT 22
#define UPIO_IMR_P23_MASK 0x800000U
#define UPIO_IMR_P23 0x800000U
#define UPIO_IMR_P23_BIT 23
#define UPIO_IMR_P24_MASK 0x1000000U
#define UPIO_IMR_P24 0x1000000U
#define UPIO_IMR_P24_BIT 24
#define UPIO_IMR_P25_MASK 0x2000000U
#define UPIO_IMR_P25 0x2000000U
#define UPIO_IMR_P25_BIT 25
#define UPIO_IMR_P26_MASK 0x4000000U
#define UPIO_IMR_P26 0x4000000U
#define UPIO_IMR_P26_BIT 26
#define UPIO_IMR_P27_MASK 0x8000000U
#define UPIO_IMR_P27 0x8000000U
#define UPIO_IMR_P27_BIT 27
#define UPIO_IMR_P28_MASK 0x10000000U
#define UPIO_IMR_P28 0x10000000U
#define UPIO_IMR_P28_BIT 28
#define UPIO_IMR_P29_MASK 0x20000000U
#define UPIO_IMR_P29 0x20000000U
#define UPIO_IMR_P29_BIT 29
#define UPIO_IMR_P30_MASK 0x40000000U
#define UPIO_IMR_P30 0x40000000U
#define UPIO_IMR_P30_BIT 30
#define UPIO_IMR_P31_MASK 0x80000000U
#define UPIO_IMR_P31 0x80000000U
#define UPIO_IMR_P31_BIT 31

#define CAPT0_BASE 0xFFFDC000

#define CAPT0_ECR (*(volatile unsigned long *)0xFFFDC050)
#define CAPT0_ECR_OFFSET 0x50
#define CAPT0_ECR_CAP_MASK 0x2U
#define CAPT0_ECR_CAP 0x2U
#define CAPT0_ECR_CAP_BIT 1

#define CAPT0_DCR (*(volatile unsigned long *)0xFFFDC054)
#define CAPT0_DCR_OFFSET 0x54
#define CAPT0_DCR_CAP_MASK 0x2U
#define CAPT0_DCR_CAP 0x2U
#define CAPT0_DCR_CAP_BIT 1

#define CAPT0_PMSR (*(volatile unsigned long *)0xFFFDC058)
#define CAPT0_PMSR_OFFSET 0x58
#define CAPT0_PMSR_CAP_MASK 0x2U
#define CAPT0_PMSR_CAP 0x2U
#define CAPT0_PMSR_CAP_BIT 1

#define CAPT0_CR (*(volatile unsigned long *)0xFFFDC060)
#define CAPT0_CR_OFFSET 0x60
#define CAPT0_CR_SWRST_MASK 0x1U
#define CAPT0_CR_SWRST 0x1U
#define CAPT0_CR_SWRST_BIT 0
#define CAPT0_CR_CAPEN_MASK 0x2U
#define CAPT0_CR_CAPEN 0x2U
#define CAPT0_CR_CAPEN_BIT 1
#define CAPT0_CR_CAPDIS_MASK 0x4U
#define CAPT0_CR_CAPDIS 0x4U
#define CAPT0_CR_CAPDIS_BIT 2
#define CAPT0_CR_STARTCAP_MASK 0x8U
#define CAPT0_CR_STARTCAP 0x8U
#define CAPT0_CR_STARTCAP_BIT 3

#define CAPT0_MR (*(volatile unsigned long *)0xFFFDC064)
#define CAPT0_MR_OFFSET 0x64
#define CAPT0_MR_PRESCALAR_MASK 0xFU
#define CAPT0_MR_PRESCALAR_BIT 0
#define CAPT0_MR_MEASMODE_MASK 0x30U
#define CAPT0_MR_MEASMODE_BIT 4
#define CAPT0_MR_OVERMODE_MASK 0x40U
#define CAPT0_MR_OVERMODE 0x40U
#define CAPT0_MR_OVERMODE_BIT 6
#define CAPT0_MR_ONESHOT_MASK 0x80U
#define CAPT0_MR_ONESHOT 0x80U
#define CAPT0_MR_ONESHOT_BIT 7

#define CAPT0_CSR (*(volatile unsigned long *)0xFFFDC06C)
#define CAPT0_CSR_OFFSET 0x6C
#define CAPT0_CSR_PDCEND_MASK 0x1U
#define CAPT0_CSR_PDCEND 0x1U
#define CAPT0_CSR_PDCEND_BIT 0
#define CAPT0_CSR_OVERRUN_MASK 0x2U
#define CAPT0_CSR_OVERRUN 0x2U
#define CAPT0_CSR_OVERRUN_BIT 1
#define CAPT0_CSR_OVERFLOW_MASK 0x4U
#define CAPT0_CSR_OVERFLOW 0x4U
#define CAPT0_CSR_OVERFLOW_BIT 2

#define CAPT0_SR (*(volatile unsigned long *)0xFFFDC070)
#define CAPT0_SR_OFFSET 0x70
#define CAPT0_SR_PDCEND_MASK 0x1U
#define CAPT0_SR_PDCEND 0x1U
#define CAPT0_SR_PDCEND_BIT 0
#define CAPT0_SR_OVERRUN_MASK 0x2U
#define CAPT0_SR_OVERRUN 0x2U
#define CAPT0_SR_OVERRUN_BIT 1
#define CAPT0_SR_OVERFLOW_MASK 0x4U
#define CAPT0_SR_OVERFLOW 0x4U
#define CAPT0_SR_OVERFLOW_BIT 2
#define CAPT0_SR_DATACAPT_MASK 0x8U
#define CAPT0_SR_DATACAPT 0x8U
#define CAPT0_SR_DATACAPT_BIT 3
#define CAPT0_SR_CAPENS_MASK 0x100U
#define CAPT0_SR_CAPENS 0x100U
#define CAPT0_SR_CAPENS_BIT 8

#define CAPT0_IER (*(volatile unsigned long *)0xFFFDC074)
#define CAPT0_IER_OFFSET 0x74
#define CAPT0_IER_PDCEND_MASK 0x1U
#define CAPT0_IER_PDCEND 0x1U
#define CAPT0_IER_PDCEND_BIT 0
#define CAPT0_IER_OVERRUN_MASK 0x2U
#define CAPT0_IER_OVERRUN 0x2U
#define CAPT0_IER_OVERRUN_BIT 1
#define CAPT0_IER_OVERFLOW_MASK 0x4U
#define CAPT0_IER_OVERFLOW 0x4U
#define CAPT0_IER_OVERFLOW_BIT 2
#define CAPT0_IER_DATACAPT_MASK 0x8U
#define CAPT0_IER_DATACAPT 0x8U
#define CAPT0_IER_DATACAPT_BIT 3

#define CAPT0_IDR (*(volatile unsigned long *)0xFFFDC078)
#define CAPT0_IDR_OFFSET 0x78
#define CAPT0_IDR_PDCEND_MASK 0x1U
#define CAPT0_IDR_PDCEND 0x1U
#define CAPT0_IDR_PDCEND_BIT 0
#define CAPT0_IDR_OVERRUN_MASK 0x2U
#define CAPT0_IDR_OVERRUN 0x2U
#define CAPT0_IDR_OVERRUN_BIT 1
#define CAPT0_IDR_OVERFLOW_MASK 0x4U
#define CAPT0_IDR_OVERFLOW 0x4U
#define CAPT0_IDR_OVERFLOW_BIT 2
#define CAPT0_IDR_DATACAPT_MASK 0x8U
#define CAPT0_IDR_DATACAPT 0x8U
#define CAPT0_IDR_DATACAPT_BIT 3

#define CAPT0_IMR (*(volatile unsigned long *)0xFFFDC07C)
#define CAPT0_IMR_OFFSET 0x7C
#define CAPT0_IMR_PDCEND_MASK 0x1U
#define CAPT0_IMR_PDCEND 0x1U
#define CAPT0_IMR_PDCEND_BIT 0
#define CAPT0_IMR_OVERRUN_MASK 0x2U
#define CAPT0_IMR_OVERRUN 0x2U
#define CAPT0_IMR_OVERRUN_BIT 1
#define CAPT0_IMR_OVERFLOW_MASK 0x4U
#define CAPT0_IMR_OVERFLOW 0x4U
#define CAPT0_IMR_OVERFLOW_BIT 2
#define CAPT0_IMR_DATACAPT_MASK 0x8U
#define CAPT0_IMR_DATACAPT 0x8U
#define CAPT0_IMR_DATACAPT_BIT 3

#define CAPT0_DR (*(volatile unsigned long *)0xFFFDC080)
#define CAPT0_DR_OFFSET 0x80
#define CAPT0_DR_DURATION_MASK 0x7FFFU
#define CAPT0_DR_DURATION_BIT 0
#define CAPT0_DR_LEVEL_MASK 0x8000U
#define CAPT0_DR_LEVEL 0x8000U
#define CAPT0_DR_LEVEL_BIT 15

#define CAPT1_BASE 0xFFFE0000

#define CAPT1_ECR (*(volatile unsigned long *)0xFFFE0050)
#define CAPT1_ECR_OFFSET 0x50
#define CAPT1_ECR_CAP_MASK 0x2U
#define CAPT1_ECR_CAP 0x2U
#define CAPT1_ECR_CAP_BIT 1

#define CAPT1_DCR (*(volatile unsigned long *)0xFFFE0054)
#define CAPT1_DCR_OFFSET 0x54
#define CAPT1_DCR_CAP_MASK 0x2U
#define CAPT1_DCR_CAP 0x2U
#define CAPT1_DCR_CAP_BIT 1

#define CAPT1_PMSR (*(volatile unsigned long *)0xFFFE0058)
#define CAPT1_PMSR_OFFSET 0x58
#define CAPT1_PMSR_CAP_MASK 0x2U
#define CAPT1_PMSR_CAP 0x2U
#define CAPT1_PMSR_CAP_BIT 1

#define CAPT1_CR (*(volatile unsigned long *)0xFFFE0060)
#define CAPT1_CR_OFFSET 0x60
#define CAPT1_CR_SWRST_MASK 0x1U
#define CAPT1_CR_SWRST 0x1U
#define CAPT1_CR_SWRST_BIT 0
#define CAPT1_CR_CAPEN_MASK 0x2U
#define CAPT1_CR_CAPEN 0x2U
#define CAPT1_CR_CAPEN_BIT 1
#define CAPT1_CR_CAPDIS_MASK 0x4U
#define CAPT1_CR_CAPDIS 0x4U
#define CAPT1_CR_CAPDIS_BIT 2
#define CAPT1_CR_STARTCAP_MASK 0x8U
#define CAPT1_CR_STARTCAP 0x8U
#define CAPT1_CR_STARTCAP_BIT 3

#define CAPT1_MR (*(volatile unsigned long *)0xFFFE0064)
#define CAPT1_MR_OFFSET 0x64
#define CAPT1_MR_PRESCALAR_MASK 0xFU
#define CAPT1_MR_PRESCALAR_BIT 0
#define CAPT1_MR_MEASMODE_MASK 0x30U
#define CAPT1_MR_MEASMODE_BIT 4
#define CAPT1_MR_OVERMODE_MASK 0x40U
#define CAPT1_MR_OVERMODE 0x40U
#define CAPT1_MR_OVERMODE_BIT 6
#define CAPT1_MR_ONESHOT_MASK 0x80U
#define CAPT1_MR_ONESHOT 0x80U
#define CAPT1_MR_ONESHOT_BIT 7

#define CAPT1_CSR (*(volatile unsigned long *)0xFFFE006C)
#define CAPT1_CSR_OFFSET 0x6C
#define CAPT1_CSR_PDCEND_MASK 0x1U
#define CAPT1_CSR_PDCEND 0x1U
#define CAPT1_CSR_PDCEND_BIT 0
#define CAPT1_CSR_OVERRUN_MASK 0x2U
#define CAPT1_CSR_OVERRUN 0x2U
#define CAPT1_CSR_OVERRUN_BIT 1
#define CAPT1_CSR_OVERFLOW_MASK 0x4U
#define CAPT1_CSR_OVERFLOW 0x4U
#define CAPT1_CSR_OVERFLOW_BIT 2

#define CAPT1_SR (*(volatile unsigned long *)0xFFFE0070)
#define CAPT1_SR_OFFSET 0x70
#define CAPT1_SR_PDCEND_MASK 0x1U
#define CAPT1_SR_PDCEND 0x1U
#define CAPT1_SR_PDCEND_BIT 0
#define CAPT1_SR_OVERRUN_MASK 0x2U
#define CAPT1_SR_OVERRUN 0x2U
#define CAPT1_SR_OVERRUN_BIT 1
#define CAPT1_SR_OVERFLOW_MASK 0x4U
#define CAPT1_SR_OVERFLOW 0x4U
#define CAPT1_SR_OVERFLOW_BIT 2
#define CAPT1_SR_DATACAPT_MASK 0x8U
#define CAPT1_SR_DATACAPT 0x8U
#define CAPT1_SR_DATACAPT_BIT 3
#define CAPT1_SR_CAPENS_MASK 0x100U
#define CAPT1_SR_CAPENS 0x100U
#define CAPT1_SR_CAPENS_BIT 8

#define CAPT1_IER (*(volatile unsigned long *)0xFFFE0074)
#define CAPT1_IER_OFFSET 0x74
#define CAPT1_IER_PDCEND_MASK 0x1U
#define CAPT1_IER_PDCEND 0x1U
#define CAPT1_IER_PDCEND_BIT 0
#define CAPT1_IER_OVERRUN_MASK 0x2U
#define CAPT1_IER_OVERRUN 0x2U
#define CAPT1_IER_OVERRUN_BIT 1
#define CAPT1_IER_OVERFLOW_MASK 0x4U
#define CAPT1_IER_OVERFLOW 0x4U
#define CAPT1_IER_OVERFLOW_BIT 2
#define CAPT1_IER_DATACAPT_MASK 0x8U
#define CAPT1_IER_DATACAPT 0x8U
#define CAPT1_IER_DATACAPT_BIT 3

#define CAPT1_IDR (*(volatile unsigned long *)0xFFFE0078)
#define CAPT1_IDR_OFFSET 0x78
#define CAPT1_IDR_PDCEND_MASK 0x1U
#define CAPT1_IDR_PDCEND 0x1U
#define CAPT1_IDR_PDCEND_BIT 0
#define CAPT1_IDR_OVERRUN_MASK 0x2U
#define CAPT1_IDR_OVERRUN 0x2U
#define CAPT1_IDR_OVERRUN_BIT 1
#define CAPT1_IDR_OVERFLOW_MASK 0x4U
#define CAPT1_IDR_OVERFLOW 0x4U
#define CAPT1_IDR_OVERFLOW_BIT 2
#define CAPT1_IDR_DATACAPT_MASK 0x8U
#define CAPT1_IDR_DATACAPT 0x8U
#define CAPT1_IDR_DATACAPT_BIT 3

#define CAPT1_IMR (*(volatile unsigned long *)0xFFFE007C)
#define CAPT1_IMR_OFFSET 0x7C
#define CAPT1_IMR_PDCEND_MASK 0x1U
#define CAPT1_IMR_PDCEND 0x1U
#define CAPT1_IMR_PDCEND_BIT 0
#define CAPT1_IMR_OVERRUN_MASK 0x2U
#define CAPT1_IMR_OVERRUN 0x2U
#define CAPT1_IMR_OVERRUN_BIT 1
#define CAPT1_IMR_OVERFLOW_MASK 0x4U
#define CAPT1_IMR_OVERFLOW 0x4U
#define CAPT1_IMR_OVERFLOW_BIT 2
#define CAPT1_IMR_DATACAPT_MASK 0x8U
#define CAPT1_IMR_DATACAPT 0x8U
#define CAPT1_IMR_DATACAPT_BIT 3

#define CAPT1_DR (*(volatile unsigned long *)0xFFFE0080)
#define CAPT1_DR_OFFSET 0x80
#define CAPT1_DR_DURATION_MASK 0x7FFFU
#define CAPT1_DR_DURATION_BIT 0
#define CAPT1_DR_LEVEL_MASK 0x8000U
#define CAPT1_DR_LEVEL 0x8000U
#define CAPT1_DR_LEVEL_BIT 15

#define ST0_BASE 0xFFFE4000

#define ST0_ECR (*(volatile unsigned long *)0xFFFE4050)
#define ST0_ECR_OFFSET 0x50
#define ST0_ECR_ST_MASK 0x2U
#define ST0_ECR_ST 0x2U
#define ST0_ECR_ST_BIT 1

#define ST0_DCR (*(volatile unsigned long *)0xFFFE4054)
#define ST0_DCR_OFFSET 0x54
#define ST0_DCR_ST_MASK 0x2U
#define ST0_DCR_ST 0x2U
#define ST0_DCR_ST_BIT 1

#define ST0_PMSR (*(volatile unsigned long *)0xFFFE4058)
#define ST0_PMSR_OFFSET 0x58
#define ST0_PMSR_ST_MASK 0x2U
#define ST0_PMSR_ST 0x2U
#define ST0_PMSR_ST_BIT 1

#define ST0_CR (*(volatile unsigned long *)0xFFFE4060)
#define ST0_CR_OFFSET 0x60
#define ST0_CR_SWRST_MASK 0x1U
#define ST0_CR_SWRST 0x1U
#define ST0_CR_SWRST_BIT 0
#define ST0_CR_CHEN0_MASK 0x2U
#define ST0_CR_CHEN0 0x2U
#define ST0_CR_CHEN0_BIT 1
#define ST0_CR_CHDIS0_MASK 0x4U
#define ST0_CR_CHDIS0 0x4U
#define ST0_CR_CHDIS0_BIT 2
#define ST0_CR_CHEN1_MASK 0x8U
#define ST0_CR_CHEN1 0x8U
#define ST0_CR_CHEN1_BIT 3
#define ST0_CR_CHDIS1_MASK 0x10U
#define ST0_CR_CHDIS1 0x10U
#define ST0_CR_CHDIS1_BIT 4

#define ST0_CSR (*(volatile unsigned long *)0xFFFE406C)
#define ST0_CSR_OFFSET 0x6C
#define ST0_CSR_CHEND0_MASK 0x1U
#define ST0_CSR_CHEND0 0x1U
#define ST0_CSR_CHEND0_BIT 0
#define ST0_CSR_CHDIS0_MASK 0x2U
#define ST0_CSR_CHDIS0 0x2U
#define ST0_CSR_CHDIS0_BIT 1
#define ST0_CSR_CHLD0_MASK 0x4U
#define ST0_CSR_CHLD0 0x4U
#define ST0_CSR_CHLD0_BIT 2
#define ST0_CSR_CHEND1_MASK 0x8U
#define ST0_CSR_CHEND1 0x8U
#define ST0_CSR_CHEND1_BIT 3
#define ST0_CSR_CHDIS1_MASK 0x10U
#define ST0_CSR_CHDIS1 0x10U
#define ST0_CSR_CHDIS1_BIT 4
#define ST0_CSR_CHLD1_MASK 0x20U
#define ST0_CSR_CHLD1 0x20U
#define ST0_CSR_CHLD1_BIT 5

#define ST0_SR (*(volatile unsigned long *)0xFFFE4070)
#define ST0_SR_OFFSET 0x70
#define ST0_SR_CHEND0_MASK 0x1U
#define ST0_SR_CHEND0 0x1U
#define ST0_SR_CHEND0_BIT 0
#define ST0_SR_CHDIS0_MASK 0x2U
#define ST0_SR_CHDIS0 0x2U
#define ST0_SR_CHDIS0_BIT 1
#define ST0_SR_CHLD0_MASK 0x4U
#define ST0_SR_CHLD0 0x4U
#define ST0_SR_CHLD0_BIT 2
#define ST0_SR_CHEND1_MASK 0x8U
#define ST0_SR_CHEND1 0x8U
#define ST0_SR_CHEND1_BIT 3
#define ST0_SR_CHDIS1_MASK 0x10U
#define ST0_SR_CHDIS1 0x10U
#define ST0_SR_CHDIS1_BIT 4
#define ST0_SR_CHLD1_MASK 0x20U
#define ST0_SR_CHLD1 0x20U
#define ST0_SR_CHLD1_BIT 5
#define ST0_SR_CHENS0_MASK 0x1000000U
#define ST0_SR_CHENS0 0x1000000U
#define ST0_SR_CHENS0_BIT 24
#define ST0_SR_CHENS1_MASK 0x2000000U
#define ST0_SR_CHENS1 0x2000000U
#define ST0_SR_CHENS1_BIT 25

#define ST0_IER (*(volatile unsigned long *)0xFFFE4074)
#define ST0_IER_OFFSET 0x74
#define ST0_IER_CHEND0_MASK 0x1U
#define ST0_IER_CHEND0 0x1U
#define ST0_IER_CHEND0_BIT 0
#define ST0_IER_CHDIS0_MASK 0x2U
#define ST0_IER_CHDIS0 0x2U
#define ST0_IER_CHDIS0_BIT 1
#define ST0_IER_CHLD0_MASK 0x4U
#define ST0_IER_CHLD0 0x4U
#define ST0_IER_CHLD0_BIT 2
#define ST0_IER_CHEND1_MASK 0x8U
#define ST0_IER_CHEND1 0x8U
#define ST0_IER_CHEND1_BIT 3
#define ST0_IER_CHDIS1_MASK 0x10U
#define ST0_IER_CHDIS1 0x10U
#define ST0_IER_CHDIS1_BIT 4
#define ST0_IER_CHLD1_MASK 0x20U
#define ST0_IER_CHLD1 0x20U
#define ST0_IER_CHLD1_BIT 5

#define ST0_IDR (*(volatile unsigned long *)0xFFFE4078)
#define ST0_IDR_OFFSET 0x78
#define ST0_IDR_CHEND0_MASK 0x1U
#define ST0_IDR_CHEND0 0x1U
#define ST0_IDR_CHEND0_BIT 0
#define ST0_IDR_CHDIS0_MASK 0x2U
#define ST0_IDR_CHDIS0 0x2U
#define ST0_IDR_CHDIS0_BIT 1
#define ST0_IDR_CHLD0_MASK 0x4U
#define ST0_IDR_CHLD0 0x4U
#define ST0_IDR_CHLD0_BIT 2
#define ST0_IDR_CHEND1_MASK 0x8U
#define ST0_IDR_CHEND1 0x8U
#define ST0_IDR_CHEND1_BIT 3
#define ST0_IDR_CHDIS1_MASK 0x10U
#define ST0_IDR_CHDIS1 0x10U
#define ST0_IDR_CHDIS1_BIT 4
#define ST0_IDR_CHLD1_MASK 0x20U
#define ST0_IDR_CHLD1 0x20U
#define ST0_IDR_CHLD1_BIT 5

#define ST0_IMR (*(volatile unsigned long *)0xFFFE407C)
#define ST0_IMR_OFFSET 0x7C
#define ST0_IMR_CHEND0_MASK 0x1U
#define ST0_IMR_CHEND0 0x1U
#define ST0_IMR_CHEND0_BIT 0
#define ST0_IMR_CHDIS0_MASK 0x2U
#define ST0_IMR_CHDIS0 0x2U
#define ST0_IMR_CHDIS0_BIT 1
#define ST0_IMR_CHLD0_MASK 0x4U
#define ST0_IMR_CHLD0 0x4U
#define ST0_IMR_CHLD0_BIT 2
#define ST0_IMR_CHEND1_MASK 0x8U
#define ST0_IMR_CHEND1 0x8U
#define ST0_IMR_CHEND1_BIT 3
#define ST0_IMR_CHDIS1_MASK 0x10U
#define ST0_IMR_CHDIS1 0x10U
#define ST0_IMR_CHDIS1_BIT 4
#define ST0_IMR_CHLD1_MASK 0x20U
#define ST0_IMR_CHLD1 0x20U
#define ST0_IMR_CHLD1_BIT 5

#define ST0_PR0 (*(volatile unsigned long *)0xFFFE4080)
#define ST0_PR0_OFFSET 0x80
#define ST0_PR0_PRESCALAR_MASK 0xFU
#define ST0_PR0_PRESCALAR_BIT 0
#define ST0_PR0_SELECTCLK_MASK 0x10U
#define ST0_PR0_SELECTCLK 0x10U
#define ST0_PR0_SELECTCLK_BIT 4
#define ST0_PR0_AUTOREL_MASK 0x20U
#define ST0_PR0_AUTOREL 0x20U
#define ST0_PR0_AUTOREL_BIT 5
#define ST0_PR0_SYSCAL_MASK 0x7FF00U
#define ST0_PR0_SYSCAL_BIT 8

#define ST0_CT0 (*(volatile unsigned long *)0xFFFE4084)
#define ST0_CT0_OFFSET 0x84
#define ST0_CT0_LOAD_MASK 0xFFFFU
#define ST0_CT0_LOAD_BIT 0

#define ST0_PR1 (*(volatile unsigned long *)0xFFFE4088)
#define ST0_PR1_OFFSET 0x88
#define ST0_PR1_PRESCALAR_MASK 0xFU
#define ST0_PR1_PRESCALAR_BIT 0
#define ST0_PR1_SELECTCLK_MASK 0x10U
#define ST0_PR1_SELECTCLK 0x10U
#define ST0_PR1_SELECTCLK_BIT 4
#define ST0_PR1_AUTOREL_MASK 0x20U
#define ST0_PR1_AUTOREL 0x20U
#define ST0_PR1_AUTOREL_BIT 5
#define ST0_PR1_SYSCAL_MASK 0x7FF00U
#define ST0_PR1_SYSCAL_BIT 8

#define ST0_CT1 (*(volatile unsigned long *)0xFFFE408C)
#define ST0_CT1_OFFSET 0x8C
#define ST0_CT1_LOAD_MASK 0xFFFFU
#define ST0_CT1_LOAD_BIT 0

#define ST0_CCV0 (*(volatile unsigned long *)0xFFFE4200)
#define ST0_CCV0_OFFSET 0x200
#define ST0_CCV0_COUNT_MASK 0xFFFFU
#define ST0_CCV0_COUNT_BIT 0

#define ST0_CCV1 (*(volatile unsigned long *)0xFFFE4204)
#define ST0_CCV1_OFFSET 0x204
#define ST0_CCV1_COUNT_MASK 0xFFFFU
#define ST0_CCV1_COUNT_BIT 0

#define ST1_BASE 0xFFFE8000

#define ST1_ECR (*(volatile unsigned long *)0xFFFE8050)
#define ST1_ECR_OFFSET 0x50
#define ST1_ECR_ST_MASK 0x2U
#define ST1_ECR_ST 0x2U
#define ST1_ECR_ST_BIT 1

#define ST1_DCR (*(volatile unsigned long *)0xFFFE8054)
#define ST1_DCR_OFFSET 0x54
#define ST1_DCR_ST_MASK 0x2U
#define ST1_DCR_ST 0x2U
#define ST1_DCR_ST_BIT 1

#define ST1_PMSR (*(volatile unsigned long *)0xFFFE8058)
#define ST1_PMSR_OFFSET 0x58
#define ST1_PMSR_ST_MASK 0x2U
#define ST1_PMSR_ST 0x2U
#define ST1_PMSR_ST_BIT 1

#define ST1_CR (*(volatile unsigned long *)0xFFFE8060)
#define ST1_CR_OFFSET 0x60
#define ST1_CR_SWRST_MASK 0x1U
#define ST1_CR_SWRST 0x1U
#define ST1_CR_SWRST_BIT 0
#define ST1_CR_CHEN0_MASK 0x2U
#define ST1_CR_CHEN0 0x2U
#define ST1_CR_CHEN0_BIT 1
#define ST1_CR_CHDIS0_MASK 0x4U
#define ST1_CR_CHDIS0 0x4U
#define ST1_CR_CHDIS0_BIT 2
#define ST1_CR_CHEN1_MASK 0x8U
#define ST1_CR_CHEN1 0x8U
#define ST1_CR_CHEN1_BIT 3
#define ST1_CR_CHDIS1_MASK 0x10U
#define ST1_CR_CHDIS1 0x10U
#define ST1_CR_CHDIS1_BIT 4

#define ST1_CSR (*(volatile unsigned long *)0xFFFE806C)
#define ST1_CSR_OFFSET 0x6C
#define ST1_CSR_CHEND0_MASK 0x1U
#define ST1_CSR_CHEND0 0x1U
#define ST1_CSR_CHEND0_BIT 0
#define ST1_CSR_CHDIS0_MASK 0x2U
#define ST1_CSR_CHDIS0 0x2U
#define ST1_CSR_CHDIS0_BIT 1
#define ST1_CSR_CHLD0_MASK 0x4U
#define ST1_CSR_CHLD0 0x4U
#define ST1_CSR_CHLD0_BIT 2
#define ST1_CSR_CHEND1_MASK 0x8U
#define ST1_CSR_CHEND1 0x8U
#define ST1_CSR_CHEND1_BIT 3
#define ST1_CSR_CHDIS1_MASK 0x10U
#define ST1_CSR_CHDIS1 0x10U
#define ST1_CSR_CHDIS1_BIT 4
#define ST1_CSR_CHLD1_MASK 0x20U
#define ST1_CSR_CHLD1 0x20U
#define ST1_CSR_CHLD1_BIT 5

#define ST1_SR (*(volatile unsigned long *)0xFFFE8070)
#define ST1_SR_OFFSET 0x70
#define ST1_SR_CHEND0_MASK 0x1U
#define ST1_SR_CHEND0 0x1U
#define ST1_SR_CHEND0_BIT 0
#define ST1_SR_CHDIS0_MASK 0x2U
#define ST1_SR_CHDIS0 0x2U
#define ST1_SR_CHDIS0_BIT 1
#define ST1_SR_CHLD0_MASK 0x4U
#define ST1_SR_CHLD0 0x4U
#define ST1_SR_CHLD0_BIT 2
#define ST1_SR_CHEND1_MASK 0x8U
#define ST1_SR_CHEND1 0x8U
#define ST1_SR_CHEND1_BIT 3
#define ST1_SR_CHDIS1_MASK 0x10U
#define ST1_SR_CHDIS1 0x10U
#define ST1_SR_CHDIS1_BIT 4
#define ST1_SR_CHLD1_MASK 0x20U
#define ST1_SR_CHLD1 0x20U
#define ST1_SR_CHLD1_BIT 5
#define ST1_SR_CHENS0_MASK 0x1000000U
#define ST1_SR_CHENS0 0x1000000U
#define ST1_SR_CHENS0_BIT 24
#define ST1_SR_CHENS1_MASK 0x2000000U
#define ST1_SR_CHENS1 0x2000000U
#define ST1_SR_CHENS1_BIT 25

#define ST1_IER (*(volatile unsigned long *)0xFFFE8074)
#define ST1_IER_OFFSET 0x74
#define ST1_IER_CHEND0_MASK 0x1U
#define ST1_IER_CHEND0 0x1U
#define ST1_IER_CHEND0_BIT 0
#define ST1_IER_CHDIS0_MASK 0x2U
#define ST1_IER_CHDIS0 0x2U
#define ST1_IER_CHDIS0_BIT 1
#define ST1_IER_CHLD0_MASK 0x4U
#define ST1_IER_CHLD0 0x4U
#define ST1_IER_CHLD0_BIT 2
#define ST1_IER_CHEND1_MASK 0x8U
#define ST1_IER_CHEND1 0x8U
#define ST1_IER_CHEND1_BIT 3
#define ST1_IER_CHDIS1_MASK 0x10U
#define ST1_IER_CHDIS1 0x10U
#define ST1_IER_CHDIS1_BIT 4
#define ST1_IER_CHLD1_MASK 0x20U
#define ST1_IER_CHLD1 0x20U
#define ST1_IER_CHLD1_BIT 5

#define ST1_IDR (*(volatile unsigned long *)0xFFFE8078)
#define ST1_IDR_OFFSET 0x78
#define ST1_IDR_CHEND0_MASK 0x1U
#define ST1_IDR_CHEND0 0x1U
#define ST1_IDR_CHEND0_BIT 0
#define ST1_IDR_CHDIS0_MASK 0x2U
#define ST1_IDR_CHDIS0 0x2U
#define ST1_IDR_CHDIS0_BIT 1
#define ST1_IDR_CHLD0_MASK 0x4U
#define ST1_IDR_CHLD0 0x4U
#define ST1_IDR_CHLD0_BIT 2
#define ST1_IDR_CHEND1_MASK 0x8U
#define ST1_IDR_CHEND1 0x8U
#define ST1_IDR_CHEND1_BIT 3
#define ST1_IDR_CHDIS1_MASK 0x10U
#define ST1_IDR_CHDIS1 0x10U
#define ST1_IDR_CHDIS1_BIT 4
#define ST1_IDR_CHLD1_MASK 0x20U
#define ST1_IDR_CHLD1 0x20U
#define ST1_IDR_CHLD1_BIT 5

#define ST1_IMR (*(volatile unsigned long *)0xFFFE807C)
#define ST1_IMR_OFFSET 0x7C
#define ST1_IMR_CHEND0_MASK 0x1U
#define ST1_IMR_CHEND0 0x1U
#define ST1_IMR_CHEND0_BIT 0
#define ST1_IMR_CHDIS0_MASK 0x2U
#define ST1_IMR_CHDIS0 0x2U
#define ST1_IMR_CHDIS0_BIT 1
#define ST1_IMR_CHLD0_MASK 0x4U
#define ST1_IMR_CHLD0 0x4U
#define ST1_IMR_CHLD0_BIT 2
#define ST1_IMR_CHEND1_MASK 0x8U
#define ST1_IMR_CHEND1 0x8U
#define ST1_IMR_CHEND1_BIT 3
#define ST1_IMR_CHDIS1_MASK 0x10U
#define ST1_IMR_CHDIS1 0x10U
#define ST1_IMR_CHDIS1_BIT 4
#define ST1_IMR_CHLD1_MASK 0x20U
#define ST1_IMR_CHLD1 0x20U
#define ST1_IMR_CHLD1_BIT 5

#define ST1_PR0 (*(volatile unsigned long *)0xFFFE8080)
#define ST1_PR0_OFFSET 0x80
#define ST1_PR0_PRESCALAR_MASK 0xFU
#define ST1_PR0_PRESCALAR_BIT 0
#define ST1_PR0_SELECTCLK_MASK 0x10U
#define ST1_PR0_SELECTCLK 0x10U
#define ST1_PR0_SELECTCLK_BIT 4
#define ST1_PR0_AUTOREL_MASK 0x20U
#define ST1_PR0_AUTOREL 0x20U
#define ST1_PR0_AUTOREL_BIT 5
#define ST1_PR0_SYSCAL_MASK 0x7FF00U
#define ST1_PR0_SYSCAL_BIT 8

#define ST1_CT0 (*(volatile unsigned long *)0xFFFE8084)
#define ST1_CT0_OFFSET 0x84
#define ST1_CT0_LOAD_MASK 0xFFFFU
#define ST1_CT0_LOAD_BIT 0

#define ST1_PR1 (*(volatile unsigned long *)0xFFFE8088)
#define ST1_PR1_OFFSET 0x88
#define ST1_PR1_PRESCALAR_MASK 0xFU
#define ST1_PR1_PRESCALAR_BIT 0
#define ST1_PR1_SELECTCLK_MASK 0x10U
#define ST1_PR1_SELECTCLK 0x10U
#define ST1_PR1_SELECTCLK_BIT 4
#define ST1_PR1_AUTOREL_MASK 0x20U
#define ST1_PR1_AUTOREL 0x20U
#define ST1_PR1_AUTOREL_BIT 5
#define ST1_PR1_SYSCAL_MASK 0x7FF00U
#define ST1_PR1_SYSCAL_BIT 8

#define ST1_CT1 (*(volatile unsigned long *)0xFFFE808C)
#define ST1_CT1_OFFSET 0x8C
#define ST1_CT1_LOAD_MASK 0xFFFFU
#define ST1_CT1_LOAD_BIT 0

#define ST1_CCV0 (*(volatile unsigned long *)0xFFFE8200)
#define ST1_CCV0_OFFSET 0x200
#define ST1_CCV0_COUNT_MASK 0xFFFFU
#define ST1_CCV0_COUNT_BIT 0

#define ST1_CCV1 (*(volatile unsigned long *)0xFFFE8204)
#define ST1_CCV1_OFFSET 0x204
#define ST1_CCV1_COUNT_MASK 0xFFFFU
#define ST1_CCV1_COUNT_BIT 0

#define CM_BASE 0xFFFEC000

#define CM_CE (*(volatile unsigned long *)0xFFFEC000)
#define CM_CE_OFFSET 0x0
#define CM_CE_PLLSLCT_MASK 0x4U
#define CM_CE_PLLSLCT 0x4U
#define CM_CE_PLLSLCT_BIT 2
#define CM_CE_LFSLCT_MASK 0x8U
#define CM_CE_LFSLCT 0x8U
#define CM_CE_LFSLCT_BIT 3
#define CM_CE_DIVSLCT_MASK 0x20U
#define CM_CE_DIVSLCT 0x20U
#define CM_CE_DIVSLCT_BIT 5
#define CM_CE_RTCSEL_MASK 0x40U
#define CM_CE_RTCSEL 0x40U
#define CM_CE_RTCSEL_BIT 6
#define CM_CE_RTCKEN_MASK 0x80U
#define CM_CE_RTCKEN 0x80U
#define CM_CE_RTCKEN_BIT 7
#define CM_CE_CLKEKEY_MASK 0xFFFF0000U
#define CM_CE_CLKEKEY_BIT 16

#define CM_CD (*(volatile unsigned long *)0xFFFEC004)
#define CM_CD_OFFSET 0x4
#define CM_CD_PLLSLCT_MASK 0x4U
#define CM_CD_PLLSLCT 0x4U
#define CM_CD_PLLSLCT_BIT 2
#define CM_CD_LFSLCT_MASK 0x8U
#define CM_CD_LFSLCT 0x8U
#define CM_CD_LFSLCT_BIT 3
#define CM_CD_DIVSLCT_MASK 0x20U
#define CM_CD_DIVSLCT 0x20U
#define CM_CD_DIVSLCT_BIT 5
#define CM_CD_RTCSEL_MASK 0x40U
#define CM_CD_RTCSEL 0x40U
#define CM_CD_RTCSEL_BIT 6
#define CM_CD_RTCKEN_MASK 0x80U
#define CM_CD_RTCKEN 0x80U
#define CM_CD_RTCKEN_BIT 7
#define CM_CD_CLKEKEY_MASK 0xFFFF0000U
#define CM_CD_CLKEKEY_BIT 16

#define CM_CS (*(volatile unsigned long *)0xFFFEC008)
#define CM_CS_OFFSET 0x8
#define CM_CS_PLLSLCT_MASK 0x4U
#define CM_CS_PLLSLCT 0x4U
#define CM_CS_PLLSLCT_BIT 2
#define CM_CS_LFSLCT_MASK 0x8U
#define CM_CS_LFSLCT 0x8U
#define CM_CS_LFSLCT_BIT 3
#define CM_CS_DIVSLCT_MASK 0x20U
#define CM_CS_DIVSLCT 0x20U
#define CM_CS_DIVSLCT_BIT 5
#define CM_CS_RTCSEL_MASK 0x40U
#define CM_CS_RTCSEL 0x40U
#define CM_CS_RTCSEL_BIT 6
#define CM_CS_RTCKEN_MASK 0x80U
#define CM_CS_RTCKEN 0x80U
#define CM_CS_RTCKEN_BIT 7
#define CM_CS_MCKEN_MASK 0x100U
#define CM_CS_MCKEN 0x100U
#define CM_CS_MCKEN_BIT 8
#define CM_CS_PLLEN_MASK 0x200U
#define CM_CS_PLLEN 0x200U
#define CM_CS_PLLEN_BIT 9
#define CM_CS_DIVEN_MASK 0x2000U
#define CM_CS_DIVEN 0x2000U
#define CM_CS_DIVEN_BIT 13
#define CM_CS_RTCSLCT_MASK 0x4000U
#define CM_CS_RTCSLCT 0x4000U
#define CM_CS_RTCSLCT_BIT 14

#define CM_PST (*(volatile unsigned long *)0xFFFEC00C)
#define CM_PST_OFFSET 0xC
#define CM_PST_PSTB_MASK 0x3FFU
#define CM_PST_PSTB_BIT 0
#define CM_PST_PSTKEY_MASK 0xFFFF0000U
#define CM_PST_PSTKEY_BIT 16

#define CM_PDIV (*(volatile unsigned long *)0xFFFEC010)
#define CM_PDIV_OFFSET 0x10
#define CM_PDIV_PMUL_MASK 0x1FU
#define CM_PDIV_PMUL_BIT 0
#define CM_PDIV_PLLDIV2_MASK 0x8000U
#define CM_PDIV_PLLDIV2 0x8000U
#define CM_PDIV_PLLDIV2_BIT 15
#define CM_PDIV_PDIVKEY_MASK 0xFFFF0000U
#define CM_PDIV_PDIVKEY_BIT 16

#define CM_OST (*(volatile unsigned long *)0xFFFEC014)
#define CM_OST_OFFSET 0x14
#define CM_OST_OSTB_MASK 0x3FFU
#define CM_OST_OSTB_BIT 0
#define CM_OST_OSTKEY_MASK 0xFFFF0000U
#define CM_OST_OSTKEY_BIT 16

#define CM_MDIV (*(volatile unsigned long *)0xFFFEC018)
#define CM_MDIV_OFFSET 0x18
#define CM_MDIV_MDIV_MASK 0x3FU
#define CM_MDIV_MDIV_BIT 0
#define CM_MDIV_MDIVKEY_MASK 0xFFFF0000U
#define CM_MDIV_MDIVKEY_BIT 16

#define PMC_BASE 0xFFFF4000

#define PMC_ECR (*(volatile unsigned long *)0xFFFF4050)
#define PMC_ECR_OFFSET 0x50
#define PMC_ECR_PDC_MASK 0x2U
#define PMC_ECR_PDC 0x2U
#define PMC_ECR_PDC_BIT 1

#define PMC_DCR (*(volatile unsigned long *)0xFFFF4054)
#define PMC_DCR_OFFSET 0x54
#define PMC_DCR_ARM_MASK 0x1U
#define PMC_DCR_ARM 0x1U
#define PMC_DCR_ARM_BIT 0
#define PMC_DCR_PDC_MASK 0x2U
#define PMC_DCR_PDC 0x2U
#define PMC_DCR_PDC_BIT 1

#define PMC_PMSR (*(volatile unsigned long *)0xFFFF4058)
#define PMC_PMSR_OFFSET 0x58
#define PMC_PMSR_ARM_MASK 0x1U
#define PMC_PMSR_ARM 0x1U
#define PMC_PMSR_ARM_BIT 0
#define PMC_PMSR_PDC_MASK 0x2U
#define PMC_PMSR_PDC 0x2U
#define PMC_PMSR_PDC_BIT 1

#define PDC_BASE 0xFFFF8000

#define PDC_PRA0 (*(volatile unsigned long *)0xFFFF8080)
#define PDC_PRA0_OFFSET 0x80
#define PDC_PRA0_CHPRA_MASK 0x0U
#define PDC_PRA0_CHPRA_BIT 0

#define PDC_CR0 (*(volatile unsigned long *)0xFFFF8084)
#define PDC_CR0_OFFSET 0x84
#define PDC_CR0_DIR_MASK 0x1U
#define PDC_CR0_DIR 0x1U
#define PDC_CR0_DIR_BIT 0
#define PDC_CR0_SIZE_MASK 0x6U
#define PDC_CR0_SIZE_BIT 1

#define PDC_MPR0 (*(volatile unsigned long *)0xFFFF8088)
#define PDC_MPR0_OFFSET 0x88
#define PDC_MPR0_CHPTR_MASK 0x0U
#define PDC_MPR0_CHPTR_BIT 0

#define PDC_TCR0 (*(volatile unsigned long *)0xFFFF808C)
#define PDC_TCR0_OFFSET 0x8C
#define PDC_TCR0_CHCTR_MASK 0xFFFFU
#define PDC_TCR0_CHCTR_BIT 0

#define PDC_PRA1 (*(volatile unsigned long *)0xFFFF8090)
#define PDC_PRA1_OFFSET 0x90
#define PDC_PRA1_CHPRA_MASK 0x0U
#define PDC_PRA1_CHPRA_BIT 0

#define PDC_CR1 (*(volatile unsigned long *)0xFFFF8094)
#define PDC_CR1_OFFSET 0x94
#define PDC_CR1_DIR_MASK 0x1U
#define PDC_CR1_DIR 0x1U
#define PDC_CR1_DIR_BIT 0
#define PDC_CR1_SIZE_MASK 0x6U
#define PDC_CR1_SIZE_BIT 1

#define PDC_MPR1 (*(volatile unsigned long *)0xFFFF8098)
#define PDC_MPR1_OFFSET 0x98
#define PDC_MPR1_CHPTR_MASK 0x0U
#define PDC_MPR1_CHPTR_BIT 0

#define PDC_TCR1 (*(volatile unsigned long *)0xFFFF809C)
#define PDC_TCR1_OFFSET 0x9C
#define PDC_TCR1_CHCTR_MASK 0xFFFFU
#define PDC_TCR1_CHCTR_BIT 0

#define PDC_PRA2 (*(volatile unsigned long *)0xFFFF80A0)
#define PDC_PRA2_OFFSET 0xA0
#define PDC_PRA2_CHPRA_MASK 0x0U
#define PDC_PRA2_CHPRA_BIT 0

#define PDC_CR2 (*(volatile unsigned long *)0xFFFF80A4)
#define PDC_CR2_OFFSET 0xA4
#define PDC_CR2_DIR_MASK 0x1U
#define PDC_CR2_DIR 0x1U
#define PDC_CR2_DIR_BIT 0
#define PDC_CR2_SIZE_MASK 0x6U
#define PDC_CR2_SIZE_BIT 1

#define PDC_MPR2 (*(volatile unsigned long *)0xFFFF80A8)
#define PDC_MPR2_OFFSET 0xA8
#define PDC_MPR2_CHPTR_MASK 0x0U
#define PDC_MPR2_CHPTR_BIT 0

#define PDC_TCR2 (*(volatile unsigned long *)0xFFFF80AC)
#define PDC_TCR2_OFFSET 0xAC
#define PDC_TCR2_CHCTR_MASK 0xFFFFU
#define PDC_TCR2_CHCTR_BIT 0

#define PDC_PRA3 (*(volatile unsigned long *)0xFFFF80B0)
#define PDC_PRA3_OFFSET 0xB0
#define PDC_PRA3_CHPRA_MASK 0x0U
#define PDC_PRA3_CHPRA_BIT 0

#define PDC_CR3 (*(volatile unsigned long *)0xFFFF80B4)
#define PDC_CR3_OFFSET 0xB4
#define PDC_CR3_DIR_MASK 0x1U
#define PDC_CR3_DIR 0x1U
#define PDC_CR3_DIR_BIT 0
#define PDC_CR3_SIZE_MASK 0x6U
#define PDC_CR3_SIZE_BIT 1

#define PDC_MPR3 (*(volatile unsigned long *)0xFFFF80B8)
#define PDC_MPR3_OFFSET 0xB8
#define PDC_MPR3_CHPTR_MASK 0x0U
#define PDC_MPR3_CHPTR_BIT 0

#define PDC_TCR3 (*(volatile unsigned long *)0xFFFF80BC)
#define PDC_TCR3_OFFSET 0xBC
#define PDC_TCR3_CHCTR_MASK 0xFFFFU
#define PDC_TCR3_CHCTR_BIT 0

#define PDC_PRA4 (*(volatile unsigned long *)0xFFFF80C0)
#define PDC_PRA4_OFFSET 0xC0
#define PDC_PRA4_CHPRA_MASK 0x0U
#define PDC_PRA4_CHPRA_BIT 0

#define PDC_CR4 (*(volatile unsigned long *)0xFFFF80C4)
#define PDC_CR4_OFFSET 0xC4
#define PDC_CR4_DIR_MASK 0x1U
#define PDC_CR4_DIR 0x1U
#define PDC_CR4_DIR_BIT 0
#define PDC_CR4_SIZE_MASK 0x6U
#define PDC_CR4_SIZE_BIT 1

#define PDC_MPR4 (*(volatile unsigned long *)0xFFFF80C8)
#define PDC_MPR4_OFFSET 0xC8
#define PDC_MPR4_CHPTR_MASK 0x0U
#define PDC_MPR4_CHPTR_BIT 0

#define PDC_TCR4 (*(volatile unsigned long *)0xFFFF80CC)
#define PDC_TCR4_OFFSET 0xCC
#define PDC_TCR4_CHCTR_MASK 0xFFFFU
#define PDC_TCR4_CHCTR_BIT 0

#define PDC_PRA5 (*(volatile unsigned long *)0xFFFF80D0)
#define PDC_PRA5_OFFSET 0xD0
#define PDC_PRA5_CHPRA_MASK 0x0U
#define PDC_PRA5_CHPRA_BIT 0

#define PDC_CR5 (*(volatile unsigned long *)0xFFFF80D4)
#define PDC_CR5_OFFSET 0xD4
#define PDC_CR5_DIR_MASK 0x1U
#define PDC_CR5_DIR 0x1U
#define PDC_CR5_DIR_BIT 0
#define PDC_CR5_SIZE_MASK 0x6U
#define PDC_CR5_SIZE_BIT 1

#define PDC_MPR5 (*(volatile unsigned long *)0xFFFF80D8)
#define PDC_MPR5_OFFSET 0xD8
#define PDC_MPR5_CHPTR_MASK 0x0U
#define PDC_MPR5_CHPTR_BIT 0

#define PDC_TCR5 (*(volatile unsigned long *)0xFFFF80DC)
#define PDC_TCR5_OFFSET 0xDC
#define PDC_TCR5_CHCTR_MASK 0xFFFFU
#define PDC_TCR5_CHCTR_BIT 0

#define PDC_PRA6 (*(volatile unsigned long *)0xFFFF80E0)
#define PDC_PRA6_OFFSET 0xE0
#define PDC_PRA6_CHPRA_MASK 0x0U
#define PDC_PRA6_CHPRA_BIT 0

#define PDC_CR6 (*(volatile unsigned long *)0xFFFF80E4)
#define PDC_CR6_OFFSET 0xE4
#define PDC_CR6_DIR_MASK 0x1U
#define PDC_CR6_DIR 0x1U
#define PDC_CR6_DIR_BIT 0
#define PDC_CR6_SIZE_MASK 0x6U
#define PDC_CR6_SIZE_BIT 1

#define PDC_MPR6 (*(volatile unsigned long *)0xFFFF80E8)
#define PDC_MPR6_OFFSET 0xE8
#define PDC_MPR6_CHPTR_MASK 0x0U
#define PDC_MPR6_CHPTR_BIT 0

#define PDC_TCR6 (*(volatile unsigned long *)0xFFFF80EC)
#define PDC_TCR6_OFFSET 0xEC
#define PDC_TCR6_CHCTR_MASK 0xFFFFU
#define PDC_TCR6_CHCTR_BIT 0

#define PDC_PRA7 (*(volatile unsigned long *)0xFFFF80F0)
#define PDC_PRA7_OFFSET 0xF0
#define PDC_PRA7_CHPRA_MASK 0x0U
#define PDC_PRA7_CHPRA_BIT 0

#define PDC_CR7 (*(volatile unsigned long *)0xFFFF80F4)
#define PDC_CR7_OFFSET 0xF4
#define PDC_CR7_DIR_MASK 0x1U
#define PDC_CR7_DIR 0x1U
#define PDC_CR7_DIR_BIT 0
#define PDC_CR7_SIZE_MASK 0x6U
#define PDC_CR7_SIZE_BIT 1

#define PDC_MPR7 (*(volatile unsigned long *)0xFFFF80F8)
#define PDC_MPR7_OFFSET 0xF8
#define PDC_MPR7_CHPTR_MASK 0x0U
#define PDC_MPR7_CHPTR_BIT 0

#define PDC_TCR7 (*(volatile unsigned long *)0xFFFF80FC)
#define PDC_TCR7_OFFSET 0xFC
#define PDC_TCR7_CHCTR_MASK 0xFFFFU
#define PDC_TCR7_CHCTR_BIT 0

#define PDC_PRA8 (*(volatile unsigned long *)0xFFFF8100)
#define PDC_PRA8_OFFSET 0x100
#define PDC_PRA8_CHPRA_MASK 0x0U
#define PDC_PRA8_CHPRA_BIT 0

#define PDC_CR8 (*(volatile unsigned long *)0xFFFF8104)
#define PDC_CR8_OFFSET 0x104
#define PDC_CR8_DIR_MASK 0x1U
#define PDC_CR8_DIR 0x1U
#define PDC_CR8_DIR_BIT 0
#define PDC_CR8_SIZE_MASK 0x6U
#define PDC_CR8_SIZE_BIT 1

#define PDC_MPR8 (*(volatile unsigned long *)0xFFFF8108)
#define PDC_MPR8_OFFSET 0x108
#define PDC_MPR8_CHPTR_MASK 0x0U
#define PDC_MPR8_CHPTR_BIT 0

#define PDC_TCR8 (*(volatile unsigned long *)0xFFFF810C)
#define PDC_TCR8_OFFSET 0x10C
#define PDC_TCR8_CHCTR_MASK 0xFFFFU
#define PDC_TCR8_CHCTR_BIT 0

#define PDC_PRA9 (*(volatile unsigned long *)0xFFFF8110)
#define PDC_PRA9_OFFSET 0x110
#define PDC_PRA9_CHPRA_MASK 0x0U
#define PDC_PRA9_CHPRA_BIT 0

#define PDC_CR9 (*(volatile unsigned long *)0xFFFF8114)
#define PDC_CR9_OFFSET 0x114
#define PDC_CR9_DIR_MASK 0x1U
#define PDC_CR9_DIR 0x1U
#define PDC_CR9_DIR_BIT 0
#define PDC_CR9_SIZE_MASK 0x6U
#define PDC_CR9_SIZE_BIT 1

#define PDC_MPR9 (*(volatile unsigned long *)0xFFFF8118)
#define PDC_MPR9_OFFSET 0x118
#define PDC_MPR9_CHPTR_MASK 0x0U
#define PDC_MPR9_CHPTR_BIT 0

#define PDC_TCR9 (*(volatile unsigned long *)0xFFFF811C)
#define PDC_TCR9_OFFSET 0x11C
#define PDC_TCR9_CHCTR_MASK 0xFFFFU
#define PDC_TCR9_CHCTR_BIT 0

#define PDC_PRA10 (*(volatile unsigned long *)0xFFFF8120)
#define PDC_PRA10_OFFSET 0x120
#define PDC_PRA10_CHPRA_MASK 0x0U
#define PDC_PRA10_CHPRA_BIT 0

#define PDC_CR10 (*(volatile unsigned long *)0xFFFF8124)
#define PDC_CR10_OFFSET 0x124
#define PDC_CR10_DIR_MASK 0x1U
#define PDC_CR10_DIR 0x1U
#define PDC_CR10_DIR_BIT 0
#define PDC_CR10_SIZE_MASK 0x6U
#define PDC_CR10_SIZE_BIT 1

#define PDC_MPR10 (*(volatile unsigned long *)0xFFFF8128)
#define PDC_MPR10_OFFSET 0x128
#define PDC_MPR10_CHPTR_MASK 0x0U
#define PDC_MPR10_CHPTR_BIT 0

#define PDC_TCR10 (*(volatile unsigned long *)0xFFFF812C)
#define PDC_TCR10_OFFSET 0x12C
#define PDC_TCR10_CHCTR_MASK 0xFFFFU
#define PDC_TCR10_CHCTR_BIT 0

#define GIC_BASE 0xFFFFF000

#define GIC_SMR0 (*(volatile unsigned long *)0xFFFFF000)
#define GIC_SMR0_OFFSET 0x0
#define GIC_SMR0_PRIOR_MASK 0x7U
#define GIC_SMR0_PRIOR_BIT 0
#define GIC_SMR0_SRCTYPE_MASK 0x60U
#define GIC_SMR0_SRCTYPE_BIT 5

#define GIC_SMR1 (*(volatile unsigned long *)0xFFFFF004)
#define GIC_SMR1_OFFSET 0x4
#define GIC_SMR1_PRIOR_MASK 0x7U
#define GIC_SMR1_PRIOR_BIT 0
#define GIC_SMR1_SRCTYPE_MASK 0x60U
#define GIC_SMR1_SRCTYPE_BIT 5

#define GIC_SMR2 (*(volatile unsigned long *)0xFFFFF008)
#define GIC_SMR2_OFFSET 0x8
#define GIC_SMR2_PRIOR_MASK 0x7U
#define GIC_SMR2_PRIOR_BIT 0
#define GIC_SMR2_SRCTYPE_MASK 0x60U
#define GIC_SMR2_SRCTYPE_BIT 5

#define GIC_SMR3 (*(volatile unsigned long *)0xFFFFF00C)
#define GIC_SMR3_OFFSET 0xC
#define GIC_SMR3_PRIOR_MASK 0x7U
#define GIC_SMR3_PRIOR_BIT 0
#define GIC_SMR3_SRCTYPE_MASK 0x60U
#define GIC_SMR3_SRCTYPE_BIT 5

#define GIC_SMR4 (*(volatile unsigned long *)0xFFFFF010)
#define GIC_SMR4_OFFSET 0x10
#define GIC_SMR4_PRIOR_MASK 0x7U
#define GIC_SMR4_PRIOR_BIT 0
#define GIC_SMR4_SRCTYPE_MASK 0x60U
#define GIC_SMR4_SRCTYPE_BIT 5

#define GIC_SMR5 (*(volatile unsigned long *)0xFFFFF014)
#define GIC_SMR5_OFFSET 0x14
#define GIC_SMR5_PRIOR_MASK 0x7U
#define GIC_SMR5_PRIOR_BIT 0
#define GIC_SMR5_SRCTYPE_MASK 0x60U
#define GIC_SMR5_SRCTYPE_BIT 5

#define GIC_SMR6 (*(volatile unsigned long *)0xFFFFF018)
#define GIC_SMR6_OFFSET 0x18
#define GIC_SMR6_PRIOR_MASK 0x7U
#define GIC_SMR6_PRIOR_BIT 0
#define GIC_SMR6_SRCTYPE_MASK 0x60U
#define GIC_SMR6_SRCTYPE_BIT 5

#define GIC_SMR7 (*(volatile unsigned long *)0xFFFFF01C)
#define GIC_SMR7_OFFSET 0x1C
#define GIC_SMR7_PRIOR_MASK 0x7U
#define GIC_SMR7_PRIOR_BIT 0
#define GIC_SMR7_SRCTYPE_MASK 0x60U
#define GIC_SMR7_SRCTYPE_BIT 5

#define GIC_SMR8 (*(volatile unsigned long *)0xFFFFF020)
#define GIC_SMR8_OFFSET 0x20
#define GIC_SMR8_PRIOR_MASK 0x7U
#define GIC_SMR8_PRIOR_BIT 0
#define GIC_SMR8_SRCTYPE_MASK 0x60U
#define GIC_SMR8_SRCTYPE_BIT 5

#define GIC_SMR9 (*(volatile unsigned long *)0xFFFFF024)
#define GIC_SMR9_OFFSET 0x24
#define GIC_SMR9_PRIOR_MASK 0x7U
#define GIC_SMR9_PRIOR_BIT 0
#define GIC_SMR9_SRCTYPE_MASK 0x60U
#define GIC_SMR9_SRCTYPE_BIT 5

#define GIC_SMR10 (*(volatile unsigned long *)0xFFFFF028)
#define GIC_SMR10_OFFSET 0x28
#define GIC_SMR10_PRIOR_MASK 0x7U
#define GIC_SMR10_PRIOR_BIT 0
#define GIC_SMR10_SRCTYPE_MASK 0x60U
#define GIC_SMR10_SRCTYPE_BIT 5

#define GIC_SMR11 (*(volatile unsigned long *)0xFFFFF02C)
#define GIC_SMR11_OFFSET 0x2C
#define GIC_SMR11_PRIOR_MASK 0x7U
#define GIC_SMR11_PRIOR_BIT 0
#define GIC_SMR11_SRCTYPE_MASK 0x60U
#define GIC_SMR11_SRCTYPE_BIT 5

#define GIC_SMR12 (*(volatile unsigned long *)0xFFFFF030)
#define GIC_SMR12_OFFSET 0x30
#define GIC_SMR12_PRIOR_MASK 0x7U
#define GIC_SMR12_PRIOR_BIT 0
#define GIC_SMR12_SRCTYPE_MASK 0x60U
#define GIC_SMR12_SRCTYPE_BIT 5

#define GIC_SMR13 (*(volatile unsigned long *)0xFFFFF034)
#define GIC_SMR13_OFFSET 0x34
#define GIC_SMR13_PRIOR_MASK 0x7U
#define GIC_SMR13_PRIOR_BIT 0
#define GIC_SMR13_SRCTYPE_MASK 0x60U
#define GIC_SMR13_SRCTYPE_BIT 5

#define GIC_SMR14 (*(volatile unsigned long *)0xFFFFF038)
#define GIC_SMR14_OFFSET 0x38
#define GIC_SMR14_PRIOR_MASK 0x7U
#define GIC_SMR14_PRIOR_BIT 0
#define GIC_SMR14_SRCTYPE_MASK 0x60U
#define GIC_SMR14_SRCTYPE_BIT 5

#define GIC_SMR15 (*(volatile unsigned long *)0xFFFFF03C)
#define GIC_SMR15_OFFSET 0x3C
#define GIC_SMR15_PRIOR_MASK 0x7U
#define GIC_SMR15_PRIOR_BIT 0
#define GIC_SMR15_SRCTYPE_MASK 0x60U
#define GIC_SMR15_SRCTYPE_BIT 5

#define GIC_SMR16 (*(volatile unsigned long *)0xFFFFF040)
#define GIC_SMR16_OFFSET 0x40
#define GIC_SMR16_PRIOR_MASK 0x7U
#define GIC_SMR16_PRIOR_BIT 0
#define GIC_SMR16_SRCTYPE_MASK 0x60U
#define GIC_SMR16_SRCTYPE_BIT 5

#define GIC_SMR17 (*(volatile unsigned long *)0xFFFFF044)
#define GIC_SMR17_OFFSET 0x44
#define GIC_SMR17_PRIOR_MASK 0x7U
#define GIC_SMR17_PRIOR_BIT 0
#define GIC_SMR17_SRCTYPE_MASK 0x60U
#define GIC_SMR17_SRCTYPE_BIT 5

#define GIC_SMR18 (*(volatile unsigned long *)0xFFFFF048)
#define GIC_SMR18_OFFSET 0x48
#define GIC_SMR18_PRIOR_MASK 0x7U
#define GIC_SMR18_PRIOR_BIT 0
#define GIC_SMR18_SRCTYPE_MASK 0x60U
#define GIC_SMR18_SRCTYPE_BIT 5

#define GIC_SMR19 (*(volatile unsigned long *)0xFFFFF04C)
#define GIC_SMR19_OFFSET 0x4C
#define GIC_SMR19_PRIOR_MASK 0x7U
#define GIC_SMR19_PRIOR_BIT 0
#define GIC_SMR19_SRCTYPE_MASK 0x60U
#define GIC_SMR19_SRCTYPE_BIT 5

#define GIC_SMR20 (*(volatile unsigned long *)0xFFFFF050)
#define GIC_SMR20_OFFSET 0x50
#define GIC_SMR20_PRIOR_MASK 0x7U
#define GIC_SMR20_PRIOR_BIT 0
#define GIC_SMR20_SRCTYPE_MASK 0x60U
#define GIC_SMR20_SRCTYPE_BIT 5

#define GIC_SMR21 (*(volatile unsigned long *)0xFFFFF054)
#define GIC_SMR21_OFFSET 0x54
#define GIC_SMR21_PRIOR_MASK 0x7U
#define GIC_SMR21_PRIOR_BIT 0
#define GIC_SMR21_SRCTYPE_MASK 0x60U
#define GIC_SMR21_SRCTYPE_BIT 5

#define GIC_SMR22 (*(volatile unsigned long *)0xFFFFF058)
#define GIC_SMR22_OFFSET 0x58
#define GIC_SMR22_PRIOR_MASK 0x7U
#define GIC_SMR22_PRIOR_BIT 0
#define GIC_SMR22_SRCTYPE_MASK 0x60U
#define GIC_SMR22_SRCTYPE_BIT 5

#define GIC_SMR23 (*(volatile unsigned long *)0xFFFFF05C)
#define GIC_SMR23_OFFSET 0x5C
#define GIC_SMR23_PRIOR_MASK 0x7U
#define GIC_SMR23_PRIOR_BIT 0
#define GIC_SMR23_SRCTYPE_MASK 0x60U
#define GIC_SMR23_SRCTYPE_BIT 5

#define GIC_SMR24 (*(volatile unsigned long *)0xFFFFF060)
#define GIC_SMR24_OFFSET 0x60
#define GIC_SMR24_PRIOR_MASK 0x7U
#define GIC_SMR24_PRIOR_BIT 0
#define GIC_SMR24_SRCTYPE_MASK 0x60U
#define GIC_SMR24_SRCTYPE_BIT 5

#define GIC_SMR25 (*(volatile unsigned long *)0xFFFFF064)
#define GIC_SMR25_OFFSET 0x64
#define GIC_SMR25_PRIOR_MASK 0x7U
#define GIC_SMR25_PRIOR_BIT 0
#define GIC_SMR25_SRCTYPE_MASK 0x60U
#define GIC_SMR25_SRCTYPE_BIT 5

#define GIC_SMR26 (*(volatile unsigned long *)0xFFFFF068)
#define GIC_SMR26_OFFSET 0x68
#define GIC_SMR26_PRIOR_MASK 0x7U
#define GIC_SMR26_PRIOR_BIT 0
#define GIC_SMR26_SRCTYPE_MASK 0x60U
#define GIC_SMR26_SRCTYPE_BIT 5

#define GIC_SMR27 (*(volatile unsigned long *)0xFFFFF06C)
#define GIC_SMR27_OFFSET 0x6C
#define GIC_SMR27_PRIOR_MASK 0x7U
#define GIC_SMR27_PRIOR_BIT 0
#define GIC_SMR27_SRCTYPE_MASK 0x60U
#define GIC_SMR27_SRCTYPE_BIT 5

#define GIC_SMR28 (*(volatile unsigned long *)0xFFFFF070)
#define GIC_SMR28_OFFSET 0x70
#define GIC_SMR28_PRIOR_MASK 0x7U
#define GIC_SMR28_PRIOR_BIT 0
#define GIC_SMR28_SRCTYPE_MASK 0x60U
#define GIC_SMR28_SRCTYPE_BIT 5

#define GIC_SMR29 (*(volatile unsigned long *)0xFFFFF074)
#define GIC_SMR29_OFFSET 0x74
#define GIC_SMR29_PRIOR_MASK 0x7U
#define GIC_SMR29_PRIOR_BIT 0
#define GIC_SMR29_SRCTYPE_MASK 0x60U
#define GIC_SMR29_SRCTYPE_BIT 5

#define GIC_SMR30 (*(volatile unsigned long *)0xFFFFF078)
#define GIC_SMR30_OFFSET 0x78
#define GIC_SMR30_PRIOR_MASK 0x7U
#define GIC_SMR30_PRIOR_BIT 0
#define GIC_SMR30_SRCTYPE_MASK 0x60U
#define GIC_SMR30_SRCTYPE_BIT 5

#define GIC_SMR31 (*(volatile unsigned long *)0xFFFFF07C)
#define GIC_SMR31_OFFSET 0x7C
#define GIC_SMR31_PRIOR_MASK 0x7U
#define GIC_SMR31_PRIOR_BIT 0
#define GIC_SMR31_SRCTYPE_MASK 0x60U
#define GIC_SMR31_SRCTYPE_BIT 5

#define GIC_SVR0 (*(volatile unsigned long *)0xFFFFF080)
#define GIC_SVR0_OFFSET 0x80

#define GIC_SVR1 (*(volatile unsigned long *)0xFFFFF084)
#define GIC_SVR1_OFFSET 0x84

#define GIC_SVR2 (*(volatile unsigned long *)0xFFFFF088)
#define GIC_SVR2_OFFSET 0x88

#define GIC_SVR3 (*(volatile unsigned long *)0xFFFFF08C)
#define GIC_SVR3_OFFSET 0x8C

#define GIC_SVR4 (*(volatile unsigned long *)0xFFFFF090)
#define GIC_SVR4_OFFSET 0x90

#define GIC_SVR5 (*(volatile unsigned long *)0xFFFFF094)
#define GIC_SVR5_OFFSET 0x94

#define GIC_SVR6 (*(volatile unsigned long *)0xFFFFF098)
#define GIC_SVR6_OFFSET 0x98

#define GIC_SVR7 (*(volatile unsigned long *)0xFFFFF09C)
#define GIC_SVR7_OFFSET 0x9C

#define GIC_SVR8 (*(volatile unsigned long *)0xFFFFF0A0)
#define GIC_SVR8_OFFSET 0xA0

#define GIC_SVR9 (*(volatile unsigned long *)0xFFFFF0A4)
#define GIC_SVR9_OFFSET 0xA4

#define GIC_SVR10 (*(volatile unsigned long *)0xFFFFF0A8)
#define GIC_SVR10_OFFSET 0xA8

#define GIC_SVR11 (*(volatile unsigned long *)0xFFFFF0AC)
#define GIC_SVR11_OFFSET 0xAC

#define GIC_SVR12 (*(volatile unsigned long *)0xFFFFF0B0)
#define GIC_SVR12_OFFSET 0xB0

#define GIC_SVR13 (*(volatile unsigned long *)0xFFFFF0B4)
#define GIC_SVR13_OFFSET 0xB4

#define GIC_SVR14 (*(volatile unsigned long *)0xFFFFF0B8)
#define GIC_SVR14_OFFSET 0xB8

#define GIC_SVR15 (*(volatile unsigned long *)0xFFFFF0BC)
#define GIC_SVR15_OFFSET 0xBC

#define GIC_SVR16 (*(volatile unsigned long *)0xFFFFF0C0)
#define GIC_SVR16_OFFSET 0xC0

#define GIC_SVR17 (*(volatile unsigned long *)0xFFFFF0C4)
#define GIC_SVR17_OFFSET 0xC4

#define GIC_SVR18 (*(volatile unsigned long *)0xFFFFF0C8)
#define GIC_SVR18_OFFSET 0xC8

#define GIC_SVR19 (*(volatile unsigned long *)0xFFFFF0CC)
#define GIC_SVR19_OFFSET 0xCC

#define GIC_SVR20 (*(volatile unsigned long *)0xFFFFF0D0)
#define GIC_SVR20_OFFSET 0xD0

#define GIC_SVR21 (*(volatile unsigned long *)0xFFFFF0D4)
#define GIC_SVR21_OFFSET 0xD4

#define GIC_SVR22 (*(volatile unsigned long *)0xFFFFF0D8)
#define GIC_SVR22_OFFSET 0xD8

#define GIC_SVR23 (*(volatile unsigned long *)0xFFFFF0DC)
#define GIC_SVR23_OFFSET 0xDC

#define GIC_SVR24 (*(volatile unsigned long *)0xFFFFF0E0)
#define GIC_SVR24_OFFSET 0xE0

#define GIC_SVR25 (*(volatile unsigned long *)0xFFFFF0E4)
#define GIC_SVR25_OFFSET 0xE4

#define GIC_SVR26 (*(volatile unsigned long *)0xFFFFF0E8)
#define GIC_SVR26_OFFSET 0xE8

#define GIC_SVR27 (*(volatile unsigned long *)0xFFFFF0EC)
#define GIC_SVR27_OFFSET 0xEC

#define GIC_SVR28 (*(volatile unsigned long *)0xFFFFF0F0)
#define GIC_SVR28_OFFSET 0xF0

#define GIC_SVR29 (*(volatile unsigned long *)0xFFFFF0F4)
#define GIC_SVR29_OFFSET 0xF4

#define GIC_SVR30 (*(volatile unsigned long *)0xFFFFF0F8)
#define GIC_SVR30_OFFSET 0xF8

#define GIC_SVR31 (*(volatile unsigned long *)0xFFFFF0FC)
#define GIC_SVR31_OFFSET 0xFC

#define GIC_IVR (*(volatile unsigned long *)0xFFFFF100)
#define GIC_IVR_OFFSET 0x100

#define GIC_FVR (*(volatile unsigned long *)0xFFFFF104)
#define GIC_FVR_OFFSET 0x104

#define GIC_ISR (*(volatile unsigned long *)0xFFFFF108)
#define GIC_ISR_OFFSET 0x108
#define GIC_ISR_IRQID_MASK 0x1FU
#define GIC_ISR_IRQID_BIT 0

#define GIC_IPR (*(volatile unsigned long *)0xFFFFF10C)
#define GIC_IPR_OFFSET 0x10C
#define GIC_IPR_FIQ_MASK 0x1U
#define GIC_IPR_FIQ 0x1U
#define GIC_IPR_FIQ_BIT 0
#define GIC_IPR_SWIRQ0_MASK 0x2U
#define GIC_IPR_SWIRQ0 0x2U
#define GIC_IPR_SWIRQ0_BIT 1
#define GIC_IPR_WD_MASK 0x4U
#define GIC_IPR_WD 0x4U
#define GIC_IPR_WD_BIT 2
#define GIC_IPR_WT_MASK 0x8U
#define GIC_IPR_WT 0x8U
#define GIC_IPR_WT_BIT 3
#define GIC_IPR_USART0_MASK 0x10U
#define GIC_IPR_USART0 0x10U
#define GIC_IPR_USART0_BIT 4
#define GIC_IPR_USART1_MASK 0x20U
#define GIC_IPR_USART1 0x20U
#define GIC_IPR_USART1_BIT 5
#define GIC_IPR_CAN3_MASK 0x40U
#define GIC_IPR_CAN3 0x40U
#define GIC_IPR_CAN3_BIT 6
#define GIC_IPR_SPI_MASK 0x80U
#define GIC_IPR_SPI 0x80U
#define GIC_IPR_SPI_BIT 7
#define GIC_IPR_CAN1_MASK 0x100U
#define GIC_IPR_CAN1 0x100U
#define GIC_IPR_CAN1_BIT 8
#define GIC_IPR_CAN2_MASK 0x200U
#define GIC_IPR_CAN2 0x200U
#define GIC_IPR_CAN2_BIT 9
#define GIC_IPR_ADC0_MASK 0x400U
#define GIC_IPR_ADC0 0x400U
#define GIC_IPR_ADC0_BIT 10
#define GIC_IPR_ADC1_MASK 0x800U
#define GIC_IPR_ADC1 0x800U
#define GIC_IPR_ADC1_BIT 11
#define GIC_IPR_GPT0CH0_MASK 0x1000U
#define GIC_IPR_GPT0CH0 0x1000U
#define GIC_IPR_GPT0CH0_BIT 12
#define GIC_IPR_GPT0CH1_MASK 0x2000U
#define GIC_IPR_GPT0CH1 0x2000U
#define GIC_IPR_GPT0CH1_BIT 13
#define GIC_IPR_GPT0CH2_MASK 0x4000U
#define GIC_IPR_GPT0CH2 0x4000U
#define GIC_IPR_GPT0CH2_BIT 14
#define GIC_IPR_SWIRQ1_MASK 0x8000U
#define GIC_IPR_SWIRQ1 0x8000U
#define GIC_IPR_SWIRQ1_BIT 15
#define GIC_IPR_SWIRQ2_MASK 0x10000U
#define GIC_IPR_SWIRQ2 0x10000U
#define GIC_IPR_SWIRQ2_BIT 16
#define GIC_IPR_SWIRQ3_MASK 0x20000U
#define GIC_IPR_SWIRQ3 0x20000U
#define GIC_IPR_SWIRQ3_BIT 17
#define GIC_IPR_GPT1CH0_MASK 0x40000U
#define GIC_IPR_GPT1CH0 0x40000U
#define GIC_IPR_GPT1CH0_BIT 18
#define GIC_IPR_PWM_MASK 0x80000U
#define GIC_IPR_PWM 0x80000U
#define GIC_IPR_PWM_BIT 19
#define GIC_IPR_CAN0_MASK 0x100000U
#define GIC_IPR_CAN0 0x100000U
#define GIC_IPR_CAN0_BIT 20
#define GIC_IPR_UPIO_MASK 0x200000U
#define GIC_IPR_UPIO 0x200000U
#define GIC_IPR_UPIO_BIT 21
#define GIC_IPR_CAPT0_MASK 0x400000U
#define GIC_IPR_CAPT0 0x400000U
#define GIC_IPR_CAPT0_BIT 22
#define GIC_IPR_CAPT1_MASK 0x800000U
#define GIC_IPR_CAPT1 0x800000U
#define GIC_IPR_CAPT1_BIT 23
#define GIC_IPR_ST0_MASK 0x1000000U
#define GIC_IPR_ST0 0x1000000U
#define GIC_IPR_ST0_BIT 24
#define GIC_IPR_ST1_MASK 0x2000000U
#define GIC_IPR_ST1 0x2000000U
#define GIC_IPR_ST1_BIT 25
#define GIC_IPR_SWIRQ4_MASK 0x4000000U
#define GIC_IPR_SWIRQ4 0x4000000U
#define GIC_IPR_SWIRQ4_BIT 26
#define GIC_IPR_SWIRQ5_MASK 0x8000000U
#define GIC_IPR_SWIRQ5 0x8000000U
#define GIC_IPR_SWIRQ5_BIT 27
#define GIC_IPR_IRQ0_MASK 0x10000000U
#define GIC_IPR_IRQ0 0x10000000U
#define GIC_IPR_IRQ0_BIT 28
#define GIC_IPR_IRQ1_MASK 0x20000000U
#define GIC_IPR_IRQ1 0x20000000U
#define GIC_IPR_IRQ1_BIT 29
#define GIC_IPR_SWIRQ6_MASK 0x40000000U
#define GIC_IPR_SWIRQ6 0x40000000U
#define GIC_IPR_SWIRQ6_BIT 30
#define GIC_IPR_SWIRQ7_MASK 0x80000000U
#define GIC_IPR_SWIRQ7 0x80000000U
#define GIC_IPR_SWIRQ7_BIT 31

#define GIC_IMR (*(volatile unsigned long *)0xFFFFF110)
#define GIC_IMR_OFFSET 0x110
#define GIC_IMR_FIQ_MASK 0x1U
#define GIC_IMR_FIQ 0x1U
#define GIC_IMR_FIQ_BIT 0
#define GIC_IMR_SWIRQ0_MASK 0x2U
#define GIC_IMR_SWIRQ0 0x2U
#define GIC_IMR_SWIRQ0_BIT 1
#define GIC_IMR_WD_MASK 0x4U
#define GIC_IMR_WD 0x4U
#define GIC_IMR_WD_BIT 2
#define GIC_IMR_WT_MASK 0x8U
#define GIC_IMR_WT 0x8U
#define GIC_IMR_WT_BIT 3
#define GIC_IMR_USART0_MASK 0x10U
#define GIC_IMR_USART0 0x10U
#define GIC_IMR_USART0_BIT 4
#define GIC_IMR_USART1_MASK 0x20U
#define GIC_IMR_USART1 0x20U
#define GIC_IMR_USART1_BIT 5
#define GIC_IMR_CAN3_MASK 0x40U
#define GIC_IMR_CAN3 0x40U
#define GIC_IMR_CAN3_BIT 6
#define GIC_IMR_SPI_MASK 0x80U
#define GIC_IMR_SPI 0x80U
#define GIC_IMR_SPI_BIT 7
#define GIC_IMR_CAN1_MASK 0x100U
#define GIC_IMR_CAN1 0x100U
#define GIC_IMR_CAN1_BIT 8
#define GIC_IMR_CAN2_MASK 0x200U
#define GIC_IMR_CAN2 0x200U
#define GIC_IMR_CAN2_BIT 9
#define GIC_IMR_ADC0_MASK 0x400U
#define GIC_IMR_ADC0 0x400U
#define GIC_IMR_ADC0_BIT 10
#define GIC_IMR_ADC1_MASK 0x800U
#define GIC_IMR_ADC1 0x800U
#define GIC_IMR_ADC1_BIT 11
#define GIC_IMR_GPT0CH0_MASK 0x1000U
#define GIC_IMR_GPT0CH0 0x1000U
#define GIC_IMR_GPT0CH0_BIT 12
#define GIC_IMR_GPT0CH1_MASK 0x2000U
#define GIC_IMR_GPT0CH1 0x2000U
#define GIC_IMR_GPT0CH1_BIT 13
#define GIC_IMR_GPT0CH2_MASK 0x4000U
#define GIC_IMR_GPT0CH2 0x4000U
#define GIC_IMR_GPT0CH2_BIT 14
#define GIC_IMR_SWIRQ1_MASK 0x8000U
#define GIC_IMR_SWIRQ1 0x8000U
#define GIC_IMR_SWIRQ1_BIT 15
#define GIC_IMR_SWIRQ2_MASK 0x10000U
#define GIC_IMR_SWIRQ2 0x10000U
#define GIC_IMR_SWIRQ2_BIT 16
#define GIC_IMR_SWIRQ3_MASK 0x20000U
#define GIC_IMR_SWIRQ3 0x20000U
#define GIC_IMR_SWIRQ3_BIT 17
#define GIC_IMR_GPT1CH0_MASK 0x40000U
#define GIC_IMR_GPT1CH0 0x40000U
#define GIC_IMR_GPT1CH0_BIT 18
#define GIC_IMR_PWM_MASK 0x80000U
#define GIC_IMR_PWM 0x80000U
#define GIC_IMR_PWM_BIT 19
#define GIC_IMR_CAN0_MASK 0x100000U
#define GIC_IMR_CAN0 0x100000U
#define GIC_IMR_CAN0_BIT 20
#define GIC_IMR_UPIO_MASK 0x200000U
#define GIC_IMR_UPIO 0x200000U
#define GIC_IMR_UPIO_BIT 21
#define GIC_IMR_CAPT0_MASK 0x400000U
#define GIC_IMR_CAPT0 0x400000U
#define GIC_IMR_CAPT0_BIT 22
#define GIC_IMR_CAPT1_MASK 0x800000U
#define GIC_IMR_CAPT1 0x800000U
#define GIC_IMR_CAPT1_BIT 23
#define GIC_IMR_ST0_MASK 0x1000000U
#define GIC_IMR_ST0 0x1000000U
#define GIC_IMR_ST0_BIT 24
#define GIC_IMR_ST1_MASK 0x2000000U
#define GIC_IMR_ST1 0x2000000U
#define GIC_IMR_ST1_BIT 25
#define GIC_IMR_SWIRQ4_MASK 0x4000000U
#define GIC_IMR_SWIRQ4 0x4000000U
#define GIC_IMR_SWIRQ4_BIT 26
#define GIC_IMR_SWIRQ5_MASK 0x8000000U
#define GIC_IMR_SWIRQ5 0x8000000U
#define GIC_IMR_SWIRQ5_BIT 27
#define GIC_IMR_IRQ0_MASK 0x10000000U
#define GIC_IMR_IRQ0 0x10000000U
#define GIC_IMR_IRQ0_BIT 28
#define GIC_IMR_IRQ1_MASK 0x20000000U
#define GIC_IMR_IRQ1 0x20000000U
#define GIC_IMR_IRQ1_BIT 29
#define GIC_IMR_SWIRQ6_MASK 0x40000000U
#define GIC_IMR_SWIRQ6 0x40000000U
#define GIC_IMR_SWIRQ6_BIT 30
#define GIC_IMR_SWIRQ7_MASK 0x80000000U
#define GIC_IMR_SWIRQ7 0x80000000U
#define GIC_IMR_SWIRQ7_BIT 31

#define GIC_CISR (*(volatile unsigned long *)0xFFFFF114)
#define GIC_CISR_OFFSET 0x114
#define GIC_CISR_NFIQ_MASK 0x1U
#define GIC_CISR_NFIQ 0x1U
#define GIC_CISR_NFIQ_BIT 0
#define GIC_CISR_NIRQ_MASK 0x2U
#define GIC_CISR_NIRQ 0x2U
#define GIC_CISR_NIRQ_BIT 1

#define GIC_IECR (*(volatile unsigned long *)0xFFFFF120)
#define GIC_IECR_OFFSET 0x120
#define GIC_IECR_FIQ_MASK 0x1U
#define GIC_IECR_FIQ 0x1U
#define GIC_IECR_FIQ_BIT 0
#define GIC_IECR_SWIRQ0_MASK 0x2U
#define GIC_IECR_SWIRQ0 0x2U
#define GIC_IECR_SWIRQ0_BIT 1
#define GIC_IECR_WD_MASK 0x4U
#define GIC_IECR_WD 0x4U
#define GIC_IECR_WD_BIT 2
#define GIC_IECR_WT_MASK 0x8U
#define GIC_IECR_WT 0x8U
#define GIC_IECR_WT_BIT 3
#define GIC_IECR_USART0_MASK 0x10U
#define GIC_IECR_USART0 0x10U
#define GIC_IECR_USART0_BIT 4
#define GIC_IECR_USART1_MASK 0x20U
#define GIC_IECR_USART1 0x20U
#define GIC_IECR_USART1_BIT 5
#define GIC_IECR_CAN3_MASK 0x40U
#define GIC_IECR_CAN3 0x40U
#define GIC_IECR_CAN3_BIT 6
#define GIC_IECR_SPI_MASK 0x80U
#define GIC_IECR_SPI 0x80U
#define GIC_IECR_SPI_BIT 7
#define GIC_IECR_CAN1_MASK 0x100U
#define GIC_IECR_CAN1 0x100U
#define GIC_IECR_CAN1_BIT 8
#define GIC_IECR_CAN2_MASK 0x200U
#define GIC_IECR_CAN2 0x200U
#define GIC_IECR_CAN2_BIT 9
#define GIC_IECR_ADC0_MASK 0x400U
#define GIC_IECR_ADC0 0x400U
#define GIC_IECR_ADC0_BIT 10
#define GIC_IECR_ADC1_MASK 0x800U
#define GIC_IECR_ADC1 0x800U
#define GIC_IECR_ADC1_BIT 11
#define GIC_IECR_GPT0CH0_MASK 0x1000U
#define GIC_IECR_GPT0CH0 0x1000U
#define GIC_IECR_GPT0CH0_BIT 12
#define GIC_IECR_GPT0CH1_MASK 0x2000U
#define GIC_IECR_GPT0CH1 0x2000U
#define GIC_IECR_GPT0CH1_BIT 13
#define GIC_IECR_GPT0CH2_MASK 0x4000U
#define GIC_IECR_GPT0CH2 0x4000U
#define GIC_IECR_GPT0CH2_BIT 14
#define GIC_IECR_SWIRQ1_MASK 0x8000U
#define GIC_IECR_SWIRQ1 0x8000U
#define GIC_IECR_SWIRQ1_BIT 15
#define GIC_IECR_SWIRQ2_MASK 0x10000U
#define GIC_IECR_SWIRQ2 0x10000U
#define GIC_IECR_SWIRQ2_BIT 16
#define GIC_IECR_SWIRQ3_MASK 0x20000U
#define GIC_IECR_SWIRQ3 0x20000U
#define GIC_IECR_SWIRQ3_BIT 17
#define GIC_IECR_GPT1CH0_MASK 0x40000U
#define GIC_IECR_GPT1CH0 0x40000U
#define GIC_IECR_GPT1CH0_BIT 18
#define GIC_IECR_PWM_MASK 0x80000U
#define GIC_IECR_PWM 0x80000U
#define GIC_IECR_PWM_BIT 19
#define GIC_IECR_CAN0_MASK 0x100000U
#define GIC_IECR_CAN0 0x100000U
#define GIC_IECR_CAN0_BIT 20
#define GIC_IECR_UPIO_MASK 0x200000U
#define GIC_IECR_UPIO 0x200000U
#define GIC_IECR_UPIO_BIT 21
#define GIC_IECR_CAPT0_MASK 0x400000U
#define GIC_IECR_CAPT0 0x400000U
#define GIC_IECR_CAPT0_BIT 22
#define GIC_IECR_CAPT1_MASK 0x800000U
#define GIC_IECR_CAPT1 0x800000U
#define GIC_IECR_CAPT1_BIT 23
#define GIC_IECR_ST0_MASK 0x1000000U
#define GIC_IECR_ST0 0x1000000U
#define GIC_IECR_ST0_BIT 24
#define GIC_IECR_ST1_MASK 0x2000000U
#define GIC_IECR_ST1 0x2000000U
#define GIC_IECR_ST1_BIT 25
#define GIC_IECR_SWIRQ4_MASK 0x4000000U
#define GIC_IECR_SWIRQ4 0x4000000U
#define GIC_IECR_SWIRQ4_BIT 26
#define GIC_IECR_SWIRQ5_MASK 0x8000000U
#define GIC_IECR_SWIRQ5 0x8000000U
#define GIC_IECR_SWIRQ5_BIT 27
#define GIC_IECR_IRQ0_MASK 0x10000000U
#define GIC_IECR_IRQ0 0x10000000U
#define GIC_IECR_IRQ0_BIT 28
#define GIC_IECR_IRQ1_MASK 0x20000000U
#define GIC_IECR_IRQ1 0x20000000U
#define GIC_IECR_IRQ1_BIT 29
#define GIC_IECR_SWIRQ6_MASK 0x40000000U
#define GIC_IECR_SWIRQ6 0x40000000U
#define GIC_IECR_SWIRQ6_BIT 30
#define GIC_IECR_SWIRQ7_MASK 0x80000000U
#define GIC_IECR_SWIRQ7 0x80000000U
#define GIC_IECR_SWIRQ7_BIT 31

#define GIC_IDCR (*(volatile unsigned long *)0xFFFFF124)
#define GIC_IDCR_OFFSET 0x124
#define GIC_IDCR_FIQ_MASK 0x1U
#define GIC_IDCR_FIQ 0x1U
#define GIC_IDCR_FIQ_BIT 0
#define GIC_IDCR_SWIRQ0_MASK 0x2U
#define GIC_IDCR_SWIRQ0 0x2U
#define GIC_IDCR_SWIRQ0_BIT 1
#define GIC_IDCR_WD_MASK 0x4U
#define GIC_IDCR_WD 0x4U
#define GIC_IDCR_WD_BIT 2
#define GIC_IDCR_WT_MASK 0x8U
#define GIC_IDCR_WT 0x8U
#define GIC_IDCR_WT_BIT 3
#define GIC_IDCR_USART0_MASK 0x10U
#define GIC_IDCR_USART0 0x10U
#define GIC_IDCR_USART0_BIT 4
#define GIC_IDCR_USART1_MASK 0x20U
#define GIC_IDCR_USART1 0x20U
#define GIC_IDCR_USART1_BIT 5
#define GIC_IDCR_CAN3_MASK 0x40U
#define GIC_IDCR_CAN3 0x40U
#define GIC_IDCR_CAN3_BIT 6
#define GIC_IDCR_SPI_MASK 0x80U
#define GIC_IDCR_SPI 0x80U
#define GIC_IDCR_SPI_BIT 7
#define GIC_IDCR_CAN1_MASK 0x100U
#define GIC_IDCR_CAN1 0x100U
#define GIC_IDCR_CAN1_BIT 8
#define GIC_IDCR_CAN2_MASK 0x200U
#define GIC_IDCR_CAN2 0x200U
#define GIC_IDCR_CAN2_BIT 9
#define GIC_IDCR_ADC0_MASK 0x400U
#define GIC_IDCR_ADC0 0x400U
#define GIC_IDCR_ADC0_BIT 10
#define GIC_IDCR_ADC1_MASK 0x800U
#define GIC_IDCR_ADC1 0x800U
#define GIC_IDCR_ADC1_BIT 11
#define GIC_IDCR_GPT0CH0_MASK 0x1000U
#define GIC_IDCR_GPT0CH0 0x1000U
#define GIC_IDCR_GPT0CH0_BIT 12
#define GIC_IDCR_GPT0CH1_MASK 0x2000U
#define GIC_IDCR_GPT0CH1 0x2000U
#define GIC_IDCR_GPT0CH1_BIT 13
#define GIC_IDCR_GPT0CH2_MASK 0x4000U
#define GIC_IDCR_GPT0CH2 0x4000U
#define GIC_IDCR_GPT0CH2_BIT 14
#define GIC_IDCR_SWIRQ1_MASK 0x8000U
#define GIC_IDCR_SWIRQ1 0x8000U
#define GIC_IDCR_SWIRQ1_BIT 15
#define GIC_IDCR_SWIRQ2_MASK 0x10000U
#define GIC_IDCR_SWIRQ2 0x10000U
#define GIC_IDCR_SWIRQ2_BIT 16
#define GIC_IDCR_SWIRQ3_MASK 0x20000U
#define GIC_IDCR_SWIRQ3 0x20000U
#define GIC_IDCR_SWIRQ3_BIT 17
#define GIC_IDCR_GPT1CH0_MASK 0x40000U
#define GIC_IDCR_GPT1CH0 0x40000U
#define GIC_IDCR_GPT1CH0_BIT 18
#define GIC_IDCR_PWM_MASK 0x80000U
#define GIC_IDCR_PWM 0x80000U
#define GIC_IDCR_PWM_BIT 19
#define GIC_IDCR_CAN0_MASK 0x100000U
#define GIC_IDCR_CAN0 0x100000U
#define GIC_IDCR_CAN0_BIT 20
#define GIC_IDCR_UPIO_MASK 0x200000U
#define GIC_IDCR_UPIO 0x200000U
#define GIC_IDCR_UPIO_BIT 21
#define GIC_IDCR_CAPT0_MASK 0x400000U
#define GIC_IDCR_CAPT0 0x400000U
#define GIC_IDCR_CAPT0_BIT 22
#define GIC_IDCR_CAPT1_MASK 0x800000U
#define GIC_IDCR_CAPT1 0x800000U
#define GIC_IDCR_CAPT1_BIT 23
#define GIC_IDCR_ST0_MASK 0x1000000U
#define GIC_IDCR_ST0 0x1000000U
#define GIC_IDCR_ST0_BIT 24
#define GIC_IDCR_ST1_MASK 0x2000000U
#define GIC_IDCR_ST1 0x2000000U
#define GIC_IDCR_ST1_BIT 25
#define GIC_IDCR_SWIRQ4_MASK 0x4000000U
#define GIC_IDCR_SWIRQ4 0x4000000U
#define GIC_IDCR_SWIRQ4_BIT 26
#define GIC_IDCR_SWIRQ5_MASK 0x8000000U
#define GIC_IDCR_SWIRQ5 0x8000000U
#define GIC_IDCR_SWIRQ5_BIT 27
#define GIC_IDCR_IRQ0_MASK 0x10000000U
#define GIC_IDCR_IRQ0 0x10000000U
#define GIC_IDCR_IRQ0_BIT 28
#define GIC_IDCR_IRQ1_MASK 0x20000000U
#define GIC_IDCR_IRQ1 0x20000000U
#define GIC_IDCR_IRQ1_BIT 29
#define GIC_IDCR_SWIRQ6_MASK 0x40000000U
#define GIC_IDCR_SWIRQ6 0x40000000U
#define GIC_IDCR_SWIRQ6_BIT 30
#define GIC_IDCR_SWIRQ7_MASK 0x80000000U
#define GIC_IDCR_SWIRQ7 0x80000000U
#define GIC_IDCR_SWIRQ7_BIT 31

#define GIC_ICCR (*(volatile unsigned long *)0xFFFFF128)
#define GIC_ICCR_OFFSET 0x128
#define GIC_ICCR_FIQ_MASK 0x1U
#define GIC_ICCR_FIQ 0x1U
#define GIC_ICCR_FIQ_BIT 0
#define GIC_ICCR_SWIRQ0_MASK 0x2U
#define GIC_ICCR_SWIRQ0 0x2U
#define GIC_ICCR_SWIRQ0_BIT 1
#define GIC_ICCR_WD_MASK 0x4U
#define GIC_ICCR_WD 0x4U
#define GIC_ICCR_WD_BIT 2
#define GIC_ICCR_WT_MASK 0x8U
#define GIC_ICCR_WT 0x8U
#define GIC_ICCR_WT_BIT 3
#define GIC_ICCR_USART0_MASK 0x10U
#define GIC_ICCR_USART0 0x10U
#define GIC_ICCR_USART0_BIT 4
#define GIC_ICCR_USART1_MASK 0x20U
#define GIC_ICCR_USART1 0x20U
#define GIC_ICCR_USART1_BIT 5
#define GIC_ICCR_CAN3_MASK 0x40U
#define GIC_ICCR_CAN3 0x40U
#define GIC_ICCR_CAN3_BIT 6
#define GIC_ICCR_SPI_MASK 0x80U
#define GIC_ICCR_SPI 0x80U
#define GIC_ICCR_SPI_BIT 7
#define GIC_ICCR_CAN1_MASK 0x100U
#define GIC_ICCR_CAN1 0x100U
#define GIC_ICCR_CAN1_BIT 8
#define GIC_ICCR_CAN2_MASK 0x200U
#define GIC_ICCR_CAN2 0x200U
#define GIC_ICCR_CAN2_BIT 9
#define GIC_ICCR_ADC0_MASK 0x400U
#define GIC_ICCR_ADC0 0x400U
#define GIC_ICCR_ADC0_BIT 10
#define GIC_ICCR_ADC1_MASK 0x800U
#define GIC_ICCR_ADC1 0x800U
#define GIC_ICCR_ADC1_BIT 11
#define GIC_ICCR_GPT0CH0_MASK 0x1000U
#define GIC_ICCR_GPT0CH0 0x1000U
#define GIC_ICCR_GPT0CH0_BIT 12
#define GIC_ICCR_GPT0CH1_MASK 0x2000U
#define GIC_ICCR_GPT0CH1 0x2000U
#define GIC_ICCR_GPT0CH1_BIT 13
#define GIC_ICCR_GPT0CH2_MASK 0x4000U
#define GIC_ICCR_GPT0CH2 0x4000U
#define GIC_ICCR_GPT0CH2_BIT 14
#define GIC_ICCR_SWIRQ1_MASK 0x8000U
#define GIC_ICCR_SWIRQ1 0x8000U
#define GIC_ICCR_SWIRQ1_BIT 15
#define GIC_ICCR_SWIRQ2_MASK 0x10000U
#define GIC_ICCR_SWIRQ2 0x10000U
#define GIC_ICCR_SWIRQ2_BIT 16
#define GIC_ICCR_SWIRQ3_MASK 0x20000U
#define GIC_ICCR_SWIRQ3 0x20000U
#define GIC_ICCR_SWIRQ3_BIT 17
#define GIC_ICCR_GPT1CH0_MASK 0x40000U
#define GIC_ICCR_GPT1CH0 0x40000U
#define GIC_ICCR_GPT1CH0_BIT 18
#define GIC_ICCR_PWM_MASK 0x80000U
#define GIC_ICCR_PWM 0x80000U
#define GIC_ICCR_PWM_BIT 19
#define GIC_ICCR_CAN0_MASK 0x100000U
#define GIC_ICCR_CAN0 0x100000U
#define GIC_ICCR_CAN0_BIT 20
#define GIC_ICCR_UPIO_MASK 0x200000U
#define GIC_ICCR_UPIO 0x200000U
#define GIC_ICCR_UPIO_BIT 21
#define GIC_ICCR_CAPT0_MASK 0x400000U
#define GIC_ICCR_CAPT0 0x400000U
#define GIC_ICCR_CAPT0_BIT 22
#define GIC_ICCR_CAPT1_MASK 0x800000U
#define GIC_ICCR_CAPT1 0x800000U
#define GIC_ICCR_CAPT1_BIT 23
#define GIC_ICCR_ST0_MASK 0x1000000U
#define GIC_ICCR_ST0 0x1000000U
#define GIC_ICCR_ST0_BIT 24
#define GIC_ICCR_ST1_MASK 0x2000000U
#define GIC_ICCR_ST1 0x2000000U
#define GIC_ICCR_ST1_BIT 25
#define GIC_ICCR_SWIRQ4_MASK 0x4000000U
#define GIC_ICCR_SWIRQ4 0x4000000U
#define GIC_ICCR_SWIRQ4_BIT 26
#define GIC_ICCR_SWIRQ5_MASK 0x8000000U
#define GIC_ICCR_SWIRQ5 0x8000000U
#define GIC_ICCR_SWIRQ5_BIT 27
#define GIC_ICCR_IRQ0_MASK 0x10000000U
#define GIC_ICCR_IRQ0 0x10000000U
#define GIC_ICCR_IRQ0_BIT 28
#define GIC_ICCR_IRQ1_MASK 0x20000000U
#define GIC_ICCR_IRQ1 0x20000000U
#define GIC_ICCR_IRQ1_BIT 29
#define GIC_ICCR_SWIRQ6_MASK 0x40000000U
#define GIC_ICCR_SWIRQ6 0x40000000U
#define GIC_ICCR_SWIRQ6_BIT 30
#define GIC_ICCR_SWIRQ7_MASK 0x80000000U
#define GIC_ICCR_SWIRQ7 0x80000000U
#define GIC_ICCR_SWIRQ7_BIT 31

#define GIC_ISCR (*(volatile unsigned long *)0xFFFFF12C)
#define GIC_ISCR_OFFSET 0x12C
#define GIC_ISCR_FIQ_MASK 0x1U
#define GIC_ISCR_FIQ 0x1U
#define GIC_ISCR_FIQ_BIT 0
#define GIC_ISCR_SWIRQ0_MASK 0x2U
#define GIC_ISCR_SWIRQ0 0x2U
#define GIC_ISCR_SWIRQ0_BIT 1
#define GIC_ISCR_WD_MASK 0x4U
#define GIC_ISCR_WD 0x4U
#define GIC_ISCR_WD_BIT 2
#define GIC_ISCR_WT_MASK 0x8U
#define GIC_ISCR_WT 0x8U
#define GIC_ISCR_WT_BIT 3
#define GIC_ISCR_USART0_MASK 0x10U
#define GIC_ISCR_USART0 0x10U
#define GIC_ISCR_USART0_BIT 4
#define GIC_ISCR_USART1_MASK 0x20U
#define GIC_ISCR_USART1 0x20U
#define GIC_ISCR_USART1_BIT 5
#define GIC_ISCR_CAN3_MASK 0x40U
#define GIC_ISCR_CAN3 0x40U
#define GIC_ISCR_CAN3_BIT 6
#define GIC_ISCR_SPI_MASK 0x80U
#define GIC_ISCR_SPI 0x80U
#define GIC_ISCR_SPI_BIT 7
#define GIC_ISCR_CAN1_MASK 0x100U
#define GIC_ISCR_CAN1 0x100U
#define GIC_ISCR_CAN1_BIT 8
#define GIC_ISCR_CAN2_MASK 0x200U
#define GIC_ISCR_CAN2 0x200U
#define GIC_ISCR_CAN2_BIT 9
#define GIC_ISCR_ADC0_MASK 0x400U
#define GIC_ISCR_ADC0 0x400U
#define GIC_ISCR_ADC0_BIT 10
#define GIC_ISCR_ADC1_MASK 0x800U
#define GIC_ISCR_ADC1 0x800U
#define GIC_ISCR_ADC1_BIT 11
#define GIC_ISCR_GPT0CH0_MASK 0x1000U
#define GIC_ISCR_GPT0CH0 0x1000U
#define GIC_ISCR_GPT0CH0_BIT 12
#define GIC_ISCR_GPT0CH1_MASK 0x2000U
#define GIC_ISCR_GPT0CH1 0x2000U
#define GIC_ISCR_GPT0CH1_BIT 13
#define GIC_ISCR_GPT0CH2_MASK 0x4000U
#define GIC_ISCR_GPT0CH2 0x4000U
#define GIC_ISCR_GPT0CH2_BIT 14
#define GIC_ISCR_SWIRQ1_MASK 0x8000U
#define GIC_ISCR_SWIRQ1 0x8000U
#define GIC_ISCR_SWIRQ1_BIT 15
#define GIC_ISCR_SWIRQ2_MASK 0x10000U
#define GIC_ISCR_SWIRQ2 0x10000U
#define GIC_ISCR_SWIRQ2_BIT 16
#define GIC_ISCR_SWIRQ3_MASK 0x20000U
#define GIC_ISCR_SWIRQ3 0x20000U
#define GIC_ISCR_SWIRQ3_BIT 17
#define GIC_ISCR_GPT1CH0_MASK 0x40000U
#define GIC_ISCR_GPT1CH0 0x40000U
#define GIC_ISCR_GPT1CH0_BIT 18
#define GIC_ISCR_PWM_MASK 0x80000U
#define GIC_ISCR_PWM 0x80000U
#define GIC_ISCR_PWM_BIT 19
#define GIC_ISCR_CAN0_MASK 0x100000U
#define GIC_ISCR_CAN0 0x100000U
#define GIC_ISCR_CAN0_BIT 20
#define GIC_ISCR_UPIO_MASK 0x200000U
#define GIC_ISCR_UPIO 0x200000U
#define GIC_ISCR_UPIO_BIT 21
#define GIC_ISCR_CAPT0_MASK 0x400000U
#define GIC_ISCR_CAPT0 0x400000U
#define GIC_ISCR_CAPT0_BIT 22
#define GIC_ISCR_CAPT1_MASK 0x800000U
#define GIC_ISCR_CAPT1 0x800000U
#define GIC_ISCR_CAPT1_BIT 23
#define GIC_ISCR_ST0_MASK 0x1000000U
#define GIC_ISCR_ST0 0x1000000U
#define GIC_ISCR_ST0_BIT 24
#define GIC_ISCR_ST1_MASK 0x2000000U
#define GIC_ISCR_ST1 0x2000000U
#define GIC_ISCR_ST1_BIT 25
#define GIC_ISCR_SWIRQ4_MASK 0x4000000U
#define GIC_ISCR_SWIRQ4 0x4000000U
#define GIC_ISCR_SWIRQ4_BIT 26
#define GIC_ISCR_SWIRQ5_MASK 0x8000000U
#define GIC_ISCR_SWIRQ5 0x8000000U
#define GIC_ISCR_SWIRQ5_BIT 27
#define GIC_ISCR_IRQ0_MASK 0x10000000U
#define GIC_ISCR_IRQ0 0x10000000U
#define GIC_ISCR_IRQ0_BIT 28
#define GIC_ISCR_IRQ1_MASK 0x20000000U
#define GIC_ISCR_IRQ1 0x20000000U
#define GIC_ISCR_IRQ1_BIT 29
#define GIC_ISCR_SWIRQ6_MASK 0x40000000U
#define GIC_ISCR_SWIRQ6 0x40000000U
#define GIC_ISCR_SWIRQ6_BIT 30
#define GIC_ISCR_SWIRQ7_MASK 0x80000000U
#define GIC_ISCR_SWIRQ7 0x80000000U
#define GIC_ISCR_SWIRQ7_BIT 31

#define GIC_EOICR (*(volatile unsigned long *)0xFFFFF130)
#define GIC_EOICR_OFFSET 0x130

#define GIC_SPU (*(volatile unsigned long *)0xFFFFF134)
#define GIC_SPU_OFFSET 0x134


#endif
