// CrossWorks Tasking Library.
//
// Copyright (c) 2004 Rowley Associates Limited.
//
// This file may be distributed under the terms of the License Agreement
// provided with this software.
//
// THIS FILE IS PROVIDED AS IS WITH NO WARRANTY OF ANY KIND, INCLUDING THE
// WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.

function getState(state)
{
  if (state == 0x00)
    return "runnable";
  if (state == 0x1)
    return "timer wait";
  var stateStr;
  if ((state & 0x30) == 0x30)
    stateStr = "message queue receive";  
  else if ((state & 0x20) == 0x20)
    stateStr = "message queue post";  
  else if ((state & 0x10) == 0x10)
    stateStr = "semaphore";
  else if ((state & 0x04)==0x04)     
    stateStr = "event any";     
  else if ((state & 0x02)==0x02)
    stateStr = "event all";
  else
    return "invalid";
  if ((state & 0x01) == 0x01)      
    stateStr += "& timer wait";
  else
    stateStr += " wait";
  return stateStr;
}

function getregs(sp)
{
  var a = new Array();
  a[16] = Debug.evaluate("*(unsigned*)0x"+sp.toString(16)); 
  sp+=4;
  for (i=0;i<13;i++)
    {
      a[i] = Debug.evaluate("*(unsigned*)0x"+sp.toString(16)); 
      sp+=4;
    }
  a[14] = Debug.evaluate("*(unsigned*)0x"+sp.toString(16)); 
  sp+=4;
  a[15] = Debug.evaluate("*(unsigned*)0x"+sp.toString(16));
  sp+=4;
  a[13] = sp;
  return a;
}

function update() 
{
  Threads.clear();
  var x=Debug.evaluate("ctl_task_executing");
  if (x)
    {
      Threads.newqueue("Executing");
      x = Debug.evaluate("*(CTL_TASK_t*)"+x);
      Threads.add(x.name, x.priority, "executing", []);
    }
  x=Debug.evaluate("ctl_task_list");
  if (x)
    Threads.newqueue("Waiting");
  var count=0;
  while (x && count<10)
    {
      x = Debug.evaluate("*(CTL_TASK_t*)"+x);         
      Threads.add(x.name, x.priority, getState(x.state), getregs(x.stack_pointer));
      x=x.next;
      count++;
    }
}
