// CrossWorks Tasking Library.
//
// Copyright (c) 2004 Rowley Associates Limited.
//
// This file may be distributed under the terms of the License Agreement
// provided with this software.
//
// THIS FILE IS PROVIDED AS IS WITH NO WARRANTY OF ANY KIND, INCLUDING THE
// WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.

#include <targets/S3C4510B.h>
#include "ctl_api.h"

typedef volatile unsigned int *reg32_t;
#define INTPRI(n) (*(reg32_t)(0x03FF0000 + 0x400C + n * 4))
#define INTERRUPT_SOURCE_COUNT 21


static CTL_ISR_FN_t vectors[INTERRUPT_SOURCE_COUNT];
static unsigned int currentVector;

void irq_handler(void) __attribute__((naked));

void
irq_handler(void)
{
  asm("stmfd sp!, {r0-r12, lr}"); 
  asm("mrs r0, spsr");
  asm("stmfd sp!, {r0}");
  ctl_interrupt_count++;
  currentVector = INTOSET_IRQ >> 2;
  INTPND = 1 << currentVector;
  vectors[currentVector]();
  asm("mov r0, sp");
  asm("ldr r1, =ctl_exit_isr");
  asm("bx r1");
}

int
ctl_set_isr(unsigned int vector, unsigned int priority, CTL_ISR_TRIGGER_t trigger, CTL_ISR_FN_t isr, CTL_ISR_FN_t *oldisr)
{
  if (oldisr)
    *oldisr = vectors[vector];
  vectors[vector] = isr;
  INTPRI(priority >> 2) = vector;
  return 1;
}

int
ctl_unmask_isr(unsigned int vector)
{
  INTMSK &= ~(1 << 21 | 1 << vector);
  return 1;
}

int
ctl_mask_isr(unsigned int vector)
{
  INTMSK |= (1 << vector);
  return 1;
}

      
