/*****************************************************************************
 * Copyright (c) 2001, 2002 Rowley Associates Limited.                       *
 *                                                                           *
 * This file may be distributed under the terms of the License Agreement     *
 * provided with this software.                                              *
 *                                                                           *
 * THIS FILE IS PROVIDED AS IS WITH NO WARRANTY OF ANY KIND, INCLUDING THE   *
 * WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE. *
 *****************************************************************************/

  .section .vectors, "ax"
  .code 32
  .align 0
  
/*****************************************************************************
 * Exception Vectors                                                         *
 *****************************************************************************/
_vectors:
  ldr pc, [pc, #reset_handler_address - . - 8] /* reset */
  ldr pc, [pc, #undef_handler_address - . - 8] /* undefined instruction */
  ldr pc, [pc, #swi_handler_address - . - 8] /* swi handler */
  ldr pc, [pc, #pabort_handler_address - . - 8] /* abort prefetch */
  ldr pc, [pc, #dabort_handler_address - . - 8] /* abort data */
  nop
  ldr pc, [pc, #irq_handler_address - . - 8]
  ldr pc, [pc, #fiq_handler_address - . - 8]

reset_handler_address:
  .word reset_handler
undef_handler_address:
  .word undef_handler
swi_handler_address:
  .word swi_handler
pabort_handler_address:
  .word pabort_handler
dabort_handler_address:
  .word dabort_handler
irq_handler_address:
  .word irq_handler
fiq_handler_address:
  .word fiq_handler

  .section .init, "ax"
  .code 32
  .align 0

/******************************************************************************
 *                                                                            *
 * Default exception handlers                                                 *
 *                                                                            *
 ******************************************************************************/
reset_handler:
#ifdef __FLASH_BUILD
  /* Copy exception vectors into RAM */
  mov r8, #0x20000000
  ldr r9, =_vectors
  ldmia r9!, {r0-r7}
  stmia r8!, {r0-r7}
  ldmia r9!, {r0-r6}
  stmia r8!, {r0-r6}     
#endif

  /* Configure system and jump to the _start entry point. */
  LDR r0, =0x6C000000
  LDR r1, =0x801D
  STR r1, [r0, #4]         // set up the emi to 1 wait state

  LDR r0, =0xA0000000
  LDR r1, =0x1c2
  STR r1, [r0, #0x50]      // set up the internal RAM at 0x0

  LDR r1, =0x73            // set the PLL to x16 and div 2  = 32Mhz
  STR r1, [r0, #0x18]

  LDR r1, =0x8009
  STR r1, [r0, #0x8]       // turn on the PLL

  LDR r1, =0x0             // cpu clock is div 1            = 32Mhz
  STR r1, [r0, #0x40]

  LDR r1, =0x0
  STR r1, [r0, #0x44]      // peripheral clocks are div 2   = 32Mhz

  /* Jump to the default C runtime startup code. */
  b _start

/******************************************************************************
 *                                                                            *
 * Default exception handlers                                                 *
 * These are declared weak symbols so they can be redefined in user code.     * 
 *                                                                            *
 ******************************************************************************/

undef_handler:
  b undef_handler
  
swi_handler:
  b swi_handler
  
pabort_handler:
  b pabort_handler
  
dabort_handler:
  b dabort_handler
  
irq_handler:
  b irq_handler
  
fiq_handler:
  b fiq_handler

  .weak undef_handler, swi_handler, pabort_handler, dabort_handler, irq_handler, fiq_handler
