function Reset()
{
  TargetInterface.setICEBreakerBreakpoint(0, 0x00000000, 0xFFFFFFFF, 0x00000000, 0xFFFFFFFF, 0x100, 0xF7);
  TargetInterface.runTestIdle();
  TargetInterface.setNSRST(0);
  TargetInterface.setNSRST(1);
  TargetInterface.waitForDebugState(1000);
  TargetInterface.trst();
}

function ResetWithRamAtZero()
{
  Reset();

  TargetInterface.pokeWord(0x78100000, 0x00000068); // BWC
  TargetInterface.pokeWord(0x78100004, 0x00000003); // ROMAC
  TargetInterface.pokeWord(0x78100008, 0x00000001); // RAMAC
  TargetInterface.pokeWord(0x7810000C, 0x00000007); // IO0AC
  TargetInterface.pokeWord(0x78100010, 0x00000007); // IO1AC

  TargetInterface.pokeWord(0x78180000, 0x00000000); // DBWC
  TargetInterface.pokeWord(0x78180004, 0x00000000); // DRMC
  TargetInterface.pokeWord(0x78180008, 0x00000000); // DRPC
  TargetInterface.pokeWord(0x7818000C, 0x00000000); // SDMD
  TargetInterface.pokeWord(0x78180010, 0x00000000); // DCMD
  TargetInterface.pokeWord(0x78180014, 0x00000000); // RFSH0
  TargetInterface.pokeWord(0x78180018, 0x00000000); // RDWC
  TargetInterface.pokeWord(0x7818001C, 0x00000000); // RFSH1

  TargetInterface.pokeWord(0xB8000010, 0x0000003C); // RMPCON (Disable write protection)
  TargetInterface.pokeWord(0xB8000010, 0x00000008); // RMPCON
}

function ResetWithFlashAtZero()
{
  Reset();
}

