/******************************************************************************
  Target Script for Freescale MC9328MXL.

  Copyright (c) 2005 Rowley Associates Limited.

  This file may be distributed under the terms of the License Agreement
  provided with this software.

  THIS FILE IS PROVIDED AS IS WITH NO WARRANTY OF ANY KIND, INCLUDING THE
  WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
 ******************************************************************************/

debugCodeLoadAddress = 0x0BFFB000;
debugCodeOnStopOffset = 0;
debugCodeOnRunOffset = 64;
debugCode =
[
  // debug_stop:
  0xEE110F10, //    mrc     15, 0, r0, cr1, cr0, 0   ; Read MMU Control
  0xE58F0040, //    str     r0, [pc, #64]            ; Store MMU Control
  0xE3C00005, //    bic     r0, r0, #0x5             ; Disable MMU & Caches
  0xE3C00A01, //    bic     r0, r0, #0x1000
  0xEE010F10, //    mcr     15, 0, r0, cr1, cr0, 0
  0xE3A010E0, //    mov     r1, #0xe0                ; Clean D Cache
  0xE381333F, // 1: orr     r3, r1, #0xfc000000
  0xEE073F5E, // 2: mcr     15, 0, r3, cr7, cr14, 2
  0xE2533301, //    subs    r3, r3, #0x4000000
  0x2AFFFFFC, //    bcs     2b
  0xE2511020, //    subs    r1, r1, #0x20
  0x2AFFFFF9, //    bcs     1b
  0xE3A00000, //    mov     r0, #0x00000000 
  0xEE070F15, //    mcr     15, 0, r0, cr7, cr5, 0  ; Invalidate I Cache
  0xEE070F9A, //    mcr     15, 0, r0, cr7, cr10, 4 ; Drain Write Buffer
  0xE1A0F00E, //    mov     pc, lr
 
  // debug_run:
  0xE59F0004, //    ldr     r0, [pc, #4]            ; Restore MMU Control
  0xEE010F10, //    mcr     15, 0, r0, cr1, cr0, 0
  0xE1A0F00E, //    mov     pc, lr
 
  // debug_mmu_control_state
  0x00000000 //     .word   0x00000000
];

function OnAttach()
{ 
  TargetInterface.pokeMultUint32(debugCodeLoadAddress, debugCode);
}

function OnStop()
{
  TargetInterface.executeFunction(debugCodeOnStopOffset + debugCodeLoadAddress, 0, 1000);
}

function OnRun()
{
  TargetInterface.executeFunction(debugCodeOnRunOffset + debugCodeLoadAddress, 0, 1000);
}

function Reset()
{
  //
  // Reset and stop the CPU 
  //
  TargetInterface.beginDebugAccess();
  TargetInterface.setICEBreakerBreakpoint(0, 0x00000000, 0, 0x00000000, 0xFFFFFFFF, 0x100, 0xF7);
  TargetInterface.pokeWord(0x00201000, 0x00000100); // WDT_WCR - Set watchdog timeout value
  TargetInterface.pokeWord(0x00201000, 0x00000101); // WDT_WCR - Enable watchdog
  TargetInterface.endDebugAccess(true);
  TargetInterface.waitForDebugState(1000);
  TargetInterface.trst();

  //
  // Configure memory
  //
  TargetInterface.pokeWord(0x0021B000, 0x2F00AC03); // PLLCLK_CSCR - Select CLKO mux to output HCLK(BCLK)
  TargetInterface.pokeWord(0x0021B000, 0x2F008403); // PLLCLK_CSCR - 48MHz System Clock
  TargetInterface.pokeWord(0x0021B020, 0x000B00B0); // PLLCLK_PCDR - PERCLK1 = PLLCLK / 1
  // CS0 - Boot FLASH, 32 wait states, 8 bit
  TargetInterface.pokeWord(0x00220000, 0x00002000); // EIM_CS0U 
  TargetInterface.pokeWord(0x00220004, 0x11110301); // EIM_CS0L
  // CS1 - SDRAM, 10 wait states, 32 bit
  TargetInterface.pokeWord(0x00220008, 0x00000A00); // EIM_CS1U
  TargetInterface.pokeWord(0x0022000C, 0x11110601); // EIM_CS1L
  // CS4
  TargetInterface.pokeWord(0x00220020, 0x00000F01); // EIM_CS4U
  TargetInterface.pokeWord(0x00220024, 0x11110B01); // EIM_CS4L
  // SDRAM Precharge Command
  TargetInterface.pokeWord(0x00221000, 0x92120200); // SDRAMC_SDCTL0
  TargetInterface.peekWord(0x08200000);
  // SDRAM Auto-Refresh Command
  TargetInterface.pokeWord(0x00221000, 0xA2120200); // SDRAMC_SDCTL0
  TargetInterface.peekWord(0x08000000);
  TargetInterface.peekWord(0x08000000);
  TargetInterface.peekWord(0x08000000);
  TargetInterface.peekWord(0x08000000);
  TargetInterface.peekWord(0x08000000);
  TargetInterface.peekWord(0x08000000);
  TargetInterface.peekWord(0x08000000);
  TargetInterface.peekWord(0x08000000);
  // SDRAM Set Mode Register Command
  TargetInterface.pokeWord(0x00221000, 0xB2120200);
  TargetInterface.peekWord(0x08111800);
  // SDRAM Set Normal Mode
  TargetInterface.pokeWord(0x00221000, 0x82124200);
  // Initialise SyncFLASH
  TargetInterface.pokeWord(0x00221004, 0x81020303);

  OnAttach();
  OnStop();
}

function RAMReset()
{
  Reset();
}

function FLASHReset()
{
  Reset();
}

