function Reset()
{
  TargetInterface.setICEBreakerBreakpoint(0, 0x00000000, 0xFFFFFFFF, 0x00000000, 0xFFFFFFFF, 0x100, 0xF7);
  TargetInterface.runTestIdle();
  TargetInterface.setNSRST(0);
  TargetInterface.setNSRST(1);
  TargetInterface.waitForDebugState(1000);
  TargetInterface.trst();
  TargetInterface.pokeWord(0xFFFF4020, 0x002F0002); // APMC_CGMR - Enable main oscillator, OSCCOUNT = 0x2F
  TargetInterface.delay(10); // Wait for the main oscillator to stabilize.
  TargetInterface.pokeWord(0xFFFF4020, 0x002F4002); // APMC_CGMR - Set main oscillator to be clock source
  TargetInterface.pokeWord(0xFFFF4020, 0x032F4102); // APMC_CGMR - Activate PLL, PLL multiplier = 1, PLL count = 3
  TargetInterface.delay(10); // Wait for the PLL to stabilize.
  TargetInterface.pokeWord(0xFFFF4020, 0x032F8102); // APMC_CGMR - Set PLL to be clock source

}

function SRAMReset()
{
  Reset();
  TargetInterface.pokeWord(0xFFE00000, 0x01002529); // EBI_CSR0
  TargetInterface.pokeWord(0xFFE00004, 0x02002121); // EBI_CSR1
  TargetInterface.pokeWord(0xFFE00024, 6); // EBI_MCR
  TargetInterface.pokeWord(0xFFE00020, 1); // EBI_RCR - Cancel remapping, put SRAM at zero.
}

function FLASHReset()
{
  Reset();
}

