function EB40A_Reset()
{
  // Get the target interface into debug state for the peeks and pokes
  TargetInterface.beginDebugAccess();

  // Disable watchdog
  TargetInterface.pokeWord(0xFFFF8000, 0x2340);
  // Initialize the WD Clock Mode Register
  TargetInterface.pokeWord(0xFFFF8004, 0x373F);
  // Restart the timer
  TargetInterface.pokeWord(0xFFFF8008, 0xC071);
  // Enable the watchdog
  TargetInterface.pokeWord(0xFFFF8000, 0x2341);
  // Enable internal reset generation
  TargetInterface.pokeWord(0xFFFF8000, 0x2343);

  // Set a breakpoint on reset vector
  TargetInterface.setICEBreakerBreakpoint(0, 0x00000000, 0x00000000, 0x00000000, 0xFFFFFFFF, 0x100, 0xF7);

  // Release target from debug state.
  TargetInterface.endDebugAccess(true);

  // Wait for CPU to reset and hit the breakpoint
  TargetInterface.waitForDebugState(5000);

  // Reset the Embedded ICE macrocell
  TargetInterface.trst();

  // Disable the watchdog
  TargetInterface.pokeWord(0xFFFF8000, 0x2340);

}

function EB40A_ResetWithRamAtZero()
{
  EB40A_Reset();
  TargetInterface.pokeWord(0xFFE00000, 0x1002539);
  TargetInterface.pokeWord(0xFFE00024, 6);
  // Cancel remapping, put SRAM at zero.
  TargetInterface.pokeWord(0xFFE00020, 1);
  //TargetInterface.delay(1000);
}

function EB40A_ResetWithFlashAtZero()
{
  EB40A_Reset();
}

