/*****************************************************************************
  ATMEL AT91SAM7 loader startup code.

  Copyright (c) 2004 Rowley Associates Limited.
 
  This file may be distributed under the terms of the License Agreement
  provided with this software.
 
  THIS FILE IS PROVIDED AS IS WITH NO WARRANTY OF ANY KIND, INCLUDING THE
  WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
 *****************************************************************************/
  .text
  .code 32
  .align 0

  .global _start
  .extern C_Entry
  .global stack_start
  .global stack_end

/*****************************************************************************
  Function    : _start
  Description : Minimal startup code for C system.
 *****************************************************************************/
_start:                         
  mov r10, #0x80000000
  mov r10, r10, asr #0x00000013 /* r10 = 0xFFFFF000 */

  /* Disable Watchdog */
  mov r0, #0x00008000
  str r0, [r10, #0xD44] /* WDT_MR */

  /* Setup stack */ 
  add sp, pc, #1024 
  
  /* Jump to main entry point */
  bl C_Entry

  /* Return from main, loop forever. */
loop:
  b loop
                          
stack_start:
  .fill 1024
stack_end:
                  
