// Copyright (c) 2001-2005 Rowley Associates Limited.
//
// This file may be distributed under the terms of the License Agreement
// provided with this software.
//
// THIS FILE IS PROVIDED AS IS WITH NO WARRANTY OF ANY KIND, INCLUDING THE
// WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
//
////////////////////////////////////////////////////////////////////////////////
//
//                          TMS470 LED Example
//
// Description
// -----------
// This example demonstrates writing to the IO ports and also how to place
// functions into the .fast section.
//
////////////////////////////////////////////////////////////////////////////////

#include <targets/TMS470.h>

extern void delay(volatile unsigned int d);

static void
cycle(int n)
{
  int m = 0;
  for (; n; m++, n--)
    {
      HETDOUT = 0x00000000;
      delay(m);
      HETDOUT = 0xFFFFFFFF;
      delay(n);
    }

  for (; m; m--, n++)
    {
      HETDOUT = 0x00000000;
      delay(m);
      HETDOUT = 0xFFFFFFFF;
      delay(n);
    }
}

int
main(void)
{
  HETDIR  = 0xFFFFFFFF;
  while (1)
    {
      cycle(300);
      cycle(500);
      delay(200000);
    }
  return 0;
}

