// Copyright (c) 2001-2004 Rowley Associates Limited.
//
// This file may be distributed under the terms of the License Agreement
// provided with this software.
//
// THIS FILE IS PROVIDED AS IS WITH NO WARRANTY OF ANY KIND, INCLUDING THE
// WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
//
////////////////////////////////////////////////////////////////////////////////
//
//                 ST STR71x Timer LED Example
//
// Description
// -----------
// This example demonstrates writing to the PIO ports and also how to place
// functions into the .fast section.
//
////////////////////////////////////////////////////////////////////////////////

#include <targets/STR71x.h>

#define LEDS (0xF << 11)

extern void delay(volatile unsigned int d);

static void
ledInit(void)
{
  IOPORT2_PC0 |= LEDS;
  IOPORT2_PC1 &= ~LEDS;
  IOPORT2_PC2 |= LEDS;
  IOPORT2_PD  &= ~LEDS;
}

static void
cycle(int n)
{
  int m = 0;
  for (; n; m++, n--)
    {
      IOPORT2_PD |= LEDS;
      delay(m);
      IOPORT2_PD &= ~LEDS;
      delay(n);
    }

  for (; m; m--, n++)
    {
      IOPORT2_PD |= LEDS;
      delay(m);
      IOPORT2_PD &= ~LEDS;
      delay(n);
    }
}


int
main(void)
{
  ledInit();
  
  while (1)
    {
      cycle(500);
      cycle(800);
      delay(300000);
    }      
          
  return 0;    
}


