/*================================< video.h >================================*/
//
// Header file for RMS101 SBC Video unit.
//
//*==========================================================================*/
#ifndef _VIDEO
#define _VIDEO


#define VRAM_SIZE		614400	// 640 x 480 x 16 bits Video Ram = 614400
										// 800 x 600 x 8 bits = 480000
// Video output modes
#define VOUT_RGB		0
#define VOUT_NTSC		1
#define VOUT_PAL		2
// Video Resolution modes
#define VRES_VGA		0		// 640 x 480 - 8 bit color
#define VRES_SVGA		1		// 800 x 600 - 8 bit color
#define VRES_VGATC	2		// 640 x 480 - 15 bit color

/*===========================< Function Prototypes >=========================*/

/*-------------------------------< VideoInit >-------------------------------*/
// Call to configure CLCD Controller on LH79520 to generate video signals.  
// Parameters 	:	bRes		Resolution mode (0..2)
//						bOutput	Output mode (RGB, NTSC)
//						ppV1		Double indirect pointer to start of video RAM
//						ppV2		Double indirect pointer to start of video RAM
// Returns :		nothing
//void VideoInit(PBYTE *ppV1, PBYTE *ppV2, BYTE bVRes, BYTE bVOut);
void VideoInit(PWORD pV1, PWORD pV2, BYTE bVRes, BYTE bVOut);

/*-----------------------------< VideoInitDAC >------------------------------*/
// Call to intialize CH7013 Video Encoder.  Uses I2C unit to set various
// registers withing the encoder.
// Parameters	:	bVRes		Resolution mode (0..2)
//						bVOut		Output mode (RGB, NTSC)
// Returns	:		nothing
void VideoInitDAC(BYTE bVRes, BYTE bVOut);

/*-----------------------------< VideoSetBuff >------------------------------*/
// Sets the start address of the video buffer.
// Parameters	: pBuff	Pointer to start of video buffer
// Returns		: nothing
void VideoSetBuff(PBYTE pBuff);

#endif


// end of video.h
