// Copyright (c) 2004 Rowley Associates Limited.
//
// This file may be distributed under the terms of the License Agreement
// provided with this software.
//
// THIS FILE IS PROVIDED AS IS WITH NO WARRANTY OF ANY KIND, INCLUDING THE
// WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.

#include "test.h"
#include <ctl_api.h>
#include <targets/LH79520.h>

#define TIMER0_INT 17

unsigned long idleCount;

static CTL_ISR_FN_t userTimerISR;

static void
timerISR(void)
{
  userTimerISR();
  /* Clear the timer 0 interrupt */
  TIMER0Clear = 0;
}

void
SetTimerISR(CTL_ISR_FN_t isr)
{
  /* Enable clock to timer 0 and 1 */
  PeriphClkCtrl &= ~0x10;
  /* Start timer 0, set clock division to 256 */
  TIMER0Control = 0x80;
  userTimerISR = isr;
  ctl_set_isr(TIMER0_INT, 0, CTL_ISR_TRIGGER_FIXED, timerISR, 0);
  ctl_unmask_isr(TIMER0_INT);
}

void
Idle()
{
  ++idleCount;
}
