// Copyright (c) 2001-2004 Rowley Associates Limited.
//
// This file may be distributed under the terms of the License Agreement
// provided with this software.
//
// THIS FILE IS PROVIDED AS IS WITH NO WARRANTY OF ANY KIND, INCLUDING THE
// WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
//
////////////////////////////////////////////////////////////////////////////////
//
//                 Philips LPC210X LED Example
//
// Description
// -----------
// This example demonstrates writing to the GPIO port.
//
////////////////////////////////////////////////////////////////////////////////

#include <targets/LPC210x.h>

#define NUM_LEDS 8

static int leds[] = { 0x0100, 0x0200, 0x0400, 0x0800, 0x1000, 0x2000, 0x4000, 0x8000};

static void
ledInit()
{
  IODIR |= 0x0000FF00;
  IOSET = 0x0000FF00;
}

static void
ledOn(int led)
{
  IOCLR = led;
}

static void
ledOff(int led)
{
  IOSET = led;
}

void
delay(int d)
{     
  for(; d; --d);
}
 
int
main(void)
{
  int i, j;
  MAMCR = 2;
  ledInit();
  while (1)
    {
      for (i = 0; i < NUM_LEDS; ++i)
        {
          ledOn(leds[i]);
          delay(20000);
        }
      for (i = 0; i < NUM_LEDS; ++i)
        {
          ledOff(leds[i]);
          delay(20000);
        }
      for (i = NUM_LEDS - 1; i >= 0; --i)
        {
          ledOn(leds[i]);
          delay(20000);
        }
      for (i = NUM_LEDS - 1; i >= 0; --i)
        {
          ledOff(leds[i]);
          delay(20000);
        }

    }
  return 0;
}


