// Copyright (c) 2001-2004 Rowley Associates Limited.
//
// This file may be distributed under the terms of the License Agreement
// provided with this software.
//
// THIS FILE IS PROVIDED AS IS WITH NO WARRANTY OF ANY KIND, INCLUDING THE
// WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
//
////////////////////////////////////////////////////////////////////////////////
//
//                 IAR LPC210x KickStart LED Example
//
// Description
// -----------
// This example demonstrates writing to the GPIO port.
//
////////////////////////////////////////////////////////////////////////////////

#include <targets/LPC210x.h>

#define NUM_LEDS 16

static void
ledInit()
{
  IODIR |= 0x0000FFFF;
  IOCLR = 0x0000FFFF;
}

static void
ledOn(int led)
{
  IOSET = 1 << led;
}

static void
ledOff(int led)
{
  IOCLR = 1 << led;
}

void
delay(int d)
{     
  for(; d; --d);
}
 
int
main(void)
{
  int i, j;
  MAMCR = 2;
  ledInit();
  while (1)
    {
      for (i = 0; i < NUM_LEDS; ++i)
        {
          ledOn(i);
          delay(10000);
        }
      for (i = 0; i < NUM_LEDS; ++i)
        {
          ledOff(i);
          delay(10000);
        }
      for (i = NUM_LEDS - 1; i >= 0; --i)
        {
          ledOn(i);
          delay(10000);
        }
      for (i = NUM_LEDS - 1; i >= 0; --i)
        {
          ledOff(i);
          delay(10000);
        }

    }
  return 0;
}


