// Copyright (c) 2004 Rowley Associates Limited.
//
// This file may be distributed under the terms of the License Agreement
// provided with this software.
//
// THIS FILE IS PROVIDED AS IS WITH NO WARRANTY OF ANY KIND, INCLUDING THE
// WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.

#include "test.h"
#include <ctl_api.h>
#include <targets/ML674000.h>

unsigned long idleCount;

static CTL_ISR_FN_t userTimerISR;

static void
timerISR(void)
{
  userTimerISR();
  /* Clear the timer interrupt */
  TIMESTAT0 = 1;
}

void
SetTimerISR(CTL_ISR_FN_t isr)
{
  userTimerISR = isr;
  TIMECNTL0 = 0x18; /* Interval timer, start, enable interrupts, CCLK */
  ctl_set_isr(16, 2, CTL_ISR_TRIGGER_FIXED, timerISR, 0);
  ctl_unmask_isr(16);
}

void
Idle(void)
{
  ++idleCount;
  /* Enter halt mode */
  CLKSTP = 0x3C; 
  CLKSTP = 0x04; 
}
