// Copyright (c) 2004 Rowley Associates Limited.
//
// This file may be distributed under the terms of the License Agreement
// provided with this software.
//
// THIS FILE IS PROVIDED AS IS WITH NO WARRANTY OF ANY KIND, INCLUDING THE
// WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.

#include "test.h"
#include <ctl_api.h>
#include <targets/MC9328MXL.h>

#define PERCLK1_FREQUENCY 96000000

#define TIMER1_INT 59

static CTL_ISR_FN_t userTimerISR;

unsigned long idleCount;

static void
timerISR(void)
{
  userTimerISR();
  /* Clear the timer interrupt */
  TIMER1_TSTAT &= ~1;
}

void
SetTimerISR(CTL_ISR_FN_t isr)
{
  /* Reset timer 1 */
  TIMER1_TCTL |= 0x00000001;
  TIMER1_TCTL |= 0x00008000;
  TIMER1_TCTL &= ~0x00000001;

  /* Configure and enable timer 1 */
  TIMER1_TPRER = 0; /* Prescaler = 1 */
  TIMER1_TCMP = PERCLK1_FREQUENCY / 1000; /* Generate 1Khz timer interrupt */
  TIMER1_TCTL = 0x00000013; /* Enable timer, clock source = PERCLK1, enable interrupt, restart mode */

  userTimerISR = isr;
  ctl_set_isr(TIMER1_INT, 1, CTL_ISR_TRIGGER_LOW_LEVEL, timerISR, 0);
  ctl_unmask_isr(TIMER1_INT);
}

unsigned long
TicksPerSecond(void)
{
  return 1000;
}

void
Idle()
{
  ++idleCount;
}


