// Copyright (c) 2001-2004 Rowley Associates Limited.
//
// This file may be distributed under the terms of the License Agreement
// provided with this software.
//
// THIS FILE IS PROVIDED AS IS WITH NO WARRANTY OF ANY KIND, INCLUDING THE
// WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
//
////////////////////////////////////////////////////////////////////////////////
//
//                Aeroflex AX07CF192 Timer Interrupt Example
//
// Description
// -----------
// This example demonstrates a simple interrupt handler and setting up a timer.
//
////////////////////////////////////////////////////////////////////////////////

#include <targets/AX07CF192.h>

#define INTERRUPT_SOURCE 14

static int timerCount;

static void
ledInit()
{
  /* Set P75 to output */
  P7DDR &= ~(1 << 5);
}
                                           
static void
toggleLED()
{
  P7DR ^= 1 << 5;
}                 

void irq_handler(void) __attribute__ ((interrupt ("IRQ")));

void
irq_handler(void)
{
  if (ISR & (1 << INTERRUPT_SOURCE))
    {
      ISCR = 1 << INTERRUPT_SOURCE;
      TSR0;
      toggleLED();
      ++timerCount;
    }
}

int
main(void)
{
  ledInit();

  /* Setup timer 0 interrupt */
  TMR &= ~(1 << INTERRUPT_SOURCE); /* Edge triggered */
  TPR |= 1 << INTERRUPT_SOURCE;    /* Rising edge */
  IDR &= ~(1 << INTERRUPT_SOURCE); /* IRQ interrupt */
  GMR &= ~(1 << INTERRUPT_SOURCE); /* Unmask interrupt */

  TCR0 = 3; /* Free running, BCLK/64 */
  TIER0 |= 0x4; /* Enable overflow interrupt */

  TSTARTR |= 1; /* Start timer */

  /* Enable Interrupts */
  __ARMLIB_enableIRQ();

  while (timerCount < 50);

  return 0; 
}
