// Copyright (c) 2001-2004 Rowley Associates Limited.
//
// This file may be distributed under the terms of the License Agreement
// provided with this software.
//
// THIS FILE IS PROVIDED AS IS WITH NO WARRANTY OF ANY KIND, INCLUDING THE
// WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
////////////////////////////////////////////////////////////////////////////////
//
//                 Aeroflex AX07CF192 Interrupt Example
//
// Description
// -----------
// This example demonstrates a simple interrupt handler. When running, pressing
// the "IRQ 0" button causes the irq_handler to execute which toggles
// the LED.
//
////////////////////////////////////////////////////////////////////////////////

#include "__armlib.h"
#include <targets/AX07CF192.h>

#define INTERRUPT_SOURCE 0

static void
ledInit()
{
  /* Set P75 to output */
  P7DDR &= ~(1 << 5);
}
                                           
static void
toggleLED()
{
  P7DR ^= 1 << 5;
}                 

void irq_handler(void) __attribute__ ((interrupt ("IRQ")));

void
irq_handler(void)
{
  if (ISR & (1 << INTERRUPT_SOURCE))
    {
      ISCR = 1 << INTERRUPT_SOURCE;
      toggleLED();
    }
}
          
int
main(int argc, const char *argv[])
{
  unsigned int v;

  ledInit();

  __ARMLIB_enableIRQ();

  TMR &= ~(1 << INTERRUPT_SOURCE); /* Edge triggered */
  TPR |= 1 << INTERRUPT_SOURCE;    /* Rising edge */
  IDR &= ~(1 << INTERRUPT_SOURCE); /* IRQ interrupt */
  GMR &= ~(1 << INTERRUPT_SOURCE); /* Unmask interrupt */
 
  while(1)
    v++;
  
  return 0;
}
