// Copyright (c) 2001-2005 Rowley Associates Limited.
//
// This file may be distributed under the terms of the License Agreement
// provided with this software.
//
// THIS FILE IS PROVIDED AS IS WITH NO WARRANTY OF ANY KIND, INCLUDING THE
// WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
//
////////////////////////////////////////////////////////////////////////////////
//
//                     Atmel AT91SAM7A1-EK LED Example
//
// Description
// -----------
// This example demonstrates writing to the PIO ports and also how to place
// functions into the .fast section.
//
////////////////////////////////////////////////////////////////////////////////

#include <targets/AT91SAM7A1.h>

void
ledInit()
{
  GPT0C0_ECR = 0x00000001;
  GPT0C0_PER = 0x00020000;
  GPT0C0_OER = 0x00020000;
  GPT0C0_CODR = 0x00020000;
}

static void
cycle(int n)
{
  int m = 0;
  for (; n; m++, n--)
    {
      GPT0C0_SODR = 0x00020000;
      delay(m);
      GPT0C0_CODR = 0x00020000;
      delay(n);
    }

  for (; m; m--, n++)
    {
      GPT0C0_SODR = 0x00020000;
      delay(m);
      GPT0C0_CODR = 0x00020000;
      delay(n);
    }
}


int
main(void)
{
  ledInit();
  while (1)
    {
      cycle(600);
      cycle(1000);
      delay(600000);
    }
  return 0;
}

