// CrossWorks Tasking Library.
//
// Copyright (c) 2004 Rowley Associates Limited.
//
// This file may be distributed under the terms of the License Agreement
// provided with this software.
//
// THIS FILE IS PROVIDED AS IS WITH NO WARRANTY OF ANY KIND, INCLUDING THE
// WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.

#include <targets/TMS470.h>
#include "ctl_api.h"

#define INTERRUPT_SOURCE_COUNT 32

static CTL_ISR_FN_t vectors[INTERRUPT_SOURCE_COUNT];

void irq_handler(void) __attribute__((naked));

void
irq_handler(void)
{
  asm("stmfd sp!, {r0-r12, lr}"); 
  asm("mrs r0, spsr");
  asm("stmfd sp!, {r0}");
  ctl_interrupt_count++;  
  vectors[(0xFF & IRQIVEC) - 1]();
  asm("mov r0, sp");
  asm("ldr r1, =ctl_exit_isr");
  asm("bx r1");
}

int
ctl_set_isr(unsigned int vector, unsigned int priority, CTL_ISR_TRIGGER_t trigger, CTL_ISR_FN_t isr, CTL_ISR_FN_t *oldisr)
{
  if (oldisr)
    *oldisr = vectors[vector];
  vectors[vector] = isr;
  return 1;
}

int
ctl_unmask_isr(unsigned int vector)
{
  REQMASK |= 1 << vector;
  return 1;
}

int
ctl_mask_isr(unsigned int vector)
{
  REQMASK &= ~(1 << vector);
  return 1;
}

      
