// CrossWorks Tasking Library.
//
// Copyright (c) 2004 Rowley Associates Limited.
//
// This file may be distributed under the terms of the License Agreement
// provided with this software.
//
// THIS FILE IS PROVIDED AS IS WITH NO WARRANTY OF ANY KIND, INCLUDING THE
// WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.

#include "ctl_api.h"
#include <targets/LH79524.h>

typedef volatile unsigned int *reg32_t;

#define VECTADDR(n) (*(&VIC_VECTADDR0 + n))
#define VECTCTRL(n) (*(&VIC_VECTCTRL0 + n))

#define INTERRUPT_SOURCE_COUNT 32

static unsigned int currentVector;

void irq_handler(void) __attribute__((naked));

void
irq_handler(void)
{
  asm("stmfd sp!, {r0-r12, lr}"); 
  asm("mrs r0, spsr");
  asm("stmfd sp!, {r0}");
  ctl_interrupt_count++;
  ((CTL_ISR_FN_t)VIC_VECTADDR)();
  VIC_VECTADDR = 0;
  asm("mov r0, sp");
  asm("ldr r1, =ctl_exit_isr");
  asm("bx r1");
}

int
ctl_set_isr(unsigned int vector, unsigned int priority, CTL_ISR_TRIGGER_t trigger, CTL_ISR_FN_t isr, CTL_ISR_FN_t *oldisr)
{
  if (oldisr)
    {
      int i;
      *oldisr = 0;
      for (i = 0; i < INTERRUPT_SOURCE_COUNT; ++i)
        if ((VECTCTRL(i) & 0x1F) == vector)
          *oldisr = (CTL_ISR_FN_t)VECTADDR(i);
    }
  if (isr)
    {
      /* Installing an ISR */
#ifdef CHECK_INTERRUPT_INSTALLED
      if (VectCntl(priority))
        return 0; /* ISR already installed at this interrupt priority */
#endif
      VIC_INTSELECT &= ~(1 << vector); /* IRQ Interrupt */
      VECTCTRL(priority) = (1 << 5) | vector;
      VECTADDR(priority) = (unsigned int)isr;
    }
  else
    {
      /* Removing an ISR */
      VECTCTRL(priority) = 0;
      VECTADDR(priority) = 0;
    }
   
  return 1;
}

int
ctl_unmask_isr(unsigned int vector)
{
  VIC_INTENABLE = 1 << vector;
  return 1;
}

int
ctl_mask_isr(unsigned int vector)
{
  VIC_INTENCLEAR = 1 << vector;
  return 1;
}
