/*****************************************************************************
 * ARM Loader - RAM Loader Functions                                         *
 *                                                                           *
 * Copyright (c) 2003 Rowley Associates Limited.                             *
 *                                                                           *
 * This file may be distributed under the terms of the License Agreement     *
 * provided with this software.                                              *
 *                                                                           *
 * THIS FILE IS PROVIDED AS IS WITH NO WARRANTY OF ANY KIND, INCLUDING THE   *
 * WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE. *
 *****************************************************************************/

#include "loader.h"

static unsigned int *comm_in_buffer_ptr;
static unsigned int *comm_out_buffer_ptr;
extern char __comm_buffer_start__;

void
loaderWaitForCommand()
{
#if defined(__ARM_ARCH_3__) || defined(__ARM_ARCH_4T__)
  asm(".word 0xdfffdfff");
#else
  asm("bkpt 0");
#endif
  comm_in_buffer_ptr = (unsigned int *)&__comm_buffer_start__;
  comm_out_buffer_ptr = (unsigned int *)&__comm_buffer_start__; 
}

unsigned int
loaderReadWord()
{
  return *comm_in_buffer_ptr++;
}

void
loaderWriteWord(unsigned int v)
{
  *comm_out_buffer_ptr++ = v;
}

unsigned int *
loaderGetReadPtr()
{
  return comm_in_buffer_ptr;
}

unsigned int *
loaderGetWritePtr()
{
  return comm_out_buffer_ptr;
}

