/******************************************************************************
  Target Script for ST STR71x.

  Copyright (c) 2004 Rowley Associates Limited.

  This file may be distributed under the terms of the License Agreement
  provided with this software.

  THIS FILE IS PROVIDED AS IS WITH NO WARRANTY OF ANY KIND, INCLUDING THE
  WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
 ******************************************************************************/

function Reset()
{
  TargetInterface.setNSRST(0);
  TargetInterface.setICEBreakerBreakpoint(0, 0x00000000, 0xFFFFFFFF, 0x00000000, 0xFFFFFFFF, 0x100, 0xF7);
  TargetInterface.setNSRST(1);
  TargetInterface.waitForDebugState(1000);
  TargetInterface.trst();
  // Reset UARTS
  TargetInterface.pokeWord(0xC0000014, 0x78);
  TargetInterface.pokeWord(0xC0000014, 0x0);
  // Reset EIC, TIMERS 0-3
  TargetInterface.pokeWord(0xE0000014, 0x4800);
  TargetInterface.pokeWord(0xE0000014, 0x0);
}

function RAMReset()
{
  Reset();
  TargetInterface.pokeWord(0xA0000050, 0x1c2); // Map RAM at Zero
}

function FLASHReset()
{
  Reset();
  TargetInterface.pokeWord(0xA0000050, 0x1c0); // Map FLASH at Zero
}

