/*****************************************************************************
 * Copyright (c) 2001, 2002 Rowley Associates Limited.                       *
 *                                                                           *
 * This file may be distributed under the terms of the License Agreement     *
 * provided with this software.                                              *
 *                                                                           *
 * THIS FILE IS PROVIDED AS IS WITH NO WARRANTY OF ANY KIND, INCLUDING THE   *
 * WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE. *
 *****************************************************************************/
  .text
  .code 32
  .align 0

  .global _start
  .extern C_Entry

 .equ GPCTL, 0xB7000000
 
/*****************************************************************************
 * Function    : _start                                                      *
 * Description : Minimal startup code for C system.                          *
 *****************************************************************************/
_start:
  /* Enable external bus function (second function of PIOA[14:10]) */
  mov r0, #GPCTL
  ldrh r1, [r0]
  orr r1, r1, #0x4
  strh r1, [r0]

  /* Setup stack */ 
  add sp, pc, #1024
  
  /* Jump to main entry point */
  bl C_Entry

  /* Return from main, loop forever. */
loop:
  b loop
                          
stack_start:
  .fill 1024
stack_end:
                  

