// Copyright (c) 2004 Rowley Associates Limited.
//
// This file may be distributed under the terms of the License Agreement
// provided with this software.
//
// THIS FILE IS PROVIDED AS IS WITH NO WARRANTY OF ANY KIND, INCLUDING THE
// WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.

#include "test.h"
#include <ctl_api.h>
#include <targets/AT91x408xx.h>

#define SW1 (1 << 19)

#define PIO_INT   8       /* Parallel I/O Controller A interrupt */

#define PROCESSOR_CLOCK_FREQUENCY 66000000

void
BoardInit(void)
{
  PIO_PER = SW1;
}

unsigned long
TicksPerSecond(void)
{
  return 503;
}

static CTL_ISR_FN_t userButtonISR;
static void
buttonISR(void)
{
  unsigned long isr = PIO_ISR;
  unsigned long pdsr = PIO_PDSR;
  userButtonISR();
}

void
SetButtonPressedISR(CTL_ISR_FN_t isr)
{
  userButtonISR = isr;
  // Setup PIO
  PIO_IER = SW1;
  ctl_set_isr(PIO_INT, 0, CTL_ISR_TRIGGER_LOW_LEVEL, buttonISR, 0);
  ctl_unmask_isr(PIO_INT);
}

void
SetLeds(unsigned v)
{
}
